goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('dommy.utils');
/**
 * Returns a selector in string format.
 * Accepts string, keyword, or collection.
 */
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_(data)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(dommy.core.selector,data));
} else {
if(((typeof data === 'string') || ((data instanceof cljs.core.Keyword)))){
return cljs.core.name(data);
} else {
return null;
}
}
});
dommy.core.text = (function dommy$core$text(elem){
var or__4185__auto__ = elem.textContent;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return elem.innerText;
}
});
dommy.core.html = (function dommy$core$html(elem){
return elem.innerHTML;
});
dommy.core.value = (function dommy$core$value(elem){
return elem.value;
});
dommy.core.class$ = (function dommy$core$class(elem){
return elem.className;
});
dommy.core.attr = (function dommy$core$attr(elem,k){
if(cljs.core.truth_(k)){
return elem.getAttribute(dommy.utils.as_str(k));
} else {
return null;
}
});
/**
 * The computed style of `elem`, optionally specifying the key of
 * a particular style to return
 */
dommy.core.style = (function dommy$core$style(var_args){
var G__19308 = arguments.length;
switch (G__19308) {
case 1:
return dommy.core.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.style.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(window.getComputedStyle(elem));
}));

(dommy.core.style.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return (window.getComputedStyle(elem)[dommy.utils.as_str(k)]);
}));

(dommy.core.style.cljs$lang$maxFixedArity = 2);

dommy.core.px = (function dommy$core$px(elem,k){

var pixels = dommy.core.style.cljs$core$IFn$_invoke$arity$2(elem,k);
if(cljs.core.seq(pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Does `elem` contain `c` in its class list
 */
dommy.core.has_class_QMARK_ = (function dommy$core$has_class_QMARK_(elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto__ = elem.classList;
if(cljs.core.truth_(temp__5733__auto__)){
var class_list = temp__5733__auto__;
return class_list.contains(c__$1);
} else {
var temp__5735__auto__ = dommy.core.class$(elem);
if(cljs.core.truth_(temp__5735__auto__)){
var class_name = temp__5735__auto__;
var temp__5735__auto____$1 = dommy.utils.class_index(class_name,c__$1);
if(cljs.core.truth_(temp__5735__auto____$1)){
var i = temp__5735__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Is `elem` hidden (as associated with hide!/show!/toggle!, using display: none)
 */
dommy.core.hidden_QMARK_ = (function dommy$core$hidden_QMARK_(elem){
return (dommy.core.style.cljs$core$IFn$_invoke$arity$2(elem,new cljs.core.Keyword(null,"display","display",242065432)) === "none");
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.core.bounding_client_rect = (function dommy$core$bounding_client_rect(elem){
var r = elem.getBoundingClientRect();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top","top",-1856271961),r.top,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),r.bottom,new cljs.core.Keyword(null,"left","left",-399115937),r.left,new cljs.core.Keyword(null,"right","right",-452581833),r.right,new cljs.core.Keyword(null,"width","width",-384071477),r.width,new cljs.core.Keyword(null,"height","height",1025178622),r.height], null);
});
dommy.core.parent = (function dommy$core$parent(elem){
return elem.parentNode;
});
dommy.core.children = (function dommy$core$children(elem){
return elem.children;
});
/**
 * Lazy seq of the ancestors of `elem`
 */
dommy.core.ancestors = (function dommy$core$ancestors(elem){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.iterate(dommy.core.parent,elem));
});
dommy.core.ancestor_nodes = dommy.core.ancestors;
/**
 * Returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(var_args){
var G__19316 = arguments.length;
switch (G__19316) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array(base.querySelectorAll(dommy.core.selector(selector)));
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
}));

(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(document,selector);
}));

(dommy.core.matches_pred.cljs$lang$maxFixedArity = 2);

/**
 * Closest ancestor of `elem` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(var_args){
var G__19321 = arguments.length;
switch (G__19321) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(base,selector),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((function (p1__19319_SHARP_){
return (!((p1__19319_SHARP_ === base)));
}),dommy.core.ancestors(elem))));
}));

(dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3(document.body,elem,selector);
}));

(dommy.core.closest.cljs$lang$maxFixedArity = 3);

/**
 * Is `descendant` a descendant of `ancestor`?
 * (http://goo.gl/T8pgCX)
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
if(cljs.core.truth_(ancestor.contains)){
return ancestor.contains(descendant);
} else {
if(cljs.core.truth_(ancestor.compareDocumentPosition)){
return ((ancestor.compareDocumentPosition(descendant) & (1 << (4))) != 0);
} else {
return null;
}
}
});
/**
 * Set the textContent of `elem` to `text`, fall back to innerText
 */
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
if((!((void 0 === elem.textContent)))){
(elem.textContent = text);
} else {
(elem.innerText = text);
}

return elem;
});
/**
 * Set the innerHTML of `elem` to `html`
 */
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
(elem.innerHTML = html);

return elem;
});
/**
 * Set the value of `elem` to `value`
 */
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
(elem.value = value);

return elem;
});
/**
 * Set the css class of `elem` to `elem`
 */
dommy.core.set_class_BANG_ = (function dommy$core$set_class_BANG_(elem,c){
return (elem.className = c);
});
/**
 * Set the style of `elem` using key-value pairs:
 * 
 *    (set-style! elem :display "block" :color "red")
 */
dommy.core.set_style_BANG_ = (function dommy$core$set_style_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___19735 = arguments.length;
var i__4790__auto___19736 = (0);
while(true){
if((i__4790__auto___19736 < len__4789__auto___19735)){
args__4795__auto__.push((arguments[i__4790__auto___19736]));

var G__19737 = (i__4790__auto___19736 + (1));
i__4790__auto___19736 = G__19737;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var style = elem.style;
var seq__19331_19738 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__19332_19739 = null;
var count__19333_19740 = (0);
var i__19334_19741 = (0);
while(true){
if((i__19334_19741 < count__19333_19740)){
var vec__19341_19742 = chunk__19332_19739.cljs$core$IIndexed$_nth$arity$2(null,i__19334_19741);
var k_19743 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19341_19742,(0),null);
var v_19744 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19341_19742,(1),null);
style.setProperty(dommy.utils.as_str(k_19743),v_19744);


var G__19745 = seq__19331_19738;
var G__19746 = chunk__19332_19739;
var G__19747 = count__19333_19740;
var G__19748 = (i__19334_19741 + (1));
seq__19331_19738 = G__19745;
chunk__19332_19739 = G__19746;
count__19333_19740 = G__19747;
i__19334_19741 = G__19748;
continue;
} else {
var temp__5735__auto___19749 = cljs.core.seq(seq__19331_19738);
if(temp__5735__auto___19749){
var seq__19331_19750__$1 = temp__5735__auto___19749;
if(cljs.core.chunked_seq_QMARK_(seq__19331_19750__$1)){
var c__4609__auto___19751 = cljs.core.chunk_first(seq__19331_19750__$1);
var G__19752 = cljs.core.chunk_rest(seq__19331_19750__$1);
var G__19753 = c__4609__auto___19751;
var G__19754 = cljs.core.count(c__4609__auto___19751);
var G__19755 = (0);
seq__19331_19738 = G__19752;
chunk__19332_19739 = G__19753;
count__19333_19740 = G__19754;
i__19334_19741 = G__19755;
continue;
} else {
var vec__19348_19756 = cljs.core.first(seq__19331_19750__$1);
var k_19757 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19348_19756,(0),null);
var v_19758 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19348_19756,(1),null);
style.setProperty(dommy.utils.as_str(k_19757),v_19758);


var G__19759 = cljs.core.next(seq__19331_19750__$1);
var G__19760 = null;
var G__19761 = (0);
var G__19762 = (0);
seq__19331_19738 = G__19759;
chunk__19332_19739 = G__19760;
count__19333_19740 = G__19761;
i__19334_19741 = G__19762;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.set_style_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.set_style_BANG_.cljs$lang$applyTo = (function (seq19325){
var G__19326 = cljs.core.first(seq19325);
var seq19325__$1 = cljs.core.next(seq19325);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19326,seq19325__$1);
}));

/**
 * Remove the style of `elem` using keywords:
 *   
 *    (remove-style! elem :display :color)
 */
dommy.core.remove_style_BANG_ = (function dommy$core$remove_style_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___19763 = arguments.length;
var i__4790__auto___19764 = (0);
while(true){
if((i__4790__auto___19764 < len__4789__auto___19763)){
args__4795__auto__.push((arguments[i__4790__auto___19764]));

var G__19765 = (i__4790__auto___19764 + (1));
i__4790__auto___19764 = G__19765;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,keywords){
var style = elem.style;
var seq__19355_19766 = cljs.core.seq(keywords);
var chunk__19356_19767 = null;
var count__19357_19768 = (0);
var i__19358_19769 = (0);
while(true){
if((i__19358_19769 < count__19357_19768)){
var kw_19770 = chunk__19356_19767.cljs$core$IIndexed$_nth$arity$2(null,i__19358_19769);
style.removeProperty(dommy.utils.as_str(kw_19770));


var G__19771 = seq__19355_19766;
var G__19772 = chunk__19356_19767;
var G__19773 = count__19357_19768;
var G__19774 = (i__19358_19769 + (1));
seq__19355_19766 = G__19771;
chunk__19356_19767 = G__19772;
count__19357_19768 = G__19773;
i__19358_19769 = G__19774;
continue;
} else {
var temp__5735__auto___19775 = cljs.core.seq(seq__19355_19766);
if(temp__5735__auto___19775){
var seq__19355_19776__$1 = temp__5735__auto___19775;
if(cljs.core.chunked_seq_QMARK_(seq__19355_19776__$1)){
var c__4609__auto___19777 = cljs.core.chunk_first(seq__19355_19776__$1);
var G__19778 = cljs.core.chunk_rest(seq__19355_19776__$1);
var G__19779 = c__4609__auto___19777;
var G__19780 = cljs.core.count(c__4609__auto___19777);
var G__19781 = (0);
seq__19355_19766 = G__19778;
chunk__19356_19767 = G__19779;
count__19357_19768 = G__19780;
i__19358_19769 = G__19781;
continue;
} else {
var kw_19782 = cljs.core.first(seq__19355_19776__$1);
style.removeProperty(dommy.utils.as_str(kw_19782));


var G__19783 = cljs.core.next(seq__19355_19776__$1);
var G__19784 = null;
var G__19785 = (0);
var G__19786 = (0);
seq__19355_19766 = G__19783;
chunk__19356_19767 = G__19784;
count__19357_19768 = G__19785;
i__19358_19769 = G__19786;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.remove_style_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.remove_style_BANG_.cljs$lang$applyTo = (function (seq19351){
var G__19352 = cljs.core.first(seq19351);
var seq19351__$1 = cljs.core.next(seq19351);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19352,seq19351__$1);
}));

dommy.core.set_px_BANG_ = (function dommy$core$set_px_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___19794 = arguments.length;
var i__4790__auto___19796 = (0);
while(true){
if((i__4790__auto___19796 < len__4789__auto___19794)){
args__4795__auto__.push((arguments[i__4790__auto___19796]));

var G__19798 = (i__4790__auto___19796 + (1));
i__4790__auto___19796 = G__19798;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){

if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__19367_19800 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__19368_19801 = null;
var count__19369_19802 = (0);
var i__19370_19803 = (0);
while(true){
if((i__19370_19803 < count__19369_19802)){
var vec__19379_19806 = chunk__19368_19801.cljs$core$IIndexed$_nth$arity$2(null,i__19370_19803);
var k_19807 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19379_19806,(0),null);
var v_19808 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19379_19806,(1),null);
dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k_19807,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_19808),"px"].join('')], 0));


var G__19810 = seq__19367_19800;
var G__19811 = chunk__19368_19801;
var G__19812 = count__19369_19802;
var G__19813 = (i__19370_19803 + (1));
seq__19367_19800 = G__19810;
chunk__19368_19801 = G__19811;
count__19369_19802 = G__19812;
i__19370_19803 = G__19813;
continue;
} else {
var temp__5735__auto___19820 = cljs.core.seq(seq__19367_19800);
if(temp__5735__auto___19820){
var seq__19367_19824__$1 = temp__5735__auto___19820;
if(cljs.core.chunked_seq_QMARK_(seq__19367_19824__$1)){
var c__4609__auto___19825 = cljs.core.chunk_first(seq__19367_19824__$1);
var G__19826 = cljs.core.chunk_rest(seq__19367_19824__$1);
var G__19827 = c__4609__auto___19825;
var G__19828 = cljs.core.count(c__4609__auto___19825);
var G__19829 = (0);
seq__19367_19800 = G__19826;
chunk__19368_19801 = G__19827;
count__19369_19802 = G__19828;
i__19370_19803 = G__19829;
continue;
} else {
var vec__19383_19831 = cljs.core.first(seq__19367_19824__$1);
var k_19832 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19383_19831,(0),null);
var v_19833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19383_19831,(1),null);
dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k_19832,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_19833),"px"].join('')], 0));


var G__19836 = cljs.core.next(seq__19367_19824__$1);
var G__19837 = null;
var G__19838 = (0);
var G__19839 = (0);
seq__19367_19800 = G__19836;
chunk__19368_19801 = G__19837;
count__19369_19802 = G__19838;
i__19370_19803 = G__19839;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.set_px_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.set_px_BANG_.cljs$lang$applyTo = (function (seq19362){
var G__19363 = cljs.core.first(seq19362);
var seq19362__$1 = cljs.core.next(seq19362);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19363,seq19362__$1);
}));

/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to their name:
 * 
 *     (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 *     (set-attr! elem :id "some-id"
 *                     :name "some-name")
 */
dommy.core.set_attr_BANG_ = (function dommy$core$set_attr_BANG_(var_args){
var G__19396 = arguments.length;
switch (G__19396) {
case 2:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___19845 = arguments.length;
var i__4790__auto___19846 = (0);
while(true){
if((i__4790__auto___19846 < len__4789__auto___19845)){
args_arr__4810__auto__.push((arguments[i__4790__auto___19846]));

var G__19849 = (i__4790__auto___19846 + (1));
i__4790__auto___19846 = G__19849;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((3)),(0),null));
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4811__auto__);

}
});

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,dommy.utils.as_str(k));
}));

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
var k__$1 = dommy.utils.as_str(k);
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_(v)){
var G__19398 = elem;
(G__19398[k__$1] = v);

return G__19398;
} else {
var G__19399 = elem;
G__19399.setAttribute(k__$1,v);

return G__19399;
}
} else {
return null;
}
}));

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__19402_19855 = cljs.core.seq(cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs)));
var chunk__19403_19856 = null;
var count__19404_19857 = (0);
var i__19405_19858 = (0);
while(true){
if((i__19405_19858 < count__19404_19857)){
var vec__19413_19861 = chunk__19403_19856.cljs$core$IIndexed$_nth$arity$2(null,i__19405_19858);
var k_19862__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19413_19861,(0),null);
var v_19863__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19413_19861,(1),null);
dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k_19862__$1,v_19863__$1);


var G__19864 = seq__19402_19855;
var G__19865 = chunk__19403_19856;
var G__19866 = count__19404_19857;
var G__19867 = (i__19405_19858 + (1));
seq__19402_19855 = G__19864;
chunk__19403_19856 = G__19865;
count__19404_19857 = G__19866;
i__19405_19858 = G__19867;
continue;
} else {
var temp__5735__auto___19868 = cljs.core.seq(seq__19402_19855);
if(temp__5735__auto___19868){
var seq__19402_19869__$1 = temp__5735__auto___19868;
if(cljs.core.chunked_seq_QMARK_(seq__19402_19869__$1)){
var c__4609__auto___19870 = cljs.core.chunk_first(seq__19402_19869__$1);
var G__19871 = cljs.core.chunk_rest(seq__19402_19869__$1);
var G__19872 = c__4609__auto___19870;
var G__19873 = cljs.core.count(c__4609__auto___19870);
var G__19874 = (0);
seq__19402_19855 = G__19871;
chunk__19403_19856 = G__19872;
count__19404_19857 = G__19873;
i__19405_19858 = G__19874;
continue;
} else {
var vec__19417_19877 = cljs.core.first(seq__19402_19869__$1);
var k_19878__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19417_19877,(0),null);
var v_19879__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19417_19877,(1),null);
dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k_19878__$1,v_19879__$1);


var G__19882 = cljs.core.next(seq__19402_19869__$1);
var G__19883 = null;
var G__19884 = (0);
var G__19885 = (0);
seq__19402_19855 = G__19882;
chunk__19403_19856 = G__19883;
count__19404_19857 = G__19884;
i__19405_19858 = G__19885;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.set_attr_BANG_.cljs$lang$applyTo = (function (seq19392){
var G__19393 = cljs.core.first(seq19392);
var seq19392__$1 = cljs.core.next(seq19392);
var G__19394 = cljs.core.first(seq19392__$1);
var seq19392__$2 = cljs.core.next(seq19392__$1);
var G__19395 = cljs.core.first(seq19392__$2);
var seq19392__$3 = cljs.core.next(seq19392__$2);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19393,G__19394,G__19395,seq19392__$3);
}));

(dommy.core.set_attr_BANG_.cljs$lang$maxFixedArity = (3));

/**
 * Removes dom attributes on and returns `elem`.
 * `class` and `classes` are special cases which clear
 * out the class name on removal.
 */
dommy.core.remove_attr_BANG_ = (function dommy$core$remove_attr_BANG_(var_args){
var G__19424 = arguments.length;
switch (G__19424) {
case 2:
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___19892 = arguments.length;
var i__4790__auto___19893 = (0);
while(true){
if((i__4790__auto___19893 < len__4789__auto___19892)){
args_arr__4810__auto__.push((arguments[i__4790__auto___19893]));

var G__19894 = (i__4790__auto___19893 + (1));
i__4790__auto___19893 = G__19894;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var k_19895__$1 = dommy.utils.as_str(k);
if(cljs.core.truth_((function (){var fexpr__19425 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["class",null,"classes",null], null), null);
return (fexpr__19425.cljs$core$IFn$_invoke$arity$1 ? fexpr__19425.cljs$core$IFn$_invoke$arity$1(k_19895__$1) : fexpr__19425.call(null,k_19895__$1));
})())){
dommy.core.set_class_BANG_(elem,"");
} else {
elem.removeAttribute(k_19895__$1);
}

return elem;
}));

(dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var seq__19426_19897 = cljs.core.seq(cljs.core.cons(k,ks));
var chunk__19427_19898 = null;
var count__19428_19899 = (0);
var i__19429_19900 = (0);
while(true){
if((i__19429_19900 < count__19428_19899)){
var k_19901__$1 = chunk__19427_19898.cljs$core$IIndexed$_nth$arity$2(null,i__19429_19900);
dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k_19901__$1);


var G__19903 = seq__19426_19897;
var G__19904 = chunk__19427_19898;
var G__19905 = count__19428_19899;
var G__19906 = (i__19429_19900 + (1));
seq__19426_19897 = G__19903;
chunk__19427_19898 = G__19904;
count__19428_19899 = G__19905;
i__19429_19900 = G__19906;
continue;
} else {
var temp__5735__auto___19909 = cljs.core.seq(seq__19426_19897);
if(temp__5735__auto___19909){
var seq__19426_19910__$1 = temp__5735__auto___19909;
if(cljs.core.chunked_seq_QMARK_(seq__19426_19910__$1)){
var c__4609__auto___19911 = cljs.core.chunk_first(seq__19426_19910__$1);
var G__19912 = cljs.core.chunk_rest(seq__19426_19910__$1);
var G__19913 = c__4609__auto___19911;
var G__19914 = cljs.core.count(c__4609__auto___19911);
var G__19915 = (0);
seq__19426_19897 = G__19912;
chunk__19427_19898 = G__19913;
count__19428_19899 = G__19914;
i__19429_19900 = G__19915;
continue;
} else {
var k_19916__$1 = cljs.core.first(seq__19426_19910__$1);
dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k_19916__$1);


var G__19917 = cljs.core.next(seq__19426_19910__$1);
var G__19918 = null;
var G__19919 = (0);
var G__19920 = (0);
seq__19426_19897 = G__19917;
chunk__19427_19898 = G__19918;
count__19428_19899 = G__19919;
i__19429_19900 = G__19920;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.remove_attr_BANG_.cljs$lang$applyTo = (function (seq19421){
var G__19422 = cljs.core.first(seq19421);
var seq19421__$1 = cljs.core.next(seq19421);
var G__19423 = cljs.core.first(seq19421__$1);
var seq19421__$2 = cljs.core.next(seq19421__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19422,G__19423,seq19421__$2);
}));

(dommy.core.remove_attr_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Toggles a dom attribute `k` on `elem`, optionally specifying
 * the boolean value with `add?`
 */
dommy.core.toggle_attr_BANG_ = (function dommy$core$toggle_attr_BANG_(var_args){
var G__19432 = arguments.length;
switch (G__19432) {
case 2:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,cljs.core.boolean$(dommy.core.attr(elem,k)));
}));

(dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
if(add_QMARK_){
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k);
} else {
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k);
}
}));

(dommy.core.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Add `classes` to `elem`, trying to use Element::classList, and
 * falling back to fast string parsing/manipulation
 */
dommy.core.add_class_BANG_ = (function dommy$core$add_class_BANG_(var_args){
var G__19437 = arguments.length;
switch (G__19437) {
case 2:
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___19923 = arguments.length;
var i__4790__auto___19924 = (0);
while(true){
if((i__4790__auto___19924 < len__4789__auto___19923)){
args_arr__4810__auto__.push((arguments[i__4790__auto___19924]));

var G__19925 = (i__4790__auto___19924 + (1));
i__4790__auto___19924 = G__19925;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var classes__$1 = clojure.string.trim(dommy.utils.as_str(classes)).split(/\s+/);
if(cljs.core.seq(classes__$1)){
var temp__5733__auto___19930 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___19930)){
var class_list_19931 = temp__5733__auto___19930;
var seq__19438_19932 = cljs.core.seq(classes__$1);
var chunk__19439_19933 = null;
var count__19440_19934 = (0);
var i__19441_19935 = (0);
while(true){
if((i__19441_19935 < count__19440_19934)){
var c_19936 = chunk__19439_19933.cljs$core$IIndexed$_nth$arity$2(null,i__19441_19935);
class_list_19931.add(c_19936);


var G__19937 = seq__19438_19932;
var G__19938 = chunk__19439_19933;
var G__19939 = count__19440_19934;
var G__19940 = (i__19441_19935 + (1));
seq__19438_19932 = G__19937;
chunk__19439_19933 = G__19938;
count__19440_19934 = G__19939;
i__19441_19935 = G__19940;
continue;
} else {
var temp__5735__auto___19941 = cljs.core.seq(seq__19438_19932);
if(temp__5735__auto___19941){
var seq__19438_19942__$1 = temp__5735__auto___19941;
if(cljs.core.chunked_seq_QMARK_(seq__19438_19942__$1)){
var c__4609__auto___19944 = cljs.core.chunk_first(seq__19438_19942__$1);
var G__19945 = cljs.core.chunk_rest(seq__19438_19942__$1);
var G__19946 = c__4609__auto___19944;
var G__19947 = cljs.core.count(c__4609__auto___19944);
var G__19948 = (0);
seq__19438_19932 = G__19945;
chunk__19439_19933 = G__19946;
count__19440_19934 = G__19947;
i__19441_19935 = G__19948;
continue;
} else {
var c_19952 = cljs.core.first(seq__19438_19942__$1);
class_list_19931.add(c_19952);


var G__19953 = cljs.core.next(seq__19438_19942__$1);
var G__19954 = null;
var G__19955 = (0);
var G__19956 = (0);
seq__19438_19932 = G__19953;
chunk__19439_19933 = G__19954;
count__19440_19934 = G__19955;
i__19441_19935 = G__19956;
continue;
}
} else {
}
}
break;
}
} else {
var seq__19442_19957 = cljs.core.seq(classes__$1);
var chunk__19443_19958 = null;
var count__19444_19959 = (0);
var i__19445_19960 = (0);
while(true){
if((i__19445_19960 < count__19444_19959)){
var c_19961 = chunk__19443_19958.cljs$core$IIndexed$_nth$arity$2(null,i__19445_19960);
var class_name_19962 = dommy.core.class$(elem);
if(cljs.core.truth_(dommy.utils.class_index(class_name_19962,c_19961))){
} else {
dommy.core.set_class_BANG_(elem,(((class_name_19962 === ""))?c_19961:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_19962)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_19961)].join('')));
}


var G__19963 = seq__19442_19957;
var G__19964 = chunk__19443_19958;
var G__19965 = count__19444_19959;
var G__19966 = (i__19445_19960 + (1));
seq__19442_19957 = G__19963;
chunk__19443_19958 = G__19964;
count__19444_19959 = G__19965;
i__19445_19960 = G__19966;
continue;
} else {
var temp__5735__auto___19967 = cljs.core.seq(seq__19442_19957);
if(temp__5735__auto___19967){
var seq__19442_19968__$1 = temp__5735__auto___19967;
if(cljs.core.chunked_seq_QMARK_(seq__19442_19968__$1)){
var c__4609__auto___19971 = cljs.core.chunk_first(seq__19442_19968__$1);
var G__19973 = cljs.core.chunk_rest(seq__19442_19968__$1);
var G__19974 = c__4609__auto___19971;
var G__19975 = cljs.core.count(c__4609__auto___19971);
var G__19976 = (0);
seq__19442_19957 = G__19973;
chunk__19443_19958 = G__19974;
count__19444_19959 = G__19975;
i__19445_19960 = G__19976;
continue;
} else {
var c_19977 = cljs.core.first(seq__19442_19968__$1);
var class_name_19978 = dommy.core.class$(elem);
if(cljs.core.truth_(dommy.utils.class_index(class_name_19978,c_19977))){
} else {
dommy.core.set_class_BANG_(elem,(((class_name_19978 === ""))?c_19977:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_19978)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_19977)].join('')));
}


var G__19979 = cljs.core.next(seq__19442_19968__$1);
var G__19980 = null;
var G__19981 = (0);
var G__19982 = (0);
seq__19442_19957 = G__19979;
chunk__19443_19958 = G__19980;
count__19444_19959 = G__19981;
i__19445_19960 = G__19982;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem;
}));

(dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var seq__19446_19983 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(more_classes,classes));
var chunk__19447_19984 = null;
var count__19448_19985 = (0);
var i__19449_19986 = (0);
while(true){
if((i__19449_19986 < count__19448_19985)){
var c_19987 = chunk__19447_19984.cljs$core$IIndexed$_nth$arity$2(null,i__19449_19986);
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c_19987);


var G__19988 = seq__19446_19983;
var G__19989 = chunk__19447_19984;
var G__19990 = count__19448_19985;
var G__19991 = (i__19449_19986 + (1));
seq__19446_19983 = G__19988;
chunk__19447_19984 = G__19989;
count__19448_19985 = G__19990;
i__19449_19986 = G__19991;
continue;
} else {
var temp__5735__auto___19992 = cljs.core.seq(seq__19446_19983);
if(temp__5735__auto___19992){
var seq__19446_19994__$1 = temp__5735__auto___19992;
if(cljs.core.chunked_seq_QMARK_(seq__19446_19994__$1)){
var c__4609__auto___19995 = cljs.core.chunk_first(seq__19446_19994__$1);
var G__19996 = cljs.core.chunk_rest(seq__19446_19994__$1);
var G__19997 = c__4609__auto___19995;
var G__19998 = cljs.core.count(c__4609__auto___19995);
var G__19999 = (0);
seq__19446_19983 = G__19996;
chunk__19447_19984 = G__19997;
count__19448_19985 = G__19998;
i__19449_19986 = G__19999;
continue;
} else {
var c_20000 = cljs.core.first(seq__19446_19994__$1);
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c_20000);


var G__20001 = cljs.core.next(seq__19446_19994__$1);
var G__20002 = null;
var G__20003 = (0);
var G__20004 = (0);
seq__19446_19983 = G__20001;
chunk__19447_19984 = G__20002;
count__19448_19985 = G__20003;
i__19449_19986 = G__20004;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.add_class_BANG_.cljs$lang$applyTo = (function (seq19434){
var G__19435 = cljs.core.first(seq19434);
var seq19434__$1 = cljs.core.next(seq19434);
var G__19436 = cljs.core.first(seq19434__$1);
var seq19434__$2 = cljs.core.next(seq19434__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19435,G__19436,seq19434__$2);
}));

(dommy.core.add_class_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Remove `c` from `elem` class list
 */
dommy.core.remove_class_BANG_ = (function dommy$core$remove_class_BANG_(var_args){
var G__19454 = arguments.length;
switch (G__19454) {
case 2:
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___20009 = arguments.length;
var i__4790__auto___20010 = (0);
while(true){
if((i__4790__auto___20010 < len__4789__auto___20009)){
args_arr__4810__auto__.push((arguments[i__4790__auto___20010]));

var G__20011 = (i__4790__auto___20010 + (1));
i__4790__auto___20010 = G__20011;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto___20012 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___20012)){
var class_list_20013 = temp__5733__auto___20012;
class_list_20013.remove(c__$1);
} else {
var class_name_20014 = dommy.core.class$(elem);
var new_class_name_20015 = dommy.utils.remove_class_str(class_name_20014,c__$1);
if((class_name_20014 === new_class_name_20015)){
} else {
dommy.core.set_class_BANG_(elem,new_class_name_20015);
}
}

return elem;
}));

(dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var seq__19455 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(classes,class$));
var chunk__19456 = null;
var count__19457 = (0);
var i__19458 = (0);
while(true){
if((i__19458 < count__19457)){
var c = chunk__19456.cljs$core$IIndexed$_nth$arity$2(null,i__19458);
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c);


var G__20016 = seq__19455;
var G__20017 = chunk__19456;
var G__20018 = count__19457;
var G__20019 = (i__19458 + (1));
seq__19455 = G__20016;
chunk__19456 = G__20017;
count__19457 = G__20018;
i__19458 = G__20019;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__19455);
if(temp__5735__auto__){
var seq__19455__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__19455__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__19455__$1);
var G__20023 = cljs.core.chunk_rest(seq__19455__$1);
var G__20024 = c__4609__auto__;
var G__20025 = cljs.core.count(c__4609__auto__);
var G__20026 = (0);
seq__19455 = G__20023;
chunk__19456 = G__20024;
count__19457 = G__20025;
i__19458 = G__20026;
continue;
} else {
var c = cljs.core.first(seq__19455__$1);
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c);


var G__20027 = cljs.core.next(seq__19455__$1);
var G__20028 = null;
var G__20029 = (0);
var G__20030 = (0);
seq__19455 = G__20027;
chunk__19456 = G__20028;
count__19457 = G__20029;
i__19458 = G__20030;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(dommy.core.remove_class_BANG_.cljs$lang$applyTo = (function (seq19451){
var G__19452 = cljs.core.first(seq19451);
var seq19451__$1 = cljs.core.next(seq19451);
var G__19453 = cljs.core.first(seq19451__$1);
var seq19451__$2 = cljs.core.next(seq19451__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19452,G__19453,seq19451__$2);
}));

(dommy.core.remove_class_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.core.toggle_class_BANG_ = (function dommy$core$toggle_class_BANG_(var_args){
var G__19460 = arguments.length;
switch (G__19460) {
case 2:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto___20032 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___20032)){
var class_list_20033 = temp__5733__auto___20032;
class_list_20033.toggle(c__$1);
} else {
dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3(elem,c__$1,(!(dommy.core.has_class_QMARK_(elem,c__$1))));
}

return elem;
}));

(dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
if(add_QMARK_){
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,class$);
} else {
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,class$);
}

return elem;
}));

(dommy.core.toggle_class_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Display or hide the given `elem` (using display: none).
 * Takes an optional boolean `show?`
 */
dommy.core.toggle_BANG_ = (function dommy$core$toggle_BANG_(var_args){
var G__19463 = arguments.length;
switch (G__19463) {
case 2:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"display","display",242065432),((show_QMARK_)?"":"none")], 0));
}));

(dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,dommy.core.hidden_QMARK_(elem));
}));

(dommy.core.toggle_BANG_.cljs$lang$maxFixedArity = 2);

dommy.core.hide_BANG_ = (function dommy$core$hide_BANG_(elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,false);
});
dommy.core.show_BANG_ = (function dommy$core$show_BANG_(elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,true);
});
dommy.core.scroll_into_view = (function dommy$core$scroll_into_view(elem,align_with_top_QMARK_){
var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.core.bounding_client_rect(elem));
if((window.innerHeight < (top + elem.offsetHeight))){
return elem.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
dommy.core.create_element = (function dommy$core$create_element(var_args){
var G__19465 = arguments.length;
switch (G__19465) {
case 1:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.create_element.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return document.createElement(dommy.utils.as_str(tag));
}));

(dommy.core.create_element.cljs$core$IFn$_invoke$arity$2 = (function (tag_ns,tag){
return document.createElementNS(dommy.utils.as_str(tag_ns),dommy.utils.as_str(tag));
}));

(dommy.core.create_element.cljs$lang$maxFixedArity = 2);

dommy.core.create_text_node = (function dommy$core$create_text_node(text){
return document.createTextNode(text);
});
/**
 * Clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.core.set_html_BANG_(elem,"");
});
/**
 * Append `child` to `parent`
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(var_args){
var G__19471 = arguments.length;
switch (G__19471) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___20042 = arguments.length;
var i__4790__auto___20043 = (0);
while(true){
if((i__4790__auto___20043 < len__4789__auto___20042)){
args_arr__4810__auto__.push((arguments[i__4790__auto___20043]));

var G__20044 = (i__4790__auto___20043 + (1));
i__4790__auto___20043 = G__20044;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__19472 = parent;
G__19472.appendChild(child);

return G__19472;
}));

(dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__19473_20045 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__19474_20046 = null;
var count__19475_20047 = (0);
var i__19476_20048 = (0);
while(true){
if((i__19476_20048 < count__19475_20047)){
var c_20051 = chunk__19474_20046.cljs$core$IIndexed$_nth$arity$2(null,i__19476_20048);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_20051);


var G__20052 = seq__19473_20045;
var G__20053 = chunk__19474_20046;
var G__20054 = count__19475_20047;
var G__20055 = (i__19476_20048 + (1));
seq__19473_20045 = G__20052;
chunk__19474_20046 = G__20053;
count__19475_20047 = G__20054;
i__19476_20048 = G__20055;
continue;
} else {
var temp__5735__auto___20056 = cljs.core.seq(seq__19473_20045);
if(temp__5735__auto___20056){
var seq__19473_20057__$1 = temp__5735__auto___20056;
if(cljs.core.chunked_seq_QMARK_(seq__19473_20057__$1)){
var c__4609__auto___20058 = cljs.core.chunk_first(seq__19473_20057__$1);
var G__20059 = cljs.core.chunk_rest(seq__19473_20057__$1);
var G__20060 = c__4609__auto___20058;
var G__20061 = cljs.core.count(c__4609__auto___20058);
var G__20062 = (0);
seq__19473_20045 = G__20059;
chunk__19474_20046 = G__20060;
count__19475_20047 = G__20061;
i__19476_20048 = G__20062;
continue;
} else {
var c_20063 = cljs.core.first(seq__19473_20057__$1);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_20063);


var G__20065 = cljs.core.next(seq__19473_20057__$1);
var G__20066 = null;
var G__20067 = (0);
var G__20068 = (0);
seq__19473_20045 = G__20065;
chunk__19474_20046 = G__20066;
count__19475_20047 = G__20067;
i__19476_20048 = G__20068;
continue;
}
} else {
}
}
break;
}

return parent;
}));

/** @this {Function} */
(dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq19468){
var G__19469 = cljs.core.first(seq19468);
var seq19468__$1 = cljs.core.next(seq19468);
var G__19470 = cljs.core.first(seq19468__$1);
var seq19468__$2 = cljs.core.next(seq19468__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19469,G__19470,seq19468__$2);
}));

(dommy.core.append_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Prepend `child` to `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(var_args){
var G__19481 = arguments.length;
switch (G__19481) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___20075 = arguments.length;
var i__4790__auto___20076 = (0);
while(true){
if((i__4790__auto___20076 < len__4789__auto___20075)){
args_arr__4810__auto__.push((arguments[i__4790__auto___20076]));

var G__20077 = (i__4790__auto___20076 + (1));
i__4790__auto___20076 = G__20077;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__19482 = parent;
G__19482.insertBefore(child,parent.firstChild);

return G__19482;
}));

(dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__19483_20078 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__19484_20079 = null;
var count__19485_20080 = (0);
var i__19486_20081 = (0);
while(true){
if((i__19486_20081 < count__19485_20080)){
var c_20082 = chunk__19484_20079.cljs$core$IIndexed$_nth$arity$2(null,i__19486_20081);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_20082);


var G__20083 = seq__19483_20078;
var G__20084 = chunk__19484_20079;
var G__20085 = count__19485_20080;
var G__20086 = (i__19486_20081 + (1));
seq__19483_20078 = G__20083;
chunk__19484_20079 = G__20084;
count__19485_20080 = G__20085;
i__19486_20081 = G__20086;
continue;
} else {
var temp__5735__auto___20087 = cljs.core.seq(seq__19483_20078);
if(temp__5735__auto___20087){
var seq__19483_20088__$1 = temp__5735__auto___20087;
if(cljs.core.chunked_seq_QMARK_(seq__19483_20088__$1)){
var c__4609__auto___20089 = cljs.core.chunk_first(seq__19483_20088__$1);
var G__20090 = cljs.core.chunk_rest(seq__19483_20088__$1);
var G__20091 = c__4609__auto___20089;
var G__20092 = cljs.core.count(c__4609__auto___20089);
var G__20093 = (0);
seq__19483_20078 = G__20090;
chunk__19484_20079 = G__20091;
count__19485_20080 = G__20092;
i__19486_20081 = G__20093;
continue;
} else {
var c_20094 = cljs.core.first(seq__19483_20088__$1);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_20094);


var G__20095 = cljs.core.next(seq__19483_20088__$1);
var G__20096 = null;
var G__20097 = (0);
var G__20098 = (0);
seq__19483_20078 = G__20095;
chunk__19484_20079 = G__20096;
count__19485_20080 = G__20097;
i__19486_20081 = G__20098;
continue;
}
} else {
}
}
break;
}

return parent;
}));

/** @this {Function} */
(dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq19478){
var G__19479 = cljs.core.first(seq19478);
var seq19478__$1 = cljs.core.next(seq19478);
var G__19480 = cljs.core.first(seq19478__$1);
var seq19478__$2 = cljs.core.next(seq19478__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19479,G__19480,seq19478__$2);
}));

(dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Insert `elem` before `other`, `other` must have a parent
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var p = dommy.core.parent(other);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

p.insertBefore(elem,other);

return elem;
});
/**
 * Insert `elem` after `other`, `other` must have a parent
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var temp__5733__auto___20099 = other.nextSibling;
if(cljs.core.truth_(temp__5733__auto___20099)){
var next_20100 = temp__5733__auto___20099;
dommy.core.insert_before_BANG_(elem,next_20100);
} else {
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(dommy.core.parent(other),elem);
}

return elem;
});
/**
 * Replace `elem` with `new`, return `new`
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var p = dommy.core.parent(elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

p.replaceChild(new$,elem);

return new$;
});
/**
 * Replace children of `elem` with `child`
 */
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(p,child){
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(dommy.core.clear_BANG_(p),child);
});
/**
 * Remove `elem` from `parent`, return `parent`
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(var_args){
var G__19489 = arguments.length;
switch (G__19489) {
case 1:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var p = dommy.core.parent(elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2(p,elem);
}));

(dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (p,elem){
var G__19490 = p;
G__19490.removeChild(elem);

return G__19490;
}));

(dommy.core.remove_BANG_.cljs$lang$maxFixedArity = 2);

dommy.core.special_listener_makers = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__19491){
var vec__19492 = p__19491;
var special_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19492,(0),null);
var real_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19492,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,cljs.core.PersistentArrayMap.createAsIfByAssoc([real_mouse_event,(function (f){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__4185__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__4174__auto__ = related_target;
if(cljs.core.truth_(and__4174__auto__)){
return dommy.core.descendant_QMARK_(related_target,listener_target);
} else {
return and__4174__auto__;
}
})())){
return null;
} else {
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(event) : f.call(null,event));
}
});
})])], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.cljs$core$IFn$_invoke$arity$3(elem,event.target,selector);
if(cljs.core.truth_((function (){var and__4174__auto__ = selected_target;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.not(dommy.core.attr(selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else {
return and__4174__auto__;
}
})())){
(event.selectedTarget = selected_target);

return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(event) : f.call(null,event));
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `elem`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__4185__auto__ = elem.dommyEventListeners;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___20114 = arguments.length;
var i__4790__auto___20115 = (0);
while(true){
if((i__4790__auto___20115 < len__4789__auto___20114)){
args__4795__auto__.push((arguments[i__4790__auto___20115]));

var G__20116 = (i__4790__auto___20115 + (1));
i__4790__auto___20115 = G__20116;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = elem;
return (elem__$1.dommyEventListeners = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,dommy.core.event_listeners(elem__$1),args));
}));

(dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq19495){
var G__19496 = cljs.core.first(seq19495);
var seq19495__$1 = cljs.core.next(seq19495);
var G__19497 = cljs.core.first(seq19495__$1);
var seq19495__$2 = cljs.core.next(seq19495__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19496,G__19497,seq19495__$2);
}));

dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_(elem_sel)){
var fexpr__19498 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.rest);
return (fexpr__19498.cljs$core$IFn$_invoke$arity$1 ? fexpr__19498.cljs$core$IFn$_invoke$arity$1(elem_sel) : fexpr__19498.call(null,elem_sel));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elem_sel,null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 *     (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 *     (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 *     (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___20121 = arguments.length;
var i__4790__auto___20122 = (0);
while(true){
if((i__4790__auto___20122 < len__4789__auto___20121)){
args__4795__auto__.push((arguments[i__4790__auto___20122]));

var G__20123 = (i__4790__auto___20122 + (1));
i__4790__auto___20122 = G__20123;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__19504_20124 = dommy.core.elem_and_selector(elem_sel);
var elem_20125 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19504_20124,(0),null);
var selector_20126 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19504_20124,(1),null);
var seq__19507_20127 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__19514_20128 = null;
var count__19515_20129 = (0);
var i__19516_20130 = (0);
while(true){
if((i__19516_20130 < count__19515_20129)){
var vec__19584_20131 = chunk__19514_20128.cljs$core$IIndexed$_nth$arity$2(null,i__19516_20130);
var orig_type_20132 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19584_20131,(0),null);
var f_20133 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19584_20131,(1),null);
var seq__19517_20134 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_20132,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_20132,cljs.core.identity])));
var chunk__19519_20135 = null;
var count__19520_20136 = (0);
var i__19521_20137 = (0);
while(true){
if((i__19521_20137 < count__19520_20136)){
var vec__19597_20138 = chunk__19519_20135.cljs$core$IIndexed$_nth$arity$2(null,i__19521_20137);
var actual_type_20139 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19597_20138,(0),null);
var factory_20140 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19597_20138,(1),null);
var canonical_f_20141 = (function (){var G__19601 = (factory_20140.cljs$core$IFn$_invoke$arity$1 ? factory_20140.cljs$core$IFn$_invoke$arity$1(f_20133) : factory_20140.call(null,f_20133));
var fexpr__19600 = (cljs.core.truth_(selector_20126)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_20125,selector_20126):cljs.core.identity);
return (fexpr__19600.cljs$core$IFn$_invoke$arity$1 ? fexpr__19600.cljs$core$IFn$_invoke$arity$1(G__19601) : fexpr__19600.call(null,G__19601));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_20125,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_20126,actual_type_20139,f_20133], null),canonical_f_20141], 0));

if(cljs.core.truth_(elem_20125.addEventListener)){
elem_20125.addEventListener(cljs.core.name(actual_type_20139),canonical_f_20141);
} else {
elem_20125.attachEvent(cljs.core.name(actual_type_20139),canonical_f_20141);
}


var G__20142 = seq__19517_20134;
var G__20143 = chunk__19519_20135;
var G__20144 = count__19520_20136;
var G__20145 = (i__19521_20137 + (1));
seq__19517_20134 = G__20142;
chunk__19519_20135 = G__20143;
count__19520_20136 = G__20144;
i__19521_20137 = G__20145;
continue;
} else {
var temp__5735__auto___20146 = cljs.core.seq(seq__19517_20134);
if(temp__5735__auto___20146){
var seq__19517_20147__$1 = temp__5735__auto___20146;
if(cljs.core.chunked_seq_QMARK_(seq__19517_20147__$1)){
var c__4609__auto___20148 = cljs.core.chunk_first(seq__19517_20147__$1);
var G__20149 = cljs.core.chunk_rest(seq__19517_20147__$1);
var G__20150 = c__4609__auto___20148;
var G__20151 = cljs.core.count(c__4609__auto___20148);
var G__20152 = (0);
seq__19517_20134 = G__20149;
chunk__19519_20135 = G__20150;
count__19520_20136 = G__20151;
i__19521_20137 = G__20152;
continue;
} else {
var vec__19602_20154 = cljs.core.first(seq__19517_20147__$1);
var actual_type_20155 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19602_20154,(0),null);
var factory_20156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19602_20154,(1),null);
var canonical_f_20158 = (function (){var G__19606 = (factory_20156.cljs$core$IFn$_invoke$arity$1 ? factory_20156.cljs$core$IFn$_invoke$arity$1(f_20133) : factory_20156.call(null,f_20133));
var fexpr__19605 = (cljs.core.truth_(selector_20126)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_20125,selector_20126):cljs.core.identity);
return (fexpr__19605.cljs$core$IFn$_invoke$arity$1 ? fexpr__19605.cljs$core$IFn$_invoke$arity$1(G__19606) : fexpr__19605.call(null,G__19606));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_20125,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_20126,actual_type_20155,f_20133], null),canonical_f_20158], 0));

if(cljs.core.truth_(elem_20125.addEventListener)){
elem_20125.addEventListener(cljs.core.name(actual_type_20155),canonical_f_20158);
} else {
elem_20125.attachEvent(cljs.core.name(actual_type_20155),canonical_f_20158);
}


var G__20160 = cljs.core.next(seq__19517_20147__$1);
var G__20161 = null;
var G__20162 = (0);
var G__20163 = (0);
seq__19517_20134 = G__20160;
chunk__19519_20135 = G__20161;
count__19520_20136 = G__20162;
i__19521_20137 = G__20163;
continue;
}
} else {
}
}
break;
}

var G__20164 = seq__19507_20127;
var G__20165 = chunk__19514_20128;
var G__20166 = count__19515_20129;
var G__20167 = (i__19516_20130 + (1));
seq__19507_20127 = G__20164;
chunk__19514_20128 = G__20165;
count__19515_20129 = G__20166;
i__19516_20130 = G__20167;
continue;
} else {
var temp__5735__auto___20169 = cljs.core.seq(seq__19507_20127);
if(temp__5735__auto___20169){
var seq__19507_20170__$1 = temp__5735__auto___20169;
if(cljs.core.chunked_seq_QMARK_(seq__19507_20170__$1)){
var c__4609__auto___20171 = cljs.core.chunk_first(seq__19507_20170__$1);
var G__20172 = cljs.core.chunk_rest(seq__19507_20170__$1);
var G__20173 = c__4609__auto___20171;
var G__20174 = cljs.core.count(c__4609__auto___20171);
var G__20175 = (0);
seq__19507_20127 = G__20172;
chunk__19514_20128 = G__20173;
count__19515_20129 = G__20174;
i__19516_20130 = G__20175;
continue;
} else {
var vec__19607_20176 = cljs.core.first(seq__19507_20170__$1);
var orig_type_20177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19607_20176,(0),null);
var f_20178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19607_20176,(1),null);
var seq__19508_20179 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_20177,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_20177,cljs.core.identity])));
var chunk__19510_20180 = null;
var count__19511_20181 = (0);
var i__19512_20182 = (0);
while(true){
if((i__19512_20182 < count__19511_20181)){
var vec__19620_20184 = chunk__19510_20180.cljs$core$IIndexed$_nth$arity$2(null,i__19512_20182);
var actual_type_20185 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19620_20184,(0),null);
var factory_20186 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19620_20184,(1),null);
var canonical_f_20187 = (function (){var G__19624 = (factory_20186.cljs$core$IFn$_invoke$arity$1 ? factory_20186.cljs$core$IFn$_invoke$arity$1(f_20178) : factory_20186.call(null,f_20178));
var fexpr__19623 = (cljs.core.truth_(selector_20126)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_20125,selector_20126):cljs.core.identity);
return (fexpr__19623.cljs$core$IFn$_invoke$arity$1 ? fexpr__19623.cljs$core$IFn$_invoke$arity$1(G__19624) : fexpr__19623.call(null,G__19624));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_20125,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_20126,actual_type_20185,f_20178], null),canonical_f_20187], 0));

if(cljs.core.truth_(elem_20125.addEventListener)){
elem_20125.addEventListener(cljs.core.name(actual_type_20185),canonical_f_20187);
} else {
elem_20125.attachEvent(cljs.core.name(actual_type_20185),canonical_f_20187);
}


var G__20189 = seq__19508_20179;
var G__20190 = chunk__19510_20180;
var G__20191 = count__19511_20181;
var G__20192 = (i__19512_20182 + (1));
seq__19508_20179 = G__20189;
chunk__19510_20180 = G__20190;
count__19511_20181 = G__20191;
i__19512_20182 = G__20192;
continue;
} else {
var temp__5735__auto___20194__$1 = cljs.core.seq(seq__19508_20179);
if(temp__5735__auto___20194__$1){
var seq__19508_20196__$1 = temp__5735__auto___20194__$1;
if(cljs.core.chunked_seq_QMARK_(seq__19508_20196__$1)){
var c__4609__auto___20197 = cljs.core.chunk_first(seq__19508_20196__$1);
var G__20198 = cljs.core.chunk_rest(seq__19508_20196__$1);
var G__20199 = c__4609__auto___20197;
var G__20200 = cljs.core.count(c__4609__auto___20197);
var G__20201 = (0);
seq__19508_20179 = G__20198;
chunk__19510_20180 = G__20199;
count__19511_20181 = G__20200;
i__19512_20182 = G__20201;
continue;
} else {
var vec__19625_20202 = cljs.core.first(seq__19508_20196__$1);
var actual_type_20203 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19625_20202,(0),null);
var factory_20204 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19625_20202,(1),null);
var canonical_f_20206 = (function (){var G__19629 = (factory_20204.cljs$core$IFn$_invoke$arity$1 ? factory_20204.cljs$core$IFn$_invoke$arity$1(f_20178) : factory_20204.call(null,f_20178));
var fexpr__19628 = (cljs.core.truth_(selector_20126)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_20125,selector_20126):cljs.core.identity);
return (fexpr__19628.cljs$core$IFn$_invoke$arity$1 ? fexpr__19628.cljs$core$IFn$_invoke$arity$1(G__19629) : fexpr__19628.call(null,G__19629));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_20125,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_20126,actual_type_20203,f_20178], null),canonical_f_20206], 0));

if(cljs.core.truth_(elem_20125.addEventListener)){
elem_20125.addEventListener(cljs.core.name(actual_type_20203),canonical_f_20206);
} else {
elem_20125.attachEvent(cljs.core.name(actual_type_20203),canonical_f_20206);
}


var G__20210 = cljs.core.next(seq__19508_20196__$1);
var G__20211 = null;
var G__20212 = (0);
var G__20213 = (0);
seq__19508_20179 = G__20210;
chunk__19510_20180 = G__20211;
count__19511_20181 = G__20212;
i__19512_20182 = G__20213;
continue;
}
} else {
}
}
break;
}

var G__20214 = cljs.core.next(seq__19507_20170__$1);
var G__20215 = null;
var G__20216 = (0);
var G__20217 = (0);
seq__19507_20127 = G__20214;
chunk__19514_20128 = G__20215;
count__19515_20129 = G__20216;
i__19516_20130 = G__20217;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq19500){
var G__19501 = cljs.core.first(seq19500);
var seq19500__$1 = cljs.core.next(seq19500);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19501,seq19500__$1);
}));

/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 *   The following forms are allowed, and will remove all handlers
 *   that match the parameters passed in:
 * 
 *    (unlisten! [elem :.selector] :click event-listener)
 * 
 *    (unlisten! [elem :.selector]
 *      :click event-listener
 *      :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___20218 = arguments.length;
var i__4790__auto___20219 = (0);
while(true){
if((i__4790__auto___20219 < len__4789__auto___20218)){
args__4795__auto__.push((arguments[i__4790__auto___20219]));

var G__20220 = (i__4790__auto___20219 + (1));
i__4790__auto___20219 = G__20220;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__19632_20221 = dommy.core.elem_and_selector(elem_sel);
var elem_20222 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19632_20221,(0),null);
var selector_20223 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19632_20221,(1),null);
var seq__19635_20224 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__19642_20225 = null;
var count__19643_20226 = (0);
var i__19644_20227 = (0);
while(true){
if((i__19644_20227 < count__19643_20226)){
var vec__19681_20228 = chunk__19642_20225.cljs$core$IIndexed$_nth$arity$2(null,i__19644_20227);
var orig_type_20229 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19681_20228,(0),null);
var f_20230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19681_20228,(1),null);
var seq__19645_20231 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_20229,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_20229,cljs.core.identity])));
var chunk__19647_20232 = null;
var count__19648_20233 = (0);
var i__19649_20234 = (0);
while(true){
if((i__19649_20234 < count__19648_20233)){
var vec__19690_20237 = chunk__19647_20232.cljs$core$IIndexed$_nth$arity$2(null,i__19649_20234);
var actual_type_20238 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19690_20237,(0),null);
var __20239 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19690_20237,(1),null);
var keys_20240 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_20223,actual_type_20238,f_20230], null);
var canonical_f_20241 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_20222),keys_20240);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_20222,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_20240], 0));

if(cljs.core.truth_(elem_20222.removeEventListener)){
elem_20222.removeEventListener(cljs.core.name(actual_type_20238),canonical_f_20241);
} else {
elem_20222.detachEvent(cljs.core.name(actual_type_20238),canonical_f_20241);
}


var G__20242 = seq__19645_20231;
var G__20243 = chunk__19647_20232;
var G__20244 = count__19648_20233;
var G__20245 = (i__19649_20234 + (1));
seq__19645_20231 = G__20242;
chunk__19647_20232 = G__20243;
count__19648_20233 = G__20244;
i__19649_20234 = G__20245;
continue;
} else {
var temp__5735__auto___20247 = cljs.core.seq(seq__19645_20231);
if(temp__5735__auto___20247){
var seq__19645_20249__$1 = temp__5735__auto___20247;
if(cljs.core.chunked_seq_QMARK_(seq__19645_20249__$1)){
var c__4609__auto___20250 = cljs.core.chunk_first(seq__19645_20249__$1);
var G__20251 = cljs.core.chunk_rest(seq__19645_20249__$1);
var G__20252 = c__4609__auto___20250;
var G__20253 = cljs.core.count(c__4609__auto___20250);
var G__20254 = (0);
seq__19645_20231 = G__20251;
chunk__19647_20232 = G__20252;
count__19648_20233 = G__20253;
i__19649_20234 = G__20254;
continue;
} else {
var vec__19693_20255 = cljs.core.first(seq__19645_20249__$1);
var actual_type_20256 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19693_20255,(0),null);
var __20257 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19693_20255,(1),null);
var keys_20258 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_20223,actual_type_20256,f_20230], null);
var canonical_f_20259 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_20222),keys_20258);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_20222,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_20258], 0));

if(cljs.core.truth_(elem_20222.removeEventListener)){
elem_20222.removeEventListener(cljs.core.name(actual_type_20256),canonical_f_20259);
} else {
elem_20222.detachEvent(cljs.core.name(actual_type_20256),canonical_f_20259);
}


var G__20263 = cljs.core.next(seq__19645_20249__$1);
var G__20264 = null;
var G__20265 = (0);
var G__20266 = (0);
seq__19645_20231 = G__20263;
chunk__19647_20232 = G__20264;
count__19648_20233 = G__20265;
i__19649_20234 = G__20266;
continue;
}
} else {
}
}
break;
}

var G__20267 = seq__19635_20224;
var G__20268 = chunk__19642_20225;
var G__20269 = count__19643_20226;
var G__20270 = (i__19644_20227 + (1));
seq__19635_20224 = G__20267;
chunk__19642_20225 = G__20268;
count__19643_20226 = G__20269;
i__19644_20227 = G__20270;
continue;
} else {
var temp__5735__auto___20271 = cljs.core.seq(seq__19635_20224);
if(temp__5735__auto___20271){
var seq__19635_20272__$1 = temp__5735__auto___20271;
if(cljs.core.chunked_seq_QMARK_(seq__19635_20272__$1)){
var c__4609__auto___20273 = cljs.core.chunk_first(seq__19635_20272__$1);
var G__20274 = cljs.core.chunk_rest(seq__19635_20272__$1);
var G__20275 = c__4609__auto___20273;
var G__20276 = cljs.core.count(c__4609__auto___20273);
var G__20277 = (0);
seq__19635_20224 = G__20274;
chunk__19642_20225 = G__20275;
count__19643_20226 = G__20276;
i__19644_20227 = G__20277;
continue;
} else {
var vec__19696_20278 = cljs.core.first(seq__19635_20272__$1);
var orig_type_20279 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19696_20278,(0),null);
var f_20280 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19696_20278,(1),null);
var seq__19636_20281 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_20279,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_20279,cljs.core.identity])));
var chunk__19638_20282 = null;
var count__19639_20283 = (0);
var i__19640_20284 = (0);
while(true){
if((i__19640_20284 < count__19639_20283)){
var vec__19705_20285 = chunk__19638_20282.cljs$core$IIndexed$_nth$arity$2(null,i__19640_20284);
var actual_type_20286 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19705_20285,(0),null);
var __20287 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19705_20285,(1),null);
var keys_20288 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_20223,actual_type_20286,f_20280], null);
var canonical_f_20289 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_20222),keys_20288);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_20222,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_20288], 0));

if(cljs.core.truth_(elem_20222.removeEventListener)){
elem_20222.removeEventListener(cljs.core.name(actual_type_20286),canonical_f_20289);
} else {
elem_20222.detachEvent(cljs.core.name(actual_type_20286),canonical_f_20289);
}


var G__20291 = seq__19636_20281;
var G__20292 = chunk__19638_20282;
var G__20293 = count__19639_20283;
var G__20294 = (i__19640_20284 + (1));
seq__19636_20281 = G__20291;
chunk__19638_20282 = G__20292;
count__19639_20283 = G__20293;
i__19640_20284 = G__20294;
continue;
} else {
var temp__5735__auto___20295__$1 = cljs.core.seq(seq__19636_20281);
if(temp__5735__auto___20295__$1){
var seq__19636_20296__$1 = temp__5735__auto___20295__$1;
if(cljs.core.chunked_seq_QMARK_(seq__19636_20296__$1)){
var c__4609__auto___20297 = cljs.core.chunk_first(seq__19636_20296__$1);
var G__20298 = cljs.core.chunk_rest(seq__19636_20296__$1);
var G__20299 = c__4609__auto___20297;
var G__20300 = cljs.core.count(c__4609__auto___20297);
var G__20301 = (0);
seq__19636_20281 = G__20298;
chunk__19638_20282 = G__20299;
count__19639_20283 = G__20300;
i__19640_20284 = G__20301;
continue;
} else {
var vec__19708_20302 = cljs.core.first(seq__19636_20296__$1);
var actual_type_20303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19708_20302,(0),null);
var __20304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19708_20302,(1),null);
var keys_20305 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_20223,actual_type_20303,f_20280], null);
var canonical_f_20306 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_20222),keys_20305);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_20222,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_20305], 0));

if(cljs.core.truth_(elem_20222.removeEventListener)){
elem_20222.removeEventListener(cljs.core.name(actual_type_20303),canonical_f_20306);
} else {
elem_20222.detachEvent(cljs.core.name(actual_type_20303),canonical_f_20306);
}


var G__20307 = cljs.core.next(seq__19636_20296__$1);
var G__20308 = null;
var G__20309 = (0);
var G__20310 = (0);
seq__19636_20281 = G__20307;
chunk__19638_20282 = G__20308;
count__19639_20283 = G__20309;
i__19640_20284 = G__20310;
continue;
}
} else {
}
}
break;
}

var G__20311 = cljs.core.next(seq__19635_20272__$1);
var G__20312 = null;
var G__20313 = (0);
var G__20314 = (0);
seq__19635_20224 = G__20311;
chunk__19642_20225 = G__20312;
count__19643_20226 = G__20313;
i__19644_20227 = G__20314;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq19630){
var G__19631 = cljs.core.first(seq19630);
var seq19630__$1 = cljs.core.next(seq19630);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19631,seq19630__$1);
}));

/**
 * Behaves like `listen!`, but removes the listener after the first event occurs.
 */
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___20315 = arguments.length;
var i__4790__auto___20316 = (0);
while(true){
if((i__4790__auto___20316 < len__4789__auto___20315)){
args__4795__auto__.push((arguments[i__4790__auto___20316]));

var G__20317 = (i__4790__auto___20316 + (1));
i__4790__auto___20316 = G__20317;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__19713_20319 = dommy.core.elem_and_selector(elem_sel);
var elem_20320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19713_20319,(0),null);
var selector_20321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19713_20319,(1),null);
var seq__19716_20322 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__19717_20323 = null;
var count__19718_20324 = (0);
var i__19719_20325 = (0);
while(true){
if((i__19719_20325 < count__19718_20324)){
var vec__19726_20326 = chunk__19717_20323.cljs$core$IIndexed$_nth$arity$2(null,i__19719_20325);
var type_20327 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19726_20326,(0),null);
var f_20328 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19726_20326,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_20327,((function (seq__19716_20322,chunk__19717_20323,count__19718_20324,i__19719_20325,vec__19726_20326,type_20327,f_20328,vec__19713_20319,elem_20320,selector_20321){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_20327,dommy$core$this_fn], 0));

return (f_20328.cljs$core$IFn$_invoke$arity$1 ? f_20328.cljs$core$IFn$_invoke$arity$1(e) : f_20328.call(null,e));
});})(seq__19716_20322,chunk__19717_20323,count__19718_20324,i__19719_20325,vec__19726_20326,type_20327,f_20328,vec__19713_20319,elem_20320,selector_20321))
], 0));


var G__20329 = seq__19716_20322;
var G__20330 = chunk__19717_20323;
var G__20331 = count__19718_20324;
var G__20332 = (i__19719_20325 + (1));
seq__19716_20322 = G__20329;
chunk__19717_20323 = G__20330;
count__19718_20324 = G__20331;
i__19719_20325 = G__20332;
continue;
} else {
var temp__5735__auto___20333 = cljs.core.seq(seq__19716_20322);
if(temp__5735__auto___20333){
var seq__19716_20334__$1 = temp__5735__auto___20333;
if(cljs.core.chunked_seq_QMARK_(seq__19716_20334__$1)){
var c__4609__auto___20335 = cljs.core.chunk_first(seq__19716_20334__$1);
var G__20336 = cljs.core.chunk_rest(seq__19716_20334__$1);
var G__20337 = c__4609__auto___20335;
var G__20338 = cljs.core.count(c__4609__auto___20335);
var G__20339 = (0);
seq__19716_20322 = G__20336;
chunk__19717_20323 = G__20337;
count__19718_20324 = G__20338;
i__19719_20325 = G__20339;
continue;
} else {
var vec__19729_20340 = cljs.core.first(seq__19716_20334__$1);
var type_20341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19729_20340,(0),null);
var f_20342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19729_20340,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_20341,((function (seq__19716_20322,chunk__19717_20323,count__19718_20324,i__19719_20325,vec__19729_20340,type_20341,f_20342,seq__19716_20334__$1,temp__5735__auto___20333,vec__19713_20319,elem_20320,selector_20321){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_20341,dommy$core$this_fn], 0));

return (f_20342.cljs$core$IFn$_invoke$arity$1 ? f_20342.cljs$core$IFn$_invoke$arity$1(e) : f_20342.call(null,e));
});})(seq__19716_20322,chunk__19717_20323,count__19718_20324,i__19719_20325,vec__19729_20340,type_20341,f_20342,seq__19716_20334__$1,temp__5735__auto___20333,vec__19713_20319,elem_20320,selector_20321))
], 0));


var G__20343 = cljs.core.next(seq__19716_20334__$1);
var G__20344 = null;
var G__20345 = (0);
var G__20346 = (0);
seq__19716_20322 = G__20343;
chunk__19717_20323 = G__20344;
count__19718_20324 = G__20345;
i__19719_20325 = G__20346;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq19711){
var G__19712 = cljs.core.first(seq19711);
var seq19711__$1 = cljs.core.next(seq19711);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19712,seq19711__$1);
}));


//# sourceMappingURL=dommy.core.js.map
