goog.provide('pinkgorilla.kernel.nrepl');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('cljs_uuid_utils.core');
goog.require('clojure.walk');
goog.require('cljs.core.async');
goog.require('chord.client');
goog.require('reagent.core');
goog.require('re_frame.core');
goog.require('pinkgorilla.util');
goog.require('pinkgorilla.notifications');
if((typeof pinkgorilla !== 'undefined') && (typeof pinkgorilla.kernel !== 'undefined') && (typeof pinkgorilla.kernel.nrepl !== 'undefined') && (typeof pinkgorilla.kernel.nrepl.ws_repl !== 'undefined')){
} else {
pinkgorilla.kernel.nrepl.ws_repl = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"channel","channel",734187692),null,new cljs.core.Keyword(null,"session-id","session-id",-1147060351),null,new cljs.core.Keyword(null,"evaluations","evaluations",57802423),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ciders","ciders",-1421942407),cljs.core.PersistentArrayMap.EMPTY], null));
}
/**
 * awb99: TODO: if websocket is nil, this will throw! (or not?).
 * This could be the error of some of the notebooks not loading.
 * Why dont we keep the core.async channels open all the time. And when we have a
 * websocket connection, then the messages get sent. Or we just dump messages that happen
 * before the socket gets opened. But in this case we have to LOG message dumping.
 * I have seen situations where the first eval does not go through. Might be this issue.
 * 
 */
pinkgorilla.kernel.nrepl.send_message_BANG_ = (function pinkgorilla$kernel$nrepl$send_message_BANG_(key,message,storeval){
var eval_id = cljs_uuid_utils.core.uuid_string(cljs_uuid_utils.core.make_random_uuid());
var nrepl_msg = cljs.core.clj__GT_js(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),eval_id,new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"session-id","session-id",-1147060351).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl))], null)], 0)));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(eval_id)], null),storeval);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl)),nrepl_msg);

return eval_id;
});
pinkgorilla.kernel.nrepl.eval_BANG_ = (function pinkgorilla$kernel$nrepl$eval_BANG_(segment_id,content){
return pinkgorilla.kernel.nrepl.send_message_BANG_(new cljs.core.Keyword(null,"evaluations","evaluations",57802423),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),"eval",new cljs.core.Keyword(null,"code","code",1586293142),content], null),segment_id);
});
pinkgorilla.kernel.nrepl.send_cider_message_BANG_ = (function pinkgorilla$kernel$nrepl$send_cider_message_BANG_(message,storeval){
return pinkgorilla.kernel.nrepl.send_message_BANG_(new cljs.core.Keyword(null,"ciders","ciders",-1421942407),message,storeval);
});
/**
 * Query the REPL server for autocompletion suggestions. Relies on the cider-nrepl middleware.
 *   We call the given callback with the list of symbols once the REPL server replies.
 */
pinkgorilla.kernel.nrepl.get_completions = (function pinkgorilla$kernel$nrepl$get_completions(symbol,ns,context,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"op","op",-1882987955),"complete",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns,new cljs.core.Keyword(null,"context","context",-830191113),context], null),(function (msg){
var G__27274 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__27271_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__27271_SHARP_,"candidate");
}),cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"completions"));
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__27274) : callback.call(null,G__27274));
}));
});
/**
 * Queries the REPL server for docs for the given symbol. Relies on the cider-nrepl middleware.
 *   Calls back with the documentation text
 */
pinkgorilla.kernel.nrepl.get_completion_doc = (function pinkgorilla$kernel$nrepl$get_completion_doc(symbol,ns,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"complete-doc",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null),(function (msg){
var G__27276 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"completion-doc");
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__27276) : callback.call(null,G__27276));
}));
});
/**
 * resolve a symbol to get its namespace takes the symbol and the namespace that should be used as context.
 *   Relies on the cider-nrepl middleware. Calls back with the symbol and the symbol's namespace
 */
pinkgorilla.kernel.nrepl.resolve_symbol = (function pinkgorilla$kernel$nrepl$resolve_symbol(symbol,ns,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"info",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null),(function (msg){
var G__27277 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"symbol","symbol",-1038572696),cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"name"),new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"ns")], null);
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__27277) : callback.call(null,G__27277));
}));
});
/**
 * processes an incoming message from websocket that comes from nrepl (and has cider enhancements)
 * dispatches events to reagent to update notebook state ui.
 *   
 */
pinkgorilla.kernel.nrepl.process_msg = (function pinkgorilla$kernel$nrepl$process_msg(message){
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"id"));
var out = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"out");
var err = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"err");
var root_ex = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"root-ex");
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"ns");
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"value");
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"status");
var segment_id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluations","evaluations",57802423),id], null));
var cider_cb = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ciders","ciders",-1421942407),id], null));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init5318300759512683746.clj",97,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got message",id,"for segment",segment_id], null);
}),null)),null,1290500564);

if(cljs.core.truth_(segment_id)){
if(cljs.core.truth_(ns)){
var G__27278 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:value-response","evaluator:value-response",-622097925),segment_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942),clojure.walk.keywordize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(JSON.parse(JSON.parse(value))))], null),ns], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27278) : re_frame.core.dispatch.call(null,G__27278));
} else {
if(cljs.core.truth_(out)){
var G__27279 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:console-response","evaluator:console-response",-650807352),segment_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"console-response","console-response",81719661),out], null)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27279) : re_frame.core.dispatch.call(null,G__27279));
} else {
if(cljs.core.truth_(err)){
var error = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error-text","error-text",2021893718),err,new cljs.core.Keyword(null,"segment-id","segment-id",1810133590),segment_id], null));
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op","op",-1882987955),"stacktrace"], null),(function (msg){
var status__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"status");
if(cljs.core.truth_((function (){var and__4174__auto__ = status__$1;
if(cljs.core.truth_(and__4174__auto__)){
return (status__$1.indexOf("done") >= (0));
} else {
return and__4174__auto__;
}
})())){
var G__27280 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:error-response","evaluator:error-response",1375419587),cljs.core.deref(error)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27280) : re_frame.core.dispatch.call(null,G__27280));
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(error,(function (err__$1,ex){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(err__$1,new cljs.core.Keyword(null,"exception","exception",-335277064)))){
return cljs.core.assoc_in(err__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"cause","cause",231901252)], null),new cljs.core.Keyword(null,"exception","exception",-335277064).cljs$core$IFn$_invoke$arity$1(ex));
} else {
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ex,err__$1], 0));
}
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"exception","exception",-335277064),msg], null));
}
}));
} else {
if(cljs.core.truth_(root_ex)){
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init5318300759512683746.clj",139,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got root-ex",root_ex,"for",segment_id], null);
}),null)),null,-25804882);
} else {
if((status.indexOf("done") >= (0))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluations","evaluations",57802423),id], null));

var G__27281 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:done-response","evaluator:done-response",1140676326),segment_id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27281) : re_frame.core.dispatch.call(null,G__27281));
} else {
return null;
}
}
}
}
}
} else {
if(cljs.core.truth_(cider_cb)){
(cider_cb.cljs$core$IFn$_invoke$arity$1 ? cider_cb.cljs$core$IFn$_invoke$arity$1(message) : cider_cb.call(null,message));

if(cljs.core.truth_((function (){var and__4174__auto__ = status;
if(cljs.core.truth_(and__4174__auto__)){
return (status.indexOf("done") >= (0));
} else {
return and__4174__auto__;
}
})())){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ciders","ciders",-1421942407),id], null));
} else {
return null;
}
} else {
return null;
}
}
});
pinkgorilla.kernel.nrepl.set_clj_kernel_status = (function pinkgorilla$kernel$nrepl$set_clj_kernel_status(connected,session_id){
var G__27285 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"kernel-clj-status-set","kernel-clj-status-set",-1158664458),connected,session_id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27285) : re_frame.core.dispatch.call(null,G__27285));
});
pinkgorilla.kernel.nrepl.receive_msgs_BANG_ = (function pinkgorilla$kernel$nrepl$receive_msgs_BANG_(server_ch){
var c__26189__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__26190__auto__ = (function (){var switch__26131__auto__ = (function (state_27373){
var state_val_27374 = (state_27373[(1)]);
if((state_val_27374 === (7))){
var state_27373__$1 = state_27373;
var statearr_27375_27692 = state_27373__$1;
(statearr_27375_27692[(2)] = false);

(statearr_27375_27692[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27374 === (1))){
var state_27373__$1 = state_27373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27373__$1,(2),server_ch);
} else {
if((state_val_27374 === (4))){
var state_27373__$1 = state_27373;
var statearr_27376_27693 = state_27373__$1;
(statearr_27376_27693[(2)] = false);

(statearr_27376_27693[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27374 === (13))){
var inst_27312 = (state_27373[(7)]);
var inst_27366 = ["clj-kernel Fatal Error : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27312)," - Unable to create session. Game over"].join('');
var inst_27367 = pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"danger","danger",-624338030),inst_27366);
var inst_27368 = pinkgorilla.notifications.add_notification(inst_27367);
var inst_27369 = pinkgorilla.kernel.nrepl.set_clj_kernel_status(false,null);
var state_27373__$1 = (function (){var statearr_27377 = state_27373;
(statearr_27377[(8)] = inst_27368);

return statearr_27377;
})();
var statearr_27378_27694 = state_27373__$1;
(statearr_27378_27694[(2)] = inst_27369);

(statearr_27378_27694[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27374 === (6))){
var state_27373__$1 = state_27373;
var statearr_27379_27696 = state_27373__$1;
(statearr_27379_27696[(2)] = true);

(statearr_27379_27696[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27374 === (3))){
var inst_27289 = (state_27373[(9)]);
var inst_27294 = inst_27289.cljs$lang$protocol_mask$partition0$;
var inst_27295 = (inst_27294 & (64));
var inst_27296 = inst_27289.cljs$core$ISeq$;
var inst_27297 = (cljs.core.PROTOCOL_SENTINEL === inst_27296);
var inst_27298 = ((inst_27295) || (inst_27297));
var state_27373__$1 = state_27373;
if(cljs.core.truth_(inst_27298)){
var statearr_27380_27697 = state_27373__$1;
(statearr_27380_27697[(1)] = (6));

} else {
var statearr_27381_27698 = state_27373__$1;
(statearr_27381_27698[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27374 === (12))){
var inst_27311 = (state_27373[(10)]);
var inst_27316 = (state_27373[(11)]);
var inst_27312 = (state_27373[(7)]);
var inst_27310 = (state_27373[(12)]);
var inst_27318 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc,new cljs.core.Keyword(null,"session-id","session-id",-1147060351),inst_27316);
var inst_27319 = pinkgorilla.kernel.nrepl.set_clj_kernel_status(true,inst_27316);
var inst_27362 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_27363 = (function (){var map__27287 = inst_27310;
var msg = inst_27310;
var message = inst_27311;
var error = inst_27312;
var temp__5733__auto__ = inst_27316;
var new_session = inst_27316;
var c__26189__auto____$1 = inst_27362;
return (function (){
var f__26190__auto__ = (function (){var switch__26131__auto__ = (function (state_27360){
var state_val_27361 = (state_27360[(1)]);
if((state_val_27361 === (7))){
var inst_27339 = (state_27360[(2)]);
var state_27360__$1 = state_27360;
if(cljs.core.truth_(inst_27339)){
var statearr_27382_27699 = state_27360__$1;
(statearr_27382_27699[(1)] = (11));

} else {
var statearr_27383_27700 = state_27360__$1;
(statearr_27383_27700[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27361 === (1))){
var state_27360__$1 = state_27360;
var statearr_27384_27701 = state_27360__$1;
(statearr_27384_27701[(2)] = null);

(statearr_27384_27701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27361 === (4))){
var inst_27323 = (state_27360[(7)]);
var inst_27323__$1 = (state_27360[(2)]);
var inst_27325 = (inst_27323__$1 == null);
var inst_27326 = cljs.core.not(inst_27325);
var state_27360__$1 = (function (){var statearr_27385 = state_27360;
(statearr_27385[(7)] = inst_27323__$1);

return statearr_27385;
})();
if(inst_27326){
var statearr_27386_27702 = state_27360__$1;
(statearr_27386_27702[(1)] = (5));

} else {
var statearr_27387_27703 = state_27360__$1;
(statearr_27387_27703[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27361 === (15))){
var inst_27346 = (state_27360[(8)]);
var inst_27351 = ["clj-kernel Fatal Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27346)," - Game over"].join('');
var inst_27352 = pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"danger","danger",-624338030),inst_27351);
var inst_27353 = pinkgorilla.notifications.add_notification(inst_27352);
var inst_27354 = pinkgorilla.kernel.nrepl.set_clj_kernel_status(false,null);
var state_27360__$1 = (function (){var statearr_27392 = state_27360;
(statearr_27392[(9)] = inst_27353);

return statearr_27392;
})();
var statearr_27393_27705 = state_27360__$1;
(statearr_27393_27705[(2)] = inst_27354);

(statearr_27393_27705[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27361 === (13))){
var inst_27345 = (state_27360[(10)]);
var inst_27344 = (state_27360[(2)]);
var inst_27345__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27344,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_27346 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27344,new cljs.core.Keyword(null,"error","error",-978969032));
var state_27360__$1 = (function (){var statearr_27405 = state_27360;
(statearr_27405[(8)] = inst_27346);

(statearr_27405[(10)] = inst_27345__$1);

return statearr_27405;
})();
if(cljs.core.truth_(inst_27345__$1)){
var statearr_27408_27707 = state_27360__$1;
(statearr_27408_27707[(1)] = (14));

} else {
var statearr_27414_27708 = state_27360__$1;
(statearr_27414_27708[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27361 === (6))){
var state_27360__$1 = state_27360;
var statearr_27415_27709 = state_27360__$1;
(statearr_27415_27709[(2)] = false);

(statearr_27415_27709[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27361 === (3))){
var inst_27358 = (state_27360[(2)]);
var state_27360__$1 = state_27360;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27360__$1,inst_27358);
} else {
if((state_val_27361 === (12))){
var inst_27323 = (state_27360[(7)]);
var state_27360__$1 = state_27360;
var statearr_27418_27710 = state_27360__$1;
(statearr_27418_27710[(2)] = inst_27323);

(statearr_27418_27710[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27361 === (2))){
var state_27360__$1 = state_27360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27360__$1,(4),server_ch);
} else {
if((state_val_27361 === (11))){
var inst_27323 = (state_27360[(7)]);
var inst_27341 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_27323);
var state_27360__$1 = state_27360;
var statearr_27423_27712 = state_27360__$1;
(statearr_27423_27712[(2)] = inst_27341);

(statearr_27423_27712[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27361 === (9))){
var state_27360__$1 = state_27360;
var statearr_27428_27713 = state_27360__$1;
(statearr_27428_27713[(2)] = false);

(statearr_27428_27713[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27361 === (5))){
var inst_27323 = (state_27360[(7)]);
var inst_27328 = inst_27323.cljs$lang$protocol_mask$partition0$;
var inst_27329 = (inst_27328 & (64));
var inst_27330 = inst_27323.cljs$core$ISeq$;
var inst_27331 = (cljs.core.PROTOCOL_SENTINEL === inst_27330);
var inst_27332 = ((inst_27329) || (inst_27331));
var state_27360__$1 = state_27360;
if(cljs.core.truth_(inst_27332)){
var statearr_27429_27715 = state_27360__$1;
(statearr_27429_27715[(1)] = (8));

} else {
var statearr_27431_27716 = state_27360__$1;
(statearr_27431_27716[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27361 === (14))){
var inst_27345 = (state_27360[(10)]);
var inst_27348 = pinkgorilla.kernel.nrepl.process_msg(inst_27345);
var state_27360__$1 = (function (){var statearr_27433 = state_27360;
(statearr_27433[(11)] = inst_27348);

return statearr_27433;
})();
var statearr_27434_27718 = state_27360__$1;
(statearr_27434_27718[(2)] = null);

(statearr_27434_27718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27361 === (16))){
var inst_27356 = (state_27360[(2)]);
var state_27360__$1 = state_27360;
var statearr_27442_27719 = state_27360__$1;
(statearr_27442_27719[(2)] = inst_27356);

(statearr_27442_27719[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27361 === (10))){
var inst_27336 = (state_27360[(2)]);
var state_27360__$1 = state_27360;
var statearr_27443_27722 = state_27360__$1;
(statearr_27443_27722[(2)] = inst_27336);

(statearr_27443_27722[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27361 === (8))){
var state_27360__$1 = state_27360;
var statearr_27444_27724 = state_27360__$1;
(statearr_27444_27724[(2)] = true);

(statearr_27444_27724[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto__ = null;
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto____0 = (function (){
var statearr_27447 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27447[(0)] = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto__);

(statearr_27447[(1)] = (1));

return statearr_27447;
});
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto____1 = (function (state_27360){
while(true){
var ret_value__26133__auto__ = (function (){try{while(true){
var result__26134__auto__ = switch__26131__auto__(state_27360);
if(cljs.core.keyword_identical_QMARK_(result__26134__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26134__auto__;
}
break;
}
}catch (e27448){if((e27448 instanceof Object)){
var ex__26135__auto__ = e27448;
var statearr_27449_27728 = state_27360;
(statearr_27449_27728[(5)] = ex__26135__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27360);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27448;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26133__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27729 = state_27360;
state_27360 = G__27729;
continue;
} else {
return ret_value__26133__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto__ = function(state_27360){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto____1.call(this,state_27360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto____0;
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto____1;
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto__;
})()
})();
var state__26191__auto__ = (function (){var statearr_27454 = (f__26190__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26190__auto__.cljs$core$IFn$_invoke$arity$0() : f__26190__auto__.call(null));
(statearr_27454[(6)] = c__26189__auto____$1);

return statearr_27454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26191__auto__);
});
})();
var inst_27364 = cljs.core.async.impl.dispatch.run(inst_27363);
var state_27373__$1 = (function (){var statearr_27455 = state_27373;
(statearr_27455[(13)] = inst_27318);

(statearr_27455[(14)] = inst_27319);

(statearr_27455[(15)] = inst_27364);

return statearr_27455;
})();
var statearr_27456_27730 = state_27373__$1;
(statearr_27456_27730[(2)] = inst_27362);

(statearr_27456_27730[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27374 === (2))){
var inst_27289 = (state_27373[(9)]);
var inst_27289__$1 = (state_27373[(2)]);
var inst_27291 = (inst_27289__$1 == null);
var inst_27292 = cljs.core.not(inst_27291);
var state_27373__$1 = (function (){var statearr_27457 = state_27373;
(statearr_27457[(9)] = inst_27289__$1);

return statearr_27457;
})();
if(inst_27292){
var statearr_27458_27731 = state_27373__$1;
(statearr_27458_27731[(1)] = (3));

} else {
var statearr_27460_27732 = state_27373__$1;
(statearr_27460_27732[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27374 === (11))){
var inst_27311 = (state_27373[(10)]);
var inst_27316 = (state_27373[(11)]);
var inst_27312 = (state_27373[(7)]);
var inst_27310 = (state_27373[(12)]);
var inst_27310__$1 = (state_27373[(2)]);
var inst_27311__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27310__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_27312__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27310__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var inst_27313 = (function (){var map__27287 = inst_27310__$1;
var msg = inst_27310__$1;
var message = inst_27311__$1;
var error = inst_27312__$1;
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got initial message ",message], null);
});
})();
var inst_27314 = (new cljs.core.Delay(inst_27313,null));
var inst_27315 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init5318300759512683746.clj",163,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_27314,null,622168481);
var inst_27316__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27311__$1,"new-session");
var state_27373__$1 = (function (){var statearr_27461 = state_27373;
(statearr_27461[(10)] = inst_27311__$1);

(statearr_27461[(11)] = inst_27316__$1);

(statearr_27461[(16)] = inst_27315);

(statearr_27461[(7)] = inst_27312__$1);

(statearr_27461[(12)] = inst_27310__$1);

return statearr_27461;
})();
if(cljs.core.truth_(inst_27316__$1)){
var statearr_27465_27733 = state_27373__$1;
(statearr_27465_27733[(1)] = (12));

} else {
var statearr_27466_27734 = state_27373__$1;
(statearr_27466_27734[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27374 === (9))){
var inst_27289 = (state_27373[(9)]);
var inst_27307 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_27289);
var state_27373__$1 = state_27373;
var statearr_27471_27735 = state_27373__$1;
(statearr_27471_27735[(2)] = inst_27307);

(statearr_27471_27735[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27374 === (5))){
var inst_27305 = (state_27373[(2)]);
var state_27373__$1 = state_27373;
if(cljs.core.truth_(inst_27305)){
var statearr_27476_27736 = state_27373__$1;
(statearr_27476_27736[(1)] = (9));

} else {
var statearr_27477_27737 = state_27373__$1;
(statearr_27477_27737[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27374 === (14))){
var inst_27371 = (state_27373[(2)]);
var state_27373__$1 = state_27373;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27373__$1,inst_27371);
} else {
if((state_val_27374 === (10))){
var inst_27289 = (state_27373[(9)]);
var state_27373__$1 = state_27373;
var statearr_27478_27738 = state_27373__$1;
(statearr_27478_27738[(2)] = inst_27289);

(statearr_27478_27738[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27374 === (8))){
var inst_27302 = (state_27373[(2)]);
var state_27373__$1 = state_27373;
var statearr_27479_27739 = state_27373__$1;
(statearr_27479_27739[(2)] = inst_27302);

(statearr_27479_27739[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto__ = null;
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto____0 = (function (){
var statearr_27480 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27480[(0)] = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto__);

(statearr_27480[(1)] = (1));

return statearr_27480;
});
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto____1 = (function (state_27373){
while(true){
var ret_value__26133__auto__ = (function (){try{while(true){
var result__26134__auto__ = switch__26131__auto__(state_27373);
if(cljs.core.keyword_identical_QMARK_(result__26134__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26134__auto__;
}
break;
}
}catch (e27481){if((e27481 instanceof Object)){
var ex__26135__auto__ = e27481;
var statearr_27482_27740 = state_27373;
(statearr_27482_27740[(5)] = ex__26135__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27373);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27481;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26133__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27741 = state_27373;
state_27373 = G__27741;
continue;
} else {
return ret_value__26133__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto__ = function(state_27373){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto____1.call(this,state_27373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto____0;
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto____1;
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__26132__auto__;
})()
})();
var state__26191__auto__ = (function (){var statearr_27483 = (f__26190__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26190__auto__.cljs$core$IFn$_invoke$arity$0() : f__26190__auto__.call(null));
(statearr_27483[(6)] = c__26189__auto__);

return statearr_27483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26191__auto__);
}));

return c__26189__auto__;
});
pinkgorilla.kernel.nrepl.send_msgs_BANG_ = (function pinkgorilla$kernel$nrepl$send_msgs_BANG_(new_msg_ch,server_ch){
var c__26189__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__26190__auto__ = (function (){var switch__26131__auto__ = (function (state_27497){
var state_val_27498 = (state_27497[(1)]);
if((state_val_27498 === (1))){
var state_27497__$1 = state_27497;
var statearr_27499_27742 = state_27497__$1;
(statearr_27499_27742[(2)] = null);

(statearr_27499_27742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27498 === (2))){
var state_27497__$1 = state_27497;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27497__$1,(4),new_msg_ch);
} else {
if((state_val_27498 === (3))){
var inst_27495 = (state_27497[(2)]);
var state_27497__$1 = state_27497;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27497__$1,inst_27495);
} else {
if((state_val_27498 === (4))){
var inst_27486 = (state_27497[(7)]);
var inst_27486__$1 = (state_27497[(2)]);
var state_27497__$1 = (function (){var statearr_27500 = state_27497;
(statearr_27500[(7)] = inst_27486__$1);

return statearr_27500;
})();
if(cljs.core.truth_(inst_27486__$1)){
var statearr_27501_27750 = state_27497__$1;
(statearr_27501_27750[(1)] = (5));

} else {
var statearr_27502_27751 = state_27497__$1;
(statearr_27502_27751[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27498 === (5))){
var inst_27486 = (state_27497[(7)]);
var state_27497__$1 = state_27497;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27497__$1,(8),server_ch,inst_27486);
} else {
if((state_val_27498 === (6))){
var state_27497__$1 = state_27497;
var statearr_27503_27753 = state_27497__$1;
(statearr_27503_27753[(2)] = null);

(statearr_27503_27753[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27498 === (7))){
var inst_27493 = (state_27497[(2)]);
var state_27497__$1 = state_27497;
var statearr_27508_27754 = state_27497__$1;
(statearr_27508_27754[(2)] = inst_27493);

(statearr_27508_27754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27498 === (8))){
var inst_27489 = (state_27497[(2)]);
var state_27497__$1 = (function (){var statearr_27509 = state_27497;
(statearr_27509[(8)] = inst_27489);

return statearr_27509;
})();
var statearr_27510_27755 = state_27497__$1;
(statearr_27510_27755[(2)] = null);

(statearr_27510_27755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__26132__auto__ = null;
var pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__26132__auto____0 = (function (){
var statearr_27511 = [null,null,null,null,null,null,null,null,null];
(statearr_27511[(0)] = pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__26132__auto__);

(statearr_27511[(1)] = (1));

return statearr_27511;
});
var pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__26132__auto____1 = (function (state_27497){
while(true){
var ret_value__26133__auto__ = (function (){try{while(true){
var result__26134__auto__ = switch__26131__auto__(state_27497);
if(cljs.core.keyword_identical_QMARK_(result__26134__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26134__auto__;
}
break;
}
}catch (e27512){if((e27512 instanceof Object)){
var ex__26135__auto__ = e27512;
var statearr_27513_27756 = state_27497;
(statearr_27513_27756[(5)] = ex__26135__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27497);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27512;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26133__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27764 = state_27497;
state_27497 = G__27764;
continue;
} else {
return ret_value__26133__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__26132__auto__ = function(state_27497){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__26132__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__26132__auto____1.call(this,state_27497);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__26132__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__26132__auto____0;
pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__26132__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__26132__auto____1;
return pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__26132__auto__;
})()
})();
var state__26191__auto__ = (function (){var statearr_27515 = (f__26190__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26190__auto__.cljs$core$IFn$_invoke$arity$0() : f__26190__auto__.call(null));
(statearr_27515[(6)] = c__26189__auto__);

return statearr_27515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26191__auto__);
}));

return c__26189__auto__;
});
pinkgorilla.kernel.nrepl.init_BANG_ = (function pinkgorilla$kernel$nrepl$init_BANG_(path,app_url){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init5318300759512683746.clj",189,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["clj kernel starting at",path], null);
}),null)),null,943810330);

var c__26189__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__26190__auto__ = (function (){var switch__26131__auto__ = (function (state_27563){
var state_val_27564 = (state_27563[(1)]);
if((state_val_27564 === (7))){
var state_27563__$1 = state_27563;
var statearr_27569_27774 = state_27563__$1;
(statearr_27569_27774[(2)] = false);

(statearr_27569_27774[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27564 === (1))){
var inst_27517 = pinkgorilla.util.ws_origin(path,app_url);
var inst_27518 = [new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_27519 = [new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_27520 = cljs.core.PersistentHashMap.fromArrays(inst_27518,inst_27519);
var inst_27521 = chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(inst_27517,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27520], 0));
var state_27563__$1 = state_27563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27563__$1,(2),inst_27521);
} else {
if((state_val_27564 === (4))){
var state_27563__$1 = state_27563;
var statearr_27570_27779 = state_27563__$1;
(statearr_27570_27779[(2)] = false);

(statearr_27570_27779[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27564 === (15))){
var inst_27561 = (state_27563[(2)]);
var state_27563__$1 = state_27563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27563__$1,inst_27561);
} else {
if((state_val_27564 === (13))){
var state_27563__$1 = state_27563;
var statearr_27571_27781 = state_27563__$1;
(statearr_27571_27781[(2)] = null);

(statearr_27571_27781[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27564 === (6))){
var state_27563__$1 = state_27563;
var statearr_27572_27783 = state_27563__$1;
(statearr_27572_27783[(2)] = true);

(statearr_27572_27783[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27564 === (3))){
var inst_27523 = (state_27563[(7)]);
var inst_27528 = inst_27523.cljs$lang$protocol_mask$partition0$;
var inst_27529 = (inst_27528 & (64));
var inst_27530 = inst_27523.cljs$core$ISeq$;
var inst_27531 = (cljs.core.PROTOCOL_SENTINEL === inst_27530);
var inst_27532 = ((inst_27529) || (inst_27531));
var state_27563__$1 = state_27563;
if(cljs.core.truth_(inst_27532)){
var statearr_27573_27789 = state_27563__$1;
(statearr_27573_27789[(1)] = (6));

} else {
var statearr_27574_27791 = state_27563__$1;
(statearr_27574_27791[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27564 === (12))){
var inst_27546 = (state_27563[(8)]);
var inst_27548 = ["clj-kernel ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27546)].join('');
var inst_27549 = pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"danger","danger",-624338030),inst_27548);
var inst_27550 = pinkgorilla.notifications.add_notification(inst_27549);
var state_27563__$1 = state_27563;
var statearr_27575_27797 = state_27563__$1;
(statearr_27575_27797[(2)] = inst_27550);

(statearr_27575_27797[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27564 === (2))){
var inst_27523 = (state_27563[(7)]);
var inst_27523__$1 = (state_27563[(2)]);
var inst_27525 = (inst_27523__$1 == null);
var inst_27526 = cljs.core.not(inst_27525);
var state_27563__$1 = (function (){var statearr_27577 = state_27563;
(statearr_27577[(7)] = inst_27523__$1);

return statearr_27577;
})();
if(inst_27526){
var statearr_27578_27802 = state_27563__$1;
(statearr_27578_27802[(1)] = (3));

} else {
var statearr_27579_27804 = state_27563__$1;
(statearr_27579_27804[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27564 === (11))){
var inst_27546 = (state_27563[(8)]);
var inst_27544 = (state_27563[(2)]);
var inst_27545 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27544,new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174));
var inst_27546__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27544,new cljs.core.Keyword(null,"error","error",-978969032));
var state_27563__$1 = (function (){var statearr_27580 = state_27563;
(statearr_27580[(8)] = inst_27546__$1);

(statearr_27580[(9)] = inst_27545);

return statearr_27580;
})();
if(cljs.core.truth_(inst_27546__$1)){
var statearr_27581_27813 = state_27563__$1;
(statearr_27581_27813[(1)] = (12));

} else {
var statearr_27582_27814 = state_27563__$1;
(statearr_27582_27814[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27564 === (9))){
var inst_27523 = (state_27563[(7)]);
var inst_27541 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_27523);
var state_27563__$1 = state_27563;
var statearr_27583_27820 = state_27563__$1;
(statearr_27583_27820[(2)] = inst_27541);

(statearr_27583_27820[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27564 === (5))){
var inst_27539 = (state_27563[(2)]);
var state_27563__$1 = state_27563;
if(cljs.core.truth_(inst_27539)){
var statearr_27586_27821 = state_27563__$1;
(statearr_27586_27821[(1)] = (9));

} else {
var statearr_27587_27822 = state_27563__$1;
(statearr_27587_27822[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27564 === (14))){
var inst_27545 = (state_27563[(9)]);
var inst_27553 = (state_27563[(2)]);
var inst_27556 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_27557 = pinkgorilla.kernel.nrepl.send_msgs_BANG_(inst_27556,inst_27545);
var inst_27558 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc,new cljs.core.Keyword(null,"channel","channel",734187692),inst_27556);
var inst_27559 = pinkgorilla.kernel.nrepl.receive_msgs_BANG_(inst_27545);
var state_27563__$1 = (function (){var statearr_27591 = state_27563;
(statearr_27591[(10)] = inst_27558);

(statearr_27591[(11)] = inst_27559);

(statearr_27591[(12)] = inst_27557);

(statearr_27591[(13)] = inst_27553);

return statearr_27591;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27563__$1,(15),inst_27556,({"op": "clone"}));
} else {
if((state_val_27564 === (10))){
var inst_27523 = (state_27563[(7)]);
var state_27563__$1 = state_27563;
var statearr_27592_27823 = state_27563__$1;
(statearr_27592_27823[(2)] = inst_27523);

(statearr_27592_27823[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27564 === (8))){
var inst_27536 = (state_27563[(2)]);
var state_27563__$1 = state_27563;
var statearr_27593_27824 = state_27563__$1;
(statearr_27593_27824[(2)] = inst_27536);

(statearr_27593_27824[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__26132__auto__ = null;
var pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__26132__auto____0 = (function (){
var statearr_27599 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27599[(0)] = pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__26132__auto__);

(statearr_27599[(1)] = (1));

return statearr_27599;
});
var pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__26132__auto____1 = (function (state_27563){
while(true){
var ret_value__26133__auto__ = (function (){try{while(true){
var result__26134__auto__ = switch__26131__auto__(state_27563);
if(cljs.core.keyword_identical_QMARK_(result__26134__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26134__auto__;
}
break;
}
}catch (e27600){if((e27600 instanceof Object)){
var ex__26135__auto__ = e27600;
var statearr_27601_27828 = state_27563;
(statearr_27601_27828[(5)] = ex__26135__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27563);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27600;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26133__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27829 = state_27563;
state_27563 = G__27829;
continue;
} else {
return ret_value__26133__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__26132__auto__ = function(state_27563){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__26132__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__26132__auto____1.call(this,state_27563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__26132__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__26132__auto____0;
pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__26132__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__26132__auto____1;
return pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__26132__auto__;
})()
})();
var state__26191__auto__ = (function (){var statearr_27603 = (f__26190__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26190__auto__.cljs$core$IFn$_invoke$arity$0() : f__26190__auto__.call(null));
(statearr_27603[(6)] = c__26189__auto__);

return statearr_27603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26191__auto__);
}));

return c__26189__auto__;
});
pinkgorilla.kernel.nrepl.clj_eval = (function pinkgorilla$kernel$nrepl$clj_eval(snippet,callback){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["clj-eval: ",snippet], 0));

console.log(["clj-eval: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(snippet)].join(''));

return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),"eval",new cljs.core.Keyword(null,"code","code",1586293142),snippet], null),(function (message){
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"ns");
var _ = console.log(["ns: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join(''));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"value");
var data = clojure.walk.keywordize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(JSON.parse(JSON.parse(value))));
if(cljs.core.truth_(ns)){
var v2 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(data));
console.log("clj-eval response: ",data," type: ",cljs.core.type(value));

console.log("clj-eval result: ",v2," type: ",cljs.core.type(v2));

return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(v2) : callback.call(null,v2));
} else {
return null;
}
}));
});
pinkgorilla.kernel.nrepl.clj_eval_sync = (function pinkgorilla$kernel$nrepl$clj_eval_sync(result_atom,snippet){
var result_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__26189__auto___27831 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__26190__auto__ = (function (){var switch__26131__auto__ = (function (state_27612){
var state_val_27613 = (state_27612[(1)]);
if((state_val_27613 === (1))){
var inst_27609 = (function (){return (function (result){
console.log(["async evalued result: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(result)].join(''));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_chan,result);
});
})();
var inst_27610 = pinkgorilla.kernel.nrepl.clj_eval(snippet,inst_27609);
var state_27612__$1 = state_27612;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27612__$1,inst_27610);
} else {
return null;
}
});
return (function() {
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto__ = null;
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto____0 = (function (){
var statearr_27616 = [null,null,null,null,null,null,null];
(statearr_27616[(0)] = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto__);

(statearr_27616[(1)] = (1));

return statearr_27616;
});
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto____1 = (function (state_27612){
while(true){
var ret_value__26133__auto__ = (function (){try{while(true){
var result__26134__auto__ = switch__26131__auto__(state_27612);
if(cljs.core.keyword_identical_QMARK_(result__26134__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26134__auto__;
}
break;
}
}catch (e27617){if((e27617 instanceof Object)){
var ex__26135__auto__ = e27617;
var statearr_27618_27834 = state_27612;
(statearr_27618_27834[(5)] = ex__26135__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27612);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27617;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26133__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27835 = state_27612;
state_27612 = G__27835;
continue;
} else {
return ret_value__26133__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto__ = function(state_27612){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto____1.call(this,state_27612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto____0;
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto____1;
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto__;
})()
})();
var state__26191__auto__ = (function (){var statearr_27619 = (f__26190__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26190__auto__.cljs$core$IFn$_invoke$arity$0() : f__26190__auto__.call(null));
(statearr_27619[(6)] = c__26189__auto___27831);

return statearr_27619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26191__auto__);
}));


var c__26189__auto___27837 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__26190__auto__ = (function (){var switch__26131__auto__ = (function (state_27627){
var state_val_27628 = (state_27627[(1)]);
if((state_val_27628 === (1))){
var state_27627__$1 = state_27627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27627__$1,(2),result_chan);
} else {
if((state_val_27628 === (2))){
var inst_27624 = (state_27627[(2)]);
var inst_27625 = cljs.core.reset_BANG_(result_atom,inst_27624);
var state_27627__$1 = state_27627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27627__$1,inst_27625);
} else {
return null;
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto__ = null;
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto____0 = (function (){
var statearr_27639 = [null,null,null,null,null,null,null];
(statearr_27639[(0)] = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto__);

(statearr_27639[(1)] = (1));

return statearr_27639;
});
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto____1 = (function (state_27627){
while(true){
var ret_value__26133__auto__ = (function (){try{while(true){
var result__26134__auto__ = switch__26131__auto__(state_27627);
if(cljs.core.keyword_identical_QMARK_(result__26134__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26134__auto__;
}
break;
}
}catch (e27640){if((e27640 instanceof Object)){
var ex__26135__auto__ = e27640;
var statearr_27641_27839 = state_27627;
(statearr_27641_27839[(5)] = ex__26135__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27627);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27640;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26133__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27844 = state_27627;
state_27627 = G__27844;
continue;
} else {
return ret_value__26133__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto__ = function(state_27627){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto____1.call(this,state_27627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto____0;
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto____1;
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__26132__auto__;
})()
})();
var state__26191__auto__ = (function (){var statearr_27646 = (f__26190__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26190__auto__.cljs$core$IFn$_invoke$arity$0() : f__26190__auto__.call(null));
(statearr_27646[(6)] = c__26189__auto___27837);

return statearr_27646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26191__auto__);
}));


return result_atom;
});
pinkgorilla.kernel.nrepl.clj = (function pinkgorilla$kernel$nrepl$clj(var_args){
var args__4795__auto__ = [];
var len__4789__auto___27852 = arguments.length;
var i__4790__auto___27856 = (0);
while(true){
if((i__4790__auto___27856 < len__4789__auto___27852)){
args__4795__auto__.push((arguments[i__4790__auto___27856]));

var G__27857 = (i__4790__auto___27856 + (1));
i__4790__auto___27856 = G__27857;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return pinkgorilla.kernel.nrepl.clj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(pinkgorilla.kernel.nrepl.clj.cljs$core$IFn$_invoke$arity$variadic = (function (result_atom,function_as_string,params){
var _ = console.log("params: ",params);
var expr = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(",function_as_string], null),params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [")"], null)], 0));
var str_eval = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",expr);
var ___$1 = console.log(["Calling CLJ: ",str_eval].join(''));
return pinkgorilla.kernel.nrepl.clj_eval_sync(result_atom,str_eval);
}));

(pinkgorilla.kernel.nrepl.clj.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.kernel.nrepl.clj.cljs$lang$applyTo = (function (seq27649){
var G__27652 = cljs.core.first(seq27649);
var seq27649__$1 = cljs.core.next(seq27649);
var G__27653 = cljs.core.first(seq27649__$1);
var seq27649__$2 = cljs.core.next(seq27649__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27652,G__27653,seq27649__$2);
}));


//# sourceMappingURL=pinkgorilla.kernel.nrepl.js.map
