goog.provide('pinkgorilla.notebook.newnb');
goog.require('cljs.core');
goog.require('pinkgorilla.notebook.core');
pinkgorilla.notebook.newnb.hip_adjective = cljs.core.PersistentVector.fromArray(["affectionate","amiable","arrogant","balmy","barren","benevolent","billowing","blessed","breezy","calm","celestial","charming","combative","composed","condemned","divine","dry","energized","enigmatic","exuberant","flowing","fluffy","fluttering","frightened","fuscia","gentle","greasy","grieving","harmonious","hollow","homeless","icy","indigo","inquisitive","itchy","joyful","jubilant","juicy","khaki","limitless","lush","mellow","merciful","merry","mirthful","moonlit","mysterious","natural","outrageous","pacific","parched","placid","pleasant","poised","purring","radioactive","resilient","scenic","screeching","sensitive","serene","snowy","solitary","spacial","squealing","stark","stunning","sunset","talented","tasteless","teal","thoughtless","thriving","tranquil","tropical","undisturbed","unsightly","unwavering","uplifting","voiceless","wandering","warm","wealthy","whispering","withered","wooden","zealous"], true);
pinkgorilla.notebook.newnb.hip_nouns = cljs.core.PersistentVector.fromArray(["abyss","atoll","aurora","autumn","badlands","beach","briars","brook","canopy","canyon","cavern","chasm","cliff","cove","crater","creek","darkness","dawn","desert","dew","dove","drylands","dusk","farm","fern","firefly","flowers","fog","foliage","forest","galaxy","garden","geyser","grove","hurricane","iceberg","lagoon","lake","leaves","marsh","meadow","mist","moss","mountain","oasis","ocean","peak","pebble","pine","plateau","pond","reef","reserve","resonance","sanctuary","sands","shelter","silence","smokescreen","snowflake","spring","storm","stream","summer","summit","sunrise","sunset","sunshine","surf","swamp","temple","thorns","tsunami","tundra","valley","volcano","waterfall","willow","winds","winter"], true);
pinkgorilla.notebook.newnb.floor = (function pinkgorilla$notebook$newnb$floor(nr){
return Math.floor(nr);
});
pinkgorilla.notebook.newnb.make_hip_nsname = (function pinkgorilla$notebook$newnb$make_hip_nsname(){
var adj_index = pinkgorilla.notebook.newnb.floor((cljs.core.count(pinkgorilla.notebook.newnb.hip_adjective) * cljs.core.rand.cljs$core$IFn$_invoke$arity$0()));
var noun_index = pinkgorilla.notebook.newnb.floor((cljs.core.count(pinkgorilla.notebook.newnb.hip_nouns) * cljs.core.rand.cljs$core$IFn$_invoke$arity$0()));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(pinkgorilla.notebook.newnb.hip_adjective,adj_index)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(pinkgorilla.notebook.newnb.hip_nouns,noun_index))].join('');
});
/**
 * A pure function that creates a new worksheet in the browser.
 *   All db functions used are pure functions!
 */
pinkgorilla.notebook.newnb.create_new_worksheet = (function pinkgorilla$notebook$newnb$create_new_worksheet(){
var worksheet = pinkgorilla.notebook.core.empty_notebook();
var markdown_howto = pinkgorilla.notebook.core.create_free_segment(["# PinkGorilla \n\n","Shift + enter evaluates code. ","Hit CTRL+g twice in quick succession or click the menu icon (upper-right corner) for more commands.\n\n","It's a good habit to run each worksheet in its own namespace. We created a random namespace for you; you can keep using it."].join(''));
var code_dependencies = pinkgorilla.notebook.core.create_code_segment(["; Automatically Download Dependencies (if they are not installed already) \n ","(use '[pinkgorilla.helper]) \n ","(pinkgorilla.helper/add-dependencies '[pinkgorilla.ui.gorilla-plot \"0.8.6\"])"].join(''));
var code_namespace = pinkgorilla.notebook.core.create_code_segment(["; Define Namespace for your notebook and require namespaces \n","(ns ",pinkgorilla.notebook.newnb.make_hip_nsname(),"  \n","  (:require \n","     [pinkgorilla.ui.hiccup :refer [html!]] \n","     [pinkgorilla.ui.vega :refer [vega!]] \n","     [pinkgorilla.ui.gorilla-plot.core :refer [list-plot bar-chart compose histogram plot]])) \n"].join(''));
var code_html = pinkgorilla.notebook.core.create_code_segment(["(html! \n","  [:div \n","    [:h4 \"Hiccup Markup\"] \n","    [:div {:style \"color:green;font-weight:bold;background-color:pink\"} \"World!\" \n","    [:ol \n","       [:li \"The Pinkie\"] \n","       [:li \"The Pinkie and the Brain\"]  \n","       [:li \"What will we be doing today?\"]]  \n","    [:img {:height 100 :width 100 :src \"https://images-na.ssl-images-amazon.com/images/I/61LeuO%2Bj0xL._SL1500_.jpg\"}]]])\n            "].join(''));
var code_plot = pinkgorilla.notebook.core.create_code_segment(" (list-plot [5 6 7 3 9 20] ) \n");
var code_vega = pinkgorilla.notebook.core.create_code_segment(" (vega! \"https://raw.githubusercontent.com/vega/vega/master/docs/examples/bar-chart.vg.json\" ) \n");
return pinkgorilla.notebook.core.insert_segment_at(pinkgorilla.notebook.core.insert_segment_at(pinkgorilla.notebook.core.insert_segment_at(pinkgorilla.notebook.core.insert_segment_at(pinkgorilla.notebook.core.insert_segment_at(pinkgorilla.notebook.core.insert_segment_at(worksheet,(0),markdown_howto),(1),code_dependencies),(2),code_namespace),(3),code_html),(4),code_plot),(5),code_vega);
});

//# sourceMappingURL=pinkgorilla.notebook.newnb.js.map
