goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});
/**
 * @define {boolean}
 */
re_frame.trace.trace_enabled_QMARK_ = goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/Day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__9584){
var map__9585 = p__9584;
var map__9585__$1 = (((((!((map__9585 == null))))?(((((map__9585.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9585.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9585):map__9585);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9585__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9585__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9585__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9585__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id(),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__4185__auto__ = child_of;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__9593_9638 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__9594_9639 = null;
var count__9595_9640 = (0);
var i__9596_9641 = (0);
while(true){
if((i__9596_9641 < count__9595_9640)){
var vec__9614_9642 = chunk__9594_9639.cljs$core$IIndexed$_nth$arity$2(null,i__9596_9641);
var k_9643 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9614_9642,(0),null);
var cb_9644 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9614_9642,(1),null);
try{var G__9618_9646 = cljs.core.deref(re_frame.trace.traces);
(cb_9644.cljs$core$IFn$_invoke$arity$1 ? cb_9644.cljs$core$IFn$_invoke$arity$1(G__9618_9646) : cb_9644.call(null,G__9618_9646));
}catch (e9617){var e_9647 = e9617;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_9643,"while storing",cljs.core.deref(re_frame.trace.traces),e_9647], 0));
}

var G__9648 = seq__9593_9638;
var G__9649 = chunk__9594_9639;
var G__9650 = count__9595_9640;
var G__9651 = (i__9596_9641 + (1));
seq__9593_9638 = G__9648;
chunk__9594_9639 = G__9649;
count__9595_9640 = G__9650;
i__9596_9641 = G__9651;
continue;
} else {
var temp__5735__auto___9654 = cljs.core.seq(seq__9593_9638);
if(temp__5735__auto___9654){
var seq__9593_9656__$1 = temp__5735__auto___9654;
if(cljs.core.chunked_seq_QMARK_(seq__9593_9656__$1)){
var c__4609__auto___9657 = cljs.core.chunk_first(seq__9593_9656__$1);
var G__9658 = cljs.core.chunk_rest(seq__9593_9656__$1);
var G__9659 = c__4609__auto___9657;
var G__9660 = cljs.core.count(c__4609__auto___9657);
var G__9661 = (0);
seq__9593_9638 = G__9658;
chunk__9594_9639 = G__9659;
count__9595_9640 = G__9660;
i__9596_9641 = G__9661;
continue;
} else {
var vec__9620_9662 = cljs.core.first(seq__9593_9656__$1);
var k_9663 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9620_9662,(0),null);
var cb_9664 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9620_9662,(1),null);
try{var G__9627_9665 = cljs.core.deref(re_frame.trace.traces);
(cb_9664.cljs$core$IFn$_invoke$arity$1 ? cb_9664.cljs$core$IFn$_invoke$arity$1(G__9627_9665) : cb_9664.call(null,G__9627_9665));
}catch (e9625){var e_9666 = e9625;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_9663,"while storing",cljs.core.deref(re_frame.trace.traces),e_9666], 0));
}

var G__9667 = cljs.core.next(seq__9593_9656__$1);
var G__9668 = null;
var G__9669 = (0);
var G__9670 = (0);
seq__9593_9638 = G__9667;
chunk__9594_9639 = G__9668;
count__9595_9640 = G__9669;
i__9596_9641 = G__9670;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=re_frame.trace.js.map
