goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__44728){
var vec__44729 = p__44728;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44729,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44729,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__44734 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44734,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44734,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44734,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44734,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44734,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__44739 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44739,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44739,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44739,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44739,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44739,(4),null);
var vec__44742 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44742,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44742,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44742,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44742,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44742,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__44745 = segmap;
var map__44745__$1 = (((((!((map__44745 == null))))?(((((map__44745.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44745.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44745):map__44745);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44745__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44745__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44745__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44745__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44745__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__44749 = arguments.length;
switch (G__44749) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44764 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45831 = cljs.core.next(segs__$1);
var G__45832 = nrelseg;
var G__45833 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45831;
relseg__$1 = G__45832;
result__$1 = G__45833;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44764,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44764,(1),null);
var G__45835 = (gline + (1));
var G__45836 = cljs.core.next(lines__$1);
var G__45837 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45838 = result__$1;
gline = G__45835;
lines__$1 = G__45836;
relseg = G__45837;
result = G__45838;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__44776 = segmap;
var map__44776__$1 = (((((!((map__44776 == null))))?(((((map__44776.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44776.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44776):map__44776);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44776__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44776__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44776__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44776__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44776__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__44771_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__44771_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__44788 = arguments.length;
switch (G__44788) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44807 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45851 = cljs.core.next(segs__$1);
var G__45852 = nrelseg;
var G__45853 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45851;
relseg__$1 = G__45852;
result__$1 = G__45853;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44807,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44807,(1),null);
var G__45854 = (gline + (1));
var G__45855 = cljs.core.next(lines__$1);
var G__45856 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45857 = result__$1;
gline = G__45854;
lines__$1 = G__45855;
relseg = G__45856;
result = G__45857;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44816){
var vec__44820 = p__44816;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44820,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44820,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44820,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44820,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44820,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__44825){
var vec__44826 = p__44825;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44826,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44826,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44826,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44826,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44826,(4),null);
var seg = vec__44826;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44834){
var vec__44838 = p__44834;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44838,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44838,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44838,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44838,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44838,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__44857 = cljs.core.seq(infos);
var chunk__44858 = null;
var count__44859 = (0);
var i__44860 = (0);
while(true){
if((i__44860 < count__44859)){
var info = chunk__44858.cljs$core$IIndexed$_nth$arity$2(null,i__44860);
var segv_45868 = info__GT_segv(info,source_idx,line,col);
var gline_45869 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45870 = cljs.core.count(cljs.core.deref(lines));
if((gline_45869 > (lc_45870 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44857,chunk__44858,count__44859,i__44860,segv_45868,gline_45869,lc_45870,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45869 - (lc_45870 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45868], null));
});})(seq__44857,chunk__44858,count__44859,i__44860,segv_45868,gline_45869,lc_45870,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44857,chunk__44858,count__44859,i__44860,segv_45868,gline_45869,lc_45870,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45869], null),cljs.core.conj,segv_45868);
});})(seq__44857,chunk__44858,count__44859,i__44860,segv_45868,gline_45869,lc_45870,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45872 = seq__44857;
var G__45873 = chunk__44858;
var G__45874 = count__44859;
var G__45875 = (i__44860 + (1));
seq__44857 = G__45872;
chunk__44858 = G__45873;
count__44859 = G__45874;
i__44860 = G__45875;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__44857);
if(temp__5735__auto__){
var seq__44857__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44857__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__44857__$1);
var G__45876 = cljs.core.chunk_rest(seq__44857__$1);
var G__45877 = c__4609__auto__;
var G__45878 = cljs.core.count(c__4609__auto__);
var G__45879 = (0);
seq__44857 = G__45876;
chunk__44858 = G__45877;
count__44859 = G__45878;
i__44860 = G__45879;
continue;
} else {
var info = cljs.core.first(seq__44857__$1);
var segv_45882 = info__GT_segv(info,source_idx,line,col);
var gline_45883 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45884 = cljs.core.count(cljs.core.deref(lines));
if((gline_45883 > (lc_45884 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44857,chunk__44858,count__44859,i__44860,segv_45882,gline_45883,lc_45884,info,seq__44857__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45883 - (lc_45884 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45882], null));
});})(seq__44857,chunk__44858,count__44859,i__44860,segv_45882,gline_45883,lc_45884,info,seq__44857__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44857,chunk__44858,count__44859,i__44860,segv_45882,gline_45883,lc_45884,info,seq__44857__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45883], null),cljs.core.conj,segv_45882);
});})(seq__44857,chunk__44858,count__44859,i__44860,segv_45882,gline_45883,lc_45884,info,seq__44857__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45887 = cljs.core.next(seq__44857__$1);
var G__45889 = null;
var G__45890 = (0);
var G__45891 = (0);
seq__44857 = G__45887;
chunk__44858 = G__45889;
count__44859 = G__45890;
i__44860 = G__45891;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__44867_45892 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__44868_45893 = null;
var count__44869_45894 = (0);
var i__44870_45895 = (0);
while(true){
if((i__44870_45895 < count__44869_45894)){
var vec__45107_45896 = chunk__44868_45893.cljs$core$IIndexed$_nth$arity$2(null,i__44870_45895);
var source_idx_45897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45107_45896,(0),null);
var vec__45110_45898 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45107_45896,(1),null);
var __45899 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45110_45898,(0),null);
var lines_45900__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45110_45898,(1),null);
var seq__45113_45903 = cljs.core.seq(lines_45900__$1);
var chunk__45114_45904 = null;
var count__45115_45905 = (0);
var i__45116_45906 = (0);
while(true){
if((i__45116_45906 < count__45115_45905)){
var vec__45174_45907 = chunk__45114_45904.cljs$core$IIndexed$_nth$arity$2(null,i__45116_45906);
var line_45908 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45174_45907,(0),null);
var cols_45909 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45174_45907,(1),null);
var seq__45177_45910 = cljs.core.seq(cols_45909);
var chunk__45178_45911 = null;
var count__45179_45912 = (0);
var i__45180_45913 = (0);
while(true){
if((i__45180_45913 < count__45179_45912)){
var vec__45189_45916 = chunk__45178_45911.cljs$core$IIndexed$_nth$arity$2(null,i__45180_45913);
var col_45917 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45189_45916,(0),null);
var infos_45918 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45189_45916,(1),null);
encode_cols(infos_45918,source_idx_45897,line_45908,col_45917);


var G__45919 = seq__45177_45910;
var G__45920 = chunk__45178_45911;
var G__45921 = count__45179_45912;
var G__45922 = (i__45180_45913 + (1));
seq__45177_45910 = G__45919;
chunk__45178_45911 = G__45920;
count__45179_45912 = G__45921;
i__45180_45913 = G__45922;
continue;
} else {
var temp__5735__auto___45923 = cljs.core.seq(seq__45177_45910);
if(temp__5735__auto___45923){
var seq__45177_45924__$1 = temp__5735__auto___45923;
if(cljs.core.chunked_seq_QMARK_(seq__45177_45924__$1)){
var c__4609__auto___45925 = cljs.core.chunk_first(seq__45177_45924__$1);
var G__45926 = cljs.core.chunk_rest(seq__45177_45924__$1);
var G__45927 = c__4609__auto___45925;
var G__45928 = cljs.core.count(c__4609__auto___45925);
var G__45929 = (0);
seq__45177_45910 = G__45926;
chunk__45178_45911 = G__45927;
count__45179_45912 = G__45928;
i__45180_45913 = G__45929;
continue;
} else {
var vec__45196_45930 = cljs.core.first(seq__45177_45924__$1);
var col_45931 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45196_45930,(0),null);
var infos_45932 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45196_45930,(1),null);
encode_cols(infos_45932,source_idx_45897,line_45908,col_45931);


var G__45933 = cljs.core.next(seq__45177_45924__$1);
var G__45934 = null;
var G__45935 = (0);
var G__45936 = (0);
seq__45177_45910 = G__45933;
chunk__45178_45911 = G__45934;
count__45179_45912 = G__45935;
i__45180_45913 = G__45936;
continue;
}
} else {
}
}
break;
}


var G__45937 = seq__45113_45903;
var G__45938 = chunk__45114_45904;
var G__45939 = count__45115_45905;
var G__45940 = (i__45116_45906 + (1));
seq__45113_45903 = G__45937;
chunk__45114_45904 = G__45938;
count__45115_45905 = G__45939;
i__45116_45906 = G__45940;
continue;
} else {
var temp__5735__auto___45941 = cljs.core.seq(seq__45113_45903);
if(temp__5735__auto___45941){
var seq__45113_45942__$1 = temp__5735__auto___45941;
if(cljs.core.chunked_seq_QMARK_(seq__45113_45942__$1)){
var c__4609__auto___45943 = cljs.core.chunk_first(seq__45113_45942__$1);
var G__45944 = cljs.core.chunk_rest(seq__45113_45942__$1);
var G__45945 = c__4609__auto___45943;
var G__45946 = cljs.core.count(c__4609__auto___45943);
var G__45947 = (0);
seq__45113_45903 = G__45944;
chunk__45114_45904 = G__45945;
count__45115_45905 = G__45946;
i__45116_45906 = G__45947;
continue;
} else {
var vec__45200_45948 = cljs.core.first(seq__45113_45942__$1);
var line_45949 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45200_45948,(0),null);
var cols_45950 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45200_45948,(1),null);
var seq__45203_45951 = cljs.core.seq(cols_45950);
var chunk__45204_45952 = null;
var count__45205_45953 = (0);
var i__45206_45954 = (0);
while(true){
if((i__45206_45954 < count__45205_45953)){
var vec__45219_45955 = chunk__45204_45952.cljs$core$IIndexed$_nth$arity$2(null,i__45206_45954);
var col_45956 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45219_45955,(0),null);
var infos_45957 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45219_45955,(1),null);
encode_cols(infos_45957,source_idx_45897,line_45949,col_45956);


var G__45958 = seq__45203_45951;
var G__45959 = chunk__45204_45952;
var G__45960 = count__45205_45953;
var G__45961 = (i__45206_45954 + (1));
seq__45203_45951 = G__45958;
chunk__45204_45952 = G__45959;
count__45205_45953 = G__45960;
i__45206_45954 = G__45961;
continue;
} else {
var temp__5735__auto___45962__$1 = cljs.core.seq(seq__45203_45951);
if(temp__5735__auto___45962__$1){
var seq__45203_45963__$1 = temp__5735__auto___45962__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45203_45963__$1)){
var c__4609__auto___45964 = cljs.core.chunk_first(seq__45203_45963__$1);
var G__45965 = cljs.core.chunk_rest(seq__45203_45963__$1);
var G__45966 = c__4609__auto___45964;
var G__45967 = cljs.core.count(c__4609__auto___45964);
var G__45968 = (0);
seq__45203_45951 = G__45965;
chunk__45204_45952 = G__45966;
count__45205_45953 = G__45967;
i__45206_45954 = G__45968;
continue;
} else {
var vec__45226_45969 = cljs.core.first(seq__45203_45963__$1);
var col_45970 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45226_45969,(0),null);
var infos_45971 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45226_45969,(1),null);
encode_cols(infos_45971,source_idx_45897,line_45949,col_45970);


var G__45972 = cljs.core.next(seq__45203_45963__$1);
var G__45973 = null;
var G__45974 = (0);
var G__45975 = (0);
seq__45203_45951 = G__45972;
chunk__45204_45952 = G__45973;
count__45205_45953 = G__45974;
i__45206_45954 = G__45975;
continue;
}
} else {
}
}
break;
}


var G__45976 = cljs.core.next(seq__45113_45942__$1);
var G__45977 = null;
var G__45978 = (0);
var G__45979 = (0);
seq__45113_45903 = G__45976;
chunk__45114_45904 = G__45977;
count__45115_45905 = G__45978;
i__45116_45906 = G__45979;
continue;
}
} else {
}
}
break;
}


var G__45980 = seq__44867_45892;
var G__45981 = chunk__44868_45893;
var G__45982 = count__44869_45894;
var G__45983 = (i__44870_45895 + (1));
seq__44867_45892 = G__45980;
chunk__44868_45893 = G__45981;
count__44869_45894 = G__45982;
i__44870_45895 = G__45983;
continue;
} else {
var temp__5735__auto___45985 = cljs.core.seq(seq__44867_45892);
if(temp__5735__auto___45985){
var seq__44867_45989__$1 = temp__5735__auto___45985;
if(cljs.core.chunked_seq_QMARK_(seq__44867_45989__$1)){
var c__4609__auto___45990 = cljs.core.chunk_first(seq__44867_45989__$1);
var G__45991 = cljs.core.chunk_rest(seq__44867_45989__$1);
var G__45992 = c__4609__auto___45990;
var G__45993 = cljs.core.count(c__4609__auto___45990);
var G__45994 = (0);
seq__44867_45892 = G__45991;
chunk__44868_45893 = G__45992;
count__44869_45894 = G__45993;
i__44870_45895 = G__45994;
continue;
} else {
var vec__45230_45995 = cljs.core.first(seq__44867_45989__$1);
var source_idx_45996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45230_45995,(0),null);
var vec__45233_45997 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45230_45995,(1),null);
var __45998 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45233_45997,(0),null);
var lines_45999__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45233_45997,(1),null);
var seq__45239_46000 = cljs.core.seq(lines_45999__$1);
var chunk__45240_46001 = null;
var count__45241_46002 = (0);
var i__45242_46003 = (0);
while(true){
if((i__45242_46003 < count__45241_46002)){
var vec__45300_46004 = chunk__45240_46001.cljs$core$IIndexed$_nth$arity$2(null,i__45242_46003);
var line_46005 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45300_46004,(0),null);
var cols_46006 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45300_46004,(1),null);
var seq__45303_46009 = cljs.core.seq(cols_46006);
var chunk__45304_46010 = null;
var count__45305_46011 = (0);
var i__45306_46012 = (0);
while(true){
if((i__45306_46012 < count__45305_46011)){
var vec__45319_46013 = chunk__45304_46010.cljs$core$IIndexed$_nth$arity$2(null,i__45306_46012);
var col_46014 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45319_46013,(0),null);
var infos_46015 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45319_46013,(1),null);
encode_cols(infos_46015,source_idx_45996,line_46005,col_46014);


var G__46016 = seq__45303_46009;
var G__46017 = chunk__45304_46010;
var G__46018 = count__45305_46011;
var G__46019 = (i__45306_46012 + (1));
seq__45303_46009 = G__46016;
chunk__45304_46010 = G__46017;
count__45305_46011 = G__46018;
i__45306_46012 = G__46019;
continue;
} else {
var temp__5735__auto___46020__$1 = cljs.core.seq(seq__45303_46009);
if(temp__5735__auto___46020__$1){
var seq__45303_46021__$1 = temp__5735__auto___46020__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45303_46021__$1)){
var c__4609__auto___46022 = cljs.core.chunk_first(seq__45303_46021__$1);
var G__46023 = cljs.core.chunk_rest(seq__45303_46021__$1);
var G__46024 = c__4609__auto___46022;
var G__46025 = cljs.core.count(c__4609__auto___46022);
var G__46026 = (0);
seq__45303_46009 = G__46023;
chunk__45304_46010 = G__46024;
count__45305_46011 = G__46025;
i__45306_46012 = G__46026;
continue;
} else {
var vec__45326_46027 = cljs.core.first(seq__45303_46021__$1);
var col_46028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45326_46027,(0),null);
var infos_46029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45326_46027,(1),null);
encode_cols(infos_46029,source_idx_45996,line_46005,col_46028);


var G__46030 = cljs.core.next(seq__45303_46021__$1);
var G__46031 = null;
var G__46032 = (0);
var G__46033 = (0);
seq__45303_46009 = G__46030;
chunk__45304_46010 = G__46031;
count__45305_46011 = G__46032;
i__45306_46012 = G__46033;
continue;
}
} else {
}
}
break;
}


var G__46035 = seq__45239_46000;
var G__46036 = chunk__45240_46001;
var G__46037 = count__45241_46002;
var G__46038 = (i__45242_46003 + (1));
seq__45239_46000 = G__46035;
chunk__45240_46001 = G__46036;
count__45241_46002 = G__46037;
i__45242_46003 = G__46038;
continue;
} else {
var temp__5735__auto___46040__$1 = cljs.core.seq(seq__45239_46000);
if(temp__5735__auto___46040__$1){
var seq__45239_46041__$1 = temp__5735__auto___46040__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45239_46041__$1)){
var c__4609__auto___46042 = cljs.core.chunk_first(seq__45239_46041__$1);
var G__46043 = cljs.core.chunk_rest(seq__45239_46041__$1);
var G__46044 = c__4609__auto___46042;
var G__46045 = cljs.core.count(c__4609__auto___46042);
var G__46046 = (0);
seq__45239_46000 = G__46043;
chunk__45240_46001 = G__46044;
count__45241_46002 = G__46045;
i__45242_46003 = G__46046;
continue;
} else {
var vec__45329_46047 = cljs.core.first(seq__45239_46041__$1);
var line_46048 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45329_46047,(0),null);
var cols_46049 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45329_46047,(1),null);
var seq__45332_46050 = cljs.core.seq(cols_46049);
var chunk__45333_46051 = null;
var count__45334_46052 = (0);
var i__45335_46053 = (0);
while(true){
if((i__45335_46053 < count__45334_46052)){
var vec__45346_46062 = chunk__45333_46051.cljs$core$IIndexed$_nth$arity$2(null,i__45335_46053);
var col_46063 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45346_46062,(0),null);
var infos_46064 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45346_46062,(1),null);
encode_cols(infos_46064,source_idx_45996,line_46048,col_46063);


var G__46065 = seq__45332_46050;
var G__46066 = chunk__45333_46051;
var G__46067 = count__45334_46052;
var G__46068 = (i__45335_46053 + (1));
seq__45332_46050 = G__46065;
chunk__45333_46051 = G__46066;
count__45334_46052 = G__46067;
i__45335_46053 = G__46068;
continue;
} else {
var temp__5735__auto___46069__$2 = cljs.core.seq(seq__45332_46050);
if(temp__5735__auto___46069__$2){
var seq__45332_46070__$1 = temp__5735__auto___46069__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45332_46070__$1)){
var c__4609__auto___46071 = cljs.core.chunk_first(seq__45332_46070__$1);
var G__46072 = cljs.core.chunk_rest(seq__45332_46070__$1);
var G__46073 = c__4609__auto___46071;
var G__46074 = cljs.core.count(c__4609__auto___46071);
var G__46075 = (0);
seq__45332_46050 = G__46072;
chunk__45333_46051 = G__46073;
count__45334_46052 = G__46074;
i__45335_46053 = G__46075;
continue;
} else {
var vec__45349_46076 = cljs.core.first(seq__45332_46070__$1);
var col_46077 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45349_46076,(0),null);
var infos_46078 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45349_46076,(1),null);
encode_cols(infos_46078,source_idx_45996,line_46048,col_46077);


var G__46080 = cljs.core.next(seq__45332_46070__$1);
var G__46081 = null;
var G__46082 = (0);
var G__46083 = (0);
seq__45332_46050 = G__46080;
chunk__45333_46051 = G__46081;
count__45334_46052 = G__46082;
i__45335_46053 = G__46083;
continue;
}
} else {
}
}
break;
}


var G__46084 = cljs.core.next(seq__45239_46041__$1);
var G__46085 = null;
var G__46086 = (0);
var G__46087 = (0);
seq__45239_46000 = G__46084;
chunk__45240_46001 = G__46085;
count__45241_46002 = G__46086;
i__45242_46003 = G__46087;
continue;
}
} else {
}
}
break;
}


var G__46088 = cljs.core.next(seq__44867_45989__$1);
var G__46089 = null;
var G__46090 = (0);
var G__46091 = (0);
seq__44867_45892 = G__46088;
chunk__44868_45893 = G__46089;
count__44869_45894 = G__46090;
i__44870_45895 = G__46091;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__45356 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__44846_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__44846_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__44847_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__44847_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__44850_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__44850_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__45357 = G__45356;
var G__45358_46092 = G__45357;
var G__45359_46093 = "sourcesContent";
var G__45360_46094 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__45358_46092,G__45359_46093,G__45360_46094);

return G__45357;
} else {
return G__45356;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__45365 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45365,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45365,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__45368 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45368,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45368,(1),null);
var G__46095 = cljs.core.next(col_map_seq);
var G__46096 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__45368,col,infos,vec__45365,line,col_map){
return (function (v,p__45372){
var map__45373 = p__45372;
var map__45373__$1 = (((((!((map__45373 == null))))?(((((map__45373.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45373.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45373):map__45373);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45373__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45373__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__45368,col,infos,vec__45365,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__46095;
new_cols = G__46096;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__46098 = cljs.core.next(line_map_seq);
var G__46099 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__46098;
new_lines = G__46099;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__45381_46100 = cljs.core.seq(reverse_map);
var chunk__45382_46101 = null;
var count__45383_46102 = (0);
var i__45384_46103 = (0);
while(true){
if((i__45384_46103 < count__45383_46102)){
var vec__45614_46104 = chunk__45382_46101.cljs$core$IIndexed$_nth$arity$2(null,i__45384_46103);
var line_46105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45614_46104,(0),null);
var columns_46106 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45614_46104,(1),null);
var seq__45617_46107 = cljs.core.seq(columns_46106);
var chunk__45618_46108 = null;
var count__45619_46109 = (0);
var i__45620_46110 = (0);
while(true){
if((i__45620_46110 < count__45619_46109)){
var vec__45676_46111 = chunk__45618_46108.cljs$core$IIndexed$_nth$arity$2(null,i__45620_46110);
var column_46112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45676_46111,(0),null);
var column_info_46113 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45676_46111,(1),null);
var seq__45679_46114 = cljs.core.seq(column_info_46113);
var chunk__45680_46115 = null;
var count__45681_46116 = (0);
var i__45682_46117 = (0);
while(true){
if((i__45682_46117 < count__45681_46116)){
var map__45690_46118 = chunk__45680_46115.cljs$core$IIndexed$_nth$arity$2(null,i__45682_46117);
var map__45690_46119__$1 = (((((!((map__45690_46118 == null))))?(((((map__45690_46118.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45690_46118.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45690_46118):map__45690_46118);
var gline_46120 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45690_46119__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46121 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45690_46119__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46122 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45690_46119__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46120], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45679_46114,chunk__45680_46115,count__45681_46116,i__45682_46117,seq__45617_46107,chunk__45618_46108,count__45619_46109,i__45620_46110,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45690_46118,map__45690_46119__$1,gline_46120,gcol_46121,name_46122,vec__45676_46111,column_46112,column_info_46113,vec__45614_46104,line_46105,columns_46106,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46121], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46105,new cljs.core.Keyword(null,"col","col",-1959363084),column_46112,new cljs.core.Keyword(null,"name","name",1843675177),name_46122], null));
});})(seq__45679_46114,chunk__45680_46115,count__45681_46116,i__45682_46117,seq__45617_46107,chunk__45618_46108,count__45619_46109,i__45620_46110,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45690_46118,map__45690_46119__$1,gline_46120,gcol_46121,name_46122,vec__45676_46111,column_46112,column_info_46113,vec__45614_46104,line_46105,columns_46106,inverted))
,cljs.core.sorted_map()));


var G__46124 = seq__45679_46114;
var G__46125 = chunk__45680_46115;
var G__46126 = count__45681_46116;
var G__46127 = (i__45682_46117 + (1));
seq__45679_46114 = G__46124;
chunk__45680_46115 = G__46125;
count__45681_46116 = G__46126;
i__45682_46117 = G__46127;
continue;
} else {
var temp__5735__auto___46128 = cljs.core.seq(seq__45679_46114);
if(temp__5735__auto___46128){
var seq__45679_46129__$1 = temp__5735__auto___46128;
if(cljs.core.chunked_seq_QMARK_(seq__45679_46129__$1)){
var c__4609__auto___46130 = cljs.core.chunk_first(seq__45679_46129__$1);
var G__46131 = cljs.core.chunk_rest(seq__45679_46129__$1);
var G__46132 = c__4609__auto___46130;
var G__46133 = cljs.core.count(c__4609__auto___46130);
var G__46134 = (0);
seq__45679_46114 = G__46131;
chunk__45680_46115 = G__46132;
count__45681_46116 = G__46133;
i__45682_46117 = G__46134;
continue;
} else {
var map__45696_46135 = cljs.core.first(seq__45679_46129__$1);
var map__45696_46136__$1 = (((((!((map__45696_46135 == null))))?(((((map__45696_46135.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45696_46135.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45696_46135):map__45696_46135);
var gline_46137 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45696_46136__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46138 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45696_46136__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46139 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45696_46136__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46137], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45679_46114,chunk__45680_46115,count__45681_46116,i__45682_46117,seq__45617_46107,chunk__45618_46108,count__45619_46109,i__45620_46110,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45696_46135,map__45696_46136__$1,gline_46137,gcol_46138,name_46139,seq__45679_46129__$1,temp__5735__auto___46128,vec__45676_46111,column_46112,column_info_46113,vec__45614_46104,line_46105,columns_46106,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46138], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46105,new cljs.core.Keyword(null,"col","col",-1959363084),column_46112,new cljs.core.Keyword(null,"name","name",1843675177),name_46139], null));
});})(seq__45679_46114,chunk__45680_46115,count__45681_46116,i__45682_46117,seq__45617_46107,chunk__45618_46108,count__45619_46109,i__45620_46110,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45696_46135,map__45696_46136__$1,gline_46137,gcol_46138,name_46139,seq__45679_46129__$1,temp__5735__auto___46128,vec__45676_46111,column_46112,column_info_46113,vec__45614_46104,line_46105,columns_46106,inverted))
,cljs.core.sorted_map()));


var G__46153 = cljs.core.next(seq__45679_46129__$1);
var G__46154 = null;
var G__46155 = (0);
var G__46156 = (0);
seq__45679_46114 = G__46153;
chunk__45680_46115 = G__46154;
count__45681_46116 = G__46155;
i__45682_46117 = G__46156;
continue;
}
} else {
}
}
break;
}


var G__46161 = seq__45617_46107;
var G__46162 = chunk__45618_46108;
var G__46163 = count__45619_46109;
var G__46164 = (i__45620_46110 + (1));
seq__45617_46107 = G__46161;
chunk__45618_46108 = G__46162;
count__45619_46109 = G__46163;
i__45620_46110 = G__46164;
continue;
} else {
var temp__5735__auto___46166 = cljs.core.seq(seq__45617_46107);
if(temp__5735__auto___46166){
var seq__45617_46171__$1 = temp__5735__auto___46166;
if(cljs.core.chunked_seq_QMARK_(seq__45617_46171__$1)){
var c__4609__auto___46172 = cljs.core.chunk_first(seq__45617_46171__$1);
var G__46177 = cljs.core.chunk_rest(seq__45617_46171__$1);
var G__46178 = c__4609__auto___46172;
var G__46179 = cljs.core.count(c__4609__auto___46172);
var G__46180 = (0);
seq__45617_46107 = G__46177;
chunk__45618_46108 = G__46178;
count__45619_46109 = G__46179;
i__45620_46110 = G__46180;
continue;
} else {
var vec__45702_46184 = cljs.core.first(seq__45617_46171__$1);
var column_46185 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45702_46184,(0),null);
var column_info_46186 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45702_46184,(1),null);
var seq__45705_46187 = cljs.core.seq(column_info_46186);
var chunk__45706_46188 = null;
var count__45707_46189 = (0);
var i__45708_46190 = (0);
while(true){
if((i__45708_46190 < count__45707_46189)){
var map__45715_46195 = chunk__45706_46188.cljs$core$IIndexed$_nth$arity$2(null,i__45708_46190);
var map__45715_46196__$1 = (((((!((map__45715_46195 == null))))?(((((map__45715_46195.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45715_46195.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45715_46195):map__45715_46195);
var gline_46197 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45715_46196__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46198 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45715_46196__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46199 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45715_46196__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46197], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45705_46187,chunk__45706_46188,count__45707_46189,i__45708_46190,seq__45617_46107,chunk__45618_46108,count__45619_46109,i__45620_46110,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45715_46195,map__45715_46196__$1,gline_46197,gcol_46198,name_46199,vec__45702_46184,column_46185,column_info_46186,seq__45617_46171__$1,temp__5735__auto___46166,vec__45614_46104,line_46105,columns_46106,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46198], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46105,new cljs.core.Keyword(null,"col","col",-1959363084),column_46185,new cljs.core.Keyword(null,"name","name",1843675177),name_46199], null));
});})(seq__45705_46187,chunk__45706_46188,count__45707_46189,i__45708_46190,seq__45617_46107,chunk__45618_46108,count__45619_46109,i__45620_46110,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45715_46195,map__45715_46196__$1,gline_46197,gcol_46198,name_46199,vec__45702_46184,column_46185,column_info_46186,seq__45617_46171__$1,temp__5735__auto___46166,vec__45614_46104,line_46105,columns_46106,inverted))
,cljs.core.sorted_map()));


var G__46214 = seq__45705_46187;
var G__46215 = chunk__45706_46188;
var G__46216 = count__45707_46189;
var G__46217 = (i__45708_46190 + (1));
seq__45705_46187 = G__46214;
chunk__45706_46188 = G__46215;
count__45707_46189 = G__46216;
i__45708_46190 = G__46217;
continue;
} else {
var temp__5735__auto___46218__$1 = cljs.core.seq(seq__45705_46187);
if(temp__5735__auto___46218__$1){
var seq__45705_46220__$1 = temp__5735__auto___46218__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45705_46220__$1)){
var c__4609__auto___46222 = cljs.core.chunk_first(seq__45705_46220__$1);
var G__46224 = cljs.core.chunk_rest(seq__45705_46220__$1);
var G__46225 = c__4609__auto___46222;
var G__46226 = cljs.core.count(c__4609__auto___46222);
var G__46227 = (0);
seq__45705_46187 = G__46224;
chunk__45706_46188 = G__46225;
count__45707_46189 = G__46226;
i__45708_46190 = G__46227;
continue;
} else {
var map__45719_46228 = cljs.core.first(seq__45705_46220__$1);
var map__45719_46229__$1 = (((((!((map__45719_46228 == null))))?(((((map__45719_46228.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45719_46228.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45719_46228):map__45719_46228);
var gline_46230 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45719_46229__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46231 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45719_46229__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46232 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45719_46229__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46230], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45705_46187,chunk__45706_46188,count__45707_46189,i__45708_46190,seq__45617_46107,chunk__45618_46108,count__45619_46109,i__45620_46110,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45719_46228,map__45719_46229__$1,gline_46230,gcol_46231,name_46232,seq__45705_46220__$1,temp__5735__auto___46218__$1,vec__45702_46184,column_46185,column_info_46186,seq__45617_46171__$1,temp__5735__auto___46166,vec__45614_46104,line_46105,columns_46106,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46231], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46105,new cljs.core.Keyword(null,"col","col",-1959363084),column_46185,new cljs.core.Keyword(null,"name","name",1843675177),name_46232], null));
});})(seq__45705_46187,chunk__45706_46188,count__45707_46189,i__45708_46190,seq__45617_46107,chunk__45618_46108,count__45619_46109,i__45620_46110,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45719_46228,map__45719_46229__$1,gline_46230,gcol_46231,name_46232,seq__45705_46220__$1,temp__5735__auto___46218__$1,vec__45702_46184,column_46185,column_info_46186,seq__45617_46171__$1,temp__5735__auto___46166,vec__45614_46104,line_46105,columns_46106,inverted))
,cljs.core.sorted_map()));


var G__46233 = cljs.core.next(seq__45705_46220__$1);
var G__46234 = null;
var G__46235 = (0);
var G__46236 = (0);
seq__45705_46187 = G__46233;
chunk__45706_46188 = G__46234;
count__45707_46189 = G__46235;
i__45708_46190 = G__46236;
continue;
}
} else {
}
}
break;
}


var G__46237 = cljs.core.next(seq__45617_46171__$1);
var G__46238 = null;
var G__46239 = (0);
var G__46240 = (0);
seq__45617_46107 = G__46237;
chunk__45618_46108 = G__46238;
count__45619_46109 = G__46239;
i__45620_46110 = G__46240;
continue;
}
} else {
}
}
break;
}


var G__46241 = seq__45381_46100;
var G__46242 = chunk__45382_46101;
var G__46243 = count__45383_46102;
var G__46244 = (i__45384_46103 + (1));
seq__45381_46100 = G__46241;
chunk__45382_46101 = G__46242;
count__45383_46102 = G__46243;
i__45384_46103 = G__46244;
continue;
} else {
var temp__5735__auto___46245 = cljs.core.seq(seq__45381_46100);
if(temp__5735__auto___46245){
var seq__45381_46246__$1 = temp__5735__auto___46245;
if(cljs.core.chunked_seq_QMARK_(seq__45381_46246__$1)){
var c__4609__auto___46247 = cljs.core.chunk_first(seq__45381_46246__$1);
var G__46248 = cljs.core.chunk_rest(seq__45381_46246__$1);
var G__46249 = c__4609__auto___46247;
var G__46250 = cljs.core.count(c__4609__auto___46247);
var G__46251 = (0);
seq__45381_46100 = G__46248;
chunk__45382_46101 = G__46249;
count__45383_46102 = G__46250;
i__45384_46103 = G__46251;
continue;
} else {
var vec__45721_46252 = cljs.core.first(seq__45381_46246__$1);
var line_46253 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45721_46252,(0),null);
var columns_46254 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45721_46252,(1),null);
var seq__45724_46255 = cljs.core.seq(columns_46254);
var chunk__45725_46256 = null;
var count__45726_46257 = (0);
var i__45727_46258 = (0);
while(true){
if((i__45727_46258 < count__45726_46257)){
var vec__45763_46259 = chunk__45725_46256.cljs$core$IIndexed$_nth$arity$2(null,i__45727_46258);
var column_46260 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45763_46259,(0),null);
var column_info_46261 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45763_46259,(1),null);
var seq__45766_46262 = cljs.core.seq(column_info_46261);
var chunk__45767_46263 = null;
var count__45768_46264 = (0);
var i__45769_46265 = (0);
while(true){
if((i__45769_46265 < count__45768_46264)){
var map__45778_46266 = chunk__45767_46263.cljs$core$IIndexed$_nth$arity$2(null,i__45769_46265);
var map__45778_46267__$1 = (((((!((map__45778_46266 == null))))?(((((map__45778_46266.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45778_46266.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45778_46266):map__45778_46266);
var gline_46268 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45778_46267__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46269 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45778_46267__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46270 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45778_46267__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46268], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45766_46262,chunk__45767_46263,count__45768_46264,i__45769_46265,seq__45724_46255,chunk__45725_46256,count__45726_46257,i__45727_46258,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45778_46266,map__45778_46267__$1,gline_46268,gcol_46269,name_46270,vec__45763_46259,column_46260,column_info_46261,vec__45721_46252,line_46253,columns_46254,seq__45381_46246__$1,temp__5735__auto___46245,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46269], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46253,new cljs.core.Keyword(null,"col","col",-1959363084),column_46260,new cljs.core.Keyword(null,"name","name",1843675177),name_46270], null));
});})(seq__45766_46262,chunk__45767_46263,count__45768_46264,i__45769_46265,seq__45724_46255,chunk__45725_46256,count__45726_46257,i__45727_46258,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45778_46266,map__45778_46267__$1,gline_46268,gcol_46269,name_46270,vec__45763_46259,column_46260,column_info_46261,vec__45721_46252,line_46253,columns_46254,seq__45381_46246__$1,temp__5735__auto___46245,inverted))
,cljs.core.sorted_map()));


var G__46271 = seq__45766_46262;
var G__46272 = chunk__45767_46263;
var G__46273 = count__45768_46264;
var G__46274 = (i__45769_46265 + (1));
seq__45766_46262 = G__46271;
chunk__45767_46263 = G__46272;
count__45768_46264 = G__46273;
i__45769_46265 = G__46274;
continue;
} else {
var temp__5735__auto___46275__$1 = cljs.core.seq(seq__45766_46262);
if(temp__5735__auto___46275__$1){
var seq__45766_46276__$1 = temp__5735__auto___46275__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45766_46276__$1)){
var c__4609__auto___46277 = cljs.core.chunk_first(seq__45766_46276__$1);
var G__46278 = cljs.core.chunk_rest(seq__45766_46276__$1);
var G__46279 = c__4609__auto___46277;
var G__46280 = cljs.core.count(c__4609__auto___46277);
var G__46281 = (0);
seq__45766_46262 = G__46278;
chunk__45767_46263 = G__46279;
count__45768_46264 = G__46280;
i__45769_46265 = G__46281;
continue;
} else {
var map__45780_46282 = cljs.core.first(seq__45766_46276__$1);
var map__45780_46283__$1 = (((((!((map__45780_46282 == null))))?(((((map__45780_46282.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45780_46282.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45780_46282):map__45780_46282);
var gline_46284 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45780_46283__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46285 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45780_46283__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46286 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45780_46283__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46284], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45766_46262,chunk__45767_46263,count__45768_46264,i__45769_46265,seq__45724_46255,chunk__45725_46256,count__45726_46257,i__45727_46258,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45780_46282,map__45780_46283__$1,gline_46284,gcol_46285,name_46286,seq__45766_46276__$1,temp__5735__auto___46275__$1,vec__45763_46259,column_46260,column_info_46261,vec__45721_46252,line_46253,columns_46254,seq__45381_46246__$1,temp__5735__auto___46245,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46285], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46253,new cljs.core.Keyword(null,"col","col",-1959363084),column_46260,new cljs.core.Keyword(null,"name","name",1843675177),name_46286], null));
});})(seq__45766_46262,chunk__45767_46263,count__45768_46264,i__45769_46265,seq__45724_46255,chunk__45725_46256,count__45726_46257,i__45727_46258,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45780_46282,map__45780_46283__$1,gline_46284,gcol_46285,name_46286,seq__45766_46276__$1,temp__5735__auto___46275__$1,vec__45763_46259,column_46260,column_info_46261,vec__45721_46252,line_46253,columns_46254,seq__45381_46246__$1,temp__5735__auto___46245,inverted))
,cljs.core.sorted_map()));


var G__46287 = cljs.core.next(seq__45766_46276__$1);
var G__46288 = null;
var G__46289 = (0);
var G__46290 = (0);
seq__45766_46262 = G__46287;
chunk__45767_46263 = G__46288;
count__45768_46264 = G__46289;
i__45769_46265 = G__46290;
continue;
}
} else {
}
}
break;
}


var G__46291 = seq__45724_46255;
var G__46292 = chunk__45725_46256;
var G__46293 = count__45726_46257;
var G__46294 = (i__45727_46258 + (1));
seq__45724_46255 = G__46291;
chunk__45725_46256 = G__46292;
count__45726_46257 = G__46293;
i__45727_46258 = G__46294;
continue;
} else {
var temp__5735__auto___46295__$1 = cljs.core.seq(seq__45724_46255);
if(temp__5735__auto___46295__$1){
var seq__45724_46296__$1 = temp__5735__auto___46295__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45724_46296__$1)){
var c__4609__auto___46297 = cljs.core.chunk_first(seq__45724_46296__$1);
var G__46298 = cljs.core.chunk_rest(seq__45724_46296__$1);
var G__46299 = c__4609__auto___46297;
var G__46300 = cljs.core.count(c__4609__auto___46297);
var G__46301 = (0);
seq__45724_46255 = G__46298;
chunk__45725_46256 = G__46299;
count__45726_46257 = G__46300;
i__45727_46258 = G__46301;
continue;
} else {
var vec__45786_46302 = cljs.core.first(seq__45724_46296__$1);
var column_46303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45786_46302,(0),null);
var column_info_46304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45786_46302,(1),null);
var seq__45789_46305 = cljs.core.seq(column_info_46304);
var chunk__45790_46306 = null;
var count__45791_46307 = (0);
var i__45792_46308 = (0);
while(true){
if((i__45792_46308 < count__45791_46307)){
var map__45798_46309 = chunk__45790_46306.cljs$core$IIndexed$_nth$arity$2(null,i__45792_46308);
var map__45798_46310__$1 = (((((!((map__45798_46309 == null))))?(((((map__45798_46309.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45798_46309.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45798_46309):map__45798_46309);
var gline_46311 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45798_46310__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46312 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45798_46310__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46313 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45798_46310__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46311], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45789_46305,chunk__45790_46306,count__45791_46307,i__45792_46308,seq__45724_46255,chunk__45725_46256,count__45726_46257,i__45727_46258,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45798_46309,map__45798_46310__$1,gline_46311,gcol_46312,name_46313,vec__45786_46302,column_46303,column_info_46304,seq__45724_46296__$1,temp__5735__auto___46295__$1,vec__45721_46252,line_46253,columns_46254,seq__45381_46246__$1,temp__5735__auto___46245,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46312], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46253,new cljs.core.Keyword(null,"col","col",-1959363084),column_46303,new cljs.core.Keyword(null,"name","name",1843675177),name_46313], null));
});})(seq__45789_46305,chunk__45790_46306,count__45791_46307,i__45792_46308,seq__45724_46255,chunk__45725_46256,count__45726_46257,i__45727_46258,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45798_46309,map__45798_46310__$1,gline_46311,gcol_46312,name_46313,vec__45786_46302,column_46303,column_info_46304,seq__45724_46296__$1,temp__5735__auto___46295__$1,vec__45721_46252,line_46253,columns_46254,seq__45381_46246__$1,temp__5735__auto___46245,inverted))
,cljs.core.sorted_map()));


var G__46314 = seq__45789_46305;
var G__46315 = chunk__45790_46306;
var G__46316 = count__45791_46307;
var G__46317 = (i__45792_46308 + (1));
seq__45789_46305 = G__46314;
chunk__45790_46306 = G__46315;
count__45791_46307 = G__46316;
i__45792_46308 = G__46317;
continue;
} else {
var temp__5735__auto___46318__$2 = cljs.core.seq(seq__45789_46305);
if(temp__5735__auto___46318__$2){
var seq__45789_46319__$1 = temp__5735__auto___46318__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45789_46319__$1)){
var c__4609__auto___46320 = cljs.core.chunk_first(seq__45789_46319__$1);
var G__46321 = cljs.core.chunk_rest(seq__45789_46319__$1);
var G__46322 = c__4609__auto___46320;
var G__46323 = cljs.core.count(c__4609__auto___46320);
var G__46324 = (0);
seq__45789_46305 = G__46321;
chunk__45790_46306 = G__46322;
count__45791_46307 = G__46323;
i__45792_46308 = G__46324;
continue;
} else {
var map__45801_46325 = cljs.core.first(seq__45789_46319__$1);
var map__45801_46326__$1 = (((((!((map__45801_46325 == null))))?(((((map__45801_46325.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45801_46325.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45801_46325):map__45801_46325);
var gline_46327 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45801_46326__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46328 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45801_46326__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46329 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45801_46326__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46327], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45789_46305,chunk__45790_46306,count__45791_46307,i__45792_46308,seq__45724_46255,chunk__45725_46256,count__45726_46257,i__45727_46258,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45801_46325,map__45801_46326__$1,gline_46327,gcol_46328,name_46329,seq__45789_46319__$1,temp__5735__auto___46318__$2,vec__45786_46302,column_46303,column_info_46304,seq__45724_46296__$1,temp__5735__auto___46295__$1,vec__45721_46252,line_46253,columns_46254,seq__45381_46246__$1,temp__5735__auto___46245,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46328], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46253,new cljs.core.Keyword(null,"col","col",-1959363084),column_46303,new cljs.core.Keyword(null,"name","name",1843675177),name_46329], null));
});})(seq__45789_46305,chunk__45790_46306,count__45791_46307,i__45792_46308,seq__45724_46255,chunk__45725_46256,count__45726_46257,i__45727_46258,seq__45381_46100,chunk__45382_46101,count__45383_46102,i__45384_46103,map__45801_46325,map__45801_46326__$1,gline_46327,gcol_46328,name_46329,seq__45789_46319__$1,temp__5735__auto___46318__$2,vec__45786_46302,column_46303,column_info_46304,seq__45724_46296__$1,temp__5735__auto___46295__$1,vec__45721_46252,line_46253,columns_46254,seq__45381_46246__$1,temp__5735__auto___46245,inverted))
,cljs.core.sorted_map()));


var G__46330 = cljs.core.next(seq__45789_46319__$1);
var G__46331 = null;
var G__46332 = (0);
var G__46333 = (0);
seq__45789_46305 = G__46330;
chunk__45790_46306 = G__46331;
count__45791_46307 = G__46332;
i__45792_46308 = G__46333;
continue;
}
} else {
}
}
break;
}


var G__46334 = cljs.core.next(seq__45724_46296__$1);
var G__46335 = null;
var G__46336 = (0);
var G__46337 = (0);
seq__45724_46255 = G__46334;
chunk__45725_46256 = G__46335;
count__45726_46257 = G__46336;
i__45727_46258 = G__46337;
continue;
}
} else {
}
}
break;
}


var G__46338 = cljs.core.next(seq__45381_46246__$1);
var G__46339 = null;
var G__46340 = (0);
var G__46341 = (0);
seq__45381_46100 = G__46338;
chunk__45382_46101 = G__46339;
count__45383_46102 = G__46340;
i__45384_46103 = G__46341;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
