goog.provide('day8.re_frame_10x.utils.localstorage');
goog.require('cljs.core');
goog.require('goog.storage.Storage');
goog.require('goog.storage.mechanism.HTML5LocalStorage');
goog.require('cljs.reader');
goog.require('clojure.string');
day8.re_frame_10x.utils.localstorage.storage = (new goog.storage.Storage((new goog.storage.mechanism.HTML5LocalStorage())));
day8.re_frame_10x.utils.localstorage.safe_prefix = "day8.re-frame-10x.";
day8.re_frame_10x.utils.localstorage.safe_key = (function day8$re_frame_10x$utils$localstorage$safe_key(key){

return [day8.re_frame_10x.utils.localstorage.safe_prefix,cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
});
/**
 * Gets a re-frame-10x value from local storage.
 */
day8.re_frame_10x.utils.localstorage.get = (function day8$re_frame_10x$utils$localstorage$get(var_args){
var G__39635 = arguments.length;
switch (G__39635) {
case 1:
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$1 = (function (key){
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2(key,null);
}));

(day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var value = day8.re_frame_10x.utils.localstorage.storage.get(day8.re_frame_10x.utils.localstorage.safe_key(key));
if((void 0 === value)){
return not_found;
} else {
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(value);
}
}));

(day8.re_frame_10x.utils.localstorage.get.cljs$lang$maxFixedArity = 2);

/**
 * Saves a re-frame-10x value to local storage.
 */
day8.re_frame_10x.utils.localstorage.save_BANG_ = (function day8$re_frame_10x$utils$localstorage$save_BANG_(key,value){
return day8.re_frame_10x.utils.localstorage.storage.set(day8.re_frame_10x.utils.localstorage.safe_key(key),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value], 0)));
});
/**
 * Deletes all re-frame-10x config keys
 */
day8.re_frame_10x.utils.localstorage.delete_all_keys_BANG_ = (function day8$re_frame_10x$utils$localstorage$delete_all_keys_BANG_(){
var seq__39646 = cljs.core.seq(Object.keys(localStorage));
var chunk__39647 = null;
var count__39648 = (0);
var i__39649 = (0);
while(true){
if((i__39649 < count__39648)){
var k = chunk__39647.cljs$core$IIndexed$_nth$arity$2(null,i__39649);
if(clojure.string.starts_with_QMARK_(k,day8.re_frame_10x.utils.localstorage.safe_prefix)){
day8.re_frame_10x.utils.localstorage.storage.remove(k);
} else {
}


var G__39675 = seq__39646;
var G__39676 = chunk__39647;
var G__39677 = count__39648;
var G__39678 = (i__39649 + (1));
seq__39646 = G__39675;
chunk__39647 = G__39676;
count__39648 = G__39677;
i__39649 = G__39678;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__39646);
if(temp__5735__auto__){
var seq__39646__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39646__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__39646__$1);
var G__39679 = cljs.core.chunk_rest(seq__39646__$1);
var G__39680 = c__4609__auto__;
var G__39681 = cljs.core.count(c__4609__auto__);
var G__39682 = (0);
seq__39646 = G__39679;
chunk__39647 = G__39680;
count__39648 = G__39681;
i__39649 = G__39682;
continue;
} else {
var k = cljs.core.first(seq__39646__$1);
if(clojure.string.starts_with_QMARK_(k,day8.re_frame_10x.utils.localstorage.safe_prefix)){
day8.re_frame_10x.utils.localstorage.storage.remove(k);
} else {
}


var G__39683 = cljs.core.next(seq__39646__$1);
var G__39684 = null;
var G__39685 = (0);
var G__39686 = (0);
seq__39646 = G__39683;
chunk__39647 = G__39684;
count__39648 = G__39685;
i__39649 = G__39686;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=day8.re_frame_10x.utils.localstorage.js.map
