goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__46351 = s;
var map__46351__$1 = (((((!((map__46351 == null))))?(((((map__46351.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46351.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46351):map__46351);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46351__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46351__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__46358 = info;
var map__46359 = G__46358;
var map__46359__$1 = (((((!((map__46359 == null))))?(((((map__46359.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46359.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46359):map__46359);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46359__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__46358__$1 = G__46358;
while(true){
var d__$2 = d__$1;
var map__46363 = G__46358__$1;
var map__46363__$1 = (((((!((map__46363 == null))))?(((((map__46363.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46363.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46363):map__46363);
var shadow__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46363__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$2)){
var G__47019 = (d__$2 + (1));
var G__47020 = shadow__$2;
d__$1 = G__47019;
G__46358__$1 = G__47020;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__46368){
var map__46369 = p__46368;
var map__46369__$1 = (((((!((map__46369 == null))))?(((((map__46369.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46369.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46369):map__46369);
var name_var = map__46369__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46369__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46369__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__46371 = info;
var map__46371__$1 = (((((!((map__46371 == null))))?(((((map__46371.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46371.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46371):map__46371);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46371__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46371__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__46373 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__46373) : cljs.compiler.munge.call(null,G__46373));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__46375 = arguments.length;
switch (G__46375) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__46376 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11472,11472,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__46376.cljs$core$IFn$_invoke$arity$1 ? fexpr__46376.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__46376.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__46377 = cp;
switch (G__46377) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__46378_47031 = cljs.core.seq(s);
var chunk__46379_47032 = null;
var count__46380_47033 = (0);
var i__46381_47034 = (0);
while(true){
if((i__46381_47034 < count__46380_47033)){
var c_47035 = chunk__46379_47032.cljs$core$IIndexed$_nth$arity$2(null,i__46381_47034);
sb.append(cljs.compiler.escape_char(c_47035));


var G__47036 = seq__46378_47031;
var G__47037 = chunk__46379_47032;
var G__47038 = count__46380_47033;
var G__47039 = (i__46381_47034 + (1));
seq__46378_47031 = G__47036;
chunk__46379_47032 = G__47037;
count__46380_47033 = G__47038;
i__46381_47034 = G__47039;
continue;
} else {
var temp__5735__auto___47044 = cljs.core.seq(seq__46378_47031);
if(temp__5735__auto___47044){
var seq__46378_47045__$1 = temp__5735__auto___47044;
if(cljs.core.chunked_seq_QMARK_(seq__46378_47045__$1)){
var c__4609__auto___47047 = cljs.core.chunk_first(seq__46378_47045__$1);
var G__47048 = cljs.core.chunk_rest(seq__46378_47045__$1);
var G__47049 = c__4609__auto___47047;
var G__47050 = cljs.core.count(c__4609__auto___47047);
var G__47051 = (0);
seq__46378_47031 = G__47048;
chunk__46379_47032 = G__47049;
count__46380_47033 = G__47050;
i__46381_47034 = G__47051;
continue;
} else {
var c_47052 = cljs.core.first(seq__46378_47045__$1);
sb.append(cljs.compiler.escape_char(c_47052));


var G__47053 = cljs.core.next(seq__46378_47045__$1);
var G__47054 = null;
var G__47055 = (0);
var G__47056 = (0);
seq__46378_47031 = G__47053;
chunk__46379_47032 = G__47054;
count__46380_47033 = G__47055;
i__46381_47034 = G__47056;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__46382 = cljs.core.get_global_hierarchy;
return (fexpr__46382.cljs$core$IFn$_invoke$arity$0 ? fexpr__46382.cljs$core$IFn$_invoke$arity$0() : fexpr__46382.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__46383_47064 = ast;
var map__46383_47065__$1 = (((((!((map__46383_47064 == null))))?(((((map__46383_47064.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46383_47064.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46383_47064):map__46383_47064);
var env_47066 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46383_47065__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_47066))){
var map__46385_47073 = env_47066;
var map__46385_47074__$1 = (((((!((map__46385_47073 == null))))?(((((map__46385_47073.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46385_47073.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46385_47073):map__46385_47073);
var line_47075 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46385_47074__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_47076 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46385_47074__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__46387 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__46389 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__46388 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__46388.cljs$core$IFn$_invoke$arity$1 ? fexpr__46388.cljs$core$IFn$_invoke$arity$1(G__46389) : fexpr__46388.call(null,G__46389));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__46387,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__46387;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_47075 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_47076)?(column_47076 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__46398 = arguments.length;
switch (G__46398) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___47090 = arguments.length;
var i__4790__auto___47091 = (0);
while(true){
if((i__4790__auto___47091 < len__4789__auto___47090)){
args_arr__4810__auto__.push((arguments[i__4790__auto___47091]));

var G__47092 = (i__4790__auto___47091 + (1));
i__4790__auto___47091 = G__47092;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_47093 = (function (){var G__46399 = a;
if((!(typeof a === 'string'))){
return G__46399.toString();
} else {
return G__46399;
}
})();
var temp__5739__auto___47094 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___47094 == null)){
} else {
var sm_data_47095 = temp__5739__auto___47094;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_47095,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__46390_SHARP_){
return (p1__46390_SHARP_ + s_47093.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_47093], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__46400 = cljs.core.seq(xs);
var chunk__46401 = null;
var count__46402 = (0);
var i__46403 = (0);
while(true){
if((i__46403 < count__46402)){
var x = chunk__46401.cljs$core$IIndexed$_nth$arity$2(null,i__46403);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__47096 = seq__46400;
var G__47097 = chunk__46401;
var G__47098 = count__46402;
var G__47099 = (i__46403 + (1));
seq__46400 = G__47096;
chunk__46401 = G__47097;
count__46402 = G__47098;
i__46403 = G__47099;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46400);
if(temp__5735__auto__){
var seq__46400__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46400__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__46400__$1);
var G__47100 = cljs.core.chunk_rest(seq__46400__$1);
var G__47101 = c__4609__auto__;
var G__47102 = cljs.core.count(c__4609__auto__);
var G__47103 = (0);
seq__46400 = G__47100;
chunk__46401 = G__47101;
count__46402 = G__47102;
i__46403 = G__47103;
continue;
} else {
var x = cljs.core.first(seq__46400__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__47104 = cljs.core.next(seq__46400__$1);
var G__47105 = null;
var G__47106 = (0);
var G__47107 = (0);
seq__46400 = G__47104;
chunk__46401 = G__47105;
count__46402 = G__47106;
i__46403 = G__47107;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq46392){
var G__46393 = cljs.core.first(seq46392);
var seq46392__$1 = cljs.core.next(seq46392);
var G__46394 = cljs.core.first(seq46392__$1);
var seq46392__$2 = cljs.core.next(seq46392__$1);
var G__46395 = cljs.core.first(seq46392__$2);
var seq46392__$3 = cljs.core.next(seq46392__$2);
var G__46396 = cljs.core.first(seq46392__$3);
var seq46392__$4 = cljs.core.next(seq46392__$3);
var G__46397 = cljs.core.first(seq46392__$4);
var seq46392__$5 = cljs.core.next(seq46392__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46393,G__46394,G__46395,G__46396,G__46397,seq46392__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__46407){
var map__46408 = p__46407;
var map__46408__$1 = (((((!((map__46408 == null))))?(((((map__46408.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46408.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46408):map__46408);
var m = map__46408__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46408__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__46418 = arguments.length;
switch (G__46418) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___47109 = arguments.length;
var i__4790__auto___47110 = (0);
while(true){
if((i__4790__auto___47110 < len__4789__auto___47109)){
args_arr__4810__auto__.push((arguments[i__4790__auto___47110]));

var G__47111 = (i__4790__auto___47110 + (1));
i__4790__auto___47110 = G__47111;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__46421_47124 = cljs.core.seq(xs);
var chunk__46422_47125 = null;
var count__46423_47126 = (0);
var i__46424_47127 = (0);
while(true){
if((i__46424_47127 < count__46423_47126)){
var x_47128 = chunk__46422_47125.cljs$core$IIndexed$_nth$arity$2(null,i__46424_47127);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_47128);


var G__47129 = seq__46421_47124;
var G__47130 = chunk__46422_47125;
var G__47131 = count__46423_47126;
var G__47132 = (i__46424_47127 + (1));
seq__46421_47124 = G__47129;
chunk__46422_47125 = G__47130;
count__46423_47126 = G__47131;
i__46424_47127 = G__47132;
continue;
} else {
var temp__5735__auto___47133 = cljs.core.seq(seq__46421_47124);
if(temp__5735__auto___47133){
var seq__46421_47134__$1 = temp__5735__auto___47133;
if(cljs.core.chunked_seq_QMARK_(seq__46421_47134__$1)){
var c__4609__auto___47135 = cljs.core.chunk_first(seq__46421_47134__$1);
var G__47136 = cljs.core.chunk_rest(seq__46421_47134__$1);
var G__47137 = c__4609__auto___47135;
var G__47138 = cljs.core.count(c__4609__auto___47135);
var G__47139 = (0);
seq__46421_47124 = G__47136;
chunk__46422_47125 = G__47137;
count__46423_47126 = G__47138;
i__46424_47127 = G__47139;
continue;
} else {
var x_47140 = cljs.core.first(seq__46421_47134__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_47140);


var G__47141 = cljs.core.next(seq__46421_47134__$1);
var G__47142 = null;
var G__47143 = (0);
var G__47144 = (0);
seq__46421_47124 = G__47141;
chunk__46422_47125 = G__47142;
count__46423_47126 = G__47143;
i__46424_47127 = G__47144;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq46412){
var G__46413 = cljs.core.first(seq46412);
var seq46412__$1 = cljs.core.next(seq46412);
var G__46414 = cljs.core.first(seq46412__$1);
var seq46412__$2 = cljs.core.next(seq46412__$1);
var G__46415 = cljs.core.first(seq46412__$2);
var seq46412__$3 = cljs.core.next(seq46412__$2);
var G__46416 = cljs.core.first(seq46412__$3);
var seq46412__$4 = cljs.core.next(seq46412__$3);
var G__46417 = cljs.core.first(seq46412__$4);
var seq46412__$5 = cljs.core.next(seq46412__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46413,G__46414,G__46415,G__46416,G__46417,seq46412__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__46425_47154 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__46426_47155 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__46427_47156 = true;
var _STAR_print_fn_STAR__temp_val__46428_47157 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__46427_47156);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__46428_47157);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__46426_47155);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__46425_47154);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__46430 = cljs.core.get_global_hierarchy;
return (fexpr__46430.cljs$core$IFn$_invoke$arity$0 ? fexpr__46430.cljs$core$IFn$_invoke$arity$0() : fexpr__46430.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__46433 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46433,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46433,(1),null);
var G__46438 = ns;
var G__46439 = name;
var G__46440 = (function (){
var G__46441 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__46441) : cljs.compiler.emit_constant.call(null,G__46441));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__46438,G__46439,G__46440) : cljs.compiler.emit_record_value.call(null,G__46438,G__46439,G__46440));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__46446 = cljs.core.keys(x);
var G__46447 = cljs.core.vals(x);
var G__46448 = cljs.compiler.emit_constants_comma_sep;
var G__46449 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__46446,G__46447,G__46448,G__46449) : cljs.compiler.emit_map.call(null,G__46446,G__46447,G__46448,G__46449));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__46454 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__46455 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__46454,G__46455) : cljs.compiler.emit_with_meta.call(null,G__46454,G__46455));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__46458 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46458,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46458,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46458,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__46461 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__46461) : x.call(null,G__46461));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__46462 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__46462) : x.call(null,G__46462));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__46465 = items;
var G__46466 = (function (p1__46464_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__46464_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__46465,G__46466) : cljs.compiler.emit_js_object.call(null,G__46465,G__46466));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__46469){
var map__46470 = p__46469;
var map__46470__$1 = (((((!((map__46470 == null))))?(((((map__46470.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46470.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46470):map__46470);
var ast = map__46470__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46470__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46470__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46470__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__46473 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__46473__$1 = (((((!((map__46473 == null))))?(((((map__46473.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46473.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46473):map__46473);
var cenv = map__46473__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46473__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4185__auto__ = js_module_name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__46475 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4174__auto__ = (function (){var G__46478 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__46478) : cljs.compiler.es5_GT__EQ_.call(null,G__46478));
})();
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4174__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__46475,cljs.analyzer.es5_allowed);
} else {
return G__46475;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4185__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__46479 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__46479,reserved);
} else {
return G__46479;
}
})();
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__46480_47193 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__46480_47194__$1 = (((G__46480_47193 instanceof cljs.core.Keyword))?G__46480_47193.fqn:null);
switch (G__46480_47194__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4174__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__46481){
var map__46482 = p__46481;
var map__46482__$1 = (((((!((map__46482 == null))))?(((((map__46482.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46482.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46482):map__46482);
var arg = map__46482__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46482__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46482__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46482__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46482__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__46484 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__46484__$1 = (((((!((map__46484 == null))))?(((((map__46484.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46484.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46484):map__46484);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46484__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__46490){
var map__46491 = p__46490;
var map__46491__$1 = (((((!((map__46491 == null))))?(((((map__46491.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46491.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46491):map__46491);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46491__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46491__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46491__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__46493_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__46493_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__46495 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__46495) : comma_sep.call(null,G__46495));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__46496 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__46496) : comma_sep.call(null,G__46496));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__46497){
var map__46498 = p__46497;
var map__46498__$1 = (((((!((map__46498 == null))))?(((((map__46498.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46498.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46498):map__46498);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46498__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46498__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46498__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__46504){
var map__46505 = p__46504;
var map__46505__$1 = (((((!((map__46505 == null))))?(((((map__46505.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46505.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46505):map__46505);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46505__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46505__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__46507_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__46507_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__46509 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__46509) : comma_sep.call(null,G__46509));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__46510){
var map__46511 = p__46510;
var map__46511__$1 = (((((!((map__46511 == null))))?(((((map__46511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46511.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46511):map__46511);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46511__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46511__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___47212 = cljs.core.seq(items);
if(temp__5735__auto___47212){
var items_47213__$1 = temp__5735__auto___47212;
var vec__46513_47214 = items_47213__$1;
var seq__46514_47215 = cljs.core.seq(vec__46513_47214);
var first__46515_47216 = cljs.core.first(seq__46514_47215);
var seq__46514_47217__$1 = cljs.core.next(seq__46514_47215);
var vec__46516_47218 = first__46515_47216;
var k_47219 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46516_47218,(0),null);
var v_47220 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46516_47218,(1),null);
var r_47221 = seq__46514_47217__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_47219),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_47220) : emit_js_object_val.call(null,v_47220)));

var seq__46519_47222 = cljs.core.seq(r_47221);
var chunk__46520_47223 = null;
var count__46521_47224 = (0);
var i__46522_47225 = (0);
while(true){
if((i__46522_47225 < count__46521_47224)){
var vec__46529_47226 = chunk__46520_47223.cljs$core$IIndexed$_nth$arity$2(null,i__46522_47225);
var k_47227__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46529_47226,(0),null);
var v_47228__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46529_47226,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_47227__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_47228__$1) : emit_js_object_val.call(null,v_47228__$1)));


var G__47229 = seq__46519_47222;
var G__47230 = chunk__46520_47223;
var G__47231 = count__46521_47224;
var G__47232 = (i__46522_47225 + (1));
seq__46519_47222 = G__47229;
chunk__46520_47223 = G__47230;
count__46521_47224 = G__47231;
i__46522_47225 = G__47232;
continue;
} else {
var temp__5735__auto___47233__$1 = cljs.core.seq(seq__46519_47222);
if(temp__5735__auto___47233__$1){
var seq__46519_47234__$1 = temp__5735__auto___47233__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46519_47234__$1)){
var c__4609__auto___47235 = cljs.core.chunk_first(seq__46519_47234__$1);
var G__47236 = cljs.core.chunk_rest(seq__46519_47234__$1);
var G__47237 = c__4609__auto___47235;
var G__47238 = cljs.core.count(c__4609__auto___47235);
var G__47239 = (0);
seq__46519_47222 = G__47236;
chunk__46520_47223 = G__47237;
count__46521_47224 = G__47238;
i__46522_47225 = G__47239;
continue;
} else {
var vec__46532_47240 = cljs.core.first(seq__46519_47234__$1);
var k_47241__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46532_47240,(0),null);
var v_47242__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46532_47240,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_47241__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_47242__$1) : emit_js_object_val.call(null,v_47242__$1)));


var G__47243 = cljs.core.next(seq__46519_47234__$1);
var G__47244 = null;
var G__47245 = (0);
var G__47246 = (0);
seq__46519_47222 = G__47243;
chunk__46520_47223 = G__47244;
count__46521_47224 = G__47245;
i__46522_47225 = G__47246;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__46535){
var map__46536 = p__46535;
var map__46536__$1 = (((((!((map__46536 == null))))?(((((map__46536.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46536.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46536):map__46536);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46536__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46536__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46536__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__46538){
var map__46539 = p__46538;
var map__46539__$1 = (((((!((map__46539 == null))))?(((((map__46539.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46539.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46539):map__46539);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46539__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46539__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__46541){
var map__46542 = p__46541;
var map__46542__$1 = (((((!((map__46542 == null))))?(((((map__46542.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46542.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46542):map__46542);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46542__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__46544){
var map__46545 = p__46544;
var map__46545__$1 = (((((!((map__46545 == null))))?(((((map__46545.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46545.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46545):map__46545);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46545__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46545__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__46548 = cljs.analyzer.unwrap_quote(expr);
var map__46548__$1 = (((((!((map__46548 == null))))?(((((map__46548.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46548.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46548):map__46548);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46548__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46548__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46548__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4174__auto__ = form;
if(cljs.core.truth_(and__4174__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4174__auto__;
}
})():false);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__46551 = cljs.analyzer.unwrap_quote(expr);
var map__46551__$1 = (((((!((map__46551 == null))))?(((((map__46551.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46551.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46551):map__46551);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46551__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46551__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46551__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4185__auto__){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4185__auto__ = (function (){var fexpr__46554 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__46554.cljs$core$IFn$_invoke$arity$1 ? fexpr__46554.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__46554.call(null,tag));
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__46555){
var map__46556 = p__46555;
var map__46556__$1 = (((((!((map__46556 == null))))?(((((map__46556.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46556.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46556):map__46556);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46556__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46556__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46556__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46556__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46556__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4185__auto__ = unchecked;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__46561){
var map__46562 = p__46561;
var map__46562__$1 = (((((!((map__46562 == null))))?(((((map__46562.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46562.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46562):map__46562);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46562__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46562__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46562__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46562__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__46564_47264 = cljs.core.seq(nodes);
var chunk__46565_47265 = null;
var count__46566_47266 = (0);
var i__46567_47267 = (0);
while(true){
if((i__46567_47267 < count__46566_47266)){
var map__46590_47268 = chunk__46565_47265.cljs$core$IIndexed$_nth$arity$2(null,i__46567_47267);
var map__46590_47269__$1 = (((((!((map__46590_47268 == null))))?(((((map__46590_47268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46590_47268.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46590_47268):map__46590_47268);
var ts_47270 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46590_47269__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__46591_47271 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46590_47269__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__46591_47272__$1 = (((((!((map__46591_47271 == null))))?(((((map__46591_47271.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46591_47271.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46591_47271):map__46591_47271);
var then_47273 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46591_47272__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__46596_47279 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_47270));
var chunk__46597_47280 = null;
var count__46598_47281 = (0);
var i__46599_47282 = (0);
while(true){
if((i__46599_47282 < count__46598_47281)){
var test_47283 = chunk__46597_47280.cljs$core$IIndexed$_nth$arity$2(null,i__46599_47282);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_47283,":");


var G__47284 = seq__46596_47279;
var G__47285 = chunk__46597_47280;
var G__47286 = count__46598_47281;
var G__47287 = (i__46599_47282 + (1));
seq__46596_47279 = G__47284;
chunk__46597_47280 = G__47285;
count__46598_47281 = G__47286;
i__46599_47282 = G__47287;
continue;
} else {
var temp__5735__auto___47289 = cljs.core.seq(seq__46596_47279);
if(temp__5735__auto___47289){
var seq__46596_47290__$1 = temp__5735__auto___47289;
if(cljs.core.chunked_seq_QMARK_(seq__46596_47290__$1)){
var c__4609__auto___47291 = cljs.core.chunk_first(seq__46596_47290__$1);
var G__47292 = cljs.core.chunk_rest(seq__46596_47290__$1);
var G__47293 = c__4609__auto___47291;
var G__47294 = cljs.core.count(c__4609__auto___47291);
var G__47295 = (0);
seq__46596_47279 = G__47292;
chunk__46597_47280 = G__47293;
count__46598_47281 = G__47294;
i__46599_47282 = G__47295;
continue;
} else {
var test_47297 = cljs.core.first(seq__46596_47290__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_47297,":");


var G__47298 = cljs.core.next(seq__46596_47290__$1);
var G__47299 = null;
var G__47300 = (0);
var G__47301 = (0);
seq__46596_47279 = G__47298;
chunk__46597_47280 = G__47299;
count__46598_47281 = G__47300;
i__46599_47282 = G__47301;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_47273);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_47273);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__47302 = seq__46564_47264;
var G__47303 = chunk__46565_47265;
var G__47304 = count__46566_47266;
var G__47305 = (i__46567_47267 + (1));
seq__46564_47264 = G__47302;
chunk__46565_47265 = G__47303;
count__46566_47266 = G__47304;
i__46567_47267 = G__47305;
continue;
} else {
var temp__5735__auto___47306 = cljs.core.seq(seq__46564_47264);
if(temp__5735__auto___47306){
var seq__46564_47307__$1 = temp__5735__auto___47306;
if(cljs.core.chunked_seq_QMARK_(seq__46564_47307__$1)){
var c__4609__auto___47308 = cljs.core.chunk_first(seq__46564_47307__$1);
var G__47309 = cljs.core.chunk_rest(seq__46564_47307__$1);
var G__47310 = c__4609__auto___47308;
var G__47311 = cljs.core.count(c__4609__auto___47308);
var G__47312 = (0);
seq__46564_47264 = G__47309;
chunk__46565_47265 = G__47310;
count__46566_47266 = G__47311;
i__46567_47267 = G__47312;
continue;
} else {
var map__46614_47313 = cljs.core.first(seq__46564_47307__$1);
var map__46614_47314__$1 = (((((!((map__46614_47313 == null))))?(((((map__46614_47313.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46614_47313.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46614_47313):map__46614_47313);
var ts_47315 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46614_47314__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__46615_47316 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46614_47314__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__46615_47317__$1 = (((((!((map__46615_47316 == null))))?(((((map__46615_47316.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46615_47316.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46615_47316):map__46615_47316);
var then_47318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46615_47317__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__46618_47319 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_47315));
var chunk__46619_47320 = null;
var count__46620_47321 = (0);
var i__46621_47322 = (0);
while(true){
if((i__46621_47322 < count__46620_47321)){
var test_47323 = chunk__46619_47320.cljs$core$IIndexed$_nth$arity$2(null,i__46621_47322);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_47323,":");


var G__47324 = seq__46618_47319;
var G__47325 = chunk__46619_47320;
var G__47326 = count__46620_47321;
var G__47327 = (i__46621_47322 + (1));
seq__46618_47319 = G__47324;
chunk__46619_47320 = G__47325;
count__46620_47321 = G__47326;
i__46621_47322 = G__47327;
continue;
} else {
var temp__5735__auto___47328__$1 = cljs.core.seq(seq__46618_47319);
if(temp__5735__auto___47328__$1){
var seq__46618_47329__$1 = temp__5735__auto___47328__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46618_47329__$1)){
var c__4609__auto___47330 = cljs.core.chunk_first(seq__46618_47329__$1);
var G__47331 = cljs.core.chunk_rest(seq__46618_47329__$1);
var G__47332 = c__4609__auto___47330;
var G__47333 = cljs.core.count(c__4609__auto___47330);
var G__47334 = (0);
seq__46618_47319 = G__47331;
chunk__46619_47320 = G__47332;
count__46620_47321 = G__47333;
i__46621_47322 = G__47334;
continue;
} else {
var test_47335 = cljs.core.first(seq__46618_47329__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_47335,":");


var G__47336 = cljs.core.next(seq__46618_47329__$1);
var G__47337 = null;
var G__47338 = (0);
var G__47339 = (0);
seq__46618_47319 = G__47336;
chunk__46619_47320 = G__47337;
count__46620_47321 = G__47338;
i__46621_47322 = G__47339;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_47318);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_47318);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__47340 = cljs.core.next(seq__46564_47307__$1);
var G__47341 = null;
var G__47342 = (0);
var G__47343 = (0);
seq__46564_47264 = G__47340;
chunk__46565_47265 = G__47341;
count__46566_47266 = G__47342;
i__46567_47267 = G__47343;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__46622){
var map__46623 = p__46622;
var map__46623__$1 = (((((!((map__46623 == null))))?(((((map__46623.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46623.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46623):map__46623);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46623__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46623__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__46628 = env;
var G__46629 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__46628,G__46629) : cljs.compiler.resolve_type.call(null,G__46628,G__46629));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__46630 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46630,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46630,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__46625_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__46625_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__46625_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__46633 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__46633,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__46633;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__46636 = env;
var G__46637 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__46636,G__46637) : cljs.compiler.resolve_type.call(null,G__46636,G__46637));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46638_SHARP_){
return cljs.compiler.resolve_type(env,p1__46638_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__46639 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__46640 = cljs.core.seq(vec__46639);
var first__46641 = cljs.core.first(seq__46640);
var seq__46640__$1 = cljs.core.next(seq__46640);
var p = first__46641;
var first__46641__$1 = cljs.core.first(seq__46640__$1);
var seq__46640__$2 = cljs.core.next(seq__46640__$1);
var ts = first__46641__$1;
var first__46641__$2 = cljs.core.first(seq__46640__$2);
var seq__46640__$3 = cljs.core.next(seq__46640__$2);
var n = first__46641__$2;
var xs = seq__46640__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__46642 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__46643 = cljs.core.seq(vec__46642);
var first__46644 = cljs.core.first(seq__46643);
var seq__46643__$1 = cljs.core.next(seq__46643);
var p = first__46644;
var first__46644__$1 = cljs.core.first(seq__46643__$1);
var seq__46643__$2 = cljs.core.next(seq__46643__$1);
var ts = first__46644__$1;
var xs = seq__46643__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__46646 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__46645 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__46645.cljs$core$IFn$_invoke$arity$1 ? fexpr__46645.cljs$core$IFn$_invoke$arity$1(G__46646) : fexpr__46645.call(null,G__46646));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__46649 = arguments.length;
switch (G__46649) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__46658 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46647_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__46647_SHARP_);
} else {
return p1__46647_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__46659 = cljs.core.seq(vec__46658);
var first__46660 = cljs.core.first(seq__46659);
var seq__46659__$1 = cljs.core.next(seq__46659);
var x = first__46660;
var ys = seq__46659__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__46661 = cljs.core.seq(ys);
var chunk__46662 = null;
var count__46663 = (0);
var i__46664 = (0);
while(true){
if((i__46664 < count__46663)){
var next_line = chunk__46662.cljs$core$IIndexed$_nth$arity$2(null,i__46664);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__47347 = seq__46661;
var G__47348 = chunk__46662;
var G__47349 = count__46663;
var G__47350 = (i__46664 + (1));
seq__46661 = G__47347;
chunk__46662 = G__47348;
count__46663 = G__47349;
i__46664 = G__47350;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46661);
if(temp__5735__auto__){
var seq__46661__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46661__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__46661__$1);
var G__47351 = cljs.core.chunk_rest(seq__46661__$1);
var G__47352 = c__4609__auto__;
var G__47353 = cljs.core.count(c__4609__auto__);
var G__47354 = (0);
seq__46661 = G__47351;
chunk__46662 = G__47352;
count__46663 = G__47353;
i__46664 = G__47354;
continue;
} else {
var next_line = cljs.core.first(seq__46661__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__47355 = cljs.core.next(seq__46661__$1);
var G__47356 = null;
var G__47357 = (0);
var G__47358 = (0);
seq__46661 = G__47355;
chunk__46662 = G__47356;
count__46663 = G__47357;
i__46664 = G__47358;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__46669_47359 = cljs.core.seq(docs__$2);
var chunk__46670_47360 = null;
var count__46671_47361 = (0);
var i__46672_47362 = (0);
while(true){
if((i__46672_47362 < count__46671_47361)){
var e_47363 = chunk__46670_47360.cljs$core$IIndexed$_nth$arity$2(null,i__46672_47362);
if(cljs.core.truth_(e_47363)){
print_comment_lines(e_47363);
} else {
}


var G__47364 = seq__46669_47359;
var G__47365 = chunk__46670_47360;
var G__47366 = count__46671_47361;
var G__47367 = (i__46672_47362 + (1));
seq__46669_47359 = G__47364;
chunk__46670_47360 = G__47365;
count__46671_47361 = G__47366;
i__46672_47362 = G__47367;
continue;
} else {
var temp__5735__auto___47368 = cljs.core.seq(seq__46669_47359);
if(temp__5735__auto___47368){
var seq__46669_47369__$1 = temp__5735__auto___47368;
if(cljs.core.chunked_seq_QMARK_(seq__46669_47369__$1)){
var c__4609__auto___47370 = cljs.core.chunk_first(seq__46669_47369__$1);
var G__47371 = cljs.core.chunk_rest(seq__46669_47369__$1);
var G__47372 = c__4609__auto___47370;
var G__47373 = cljs.core.count(c__4609__auto___47370);
var G__47374 = (0);
seq__46669_47359 = G__47371;
chunk__46670_47360 = G__47372;
count__46671_47361 = G__47373;
i__46672_47362 = G__47374;
continue;
} else {
var e_47375 = cljs.core.first(seq__46669_47369__$1);
if(cljs.core.truth_(e_47375)){
print_comment_lines(e_47375);
} else {
}


var G__47376 = cljs.core.next(seq__46669_47369__$1);
var G__47377 = null;
var G__47378 = (0);
var G__47379 = (0);
seq__46669_47359 = G__47376;
chunk__46670_47360 = G__47377;
count__46671_47361 = G__47378;
i__46672_47362 = G__47379;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4174__auto__ = cljs.core.some((function (p1__46674_SHARP_){
return goog.string.startsWith(p1__46674_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = opts;
if(cljs.core.truth_(and__4174__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__46675){
var map__46676 = p__46675;
var map__46676__$1 = (((((!((map__46676 == null))))?(((((map__46676.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46676.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46676):map__46676);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"test","test",577538877));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4185__auto__ = init;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
return test;
} else {
return and__4174__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__46678){
var map__46679 = p__46678;
var map__46679__$1 = (((((!((map__46679 == null))))?(((((map__46679.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46679.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46679):map__46679);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46679__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46679__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46679__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__46681_47380 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__46682_47381 = null;
var count__46683_47382 = (0);
var i__46684_47383 = (0);
while(true){
if((i__46684_47383 < count__46683_47382)){
var vec__46691_47384 = chunk__46682_47381.cljs$core$IIndexed$_nth$arity$2(null,i__46684_47383);
var i_47385 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46691_47384,(0),null);
var param_47386 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46691_47384,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_47386);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__47387 = seq__46681_47380;
var G__47388 = chunk__46682_47381;
var G__47389 = count__46683_47382;
var G__47390 = (i__46684_47383 + (1));
seq__46681_47380 = G__47387;
chunk__46682_47381 = G__47388;
count__46683_47382 = G__47389;
i__46684_47383 = G__47390;
continue;
} else {
var temp__5735__auto___47391 = cljs.core.seq(seq__46681_47380);
if(temp__5735__auto___47391){
var seq__46681_47392__$1 = temp__5735__auto___47391;
if(cljs.core.chunked_seq_QMARK_(seq__46681_47392__$1)){
var c__4609__auto___47393 = cljs.core.chunk_first(seq__46681_47392__$1);
var G__47394 = cljs.core.chunk_rest(seq__46681_47392__$1);
var G__47395 = c__4609__auto___47393;
var G__47396 = cljs.core.count(c__4609__auto___47393);
var G__47397 = (0);
seq__46681_47380 = G__47394;
chunk__46682_47381 = G__47395;
count__46683_47382 = G__47396;
i__46684_47383 = G__47397;
continue;
} else {
var vec__46694_47398 = cljs.core.first(seq__46681_47392__$1);
var i_47399 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46694_47398,(0),null);
var param_47400 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46694_47398,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_47400);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__47401 = cljs.core.next(seq__46681_47392__$1);
var G__47402 = null;
var G__47403 = (0);
var G__47404 = (0);
seq__46681_47380 = G__47401;
chunk__46682_47381 = G__47402;
count__46683_47382 = G__47403;
i__46684_47383 = G__47404;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__46697_47408 = cljs.core.seq(params);
var chunk__46698_47409 = null;
var count__46699_47410 = (0);
var i__46700_47411 = (0);
while(true){
if((i__46700_47411 < count__46699_47410)){
var param_47412 = chunk__46698_47409.cljs$core$IIndexed$_nth$arity$2(null,i__46700_47411);
cljs.compiler.emit(param_47412);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47412,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47413 = seq__46697_47408;
var G__47414 = chunk__46698_47409;
var G__47415 = count__46699_47410;
var G__47416 = (i__46700_47411 + (1));
seq__46697_47408 = G__47413;
chunk__46698_47409 = G__47414;
count__46699_47410 = G__47415;
i__46700_47411 = G__47416;
continue;
} else {
var temp__5735__auto___47417 = cljs.core.seq(seq__46697_47408);
if(temp__5735__auto___47417){
var seq__46697_47418__$1 = temp__5735__auto___47417;
if(cljs.core.chunked_seq_QMARK_(seq__46697_47418__$1)){
var c__4609__auto___47419 = cljs.core.chunk_first(seq__46697_47418__$1);
var G__47420 = cljs.core.chunk_rest(seq__46697_47418__$1);
var G__47421 = c__4609__auto___47419;
var G__47422 = cljs.core.count(c__4609__auto___47419);
var G__47423 = (0);
seq__46697_47408 = G__47420;
chunk__46698_47409 = G__47421;
count__46699_47410 = G__47422;
i__46700_47411 = G__47423;
continue;
} else {
var param_47425 = cljs.core.first(seq__46697_47418__$1);
cljs.compiler.emit(param_47425);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47425,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47426 = cljs.core.next(seq__46697_47418__$1);
var G__47427 = null;
var G__47428 = (0);
var G__47429 = (0);
seq__46697_47408 = G__47426;
chunk__46698_47409 = G__47427;
count__46699_47410 = G__47428;
i__46700_47411 = G__47429;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__46701_47431 = cljs.core.seq(params);
var chunk__46702_47432 = null;
var count__46703_47433 = (0);
var i__46704_47434 = (0);
while(true){
if((i__46704_47434 < count__46703_47433)){
var param_47435 = chunk__46702_47432.cljs$core$IIndexed$_nth$arity$2(null,i__46704_47434);
cljs.compiler.emit(param_47435);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47435,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47436 = seq__46701_47431;
var G__47437 = chunk__46702_47432;
var G__47438 = count__46703_47433;
var G__47439 = (i__46704_47434 + (1));
seq__46701_47431 = G__47436;
chunk__46702_47432 = G__47437;
count__46703_47433 = G__47438;
i__46704_47434 = G__47439;
continue;
} else {
var temp__5735__auto___47440 = cljs.core.seq(seq__46701_47431);
if(temp__5735__auto___47440){
var seq__46701_47441__$1 = temp__5735__auto___47440;
if(cljs.core.chunked_seq_QMARK_(seq__46701_47441__$1)){
var c__4609__auto___47442 = cljs.core.chunk_first(seq__46701_47441__$1);
var G__47443 = cljs.core.chunk_rest(seq__46701_47441__$1);
var G__47444 = c__4609__auto___47442;
var G__47445 = cljs.core.count(c__4609__auto___47442);
var G__47446 = (0);
seq__46701_47431 = G__47443;
chunk__46702_47432 = G__47444;
count__46703_47433 = G__47445;
i__46704_47434 = G__47446;
continue;
} else {
var param_47447 = cljs.core.first(seq__46701_47441__$1);
cljs.compiler.emit(param_47447);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47447,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47448 = cljs.core.next(seq__46701_47441__$1);
var G__47449 = null;
var G__47450 = (0);
var G__47451 = (0);
seq__46701_47431 = G__47448;
chunk__46702_47432 = G__47449;
count__46703_47433 = G__47450;
i__46704_47434 = G__47451;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__46705 = cljs.core.seq(params);
var chunk__46706 = null;
var count__46707 = (0);
var i__46708 = (0);
while(true){
if((i__46708 < count__46707)){
var param = chunk__46706.cljs$core$IIndexed$_nth$arity$2(null,i__46708);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47452 = seq__46705;
var G__47453 = chunk__46706;
var G__47454 = count__46707;
var G__47455 = (i__46708 + (1));
seq__46705 = G__47452;
chunk__46706 = G__47453;
count__46707 = G__47454;
i__46708 = G__47455;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46705);
if(temp__5735__auto__){
var seq__46705__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46705__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__46705__$1);
var G__47456 = cljs.core.chunk_rest(seq__46705__$1);
var G__47457 = c__4609__auto__;
var G__47458 = cljs.core.count(c__4609__auto__);
var G__47459 = (0);
seq__46705 = G__47456;
chunk__46706 = G__47457;
count__46707 = G__47458;
i__46708 = G__47459;
continue;
} else {
var param = cljs.core.first(seq__46705__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47460 = cljs.core.next(seq__46705__$1);
var G__47461 = null;
var G__47462 = (0);
var G__47463 = (0);
seq__46705 = G__47460;
chunk__46706 = G__47461;
count__46707 = G__47462;
i__46708 = G__47463;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__46709){
var map__46710 = p__46709;
var map__46710__$1 = (((((!((map__46710 == null))))?(((((map__46710.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46710.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46710):map__46710);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46710__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46710__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46710__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46710__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46710__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46710__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__46712){
var map__46713 = p__46712;
var map__46713__$1 = (((((!((map__46713 == null))))?(((((map__46713.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46713.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46713):map__46713);
var f = map__46713__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46713__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46713__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46713__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46713__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46713__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46713__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46713__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46713__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_47464__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_47465 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_47464__$1);
var delegate_name_47466 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_47465),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_47466," = function (");

var seq__46715_47467 = cljs.core.seq(params);
var chunk__46716_47468 = null;
var count__46717_47469 = (0);
var i__46718_47470 = (0);
while(true){
if((i__46718_47470 < count__46717_47469)){
var param_47471 = chunk__46716_47468.cljs$core$IIndexed$_nth$arity$2(null,i__46718_47470);
cljs.compiler.emit(param_47471);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47471,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47472 = seq__46715_47467;
var G__47473 = chunk__46716_47468;
var G__47474 = count__46717_47469;
var G__47475 = (i__46718_47470 + (1));
seq__46715_47467 = G__47472;
chunk__46716_47468 = G__47473;
count__46717_47469 = G__47474;
i__46718_47470 = G__47475;
continue;
} else {
var temp__5735__auto___47476 = cljs.core.seq(seq__46715_47467);
if(temp__5735__auto___47476){
var seq__46715_47477__$1 = temp__5735__auto___47476;
if(cljs.core.chunked_seq_QMARK_(seq__46715_47477__$1)){
var c__4609__auto___47478 = cljs.core.chunk_first(seq__46715_47477__$1);
var G__47479 = cljs.core.chunk_rest(seq__46715_47477__$1);
var G__47480 = c__4609__auto___47478;
var G__47481 = cljs.core.count(c__4609__auto___47478);
var G__47482 = (0);
seq__46715_47467 = G__47479;
chunk__46716_47468 = G__47480;
count__46717_47469 = G__47481;
i__46718_47470 = G__47482;
continue;
} else {
var param_47483 = cljs.core.first(seq__46715_47477__$1);
cljs.compiler.emit(param_47483);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47483,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47484 = cljs.core.next(seq__46715_47477__$1);
var G__47485 = null;
var G__47486 = (0);
var G__47487 = (0);
seq__46715_47467 = G__47484;
chunk__46716_47468 = G__47485;
count__46717_47469 = G__47486;
i__46718_47470 = G__47487;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_47465," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_47488 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_47488,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_47466,".call(this,");

var seq__46719_47489 = cljs.core.seq(params);
var chunk__46720_47490 = null;
var count__46721_47491 = (0);
var i__46722_47492 = (0);
while(true){
if((i__46722_47492 < count__46721_47491)){
var param_47493 = chunk__46720_47490.cljs$core$IIndexed$_nth$arity$2(null,i__46722_47492);
cljs.compiler.emit(param_47493);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47493,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47494 = seq__46719_47489;
var G__47495 = chunk__46720_47490;
var G__47496 = count__46721_47491;
var G__47497 = (i__46722_47492 + (1));
seq__46719_47489 = G__47494;
chunk__46720_47490 = G__47495;
count__46721_47491 = G__47496;
i__46722_47492 = G__47497;
continue;
} else {
var temp__5735__auto___47498 = cljs.core.seq(seq__46719_47489);
if(temp__5735__auto___47498){
var seq__46719_47499__$1 = temp__5735__auto___47498;
if(cljs.core.chunked_seq_QMARK_(seq__46719_47499__$1)){
var c__4609__auto___47500 = cljs.core.chunk_first(seq__46719_47499__$1);
var G__47501 = cljs.core.chunk_rest(seq__46719_47499__$1);
var G__47502 = c__4609__auto___47500;
var G__47503 = cljs.core.count(c__4609__auto___47500);
var G__47504 = (0);
seq__46719_47489 = G__47501;
chunk__46720_47490 = G__47502;
count__46721_47491 = G__47503;
i__46722_47492 = G__47504;
continue;
} else {
var param_47505 = cljs.core.first(seq__46719_47499__$1);
cljs.compiler.emit(param_47505);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47505,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47506 = cljs.core.next(seq__46719_47499__$1);
var G__47507 = null;
var G__47508 = (0);
var G__47509 = (0);
seq__46719_47489 = G__47506;
chunk__46720_47490 = G__47507;
count__46721_47491 = G__47508;
i__46722_47492 = G__47509;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47465,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_47465,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_47464__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47465,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_47466,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_47465,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__46734){
var map__46735 = p__46734;
var map__46735__$1 = (((((!((map__46735 == null))))?(((((map__46735.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46735.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46735):map__46735);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__46730_SHARP_){
var and__4174__auto__ = p1__46730_SHARP_;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__46730_SHARP_));
} else {
return and__4174__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4185__auto__ = in_loop;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_47510__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_47511 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_47510__$1);
var maxparams_47512 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_47513 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_47511),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_47514 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__46732_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__46732_SHARP_)));
}),cljs.core.seq(mmap_47513));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_47511," = null;");

var seq__46737_47523 = cljs.core.seq(ms_47514);
var chunk__46738_47524 = null;
var count__46739_47525 = (0);
var i__46740_47526 = (0);
while(true){
if((i__46740_47526 < count__46739_47525)){
var vec__46747_47527 = chunk__46738_47524.cljs$core$IIndexed$_nth$arity$2(null,i__46740_47526);
var n_47528 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46747_47527,(0),null);
var meth_47529 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46747_47527,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_47528," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47529))){
cljs.compiler.emit_variadic_fn_method(meth_47529);
} else {
cljs.compiler.emit_fn_method(meth_47529);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__47530 = seq__46737_47523;
var G__47531 = chunk__46738_47524;
var G__47532 = count__46739_47525;
var G__47533 = (i__46740_47526 + (1));
seq__46737_47523 = G__47530;
chunk__46738_47524 = G__47531;
count__46739_47525 = G__47532;
i__46740_47526 = G__47533;
continue;
} else {
var temp__5735__auto___47534 = cljs.core.seq(seq__46737_47523);
if(temp__5735__auto___47534){
var seq__46737_47535__$1 = temp__5735__auto___47534;
if(cljs.core.chunked_seq_QMARK_(seq__46737_47535__$1)){
var c__4609__auto___47536 = cljs.core.chunk_first(seq__46737_47535__$1);
var G__47537 = cljs.core.chunk_rest(seq__46737_47535__$1);
var G__47538 = c__4609__auto___47536;
var G__47539 = cljs.core.count(c__4609__auto___47536);
var G__47540 = (0);
seq__46737_47523 = G__47537;
chunk__46738_47524 = G__47538;
count__46739_47525 = G__47539;
i__46740_47526 = G__47540;
continue;
} else {
var vec__46750_47541 = cljs.core.first(seq__46737_47535__$1);
var n_47542 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46750_47541,(0),null);
var meth_47543 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46750_47541,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_47542," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47543))){
cljs.compiler.emit_variadic_fn_method(meth_47543);
} else {
cljs.compiler.emit_fn_method(meth_47543);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__47546 = cljs.core.next(seq__46737_47535__$1);
var G__47547 = null;
var G__47548 = (0);
var G__47549 = (0);
seq__46737_47523 = G__47546;
chunk__46738_47524 = G__47547;
count__46739_47525 = G__47548;
i__46740_47526 = G__47549;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47511," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_47512),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_47512)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_47512));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__46753_47550 = cljs.core.seq(ms_47514);
var chunk__46754_47551 = null;
var count__46755_47552 = (0);
var i__46756_47553 = (0);
while(true){
if((i__46756_47553 < count__46755_47552)){
var vec__46763_47554 = chunk__46754_47551.cljs$core$IIndexed$_nth$arity$2(null,i__46756_47553);
var n_47555 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46763_47554,(0),null);
var meth_47556 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46763_47554,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47556))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_47557 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_47557," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_47558 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_47557," = new cljs.core.IndexedSeq(",a_47558,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_47555,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_47512)),(((cljs.core.count(maxparams_47512) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_47557,");"], 0));
} else {
var pcnt_47559 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_47556));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_47559,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_47555,".call(this",(((pcnt_47559 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_47559,maxparams_47512)),null,(1),null)),(2),null))),");");
}


var G__47560 = seq__46753_47550;
var G__47561 = chunk__46754_47551;
var G__47562 = count__46755_47552;
var G__47563 = (i__46756_47553 + (1));
seq__46753_47550 = G__47560;
chunk__46754_47551 = G__47561;
count__46755_47552 = G__47562;
i__46756_47553 = G__47563;
continue;
} else {
var temp__5735__auto___47564 = cljs.core.seq(seq__46753_47550);
if(temp__5735__auto___47564){
var seq__46753_47565__$1 = temp__5735__auto___47564;
if(cljs.core.chunked_seq_QMARK_(seq__46753_47565__$1)){
var c__4609__auto___47566 = cljs.core.chunk_first(seq__46753_47565__$1);
var G__47567 = cljs.core.chunk_rest(seq__46753_47565__$1);
var G__47568 = c__4609__auto___47566;
var G__47569 = cljs.core.count(c__4609__auto___47566);
var G__47570 = (0);
seq__46753_47550 = G__47567;
chunk__46754_47551 = G__47568;
count__46755_47552 = G__47569;
i__46756_47553 = G__47570;
continue;
} else {
var vec__46766_47571 = cljs.core.first(seq__46753_47565__$1);
var n_47572 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46766_47571,(0),null);
var meth_47573 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46766_47571,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47573))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_47574 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_47574," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_47575 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_47574," = new cljs.core.IndexedSeq(",a_47575,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_47572,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_47512)),(((cljs.core.count(maxparams_47512) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_47574,");"], 0));
} else {
var pcnt_47576 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_47573));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_47576,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_47572,".call(this",(((pcnt_47576 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_47576,maxparams_47512)),null,(1),null)),(2),null))),");");
}


var G__47578 = cljs.core.next(seq__46753_47565__$1);
var G__47579 = null;
var G__47580 = (0);
var G__47581 = (0);
seq__46753_47550 = G__47578;
chunk__46754_47551 = G__47579;
count__46755_47552 = G__47580;
i__46756_47553 = G__47581;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_47582 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_47514)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_47582,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47511,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47511,".cljs$lang$applyTo = ",cljs.core.some((function (p1__46733_SHARP_){
var vec__46769 = p1__46733_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46769,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46769,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_47514),".cljs$lang$applyTo;");
} else {
}

var seq__46772_47583 = cljs.core.seq(ms_47514);
var chunk__46773_47584 = null;
var count__46774_47585 = (0);
var i__46775_47586 = (0);
while(true){
if((i__46775_47586 < count__46774_47585)){
var vec__46783_47587 = chunk__46773_47584.cljs$core$IIndexed$_nth$arity$2(null,i__46775_47586);
var n_47588 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46783_47587,(0),null);
var meth_47589 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46783_47587,(1),null);
var c_47590 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_47589));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47589))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47511,".cljs$core$IFn$_invoke$arity$variadic = ",n_47588,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_47511,".cljs$core$IFn$_invoke$arity$",c_47590," = ",n_47588,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__47591 = seq__46772_47583;
var G__47592 = chunk__46773_47584;
var G__47593 = count__46774_47585;
var G__47594 = (i__46775_47586 + (1));
seq__46772_47583 = G__47591;
chunk__46773_47584 = G__47592;
count__46774_47585 = G__47593;
i__46775_47586 = G__47594;
continue;
} else {
var temp__5735__auto___47595 = cljs.core.seq(seq__46772_47583);
if(temp__5735__auto___47595){
var seq__46772_47596__$1 = temp__5735__auto___47595;
if(cljs.core.chunked_seq_QMARK_(seq__46772_47596__$1)){
var c__4609__auto___47597 = cljs.core.chunk_first(seq__46772_47596__$1);
var G__47598 = cljs.core.chunk_rest(seq__46772_47596__$1);
var G__47599 = c__4609__auto___47597;
var G__47600 = cljs.core.count(c__4609__auto___47597);
var G__47601 = (0);
seq__46772_47583 = G__47598;
chunk__46773_47584 = G__47599;
count__46774_47585 = G__47600;
i__46775_47586 = G__47601;
continue;
} else {
var vec__46786_47602 = cljs.core.first(seq__46772_47596__$1);
var n_47603 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46786_47602,(0),null);
var meth_47604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46786_47602,(1),null);
var c_47605 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_47604));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47604))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47511,".cljs$core$IFn$_invoke$arity$variadic = ",n_47603,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_47511,".cljs$core$IFn$_invoke$arity$",c_47605," = ",n_47603,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__47606 = cljs.core.next(seq__46772_47596__$1);
var G__47607 = null;
var G__47608 = (0);
var G__47609 = (0);
seq__46772_47583 = G__47606;
chunk__46773_47584 = G__47607;
count__46774_47585 = G__47608;
i__46775_47586 = G__47609;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_47511,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__46790){
var map__46791 = p__46790;
var map__46791__$1 = (((((!((map__46791 == null))))?(((((map__46791.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46791.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46791):map__46791);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46791__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46791__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46791__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__46793_47610 = cljs.core.seq(statements);
var chunk__46794_47611 = null;
var count__46795_47612 = (0);
var i__46796_47613 = (0);
while(true){
if((i__46796_47613 < count__46795_47612)){
var s_47614 = chunk__46794_47611.cljs$core$IIndexed$_nth$arity$2(null,i__46796_47613);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_47614);


var G__47615 = seq__46793_47610;
var G__47616 = chunk__46794_47611;
var G__47617 = count__46795_47612;
var G__47618 = (i__46796_47613 + (1));
seq__46793_47610 = G__47615;
chunk__46794_47611 = G__47616;
count__46795_47612 = G__47617;
i__46796_47613 = G__47618;
continue;
} else {
var temp__5735__auto___47619 = cljs.core.seq(seq__46793_47610);
if(temp__5735__auto___47619){
var seq__46793_47620__$1 = temp__5735__auto___47619;
if(cljs.core.chunked_seq_QMARK_(seq__46793_47620__$1)){
var c__4609__auto___47621 = cljs.core.chunk_first(seq__46793_47620__$1);
var G__47622 = cljs.core.chunk_rest(seq__46793_47620__$1);
var G__47623 = c__4609__auto___47621;
var G__47624 = cljs.core.count(c__4609__auto___47621);
var G__47625 = (0);
seq__46793_47610 = G__47622;
chunk__46794_47611 = G__47623;
count__46795_47612 = G__47624;
i__46796_47613 = G__47625;
continue;
} else {
var s_47626 = cljs.core.first(seq__46793_47620__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_47626);


var G__47627 = cljs.core.next(seq__46793_47620__$1);
var G__47628 = null;
var G__47629 = (0);
var G__47630 = (0);
seq__46793_47610 = G__47627;
chunk__46794_47611 = G__47628;
count__46795_47612 = G__47629;
i__46796_47613 = G__47630;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__46799){
var map__46800 = p__46799;
var map__46800__$1 = (((((!((map__46800 == null))))?(((((map__46800.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46800.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46800):map__46800);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46800__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46800__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46800__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46800__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46800__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__46804,is_loop){
var map__46805 = p__46804;
var map__46805__$1 = (((((!((map__46805 == null))))?(((((map__46805.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46805.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46805):map__46805);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46805__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46805__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46805__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__46807_47631 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__46808_47632 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__46808_47632);

try{var seq__46809_47633 = cljs.core.seq(bindings);
var chunk__46810_47634 = null;
var count__46811_47635 = (0);
var i__46812_47636 = (0);
while(true){
if((i__46812_47636 < count__46811_47635)){
var map__46817_47637 = chunk__46810_47634.cljs$core$IIndexed$_nth$arity$2(null,i__46812_47636);
var map__46817_47638__$1 = (((((!((map__46817_47637 == null))))?(((((map__46817_47637.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46817_47637.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46817_47637):map__46817_47637);
var binding_47639 = map__46817_47638__$1;
var init_47640 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46817_47638__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_47639);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_47640,";");


var G__47641 = seq__46809_47633;
var G__47642 = chunk__46810_47634;
var G__47643 = count__46811_47635;
var G__47644 = (i__46812_47636 + (1));
seq__46809_47633 = G__47641;
chunk__46810_47634 = G__47642;
count__46811_47635 = G__47643;
i__46812_47636 = G__47644;
continue;
} else {
var temp__5735__auto___47645 = cljs.core.seq(seq__46809_47633);
if(temp__5735__auto___47645){
var seq__46809_47646__$1 = temp__5735__auto___47645;
if(cljs.core.chunked_seq_QMARK_(seq__46809_47646__$1)){
var c__4609__auto___47647 = cljs.core.chunk_first(seq__46809_47646__$1);
var G__47648 = cljs.core.chunk_rest(seq__46809_47646__$1);
var G__47649 = c__4609__auto___47647;
var G__47650 = cljs.core.count(c__4609__auto___47647);
var G__47651 = (0);
seq__46809_47633 = G__47648;
chunk__46810_47634 = G__47649;
count__46811_47635 = G__47650;
i__46812_47636 = G__47651;
continue;
} else {
var map__46819_47652 = cljs.core.first(seq__46809_47646__$1);
var map__46819_47653__$1 = (((((!((map__46819_47652 == null))))?(((((map__46819_47652.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46819_47652.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46819_47652):map__46819_47652);
var binding_47654 = map__46819_47653__$1;
var init_47655 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46819_47653__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_47654);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_47655,";");


var G__47657 = cljs.core.next(seq__46809_47646__$1);
var G__47658 = null;
var G__47659 = (0);
var G__47660 = (0);
seq__46809_47633 = G__47657;
chunk__46810_47634 = G__47658;
count__46811_47635 = G__47659;
i__46812_47636 = G__47660;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__46807_47631);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__46823){
var map__46824 = p__46823;
var map__46824__$1 = (((((!((map__46824 == null))))?(((((map__46824.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46824.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46824):map__46824);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46824__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46824__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46824__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4666__auto___47661 = cljs.core.count(exprs);
var i_47662 = (0);
while(true){
if((i_47662 < n__4666__auto___47661)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_47662) : temps.call(null,i_47662))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_47662) : exprs.call(null,i_47662)),";");

var G__47663 = (i_47662 + (1));
i_47662 = G__47663;
continue;
} else {
}
break;
}

var n__4666__auto___47664 = cljs.core.count(exprs);
var i_47665 = (0);
while(true){
if((i_47665 < n__4666__auto___47664)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_47665) : params.call(null,i_47665)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_47665) : temps.call(null,i_47665)),";");

var G__47666 = (i_47665 + (1));
i_47665 = G__47666;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__46826){
var map__46827 = p__46826;
var map__46827__$1 = (((((!((map__46827 == null))))?(((((map__46827.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46827.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46827):map__46827);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46827__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46827__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46827__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__46829_47667 = cljs.core.seq(bindings);
var chunk__46830_47668 = null;
var count__46831_47669 = (0);
var i__46832_47670 = (0);
while(true){
if((i__46832_47670 < count__46831_47669)){
var map__46837_47671 = chunk__46830_47668.cljs$core$IIndexed$_nth$arity$2(null,i__46832_47670);
var map__46837_47672__$1 = (((((!((map__46837_47671 == null))))?(((((map__46837_47671.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46837_47671.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46837_47671):map__46837_47671);
var binding_47673 = map__46837_47672__$1;
var init_47674 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46837_47672__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_47673)," = ",init_47674,";");


var G__47675 = seq__46829_47667;
var G__47676 = chunk__46830_47668;
var G__47677 = count__46831_47669;
var G__47678 = (i__46832_47670 + (1));
seq__46829_47667 = G__47675;
chunk__46830_47668 = G__47676;
count__46831_47669 = G__47677;
i__46832_47670 = G__47678;
continue;
} else {
var temp__5735__auto___47679 = cljs.core.seq(seq__46829_47667);
if(temp__5735__auto___47679){
var seq__46829_47680__$1 = temp__5735__auto___47679;
if(cljs.core.chunked_seq_QMARK_(seq__46829_47680__$1)){
var c__4609__auto___47681 = cljs.core.chunk_first(seq__46829_47680__$1);
var G__47682 = cljs.core.chunk_rest(seq__46829_47680__$1);
var G__47683 = c__4609__auto___47681;
var G__47684 = cljs.core.count(c__4609__auto___47681);
var G__47685 = (0);
seq__46829_47667 = G__47682;
chunk__46830_47668 = G__47683;
count__46831_47669 = G__47684;
i__46832_47670 = G__47685;
continue;
} else {
var map__46839_47686 = cljs.core.first(seq__46829_47680__$1);
var map__46839_47687__$1 = (((((!((map__46839_47686 == null))))?(((((map__46839_47686.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46839_47686.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46839_47686):map__46839_47686);
var binding_47688 = map__46839_47687__$1;
var init_47689 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46839_47687__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_47688)," = ",init_47689,";");


var G__47690 = cljs.core.next(seq__46829_47680__$1);
var G__47691 = null;
var G__47692 = (0);
var G__47693 = (0);
seq__46829_47667 = G__47690;
chunk__46830_47668 = G__47691;
count__46831_47669 = G__47692;
i__46832_47670 = G__47693;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__46843){
var map__46844 = p__46843;
var map__46844__$1 = (((((!((map__46844 == null))))?(((((map__46844.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46844.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46844):map__46844);
var expr = map__46844__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46844__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46844__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46844__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
if(cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4174__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4174__auto__ = protocol;
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = tag;
if(cljs.core.truth_(and__4174__auto____$1)){
var or__4185__auto__ = (function (){var and__4174__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto____$2)){
var and__4174__auto____$3 = protocol;
if(cljs.core.truth_(and__4174__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4174__auto____$3;
}
} else {
return and__4174__auto____$2;
}
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var and__4174__auto____$2 = (function (){var or__4185__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4174__auto____$2)){
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__46856 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__46856.cljs$core$IFn$_invoke$arity$1 ? fexpr__46856.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__46856.call(null,tag));
})())){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4174__auto____$2;
}
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__46858 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__46858.cljs$core$IFn$_invoke$arity$1 ? fexpr__46858.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__46858.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4185__auto__){
return or__4185__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__46846 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4174__auto__)){
return (arity > mfa);
} else {
return and__4174__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__46841_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__46841_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__46842_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__46842_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46846,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46846,(1),null);
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_47695 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_47695,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_47696 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_47696,args)),(((mfa_47696 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_47696,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
var G__46860 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__46859 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__46859.cljs$core$IFn$_invoke$arity$1 ? fexpr__46859.cljs$core$IFn$_invoke$arity$1(G__46860) : fexpr__46859.call(null,G__46860));
} else {
return and__4174__auto__;
}
})())){
var fprop_47697 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_47697," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_47697,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_47697," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_47697,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__46861){
var map__46862 = p__46861;
var map__46862__$1 = (((((!((map__46862 == null))))?(((((map__46862.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46862.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46862):map__46862);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46862__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46862__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46862__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__46864){
var map__46865 = p__46864;
var map__46865__$1 = (((((!((map__46865 == null))))?(((((map__46865.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46865.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46865):map__46865);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46865__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46865__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46865__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__46870 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__46870__$1 = (((((!((map__46870 == null))))?(((((map__46870.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46870.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46870):map__46870);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46870__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46870__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__46871 = options;
var map__46871__$1 = (((((!((map__46871 == null))))?(((((map__46871.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46871.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46871):map__46871);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46871__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46871__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__46872 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__46877 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__46877__$1 = (((((!((map__46877 == null))))?(((((map__46877.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46877.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46877):map__46877);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46877__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46877__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46872,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46872,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__46879_47698 = cljs.core.seq(libs_to_load);
var chunk__46880_47699 = null;
var count__46881_47700 = (0);
var i__46882_47701 = (0);
while(true){
if((i__46882_47701 < count__46881_47700)){
var lib_47702 = chunk__46880_47699.cljs$core$IIndexed$_nth$arity$2(null,i__46882_47701);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_47702)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_47702),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47702),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_47702),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47702),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_47702,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47702),"');");
}

}
}
}


var G__47710 = seq__46879_47698;
var G__47711 = chunk__46880_47699;
var G__47712 = count__46881_47700;
var G__47713 = (i__46882_47701 + (1));
seq__46879_47698 = G__47710;
chunk__46880_47699 = G__47711;
count__46881_47700 = G__47712;
i__46882_47701 = G__47713;
continue;
} else {
var temp__5735__auto___47715 = cljs.core.seq(seq__46879_47698);
if(temp__5735__auto___47715){
var seq__46879_47716__$1 = temp__5735__auto___47715;
if(cljs.core.chunked_seq_QMARK_(seq__46879_47716__$1)){
var c__4609__auto___47717 = cljs.core.chunk_first(seq__46879_47716__$1);
var G__47718 = cljs.core.chunk_rest(seq__46879_47716__$1);
var G__47719 = c__4609__auto___47717;
var G__47720 = cljs.core.count(c__4609__auto___47717);
var G__47721 = (0);
seq__46879_47698 = G__47718;
chunk__46880_47699 = G__47719;
count__46881_47700 = G__47720;
i__46882_47701 = G__47721;
continue;
} else {
var lib_47722 = cljs.core.first(seq__46879_47716__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_47722)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_47722),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47722),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_47722),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47722),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_47722,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47722),"');");
}

}
}
}


var G__47723 = cljs.core.next(seq__46879_47716__$1);
var G__47724 = null;
var G__47725 = (0);
var G__47726 = (0);
seq__46879_47698 = G__47723;
chunk__46880_47699 = G__47724;
count__46881_47700 = G__47725;
i__46882_47701 = G__47726;
continue;
}
} else {
}
}
break;
}

var seq__46883_47727 = cljs.core.seq(node_libs);
var chunk__46884_47728 = null;
var count__46885_47729 = (0);
var i__46886_47730 = (0);
while(true){
if((i__46886_47730 < count__46885_47729)){
var lib_47731 = chunk__46884_47728.cljs$core$IIndexed$_nth$arity$2(null,i__46886_47730);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_47731)," = require('",lib_47731,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__47732 = seq__46883_47727;
var G__47733 = chunk__46884_47728;
var G__47734 = count__46885_47729;
var G__47735 = (i__46886_47730 + (1));
seq__46883_47727 = G__47732;
chunk__46884_47728 = G__47733;
count__46885_47729 = G__47734;
i__46886_47730 = G__47735;
continue;
} else {
var temp__5735__auto___47736 = cljs.core.seq(seq__46883_47727);
if(temp__5735__auto___47736){
var seq__46883_47737__$1 = temp__5735__auto___47736;
if(cljs.core.chunked_seq_QMARK_(seq__46883_47737__$1)){
var c__4609__auto___47738 = cljs.core.chunk_first(seq__46883_47737__$1);
var G__47739 = cljs.core.chunk_rest(seq__46883_47737__$1);
var G__47740 = c__4609__auto___47738;
var G__47741 = cljs.core.count(c__4609__auto___47738);
var G__47742 = (0);
seq__46883_47727 = G__47739;
chunk__46884_47728 = G__47740;
count__46885_47729 = G__47741;
i__46886_47730 = G__47742;
continue;
} else {
var lib_47743 = cljs.core.first(seq__46883_47737__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_47743)," = require('",lib_47743,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__47744 = cljs.core.next(seq__46883_47737__$1);
var G__47745 = null;
var G__47746 = (0);
var G__47747 = (0);
seq__46883_47727 = G__47744;
chunk__46884_47728 = G__47745;
count__46885_47729 = G__47746;
i__46886_47730 = G__47747;
continue;
}
} else {
}
}
break;
}

var seq__46887_47748 = cljs.core.seq(global_exports_libs);
var chunk__46888_47749 = null;
var count__46889_47750 = (0);
var i__46890_47751 = (0);
while(true){
if((i__46890_47751 < count__46889_47750)){
var lib_47752 = chunk__46888_47749.cljs$core$IIndexed$_nth$arity$2(null,i__46890_47751);
var map__46895_47754 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_47752));
var map__46895_47755__$1 = (((((!((map__46895_47754 == null))))?(((((map__46895_47754.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46895_47754.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46895_47754):map__46895_47754);
var global_exports_47756 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46895_47755__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_47756,lib_47752);


var G__47757 = seq__46887_47748;
var G__47758 = chunk__46888_47749;
var G__47759 = count__46889_47750;
var G__47760 = (i__46890_47751 + (1));
seq__46887_47748 = G__47757;
chunk__46888_47749 = G__47758;
count__46889_47750 = G__47759;
i__46890_47751 = G__47760;
continue;
} else {
var temp__5735__auto___47761 = cljs.core.seq(seq__46887_47748);
if(temp__5735__auto___47761){
var seq__46887_47762__$1 = temp__5735__auto___47761;
if(cljs.core.chunked_seq_QMARK_(seq__46887_47762__$1)){
var c__4609__auto___47763 = cljs.core.chunk_first(seq__46887_47762__$1);
var G__47764 = cljs.core.chunk_rest(seq__46887_47762__$1);
var G__47765 = c__4609__auto___47763;
var G__47766 = cljs.core.count(c__4609__auto___47763);
var G__47767 = (0);
seq__46887_47748 = G__47764;
chunk__46888_47749 = G__47765;
count__46889_47750 = G__47766;
i__46890_47751 = G__47767;
continue;
} else {
var lib_47768 = cljs.core.first(seq__46887_47762__$1);
var map__46897_47769 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_47768));
var map__46897_47770__$1 = (((((!((map__46897_47769 == null))))?(((((map__46897_47769.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46897_47769.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46897_47769):map__46897_47769);
var global_exports_47771 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46897_47770__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_47771,lib_47768);


var G__47772 = cljs.core.next(seq__46887_47762__$1);
var G__47773 = null;
var G__47774 = (0);
var G__47775 = (0);
seq__46887_47748 = G__47772;
chunk__46888_47749 = G__47773;
count__46889_47750 = G__47774;
i__46890_47751 = G__47775;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__46899){
var map__46900 = p__46899;
var map__46900__$1 = (((((!((map__46900 == null))))?(((((map__46900.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46900.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46900):map__46900);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46900__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46900__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46900__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46900__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46900__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46900__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46900__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__46902){
var map__46903 = p__46902;
var map__46903__$1 = (((((!((map__46903 == null))))?(((((map__46903.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46903.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46903):map__46903);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46903__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46903__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46903__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46903__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46903__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46903__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46903__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__46905){
var map__46906 = p__46905;
var map__46906__$1 = (((((!((map__46906 == null))))?(((((map__46906.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46906.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46906):map__46906);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46906__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46906__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46906__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46906__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46906__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__46908_47778 = cljs.core.seq(protocols);
var chunk__46909_47779 = null;
var count__46910_47780 = (0);
var i__46911_47781 = (0);
while(true){
if((i__46911_47781 < count__46910_47780)){
var protocol_47782 = chunk__46909_47779.cljs$core$IIndexed$_nth$arity$2(null,i__46911_47781);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_47782)),"}");


var G__47784 = seq__46908_47778;
var G__47785 = chunk__46909_47779;
var G__47786 = count__46910_47780;
var G__47787 = (i__46911_47781 + (1));
seq__46908_47778 = G__47784;
chunk__46909_47779 = G__47785;
count__46910_47780 = G__47786;
i__46911_47781 = G__47787;
continue;
} else {
var temp__5735__auto___47789 = cljs.core.seq(seq__46908_47778);
if(temp__5735__auto___47789){
var seq__46908_47790__$1 = temp__5735__auto___47789;
if(cljs.core.chunked_seq_QMARK_(seq__46908_47790__$1)){
var c__4609__auto___47791 = cljs.core.chunk_first(seq__46908_47790__$1);
var G__47792 = cljs.core.chunk_rest(seq__46908_47790__$1);
var G__47793 = c__4609__auto___47791;
var G__47794 = cljs.core.count(c__4609__auto___47791);
var G__47795 = (0);
seq__46908_47778 = G__47792;
chunk__46909_47779 = G__47793;
count__46910_47780 = G__47794;
i__46911_47781 = G__47795;
continue;
} else {
var protocol_47796 = cljs.core.first(seq__46908_47790__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_47796)),"}");


var G__47798 = cljs.core.next(seq__46908_47790__$1);
var G__47799 = null;
var G__47800 = (0);
var G__47801 = (0);
seq__46908_47778 = G__47798;
chunk__46909_47779 = G__47799;
count__46910_47780 = G__47800;
i__46911_47781 = G__47801;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__46915_47802 = cljs.core.seq(fields__$1);
var chunk__46916_47803 = null;
var count__46917_47804 = (0);
var i__46918_47805 = (0);
while(true){
if((i__46918_47805 < count__46917_47804)){
var fld_47806 = chunk__46916_47803.cljs$core$IIndexed$_nth$arity$2(null,i__46918_47805);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_47806," = ",fld_47806,";");


var G__47807 = seq__46915_47802;
var G__47808 = chunk__46916_47803;
var G__47809 = count__46917_47804;
var G__47810 = (i__46918_47805 + (1));
seq__46915_47802 = G__47807;
chunk__46916_47803 = G__47808;
count__46917_47804 = G__47809;
i__46918_47805 = G__47810;
continue;
} else {
var temp__5735__auto___47811 = cljs.core.seq(seq__46915_47802);
if(temp__5735__auto___47811){
var seq__46915_47812__$1 = temp__5735__auto___47811;
if(cljs.core.chunked_seq_QMARK_(seq__46915_47812__$1)){
var c__4609__auto___47813 = cljs.core.chunk_first(seq__46915_47812__$1);
var G__47814 = cljs.core.chunk_rest(seq__46915_47812__$1);
var G__47815 = c__4609__auto___47813;
var G__47816 = cljs.core.count(c__4609__auto___47813);
var G__47817 = (0);
seq__46915_47802 = G__47814;
chunk__46916_47803 = G__47815;
count__46917_47804 = G__47816;
i__46918_47805 = G__47817;
continue;
} else {
var fld_47818 = cljs.core.first(seq__46915_47812__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_47818," = ",fld_47818,";");


var G__47819 = cljs.core.next(seq__46915_47812__$1);
var G__47820 = null;
var G__47821 = (0);
var G__47822 = (0);
seq__46915_47802 = G__47819;
chunk__46916_47803 = G__47820;
count__46917_47804 = G__47821;
i__46918_47805 = G__47822;
continue;
}
} else {
}
}
break;
}

var seq__46919_47823 = cljs.core.seq(pmasks);
var chunk__46920_47824 = null;
var count__46921_47825 = (0);
var i__46922_47826 = (0);
while(true){
if((i__46922_47826 < count__46921_47825)){
var vec__46929_47830 = chunk__46920_47824.cljs$core$IIndexed$_nth$arity$2(null,i__46922_47826);
var pno_47831 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46929_47830,(0),null);
var pmask_47832 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46929_47830,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_47831,"$ = ",pmask_47832,";");


var G__47836 = seq__46919_47823;
var G__47837 = chunk__46920_47824;
var G__47838 = count__46921_47825;
var G__47839 = (i__46922_47826 + (1));
seq__46919_47823 = G__47836;
chunk__46920_47824 = G__47837;
count__46921_47825 = G__47838;
i__46922_47826 = G__47839;
continue;
} else {
var temp__5735__auto___47840 = cljs.core.seq(seq__46919_47823);
if(temp__5735__auto___47840){
var seq__46919_47841__$1 = temp__5735__auto___47840;
if(cljs.core.chunked_seq_QMARK_(seq__46919_47841__$1)){
var c__4609__auto___47842 = cljs.core.chunk_first(seq__46919_47841__$1);
var G__47843 = cljs.core.chunk_rest(seq__46919_47841__$1);
var G__47844 = c__4609__auto___47842;
var G__47845 = cljs.core.count(c__4609__auto___47842);
var G__47846 = (0);
seq__46919_47823 = G__47843;
chunk__46920_47824 = G__47844;
count__46921_47825 = G__47845;
i__46922_47826 = G__47846;
continue;
} else {
var vec__46932_47847 = cljs.core.first(seq__46919_47841__$1);
var pno_47848 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46932_47847,(0),null);
var pmask_47849 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46932_47847,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_47848,"$ = ",pmask_47849,";");


var G__47850 = cljs.core.next(seq__46919_47841__$1);
var G__47851 = null;
var G__47852 = (0);
var G__47853 = (0);
seq__46919_47823 = G__47850;
chunk__46920_47824 = G__47851;
count__46921_47825 = G__47852;
i__46922_47826 = G__47853;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__46935){
var map__46936 = p__46935;
var map__46936__$1 = (((((!((map__46936 == null))))?(((((map__46936.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46936.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46936):map__46936);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46936__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46936__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46936__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46936__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46936__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__46942_47854 = cljs.core.seq(protocols);
var chunk__46943_47855 = null;
var count__46944_47856 = (0);
var i__46945_47857 = (0);
while(true){
if((i__46945_47857 < count__46944_47856)){
var protocol_47858 = chunk__46943_47855.cljs$core$IIndexed$_nth$arity$2(null,i__46945_47857);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_47858)),"}");


var G__47859 = seq__46942_47854;
var G__47860 = chunk__46943_47855;
var G__47861 = count__46944_47856;
var G__47862 = (i__46945_47857 + (1));
seq__46942_47854 = G__47859;
chunk__46943_47855 = G__47860;
count__46944_47856 = G__47861;
i__46945_47857 = G__47862;
continue;
} else {
var temp__5735__auto___47863 = cljs.core.seq(seq__46942_47854);
if(temp__5735__auto___47863){
var seq__46942_47864__$1 = temp__5735__auto___47863;
if(cljs.core.chunked_seq_QMARK_(seq__46942_47864__$1)){
var c__4609__auto___47865 = cljs.core.chunk_first(seq__46942_47864__$1);
var G__47866 = cljs.core.chunk_rest(seq__46942_47864__$1);
var G__47867 = c__4609__auto___47865;
var G__47868 = cljs.core.count(c__4609__auto___47865);
var G__47869 = (0);
seq__46942_47854 = G__47866;
chunk__46943_47855 = G__47867;
count__46944_47856 = G__47868;
i__46945_47857 = G__47869;
continue;
} else {
var protocol_47870 = cljs.core.first(seq__46942_47864__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_47870)),"}");


var G__47871 = cljs.core.next(seq__46942_47864__$1);
var G__47872 = null;
var G__47873 = (0);
var G__47874 = (0);
seq__46942_47854 = G__47871;
chunk__46943_47855 = G__47872;
count__46944_47856 = G__47873;
i__46945_47857 = G__47874;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__46946_47875 = cljs.core.seq(fields__$1);
var chunk__46947_47876 = null;
var count__46948_47877 = (0);
var i__46949_47878 = (0);
while(true){
if((i__46949_47878 < count__46948_47877)){
var fld_47879 = chunk__46947_47876.cljs$core$IIndexed$_nth$arity$2(null,i__46949_47878);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_47879," = ",fld_47879,";");


var G__47880 = seq__46946_47875;
var G__47881 = chunk__46947_47876;
var G__47882 = count__46948_47877;
var G__47883 = (i__46949_47878 + (1));
seq__46946_47875 = G__47880;
chunk__46947_47876 = G__47881;
count__46948_47877 = G__47882;
i__46949_47878 = G__47883;
continue;
} else {
var temp__5735__auto___47884 = cljs.core.seq(seq__46946_47875);
if(temp__5735__auto___47884){
var seq__46946_47885__$1 = temp__5735__auto___47884;
if(cljs.core.chunked_seq_QMARK_(seq__46946_47885__$1)){
var c__4609__auto___47886 = cljs.core.chunk_first(seq__46946_47885__$1);
var G__47887 = cljs.core.chunk_rest(seq__46946_47885__$1);
var G__47888 = c__4609__auto___47886;
var G__47889 = cljs.core.count(c__4609__auto___47886);
var G__47890 = (0);
seq__46946_47875 = G__47887;
chunk__46947_47876 = G__47888;
count__46948_47877 = G__47889;
i__46949_47878 = G__47890;
continue;
} else {
var fld_47891 = cljs.core.first(seq__46946_47885__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_47891," = ",fld_47891,";");


var G__47892 = cljs.core.next(seq__46946_47885__$1);
var G__47893 = null;
var G__47894 = (0);
var G__47895 = (0);
seq__46946_47875 = G__47892;
chunk__46947_47876 = G__47893;
count__46948_47877 = G__47894;
i__46949_47878 = G__47895;
continue;
}
} else {
}
}
break;
}

var seq__46950_47896 = cljs.core.seq(pmasks);
var chunk__46951_47897 = null;
var count__46952_47898 = (0);
var i__46953_47899 = (0);
while(true){
if((i__46953_47899 < count__46952_47898)){
var vec__46960_47900 = chunk__46951_47897.cljs$core$IIndexed$_nth$arity$2(null,i__46953_47899);
var pno_47901 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46960_47900,(0),null);
var pmask_47902 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46960_47900,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_47901,"$ = ",pmask_47902,";");


var G__47903 = seq__46950_47896;
var G__47904 = chunk__46951_47897;
var G__47905 = count__46952_47898;
var G__47906 = (i__46953_47899 + (1));
seq__46950_47896 = G__47903;
chunk__46951_47897 = G__47904;
count__46952_47898 = G__47905;
i__46953_47899 = G__47906;
continue;
} else {
var temp__5735__auto___47907 = cljs.core.seq(seq__46950_47896);
if(temp__5735__auto___47907){
var seq__46950_47908__$1 = temp__5735__auto___47907;
if(cljs.core.chunked_seq_QMARK_(seq__46950_47908__$1)){
var c__4609__auto___47909 = cljs.core.chunk_first(seq__46950_47908__$1);
var G__47910 = cljs.core.chunk_rest(seq__46950_47908__$1);
var G__47911 = c__4609__auto___47909;
var G__47912 = cljs.core.count(c__4609__auto___47909);
var G__47913 = (0);
seq__46950_47896 = G__47910;
chunk__46951_47897 = G__47911;
count__46952_47898 = G__47912;
i__46953_47899 = G__47913;
continue;
} else {
var vec__46963_47914 = cljs.core.first(seq__46950_47908__$1);
var pno_47915 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46963_47914,(0),null);
var pmask_47916 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46963_47914,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_47915,"$ = ",pmask_47916,";");


var G__47917 = cljs.core.next(seq__46950_47908__$1);
var G__47918 = null;
var G__47919 = (0);
var G__47920 = (0);
seq__46950_47896 = G__47917;
chunk__46951_47897 = G__47918;
count__46952_47898 = G__47919;
i__46953_47899 = G__47920;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__46966){
var map__46967 = p__46966;
var map__46967__$1 = (((((!((map__46967 == null))))?(((((map__46967.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46967.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46967):map__46967);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46967__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46967__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46967__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46967__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46967__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__46969){
var map__46970 = p__46969;
var map__46970__$1 = (((((!((map__46970 == null))))?(((((map__46970.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46970.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46970):map__46970);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46970__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46970__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46970__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46970__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46970__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4174__auto__ = code;
if(cljs.core.truth_(and__4174__auto__)){
var G__46972 = clojure.string.trim(code);
var G__46973 = "/*";
return goog.string.startsWith(G__46972,G__46973);
} else {
return and__4174__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__46302__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46302__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__46978 = cljs.core.seq(table);
var chunk__46979 = null;
var count__46980 = (0);
var i__46981 = (0);
while(true){
if((i__46981 < count__46980)){
var vec__46993 = chunk__46979.cljs$core$IIndexed$_nth$arity$2(null,i__46981);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46993,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46993,(1),null);
var ns_47921 = cljs.core.namespace(sym);
var name_47922 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__47923 = seq__46978;
var G__47924 = chunk__46979;
var G__47925 = count__46980;
var G__47926 = (i__46981 + (1));
seq__46978 = G__47923;
chunk__46979 = G__47924;
count__46980 = G__47925;
i__46981 = G__47926;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46978);
if(temp__5735__auto__){
var seq__46978__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46978__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__46978__$1);
var G__47927 = cljs.core.chunk_rest(seq__46978__$1);
var G__47928 = c__4609__auto__;
var G__47929 = cljs.core.count(c__4609__auto__);
var G__47930 = (0);
seq__46978 = G__47927;
chunk__46979 = G__47928;
count__46980 = G__47929;
i__46981 = G__47930;
continue;
} else {
var vec__46996 = cljs.core.first(seq__46978__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46996,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46996,(1),null);
var ns_47931 = cljs.core.namespace(sym);
var name_47932 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__47933 = cljs.core.next(seq__46978__$1);
var G__47934 = null;
var G__47935 = (0);
var G__47936 = (0);
seq__46978 = G__47933;
chunk__46979 = G__47934;
count__46980 = G__47935;
i__46981 = G__47936;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__47000 = arguments.length;
switch (G__47000) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_47938 = cljs.core.first(ks);
var vec__47002_47939 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_47938);
var top_47940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47002_47939,(0),null);
var prefix_SINGLEQUOTE__47941 = vec__47002_47939;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_47938)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__47941) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_47940)) || (cljs.core.contains_QMARK_(known_externs,top_47940)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__47941)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_47940);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__47941)),";");
}
} else {
}

var m_47942 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_47938);
if(cljs.core.empty_QMARK_(m_47942)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__47941,m_47942,top_level,known_externs);
}

var G__47943 = cljs.core.next(ks);
ks = G__47943;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=cljs.compiler.js.map
