goog.provide('pinkgorilla.kernel.nrepl');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('cljs_uuid_utils.core');
goog.require('clojure.walk');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('chord.client');
goog.require('re_frame.core');
goog.require('pinkgorilla.notifications');
goog.require('pinkgorilla.kernel.cljs_helper');
/**
 * rendering via the Renderable protocol (needs renderable project)
 * (users can define their own render implementations)
 * identical to cljs version, except for non meta rendering it will not
 * call render, as this already has been rendered in the clj kernel
 */
pinkgorilla.kernel.nrepl.render_renderable_meta = (function pinkgorilla$kernel$nrepl$render_renderable_meta(result){
var m = cljs.core.meta(result);
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942),((cljs.core.contains_QMARK_(m,new cljs.core.Keyword(null,"r","r",-471384190)))?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"reagent-cljs","reagent-cljs",1666311021),new cljs.core.Keyword(null,"reagent","reagent",2131627322),result,new cljs.core.Keyword(null,"map-keywords","map-keywords",-170077571),false], null):((cljs.core.contains_QMARK_(m,new cljs.core.Keyword(null,"R","R",-936662523)))?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"reagent-cljs","reagent-cljs",1666311021),new cljs.core.Keyword(null,"reagent","reagent",2131627322),result,new cljs.core.Keyword(null,"map-keywords","map-keywords",-170077571),true], null):result
))], null);
});
if((typeof pinkgorilla !== 'undefined') && (typeof pinkgorilla.kernel !== 'undefined') && (typeof pinkgorilla.kernel.nrepl !== 'undefined') && (typeof pinkgorilla.kernel.nrepl.ws_repl !== 'undefined')){
} else {
pinkgorilla.kernel.nrepl.ws_repl = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"channel","channel",734187692),null,new cljs.core.Keyword(null,"session-id","session-id",-1147060351),null,new cljs.core.Keyword(null,"evaluations","evaluations",57802423),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ciders","ciders",-1421942407),cljs.core.PersistentArrayMap.EMPTY], null));
}
/**
 * awb99: TODO: if websocket is nil, this will throw! (or not?).
 * This could be the error of some of the notebooks not loading.
 * Why dont we keep the core.async channels open all the time. And when we have a
 * websocket connection, then the messages get sent. Or we just dump messages that happen
 * before the socket gets opened. But in this case we have to LOG message dumping.
 * I have seen situations where the first eval does not go through. Might be this issue.
 * 
 */
pinkgorilla.kernel.nrepl.send_message_BANG_ = (function pinkgorilla$kernel$nrepl$send_message_BANG_(key,message,storeval){
var eval_id = cljs_uuid_utils.core.uuid_string(cljs_uuid_utils.core.make_random_uuid());
var nrepl_msg = cljs.core.clj__GT_js(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),eval_id,new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"session-id","session-id",-1147060351).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl))], null)], 0)));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(eval_id)], null),storeval);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl)),nrepl_msg);

return eval_id;
});
pinkgorilla.kernel.nrepl.eval_BANG_ = (function pinkgorilla$kernel$nrepl$eval_BANG_(segment_id,content){
return pinkgorilla.kernel.nrepl.send_message_BANG_(new cljs.core.Keyword(null,"evaluations","evaluations",57802423),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),"eval",new cljs.core.Keyword(null,"code","code",1586293142),content], null),segment_id);
});
pinkgorilla.kernel.nrepl.send_cider_message_BANG_ = (function pinkgorilla$kernel$nrepl$send_cider_message_BANG_(message,storeval){
return pinkgorilla.kernel.nrepl.send_message_BANG_(new cljs.core.Keyword(null,"ciders","ciders",-1421942407),message,storeval);
});
/**
 * Query the REPL server for autocompletion suggestions. Relies on the cider-nrepl middleware.
 *   We call the given callback with the list of symbols once the REPL server replies.
 */
pinkgorilla.kernel.nrepl.get_completions = (function pinkgorilla$kernel$nrepl$get_completions(symbol,ns,context,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"op","op",-1882987955),"complete",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns,new cljs.core.Keyword(null,"context","context",-830191113),context], null),(function (msg){
var G__51854 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__51853_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__51853_SHARP_,"candidate");
}),cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"completions"));
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__51854) : callback.call(null,G__51854));
}));
});
/**
 * Queries the REPL server for docs for the given symbol. Relies on the cider-nrepl middleware.
 *   Calls back with the documentation text
 */
pinkgorilla.kernel.nrepl.get_completion_doc = (function pinkgorilla$kernel$nrepl$get_completion_doc(symbol,ns,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"complete-doc",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null),(function (msg){
var G__51855 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"completion-doc");
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__51855) : callback.call(null,G__51855));
}));
});
/**
 * resolve a symbol to get its namespace takes the symbol and the namespace that should be used as context.
 *   Relies on the cider-nrepl middleware. Calls back with the symbol and the symbol's namespace
 */
pinkgorilla.kernel.nrepl.resolve_symbol = (function pinkgorilla$kernel$nrepl$resolve_symbol(symbol,ns,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"info",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null),(function (msg){
var G__51856 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"symbol","symbol",-1038572696),cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"name"),new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"ns")], null);
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__51856) : callback.call(null,G__51856));
}));
});
pinkgorilla.kernel.nrepl.parse_value = (function pinkgorilla$kernel$nrepl$parse_value(value){
var data = clojure.walk.keywordize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(JSON.parse(JSON.parse(value))));
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init9210512555929219670.clj",103,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["value ",value," => ",data], null);
}),null)),null,-1609577203);
return data;
});
/**
 * processes an incoming message from websocket that comes from nrepl (and has cider enhancements)
 * dispatches events to reagent to update notebook state ui.
 *   
 */
pinkgorilla.kernel.nrepl.process_msg = (function pinkgorilla$kernel$nrepl$process_msg(message){
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"id"));
var out = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"out");
var err = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"err");
var root_ex = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"root-ex");
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"ns");
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"value");
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"status");
var segment_id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluations","evaluations",57802423),id], null));
var cider_cb = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ciders","ciders",-1421942407),id], null));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init9210512555929219670.clj",120,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got message",id,"for segment",segment_id], null);
}),null)),null,337189545);

if(cljs.core.truth_(segment_id)){
if(cljs.core.truth_(ns)){
var data = pinkgorilla.kernel.nrepl.parse_value(value);
return pinkgorilla.kernel.cljs_helper.send_value.cljs$core$IFn$_invoke$arity$3(segment_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942),data], null),ns);
} else {
if(cljs.core.truth_(out)){
var G__51860 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:console-response","evaluator:console-response",-650807352),segment_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"console-response","console-response",81719661),out], null)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__51860) : re_frame.core.dispatch.call(null,G__51860));
} else {
if(cljs.core.truth_(err)){
var error = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error-text","error-text",2021893718),err,new cljs.core.Keyword(null,"segment-id","segment-id",1810133590),segment_id], null));
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op","op",-1882987955),"stacktrace"], null),(function (msg){
var status__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"status");
if(cljs.core.truth_((function (){var and__4174__auto__ = status__$1;
if(cljs.core.truth_(and__4174__auto__)){
return (status__$1.indexOf("done") >= (0));
} else {
return and__4174__auto__;
}
})())){
var G__51861 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:error-response","evaluator:error-response",1375419587),cljs.core.deref(error)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__51861) : re_frame.core.dispatch.call(null,G__51861));
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(error,(function (err__$1,ex){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(err__$1,new cljs.core.Keyword(null,"exception","exception",-335277064)))){
return cljs.core.assoc_in(err__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"cause","cause",231901252)], null),new cljs.core.Keyword(null,"exception","exception",-335277064).cljs$core$IFn$_invoke$arity$1(ex));
} else {
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ex,err__$1], 0));
}
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"exception","exception",-335277064),msg], null));
}
}));
} else {
if(cljs.core.truth_(root_ex)){
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init9210512555929219670.clj",160,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got root-ex",root_ex,"for",segment_id], null);
}),null)),null,-394220358);
} else {
if((status.indexOf("done") >= (0))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluations","evaluations",57802423),id], null));

var G__51863 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:done-response","evaluator:done-response",1140676326),segment_id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__51863) : re_frame.core.dispatch.call(null,G__51863));
} else {
return null;
}
}
}
}
}
} else {
if(cljs.core.truth_(cider_cb)){
(cider_cb.cljs$core$IFn$_invoke$arity$1 ? cider_cb.cljs$core$IFn$_invoke$arity$1(message) : cider_cb.call(null,message));

if(cljs.core.truth_((function (){var and__4174__auto__ = status;
if(cljs.core.truth_(and__4174__auto__)){
return (status.indexOf("done") >= (0));
} else {
return and__4174__auto__;
}
})())){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ciders","ciders",-1421942407),id], null));
} else {
return null;
}
} else {
return null;
}
}
});
pinkgorilla.kernel.nrepl.set_clj_kernel_status = (function pinkgorilla$kernel$nrepl$set_clj_kernel_status(connected,session_id){
var G__51868 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"kernel-clj-status-set","kernel-clj-status-set",-1158664458),connected,session_id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__51868) : re_frame.core.dispatch.call(null,G__51868));
});
pinkgorilla.kernel.nrepl.receive_msgs_BANG_ = (function pinkgorilla$kernel$nrepl$receive_msgs_BANG_(server_ch){
var c__42129__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42130__auto__ = (function (){var switch__42062__auto__ = (function (state_51963){
var state_val_51964 = (state_51963[(1)]);
if((state_val_51964 === (7))){
var state_51963__$1 = state_51963;
var statearr_51967_52145 = state_51963__$1;
(statearr_51967_52145[(2)] = false);

(statearr_51967_52145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51964 === (1))){
var state_51963__$1 = state_51963;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51963__$1,(2),server_ch);
} else {
if((state_val_51964 === (4))){
var state_51963__$1 = state_51963;
var statearr_51968_52146 = state_51963__$1;
(statearr_51968_52146[(2)] = false);

(statearr_51968_52146[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51964 === (13))){
var inst_51898 = (state_51963[(7)]);
var inst_51956 = ["clj-kernel Fatal Error : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_51898)," - Unable to create session. Game over"].join('');
var inst_51957 = pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"danger","danger",-624338030),inst_51956);
var inst_51958 = pinkgorilla.notifications.add_notification(inst_51957);
var inst_51959 = pinkgorilla.kernel.nrepl.set_clj_kernel_status(false,null);
var state_51963__$1 = (function (){var statearr_51970 = state_51963;
(statearr_51970[(8)] = inst_51958);

return statearr_51970;
})();
var statearr_51972_52147 = state_51963__$1;
(statearr_51972_52147[(2)] = inst_51959);

(statearr_51972_52147[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51964 === (6))){
var state_51963__$1 = state_51963;
var statearr_51973_52148 = state_51963__$1;
(statearr_51973_52148[(2)] = true);

(statearr_51973_52148[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51964 === (3))){
var inst_51874 = (state_51963[(9)]);
var inst_51880 = inst_51874.cljs$lang$protocol_mask$partition0$;
var inst_51881 = (inst_51880 & (64));
var inst_51882 = inst_51874.cljs$core$ISeq$;
var inst_51883 = (cljs.core.PROTOCOL_SENTINEL === inst_51882);
var inst_51884 = ((inst_51881) || (inst_51883));
var state_51963__$1 = state_51963;
if(cljs.core.truth_(inst_51884)){
var statearr_51976_52149 = state_51963__$1;
(statearr_51976_52149[(1)] = (6));

} else {
var statearr_51977_52150 = state_51963__$1;
(statearr_51977_52150[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51964 === (12))){
var inst_51897 = (state_51963[(10)]);
var inst_51896 = (state_51963[(11)]);
var inst_51898 = (state_51963[(7)]);
var inst_51903 = (state_51963[(12)]);
var inst_51906 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc,new cljs.core.Keyword(null,"session-id","session-id",-1147060351),inst_51903);
var inst_51907 = pinkgorilla.kernel.nrepl.set_clj_kernel_status(true,inst_51903);
var inst_51952 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_51953 = (function (){var map__51872 = inst_51896;
var message = inst_51897;
var error = inst_51898;
var temp__5733__auto__ = inst_51903;
var new_session = inst_51903;
var c__42129__auto____$1 = inst_51952;
return (function (){
var f__42130__auto__ = (function (){var switch__42062__auto__ = (function (state_51949){
var state_val_51950 = (state_51949[(1)]);
if((state_val_51950 === (7))){
var inst_51927 = (state_51949[(2)]);
var state_51949__$1 = state_51949;
if(cljs.core.truth_(inst_51927)){
var statearr_51979_52151 = state_51949__$1;
(statearr_51979_52151[(1)] = (11));

} else {
var statearr_51980_52152 = state_51949__$1;
(statearr_51980_52152[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51950 === (1))){
var state_51949__$1 = state_51949;
var statearr_51981_52153 = state_51949__$1;
(statearr_51981_52153[(2)] = null);

(statearr_51981_52153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51950 === (4))){
var inst_51911 = (state_51949[(7)]);
var inst_51911__$1 = (state_51949[(2)]);
var inst_51913 = (inst_51911__$1 == null);
var inst_51914 = cljs.core.not(inst_51913);
var state_51949__$1 = (function (){var statearr_51984 = state_51949;
(statearr_51984[(7)] = inst_51911__$1);

return statearr_51984;
})();
if(inst_51914){
var statearr_51985_52154 = state_51949__$1;
(statearr_51985_52154[(1)] = (5));

} else {
var statearr_51986_52155 = state_51949__$1;
(statearr_51986_52155[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51950 === (15))){
var inst_51934 = (state_51949[(8)]);
var inst_51940 = ["clj-kernel Fatal Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_51934)," - Game over"].join('');
var inst_51941 = pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"danger","danger",-624338030),inst_51940);
var inst_51942 = pinkgorilla.notifications.add_notification(inst_51941);
var inst_51943 = pinkgorilla.kernel.nrepl.set_clj_kernel_status(false,null);
var state_51949__$1 = (function (){var statearr_51987 = state_51949;
(statearr_51987[(9)] = inst_51942);

return statearr_51987;
})();
var statearr_51988_52156 = state_51949__$1;
(statearr_51988_52156[(2)] = inst_51943);

(statearr_51988_52156[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51950 === (13))){
var inst_51933 = (state_51949[(10)]);
var inst_51932 = (state_51949[(2)]);
var inst_51933__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51932,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_51934 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51932,new cljs.core.Keyword(null,"error","error",-978969032));
var state_51949__$1 = (function (){var statearr_51989 = state_51949;
(statearr_51989[(8)] = inst_51934);

(statearr_51989[(10)] = inst_51933__$1);

return statearr_51989;
})();
if(cljs.core.truth_(inst_51933__$1)){
var statearr_51990_52157 = state_51949__$1;
(statearr_51990_52157[(1)] = (14));

} else {
var statearr_51991_52158 = state_51949__$1;
(statearr_51991_52158[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51950 === (6))){
var state_51949__$1 = state_51949;
var statearr_51992_52159 = state_51949__$1;
(statearr_51992_52159[(2)] = false);

(statearr_51992_52159[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51950 === (3))){
var inst_51947 = (state_51949[(2)]);
var state_51949__$1 = state_51949;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51949__$1,inst_51947);
} else {
if((state_val_51950 === (12))){
var inst_51911 = (state_51949[(7)]);
var state_51949__$1 = state_51949;
var statearr_51993_52160 = state_51949__$1;
(statearr_51993_52160[(2)] = inst_51911);

(statearr_51993_52160[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51950 === (2))){
var state_51949__$1 = state_51949;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51949__$1,(4),server_ch);
} else {
if((state_val_51950 === (11))){
var inst_51911 = (state_51949[(7)]);
var inst_51929 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_51911);
var state_51949__$1 = state_51949;
var statearr_51994_52161 = state_51949__$1;
(statearr_51994_52161[(2)] = inst_51929);

(statearr_51994_52161[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51950 === (9))){
var state_51949__$1 = state_51949;
var statearr_51995_52162 = state_51949__$1;
(statearr_51995_52162[(2)] = false);

(statearr_51995_52162[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51950 === (5))){
var inst_51911 = (state_51949[(7)]);
var inst_51916 = inst_51911.cljs$lang$protocol_mask$partition0$;
var inst_51917 = (inst_51916 & (64));
var inst_51918 = inst_51911.cljs$core$ISeq$;
var inst_51919 = (cljs.core.PROTOCOL_SENTINEL === inst_51918);
var inst_51920 = ((inst_51917) || (inst_51919));
var state_51949__$1 = state_51949;
if(cljs.core.truth_(inst_51920)){
var statearr_51996_52163 = state_51949__$1;
(statearr_51996_52163[(1)] = (8));

} else {
var statearr_51997_52164 = state_51949__$1;
(statearr_51997_52164[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51950 === (14))){
var inst_51933 = (state_51949[(10)]);
var inst_51937 = pinkgorilla.kernel.nrepl.process_msg(inst_51933);
var state_51949__$1 = (function (){var statearr_51998 = state_51949;
(statearr_51998[(11)] = inst_51937);

return statearr_51998;
})();
var statearr_51999_52165 = state_51949__$1;
(statearr_51999_52165[(2)] = null);

(statearr_51999_52165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51950 === (16))){
var inst_51945 = (state_51949[(2)]);
var state_51949__$1 = state_51949;
var statearr_52000_52166 = state_51949__$1;
(statearr_52000_52166[(2)] = inst_51945);

(statearr_52000_52166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51950 === (10))){
var inst_51924 = (state_51949[(2)]);
var state_51949__$1 = state_51949;
var statearr_52001_52167 = state_51949__$1;
(statearr_52001_52167[(2)] = inst_51924);

(statearr_52001_52167[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51950 === (8))){
var state_51949__$1 = state_51949;
var statearr_52002_52168 = state_51949__$1;
(statearr_52002_52168[(2)] = true);

(statearr_52002_52168[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0 = (function (){
var statearr_52003 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52003[(0)] = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__);

(statearr_52003[(1)] = (1));

return statearr_52003;
});
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1 = (function (state_51949){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_51949);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52004){if((e52004 instanceof Object)){
var ex__42066__auto__ = e52004;
var statearr_52005_52169 = state_51949;
(statearr_52005_52169[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51949);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52004;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52170 = state_51949;
state_51949 = G__52170;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__ = function(state_51949){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1.call(this,state_51949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__;
})()
})();
var state__42131__auto__ = (function (){var statearr_52006 = (f__42130__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42130__auto__.cljs$core$IFn$_invoke$arity$0() : f__42130__auto__.call(null));
(statearr_52006[(6)] = c__42129__auto____$1);

return statearr_52006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42131__auto__);
});
})();
var inst_51954 = cljs.core.async.impl.dispatch.run(inst_51953);
var state_51963__$1 = (function (){var statearr_52007 = state_51963;
(statearr_52007[(13)] = inst_51906);

(statearr_52007[(14)] = inst_51954);

(statearr_52007[(15)] = inst_51907);

return statearr_52007;
})();
var statearr_52008_52171 = state_51963__$1;
(statearr_52008_52171[(2)] = inst_51952);

(statearr_52008_52171[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51964 === (2))){
var inst_51874 = (state_51963[(9)]);
var inst_51874__$1 = (state_51963[(2)]);
var inst_51877 = (inst_51874__$1 == null);
var inst_51878 = cljs.core.not(inst_51877);
var state_51963__$1 = (function (){var statearr_52009 = state_51963;
(statearr_52009[(9)] = inst_51874__$1);

return statearr_52009;
})();
if(inst_51878){
var statearr_52010_52172 = state_51963__$1;
(statearr_52010_52172[(1)] = (3));

} else {
var statearr_52011_52173 = state_51963__$1;
(statearr_52011_52173[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51964 === (11))){
var inst_51897 = (state_51963[(10)]);
var inst_51896 = (state_51963[(11)]);
var inst_51898 = (state_51963[(7)]);
var inst_51903 = (state_51963[(12)]);
var inst_51896__$1 = (state_51963[(2)]);
var inst_51897__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51896__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_51898__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51896__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var inst_51899 = (function (){var map__51872 = inst_51896__$1;
var message = inst_51897__$1;
var error = inst_51898__$1;
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got initial message ",message], null);
});
})();
var inst_51900 = (new cljs.core.Delay(inst_51899,null));
var inst_51901 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init9210512555929219670.clj",183,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_51900,null,-300722203);
var inst_51903__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51897__$1,"new-session");
var state_51963__$1 = (function (){var statearr_52012 = state_51963;
(statearr_52012[(10)] = inst_51897__$1);

(statearr_52012[(11)] = inst_51896__$1);

(statearr_52012[(7)] = inst_51898__$1);

(statearr_52012[(16)] = inst_51901);

(statearr_52012[(12)] = inst_51903__$1);

return statearr_52012;
})();
if(cljs.core.truth_(inst_51903__$1)){
var statearr_52013_52175 = state_51963__$1;
(statearr_52013_52175[(1)] = (12));

} else {
var statearr_52014_52176 = state_51963__$1;
(statearr_52014_52176[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51964 === (9))){
var inst_51874 = (state_51963[(9)]);
var inst_51893 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_51874);
var state_51963__$1 = state_51963;
var statearr_52015_52178 = state_51963__$1;
(statearr_52015_52178[(2)] = inst_51893);

(statearr_52015_52178[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51964 === (5))){
var inst_51891 = (state_51963[(2)]);
var state_51963__$1 = state_51963;
if(cljs.core.truth_(inst_51891)){
var statearr_52016_52179 = state_51963__$1;
(statearr_52016_52179[(1)] = (9));

} else {
var statearr_52017_52180 = state_51963__$1;
(statearr_52017_52180[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51964 === (14))){
var inst_51961 = (state_51963[(2)]);
var state_51963__$1 = state_51963;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51963__$1,inst_51961);
} else {
if((state_val_51964 === (10))){
var inst_51874 = (state_51963[(9)]);
var state_51963__$1 = state_51963;
var statearr_52018_52182 = state_51963__$1;
(statearr_52018_52182[(2)] = inst_51874);

(statearr_52018_52182[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51964 === (8))){
var inst_51888 = (state_51963[(2)]);
var state_51963__$1 = state_51963;
var statearr_52019_52183 = state_51963__$1;
(statearr_52019_52183[(2)] = inst_51888);

(statearr_52019_52183[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0 = (function (){
var statearr_52020 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52020[(0)] = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__);

(statearr_52020[(1)] = (1));

return statearr_52020;
});
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1 = (function (state_51963){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_51963);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52021){if((e52021 instanceof Object)){
var ex__42066__auto__ = e52021;
var statearr_52022_52185 = state_51963;
(statearr_52022_52185[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51963);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52021;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52186 = state_51963;
state_51963 = G__52186;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__ = function(state_51963){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1.call(this,state_51963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__;
})()
})();
var state__42131__auto__ = (function (){var statearr_52023 = (f__42130__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42130__auto__.cljs$core$IFn$_invoke$arity$0() : f__42130__auto__.call(null));
(statearr_52023[(6)] = c__42129__auto__);

return statearr_52023;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42131__auto__);
}));

return c__42129__auto__;
});
pinkgorilla.kernel.nrepl.send_msgs_BANG_ = (function pinkgorilla$kernel$nrepl$send_msgs_BANG_(new_msg_ch,server_ch){
var c__42129__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42130__auto__ = (function (){var switch__42062__auto__ = (function (state_52037){
var state_val_52038 = (state_52037[(1)]);
if((state_val_52038 === (1))){
var state_52037__$1 = state_52037;
var statearr_52039_52187 = state_52037__$1;
(statearr_52039_52187[(2)] = null);

(statearr_52039_52187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52038 === (2))){
var state_52037__$1 = state_52037;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52037__$1,(4),new_msg_ch);
} else {
if((state_val_52038 === (3))){
var inst_52035 = (state_52037[(2)]);
var state_52037__$1 = state_52037;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52037__$1,inst_52035);
} else {
if((state_val_52038 === (4))){
var inst_52026 = (state_52037[(7)]);
var inst_52026__$1 = (state_52037[(2)]);
var state_52037__$1 = (function (){var statearr_52040 = state_52037;
(statearr_52040[(7)] = inst_52026__$1);

return statearr_52040;
})();
if(cljs.core.truth_(inst_52026__$1)){
var statearr_52041_52188 = state_52037__$1;
(statearr_52041_52188[(1)] = (5));

} else {
var statearr_52042_52189 = state_52037__$1;
(statearr_52042_52189[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52038 === (5))){
var inst_52026 = (state_52037[(7)]);
var state_52037__$1 = state_52037;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52037__$1,(8),server_ch,inst_52026);
} else {
if((state_val_52038 === (6))){
var state_52037__$1 = state_52037;
var statearr_52043_52190 = state_52037__$1;
(statearr_52043_52190[(2)] = null);

(statearr_52043_52190[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52038 === (7))){
var inst_52033 = (state_52037[(2)]);
var state_52037__$1 = state_52037;
var statearr_52044_52191 = state_52037__$1;
(statearr_52044_52191[(2)] = inst_52033);

(statearr_52044_52191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52038 === (8))){
var inst_52029 = (state_52037[(2)]);
var state_52037__$1 = (function (){var statearr_52045 = state_52037;
(statearr_52045[(8)] = inst_52029);

return statearr_52045;
})();
var statearr_52046_52192 = state_52037__$1;
(statearr_52046_52192[(2)] = null);

(statearr_52046_52192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto____0 = (function (){
var statearr_52047 = [null,null,null,null,null,null,null,null,null];
(statearr_52047[(0)] = pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto__);

(statearr_52047[(1)] = (1));

return statearr_52047;
});
var pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto____1 = (function (state_52037){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_52037);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52048){if((e52048 instanceof Object)){
var ex__42066__auto__ = e52048;
var statearr_52049_52196 = state_52037;
(statearr_52049_52196[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52037);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52048;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52197 = state_52037;
state_52037 = G__52197;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto__ = function(state_52037){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto____1.call(this,state_52037);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto__;
})()
})();
var state__42131__auto__ = (function (){var statearr_52050 = (f__42130__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42130__auto__.cljs$core$IFn$_invoke$arity$0() : f__42130__auto__.call(null));
(statearr_52050[(6)] = c__42129__auto__);

return statearr_52050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42131__auto__);
}));

return c__42129__auto__;
});
pinkgorilla.kernel.nrepl.init_BANG_ = (function pinkgorilla$kernel$nrepl$init_BANG_(ws_url){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init9210512555929219670.clj",209,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["clj kernel starting at",ws_url], null);
}),null)),null,820217685);

var c__42129__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42130__auto__ = (function (){var switch__42062__auto__ = (function (state_52096){
var state_val_52097 = (state_52096[(1)]);
if((state_val_52097 === (7))){
var state_52096__$1 = state_52096;
var statearr_52098_52200 = state_52096__$1;
(statearr_52098_52200[(2)] = false);

(statearr_52098_52200[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52097 === (1))){
var inst_52052 = [new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_52053 = [new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_52054 = cljs.core.PersistentHashMap.fromArrays(inst_52052,inst_52053);
var inst_52055 = chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(ws_url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_52054], 0));
var state_52096__$1 = state_52096;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52096__$1,(2),inst_52055);
} else {
if((state_val_52097 === (4))){
var state_52096__$1 = state_52096;
var statearr_52099_52202 = state_52096__$1;
(statearr_52099_52202[(2)] = false);

(statearr_52099_52202[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52097 === (15))){
var inst_52094 = (state_52096[(2)]);
var state_52096__$1 = state_52096;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52096__$1,inst_52094);
} else {
if((state_val_52097 === (13))){
var state_52096__$1 = state_52096;
var statearr_52100_52203 = state_52096__$1;
(statearr_52100_52203[(2)] = null);

(statearr_52100_52203[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52097 === (6))){
var state_52096__$1 = state_52096;
var statearr_52101_52204 = state_52096__$1;
(statearr_52101_52204[(2)] = true);

(statearr_52101_52204[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52097 === (3))){
var inst_52057 = (state_52096[(7)]);
var inst_52062 = inst_52057.cljs$lang$protocol_mask$partition0$;
var inst_52063 = (inst_52062 & (64));
var inst_52064 = inst_52057.cljs$core$ISeq$;
var inst_52065 = (cljs.core.PROTOCOL_SENTINEL === inst_52064);
var inst_52066 = ((inst_52063) || (inst_52065));
var state_52096__$1 = state_52096;
if(cljs.core.truth_(inst_52066)){
var statearr_52102_52205 = state_52096__$1;
(statearr_52102_52205[(1)] = (6));

} else {
var statearr_52103_52206 = state_52096__$1;
(statearr_52103_52206[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52097 === (12))){
var inst_52080 = (state_52096[(8)]);
var inst_52082 = ["clj-kernel ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_52080)].join('');
var inst_52083 = pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"danger","danger",-624338030),inst_52082);
var inst_52084 = pinkgorilla.notifications.add_notification(inst_52083);
var state_52096__$1 = state_52096;
var statearr_52104_52207 = state_52096__$1;
(statearr_52104_52207[(2)] = inst_52084);

(statearr_52104_52207[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52097 === (2))){
var inst_52057 = (state_52096[(7)]);
var inst_52057__$1 = (state_52096[(2)]);
var inst_52059 = (inst_52057__$1 == null);
var inst_52060 = cljs.core.not(inst_52059);
var state_52096__$1 = (function (){var statearr_52105 = state_52096;
(statearr_52105[(7)] = inst_52057__$1);

return statearr_52105;
})();
if(inst_52060){
var statearr_52106_52208 = state_52096__$1;
(statearr_52106_52208[(1)] = (3));

} else {
var statearr_52107_52209 = state_52096__$1;
(statearr_52107_52209[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52097 === (11))){
var inst_52080 = (state_52096[(8)]);
var inst_52078 = (state_52096[(2)]);
var inst_52079 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52078,new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174));
var inst_52080__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52078,new cljs.core.Keyword(null,"error","error",-978969032));
var state_52096__$1 = (function (){var statearr_52108 = state_52096;
(statearr_52108[(9)] = inst_52079);

(statearr_52108[(8)] = inst_52080__$1);

return statearr_52108;
})();
if(cljs.core.truth_(inst_52080__$1)){
var statearr_52110_52210 = state_52096__$1;
(statearr_52110_52210[(1)] = (12));

} else {
var statearr_52111_52211 = state_52096__$1;
(statearr_52111_52211[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52097 === (9))){
var inst_52057 = (state_52096[(7)]);
var inst_52075 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_52057);
var state_52096__$1 = state_52096;
var statearr_52112_52212 = state_52096__$1;
(statearr_52112_52212[(2)] = inst_52075);

(statearr_52112_52212[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52097 === (5))){
var inst_52073 = (state_52096[(2)]);
var state_52096__$1 = state_52096;
if(cljs.core.truth_(inst_52073)){
var statearr_52114_52213 = state_52096__$1;
(statearr_52114_52213[(1)] = (9));

} else {
var statearr_52115_52214 = state_52096__$1;
(statearr_52115_52214[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52097 === (14))){
var inst_52079 = (state_52096[(9)]);
var inst_52087 = (state_52096[(2)]);
var inst_52089 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_52090 = pinkgorilla.kernel.nrepl.send_msgs_BANG_(inst_52089,inst_52079);
var inst_52091 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc,new cljs.core.Keyword(null,"channel","channel",734187692),inst_52089);
var inst_52092 = pinkgorilla.kernel.nrepl.receive_msgs_BANG_(inst_52079);
var state_52096__$1 = (function (){var statearr_52116 = state_52096;
(statearr_52116[(10)] = inst_52087);

(statearr_52116[(11)] = inst_52090);

(statearr_52116[(12)] = inst_52092);

(statearr_52116[(13)] = inst_52091);

return statearr_52116;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52096__$1,(15),inst_52089,({"op": "clone"}));
} else {
if((state_val_52097 === (10))){
var inst_52057 = (state_52096[(7)]);
var state_52096__$1 = state_52096;
var statearr_52117_52215 = state_52096__$1;
(statearr_52117_52215[(2)] = inst_52057);

(statearr_52117_52215[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52097 === (8))){
var inst_52070 = (state_52096[(2)]);
var state_52096__$1 = state_52096;
var statearr_52118_52216 = state_52096__$1;
(statearr_52118_52216[(2)] = inst_52070);

(statearr_52118_52216[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto____0 = (function (){
var statearr_52119 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52119[(0)] = pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto__);

(statearr_52119[(1)] = (1));

return statearr_52119;
});
var pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto____1 = (function (state_52096){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_52096);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52120){if((e52120 instanceof Object)){
var ex__42066__auto__ = e52120;
var statearr_52121_52217 = state_52096;
(statearr_52121_52217[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52096);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52120;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52218 = state_52096;
state_52096 = G__52218;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto__ = function(state_52096){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto____1.call(this,state_52096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto__;
})()
})();
var state__42131__auto__ = (function (){var statearr_52122 = (f__42130__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42130__auto__.cljs$core$IFn$_invoke$arity$0() : f__42130__auto__.call(null));
(statearr_52122[(6)] = c__42129__auto__);

return statearr_52122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42131__auto__);
}));

return c__42129__auto__;
});
pinkgorilla.kernel.nrepl.clj_eval = (function pinkgorilla$kernel$nrepl$clj_eval(snippet,callback){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["clj-eval: ",snippet], 0));

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init9210512555929219670.clj",235,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["clj-eval: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(snippet)].join('')], null);
}),null)),null,-1700660540);

return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),"eval",new cljs.core.Keyword(null,"code","code",1586293142),snippet], null),(function (message){
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"ns");
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init9210512555929219670.clj",240,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["ns: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join('')], null);
}),null)),null,-1720260246);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"value");
var data = pinkgorilla.kernel.nrepl.parse_value(value);
if(cljs.core.truth_(ns)){
var v2 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(data));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init9210512555929219670.clj",244,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["clj-eval response: ",data," type: ",cljs.core.type(value)], null);
}),null)),null,1119410119);

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init9210512555929219670.clj",245,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["clj-eval result: ",v2," type: ",cljs.core.type(v2)], null);
}),null)),null,-2059809683);

return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(v2) : callback.call(null,v2));
} else {
return null;
}
}));
});
goog.exportSymbol('pinkgorilla.kernel.nrepl.clj_eval', pinkgorilla.kernel.nrepl.clj_eval);
pinkgorilla.kernel.nrepl.clj_eval_sync = (function pinkgorilla$kernel$nrepl$clj_eval_sync(result_atom,snippet){
var result_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__42129__auto___52219 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42130__auto__ = (function (){var switch__42062__auto__ = (function (state_52126){
var state_val_52127 = (state_52126[(1)]);
if((state_val_52127 === (1))){
var inst_52123 = (function (){return (function (result){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init9210512555929219670.clj",252,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["async evalued result: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(result)].join('')], null);
}),null)),null,1595869739);

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_chan,result);
});
})();
var inst_52124 = pinkgorilla.kernel.nrepl.clj_eval(snippet,inst_52123);
var state_52126__$1 = state_52126;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52126__$1,inst_52124);
} else {
return null;
}
});
return (function() {
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0 = (function (){
var statearr_52128 = [null,null,null,null,null,null,null];
(statearr_52128[(0)] = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__);

(statearr_52128[(1)] = (1));

return statearr_52128;
});
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1 = (function (state_52126){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_52126);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52129){if((e52129 instanceof Object)){
var ex__42066__auto__ = e52129;
var statearr_52130_52220 = state_52126;
(statearr_52130_52220[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52126);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52129;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52221 = state_52126;
state_52126 = G__52221;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__ = function(state_52126){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1.call(this,state_52126);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__;
})()
})();
var state__42131__auto__ = (function (){var statearr_52131 = (f__42130__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42130__auto__.cljs$core$IFn$_invoke$arity$0() : f__42130__auto__.call(null));
(statearr_52131[(6)] = c__42129__auto___52219);

return statearr_52131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42131__auto__);
}));


var c__42129__auto___52222 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42130__auto__ = (function (){var switch__42062__auto__ = (function (state_52136){
var state_val_52137 = (state_52136[(1)]);
if((state_val_52137 === (1))){
var state_52136__$1 = state_52136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52136__$1,(2),result_chan);
} else {
if((state_val_52137 === (2))){
var inst_52133 = (state_52136[(2)]);
var inst_52134 = cljs.core.reset_BANG_(result_atom,inst_52133);
var state_52136__$1 = state_52136;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52136__$1,inst_52134);
} else {
return null;
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0 = (function (){
var statearr_52138 = [null,null,null,null,null,null,null];
(statearr_52138[(0)] = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__);

(statearr_52138[(1)] = (1));

return statearr_52138;
});
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1 = (function (state_52136){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_52136);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52139){if((e52139 instanceof Object)){
var ex__42066__auto__ = e52139;
var statearr_52140_52223 = state_52136;
(statearr_52140_52223[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52136);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52139;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52224 = state_52136;
state_52136 = G__52224;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__ = function(state_52136){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1.call(this,state_52136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__;
})()
})();
var state__42131__auto__ = (function (){var statearr_52141 = (f__42130__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42130__auto__.cljs$core$IFn$_invoke$arity$0() : f__42130__auto__.call(null));
(statearr_52141[(6)] = c__42129__auto___52222);

return statearr_52141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42131__auto__);
}));


return result_atom;
});
goog.exportSymbol('pinkgorilla.kernel.nrepl.clj_eval_sync', pinkgorilla.kernel.nrepl.clj_eval_sync);
pinkgorilla.kernel.nrepl.clj = (function pinkgorilla$kernel$nrepl$clj(var_args){
var args__4795__auto__ = [];
var len__4789__auto___52225 = arguments.length;
var i__4790__auto___52226 = (0);
while(true){
if((i__4790__auto___52226 < len__4789__auto___52225)){
args__4795__auto__.push((arguments[i__4790__auto___52226]));

var G__52227 = (i__4790__auto___52226 + (1));
i__4790__auto___52226 = G__52227;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return pinkgorilla.kernel.nrepl.clj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});
goog.exportSymbol('pinkgorilla.kernel.nrepl.clj', pinkgorilla.kernel.nrepl.clj);

(pinkgorilla.kernel.nrepl.clj.cljs$core$IFn$_invoke$arity$variadic = (function (result_atom,function_as_string,params){
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init9210512555929219670.clj",258,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["params: ",params], null);
}),null)),null,-325452146);
var expr = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(",function_as_string], null),params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [")"], null)], 0));
var str_eval = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",expr);
var ___$1 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init9210512555929219670.clj",261,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["Calling CLJ: ",str_eval].join('')], null);
}),null)),null,-1502145200);
return pinkgorilla.kernel.nrepl.clj_eval_sync(result_atom,str_eval);
}));

(pinkgorilla.kernel.nrepl.clj.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.kernel.nrepl.clj.cljs$lang$applyTo = (function (seq52142){
var G__52143 = cljs.core.first(seq52142);
var seq52142__$1 = cljs.core.next(seq52142);
var G__52144 = cljs.core.first(seq52142__$1);
var seq52142__$2 = cljs.core.next(seq52142__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__52143,G__52144,seq52142__$2);
}));


//# sourceMappingURL=pinkgorilla.kernel.nrepl.js.map
