goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('dommy.utils');
/**
 * Returns a selector in string format.
 * Accepts string, keyword, or collection.
 */
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_(data)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(dommy.core.selector,data));
} else {
if(((typeof data === 'string') || ((data instanceof cljs.core.Keyword)))){
return cljs.core.name(data);
} else {
return null;
}
}
});
dommy.core.text = (function dommy$core$text(elem){
var or__4185__auto__ = elem.textContent;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return elem.innerText;
}
});
dommy.core.html = (function dommy$core$html(elem){
return elem.innerHTML;
});
dommy.core.value = (function dommy$core$value(elem){
return elem.value;
});
dommy.core.class$ = (function dommy$core$class(elem){
return elem.className;
});
dommy.core.attr = (function dommy$core$attr(elem,k){
if(cljs.core.truth_(k)){
return elem.getAttribute(dommy.utils.as_str(k));
} else {
return null;
}
});
/**
 * The computed style of `elem`, optionally specifying the key of
 * a particular style to return
 */
dommy.core.style = (function dommy$core$style(var_args){
var G__53571 = arguments.length;
switch (G__53571) {
case 1:
return dommy.core.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.style.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(window.getComputedStyle(elem));
}));

(dommy.core.style.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return (window.getComputedStyle(elem)[dommy.utils.as_str(k)]);
}));

(dommy.core.style.cljs$lang$maxFixedArity = 2);

dommy.core.px = (function dommy$core$px(elem,k){

var pixels = dommy.core.style.cljs$core$IFn$_invoke$arity$2(elem,k);
if(cljs.core.seq(pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Does `elem` contain `c` in its class list
 */
dommy.core.has_class_QMARK_ = (function dommy$core$has_class_QMARK_(elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto__ = elem.classList;
if(cljs.core.truth_(temp__5733__auto__)){
var class_list = temp__5733__auto__;
return class_list.contains(c__$1);
} else {
var temp__5735__auto__ = dommy.core.class$(elem);
if(cljs.core.truth_(temp__5735__auto__)){
var class_name = temp__5735__auto__;
var temp__5735__auto____$1 = dommy.utils.class_index(class_name,c__$1);
if(cljs.core.truth_(temp__5735__auto____$1)){
var i = temp__5735__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Is `elem` hidden (as associated with hide!/show!/toggle!, using display: none)
 */
dommy.core.hidden_QMARK_ = (function dommy$core$hidden_QMARK_(elem){
return (dommy.core.style.cljs$core$IFn$_invoke$arity$2(elem,new cljs.core.Keyword(null,"display","display",242065432)) === "none");
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.core.bounding_client_rect = (function dommy$core$bounding_client_rect(elem){
var r = elem.getBoundingClientRect();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top","top",-1856271961),r.top,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),r.bottom,new cljs.core.Keyword(null,"left","left",-399115937),r.left,new cljs.core.Keyword(null,"right","right",-452581833),r.right,new cljs.core.Keyword(null,"width","width",-384071477),r.width,new cljs.core.Keyword(null,"height","height",1025178622),r.height], null);
});
dommy.core.parent = (function dommy$core$parent(elem){
return elem.parentNode;
});
dommy.core.children = (function dommy$core$children(elem){
return elem.children;
});
/**
 * Lazy seq of the ancestors of `elem`
 */
dommy.core.ancestors = (function dommy$core$ancestors(elem){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.iterate(dommy.core.parent,elem));
});
dommy.core.ancestor_nodes = dommy.core.ancestors;
/**
 * Returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(var_args){
var G__53573 = arguments.length;
switch (G__53573) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array(base.querySelectorAll(dommy.core.selector(selector)));
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
}));

(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(document,selector);
}));

(dommy.core.matches_pred.cljs$lang$maxFixedArity = 2);

/**
 * Closest ancestor of `elem` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(var_args){
var G__53576 = arguments.length;
switch (G__53576) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(base,selector),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((function (p1__53574_SHARP_){
return (!((p1__53574_SHARP_ === base)));
}),dommy.core.ancestors(elem))));
}));

(dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3(document.body,elem,selector);
}));

(dommy.core.closest.cljs$lang$maxFixedArity = 3);

/**
 * Is `descendant` a descendant of `ancestor`?
 * (http://goo.gl/T8pgCX)
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
if(cljs.core.truth_(ancestor.contains)){
return ancestor.contains(descendant);
} else {
if(cljs.core.truth_(ancestor.compareDocumentPosition)){
return ((ancestor.compareDocumentPosition(descendant) & (1 << (4))) != 0);
} else {
return null;
}
}
});
/**
 * Set the textContent of `elem` to `text`, fall back to innerText
 */
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
if((!((void 0 === elem.textContent)))){
(elem.textContent = text);
} else {
(elem.innerText = text);
}

return elem;
});
/**
 * Set the innerHTML of `elem` to `html`
 */
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
(elem.innerHTML = html);

return elem;
});
/**
 * Set the value of `elem` to `value`
 */
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
(elem.value = value);

return elem;
});
/**
 * Set the css class of `elem` to `elem`
 */
dommy.core.set_class_BANG_ = (function dommy$core$set_class_BANG_(elem,c){
return (elem.className = c);
});
/**
 * Set the style of `elem` using key-value pairs:
 * 
 *    (set-style! elem :display "block" :color "red")
 */
dommy.core.set_style_BANG_ = (function dommy$core$set_style_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___54019 = arguments.length;
var i__4790__auto___54020 = (0);
while(true){
if((i__4790__auto___54020 < len__4789__auto___54019)){
args__4795__auto__.push((arguments[i__4790__auto___54020]));

var G__54021 = (i__4790__auto___54020 + (1));
i__4790__auto___54020 = G__54021;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var style = elem.style;
var seq__53579_54022 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__53580_54023 = null;
var count__53581_54024 = (0);
var i__53582_54025 = (0);
while(true){
if((i__53582_54025 < count__53581_54024)){
var vec__53589_54026 = chunk__53580_54023.cljs$core$IIndexed$_nth$arity$2(null,i__53582_54025);
var k_54027 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53589_54026,(0),null);
var v_54028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53589_54026,(1),null);
style.setProperty(dommy.utils.as_str(k_54027),v_54028);


var G__54029 = seq__53579_54022;
var G__54030 = chunk__53580_54023;
var G__54031 = count__53581_54024;
var G__54032 = (i__53582_54025 + (1));
seq__53579_54022 = G__54029;
chunk__53580_54023 = G__54030;
count__53581_54024 = G__54031;
i__53582_54025 = G__54032;
continue;
} else {
var temp__5735__auto___54033 = cljs.core.seq(seq__53579_54022);
if(temp__5735__auto___54033){
var seq__53579_54034__$1 = temp__5735__auto___54033;
if(cljs.core.chunked_seq_QMARK_(seq__53579_54034__$1)){
var c__4609__auto___54035 = cljs.core.chunk_first(seq__53579_54034__$1);
var G__54036 = cljs.core.chunk_rest(seq__53579_54034__$1);
var G__54037 = c__4609__auto___54035;
var G__54038 = cljs.core.count(c__4609__auto___54035);
var G__54039 = (0);
seq__53579_54022 = G__54036;
chunk__53580_54023 = G__54037;
count__53581_54024 = G__54038;
i__53582_54025 = G__54039;
continue;
} else {
var vec__53592_54040 = cljs.core.first(seq__53579_54034__$1);
var k_54041 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53592_54040,(0),null);
var v_54042 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53592_54040,(1),null);
style.setProperty(dommy.utils.as_str(k_54041),v_54042);


var G__54043 = cljs.core.next(seq__53579_54034__$1);
var G__54044 = null;
var G__54045 = (0);
var G__54046 = (0);
seq__53579_54022 = G__54043;
chunk__53580_54023 = G__54044;
count__53581_54024 = G__54045;
i__53582_54025 = G__54046;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.set_style_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.set_style_BANG_.cljs$lang$applyTo = (function (seq53577){
var G__53578 = cljs.core.first(seq53577);
var seq53577__$1 = cljs.core.next(seq53577);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53578,seq53577__$1);
}));

/**
 * Remove the style of `elem` using keywords:
 *   
 *    (remove-style! elem :display :color)
 */
dommy.core.remove_style_BANG_ = (function dommy$core$remove_style_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___54047 = arguments.length;
var i__4790__auto___54048 = (0);
while(true){
if((i__4790__auto___54048 < len__4789__auto___54047)){
args__4795__auto__.push((arguments[i__4790__auto___54048]));

var G__54049 = (i__4790__auto___54048 + (1));
i__4790__auto___54048 = G__54049;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,keywords){
var style = elem.style;
var seq__53597_54050 = cljs.core.seq(keywords);
var chunk__53598_54051 = null;
var count__53599_54052 = (0);
var i__53600_54053 = (0);
while(true){
if((i__53600_54053 < count__53599_54052)){
var kw_54054 = chunk__53598_54051.cljs$core$IIndexed$_nth$arity$2(null,i__53600_54053);
style.removeProperty(dommy.utils.as_str(kw_54054));


var G__54055 = seq__53597_54050;
var G__54056 = chunk__53598_54051;
var G__54057 = count__53599_54052;
var G__54058 = (i__53600_54053 + (1));
seq__53597_54050 = G__54055;
chunk__53598_54051 = G__54056;
count__53599_54052 = G__54057;
i__53600_54053 = G__54058;
continue;
} else {
var temp__5735__auto___54059 = cljs.core.seq(seq__53597_54050);
if(temp__5735__auto___54059){
var seq__53597_54060__$1 = temp__5735__auto___54059;
if(cljs.core.chunked_seq_QMARK_(seq__53597_54060__$1)){
var c__4609__auto___54061 = cljs.core.chunk_first(seq__53597_54060__$1);
var G__54062 = cljs.core.chunk_rest(seq__53597_54060__$1);
var G__54063 = c__4609__auto___54061;
var G__54064 = cljs.core.count(c__4609__auto___54061);
var G__54065 = (0);
seq__53597_54050 = G__54062;
chunk__53598_54051 = G__54063;
count__53599_54052 = G__54064;
i__53600_54053 = G__54065;
continue;
} else {
var kw_54066 = cljs.core.first(seq__53597_54060__$1);
style.removeProperty(dommy.utils.as_str(kw_54066));


var G__54067 = cljs.core.next(seq__53597_54060__$1);
var G__54068 = null;
var G__54069 = (0);
var G__54070 = (0);
seq__53597_54050 = G__54067;
chunk__53598_54051 = G__54068;
count__53599_54052 = G__54069;
i__53600_54053 = G__54070;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.remove_style_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.remove_style_BANG_.cljs$lang$applyTo = (function (seq53595){
var G__53596 = cljs.core.first(seq53595);
var seq53595__$1 = cljs.core.next(seq53595);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53596,seq53595__$1);
}));

dommy.core.set_px_BANG_ = (function dommy$core$set_px_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___54071 = arguments.length;
var i__4790__auto___54072 = (0);
while(true){
if((i__4790__auto___54072 < len__4789__auto___54071)){
args__4795__auto__.push((arguments[i__4790__auto___54072]));

var G__54073 = (i__4790__auto___54072 + (1));
i__4790__auto___54072 = G__54073;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){

if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__53603_54074 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__53604_54075 = null;
var count__53605_54076 = (0);
var i__53606_54077 = (0);
while(true){
if((i__53606_54077 < count__53605_54076)){
var vec__53613_54078 = chunk__53604_54075.cljs$core$IIndexed$_nth$arity$2(null,i__53606_54077);
var k_54079 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53613_54078,(0),null);
var v_54080 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53613_54078,(1),null);
dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k_54079,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_54080),"px"].join('')], 0));


var G__54081 = seq__53603_54074;
var G__54082 = chunk__53604_54075;
var G__54083 = count__53605_54076;
var G__54084 = (i__53606_54077 + (1));
seq__53603_54074 = G__54081;
chunk__53604_54075 = G__54082;
count__53605_54076 = G__54083;
i__53606_54077 = G__54084;
continue;
} else {
var temp__5735__auto___54085 = cljs.core.seq(seq__53603_54074);
if(temp__5735__auto___54085){
var seq__53603_54086__$1 = temp__5735__auto___54085;
if(cljs.core.chunked_seq_QMARK_(seq__53603_54086__$1)){
var c__4609__auto___54087 = cljs.core.chunk_first(seq__53603_54086__$1);
var G__54088 = cljs.core.chunk_rest(seq__53603_54086__$1);
var G__54089 = c__4609__auto___54087;
var G__54090 = cljs.core.count(c__4609__auto___54087);
var G__54091 = (0);
seq__53603_54074 = G__54088;
chunk__53604_54075 = G__54089;
count__53605_54076 = G__54090;
i__53606_54077 = G__54091;
continue;
} else {
var vec__53616_54092 = cljs.core.first(seq__53603_54086__$1);
var k_54093 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53616_54092,(0),null);
var v_54094 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53616_54092,(1),null);
dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k_54093,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_54094),"px"].join('')], 0));


var G__54095 = cljs.core.next(seq__53603_54086__$1);
var G__54096 = null;
var G__54097 = (0);
var G__54098 = (0);
seq__53603_54074 = G__54095;
chunk__53604_54075 = G__54096;
count__53605_54076 = G__54097;
i__53606_54077 = G__54098;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.set_px_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.set_px_BANG_.cljs$lang$applyTo = (function (seq53601){
var G__53602 = cljs.core.first(seq53601);
var seq53601__$1 = cljs.core.next(seq53601);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53602,seq53601__$1);
}));

/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to their name:
 * 
 *     (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 *     (set-attr! elem :id "some-id"
 *                     :name "some-name")
 */
dommy.core.set_attr_BANG_ = (function dommy$core$set_attr_BANG_(var_args){
var G__53624 = arguments.length;
switch (G__53624) {
case 2:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54100 = arguments.length;
var i__4790__auto___54101 = (0);
while(true){
if((i__4790__auto___54101 < len__4789__auto___54100)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54101]));

var G__54102 = (i__4790__auto___54101 + (1));
i__4790__auto___54101 = G__54102;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((3)),(0),null));
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4811__auto__);

}
});

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,dommy.utils.as_str(k));
}));

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
var k__$1 = dommy.utils.as_str(k);
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_(v)){
var G__53625 = elem;
(G__53625[k__$1] = v);

return G__53625;
} else {
var G__53626 = elem;
G__53626.setAttribute(k__$1,v);

return G__53626;
}
} else {
return null;
}
}));

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__53627_54103 = cljs.core.seq(cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs)));
var chunk__53628_54104 = null;
var count__53629_54105 = (0);
var i__53630_54106 = (0);
while(true){
if((i__53630_54106 < count__53629_54105)){
var vec__53641_54107 = chunk__53628_54104.cljs$core$IIndexed$_nth$arity$2(null,i__53630_54106);
var k_54108__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53641_54107,(0),null);
var v_54109__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53641_54107,(1),null);
dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k_54108__$1,v_54109__$1);


var G__54110 = seq__53627_54103;
var G__54111 = chunk__53628_54104;
var G__54112 = count__53629_54105;
var G__54113 = (i__53630_54106 + (1));
seq__53627_54103 = G__54110;
chunk__53628_54104 = G__54111;
count__53629_54105 = G__54112;
i__53630_54106 = G__54113;
continue;
} else {
var temp__5735__auto___54114 = cljs.core.seq(seq__53627_54103);
if(temp__5735__auto___54114){
var seq__53627_54115__$1 = temp__5735__auto___54114;
if(cljs.core.chunked_seq_QMARK_(seq__53627_54115__$1)){
var c__4609__auto___54116 = cljs.core.chunk_first(seq__53627_54115__$1);
var G__54117 = cljs.core.chunk_rest(seq__53627_54115__$1);
var G__54118 = c__4609__auto___54116;
var G__54119 = cljs.core.count(c__4609__auto___54116);
var G__54120 = (0);
seq__53627_54103 = G__54117;
chunk__53628_54104 = G__54118;
count__53629_54105 = G__54119;
i__53630_54106 = G__54120;
continue;
} else {
var vec__53650_54121 = cljs.core.first(seq__53627_54115__$1);
var k_54122__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53650_54121,(0),null);
var v_54123__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53650_54121,(1),null);
dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k_54122__$1,v_54123__$1);


var G__54124 = cljs.core.next(seq__53627_54115__$1);
var G__54125 = null;
var G__54126 = (0);
var G__54127 = (0);
seq__53627_54103 = G__54124;
chunk__53628_54104 = G__54125;
count__53629_54105 = G__54126;
i__53630_54106 = G__54127;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.set_attr_BANG_.cljs$lang$applyTo = (function (seq53620){
var G__53621 = cljs.core.first(seq53620);
var seq53620__$1 = cljs.core.next(seq53620);
var G__53622 = cljs.core.first(seq53620__$1);
var seq53620__$2 = cljs.core.next(seq53620__$1);
var G__53623 = cljs.core.first(seq53620__$2);
var seq53620__$3 = cljs.core.next(seq53620__$2);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53621,G__53622,G__53623,seq53620__$3);
}));

(dommy.core.set_attr_BANG_.cljs$lang$maxFixedArity = (3));

/**
 * Removes dom attributes on and returns `elem`.
 * `class` and `classes` are special cases which clear
 * out the class name on removal.
 */
dommy.core.remove_attr_BANG_ = (function dommy$core$remove_attr_BANG_(var_args){
var G__53658 = arguments.length;
switch (G__53658) {
case 2:
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54129 = arguments.length;
var i__4790__auto___54130 = (0);
while(true){
if((i__4790__auto___54130 < len__4789__auto___54129)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54130]));

var G__54131 = (i__4790__auto___54130 + (1));
i__4790__auto___54130 = G__54131;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var k_54132__$1 = dommy.utils.as_str(k);
if(cljs.core.truth_((function (){var fexpr__53660 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["class",null,"classes",null], null), null);
return (fexpr__53660.cljs$core$IFn$_invoke$arity$1 ? fexpr__53660.cljs$core$IFn$_invoke$arity$1(k_54132__$1) : fexpr__53660.call(null,k_54132__$1));
})())){
dommy.core.set_class_BANG_(elem,"");
} else {
elem.removeAttribute(k_54132__$1);
}

return elem;
}));

(dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var seq__53661_54133 = cljs.core.seq(cljs.core.cons(k,ks));
var chunk__53662_54134 = null;
var count__53663_54135 = (0);
var i__53664_54136 = (0);
while(true){
if((i__53664_54136 < count__53663_54135)){
var k_54137__$1 = chunk__53662_54134.cljs$core$IIndexed$_nth$arity$2(null,i__53664_54136);
dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k_54137__$1);


var G__54138 = seq__53661_54133;
var G__54139 = chunk__53662_54134;
var G__54140 = count__53663_54135;
var G__54141 = (i__53664_54136 + (1));
seq__53661_54133 = G__54138;
chunk__53662_54134 = G__54139;
count__53663_54135 = G__54140;
i__53664_54136 = G__54141;
continue;
} else {
var temp__5735__auto___54142 = cljs.core.seq(seq__53661_54133);
if(temp__5735__auto___54142){
var seq__53661_54143__$1 = temp__5735__auto___54142;
if(cljs.core.chunked_seq_QMARK_(seq__53661_54143__$1)){
var c__4609__auto___54144 = cljs.core.chunk_first(seq__53661_54143__$1);
var G__54145 = cljs.core.chunk_rest(seq__53661_54143__$1);
var G__54146 = c__4609__auto___54144;
var G__54147 = cljs.core.count(c__4609__auto___54144);
var G__54148 = (0);
seq__53661_54133 = G__54145;
chunk__53662_54134 = G__54146;
count__53663_54135 = G__54147;
i__53664_54136 = G__54148;
continue;
} else {
var k_54149__$1 = cljs.core.first(seq__53661_54143__$1);
dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k_54149__$1);


var G__54150 = cljs.core.next(seq__53661_54143__$1);
var G__54151 = null;
var G__54152 = (0);
var G__54153 = (0);
seq__53661_54133 = G__54150;
chunk__53662_54134 = G__54151;
count__53663_54135 = G__54152;
i__53664_54136 = G__54153;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.remove_attr_BANG_.cljs$lang$applyTo = (function (seq53655){
var G__53656 = cljs.core.first(seq53655);
var seq53655__$1 = cljs.core.next(seq53655);
var G__53657 = cljs.core.first(seq53655__$1);
var seq53655__$2 = cljs.core.next(seq53655__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53656,G__53657,seq53655__$2);
}));

(dommy.core.remove_attr_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Toggles a dom attribute `k` on `elem`, optionally specifying
 * the boolean value with `add?`
 */
dommy.core.toggle_attr_BANG_ = (function dommy$core$toggle_attr_BANG_(var_args){
var G__53667 = arguments.length;
switch (G__53667) {
case 2:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,cljs.core.boolean$(dommy.core.attr(elem,k)));
}));

(dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
if(add_QMARK_){
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k);
} else {
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k);
}
}));

(dommy.core.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Add `classes` to `elem`, trying to use Element::classList, and
 * falling back to fast string parsing/manipulation
 */
dommy.core.add_class_BANG_ = (function dommy$core$add_class_BANG_(var_args){
var G__53672 = arguments.length;
switch (G__53672) {
case 2:
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54156 = arguments.length;
var i__4790__auto___54157 = (0);
while(true){
if((i__4790__auto___54157 < len__4789__auto___54156)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54157]));

var G__54158 = (i__4790__auto___54157 + (1));
i__4790__auto___54157 = G__54158;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var classes__$1 = clojure.string.trim(dommy.utils.as_str(classes)).split(/\s+/);
if(cljs.core.seq(classes__$1)){
var temp__5733__auto___54159 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___54159)){
var class_list_54160 = temp__5733__auto___54159;
var seq__53675_54161 = cljs.core.seq(classes__$1);
var chunk__53676_54162 = null;
var count__53677_54163 = (0);
var i__53678_54164 = (0);
while(true){
if((i__53678_54164 < count__53677_54163)){
var c_54165 = chunk__53676_54162.cljs$core$IIndexed$_nth$arity$2(null,i__53678_54164);
class_list_54160.add(c_54165);


var G__54166 = seq__53675_54161;
var G__54167 = chunk__53676_54162;
var G__54168 = count__53677_54163;
var G__54169 = (i__53678_54164 + (1));
seq__53675_54161 = G__54166;
chunk__53676_54162 = G__54167;
count__53677_54163 = G__54168;
i__53678_54164 = G__54169;
continue;
} else {
var temp__5735__auto___54170 = cljs.core.seq(seq__53675_54161);
if(temp__5735__auto___54170){
var seq__53675_54171__$1 = temp__5735__auto___54170;
if(cljs.core.chunked_seq_QMARK_(seq__53675_54171__$1)){
var c__4609__auto___54172 = cljs.core.chunk_first(seq__53675_54171__$1);
var G__54173 = cljs.core.chunk_rest(seq__53675_54171__$1);
var G__54174 = c__4609__auto___54172;
var G__54175 = cljs.core.count(c__4609__auto___54172);
var G__54176 = (0);
seq__53675_54161 = G__54173;
chunk__53676_54162 = G__54174;
count__53677_54163 = G__54175;
i__53678_54164 = G__54176;
continue;
} else {
var c_54177 = cljs.core.first(seq__53675_54171__$1);
class_list_54160.add(c_54177);


var G__54178 = cljs.core.next(seq__53675_54171__$1);
var G__54179 = null;
var G__54180 = (0);
var G__54181 = (0);
seq__53675_54161 = G__54178;
chunk__53676_54162 = G__54179;
count__53677_54163 = G__54180;
i__53678_54164 = G__54181;
continue;
}
} else {
}
}
break;
}
} else {
var seq__53679_54182 = cljs.core.seq(classes__$1);
var chunk__53680_54183 = null;
var count__53681_54184 = (0);
var i__53682_54185 = (0);
while(true){
if((i__53682_54185 < count__53681_54184)){
var c_54186 = chunk__53680_54183.cljs$core$IIndexed$_nth$arity$2(null,i__53682_54185);
var class_name_54187 = dommy.core.class$(elem);
if(cljs.core.truth_(dommy.utils.class_index(class_name_54187,c_54186))){
} else {
dommy.core.set_class_BANG_(elem,(((class_name_54187 === ""))?c_54186:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_54187)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_54186)].join('')));
}


var G__54188 = seq__53679_54182;
var G__54189 = chunk__53680_54183;
var G__54190 = count__53681_54184;
var G__54191 = (i__53682_54185 + (1));
seq__53679_54182 = G__54188;
chunk__53680_54183 = G__54189;
count__53681_54184 = G__54190;
i__53682_54185 = G__54191;
continue;
} else {
var temp__5735__auto___54192 = cljs.core.seq(seq__53679_54182);
if(temp__5735__auto___54192){
var seq__53679_54193__$1 = temp__5735__auto___54192;
if(cljs.core.chunked_seq_QMARK_(seq__53679_54193__$1)){
var c__4609__auto___54194 = cljs.core.chunk_first(seq__53679_54193__$1);
var G__54195 = cljs.core.chunk_rest(seq__53679_54193__$1);
var G__54196 = c__4609__auto___54194;
var G__54197 = cljs.core.count(c__4609__auto___54194);
var G__54198 = (0);
seq__53679_54182 = G__54195;
chunk__53680_54183 = G__54196;
count__53681_54184 = G__54197;
i__53682_54185 = G__54198;
continue;
} else {
var c_54199 = cljs.core.first(seq__53679_54193__$1);
var class_name_54200 = dommy.core.class$(elem);
if(cljs.core.truth_(dommy.utils.class_index(class_name_54200,c_54199))){
} else {
dommy.core.set_class_BANG_(elem,(((class_name_54200 === ""))?c_54199:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_54200)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_54199)].join('')));
}


var G__54201 = cljs.core.next(seq__53679_54193__$1);
var G__54202 = null;
var G__54203 = (0);
var G__54204 = (0);
seq__53679_54182 = G__54201;
chunk__53680_54183 = G__54202;
count__53681_54184 = G__54203;
i__53682_54185 = G__54204;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem;
}));

(dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var seq__53686_54205 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(more_classes,classes));
var chunk__53687_54206 = null;
var count__53688_54207 = (0);
var i__53689_54208 = (0);
while(true){
if((i__53689_54208 < count__53688_54207)){
var c_54209 = chunk__53687_54206.cljs$core$IIndexed$_nth$arity$2(null,i__53689_54208);
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c_54209);


var G__54210 = seq__53686_54205;
var G__54211 = chunk__53687_54206;
var G__54212 = count__53688_54207;
var G__54213 = (i__53689_54208 + (1));
seq__53686_54205 = G__54210;
chunk__53687_54206 = G__54211;
count__53688_54207 = G__54212;
i__53689_54208 = G__54213;
continue;
} else {
var temp__5735__auto___54214 = cljs.core.seq(seq__53686_54205);
if(temp__5735__auto___54214){
var seq__53686_54215__$1 = temp__5735__auto___54214;
if(cljs.core.chunked_seq_QMARK_(seq__53686_54215__$1)){
var c__4609__auto___54216 = cljs.core.chunk_first(seq__53686_54215__$1);
var G__54217 = cljs.core.chunk_rest(seq__53686_54215__$1);
var G__54218 = c__4609__auto___54216;
var G__54219 = cljs.core.count(c__4609__auto___54216);
var G__54220 = (0);
seq__53686_54205 = G__54217;
chunk__53687_54206 = G__54218;
count__53688_54207 = G__54219;
i__53689_54208 = G__54220;
continue;
} else {
var c_54221 = cljs.core.first(seq__53686_54215__$1);
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c_54221);


var G__54222 = cljs.core.next(seq__53686_54215__$1);
var G__54223 = null;
var G__54224 = (0);
var G__54225 = (0);
seq__53686_54205 = G__54222;
chunk__53687_54206 = G__54223;
count__53688_54207 = G__54224;
i__53689_54208 = G__54225;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.add_class_BANG_.cljs$lang$applyTo = (function (seq53669){
var G__53670 = cljs.core.first(seq53669);
var seq53669__$1 = cljs.core.next(seq53669);
var G__53671 = cljs.core.first(seq53669__$1);
var seq53669__$2 = cljs.core.next(seq53669__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53670,G__53671,seq53669__$2);
}));

(dommy.core.add_class_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Remove `c` from `elem` class list
 */
dommy.core.remove_class_BANG_ = (function dommy$core$remove_class_BANG_(var_args){
var G__53701 = arguments.length;
switch (G__53701) {
case 2:
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54227 = arguments.length;
var i__4790__auto___54228 = (0);
while(true){
if((i__4790__auto___54228 < len__4789__auto___54227)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54228]));

var G__54229 = (i__4790__auto___54228 + (1));
i__4790__auto___54228 = G__54229;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto___54230 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___54230)){
var class_list_54231 = temp__5733__auto___54230;
class_list_54231.remove(c__$1);
} else {
var class_name_54232 = dommy.core.class$(elem);
var new_class_name_54233 = dommy.utils.remove_class_str(class_name_54232,c__$1);
if((class_name_54232 === new_class_name_54233)){
} else {
dommy.core.set_class_BANG_(elem,new_class_name_54233);
}
}

return elem;
}));

(dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var seq__53706 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(classes,class$));
var chunk__53707 = null;
var count__53708 = (0);
var i__53709 = (0);
while(true){
if((i__53709 < count__53708)){
var c = chunk__53707.cljs$core$IIndexed$_nth$arity$2(null,i__53709);
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c);


var G__54234 = seq__53706;
var G__54235 = chunk__53707;
var G__54236 = count__53708;
var G__54237 = (i__53709 + (1));
seq__53706 = G__54234;
chunk__53707 = G__54235;
count__53708 = G__54236;
i__53709 = G__54237;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__53706);
if(temp__5735__auto__){
var seq__53706__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53706__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__53706__$1);
var G__54238 = cljs.core.chunk_rest(seq__53706__$1);
var G__54239 = c__4609__auto__;
var G__54240 = cljs.core.count(c__4609__auto__);
var G__54241 = (0);
seq__53706 = G__54238;
chunk__53707 = G__54239;
count__53708 = G__54240;
i__53709 = G__54241;
continue;
} else {
var c = cljs.core.first(seq__53706__$1);
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c);


var G__54242 = cljs.core.next(seq__53706__$1);
var G__54243 = null;
var G__54244 = (0);
var G__54245 = (0);
seq__53706 = G__54242;
chunk__53707 = G__54243;
count__53708 = G__54244;
i__53709 = G__54245;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(dommy.core.remove_class_BANG_.cljs$lang$applyTo = (function (seq53698){
var G__53699 = cljs.core.first(seq53698);
var seq53698__$1 = cljs.core.next(seq53698);
var G__53700 = cljs.core.first(seq53698__$1);
var seq53698__$2 = cljs.core.next(seq53698__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53699,G__53700,seq53698__$2);
}));

(dommy.core.remove_class_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.core.toggle_class_BANG_ = (function dommy$core$toggle_class_BANG_(var_args){
var G__53717 = arguments.length;
switch (G__53717) {
case 2:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto___54247 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___54247)){
var class_list_54248 = temp__5733__auto___54247;
class_list_54248.toggle(c__$1);
} else {
dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3(elem,c__$1,(!(dommy.core.has_class_QMARK_(elem,c__$1))));
}

return elem;
}));

(dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
if(add_QMARK_){
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,class$);
} else {
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,class$);
}

return elem;
}));

(dommy.core.toggle_class_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Display or hide the given `elem` (using display: none).
 * Takes an optional boolean `show?`
 */
dommy.core.toggle_BANG_ = (function dommy$core$toggle_BANG_(var_args){
var G__53719 = arguments.length;
switch (G__53719) {
case 2:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"display","display",242065432),((show_QMARK_)?"":"none")], 0));
}));

(dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,dommy.core.hidden_QMARK_(elem));
}));

(dommy.core.toggle_BANG_.cljs$lang$maxFixedArity = 2);

dommy.core.hide_BANG_ = (function dommy$core$hide_BANG_(elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,false);
});
dommy.core.show_BANG_ = (function dommy$core$show_BANG_(elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,true);
});
dommy.core.scroll_into_view = (function dommy$core$scroll_into_view(elem,align_with_top_QMARK_){
var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.core.bounding_client_rect(elem));
if((window.innerHeight < (top + elem.offsetHeight))){
return elem.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
dommy.core.create_element = (function dommy$core$create_element(var_args){
var G__53725 = arguments.length;
switch (G__53725) {
case 1:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.create_element.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return document.createElement(dommy.utils.as_str(tag));
}));

(dommy.core.create_element.cljs$core$IFn$_invoke$arity$2 = (function (tag_ns,tag){
return document.createElementNS(dommy.utils.as_str(tag_ns),dommy.utils.as_str(tag));
}));

(dommy.core.create_element.cljs$lang$maxFixedArity = 2);

dommy.core.create_text_node = (function dommy$core$create_text_node(text){
return document.createTextNode(text);
});
/**
 * Clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.core.set_html_BANG_(elem,"");
});
/**
 * Append `child` to `parent`
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(var_args){
var G__53732 = arguments.length;
switch (G__53732) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54252 = arguments.length;
var i__4790__auto___54253 = (0);
while(true){
if((i__4790__auto___54253 < len__4789__auto___54252)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54253]));

var G__54254 = (i__4790__auto___54253 + (1));
i__4790__auto___54253 = G__54254;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__53734 = parent;
G__53734.appendChild(child);

return G__53734;
}));

(dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__53735_54255 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__53736_54256 = null;
var count__53737_54257 = (0);
var i__53738_54258 = (0);
while(true){
if((i__53738_54258 < count__53737_54257)){
var c_54259 = chunk__53736_54256.cljs$core$IIndexed$_nth$arity$2(null,i__53738_54258);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_54259);


var G__54260 = seq__53735_54255;
var G__54261 = chunk__53736_54256;
var G__54262 = count__53737_54257;
var G__54263 = (i__53738_54258 + (1));
seq__53735_54255 = G__54260;
chunk__53736_54256 = G__54261;
count__53737_54257 = G__54262;
i__53738_54258 = G__54263;
continue;
} else {
var temp__5735__auto___54264 = cljs.core.seq(seq__53735_54255);
if(temp__5735__auto___54264){
var seq__53735_54265__$1 = temp__5735__auto___54264;
if(cljs.core.chunked_seq_QMARK_(seq__53735_54265__$1)){
var c__4609__auto___54266 = cljs.core.chunk_first(seq__53735_54265__$1);
var G__54267 = cljs.core.chunk_rest(seq__53735_54265__$1);
var G__54268 = c__4609__auto___54266;
var G__54269 = cljs.core.count(c__4609__auto___54266);
var G__54270 = (0);
seq__53735_54255 = G__54267;
chunk__53736_54256 = G__54268;
count__53737_54257 = G__54269;
i__53738_54258 = G__54270;
continue;
} else {
var c_54271 = cljs.core.first(seq__53735_54265__$1);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_54271);


var G__54272 = cljs.core.next(seq__53735_54265__$1);
var G__54273 = null;
var G__54274 = (0);
var G__54275 = (0);
seq__53735_54255 = G__54272;
chunk__53736_54256 = G__54273;
count__53737_54257 = G__54274;
i__53738_54258 = G__54275;
continue;
}
} else {
}
}
break;
}

return parent;
}));

/** @this {Function} */
(dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq53727){
var G__53728 = cljs.core.first(seq53727);
var seq53727__$1 = cljs.core.next(seq53727);
var G__53729 = cljs.core.first(seq53727__$1);
var seq53727__$2 = cljs.core.next(seq53727__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53728,G__53729,seq53727__$2);
}));

(dommy.core.append_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Prepend `child` to `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(var_args){
var G__53748 = arguments.length;
switch (G__53748) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___54277 = arguments.length;
var i__4790__auto___54278 = (0);
while(true){
if((i__4790__auto___54278 < len__4789__auto___54277)){
args_arr__4810__auto__.push((arguments[i__4790__auto___54278]));

var G__54279 = (i__4790__auto___54278 + (1));
i__4790__auto___54278 = G__54279;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__53750 = parent;
G__53750.insertBefore(child,parent.firstChild);

return G__53750;
}));

(dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__53751_54280 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__53752_54281 = null;
var count__53753_54282 = (0);
var i__53754_54283 = (0);
while(true){
if((i__53754_54283 < count__53753_54282)){
var c_54284 = chunk__53752_54281.cljs$core$IIndexed$_nth$arity$2(null,i__53754_54283);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_54284);


var G__54285 = seq__53751_54280;
var G__54286 = chunk__53752_54281;
var G__54287 = count__53753_54282;
var G__54288 = (i__53754_54283 + (1));
seq__53751_54280 = G__54285;
chunk__53752_54281 = G__54286;
count__53753_54282 = G__54287;
i__53754_54283 = G__54288;
continue;
} else {
var temp__5735__auto___54289 = cljs.core.seq(seq__53751_54280);
if(temp__5735__auto___54289){
var seq__53751_54290__$1 = temp__5735__auto___54289;
if(cljs.core.chunked_seq_QMARK_(seq__53751_54290__$1)){
var c__4609__auto___54291 = cljs.core.chunk_first(seq__53751_54290__$1);
var G__54292 = cljs.core.chunk_rest(seq__53751_54290__$1);
var G__54293 = c__4609__auto___54291;
var G__54294 = cljs.core.count(c__4609__auto___54291);
var G__54295 = (0);
seq__53751_54280 = G__54292;
chunk__53752_54281 = G__54293;
count__53753_54282 = G__54294;
i__53754_54283 = G__54295;
continue;
} else {
var c_54296 = cljs.core.first(seq__53751_54290__$1);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_54296);


var G__54297 = cljs.core.next(seq__53751_54290__$1);
var G__54298 = null;
var G__54299 = (0);
var G__54300 = (0);
seq__53751_54280 = G__54297;
chunk__53752_54281 = G__54298;
count__53753_54282 = G__54299;
i__53754_54283 = G__54300;
continue;
}
} else {
}
}
break;
}

return parent;
}));

/** @this {Function} */
(dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq53743){
var G__53744 = cljs.core.first(seq53743);
var seq53743__$1 = cljs.core.next(seq53743);
var G__53745 = cljs.core.first(seq53743__$1);
var seq53743__$2 = cljs.core.next(seq53743__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53744,G__53745,seq53743__$2);
}));

(dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Insert `elem` before `other`, `other` must have a parent
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var p = dommy.core.parent(other);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

p.insertBefore(elem,other);

return elem;
});
/**
 * Insert `elem` after `other`, `other` must have a parent
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var temp__5733__auto___54301 = other.nextSibling;
if(cljs.core.truth_(temp__5733__auto___54301)){
var next_54302 = temp__5733__auto___54301;
dommy.core.insert_before_BANG_(elem,next_54302);
} else {
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(dommy.core.parent(other),elem);
}

return elem;
});
/**
 * Replace `elem` with `new`, return `new`
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var p = dommy.core.parent(elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

p.replaceChild(new$,elem);

return new$;
});
/**
 * Replace children of `elem` with `child`
 */
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(p,child){
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(dommy.core.clear_BANG_(p),child);
});
/**
 * Remove `elem` from `parent`, return `parent`
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(var_args){
var G__53762 = arguments.length;
switch (G__53762) {
case 1:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var p = dommy.core.parent(elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2(p,elem);
}));

(dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (p,elem){
var G__53763 = p;
G__53763.removeChild(elem);

return G__53763;
}));

(dommy.core.remove_BANG_.cljs$lang$maxFixedArity = 2);

dommy.core.special_listener_makers = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__53764){
var vec__53765 = p__53764;
var special_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53765,(0),null);
var real_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53765,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,cljs.core.PersistentArrayMap.createAsIfByAssoc([real_mouse_event,(function (f){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__4185__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__4174__auto__ = related_target;
if(cljs.core.truth_(and__4174__auto__)){
return dommy.core.descendant_QMARK_(related_target,listener_target);
} else {
return and__4174__auto__;
}
})())){
return null;
} else {
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(event) : f.call(null,event));
}
});
})])], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.cljs$core$IFn$_invoke$arity$3(elem,event.target,selector);
if(cljs.core.truth_((function (){var and__4174__auto__ = selected_target;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.not(dommy.core.attr(selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else {
return and__4174__auto__;
}
})())){
(event.selectedTarget = selected_target);

return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(event) : f.call(null,event));
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `elem`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__4185__auto__ = elem.dommyEventListeners;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___54304 = arguments.length;
var i__4790__auto___54305 = (0);
while(true){
if((i__4790__auto___54305 < len__4789__auto___54304)){
args__4795__auto__.push((arguments[i__4790__auto___54305]));

var G__54306 = (i__4790__auto___54305 + (1));
i__4790__auto___54305 = G__54306;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = elem;
return (elem__$1.dommyEventListeners = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,dommy.core.event_listeners(elem__$1),args));
}));

(dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq53768){
var G__53769 = cljs.core.first(seq53768);
var seq53768__$1 = cljs.core.next(seq53768);
var G__53770 = cljs.core.first(seq53768__$1);
var seq53768__$2 = cljs.core.next(seq53768__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53769,G__53770,seq53768__$2);
}));

dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_(elem_sel)){
var fexpr__53771 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.rest);
return (fexpr__53771.cljs$core$IFn$_invoke$arity$1 ? fexpr__53771.cljs$core$IFn$_invoke$arity$1(elem_sel) : fexpr__53771.call(null,elem_sel));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elem_sel,null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 *     (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 *     (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 *     (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___54307 = arguments.length;
var i__4790__auto___54308 = (0);
while(true){
if((i__4790__auto___54308 < len__4789__auto___54307)){
args__4795__auto__.push((arguments[i__4790__auto___54308]));

var G__54309 = (i__4790__auto___54308 + (1));
i__4790__auto___54308 = G__54309;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__53774_54310 = dommy.core.elem_and_selector(elem_sel);
var elem_54311 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53774_54310,(0),null);
var selector_54312 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53774_54310,(1),null);
var seq__53777_54313 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__53784_54314 = null;
var count__53785_54315 = (0);
var i__53786_54316 = (0);
while(true){
if((i__53786_54316 < count__53785_54315)){
var vec__53843_54317 = chunk__53784_54314.cljs$core$IIndexed$_nth$arity$2(null,i__53786_54316);
var orig_type_54318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53843_54317,(0),null);
var f_54319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53843_54317,(1),null);
var seq__53787_54320 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_54318,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_54318,cljs.core.identity])));
var chunk__53789_54321 = null;
var count__53790_54322 = (0);
var i__53791_54323 = (0);
while(true){
if((i__53791_54323 < count__53790_54322)){
var vec__53856_54324 = chunk__53789_54321.cljs$core$IIndexed$_nth$arity$2(null,i__53791_54323);
var actual_type_54325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53856_54324,(0),null);
var factory_54326 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53856_54324,(1),null);
var canonical_f_54327 = (function (){var G__53860 = (factory_54326.cljs$core$IFn$_invoke$arity$1 ? factory_54326.cljs$core$IFn$_invoke$arity$1(f_54319) : factory_54326.call(null,f_54319));
var fexpr__53859 = (cljs.core.truth_(selector_54312)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_54311,selector_54312):cljs.core.identity);
return (fexpr__53859.cljs$core$IFn$_invoke$arity$1 ? fexpr__53859.cljs$core$IFn$_invoke$arity$1(G__53860) : fexpr__53859.call(null,G__53860));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54311,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54312,actual_type_54325,f_54319], null),canonical_f_54327], 0));

if(cljs.core.truth_(elem_54311.addEventListener)){
elem_54311.addEventListener(cljs.core.name(actual_type_54325),canonical_f_54327);
} else {
elem_54311.attachEvent(cljs.core.name(actual_type_54325),canonical_f_54327);
}


var G__54328 = seq__53787_54320;
var G__54329 = chunk__53789_54321;
var G__54330 = count__53790_54322;
var G__54331 = (i__53791_54323 + (1));
seq__53787_54320 = G__54328;
chunk__53789_54321 = G__54329;
count__53790_54322 = G__54330;
i__53791_54323 = G__54331;
continue;
} else {
var temp__5735__auto___54332 = cljs.core.seq(seq__53787_54320);
if(temp__5735__auto___54332){
var seq__53787_54333__$1 = temp__5735__auto___54332;
if(cljs.core.chunked_seq_QMARK_(seq__53787_54333__$1)){
var c__4609__auto___54334 = cljs.core.chunk_first(seq__53787_54333__$1);
var G__54335 = cljs.core.chunk_rest(seq__53787_54333__$1);
var G__54336 = c__4609__auto___54334;
var G__54337 = cljs.core.count(c__4609__auto___54334);
var G__54338 = (0);
seq__53787_54320 = G__54335;
chunk__53789_54321 = G__54336;
count__53790_54322 = G__54337;
i__53791_54323 = G__54338;
continue;
} else {
var vec__53866_54339 = cljs.core.first(seq__53787_54333__$1);
var actual_type_54340 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53866_54339,(0),null);
var factory_54341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53866_54339,(1),null);
var canonical_f_54342 = (function (){var G__53870 = (factory_54341.cljs$core$IFn$_invoke$arity$1 ? factory_54341.cljs$core$IFn$_invoke$arity$1(f_54319) : factory_54341.call(null,f_54319));
var fexpr__53869 = (cljs.core.truth_(selector_54312)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_54311,selector_54312):cljs.core.identity);
return (fexpr__53869.cljs$core$IFn$_invoke$arity$1 ? fexpr__53869.cljs$core$IFn$_invoke$arity$1(G__53870) : fexpr__53869.call(null,G__53870));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54311,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54312,actual_type_54340,f_54319], null),canonical_f_54342], 0));

if(cljs.core.truth_(elem_54311.addEventListener)){
elem_54311.addEventListener(cljs.core.name(actual_type_54340),canonical_f_54342);
} else {
elem_54311.attachEvent(cljs.core.name(actual_type_54340),canonical_f_54342);
}


var G__54343 = cljs.core.next(seq__53787_54333__$1);
var G__54344 = null;
var G__54345 = (0);
var G__54346 = (0);
seq__53787_54320 = G__54343;
chunk__53789_54321 = G__54344;
count__53790_54322 = G__54345;
i__53791_54323 = G__54346;
continue;
}
} else {
}
}
break;
}

var G__54347 = seq__53777_54313;
var G__54348 = chunk__53784_54314;
var G__54349 = count__53785_54315;
var G__54350 = (i__53786_54316 + (1));
seq__53777_54313 = G__54347;
chunk__53784_54314 = G__54348;
count__53785_54315 = G__54349;
i__53786_54316 = G__54350;
continue;
} else {
var temp__5735__auto___54351 = cljs.core.seq(seq__53777_54313);
if(temp__5735__auto___54351){
var seq__53777_54352__$1 = temp__5735__auto___54351;
if(cljs.core.chunked_seq_QMARK_(seq__53777_54352__$1)){
var c__4609__auto___54353 = cljs.core.chunk_first(seq__53777_54352__$1);
var G__54354 = cljs.core.chunk_rest(seq__53777_54352__$1);
var G__54355 = c__4609__auto___54353;
var G__54356 = cljs.core.count(c__4609__auto___54353);
var G__54357 = (0);
seq__53777_54313 = G__54354;
chunk__53784_54314 = G__54355;
count__53785_54315 = G__54356;
i__53786_54316 = G__54357;
continue;
} else {
var vec__53875_54358 = cljs.core.first(seq__53777_54352__$1);
var orig_type_54359 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53875_54358,(0),null);
var f_54360 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53875_54358,(1),null);
var seq__53778_54361 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_54359,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_54359,cljs.core.identity])));
var chunk__53780_54362 = null;
var count__53781_54363 = (0);
var i__53782_54364 = (0);
while(true){
if((i__53782_54364 < count__53781_54363)){
var vec__53891_54365 = chunk__53780_54362.cljs$core$IIndexed$_nth$arity$2(null,i__53782_54364);
var actual_type_54366 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53891_54365,(0),null);
var factory_54367 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53891_54365,(1),null);
var canonical_f_54368 = (function (){var G__53895 = (factory_54367.cljs$core$IFn$_invoke$arity$1 ? factory_54367.cljs$core$IFn$_invoke$arity$1(f_54360) : factory_54367.call(null,f_54360));
var fexpr__53894 = (cljs.core.truth_(selector_54312)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_54311,selector_54312):cljs.core.identity);
return (fexpr__53894.cljs$core$IFn$_invoke$arity$1 ? fexpr__53894.cljs$core$IFn$_invoke$arity$1(G__53895) : fexpr__53894.call(null,G__53895));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54311,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54312,actual_type_54366,f_54360], null),canonical_f_54368], 0));

if(cljs.core.truth_(elem_54311.addEventListener)){
elem_54311.addEventListener(cljs.core.name(actual_type_54366),canonical_f_54368);
} else {
elem_54311.attachEvent(cljs.core.name(actual_type_54366),canonical_f_54368);
}


var G__54369 = seq__53778_54361;
var G__54370 = chunk__53780_54362;
var G__54371 = count__53781_54363;
var G__54372 = (i__53782_54364 + (1));
seq__53778_54361 = G__54369;
chunk__53780_54362 = G__54370;
count__53781_54363 = G__54371;
i__53782_54364 = G__54372;
continue;
} else {
var temp__5735__auto___54373__$1 = cljs.core.seq(seq__53778_54361);
if(temp__5735__auto___54373__$1){
var seq__53778_54374__$1 = temp__5735__auto___54373__$1;
if(cljs.core.chunked_seq_QMARK_(seq__53778_54374__$1)){
var c__4609__auto___54375 = cljs.core.chunk_first(seq__53778_54374__$1);
var G__54376 = cljs.core.chunk_rest(seq__53778_54374__$1);
var G__54377 = c__4609__auto___54375;
var G__54378 = cljs.core.count(c__4609__auto___54375);
var G__54379 = (0);
seq__53778_54361 = G__54376;
chunk__53780_54362 = G__54377;
count__53781_54363 = G__54378;
i__53782_54364 = G__54379;
continue;
} else {
var vec__53896_54380 = cljs.core.first(seq__53778_54374__$1);
var actual_type_54381 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53896_54380,(0),null);
var factory_54382 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53896_54380,(1),null);
var canonical_f_54383 = (function (){var G__53900 = (factory_54382.cljs$core$IFn$_invoke$arity$1 ? factory_54382.cljs$core$IFn$_invoke$arity$1(f_54360) : factory_54382.call(null,f_54360));
var fexpr__53899 = (cljs.core.truth_(selector_54312)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_54311,selector_54312):cljs.core.identity);
return (fexpr__53899.cljs$core$IFn$_invoke$arity$1 ? fexpr__53899.cljs$core$IFn$_invoke$arity$1(G__53900) : fexpr__53899.call(null,G__53900));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54311,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54312,actual_type_54381,f_54360], null),canonical_f_54383], 0));

if(cljs.core.truth_(elem_54311.addEventListener)){
elem_54311.addEventListener(cljs.core.name(actual_type_54381),canonical_f_54383);
} else {
elem_54311.attachEvent(cljs.core.name(actual_type_54381),canonical_f_54383);
}


var G__54384 = cljs.core.next(seq__53778_54374__$1);
var G__54385 = null;
var G__54386 = (0);
var G__54387 = (0);
seq__53778_54361 = G__54384;
chunk__53780_54362 = G__54385;
count__53781_54363 = G__54386;
i__53782_54364 = G__54387;
continue;
}
} else {
}
}
break;
}

var G__54388 = cljs.core.next(seq__53777_54352__$1);
var G__54389 = null;
var G__54390 = (0);
var G__54391 = (0);
seq__53777_54313 = G__54388;
chunk__53784_54314 = G__54389;
count__53785_54315 = G__54390;
i__53786_54316 = G__54391;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq53772){
var G__53773 = cljs.core.first(seq53772);
var seq53772__$1 = cljs.core.next(seq53772);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53773,seq53772__$1);
}));

/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 *   The following forms are allowed, and will remove all handlers
 *   that match the parameters passed in:
 * 
 *    (unlisten! [elem :.selector] :click event-listener)
 * 
 *    (unlisten! [elem :.selector]
 *      :click event-listener
 *      :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___54392 = arguments.length;
var i__4790__auto___54393 = (0);
while(true){
if((i__4790__auto___54393 < len__4789__auto___54392)){
args__4795__auto__.push((arguments[i__4790__auto___54393]));

var G__54394 = (i__4790__auto___54393 + (1));
i__4790__auto___54393 = G__54394;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__53903_54395 = dommy.core.elem_and_selector(elem_sel);
var elem_54396 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53903_54395,(0),null);
var selector_54397 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53903_54395,(1),null);
var seq__53906_54398 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__53913_54399 = null;
var count__53914_54400 = (0);
var i__53915_54401 = (0);
while(true){
if((i__53915_54401 < count__53914_54400)){
var vec__53953_54402 = chunk__53913_54399.cljs$core$IIndexed$_nth$arity$2(null,i__53915_54401);
var orig_type_54403 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53953_54402,(0),null);
var f_54404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53953_54402,(1),null);
var seq__53916_54405 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_54403,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_54403,cljs.core.identity])));
var chunk__53918_54406 = null;
var count__53919_54407 = (0);
var i__53920_54408 = (0);
while(true){
if((i__53920_54408 < count__53919_54407)){
var vec__53962_54409 = chunk__53918_54406.cljs$core$IIndexed$_nth$arity$2(null,i__53920_54408);
var actual_type_54410 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53962_54409,(0),null);
var __54411 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53962_54409,(1),null);
var keys_54412 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54397,actual_type_54410,f_54404], null);
var canonical_f_54413 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_54396),keys_54412);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54396,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_54412], 0));

if(cljs.core.truth_(elem_54396.removeEventListener)){
elem_54396.removeEventListener(cljs.core.name(actual_type_54410),canonical_f_54413);
} else {
elem_54396.detachEvent(cljs.core.name(actual_type_54410),canonical_f_54413);
}


var G__54414 = seq__53916_54405;
var G__54415 = chunk__53918_54406;
var G__54416 = count__53919_54407;
var G__54417 = (i__53920_54408 + (1));
seq__53916_54405 = G__54414;
chunk__53918_54406 = G__54415;
count__53919_54407 = G__54416;
i__53920_54408 = G__54417;
continue;
} else {
var temp__5735__auto___54418 = cljs.core.seq(seq__53916_54405);
if(temp__5735__auto___54418){
var seq__53916_54419__$1 = temp__5735__auto___54418;
if(cljs.core.chunked_seq_QMARK_(seq__53916_54419__$1)){
var c__4609__auto___54420 = cljs.core.chunk_first(seq__53916_54419__$1);
var G__54421 = cljs.core.chunk_rest(seq__53916_54419__$1);
var G__54422 = c__4609__auto___54420;
var G__54423 = cljs.core.count(c__4609__auto___54420);
var G__54424 = (0);
seq__53916_54405 = G__54421;
chunk__53918_54406 = G__54422;
count__53919_54407 = G__54423;
i__53920_54408 = G__54424;
continue;
} else {
var vec__53965_54425 = cljs.core.first(seq__53916_54419__$1);
var actual_type_54426 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53965_54425,(0),null);
var __54427 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53965_54425,(1),null);
var keys_54428 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54397,actual_type_54426,f_54404], null);
var canonical_f_54429 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_54396),keys_54428);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54396,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_54428], 0));

if(cljs.core.truth_(elem_54396.removeEventListener)){
elem_54396.removeEventListener(cljs.core.name(actual_type_54426),canonical_f_54429);
} else {
elem_54396.detachEvent(cljs.core.name(actual_type_54426),canonical_f_54429);
}


var G__54430 = cljs.core.next(seq__53916_54419__$1);
var G__54431 = null;
var G__54432 = (0);
var G__54433 = (0);
seq__53916_54405 = G__54430;
chunk__53918_54406 = G__54431;
count__53919_54407 = G__54432;
i__53920_54408 = G__54433;
continue;
}
} else {
}
}
break;
}

var G__54434 = seq__53906_54398;
var G__54435 = chunk__53913_54399;
var G__54436 = count__53914_54400;
var G__54437 = (i__53915_54401 + (1));
seq__53906_54398 = G__54434;
chunk__53913_54399 = G__54435;
count__53914_54400 = G__54436;
i__53915_54401 = G__54437;
continue;
} else {
var temp__5735__auto___54438 = cljs.core.seq(seq__53906_54398);
if(temp__5735__auto___54438){
var seq__53906_54439__$1 = temp__5735__auto___54438;
if(cljs.core.chunked_seq_QMARK_(seq__53906_54439__$1)){
var c__4609__auto___54440 = cljs.core.chunk_first(seq__53906_54439__$1);
var G__54441 = cljs.core.chunk_rest(seq__53906_54439__$1);
var G__54442 = c__4609__auto___54440;
var G__54443 = cljs.core.count(c__4609__auto___54440);
var G__54444 = (0);
seq__53906_54398 = G__54441;
chunk__53913_54399 = G__54442;
count__53914_54400 = G__54443;
i__53915_54401 = G__54444;
continue;
} else {
var vec__53968_54445 = cljs.core.first(seq__53906_54439__$1);
var orig_type_54446 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53968_54445,(0),null);
var f_54447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53968_54445,(1),null);
var seq__53907_54448 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_54446,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_54446,cljs.core.identity])));
var chunk__53909_54449 = null;
var count__53910_54450 = (0);
var i__53911_54451 = (0);
while(true){
if((i__53911_54451 < count__53910_54450)){
var vec__53979_54452 = chunk__53909_54449.cljs$core$IIndexed$_nth$arity$2(null,i__53911_54451);
var actual_type_54453 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53979_54452,(0),null);
var __54454 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53979_54452,(1),null);
var keys_54455 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54397,actual_type_54453,f_54447], null);
var canonical_f_54456 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_54396),keys_54455);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54396,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_54455], 0));

if(cljs.core.truth_(elem_54396.removeEventListener)){
elem_54396.removeEventListener(cljs.core.name(actual_type_54453),canonical_f_54456);
} else {
elem_54396.detachEvent(cljs.core.name(actual_type_54453),canonical_f_54456);
}


var G__54457 = seq__53907_54448;
var G__54458 = chunk__53909_54449;
var G__54459 = count__53910_54450;
var G__54460 = (i__53911_54451 + (1));
seq__53907_54448 = G__54457;
chunk__53909_54449 = G__54458;
count__53910_54450 = G__54459;
i__53911_54451 = G__54460;
continue;
} else {
var temp__5735__auto___54461__$1 = cljs.core.seq(seq__53907_54448);
if(temp__5735__auto___54461__$1){
var seq__53907_54462__$1 = temp__5735__auto___54461__$1;
if(cljs.core.chunked_seq_QMARK_(seq__53907_54462__$1)){
var c__4609__auto___54463 = cljs.core.chunk_first(seq__53907_54462__$1);
var G__54464 = cljs.core.chunk_rest(seq__53907_54462__$1);
var G__54465 = c__4609__auto___54463;
var G__54466 = cljs.core.count(c__4609__auto___54463);
var G__54467 = (0);
seq__53907_54448 = G__54464;
chunk__53909_54449 = G__54465;
count__53910_54450 = G__54466;
i__53911_54451 = G__54467;
continue;
} else {
var vec__53983_54468 = cljs.core.first(seq__53907_54462__$1);
var actual_type_54469 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53983_54468,(0),null);
var __54470 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53983_54468,(1),null);
var keys_54471 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_54397,actual_type_54469,f_54447], null);
var canonical_f_54472 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_54396),keys_54471);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_54396,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_54471], 0));

if(cljs.core.truth_(elem_54396.removeEventListener)){
elem_54396.removeEventListener(cljs.core.name(actual_type_54469),canonical_f_54472);
} else {
elem_54396.detachEvent(cljs.core.name(actual_type_54469),canonical_f_54472);
}


var G__54473 = cljs.core.next(seq__53907_54462__$1);
var G__54474 = null;
var G__54475 = (0);
var G__54476 = (0);
seq__53907_54448 = G__54473;
chunk__53909_54449 = G__54474;
count__53910_54450 = G__54475;
i__53911_54451 = G__54476;
continue;
}
} else {
}
}
break;
}

var G__54477 = cljs.core.next(seq__53906_54439__$1);
var G__54478 = null;
var G__54479 = (0);
var G__54480 = (0);
seq__53906_54398 = G__54477;
chunk__53913_54399 = G__54478;
count__53914_54400 = G__54479;
i__53915_54401 = G__54480;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq53901){
var G__53902 = cljs.core.first(seq53901);
var seq53901__$1 = cljs.core.next(seq53901);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53902,seq53901__$1);
}));

/**
 * Behaves like `listen!`, but removes the listener after the first event occurs.
 */
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___54481 = arguments.length;
var i__4790__auto___54482 = (0);
while(true){
if((i__4790__auto___54482 < len__4789__auto___54481)){
args__4795__auto__.push((arguments[i__4790__auto___54482]));

var G__54483 = (i__4790__auto___54482 + (1));
i__4790__auto___54482 = G__54483;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__53988_54484 = dommy.core.elem_and_selector(elem_sel);
var elem_54485 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53988_54484,(0),null);
var selector_54486 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53988_54484,(1),null);
var seq__53991_54487 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__53992_54488 = null;
var count__53993_54489 = (0);
var i__53994_54490 = (0);
while(true){
if((i__53994_54490 < count__53993_54489)){
var vec__54001_54491 = chunk__53992_54488.cljs$core$IIndexed$_nth$arity$2(null,i__53994_54490);
var type_54492 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54001_54491,(0),null);
var f_54493 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54001_54491,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_54492,((function (seq__53991_54487,chunk__53992_54488,count__53993_54489,i__53994_54490,vec__54001_54491,type_54492,f_54493,vec__53988_54484,elem_54485,selector_54486){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_54492,dommy$core$this_fn], 0));

return (f_54493.cljs$core$IFn$_invoke$arity$1 ? f_54493.cljs$core$IFn$_invoke$arity$1(e) : f_54493.call(null,e));
});})(seq__53991_54487,chunk__53992_54488,count__53993_54489,i__53994_54490,vec__54001_54491,type_54492,f_54493,vec__53988_54484,elem_54485,selector_54486))
], 0));


var G__54494 = seq__53991_54487;
var G__54495 = chunk__53992_54488;
var G__54496 = count__53993_54489;
var G__54497 = (i__53994_54490 + (1));
seq__53991_54487 = G__54494;
chunk__53992_54488 = G__54495;
count__53993_54489 = G__54496;
i__53994_54490 = G__54497;
continue;
} else {
var temp__5735__auto___54498 = cljs.core.seq(seq__53991_54487);
if(temp__5735__auto___54498){
var seq__53991_54499__$1 = temp__5735__auto___54498;
if(cljs.core.chunked_seq_QMARK_(seq__53991_54499__$1)){
var c__4609__auto___54500 = cljs.core.chunk_first(seq__53991_54499__$1);
var G__54501 = cljs.core.chunk_rest(seq__53991_54499__$1);
var G__54502 = c__4609__auto___54500;
var G__54503 = cljs.core.count(c__4609__auto___54500);
var G__54504 = (0);
seq__53991_54487 = G__54501;
chunk__53992_54488 = G__54502;
count__53993_54489 = G__54503;
i__53994_54490 = G__54504;
continue;
} else {
var vec__54004_54505 = cljs.core.first(seq__53991_54499__$1);
var type_54506 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54004_54505,(0),null);
var f_54507 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54004_54505,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_54506,((function (seq__53991_54487,chunk__53992_54488,count__53993_54489,i__53994_54490,vec__54004_54505,type_54506,f_54507,seq__53991_54499__$1,temp__5735__auto___54498,vec__53988_54484,elem_54485,selector_54486){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_54506,dommy$core$this_fn], 0));

return (f_54507.cljs$core$IFn$_invoke$arity$1 ? f_54507.cljs$core$IFn$_invoke$arity$1(e) : f_54507.call(null,e));
});})(seq__53991_54487,chunk__53992_54488,count__53993_54489,i__53994_54490,vec__54004_54505,type_54506,f_54507,seq__53991_54499__$1,temp__5735__auto___54498,vec__53988_54484,elem_54485,selector_54486))
], 0));


var G__54508 = cljs.core.next(seq__53991_54499__$1);
var G__54509 = null;
var G__54510 = (0);
var G__54511 = (0);
seq__53991_54487 = G__54508;
chunk__53992_54488 = G__54509;
count__53993_54489 = G__54510;
i__53994_54490 = G__54511;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq53986){
var G__53987 = cljs.core.first(seq53986);
var seq53986__$1 = cljs.core.next(seq53986);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53987,seq53986__$1);
}));


//# sourceMappingURL=dommy.core.js.map
