goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__49840 = (line + (1));
var G__49841 = (1);
var G__49842 = (counter + (1));
line = G__49840;
col = G__49841;
counter = G__49842;
continue;
} else {
var G__49843 = line;
var G__49844 = (col + (1));
var G__49845 = (counter + (1));
line = G__49843;
col = G__49844;
counter = G__49845;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__49846 = cljs.core.next(chars);
var G__49847 = (n__$1 - (1));
chars = G__49846;
n__$1 = G__49847;
continue;
} else {
var G__49848 = cljs.core.next(chars);
var G__49849 = n__$1;
chars = G__49848;
n__$1 = G__49849;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__49818){
var map__49819 = p__49818;
var map__49819__$1 = (((((!((map__49819 == null))))?(((((map__49819.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49819.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49819):map__49819);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49819__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49819__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49819__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49819__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__49827_49853 = cljs.core.seq(full_reasons);
var chunk__49828_49854 = null;
var count__49829_49855 = (0);
var i__49830_49856 = (0);
while(true){
if((i__49830_49856 < count__49829_49855)){
var r_49859 = chunk__49828_49854.cljs$core$IIndexed$_nth$arity$2(null,i__49830_49856);
instaparse.failure.print_reason(r_49859);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__49862 = seq__49827_49853;
var G__49863 = chunk__49828_49854;
var G__49864 = count__49829_49855;
var G__49865 = (i__49830_49856 + (1));
seq__49827_49853 = G__49862;
chunk__49828_49854 = G__49863;
count__49829_49855 = G__49864;
i__49830_49856 = G__49865;
continue;
} else {
var temp__5735__auto___49866 = cljs.core.seq(seq__49827_49853);
if(temp__5735__auto___49866){
var seq__49827_49867__$1 = temp__5735__auto___49866;
if(cljs.core.chunked_seq_QMARK_(seq__49827_49867__$1)){
var c__4609__auto___49868 = cljs.core.chunk_first(seq__49827_49867__$1);
var G__49869 = cljs.core.chunk_rest(seq__49827_49867__$1);
var G__49870 = c__4609__auto___49868;
var G__49871 = cljs.core.count(c__4609__auto___49868);
var G__49872 = (0);
seq__49827_49853 = G__49869;
chunk__49828_49854 = G__49870;
count__49829_49855 = G__49871;
i__49830_49856 = G__49872;
continue;
} else {
var r_49873 = cljs.core.first(seq__49827_49867__$1);
instaparse.failure.print_reason(r_49873);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__49874 = cljs.core.next(seq__49827_49867__$1);
var G__49875 = null;
var G__49876 = (0);
var G__49877 = (0);
seq__49827_49853 = G__49874;
chunk__49828_49854 = G__49875;
count__49829_49855 = G__49876;
i__49830_49856 = G__49877;
continue;
}
} else {
}
}
break;
}

var seq__49836 = cljs.core.seq(partial_reasons);
var chunk__49837 = null;
var count__49838 = (0);
var i__49839 = (0);
while(true){
if((i__49839 < count__49838)){
var r = chunk__49837.cljs$core$IIndexed$_nth$arity$2(null,i__49839);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__49878 = seq__49836;
var G__49879 = chunk__49837;
var G__49880 = count__49838;
var G__49881 = (i__49839 + (1));
seq__49836 = G__49878;
chunk__49837 = G__49879;
count__49838 = G__49880;
i__49839 = G__49881;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__49836);
if(temp__5735__auto__){
var seq__49836__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49836__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__49836__$1);
var G__49882 = cljs.core.chunk_rest(seq__49836__$1);
var G__49883 = c__4609__auto__;
var G__49884 = cljs.core.count(c__4609__auto__);
var G__49885 = (0);
seq__49836 = G__49882;
chunk__49837 = G__49883;
count__49838 = G__49884;
i__49839 = G__49885;
continue;
} else {
var r = cljs.core.first(seq__49836__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__49886 = cljs.core.next(seq__49836__$1);
var G__49887 = null;
var G__49888 = (0);
var G__49889 = (0);
seq__49836 = G__49886;
chunk__49837 = G__49887;
count__49838 = G__49888;
i__49839 = G__49889;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=instaparse.failure.js.map
