goog.provide('pinkgorilla.editor.editor_support');
goog.require('cljs.core');
goog.require('pinkgorilla.editor.parinfer');
if((typeof pinkgorilla !== 'undefined') && (typeof pinkgorilla.editor !== 'undefined') && (typeof pinkgorilla.editor.editor_support !== 'undefined') && (typeof pinkgorilla.editor.editor_support.state !== 'undefined')){
} else {
pinkgorilla.editor.editor_support.state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
}

/**
 * Custom data/methods for a CodeMirror editor.
 * @interface
 */
pinkgorilla.editor.editor_support.IEditor = function(){};

pinkgorilla.editor.editor_support.frame_updated_QMARK_ = (function pinkgorilla$editor$editor_support$frame_updated_QMARK_(this$){
if((((!((this$ == null)))) && ((!((this$.pinkgorilla$editor$editor_support$IEditor$frame_updated_QMARK_$arity$1 == null)))))){
return this$.pinkgorilla$editor$editor_support$IEditor$frame_updated_QMARK_$arity$1(this$);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (pinkgorilla.editor.editor_support.frame_updated_QMARK_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4488__auto__.call(null,this$));
} else {
var m__4485__auto__ = (pinkgorilla.editor.editor_support.frame_updated_QMARK_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4485__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IEditor.frame-updated?",this$);
}
}
}
});

pinkgorilla.editor.editor_support.set_frame_updated_BANG_ = (function pinkgorilla$editor$editor_support$set_frame_updated_BANG_(this$,value){
if((((!((this$ == null)))) && ((!((this$.pinkgorilla$editor$editor_support$IEditor$set_frame_updated_BANG_$arity$2 == null)))))){
return this$.pinkgorilla$editor$editor_support$IEditor$set_frame_updated_BANG_$arity$2(this$,value);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (pinkgorilla.editor.editor_support.set_frame_updated_BANG_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(this$,value) : m__4488__auto__.call(null,this$,value));
} else {
var m__4485__auto__ = (pinkgorilla.editor.editor_support.set_frame_updated_BANG_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(this$,value) : m__4485__auto__.call(null,this$,value));
} else {
throw cljs.core.missing_protocol("IEditor.set-frame-updated!",this$);
}
}
}
});

pinkgorilla.editor.editor_support.compute_cursor_dx = (function pinkgorilla$editor$editor_support$compute_cursor_dx(_,change){
if(cljs.core.truth_(change)){
var ignore_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("+indenthack",change.origin);
if(ignore_QMARK_){
return (0);
} else {
var start_x = change.to.ch;
var new_lines = change.text;
var len_last_line = cljs.core.count(cljs.core.last(new_lines));
var end_x = (((cljs.core.count(new_lines) > (1)))?len_last_line:(len_last_line + change.from.ch));
return (end_x - start_x);
}
} else {
return null;
}
});
pinkgorilla.editor.editor_support.compute_cm_change = (function pinkgorilla$editor$editor_support$compute_cm_change(cm,change,_,prev_state){
var map__52350 = (cljs.core.truth_(change)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"start-line","start-line",-41746654),change.from.line,new cljs.core.Keyword(null,"end-line","end-line",1837326455),(change.to.line + (1)),new cljs.core.Keyword(null,"num-new-lines","num-new-lines",-1319642646),change.text.length], null):(function (){var start = new cljs.core.Keyword(null,"cursor-line","cursor-line",-1089611007).cljs$core$IFn$_invoke$arity$1(prev_state);
var end = (start + (1));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"start-line","start-line",-41746654),start,new cljs.core.Keyword(null,"end-line","end-line",1837326455),end,new cljs.core.Keyword(null,"num-new-lines","num-new-lines",-1319642646),(end - start)], null);
})());
var map__52350__$1 = (((((!((map__52350 == null))))?(((((map__52350.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52350.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52350):map__52350);
var start_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52350__$1,new cljs.core.Keyword(null,"start-line","start-line",-41746654));
var end_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52350__$1,new cljs.core.Keyword(null,"end-line","end-line",1837326455));
var num_new_lines = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52350__$1,new cljs.core.Keyword(null,"num-new-lines","num-new-lines",-1319642646));
var lines = (function (){var iter__4582__auto__ = (function pinkgorilla$editor$editor_support$compute_cm_change_$_iter__52352(s__52353){
return (new cljs.core.LazySeq(null,(function (){
var s__52353__$1 = s__52353;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__52353__$1);
if(temp__5735__auto__){
var s__52353__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__52353__$2)){
var c__4580__auto__ = cljs.core.chunk_first(s__52353__$2);
var size__4581__auto__ = cljs.core.count(c__4580__auto__);
var b__52355 = cljs.core.chunk_buffer(size__4581__auto__);
if((function (){var i__52354 = (0);
while(true){
if((i__52354 < size__4581__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4580__auto__,i__52354);
cljs.core.chunk_append(b__52355,cm.getLine(i));

var G__52362 = (i__52354 + (1));
i__52354 = G__52362;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__52355),pinkgorilla$editor$editor_support$compute_cm_change_$_iter__52352(cljs.core.chunk_rest(s__52353__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__52355),null);
}
} else {
var i = cljs.core.first(s__52353__$2);
return cljs.core.cons(cm.getLine(i),pinkgorilla$editor$editor_support$compute_cm_change_$_iter__52352(cljs.core.rest(s__52353__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4582__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$2(start_line,(start_line + num_new_lines)));
})();
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line-no","line-no",-666819466),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_line,end_line], null),new cljs.core.Keyword(null,"new-line","new-line",1060819447),lines], null);
});
/**
 * Correctly format the text from the given editor.
 * @param {CodeMirror} cm
 */
pinkgorilla.editor.editor_support.fix_text_BANG_ = (function pinkgorilla$editor$editor_support$fix_text_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___52363 = arguments.length;
var i__4790__auto___52364 = (0);
while(true){
if((i__4790__auto___52364 < len__4789__auto___52363)){
args__4795__auto__.push((arguments[i__4790__auto___52364]));

var G__52365 = (i__4790__auto___52364 + (1));
i__4790__auto___52364 = G__52365;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return pinkgorilla.editor.editor_support.fix_text_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(pinkgorilla.editor.editor_support.fix_text_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (cm,p__52358){
var map__52359 = p__52358;
var map__52359__$1 = (((((!((map__52359 == null))))?(((((map__52359.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52359.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52359):map__52359);
var change = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__52359__$1,new cljs.core.Keyword(null,"change","change",-1163046502),null);
var current_text = cm.getValue();
var selection_QMARK_ = cm.somethingSelected();
var selections = cm.listSelections();
var cursor = cm.getCursor();
var scroller = cm.getScrollerElement();
var scroll_x = scroller.scrollLeft;
var scroll_y = scroller.scrollTop;
var options = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"cursor-line","cursor-line",-1089611007),cursor.line,new cljs.core.Keyword(null,"cursor-x","cursor-x",475204266),cursor.ch,new cljs.core.Keyword(null,"cursor-dx","cursor-dx",133069327),pinkgorilla.editor.editor_support.compute_cursor_dx(cursor,change)], null);
var options__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([options,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.editor.editor_support.state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489)], null))], 0));
var mode = (function (){var or__4185__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.editor.editor_support.state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mode","mode",654403691)], null));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"indent-mode","indent-mode",1737814542);
}
})();
var result = (function (){var G__52361 = mode;
var G__52361__$1 = (((G__52361 instanceof cljs.core.Keyword))?G__52361.fqn:null);
switch (G__52361__$1) {
case "indent-mode":
return pinkgorilla.editor.parinfer.indent_mode.cljs$core$IFn$_invoke$arity$2(current_text,options__$1);

break;
case "paren-mode":
return pinkgorilla.editor.parinfer.paren_mode.cljs$core$IFn$_invoke$arity$2(current_text,options__$1);

break;
default:
return null;

}
})();
var new_text = new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(result);
var new_cursor_x = new cljs.core.Keyword(null,"cursor-x","cursor-x",475204266).cljs$core$IFn$_invoke$arity$1(result);
cm.setValue(new_text);

if(cljs.core.truth_(selection_QMARK_)){
cm.setSelections(selections);
} else {
cm.setCursor((cursor["line"]),new_cursor_x);
}

return cm.scrollTo(scroll_x,scroll_y);
}));

(pinkgorilla.editor.editor_support.fix_text_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.editor.editor_support.fix_text_BANG_.cljs$lang$applyTo = (function (seq52356){
var G__52357 = cljs.core.first(seq52356);
var seq52356__$1 = cljs.core.next(seq52356);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__52357,seq52356__$1);
}));


//# sourceMappingURL=pinkgorilla.editor.editor_support.js.map
