goog.provide('pinkgorilla.encoding.decode');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.edn');
goog.require('instaparse.core');
goog.require('pinkgorilla.encoding.helper');
/**
 * parse-notebook gets passed in a string and returns an intermediary output format.
 * It is based on InstaParse.
 * Notes: 
 *    SEGMENTS=SEGMENT (<N> SEGMENT)*
 *    This basically decodes one or more segments, that are separated by newline.
 * 
 *    LINE = #'.*'
 *    This is an regex that spans maximum one line and can contain one or more
 *    characters of any type.
 * 
 *    One of multiple keywords:
 *    keyword = 'cond' | 'defn'
 * 
 *    <IN>   = #'[a-zA-Z0-9]+[
 * ]'
 *    <OUT>  = #'[a-zA-Z0-9]+[
 * ]'
 * 
 */
pinkgorilla.encoding.decode.parse_notebook = instaparse.core.parser("NOTEBOOK = HEADER SEGMENTS\n     SEGMENT = MD | CODE\n     SEGMENTS = SEGMENT (<N> SEGMENT)*\n\n     HEADER = <F> VERSION <N> <N>\n     F = ';; gorilla-repl.fileformat = '\n     VERSION = #'[1-9]'\n     \n     N = '\n'\n     LINE = #'.*'\n     DATA = #'[.\\w\\d\\s\\-\\+()]'\n     LINES = LINE (<N> LINE)*\n\n     MD = <MD-B> LINES <MD-E>\n     MD-B =   ';; **' N\n     MD-E =  N ';; **' N \n\n     CODE = INP CON? VAL?\n\n     KERNEL = ' [clj]' | ' [cljs]' | ' [mock]' | ' [meta]'\n\n     INP = <INP-B> KERNEL? <N> LINES <INP-E>\n     INP-B =   ';; @@' \n     INP-E =  N ';; @@' N \n\n     CON = <CON-B> LINES <CON-E>\n     CON-B =   ';; ->' N\n     CON-E =  N ';; <-' N \n\n     VAL = <VAL-B> LINES <VAL-E>\n     VAL-B =   ';; =>' N\n     VAL-E =  N ';; <=' N \n\n     ");
pinkgorilla.encoding.decode.get_lines = (function pinkgorilla$encoding$decode$get_lines(lines){
var rlines = cljs.core.rest(lines);
var slines = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.second,rlines);
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",slines);
});
pinkgorilla.encoding.decode.process_md = (function pinkgorilla$encoding$decode$process_md(seg){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"free","free",801364328),new cljs.core.Keyword(null,"markup-visible","markup-visible",447471311),false,new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4185__auto__ = pinkgorilla.encoding.helper.unmake_clojure_comment(pinkgorilla.encoding.decode.get_lines(seg));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "";
}
})(),new cljs.core.Keyword(null,"type","type",1174270348),"text/x-markdown"], null)], null);
});
pinkgorilla.encoding.decode.is_type = (function pinkgorilla$encoding$decode$is_type(kw,data){
var t = cljs.core.first(data);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,kw);
});
pinkgorilla.encoding.decode.find_element = (function pinkgorilla$encoding$decode$find_element(data,kw){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(pinkgorilla.encoding.decode.is_type,kw),cljs.core.rest(data)));
});
pinkgorilla.encoding.decode.kernel_s_to_kw = (function pinkgorilla$encoding$decode$kernel_s_to_kw(skernel){
var G__51603 = skernel;
switch (G__51603) {
case " [clj]":
return new cljs.core.Keyword(null,"clj","clj",-660495428);

break;
case " [cljs]":
return new cljs.core.Keyword(null,"cljs","cljs",1492417629);

break;
case " [mock]":
return new cljs.core.Keyword(null,"mock","mock",-383657858);

break;
case " [meta]":
return new cljs.core.Keyword(null,"meta","meta",1499536964);

break;
default:
return new cljs.core.Keyword(null,"unknown","unknown",-935977881);

}
});
pinkgorilla.encoding.decode.create_code_segment = (function pinkgorilla$encoding$decode$create_code_segment(inp){
var lines = pinkgorilla.encoding.decode.find_element(inp,new cljs.core.Keyword(null,"LINES","LINES",-1344692081));
var kernel = pinkgorilla.encoding.decode.find_element(inp,new cljs.core.Keyword(null,"KERNEL","KERNEL",757119222));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"code","code",1586293142),new cljs.core.Keyword(null,"kernel","kernel",-650895913),(((kernel == null))?new cljs.core.Keyword(null,"clj","clj",-660495428):pinkgorilla.encoding.decode.kernel_s_to_kw(cljs.core.second(kernel))),new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4185__auto__ = pinkgorilla.encoding.decode.get_lines(lines);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "";
}
})(),new cljs.core.Keyword(null,"type","type",1174270348),"text/x-clojure"], null)], null);
});
pinkgorilla.encoding.decode.add_console_response = (function pinkgorilla$encoding$decode$add_console_response(segment,con){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(segment,new cljs.core.Keyword(null,"console-response","console-response",81719661),(function (){var or__4185__auto__ = pinkgorilla.encoding.helper.unmake_clojure_comment(pinkgorilla.encoding.decode.get_lines(cljs.core.second(con)));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "";
}
})());
});
pinkgorilla.encoding.decode.add_value_response = (function pinkgorilla$encoding$decode$add_value_response(segment,val){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(segment,new cljs.core.Keyword(null,"value-response","value-response",-1249272942),pinkgorilla.encoding.helper.from_json((function (){var or__4185__auto__ = pinkgorilla.encoding.helper.unmake_clojure_comment(pinkgorilla.encoding.decode.get_lines(cljs.core.second(val)));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "";
}
})()));
});
pinkgorilla.encoding.decode.add_addon = (function pinkgorilla$encoding$decode$add_addon(segment,addon){
var addon_type = cljs.core.first(addon);
var G__51607 = addon_type;
var G__51607__$1 = (((G__51607 instanceof cljs.core.Keyword))?G__51607.fqn:null);
switch (G__51607__$1) {
case "CON":
return pinkgorilla.encoding.decode.add_console_response(segment,addon);

break;
case "VAL":
return pinkgorilla.encoding.decode.add_value_response(segment,addon);

break;
default:
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["unknwn code-addon type: ",addon_type], 0));

return segment;

}
});
pinkgorilla.encoding.decode.process_code = (function pinkgorilla$encoding$decode$process_code(seg){
var inp = cljs.core.first(seg);
var segment = pinkgorilla.encoding.decode.create_code_segment(inp);
var addons = cljs.core.rest(seg);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(pinkgorilla.encoding.decode.add_addon,segment,addons);
});
pinkgorilla.encoding.decode.process_segment = (function pinkgorilla$encoding$decode$process_segment(seg){
var seg_with_wrapper = cljs.core.second(seg);
var type = cljs.core.first(seg_with_wrapper);
var data = cljs.core.rest(seg_with_wrapper);
var G__51609 = type;
var G__51609__$1 = (((G__51609 instanceof cljs.core.Keyword))?G__51609.fqn:null);
switch (G__51609__$1) {
case "MD":
return pinkgorilla.encoding.decode.process_md(cljs.core.first(data));

break;
case "CODE":
return pinkgorilla.encoding.decode.process_code(data);

break;
default:
return null;

}
});
pinkgorilla.encoding.decode.meta_QMARK_ = (function pinkgorilla$encoding$decode$meta_QMARK_(segment){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(segment),new cljs.core.Keyword(null,"code","code",1586293142))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"kernel","kernel",-650895913).cljs$core$IFn$_invoke$arity$1(segment),new cljs.core.Keyword(null,"meta","meta",1499536964))));
});
pinkgorilla.encoding.decode.get_meta = (function pinkgorilla$encoding$decode$get_meta(segments){
var meta_segment = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pinkgorilla.encoding.decode.meta_QMARK_,segments));
if((meta_segment == null)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return clojure.edn.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(meta_segment,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.Keyword(null,"value","value",305978217)], null)));
}
});
pinkgorilla.encoding.decode.vector_type = cljs.core.PersistentVector;
pinkgorilla.encoding.decode.decode = (function pinkgorilla$encoding$decode$decode(s){
var nb = (pinkgorilla.encoding.decode.parse_notebook.cljs$core$IFn$_invoke$arity$1 ? pinkgorilla.encoding.decode.parse_notebook.cljs$core$IFn$_invoke$arity$1(s) : pinkgorilla.encoding.decode.parse_notebook.call(null,s));
var el_header = pinkgorilla.encoding.decode.find_element(nb,new cljs.core.Keyword(null,"HEADER","HEADER",2119205739));
var el_version = pinkgorilla.encoding.decode.find_element(el_header,new cljs.core.Keyword(null,"VERSION","VERSION",-417550561));
var version = cljs.core.get.cljs$core$IFn$_invoke$arity$2(el_version,(1));
var version__$1 = (function (){var G__51610 = version;
switch (G__51610) {
case "1":
return (1);

break;
case "2":
return (2);

break;
default:
return null;

}
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.type(nb),pinkgorilla.encoding.decode.vector_type)){
var segments = cljs.core.rest(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(nb,(2)));
var segments__$1 = cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(pinkgorilla.encoding.decode.process_segment,segments));
var segments_no_meta = cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pinkgorilla.encoding.decode.meta_QMARK_,segments__$1));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"version","version",425292698),version__$1,new cljs.core.Keyword(null,"meta","meta",1499536964),pinkgorilla.encoding.decode.get_meta(segments__$1),new cljs.core.Keyword(null,"segments","segments",1937535949),segments_no_meta], null);
} else {
if((!((nb == null)))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["notebook format is invalid. error:",nb], 0));
} else {
}

return null;
}
});

//# sourceMappingURL=pinkgorilla.encoding.decode.js.map
