goog.provide('pinkgorilla.explore.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs_time.format');
/**
 * Capitalize every word in a string
 */
pinkgorilla.explore.utils.capitalize_words = (function pinkgorilla$explore$utils$capitalize_words(s){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.capitalize,clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),/\b/)));
});
pinkgorilla.explore.utils.hkey_text = (function pinkgorilla$explore$utils$hkey_text(hkey){
return pinkgorilla.explore.utils.capitalize_words(clojure.string.replace(cljs.core.name(hkey),/-/," "));
});
pinkgorilla.explore.utils.prevent_default = (function pinkgorilla$explore$utils$prevent_default(f){
return (function (e){
e.preventDefault();

return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(e) : f.call(null,e));
});
});
pinkgorilla.explore.utils.strk = (function pinkgorilla$explore$utils$strk(var_args){
var args__4795__auto__ = [];
var len__4789__auto___53073 = arguments.length;
var i__4790__auto___53074 = (0);
while(true){
if((i__4790__auto___53074 < len__4789__auto___53073)){
args__4795__auto__.push((arguments[i__4790__auto___53074]));

var G__53075 = (i__4790__auto___53074 + (1));
i__4790__auto___53074 = G__53075;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return pinkgorilla.explore.utils.strk.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(pinkgorilla.explore.utils.strk.cljs$core$IFn$_invoke$arity$variadic = (function (key,args){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.str,cljs.core.name(key),args));
}));

(pinkgorilla.explore.utils.strk.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.explore.utils.strk.cljs$lang$applyTo = (function (seq53069){
var G__53070 = cljs.core.first(seq53069);
var seq53069__$1 = cljs.core.next(seq53069);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53070,seq53069__$1);
}));

pinkgorilla.explore.utils.kabob = (function pinkgorilla$explore$utils$kabob(s){
return clojure.string.replace(s,/[^a-zA-Z]/,"-");
});
pinkgorilla.explore.utils.format_date = (function pinkgorilla$explore$utils$format_date(date){
return cljs_time.format.unparse(cljs_time.format.formatter.cljs$core$IFn$_invoke$arity$1("MMM d, YYYY"),(new goog.date.DateTime(date)));
});
pinkgorilla.explore.utils.short_date = (function pinkgorilla$explore$utils$short_date(date){
return cljs_time.format.unparse(cljs_time.format.formatter.cljs$core$IFn$_invoke$arity$1("MMM d"),(new goog.date.DateTime(date)));
});
pinkgorilla.explore.utils.el_by_id = (function pinkgorilla$explore$utils$el_by_id(id){
return document.getElementById(id);
});
pinkgorilla.explore.utils.toggle = (function pinkgorilla$explore$utils$toggle(v,x,y){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,x)){
return y;
} else {
return x;
}
});
pinkgorilla.explore.utils.flatv = (function pinkgorilla$explore$utils$flatv(var_args){
var args__4795__auto__ = [];
var len__4789__auto___53077 = arguments.length;
var i__4790__auto___53078 = (0);
while(true){
if((i__4790__auto___53078 < len__4789__auto___53077)){
args__4795__auto__.push((arguments[i__4790__auto___53078]));

var G__53079 = (i__4790__auto___53078 + (1));
i__4790__auto___53078 = G__53079;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((0) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((0)),(0),null)):null);
return pinkgorilla.explore.utils.flatv.cljs$core$IFn$_invoke$arity$variadic(argseq__4796__auto__);
});

(pinkgorilla.explore.utils.flatv.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.flatten(args));
}));

(pinkgorilla.explore.utils.flatv.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(pinkgorilla.explore.utils.flatv.cljs$lang$applyTo = (function (seq53071){
var self__4777__auto__ = this;
return self__4777__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq53071));
}));

pinkgorilla.explore.utils.now = (function pinkgorilla$explore$utils$now(){
return (new Date());
});
pinkgorilla.explore.utils.nav = (function pinkgorilla$explore$utils$nav(fragment){
return (window["location"] = fragment);
});
pinkgorilla.explore.utils.scroll_top = (function pinkgorilla$explore$utils$scroll_top(){
return (document.querySelector("body")["scrollTop"] = (0));
});
pinkgorilla.explore.utils.slugify = (function pinkgorilla$explore$utils$slugify(txt){
return clojure.string.replace(clojure.string.lower_case(txt),/[^a-zA-Z0-9]/,"-");
});
pinkgorilla.explore.utils.slug = (function pinkgorilla$explore$utils$slug(listing){
return ["/projects/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("db","id","db/id",-1388397098).cljs$core$IFn$_invoke$arity$1(listing)),"/",pinkgorilla.explore.utils.slugify(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("project","name","project/name",2022968152).cljs$core$IFn$_invoke$arity$1(listing)))].join('');
});
pinkgorilla.explore.utils.split_tags = (function pinkgorilla$explore$utils$split_tags(tags){
if((((tags == null)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",tags)))){
return null;
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(clojure.string.lower_case,clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(tags,","));
}
});

//# sourceMappingURL=pinkgorilla.explore.utils.js.map
