goog.provide('pinkgorilla.kernel.nrepl');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('cljs_uuid_utils.core');
goog.require('clojure.walk');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('chord.client');
goog.require('re_frame.core');
goog.require('pinkgorilla.notifications');
goog.require('pinkgorilla.kernel.cljs_helper');
/**
 * rendering via the Renderable protocol (needs renderable project)
 * (users can define their own render implementations)
 * identical to cljs version, except for non meta rendering it will not
 * call render, as this already has been rendered in the clj kernel
 */
pinkgorilla.kernel.nrepl.render_renderable_meta = (function pinkgorilla$kernel$nrepl$render_renderable_meta(result){
var m = cljs.core.meta(result);
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942),((cljs.core.contains_QMARK_(m,new cljs.core.Keyword(null,"r","r",-471384190)))?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"reagent-cljs","reagent-cljs",1666311021),new cljs.core.Keyword(null,"reagent","reagent",2131627322),result,new cljs.core.Keyword(null,"map-keywords","map-keywords",-170077571),false], null):((cljs.core.contains_QMARK_(m,new cljs.core.Keyword(null,"R","R",-936662523)))?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"reagent-cljs","reagent-cljs",1666311021),new cljs.core.Keyword(null,"reagent","reagent",2131627322),result,new cljs.core.Keyword(null,"map-keywords","map-keywords",-170077571),true], null):result
))], null);
});
if((typeof pinkgorilla !== 'undefined') && (typeof pinkgorilla.kernel !== 'undefined') && (typeof pinkgorilla.kernel.nrepl !== 'undefined') && (typeof pinkgorilla.kernel.nrepl.ws_repl !== 'undefined')){
} else {
pinkgorilla.kernel.nrepl.ws_repl = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"channel","channel",734187692),null,new cljs.core.Keyword(null,"session-id","session-id",-1147060351),null,new cljs.core.Keyword(null,"evaluations","evaluations",57802423),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ciders","ciders",-1421942407),cljs.core.PersistentArrayMap.EMPTY], null));
}
/**
 * awb99: TODO: if websocket is nil, this will throw! (or not?).
 * This could be the error of some of the notebooks not loading.
 * Why dont we keep the core.async channels open all the time. And when we have a
 * websocket connection, then the messages get sent. Or we just dump messages that happen
 * before the socket gets opened. But in this case we have to LOG message dumping.
 * I have seen situations where the first eval does not go through. Might be this issue.
 * 
 */
pinkgorilla.kernel.nrepl.send_message_BANG_ = (function pinkgorilla$kernel$nrepl$send_message_BANG_(key,message,storeval){
var eval_id = cljs_uuid_utils.core.uuid_string(cljs_uuid_utils.core.make_random_uuid());
var nrepl_msg = cljs.core.clj__GT_js(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),eval_id,new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"session-id","session-id",-1147060351).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl))], null)], 0)));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(eval_id)], null),storeval);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl)),nrepl_msg);

return eval_id;
});
pinkgorilla.kernel.nrepl.eval_BANG_ = (function pinkgorilla$kernel$nrepl$eval_BANG_(segment_id,content){
return pinkgorilla.kernel.nrepl.send_message_BANG_(new cljs.core.Keyword(null,"evaluations","evaluations",57802423),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),"eval",new cljs.core.Keyword(null,"code","code",1586293142),content], null),segment_id);
});
pinkgorilla.kernel.nrepl.send_cider_message_BANG_ = (function pinkgorilla$kernel$nrepl$send_cider_message_BANG_(message,storeval){
return pinkgorilla.kernel.nrepl.send_message_BANG_(new cljs.core.Keyword(null,"ciders","ciders",-1421942407),message,storeval);
});
/**
 * Query the REPL server for autocompletion suggestions. Relies on the cider-nrepl middleware.
 *   We call the given callback with the list of symbols once the REPL server replies.
 */
pinkgorilla.kernel.nrepl.get_completions = (function pinkgorilla$kernel$nrepl$get_completions(symbol,ns,context,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"op","op",-1882987955),"complete",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns,new cljs.core.Keyword(null,"context","context",-830191113),context], null),(function (msg){
var G__51876 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__51873_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__51873_SHARP_,"candidate");
}),cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"completions"));
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__51876) : callback.call(null,G__51876));
}));
});
/**
 * Queries the REPL server for docs for the given symbol. Relies on the cider-nrepl middleware.
 *   Calls back with the documentation text
 */
pinkgorilla.kernel.nrepl.get_completion_doc = (function pinkgorilla$kernel$nrepl$get_completion_doc(symbol,ns,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"complete-doc",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null),(function (msg){
var G__51878 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"completion-doc");
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__51878) : callback.call(null,G__51878));
}));
});
/**
 * resolve a symbol to get its namespace takes the symbol and the namespace that should be used as context.
 *   Relies on the cider-nrepl middleware. Calls back with the symbol and the symbol's namespace
 */
pinkgorilla.kernel.nrepl.resolve_symbol = (function pinkgorilla$kernel$nrepl$resolve_symbol(symbol,ns,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"info",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null),(function (msg){
var G__51881 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"symbol","symbol",-1038572696),cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"name"),new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"ns")], null);
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__51881) : callback.call(null,G__51881));
}));
});
pinkgorilla.kernel.nrepl.parse_value = (function pinkgorilla$kernel$nrepl$parse_value(value){
var data = clojure.walk.keywordize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(JSON.parse(JSON.parse(value))));
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init1011153544949464259.clj",103,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["value ",value," => ",data], null);
}),null)),null,-779781075);
return data;
});
/**
 * processes an incoming message from websocket that comes from nrepl (and has cider enhancements)
 * dispatches events to reagent to update notebook state ui.
 *   
 */
pinkgorilla.kernel.nrepl.process_msg = (function pinkgorilla$kernel$nrepl$process_msg(message){
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"id"));
var out = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"out");
var err = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"err");
var root_ex = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"root-ex");
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"ns");
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"value");
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"status");
var segment_id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluations","evaluations",57802423),id], null));
var cider_cb = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ciders","ciders",-1421942407),id], null));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init1011153544949464259.clj",120,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got message",id,"for segment",segment_id], null);
}),null)),null,-653783566);

if(cljs.core.truth_(segment_id)){
if(cljs.core.truth_(ns)){
var data = pinkgorilla.kernel.nrepl.parse_value(value);
return pinkgorilla.kernel.cljs_helper.send_value.cljs$core$IFn$_invoke$arity$3(segment_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942),data], null),ns);
} else {
if(cljs.core.truth_(out)){
var G__51882 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:console-response","evaluator:console-response",-650807352),segment_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"console-response","console-response",81719661),out], null)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__51882) : re_frame.core.dispatch.call(null,G__51882));
} else {
if(cljs.core.truth_(err)){
var error = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error-text","error-text",2021893718),err,new cljs.core.Keyword(null,"segment-id","segment-id",1810133590),segment_id], null));
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op","op",-1882987955),"stacktrace"], null),(function (msg){
var status__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"status");
if(cljs.core.truth_((function (){var and__4174__auto__ = status__$1;
if(cljs.core.truth_(and__4174__auto__)){
return (status__$1.indexOf("done") >= (0));
} else {
return and__4174__auto__;
}
})())){
var G__51883 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:error-response","evaluator:error-response",1375419587),cljs.core.deref(error)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__51883) : re_frame.core.dispatch.call(null,G__51883));
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(error,(function (err__$1,ex){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(err__$1,new cljs.core.Keyword(null,"exception","exception",-335277064)))){
return cljs.core.assoc_in(err__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"cause","cause",231901252)], null),new cljs.core.Keyword(null,"exception","exception",-335277064).cljs$core$IFn$_invoke$arity$1(ex));
} else {
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ex,err__$1], 0));
}
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"exception","exception",-335277064),msg], null));
}
}));
} else {
if(cljs.core.truth_(root_ex)){
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init1011153544949464259.clj",160,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got root-ex",root_ex,"for",segment_id], null);
}),null)),null,472701512);
} else {
if((status.indexOf("done") >= (0))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluations","evaluations",57802423),id], null));

var G__51884 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:done-response","evaluator:done-response",1140676326),segment_id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__51884) : re_frame.core.dispatch.call(null,G__51884));
} else {
return null;
}
}
}
}
}
} else {
if(cljs.core.truth_(cider_cb)){
(cider_cb.cljs$core$IFn$_invoke$arity$1 ? cider_cb.cljs$core$IFn$_invoke$arity$1(message) : cider_cb.call(null,message));

if(cljs.core.truth_((function (){var and__4174__auto__ = status;
if(cljs.core.truth_(and__4174__auto__)){
return (status.indexOf("done") >= (0));
} else {
return and__4174__auto__;
}
})())){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ciders","ciders",-1421942407),id], null));
} else {
return null;
}
} else {
return null;
}
}
});
pinkgorilla.kernel.nrepl.set_clj_kernel_status = (function pinkgorilla$kernel$nrepl$set_clj_kernel_status(connected,session_id){
var G__51885 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"kernel-clj-status-set","kernel-clj-status-set",-1158664458),connected,session_id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__51885) : re_frame.core.dispatch.call(null,G__51885));
});
pinkgorilla.kernel.nrepl.receive_msgs_BANG_ = (function pinkgorilla$kernel$nrepl$receive_msgs_BANG_(ws_chan,msg_chan){
var c__42130__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_51971){
var state_val_51972 = (state_51971[(1)]);
if((state_val_51972 === (7))){
var state_51971__$1 = state_51971;
var statearr_51973_52235 = state_51971__$1;
(statearr_51973_52235[(2)] = false);

(statearr_51973_52235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51972 === (1))){
var state_51971__$1 = state_51971;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51971__$1,(2),ws_chan);
} else {
if((state_val_51972 === (4))){
var state_51971__$1 = state_51971;
var statearr_51974_52237 = state_51971__$1;
(statearr_51974_52237[(2)] = false);

(statearr_51974_52237[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51972 === (15))){
var inst_51917 = (state_51971[(7)]);
var inst_51919 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc,new cljs.core.Keyword(null,"session-id","session-id",-1147060351),inst_51917);
var inst_51920 = pinkgorilla.kernel.nrepl.set_clj_kernel_status(true,inst_51917);
var state_51971__$1 = (function (){var statearr_51975 = state_51971;
(statearr_51975[(8)] = inst_51919);

return statearr_51975;
})();
var statearr_51976_52238 = state_51971__$1;
(statearr_51976_52238[(2)] = inst_51920);

(statearr_51976_52238[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51972 === (13))){
var inst_51911 = (state_51971[(9)]);
var inst_51912 = (state_51971[(10)]);
var inst_51967 = (inst_51912.cljs$core$IFn$_invoke$arity$1 ? inst_51912.cljs$core$IFn$_invoke$arity$1(inst_51911) : inst_51912.call(null,inst_51911));
var state_51971__$1 = state_51971;
var statearr_51977_52240 = state_51971__$1;
(statearr_51977_52240[(2)] = inst_51967);

(statearr_51977_52240[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51972 === (6))){
var state_51971__$1 = state_51971;
var statearr_51978_52241 = state_51971__$1;
(statearr_51978_52241[(2)] = true);

(statearr_51978_52241[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51972 === (17))){
var inst_51911 = (state_51971[(9)]);
var inst_51912 = (state_51971[(10)]);
var inst_51910 = (state_51971[(11)]);
var inst_51909 = (state_51971[(12)]);
var inst_51923 = (state_51971[(2)]);
var inst_51963 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_51964 = (function (){var map__51886 = inst_51909;
var message = inst_51910;
var error = inst_51911;
var fail_fn = inst_51912;
var c__42130__auto____$1 = inst_51963;
return (function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_51961){
var state_val_51962 = (state_51961[(1)]);
if((state_val_51962 === (7))){
var inst_51943 = (state_51961[(2)]);
var state_51961__$1 = state_51961;
if(cljs.core.truth_(inst_51943)){
var statearr_51979_52243 = state_51961__$1;
(statearr_51979_52243[(1)] = (11));

} else {
var statearr_51980_52244 = state_51961__$1;
(statearr_51980_52244[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51962 === (1))){
var state_51961__$1 = state_51961;
var statearr_51981_52245 = state_51961__$1;
(statearr_51981_52245[(2)] = null);

(statearr_51981_52245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51962 === (4))){
var inst_51927 = (state_51961[(7)]);
var inst_51927__$1 = (state_51961[(2)]);
var inst_51929 = (inst_51927__$1 == null);
var inst_51930 = cljs.core.not(inst_51929);
var state_51961__$1 = (function (){var statearr_51982 = state_51961;
(statearr_51982[(7)] = inst_51927__$1);

return statearr_51982;
})();
if(inst_51930){
var statearr_51983_52247 = state_51961__$1;
(statearr_51983_52247[(1)] = (5));

} else {
var statearr_51984_52248 = state_51961__$1;
(statearr_51984_52248[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51962 === (15))){
var inst_51950 = (state_51961[(8)]);
var inst_51955 = (fail_fn.cljs$core$IFn$_invoke$arity$1 ? fail_fn.cljs$core$IFn$_invoke$arity$1(inst_51950) : fail_fn.call(null,inst_51950));
var state_51961__$1 = state_51961;
var statearr_51985_52249 = state_51961__$1;
(statearr_51985_52249[(2)] = inst_51955);

(statearr_51985_52249[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51962 === (13))){
var inst_51949 = (state_51961[(9)]);
var inst_51948 = (state_51961[(2)]);
var inst_51949__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51948,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_51950 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51948,new cljs.core.Keyword(null,"error","error",-978969032));
var state_51961__$1 = (function (){var statearr_51986 = state_51961;
(statearr_51986[(8)] = inst_51950);

(statearr_51986[(9)] = inst_51949__$1);

return statearr_51986;
})();
if(cljs.core.truth_(inst_51949__$1)){
var statearr_51987_52250 = state_51961__$1;
(statearr_51987_52250[(1)] = (14));

} else {
var statearr_51988_52251 = state_51961__$1;
(statearr_51988_52251[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51962 === (6))){
var state_51961__$1 = state_51961;
var statearr_51989_52252 = state_51961__$1;
(statearr_51989_52252[(2)] = false);

(statearr_51989_52252[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51962 === (3))){
var inst_51959 = (state_51961[(2)]);
var state_51961__$1 = state_51961;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51961__$1,inst_51959);
} else {
if((state_val_51962 === (12))){
var inst_51927 = (state_51961[(7)]);
var state_51961__$1 = state_51961;
var statearr_51990_52253 = state_51961__$1;
(statearr_51990_52253[(2)] = inst_51927);

(statearr_51990_52253[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51962 === (2))){
var state_51961__$1 = state_51961;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51961__$1,(4),ws_chan);
} else {
if((state_val_51962 === (11))){
var inst_51927 = (state_51961[(7)]);
var inst_51945 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_51927);
var state_51961__$1 = state_51961;
var statearr_51991_52254 = state_51961__$1;
(statearr_51991_52254[(2)] = inst_51945);

(statearr_51991_52254[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51962 === (9))){
var state_51961__$1 = state_51961;
var statearr_51992_52255 = state_51961__$1;
(statearr_51992_52255[(2)] = false);

(statearr_51992_52255[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51962 === (5))){
var inst_51927 = (state_51961[(7)]);
var inst_51932 = inst_51927.cljs$lang$protocol_mask$partition0$;
var inst_51933 = (inst_51932 & (64));
var inst_51934 = inst_51927.cljs$core$ISeq$;
var inst_51935 = (cljs.core.PROTOCOL_SENTINEL === inst_51934);
var inst_51936 = ((inst_51933) || (inst_51935));
var state_51961__$1 = state_51961;
if(cljs.core.truth_(inst_51936)){
var statearr_51993_52256 = state_51961__$1;
(statearr_51993_52256[(1)] = (8));

} else {
var statearr_51994_52257 = state_51961__$1;
(statearr_51994_52257[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51962 === (14))){
var inst_51949 = (state_51961[(9)]);
var inst_51952 = pinkgorilla.kernel.nrepl.process_msg(inst_51949);
var state_51961__$1 = (function (){var statearr_51995 = state_51961;
(statearr_51995[(10)] = inst_51952);

return statearr_51995;
})();
var statearr_51996_52259 = state_51961__$1;
(statearr_51996_52259[(2)] = null);

(statearr_51996_52259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51962 === (16))){
var inst_51957 = (state_51961[(2)]);
var state_51961__$1 = state_51961;
var statearr_51997_52262 = state_51961__$1;
(statearr_51997_52262[(2)] = inst_51957);

(statearr_51997_52262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51962 === (10))){
var inst_51940 = (state_51961[(2)]);
var state_51961__$1 = state_51961;
var statearr_51998_52263 = state_51961__$1;
(statearr_51998_52263[(2)] = inst_51940);

(statearr_51998_52263[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51962 === (8))){
var state_51961__$1 = state_51961;
var statearr_51999_52264 = state_51961__$1;
(statearr_51999_52264[(2)] = true);

(statearr_51999_52264[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0 = (function (){
var statearr_52000 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_52000[(0)] = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__);

(statearr_52000[(1)] = (1));

return statearr_52000;
});
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1 = (function (state_51961){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_51961);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52001){if((e52001 instanceof Object)){
var ex__42066__auto__ = e52001;
var statearr_52002_52267 = state_51961;
(statearr_52002_52267[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51961);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52001;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52268 = state_51961;
state_51961 = G__52268;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__ = function(state_51961){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1.call(this,state_51961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_52003 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_52003[(6)] = c__42130__auto____$1);

return statearr_52003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
});
})();
var inst_51965 = cljs.core.async.impl.dispatch.run(inst_51964);
var state_51971__$1 = (function (){var statearr_52004 = state_51971;
(statearr_52004[(13)] = inst_51965);

(statearr_52004[(14)] = inst_51923);

return statearr_52004;
})();
var statearr_52005_52270 = state_51971__$1;
(statearr_52005_52270[(2)] = inst_51963);

(statearr_52005_52270[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51972 === (3))){
var inst_51888 = (state_51971[(15)]);
var inst_51893 = inst_51888.cljs$lang$protocol_mask$partition0$;
var inst_51894 = (inst_51893 & (64));
var inst_51895 = inst_51888.cljs$core$ISeq$;
var inst_51896 = (cljs.core.PROTOCOL_SENTINEL === inst_51895);
var inst_51897 = ((inst_51894) || (inst_51896));
var state_51971__$1 = state_51971;
if(cljs.core.truth_(inst_51897)){
var statearr_52006_52271 = state_51971__$1;
(statearr_52006_52271[(1)] = (6));

} else {
var statearr_52007_52272 = state_51971__$1;
(statearr_52007_52272[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51972 === (12))){
var inst_51911 = (state_51971[(9)]);
var inst_51912 = (state_51971[(10)]);
var inst_51917 = (state_51971[(7)]);
var inst_51910 = (state_51971[(11)]);
var inst_51909 = (state_51971[(12)]);
var inst_51914 = (function (){var map__51886 = inst_51909;
var message = inst_51910;
var error = inst_51911;
var fail_fn = inst_51912;
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got initial message ",message], null);
});
})();
var inst_51915 = (new cljs.core.Delay(inst_51914,null));
var inst_51916 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init1011153544949464259.clj",190,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_51915,null,568925335);
var inst_51917__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51910,"new-session");
var state_51971__$1 = (function (){var statearr_52008 = state_51971;
(statearr_52008[(16)] = inst_51916);

(statearr_52008[(7)] = inst_51917__$1);

return statearr_52008;
})();
if(cljs.core.truth_(inst_51917__$1)){
var statearr_52009_52273 = state_51971__$1;
(statearr_52009_52273[(1)] = (15));

} else {
var statearr_52010_52274 = state_51971__$1;
(statearr_52010_52274[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51972 === (2))){
var inst_51888 = (state_51971[(15)]);
var inst_51888__$1 = (state_51971[(2)]);
var inst_51890 = (inst_51888__$1 == null);
var inst_51891 = cljs.core.not(inst_51890);
var state_51971__$1 = (function (){var statearr_52011 = state_51971;
(statearr_52011[(15)] = inst_51888__$1);

return statearr_52011;
})();
if(inst_51891){
var statearr_52013_52275 = state_51971__$1;
(statearr_52013_52275[(1)] = (3));

} else {
var statearr_52014_52276 = state_51971__$1;
(statearr_52014_52276[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51972 === (11))){
var inst_51911 = (state_51971[(9)]);
var inst_51910 = (state_51971[(11)]);
var inst_51909 = (state_51971[(12)]);
var inst_51909__$1 = (state_51971[(2)]);
var inst_51910__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51909__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_51911__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51909__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var inst_51912 = (function (){var map__51886 = inst_51909__$1;
var message = inst_51910__$1;
var error = inst_51911__$1;
return (function (error__$1){
cljs.core.async.close_BANG_(ws_chan);

cljs.core.async.close_BANG_(msg_chan);

pinkgorilla.notifications.add_notification(pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"danger","danger",-624338030),["clj-kernel Fatal Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(error__$1)].join('')));

return pinkgorilla.kernel.nrepl.set_clj_kernel_status(false,null);
});
})();
var state_51971__$1 = (function (){var statearr_52016 = state_51971;
(statearr_52016[(9)] = inst_51911__$1);

(statearr_52016[(10)] = inst_51912);

(statearr_52016[(11)] = inst_51910__$1);

(statearr_52016[(12)] = inst_51909__$1);

return statearr_52016;
})();
if(cljs.core.truth_(inst_51910__$1)){
var statearr_52017_52277 = state_51971__$1;
(statearr_52017_52277[(1)] = (12));

} else {
var statearr_52018_52278 = state_51971__$1;
(statearr_52018_52278[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51972 === (9))){
var inst_51888 = (state_51971[(15)]);
var inst_51906 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_51888);
var state_51971__$1 = state_51971;
var statearr_52019_52279 = state_51971__$1;
(statearr_52019_52279[(2)] = inst_51906);

(statearr_52019_52279[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51972 === (5))){
var inst_51904 = (state_51971[(2)]);
var state_51971__$1 = state_51971;
if(cljs.core.truth_(inst_51904)){
var statearr_52020_52280 = state_51971__$1;
(statearr_52020_52280[(1)] = (9));

} else {
var statearr_52021_52281 = state_51971__$1;
(statearr_52021_52281[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51972 === (14))){
var inst_51969 = (state_51971[(2)]);
var state_51971__$1 = state_51971;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51971__$1,inst_51969);
} else {
if((state_val_51972 === (16))){
var state_51971__$1 = state_51971;
var statearr_52022_52282 = state_51971__$1;
(statearr_52022_52282[(2)] = null);

(statearr_52022_52282[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51972 === (10))){
var inst_51888 = (state_51971[(15)]);
var state_51971__$1 = state_51971;
var statearr_52023_52283 = state_51971__$1;
(statearr_52023_52283[(2)] = inst_51888);

(statearr_52023_52283[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51972 === (8))){
var inst_51901 = (state_51971[(2)]);
var state_51971__$1 = state_51971;
var statearr_52024_52284 = state_51971__$1;
(statearr_52024_52284[(2)] = inst_51901);

(statearr_52024_52284[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0 = (function (){
var statearr_52025 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52025[(0)] = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__);

(statearr_52025[(1)] = (1));

return statearr_52025;
});
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1 = (function (state_51971){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_51971);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52026){if((e52026 instanceof Object)){
var ex__42066__auto__ = e52026;
var statearr_52027_52285 = state_51971;
(statearr_52027_52285[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51971);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52026;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52286 = state_51971;
state_51971 = G__52286;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__ = function(state_51971){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1.call(this,state_51971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_52028 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_52028[(6)] = c__42130__auto__);

return statearr_52028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));

return c__42130__auto__;
});
pinkgorilla.kernel.nrepl.start_repl_BANG_ = (function pinkgorilla$kernel$nrepl$start_repl_BANG_(ws_url){
var c__42130__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_52149){
var state_val_52150 = (state_52149[(1)]);
if((state_val_52150 === (7))){
var state_52149__$1 = state_52149;
var statearr_52151_52287 = state_52149__$1;
(statearr_52151_52287[(2)] = false);

(statearr_52151_52287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (20))){
var inst_52061 = (state_52149[(7)]);
var inst_52082 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_52061);
var state_52149__$1 = state_52149;
var statearr_52152_52288 = state_52149__$1;
(statearr_52152_52288[(2)] = inst_52082);

(statearr_52152_52288[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (27))){
var state_52149__$1 = state_52149;
var statearr_52153_52289 = state_52149__$1;
(statearr_52153_52289[(2)] = null);

(statearr_52153_52289[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (1))){
var inst_52032 = [new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_52033 = [new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_52034 = cljs.core.PersistentHashMap.fromArrays(inst_52032,inst_52033);
var inst_52035 = chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(ws_url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_52034], 0));
var state_52149__$1 = state_52149;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52149__$1,(2),inst_52035);
} else {
if((state_val_52150 === (24))){
var inst_52087 = (state_52149[(8)]);
var inst_52129 = (state_52149[(9)]);
var inst_52128 = cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl);
var inst_52129__$1 = new cljs.core.Keyword(null,"session-id","session-id",-1147060351).cljs$core$IFn$_invoke$arity$1(inst_52128);
var inst_52130 = ["clj-kernel error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_52087)," - trying to recover with session ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_52129__$1)].join('');
var inst_52131 = pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"danger","danger",-624338030),inst_52130);
var inst_52132 = pinkgorilla.notifications.add_notification(inst_52131);
var inst_52133 = cljs.core.async.timeout((3000));
var state_52149__$1 = (function (){var statearr_52154 = state_52149;
(statearr_52154[(9)] = inst_52129__$1);

(statearr_52154[(10)] = inst_52132);

return statearr_52154;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52149__$1,(38),inst_52133);
} else {
if((state_val_52150 === (39))){
var inst_52129 = (state_52149[(9)]);
var inst_52141 = (state_52149[(2)]);
var inst_52142 = (inst_52129 == null);
var inst_52061 = inst_52141;
var inst_52062 = inst_52142;
var state_52149__$1 = (function (){var statearr_52155 = state_52149;
(statearr_52155[(7)] = inst_52061);

(statearr_52155[(11)] = inst_52062);

return statearr_52155;
})();
var statearr_52156_52290 = state_52149__$1;
(statearr_52156_52290[(2)] = null);

(statearr_52156_52290[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (4))){
var state_52149__$1 = state_52149;
var statearr_52157_52291 = state_52149__$1;
(statearr_52157_52291[(2)] = false);

(statearr_52157_52291[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (15))){
var state_52149__$1 = state_52149;
var statearr_52158_52292 = state_52149__$1;
(statearr_52158_52292[(2)] = false);

(statearr_52158_52292[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (21))){
var inst_52061 = (state_52149[(7)]);
var state_52149__$1 = state_52149;
var statearr_52159_52293 = state_52149__$1;
(statearr_52159_52293[(2)] = inst_52061);

(statearr_52159_52293[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (31))){
var inst_52107 = (state_52149[(12)]);
var inst_52107__$1 = (state_52149[(2)]);
var state_52149__$1 = (function (){var statearr_52160 = state_52149;
(statearr_52160[(12)] = inst_52107__$1);

return statearr_52160;
})();
if(cljs.core.truth_(inst_52107__$1)){
var statearr_52161_52294 = state_52149__$1;
(statearr_52161_52294[(1)] = (32));

} else {
var statearr_52162_52295 = state_52149__$1;
(statearr_52162_52295[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (32))){
var inst_52086 = (state_52149[(13)]);
var inst_52107 = (state_52149[(12)]);
var state_52149__$1 = state_52149;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52149__$1,(35),inst_52086,inst_52107);
} else {
if((state_val_52150 === (33))){
var state_52149__$1 = state_52149;
var statearr_52163_52296 = state_52149__$1;
(statearr_52163_52296[(2)] = null);

(statearr_52163_52296[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (13))){
var inst_52147 = (state_52149[(2)]);
var state_52149__$1 = state_52149;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52149__$1,inst_52147);
} else {
if((state_val_52150 === (22))){
var inst_52087 = (state_52149[(8)]);
var inst_52085 = (state_52149[(14)]);
var inst_52085__$1 = (state_52149[(2)]);
var inst_52086 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52085__$1,new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174));
var inst_52087__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52085__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var inst_52088 = cljs.core.not(inst_52087__$1);
var state_52149__$1 = (function (){var statearr_52164 = state_52149;
(statearr_52164[(8)] = inst_52087__$1);

(statearr_52164[(13)] = inst_52086);

(statearr_52164[(14)] = inst_52085__$1);

return statearr_52164;
})();
if(inst_52088){
var statearr_52165_52297 = state_52149__$1;
(statearr_52165_52297[(1)] = (23));

} else {
var statearr_52166_52298 = state_52149__$1;
(statearr_52166_52298[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (36))){
var inst_52119 = (state_52149[(2)]);
var inst_52120 = [new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_52121 = [new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_52122 = cljs.core.PersistentHashMap.fromArrays(inst_52120,inst_52121);
var inst_52123 = chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(ws_url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_52122], 0));
var state_52149__$1 = (function (){var statearr_52167 = state_52149;
(statearr_52167[(15)] = inst_52119);

return statearr_52167;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52149__$1,(37),inst_52123);
} else {
if((state_val_52150 === (29))){
var inst_52090 = (state_52149[(16)]);
var state_52149__$1 = state_52149;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52149__$1,(31),inst_52090);
} else {
if((state_val_52150 === (6))){
var state_52149__$1 = state_52149;
var statearr_52168_52299 = state_52149__$1;
(statearr_52168_52299[(2)] = true);

(statearr_52168_52299[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (28))){
var inst_52086 = (state_52149[(13)]);
var inst_52090 = (state_52149[(16)]);
var inst_52103 = (state_52149[(2)]);
var inst_52104 = pinkgorilla.kernel.nrepl.receive_msgs_BANG_(inst_52086,inst_52090);
var state_52149__$1 = (function (){var statearr_52169 = state_52149;
(statearr_52169[(17)] = inst_52103);

(statearr_52169[(18)] = inst_52104);

return statearr_52169;
})();
var statearr_52170_52300 = state_52149__$1;
(statearr_52170_52300[(2)] = null);

(statearr_52170_52300[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (25))){
var inst_52145 = (state_52149[(2)]);
var state_52149__$1 = state_52149;
var statearr_52171_52301 = state_52149__$1;
(statearr_52171_52301[(2)] = inst_52145);

(statearr_52171_52301[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (34))){
var inst_52114 = (state_52149[(2)]);
var state_52149__$1 = state_52149;
var statearr_52172_52302 = state_52149__$1;
(statearr_52172_52302[(2)] = inst_52114);

(statearr_52172_52302[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (17))){
var state_52149__$1 = state_52149;
var statearr_52173_52303 = state_52149__$1;
(statearr_52173_52303[(2)] = true);

(statearr_52173_52303[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (3))){
var inst_52037 = (state_52149[(19)]);
var inst_52042 = inst_52037.cljs$lang$protocol_mask$partition0$;
var inst_52043 = (inst_52042 & (64));
var inst_52044 = inst_52037.cljs$core$ISeq$;
var inst_52045 = (cljs.core.PROTOCOL_SENTINEL === inst_52044);
var inst_52046 = ((inst_52043) || (inst_52045));
var state_52149__$1 = state_52149;
if(cljs.core.truth_(inst_52046)){
var statearr_52174_52304 = state_52149__$1;
(statearr_52174_52304[(1)] = (6));

} else {
var statearr_52175_52305 = state_52149__$1;
(statearr_52175_52305[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (12))){
var inst_52061 = (state_52149[(7)]);
var inst_52066 = (inst_52061 == null);
var inst_52067 = cljs.core.not(inst_52066);
var state_52149__$1 = state_52149;
if(inst_52067){
var statearr_52176_52306 = state_52149__$1;
(statearr_52176_52306[(1)] = (14));

} else {
var statearr_52177_52307 = state_52149__$1;
(statearr_52177_52307[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (2))){
var inst_52037 = (state_52149[(19)]);
var inst_52037__$1 = (state_52149[(2)]);
var inst_52039 = (inst_52037__$1 == null);
var inst_52040 = cljs.core.not(inst_52039);
var state_52149__$1 = (function (){var statearr_52178 = state_52149;
(statearr_52178[(19)] = inst_52037__$1);

return statearr_52178;
})();
if(inst_52040){
var statearr_52179_52308 = state_52149__$1;
(statearr_52179_52308[(1)] = (3));

} else {
var statearr_52180_52309 = state_52149__$1;
(statearr_52180_52309[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (23))){
var inst_52090 = (state_52149[(16)]);
var inst_52062 = (state_52149[(11)]);
var inst_52090__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_52091 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc,new cljs.core.Keyword(null,"channel","channel",734187692),inst_52090__$1);
var state_52149__$1 = (function (){var statearr_52181 = state_52149;
(statearr_52181[(16)] = inst_52090__$1);

(statearr_52181[(20)] = inst_52091);

return statearr_52181;
})();
if(cljs.core.truth_(inst_52062)){
var statearr_52182_52310 = state_52149__$1;
(statearr_52182_52310[(1)] = (26));

} else {
var statearr_52183_52311 = state_52149__$1;
(statearr_52183_52311[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (35))){
var inst_52110 = (state_52149[(2)]);
var state_52149__$1 = (function (){var statearr_52184 = state_52149;
(statearr_52184[(21)] = inst_52110);

return statearr_52184;
})();
var statearr_52185_52312 = state_52149__$1;
(statearr_52185_52312[(2)] = null);

(statearr_52185_52312[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (19))){
var inst_52077 = (state_52149[(2)]);
var state_52149__$1 = state_52149;
var statearr_52186_52313 = state_52149__$1;
(statearr_52186_52313[(2)] = inst_52077);

(statearr_52186_52313[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (11))){
var inst_52037 = (state_52149[(19)]);
var inst_52058 = (state_52149[(22)]);
var inst_52058__$1 = (state_52149[(2)]);
var inst_52059 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52058__$1,new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174));
var inst_52060 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52058__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var inst_52061 = inst_52037;
var inst_52062 = true;
var state_52149__$1 = (function (){var statearr_52187 = state_52149;
(statearr_52187[(7)] = inst_52061);

(statearr_52187[(23)] = inst_52059);

(statearr_52187[(11)] = inst_52062);

(statearr_52187[(22)] = inst_52058__$1);

(statearr_52187[(24)] = inst_52060);

return statearr_52187;
})();
var statearr_52188_52314 = state_52149__$1;
(statearr_52188_52314[(2)] = null);

(statearr_52188_52314[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (9))){
var inst_52037 = (state_52149[(19)]);
var inst_52055 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_52037);
var state_52149__$1 = state_52149;
var statearr_52189_52315 = state_52149__$1;
(statearr_52189_52315[(2)] = inst_52055);

(statearr_52189_52315[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (5))){
var inst_52053 = (state_52149[(2)]);
var state_52149__$1 = state_52149;
if(cljs.core.truth_(inst_52053)){
var statearr_52190_52316 = state_52149__$1;
(statearr_52190_52316[(1)] = (9));

} else {
var statearr_52191_52317 = state_52149__$1;
(statearr_52191_52317[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (14))){
var inst_52061 = (state_52149[(7)]);
var inst_52069 = inst_52061.cljs$lang$protocol_mask$partition0$;
var inst_52070 = (inst_52069 & (64));
var inst_52071 = inst_52061.cljs$core$ISeq$;
var inst_52072 = (cljs.core.PROTOCOL_SENTINEL === inst_52071);
var inst_52073 = ((inst_52070) || (inst_52072));
var state_52149__$1 = state_52149;
if(cljs.core.truth_(inst_52073)){
var statearr_52192_52318 = state_52149__$1;
(statearr_52192_52318[(1)] = (17));

} else {
var statearr_52193_52319 = state_52149__$1;
(statearr_52193_52319[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (26))){
var inst_52087 = (state_52149[(8)]);
var inst_52086 = (state_52149[(13)]);
var inst_52061 = (state_52149[(7)]);
var inst_52090 = (state_52149[(16)]);
var inst_52085 = (state_52149[(14)]);
var inst_52062 = (state_52149[(11)]);
var inst_52058 = (state_52149[(22)]);
var inst_52098 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_52099 = (function (){var G__52030 = inst_52061;
var map__52031 = inst_52058;
var ws_channel = inst_52086;
var error = inst_52087;
var new_session = inst_52062;
var map__52064 = inst_52085;
var msg_ch = inst_52090;
var c__42130__auto____$1 = inst_52098;
return (function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_52096){
var state_val_52097 = (state_52096[(1)]);
if((state_val_52097 === (1))){
var state_52096__$1 = state_52096;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52096__$1,(2),msg_ch,({"op": "clone"}));
} else {
if((state_val_52097 === (2))){
var inst_52094 = (state_52096[(2)]);
var state_52096__$1 = state_52096;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52096__$1,inst_52094);
} else {
return null;
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto____0 = (function (){
var statearr_52194 = [null,null,null,null,null,null,null];
(statearr_52194[(0)] = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto__);

(statearr_52194[(1)] = (1));

return statearr_52194;
});
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto____1 = (function (state_52096){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_52096);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52195){if((e52195 instanceof Object)){
var ex__42066__auto__ = e52195;
var statearr_52196_52320 = state_52096;
(statearr_52196_52320[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52096);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52195;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52321 = state_52096;
state_52096 = G__52321;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto__ = function(state_52096){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto____1.call(this,state_52096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_52197 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_52197[(6)] = c__42130__auto____$1);

return statearr_52197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
});
})();
var inst_52100 = cljs.core.async.impl.dispatch.run(inst_52099);
var state_52149__$1 = (function (){var statearr_52198 = state_52149;
(statearr_52198[(25)] = inst_52100);

return statearr_52198;
})();
var statearr_52199_52322 = state_52149__$1;
(statearr_52199_52322[(2)] = inst_52098);

(statearr_52199_52322[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (16))){
var inst_52080 = (state_52149[(2)]);
var state_52149__$1 = state_52149;
if(cljs.core.truth_(inst_52080)){
var statearr_52200_52323 = state_52149__$1;
(statearr_52200_52323[(1)] = (20));

} else {
var statearr_52201_52324 = state_52149__$1;
(statearr_52201_52324[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (38))){
var inst_52135 = (state_52149[(2)]);
var inst_52136 = [new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_52137 = [new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_52138 = cljs.core.PersistentHashMap.fromArrays(inst_52136,inst_52137);
var inst_52139 = chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(ws_url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_52138], 0));
var state_52149__$1 = (function (){var statearr_52202 = state_52149;
(statearr_52202[(26)] = inst_52135);

return statearr_52202;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52149__$1,(39),inst_52139);
} else {
if((state_val_52150 === (30))){
var inst_52116 = (state_52149[(2)]);
var inst_52117 = cljs.core.async.timeout((3000));
var state_52149__$1 = (function (){var statearr_52203 = state_52149;
(statearr_52203[(27)] = inst_52116);

return statearr_52203;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52149__$1,(36),inst_52117);
} else {
if((state_val_52150 === (10))){
var inst_52037 = (state_52149[(19)]);
var state_52149__$1 = state_52149;
var statearr_52204_52325 = state_52149__$1;
(statearr_52204_52325[(2)] = inst_52037);

(statearr_52204_52325[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (18))){
var state_52149__$1 = state_52149;
var statearr_52205_52326 = state_52149__$1;
(statearr_52205_52326[(2)] = false);

(statearr_52205_52326[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (37))){
var inst_52125 = (state_52149[(2)]);
var inst_52061 = inst_52125;
var inst_52062 = false;
var state_52149__$1 = (function (){var statearr_52206 = state_52149;
(statearr_52206[(7)] = inst_52061);

(statearr_52206[(11)] = inst_52062);

return statearr_52206;
})();
var statearr_52207_52327 = state_52149__$1;
(statearr_52207_52327[(2)] = null);

(statearr_52207_52327[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52150 === (8))){
var inst_52050 = (state_52149[(2)]);
var state_52149__$1 = state_52149;
var statearr_52208_52328 = state_52149__$1;
(statearr_52208_52328[(2)] = inst_52050);

(statearr_52208_52328[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto____0 = (function (){
var statearr_52209 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52209[(0)] = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto__);

(statearr_52209[(1)] = (1));

return statearr_52209;
});
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto____1 = (function (state_52149){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_52149);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52210){if((e52210 instanceof Object)){
var ex__42066__auto__ = e52210;
var statearr_52211_52329 = state_52149;
(statearr_52211_52329[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52149);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52210;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52330 = state_52149;
state_52149 = G__52330;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto__ = function(state_52149){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto____1.call(this,state_52149);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_52212 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_52212[(6)] = c__42130__auto__);

return statearr_52212;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));

return c__42130__auto__;
});
pinkgorilla.kernel.nrepl.clj_eval = (function pinkgorilla$kernel$nrepl$clj_eval(snippet,callback){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["clj-eval: ",snippet], 0));

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init1011153544949464259.clj",261,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["clj-eval: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(snippet)].join('')], null);
}),null)),null,-974847466);

return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),"eval",new cljs.core.Keyword(null,"code","code",1586293142),snippet], null),(function (message){
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"ns");
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init1011153544949464259.clj",266,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["ns: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join('')], null);
}),null)),null,-1253686158);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"value");
var data = pinkgorilla.kernel.nrepl.parse_value(value);
if(cljs.core.truth_(ns)){
var v2 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(data));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init1011153544949464259.clj",270,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["clj-eval response: ",data," type: ",cljs.core.type(value)], null);
}),null)),null,598544139);

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init1011153544949464259.clj",271,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["clj-eval result: ",v2," type: ",cljs.core.type(v2)], null);
}),null)),null,366658495);

return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(v2) : callback.call(null,v2));
} else {
return null;
}
}));
});
goog.exportSymbol('pinkgorilla.kernel.nrepl.clj_eval', pinkgorilla.kernel.nrepl.clj_eval);
pinkgorilla.kernel.nrepl.clj_eval_sync = (function pinkgorilla$kernel$nrepl$clj_eval_sync(result_atom,snippet){
var result_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__42130__auto___52331 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_52216){
var state_val_52217 = (state_52216[(1)]);
if((state_val_52217 === (1))){
var inst_52213 = (function (){return (function (result){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init1011153544949464259.clj",279,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["async evalued result: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(result)].join('')], null);
}),null)),null,616426730);

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_chan,result);
});
})();
var inst_52214 = pinkgorilla.kernel.nrepl.clj_eval(snippet,inst_52213);
var state_52216__$1 = state_52216;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52216__$1,inst_52214);
} else {
return null;
}
});
return (function() {
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0 = (function (){
var statearr_52218 = [null,null,null,null,null,null,null];
(statearr_52218[(0)] = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__);

(statearr_52218[(1)] = (1));

return statearr_52218;
});
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1 = (function (state_52216){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_52216);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52219){if((e52219 instanceof Object)){
var ex__42066__auto__ = e52219;
var statearr_52220_52332 = state_52216;
(statearr_52220_52332[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52216);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52219;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52333 = state_52216;
state_52216 = G__52333;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__ = function(state_52216){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1.call(this,state_52216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_52221 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_52221[(6)] = c__42130__auto___52331);

return statearr_52221;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


var c__42130__auto___52335 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_52226){
var state_val_52227 = (state_52226[(1)]);
if((state_val_52227 === (1))){
var state_52226__$1 = state_52226;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52226__$1,(2),result_chan);
} else {
if((state_val_52227 === (2))){
var inst_52223 = (state_52226[(2)]);
var inst_52224 = cljs.core.reset_BANG_(result_atom,inst_52223);
var state_52226__$1 = state_52226;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52226__$1,inst_52224);
} else {
return null;
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0 = (function (){
var statearr_52228 = [null,null,null,null,null,null,null];
(statearr_52228[(0)] = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__);

(statearr_52228[(1)] = (1));

return statearr_52228;
});
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1 = (function (state_52226){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_52226);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52229){if((e52229 instanceof Object)){
var ex__42066__auto__ = e52229;
var statearr_52230_52339 = state_52226;
(statearr_52230_52339[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52226);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52229;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52341 = state_52226;
state_52226 = G__52341;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__ = function(state_52226){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1.call(this,state_52226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_52231 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_52231[(6)] = c__42130__auto___52335);

return statearr_52231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));


return result_atom;
});
goog.exportSymbol('pinkgorilla.kernel.nrepl.clj_eval_sync', pinkgorilla.kernel.nrepl.clj_eval_sync);
pinkgorilla.kernel.nrepl.clj = (function pinkgorilla$kernel$nrepl$clj(var_args){
var args__4795__auto__ = [];
var len__4789__auto___52343 = arguments.length;
var i__4790__auto___52344 = (0);
while(true){
if((i__4790__auto___52344 < len__4789__auto___52343)){
args__4795__auto__.push((arguments[i__4790__auto___52344]));

var G__52345 = (i__4790__auto___52344 + (1));
i__4790__auto___52344 = G__52345;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return pinkgorilla.kernel.nrepl.clj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});
goog.exportSymbol('pinkgorilla.kernel.nrepl.clj', pinkgorilla.kernel.nrepl.clj);

(pinkgorilla.kernel.nrepl.clj.cljs$core$IFn$_invoke$arity$variadic = (function (result_atom,function_as_string,params){
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init1011153544949464259.clj",286,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["params: ",params], null);
}),null)),null,-2139912923);
var expr = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(",function_as_string], null),params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [")"], null)], 0));
var str_eval = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",expr);
var ___$1 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init1011153544949464259.clj",289,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["Calling CLJ: ",str_eval].join('')], null);
}),null)),null,1253457998);
return pinkgorilla.kernel.nrepl.clj_eval_sync(result_atom,str_eval);
}));

(pinkgorilla.kernel.nrepl.clj.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.kernel.nrepl.clj.cljs$lang$applyTo = (function (seq52232){
var G__52233 = cljs.core.first(seq52232);
var seq52232__$1 = cljs.core.next(seq52232);
var G__52234 = cljs.core.first(seq52232__$1);
var seq52232__$2 = cljs.core.next(seq52232__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__52233,G__52234,seq52232__$2);
}));


//# sourceMappingURL=pinkgorilla.kernel.nrepl.js.map
