goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('dommy.utils');
/**
 * Returns a selector in string format.
 * Accepts string, keyword, or collection.
 */
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_(data)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(dommy.core.selector,data));
} else {
if(((typeof data === 'string') || ((data instanceof cljs.core.Keyword)))){
return cljs.core.name(data);
} else {
return null;
}
}
});
dommy.core.text = (function dommy$core$text(elem){
var or__4185__auto__ = elem.textContent;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return elem.innerText;
}
});
dommy.core.html = (function dommy$core$html(elem){
return elem.innerHTML;
});
dommy.core.value = (function dommy$core$value(elem){
return elem.value;
});
dommy.core.class$ = (function dommy$core$class(elem){
return elem.className;
});
dommy.core.attr = (function dommy$core$attr(elem,k){
if(cljs.core.truth_(k)){
return elem.getAttribute(dommy.utils.as_str(k));
} else {
return null;
}
});
/**
 * The computed style of `elem`, optionally specifying the key of
 * a particular style to return
 */
dommy.core.style = (function dommy$core$style(var_args){
var G__47785 = arguments.length;
switch (G__47785) {
case 1:
return dommy.core.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.style.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(window.getComputedStyle(elem));
}));

(dommy.core.style.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return (window.getComputedStyle(elem)[dommy.utils.as_str(k)]);
}));

(dommy.core.style.cljs$lang$maxFixedArity = 2);

dommy.core.px = (function dommy$core$px(elem,k){

var pixels = dommy.core.style.cljs$core$IFn$_invoke$arity$2(elem,k);
if(cljs.core.seq(pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Does `elem` contain `c` in its class list
 */
dommy.core.has_class_QMARK_ = (function dommy$core$has_class_QMARK_(elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto__ = elem.classList;
if(cljs.core.truth_(temp__5733__auto__)){
var class_list = temp__5733__auto__;
return class_list.contains(c__$1);
} else {
var temp__5735__auto__ = dommy.core.class$(elem);
if(cljs.core.truth_(temp__5735__auto__)){
var class_name = temp__5735__auto__;
var temp__5735__auto____$1 = dommy.utils.class_index(class_name,c__$1);
if(cljs.core.truth_(temp__5735__auto____$1)){
var i = temp__5735__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Is `elem` hidden (as associated with hide!/show!/toggle!, using display: none)
 */
dommy.core.hidden_QMARK_ = (function dommy$core$hidden_QMARK_(elem){
return (dommy.core.style.cljs$core$IFn$_invoke$arity$2(elem,new cljs.core.Keyword(null,"display","display",242065432)) === "none");
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.core.bounding_client_rect = (function dommy$core$bounding_client_rect(elem){
var r = elem.getBoundingClientRect();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top","top",-1856271961),r.top,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),r.bottom,new cljs.core.Keyword(null,"left","left",-399115937),r.left,new cljs.core.Keyword(null,"right","right",-452581833),r.right,new cljs.core.Keyword(null,"width","width",-384071477),r.width,new cljs.core.Keyword(null,"height","height",1025178622),r.height], null);
});
dommy.core.parent = (function dommy$core$parent(elem){
return elem.parentNode;
});
dommy.core.children = (function dommy$core$children(elem){
return elem.children;
});
/**
 * Lazy seq of the ancestors of `elem`
 */
dommy.core.ancestors = (function dommy$core$ancestors(elem){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.iterate(dommy.core.parent,elem));
});
dommy.core.ancestor_nodes = dommy.core.ancestors;
/**
 * Returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(var_args){
var G__47787 = arguments.length;
switch (G__47787) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array(base.querySelectorAll(dommy.core.selector(selector)));
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
}));

(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(document,selector);
}));

(dommy.core.matches_pred.cljs$lang$maxFixedArity = 2);

/**
 * Closest ancestor of `elem` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(var_args){
var G__47790 = arguments.length;
switch (G__47790) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(base,selector),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((function (p1__47788_SHARP_){
return (!((p1__47788_SHARP_ === base)));
}),dommy.core.ancestors(elem))));
}));

(dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3(document.body,elem,selector);
}));

(dommy.core.closest.cljs$lang$maxFixedArity = 3);

/**
 * Is `descendant` a descendant of `ancestor`?
 * (http://goo.gl/T8pgCX)
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
if(cljs.core.truth_(ancestor.contains)){
return ancestor.contains(descendant);
} else {
if(cljs.core.truth_(ancestor.compareDocumentPosition)){
return ((ancestor.compareDocumentPosition(descendant) & (1 << (4))) != 0);
} else {
return null;
}
}
});
/**
 * Set the textContent of `elem` to `text`, fall back to innerText
 */
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
if((!((void 0 === elem.textContent)))){
(elem.textContent = text);
} else {
(elem.innerText = text);
}

return elem;
});
/**
 * Set the innerHTML of `elem` to `html`
 */
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
(elem.innerHTML = html);

return elem;
});
/**
 * Set the value of `elem` to `value`
 */
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
(elem.value = value);

return elem;
});
/**
 * Set the css class of `elem` to `elem`
 */
dommy.core.set_class_BANG_ = (function dommy$core$set_class_BANG_(elem,c){
return (elem.className = c);
});
/**
 * Set the style of `elem` using key-value pairs:
 * 
 *    (set-style! elem :display "block" :color "red")
 */
dommy.core.set_style_BANG_ = (function dommy$core$set_style_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___48182 = arguments.length;
var i__4790__auto___48183 = (0);
while(true){
if((i__4790__auto___48183 < len__4789__auto___48182)){
args__4795__auto__.push((arguments[i__4790__auto___48183]));

var G__48184 = (i__4790__auto___48183 + (1));
i__4790__auto___48183 = G__48184;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var style = elem.style;
var seq__47813_48185 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__47814_48186 = null;
var count__47815_48187 = (0);
var i__47816_48188 = (0);
while(true){
if((i__47816_48188 < count__47815_48187)){
var vec__47826_48189 = chunk__47814_48186.cljs$core$IIndexed$_nth$arity$2(null,i__47816_48188);
var k_48190 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47826_48189,(0),null);
var v_48191 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47826_48189,(1),null);
style.setProperty(dommy.utils.as_str(k_48190),v_48191);


var G__48192 = seq__47813_48185;
var G__48193 = chunk__47814_48186;
var G__48194 = count__47815_48187;
var G__48195 = (i__47816_48188 + (1));
seq__47813_48185 = G__48192;
chunk__47814_48186 = G__48193;
count__47815_48187 = G__48194;
i__47816_48188 = G__48195;
continue;
} else {
var temp__5735__auto___48196 = cljs.core.seq(seq__47813_48185);
if(temp__5735__auto___48196){
var seq__47813_48197__$1 = temp__5735__auto___48196;
if(cljs.core.chunked_seq_QMARK_(seq__47813_48197__$1)){
var c__4609__auto___48198 = cljs.core.chunk_first(seq__47813_48197__$1);
var G__48199 = cljs.core.chunk_rest(seq__47813_48197__$1);
var G__48200 = c__4609__auto___48198;
var G__48201 = cljs.core.count(c__4609__auto___48198);
var G__48202 = (0);
seq__47813_48185 = G__48199;
chunk__47814_48186 = G__48200;
count__47815_48187 = G__48201;
i__47816_48188 = G__48202;
continue;
} else {
var vec__47831_48203 = cljs.core.first(seq__47813_48197__$1);
var k_48204 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47831_48203,(0),null);
var v_48205 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47831_48203,(1),null);
style.setProperty(dommy.utils.as_str(k_48204),v_48205);


var G__48206 = cljs.core.next(seq__47813_48197__$1);
var G__48207 = null;
var G__48208 = (0);
var G__48209 = (0);
seq__47813_48185 = G__48206;
chunk__47814_48186 = G__48207;
count__47815_48187 = G__48208;
i__47816_48188 = G__48209;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.set_style_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.set_style_BANG_.cljs$lang$applyTo = (function (seq47807){
var G__47808 = cljs.core.first(seq47807);
var seq47807__$1 = cljs.core.next(seq47807);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47808,seq47807__$1);
}));

/**
 * Remove the style of `elem` using keywords:
 *   
 *    (remove-style! elem :display :color)
 */
dommy.core.remove_style_BANG_ = (function dommy$core$remove_style_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___48210 = arguments.length;
var i__4790__auto___48211 = (0);
while(true){
if((i__4790__auto___48211 < len__4789__auto___48210)){
args__4795__auto__.push((arguments[i__4790__auto___48211]));

var G__48212 = (i__4790__auto___48211 + (1));
i__4790__auto___48211 = G__48212;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,keywords){
var style = elem.style;
var seq__47836_48213 = cljs.core.seq(keywords);
var chunk__47837_48214 = null;
var count__47838_48215 = (0);
var i__47839_48216 = (0);
while(true){
if((i__47839_48216 < count__47838_48215)){
var kw_48217 = chunk__47837_48214.cljs$core$IIndexed$_nth$arity$2(null,i__47839_48216);
style.removeProperty(dommy.utils.as_str(kw_48217));


var G__48218 = seq__47836_48213;
var G__48219 = chunk__47837_48214;
var G__48220 = count__47838_48215;
var G__48221 = (i__47839_48216 + (1));
seq__47836_48213 = G__48218;
chunk__47837_48214 = G__48219;
count__47838_48215 = G__48220;
i__47839_48216 = G__48221;
continue;
} else {
var temp__5735__auto___48222 = cljs.core.seq(seq__47836_48213);
if(temp__5735__auto___48222){
var seq__47836_48223__$1 = temp__5735__auto___48222;
if(cljs.core.chunked_seq_QMARK_(seq__47836_48223__$1)){
var c__4609__auto___48224 = cljs.core.chunk_first(seq__47836_48223__$1);
var G__48225 = cljs.core.chunk_rest(seq__47836_48223__$1);
var G__48226 = c__4609__auto___48224;
var G__48227 = cljs.core.count(c__4609__auto___48224);
var G__48228 = (0);
seq__47836_48213 = G__48225;
chunk__47837_48214 = G__48226;
count__47838_48215 = G__48227;
i__47839_48216 = G__48228;
continue;
} else {
var kw_48229 = cljs.core.first(seq__47836_48223__$1);
style.removeProperty(dommy.utils.as_str(kw_48229));


var G__48230 = cljs.core.next(seq__47836_48223__$1);
var G__48231 = null;
var G__48232 = (0);
var G__48233 = (0);
seq__47836_48213 = G__48230;
chunk__47837_48214 = G__48231;
count__47838_48215 = G__48232;
i__47839_48216 = G__48233;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.remove_style_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.remove_style_BANG_.cljs$lang$applyTo = (function (seq47834){
var G__47835 = cljs.core.first(seq47834);
var seq47834__$1 = cljs.core.next(seq47834);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47835,seq47834__$1);
}));

dommy.core.set_px_BANG_ = (function dommy$core$set_px_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___48234 = arguments.length;
var i__4790__auto___48235 = (0);
while(true){
if((i__4790__auto___48235 < len__4789__auto___48234)){
args__4795__auto__.push((arguments[i__4790__auto___48235]));

var G__48236 = (i__4790__auto___48235 + (1));
i__4790__auto___48235 = G__48236;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){

if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__47842_48237 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__47843_48238 = null;
var count__47844_48239 = (0);
var i__47845_48240 = (0);
while(true){
if((i__47845_48240 < count__47844_48239)){
var vec__47852_48241 = chunk__47843_48238.cljs$core$IIndexed$_nth$arity$2(null,i__47845_48240);
var k_48242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47852_48241,(0),null);
var v_48243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47852_48241,(1),null);
dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k_48242,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_48243),"px"].join('')], 0));


var G__48244 = seq__47842_48237;
var G__48245 = chunk__47843_48238;
var G__48246 = count__47844_48239;
var G__48247 = (i__47845_48240 + (1));
seq__47842_48237 = G__48244;
chunk__47843_48238 = G__48245;
count__47844_48239 = G__48246;
i__47845_48240 = G__48247;
continue;
} else {
var temp__5735__auto___48248 = cljs.core.seq(seq__47842_48237);
if(temp__5735__auto___48248){
var seq__47842_48249__$1 = temp__5735__auto___48248;
if(cljs.core.chunked_seq_QMARK_(seq__47842_48249__$1)){
var c__4609__auto___48250 = cljs.core.chunk_first(seq__47842_48249__$1);
var G__48251 = cljs.core.chunk_rest(seq__47842_48249__$1);
var G__48252 = c__4609__auto___48250;
var G__48253 = cljs.core.count(c__4609__auto___48250);
var G__48254 = (0);
seq__47842_48237 = G__48251;
chunk__47843_48238 = G__48252;
count__47844_48239 = G__48253;
i__47845_48240 = G__48254;
continue;
} else {
var vec__47855_48255 = cljs.core.first(seq__47842_48249__$1);
var k_48256 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47855_48255,(0),null);
var v_48257 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47855_48255,(1),null);
dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k_48256,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_48257),"px"].join('')], 0));


var G__48258 = cljs.core.next(seq__47842_48249__$1);
var G__48259 = null;
var G__48260 = (0);
var G__48261 = (0);
seq__47842_48237 = G__48258;
chunk__47843_48238 = G__48259;
count__47844_48239 = G__48260;
i__47845_48240 = G__48261;
continue;
}
} else {
}
}
break;
}

return elem;
}));

(dommy.core.set_px_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.set_px_BANG_.cljs$lang$applyTo = (function (seq47840){
var G__47841 = cljs.core.first(seq47840);
var seq47840__$1 = cljs.core.next(seq47840);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47841,seq47840__$1);
}));

/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to their name:
 * 
 *     (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 *     (set-attr! elem :id "some-id"
 *                     :name "some-name")
 */
dommy.core.set_attr_BANG_ = (function dommy$core$set_attr_BANG_(var_args){
var G__47863 = arguments.length;
switch (G__47863) {
case 2:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___48263 = arguments.length;
var i__4790__auto___48264 = (0);
while(true){
if((i__4790__auto___48264 < len__4789__auto___48263)){
args_arr__4810__auto__.push((arguments[i__4790__auto___48264]));

var G__48265 = (i__4790__auto___48264 + (1));
i__4790__auto___48264 = G__48265;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((3)),(0),null));
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4811__auto__);

}
});

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,dommy.utils.as_str(k));
}));

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
var k__$1 = dommy.utils.as_str(k);
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_(v)){
var G__47864 = elem;
(G__47864[k__$1] = v);

return G__47864;
} else {
var G__47865 = elem;
G__47865.setAttribute(k__$1,v);

return G__47865;
}
} else {
return null;
}
}));

(dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__47866_48266 = cljs.core.seq(cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs)));
var chunk__47867_48267 = null;
var count__47868_48268 = (0);
var i__47869_48269 = (0);
while(true){
if((i__47869_48269 < count__47868_48268)){
var vec__47876_48270 = chunk__47867_48267.cljs$core$IIndexed$_nth$arity$2(null,i__47869_48269);
var k_48271__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47876_48270,(0),null);
var v_48272__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47876_48270,(1),null);
dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k_48271__$1,v_48272__$1);


var G__48273 = seq__47866_48266;
var G__48274 = chunk__47867_48267;
var G__48275 = count__47868_48268;
var G__48276 = (i__47869_48269 + (1));
seq__47866_48266 = G__48273;
chunk__47867_48267 = G__48274;
count__47868_48268 = G__48275;
i__47869_48269 = G__48276;
continue;
} else {
var temp__5735__auto___48277 = cljs.core.seq(seq__47866_48266);
if(temp__5735__auto___48277){
var seq__47866_48278__$1 = temp__5735__auto___48277;
if(cljs.core.chunked_seq_QMARK_(seq__47866_48278__$1)){
var c__4609__auto___48279 = cljs.core.chunk_first(seq__47866_48278__$1);
var G__48280 = cljs.core.chunk_rest(seq__47866_48278__$1);
var G__48281 = c__4609__auto___48279;
var G__48282 = cljs.core.count(c__4609__auto___48279);
var G__48283 = (0);
seq__47866_48266 = G__48280;
chunk__47867_48267 = G__48281;
count__47868_48268 = G__48282;
i__47869_48269 = G__48283;
continue;
} else {
var vec__47879_48284 = cljs.core.first(seq__47866_48278__$1);
var k_48285__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47879_48284,(0),null);
var v_48286__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47879_48284,(1),null);
dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k_48285__$1,v_48286__$1);


var G__48287 = cljs.core.next(seq__47866_48278__$1);
var G__48288 = null;
var G__48289 = (0);
var G__48290 = (0);
seq__47866_48266 = G__48287;
chunk__47867_48267 = G__48288;
count__47868_48268 = G__48289;
i__47869_48269 = G__48290;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.set_attr_BANG_.cljs$lang$applyTo = (function (seq47859){
var G__47860 = cljs.core.first(seq47859);
var seq47859__$1 = cljs.core.next(seq47859);
var G__47861 = cljs.core.first(seq47859__$1);
var seq47859__$2 = cljs.core.next(seq47859__$1);
var G__47862 = cljs.core.first(seq47859__$2);
var seq47859__$3 = cljs.core.next(seq47859__$2);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47860,G__47861,G__47862,seq47859__$3);
}));

(dommy.core.set_attr_BANG_.cljs$lang$maxFixedArity = (3));

/**
 * Removes dom attributes on and returns `elem`.
 * `class` and `classes` are special cases which clear
 * out the class name on removal.
 */
dommy.core.remove_attr_BANG_ = (function dommy$core$remove_attr_BANG_(var_args){
var G__47886 = arguments.length;
switch (G__47886) {
case 2:
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___48292 = arguments.length;
var i__4790__auto___48293 = (0);
while(true){
if((i__4790__auto___48293 < len__4789__auto___48292)){
args_arr__4810__auto__.push((arguments[i__4790__auto___48293]));

var G__48294 = (i__4790__auto___48293 + (1));
i__4790__auto___48293 = G__48294;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var k_48295__$1 = dommy.utils.as_str(k);
if(cljs.core.truth_((function (){var fexpr__47887 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["class",null,"classes",null], null), null);
return (fexpr__47887.cljs$core$IFn$_invoke$arity$1 ? fexpr__47887.cljs$core$IFn$_invoke$arity$1(k_48295__$1) : fexpr__47887.call(null,k_48295__$1));
})())){
dommy.core.set_class_BANG_(elem,"");
} else {
elem.removeAttribute(k_48295__$1);
}

return elem;
}));

(dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var seq__47888_48296 = cljs.core.seq(cljs.core.cons(k,ks));
var chunk__47889_48297 = null;
var count__47890_48298 = (0);
var i__47891_48299 = (0);
while(true){
if((i__47891_48299 < count__47890_48298)){
var k_48300__$1 = chunk__47889_48297.cljs$core$IIndexed$_nth$arity$2(null,i__47891_48299);
dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k_48300__$1);


var G__48301 = seq__47888_48296;
var G__48302 = chunk__47889_48297;
var G__48303 = count__47890_48298;
var G__48304 = (i__47891_48299 + (1));
seq__47888_48296 = G__48301;
chunk__47889_48297 = G__48302;
count__47890_48298 = G__48303;
i__47891_48299 = G__48304;
continue;
} else {
var temp__5735__auto___48305 = cljs.core.seq(seq__47888_48296);
if(temp__5735__auto___48305){
var seq__47888_48306__$1 = temp__5735__auto___48305;
if(cljs.core.chunked_seq_QMARK_(seq__47888_48306__$1)){
var c__4609__auto___48307 = cljs.core.chunk_first(seq__47888_48306__$1);
var G__48308 = cljs.core.chunk_rest(seq__47888_48306__$1);
var G__48309 = c__4609__auto___48307;
var G__48310 = cljs.core.count(c__4609__auto___48307);
var G__48311 = (0);
seq__47888_48296 = G__48308;
chunk__47889_48297 = G__48309;
count__47890_48298 = G__48310;
i__47891_48299 = G__48311;
continue;
} else {
var k_48312__$1 = cljs.core.first(seq__47888_48306__$1);
dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k_48312__$1);


var G__48313 = cljs.core.next(seq__47888_48306__$1);
var G__48314 = null;
var G__48315 = (0);
var G__48316 = (0);
seq__47888_48296 = G__48313;
chunk__47889_48297 = G__48314;
count__47890_48298 = G__48315;
i__47891_48299 = G__48316;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.remove_attr_BANG_.cljs$lang$applyTo = (function (seq47883){
var G__47884 = cljs.core.first(seq47883);
var seq47883__$1 = cljs.core.next(seq47883);
var G__47885 = cljs.core.first(seq47883__$1);
var seq47883__$2 = cljs.core.next(seq47883__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47884,G__47885,seq47883__$2);
}));

(dommy.core.remove_attr_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Toggles a dom attribute `k` on `elem`, optionally specifying
 * the boolean value with `add?`
 */
dommy.core.toggle_attr_BANG_ = (function dommy$core$toggle_attr_BANG_(var_args){
var G__47893 = arguments.length;
switch (G__47893) {
case 2:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,cljs.core.boolean$(dommy.core.attr(elem,k)));
}));

(dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
if(add_QMARK_){
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k);
} else {
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k);
}
}));

(dommy.core.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Add `classes` to `elem`, trying to use Element::classList, and
 * falling back to fast string parsing/manipulation
 */
dommy.core.add_class_BANG_ = (function dommy$core$add_class_BANG_(var_args){
var G__47898 = arguments.length;
switch (G__47898) {
case 2:
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___48319 = arguments.length;
var i__4790__auto___48320 = (0);
while(true){
if((i__4790__auto___48320 < len__4789__auto___48319)){
args_arr__4810__auto__.push((arguments[i__4790__auto___48320]));

var G__48321 = (i__4790__auto___48320 + (1));
i__4790__auto___48320 = G__48321;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var classes__$1 = clojure.string.trim(dommy.utils.as_str(classes)).split(/\s+/);
if(cljs.core.seq(classes__$1)){
var temp__5733__auto___48322 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___48322)){
var class_list_48323 = temp__5733__auto___48322;
var seq__47899_48324 = cljs.core.seq(classes__$1);
var chunk__47900_48325 = null;
var count__47901_48326 = (0);
var i__47902_48327 = (0);
while(true){
if((i__47902_48327 < count__47901_48326)){
var c_48328 = chunk__47900_48325.cljs$core$IIndexed$_nth$arity$2(null,i__47902_48327);
class_list_48323.add(c_48328);


var G__48329 = seq__47899_48324;
var G__48330 = chunk__47900_48325;
var G__48331 = count__47901_48326;
var G__48332 = (i__47902_48327 + (1));
seq__47899_48324 = G__48329;
chunk__47900_48325 = G__48330;
count__47901_48326 = G__48331;
i__47902_48327 = G__48332;
continue;
} else {
var temp__5735__auto___48333 = cljs.core.seq(seq__47899_48324);
if(temp__5735__auto___48333){
var seq__47899_48334__$1 = temp__5735__auto___48333;
if(cljs.core.chunked_seq_QMARK_(seq__47899_48334__$1)){
var c__4609__auto___48335 = cljs.core.chunk_first(seq__47899_48334__$1);
var G__48336 = cljs.core.chunk_rest(seq__47899_48334__$1);
var G__48337 = c__4609__auto___48335;
var G__48338 = cljs.core.count(c__4609__auto___48335);
var G__48339 = (0);
seq__47899_48324 = G__48336;
chunk__47900_48325 = G__48337;
count__47901_48326 = G__48338;
i__47902_48327 = G__48339;
continue;
} else {
var c_48340 = cljs.core.first(seq__47899_48334__$1);
class_list_48323.add(c_48340);


var G__48341 = cljs.core.next(seq__47899_48334__$1);
var G__48342 = null;
var G__48343 = (0);
var G__48344 = (0);
seq__47899_48324 = G__48341;
chunk__47900_48325 = G__48342;
count__47901_48326 = G__48343;
i__47902_48327 = G__48344;
continue;
}
} else {
}
}
break;
}
} else {
var seq__47903_48345 = cljs.core.seq(classes__$1);
var chunk__47904_48346 = null;
var count__47905_48347 = (0);
var i__47906_48348 = (0);
while(true){
if((i__47906_48348 < count__47905_48347)){
var c_48349 = chunk__47904_48346.cljs$core$IIndexed$_nth$arity$2(null,i__47906_48348);
var class_name_48350 = dommy.core.class$(elem);
if(cljs.core.truth_(dommy.utils.class_index(class_name_48350,c_48349))){
} else {
dommy.core.set_class_BANG_(elem,(((class_name_48350 === ""))?c_48349:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_48350)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_48349)].join('')));
}


var G__48351 = seq__47903_48345;
var G__48352 = chunk__47904_48346;
var G__48353 = count__47905_48347;
var G__48354 = (i__47906_48348 + (1));
seq__47903_48345 = G__48351;
chunk__47904_48346 = G__48352;
count__47905_48347 = G__48353;
i__47906_48348 = G__48354;
continue;
} else {
var temp__5735__auto___48355 = cljs.core.seq(seq__47903_48345);
if(temp__5735__auto___48355){
var seq__47903_48356__$1 = temp__5735__auto___48355;
if(cljs.core.chunked_seq_QMARK_(seq__47903_48356__$1)){
var c__4609__auto___48357 = cljs.core.chunk_first(seq__47903_48356__$1);
var G__48358 = cljs.core.chunk_rest(seq__47903_48356__$1);
var G__48359 = c__4609__auto___48357;
var G__48360 = cljs.core.count(c__4609__auto___48357);
var G__48361 = (0);
seq__47903_48345 = G__48358;
chunk__47904_48346 = G__48359;
count__47905_48347 = G__48360;
i__47906_48348 = G__48361;
continue;
} else {
var c_48362 = cljs.core.first(seq__47903_48356__$1);
var class_name_48363 = dommy.core.class$(elem);
if(cljs.core.truth_(dommy.utils.class_index(class_name_48363,c_48362))){
} else {
dommy.core.set_class_BANG_(elem,(((class_name_48363 === ""))?c_48362:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_48363)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_48362)].join('')));
}


var G__48364 = cljs.core.next(seq__47903_48356__$1);
var G__48365 = null;
var G__48366 = (0);
var G__48367 = (0);
seq__47903_48345 = G__48364;
chunk__47904_48346 = G__48365;
count__47905_48347 = G__48366;
i__47906_48348 = G__48367;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem;
}));

(dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var seq__47907_48368 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(more_classes,classes));
var chunk__47908_48369 = null;
var count__47909_48370 = (0);
var i__47910_48371 = (0);
while(true){
if((i__47910_48371 < count__47909_48370)){
var c_48372 = chunk__47908_48369.cljs$core$IIndexed$_nth$arity$2(null,i__47910_48371);
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c_48372);


var G__48373 = seq__47907_48368;
var G__48374 = chunk__47908_48369;
var G__48375 = count__47909_48370;
var G__48376 = (i__47910_48371 + (1));
seq__47907_48368 = G__48373;
chunk__47908_48369 = G__48374;
count__47909_48370 = G__48375;
i__47910_48371 = G__48376;
continue;
} else {
var temp__5735__auto___48377 = cljs.core.seq(seq__47907_48368);
if(temp__5735__auto___48377){
var seq__47907_48378__$1 = temp__5735__auto___48377;
if(cljs.core.chunked_seq_QMARK_(seq__47907_48378__$1)){
var c__4609__auto___48379 = cljs.core.chunk_first(seq__47907_48378__$1);
var G__48380 = cljs.core.chunk_rest(seq__47907_48378__$1);
var G__48381 = c__4609__auto___48379;
var G__48382 = cljs.core.count(c__4609__auto___48379);
var G__48383 = (0);
seq__47907_48368 = G__48380;
chunk__47908_48369 = G__48381;
count__47909_48370 = G__48382;
i__47910_48371 = G__48383;
continue;
} else {
var c_48384 = cljs.core.first(seq__47907_48378__$1);
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c_48384);


var G__48385 = cljs.core.next(seq__47907_48378__$1);
var G__48386 = null;
var G__48387 = (0);
var G__48388 = (0);
seq__47907_48368 = G__48385;
chunk__47908_48369 = G__48386;
count__47909_48370 = G__48387;
i__47910_48371 = G__48388;
continue;
}
} else {
}
}
break;
}

return elem;
}));

/** @this {Function} */
(dommy.core.add_class_BANG_.cljs$lang$applyTo = (function (seq47895){
var G__47896 = cljs.core.first(seq47895);
var seq47895__$1 = cljs.core.next(seq47895);
var G__47897 = cljs.core.first(seq47895__$1);
var seq47895__$2 = cljs.core.next(seq47895__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47896,G__47897,seq47895__$2);
}));

(dommy.core.add_class_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Remove `c` from `elem` class list
 */
dommy.core.remove_class_BANG_ = (function dommy$core$remove_class_BANG_(var_args){
var G__47915 = arguments.length;
switch (G__47915) {
case 2:
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___48390 = arguments.length;
var i__4790__auto___48391 = (0);
while(true){
if((i__4790__auto___48391 < len__4789__auto___48390)){
args_arr__4810__auto__.push((arguments[i__4790__auto___48391]));

var G__48392 = (i__4790__auto___48391 + (1));
i__4790__auto___48391 = G__48392;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto___48393 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___48393)){
var class_list_48394 = temp__5733__auto___48393;
class_list_48394.remove(c__$1);
} else {
var class_name_48395 = dommy.core.class$(elem);
var new_class_name_48396 = dommy.utils.remove_class_str(class_name_48395,c__$1);
if((class_name_48395 === new_class_name_48396)){
} else {
dommy.core.set_class_BANG_(elem,new_class_name_48396);
}
}

return elem;
}));

(dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var seq__47916 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(classes,class$));
var chunk__47917 = null;
var count__47918 = (0);
var i__47919 = (0);
while(true){
if((i__47919 < count__47918)){
var c = chunk__47917.cljs$core$IIndexed$_nth$arity$2(null,i__47919);
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c);


var G__48398 = seq__47916;
var G__48399 = chunk__47917;
var G__48400 = count__47918;
var G__48401 = (i__47919 + (1));
seq__47916 = G__48398;
chunk__47917 = G__48399;
count__47918 = G__48400;
i__47919 = G__48401;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__47916);
if(temp__5735__auto__){
var seq__47916__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47916__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__47916__$1);
var G__48403 = cljs.core.chunk_rest(seq__47916__$1);
var G__48404 = c__4609__auto__;
var G__48405 = cljs.core.count(c__4609__auto__);
var G__48406 = (0);
seq__47916 = G__48403;
chunk__47917 = G__48404;
count__47918 = G__48405;
i__47919 = G__48406;
continue;
} else {
var c = cljs.core.first(seq__47916__$1);
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c);


var G__48407 = cljs.core.next(seq__47916__$1);
var G__48408 = null;
var G__48409 = (0);
var G__48410 = (0);
seq__47916 = G__48407;
chunk__47917 = G__48408;
count__47918 = G__48409;
i__47919 = G__48410;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(dommy.core.remove_class_BANG_.cljs$lang$applyTo = (function (seq47912){
var G__47913 = cljs.core.first(seq47912);
var seq47912__$1 = cljs.core.next(seq47912);
var G__47914 = cljs.core.first(seq47912__$1);
var seq47912__$2 = cljs.core.next(seq47912__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47913,G__47914,seq47912__$2);
}));

(dommy.core.remove_class_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.core.toggle_class_BANG_ = (function dommy$core$toggle_class_BANG_(var_args){
var G__47921 = arguments.length;
switch (G__47921) {
case 2:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__5733__auto___48418 = elem.classList;
if(cljs.core.truth_(temp__5733__auto___48418)){
var class_list_48419 = temp__5733__auto___48418;
class_list_48419.toggle(c__$1);
} else {
dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3(elem,c__$1,(!(dommy.core.has_class_QMARK_(elem,c__$1))));
}

return elem;
}));

(dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
if(add_QMARK_){
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,class$);
} else {
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,class$);
}

return elem;
}));

(dommy.core.toggle_class_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Display or hide the given `elem` (using display: none).
 * Takes an optional boolean `show?`
 */
dommy.core.toggle_BANG_ = (function dommy$core$toggle_BANG_(var_args){
var G__47923 = arguments.length;
switch (G__47923) {
case 2:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"display","display",242065432),((show_QMARK_)?"":"none")], 0));
}));

(dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,dommy.core.hidden_QMARK_(elem));
}));

(dommy.core.toggle_BANG_.cljs$lang$maxFixedArity = 2);

dommy.core.hide_BANG_ = (function dommy$core$hide_BANG_(elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,false);
});
dommy.core.show_BANG_ = (function dommy$core$show_BANG_(elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,true);
});
dommy.core.scroll_into_view = (function dommy$core$scroll_into_view(elem,align_with_top_QMARK_){
var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.core.bounding_client_rect(elem));
if((window.innerHeight < (top + elem.offsetHeight))){
return elem.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
dommy.core.create_element = (function dommy$core$create_element(var_args){
var G__47925 = arguments.length;
switch (G__47925) {
case 1:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.create_element.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return document.createElement(dommy.utils.as_str(tag));
}));

(dommy.core.create_element.cljs$core$IFn$_invoke$arity$2 = (function (tag_ns,tag){
return document.createElementNS(dommy.utils.as_str(tag_ns),dommy.utils.as_str(tag));
}));

(dommy.core.create_element.cljs$lang$maxFixedArity = 2);

dommy.core.create_text_node = (function dommy$core$create_text_node(text){
return document.createTextNode(text);
});
/**
 * Clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.core.set_html_BANG_(elem,"");
});
/**
 * Append `child` to `parent`
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(var_args){
var G__47930 = arguments.length;
switch (G__47930) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___48431 = arguments.length;
var i__4790__auto___48432 = (0);
while(true){
if((i__4790__auto___48432 < len__4789__auto___48431)){
args_arr__4810__auto__.push((arguments[i__4790__auto___48432]));

var G__48433 = (i__4790__auto___48432 + (1));
i__4790__auto___48432 = G__48433;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__47931 = parent;
G__47931.appendChild(child);

return G__47931;
}));

(dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__47932_48434 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__47933_48435 = null;
var count__47934_48436 = (0);
var i__47935_48437 = (0);
while(true){
if((i__47935_48437 < count__47934_48436)){
var c_48438 = chunk__47933_48435.cljs$core$IIndexed$_nth$arity$2(null,i__47935_48437);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_48438);


var G__48439 = seq__47932_48434;
var G__48440 = chunk__47933_48435;
var G__48441 = count__47934_48436;
var G__48442 = (i__47935_48437 + (1));
seq__47932_48434 = G__48439;
chunk__47933_48435 = G__48440;
count__47934_48436 = G__48441;
i__47935_48437 = G__48442;
continue;
} else {
var temp__5735__auto___48443 = cljs.core.seq(seq__47932_48434);
if(temp__5735__auto___48443){
var seq__47932_48444__$1 = temp__5735__auto___48443;
if(cljs.core.chunked_seq_QMARK_(seq__47932_48444__$1)){
var c__4609__auto___48445 = cljs.core.chunk_first(seq__47932_48444__$1);
var G__48446 = cljs.core.chunk_rest(seq__47932_48444__$1);
var G__48447 = c__4609__auto___48445;
var G__48448 = cljs.core.count(c__4609__auto___48445);
var G__48449 = (0);
seq__47932_48434 = G__48446;
chunk__47933_48435 = G__48447;
count__47934_48436 = G__48448;
i__47935_48437 = G__48449;
continue;
} else {
var c_48450 = cljs.core.first(seq__47932_48444__$1);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_48450);


var G__48451 = cljs.core.next(seq__47932_48444__$1);
var G__48452 = null;
var G__48453 = (0);
var G__48454 = (0);
seq__47932_48434 = G__48451;
chunk__47933_48435 = G__48452;
count__47934_48436 = G__48453;
i__47935_48437 = G__48454;
continue;
}
} else {
}
}
break;
}

return parent;
}));

/** @this {Function} */
(dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq47927){
var G__47928 = cljs.core.first(seq47927);
var seq47927__$1 = cljs.core.next(seq47927);
var G__47929 = cljs.core.first(seq47927__$1);
var seq47927__$2 = cljs.core.next(seq47927__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47928,G__47929,seq47927__$2);
}));

(dommy.core.append_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Prepend `child` to `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(var_args){
var G__47940 = arguments.length;
switch (G__47940) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___48456 = arguments.length;
var i__4790__auto___48457 = (0);
while(true){
if((i__4790__auto___48457 < len__4789__auto___48456)){
args_arr__4810__auto__.push((arguments[i__4790__auto___48457]));

var G__48458 = (i__4790__auto___48457 + (1));
i__4790__auto___48457 = G__48458;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((2)),(0),null));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4811__auto__);

}
});

(dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__47941 = parent;
G__47941.insertBefore(child,parent.firstChild);

return G__47941;
}));

(dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__47942_48459 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__47943_48460 = null;
var count__47944_48461 = (0);
var i__47945_48462 = (0);
while(true){
if((i__47945_48462 < count__47944_48461)){
var c_48463 = chunk__47943_48460.cljs$core$IIndexed$_nth$arity$2(null,i__47945_48462);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_48463);


var G__48464 = seq__47942_48459;
var G__48465 = chunk__47943_48460;
var G__48466 = count__47944_48461;
var G__48467 = (i__47945_48462 + (1));
seq__47942_48459 = G__48464;
chunk__47943_48460 = G__48465;
count__47944_48461 = G__48466;
i__47945_48462 = G__48467;
continue;
} else {
var temp__5735__auto___48468 = cljs.core.seq(seq__47942_48459);
if(temp__5735__auto___48468){
var seq__47942_48469__$1 = temp__5735__auto___48468;
if(cljs.core.chunked_seq_QMARK_(seq__47942_48469__$1)){
var c__4609__auto___48470 = cljs.core.chunk_first(seq__47942_48469__$1);
var G__48471 = cljs.core.chunk_rest(seq__47942_48469__$1);
var G__48472 = c__4609__auto___48470;
var G__48473 = cljs.core.count(c__4609__auto___48470);
var G__48474 = (0);
seq__47942_48459 = G__48471;
chunk__47943_48460 = G__48472;
count__47944_48461 = G__48473;
i__47945_48462 = G__48474;
continue;
} else {
var c_48475 = cljs.core.first(seq__47942_48469__$1);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_48475);


var G__48476 = cljs.core.next(seq__47942_48469__$1);
var G__48477 = null;
var G__48478 = (0);
var G__48479 = (0);
seq__47942_48459 = G__48476;
chunk__47943_48460 = G__48477;
count__47944_48461 = G__48478;
i__47945_48462 = G__48479;
continue;
}
} else {
}
}
break;
}

return parent;
}));

/** @this {Function} */
(dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq47937){
var G__47938 = cljs.core.first(seq47937);
var seq47937__$1 = cljs.core.next(seq47937);
var G__47939 = cljs.core.first(seq47937__$1);
var seq47937__$2 = cljs.core.next(seq47937__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47938,G__47939,seq47937__$2);
}));

(dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Insert `elem` before `other`, `other` must have a parent
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var p = dommy.core.parent(other);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

p.insertBefore(elem,other);

return elem;
});
/**
 * Insert `elem` after `other`, `other` must have a parent
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var temp__5733__auto___48480 = other.nextSibling;
if(cljs.core.truth_(temp__5733__auto___48480)){
var next_48481 = temp__5733__auto___48480;
dommy.core.insert_before_BANG_(elem,next_48481);
} else {
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(dommy.core.parent(other),elem);
}

return elem;
});
/**
 * Replace `elem` with `new`, return `new`
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var p = dommy.core.parent(elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

p.replaceChild(new$,elem);

return new$;
});
/**
 * Replace children of `elem` with `child`
 */
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(p,child){
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(dommy.core.clear_BANG_(p),child);
});
/**
 * Remove `elem` from `parent`, return `parent`
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(var_args){
var G__47947 = arguments.length;
switch (G__47947) {
case 1:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var p = dommy.core.parent(elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2(p,elem);
}));

(dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (p,elem){
var G__47948 = p;
G__47948.removeChild(elem);

return G__47948;
}));

(dommy.core.remove_BANG_.cljs$lang$maxFixedArity = 2);

dommy.core.special_listener_makers = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__47949){
var vec__47950 = p__47949;
var special_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47950,(0),null);
var real_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47950,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,cljs.core.PersistentArrayMap.createAsIfByAssoc([real_mouse_event,(function (f){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__4185__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__4174__auto__ = related_target;
if(cljs.core.truth_(and__4174__auto__)){
return dommy.core.descendant_QMARK_(related_target,listener_target);
} else {
return and__4174__auto__;
}
})())){
return null;
} else {
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(event) : f.call(null,event));
}
});
})])], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.cljs$core$IFn$_invoke$arity$3(elem,event.target,selector);
if(cljs.core.truth_((function (){var and__4174__auto__ = selected_target;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.not(dommy.core.attr(selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else {
return and__4174__auto__;
}
})())){
(event.selectedTarget = selected_target);

return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(event) : f.call(null,event));
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `elem`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__4185__auto__ = elem.dommyEventListeners;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___48483 = arguments.length;
var i__4790__auto___48484 = (0);
while(true){
if((i__4790__auto___48484 < len__4789__auto___48483)){
args__4795__auto__.push((arguments[i__4790__auto___48484]));

var G__48485 = (i__4790__auto___48484 + (1));
i__4790__auto___48484 = G__48485;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = elem;
return (elem__$1.dommyEventListeners = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,dommy.core.event_listeners(elem__$1),args));
}));

(dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq47953){
var G__47954 = cljs.core.first(seq47953);
var seq47953__$1 = cljs.core.next(seq47953);
var G__47955 = cljs.core.first(seq47953__$1);
var seq47953__$2 = cljs.core.next(seq47953__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47954,G__47955,seq47953__$2);
}));

dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_(elem_sel)){
var fexpr__47956 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.rest);
return (fexpr__47956.cljs$core$IFn$_invoke$arity$1 ? fexpr__47956.cljs$core$IFn$_invoke$arity$1(elem_sel) : fexpr__47956.call(null,elem_sel));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elem_sel,null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 *     (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 *     (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 *     (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___48486 = arguments.length;
var i__4790__auto___48487 = (0);
while(true){
if((i__4790__auto___48487 < len__4789__auto___48486)){
args__4795__auto__.push((arguments[i__4790__auto___48487]));

var G__48488 = (i__4790__auto___48487 + (1));
i__4790__auto___48487 = G__48488;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__47959_48489 = dommy.core.elem_and_selector(elem_sel);
var elem_48490 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47959_48489,(0),null);
var selector_48491 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47959_48489,(1),null);
var seq__47962_48492 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__47969_48493 = null;
var count__47970_48494 = (0);
var i__47971_48495 = (0);
while(true){
if((i__47971_48495 < count__47970_48494)){
var vec__48024_48496 = chunk__47969_48493.cljs$core$IIndexed$_nth$arity$2(null,i__47971_48495);
var orig_type_48497 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48024_48496,(0),null);
var f_48498 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48024_48496,(1),null);
var seq__47972_48499 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_48497,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_48497,cljs.core.identity])));
var chunk__47974_48500 = null;
var count__47975_48501 = (0);
var i__47976_48502 = (0);
while(true){
if((i__47976_48502 < count__47975_48501)){
var vec__48037_48503 = chunk__47974_48500.cljs$core$IIndexed$_nth$arity$2(null,i__47976_48502);
var actual_type_48504 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48037_48503,(0),null);
var factory_48505 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48037_48503,(1),null);
var canonical_f_48506 = (function (){var G__48041 = (factory_48505.cljs$core$IFn$_invoke$arity$1 ? factory_48505.cljs$core$IFn$_invoke$arity$1(f_48498) : factory_48505.call(null,f_48498));
var fexpr__48040 = (cljs.core.truth_(selector_48491)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_48490,selector_48491):cljs.core.identity);
return (fexpr__48040.cljs$core$IFn$_invoke$arity$1 ? fexpr__48040.cljs$core$IFn$_invoke$arity$1(G__48041) : fexpr__48040.call(null,G__48041));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_48490,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_48491,actual_type_48504,f_48498], null),canonical_f_48506], 0));

if(cljs.core.truth_(elem_48490.addEventListener)){
elem_48490.addEventListener(cljs.core.name(actual_type_48504),canonical_f_48506);
} else {
elem_48490.attachEvent(cljs.core.name(actual_type_48504),canonical_f_48506);
}


var G__48507 = seq__47972_48499;
var G__48508 = chunk__47974_48500;
var G__48509 = count__47975_48501;
var G__48510 = (i__47976_48502 + (1));
seq__47972_48499 = G__48507;
chunk__47974_48500 = G__48508;
count__47975_48501 = G__48509;
i__47976_48502 = G__48510;
continue;
} else {
var temp__5735__auto___48511 = cljs.core.seq(seq__47972_48499);
if(temp__5735__auto___48511){
var seq__47972_48512__$1 = temp__5735__auto___48511;
if(cljs.core.chunked_seq_QMARK_(seq__47972_48512__$1)){
var c__4609__auto___48513 = cljs.core.chunk_first(seq__47972_48512__$1);
var G__48514 = cljs.core.chunk_rest(seq__47972_48512__$1);
var G__48515 = c__4609__auto___48513;
var G__48516 = cljs.core.count(c__4609__auto___48513);
var G__48517 = (0);
seq__47972_48499 = G__48514;
chunk__47974_48500 = G__48515;
count__47975_48501 = G__48516;
i__47976_48502 = G__48517;
continue;
} else {
var vec__48042_48518 = cljs.core.first(seq__47972_48512__$1);
var actual_type_48519 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48042_48518,(0),null);
var factory_48520 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48042_48518,(1),null);
var canonical_f_48521 = (function (){var G__48046 = (factory_48520.cljs$core$IFn$_invoke$arity$1 ? factory_48520.cljs$core$IFn$_invoke$arity$1(f_48498) : factory_48520.call(null,f_48498));
var fexpr__48045 = (cljs.core.truth_(selector_48491)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_48490,selector_48491):cljs.core.identity);
return (fexpr__48045.cljs$core$IFn$_invoke$arity$1 ? fexpr__48045.cljs$core$IFn$_invoke$arity$1(G__48046) : fexpr__48045.call(null,G__48046));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_48490,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_48491,actual_type_48519,f_48498], null),canonical_f_48521], 0));

if(cljs.core.truth_(elem_48490.addEventListener)){
elem_48490.addEventListener(cljs.core.name(actual_type_48519),canonical_f_48521);
} else {
elem_48490.attachEvent(cljs.core.name(actual_type_48519),canonical_f_48521);
}


var G__48522 = cljs.core.next(seq__47972_48512__$1);
var G__48523 = null;
var G__48524 = (0);
var G__48525 = (0);
seq__47972_48499 = G__48522;
chunk__47974_48500 = G__48523;
count__47975_48501 = G__48524;
i__47976_48502 = G__48525;
continue;
}
} else {
}
}
break;
}

var G__48526 = seq__47962_48492;
var G__48527 = chunk__47969_48493;
var G__48528 = count__47970_48494;
var G__48529 = (i__47971_48495 + (1));
seq__47962_48492 = G__48526;
chunk__47969_48493 = G__48527;
count__47970_48494 = G__48528;
i__47971_48495 = G__48529;
continue;
} else {
var temp__5735__auto___48530 = cljs.core.seq(seq__47962_48492);
if(temp__5735__auto___48530){
var seq__47962_48531__$1 = temp__5735__auto___48530;
if(cljs.core.chunked_seq_QMARK_(seq__47962_48531__$1)){
var c__4609__auto___48532 = cljs.core.chunk_first(seq__47962_48531__$1);
var G__48533 = cljs.core.chunk_rest(seq__47962_48531__$1);
var G__48534 = c__4609__auto___48532;
var G__48535 = cljs.core.count(c__4609__auto___48532);
var G__48536 = (0);
seq__47962_48492 = G__48533;
chunk__47969_48493 = G__48534;
count__47970_48494 = G__48535;
i__47971_48495 = G__48536;
continue;
} else {
var vec__48047_48537 = cljs.core.first(seq__47962_48531__$1);
var orig_type_48538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48047_48537,(0),null);
var f_48539 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48047_48537,(1),null);
var seq__47963_48540 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_48538,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_48538,cljs.core.identity])));
var chunk__47965_48541 = null;
var count__47966_48542 = (0);
var i__47967_48543 = (0);
while(true){
if((i__47967_48543 < count__47966_48542)){
var vec__48060_48544 = chunk__47965_48541.cljs$core$IIndexed$_nth$arity$2(null,i__47967_48543);
var actual_type_48545 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48060_48544,(0),null);
var factory_48546 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48060_48544,(1),null);
var canonical_f_48547 = (function (){var G__48064 = (factory_48546.cljs$core$IFn$_invoke$arity$1 ? factory_48546.cljs$core$IFn$_invoke$arity$1(f_48539) : factory_48546.call(null,f_48539));
var fexpr__48063 = (cljs.core.truth_(selector_48491)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_48490,selector_48491):cljs.core.identity);
return (fexpr__48063.cljs$core$IFn$_invoke$arity$1 ? fexpr__48063.cljs$core$IFn$_invoke$arity$1(G__48064) : fexpr__48063.call(null,G__48064));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_48490,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_48491,actual_type_48545,f_48539], null),canonical_f_48547], 0));

if(cljs.core.truth_(elem_48490.addEventListener)){
elem_48490.addEventListener(cljs.core.name(actual_type_48545),canonical_f_48547);
} else {
elem_48490.attachEvent(cljs.core.name(actual_type_48545),canonical_f_48547);
}


var G__48548 = seq__47963_48540;
var G__48549 = chunk__47965_48541;
var G__48550 = count__47966_48542;
var G__48551 = (i__47967_48543 + (1));
seq__47963_48540 = G__48548;
chunk__47965_48541 = G__48549;
count__47966_48542 = G__48550;
i__47967_48543 = G__48551;
continue;
} else {
var temp__5735__auto___48552__$1 = cljs.core.seq(seq__47963_48540);
if(temp__5735__auto___48552__$1){
var seq__47963_48553__$1 = temp__5735__auto___48552__$1;
if(cljs.core.chunked_seq_QMARK_(seq__47963_48553__$1)){
var c__4609__auto___48554 = cljs.core.chunk_first(seq__47963_48553__$1);
var G__48555 = cljs.core.chunk_rest(seq__47963_48553__$1);
var G__48556 = c__4609__auto___48554;
var G__48557 = cljs.core.count(c__4609__auto___48554);
var G__48558 = (0);
seq__47963_48540 = G__48555;
chunk__47965_48541 = G__48556;
count__47966_48542 = G__48557;
i__47967_48543 = G__48558;
continue;
} else {
var vec__48065_48559 = cljs.core.first(seq__47963_48553__$1);
var actual_type_48560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48065_48559,(0),null);
var factory_48561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48065_48559,(1),null);
var canonical_f_48562 = (function (){var G__48069 = (factory_48561.cljs$core$IFn$_invoke$arity$1 ? factory_48561.cljs$core$IFn$_invoke$arity$1(f_48539) : factory_48561.call(null,f_48539));
var fexpr__48068 = (cljs.core.truth_(selector_48491)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_48490,selector_48491):cljs.core.identity);
return (fexpr__48068.cljs$core$IFn$_invoke$arity$1 ? fexpr__48068.cljs$core$IFn$_invoke$arity$1(G__48069) : fexpr__48068.call(null,G__48069));
})();
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_48490,cljs.core.assoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_48491,actual_type_48560,f_48539], null),canonical_f_48562], 0));

if(cljs.core.truth_(elem_48490.addEventListener)){
elem_48490.addEventListener(cljs.core.name(actual_type_48560),canonical_f_48562);
} else {
elem_48490.attachEvent(cljs.core.name(actual_type_48560),canonical_f_48562);
}


var G__48563 = cljs.core.next(seq__47963_48553__$1);
var G__48564 = null;
var G__48565 = (0);
var G__48566 = (0);
seq__47963_48540 = G__48563;
chunk__47965_48541 = G__48564;
count__47966_48542 = G__48565;
i__47967_48543 = G__48566;
continue;
}
} else {
}
}
break;
}

var G__48567 = cljs.core.next(seq__47962_48531__$1);
var G__48568 = null;
var G__48569 = (0);
var G__48570 = (0);
seq__47962_48492 = G__48567;
chunk__47969_48493 = G__48568;
count__47970_48494 = G__48569;
i__47971_48495 = G__48570;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq47957){
var G__47958 = cljs.core.first(seq47957);
var seq47957__$1 = cljs.core.next(seq47957);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47958,seq47957__$1);
}));

/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 *   The following forms are allowed, and will remove all handlers
 *   that match the parameters passed in:
 * 
 *    (unlisten! [elem :.selector] :click event-listener)
 * 
 *    (unlisten! [elem :.selector]
 *      :click event-listener
 *      :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___48571 = arguments.length;
var i__4790__auto___48572 = (0);
while(true){
if((i__4790__auto___48572 < len__4789__auto___48571)){
args__4795__auto__.push((arguments[i__4790__auto___48572]));

var G__48573 = (i__4790__auto___48572 + (1));
i__4790__auto___48572 = G__48573;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__48072_48574 = dommy.core.elem_and_selector(elem_sel);
var elem_48575 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48072_48574,(0),null);
var selector_48576 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48072_48574,(1),null);
var seq__48075_48577 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__48082_48578 = null;
var count__48083_48579 = (0);
var i__48084_48580 = (0);
while(true){
if((i__48084_48580 < count__48083_48579)){
var vec__48121_48581 = chunk__48082_48578.cljs$core$IIndexed$_nth$arity$2(null,i__48084_48580);
var orig_type_48582 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48121_48581,(0),null);
var f_48583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48121_48581,(1),null);
var seq__48085_48584 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_48582,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_48582,cljs.core.identity])));
var chunk__48087_48585 = null;
var count__48088_48586 = (0);
var i__48089_48587 = (0);
while(true){
if((i__48089_48587 < count__48088_48586)){
var vec__48130_48588 = chunk__48087_48585.cljs$core$IIndexed$_nth$arity$2(null,i__48089_48587);
var actual_type_48589 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48130_48588,(0),null);
var __48590 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48130_48588,(1),null);
var keys_48591 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_48576,actual_type_48589,f_48583], null);
var canonical_f_48592 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_48575),keys_48591);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_48575,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_48591], 0));

if(cljs.core.truth_(elem_48575.removeEventListener)){
elem_48575.removeEventListener(cljs.core.name(actual_type_48589),canonical_f_48592);
} else {
elem_48575.detachEvent(cljs.core.name(actual_type_48589),canonical_f_48592);
}


var G__48593 = seq__48085_48584;
var G__48594 = chunk__48087_48585;
var G__48595 = count__48088_48586;
var G__48596 = (i__48089_48587 + (1));
seq__48085_48584 = G__48593;
chunk__48087_48585 = G__48594;
count__48088_48586 = G__48595;
i__48089_48587 = G__48596;
continue;
} else {
var temp__5735__auto___48597 = cljs.core.seq(seq__48085_48584);
if(temp__5735__auto___48597){
var seq__48085_48598__$1 = temp__5735__auto___48597;
if(cljs.core.chunked_seq_QMARK_(seq__48085_48598__$1)){
var c__4609__auto___48599 = cljs.core.chunk_first(seq__48085_48598__$1);
var G__48600 = cljs.core.chunk_rest(seq__48085_48598__$1);
var G__48601 = c__4609__auto___48599;
var G__48602 = cljs.core.count(c__4609__auto___48599);
var G__48603 = (0);
seq__48085_48584 = G__48600;
chunk__48087_48585 = G__48601;
count__48088_48586 = G__48602;
i__48089_48587 = G__48603;
continue;
} else {
var vec__48133_48604 = cljs.core.first(seq__48085_48598__$1);
var actual_type_48605 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48133_48604,(0),null);
var __48606 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48133_48604,(1),null);
var keys_48607 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_48576,actual_type_48605,f_48583], null);
var canonical_f_48608 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_48575),keys_48607);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_48575,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_48607], 0));

if(cljs.core.truth_(elem_48575.removeEventListener)){
elem_48575.removeEventListener(cljs.core.name(actual_type_48605),canonical_f_48608);
} else {
elem_48575.detachEvent(cljs.core.name(actual_type_48605),canonical_f_48608);
}


var G__48609 = cljs.core.next(seq__48085_48598__$1);
var G__48610 = null;
var G__48611 = (0);
var G__48612 = (0);
seq__48085_48584 = G__48609;
chunk__48087_48585 = G__48610;
count__48088_48586 = G__48611;
i__48089_48587 = G__48612;
continue;
}
} else {
}
}
break;
}

var G__48613 = seq__48075_48577;
var G__48614 = chunk__48082_48578;
var G__48615 = count__48083_48579;
var G__48616 = (i__48084_48580 + (1));
seq__48075_48577 = G__48613;
chunk__48082_48578 = G__48614;
count__48083_48579 = G__48615;
i__48084_48580 = G__48616;
continue;
} else {
var temp__5735__auto___48617 = cljs.core.seq(seq__48075_48577);
if(temp__5735__auto___48617){
var seq__48075_48618__$1 = temp__5735__auto___48617;
if(cljs.core.chunked_seq_QMARK_(seq__48075_48618__$1)){
var c__4609__auto___48619 = cljs.core.chunk_first(seq__48075_48618__$1);
var G__48620 = cljs.core.chunk_rest(seq__48075_48618__$1);
var G__48621 = c__4609__auto___48619;
var G__48622 = cljs.core.count(c__4609__auto___48619);
var G__48623 = (0);
seq__48075_48577 = G__48620;
chunk__48082_48578 = G__48621;
count__48083_48579 = G__48622;
i__48084_48580 = G__48623;
continue;
} else {
var vec__48136_48624 = cljs.core.first(seq__48075_48618__$1);
var orig_type_48625 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48136_48624,(0),null);
var f_48626 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48136_48624,(1),null);
var seq__48076_48627 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_48625,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_48625,cljs.core.identity])));
var chunk__48078_48628 = null;
var count__48079_48629 = (0);
var i__48080_48630 = (0);
while(true){
if((i__48080_48630 < count__48079_48629)){
var vec__48145_48631 = chunk__48078_48628.cljs$core$IIndexed$_nth$arity$2(null,i__48080_48630);
var actual_type_48632 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48145_48631,(0),null);
var __48633 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48145_48631,(1),null);
var keys_48634 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_48576,actual_type_48632,f_48626], null);
var canonical_f_48635 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_48575),keys_48634);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_48575,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_48634], 0));

if(cljs.core.truth_(elem_48575.removeEventListener)){
elem_48575.removeEventListener(cljs.core.name(actual_type_48632),canonical_f_48635);
} else {
elem_48575.detachEvent(cljs.core.name(actual_type_48632),canonical_f_48635);
}


var G__48636 = seq__48076_48627;
var G__48637 = chunk__48078_48628;
var G__48638 = count__48079_48629;
var G__48639 = (i__48080_48630 + (1));
seq__48076_48627 = G__48636;
chunk__48078_48628 = G__48637;
count__48079_48629 = G__48638;
i__48080_48630 = G__48639;
continue;
} else {
var temp__5735__auto___48640__$1 = cljs.core.seq(seq__48076_48627);
if(temp__5735__auto___48640__$1){
var seq__48076_48641__$1 = temp__5735__auto___48640__$1;
if(cljs.core.chunked_seq_QMARK_(seq__48076_48641__$1)){
var c__4609__auto___48642 = cljs.core.chunk_first(seq__48076_48641__$1);
var G__48643 = cljs.core.chunk_rest(seq__48076_48641__$1);
var G__48644 = c__4609__auto___48642;
var G__48645 = cljs.core.count(c__4609__auto___48642);
var G__48646 = (0);
seq__48076_48627 = G__48643;
chunk__48078_48628 = G__48644;
count__48079_48629 = G__48645;
i__48080_48630 = G__48646;
continue;
} else {
var vec__48148_48647 = cljs.core.first(seq__48076_48641__$1);
var actual_type_48648 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48148_48647,(0),null);
var __48649 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48148_48647,(1),null);
var keys_48650 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_48576,actual_type_48648,f_48626], null);
var canonical_f_48651 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_48575),keys_48650);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_48575,dommy.utils.dissoc_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([keys_48650], 0));

if(cljs.core.truth_(elem_48575.removeEventListener)){
elem_48575.removeEventListener(cljs.core.name(actual_type_48648),canonical_f_48651);
} else {
elem_48575.detachEvent(cljs.core.name(actual_type_48648),canonical_f_48651);
}


var G__48652 = cljs.core.next(seq__48076_48641__$1);
var G__48653 = null;
var G__48654 = (0);
var G__48655 = (0);
seq__48076_48627 = G__48652;
chunk__48078_48628 = G__48653;
count__48079_48629 = G__48654;
i__48080_48630 = G__48655;
continue;
}
} else {
}
}
break;
}

var G__48656 = cljs.core.next(seq__48075_48618__$1);
var G__48657 = null;
var G__48658 = (0);
var G__48659 = (0);
seq__48075_48577 = G__48656;
chunk__48082_48578 = G__48657;
count__48083_48579 = G__48658;
i__48084_48580 = G__48659;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq48070){
var G__48071 = cljs.core.first(seq48070);
var seq48070__$1 = cljs.core.next(seq48070);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__48071,seq48070__$1);
}));

/**
 * Behaves like `listen!`, but removes the listener after the first event occurs.
 */
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___48660 = arguments.length;
var i__4790__auto___48661 = (0);
while(true){
if((i__4790__auto___48661 < len__4789__auto___48660)){
args__4795__auto__.push((arguments[i__4790__auto___48661]));

var G__48662 = (i__4790__auto___48661 + (1));
i__4790__auto___48661 = G__48662;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__48153_48663 = dommy.core.elem_and_selector(elem_sel);
var elem_48664 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48153_48663,(0),null);
var selector_48665 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48153_48663,(1),null);
var seq__48156_48666 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__48157_48667 = null;
var count__48158_48668 = (0);
var i__48159_48669 = (0);
while(true){
if((i__48159_48669 < count__48158_48668)){
var vec__48166_48670 = chunk__48157_48667.cljs$core$IIndexed$_nth$arity$2(null,i__48159_48669);
var type_48671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48166_48670,(0),null);
var f_48672 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48166_48670,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_48671,((function (seq__48156_48666,chunk__48157_48667,count__48158_48668,i__48159_48669,vec__48166_48670,type_48671,f_48672,vec__48153_48663,elem_48664,selector_48665){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_48671,dommy$core$this_fn], 0));

return (f_48672.cljs$core$IFn$_invoke$arity$1 ? f_48672.cljs$core$IFn$_invoke$arity$1(e) : f_48672.call(null,e));
});})(seq__48156_48666,chunk__48157_48667,count__48158_48668,i__48159_48669,vec__48166_48670,type_48671,f_48672,vec__48153_48663,elem_48664,selector_48665))
], 0));


var G__48673 = seq__48156_48666;
var G__48674 = chunk__48157_48667;
var G__48675 = count__48158_48668;
var G__48676 = (i__48159_48669 + (1));
seq__48156_48666 = G__48673;
chunk__48157_48667 = G__48674;
count__48158_48668 = G__48675;
i__48159_48669 = G__48676;
continue;
} else {
var temp__5735__auto___48677 = cljs.core.seq(seq__48156_48666);
if(temp__5735__auto___48677){
var seq__48156_48678__$1 = temp__5735__auto___48677;
if(cljs.core.chunked_seq_QMARK_(seq__48156_48678__$1)){
var c__4609__auto___48679 = cljs.core.chunk_first(seq__48156_48678__$1);
var G__48680 = cljs.core.chunk_rest(seq__48156_48678__$1);
var G__48681 = c__4609__auto___48679;
var G__48682 = cljs.core.count(c__4609__auto___48679);
var G__48683 = (0);
seq__48156_48666 = G__48680;
chunk__48157_48667 = G__48681;
count__48158_48668 = G__48682;
i__48159_48669 = G__48683;
continue;
} else {
var vec__48169_48684 = cljs.core.first(seq__48156_48678__$1);
var type_48685 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48169_48684,(0),null);
var f_48686 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48169_48684,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_48685,((function (seq__48156_48666,chunk__48157_48667,count__48158_48668,i__48159_48669,vec__48169_48684,type_48685,f_48686,seq__48156_48678__$1,temp__5735__auto___48677,vec__48153_48663,elem_48664,selector_48665){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type_48685,dommy$core$this_fn], 0));

return (f_48686.cljs$core$IFn$_invoke$arity$1 ? f_48686.cljs$core$IFn$_invoke$arity$1(e) : f_48686.call(null,e));
});})(seq__48156_48666,chunk__48157_48667,count__48158_48668,i__48159_48669,vec__48169_48684,type_48685,f_48686,seq__48156_48678__$1,temp__5735__auto___48677,vec__48153_48663,elem_48664,selector_48665))
], 0));


var G__48687 = cljs.core.next(seq__48156_48678__$1);
var G__48688 = null;
var G__48689 = (0);
var G__48690 = (0);
seq__48156_48666 = G__48687;
chunk__48157_48667 = G__48688;
count__48158_48668 = G__48689;
i__48159_48669 = G__48690;
continue;
}
} else {
}
}
break;
}

return elem_sel;
}));

(dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq48151){
var G__48152 = cljs.core.first(seq48151);
var seq48151__$1 = cljs.core.next(seq48151);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__48152,seq48151__$1);
}));


//# sourceMappingURL=dommy.core.js.map
