goog.provide('pinkgorilla.kernel.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('clojure.string');
goog.require('cljs.analyzer');
goog.require('cljs.js');
goog.require('pinkgorilla.kernel.repl_resources');
if(typeof window !== "undefined") {window.cljs.user = {}};
if((typeof pinkgorilla !== 'undefined') && (typeof pinkgorilla.kernel !== 'undefined') && (typeof pinkgorilla.kernel.repl !== 'undefined') && (typeof pinkgorilla.kernel.repl.current_ns_eval !== 'undefined')){
} else {
pinkgorilla.kernel.repl.current_ns_eval = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.user","cljs.user",877795071,null));
}
if((typeof pinkgorilla !== 'undefined') && (typeof pinkgorilla.kernel !== 'undefined') && (typeof pinkgorilla.kernel.repl !== 'undefined') && (typeof pinkgorilla.kernel.repl.current_ns_compile !== 'undefined')){
} else {
pinkgorilla.kernel.repl.current_ns_compile = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.user","cljs.user",877795071,null));
}
pinkgorilla.kernel.repl.reset_ns_eval_BANG_ = (function pinkgorilla$kernel$repl$reset_ns_eval_BANG_(){
return cljs.core.reset_BANG_(pinkgorilla.kernel.repl.current_ns_eval,new cljs.core.Symbol(null,"cljs.user","cljs.user",877795071,null));
});
pinkgorilla.kernel.repl.reset_ns_compile_BANG_ = (function pinkgorilla$kernel$repl$reset_ns_compile_BANG_(){
return cljs.core.reset_BANG_(pinkgorilla.kernel.repl.current_ns_compile,new cljs.core.Symbol(null,"cljs.user","cljs.user",877795071,null));
});
if((typeof pinkgorilla !== 'undefined') && (typeof pinkgorilla.kernel !== 'undefined') && (typeof pinkgorilla.kernel.repl !== 'undefined') && (typeof pinkgorilla.kernel.repl.st !== 'undefined')){
} else {
pinkgorilla.kernel.repl.st = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
}
pinkgorilla.kernel.repl.reset_state_eval_BANG_ = (function pinkgorilla$kernel$repl$reset_state_eval_BANG_(){
return cljs.core.reset_BANG_(pinkgorilla.kernel.repl.st,null);
});
pinkgorilla.kernel.repl.st_compile = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
pinkgorilla.kernel.repl.create_state_compile = (function pinkgorilla$kernel$repl$create_state_compile(){
if((cljs.core.deref(pinkgorilla.kernel.repl.st_compile) == null)){
cljs.core.reset_BANG_(pinkgorilla.kernel.repl.st_compile,cljs.js.empty_state.cljs$core$IFn$_invoke$arity$0());
} else {
}

return cljs.core.deref(pinkgorilla.kernel.repl.st_compile);
});
pinkgorilla.kernel.repl.reset_state_compile_BANG_ = (function pinkgorilla$kernel$repl$reset_state_compile_BANG_(){
return cljs.core.reset_BANG_(pinkgorilla.kernel.repl.st_compile,null);
});
pinkgorilla.kernel.repl.add_macros_suffix = (function pinkgorilla$kernel$repl$add_macros_suffix(sym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.name(sym),"$macros"].join(''));
});
pinkgorilla.kernel.repl.eval_form = (function pinkgorilla$kernel$repl$eval_form(var_args){
var G__43223 = arguments.length;
switch (G__43223) {
case 1:
return pinkgorilla.kernel.repl.eval_form.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return pinkgorilla.kernel.repl.eval_form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(pinkgorilla.kernel.repl.eval_form.cljs$core$IFn$_invoke$arity$1 = (function (form){
return pinkgorilla.kernel.repl.eval_form.cljs$core$IFn$_invoke$arity$1(cljs.core._STAR_ns_STAR_.name);
}));

(pinkgorilla.kernel.repl.eval_form.cljs$core$IFn$_invoke$arity$2 = (function (form,ns){
var result = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
cljs.js.eval.cljs$core$IFn$_invoke$arity$4(cljs.core.deref(pinkgorilla.kernel.repl.st),form,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"ns","ns",441598760),ns,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"eval","eval",-1103567905),cljs.js.js_eval,new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320),true], null),(function (p__43224){
var map__43225 = p__43224;
var map__43225__$1 = (((((!((map__43225 == null))))?(((((map__43225.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43225.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43225):map__43225);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43225__$1,new cljs.core.Keyword(null,"value","value",305978217));
var error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43225__$1,new cljs.core.Keyword(null,"error","error",-978969032));
if(cljs.core.truth_(error)){
return error;
} else {
return cljs.core.reset_BANG_(result,value);
}
}));

return cljs.core.deref(result);
}));

(pinkgorilla.kernel.repl.eval_form.cljs$lang$maxFixedArity = 2);

pinkgorilla.kernel.repl.def_a_var = (function pinkgorilla$kernel$repl$def_a_var(var_args){
var G__43228 = arguments.length;
switch (G__43228) {
case 2:
return pinkgorilla.kernel.repl.def_a_var.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pinkgorilla.kernel.repl.def_a_var.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(pinkgorilla.kernel.repl.def_a_var.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var temp__5735__auto__ = cljs.core.find_ns((function (){var G__43230 = ns;
if((ns instanceof cljs.core.Namespace)){
return cljs.core.ns_name(G__43230);
} else {
return G__43230;
}
})());
if(cljs.core.truth_(temp__5735__auto__)){
var the_ns = temp__5735__auto__;
return pinkgorilla.kernel.repl.eval_form.cljs$core$IFn$_invoke$arity$2(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol(null,"def","def",597100991,null),null,(1),null)),(new cljs.core.List(null,name,null,(1),null))))),cljs.core.ns_name(the_ns));
} else {
return null;
}
}));

(pinkgorilla.kernel.repl.def_a_var.cljs$core$IFn$_invoke$arity$3 = (function (ns,name,val){
var temp__5735__auto__ = cljs.core.find_ns((function (){var G__43231 = ns;
if((ns instanceof cljs.core.Namespace)){
return cljs.core.ns_name(G__43231);
} else {
return G__43231;
}
})());
if(cljs.core.truth_(temp__5735__auto__)){
var the_ns = temp__5735__auto__;
return pinkgorilla.kernel.repl.eval_form.cljs$core$IFn$_invoke$arity$2(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"def","def",597100991,null),null,(1),null)),(new cljs.core.List(null,name,null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,val,null,(1),null))], 0)))),cljs.core.ns_name(the_ns));
} else {
return null;
}
}));

(pinkgorilla.kernel.repl.def_a_var.cljs$lang$maxFixedArity = 3);

/**
 * Given an analysis environment resolve a var. Analogous to
 * clojure.core/resolve
 */
pinkgorilla.kernel.repl.resolve_var = (function pinkgorilla$kernel$repl$resolve_var(env,sym){
if(cljs.core.map_QMARK_(env)){
} else {
throw (new Error("Assert failed: (map? env)"));
}

if((sym instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? sym)"));
}

try{return cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$3(env,sym,cljs.analyzer.confirm_var_exists_throw());
}catch (e43232){var _ = e43232;
return cljs.analyzer.resolve_macro_var(env,sym);
}});
pinkgorilla.kernel.repl.print_value = (function pinkgorilla$kernel$repl$print_value(value,opts){
return cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value], 0));
});
pinkgorilla.kernel.repl.str_butlast = (function pinkgorilla$kernel$repl$str_butlast(s){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),(cljs.core.count(s) - (1)));
});
pinkgorilla.kernel.repl.format_spec = (function pinkgorilla$kernel$repl$format_spec(spec,left_margin,ns){
var raw_print = (function (){var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__43233_43383 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__43234_43384 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__43235_43385 = true;
var _STAR_print_fn_STAR__temp_val__43236_43386 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__43235_43385);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__43236_43386);

try{pinkgorilla.kernel.repl.print_value(cljs.spec.alpha.describe(spec),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("pinkgorilla.kernel.repl","keyword-ns","pinkgorilla.kernel.repl/keyword-ns",-1746496143),ns,new cljs.core.Keyword("pinkgorilla.kernel.repl","spec?","pinkgorilla.kernel.repl/spec?",1676414599),true,new cljs.core.Keyword("pinkgorilla.kernel.repl","as-code?","pinkgorilla.kernel.repl/as-code?",-1413441658),true,new cljs.core.Keyword("pinkgorilla.kernel.repl","term-width-adj","pinkgorilla.kernel.repl/term-width-adj",-1445508667),(- left_margin)], null));
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__43234_43384);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__43233_43383);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
})();
return clojure.string.replace(pinkgorilla.kernel.repl.str_butlast(raw_print),/\n/,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.str,"\n",cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(left_margin," ")));
});
pinkgorilla.kernel.repl.drop_macros_suffix = (function pinkgorilla$kernel$repl$drop_macros_suffix(ns_name){
if(clojure.string.ends_with_QMARK_(ns_name,"$macros")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((7),ns_name));
} else {
return ns_name;
}
});
/**
 * Undoes the effect that wrapping a reader conditional around a defn has on a
 *   docstring.
 */
pinkgorilla.kernel.repl.undo_reader_conditional_whitespace_docstring = (function pinkgorilla$kernel$repl$undo_reader_conditional_whitespace_docstring(s){
if((s == null)){
return null;
} else {
if(cljs.core.truth_(cljs.core.re_find(/[^\n]*\n\n?      ?\S.*/,s))){
return clojure.string.replace(s,/\n      ?/,"\n  ");
} else {
return s;
}
}
});
pinkgorilla.kernel.repl.print_doc = (function pinkgorilla$kernel$repl$print_doc(p__43238){
var map__43239 = p__43238;
var map__43239__$1 = (((((!((map__43239 == null))))?(((((map__43239.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43239.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43239):map__43239);
var m = map__43239__$1;
var n = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43239__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43239__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-------------------------"], 0));

var temp__5733__auto___43387 = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5733__auto___43387)){
var spec_43388 = temp__5733__auto___43387;
pinkgorilla.kernel.repl.print_value(spec_43388,cljs.core.PersistentArrayMap.EMPTY);
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([[(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('')], 0));
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Protocol"], 0));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__43241_43389 = cljs.core.seq(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__43242_43390 = null;
var count__43243_43391 = (0);
var i__43244_43392 = (0);
while(true){
if((i__43244_43392 < count__43243_43391)){
var f_43393 = chunk__43242_43390.cljs$core$IIndexed$_nth$arity$2(null,i__43244_43392);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  ",f_43393], 0));


var G__43394 = seq__43241_43389;
var G__43395 = chunk__43242_43390;
var G__43396 = count__43243_43391;
var G__43397 = (i__43244_43392 + (1));
seq__43241_43389 = G__43394;
chunk__43242_43390 = G__43395;
count__43243_43391 = G__43396;
i__43244_43392 = G__43397;
continue;
} else {
var temp__5735__auto___43398 = cljs.core.seq(seq__43241_43389);
if(temp__5735__auto___43398){
var seq__43241_43399__$1 = temp__5735__auto___43398;
if(cljs.core.chunked_seq_QMARK_(seq__43241_43399__$1)){
var c__4609__auto___43400 = cljs.core.chunk_first(seq__43241_43399__$1);
var G__43401 = cljs.core.chunk_rest(seq__43241_43399__$1);
var G__43402 = c__4609__auto___43400;
var G__43403 = cljs.core.count(c__4609__auto___43400);
var G__43404 = (0);
seq__43241_43389 = G__43401;
chunk__43242_43390 = G__43402;
count__43243_43391 = G__43403;
i__43244_43392 = G__43404;
continue;
} else {
var f_43405 = cljs.core.first(seq__43241_43399__$1);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  ",f_43405], 0));


var G__43406 = cljs.core.next(seq__43241_43399__$1);
var G__43407 = null;
var G__43408 = (0);
var G__43409 = (0);
seq__43241_43389 = G__43406;
chunk__43242_43390 = G__43407;
count__43243_43391 = G__43408;
i__43244_43392 = G__43409;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_43411 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arglists_43411], 0));
} else {
cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first(arglists_43411)))?cljs.core.second(arglists_43411):arglists_43411)], 0));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Special Form"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m)], 0));

if(cljs.core.contains_QMARK_(m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join('')], 0));
} else {
return null;
}
} else {
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('')], 0));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Macro"], 0));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Spec"], 0));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["REPL Special Function"], 0));
} else {
}

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m)], 0));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__43246_43412 = cljs.core.seq(new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__43247_43413 = null;
var count__43248_43414 = (0);
var i__43249_43415 = (0);
while(true){
if((i__43249_43415 < count__43248_43414)){
var vec__43260_43416 = chunk__43247_43413.cljs$core$IIndexed$_nth$arity$2(null,i__43249_43415);
var name_43417 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43260_43416,(0),null);
var map__43263_43418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43260_43416,(1),null);
var map__43263_43419__$1 = (((((!((map__43263_43418 == null))))?(((((map__43263_43418.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43263_43418.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43263_43418):map__43263_43418);
var doc_43420 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43263_43419__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_43421 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43263_43419__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",name_43417], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",arglists_43421], 0));

if(cljs.core.truth_(doc_43420)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",doc_43420], 0));
} else {
}


var G__43422 = seq__43246_43412;
var G__43423 = chunk__43247_43413;
var G__43424 = count__43248_43414;
var G__43425 = (i__43249_43415 + (1));
seq__43246_43412 = G__43422;
chunk__43247_43413 = G__43423;
count__43248_43414 = G__43424;
i__43249_43415 = G__43425;
continue;
} else {
var temp__5735__auto___43426 = cljs.core.seq(seq__43246_43412);
if(temp__5735__auto___43426){
var seq__43246_43427__$1 = temp__5735__auto___43426;
if(cljs.core.chunked_seq_QMARK_(seq__43246_43427__$1)){
var c__4609__auto___43428 = cljs.core.chunk_first(seq__43246_43427__$1);
var G__43429 = cljs.core.chunk_rest(seq__43246_43427__$1);
var G__43430 = c__4609__auto___43428;
var G__43431 = cljs.core.count(c__4609__auto___43428);
var G__43432 = (0);
seq__43246_43412 = G__43429;
chunk__43247_43413 = G__43430;
count__43248_43414 = G__43431;
i__43249_43415 = G__43432;
continue;
} else {
var vec__43266_43433 = cljs.core.first(seq__43246_43427__$1);
var name_43434 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43266_43433,(0),null);
var map__43269_43435 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43266_43433,(1),null);
var map__43269_43436__$1 = (((((!((map__43269_43435 == null))))?(((((map__43269_43435.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43269_43435.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43269_43435):map__43269_43435);
var doc_43437 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43269_43436__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_43438 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43269_43436__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",name_43434], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",arglists_43438], 0));

if(cljs.core.truth_(doc_43437)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",doc_43437], 0));
} else {
}


var G__43439 = cljs.core.next(seq__43246_43427__$1);
var G__43440 = null;
var G__43441 = (0);
var G__43442 = (0);
seq__43246_43412 = G__43439;
chunk__43247_43413 = G__43440;
count__43248_43414 = G__43441;
i__43249_43415 = G__43442;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var spec_lookup = (function (ns_suffix){
return cljs.spec.alpha.get_spec(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name(n)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns_suffix)].join(''),cljs.core.name(nm)));
});
var temp__5735__auto__ = (function (){var or__4185__auto__ = spec_lookup("");
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return spec_lookup("$macros");
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var fnspec = temp__5735__auto__;
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Spec"], 0));

var seq__43271_43443 = cljs.core.seq(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__43272_43444 = null;
var count__43273_43445 = (0);
var i__43274_43446 = (0);
while(true){
if((i__43274_43446 < count__43273_43445)){
var role_43447 = chunk__43272_43444.cljs$core$IIndexed$_nth$arity$2(null,i__43274_43446);
var temp__5735__auto___43448__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fnspec,role_43447);
if(cljs.core.truth_(temp__5735__auto___43448__$1)){
var spec_43449 = temp__5735__auto___43448__$1;
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n ",cljs.core.name(role_43447),":"].join(''),pinkgorilla.kernel.repl.format_spec(spec_43449,((3) + ((cljs.core.name(role_43447)).length)),n)], 0));
} else {
}


var G__43450 = seq__43271_43443;
var G__43451 = chunk__43272_43444;
var G__43452 = count__43273_43445;
var G__43453 = (i__43274_43446 + (1));
seq__43271_43443 = G__43450;
chunk__43272_43444 = G__43451;
count__43273_43445 = G__43452;
i__43274_43446 = G__43453;
continue;
} else {
var temp__5735__auto___43454__$1 = cljs.core.seq(seq__43271_43443);
if(temp__5735__auto___43454__$1){
var seq__43271_43455__$1 = temp__5735__auto___43454__$1;
if(cljs.core.chunked_seq_QMARK_(seq__43271_43455__$1)){
var c__4609__auto___43456 = cljs.core.chunk_first(seq__43271_43455__$1);
var G__43457 = cljs.core.chunk_rest(seq__43271_43455__$1);
var G__43458 = c__4609__auto___43456;
var G__43459 = cljs.core.count(c__4609__auto___43456);
var G__43460 = (0);
seq__43271_43443 = G__43457;
chunk__43272_43444 = G__43458;
count__43273_43445 = G__43459;
i__43274_43446 = G__43460;
continue;
} else {
var role_43461 = cljs.core.first(seq__43271_43455__$1);
var temp__5735__auto___43462__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fnspec,role_43461);
if(cljs.core.truth_(temp__5735__auto___43462__$2)){
var spec_43463 = temp__5735__auto___43462__$2;
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n ",cljs.core.name(role_43461),":"].join(''),pinkgorilla.kernel.repl.format_spec(spec_43463,((3) + ((cljs.core.name(role_43461)).length)),n)], 0));
} else {
}


var G__43464 = cljs.core.next(seq__43271_43455__$1);
var G__43465 = null;
var G__43466 = (0);
var G__43467 = (0);
seq__43271_43443 = G__43464;
chunk__43272_43444 = G__43465;
count__43273_43445 = G__43466;
i__43274_43446 = G__43467;
continue;
}
} else {
}
}
break;
}

return cljs.core.println();
} else {
return null;
}
} else {
return null;
}
}
});
pinkgorilla.kernel.repl.special_doc = (function pinkgorilla$kernel$repl$special_doc(name_symbol){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((pinkgorilla.kernel.repl_resources.special_doc_map.cljs$core$IFn$_invoke$arity$1 ? pinkgorilla.kernel.repl_resources.special_doc_map.cljs$core$IFn$_invoke$arity$1(name_symbol) : pinkgorilla.kernel.repl_resources.special_doc_map.call(null,name_symbol)),new cljs.core.Keyword(null,"name","name",1843675177),name_symbol,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"special-form","special-form",-1326536374),true], 0));
});
pinkgorilla.kernel.repl.repl_special_doc = (function pinkgorilla$kernel$repl$repl_special_doc(name_symbol){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((pinkgorilla.kernel.repl_resources.repl_special_doc_map.cljs$core$IFn$_invoke$arity$1 ? pinkgorilla.kernel.repl_resources.repl_special_doc_map.cljs$core$IFn$_invoke$arity$1(name_symbol) : pinkgorilla.kernel.repl_resources.repl_special_doc_map.call(null,name_symbol)),new cljs.core.Keyword(null,"name","name",1843675177),name_symbol,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725),true], 0));
});
/**
 * Gets the AST for a given namespace.
 */
pinkgorilla.kernel.repl.get_namespace = (function pinkgorilla$kernel$repl$get_namespace(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.deref(pinkgorilla.kernel.repl.st)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),ns], null));
});
pinkgorilla.kernel.repl.get_macro_var = (function pinkgorilla$kernel$repl$get_macro_var(env,sym,macros_ns){
if((macros_ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? macros-ns)"));
}

var temp__5735__auto__ = (function (){var env__38867__auto__ = cljs.core.deref(pinkgorilla.kernel.repl.st);
var env__38867__auto____$1 = ((cljs.core.map_QMARK_(env__38867__auto__))?cljs.core.atom.cljs$core$IFn$_invoke$arity$1(env__38867__auto__):(((((env__38867__auto__ instanceof cljs.core.Atom)) && (cljs.core.map_QMARK_(cljs.core.deref(env__38867__auto__)))))?env__38867__auto__:(function(){throw (new Error(["Compiler environment must be a map or atom containing a map, not ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(env__38867__auto__))].join('')))})()
));
var _STAR_compiler_STAR__orig_val__43275 = cljs.env._STAR_compiler_STAR_;
var _STAR_compiler_STAR__temp_val__43276 = env__38867__auto____$1;
(cljs.env._STAR_compiler_STAR_ = _STAR_compiler_STAR__temp_val__43276);

try{return pinkgorilla.kernel.repl.resolve_var(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(macros_ns,cljs.core.name(sym)));
}finally {(cljs.env._STAR_compiler_STAR_ = _STAR_compiler_STAR__orig_val__43275);
}})();
if(cljs.core.truth_(temp__5735__auto__)){
var macro_var = temp__5735__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(macro_var,new cljs.core.Keyword(null,"ns","ns",441598760),macros_ns);
} else {
return null;
}
});
pinkgorilla.kernel.repl.get_aenv = (function pinkgorilla$kernel$repl$get_aenv(){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(cljs.analyzer.empty_env(),new cljs.core.Keyword(null,"ns","ns",441598760),pinkgorilla.kernel.repl.get_namespace(cljs.core.deref(pinkgorilla.kernel.repl.current_ns_eval)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291)], 0));
});
pinkgorilla.kernel.repl.get_var = (function pinkgorilla$kernel$repl$get_var(env,sym){
var _STAR_cljs_warning_handlers_STAR__orig_val__43278 = cljs.analyzer._STAR_cljs_warning_handlers_STAR_;
var _STAR_cljs_warning_handlers_STAR__temp_val__43279 = null;
(cljs.analyzer._STAR_cljs_warning_handlers_STAR_ = _STAR_cljs_warning_handlers_STAR__temp_val__43279);

try{var var$ = (function (){var or__4185__auto__ = (function (){var env__38867__auto__ = cljs.core.deref(pinkgorilla.kernel.repl.st);
var env__38867__auto____$1 = ((cljs.core.map_QMARK_(env__38867__auto__))?cljs.core.atom.cljs$core$IFn$_invoke$arity$1(env__38867__auto__):(((((env__38867__auto__ instanceof cljs.core.Atom)) && (cljs.core.map_QMARK_(cljs.core.deref(env__38867__auto__)))))?env__38867__auto__:(function(){throw (new Error(["Compiler environment must be a map or atom containing a map, not ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(env__38867__auto__))].join('')))})()
));
var _STAR_compiler_STAR__orig_val__43283 = cljs.env._STAR_compiler_STAR_;
var _STAR_compiler_STAR__temp_val__43284 = env__38867__auto____$1;
(cljs.env._STAR_compiler_STAR_ = _STAR_compiler_STAR__temp_val__43284);

try{return pinkgorilla.kernel.repl.resolve_var(env,sym);
}finally {(cljs.env._STAR_compiler_STAR_ = _STAR_compiler_STAR__orig_val__43283);
}})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var temp__5735__auto__ = (function (){var G__43285 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.deref(pinkgorilla.kernel.repl.st)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),cljs.core.deref(pinkgorilla.kernel.repl.current_ns_eval),new cljs.core.Keyword(null,"use-macros","use-macros",-905638393)], null));
return (sym.cljs$core$IFn$_invoke$arity$1 ? sym.cljs$core$IFn$_invoke$arity$1(G__43285) : sym.call(null,G__43285));
})();
if(cljs.core.truth_(temp__5735__auto__)){
var macros_ns = temp__5735__auto__;
return pinkgorilla.kernel.repl.get_macro_var(env,sym,macros_ns);
} else {
return null;
}
}
})();
if(cljs.core.truth_(var$)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((function (){var G__43286 = var$;
var G__43286__$1 = ((cljs.core.not(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(var$)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__43286,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.namespace(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(var$)))):G__43286);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(var$)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(var$)))){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(G__43286__$1,new cljs.core.Keyword(null,"name","name",1843675177),(function (p1__43277_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.name(p1__43277_SHARP_));
}));
} else {
return G__43286__$1;
}
})(),new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.comp.cljs$core$IFn$_invoke$arity$3(cljs.core.symbol,pinkgorilla.kernel.repl.drop_macros_suffix,cljs.core.str));
} else {
return null;
}
}finally {(cljs.analyzer._STAR_cljs_warning_handlers_STAR_ = _STAR_cljs_warning_handlers_STAR__orig_val__43278);
}});
pinkgorilla.kernel.repl.doc_STAR_ = (function pinkgorilla$kernel$repl$doc_STAR_(name){
var temp__5733__auto__ = (function (){var fexpr__43287 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"fn","fn",465265323,null),new cljs.core.Symbol(null,"catch","catch",-1616370245,null),new cljs.core.Symbol(null,"try","try",-1273693247,null),new cljs.core.Symbol(null,"finally","finally",-1065347064,null),new cljs.core.Symbol(null,"try","try",-1273693247,null)], null);
return (fexpr__43287.cljs$core$IFn$_invoke$arity$1 ? fexpr__43287.cljs$core$IFn$_invoke$arity$1(name) : fexpr__43287.call(null,name));
})();
if(cljs.core.truth_(temp__5733__auto__)){
var special_name = temp__5733__auto__;
return (pinkgorilla.kernel.repl.doc_STAR_.cljs$core$IFn$_invoke$arity$1 ? pinkgorilla.kernel.repl.doc_STAR_.cljs$core$IFn$_invoke$arity$1(special_name) : pinkgorilla.kernel.repl.doc_STAR_.call(null,special_name));
} else {
if(cljs.core.truth_((pinkgorilla.kernel.repl_resources.special_doc_map.cljs$core$IFn$_invoke$arity$1 ? pinkgorilla.kernel.repl_resources.special_doc_map.cljs$core$IFn$_invoke$arity$1(name) : pinkgorilla.kernel.repl_resources.special_doc_map.call(null,name)))){
return pinkgorilla.kernel.repl.print_doc(pinkgorilla.kernel.repl.special_doc(name));
} else {
if(cljs.core.truth_((pinkgorilla.kernel.repl_resources.repl_special_doc_map.cljs$core$IFn$_invoke$arity$1 ? pinkgorilla.kernel.repl_resources.repl_special_doc_map.cljs$core$IFn$_invoke$arity$1(name) : pinkgorilla.kernel.repl_resources.repl_special_doc_map.call(null,name)))){
return pinkgorilla.kernel.repl.print_doc(pinkgorilla.kernel.repl.repl_special_doc(name));
} else {
if(cljs.core.qualified_keyword_QMARK_(name)){
return pinkgorilla.kernel.repl.print_doc(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"spec","spec",347520401),name,new cljs.core.Keyword(null,"doc","doc",1913296891),pinkgorilla.kernel.repl.format_spec(cljs.spec.alpha.get_spec(name),(3),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.namespace(name)))], null));
} else {
if(cljs.core.truth_(pinkgorilla.kernel.repl.get_namespace(name))){
return pinkgorilla.kernel.repl.print_doc(cljs.core.select_keys(pinkgorilla.kernel.repl.get_namespace(name),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"doc","doc",1913296891)], null)));
} else {
if(cljs.core.truth_(pinkgorilla.kernel.repl.get_var(pinkgorilla.kernel.repl.get_aenv(),name))){
return pinkgorilla.kernel.repl.print_doc((function (){var var$ = pinkgorilla.kernel.repl.get_var(pinkgorilla.kernel.repl.get_aenv(),name);
var var$__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(var$,new cljs.core.Keyword(null,"forms","forms",2045992350),cljs.core.second(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(var$))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.second(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(var$)))], 0));
var m = cljs.core.select_keys(var$__$1,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forms","forms",2045992350),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"macro","macro",-867863404),new cljs.core.Keyword(null,"url","url",276297046)], null));
var m__$1 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.Keyword(null,"doc","doc",1913296891),pinkgorilla.kernel.repl.undo_reader_conditional_whitespace_docstring);
var G__43288 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"name","name",1843675177)], null),cljs.core.name);
if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198).cljs$core$IFn$_invoke$arity$1(var$__$1))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__43288,new cljs.core.Keyword(null,"protocol","protocol",652470118),true,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"methods","methods",453930866),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__43289){
var vec__43290 = p__43289;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43290,(0),null);
var sigs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43290,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fname,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(pinkgorilla.kernel.repl.get_var(pinkgorilla.kernel.repl.get_aenv(),cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(var$__$1)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fname)))),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.seq(sigs)], null)], null);
}),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(var$__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"methods","methods",453930866)], null))))], 0));
} else {
return G__43288;
}
})());
} else {
return null;
}
}
}
}
}
}
});
pinkgorilla.kernel.repl.completion_candidates_for_ns = (function pinkgorilla$kernel$repl$completion_candidates_for_ns(ns_sym,allow_private_QMARK_){
if(clojure.string.starts_with_QMARK_(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns_sym),"goog")){
if(cljs.core.truth_(cljs.core.find_ns(ns_sym))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.js_keys(goog.getObjectByName(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns_sym))));
} else {
return cljs.core.PersistentVector.EMPTY;
}
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.key),cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.filter.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(allow_private_QMARK_)?cljs.core.identity:(function (p1__43294_SHARP_){
return cljs.core.not(new cljs.core.Keyword(null,"private","private",-558947994).cljs$core$IFn$_invoke$arity$1(cljs.core.val(p1__43294_SHARP_)));
}))),cljs.core.remove.cljs$core$IFn$_invoke$arity$1((function (p1__43295_SHARP_){
return new cljs.core.Keyword(null,"anonymous","anonymous",447897231).cljs$core$IFn$_invoke$arity$1(cljs.core.val(p1__43295_SHARP_));
}))),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,(function (){var G__43297 = pinkgorilla.kernel.repl.get_namespace(ns_sym);
var fexpr__43296 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"defs","defs",1398449717),new cljs.core.Keyword(null,"macros","macros",811339431));
return (fexpr__43296.cljs$core$IFn$_invoke$arity$1 ? fexpr__43296.cljs$core$IFn$_invoke$arity$1(G__43297) : fexpr__43296.call(null,G__43297));
})())));
}
});
pinkgorilla.kernel.repl.completion_candidates_for_current_ns = (function pinkgorilla$kernel$repl$completion_candidates_for_current_ns(){
var cur_ns = cljs.core.deref(pinkgorilla.kernel.repl.current_ns_eval);
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.repl.completion_candidates_for_ns(cur_ns,true),cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1(cljs.core.keys),cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.str)),(function (){var G__43299 = pinkgorilla.kernel.repl.get_namespace(cur_ns);
var fexpr__43298 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"renames","renames",343278368),new cljs.core.Keyword(null,"rename-macros","rename-macros",1076432512),new cljs.core.Keyword(null,"uses","uses",232664692),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"use-macros","use-macros",-905638393)], 0));
return (fexpr__43298.cljs$core$IFn$_invoke$arity$1 ? fexpr__43298.cljs$core$IFn$_invoke$arity$1(G__43299) : fexpr__43298.call(null,G__43299));
})());
});
pinkgorilla.kernel.repl.is_completion_QMARK_ = (function pinkgorilla$kernel$repl$is_completion_QMARK_(match_suffix,candidate){
var escaped_suffix = clojure.string.replace(match_suffix,/[-\\/\\^$*+?.()|\[\]{}]/,"\\$&");
return cljs.core.re_find((new RegExp(["^",escaped_suffix].join(''),"i")),candidate);
});
pinkgorilla.kernel.repl.keyword_completions = new cljs.core.PersistentVector(null, 31, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"require","require",-468001333),new cljs.core.Keyword(null,"require-macros","require-macros",707947416),new cljs.core.Keyword(null,"import","import",-1399500709),new cljs.core.Keyword(null,"refer","refer",-964295553),new cljs.core.Keyword(null,"refer-macros","refer-macros",-1906841953),new cljs.core.Keyword(null,"include-macros","include-macros",1228110289),new cljs.core.Keyword(null,"refer-clojure","refer-clojure",813784440),new cljs.core.Keyword(null,"exclude","exclude",-1230250334),new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.Keyword(null,"strs","strs",1175537277),new cljs.core.Keyword(null,"syms","syms",-1575891762),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Keyword(null,"or","or",235744169),new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"let","let",-1282412701),new cljs.core.Keyword(null,"when","when",-576417306),new cljs.core.Keyword(null,"while","while",963117786),new cljs.core.Keyword(null,"clj","clj",-660495428),new cljs.core.Keyword(null,"cljs","cljs",1492417629),new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword(null,"else","else",-1508377146),new cljs.core.Keyword(null,"gen-class","gen-class",-426712454),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null);
pinkgorilla.kernel.repl.namespace_completion_exclusions = new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"planck.from.io.aviso.ansi","planck.from.io.aviso.ansi",2068713725,null),new cljs.core.Symbol(null,"planck.pprint.code","planck.pprint.code",1586576325,null),new cljs.core.Symbol(null,"planck.pprint.data","planck.pprint.data",804516122,null),new cljs.core.Symbol(null,"planck.bundle","planck.bundle",-403959080,null),new cljs.core.Symbol(null,"planck.closure","planck.closure",261112148,null),new cljs.core.Symbol(null,"planck.js-deps","planck.js-deps",791456760,null),new cljs.core.Symbol(null,"planck.repl","planck.repl",366873093,null),new cljs.core.Symbol(null,"planck.repl-resources","planck.repl-resources",143473453,null),new cljs.core.Symbol(null,"planck.themes","planck.themes",-2083267640,null),new cljs.core.Symbol(null,"clojure.core.rrb-vector","clojure.core.rrb-vector",-1155220319,null),new cljs.core.Symbol(null,"clojure.core.rrb-vector.interop","clojure.core.rrb-vector.interop",1752227054,null),new cljs.core.Symbol(null,"clojure.core.rrb-vector.nodes","clojure.core.rrb-vector.nodes",-1723556804,null),new cljs.core.Symbol(null,"clojure.core.rrb-vector.protocols","clojure.core.rrb-vector.protocols",1645101092,null),new cljs.core.Symbol(null,"clojure.core.rrb-vector.rrbt","clojure.core.rrb-vector.rrbt",1108920338,null),new cljs.core.Symbol(null,"clojure.core.rrb-vector.transients","clojure.core.rrb-vector.transients",1281641467,null),new cljs.core.Symbol(null,"clojure.core.rrb-vector.trees","clojure.core.rrb-vector.trees",1420144023,null),new cljs.core.Symbol(null,"cognitect.transit","cognitect.transit",-750660177,null),new cljs.core.Symbol(null,"fipp.deque","fipp.deque",162107275,null),new cljs.core.Symbol(null,"fipp.engine","fipp.engine",104802855,null),new cljs.core.Symbol(null,"fipp.visit","fipp.visit",-938866813,null),new cljs.core.Symbol(null,"lazy-map.core","lazy-map.core",462322712,null),new cljs.core.Symbol(null,"cljs.source-map","cljs.source-map",2108014936,null),new cljs.core.Symbol(null,"cljs.source-map.base64","cljs.source-map.base64",-1764326399,null),new cljs.core.Symbol(null,"cljs.source-map.base64-vlq","cljs.source-map.base64-vlq",-397707708,null),new cljs.core.Symbol(null,"cljs.tools.reader.impl.commons","cljs.tools.reader.impl.commons",1569241026,null),new cljs.core.Symbol(null,"cljs.tools.reader.impl.utils","cljs.tools.reader.impl.utils",1797659699,null),new cljs.core.Symbol(null,"cljs.stacktrace","cljs.stacktrace",880035689,null)], null);
pinkgorilla.kernel.repl.namespace_completion_additons = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"clojure.core","clojure.core",-189332625,null),new cljs.core.Symbol(null,"clojure.test","clojure.test",-699730006,null),new cljs.core.Symbol(null,"clojure.spec.alpha","clojure.spec.alpha",369813921,null),new cljs.core.Symbol(null,"clojure.spec.test.alpha","clojure.spec.test.alpha",-562225269,null),new cljs.core.Symbol(null,"clojure.spec.gen.alpha","clojure.spec.gen.alpha",231332697,null),new cljs.core.Symbol(null,"clojure.pprint","clojure.pprint",-547379114,null)], null);
/**
 * Returns a sequence of all namespaces.
 */
pinkgorilla.kernel.repl.all_ns = (function pinkgorilla$kernel$repl$all_ns(){
return cljs.core.keys(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.deref(pinkgorilla.kernel.repl.st))));
});
pinkgorilla.kernel.repl.current_alias_map = (function pinkgorilla$kernel$repl$current_alias_map(var_args){
var G__43301 = arguments.length;
switch (G__43301) {
case 0:
return pinkgorilla.kernel.repl.current_alias_map.cljs$core$IFn$_invoke$arity$0();

break;
case 2:
return pinkgorilla.kernel.repl.current_alias_map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(pinkgorilla.kernel.repl.current_alias_map.cljs$core$IFn$_invoke$arity$0 = (function (){
return pinkgorilla.kernel.repl.current_alias_map.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.kernel.repl.current_ns_eval),cljs.core.deref(pinkgorilla.kernel.repl.st));
}));

(pinkgorilla.kernel.repl.current_alias_map.cljs$core$IFn$_invoke$arity$2 = (function (ns,state){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p__43306){
var vec__43307 = p__43306;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43307,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43307,(1),null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,v);
}),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),ns,new cljs.core.Keyword(null,"requires","requires",-1201390927)], null)),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),ns,new cljs.core.Keyword(null,"require-macros","require-macros",707947416)], null))], 0))));
}));

(pinkgorilla.kernel.repl.current_alias_map.cljs$lang$maxFixedArity = 2);

pinkgorilla.kernel.repl.namespace_completions = (function pinkgorilla$kernel$repl$namespace_completions(){
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,pinkgorilla.kernel.repl.namespace_completion_additons),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,pinkgorilla.kernel.repl.namespace_completion_exclusions)),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__43310_SHARP_){
return pinkgorilla.kernel.repl.drop_macros_suffix(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__43310_SHARP_));
}),pinkgorilla.kernel.repl.all_ns())))));
});
/**
 * Expand the typed namespace symbol to a known namespace, consulting current
 *   namespace aliases if necessary.
 */
pinkgorilla.kernel.repl.expand_typed_ns = (function pinkgorilla$kernel$repl$expand_typed_ns(alias){
var alias__$1 = ((cljs.core.symbol_identical_QMARK_(alias,new cljs.core.Symbol(null,"clojure.core","clojure.core",-189332625,null)))?new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null):alias);
var or__4185__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(pinkgorilla.kernel.repl.st,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),alias__$1,new cljs.core.Keyword(null,"name","name",1843675177)], null));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = (function (){var G__43312 = pinkgorilla.kernel.repl.current_alias_map.cljs$core$IFn$_invoke$arity$0();
return (alias__$1.cljs$core$IFn$_invoke$arity$1 ? alias__$1.cljs$core$IFn$_invoke$arity$1(G__43312) : alias__$1.call(null,G__43312));
})();
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return alias__$1;
}
}
});
pinkgorilla.kernel.repl.completion_candidates = (function pinkgorilla$kernel$repl$completion_candidates(top_form_QMARK_,typed_ns){
return cljs.core.set((cljs.core.truth_(typed_ns)?(function (){var expanded_ns = pinkgorilla.kernel.repl.expand_typed_ns(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(typed_ns));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(pinkgorilla.kernel.repl.completion_candidates_for_ns(expanded_ns,false),pinkgorilla.kernel.repl.completion_candidates_for_ns(pinkgorilla.kernel.repl.add_macros_suffix(expanded_ns),false));
})():cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,pinkgorilla.kernel.repl.keyword_completions),pinkgorilla.kernel.repl.namespace_completions(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__43313_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__43313_SHARP_),"/"].join('');
}),cljs.core.keys(pinkgorilla.kernel.repl.current_alias_map.cljs$core$IFn$_invoke$arity$0())),pinkgorilla.kernel.repl.completion_candidates_for_ns(new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),false),pinkgorilla.kernel.repl.completion_candidates_for_ns(new cljs.core.Symbol(null,"cljs.core$macros","cljs.core$macros",-2057787548,null),false),pinkgorilla.kernel.repl.completion_candidates_for_current_ns(),(cljs.core.truth_(top_form_QMARK_)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.keys(pinkgorilla.kernel.repl_resources.special_doc_map)),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.keys(pinkgorilla.kernel.repl_resources.repl_special_doc_map))):null)], 0))));
});
pinkgorilla.kernel.repl.longest_common_prefix = (function pinkgorilla$kernel$repl$longest_common_prefix(strings){
var minl = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,strings));
var l = minl;
while(true){
if((l > (0))){
if(cljs.core.every_QMARK_(cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.first(strings),(0),l)]),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (l,minl){
return (function (p1__43314_SHARP_){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(p1__43314_SHARP_,(0),l);
});})(l,minl))
,cljs.core.rest(strings)))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.first(strings),(0),l);
} else {
var G__43478 = (l - (1));
l = G__43478;
continue;
}
} else {
return "";
}
break;
}
});
pinkgorilla.kernel.repl.spec_registered_keywords = (function pinkgorilla$kernel$repl$spec_registered_keywords(ns){
return cljs.core.eduction.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.keyword_QMARK_),cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (p1__43315_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),cljs.core.namespace(p1__43315_SHARP_));
})),cljs.core.keys(cljs.spec.alpha.registry())], 0));
});
pinkgorilla.kernel.repl.local_keyword_str = (function pinkgorilla$kernel$repl$local_keyword_str(kw){
return ["::",cljs.core.name(kw)].join('');
});
/**
 * Returns foo for ::foo, otherwise nil
 */
pinkgorilla.kernel.repl.local_keyword = (function pinkgorilla$kernel$repl$local_keyword(buffer){
return cljs.core.second(cljs.core.re_find(/::([a-zA-Z-]*)$/,buffer));
});
pinkgorilla.kernel.repl.local_keyword_completions = (function pinkgorilla$kernel$repl$local_keyword_completions(kw_name){
var kw_source = ["::",cljs.core.str.cljs$core$IFn$_invoke$arity$1(kw_name)].join('');
return cljs.core.clj__GT_js(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [kw_source], null),cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(pinkgorilla.kernel.repl.local_keyword_str),cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (p1__43325_SHARP_){
return clojure.string.starts_with_QMARK_(p1__43325_SHARP_,kw_source);
}))),pinkgorilla.kernel.repl.spec_registered_keywords(cljs.core.deref(pinkgorilla.kernel.repl.current_ns_eval)))));
});
/**
 * Returns an array of the buffer-match-suffix, along with completions for the
 *   entered text. If one completion is returned the line should be completed to
 *   match it (in which the completion may actually only be a longest prefix from
 *   the list of candiates), otherwise the list of completions should be
 *   displayed.
 */
pinkgorilla.kernel.repl.get_completions = (function pinkgorilla$kernel$repl$get_completions(buffer){
if((cljs.core.deref(pinkgorilla.kernel.repl.st) == null)){
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [buffer], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ready","ready",1086465795),false], null));
} else {
var temp__5733__auto__ = pinkgorilla.kernel.repl.local_keyword(buffer);
if(cljs.core.truth_(temp__5733__auto__)){
var kw_name = temp__5733__auto__;
return pinkgorilla.kernel.repl.local_keyword_completions(kw_name);
} else {
var top_form_QMARK_ = cljs.core.re_find(/^\s*\(\s*[^()\s]*$/,buffer);
var typed_ns = cljs.core.second(cljs.core.re_find(/\(*(\b[a-zA-Z0-9-.<>*=&?]+)\/[a-zA-Z0-9-]*$/,buffer));
var buffer_match_suffix = cljs.core.first(cljs.core.re_find(/:?([a-zA-Z0-9-.<>*=&?]*|^\(\/)$/,buffer));
var completions = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(pinkgorilla.kernel.repl.is_completion_QMARK_,buffer_match_suffix),pinkgorilla.kernel.repl.completion_candidates(top_form_QMARK_,typed_ns)));
var common_prefix = pinkgorilla.kernel.repl.longest_common_prefix(completions);
return cljs.core.with_meta(((((cljs.core.empty_QMARK_(common_prefix)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(common_prefix,buffer_match_suffix))))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [buffer_match_suffix], null),completions):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [buffer_match_suffix,common_prefix], null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ready","ready",1086465795),true], null));
}
}
});

//# sourceMappingURL=pinkgorilla.kernel.repl.js.map
