goog.provide('pinkgorilla.ui.clock');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('pinkgorilla.ui.pinkie');
goog.require('pinkgorilla.ui.html');
pinkgorilla.ui.clock.clock_style = "<style> \n\n/* Binary clock */\n\n.clock-main {\n    background: #333;\n    color: #cdcdcd;\n    padding-top: 55px;\n    padding-left: 20px;\n    float: left;\n    font-size: 28px;\n    line-height: 34px;\n    width: 620px;\n    cursor: pointer;\n}\n.clock-main.wide {\n    width: 790px;\n}\n.clock-cell {\n    width: 55px;\n    height: 55px;\n    text-align: center;\n    margin: 0 20px 20px 0;\n}\n.clock-cell.dark {\n    background-color: #454545;\n}\n.clock-cell.light {\n    background-color: #eee;\n}\n.clock-col {\n    margin: 0;\n    float: left;\n}\n.clock-legend > .clock-cell {\n    margin-top: 10px;\n}\n.clock-pair {\n    margin: 0;\n    float: left;\n}\n.clock-pair:not(:last-child) {\n    margin-right: 20px;\n    /* border-right: 1px solid #454545; */\n}\n </style>\n";
pinkgorilla.ui.clock.cell = (function pinkgorilla$ui$clock$cell(n,bit){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.clock-cell","div.clock-cell",-12507663),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),((((n & (1 << bit)) != 0))?"light":"dark")], null)], null);
});
pinkgorilla.ui.clock.column = (function pinkgorilla$ui$clock$column(n){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.clock-col","div.clock-col",1418748813),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.cell,n,(3)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.cell,n,(2)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.cell,n,(1)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.cell,n,(0)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.clock-cell","div.clock-cell",-12507663),n], null)], null);
});
pinkgorilla.ui.clock.column_pair = (function pinkgorilla$ui$clock$column_pair(n){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.clock-pair","div.clock-pair",-65283468),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.column,cljs.core.quot(n,(10))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.column,cljs.core.mod(n,(10))], null)], null);
});
pinkgorilla.ui.clock.legend = (function pinkgorilla$ui$clock$legend(var_args){
var args__4795__auto__ = [];
var len__4789__auto___26599 = arguments.length;
var i__4790__auto___26600 = (0);
while(true){
if((i__4790__auto___26600 < len__4789__auto___26599)){
args__4795__auto__.push((arguments[i__4790__auto___26600]));

var G__26601 = (i__4790__auto___26600 + (1));
i__4790__auto___26600 = G__26601;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((0) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((0)),(0),null)):null);
return pinkgorilla.ui.clock.legend.cljs$core$IFn$_invoke$arity$variadic(argseq__4796__auto__);
});

(pinkgorilla.ui.clock.legend.cljs$core$IFn$_invoke$arity$variadic = (function (items){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.clock-col.clock-legend","div.clock-col.clock-legend",-1934406846)], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,new cljs.core.Keyword(null,"div.clock-cell","div.clock-cell",-12507663)),items));
}));

(pinkgorilla.ui.clock.legend.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(pinkgorilla.ui.clock.legend.cljs$lang$applyTo = (function (seq26596){
var self__4777__auto__ = this;
return self__4777__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26596));
}));

pinkgorilla.ui.clock.clock = (function pinkgorilla$ui$clock$clock(date,show_100s,toggle_100s){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.clock-main","div.clock-main",-402520242),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),toggle_100s,new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(show_100s)?"wide":null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.html.html,pinkgorilla.ui.clock.clock_style], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.legend,(8),(4),(2),(1)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.column_pair,date.getHours()], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.column_pair,date.getMinutes()], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.column_pair,date.getSeconds()], null),(cljs.core.truth_(show_100s)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.column_pair,cljs.core.quot(date.getMilliseconds(),(10))], null):null)], null);
});
pinkgorilla.ui.clock.clock_state = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"time","time",1385887882),(new Date()),new cljs.core.Keyword(null,"show-100s","show-100s",1072817186),false], null));
pinkgorilla.ui.clock.update_time = (function pinkgorilla$ui$clock$update_time(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.ui.clock.clock_state,cljs.core.assoc,new cljs.core.Keyword(null,"time","time",1385887882),(new Date()));
});
pinkgorilla.ui.clock.binary_clock = (function pinkgorilla$ui$clock$binary_clock(){
var map__26597 = cljs.core.deref(pinkgorilla.ui.clock.clock_state);
var map__26597__$1 = (((((!((map__26597 == null))))?(((((map__26597.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26597.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26597):map__26597);
var time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26597__$1,new cljs.core.Keyword(null,"time","time",1385887882));
var show_100s = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26597__$1,new cljs.core.Keyword(null,"show-100s","show-100s",1072817186));
if(cljs.core.truth_(show_100s)){
reagent.core.next_tick(pinkgorilla.ui.clock.update_time);
} else {
setTimeout(pinkgorilla.ui.clock.update_time,(1000));
}

return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.clock,time,show_100s,(function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.ui.clock.clock_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"show-100s","show-100s",1072817186)], null),cljs.core.not);
})], null);
});
pinkgorilla.ui.pinkie.register_tag(new cljs.core.Keyword("p","clock","p/clock",-894300887),pinkgorilla.ui.clock.binary_clock);

//# sourceMappingURL=pinkgorilla.ui.clock.js.map
