goog.provide('chord.client');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('chord.channels');
goog.require('chord.format');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e46533){var e = e46533;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4795__auto__ = [];
var len__4789__auto___46649 = arguments.length;
var i__4790__auto___46650 = (0);
while(true){
if((i__4790__auto___46650 < len__4789__auto___46649)){
args__4795__auto__.push((arguments[i__4790__auto___46650]));

var G__46651 = (i__4790__auto___46650 + (1));
i__4790__auto___46650 = G__46651;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__46538){
var vec__46539 = p__46538;
var map__46542 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46539,(0),null);
var map__46542__$1 = (((((!((map__46542 == null))))?(((((map__46542.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46542.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46542):map__46542);
var opts = map__46542__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46542__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46542__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46542__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46542__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__46544 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4185__auto__ = read_ch;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4185__auto__ = write_ch;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__46544__$1 = (((((!((map__46544 == null))))?(((((map__46544.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46544.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46544):map__46544);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46544__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46544__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__46534_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__46534_SHARP_);
}));

(web_socket.onclose = (function (p1__46535_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__46535_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__29274__auto___46652 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_46613){
var state_val_46614 = (state_46613[(1)]);
if((state_val_46614 === (7))){
var inst_46609 = (state_46613[(2)]);
var state_46613__$1 = state_46613;
var statearr_46615_46653 = state_46613__$1;
(statearr_46615_46653[(2)] = inst_46609);

(statearr_46615_46653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (20))){
var state_46613__$1 = state_46613;
var statearr_46616_46654 = state_46613__$1;
(statearr_46616_46654[(2)] = null);

(statearr_46616_46654[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (1))){
var inst_46546 = false;
var state_46613__$1 = (function (){var statearr_46617 = state_46613;
(statearr_46617[(7)] = inst_46546);

return statearr_46617;
})();
var statearr_46618_46655 = state_46613__$1;
(statearr_46618_46655[(2)] = null);

(statearr_46618_46655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (4))){
var inst_46561 = (state_46613[(8)]);
var inst_46563 = (state_46613[(9)]);
var inst_46555 = (state_46613[(10)]);
var inst_46561__$1 = (state_46613[(2)]);
var inst_46562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46561__$1,(0),null);
var inst_46563__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46561__$1,(1),null);
var inst_46564 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46563__$1,inst_46555);
var state_46613__$1 = (function (){var statearr_46619 = state_46613;
(statearr_46619[(8)] = inst_46561__$1);

(statearr_46619[(9)] = inst_46563__$1);

(statearr_46619[(11)] = inst_46562);

return statearr_46619;
})();
if(inst_46564){
var statearr_46620_46656 = state_46613__$1;
(statearr_46620_46656[(1)] = (5));

} else {
var statearr_46621_46657 = state_46613__$1;
(statearr_46621_46657[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (15))){
var inst_46594 = (state_46613[(2)]);
var state_46613__$1 = state_46613;
var statearr_46622_46658 = state_46613__$1;
(statearr_46622_46658[(2)] = inst_46594);

(statearr_46622_46658[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (21))){
var inst_46605 = (state_46613[(2)]);
var state_46613__$1 = state_46613;
var statearr_46623_46659 = state_46613__$1;
(statearr_46623_46659[(2)] = inst_46605);

(statearr_46623_46659[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (13))){
var state_46613__$1 = state_46613;
var statearr_46624_46660 = state_46613__$1;
(statearr_46624_46660[(2)] = null);

(statearr_46624_46660[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (6))){
var inst_46563 = (state_46613[(9)]);
var inst_46556 = (state_46613[(12)]);
var inst_46578 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46563,inst_46556);
var state_46613__$1 = state_46613;
if(inst_46578){
var statearr_46625_46661 = state_46613__$1;
(statearr_46625_46661[(1)] = (9));

} else {
var statearr_46626_46662 = state_46613__$1;
(statearr_46626_46662[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (17))){
var state_46613__$1 = state_46613;
var statearr_46627_46663 = state_46613__$1;
(statearr_46627_46663[(2)] = initial_ch);

(statearr_46627_46663[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (3))){
var inst_46611 = (state_46613[(2)]);
var state_46613__$1 = state_46613;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46613__$1,inst_46611);
} else {
if((state_val_46614 === (12))){
var inst_46546 = (state_46613[(7)]);
var state_46613__$1 = state_46613;
if(cljs.core.truth_(inst_46546)){
var statearr_46628_46664 = state_46613__$1;
(statearr_46628_46664[(1)] = (16));

} else {
var statearr_46629_46665 = state_46613__$1;
(statearr_46629_46665[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (2))){
var inst_46555 = (state_46613[(10)]);
var inst_46556 = (state_46613[(12)]);
var inst_46555__$1 = open_ch;
var inst_46556__$1 = close_ch;
var inst_46557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46558 = [inst_46555__$1,inst_46556__$1];
var inst_46559 = (new cljs.core.PersistentVector(null,2,(5),inst_46557,inst_46558,null));
var state_46613__$1 = (function (){var statearr_46630 = state_46613;
(statearr_46630[(10)] = inst_46555__$1);

(statearr_46630[(12)] = inst_46556__$1);

return statearr_46630;
})();
return cljs.core.async.ioc_alts_BANG_(state_46613__$1,(4),inst_46559);
} else {
if((state_val_46614 === (19))){
var inst_46562 = (state_46613[(11)]);
var state_46613__$1 = state_46613;
var statearr_46631_46666 = state_46613__$1;
(statearr_46631_46666[(2)] = inst_46562);

(statearr_46631_46666[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (11))){
var inst_46607 = (state_46613[(2)]);
var state_46613__$1 = state_46613;
var statearr_46632_46667 = state_46613__$1;
(statearr_46632_46667[(2)] = inst_46607);

(statearr_46632_46667[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (9))){
var inst_46561 = (state_46613[(8)]);
var inst_46584 = (state_46613[(13)]);
var inst_46583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46561,(0),null);
var inst_46584__$1 = chord.client.close_event__GT_maybe_error(inst_46583);
var state_46613__$1 = (function (){var statearr_46633 = state_46613;
(statearr_46633[(13)] = inst_46584__$1);

return statearr_46633;
})();
if(cljs.core.truth_(inst_46584__$1)){
var statearr_46634_46668 = state_46613__$1;
(statearr_46634_46668[(1)] = (12));

} else {
var statearr_46635_46669 = state_46613__$1;
(statearr_46635_46669[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (5))){
var inst_46561 = (state_46613[(8)]);
var inst_46569 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46561,(0),null);
var inst_46570 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_46571 = [ws_chan];
var inst_46572 = cljs.core.PersistentHashMap.fromArrays(inst_46570,inst_46571);
var state_46613__$1 = (function (){var statearr_46636 = state_46613;
(statearr_46636[(14)] = inst_46569);

return statearr_46636;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46613__$1,(8),initial_ch,inst_46572);
} else {
if((state_val_46614 === (14))){
var inst_46597 = (state_46613[(2)]);
var inst_46598 = cljs.core.async.close_BANG_(ws_chan);
var inst_46599 = cljs.core.async.close_BANG_(initial_ch);
var state_46613__$1 = (function (){var statearr_46637 = state_46613;
(statearr_46637[(15)] = inst_46597);

(statearr_46637[(16)] = inst_46598);

return statearr_46637;
})();
var statearr_46638_46670 = state_46613__$1;
(statearr_46638_46670[(2)] = inst_46599);

(statearr_46638_46670[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (16))){
var state_46613__$1 = state_46613;
var statearr_46639_46671 = state_46613__$1;
(statearr_46639_46671[(2)] = read_ch__$1);

(statearr_46639_46671[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (10))){
var inst_46563 = (state_46613[(9)]);
var inst_46601 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46563,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_46613__$1 = state_46613;
if(inst_46601){
var statearr_46640_46673 = state_46613__$1;
(statearr_46640_46673[(1)] = (19));

} else {
var statearr_46641_46674 = state_46613__$1;
(statearr_46641_46674[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (18))){
var inst_46584 = (state_46613[(13)]);
var inst_46589 = (state_46613[(2)]);
var inst_46590 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_46591 = [inst_46584];
var inst_46592 = cljs.core.PersistentHashMap.fromArrays(inst_46590,inst_46591);
var state_46613__$1 = state_46613;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46613__$1,(15),inst_46589,inst_46592);
} else {
if((state_val_46614 === (8))){
var inst_46574 = (state_46613[(2)]);
var inst_46575 = cljs.core.async.close_BANG_(initial_ch);
var inst_46546 = true;
var state_46613__$1 = (function (){var statearr_46642 = state_46613;
(statearr_46642[(17)] = inst_46574);

(statearr_46642[(7)] = inst_46546);

(statearr_46642[(18)] = inst_46575);

return statearr_46642;
})();
var statearr_46643_46675 = state_46613__$1;
(statearr_46643_46675[(2)] = null);

(statearr_46643_46675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__29239__auto__ = null;
var chord$client$state_machine__29239__auto____0 = (function (){
var statearr_46644 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46644[(0)] = chord$client$state_machine__29239__auto__);

(statearr_46644[(1)] = (1));

return statearr_46644;
});
var chord$client$state_machine__29239__auto____1 = (function (state_46613){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_46613);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e46645){var ex__29242__auto__ = e46645;
var statearr_46646_46676 = state_46613;
(statearr_46646_46676[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_46613[(4)]))){
var statearr_46647_46677 = state_46613;
(statearr_46647_46677[(1)] = cljs.core.first((state_46613[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46678 = state_46613;
state_46613 = G__46678;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
chord$client$state_machine__29239__auto__ = function(state_46613){
switch(arguments.length){
case 0:
return chord$client$state_machine__29239__auto____0.call(this);
case 1:
return chord$client$state_machine__29239__auto____1.call(this,state_46613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__29239__auto____0;
chord$client$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__29239__auto____1;
return chord$client$state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_46648 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_46648[(6)] = c__29274__auto___46652);

return statearr_46648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq46536){
var G__46537 = cljs.core.first(seq46536);
var seq46536__$1 = cljs.core.next(seq46536);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46537,seq46536__$1);
}));


//# sourceMappingURL=chord.client.js.map
