goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__29332 = arguments.length;
switch (G__29332) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29334 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29334 = (function (f,blockable,meta29335){
this.f = f;
this.blockable = blockable;
this.meta29335 = meta29335;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29334.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29336,meta29335__$1){
var self__ = this;
var _29336__$1 = this;
return (new cljs.core.async.t_cljs$core$async29334(self__.f,self__.blockable,meta29335__$1));
}));

(cljs.core.async.t_cljs$core$async29334.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29336){
var self__ = this;
var _29336__$1 = this;
return self__.meta29335;
}));

(cljs.core.async.t_cljs$core$async29334.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29334.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async29334.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async29334.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async29334.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta29335","meta29335",350025025,null)], null);
}));

(cljs.core.async.t_cljs$core$async29334.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29334.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29334");

(cljs.core.async.t_cljs$core$async29334.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async29334");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29334.
 */
cljs.core.async.__GT_t_cljs$core$async29334 = (function cljs$core$async$__GT_t_cljs$core$async29334(f__$1,blockable__$1,meta29335){
return (new cljs.core.async.t_cljs$core$async29334(f__$1,blockable__$1,meta29335));
});

}

return (new cljs.core.async.t_cljs$core$async29334(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__29345 = arguments.length;
switch (G__29345) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__29353 = arguments.length;
switch (G__29353) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__29357 = arguments.length;
switch (G__29357) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_30889 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30889) : fn1.call(null,val_30889));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30889) : fn1.call(null,val_30889));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__29365 = arguments.length;
switch (G__29365) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4666__auto___30894 = n;
var x_30895 = (0);
while(true){
if((x_30895 < n__4666__auto___30894)){
(a[x_30895] = x_30895);

var G__30897 = (x_30895 + (1));
x_30895 = G__30897;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29367 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29367 = (function (flag,meta29368){
this.flag = flag;
this.meta29368 = meta29368;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29367.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29369,meta29368__$1){
var self__ = this;
var _29369__$1 = this;
return (new cljs.core.async.t_cljs$core$async29367(self__.flag,meta29368__$1));
}));

(cljs.core.async.t_cljs$core$async29367.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29369){
var self__ = this;
var _29369__$1 = this;
return self__.meta29368;
}));

(cljs.core.async.t_cljs$core$async29367.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29367.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async29367.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async29367.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async29367.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta29368","meta29368",-1456587865,null)], null);
}));

(cljs.core.async.t_cljs$core$async29367.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29367.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29367");

(cljs.core.async.t_cljs$core$async29367.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async29367");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29367.
 */
cljs.core.async.__GT_t_cljs$core$async29367 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async29367(flag__$1,meta29368){
return (new cljs.core.async.t_cljs$core$async29367(flag__$1,meta29368));
});

}

return (new cljs.core.async.t_cljs$core$async29367(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29372 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29372 = (function (flag,cb,meta29373){
this.flag = flag;
this.cb = cb;
this.meta29373 = meta29373;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29372.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29374,meta29373__$1){
var self__ = this;
var _29374__$1 = this;
return (new cljs.core.async.t_cljs$core$async29372(self__.flag,self__.cb,meta29373__$1));
}));

(cljs.core.async.t_cljs$core$async29372.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29374){
var self__ = this;
var _29374__$1 = this;
return self__.meta29373;
}));

(cljs.core.async.t_cljs$core$async29372.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29372.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async29372.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async29372.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async29372.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta29373","meta29373",96825082,null)], null);
}));

(cljs.core.async.t_cljs$core$async29372.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29372.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29372");

(cljs.core.async.t_cljs$core$async29372.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async29372");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29372.
 */
cljs.core.async.__GT_t_cljs$core$async29372 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async29372(flag__$1,cb__$1,meta29373){
return (new cljs.core.async.t_cljs$core$async29372(flag__$1,cb__$1,meta29373));
});

}

return (new cljs.core.async.t_cljs$core$async29372(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29380_SHARP_){
var G__29382 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29380_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__29382) : fret.call(null,G__29382));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29381_SHARP_){
var G__29383 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29381_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__29383) : fret.call(null,G__29383));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4185__auto__ = wport;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30911 = (i + (1));
i = G__30911;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4185__auto__ = ret;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4174__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4174__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___30915 = arguments.length;
var i__4790__auto___30916 = (0);
while(true){
if((i__4790__auto___30916 < len__4789__auto___30915)){
args__4795__auto__.push((arguments[i__4790__auto___30916]));

var G__30917 = (i__4790__auto___30916 + (1));
i__4790__auto___30916 = G__30917;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__29390){
var map__29391 = p__29390;
var map__29391__$1 = (((((!((map__29391 == null))))?(((((map__29391.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29391.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29391):map__29391);
var opts = map__29391__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq29386){
var G__29387 = cljs.core.first(seq29386);
var seq29386__$1 = cljs.core.next(seq29386);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29387,seq29386__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__29395 = arguments.length;
switch (G__29395) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__29274__auto___30923 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_29427){
var state_val_29428 = (state_29427[(1)]);
if((state_val_29428 === (7))){
var inst_29423 = (state_29427[(2)]);
var state_29427__$1 = state_29427;
var statearr_29432_30925 = state_29427__$1;
(statearr_29432_30925[(2)] = inst_29423);

(statearr_29432_30925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29428 === (1))){
var state_29427__$1 = state_29427;
var statearr_29433_30926 = state_29427__$1;
(statearr_29433_30926[(2)] = null);

(statearr_29433_30926[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29428 === (4))){
var inst_29406 = (state_29427[(7)]);
var inst_29406__$1 = (state_29427[(2)]);
var inst_29407 = (inst_29406__$1 == null);
var state_29427__$1 = (function (){var statearr_29435 = state_29427;
(statearr_29435[(7)] = inst_29406__$1);

return statearr_29435;
})();
if(cljs.core.truth_(inst_29407)){
var statearr_29436_30927 = state_29427__$1;
(statearr_29436_30927[(1)] = (5));

} else {
var statearr_29437_30928 = state_29427__$1;
(statearr_29437_30928[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29428 === (13))){
var state_29427__$1 = state_29427;
var statearr_29438_30929 = state_29427__$1;
(statearr_29438_30929[(2)] = null);

(statearr_29438_30929[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29428 === (6))){
var inst_29406 = (state_29427[(7)]);
var state_29427__$1 = state_29427;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29427__$1,(11),to,inst_29406);
} else {
if((state_val_29428 === (3))){
var inst_29425 = (state_29427[(2)]);
var state_29427__$1 = state_29427;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29427__$1,inst_29425);
} else {
if((state_val_29428 === (12))){
var state_29427__$1 = state_29427;
var statearr_29439_30933 = state_29427__$1;
(statearr_29439_30933[(2)] = null);

(statearr_29439_30933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29428 === (2))){
var state_29427__$1 = state_29427;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29427__$1,(4),from);
} else {
if((state_val_29428 === (11))){
var inst_29416 = (state_29427[(2)]);
var state_29427__$1 = state_29427;
if(cljs.core.truth_(inst_29416)){
var statearr_29440_30934 = state_29427__$1;
(statearr_29440_30934[(1)] = (12));

} else {
var statearr_29441_30935 = state_29427__$1;
(statearr_29441_30935[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29428 === (9))){
var state_29427__$1 = state_29427;
var statearr_29442_30936 = state_29427__$1;
(statearr_29442_30936[(2)] = null);

(statearr_29442_30936[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29428 === (5))){
var state_29427__$1 = state_29427;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29443_30938 = state_29427__$1;
(statearr_29443_30938[(1)] = (8));

} else {
var statearr_29444_30941 = state_29427__$1;
(statearr_29444_30941[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29428 === (14))){
var inst_29421 = (state_29427[(2)]);
var state_29427__$1 = state_29427;
var statearr_29445_30942 = state_29427__$1;
(statearr_29445_30942[(2)] = inst_29421);

(statearr_29445_30942[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29428 === (10))){
var inst_29413 = (state_29427[(2)]);
var state_29427__$1 = state_29427;
var statearr_29446_30944 = state_29427__$1;
(statearr_29446_30944[(2)] = inst_29413);

(statearr_29446_30944[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29428 === (8))){
var inst_29410 = cljs.core.async.close_BANG_(to);
var state_29427__$1 = state_29427;
var statearr_29447_30945 = state_29427__$1;
(statearr_29447_30945[(2)] = inst_29410);

(statearr_29447_30945[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29239__auto__ = null;
var cljs$core$async$state_machine__29239__auto____0 = (function (){
var statearr_29450 = [null,null,null,null,null,null,null,null];
(statearr_29450[(0)] = cljs$core$async$state_machine__29239__auto__);

(statearr_29450[(1)] = (1));

return statearr_29450;
});
var cljs$core$async$state_machine__29239__auto____1 = (function (state_29427){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_29427);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e29452){var ex__29242__auto__ = e29452;
var statearr_29453_30946 = state_29427;
(statearr_29453_30946[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_29427[(4)]))){
var statearr_29454_30947 = state_29427;
(statearr_29454_30947[(1)] = cljs.core.first((state_29427[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30951 = state_29427;
state_29427 = G__30951;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$state_machine__29239__auto__ = function(state_29427){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29239__auto____1.call(this,state_29427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29239__auto____0;
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29239__auto____1;
return cljs$core$async$state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_29455 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_29455[(6)] = c__29274__auto___30923);

return statearr_29455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__29457){
var vec__29458 = p__29457;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29458,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29458,(1),null);
var job = vec__29458;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__29274__auto___30953 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_29465){
var state_val_29466 = (state_29465[(1)]);
if((state_val_29466 === (1))){
var state_29465__$1 = state_29465;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29465__$1,(2),res,v);
} else {
if((state_val_29466 === (2))){
var inst_29462 = (state_29465[(2)]);
var inst_29463 = cljs.core.async.close_BANG_(res);
var state_29465__$1 = (function (){var statearr_29468 = state_29465;
(statearr_29468[(7)] = inst_29462);

return statearr_29468;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29465__$1,inst_29463);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____0 = (function (){
var statearr_29469 = [null,null,null,null,null,null,null,null];
(statearr_29469[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__);

(statearr_29469[(1)] = (1));

return statearr_29469;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____1 = (function (state_29465){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_29465);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e29470){var ex__29242__auto__ = e29470;
var statearr_29471_30957 = state_29465;
(statearr_29471_30957[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_29465[(4)]))){
var statearr_29472_30960 = state_29465;
(statearr_29472_30960[(1)] = cljs.core.first((state_29465[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30962 = state_29465;
state_29465 = G__30962;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__ = function(state_29465){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____1.call(this,state_29465);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_29475 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_29475[(6)] = c__29274__auto___30953);

return statearr_29475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__29478){
var vec__29480 = p__29478;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29480,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29480,(1),null);
var job = vec__29480;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4666__auto___30964 = n;
var __30965 = (0);
while(true){
if((__30965 < n__4666__auto___30964)){
var G__29484_30966 = type;
var G__29484_30967__$1 = (((G__29484_30966 instanceof cljs.core.Keyword))?G__29484_30966.fqn:null);
switch (G__29484_30967__$1) {
case "compute":
var c__29274__auto___30969 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30965,c__29274__auto___30969,G__29484_30966,G__29484_30967__$1,n__4666__auto___30964,jobs,results,process,async){
return (function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = ((function (__30965,c__29274__auto___30969,G__29484_30966,G__29484_30967__$1,n__4666__auto___30964,jobs,results,process,async){
return (function (state_29499){
var state_val_29500 = (state_29499[(1)]);
if((state_val_29500 === (1))){
var state_29499__$1 = state_29499;
var statearr_29501_30973 = state_29499__$1;
(statearr_29501_30973[(2)] = null);

(statearr_29501_30973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29500 === (2))){
var state_29499__$1 = state_29499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29499__$1,(4),jobs);
} else {
if((state_val_29500 === (3))){
var inst_29496 = (state_29499[(2)]);
var state_29499__$1 = state_29499;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29499__$1,inst_29496);
} else {
if((state_val_29500 === (4))){
var inst_29488 = (state_29499[(2)]);
var inst_29489 = process(inst_29488);
var state_29499__$1 = state_29499;
if(cljs.core.truth_(inst_29489)){
var statearr_29502_30975 = state_29499__$1;
(statearr_29502_30975[(1)] = (5));

} else {
var statearr_29503_30976 = state_29499__$1;
(statearr_29503_30976[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29500 === (5))){
var state_29499__$1 = state_29499;
var statearr_29504_30978 = state_29499__$1;
(statearr_29504_30978[(2)] = null);

(statearr_29504_30978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29500 === (6))){
var state_29499__$1 = state_29499;
var statearr_29505_30981 = state_29499__$1;
(statearr_29505_30981[(2)] = null);

(statearr_29505_30981[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29500 === (7))){
var inst_29494 = (state_29499[(2)]);
var state_29499__$1 = state_29499;
var statearr_29506_30982 = state_29499__$1;
(statearr_29506_30982[(2)] = inst_29494);

(statearr_29506_30982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30965,c__29274__auto___30969,G__29484_30966,G__29484_30967__$1,n__4666__auto___30964,jobs,results,process,async))
;
return ((function (__30965,switch__29238__auto__,c__29274__auto___30969,G__29484_30966,G__29484_30967__$1,n__4666__auto___30964,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____0 = (function (){
var statearr_29507 = [null,null,null,null,null,null,null];
(statearr_29507[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__);

(statearr_29507[(1)] = (1));

return statearr_29507;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____1 = (function (state_29499){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_29499);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e29508){var ex__29242__auto__ = e29508;
var statearr_29510_30984 = state_29499;
(statearr_29510_30984[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_29499[(4)]))){
var statearr_29512_30986 = state_29499;
(statearr_29512_30986[(1)] = cljs.core.first((state_29499[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30987 = state_29499;
state_29499 = G__30987;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__ = function(state_29499){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____1.call(this,state_29499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__;
})()
;})(__30965,switch__29238__auto__,c__29274__auto___30969,G__29484_30966,G__29484_30967__$1,n__4666__auto___30964,jobs,results,process,async))
})();
var state__29276__auto__ = (function (){var statearr_29516 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_29516[(6)] = c__29274__auto___30969);

return statearr_29516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
});})(__30965,c__29274__auto___30969,G__29484_30966,G__29484_30967__$1,n__4666__auto___30964,jobs,results,process,async))
);


break;
case "async":
var c__29274__auto___30988 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30965,c__29274__auto___30988,G__29484_30966,G__29484_30967__$1,n__4666__auto___30964,jobs,results,process,async){
return (function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = ((function (__30965,c__29274__auto___30988,G__29484_30966,G__29484_30967__$1,n__4666__auto___30964,jobs,results,process,async){
return (function (state_29529){
var state_val_29530 = (state_29529[(1)]);
if((state_val_29530 === (1))){
var state_29529__$1 = state_29529;
var statearr_29534_30989 = state_29529__$1;
(statearr_29534_30989[(2)] = null);

(statearr_29534_30989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (2))){
var state_29529__$1 = state_29529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29529__$1,(4),jobs);
} else {
if((state_val_29530 === (3))){
var inst_29527 = (state_29529[(2)]);
var state_29529__$1 = state_29529;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29529__$1,inst_29527);
} else {
if((state_val_29530 === (4))){
var inst_29519 = (state_29529[(2)]);
var inst_29520 = async(inst_29519);
var state_29529__$1 = state_29529;
if(cljs.core.truth_(inst_29520)){
var statearr_29538_30993 = state_29529__$1;
(statearr_29538_30993[(1)] = (5));

} else {
var statearr_29539_30994 = state_29529__$1;
(statearr_29539_30994[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (5))){
var state_29529__$1 = state_29529;
var statearr_29540_30995 = state_29529__$1;
(statearr_29540_30995[(2)] = null);

(statearr_29540_30995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (6))){
var state_29529__$1 = state_29529;
var statearr_29541_30996 = state_29529__$1;
(statearr_29541_30996[(2)] = null);

(statearr_29541_30996[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (7))){
var inst_29525 = (state_29529[(2)]);
var state_29529__$1 = state_29529;
var statearr_29542_30997 = state_29529__$1;
(statearr_29542_30997[(2)] = inst_29525);

(statearr_29542_30997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30965,c__29274__auto___30988,G__29484_30966,G__29484_30967__$1,n__4666__auto___30964,jobs,results,process,async))
;
return ((function (__30965,switch__29238__auto__,c__29274__auto___30988,G__29484_30966,G__29484_30967__$1,n__4666__auto___30964,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____0 = (function (){
var statearr_29543 = [null,null,null,null,null,null,null];
(statearr_29543[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__);

(statearr_29543[(1)] = (1));

return statearr_29543;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____1 = (function (state_29529){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_29529);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e29544){var ex__29242__auto__ = e29544;
var statearr_29545_30998 = state_29529;
(statearr_29545_30998[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_29529[(4)]))){
var statearr_29546_30999 = state_29529;
(statearr_29546_30999[(1)] = cljs.core.first((state_29529[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31001 = state_29529;
state_29529 = G__31001;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__ = function(state_29529){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____1.call(this,state_29529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__;
})()
;})(__30965,switch__29238__auto__,c__29274__auto___30988,G__29484_30966,G__29484_30967__$1,n__4666__auto___30964,jobs,results,process,async))
})();
var state__29276__auto__ = (function (){var statearr_29547 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_29547[(6)] = c__29274__auto___30988);

return statearr_29547;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
});})(__30965,c__29274__auto___30988,G__29484_30966,G__29484_30967__$1,n__4666__auto___30964,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29484_30967__$1)].join('')));

}

var G__31004 = (__30965 + (1));
__30965 = G__31004;
continue;
} else {
}
break;
}

var c__29274__auto___31005 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_29572){
var state_val_29573 = (state_29572[(1)]);
if((state_val_29573 === (7))){
var inst_29568 = (state_29572[(2)]);
var state_29572__$1 = state_29572;
var statearr_29574_31006 = state_29572__$1;
(statearr_29574_31006[(2)] = inst_29568);

(statearr_29574_31006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29573 === (1))){
var state_29572__$1 = state_29572;
var statearr_29575_31007 = state_29572__$1;
(statearr_29575_31007[(2)] = null);

(statearr_29575_31007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29573 === (4))){
var inst_29550 = (state_29572[(7)]);
var inst_29550__$1 = (state_29572[(2)]);
var inst_29551 = (inst_29550__$1 == null);
var state_29572__$1 = (function (){var statearr_29576 = state_29572;
(statearr_29576[(7)] = inst_29550__$1);

return statearr_29576;
})();
if(cljs.core.truth_(inst_29551)){
var statearr_29577_31011 = state_29572__$1;
(statearr_29577_31011[(1)] = (5));

} else {
var statearr_29578_31012 = state_29572__$1;
(statearr_29578_31012[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29573 === (6))){
var inst_29550 = (state_29572[(7)]);
var inst_29557 = (state_29572[(8)]);
var inst_29557__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_29559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29560 = [inst_29550,inst_29557__$1];
var inst_29561 = (new cljs.core.PersistentVector(null,2,(5),inst_29559,inst_29560,null));
var state_29572__$1 = (function (){var statearr_29579 = state_29572;
(statearr_29579[(8)] = inst_29557__$1);

return statearr_29579;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29572__$1,(8),jobs,inst_29561);
} else {
if((state_val_29573 === (3))){
var inst_29570 = (state_29572[(2)]);
var state_29572__$1 = state_29572;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29572__$1,inst_29570);
} else {
if((state_val_29573 === (2))){
var state_29572__$1 = state_29572;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29572__$1,(4),from);
} else {
if((state_val_29573 === (9))){
var inst_29565 = (state_29572[(2)]);
var state_29572__$1 = (function (){var statearr_29580 = state_29572;
(statearr_29580[(9)] = inst_29565);

return statearr_29580;
})();
var statearr_29581_31029 = state_29572__$1;
(statearr_29581_31029[(2)] = null);

(statearr_29581_31029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29573 === (5))){
var inst_29553 = cljs.core.async.close_BANG_(jobs);
var state_29572__$1 = state_29572;
var statearr_29582_31031 = state_29572__$1;
(statearr_29582_31031[(2)] = inst_29553);

(statearr_29582_31031[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29573 === (8))){
var inst_29557 = (state_29572[(8)]);
var inst_29563 = (state_29572[(2)]);
var state_29572__$1 = (function (){var statearr_29583 = state_29572;
(statearr_29583[(10)] = inst_29563);

return statearr_29583;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29572__$1,(9),results,inst_29557);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____0 = (function (){
var statearr_29584 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29584[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__);

(statearr_29584[(1)] = (1));

return statearr_29584;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____1 = (function (state_29572){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_29572);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e29585){var ex__29242__auto__ = e29585;
var statearr_29586_31035 = state_29572;
(statearr_29586_31035[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_29572[(4)]))){
var statearr_29587_31037 = state_29572;
(statearr_29587_31037[(1)] = cljs.core.first((state_29572[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31039 = state_29572;
state_29572 = G__31039;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__ = function(state_29572){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____1.call(this,state_29572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_29588 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_29588[(6)] = c__29274__auto___31005);

return statearr_29588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


var c__29274__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_29629){
var state_val_29630 = (state_29629[(1)]);
if((state_val_29630 === (7))){
var inst_29625 = (state_29629[(2)]);
var state_29629__$1 = state_29629;
var statearr_29631_31043 = state_29629__$1;
(statearr_29631_31043[(2)] = inst_29625);

(statearr_29631_31043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29630 === (20))){
var state_29629__$1 = state_29629;
var statearr_29632_31045 = state_29629__$1;
(statearr_29632_31045[(2)] = null);

(statearr_29632_31045[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29630 === (1))){
var state_29629__$1 = state_29629;
var statearr_29633_31047 = state_29629__$1;
(statearr_29633_31047[(2)] = null);

(statearr_29633_31047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29630 === (4))){
var inst_29594 = (state_29629[(7)]);
var inst_29594__$1 = (state_29629[(2)]);
var inst_29595 = (inst_29594__$1 == null);
var state_29629__$1 = (function (){var statearr_29634 = state_29629;
(statearr_29634[(7)] = inst_29594__$1);

return statearr_29634;
})();
if(cljs.core.truth_(inst_29595)){
var statearr_29635_31050 = state_29629__$1;
(statearr_29635_31050[(1)] = (5));

} else {
var statearr_29636_31051 = state_29629__$1;
(statearr_29636_31051[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29630 === (15))){
var inst_29607 = (state_29629[(8)]);
var state_29629__$1 = state_29629;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29629__$1,(18),to,inst_29607);
} else {
if((state_val_29630 === (21))){
var inst_29620 = (state_29629[(2)]);
var state_29629__$1 = state_29629;
var statearr_29637_31053 = state_29629__$1;
(statearr_29637_31053[(2)] = inst_29620);

(statearr_29637_31053[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29630 === (13))){
var inst_29622 = (state_29629[(2)]);
var state_29629__$1 = (function (){var statearr_29638 = state_29629;
(statearr_29638[(9)] = inst_29622);

return statearr_29638;
})();
var statearr_29639_31055 = state_29629__$1;
(statearr_29639_31055[(2)] = null);

(statearr_29639_31055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29630 === (6))){
var inst_29594 = (state_29629[(7)]);
var state_29629__$1 = state_29629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29629__$1,(11),inst_29594);
} else {
if((state_val_29630 === (17))){
var inst_29615 = (state_29629[(2)]);
var state_29629__$1 = state_29629;
if(cljs.core.truth_(inst_29615)){
var statearr_29640_31058 = state_29629__$1;
(statearr_29640_31058[(1)] = (19));

} else {
var statearr_29641_31059 = state_29629__$1;
(statearr_29641_31059[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29630 === (3))){
var inst_29627 = (state_29629[(2)]);
var state_29629__$1 = state_29629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29629__$1,inst_29627);
} else {
if((state_val_29630 === (12))){
var inst_29604 = (state_29629[(10)]);
var state_29629__$1 = state_29629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29629__$1,(14),inst_29604);
} else {
if((state_val_29630 === (2))){
var state_29629__$1 = state_29629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29629__$1,(4),results);
} else {
if((state_val_29630 === (19))){
var state_29629__$1 = state_29629;
var statearr_29642_31061 = state_29629__$1;
(statearr_29642_31061[(2)] = null);

(statearr_29642_31061[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29630 === (11))){
var inst_29604 = (state_29629[(2)]);
var state_29629__$1 = (function (){var statearr_29643 = state_29629;
(statearr_29643[(10)] = inst_29604);

return statearr_29643;
})();
var statearr_29646_31062 = state_29629__$1;
(statearr_29646_31062[(2)] = null);

(statearr_29646_31062[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29630 === (9))){
var state_29629__$1 = state_29629;
var statearr_29648_31066 = state_29629__$1;
(statearr_29648_31066[(2)] = null);

(statearr_29648_31066[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29630 === (5))){
var state_29629__$1 = state_29629;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29649_31067 = state_29629__$1;
(statearr_29649_31067[(1)] = (8));

} else {
var statearr_29650_31068 = state_29629__$1;
(statearr_29650_31068[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29630 === (14))){
var inst_29607 = (state_29629[(8)]);
var inst_29607__$1 = (state_29629[(2)]);
var inst_29608 = (inst_29607__$1 == null);
var inst_29609 = cljs.core.not(inst_29608);
var state_29629__$1 = (function (){var statearr_29651 = state_29629;
(statearr_29651[(8)] = inst_29607__$1);

return statearr_29651;
})();
if(inst_29609){
var statearr_29652_31069 = state_29629__$1;
(statearr_29652_31069[(1)] = (15));

} else {
var statearr_29653_31070 = state_29629__$1;
(statearr_29653_31070[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29630 === (16))){
var state_29629__$1 = state_29629;
var statearr_29654_31071 = state_29629__$1;
(statearr_29654_31071[(2)] = false);

(statearr_29654_31071[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29630 === (10))){
var inst_29601 = (state_29629[(2)]);
var state_29629__$1 = state_29629;
var statearr_29655_31072 = state_29629__$1;
(statearr_29655_31072[(2)] = inst_29601);

(statearr_29655_31072[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29630 === (18))){
var inst_29612 = (state_29629[(2)]);
var state_29629__$1 = state_29629;
var statearr_29656_31073 = state_29629__$1;
(statearr_29656_31073[(2)] = inst_29612);

(statearr_29656_31073[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29630 === (8))){
var inst_29598 = cljs.core.async.close_BANG_(to);
var state_29629__$1 = state_29629;
var statearr_29657_31074 = state_29629__$1;
(statearr_29657_31074[(2)] = inst_29598);

(statearr_29657_31074[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____0 = (function (){
var statearr_29658 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29658[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__);

(statearr_29658[(1)] = (1));

return statearr_29658;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____1 = (function (state_29629){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_29629);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e29660){var ex__29242__auto__ = e29660;
var statearr_29661_31075 = state_29629;
(statearr_29661_31075[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_29629[(4)]))){
var statearr_29662_31076 = state_29629;
(statearr_29662_31076[(1)] = cljs.core.first((state_29629[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31078 = state_29629;
state_29629 = G__31078;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__ = function(state_29629){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____1.call(this,state_29629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29239__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_29663 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_29663[(6)] = c__29274__auto__);

return statearr_29663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));

return c__29274__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__29665 = arguments.length;
switch (G__29665) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__29670 = arguments.length;
switch (G__29670) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__29672 = arguments.length;
switch (G__29672) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__29274__auto___31093 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_29698){
var state_val_29699 = (state_29698[(1)]);
if((state_val_29699 === (7))){
var inst_29694 = (state_29698[(2)]);
var state_29698__$1 = state_29698;
var statearr_29700_31094 = state_29698__$1;
(statearr_29700_31094[(2)] = inst_29694);

(statearr_29700_31094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29699 === (1))){
var state_29698__$1 = state_29698;
var statearr_29701_31095 = state_29698__$1;
(statearr_29701_31095[(2)] = null);

(statearr_29701_31095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29699 === (4))){
var inst_29675 = (state_29698[(7)]);
var inst_29675__$1 = (state_29698[(2)]);
var inst_29676 = (inst_29675__$1 == null);
var state_29698__$1 = (function (){var statearr_29702 = state_29698;
(statearr_29702[(7)] = inst_29675__$1);

return statearr_29702;
})();
if(cljs.core.truth_(inst_29676)){
var statearr_29703_31096 = state_29698__$1;
(statearr_29703_31096[(1)] = (5));

} else {
var statearr_29704_31097 = state_29698__$1;
(statearr_29704_31097[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29699 === (13))){
var state_29698__$1 = state_29698;
var statearr_29705_31102 = state_29698__$1;
(statearr_29705_31102[(2)] = null);

(statearr_29705_31102[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29699 === (6))){
var inst_29675 = (state_29698[(7)]);
var inst_29681 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_29675) : p.call(null,inst_29675));
var state_29698__$1 = state_29698;
if(cljs.core.truth_(inst_29681)){
var statearr_29706_31103 = state_29698__$1;
(statearr_29706_31103[(1)] = (9));

} else {
var statearr_29707_31104 = state_29698__$1;
(statearr_29707_31104[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29699 === (3))){
var inst_29696 = (state_29698[(2)]);
var state_29698__$1 = state_29698;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29698__$1,inst_29696);
} else {
if((state_val_29699 === (12))){
var state_29698__$1 = state_29698;
var statearr_29708_31105 = state_29698__$1;
(statearr_29708_31105[(2)] = null);

(statearr_29708_31105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29699 === (2))){
var state_29698__$1 = state_29698;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29698__$1,(4),ch);
} else {
if((state_val_29699 === (11))){
var inst_29675 = (state_29698[(7)]);
var inst_29685 = (state_29698[(2)]);
var state_29698__$1 = state_29698;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29698__$1,(8),inst_29685,inst_29675);
} else {
if((state_val_29699 === (9))){
var state_29698__$1 = state_29698;
var statearr_29709_31109 = state_29698__$1;
(statearr_29709_31109[(2)] = tc);

(statearr_29709_31109[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29699 === (5))){
var inst_29678 = cljs.core.async.close_BANG_(tc);
var inst_29679 = cljs.core.async.close_BANG_(fc);
var state_29698__$1 = (function (){var statearr_29710 = state_29698;
(statearr_29710[(8)] = inst_29678);

return statearr_29710;
})();
var statearr_29711_31113 = state_29698__$1;
(statearr_29711_31113[(2)] = inst_29679);

(statearr_29711_31113[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29699 === (14))){
var inst_29692 = (state_29698[(2)]);
var state_29698__$1 = state_29698;
var statearr_29712_31114 = state_29698__$1;
(statearr_29712_31114[(2)] = inst_29692);

(statearr_29712_31114[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29699 === (10))){
var state_29698__$1 = state_29698;
var statearr_29713_31115 = state_29698__$1;
(statearr_29713_31115[(2)] = fc);

(statearr_29713_31115[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29699 === (8))){
var inst_29687 = (state_29698[(2)]);
var state_29698__$1 = state_29698;
if(cljs.core.truth_(inst_29687)){
var statearr_29714_31116 = state_29698__$1;
(statearr_29714_31116[(1)] = (12));

} else {
var statearr_29715_31117 = state_29698__$1;
(statearr_29715_31117[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29239__auto__ = null;
var cljs$core$async$state_machine__29239__auto____0 = (function (){
var statearr_29716 = [null,null,null,null,null,null,null,null,null];
(statearr_29716[(0)] = cljs$core$async$state_machine__29239__auto__);

(statearr_29716[(1)] = (1));

return statearr_29716;
});
var cljs$core$async$state_machine__29239__auto____1 = (function (state_29698){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_29698);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e29717){var ex__29242__auto__ = e29717;
var statearr_29718_31118 = state_29698;
(statearr_29718_31118[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_29698[(4)]))){
var statearr_29719_31119 = state_29698;
(statearr_29719_31119[(1)] = cljs.core.first((state_29698[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31127 = state_29698;
state_29698 = G__31127;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$state_machine__29239__auto__ = function(state_29698){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29239__auto____1.call(this,state_29698);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29239__auto____0;
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29239__auto____1;
return cljs$core$async$state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_29720 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_29720[(6)] = c__29274__auto___31093);

return statearr_29720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__29274__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_29742){
var state_val_29743 = (state_29742[(1)]);
if((state_val_29743 === (7))){
var inst_29738 = (state_29742[(2)]);
var state_29742__$1 = state_29742;
var statearr_29744_31138 = state_29742__$1;
(statearr_29744_31138[(2)] = inst_29738);

(statearr_29744_31138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29743 === (1))){
var inst_29721 = init;
var inst_29722 = inst_29721;
var state_29742__$1 = (function (){var statearr_29745 = state_29742;
(statearr_29745[(7)] = inst_29722);

return statearr_29745;
})();
var statearr_29746_31147 = state_29742__$1;
(statearr_29746_31147[(2)] = null);

(statearr_29746_31147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29743 === (4))){
var inst_29725 = (state_29742[(8)]);
var inst_29725__$1 = (state_29742[(2)]);
var inst_29726 = (inst_29725__$1 == null);
var state_29742__$1 = (function (){var statearr_29747 = state_29742;
(statearr_29747[(8)] = inst_29725__$1);

return statearr_29747;
})();
if(cljs.core.truth_(inst_29726)){
var statearr_29748_31170 = state_29742__$1;
(statearr_29748_31170[(1)] = (5));

} else {
var statearr_29749_31171 = state_29742__$1;
(statearr_29749_31171[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29743 === (6))){
var inst_29725 = (state_29742[(8)]);
var inst_29722 = (state_29742[(7)]);
var inst_29729 = (state_29742[(9)]);
var inst_29729__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_29722,inst_29725) : f.call(null,inst_29722,inst_29725));
var inst_29730 = cljs.core.reduced_QMARK_(inst_29729__$1);
var state_29742__$1 = (function (){var statearr_29750 = state_29742;
(statearr_29750[(9)] = inst_29729__$1);

return statearr_29750;
})();
if(inst_29730){
var statearr_29751_31176 = state_29742__$1;
(statearr_29751_31176[(1)] = (8));

} else {
var statearr_29752_31178 = state_29742__$1;
(statearr_29752_31178[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29743 === (3))){
var inst_29740 = (state_29742[(2)]);
var state_29742__$1 = state_29742;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29742__$1,inst_29740);
} else {
if((state_val_29743 === (2))){
var state_29742__$1 = state_29742;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29742__$1,(4),ch);
} else {
if((state_val_29743 === (9))){
var inst_29729 = (state_29742[(9)]);
var inst_29722 = inst_29729;
var state_29742__$1 = (function (){var statearr_29753 = state_29742;
(statearr_29753[(7)] = inst_29722);

return statearr_29753;
})();
var statearr_29754_31180 = state_29742__$1;
(statearr_29754_31180[(2)] = null);

(statearr_29754_31180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29743 === (5))){
var inst_29722 = (state_29742[(7)]);
var state_29742__$1 = state_29742;
var statearr_29755_31182 = state_29742__$1;
(statearr_29755_31182[(2)] = inst_29722);

(statearr_29755_31182[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29743 === (10))){
var inst_29736 = (state_29742[(2)]);
var state_29742__$1 = state_29742;
var statearr_29756_31185 = state_29742__$1;
(statearr_29756_31185[(2)] = inst_29736);

(statearr_29756_31185[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29743 === (8))){
var inst_29729 = (state_29742[(9)]);
var inst_29732 = cljs.core.deref(inst_29729);
var state_29742__$1 = state_29742;
var statearr_29757_31186 = state_29742__$1;
(statearr_29757_31186[(2)] = inst_29732);

(statearr_29757_31186[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__29239__auto__ = null;
var cljs$core$async$reduce_$_state_machine__29239__auto____0 = (function (){
var statearr_29758 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29758[(0)] = cljs$core$async$reduce_$_state_machine__29239__auto__);

(statearr_29758[(1)] = (1));

return statearr_29758;
});
var cljs$core$async$reduce_$_state_machine__29239__auto____1 = (function (state_29742){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_29742);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e29759){var ex__29242__auto__ = e29759;
var statearr_29760_31191 = state_29742;
(statearr_29760_31191[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_29742[(4)]))){
var statearr_29761_31192 = state_29742;
(statearr_29761_31192[(1)] = cljs.core.first((state_29742[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31194 = state_29742;
state_29742 = G__31194;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__29239__auto__ = function(state_29742){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__29239__auto____1.call(this,state_29742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__29239__auto____0;
cljs$core$async$reduce_$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__29239__auto____1;
return cljs$core$async$reduce_$_state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_29762 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_29762[(6)] = c__29274__auto__);

return statearr_29762;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));

return c__29274__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__29274__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_29768){
var state_val_29769 = (state_29768[(1)]);
if((state_val_29769 === (1))){
var inst_29763 = cljs.core.async.reduce(f__$1,init,ch);
var state_29768__$1 = state_29768;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29768__$1,(2),inst_29763);
} else {
if((state_val_29769 === (2))){
var inst_29765 = (state_29768[(2)]);
var inst_29766 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_29765) : f__$1.call(null,inst_29765));
var state_29768__$1 = state_29768;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29768__$1,inst_29766);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__29239__auto__ = null;
var cljs$core$async$transduce_$_state_machine__29239__auto____0 = (function (){
var statearr_29770 = [null,null,null,null,null,null,null];
(statearr_29770[(0)] = cljs$core$async$transduce_$_state_machine__29239__auto__);

(statearr_29770[(1)] = (1));

return statearr_29770;
});
var cljs$core$async$transduce_$_state_machine__29239__auto____1 = (function (state_29768){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_29768);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e29771){var ex__29242__auto__ = e29771;
var statearr_29772_31200 = state_29768;
(statearr_29772_31200[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_29768[(4)]))){
var statearr_29773_31202 = state_29768;
(statearr_29773_31202[(1)] = cljs.core.first((state_29768[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31204 = state_29768;
state_29768 = G__31204;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__29239__auto__ = function(state_29768){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__29239__auto____1.call(this,state_29768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__29239__auto____0;
cljs$core$async$transduce_$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__29239__auto____1;
return cljs$core$async$transduce_$_state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_29774 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_29774[(6)] = c__29274__auto__);

return statearr_29774;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));

return c__29274__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__29776 = arguments.length;
switch (G__29776) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__29274__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_29801){
var state_val_29802 = (state_29801[(1)]);
if((state_val_29802 === (7))){
var inst_29783 = (state_29801[(2)]);
var state_29801__$1 = state_29801;
var statearr_29803_31212 = state_29801__$1;
(statearr_29803_31212[(2)] = inst_29783);

(statearr_29803_31212[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29802 === (1))){
var inst_29777 = cljs.core.seq(coll);
var inst_29778 = inst_29777;
var state_29801__$1 = (function (){var statearr_29804 = state_29801;
(statearr_29804[(7)] = inst_29778);

return statearr_29804;
})();
var statearr_29805_31214 = state_29801__$1;
(statearr_29805_31214[(2)] = null);

(statearr_29805_31214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29802 === (4))){
var inst_29778 = (state_29801[(7)]);
var inst_29781 = cljs.core.first(inst_29778);
var state_29801__$1 = state_29801;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29801__$1,(7),ch,inst_29781);
} else {
if((state_val_29802 === (13))){
var inst_29795 = (state_29801[(2)]);
var state_29801__$1 = state_29801;
var statearr_29806_31217 = state_29801__$1;
(statearr_29806_31217[(2)] = inst_29795);

(statearr_29806_31217[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29802 === (6))){
var inst_29786 = (state_29801[(2)]);
var state_29801__$1 = state_29801;
if(cljs.core.truth_(inst_29786)){
var statearr_29807_31219 = state_29801__$1;
(statearr_29807_31219[(1)] = (8));

} else {
var statearr_29808_31220 = state_29801__$1;
(statearr_29808_31220[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29802 === (3))){
var inst_29799 = (state_29801[(2)]);
var state_29801__$1 = state_29801;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29801__$1,inst_29799);
} else {
if((state_val_29802 === (12))){
var state_29801__$1 = state_29801;
var statearr_29809_31224 = state_29801__$1;
(statearr_29809_31224[(2)] = null);

(statearr_29809_31224[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29802 === (2))){
var inst_29778 = (state_29801[(7)]);
var state_29801__$1 = state_29801;
if(cljs.core.truth_(inst_29778)){
var statearr_29810_31225 = state_29801__$1;
(statearr_29810_31225[(1)] = (4));

} else {
var statearr_29811_31227 = state_29801__$1;
(statearr_29811_31227[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29802 === (11))){
var inst_29792 = cljs.core.async.close_BANG_(ch);
var state_29801__$1 = state_29801;
var statearr_29812_31228 = state_29801__$1;
(statearr_29812_31228[(2)] = inst_29792);

(statearr_29812_31228[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29802 === (9))){
var state_29801__$1 = state_29801;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29813_31229 = state_29801__$1;
(statearr_29813_31229[(1)] = (11));

} else {
var statearr_29814_31230 = state_29801__$1;
(statearr_29814_31230[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29802 === (5))){
var inst_29778 = (state_29801[(7)]);
var state_29801__$1 = state_29801;
var statearr_29815_31231 = state_29801__$1;
(statearr_29815_31231[(2)] = inst_29778);

(statearr_29815_31231[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29802 === (10))){
var inst_29797 = (state_29801[(2)]);
var state_29801__$1 = state_29801;
var statearr_29816_31232 = state_29801__$1;
(statearr_29816_31232[(2)] = inst_29797);

(statearr_29816_31232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29802 === (8))){
var inst_29778 = (state_29801[(7)]);
var inst_29788 = cljs.core.next(inst_29778);
var inst_29778__$1 = inst_29788;
var state_29801__$1 = (function (){var statearr_29817 = state_29801;
(statearr_29817[(7)] = inst_29778__$1);

return statearr_29817;
})();
var statearr_29818_31233 = state_29801__$1;
(statearr_29818_31233[(2)] = null);

(statearr_29818_31233[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29239__auto__ = null;
var cljs$core$async$state_machine__29239__auto____0 = (function (){
var statearr_29819 = [null,null,null,null,null,null,null,null];
(statearr_29819[(0)] = cljs$core$async$state_machine__29239__auto__);

(statearr_29819[(1)] = (1));

return statearr_29819;
});
var cljs$core$async$state_machine__29239__auto____1 = (function (state_29801){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_29801);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e29820){var ex__29242__auto__ = e29820;
var statearr_29821_31234 = state_29801;
(statearr_29821_31234[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_29801[(4)]))){
var statearr_29822_31235 = state_29801;
(statearr_29822_31235[(1)] = cljs.core.first((state_29801[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31236 = state_29801;
state_29801 = G__31236;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$state_machine__29239__auto__ = function(state_29801){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29239__auto____1.call(this,state_29801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29239__auto____0;
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29239__auto____1;
return cljs$core$async$state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_29823 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_29823[(6)] = c__29274__auto__);

return statearr_29823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));

return c__29274__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4487__auto__ = (((_ == null))?null:_);
var m__4488__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4488__auto__.call(null,_));
} else {
var m__4485__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4485__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4488__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4485__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4485__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4488__auto__.call(null,m,ch));
} else {
var m__4485__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4485__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4488__auto__.call(null,m));
} else {
var m__4485__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4485__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29824 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29824 = (function (ch,cs,meta29825){
this.ch = ch;
this.cs = cs;
this.meta29825 = meta29825;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29824.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29826,meta29825__$1){
var self__ = this;
var _29826__$1 = this;
return (new cljs.core.async.t_cljs$core$async29824(self__.ch,self__.cs,meta29825__$1));
}));

(cljs.core.async.t_cljs$core$async29824.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29826){
var self__ = this;
var _29826__$1 = this;
return self__.meta29825;
}));

(cljs.core.async.t_cljs$core$async29824.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29824.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29824.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29824.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async29824.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async29824.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async29824.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta29825","meta29825",-1362222379,null)], null);
}));

(cljs.core.async.t_cljs$core$async29824.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29824.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29824");

(cljs.core.async.t_cljs$core$async29824.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async29824");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29824.
 */
cljs.core.async.__GT_t_cljs$core$async29824 = (function cljs$core$async$mult_$___GT_t_cljs$core$async29824(ch__$1,cs__$1,meta29825){
return (new cljs.core.async.t_cljs$core$async29824(ch__$1,cs__$1,meta29825));
});

}

return (new cljs.core.async.t_cljs$core$async29824(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__29274__auto___31239 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_29959){
var state_val_29960 = (state_29959[(1)]);
if((state_val_29960 === (7))){
var inst_29955 = (state_29959[(2)]);
var state_29959__$1 = state_29959;
var statearr_29961_31240 = state_29959__$1;
(statearr_29961_31240[(2)] = inst_29955);

(statearr_29961_31240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (20))){
var inst_29860 = (state_29959[(7)]);
var inst_29872 = cljs.core.first(inst_29860);
var inst_29873 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29872,(0),null);
var inst_29874 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29872,(1),null);
var state_29959__$1 = (function (){var statearr_29962 = state_29959;
(statearr_29962[(8)] = inst_29873);

return statearr_29962;
})();
if(cljs.core.truth_(inst_29874)){
var statearr_29963_31241 = state_29959__$1;
(statearr_29963_31241[(1)] = (22));

} else {
var statearr_29964_31242 = state_29959__$1;
(statearr_29964_31242[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (27))){
var inst_29909 = (state_29959[(9)]);
var inst_29904 = (state_29959[(10)]);
var inst_29829 = (state_29959[(11)]);
var inst_29902 = (state_29959[(12)]);
var inst_29909__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_29902,inst_29904);
var inst_29910 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29909__$1,inst_29829,done);
var state_29959__$1 = (function (){var statearr_29965 = state_29959;
(statearr_29965[(9)] = inst_29909__$1);

return statearr_29965;
})();
if(cljs.core.truth_(inst_29910)){
var statearr_29966_31243 = state_29959__$1;
(statearr_29966_31243[(1)] = (30));

} else {
var statearr_29967_31244 = state_29959__$1;
(statearr_29967_31244[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (1))){
var state_29959__$1 = state_29959;
var statearr_29968_31245 = state_29959__$1;
(statearr_29968_31245[(2)] = null);

(statearr_29968_31245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (24))){
var inst_29860 = (state_29959[(7)]);
var inst_29879 = (state_29959[(2)]);
var inst_29880 = cljs.core.next(inst_29860);
var inst_29838 = inst_29880;
var inst_29839 = null;
var inst_29840 = (0);
var inst_29841 = (0);
var state_29959__$1 = (function (){var statearr_29969 = state_29959;
(statearr_29969[(13)] = inst_29841);

(statearr_29969[(14)] = inst_29838);

(statearr_29969[(15)] = inst_29839);

(statearr_29969[(16)] = inst_29879);

(statearr_29969[(17)] = inst_29840);

return statearr_29969;
})();
var statearr_29970_31246 = state_29959__$1;
(statearr_29970_31246[(2)] = null);

(statearr_29970_31246[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (39))){
var state_29959__$1 = state_29959;
var statearr_29974_31247 = state_29959__$1;
(statearr_29974_31247[(2)] = null);

(statearr_29974_31247[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (4))){
var inst_29829 = (state_29959[(11)]);
var inst_29829__$1 = (state_29959[(2)]);
var inst_29830 = (inst_29829__$1 == null);
var state_29959__$1 = (function (){var statearr_29975 = state_29959;
(statearr_29975[(11)] = inst_29829__$1);

return statearr_29975;
})();
if(cljs.core.truth_(inst_29830)){
var statearr_29976_31248 = state_29959__$1;
(statearr_29976_31248[(1)] = (5));

} else {
var statearr_29977_31249 = state_29959__$1;
(statearr_29977_31249[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (15))){
var inst_29841 = (state_29959[(13)]);
var inst_29838 = (state_29959[(14)]);
var inst_29839 = (state_29959[(15)]);
var inst_29840 = (state_29959[(17)]);
var inst_29856 = (state_29959[(2)]);
var inst_29857 = (inst_29841 + (1));
var tmp29971 = inst_29838;
var tmp29972 = inst_29839;
var tmp29973 = inst_29840;
var inst_29838__$1 = tmp29971;
var inst_29839__$1 = tmp29972;
var inst_29840__$1 = tmp29973;
var inst_29841__$1 = inst_29857;
var state_29959__$1 = (function (){var statearr_29978 = state_29959;
(statearr_29978[(13)] = inst_29841__$1);

(statearr_29978[(14)] = inst_29838__$1);

(statearr_29978[(15)] = inst_29839__$1);

(statearr_29978[(17)] = inst_29840__$1);

(statearr_29978[(18)] = inst_29856);

return statearr_29978;
})();
var statearr_29979_31250 = state_29959__$1;
(statearr_29979_31250[(2)] = null);

(statearr_29979_31250[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (21))){
var inst_29883 = (state_29959[(2)]);
var state_29959__$1 = state_29959;
var statearr_29983_31251 = state_29959__$1;
(statearr_29983_31251[(2)] = inst_29883);

(statearr_29983_31251[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (31))){
var inst_29909 = (state_29959[(9)]);
var inst_29913 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29909);
var state_29959__$1 = state_29959;
var statearr_29984_31253 = state_29959__$1;
(statearr_29984_31253[(2)] = inst_29913);

(statearr_29984_31253[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (32))){
var inst_29903 = (state_29959[(19)]);
var inst_29904 = (state_29959[(10)]);
var inst_29901 = (state_29959[(20)]);
var inst_29902 = (state_29959[(12)]);
var inst_29915 = (state_29959[(2)]);
var inst_29916 = (inst_29904 + (1));
var tmp29980 = inst_29903;
var tmp29981 = inst_29901;
var tmp29982 = inst_29902;
var inst_29901__$1 = tmp29981;
var inst_29902__$1 = tmp29982;
var inst_29903__$1 = tmp29980;
var inst_29904__$1 = inst_29916;
var state_29959__$1 = (function (){var statearr_29985 = state_29959;
(statearr_29985[(19)] = inst_29903__$1);

(statearr_29985[(10)] = inst_29904__$1);

(statearr_29985[(20)] = inst_29901__$1);

(statearr_29985[(21)] = inst_29915);

(statearr_29985[(12)] = inst_29902__$1);

return statearr_29985;
})();
var statearr_29986_31256 = state_29959__$1;
(statearr_29986_31256[(2)] = null);

(statearr_29986_31256[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (40))){
var inst_29928 = (state_29959[(22)]);
var inst_29932 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29928);
var state_29959__$1 = state_29959;
var statearr_29987_31258 = state_29959__$1;
(statearr_29987_31258[(2)] = inst_29932);

(statearr_29987_31258[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (33))){
var inst_29919 = (state_29959[(23)]);
var inst_29921 = cljs.core.chunked_seq_QMARK_(inst_29919);
var state_29959__$1 = state_29959;
if(inst_29921){
var statearr_29988_31259 = state_29959__$1;
(statearr_29988_31259[(1)] = (36));

} else {
var statearr_29989_31261 = state_29959__$1;
(statearr_29989_31261[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (13))){
var inst_29850 = (state_29959[(24)]);
var inst_29853 = cljs.core.async.close_BANG_(inst_29850);
var state_29959__$1 = state_29959;
var statearr_29990_31262 = state_29959__$1;
(statearr_29990_31262[(2)] = inst_29853);

(statearr_29990_31262[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (22))){
var inst_29873 = (state_29959[(8)]);
var inst_29876 = cljs.core.async.close_BANG_(inst_29873);
var state_29959__$1 = state_29959;
var statearr_29991_31264 = state_29959__$1;
(statearr_29991_31264[(2)] = inst_29876);

(statearr_29991_31264[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (36))){
var inst_29919 = (state_29959[(23)]);
var inst_29923 = cljs.core.chunk_first(inst_29919);
var inst_29924 = cljs.core.chunk_rest(inst_29919);
var inst_29925 = cljs.core.count(inst_29923);
var inst_29901 = inst_29924;
var inst_29902 = inst_29923;
var inst_29903 = inst_29925;
var inst_29904 = (0);
var state_29959__$1 = (function (){var statearr_29992 = state_29959;
(statearr_29992[(19)] = inst_29903);

(statearr_29992[(10)] = inst_29904);

(statearr_29992[(20)] = inst_29901);

(statearr_29992[(12)] = inst_29902);

return statearr_29992;
})();
var statearr_29993_31267 = state_29959__$1;
(statearr_29993_31267[(2)] = null);

(statearr_29993_31267[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (41))){
var inst_29919 = (state_29959[(23)]);
var inst_29934 = (state_29959[(2)]);
var inst_29935 = cljs.core.next(inst_29919);
var inst_29901 = inst_29935;
var inst_29902 = null;
var inst_29903 = (0);
var inst_29904 = (0);
var state_29959__$1 = (function (){var statearr_29994 = state_29959;
(statearr_29994[(19)] = inst_29903);

(statearr_29994[(10)] = inst_29904);

(statearr_29994[(20)] = inst_29901);

(statearr_29994[(25)] = inst_29934);

(statearr_29994[(12)] = inst_29902);

return statearr_29994;
})();
var statearr_29995_31269 = state_29959__$1;
(statearr_29995_31269[(2)] = null);

(statearr_29995_31269[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (43))){
var state_29959__$1 = state_29959;
var statearr_29996_31270 = state_29959__$1;
(statearr_29996_31270[(2)] = null);

(statearr_29996_31270[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (29))){
var inst_29943 = (state_29959[(2)]);
var state_29959__$1 = state_29959;
var statearr_29997_31271 = state_29959__$1;
(statearr_29997_31271[(2)] = inst_29943);

(statearr_29997_31271[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (44))){
var inst_29952 = (state_29959[(2)]);
var state_29959__$1 = (function (){var statearr_29998 = state_29959;
(statearr_29998[(26)] = inst_29952);

return statearr_29998;
})();
var statearr_29999_31272 = state_29959__$1;
(statearr_29999_31272[(2)] = null);

(statearr_29999_31272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (6))){
var inst_29893 = (state_29959[(27)]);
var inst_29892 = cljs.core.deref(cs);
var inst_29893__$1 = cljs.core.keys(inst_29892);
var inst_29894 = cljs.core.count(inst_29893__$1);
var inst_29895 = cljs.core.reset_BANG_(dctr,inst_29894);
var inst_29900 = cljs.core.seq(inst_29893__$1);
var inst_29901 = inst_29900;
var inst_29902 = null;
var inst_29903 = (0);
var inst_29904 = (0);
var state_29959__$1 = (function (){var statearr_30000 = state_29959;
(statearr_30000[(19)] = inst_29903);

(statearr_30000[(10)] = inst_29904);

(statearr_30000[(20)] = inst_29901);

(statearr_30000[(27)] = inst_29893__$1);

(statearr_30000[(12)] = inst_29902);

(statearr_30000[(28)] = inst_29895);

return statearr_30000;
})();
var statearr_30001_31273 = state_29959__$1;
(statearr_30001_31273[(2)] = null);

(statearr_30001_31273[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (28))){
var inst_29901 = (state_29959[(20)]);
var inst_29919 = (state_29959[(23)]);
var inst_29919__$1 = cljs.core.seq(inst_29901);
var state_29959__$1 = (function (){var statearr_30002 = state_29959;
(statearr_30002[(23)] = inst_29919__$1);

return statearr_30002;
})();
if(inst_29919__$1){
var statearr_30003_31274 = state_29959__$1;
(statearr_30003_31274[(1)] = (33));

} else {
var statearr_30004_31275 = state_29959__$1;
(statearr_30004_31275[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (25))){
var inst_29903 = (state_29959[(19)]);
var inst_29904 = (state_29959[(10)]);
var inst_29906 = (inst_29904 < inst_29903);
var inst_29907 = inst_29906;
var state_29959__$1 = state_29959;
if(cljs.core.truth_(inst_29907)){
var statearr_30005_31276 = state_29959__$1;
(statearr_30005_31276[(1)] = (27));

} else {
var statearr_30006_31277 = state_29959__$1;
(statearr_30006_31277[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (34))){
var state_29959__$1 = state_29959;
var statearr_30007_31278 = state_29959__$1;
(statearr_30007_31278[(2)] = null);

(statearr_30007_31278[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (17))){
var state_29959__$1 = state_29959;
var statearr_30008_31279 = state_29959__$1;
(statearr_30008_31279[(2)] = null);

(statearr_30008_31279[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (3))){
var inst_29957 = (state_29959[(2)]);
var state_29959__$1 = state_29959;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29959__$1,inst_29957);
} else {
if((state_val_29960 === (12))){
var inst_29888 = (state_29959[(2)]);
var state_29959__$1 = state_29959;
var statearr_30009_31280 = state_29959__$1;
(statearr_30009_31280[(2)] = inst_29888);

(statearr_30009_31280[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (2))){
var state_29959__$1 = state_29959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29959__$1,(4),ch);
} else {
if((state_val_29960 === (23))){
var state_29959__$1 = state_29959;
var statearr_30010_31281 = state_29959__$1;
(statearr_30010_31281[(2)] = null);

(statearr_30010_31281[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (35))){
var inst_29941 = (state_29959[(2)]);
var state_29959__$1 = state_29959;
var statearr_30011_31282 = state_29959__$1;
(statearr_30011_31282[(2)] = inst_29941);

(statearr_30011_31282[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (19))){
var inst_29860 = (state_29959[(7)]);
var inst_29864 = cljs.core.chunk_first(inst_29860);
var inst_29865 = cljs.core.chunk_rest(inst_29860);
var inst_29866 = cljs.core.count(inst_29864);
var inst_29838 = inst_29865;
var inst_29839 = inst_29864;
var inst_29840 = inst_29866;
var inst_29841 = (0);
var state_29959__$1 = (function (){var statearr_30012 = state_29959;
(statearr_30012[(13)] = inst_29841);

(statearr_30012[(14)] = inst_29838);

(statearr_30012[(15)] = inst_29839);

(statearr_30012[(17)] = inst_29840);

return statearr_30012;
})();
var statearr_30013_31283 = state_29959__$1;
(statearr_30013_31283[(2)] = null);

(statearr_30013_31283[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (11))){
var inst_29860 = (state_29959[(7)]);
var inst_29838 = (state_29959[(14)]);
var inst_29860__$1 = cljs.core.seq(inst_29838);
var state_29959__$1 = (function (){var statearr_30014 = state_29959;
(statearr_30014[(7)] = inst_29860__$1);

return statearr_30014;
})();
if(inst_29860__$1){
var statearr_30015_31284 = state_29959__$1;
(statearr_30015_31284[(1)] = (16));

} else {
var statearr_30016_31285 = state_29959__$1;
(statearr_30016_31285[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (9))){
var inst_29890 = (state_29959[(2)]);
var state_29959__$1 = state_29959;
var statearr_30017_31286 = state_29959__$1;
(statearr_30017_31286[(2)] = inst_29890);

(statearr_30017_31286[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (5))){
var inst_29836 = cljs.core.deref(cs);
var inst_29837 = cljs.core.seq(inst_29836);
var inst_29838 = inst_29837;
var inst_29839 = null;
var inst_29840 = (0);
var inst_29841 = (0);
var state_29959__$1 = (function (){var statearr_30018 = state_29959;
(statearr_30018[(13)] = inst_29841);

(statearr_30018[(14)] = inst_29838);

(statearr_30018[(15)] = inst_29839);

(statearr_30018[(17)] = inst_29840);

return statearr_30018;
})();
var statearr_30019_31287 = state_29959__$1;
(statearr_30019_31287[(2)] = null);

(statearr_30019_31287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (14))){
var state_29959__$1 = state_29959;
var statearr_30020_31288 = state_29959__$1;
(statearr_30020_31288[(2)] = null);

(statearr_30020_31288[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (45))){
var inst_29949 = (state_29959[(2)]);
var state_29959__$1 = state_29959;
var statearr_30021_31289 = state_29959__$1;
(statearr_30021_31289[(2)] = inst_29949);

(statearr_30021_31289[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (26))){
var inst_29893 = (state_29959[(27)]);
var inst_29945 = (state_29959[(2)]);
var inst_29946 = cljs.core.seq(inst_29893);
var state_29959__$1 = (function (){var statearr_30022 = state_29959;
(statearr_30022[(29)] = inst_29945);

return statearr_30022;
})();
if(inst_29946){
var statearr_30023_31290 = state_29959__$1;
(statearr_30023_31290[(1)] = (42));

} else {
var statearr_30024_31291 = state_29959__$1;
(statearr_30024_31291[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (16))){
var inst_29860 = (state_29959[(7)]);
var inst_29862 = cljs.core.chunked_seq_QMARK_(inst_29860);
var state_29959__$1 = state_29959;
if(inst_29862){
var statearr_30025_31292 = state_29959__$1;
(statearr_30025_31292[(1)] = (19));

} else {
var statearr_30026_31295 = state_29959__$1;
(statearr_30026_31295[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (38))){
var inst_29938 = (state_29959[(2)]);
var state_29959__$1 = state_29959;
var statearr_30027_31297 = state_29959__$1;
(statearr_30027_31297[(2)] = inst_29938);

(statearr_30027_31297[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (30))){
var state_29959__$1 = state_29959;
var statearr_30028_31298 = state_29959__$1;
(statearr_30028_31298[(2)] = null);

(statearr_30028_31298[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (10))){
var inst_29841 = (state_29959[(13)]);
var inst_29839 = (state_29959[(15)]);
var inst_29849 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_29839,inst_29841);
var inst_29850 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29849,(0),null);
var inst_29851 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29849,(1),null);
var state_29959__$1 = (function (){var statearr_30029 = state_29959;
(statearr_30029[(24)] = inst_29850);

return statearr_30029;
})();
if(cljs.core.truth_(inst_29851)){
var statearr_30030_31299 = state_29959__$1;
(statearr_30030_31299[(1)] = (13));

} else {
var statearr_30031_31300 = state_29959__$1;
(statearr_30031_31300[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (18))){
var inst_29886 = (state_29959[(2)]);
var state_29959__$1 = state_29959;
var statearr_30032_31301 = state_29959__$1;
(statearr_30032_31301[(2)] = inst_29886);

(statearr_30032_31301[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (42))){
var state_29959__$1 = state_29959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29959__$1,(45),dchan);
} else {
if((state_val_29960 === (37))){
var inst_29919 = (state_29959[(23)]);
var inst_29928 = (state_29959[(22)]);
var inst_29829 = (state_29959[(11)]);
var inst_29928__$1 = cljs.core.first(inst_29919);
var inst_29929 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29928__$1,inst_29829,done);
var state_29959__$1 = (function (){var statearr_30033 = state_29959;
(statearr_30033[(22)] = inst_29928__$1);

return statearr_30033;
})();
if(cljs.core.truth_(inst_29929)){
var statearr_30034_31303 = state_29959__$1;
(statearr_30034_31303[(1)] = (39));

} else {
var statearr_30035_31304 = state_29959__$1;
(statearr_30035_31304[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29960 === (8))){
var inst_29841 = (state_29959[(13)]);
var inst_29840 = (state_29959[(17)]);
var inst_29843 = (inst_29841 < inst_29840);
var inst_29844 = inst_29843;
var state_29959__$1 = state_29959;
if(cljs.core.truth_(inst_29844)){
var statearr_30036_31305 = state_29959__$1;
(statearr_30036_31305[(1)] = (10));

} else {
var statearr_30037_31306 = state_29959__$1;
(statearr_30037_31306[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__29239__auto__ = null;
var cljs$core$async$mult_$_state_machine__29239__auto____0 = (function (){
var statearr_30038 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30038[(0)] = cljs$core$async$mult_$_state_machine__29239__auto__);

(statearr_30038[(1)] = (1));

return statearr_30038;
});
var cljs$core$async$mult_$_state_machine__29239__auto____1 = (function (state_29959){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_29959);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e30039){var ex__29242__auto__ = e30039;
var statearr_30040_31307 = state_29959;
(statearr_30040_31307[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_29959[(4)]))){
var statearr_30041_31308 = state_29959;
(statearr_30041_31308[(1)] = cljs.core.first((state_29959[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31309 = state_29959;
state_29959 = G__31309;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__29239__auto__ = function(state_29959){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__29239__auto____1.call(this,state_29959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__29239__auto____0;
cljs$core$async$mult_$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__29239__auto____1;
return cljs$core$async$mult_$_state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_30042 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_30042[(6)] = c__29274__auto___31239);

return statearr_30042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__30044 = arguments.length;
switch (G__30044) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4488__auto__.call(null,m,ch));
} else {
var m__4485__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4485__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4488__auto__.call(null,m,ch));
} else {
var m__4485__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4485__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4488__auto__.call(null,m));
} else {
var m__4485__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4485__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4488__auto__.call(null,m,state_map));
} else {
var m__4485__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4485__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4488__auto__.call(null,m,mode));
} else {
var m__4485__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4485__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___31311 = arguments.length;
var i__4790__auto___31312 = (0);
while(true){
if((i__4790__auto___31312 < len__4789__auto___31311)){
args__4795__auto__.push((arguments[i__4790__auto___31312]));

var G__31313 = (i__4790__auto___31312 + (1));
i__4790__auto___31312 = G__31313;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((3) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4796__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__30049){
var map__30050 = p__30049;
var map__30050__$1 = (((((!((map__30050 == null))))?(((((map__30050.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30050.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30050):map__30050);
var opts = map__30050__$1;
var statearr_30052_31314 = state;
(statearr_30052_31314[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_30053_31315 = state;
(statearr_30053_31315[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_30054_31316 = state;
(statearr_30054_31316[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq30045){
var G__30046 = cljs.core.first(seq30045);
var seq30045__$1 = cljs.core.next(seq30045);
var G__30047 = cljs.core.first(seq30045__$1);
var seq30045__$2 = cljs.core.next(seq30045__$1);
var G__30048 = cljs.core.first(seq30045__$2);
var seq30045__$3 = cljs.core.next(seq30045__$2);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30046,G__30047,G__30048,seq30045__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30055 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30055 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta30056){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta30056 = meta30056;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30055.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30057,meta30056__$1){
var self__ = this;
var _30057__$1 = this;
return (new cljs.core.async.t_cljs$core$async30055(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta30056__$1));
}));

(cljs.core.async.t_cljs$core$async30055.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30057){
var self__ = this;
var _30057__$1 = this;
return self__.meta30056;
}));

(cljs.core.async.t_cljs$core$async30055.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30055.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async30055.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30055.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async30055.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async30055.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async30055.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async30055.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async30055.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta30056","meta30056",921255019,null)], null);
}));

(cljs.core.async.t_cljs$core$async30055.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30055.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30055");

(cljs.core.async.t_cljs$core$async30055.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async30055");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30055.
 */
cljs.core.async.__GT_t_cljs$core$async30055 = (function cljs$core$async$mix_$___GT_t_cljs$core$async30055(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30056){
return (new cljs.core.async.t_cljs$core$async30055(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30056));
});

}

return (new cljs.core.async.t_cljs$core$async30055(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29274__auto___31319 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_30159){
var state_val_30160 = (state_30159[(1)]);
if((state_val_30160 === (7))){
var inst_30074 = (state_30159[(2)]);
var state_30159__$1 = state_30159;
var statearr_30161_31321 = state_30159__$1;
(statearr_30161_31321[(2)] = inst_30074);

(statearr_30161_31321[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (20))){
var inst_30086 = (state_30159[(7)]);
var state_30159__$1 = state_30159;
var statearr_30162_31323 = state_30159__$1;
(statearr_30162_31323[(2)] = inst_30086);

(statearr_30162_31323[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (27))){
var state_30159__$1 = state_30159;
var statearr_30163_31324 = state_30159__$1;
(statearr_30163_31324[(2)] = null);

(statearr_30163_31324[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (1))){
var inst_30061 = (state_30159[(8)]);
var inst_30061__$1 = calc_state();
var inst_30063 = (inst_30061__$1 == null);
var inst_30064 = cljs.core.not(inst_30063);
var state_30159__$1 = (function (){var statearr_30164 = state_30159;
(statearr_30164[(8)] = inst_30061__$1);

return statearr_30164;
})();
if(inst_30064){
var statearr_30165_31327 = state_30159__$1;
(statearr_30165_31327[(1)] = (2));

} else {
var statearr_30166_31328 = state_30159__$1;
(statearr_30166_31328[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (24))){
var inst_30110 = (state_30159[(9)]);
var inst_30119 = (state_30159[(10)]);
var inst_30133 = (state_30159[(11)]);
var inst_30133__$1 = (inst_30110.cljs$core$IFn$_invoke$arity$1 ? inst_30110.cljs$core$IFn$_invoke$arity$1(inst_30119) : inst_30110.call(null,inst_30119));
var state_30159__$1 = (function (){var statearr_30167 = state_30159;
(statearr_30167[(11)] = inst_30133__$1);

return statearr_30167;
})();
if(cljs.core.truth_(inst_30133__$1)){
var statearr_30168_31331 = state_30159__$1;
(statearr_30168_31331[(1)] = (29));

} else {
var statearr_30169_31333 = state_30159__$1;
(statearr_30169_31333[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (4))){
var inst_30077 = (state_30159[(2)]);
var state_30159__$1 = state_30159;
if(cljs.core.truth_(inst_30077)){
var statearr_30170_31334 = state_30159__$1;
(statearr_30170_31334[(1)] = (8));

} else {
var statearr_30171_31335 = state_30159__$1;
(statearr_30171_31335[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (15))){
var inst_30104 = (state_30159[(2)]);
var state_30159__$1 = state_30159;
if(cljs.core.truth_(inst_30104)){
var statearr_30172_31336 = state_30159__$1;
(statearr_30172_31336[(1)] = (19));

} else {
var statearr_30173_31337 = state_30159__$1;
(statearr_30173_31337[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (21))){
var inst_30109 = (state_30159[(12)]);
var inst_30109__$1 = (state_30159[(2)]);
var inst_30110 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30109__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_30111 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30109__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_30112 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30109__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_30159__$1 = (function (){var statearr_30174 = state_30159;
(statearr_30174[(9)] = inst_30110);

(statearr_30174[(13)] = inst_30111);

(statearr_30174[(12)] = inst_30109__$1);

return statearr_30174;
})();
return cljs.core.async.ioc_alts_BANG_(state_30159__$1,(22),inst_30112);
} else {
if((state_val_30160 === (31))){
var inst_30141 = (state_30159[(2)]);
var state_30159__$1 = state_30159;
if(cljs.core.truth_(inst_30141)){
var statearr_30175_31340 = state_30159__$1;
(statearr_30175_31340[(1)] = (32));

} else {
var statearr_30176_31342 = state_30159__$1;
(statearr_30176_31342[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (32))){
var inst_30118 = (state_30159[(14)]);
var state_30159__$1 = state_30159;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30159__$1,(35),out,inst_30118);
} else {
if((state_val_30160 === (33))){
var inst_30109 = (state_30159[(12)]);
var inst_30086 = inst_30109;
var state_30159__$1 = (function (){var statearr_30177 = state_30159;
(statearr_30177[(7)] = inst_30086);

return statearr_30177;
})();
var statearr_30178_31344 = state_30159__$1;
(statearr_30178_31344[(2)] = null);

(statearr_30178_31344[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (13))){
var inst_30086 = (state_30159[(7)]);
var inst_30093 = inst_30086.cljs$lang$protocol_mask$partition0$;
var inst_30094 = (inst_30093 & (64));
var inst_30095 = inst_30086.cljs$core$ISeq$;
var inst_30096 = (cljs.core.PROTOCOL_SENTINEL === inst_30095);
var inst_30097 = ((inst_30094) || (inst_30096));
var state_30159__$1 = state_30159;
if(cljs.core.truth_(inst_30097)){
var statearr_30179_31346 = state_30159__$1;
(statearr_30179_31346[(1)] = (16));

} else {
var statearr_30180_31348 = state_30159__$1;
(statearr_30180_31348[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (22))){
var inst_30119 = (state_30159[(10)]);
var inst_30118 = (state_30159[(14)]);
var inst_30117 = (state_30159[(2)]);
var inst_30118__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30117,(0),null);
var inst_30119__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30117,(1),null);
var inst_30120 = (inst_30118__$1 == null);
var inst_30121 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30119__$1,change);
var inst_30122 = ((inst_30120) || (inst_30121));
var state_30159__$1 = (function (){var statearr_30181 = state_30159;
(statearr_30181[(10)] = inst_30119__$1);

(statearr_30181[(14)] = inst_30118__$1);

return statearr_30181;
})();
if(cljs.core.truth_(inst_30122)){
var statearr_30182_31351 = state_30159__$1;
(statearr_30182_31351[(1)] = (23));

} else {
var statearr_30183_31352 = state_30159__$1;
(statearr_30183_31352[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (36))){
var inst_30109 = (state_30159[(12)]);
var inst_30086 = inst_30109;
var state_30159__$1 = (function (){var statearr_30184 = state_30159;
(statearr_30184[(7)] = inst_30086);

return statearr_30184;
})();
var statearr_30185_31355 = state_30159__$1;
(statearr_30185_31355[(2)] = null);

(statearr_30185_31355[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (29))){
var inst_30133 = (state_30159[(11)]);
var state_30159__$1 = state_30159;
var statearr_30186_31357 = state_30159__$1;
(statearr_30186_31357[(2)] = inst_30133);

(statearr_30186_31357[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (6))){
var state_30159__$1 = state_30159;
var statearr_30187_31358 = state_30159__$1;
(statearr_30187_31358[(2)] = false);

(statearr_30187_31358[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (28))){
var inst_30129 = (state_30159[(2)]);
var inst_30130 = calc_state();
var inst_30086 = inst_30130;
var state_30159__$1 = (function (){var statearr_30188 = state_30159;
(statearr_30188[(7)] = inst_30086);

(statearr_30188[(15)] = inst_30129);

return statearr_30188;
})();
var statearr_30189_31361 = state_30159__$1;
(statearr_30189_31361[(2)] = null);

(statearr_30189_31361[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (25))){
var inst_30155 = (state_30159[(2)]);
var state_30159__$1 = state_30159;
var statearr_30190_31362 = state_30159__$1;
(statearr_30190_31362[(2)] = inst_30155);

(statearr_30190_31362[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (34))){
var inst_30153 = (state_30159[(2)]);
var state_30159__$1 = state_30159;
var statearr_30191_31363 = state_30159__$1;
(statearr_30191_31363[(2)] = inst_30153);

(statearr_30191_31363[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (17))){
var state_30159__$1 = state_30159;
var statearr_30192_31365 = state_30159__$1;
(statearr_30192_31365[(2)] = false);

(statearr_30192_31365[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (3))){
var state_30159__$1 = state_30159;
var statearr_30193_31367 = state_30159__$1;
(statearr_30193_31367[(2)] = false);

(statearr_30193_31367[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (12))){
var inst_30157 = (state_30159[(2)]);
var state_30159__$1 = state_30159;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30159__$1,inst_30157);
} else {
if((state_val_30160 === (2))){
var inst_30061 = (state_30159[(8)]);
var inst_30066 = inst_30061.cljs$lang$protocol_mask$partition0$;
var inst_30067 = (inst_30066 & (64));
var inst_30068 = inst_30061.cljs$core$ISeq$;
var inst_30069 = (cljs.core.PROTOCOL_SENTINEL === inst_30068);
var inst_30070 = ((inst_30067) || (inst_30069));
var state_30159__$1 = state_30159;
if(cljs.core.truth_(inst_30070)){
var statearr_30194_31369 = state_30159__$1;
(statearr_30194_31369[(1)] = (5));

} else {
var statearr_30195_31370 = state_30159__$1;
(statearr_30195_31370[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (23))){
var inst_30118 = (state_30159[(14)]);
var inst_30124 = (inst_30118 == null);
var state_30159__$1 = state_30159;
if(cljs.core.truth_(inst_30124)){
var statearr_30196_31371 = state_30159__$1;
(statearr_30196_31371[(1)] = (26));

} else {
var statearr_30197_31372 = state_30159__$1;
(statearr_30197_31372[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (35))){
var inst_30144 = (state_30159[(2)]);
var state_30159__$1 = state_30159;
if(cljs.core.truth_(inst_30144)){
var statearr_30198_31373 = state_30159__$1;
(statearr_30198_31373[(1)] = (36));

} else {
var statearr_30199_31374 = state_30159__$1;
(statearr_30199_31374[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (19))){
var inst_30086 = (state_30159[(7)]);
var inst_30106 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30086);
var state_30159__$1 = state_30159;
var statearr_30200_31375 = state_30159__$1;
(statearr_30200_31375[(2)] = inst_30106);

(statearr_30200_31375[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (11))){
var inst_30086 = (state_30159[(7)]);
var inst_30090 = (inst_30086 == null);
var inst_30091 = cljs.core.not(inst_30090);
var state_30159__$1 = state_30159;
if(inst_30091){
var statearr_30201_31376 = state_30159__$1;
(statearr_30201_31376[(1)] = (13));

} else {
var statearr_30202_31377 = state_30159__$1;
(statearr_30202_31377[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (9))){
var inst_30061 = (state_30159[(8)]);
var state_30159__$1 = state_30159;
var statearr_30203_31378 = state_30159__$1;
(statearr_30203_31378[(2)] = inst_30061);

(statearr_30203_31378[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (5))){
var state_30159__$1 = state_30159;
var statearr_30204_31379 = state_30159__$1;
(statearr_30204_31379[(2)] = true);

(statearr_30204_31379[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (14))){
var state_30159__$1 = state_30159;
var statearr_30205_31380 = state_30159__$1;
(statearr_30205_31380[(2)] = false);

(statearr_30205_31380[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (26))){
var inst_30119 = (state_30159[(10)]);
var inst_30126 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_30119);
var state_30159__$1 = state_30159;
var statearr_30206_31381 = state_30159__$1;
(statearr_30206_31381[(2)] = inst_30126);

(statearr_30206_31381[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (16))){
var state_30159__$1 = state_30159;
var statearr_30207_31382 = state_30159__$1;
(statearr_30207_31382[(2)] = true);

(statearr_30207_31382[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (38))){
var inst_30149 = (state_30159[(2)]);
var state_30159__$1 = state_30159;
var statearr_30208_31383 = state_30159__$1;
(statearr_30208_31383[(2)] = inst_30149);

(statearr_30208_31383[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (30))){
var inst_30110 = (state_30159[(9)]);
var inst_30119 = (state_30159[(10)]);
var inst_30111 = (state_30159[(13)]);
var inst_30136 = cljs.core.empty_QMARK_(inst_30110);
var inst_30137 = (inst_30111.cljs$core$IFn$_invoke$arity$1 ? inst_30111.cljs$core$IFn$_invoke$arity$1(inst_30119) : inst_30111.call(null,inst_30119));
var inst_30138 = cljs.core.not(inst_30137);
var inst_30139 = ((inst_30136) && (inst_30138));
var state_30159__$1 = state_30159;
var statearr_30209_31384 = state_30159__$1;
(statearr_30209_31384[(2)] = inst_30139);

(statearr_30209_31384[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (10))){
var inst_30061 = (state_30159[(8)]);
var inst_30082 = (state_30159[(2)]);
var inst_30083 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30082,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_30084 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30082,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_30085 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30082,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_30086 = inst_30061;
var state_30159__$1 = (function (){var statearr_30210 = state_30159;
(statearr_30210[(7)] = inst_30086);

(statearr_30210[(16)] = inst_30085);

(statearr_30210[(17)] = inst_30083);

(statearr_30210[(18)] = inst_30084);

return statearr_30210;
})();
var statearr_30211_31385 = state_30159__$1;
(statearr_30211_31385[(2)] = null);

(statearr_30211_31385[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (18))){
var inst_30101 = (state_30159[(2)]);
var state_30159__$1 = state_30159;
var statearr_30212_31386 = state_30159__$1;
(statearr_30212_31386[(2)] = inst_30101);

(statearr_30212_31386[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (37))){
var state_30159__$1 = state_30159;
var statearr_30213_31387 = state_30159__$1;
(statearr_30213_31387[(2)] = null);

(statearr_30213_31387[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30160 === (8))){
var inst_30061 = (state_30159[(8)]);
var inst_30079 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30061);
var state_30159__$1 = state_30159;
var statearr_30214_31388 = state_30159__$1;
(statearr_30214_31388[(2)] = inst_30079);

(statearr_30214_31388[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__29239__auto__ = null;
var cljs$core$async$mix_$_state_machine__29239__auto____0 = (function (){
var statearr_30215 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30215[(0)] = cljs$core$async$mix_$_state_machine__29239__auto__);

(statearr_30215[(1)] = (1));

return statearr_30215;
});
var cljs$core$async$mix_$_state_machine__29239__auto____1 = (function (state_30159){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_30159);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e30216){var ex__29242__auto__ = e30216;
var statearr_30217_31389 = state_30159;
(statearr_30217_31389[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_30159[(4)]))){
var statearr_30218_31390 = state_30159;
(statearr_30218_31390[(1)] = cljs.core.first((state_30159[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31391 = state_30159;
state_30159 = G__31391;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__29239__auto__ = function(state_30159){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__29239__auto____1.call(this,state_30159);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__29239__auto____0;
cljs$core$async$mix_$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__29239__auto____1;
return cljs$core$async$mix_$_state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_30219 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_30219[(6)] = c__29274__auto___31319);

return statearr_30219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4488__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4485__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4485__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4488__auto__.call(null,p,v,ch));
} else {
var m__4485__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4485__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__30221 = arguments.length;
switch (G__30221) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4488__auto__.call(null,p));
} else {
var m__4485__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4485__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4488__auto__.call(null,p,v));
} else {
var m__4485__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4485__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__30224 = arguments.length;
switch (G__30224) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__30222_SHARP_){
if(cljs.core.truth_((p1__30222_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__30222_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__30222_SHARP_.call(null,topic)))){
return p1__30222_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__30222_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30225 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30225 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta30226){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta30226 = meta30226;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30225.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30227,meta30226__$1){
var self__ = this;
var _30227__$1 = this;
return (new cljs.core.async.t_cljs$core$async30225(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta30226__$1));
}));

(cljs.core.async.t_cljs$core$async30225.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30227){
var self__ = this;
var _30227__$1 = this;
return self__.meta30226;
}));

(cljs.core.async.t_cljs$core$async30225.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30225.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async30225.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30225.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async30225.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async30225.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async30225.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async30225.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta30226","meta30226",1122055317,null)], null);
}));

(cljs.core.async.t_cljs$core$async30225.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30225.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30225");

(cljs.core.async.t_cljs$core$async30225.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async30225");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30225.
 */
cljs.core.async.__GT_t_cljs$core$async30225 = (function cljs$core$async$__GT_t_cljs$core$async30225(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta30226){
return (new cljs.core.async.t_cljs$core$async30225(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta30226));
});

}

return (new cljs.core.async.t_cljs$core$async30225(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29274__auto___31394 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_30299){
var state_val_30300 = (state_30299[(1)]);
if((state_val_30300 === (7))){
var inst_30295 = (state_30299[(2)]);
var state_30299__$1 = state_30299;
var statearr_30301_31395 = state_30299__$1;
(statearr_30301_31395[(2)] = inst_30295);

(statearr_30301_31395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (20))){
var state_30299__$1 = state_30299;
var statearr_30302_31396 = state_30299__$1;
(statearr_30302_31396[(2)] = null);

(statearr_30302_31396[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (1))){
var state_30299__$1 = state_30299;
var statearr_30303_31397 = state_30299__$1;
(statearr_30303_31397[(2)] = null);

(statearr_30303_31397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (24))){
var inst_30278 = (state_30299[(7)]);
var inst_30287 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_30278);
var state_30299__$1 = state_30299;
var statearr_30304_31398 = state_30299__$1;
(statearr_30304_31398[(2)] = inst_30287);

(statearr_30304_31398[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (4))){
var inst_30230 = (state_30299[(8)]);
var inst_30230__$1 = (state_30299[(2)]);
var inst_30231 = (inst_30230__$1 == null);
var state_30299__$1 = (function (){var statearr_30305 = state_30299;
(statearr_30305[(8)] = inst_30230__$1);

return statearr_30305;
})();
if(cljs.core.truth_(inst_30231)){
var statearr_30306_31399 = state_30299__$1;
(statearr_30306_31399[(1)] = (5));

} else {
var statearr_30307_31400 = state_30299__$1;
(statearr_30307_31400[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (15))){
var inst_30272 = (state_30299[(2)]);
var state_30299__$1 = state_30299;
var statearr_30308_31401 = state_30299__$1;
(statearr_30308_31401[(2)] = inst_30272);

(statearr_30308_31401[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (21))){
var inst_30292 = (state_30299[(2)]);
var state_30299__$1 = (function (){var statearr_30309 = state_30299;
(statearr_30309[(9)] = inst_30292);

return statearr_30309;
})();
var statearr_30310_31402 = state_30299__$1;
(statearr_30310_31402[(2)] = null);

(statearr_30310_31402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (13))){
var inst_30254 = (state_30299[(10)]);
var inst_30256 = cljs.core.chunked_seq_QMARK_(inst_30254);
var state_30299__$1 = state_30299;
if(inst_30256){
var statearr_30311_31403 = state_30299__$1;
(statearr_30311_31403[(1)] = (16));

} else {
var statearr_30312_31404 = state_30299__$1;
(statearr_30312_31404[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (22))){
var inst_30284 = (state_30299[(2)]);
var state_30299__$1 = state_30299;
if(cljs.core.truth_(inst_30284)){
var statearr_30313_31405 = state_30299__$1;
(statearr_30313_31405[(1)] = (23));

} else {
var statearr_30314_31406 = state_30299__$1;
(statearr_30314_31406[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (6))){
var inst_30230 = (state_30299[(8)]);
var inst_30278 = (state_30299[(7)]);
var inst_30280 = (state_30299[(11)]);
var inst_30278__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_30230) : topic_fn.call(null,inst_30230));
var inst_30279 = cljs.core.deref(mults);
var inst_30280__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30279,inst_30278__$1);
var state_30299__$1 = (function (){var statearr_30315 = state_30299;
(statearr_30315[(7)] = inst_30278__$1);

(statearr_30315[(11)] = inst_30280__$1);

return statearr_30315;
})();
if(cljs.core.truth_(inst_30280__$1)){
var statearr_30316_31407 = state_30299__$1;
(statearr_30316_31407[(1)] = (19));

} else {
var statearr_30317_31408 = state_30299__$1;
(statearr_30317_31408[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (25))){
var inst_30289 = (state_30299[(2)]);
var state_30299__$1 = state_30299;
var statearr_30318_31409 = state_30299__$1;
(statearr_30318_31409[(2)] = inst_30289);

(statearr_30318_31409[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (17))){
var inst_30254 = (state_30299[(10)]);
var inst_30263 = cljs.core.first(inst_30254);
var inst_30264 = cljs.core.async.muxch_STAR_(inst_30263);
var inst_30265 = cljs.core.async.close_BANG_(inst_30264);
var inst_30266 = cljs.core.next(inst_30254);
var inst_30240 = inst_30266;
var inst_30241 = null;
var inst_30242 = (0);
var inst_30243 = (0);
var state_30299__$1 = (function (){var statearr_30319 = state_30299;
(statearr_30319[(12)] = inst_30242);

(statearr_30319[(13)] = inst_30243);

(statearr_30319[(14)] = inst_30240);

(statearr_30319[(15)] = inst_30265);

(statearr_30319[(16)] = inst_30241);

return statearr_30319;
})();
var statearr_30320_31410 = state_30299__$1;
(statearr_30320_31410[(2)] = null);

(statearr_30320_31410[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (3))){
var inst_30297 = (state_30299[(2)]);
var state_30299__$1 = state_30299;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30299__$1,inst_30297);
} else {
if((state_val_30300 === (12))){
var inst_30274 = (state_30299[(2)]);
var state_30299__$1 = state_30299;
var statearr_30321_31411 = state_30299__$1;
(statearr_30321_31411[(2)] = inst_30274);

(statearr_30321_31411[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (2))){
var state_30299__$1 = state_30299;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30299__$1,(4),ch);
} else {
if((state_val_30300 === (23))){
var state_30299__$1 = state_30299;
var statearr_30322_31412 = state_30299__$1;
(statearr_30322_31412[(2)] = null);

(statearr_30322_31412[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (19))){
var inst_30230 = (state_30299[(8)]);
var inst_30280 = (state_30299[(11)]);
var inst_30282 = cljs.core.async.muxch_STAR_(inst_30280);
var state_30299__$1 = state_30299;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30299__$1,(22),inst_30282,inst_30230);
} else {
if((state_val_30300 === (11))){
var inst_30240 = (state_30299[(14)]);
var inst_30254 = (state_30299[(10)]);
var inst_30254__$1 = cljs.core.seq(inst_30240);
var state_30299__$1 = (function (){var statearr_30323 = state_30299;
(statearr_30323[(10)] = inst_30254__$1);

return statearr_30323;
})();
if(inst_30254__$1){
var statearr_30324_31413 = state_30299__$1;
(statearr_30324_31413[(1)] = (13));

} else {
var statearr_30325_31414 = state_30299__$1;
(statearr_30325_31414[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (9))){
var inst_30276 = (state_30299[(2)]);
var state_30299__$1 = state_30299;
var statearr_30326_31415 = state_30299__$1;
(statearr_30326_31415[(2)] = inst_30276);

(statearr_30326_31415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (5))){
var inst_30237 = cljs.core.deref(mults);
var inst_30238 = cljs.core.vals(inst_30237);
var inst_30239 = cljs.core.seq(inst_30238);
var inst_30240 = inst_30239;
var inst_30241 = null;
var inst_30242 = (0);
var inst_30243 = (0);
var state_30299__$1 = (function (){var statearr_30327 = state_30299;
(statearr_30327[(12)] = inst_30242);

(statearr_30327[(13)] = inst_30243);

(statearr_30327[(14)] = inst_30240);

(statearr_30327[(16)] = inst_30241);

return statearr_30327;
})();
var statearr_30328_31416 = state_30299__$1;
(statearr_30328_31416[(2)] = null);

(statearr_30328_31416[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (14))){
var state_30299__$1 = state_30299;
var statearr_30332_31417 = state_30299__$1;
(statearr_30332_31417[(2)] = null);

(statearr_30332_31417[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (16))){
var inst_30254 = (state_30299[(10)]);
var inst_30258 = cljs.core.chunk_first(inst_30254);
var inst_30259 = cljs.core.chunk_rest(inst_30254);
var inst_30260 = cljs.core.count(inst_30258);
var inst_30240 = inst_30259;
var inst_30241 = inst_30258;
var inst_30242 = inst_30260;
var inst_30243 = (0);
var state_30299__$1 = (function (){var statearr_30333 = state_30299;
(statearr_30333[(12)] = inst_30242);

(statearr_30333[(13)] = inst_30243);

(statearr_30333[(14)] = inst_30240);

(statearr_30333[(16)] = inst_30241);

return statearr_30333;
})();
var statearr_30334_31418 = state_30299__$1;
(statearr_30334_31418[(2)] = null);

(statearr_30334_31418[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (10))){
var inst_30242 = (state_30299[(12)]);
var inst_30243 = (state_30299[(13)]);
var inst_30240 = (state_30299[(14)]);
var inst_30241 = (state_30299[(16)]);
var inst_30248 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_30241,inst_30243);
var inst_30249 = cljs.core.async.muxch_STAR_(inst_30248);
var inst_30250 = cljs.core.async.close_BANG_(inst_30249);
var inst_30251 = (inst_30243 + (1));
var tmp30329 = inst_30242;
var tmp30330 = inst_30240;
var tmp30331 = inst_30241;
var inst_30240__$1 = tmp30330;
var inst_30241__$1 = tmp30331;
var inst_30242__$1 = tmp30329;
var inst_30243__$1 = inst_30251;
var state_30299__$1 = (function (){var statearr_30335 = state_30299;
(statearr_30335[(12)] = inst_30242__$1);

(statearr_30335[(13)] = inst_30243__$1);

(statearr_30335[(14)] = inst_30240__$1);

(statearr_30335[(17)] = inst_30250);

(statearr_30335[(16)] = inst_30241__$1);

return statearr_30335;
})();
var statearr_30336_31419 = state_30299__$1;
(statearr_30336_31419[(2)] = null);

(statearr_30336_31419[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (18))){
var inst_30269 = (state_30299[(2)]);
var state_30299__$1 = state_30299;
var statearr_30337_31420 = state_30299__$1;
(statearr_30337_31420[(2)] = inst_30269);

(statearr_30337_31420[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (8))){
var inst_30242 = (state_30299[(12)]);
var inst_30243 = (state_30299[(13)]);
var inst_30245 = (inst_30243 < inst_30242);
var inst_30246 = inst_30245;
var state_30299__$1 = state_30299;
if(cljs.core.truth_(inst_30246)){
var statearr_30338_31421 = state_30299__$1;
(statearr_30338_31421[(1)] = (10));

} else {
var statearr_30339_31422 = state_30299__$1;
(statearr_30339_31422[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29239__auto__ = null;
var cljs$core$async$state_machine__29239__auto____0 = (function (){
var statearr_30340 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30340[(0)] = cljs$core$async$state_machine__29239__auto__);

(statearr_30340[(1)] = (1));

return statearr_30340;
});
var cljs$core$async$state_machine__29239__auto____1 = (function (state_30299){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_30299);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e30341){var ex__29242__auto__ = e30341;
var statearr_30342_31423 = state_30299;
(statearr_30342_31423[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_30299[(4)]))){
var statearr_30343_31424 = state_30299;
(statearr_30343_31424[(1)] = cljs.core.first((state_30299[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31425 = state_30299;
state_30299 = G__31425;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$state_machine__29239__auto__ = function(state_30299){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29239__auto____1.call(this,state_30299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29239__auto____0;
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29239__auto____1;
return cljs$core$async$state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_30344 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_30344[(6)] = c__29274__auto___31394);

return statearr_30344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__30346 = arguments.length;
switch (G__30346) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__30348 = arguments.length;
switch (G__30348) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__30350 = arguments.length;
switch (G__30350) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__29274__auto___31429 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_30393){
var state_val_30394 = (state_30393[(1)]);
if((state_val_30394 === (7))){
var state_30393__$1 = state_30393;
var statearr_30395_31431 = state_30393__$1;
(statearr_30395_31431[(2)] = null);

(statearr_30395_31431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30394 === (1))){
var state_30393__$1 = state_30393;
var statearr_30396_31432 = state_30393__$1;
(statearr_30396_31432[(2)] = null);

(statearr_30396_31432[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30394 === (4))){
var inst_30353 = (state_30393[(7)]);
var inst_30354 = (state_30393[(8)]);
var inst_30356 = (inst_30354 < inst_30353);
var state_30393__$1 = state_30393;
if(cljs.core.truth_(inst_30356)){
var statearr_30397_31433 = state_30393__$1;
(statearr_30397_31433[(1)] = (6));

} else {
var statearr_30398_31434 = state_30393__$1;
(statearr_30398_31434[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30394 === (15))){
var inst_30379 = (state_30393[(9)]);
var inst_30384 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_30379);
var state_30393__$1 = state_30393;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30393__$1,(17),out,inst_30384);
} else {
if((state_val_30394 === (13))){
var inst_30379 = (state_30393[(9)]);
var inst_30379__$1 = (state_30393[(2)]);
var inst_30380 = cljs.core.some(cljs.core.nil_QMARK_,inst_30379__$1);
var state_30393__$1 = (function (){var statearr_30399 = state_30393;
(statearr_30399[(9)] = inst_30379__$1);

return statearr_30399;
})();
if(cljs.core.truth_(inst_30380)){
var statearr_30400_31438 = state_30393__$1;
(statearr_30400_31438[(1)] = (14));

} else {
var statearr_30401_31439 = state_30393__$1;
(statearr_30401_31439[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30394 === (6))){
var state_30393__$1 = state_30393;
var statearr_30402_31440 = state_30393__$1;
(statearr_30402_31440[(2)] = null);

(statearr_30402_31440[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30394 === (17))){
var inst_30386 = (state_30393[(2)]);
var state_30393__$1 = (function (){var statearr_30404 = state_30393;
(statearr_30404[(10)] = inst_30386);

return statearr_30404;
})();
var statearr_30405_31441 = state_30393__$1;
(statearr_30405_31441[(2)] = null);

(statearr_30405_31441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30394 === (3))){
var inst_30391 = (state_30393[(2)]);
var state_30393__$1 = state_30393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30393__$1,inst_30391);
} else {
if((state_val_30394 === (12))){
var _ = (function (){var statearr_30406 = state_30393;
(statearr_30406[(4)] = cljs.core.rest((state_30393[(4)])));

return statearr_30406;
})();
var state_30393__$1 = state_30393;
var ex30403 = (state_30393__$1[(2)]);
var statearr_30407_31442 = state_30393__$1;
(statearr_30407_31442[(5)] = ex30403);


if((ex30403 instanceof Object)){
var statearr_30408_31443 = state_30393__$1;
(statearr_30408_31443[(1)] = (11));

(statearr_30408_31443[(5)] = null);

} else {
throw ex30403;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30394 === (2))){
var inst_30352 = cljs.core.reset_BANG_(dctr,cnt);
var inst_30353 = cnt;
var inst_30354 = (0);
var state_30393__$1 = (function (){var statearr_30409 = state_30393;
(statearr_30409[(7)] = inst_30353);

(statearr_30409[(8)] = inst_30354);

(statearr_30409[(11)] = inst_30352);

return statearr_30409;
})();
var statearr_30410_31444 = state_30393__$1;
(statearr_30410_31444[(2)] = null);

(statearr_30410_31444[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30394 === (11))){
var inst_30358 = (state_30393[(2)]);
var inst_30359 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_30393__$1 = (function (){var statearr_30411 = state_30393;
(statearr_30411[(12)] = inst_30358);

return statearr_30411;
})();
var statearr_30412_31446 = state_30393__$1;
(statearr_30412_31446[(2)] = inst_30359);

(statearr_30412_31446[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30394 === (9))){
var inst_30354 = (state_30393[(8)]);
var _ = (function (){var statearr_30413 = state_30393;
(statearr_30413[(4)] = cljs.core.cons((12),(state_30393[(4)])));

return statearr_30413;
})();
var inst_30365 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_30354) : chs__$1.call(null,inst_30354));
var inst_30366 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_30354) : done.call(null,inst_30354));
var inst_30367 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_30365,inst_30366);
var ___$1 = (function (){var statearr_30414 = state_30393;
(statearr_30414[(4)] = cljs.core.rest((state_30393[(4)])));

return statearr_30414;
})();
var state_30393__$1 = state_30393;
var statearr_30415_31447 = state_30393__$1;
(statearr_30415_31447[(2)] = inst_30367);

(statearr_30415_31447[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30394 === (5))){
var inst_30377 = (state_30393[(2)]);
var state_30393__$1 = (function (){var statearr_30416 = state_30393;
(statearr_30416[(13)] = inst_30377);

return statearr_30416;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30393__$1,(13),dchan);
} else {
if((state_val_30394 === (14))){
var inst_30382 = cljs.core.async.close_BANG_(out);
var state_30393__$1 = state_30393;
var statearr_30417_31450 = state_30393__$1;
(statearr_30417_31450[(2)] = inst_30382);

(statearr_30417_31450[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30394 === (16))){
var inst_30389 = (state_30393[(2)]);
var state_30393__$1 = state_30393;
var statearr_30418_31452 = state_30393__$1;
(statearr_30418_31452[(2)] = inst_30389);

(statearr_30418_31452[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30394 === (10))){
var inst_30354 = (state_30393[(8)]);
var inst_30370 = (state_30393[(2)]);
var inst_30371 = (inst_30354 + (1));
var inst_30354__$1 = inst_30371;
var state_30393__$1 = (function (){var statearr_30419 = state_30393;
(statearr_30419[(14)] = inst_30370);

(statearr_30419[(8)] = inst_30354__$1);

return statearr_30419;
})();
var statearr_30420_31453 = state_30393__$1;
(statearr_30420_31453[(2)] = null);

(statearr_30420_31453[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30394 === (8))){
var inst_30375 = (state_30393[(2)]);
var state_30393__$1 = state_30393;
var statearr_30421_31454 = state_30393__$1;
(statearr_30421_31454[(2)] = inst_30375);

(statearr_30421_31454[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29239__auto__ = null;
var cljs$core$async$state_machine__29239__auto____0 = (function (){
var statearr_30422 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30422[(0)] = cljs$core$async$state_machine__29239__auto__);

(statearr_30422[(1)] = (1));

return statearr_30422;
});
var cljs$core$async$state_machine__29239__auto____1 = (function (state_30393){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_30393);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e30423){var ex__29242__auto__ = e30423;
var statearr_30424_31455 = state_30393;
(statearr_30424_31455[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_30393[(4)]))){
var statearr_30425_31457 = state_30393;
(statearr_30425_31457[(1)] = cljs.core.first((state_30393[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31458 = state_30393;
state_30393 = G__31458;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$state_machine__29239__auto__ = function(state_30393){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29239__auto____1.call(this,state_30393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29239__auto____0;
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29239__auto____1;
return cljs$core$async$state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_30426 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_30426[(6)] = c__29274__auto___31429);

return statearr_30426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__30429 = arguments.length;
switch (G__30429) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__29274__auto___31463 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_30461){
var state_val_30462 = (state_30461[(1)]);
if((state_val_30462 === (7))){
var inst_30441 = (state_30461[(7)]);
var inst_30440 = (state_30461[(8)]);
var inst_30440__$1 = (state_30461[(2)]);
var inst_30441__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30440__$1,(0),null);
var inst_30442 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30440__$1,(1),null);
var inst_30443 = (inst_30441__$1 == null);
var state_30461__$1 = (function (){var statearr_30463 = state_30461;
(statearr_30463[(7)] = inst_30441__$1);

(statearr_30463[(8)] = inst_30440__$1);

(statearr_30463[(9)] = inst_30442);

return statearr_30463;
})();
if(cljs.core.truth_(inst_30443)){
var statearr_30464_31465 = state_30461__$1;
(statearr_30464_31465[(1)] = (8));

} else {
var statearr_30465_31466 = state_30461__$1;
(statearr_30465_31466[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30462 === (1))){
var inst_30430 = cljs.core.vec(chs);
var inst_30431 = inst_30430;
var state_30461__$1 = (function (){var statearr_30466 = state_30461;
(statearr_30466[(10)] = inst_30431);

return statearr_30466;
})();
var statearr_30467_31467 = state_30461__$1;
(statearr_30467_31467[(2)] = null);

(statearr_30467_31467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30462 === (4))){
var inst_30431 = (state_30461[(10)]);
var state_30461__$1 = state_30461;
return cljs.core.async.ioc_alts_BANG_(state_30461__$1,(7),inst_30431);
} else {
if((state_val_30462 === (6))){
var inst_30457 = (state_30461[(2)]);
var state_30461__$1 = state_30461;
var statearr_30468_31471 = state_30461__$1;
(statearr_30468_31471[(2)] = inst_30457);

(statearr_30468_31471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30462 === (3))){
var inst_30459 = (state_30461[(2)]);
var state_30461__$1 = state_30461;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30461__$1,inst_30459);
} else {
if((state_val_30462 === (2))){
var inst_30431 = (state_30461[(10)]);
var inst_30433 = cljs.core.count(inst_30431);
var inst_30434 = (inst_30433 > (0));
var state_30461__$1 = state_30461;
if(cljs.core.truth_(inst_30434)){
var statearr_30470_31472 = state_30461__$1;
(statearr_30470_31472[(1)] = (4));

} else {
var statearr_30471_31473 = state_30461__$1;
(statearr_30471_31473[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30462 === (11))){
var inst_30431 = (state_30461[(10)]);
var inst_30450 = (state_30461[(2)]);
var tmp30469 = inst_30431;
var inst_30431__$1 = tmp30469;
var state_30461__$1 = (function (){var statearr_30472 = state_30461;
(statearr_30472[(10)] = inst_30431__$1);

(statearr_30472[(11)] = inst_30450);

return statearr_30472;
})();
var statearr_30473_31474 = state_30461__$1;
(statearr_30473_31474[(2)] = null);

(statearr_30473_31474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30462 === (9))){
var inst_30441 = (state_30461[(7)]);
var state_30461__$1 = state_30461;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30461__$1,(11),out,inst_30441);
} else {
if((state_val_30462 === (5))){
var inst_30455 = cljs.core.async.close_BANG_(out);
var state_30461__$1 = state_30461;
var statearr_30474_31475 = state_30461__$1;
(statearr_30474_31475[(2)] = inst_30455);

(statearr_30474_31475[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30462 === (10))){
var inst_30453 = (state_30461[(2)]);
var state_30461__$1 = state_30461;
var statearr_30475_31476 = state_30461__$1;
(statearr_30475_31476[(2)] = inst_30453);

(statearr_30475_31476[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30462 === (8))){
var inst_30441 = (state_30461[(7)]);
var inst_30440 = (state_30461[(8)]);
var inst_30431 = (state_30461[(10)]);
var inst_30442 = (state_30461[(9)]);
var inst_30445 = (function (){var cs = inst_30431;
var vec__30436 = inst_30440;
var v = inst_30441;
var c = inst_30442;
return (function (p1__30427_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__30427_SHARP_);
});
})();
var inst_30446 = cljs.core.filterv(inst_30445,inst_30431);
var inst_30431__$1 = inst_30446;
var state_30461__$1 = (function (){var statearr_30476 = state_30461;
(statearr_30476[(10)] = inst_30431__$1);

return statearr_30476;
})();
var statearr_30477_31480 = state_30461__$1;
(statearr_30477_31480[(2)] = null);

(statearr_30477_31480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29239__auto__ = null;
var cljs$core$async$state_machine__29239__auto____0 = (function (){
var statearr_30478 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30478[(0)] = cljs$core$async$state_machine__29239__auto__);

(statearr_30478[(1)] = (1));

return statearr_30478;
});
var cljs$core$async$state_machine__29239__auto____1 = (function (state_30461){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_30461);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e30479){var ex__29242__auto__ = e30479;
var statearr_30480_31481 = state_30461;
(statearr_30480_31481[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_30461[(4)]))){
var statearr_30481_31482 = state_30461;
(statearr_30481_31482[(1)] = cljs.core.first((state_30461[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31483 = state_30461;
state_30461 = G__31483;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$state_machine__29239__auto__ = function(state_30461){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29239__auto____1.call(this,state_30461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29239__auto____0;
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29239__auto____1;
return cljs$core$async$state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_30482 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_30482[(6)] = c__29274__auto___31463);

return statearr_30482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__30484 = arguments.length;
switch (G__30484) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__29274__auto___31485 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_30508){
var state_val_30509 = (state_30508[(1)]);
if((state_val_30509 === (7))){
var inst_30490 = (state_30508[(7)]);
var inst_30490__$1 = (state_30508[(2)]);
var inst_30491 = (inst_30490__$1 == null);
var inst_30492 = cljs.core.not(inst_30491);
var state_30508__$1 = (function (){var statearr_30510 = state_30508;
(statearr_30510[(7)] = inst_30490__$1);

return statearr_30510;
})();
if(inst_30492){
var statearr_30511_31486 = state_30508__$1;
(statearr_30511_31486[(1)] = (8));

} else {
var statearr_30512_31487 = state_30508__$1;
(statearr_30512_31487[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30509 === (1))){
var inst_30485 = (0);
var state_30508__$1 = (function (){var statearr_30513 = state_30508;
(statearr_30513[(8)] = inst_30485);

return statearr_30513;
})();
var statearr_30514_31488 = state_30508__$1;
(statearr_30514_31488[(2)] = null);

(statearr_30514_31488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30509 === (4))){
var state_30508__$1 = state_30508;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30508__$1,(7),ch);
} else {
if((state_val_30509 === (6))){
var inst_30503 = (state_30508[(2)]);
var state_30508__$1 = state_30508;
var statearr_30515_31489 = state_30508__$1;
(statearr_30515_31489[(2)] = inst_30503);

(statearr_30515_31489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30509 === (3))){
var inst_30505 = (state_30508[(2)]);
var inst_30506 = cljs.core.async.close_BANG_(out);
var state_30508__$1 = (function (){var statearr_30516 = state_30508;
(statearr_30516[(9)] = inst_30505);

return statearr_30516;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30508__$1,inst_30506);
} else {
if((state_val_30509 === (2))){
var inst_30485 = (state_30508[(8)]);
var inst_30487 = (inst_30485 < n);
var state_30508__$1 = state_30508;
if(cljs.core.truth_(inst_30487)){
var statearr_30517_31493 = state_30508__$1;
(statearr_30517_31493[(1)] = (4));

} else {
var statearr_30518_31494 = state_30508__$1;
(statearr_30518_31494[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30509 === (11))){
var inst_30485 = (state_30508[(8)]);
var inst_30495 = (state_30508[(2)]);
var inst_30496 = (inst_30485 + (1));
var inst_30485__$1 = inst_30496;
var state_30508__$1 = (function (){var statearr_30519 = state_30508;
(statearr_30519[(8)] = inst_30485__$1);

(statearr_30519[(10)] = inst_30495);

return statearr_30519;
})();
var statearr_30520_31495 = state_30508__$1;
(statearr_30520_31495[(2)] = null);

(statearr_30520_31495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30509 === (9))){
var state_30508__$1 = state_30508;
var statearr_30521_31496 = state_30508__$1;
(statearr_30521_31496[(2)] = null);

(statearr_30521_31496[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30509 === (5))){
var state_30508__$1 = state_30508;
var statearr_30522_31497 = state_30508__$1;
(statearr_30522_31497[(2)] = null);

(statearr_30522_31497[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30509 === (10))){
var inst_30500 = (state_30508[(2)]);
var state_30508__$1 = state_30508;
var statearr_30523_31498 = state_30508__$1;
(statearr_30523_31498[(2)] = inst_30500);

(statearr_30523_31498[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30509 === (8))){
var inst_30490 = (state_30508[(7)]);
var state_30508__$1 = state_30508;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30508__$1,(11),out,inst_30490);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29239__auto__ = null;
var cljs$core$async$state_machine__29239__auto____0 = (function (){
var statearr_30524 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30524[(0)] = cljs$core$async$state_machine__29239__auto__);

(statearr_30524[(1)] = (1));

return statearr_30524;
});
var cljs$core$async$state_machine__29239__auto____1 = (function (state_30508){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_30508);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e30525){var ex__29242__auto__ = e30525;
var statearr_30526_31499 = state_30508;
(statearr_30526_31499[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_30508[(4)]))){
var statearr_30527_31500 = state_30508;
(statearr_30527_31500[(1)] = cljs.core.first((state_30508[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31504 = state_30508;
state_30508 = G__31504;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$state_machine__29239__auto__ = function(state_30508){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29239__auto____1.call(this,state_30508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29239__auto____0;
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29239__auto____1;
return cljs$core$async$state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_30528 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_30528[(6)] = c__29274__auto___31485);

return statearr_30528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30530 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30530 = (function (f,ch,meta30531){
this.f = f;
this.ch = ch;
this.meta30531 = meta30531;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30530.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30532,meta30531__$1){
var self__ = this;
var _30532__$1 = this;
return (new cljs.core.async.t_cljs$core$async30530(self__.f,self__.ch,meta30531__$1));
}));

(cljs.core.async.t_cljs$core$async30530.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30532){
var self__ = this;
var _30532__$1 = this;
return self__.meta30531;
}));

(cljs.core.async.t_cljs$core$async30530.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30530.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30530.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30530.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30530.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30533 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30533 = (function (f,ch,meta30531,_,fn1,meta30534){
this.f = f;
this.ch = ch;
this.meta30531 = meta30531;
this._ = _;
this.fn1 = fn1;
this.meta30534 = meta30534;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30533.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30535,meta30534__$1){
var self__ = this;
var _30535__$1 = this;
return (new cljs.core.async.t_cljs$core$async30533(self__.f,self__.ch,self__.meta30531,self__._,self__.fn1,meta30534__$1));
}));

(cljs.core.async.t_cljs$core$async30533.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30535){
var self__ = this;
var _30535__$1 = this;
return self__.meta30534;
}));

(cljs.core.async.t_cljs$core$async30533.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30533.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async30533.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30533.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__30529_SHARP_){
var G__30536 = (((p1__30529_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__30529_SHARP_) : self__.f.call(null,p1__30529_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__30536) : f1.call(null,G__30536));
});
}));

(cljs.core.async.t_cljs$core$async30533.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30531","meta30531",1732011096,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async30530","cljs.core.async/t_cljs$core$async30530",-1864579953,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta30534","meta30534",796447015,null)], null);
}));

(cljs.core.async.t_cljs$core$async30533.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30533.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30533");

(cljs.core.async.t_cljs$core$async30533.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async30533");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30533.
 */
cljs.core.async.__GT_t_cljs$core$async30533 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30533(f__$1,ch__$1,meta30531__$1,___$2,fn1__$1,meta30534){
return (new cljs.core.async.t_cljs$core$async30533(f__$1,ch__$1,meta30531__$1,___$2,fn1__$1,meta30534));
});

}

return (new cljs.core.async.t_cljs$core$async30533(self__.f,self__.ch,self__.meta30531,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4174__auto__ = ret;
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4174__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__30537 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__30537) : self__.f.call(null,G__30537));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async30530.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30530.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async30530.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30531","meta30531",1732011096,null)], null);
}));

(cljs.core.async.t_cljs$core$async30530.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30530.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30530");

(cljs.core.async.t_cljs$core$async30530.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async30530");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30530.
 */
cljs.core.async.__GT_t_cljs$core$async30530 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30530(f__$1,ch__$1,meta30531){
return (new cljs.core.async.t_cljs$core$async30530(f__$1,ch__$1,meta30531));
});

}

return (new cljs.core.async.t_cljs$core$async30530(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30538 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30538 = (function (f,ch,meta30539){
this.f = f;
this.ch = ch;
this.meta30539 = meta30539;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30538.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30540,meta30539__$1){
var self__ = this;
var _30540__$1 = this;
return (new cljs.core.async.t_cljs$core$async30538(self__.f,self__.ch,meta30539__$1));
}));

(cljs.core.async.t_cljs$core$async30538.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30540){
var self__ = this;
var _30540__$1 = this;
return self__.meta30539;
}));

(cljs.core.async.t_cljs$core$async30538.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30538.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30538.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30538.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30538.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30538.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async30538.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30539","meta30539",-1836847384,null)], null);
}));

(cljs.core.async.t_cljs$core$async30538.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30538.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30538");

(cljs.core.async.t_cljs$core$async30538.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async30538");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30538.
 */
cljs.core.async.__GT_t_cljs$core$async30538 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async30538(f__$1,ch__$1,meta30539){
return (new cljs.core.async.t_cljs$core$async30538(f__$1,ch__$1,meta30539));
});

}

return (new cljs.core.async.t_cljs$core$async30538(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30541 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30541 = (function (p,ch,meta30542){
this.p = p;
this.ch = ch;
this.meta30542 = meta30542;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30541.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30543,meta30542__$1){
var self__ = this;
var _30543__$1 = this;
return (new cljs.core.async.t_cljs$core$async30541(self__.p,self__.ch,meta30542__$1));
}));

(cljs.core.async.t_cljs$core$async30541.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30543){
var self__ = this;
var _30543__$1 = this;
return self__.meta30542;
}));

(cljs.core.async.t_cljs$core$async30541.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30541.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30541.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30541.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30541.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30541.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30541.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async30541.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30542","meta30542",20819333,null)], null);
}));

(cljs.core.async.t_cljs$core$async30541.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30541.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30541");

(cljs.core.async.t_cljs$core$async30541.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async30541");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30541.
 */
cljs.core.async.__GT_t_cljs$core$async30541 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async30541(p__$1,ch__$1,meta30542){
return (new cljs.core.async.t_cljs$core$async30541(p__$1,ch__$1,meta30542));
});

}

return (new cljs.core.async.t_cljs$core$async30541(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__30545 = arguments.length;
switch (G__30545) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__29274__auto___31509 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_30566){
var state_val_30567 = (state_30566[(1)]);
if((state_val_30567 === (7))){
var inst_30562 = (state_30566[(2)]);
var state_30566__$1 = state_30566;
var statearr_30568_31510 = state_30566__$1;
(statearr_30568_31510[(2)] = inst_30562);

(statearr_30568_31510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30567 === (1))){
var state_30566__$1 = state_30566;
var statearr_30569_31511 = state_30566__$1;
(statearr_30569_31511[(2)] = null);

(statearr_30569_31511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30567 === (4))){
var inst_30548 = (state_30566[(7)]);
var inst_30548__$1 = (state_30566[(2)]);
var inst_30549 = (inst_30548__$1 == null);
var state_30566__$1 = (function (){var statearr_30570 = state_30566;
(statearr_30570[(7)] = inst_30548__$1);

return statearr_30570;
})();
if(cljs.core.truth_(inst_30549)){
var statearr_30571_31512 = state_30566__$1;
(statearr_30571_31512[(1)] = (5));

} else {
var statearr_30572_31513 = state_30566__$1;
(statearr_30572_31513[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30567 === (6))){
var inst_30548 = (state_30566[(7)]);
var inst_30553 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30548) : p.call(null,inst_30548));
var state_30566__$1 = state_30566;
if(cljs.core.truth_(inst_30553)){
var statearr_30573_31514 = state_30566__$1;
(statearr_30573_31514[(1)] = (8));

} else {
var statearr_30574_31515 = state_30566__$1;
(statearr_30574_31515[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30567 === (3))){
var inst_30564 = (state_30566[(2)]);
var state_30566__$1 = state_30566;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30566__$1,inst_30564);
} else {
if((state_val_30567 === (2))){
var state_30566__$1 = state_30566;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30566__$1,(4),ch);
} else {
if((state_val_30567 === (11))){
var inst_30556 = (state_30566[(2)]);
var state_30566__$1 = state_30566;
var statearr_30575_31516 = state_30566__$1;
(statearr_30575_31516[(2)] = inst_30556);

(statearr_30575_31516[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30567 === (9))){
var state_30566__$1 = state_30566;
var statearr_30576_31517 = state_30566__$1;
(statearr_30576_31517[(2)] = null);

(statearr_30576_31517[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30567 === (5))){
var inst_30551 = cljs.core.async.close_BANG_(out);
var state_30566__$1 = state_30566;
var statearr_30577_31518 = state_30566__$1;
(statearr_30577_31518[(2)] = inst_30551);

(statearr_30577_31518[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30567 === (10))){
var inst_30559 = (state_30566[(2)]);
var state_30566__$1 = (function (){var statearr_30578 = state_30566;
(statearr_30578[(8)] = inst_30559);

return statearr_30578;
})();
var statearr_30579_31519 = state_30566__$1;
(statearr_30579_31519[(2)] = null);

(statearr_30579_31519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30567 === (8))){
var inst_30548 = (state_30566[(7)]);
var state_30566__$1 = state_30566;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30566__$1,(11),out,inst_30548);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29239__auto__ = null;
var cljs$core$async$state_machine__29239__auto____0 = (function (){
var statearr_30580 = [null,null,null,null,null,null,null,null,null];
(statearr_30580[(0)] = cljs$core$async$state_machine__29239__auto__);

(statearr_30580[(1)] = (1));

return statearr_30580;
});
var cljs$core$async$state_machine__29239__auto____1 = (function (state_30566){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_30566);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e30581){var ex__29242__auto__ = e30581;
var statearr_30582_31520 = state_30566;
(statearr_30582_31520[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_30566[(4)]))){
var statearr_30583_31521 = state_30566;
(statearr_30583_31521[(1)] = cljs.core.first((state_30566[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31522 = state_30566;
state_30566 = G__31522;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$state_machine__29239__auto__ = function(state_30566){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29239__auto____1.call(this,state_30566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29239__auto____0;
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29239__auto____1;
return cljs$core$async$state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_30584 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_30584[(6)] = c__29274__auto___31509);

return statearr_30584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__30586 = arguments.length;
switch (G__30586) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__29274__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_30648){
var state_val_30649 = (state_30648[(1)]);
if((state_val_30649 === (7))){
var inst_30644 = (state_30648[(2)]);
var state_30648__$1 = state_30648;
var statearr_30650_31524 = state_30648__$1;
(statearr_30650_31524[(2)] = inst_30644);

(statearr_30650_31524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (20))){
var inst_30614 = (state_30648[(7)]);
var inst_30625 = (state_30648[(2)]);
var inst_30626 = cljs.core.next(inst_30614);
var inst_30600 = inst_30626;
var inst_30601 = null;
var inst_30602 = (0);
var inst_30603 = (0);
var state_30648__$1 = (function (){var statearr_30651 = state_30648;
(statearr_30651[(8)] = inst_30601);

(statearr_30651[(9)] = inst_30602);

(statearr_30651[(10)] = inst_30625);

(statearr_30651[(11)] = inst_30603);

(statearr_30651[(12)] = inst_30600);

return statearr_30651;
})();
var statearr_30652_31525 = state_30648__$1;
(statearr_30652_31525[(2)] = null);

(statearr_30652_31525[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (1))){
var state_30648__$1 = state_30648;
var statearr_30653_31526 = state_30648__$1;
(statearr_30653_31526[(2)] = null);

(statearr_30653_31526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (4))){
var inst_30589 = (state_30648[(13)]);
var inst_30589__$1 = (state_30648[(2)]);
var inst_30590 = (inst_30589__$1 == null);
var state_30648__$1 = (function (){var statearr_30654 = state_30648;
(statearr_30654[(13)] = inst_30589__$1);

return statearr_30654;
})();
if(cljs.core.truth_(inst_30590)){
var statearr_30655_31527 = state_30648__$1;
(statearr_30655_31527[(1)] = (5));

} else {
var statearr_30656_31528 = state_30648__$1;
(statearr_30656_31528[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (15))){
var state_30648__$1 = state_30648;
var statearr_30660_31529 = state_30648__$1;
(statearr_30660_31529[(2)] = null);

(statearr_30660_31529[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (21))){
var state_30648__$1 = state_30648;
var statearr_30661_31530 = state_30648__$1;
(statearr_30661_31530[(2)] = null);

(statearr_30661_31530[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (13))){
var inst_30601 = (state_30648[(8)]);
var inst_30602 = (state_30648[(9)]);
var inst_30603 = (state_30648[(11)]);
var inst_30600 = (state_30648[(12)]);
var inst_30610 = (state_30648[(2)]);
var inst_30611 = (inst_30603 + (1));
var tmp30657 = inst_30601;
var tmp30658 = inst_30602;
var tmp30659 = inst_30600;
var inst_30600__$1 = tmp30659;
var inst_30601__$1 = tmp30657;
var inst_30602__$1 = tmp30658;
var inst_30603__$1 = inst_30611;
var state_30648__$1 = (function (){var statearr_30662 = state_30648;
(statearr_30662[(8)] = inst_30601__$1);

(statearr_30662[(9)] = inst_30602__$1);

(statearr_30662[(14)] = inst_30610);

(statearr_30662[(11)] = inst_30603__$1);

(statearr_30662[(12)] = inst_30600__$1);

return statearr_30662;
})();
var statearr_30663_31531 = state_30648__$1;
(statearr_30663_31531[(2)] = null);

(statearr_30663_31531[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (22))){
var state_30648__$1 = state_30648;
var statearr_30664_31532 = state_30648__$1;
(statearr_30664_31532[(2)] = null);

(statearr_30664_31532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (6))){
var inst_30589 = (state_30648[(13)]);
var inst_30598 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_30589) : f.call(null,inst_30589));
var inst_30599 = cljs.core.seq(inst_30598);
var inst_30600 = inst_30599;
var inst_30601 = null;
var inst_30602 = (0);
var inst_30603 = (0);
var state_30648__$1 = (function (){var statearr_30665 = state_30648;
(statearr_30665[(8)] = inst_30601);

(statearr_30665[(9)] = inst_30602);

(statearr_30665[(11)] = inst_30603);

(statearr_30665[(12)] = inst_30600);

return statearr_30665;
})();
var statearr_30666_31533 = state_30648__$1;
(statearr_30666_31533[(2)] = null);

(statearr_30666_31533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (17))){
var inst_30614 = (state_30648[(7)]);
var inst_30618 = cljs.core.chunk_first(inst_30614);
var inst_30619 = cljs.core.chunk_rest(inst_30614);
var inst_30620 = cljs.core.count(inst_30618);
var inst_30600 = inst_30619;
var inst_30601 = inst_30618;
var inst_30602 = inst_30620;
var inst_30603 = (0);
var state_30648__$1 = (function (){var statearr_30667 = state_30648;
(statearr_30667[(8)] = inst_30601);

(statearr_30667[(9)] = inst_30602);

(statearr_30667[(11)] = inst_30603);

(statearr_30667[(12)] = inst_30600);

return statearr_30667;
})();
var statearr_30668_31534 = state_30648__$1;
(statearr_30668_31534[(2)] = null);

(statearr_30668_31534[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (3))){
var inst_30646 = (state_30648[(2)]);
var state_30648__$1 = state_30648;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30648__$1,inst_30646);
} else {
if((state_val_30649 === (12))){
var inst_30634 = (state_30648[(2)]);
var state_30648__$1 = state_30648;
var statearr_30669_31535 = state_30648__$1;
(statearr_30669_31535[(2)] = inst_30634);

(statearr_30669_31535[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (2))){
var state_30648__$1 = state_30648;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30648__$1,(4),in$);
} else {
if((state_val_30649 === (23))){
var inst_30642 = (state_30648[(2)]);
var state_30648__$1 = state_30648;
var statearr_30670_31536 = state_30648__$1;
(statearr_30670_31536[(2)] = inst_30642);

(statearr_30670_31536[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (19))){
var inst_30629 = (state_30648[(2)]);
var state_30648__$1 = state_30648;
var statearr_30671_31538 = state_30648__$1;
(statearr_30671_31538[(2)] = inst_30629);

(statearr_30671_31538[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (11))){
var inst_30614 = (state_30648[(7)]);
var inst_30600 = (state_30648[(12)]);
var inst_30614__$1 = cljs.core.seq(inst_30600);
var state_30648__$1 = (function (){var statearr_30672 = state_30648;
(statearr_30672[(7)] = inst_30614__$1);

return statearr_30672;
})();
if(inst_30614__$1){
var statearr_30673_31542 = state_30648__$1;
(statearr_30673_31542[(1)] = (14));

} else {
var statearr_30674_31543 = state_30648__$1;
(statearr_30674_31543[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (9))){
var inst_30636 = (state_30648[(2)]);
var inst_30637 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_30648__$1 = (function (){var statearr_30675 = state_30648;
(statearr_30675[(15)] = inst_30636);

return statearr_30675;
})();
if(cljs.core.truth_(inst_30637)){
var statearr_30676_31544 = state_30648__$1;
(statearr_30676_31544[(1)] = (21));

} else {
var statearr_30677_31545 = state_30648__$1;
(statearr_30677_31545[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (5))){
var inst_30592 = cljs.core.async.close_BANG_(out);
var state_30648__$1 = state_30648;
var statearr_30678_31546 = state_30648__$1;
(statearr_30678_31546[(2)] = inst_30592);

(statearr_30678_31546[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (14))){
var inst_30614 = (state_30648[(7)]);
var inst_30616 = cljs.core.chunked_seq_QMARK_(inst_30614);
var state_30648__$1 = state_30648;
if(inst_30616){
var statearr_30679_31547 = state_30648__$1;
(statearr_30679_31547[(1)] = (17));

} else {
var statearr_30680_31548 = state_30648__$1;
(statearr_30680_31548[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (16))){
var inst_30632 = (state_30648[(2)]);
var state_30648__$1 = state_30648;
var statearr_30681_31549 = state_30648__$1;
(statearr_30681_31549[(2)] = inst_30632);

(statearr_30681_31549[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (10))){
var inst_30601 = (state_30648[(8)]);
var inst_30603 = (state_30648[(11)]);
var inst_30608 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_30601,inst_30603);
var state_30648__$1 = state_30648;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30648__$1,(13),out,inst_30608);
} else {
if((state_val_30649 === (18))){
var inst_30614 = (state_30648[(7)]);
var inst_30623 = cljs.core.first(inst_30614);
var state_30648__$1 = state_30648;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30648__$1,(20),out,inst_30623);
} else {
if((state_val_30649 === (8))){
var inst_30602 = (state_30648[(9)]);
var inst_30603 = (state_30648[(11)]);
var inst_30605 = (inst_30603 < inst_30602);
var inst_30606 = inst_30605;
var state_30648__$1 = state_30648;
if(cljs.core.truth_(inst_30606)){
var statearr_30682_31550 = state_30648__$1;
(statearr_30682_31550[(1)] = (10));

} else {
var statearr_30683_31551 = state_30648__$1;
(statearr_30683_31551[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__29239__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__29239__auto____0 = (function (){
var statearr_30684 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30684[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__29239__auto__);

(statearr_30684[(1)] = (1));

return statearr_30684;
});
var cljs$core$async$mapcat_STAR__$_state_machine__29239__auto____1 = (function (state_30648){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_30648);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e30685){var ex__29242__auto__ = e30685;
var statearr_30686_31552 = state_30648;
(statearr_30686_31552[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_30648[(4)]))){
var statearr_30687_31553 = state_30648;
(statearr_30687_31553[(1)] = cljs.core.first((state_30648[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31554 = state_30648;
state_30648 = G__31554;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__29239__auto__ = function(state_30648){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__29239__auto____1.call(this,state_30648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__29239__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__29239__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_30688 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_30688[(6)] = c__29274__auto__);

return statearr_30688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));

return c__29274__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__30690 = arguments.length;
switch (G__30690) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__30692 = arguments.length;
switch (G__30692) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__30694 = arguments.length;
switch (G__30694) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__29274__auto___31558 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_30718){
var state_val_30719 = (state_30718[(1)]);
if((state_val_30719 === (7))){
var inst_30713 = (state_30718[(2)]);
var state_30718__$1 = state_30718;
var statearr_30720_31559 = state_30718__$1;
(statearr_30720_31559[(2)] = inst_30713);

(statearr_30720_31559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (1))){
var inst_30695 = null;
var state_30718__$1 = (function (){var statearr_30721 = state_30718;
(statearr_30721[(7)] = inst_30695);

return statearr_30721;
})();
var statearr_30722_31560 = state_30718__$1;
(statearr_30722_31560[(2)] = null);

(statearr_30722_31560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (4))){
var inst_30698 = (state_30718[(8)]);
var inst_30698__$1 = (state_30718[(2)]);
var inst_30699 = (inst_30698__$1 == null);
var inst_30700 = cljs.core.not(inst_30699);
var state_30718__$1 = (function (){var statearr_30723 = state_30718;
(statearr_30723[(8)] = inst_30698__$1);

return statearr_30723;
})();
if(inst_30700){
var statearr_30724_31561 = state_30718__$1;
(statearr_30724_31561[(1)] = (5));

} else {
var statearr_30725_31562 = state_30718__$1;
(statearr_30725_31562[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (6))){
var state_30718__$1 = state_30718;
var statearr_30726_31563 = state_30718__$1;
(statearr_30726_31563[(2)] = null);

(statearr_30726_31563[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (3))){
var inst_30715 = (state_30718[(2)]);
var inst_30716 = cljs.core.async.close_BANG_(out);
var state_30718__$1 = (function (){var statearr_30727 = state_30718;
(statearr_30727[(9)] = inst_30715);

return statearr_30727;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30718__$1,inst_30716);
} else {
if((state_val_30719 === (2))){
var state_30718__$1 = state_30718;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30718__$1,(4),ch);
} else {
if((state_val_30719 === (11))){
var inst_30698 = (state_30718[(8)]);
var inst_30707 = (state_30718[(2)]);
var inst_30695 = inst_30698;
var state_30718__$1 = (function (){var statearr_30728 = state_30718;
(statearr_30728[(10)] = inst_30707);

(statearr_30728[(7)] = inst_30695);

return statearr_30728;
})();
var statearr_30729_31564 = state_30718__$1;
(statearr_30729_31564[(2)] = null);

(statearr_30729_31564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (9))){
var inst_30698 = (state_30718[(8)]);
var state_30718__$1 = state_30718;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30718__$1,(11),out,inst_30698);
} else {
if((state_val_30719 === (5))){
var inst_30698 = (state_30718[(8)]);
var inst_30695 = (state_30718[(7)]);
var inst_30702 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30698,inst_30695);
var state_30718__$1 = state_30718;
if(inst_30702){
var statearr_30731_31566 = state_30718__$1;
(statearr_30731_31566[(1)] = (8));

} else {
var statearr_30732_31567 = state_30718__$1;
(statearr_30732_31567[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (10))){
var inst_30710 = (state_30718[(2)]);
var state_30718__$1 = state_30718;
var statearr_30733_31568 = state_30718__$1;
(statearr_30733_31568[(2)] = inst_30710);

(statearr_30733_31568[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (8))){
var inst_30695 = (state_30718[(7)]);
var tmp30730 = inst_30695;
var inst_30695__$1 = tmp30730;
var state_30718__$1 = (function (){var statearr_30734 = state_30718;
(statearr_30734[(7)] = inst_30695__$1);

return statearr_30734;
})();
var statearr_30735_31569 = state_30718__$1;
(statearr_30735_31569[(2)] = null);

(statearr_30735_31569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29239__auto__ = null;
var cljs$core$async$state_machine__29239__auto____0 = (function (){
var statearr_30736 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30736[(0)] = cljs$core$async$state_machine__29239__auto__);

(statearr_30736[(1)] = (1));

return statearr_30736;
});
var cljs$core$async$state_machine__29239__auto____1 = (function (state_30718){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_30718);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e30737){var ex__29242__auto__ = e30737;
var statearr_30738_31573 = state_30718;
(statearr_30738_31573[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_30718[(4)]))){
var statearr_30739_31574 = state_30718;
(statearr_30739_31574[(1)] = cljs.core.first((state_30718[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31575 = state_30718;
state_30718 = G__31575;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$state_machine__29239__auto__ = function(state_30718){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29239__auto____1.call(this,state_30718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29239__auto____0;
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29239__auto____1;
return cljs$core$async$state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_30740 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_30740[(6)] = c__29274__auto___31558);

return statearr_30740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__30742 = arguments.length;
switch (G__30742) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__29274__auto___31580 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_30780){
var state_val_30781 = (state_30780[(1)]);
if((state_val_30781 === (7))){
var inst_30776 = (state_30780[(2)]);
var state_30780__$1 = state_30780;
var statearr_30782_31581 = state_30780__$1;
(statearr_30782_31581[(2)] = inst_30776);

(statearr_30782_31581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30781 === (1))){
var inst_30743 = (new Array(n));
var inst_30744 = inst_30743;
var inst_30745 = (0);
var state_30780__$1 = (function (){var statearr_30783 = state_30780;
(statearr_30783[(7)] = inst_30745);

(statearr_30783[(8)] = inst_30744);

return statearr_30783;
})();
var statearr_30784_31582 = state_30780__$1;
(statearr_30784_31582[(2)] = null);

(statearr_30784_31582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30781 === (4))){
var inst_30748 = (state_30780[(9)]);
var inst_30748__$1 = (state_30780[(2)]);
var inst_30749 = (inst_30748__$1 == null);
var inst_30750 = cljs.core.not(inst_30749);
var state_30780__$1 = (function (){var statearr_30785 = state_30780;
(statearr_30785[(9)] = inst_30748__$1);

return statearr_30785;
})();
if(inst_30750){
var statearr_30786_31583 = state_30780__$1;
(statearr_30786_31583[(1)] = (5));

} else {
var statearr_30787_31584 = state_30780__$1;
(statearr_30787_31584[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30781 === (15))){
var inst_30770 = (state_30780[(2)]);
var state_30780__$1 = state_30780;
var statearr_30788_31585 = state_30780__$1;
(statearr_30788_31585[(2)] = inst_30770);

(statearr_30788_31585[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30781 === (13))){
var state_30780__$1 = state_30780;
var statearr_30789_31586 = state_30780__$1;
(statearr_30789_31586[(2)] = null);

(statearr_30789_31586[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30781 === (6))){
var inst_30745 = (state_30780[(7)]);
var inst_30766 = (inst_30745 > (0));
var state_30780__$1 = state_30780;
if(cljs.core.truth_(inst_30766)){
var statearr_30790_31587 = state_30780__$1;
(statearr_30790_31587[(1)] = (12));

} else {
var statearr_30791_31588 = state_30780__$1;
(statearr_30791_31588[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30781 === (3))){
var inst_30778 = (state_30780[(2)]);
var state_30780__$1 = state_30780;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30780__$1,inst_30778);
} else {
if((state_val_30781 === (12))){
var inst_30744 = (state_30780[(8)]);
var inst_30768 = cljs.core.vec(inst_30744);
var state_30780__$1 = state_30780;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30780__$1,(15),out,inst_30768);
} else {
if((state_val_30781 === (2))){
var state_30780__$1 = state_30780;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30780__$1,(4),ch);
} else {
if((state_val_30781 === (11))){
var inst_30760 = (state_30780[(2)]);
var inst_30761 = (new Array(n));
var inst_30744 = inst_30761;
var inst_30745 = (0);
var state_30780__$1 = (function (){var statearr_30792 = state_30780;
(statearr_30792[(7)] = inst_30745);

(statearr_30792[(10)] = inst_30760);

(statearr_30792[(8)] = inst_30744);

return statearr_30792;
})();
var statearr_30793_31589 = state_30780__$1;
(statearr_30793_31589[(2)] = null);

(statearr_30793_31589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30781 === (9))){
var inst_30744 = (state_30780[(8)]);
var inst_30758 = cljs.core.vec(inst_30744);
var state_30780__$1 = state_30780;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30780__$1,(11),out,inst_30758);
} else {
if((state_val_30781 === (5))){
var inst_30753 = (state_30780[(11)]);
var inst_30745 = (state_30780[(7)]);
var inst_30748 = (state_30780[(9)]);
var inst_30744 = (state_30780[(8)]);
var inst_30752 = (inst_30744[inst_30745] = inst_30748);
var inst_30753__$1 = (inst_30745 + (1));
var inst_30754 = (inst_30753__$1 < n);
var state_30780__$1 = (function (){var statearr_30794 = state_30780;
(statearr_30794[(11)] = inst_30753__$1);

(statearr_30794[(12)] = inst_30752);

return statearr_30794;
})();
if(cljs.core.truth_(inst_30754)){
var statearr_30795_31590 = state_30780__$1;
(statearr_30795_31590[(1)] = (8));

} else {
var statearr_30796_31591 = state_30780__$1;
(statearr_30796_31591[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30781 === (14))){
var inst_30773 = (state_30780[(2)]);
var inst_30774 = cljs.core.async.close_BANG_(out);
var state_30780__$1 = (function (){var statearr_30798 = state_30780;
(statearr_30798[(13)] = inst_30773);

return statearr_30798;
})();
var statearr_30799_31592 = state_30780__$1;
(statearr_30799_31592[(2)] = inst_30774);

(statearr_30799_31592[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30781 === (10))){
var inst_30764 = (state_30780[(2)]);
var state_30780__$1 = state_30780;
var statearr_30800_31593 = state_30780__$1;
(statearr_30800_31593[(2)] = inst_30764);

(statearr_30800_31593[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30781 === (8))){
var inst_30753 = (state_30780[(11)]);
var inst_30744 = (state_30780[(8)]);
var tmp30797 = inst_30744;
var inst_30744__$1 = tmp30797;
var inst_30745 = inst_30753;
var state_30780__$1 = (function (){var statearr_30801 = state_30780;
(statearr_30801[(7)] = inst_30745);

(statearr_30801[(8)] = inst_30744__$1);

return statearr_30801;
})();
var statearr_30802_31594 = state_30780__$1;
(statearr_30802_31594[(2)] = null);

(statearr_30802_31594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29239__auto__ = null;
var cljs$core$async$state_machine__29239__auto____0 = (function (){
var statearr_30803 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30803[(0)] = cljs$core$async$state_machine__29239__auto__);

(statearr_30803[(1)] = (1));

return statearr_30803;
});
var cljs$core$async$state_machine__29239__auto____1 = (function (state_30780){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_30780);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e30804){var ex__29242__auto__ = e30804;
var statearr_30805_31595 = state_30780;
(statearr_30805_31595[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_30780[(4)]))){
var statearr_30806_31596 = state_30780;
(statearr_30806_31596[(1)] = cljs.core.first((state_30780[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31597 = state_30780;
state_30780 = G__31597;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$state_machine__29239__auto__ = function(state_30780){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29239__auto____1.call(this,state_30780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29239__auto____0;
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29239__auto____1;
return cljs$core$async$state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_30807 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_30807[(6)] = c__29274__auto___31580);

return statearr_30807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__30809 = arguments.length;
switch (G__30809) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__29274__auto___31599 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_30851){
var state_val_30852 = (state_30851[(1)]);
if((state_val_30852 === (7))){
var inst_30847 = (state_30851[(2)]);
var state_30851__$1 = state_30851;
var statearr_30853_31600 = state_30851__$1;
(statearr_30853_31600[(2)] = inst_30847);

(statearr_30853_31600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30852 === (1))){
var inst_30810 = [];
var inst_30811 = inst_30810;
var inst_30812 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_30851__$1 = (function (){var statearr_30854 = state_30851;
(statearr_30854[(7)] = inst_30812);

(statearr_30854[(8)] = inst_30811);

return statearr_30854;
})();
var statearr_30855_31601 = state_30851__$1;
(statearr_30855_31601[(2)] = null);

(statearr_30855_31601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30852 === (4))){
var inst_30815 = (state_30851[(9)]);
var inst_30815__$1 = (state_30851[(2)]);
var inst_30816 = (inst_30815__$1 == null);
var inst_30817 = cljs.core.not(inst_30816);
var state_30851__$1 = (function (){var statearr_30856 = state_30851;
(statearr_30856[(9)] = inst_30815__$1);

return statearr_30856;
})();
if(inst_30817){
var statearr_30857_31602 = state_30851__$1;
(statearr_30857_31602[(1)] = (5));

} else {
var statearr_30858_31604 = state_30851__$1;
(statearr_30858_31604[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30852 === (15))){
var inst_30841 = (state_30851[(2)]);
var state_30851__$1 = state_30851;
var statearr_30859_31607 = state_30851__$1;
(statearr_30859_31607[(2)] = inst_30841);

(statearr_30859_31607[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30852 === (13))){
var state_30851__$1 = state_30851;
var statearr_30860_31608 = state_30851__$1;
(statearr_30860_31608[(2)] = null);

(statearr_30860_31608[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30852 === (6))){
var inst_30811 = (state_30851[(8)]);
var inst_30836 = inst_30811.length;
var inst_30837 = (inst_30836 > (0));
var state_30851__$1 = state_30851;
if(cljs.core.truth_(inst_30837)){
var statearr_30861_31609 = state_30851__$1;
(statearr_30861_31609[(1)] = (12));

} else {
var statearr_30862_31610 = state_30851__$1;
(statearr_30862_31610[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30852 === (3))){
var inst_30849 = (state_30851[(2)]);
var state_30851__$1 = state_30851;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30851__$1,inst_30849);
} else {
if((state_val_30852 === (12))){
var inst_30811 = (state_30851[(8)]);
var inst_30839 = cljs.core.vec(inst_30811);
var state_30851__$1 = state_30851;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30851__$1,(15),out,inst_30839);
} else {
if((state_val_30852 === (2))){
var state_30851__$1 = state_30851;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30851__$1,(4),ch);
} else {
if((state_val_30852 === (11))){
var inst_30819 = (state_30851[(10)]);
var inst_30815 = (state_30851[(9)]);
var inst_30829 = (state_30851[(2)]);
var inst_30830 = [];
var inst_30831 = inst_30830.push(inst_30815);
var inst_30811 = inst_30830;
var inst_30812 = inst_30819;
var state_30851__$1 = (function (){var statearr_30863 = state_30851;
(statearr_30863[(11)] = inst_30829);

(statearr_30863[(7)] = inst_30812);

(statearr_30863[(12)] = inst_30831);

(statearr_30863[(8)] = inst_30811);

return statearr_30863;
})();
var statearr_30864_31612 = state_30851__$1;
(statearr_30864_31612[(2)] = null);

(statearr_30864_31612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30852 === (9))){
var inst_30811 = (state_30851[(8)]);
var inst_30827 = cljs.core.vec(inst_30811);
var state_30851__$1 = state_30851;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30851__$1,(11),out,inst_30827);
} else {
if((state_val_30852 === (5))){
var inst_30812 = (state_30851[(7)]);
var inst_30819 = (state_30851[(10)]);
var inst_30815 = (state_30851[(9)]);
var inst_30819__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_30815) : f.call(null,inst_30815));
var inst_30820 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30819__$1,inst_30812);
var inst_30821 = cljs.core.keyword_identical_QMARK_(inst_30812,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_30822 = ((inst_30820) || (inst_30821));
var state_30851__$1 = (function (){var statearr_30865 = state_30851;
(statearr_30865[(10)] = inst_30819__$1);

return statearr_30865;
})();
if(cljs.core.truth_(inst_30822)){
var statearr_30866_31613 = state_30851__$1;
(statearr_30866_31613[(1)] = (8));

} else {
var statearr_30867_31614 = state_30851__$1;
(statearr_30867_31614[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30852 === (14))){
var inst_30844 = (state_30851[(2)]);
var inst_30845 = cljs.core.async.close_BANG_(out);
var state_30851__$1 = (function (){var statearr_30869 = state_30851;
(statearr_30869[(13)] = inst_30844);

return statearr_30869;
})();
var statearr_30870_31615 = state_30851__$1;
(statearr_30870_31615[(2)] = inst_30845);

(statearr_30870_31615[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30852 === (10))){
var inst_30834 = (state_30851[(2)]);
var state_30851__$1 = state_30851;
var statearr_30871_31616 = state_30851__$1;
(statearr_30871_31616[(2)] = inst_30834);

(statearr_30871_31616[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30852 === (8))){
var inst_30819 = (state_30851[(10)]);
var inst_30815 = (state_30851[(9)]);
var inst_30811 = (state_30851[(8)]);
var inst_30824 = inst_30811.push(inst_30815);
var tmp30868 = inst_30811;
var inst_30811__$1 = tmp30868;
var inst_30812 = inst_30819;
var state_30851__$1 = (function (){var statearr_30872 = state_30851;
(statearr_30872[(7)] = inst_30812);

(statearr_30872[(14)] = inst_30824);

(statearr_30872[(8)] = inst_30811__$1);

return statearr_30872;
})();
var statearr_30873_31617 = state_30851__$1;
(statearr_30873_31617[(2)] = null);

(statearr_30873_31617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29239__auto__ = null;
var cljs$core$async$state_machine__29239__auto____0 = (function (){
var statearr_30874 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30874[(0)] = cljs$core$async$state_machine__29239__auto__);

(statearr_30874[(1)] = (1));

return statearr_30874;
});
var cljs$core$async$state_machine__29239__auto____1 = (function (state_30851){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_30851);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e30875){var ex__29242__auto__ = e30875;
var statearr_30876_31618 = state_30851;
(statearr_30876_31618[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_30851[(4)]))){
var statearr_30877_31619 = state_30851;
(statearr_30877_31619[(1)] = cljs.core.first((state_30851[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31620 = state_30851;
state_30851 = G__31620;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
cljs$core$async$state_machine__29239__auto__ = function(state_30851){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29239__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29239__auto____1.call(this,state_30851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29239__auto____0;
cljs$core$async$state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29239__auto____1;
return cljs$core$async$state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_30878 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_30878[(6)] = c__29274__auto___31599);

return statearr_30878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
