goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__38977){
var vec__38978 = p__38977;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38978,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38978,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__38981 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38981,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__38984 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38984,(4),null);
var vec__38987 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38987,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__38990 = segmap;
var map__38990__$1 = (((((!((map__38990 == null))))?(((((map__38990.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38990.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38990):map__38990);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38990__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38990__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38990__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38990__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38990__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__38997 = arguments.length;
switch (G__38997) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__39001 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__39941 = cljs.core.next(segs__$1);
var G__39942 = nrelseg;
var G__39943 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__39941;
relseg__$1 = G__39942;
result__$1 = G__39943;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39001,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39001,(1),null);
var G__39944 = (gline + (1));
var G__39945 = cljs.core.next(lines__$1);
var G__39946 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__39947 = result__$1;
gline = G__39944;
lines__$1 = G__39945;
relseg = G__39946;
result = G__39947;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__39007 = segmap;
var map__39007__$1 = (((((!((map__39007 == null))))?(((((map__39007.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39007.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39007):map__39007);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39007__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39007__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39007__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39007__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39007__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__39004_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__39004_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__39015 = arguments.length;
switch (G__39015) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__39028 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__39949 = cljs.core.next(segs__$1);
var G__39950 = nrelseg;
var G__39951 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__39949;
relseg__$1 = G__39950;
result__$1 = G__39951;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39028,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39028,(1),null);
var G__39952 = (gline + (1));
var G__39953 = cljs.core.next(lines__$1);
var G__39954 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__39955 = result__$1;
gline = G__39952;
lines__$1 = G__39953;
relseg = G__39954;
result = G__39955;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__39037){
var vec__39041 = p__39037;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39041,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39041,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39041,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39041,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39041,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__39045){
var vec__39046 = p__39045;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39046,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39046,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39046,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39046,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39046,(4),null);
var seg = vec__39046;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__39049){
var vec__39052 = p__39049;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39052,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39052,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39052,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39052,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39052,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__39061 = cljs.core.seq(infos);
var chunk__39062 = null;
var count__39063 = (0);
var i__39064 = (0);
while(true){
if((i__39064 < count__39063)){
var info = chunk__39062.cljs$core$IIndexed$_nth$arity$2(null,i__39064);
var segv_39964 = info__GT_segv(info,source_idx,line,col);
var gline_39965 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_39966 = cljs.core.count(cljs.core.deref(lines));
if((gline_39965 > (lc_39966 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39061,chunk__39062,count__39063,i__39064,segv_39964,gline_39965,lc_39966,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_39965 - (lc_39966 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_39964], null));
});})(seq__39061,chunk__39062,count__39063,i__39064,segv_39964,gline_39965,lc_39966,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39061,chunk__39062,count__39063,i__39064,segv_39964,gline_39965,lc_39966,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39965], null),cljs.core.conj,segv_39964);
});})(seq__39061,chunk__39062,count__39063,i__39064,segv_39964,gline_39965,lc_39966,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__39971 = seq__39061;
var G__39972 = chunk__39062;
var G__39973 = count__39063;
var G__39974 = (i__39064 + (1));
seq__39061 = G__39971;
chunk__39062 = G__39972;
count__39063 = G__39973;
i__39064 = G__39974;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__39061);
if(temp__5735__auto__){
var seq__39061__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39061__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__39061__$1);
var G__39975 = cljs.core.chunk_rest(seq__39061__$1);
var G__39976 = c__4609__auto__;
var G__39977 = cljs.core.count(c__4609__auto__);
var G__39978 = (0);
seq__39061 = G__39975;
chunk__39062 = G__39976;
count__39063 = G__39977;
i__39064 = G__39978;
continue;
} else {
var info = cljs.core.first(seq__39061__$1);
var segv_39979 = info__GT_segv(info,source_idx,line,col);
var gline_39980 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_39981 = cljs.core.count(cljs.core.deref(lines));
if((gline_39980 > (lc_39981 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39061,chunk__39062,count__39063,i__39064,segv_39979,gline_39980,lc_39981,info,seq__39061__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_39980 - (lc_39981 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_39979], null));
});})(seq__39061,chunk__39062,count__39063,i__39064,segv_39979,gline_39980,lc_39981,info,seq__39061__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__39061,chunk__39062,count__39063,i__39064,segv_39979,gline_39980,lc_39981,info,seq__39061__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_39980], null),cljs.core.conj,segv_39979);
});})(seq__39061,chunk__39062,count__39063,i__39064,segv_39979,gline_39980,lc_39981,info,seq__39061__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__39984 = cljs.core.next(seq__39061__$1);
var G__39985 = null;
var G__39986 = (0);
var G__39987 = (0);
seq__39061 = G__39984;
chunk__39062 = G__39985;
count__39063 = G__39986;
i__39064 = G__39987;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__39075_39988 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__39076_39989 = null;
var count__39077_39990 = (0);
var i__39078_39991 = (0);
while(true){
if((i__39078_39991 < count__39077_39990)){
var vec__39282_39994 = chunk__39076_39989.cljs$core$IIndexed$_nth$arity$2(null,i__39078_39991);
var source_idx_39995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39282_39994,(0),null);
var vec__39285_39996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39282_39994,(1),null);
var __39997 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39285_39996,(0),null);
var lines_39998__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39285_39996,(1),null);
var seq__39288_39999 = cljs.core.seq(lines_39998__$1);
var chunk__39289_40000 = null;
var count__39290_40001 = (0);
var i__39291_40002 = (0);
while(true){
if((i__39291_40002 < count__39290_40001)){
var vec__39339_40003 = chunk__39289_40000.cljs$core$IIndexed$_nth$arity$2(null,i__39291_40002);
var line_40004 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39339_40003,(0),null);
var cols_40005 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39339_40003,(1),null);
var seq__39342_40006 = cljs.core.seq(cols_40005);
var chunk__39343_40007 = null;
var count__39344_40008 = (0);
var i__39345_40009 = (0);
while(true){
if((i__39345_40009 < count__39344_40008)){
var vec__39352_40010 = chunk__39343_40007.cljs$core$IIndexed$_nth$arity$2(null,i__39345_40009);
var col_40011 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39352_40010,(0),null);
var infos_40012 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39352_40010,(1),null);
encode_cols(infos_40012,source_idx_39995,line_40004,col_40011);


var G__40015 = seq__39342_40006;
var G__40016 = chunk__39343_40007;
var G__40017 = count__39344_40008;
var G__40018 = (i__39345_40009 + (1));
seq__39342_40006 = G__40015;
chunk__39343_40007 = G__40016;
count__39344_40008 = G__40017;
i__39345_40009 = G__40018;
continue;
} else {
var temp__5735__auto___40025 = cljs.core.seq(seq__39342_40006);
if(temp__5735__auto___40025){
var seq__39342_40026__$1 = temp__5735__auto___40025;
if(cljs.core.chunked_seq_QMARK_(seq__39342_40026__$1)){
var c__4609__auto___40027 = cljs.core.chunk_first(seq__39342_40026__$1);
var G__40028 = cljs.core.chunk_rest(seq__39342_40026__$1);
var G__40029 = c__4609__auto___40027;
var G__40030 = cljs.core.count(c__4609__auto___40027);
var G__40031 = (0);
seq__39342_40006 = G__40028;
chunk__39343_40007 = G__40029;
count__39344_40008 = G__40030;
i__39345_40009 = G__40031;
continue;
} else {
var vec__39355_40032 = cljs.core.first(seq__39342_40026__$1);
var col_40033 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39355_40032,(0),null);
var infos_40034 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39355_40032,(1),null);
encode_cols(infos_40034,source_idx_39995,line_40004,col_40033);


var G__40035 = cljs.core.next(seq__39342_40026__$1);
var G__40036 = null;
var G__40037 = (0);
var G__40038 = (0);
seq__39342_40006 = G__40035;
chunk__39343_40007 = G__40036;
count__39344_40008 = G__40037;
i__39345_40009 = G__40038;
continue;
}
} else {
}
}
break;
}


var G__40039 = seq__39288_39999;
var G__40040 = chunk__39289_40000;
var G__40041 = count__39290_40001;
var G__40042 = (i__39291_40002 + (1));
seq__39288_39999 = G__40039;
chunk__39289_40000 = G__40040;
count__39290_40001 = G__40041;
i__39291_40002 = G__40042;
continue;
} else {
var temp__5735__auto___40043 = cljs.core.seq(seq__39288_39999);
if(temp__5735__auto___40043){
var seq__39288_40044__$1 = temp__5735__auto___40043;
if(cljs.core.chunked_seq_QMARK_(seq__39288_40044__$1)){
var c__4609__auto___40045 = cljs.core.chunk_first(seq__39288_40044__$1);
var G__40046 = cljs.core.chunk_rest(seq__39288_40044__$1);
var G__40047 = c__4609__auto___40045;
var G__40048 = cljs.core.count(c__4609__auto___40045);
var G__40049 = (0);
seq__39288_39999 = G__40046;
chunk__39289_40000 = G__40047;
count__39290_40001 = G__40048;
i__39291_40002 = G__40049;
continue;
} else {
var vec__39360_40052 = cljs.core.first(seq__39288_40044__$1);
var line_40053 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39360_40052,(0),null);
var cols_40054 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39360_40052,(1),null);
var seq__39363_40055 = cljs.core.seq(cols_40054);
var chunk__39364_40056 = null;
var count__39365_40057 = (0);
var i__39366_40058 = (0);
while(true){
if((i__39366_40058 < count__39365_40057)){
var vec__39375_40059 = chunk__39364_40056.cljs$core$IIndexed$_nth$arity$2(null,i__39366_40058);
var col_40060 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39375_40059,(0),null);
var infos_40061 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39375_40059,(1),null);
encode_cols(infos_40061,source_idx_39995,line_40053,col_40060);


var G__40062 = seq__39363_40055;
var G__40063 = chunk__39364_40056;
var G__40064 = count__39365_40057;
var G__40065 = (i__39366_40058 + (1));
seq__39363_40055 = G__40062;
chunk__39364_40056 = G__40063;
count__39365_40057 = G__40064;
i__39366_40058 = G__40065;
continue;
} else {
var temp__5735__auto___40066__$1 = cljs.core.seq(seq__39363_40055);
if(temp__5735__auto___40066__$1){
var seq__39363_40067__$1 = temp__5735__auto___40066__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39363_40067__$1)){
var c__4609__auto___40068 = cljs.core.chunk_first(seq__39363_40067__$1);
var G__40069 = cljs.core.chunk_rest(seq__39363_40067__$1);
var G__40070 = c__4609__auto___40068;
var G__40071 = cljs.core.count(c__4609__auto___40068);
var G__40072 = (0);
seq__39363_40055 = G__40069;
chunk__39364_40056 = G__40070;
count__39365_40057 = G__40071;
i__39366_40058 = G__40072;
continue;
} else {
var vec__39378_40073 = cljs.core.first(seq__39363_40067__$1);
var col_40074 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39378_40073,(0),null);
var infos_40075 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39378_40073,(1),null);
encode_cols(infos_40075,source_idx_39995,line_40053,col_40074);


var G__40079 = cljs.core.next(seq__39363_40067__$1);
var G__40080 = null;
var G__40081 = (0);
var G__40082 = (0);
seq__39363_40055 = G__40079;
chunk__39364_40056 = G__40080;
count__39365_40057 = G__40081;
i__39366_40058 = G__40082;
continue;
}
} else {
}
}
break;
}


var G__40083 = cljs.core.next(seq__39288_40044__$1);
var G__40084 = null;
var G__40085 = (0);
var G__40086 = (0);
seq__39288_39999 = G__40083;
chunk__39289_40000 = G__40084;
count__39290_40001 = G__40085;
i__39291_40002 = G__40086;
continue;
}
} else {
}
}
break;
}


var G__40087 = seq__39075_39988;
var G__40088 = chunk__39076_39989;
var G__40089 = count__39077_39990;
var G__40090 = (i__39078_39991 + (1));
seq__39075_39988 = G__40087;
chunk__39076_39989 = G__40088;
count__39077_39990 = G__40089;
i__39078_39991 = G__40090;
continue;
} else {
var temp__5735__auto___40091 = cljs.core.seq(seq__39075_39988);
if(temp__5735__auto___40091){
var seq__39075_40092__$1 = temp__5735__auto___40091;
if(cljs.core.chunked_seq_QMARK_(seq__39075_40092__$1)){
var c__4609__auto___40093 = cljs.core.chunk_first(seq__39075_40092__$1);
var G__40094 = cljs.core.chunk_rest(seq__39075_40092__$1);
var G__40095 = c__4609__auto___40093;
var G__40096 = cljs.core.count(c__4609__auto___40093);
var G__40097 = (0);
seq__39075_39988 = G__40094;
chunk__39076_39989 = G__40095;
count__39077_39990 = G__40096;
i__39078_39991 = G__40097;
continue;
} else {
var vec__39381_40098 = cljs.core.first(seq__39075_40092__$1);
var source_idx_40099 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39381_40098,(0),null);
var vec__39384_40100 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39381_40098,(1),null);
var __40101 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39384_40100,(0),null);
var lines_40102__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39384_40100,(1),null);
var seq__39387_40103 = cljs.core.seq(lines_40102__$1);
var chunk__39388_40104 = null;
var count__39389_40105 = (0);
var i__39390_40106 = (0);
while(true){
if((i__39390_40106 < count__39389_40105)){
var vec__39434_40107 = chunk__39388_40104.cljs$core$IIndexed$_nth$arity$2(null,i__39390_40106);
var line_40108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39434_40107,(0),null);
var cols_40109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39434_40107,(1),null);
var seq__39437_40110 = cljs.core.seq(cols_40109);
var chunk__39438_40111 = null;
var count__39439_40112 = (0);
var i__39440_40113 = (0);
while(true){
if((i__39440_40113 < count__39439_40112)){
var vec__39447_40114 = chunk__39438_40111.cljs$core$IIndexed$_nth$arity$2(null,i__39440_40113);
var col_40115 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39447_40114,(0),null);
var infos_40116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39447_40114,(1),null);
encode_cols(infos_40116,source_idx_40099,line_40108,col_40115);


var G__40117 = seq__39437_40110;
var G__40118 = chunk__39438_40111;
var G__40119 = count__39439_40112;
var G__40120 = (i__39440_40113 + (1));
seq__39437_40110 = G__40117;
chunk__39438_40111 = G__40118;
count__39439_40112 = G__40119;
i__39440_40113 = G__40120;
continue;
} else {
var temp__5735__auto___40121__$1 = cljs.core.seq(seq__39437_40110);
if(temp__5735__auto___40121__$1){
var seq__39437_40122__$1 = temp__5735__auto___40121__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39437_40122__$1)){
var c__4609__auto___40123 = cljs.core.chunk_first(seq__39437_40122__$1);
var G__40124 = cljs.core.chunk_rest(seq__39437_40122__$1);
var G__40125 = c__4609__auto___40123;
var G__40126 = cljs.core.count(c__4609__auto___40123);
var G__40127 = (0);
seq__39437_40110 = G__40124;
chunk__39438_40111 = G__40125;
count__39439_40112 = G__40126;
i__39440_40113 = G__40127;
continue;
} else {
var vec__39450_40129 = cljs.core.first(seq__39437_40122__$1);
var col_40130 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39450_40129,(0),null);
var infos_40131 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39450_40129,(1),null);
encode_cols(infos_40131,source_idx_40099,line_40108,col_40130);


var G__40132 = cljs.core.next(seq__39437_40122__$1);
var G__40133 = null;
var G__40134 = (0);
var G__40135 = (0);
seq__39437_40110 = G__40132;
chunk__39438_40111 = G__40133;
count__39439_40112 = G__40134;
i__39440_40113 = G__40135;
continue;
}
} else {
}
}
break;
}


var G__40136 = seq__39387_40103;
var G__40137 = chunk__39388_40104;
var G__40138 = count__39389_40105;
var G__40139 = (i__39390_40106 + (1));
seq__39387_40103 = G__40136;
chunk__39388_40104 = G__40137;
count__39389_40105 = G__40138;
i__39390_40106 = G__40139;
continue;
} else {
var temp__5735__auto___40140__$1 = cljs.core.seq(seq__39387_40103);
if(temp__5735__auto___40140__$1){
var seq__39387_40141__$1 = temp__5735__auto___40140__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39387_40141__$1)){
var c__4609__auto___40142 = cljs.core.chunk_first(seq__39387_40141__$1);
var G__40143 = cljs.core.chunk_rest(seq__39387_40141__$1);
var G__40144 = c__4609__auto___40142;
var G__40145 = cljs.core.count(c__4609__auto___40142);
var G__40146 = (0);
seq__39387_40103 = G__40143;
chunk__39388_40104 = G__40144;
count__39389_40105 = G__40145;
i__39390_40106 = G__40146;
continue;
} else {
var vec__39454_40147 = cljs.core.first(seq__39387_40141__$1);
var line_40148 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39454_40147,(0),null);
var cols_40149 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39454_40147,(1),null);
var seq__39458_40150 = cljs.core.seq(cols_40149);
var chunk__39459_40151 = null;
var count__39460_40152 = (0);
var i__39461_40153 = (0);
while(true){
if((i__39461_40153 < count__39460_40152)){
var vec__39468_40155 = chunk__39459_40151.cljs$core$IIndexed$_nth$arity$2(null,i__39461_40153);
var col_40156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39468_40155,(0),null);
var infos_40157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39468_40155,(1),null);
encode_cols(infos_40157,source_idx_40099,line_40148,col_40156);


var G__40158 = seq__39458_40150;
var G__40159 = chunk__39459_40151;
var G__40160 = count__39460_40152;
var G__40161 = (i__39461_40153 + (1));
seq__39458_40150 = G__40158;
chunk__39459_40151 = G__40159;
count__39460_40152 = G__40160;
i__39461_40153 = G__40161;
continue;
} else {
var temp__5735__auto___40162__$2 = cljs.core.seq(seq__39458_40150);
if(temp__5735__auto___40162__$2){
var seq__39458_40163__$1 = temp__5735__auto___40162__$2;
if(cljs.core.chunked_seq_QMARK_(seq__39458_40163__$1)){
var c__4609__auto___40164 = cljs.core.chunk_first(seq__39458_40163__$1);
var G__40165 = cljs.core.chunk_rest(seq__39458_40163__$1);
var G__40166 = c__4609__auto___40164;
var G__40167 = cljs.core.count(c__4609__auto___40164);
var G__40168 = (0);
seq__39458_40150 = G__40165;
chunk__39459_40151 = G__40166;
count__39460_40152 = G__40167;
i__39461_40153 = G__40168;
continue;
} else {
var vec__39474_40170 = cljs.core.first(seq__39458_40163__$1);
var col_40171 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39474_40170,(0),null);
var infos_40172 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39474_40170,(1),null);
encode_cols(infos_40172,source_idx_40099,line_40148,col_40171);


var G__40176 = cljs.core.next(seq__39458_40163__$1);
var G__40177 = null;
var G__40178 = (0);
var G__40179 = (0);
seq__39458_40150 = G__40176;
chunk__39459_40151 = G__40177;
count__39460_40152 = G__40178;
i__39461_40153 = G__40179;
continue;
}
} else {
}
}
break;
}


var G__40180 = cljs.core.next(seq__39387_40141__$1);
var G__40181 = null;
var G__40182 = (0);
var G__40183 = (0);
seq__39387_40103 = G__40180;
chunk__39388_40104 = G__40181;
count__39389_40105 = G__40182;
i__39390_40106 = G__40183;
continue;
}
} else {
}
}
break;
}


var G__40187 = cljs.core.next(seq__39075_40092__$1);
var G__40188 = null;
var G__40189 = (0);
var G__40190 = (0);
seq__39075_39988 = G__40187;
chunk__39076_39989 = G__40188;
count__39077_39990 = G__40189;
i__39078_39991 = G__40190;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__39477 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__39057_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__39057_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__39058_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__39058_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39059_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__39059_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__39480 = G__39477;
var G__39481_40194 = G__39480;
var G__39482_40195 = "sourcesContent";
var G__39483_40196 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__39481_40194,G__39482_40195,G__39483_40196);

return G__39480;
} else {
return G__39477;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__39484 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39484,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39484,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__39487 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39487,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39487,(1),null);
var G__40199 = cljs.core.next(col_map_seq);
var G__40200 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__39487,col,infos,vec__39484,line,col_map){
return (function (v,p__39490){
var map__39491 = p__39490;
var map__39491__$1 = (((((!((map__39491 == null))))?(((((map__39491.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39491.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39491):map__39491);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39491__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39491__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__39487,col,infos,vec__39484,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__40199;
new_cols = G__40200;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__40201 = cljs.core.next(line_map_seq);
var G__40202 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__40201;
new_lines = G__40202;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__39495_40203 = cljs.core.seq(reverse_map);
var chunk__39496_40204 = null;
var count__39497_40205 = (0);
var i__39498_40206 = (0);
while(true){
if((i__39498_40206 < count__39497_40205)){
var vec__39678_40207 = chunk__39496_40204.cljs$core$IIndexed$_nth$arity$2(null,i__39498_40206);
var line_40208 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39678_40207,(0),null);
var columns_40209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39678_40207,(1),null);
var seq__39683_40210 = cljs.core.seq(columns_40209);
var chunk__39684_40211 = null;
var count__39685_40212 = (0);
var i__39686_40213 = (0);
while(true){
if((i__39686_40213 < count__39685_40212)){
var vec__39735_40214 = chunk__39684_40211.cljs$core$IIndexed$_nth$arity$2(null,i__39686_40213);
var column_40215 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39735_40214,(0),null);
var column_info_40216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39735_40214,(1),null);
var seq__39738_40218 = cljs.core.seq(column_info_40216);
var chunk__39739_40219 = null;
var count__39740_40220 = (0);
var i__39741_40221 = (0);
while(true){
if((i__39741_40221 < count__39740_40220)){
var map__39751_40225 = chunk__39739_40219.cljs$core$IIndexed$_nth$arity$2(null,i__39741_40221);
var map__39751_40226__$1 = (((((!((map__39751_40225 == null))))?(((((map__39751_40225.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39751_40225.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39751_40225):map__39751_40225);
var gline_40227 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39751_40226__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40228 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39751_40226__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40229 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39751_40226__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40227], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39738_40218,chunk__39739_40219,count__39740_40220,i__39741_40221,seq__39683_40210,chunk__39684_40211,count__39685_40212,i__39686_40213,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39751_40225,map__39751_40226__$1,gline_40227,gcol_40228,name_40229,vec__39735_40214,column_40215,column_info_40216,vec__39678_40207,line_40208,columns_40209,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40228], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40208,new cljs.core.Keyword(null,"col","col",-1959363084),column_40215,new cljs.core.Keyword(null,"name","name",1843675177),name_40229], null));
});})(seq__39738_40218,chunk__39739_40219,count__39740_40220,i__39741_40221,seq__39683_40210,chunk__39684_40211,count__39685_40212,i__39686_40213,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39751_40225,map__39751_40226__$1,gline_40227,gcol_40228,name_40229,vec__39735_40214,column_40215,column_info_40216,vec__39678_40207,line_40208,columns_40209,inverted))
,cljs.core.sorted_map()));


var G__40242 = seq__39738_40218;
var G__40243 = chunk__39739_40219;
var G__40244 = count__39740_40220;
var G__40245 = (i__39741_40221 + (1));
seq__39738_40218 = G__40242;
chunk__39739_40219 = G__40243;
count__39740_40220 = G__40244;
i__39741_40221 = G__40245;
continue;
} else {
var temp__5735__auto___40248 = cljs.core.seq(seq__39738_40218);
if(temp__5735__auto___40248){
var seq__39738_40249__$1 = temp__5735__auto___40248;
if(cljs.core.chunked_seq_QMARK_(seq__39738_40249__$1)){
var c__4609__auto___40252 = cljs.core.chunk_first(seq__39738_40249__$1);
var G__40253 = cljs.core.chunk_rest(seq__39738_40249__$1);
var G__40254 = c__4609__auto___40252;
var G__40255 = cljs.core.count(c__4609__auto___40252);
var G__40256 = (0);
seq__39738_40218 = G__40253;
chunk__39739_40219 = G__40254;
count__39740_40220 = G__40255;
i__39741_40221 = G__40256;
continue;
} else {
var map__39753_40258 = cljs.core.first(seq__39738_40249__$1);
var map__39753_40259__$1 = (((((!((map__39753_40258 == null))))?(((((map__39753_40258.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39753_40258.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39753_40258):map__39753_40258);
var gline_40260 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39753_40259__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40261 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39753_40259__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40262 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39753_40259__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40260], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39738_40218,chunk__39739_40219,count__39740_40220,i__39741_40221,seq__39683_40210,chunk__39684_40211,count__39685_40212,i__39686_40213,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39753_40258,map__39753_40259__$1,gline_40260,gcol_40261,name_40262,seq__39738_40249__$1,temp__5735__auto___40248,vec__39735_40214,column_40215,column_info_40216,vec__39678_40207,line_40208,columns_40209,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40261], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40208,new cljs.core.Keyword(null,"col","col",-1959363084),column_40215,new cljs.core.Keyword(null,"name","name",1843675177),name_40262], null));
});})(seq__39738_40218,chunk__39739_40219,count__39740_40220,i__39741_40221,seq__39683_40210,chunk__39684_40211,count__39685_40212,i__39686_40213,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39753_40258,map__39753_40259__$1,gline_40260,gcol_40261,name_40262,seq__39738_40249__$1,temp__5735__auto___40248,vec__39735_40214,column_40215,column_info_40216,vec__39678_40207,line_40208,columns_40209,inverted))
,cljs.core.sorted_map()));


var G__40270 = cljs.core.next(seq__39738_40249__$1);
var G__40271 = null;
var G__40272 = (0);
var G__40273 = (0);
seq__39738_40218 = G__40270;
chunk__39739_40219 = G__40271;
count__39740_40220 = G__40272;
i__39741_40221 = G__40273;
continue;
}
} else {
}
}
break;
}


var G__40276 = seq__39683_40210;
var G__40277 = chunk__39684_40211;
var G__40278 = count__39685_40212;
var G__40279 = (i__39686_40213 + (1));
seq__39683_40210 = G__40276;
chunk__39684_40211 = G__40277;
count__39685_40212 = G__40278;
i__39686_40213 = G__40279;
continue;
} else {
var temp__5735__auto___40280 = cljs.core.seq(seq__39683_40210);
if(temp__5735__auto___40280){
var seq__39683_40281__$1 = temp__5735__auto___40280;
if(cljs.core.chunked_seq_QMARK_(seq__39683_40281__$1)){
var c__4609__auto___40284 = cljs.core.chunk_first(seq__39683_40281__$1);
var G__40285 = cljs.core.chunk_rest(seq__39683_40281__$1);
var G__40286 = c__4609__auto___40284;
var G__40287 = cljs.core.count(c__4609__auto___40284);
var G__40288 = (0);
seq__39683_40210 = G__40285;
chunk__39684_40211 = G__40286;
count__39685_40212 = G__40287;
i__39686_40213 = G__40288;
continue;
} else {
var vec__39763_40289 = cljs.core.first(seq__39683_40281__$1);
var column_40290 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39763_40289,(0),null);
var column_info_40291 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39763_40289,(1),null);
var seq__39768_40293 = cljs.core.seq(column_info_40291);
var chunk__39769_40294 = null;
var count__39770_40295 = (0);
var i__39771_40296 = (0);
while(true){
if((i__39771_40296 < count__39770_40295)){
var map__39780_40297 = chunk__39769_40294.cljs$core$IIndexed$_nth$arity$2(null,i__39771_40296);
var map__39780_40298__$1 = (((((!((map__39780_40297 == null))))?(((((map__39780_40297.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39780_40297.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39780_40297):map__39780_40297);
var gline_40299 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39780_40298__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40300 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39780_40298__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40301 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39780_40298__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40299], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39768_40293,chunk__39769_40294,count__39770_40295,i__39771_40296,seq__39683_40210,chunk__39684_40211,count__39685_40212,i__39686_40213,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39780_40297,map__39780_40298__$1,gline_40299,gcol_40300,name_40301,vec__39763_40289,column_40290,column_info_40291,seq__39683_40281__$1,temp__5735__auto___40280,vec__39678_40207,line_40208,columns_40209,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40300], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40208,new cljs.core.Keyword(null,"col","col",-1959363084),column_40290,new cljs.core.Keyword(null,"name","name",1843675177),name_40301], null));
});})(seq__39768_40293,chunk__39769_40294,count__39770_40295,i__39771_40296,seq__39683_40210,chunk__39684_40211,count__39685_40212,i__39686_40213,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39780_40297,map__39780_40298__$1,gline_40299,gcol_40300,name_40301,vec__39763_40289,column_40290,column_info_40291,seq__39683_40281__$1,temp__5735__auto___40280,vec__39678_40207,line_40208,columns_40209,inverted))
,cljs.core.sorted_map()));


var G__40306 = seq__39768_40293;
var G__40307 = chunk__39769_40294;
var G__40308 = count__39770_40295;
var G__40309 = (i__39771_40296 + (1));
seq__39768_40293 = G__40306;
chunk__39769_40294 = G__40307;
count__39770_40295 = G__40308;
i__39771_40296 = G__40309;
continue;
} else {
var temp__5735__auto___40311__$1 = cljs.core.seq(seq__39768_40293);
if(temp__5735__auto___40311__$1){
var seq__39768_40312__$1 = temp__5735__auto___40311__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39768_40312__$1)){
var c__4609__auto___40316 = cljs.core.chunk_first(seq__39768_40312__$1);
var G__40317 = cljs.core.chunk_rest(seq__39768_40312__$1);
var G__40318 = c__4609__auto___40316;
var G__40319 = cljs.core.count(c__4609__auto___40316);
var G__40320 = (0);
seq__39768_40293 = G__40317;
chunk__39769_40294 = G__40318;
count__39770_40295 = G__40319;
i__39771_40296 = G__40320;
continue;
} else {
var map__39785_40321 = cljs.core.first(seq__39768_40312__$1);
var map__39785_40322__$1 = (((((!((map__39785_40321 == null))))?(((((map__39785_40321.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39785_40321.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39785_40321):map__39785_40321);
var gline_40323 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39785_40322__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40324 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39785_40322__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40325 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39785_40322__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40323], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39768_40293,chunk__39769_40294,count__39770_40295,i__39771_40296,seq__39683_40210,chunk__39684_40211,count__39685_40212,i__39686_40213,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39785_40321,map__39785_40322__$1,gline_40323,gcol_40324,name_40325,seq__39768_40312__$1,temp__5735__auto___40311__$1,vec__39763_40289,column_40290,column_info_40291,seq__39683_40281__$1,temp__5735__auto___40280,vec__39678_40207,line_40208,columns_40209,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40324], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40208,new cljs.core.Keyword(null,"col","col",-1959363084),column_40290,new cljs.core.Keyword(null,"name","name",1843675177),name_40325], null));
});})(seq__39768_40293,chunk__39769_40294,count__39770_40295,i__39771_40296,seq__39683_40210,chunk__39684_40211,count__39685_40212,i__39686_40213,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39785_40321,map__39785_40322__$1,gline_40323,gcol_40324,name_40325,seq__39768_40312__$1,temp__5735__auto___40311__$1,vec__39763_40289,column_40290,column_info_40291,seq__39683_40281__$1,temp__5735__auto___40280,vec__39678_40207,line_40208,columns_40209,inverted))
,cljs.core.sorted_map()));


var G__40332 = cljs.core.next(seq__39768_40312__$1);
var G__40333 = null;
var G__40334 = (0);
var G__40335 = (0);
seq__39768_40293 = G__40332;
chunk__39769_40294 = G__40333;
count__39770_40295 = G__40334;
i__39771_40296 = G__40335;
continue;
}
} else {
}
}
break;
}


var G__40336 = cljs.core.next(seq__39683_40281__$1);
var G__40337 = null;
var G__40338 = (0);
var G__40339 = (0);
seq__39683_40210 = G__40336;
chunk__39684_40211 = G__40337;
count__39685_40212 = G__40338;
i__39686_40213 = G__40339;
continue;
}
} else {
}
}
break;
}


var G__40340 = seq__39495_40203;
var G__40341 = chunk__39496_40204;
var G__40342 = count__39497_40205;
var G__40343 = (i__39498_40206 + (1));
seq__39495_40203 = G__40340;
chunk__39496_40204 = G__40341;
count__39497_40205 = G__40342;
i__39498_40206 = G__40343;
continue;
} else {
var temp__5735__auto___40344 = cljs.core.seq(seq__39495_40203);
if(temp__5735__auto___40344){
var seq__39495_40345__$1 = temp__5735__auto___40344;
if(cljs.core.chunked_seq_QMARK_(seq__39495_40345__$1)){
var c__4609__auto___40346 = cljs.core.chunk_first(seq__39495_40345__$1);
var G__40347 = cljs.core.chunk_rest(seq__39495_40345__$1);
var G__40348 = c__4609__auto___40346;
var G__40349 = cljs.core.count(c__4609__auto___40346);
var G__40350 = (0);
seq__39495_40203 = G__40347;
chunk__39496_40204 = G__40348;
count__39497_40205 = G__40349;
i__39498_40206 = G__40350;
continue;
} else {
var vec__39789_40351 = cljs.core.first(seq__39495_40345__$1);
var line_40352 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39789_40351,(0),null);
var columns_40353 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39789_40351,(1),null);
var seq__39795_40355 = cljs.core.seq(columns_40353);
var chunk__39796_40356 = null;
var count__39797_40357 = (0);
var i__39798_40358 = (0);
while(true){
if((i__39798_40358 < count__39797_40357)){
var vec__39872_40359 = chunk__39796_40356.cljs$core$IIndexed$_nth$arity$2(null,i__39798_40358);
var column_40360 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39872_40359,(0),null);
var column_info_40361 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39872_40359,(1),null);
var seq__39875_40362 = cljs.core.seq(column_info_40361);
var chunk__39876_40363 = null;
var count__39877_40364 = (0);
var i__39878_40365 = (0);
while(true){
if((i__39878_40365 < count__39877_40364)){
var map__39892_40366 = chunk__39876_40363.cljs$core$IIndexed$_nth$arity$2(null,i__39878_40365);
var map__39892_40367__$1 = (((((!((map__39892_40366 == null))))?(((((map__39892_40366.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39892_40366.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39892_40366):map__39892_40366);
var gline_40368 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39892_40367__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40369 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39892_40367__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40370 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39892_40367__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40368], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39875_40362,chunk__39876_40363,count__39877_40364,i__39878_40365,seq__39795_40355,chunk__39796_40356,count__39797_40357,i__39798_40358,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39892_40366,map__39892_40367__$1,gline_40368,gcol_40369,name_40370,vec__39872_40359,column_40360,column_info_40361,vec__39789_40351,line_40352,columns_40353,seq__39495_40345__$1,temp__5735__auto___40344,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40369], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40352,new cljs.core.Keyword(null,"col","col",-1959363084),column_40360,new cljs.core.Keyword(null,"name","name",1843675177),name_40370], null));
});})(seq__39875_40362,chunk__39876_40363,count__39877_40364,i__39878_40365,seq__39795_40355,chunk__39796_40356,count__39797_40357,i__39798_40358,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39892_40366,map__39892_40367__$1,gline_40368,gcol_40369,name_40370,vec__39872_40359,column_40360,column_info_40361,vec__39789_40351,line_40352,columns_40353,seq__39495_40345__$1,temp__5735__auto___40344,inverted))
,cljs.core.sorted_map()));


var G__40378 = seq__39875_40362;
var G__40379 = chunk__39876_40363;
var G__40380 = count__39877_40364;
var G__40381 = (i__39878_40365 + (1));
seq__39875_40362 = G__40378;
chunk__39876_40363 = G__40379;
count__39877_40364 = G__40380;
i__39878_40365 = G__40381;
continue;
} else {
var temp__5735__auto___40382__$1 = cljs.core.seq(seq__39875_40362);
if(temp__5735__auto___40382__$1){
var seq__39875_40383__$1 = temp__5735__auto___40382__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39875_40383__$1)){
var c__4609__auto___40384 = cljs.core.chunk_first(seq__39875_40383__$1);
var G__40385 = cljs.core.chunk_rest(seq__39875_40383__$1);
var G__40386 = c__4609__auto___40384;
var G__40387 = cljs.core.count(c__4609__auto___40384);
var G__40388 = (0);
seq__39875_40362 = G__40385;
chunk__39876_40363 = G__40386;
count__39877_40364 = G__40387;
i__39878_40365 = G__40388;
continue;
} else {
var map__39897_40392 = cljs.core.first(seq__39875_40383__$1);
var map__39897_40393__$1 = (((((!((map__39897_40392 == null))))?(((((map__39897_40392.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39897_40392.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39897_40392):map__39897_40392);
var gline_40394 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39897_40393__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40395 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39897_40393__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40396 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39897_40393__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40394], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39875_40362,chunk__39876_40363,count__39877_40364,i__39878_40365,seq__39795_40355,chunk__39796_40356,count__39797_40357,i__39798_40358,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39897_40392,map__39897_40393__$1,gline_40394,gcol_40395,name_40396,seq__39875_40383__$1,temp__5735__auto___40382__$1,vec__39872_40359,column_40360,column_info_40361,vec__39789_40351,line_40352,columns_40353,seq__39495_40345__$1,temp__5735__auto___40344,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40395], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40352,new cljs.core.Keyword(null,"col","col",-1959363084),column_40360,new cljs.core.Keyword(null,"name","name",1843675177),name_40396], null));
});})(seq__39875_40362,chunk__39876_40363,count__39877_40364,i__39878_40365,seq__39795_40355,chunk__39796_40356,count__39797_40357,i__39798_40358,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39897_40392,map__39897_40393__$1,gline_40394,gcol_40395,name_40396,seq__39875_40383__$1,temp__5735__auto___40382__$1,vec__39872_40359,column_40360,column_info_40361,vec__39789_40351,line_40352,columns_40353,seq__39495_40345__$1,temp__5735__auto___40344,inverted))
,cljs.core.sorted_map()));


var G__40401 = cljs.core.next(seq__39875_40383__$1);
var G__40402 = null;
var G__40403 = (0);
var G__40404 = (0);
seq__39875_40362 = G__40401;
chunk__39876_40363 = G__40402;
count__39877_40364 = G__40403;
i__39878_40365 = G__40404;
continue;
}
} else {
}
}
break;
}


var G__40405 = seq__39795_40355;
var G__40406 = chunk__39796_40356;
var G__40407 = count__39797_40357;
var G__40408 = (i__39798_40358 + (1));
seq__39795_40355 = G__40405;
chunk__39796_40356 = G__40406;
count__39797_40357 = G__40407;
i__39798_40358 = G__40408;
continue;
} else {
var temp__5735__auto___40409__$1 = cljs.core.seq(seq__39795_40355);
if(temp__5735__auto___40409__$1){
var seq__39795_40412__$1 = temp__5735__auto___40409__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39795_40412__$1)){
var c__4609__auto___40413 = cljs.core.chunk_first(seq__39795_40412__$1);
var G__40414 = cljs.core.chunk_rest(seq__39795_40412__$1);
var G__40415 = c__4609__auto___40413;
var G__40416 = cljs.core.count(c__4609__auto___40413);
var G__40417 = (0);
seq__39795_40355 = G__40414;
chunk__39796_40356 = G__40415;
count__39797_40357 = G__40416;
i__39798_40358 = G__40417;
continue;
} else {
var vec__39903_40418 = cljs.core.first(seq__39795_40412__$1);
var column_40419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39903_40418,(0),null);
var column_info_40420 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39903_40418,(1),null);
var seq__39906_40421 = cljs.core.seq(column_info_40420);
var chunk__39907_40422 = null;
var count__39908_40423 = (0);
var i__39909_40424 = (0);
while(true){
if((i__39909_40424 < count__39908_40423)){
var map__39922_40425 = chunk__39907_40422.cljs$core$IIndexed$_nth$arity$2(null,i__39909_40424);
var map__39922_40426__$1 = (((((!((map__39922_40425 == null))))?(((((map__39922_40425.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39922_40425.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39922_40425):map__39922_40425);
var gline_40427 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39922_40426__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40428 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39922_40426__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40429 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39922_40426__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40427], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39906_40421,chunk__39907_40422,count__39908_40423,i__39909_40424,seq__39795_40355,chunk__39796_40356,count__39797_40357,i__39798_40358,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39922_40425,map__39922_40426__$1,gline_40427,gcol_40428,name_40429,vec__39903_40418,column_40419,column_info_40420,seq__39795_40412__$1,temp__5735__auto___40409__$1,vec__39789_40351,line_40352,columns_40353,seq__39495_40345__$1,temp__5735__auto___40344,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40428], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40352,new cljs.core.Keyword(null,"col","col",-1959363084),column_40419,new cljs.core.Keyword(null,"name","name",1843675177),name_40429], null));
});})(seq__39906_40421,chunk__39907_40422,count__39908_40423,i__39909_40424,seq__39795_40355,chunk__39796_40356,count__39797_40357,i__39798_40358,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39922_40425,map__39922_40426__$1,gline_40427,gcol_40428,name_40429,vec__39903_40418,column_40419,column_info_40420,seq__39795_40412__$1,temp__5735__auto___40409__$1,vec__39789_40351,line_40352,columns_40353,seq__39495_40345__$1,temp__5735__auto___40344,inverted))
,cljs.core.sorted_map()));


var G__40436 = seq__39906_40421;
var G__40437 = chunk__39907_40422;
var G__40438 = count__39908_40423;
var G__40439 = (i__39909_40424 + (1));
seq__39906_40421 = G__40436;
chunk__39907_40422 = G__40437;
count__39908_40423 = G__40438;
i__39909_40424 = G__40439;
continue;
} else {
var temp__5735__auto___40440__$2 = cljs.core.seq(seq__39906_40421);
if(temp__5735__auto___40440__$2){
var seq__39906_40441__$1 = temp__5735__auto___40440__$2;
if(cljs.core.chunked_seq_QMARK_(seq__39906_40441__$1)){
var c__4609__auto___40442 = cljs.core.chunk_first(seq__39906_40441__$1);
var G__40443 = cljs.core.chunk_rest(seq__39906_40441__$1);
var G__40444 = c__4609__auto___40442;
var G__40445 = cljs.core.count(c__4609__auto___40442);
var G__40446 = (0);
seq__39906_40421 = G__40443;
chunk__39907_40422 = G__40444;
count__39908_40423 = G__40445;
i__39909_40424 = G__40446;
continue;
} else {
var map__39924_40447 = cljs.core.first(seq__39906_40441__$1);
var map__39924_40448__$1 = (((((!((map__39924_40447 == null))))?(((((map__39924_40447.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39924_40447.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39924_40447):map__39924_40447);
var gline_40449 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39924_40448__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_40450 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39924_40448__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_40451 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39924_40448__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_40449], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__39906_40421,chunk__39907_40422,count__39908_40423,i__39909_40424,seq__39795_40355,chunk__39796_40356,count__39797_40357,i__39798_40358,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39924_40447,map__39924_40448__$1,gline_40449,gcol_40450,name_40451,seq__39906_40441__$1,temp__5735__auto___40440__$2,vec__39903_40418,column_40419,column_info_40420,seq__39795_40412__$1,temp__5735__auto___40409__$1,vec__39789_40351,line_40352,columns_40353,seq__39495_40345__$1,temp__5735__auto___40344,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_40450], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_40352,new cljs.core.Keyword(null,"col","col",-1959363084),column_40419,new cljs.core.Keyword(null,"name","name",1843675177),name_40451], null));
});})(seq__39906_40421,chunk__39907_40422,count__39908_40423,i__39909_40424,seq__39795_40355,chunk__39796_40356,count__39797_40357,i__39798_40358,seq__39495_40203,chunk__39496_40204,count__39497_40205,i__39498_40206,map__39924_40447,map__39924_40448__$1,gline_40449,gcol_40450,name_40451,seq__39906_40441__$1,temp__5735__auto___40440__$2,vec__39903_40418,column_40419,column_info_40420,seq__39795_40412__$1,temp__5735__auto___40409__$1,vec__39789_40351,line_40352,columns_40353,seq__39495_40345__$1,temp__5735__auto___40344,inverted))
,cljs.core.sorted_map()));


var G__40463 = cljs.core.next(seq__39906_40441__$1);
var G__40464 = null;
var G__40465 = (0);
var G__40466 = (0);
seq__39906_40421 = G__40463;
chunk__39907_40422 = G__40464;
count__39908_40423 = G__40465;
i__39909_40424 = G__40466;
continue;
}
} else {
}
}
break;
}


var G__40467 = cljs.core.next(seq__39795_40412__$1);
var G__40468 = null;
var G__40469 = (0);
var G__40470 = (0);
seq__39795_40355 = G__40467;
chunk__39796_40356 = G__40468;
count__39797_40357 = G__40469;
i__39798_40358 = G__40470;
continue;
}
} else {
}
}
break;
}


var G__40472 = cljs.core.next(seq__39495_40345__$1);
var G__40473 = null;
var G__40474 = (0);
var G__40475 = (0);
seq__39495_40203 = G__40472;
chunk__39496_40204 = G__40473;
count__39497_40205 = G__40474;
i__39498_40206 = G__40475;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
