goog.provide('pinkgorilla.codemirror.parinfer_events');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('pinkgorilla.codemirror.editor_support');
/**
 * Called before any change is applied to the editor.
 *   @param {CodeMirror} cm
 */
pinkgorilla.codemirror.parinfer_events.parinfer_before_change = (function pinkgorilla$codemirror$parinfer_events$parinfer_before_change(cm,change){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("setValue",change.origin)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cm.getValue(),clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",change.text))))){
return change.cancel();
} else {
return null;
}
});
/**
 * Called after any change is applied to the editor.
 *   @param {CodeMirror} cm
 */
pinkgorilla.codemirror.parinfer_events.parinfer_on_change = (function pinkgorilla$codemirror$parinfer_events$parinfer_on_change(cm,change){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("setValue",change.origin)){
pinkgorilla.codemirror.editor_support.fix_text_BANG_.cljs$core$IFn$_invoke$arity$variadic(cm,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"change","change",-1163046502),change], 0));

return pinkgorilla.codemirror.editor_support.set_frame_updated_BANG_(cm,true);
} else {
return null;
}
});
/**
 * Called after the cursor moves in the editor.
 *   @param {CodeMirror} cm
 */
pinkgorilla.codemirror.parinfer_events.parinfer_on_cursor_activity = (function pinkgorilla$codemirror$parinfer_events$parinfer_on_cursor_activity(cm){
if(cljs.core.truth_(pinkgorilla.codemirror.editor_support.frame_updated_QMARK_(cm))){
} else {
pinkgorilla.codemirror.editor_support.fix_text_BANG_(cm);
}

return pinkgorilla.codemirror.editor_support.set_frame_updated_BANG_(cm,false);
});
/**
 * Indent selection or insert two spaces when tab is pressed.
 *   from: https://github.com/codemirror/CodeMirror/issues/988#issuecomment-14921785
 *   @param {CodeMirror} cm
 */
pinkgorilla.codemirror.parinfer_events.parinfer_on_tab = (function pinkgorilla$codemirror$parinfer_events$parinfer_on_tab(cm){
if(cljs.core.truth_(cm.somethingSelected())){
return cm.indentSelection();
} else {
var n = cm.getOption("indentUnit");
var spaces = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(n," "));
return cm.replaceSelection(spaces);
}
});
pinkgorilla.codemirror.parinfer_events.add_parinfer_events = (function pinkgorilla$codemirror$parinfer_events$add_parinfer_events(cm){
var atom_frame_updated = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var x47194_47195 = cm;
(x47194_47195.pinkgorilla$codemirror$editor_support$IEditor$ = cljs.core.PROTOCOL_SENTINEL);

(x47194_47195.pinkgorilla$codemirror$editor_support$IEditor$frame_updated_QMARK_$arity$1 = (function (_){
var ___$1 = this;
return cljs.core.deref(atom_frame_updated);
}));

(x47194_47195.pinkgorilla$codemirror$editor_support$IEditor$set_frame_updated_BANG_$arity$2 = (function (_,value){
var ___$1 = this;
return cljs.core.reset_BANG_(atom_frame_updated,value);
}));


cm.on("change",pinkgorilla.codemirror.parinfer_events.parinfer_on_change);

cm.on("beforeChange",pinkgorilla.codemirror.parinfer_events.parinfer_before_change);

return cm.on("cursorActivity",pinkgorilla.codemirror.parinfer_events.parinfer_on_cursor_activity);
});

//# sourceMappingURL=pinkgorilla.codemirror.parinfer_events.js.map
