goog.provide('pinkgorilla.kernel.guard');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.analyzer');
goog.require('cljs.compiler');
/**
 * each time the watchdog has a chance to run, this var is set with the current time
 */
pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_ = (0);
pinkgorilla.kernel.guard.min_max_eval_duration = (3000);
/**
 * The number of msec for the watchdog period.
 *          This value has to be much lower than min-max-eval-duration.
 */
pinkgorilla.kernel.guard.watchdog_period = (pinkgorilla.kernel.guard.min_max_eval_duration / (10));
pinkgorilla.kernel.guard.runonce = (function pinkgorilla$kernel$guard$runonce(f){
var ran = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
return (function() { 
var G__43550__delegate = function (args){
if(cljs.core.truth_(cljs.core.deref(ran))){
return null;
} else {
cljs.core.reset_BANG_(ran,true);

return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}
};
var G__43550 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__43551__i = 0, G__43551__a = new Array(arguments.length -  0);
while (G__43551__i < G__43551__a.length) {G__43551__a[G__43551__i] = arguments[G__43551__i + 0]; ++G__43551__i;}
  args = new cljs.core.IndexedSeq(G__43551__a,0,null);
} 
return G__43550__delegate.call(this,args);};
G__43550.cljs$lang$maxFixedArity = 0;
G__43550.cljs$lang$applyTo = (function (arglist__43552){
var args = cljs.core.seq(arglist__43552);
return G__43550__delegate(args);
});
G__43550.cljs$core$IFn$_invoke$arity$variadic = G__43550__delegate;
return G__43550;
})()
;
});
pinkgorilla.kernel.guard.tick = (function pinkgorilla$kernel$guard$tick(){
return (pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_ = cljs.core.system_time());
});
/**
 * reset the *watchdog-tick* to the current time once in a while
 */
pinkgorilla.kernel.guard.run_watchdog_STAR_ = (function pinkgorilla$kernel$guard$run_watchdog_STAR_(){
pinkgorilla.kernel.guard.tick();

var c__29274__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_43533){
var state_val_43534 = (state_43533[(1)]);
if((state_val_43534 === (1))){
var state_43533__$1 = state_43533;
var statearr_43535_43553 = state_43533__$1;
(statearr_43535_43553[(2)] = null);

(statearr_43535_43553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (2))){
var inst_43525 = cljs.core.async.timeout(pinkgorilla.kernel.guard.watchdog_period);
var state_43533__$1 = state_43533;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43533__$1,(4),inst_43525);
} else {
if((state_val_43534 === (3))){
var inst_43531 = (state_43533[(2)]);
var state_43533__$1 = state_43533;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43533__$1,inst_43531);
} else {
if((state_val_43534 === (4))){
var inst_43527 = (state_43533[(2)]);
var inst_43528 = pinkgorilla.kernel.guard.tick();
var state_43533__$1 = (function (){var statearr_43536 = state_43533;
(statearr_43536[(7)] = inst_43527);

(statearr_43536[(8)] = inst_43528);

return statearr_43536;
})();
var statearr_43537_43554 = state_43533__$1;
(statearr_43537_43554[(2)] = null);

(statearr_43537_43554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__29239__auto__ = null;
var pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__29239__auto____0 = (function (){
var statearr_43538 = [null,null,null,null,null,null,null,null,null];
(statearr_43538[(0)] = pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__29239__auto__);

(statearr_43538[(1)] = (1));

return statearr_43538;
});
var pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__29239__auto____1 = (function (state_43533){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_43533);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e43539){var ex__29242__auto__ = e43539;
var statearr_43540_43555 = state_43533;
(statearr_43540_43555[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_43533[(4)]))){
var statearr_43541_43556 = state_43533;
(statearr_43541_43556[(1)] = cljs.core.first((state_43533[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43557 = state_43533;
state_43533 = G__43557;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__29239__auto__ = function(state_43533){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__29239__auto____0.call(this);
case 1:
return pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__29239__auto____1.call(this,state_43533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__29239__auto____0;
pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__29239__auto____1;
return pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_43542 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_43542[(6)] = c__29274__auto__);

return statearr_43542;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));

return c__29274__auto__;
});
pinkgorilla.kernel.guard.run_watchdog_once = pinkgorilla.kernel.guard.runonce(pinkgorilla.kernel.guard.run_watchdog_STAR_);
pinkgorilla.kernel.guard.watchdog = (function pinkgorilla$kernel$guard$watchdog(){
pinkgorilla.kernel.guard.tick();

return (pinkgorilla.kernel.guard.run_watchdog_once.cljs$core$IFn$_invoke$arity$0 ? pinkgorilla.kernel.guard.run_watchdog_once.cljs$core$IFn$_invoke$arity$0() : pinkgorilla.kernel.guard.run_watchdog_once.call(null));
});
pinkgorilla.kernel.guard.guard = (function pinkgorilla$kernel$guard$guard(max_eval_duration){
if(((cljs.core.system_time() - pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_) > max_eval_duration)){
if(cljs.core.truth_(confirm(["A KLIPSE snippet has been running for more than ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_eval_duration)," milliseconds. This is often because of a long-running computation or infinite loop. Would you like to interrupt the snippet? \n OK to interrupt the evaluation.\n Cancel to continue."].join('')))){
throw "Infinite Loop";
} else {
}

return (pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_ = cljs.core.system_time());
} else {
return null;
}
});
goog.exportSymbol('pinkgorilla.kernel.guard.guard', pinkgorilla.kernel.guard.guard);
/**
 * same as cljs.compiler/emits with insertion of a `guard()` call before if and recur (emitted as continue) statement.
 * 
 *   Limitations:
 *   1. It doesn't prevent infinite loop in imported code e.g. (reduce + (range)
 *   
 */
pinkgorilla.kernel.guard.my_emits = (function pinkgorilla$kernel$guard$my_emits(var_args){
var args__4795__auto__ = [];
var len__4789__auto___43558 = arguments.length;
var i__4790__auto___43559 = (0);
while(true){
if((i__4790__auto___43559 < len__4789__auto___43558)){
args__4795__auto__.push((arguments[i__4790__auto___43559]));

var G__43560 = (i__4790__auto___43559 + (1));
i__4790__auto___43559 = G__43560;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return pinkgorilla.kernel.guard.my_emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(pinkgorilla.kernel.guard.my_emits.cljs$core$IFn$_invoke$arity$variadic = (function (max_eval_duration,xs){
if(cljs.core.truth_(((typeof cljs.core.first(xs) === 'string')?cljs.core.re_matches(/^(if|continue).*/,cljs.core.first(xs)):false))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["klipse_clj.lang.clojure.guard.guard(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_eval_duration),");"].join('')], 0));
} else {
}

var seq__43546_43561 = cljs.core.seq(xs);
var chunk__43547_43562 = null;
var count__43548_43563 = (0);
var i__43549_43564 = (0);
while(true){
if((i__43549_43564 < count__43548_43563)){
var x_43565 = chunk__43547_43562.cljs$core$IIndexed$_nth$arity$2(null,i__43549_43564);
if((x_43565 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(x_43565)){
cljs.compiler.emit(x_43565);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(x_43565)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.guard.my_emits,max_eval_duration,x_43565);
} else {
if(goog.isFunction(x_43565)){
(x_43565.cljs$core$IFn$_invoke$arity$0 ? x_43565.cljs$core$IFn$_invoke$arity$0() : x_43565.call(null));
} else {
var s_43566 = cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x_43565], 0));
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__43546_43561,chunk__43547_43562,count__43548_43563,i__43549_43564,s_43566,x_43565){
return (function (p1__43543_SHARP_){
return (p1__43543_SHARP_ + ((s_43566).length));
});})(seq__43546_43561,chunk__43547_43562,count__43548_43563,i__43549_43564,s_43566,x_43565))
);
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_43566], 0));

}
}
}
}


var G__43567 = seq__43546_43561;
var G__43568 = chunk__43547_43562;
var G__43569 = count__43548_43563;
var G__43570 = (i__43549_43564 + (1));
seq__43546_43561 = G__43567;
chunk__43547_43562 = G__43568;
count__43548_43563 = G__43569;
i__43549_43564 = G__43570;
continue;
} else {
var temp__5735__auto___43571 = cljs.core.seq(seq__43546_43561);
if(temp__5735__auto___43571){
var seq__43546_43572__$1 = temp__5735__auto___43571;
if(cljs.core.chunked_seq_QMARK_(seq__43546_43572__$1)){
var c__4609__auto___43573 = cljs.core.chunk_first(seq__43546_43572__$1);
var G__43574 = cljs.core.chunk_rest(seq__43546_43572__$1);
var G__43575 = c__4609__auto___43573;
var G__43576 = cljs.core.count(c__4609__auto___43573);
var G__43577 = (0);
seq__43546_43561 = G__43574;
chunk__43547_43562 = G__43575;
count__43548_43563 = G__43576;
i__43549_43564 = G__43577;
continue;
} else {
var x_43578 = cljs.core.first(seq__43546_43572__$1);
if((x_43578 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(x_43578)){
cljs.compiler.emit(x_43578);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(x_43578)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.guard.my_emits,max_eval_duration,x_43578);
} else {
if(goog.isFunction(x_43578)){
(x_43578.cljs$core$IFn$_invoke$arity$0 ? x_43578.cljs$core$IFn$_invoke$arity$0() : x_43578.call(null));
} else {
var s_43579 = cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x_43578], 0));
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__43546_43561,chunk__43547_43562,count__43548_43563,i__43549_43564,s_43579,x_43578,seq__43546_43572__$1,temp__5735__auto___43571){
return (function (p1__43543_SHARP_){
return (p1__43543_SHARP_ + ((s_43579).length));
});})(seq__43546_43561,chunk__43547_43562,count__43548_43563,i__43549_43564,s_43579,x_43578,seq__43546_43572__$1,temp__5735__auto___43571))
);
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_43579], 0));

}
}
}
}


var G__43580 = cljs.core.next(seq__43546_43572__$1);
var G__43581 = null;
var G__43582 = (0);
var G__43583 = (0);
seq__43546_43561 = G__43580;
chunk__43547_43562 = G__43581;
count__43548_43563 = G__43582;
i__43549_43564 = G__43583;
continue;
}
} else {
}
}
break;
}

return null;
}));

(pinkgorilla.kernel.guard.my_emits.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.kernel.guard.my_emits.cljs$lang$applyTo = (function (seq43544){
var G__43545 = cljs.core.first(seq43544);
var seq43544__$1 = cljs.core.next(seq43544);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43545,seq43544__$1);
}));


//# sourceMappingURL=pinkgorilla.kernel.guard.js.map
