goog.provide('pinkgorilla.kernel.nrepl');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('cljs_uuid_utils.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('chord.client');
goog.require('re_frame.core');
goog.require('cljs.spec.alpha');
goog.require('pinkgorilla.notifications');
goog.require('pinkgorilla.kernel.cljs_helper');
goog.require('pinkgorilla.kernel.nrepl_specs');
if((typeof pinkgorilla !== 'undefined') && (typeof pinkgorilla.kernel !== 'undefined') && (typeof pinkgorilla.kernel.nrepl !== 'undefined') && (typeof pinkgorilla.kernel.nrepl.ws_repl !== 'undefined')){
} else {
pinkgorilla.kernel.nrepl.ws_repl = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"channel","channel",734187692),null,new cljs.core.Keyword(null,"session-id","session-id",-1147060351),null,new cljs.core.Keyword(null,"evaluations","evaluations",57802423),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ciders","ciders",-1421942407),cljs.core.PersistentArrayMap.EMPTY], null));
}
/**
 * awb99: TODO: if websocket is nil, this will throw! (or not?).
 * This could be the error of some of the notebooks not loading.
 * Why dont we keep the core.async channels open all the time. And when we have a
 * websocket connection, then the messages get sent. Or we just dump messages that happen
 * before the socket gets opened. But in this case we have to LOG message dumping.
 * I have seen situations where the first eval does not go through. Might be this issue.
 * 
 * - generates request id
 * - sends message to websocket (so nrepl/cider can process the request)
 * - saves the callback function into a lookup map to an atom
 * - returns the val id.
 * 
 */
pinkgorilla.kernel.nrepl.send_message_BANG_ = (function pinkgorilla$kernel$nrepl$send_message_BANG_(key,message,callback){
var eval_id = cljs_uuid_utils.core.uuid_string(cljs_uuid_utils.core.make_random_uuid());
var nrepl_msg = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),eval_id,new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"session-id","session-id",-1147060351).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl))], null)], 0));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(eval_id)], null),callback);

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",53,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ws sending ws message: ",nrepl_msg], null);
}),null)),null,2041280208);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl)),nrepl_msg);

return eval_id;
});
pinkgorilla.kernel.nrepl.eval_BANG_ = (function pinkgorilla$kernel$nrepl$eval_BANG_(segment_id,code){
return pinkgorilla.kernel.nrepl.send_message_BANG_(new cljs.core.Keyword(null,"evaluations","evaluations",57802423),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),"eval",new cljs.core.Keyword(null,"code","code",1586293142),code], null),segment_id);
});
pinkgorilla.kernel.nrepl.send_cider_message_BANG_ = (function pinkgorilla$kernel$nrepl$send_cider_message_BANG_(message,callback){
return pinkgorilla.kernel.nrepl.send_message_BANG_(new cljs.core.Keyword(null,"ciders","ciders",-1421942407),message,callback);
});
/**
 * Query the REPL server for autocompletion suggestions. Relies on the cider-nrepl middleware.
 *   We call the given callback with the list of symbols once the REPL server replies.
 */
pinkgorilla.kernel.nrepl.get_completions = (function pinkgorilla$kernel$nrepl$get_completions(symbol,ns,context,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"op","op",-1882987955),"complete",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns,new cljs.core.Keyword(null,"context","context",-830191113),context], null),(function (msg){
var G__46683 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46682_SHARP_){
return new cljs.core.Keyword(null,"candidate","candidate",-940308314).cljs$core$IFn$_invoke$arity$1(p1__46682_SHARP_);
}),new cljs.core.Keyword(null,"completions","completions",-190930179).cljs$core$IFn$_invoke$arity$1(msg));
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__46683) : callback.call(null,G__46683));
}));
});
/**
 * Queries the REPL server for docs for the given symbol. Relies on the cider-nrepl middleware.
 *   Calls back with the documentation text
 */
pinkgorilla.kernel.nrepl.get_completion_doc = (function pinkgorilla$kernel$nrepl$get_completion_doc(symbol,ns,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"complete-doc",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null),(function (msg){
var G__46684 = new cljs.core.Keyword(null,"completion-doc","completion-doc",792734283).cljs$core$IFn$_invoke$arity$1(msg);
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__46684) : callback.call(null,G__46684));
}));
});
/**
 * resolve a symbol to get its namespace takes the symbol and the namespace that should be used as context.
 *   Relies on the cider-nrepl middleware. Calls back with the symbol and the symbol's namespace
 */
pinkgorilla.kernel.nrepl.resolve_symbol = (function pinkgorilla$kernel$nrepl$resolve_symbol(symbol,ns,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"info",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null),(function (msg){
var G__46685 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(msg)], null);
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__46685) : callback.call(null,G__46685));
}));
});
/**
 * converts (:value message)
 * nrepl has to serialize the value before it hits clojure.
 * So this value gets formatted with edn.
 * Since the message is packaged as edn too, we have edn within edn.
 * 
 */
pinkgorilla.kernel.nrepl.parse_value = (function pinkgorilla$kernel$nrepl$parse_value(value){
try{var data = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(value);
var data2 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(data);
return data2;
}catch (e46686){if((e46686 instanceof Error)){
var e = e46686;
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",109,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["parse-value ex: ",e," tried to parse: ",value], null);
}),null)),null,1636840120);
} else {
throw e46686;

}
}});
/**
 * processes an incoming message from websocket that comes from nrepl (and has cider enhancements)
 * dispatches events to reagent to update notebook state ui.
 */
pinkgorilla.kernel.nrepl.process_msg = (function pinkgorilla$kernel$nrepl$process_msg(message){
var map__46687 = message;
var map__46687__$1 = (((((!((map__46687 == null))))?(((((map__46687.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46687.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46687):map__46687);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46687__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var out = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46687__$1,new cljs.core.Keyword(null,"out","out",-910545517));
var err = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46687__$1,new cljs.core.Keyword(null,"err","err",-2089457205));
var root_ex = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46687__$1,new cljs.core.Keyword(null,"root-ex","root-ex",-1080814778));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46687__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46687__$1,new cljs.core.Keyword(null,"value","value",305978217));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46687__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var eval_id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(id);
var segment_id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluations","evaluations",57802423),eval_id], null));
var cider_cb = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ciders","ciders",-1421942407),eval_id], null));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",123,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ws rcvd message eval-id ",id," for segment ",segment_id], null);
}),null)),null,-1665525613);

if(cljs.core.truth_(segment_id)){
if(cljs.core.truth_(ns)){
var data = pinkgorilla.kernel.nrepl.parse_value(value);
return pinkgorilla.kernel.cljs_helper.send_value.cljs$core$IFn$_invoke$arity$3(segment_id,data,ns);
} else {
if(cljs.core.truth_(out)){
var G__46689 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:console-response","evaluator:console-response",-650807352),segment_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"console-response","console-response",81719661),out], null)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__46689) : re_frame.core.dispatch.call(null,G__46689));
} else {
if(cljs.core.truth_(err)){
var error = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error-text","error-text",2021893718),err,new cljs.core.Keyword(null,"segment-id","segment-id",1810133590),segment_id], null));
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op","op",-1882987955),"stacktrace"], null),(function (msg){
var status__$1 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(msg);
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",155,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["err status: ",status__$1], null);
}),null)),null,-272454707);

if(cljs.core.contains_QMARK_(status__$1,new cljs.core.Keyword(null,"done","done",-889844188))){
var G__46690 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:error-response","evaluator:error-response",1375419587),cljs.core.deref(error)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__46690) : re_frame.core.dispatch.call(null,G__46690));
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(error,(function (err__$1,ex){
if(cljs.core.truth_(new cljs.core.Keyword(null,"exception","exception",-335277064).cljs$core$IFn$_invoke$arity$1(err__$1))){
return cljs.core.assoc_in(err__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"cause","cause",231901252)], null),new cljs.core.Keyword(null,"exception","exception",-335277064).cljs$core$IFn$_invoke$arity$1(ex));
} else {
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ex,err__$1], 0));
}
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"exception","exception",-335277064),msg], null));
}
}));
} else {
if(cljs.core.truth_(root_ex)){
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",167,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got root-ex",root_ex,"for",segment_id], null);
}),null)),null,800264839);
} else {
if(cljs.core.contains_QMARK_(status,new cljs.core.Keyword(null,"done","done",-889844188))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluations","evaluations",57802423),id], null));

var G__46691 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:done-response","evaluator:done-response",1140676326),segment_id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__46691) : re_frame.core.dispatch.call(null,G__46691));
} else {
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",176,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rcvd unhandled segment message: ",message], null);
}),null)),null,-1695620625);

}
}
}
}
}
} else {
if(cljs.core.truth_(cider_cb)){
if(cljs.spec.alpha.valid_QMARK_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("nrepl-msg","stacktrace-msg","nrepl-msg/stacktrace-msg",1039649502),message)){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",183,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rcvd valid stacktrace: ",message], null);
}),null)),null,1220659692);
} else {
}

(cider_cb.cljs$core$IFn$_invoke$arity$1 ? cider_cb.cljs$core$IFn$_invoke$arity$1(message) : cider_cb.call(null,message));

if(cljs.core.contains_QMARK_(status,new cljs.core.Keyword(null,"done","done",-889844188))){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ciders","ciders",-1421942407),id], null));
} else {
return null;
}
} else {
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",189,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rcvd neither segment nor cider: ",message], null);
}),null)),null,2045532033);

}
}
});
pinkgorilla.kernel.nrepl.set_clj_kernel_status = (function pinkgorilla$kernel$nrepl$set_clj_kernel_status(connected,session_id){
var G__46692 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"kernel-clj-status-set","kernel-clj-status-set",-1158664458),connected,session_id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__46692) : re_frame.core.dispatch.call(null,G__46692));
});
pinkgorilla.kernel.nrepl.receive_msgs_BANG_ = (function pinkgorilla$kernel$nrepl$receive_msgs_BANG_(ws_chan,msg_chan){
var c__29274__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_46781){
var state_val_46782 = (state_46781[(1)]);
if((state_val_46782 === (7))){
var state_46781__$1 = state_46781;
var statearr_46783_47058 = state_46781__$1;
(statearr_46783_47058[(2)] = false);

(statearr_46783_47058[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (1))){
var state_46781__$1 = state_46781;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46781__$1,(2),ws_chan);
} else {
if((state_val_46782 === (4))){
var state_46781__$1 = state_46781;
var statearr_46784_47059 = state_46781__$1;
(statearr_46784_47059[(2)] = false);

(statearr_46784_47059[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (15))){
var inst_46724 = (state_46781[(7)]);
var inst_46726 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc,new cljs.core.Keyword(null,"session-id","session-id",-1147060351),inst_46724);
var inst_46727 = pinkgorilla.kernel.nrepl.set_clj_kernel_status(true,inst_46724);
var state_46781__$1 = (function (){var statearr_46786 = state_46781;
(statearr_46786[(8)] = inst_46726);

return statearr_46786;
})();
var statearr_46787_47061 = state_46781__$1;
(statearr_46787_47061[(2)] = inst_46727);

(statearr_46787_47061[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (13))){
var inst_46718 = (state_46781[(9)]);
var inst_46719 = (state_46781[(10)]);
var inst_46777 = (inst_46719.cljs$core$IFn$_invoke$arity$1 ? inst_46719.cljs$core$IFn$_invoke$arity$1(inst_46718) : inst_46719.call(null,inst_46718));
var state_46781__$1 = state_46781;
var statearr_46789_47062 = state_46781__$1;
(statearr_46789_47062[(2)] = inst_46777);

(statearr_46789_47062[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (6))){
var state_46781__$1 = state_46781;
var statearr_46790_47063 = state_46781__$1;
(statearr_46790_47063[(2)] = true);

(statearr_46790_47063[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (17))){
var inst_46718 = (state_46781[(9)]);
var inst_46716 = (state_46781[(11)]);
var inst_46719 = (state_46781[(10)]);
var inst_46717 = (state_46781[(12)]);
var inst_46733 = (state_46781[(2)]);
var inst_46773 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_46774 = (function (){var map__46693 = inst_46716;
var message = inst_46717;
var error = inst_46718;
var fail_fn = inst_46719;
var c__29274__auto____$1 = inst_46773;
return (function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_46771){
var state_val_46772 = (state_46771[(1)]);
if((state_val_46772 === (7))){
var inst_46753 = (state_46771[(2)]);
var state_46771__$1 = state_46771;
if(cljs.core.truth_(inst_46753)){
var statearr_46791_47066 = state_46771__$1;
(statearr_46791_47066[(1)] = (11));

} else {
var statearr_46792_47068 = state_46771__$1;
(statearr_46792_47068[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (1))){
var state_46771__$1 = state_46771;
var statearr_46793_47069 = state_46771__$1;
(statearr_46793_47069[(2)] = null);

(statearr_46793_47069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (4))){
var inst_46737 = (state_46771[(7)]);
var inst_46737__$1 = (state_46771[(2)]);
var inst_46739 = (inst_46737__$1 == null);
var inst_46740 = cljs.core.not(inst_46739);
var state_46771__$1 = (function (){var statearr_46794 = state_46771;
(statearr_46794[(7)] = inst_46737__$1);

return statearr_46794;
})();
if(inst_46740){
var statearr_46795_47071 = state_46771__$1;
(statearr_46795_47071[(1)] = (5));

} else {
var statearr_46796_47072 = state_46771__$1;
(statearr_46796_47072[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (15))){
var inst_46760 = (state_46771[(8)]);
var inst_46765 = (fail_fn.cljs$core$IFn$_invoke$arity$1 ? fail_fn.cljs$core$IFn$_invoke$arity$1(inst_46760) : fail_fn.call(null,inst_46760));
var state_46771__$1 = state_46771;
var statearr_46797_47074 = state_46771__$1;
(statearr_46797_47074[(2)] = inst_46765);

(statearr_46797_47074[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (13))){
var inst_46759 = (state_46771[(9)]);
var inst_46758 = (state_46771[(2)]);
var inst_46759__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46758,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_46760 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46758,new cljs.core.Keyword(null,"error","error",-978969032));
var state_46771__$1 = (function (){var statearr_46798 = state_46771;
(statearr_46798[(9)] = inst_46759__$1);

(statearr_46798[(8)] = inst_46760);

return statearr_46798;
})();
if(cljs.core.truth_(inst_46759__$1)){
var statearr_46799_47076 = state_46771__$1;
(statearr_46799_47076[(1)] = (14));

} else {
var statearr_46800_47077 = state_46771__$1;
(statearr_46800_47077[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (6))){
var state_46771__$1 = state_46771;
var statearr_46801_47078 = state_46771__$1;
(statearr_46801_47078[(2)] = false);

(statearr_46801_47078[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (3))){
var inst_46769 = (state_46771[(2)]);
var state_46771__$1 = state_46771;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46771__$1,inst_46769);
} else {
if((state_val_46772 === (12))){
var inst_46737 = (state_46771[(7)]);
var state_46771__$1 = state_46771;
var statearr_46802_47080 = state_46771__$1;
(statearr_46802_47080[(2)] = inst_46737);

(statearr_46802_47080[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (2))){
var state_46771__$1 = state_46771;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46771__$1,(4),ws_chan);
} else {
if((state_val_46772 === (11))){
var inst_46737 = (state_46771[(7)]);
var inst_46755 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_46737);
var state_46771__$1 = state_46771;
var statearr_46803_47081 = state_46771__$1;
(statearr_46803_47081[(2)] = inst_46755);

(statearr_46803_47081[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (9))){
var state_46771__$1 = state_46771;
var statearr_46804_47082 = state_46771__$1;
(statearr_46804_47082[(2)] = false);

(statearr_46804_47082[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (5))){
var inst_46737 = (state_46771[(7)]);
var inst_46742 = inst_46737.cljs$lang$protocol_mask$partition0$;
var inst_46743 = (inst_46742 & (64));
var inst_46744 = inst_46737.cljs$core$ISeq$;
var inst_46745 = (cljs.core.PROTOCOL_SENTINEL === inst_46744);
var inst_46746 = ((inst_46743) || (inst_46745));
var state_46771__$1 = state_46771;
if(cljs.core.truth_(inst_46746)){
var statearr_46805_47083 = state_46771__$1;
(statearr_46805_47083[(1)] = (8));

} else {
var statearr_46806_47084 = state_46771__$1;
(statearr_46806_47084[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (14))){
var inst_46759 = (state_46771[(9)]);
var inst_46762 = pinkgorilla.kernel.nrepl.process_msg(inst_46759);
var state_46771__$1 = (function (){var statearr_46807 = state_46771;
(statearr_46807[(10)] = inst_46762);

return statearr_46807;
})();
var statearr_46808_47085 = state_46771__$1;
(statearr_46808_47085[(2)] = null);

(statearr_46808_47085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (16))){
var inst_46767 = (state_46771[(2)]);
var state_46771__$1 = state_46771;
var statearr_46809_47086 = state_46771__$1;
(statearr_46809_47086[(2)] = inst_46767);

(statearr_46809_47086[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (10))){
var inst_46750 = (state_46771[(2)]);
var state_46771__$1 = state_46771;
var statearr_46810_47087 = state_46771__$1;
(statearr_46810_47087[(2)] = inst_46750);

(statearr_46810_47087[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (8))){
var state_46771__$1 = state_46771;
var statearr_46811_47088 = state_46771__$1;
(statearr_46811_47088[(2)] = true);

(statearr_46811_47088[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto__ = null;
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto____0 = (function (){
var statearr_46812 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46812[(0)] = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto__);

(statearr_46812[(1)] = (1));

return statearr_46812;
});
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto____1 = (function (state_46771){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_46771);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e46813){var ex__29242__auto__ = e46813;
var statearr_46814_47089 = state_46771;
(statearr_46814_47089[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_46771[(4)]))){
var statearr_46815_47090 = state_46771;
(statearr_46815_47090[(1)] = cljs.core.first((state_46771[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47091 = state_46771;
state_46771 = G__47091;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto__ = function(state_46771){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto____1.call(this,state_46771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto____0;
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto____1;
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_46816 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_46816[(6)] = c__29274__auto____$1);

return statearr_46816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
});
})();
var inst_46775 = cljs.core.async.impl.dispatch.run(inst_46774);
var state_46781__$1 = (function (){var statearr_46817 = state_46781;
(statearr_46817[(13)] = inst_46733);

(statearr_46817[(14)] = inst_46775);

return statearr_46817;
})();
var statearr_46818_47092 = state_46781__$1;
(statearr_46818_47092[(2)] = inst_46773);

(statearr_46818_47092[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (3))){
var inst_46695 = (state_46781[(15)]);
var inst_46700 = inst_46695.cljs$lang$protocol_mask$partition0$;
var inst_46701 = (inst_46700 & (64));
var inst_46702 = inst_46695.cljs$core$ISeq$;
var inst_46703 = (cljs.core.PROTOCOL_SENTINEL === inst_46702);
var inst_46704 = ((inst_46701) || (inst_46703));
var state_46781__$1 = state_46781;
if(cljs.core.truth_(inst_46704)){
var statearr_46819_47093 = state_46781__$1;
(statearr_46819_47093[(1)] = (6));

} else {
var statearr_46820_47094 = state_46781__$1;
(statearr_46820_47094[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (12))){
var inst_46718 = (state_46781[(9)]);
var inst_46724 = (state_46781[(7)]);
var inst_46716 = (state_46781[(11)]);
var inst_46719 = (state_46781[(10)]);
var inst_46717 = (state_46781[(12)]);
var inst_46721 = (function (){var map__46693 = inst_46716;
var message = inst_46717;
var error = inst_46718;
var fail_fn = inst_46719;
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got initial message ",message], null);
});
})();
var inst_46722 = (new cljs.core.Delay(inst_46721,null));
var inst_46723 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",205,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_46722,null,1894070491);
var inst_46724__$1 = new cljs.core.Keyword(null,"new-session","new-session",-1358977165).cljs$core$IFn$_invoke$arity$1(inst_46717);
var state_46781__$1 = (function (){var statearr_46821 = state_46781;
(statearr_46821[(7)] = inst_46724__$1);

(statearr_46821[(16)] = inst_46723);

return statearr_46821;
})();
if(cljs.core.truth_(inst_46724__$1)){
var statearr_46822_47095 = state_46781__$1;
(statearr_46822_47095[(1)] = (15));

} else {
var statearr_46823_47096 = state_46781__$1;
(statearr_46823_47096[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (2))){
var inst_46695 = (state_46781[(15)]);
var inst_46695__$1 = (state_46781[(2)]);
var inst_46697 = (inst_46695__$1 == null);
var inst_46698 = cljs.core.not(inst_46697);
var state_46781__$1 = (function (){var statearr_46824 = state_46781;
(statearr_46824[(15)] = inst_46695__$1);

return statearr_46824;
})();
if(inst_46698){
var statearr_46825_47097 = state_46781__$1;
(statearr_46825_47097[(1)] = (3));

} else {
var statearr_46826_47098 = state_46781__$1;
(statearr_46826_47098[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (11))){
var inst_46718 = (state_46781[(9)]);
var inst_46716 = (state_46781[(11)]);
var inst_46717 = (state_46781[(12)]);
var inst_46716__$1 = (state_46781[(2)]);
var inst_46717__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46716__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_46718__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46716__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var inst_46719 = (function (){var map__46693 = inst_46716__$1;
var message = inst_46717__$1;
var error = inst_46718__$1;
return (function (error__$1){
cljs.core.async.close_BANG_(ws_chan);

cljs.core.async.close_BANG_(msg_chan);

pinkgorilla.notifications.add_notification(pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"danger","danger",-624338030),["clj-kernel Fatal Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(error__$1)].join('')));

return pinkgorilla.kernel.nrepl.set_clj_kernel_status(false,null);
});
})();
var state_46781__$1 = (function (){var statearr_46827 = state_46781;
(statearr_46827[(9)] = inst_46718__$1);

(statearr_46827[(11)] = inst_46716__$1);

(statearr_46827[(10)] = inst_46719);

(statearr_46827[(12)] = inst_46717__$1);

return statearr_46827;
})();
if(cljs.core.truth_(inst_46717__$1)){
var statearr_46828_47099 = state_46781__$1;
(statearr_46828_47099[(1)] = (12));

} else {
var statearr_46829_47100 = state_46781__$1;
(statearr_46829_47100[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (9))){
var inst_46695 = (state_46781[(15)]);
var inst_46713 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_46695);
var state_46781__$1 = state_46781;
var statearr_46830_47101 = state_46781__$1;
(statearr_46830_47101[(2)] = inst_46713);

(statearr_46830_47101[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (5))){
var inst_46711 = (state_46781[(2)]);
var state_46781__$1 = state_46781;
if(cljs.core.truth_(inst_46711)){
var statearr_46831_47102 = state_46781__$1;
(statearr_46831_47102[(1)] = (9));

} else {
var statearr_46832_47103 = state_46781__$1;
(statearr_46832_47103[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (14))){
var inst_46779 = (state_46781[(2)]);
var state_46781__$1 = state_46781;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46781__$1,inst_46779);
} else {
if((state_val_46782 === (16))){
var inst_46718 = (state_46781[(9)]);
var inst_46724 = (state_46781[(7)]);
var inst_46716 = (state_46781[(11)]);
var inst_46719 = (state_46781[(10)]);
var inst_46717 = (state_46781[(12)]);
var inst_46729 = (function (){var map__46693 = inst_46716;
var message = inst_46717;
var error = inst_46718;
var fail_fn = inst_46719;
var temp__5733__auto__ = inst_46724;
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["could not extract session id!!! "], null);
});
})();
var inst_46730 = (new cljs.core.Delay(inst_46729,null));
var inst_46731 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",210,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_46730,null,154249987);
var state_46781__$1 = state_46781;
var statearr_46833_47104 = state_46781__$1;
(statearr_46833_47104[(2)] = inst_46731);

(statearr_46833_47104[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (10))){
var inst_46695 = (state_46781[(15)]);
var state_46781__$1 = state_46781;
var statearr_46834_47105 = state_46781__$1;
(statearr_46834_47105[(2)] = inst_46695);

(statearr_46834_47105[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (8))){
var inst_46708 = (state_46781[(2)]);
var state_46781__$1 = state_46781;
var statearr_46835_47106 = state_46781__$1;
(statearr_46835_47106[(2)] = inst_46708);

(statearr_46835_47106[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto__ = null;
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto____0 = (function (){
var statearr_46836 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46836[(0)] = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto__);

(statearr_46836[(1)] = (1));

return statearr_46836;
});
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto____1 = (function (state_46781){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_46781);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e46837){var ex__29242__auto__ = e46837;
var statearr_46838_47107 = state_46781;
(statearr_46838_47107[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_46781[(4)]))){
var statearr_46839_47108 = state_46781;
(statearr_46839_47108[(1)] = cljs.core.first((state_46781[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47109 = state_46781;
state_46781 = G__47109;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto__ = function(state_46781){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto____1.call(this,state_46781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto____0;
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto____1;
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_46840 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_46840[(6)] = c__29274__auto__);

return statearr_46840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));

return c__29274__auto__;
});
pinkgorilla.kernel.nrepl.start_repl_BANG_ = (function pinkgorilla$kernel$nrepl$start_repl_BANG_(ws_url){
var c__29274__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_46964){
var state_val_46965 = (state_46964[(1)]);
if((state_val_46965 === (7))){
var state_46964__$1 = state_46964;
var statearr_46966_47110 = state_46964__$1;
(statearr_46966_47110[(2)] = false);

(statearr_46966_47110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (20))){
var inst_46873 = (state_46964[(7)]);
var inst_46894 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_46873);
var state_46964__$1 = state_46964;
var statearr_46967_47111 = state_46964__$1;
(statearr_46967_47111[(2)] = inst_46894);

(statearr_46967_47111[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (27))){
var state_46964__$1 = state_46964;
var statearr_46968_47112 = state_46964__$1;
(statearr_46968_47112[(2)] = null);

(statearr_46968_47112[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (1))){
var inst_46844 = [new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_46845 = [new cljs.core.Keyword(null,"edn","edn",1317840885)];
var inst_46846 = cljs.core.PersistentHashMap.fromArrays(inst_46844,inst_46845);
var inst_46847 = chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(ws_url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_46846], 0));
var state_46964__$1 = state_46964;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46964__$1,(2),inst_46847);
} else {
if((state_val_46965 === (24))){
var inst_46899 = (state_46964[(8)]);
var inst_46944 = (state_46964[(9)]);
var inst_46943 = cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl);
var inst_46944__$1 = new cljs.core.Keyword(null,"session-id","session-id",-1147060351).cljs$core$IFn$_invoke$arity$1(inst_46943);
var inst_46945 = ["clj-kernel error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46899)," - trying to recover with session ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46944__$1)].join('');
var inst_46946 = pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"danger","danger",-624338030),inst_46945);
var inst_46947 = pinkgorilla.notifications.add_notification(inst_46946);
var inst_46948 = cljs.core.async.timeout((3000));
var state_46964__$1 = (function (){var statearr_46969 = state_46964;
(statearr_46969[(9)] = inst_46944__$1);

(statearr_46969[(10)] = inst_46947);

return statearr_46969;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46964__$1,(38),inst_46948);
} else {
if((state_val_46965 === (39))){
var inst_46944 = (state_46964[(9)]);
var inst_46956 = (state_46964[(2)]);
var inst_46957 = (inst_46944 == null);
var inst_46873 = inst_46956;
var inst_46874 = inst_46957;
var state_46964__$1 = (function (){var statearr_46970 = state_46964;
(statearr_46970[(7)] = inst_46873);

(statearr_46970[(11)] = inst_46874);

return statearr_46970;
})();
var statearr_46971_47113 = state_46964__$1;
(statearr_46971_47113[(2)] = null);

(statearr_46971_47113[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (4))){
var state_46964__$1 = state_46964;
var statearr_46972_47114 = state_46964__$1;
(statearr_46972_47114[(2)] = false);

(statearr_46972_47114[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (15))){
var state_46964__$1 = state_46964;
var statearr_46973_47115 = state_46964__$1;
(statearr_46973_47115[(2)] = false);

(statearr_46973_47115[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (21))){
var inst_46873 = (state_46964[(7)]);
var state_46964__$1 = state_46964;
var statearr_46974_47116 = state_46964__$1;
(statearr_46974_47116[(2)] = inst_46873);

(statearr_46974_47116[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (31))){
var inst_46922 = (state_46964[(12)]);
var inst_46922__$1 = (state_46964[(2)]);
var state_46964__$1 = (function (){var statearr_46975 = state_46964;
(statearr_46975[(12)] = inst_46922__$1);

return statearr_46975;
})();
if(cljs.core.truth_(inst_46922__$1)){
var statearr_46976_47117 = state_46964__$1;
(statearr_46976_47117[(1)] = (32));

} else {
var statearr_46977_47118 = state_46964__$1;
(statearr_46977_47118[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (32))){
var inst_46898 = (state_46964[(13)]);
var inst_46922 = (state_46964[(12)]);
var state_46964__$1 = state_46964;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46964__$1,(35),inst_46898,inst_46922);
} else {
if((state_val_46965 === (33))){
var state_46964__$1 = state_46964;
var statearr_46978_47119 = state_46964__$1;
(statearr_46978_47119[(2)] = null);

(statearr_46978_47119[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (13))){
var inst_46962 = (state_46964[(2)]);
var state_46964__$1 = state_46964;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46964__$1,inst_46962);
} else {
if((state_val_46965 === (22))){
var inst_46897 = (state_46964[(14)]);
var inst_46899 = (state_46964[(8)]);
var inst_46897__$1 = (state_46964[(2)]);
var inst_46898 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46897__$1,new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174));
var inst_46899__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46897__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var inst_46900 = cljs.core.not(inst_46899__$1);
var state_46964__$1 = (function (){var statearr_46979 = state_46964;
(statearr_46979[(13)] = inst_46898);

(statearr_46979[(14)] = inst_46897__$1);

(statearr_46979[(8)] = inst_46899__$1);

return statearr_46979;
})();
if(inst_46900){
var statearr_46980_47120 = state_46964__$1;
(statearr_46980_47120[(1)] = (23));

} else {
var statearr_46981_47121 = state_46964__$1;
(statearr_46981_47121[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (36))){
var inst_46934 = (state_46964[(2)]);
var inst_46935 = [new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_46936 = [new cljs.core.Keyword(null,"edn","edn",1317840885)];
var inst_46937 = cljs.core.PersistentHashMap.fromArrays(inst_46935,inst_46936);
var inst_46938 = chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(ws_url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_46937], 0));
var state_46964__$1 = (function (){var statearr_46982 = state_46964;
(statearr_46982[(15)] = inst_46934);

return statearr_46982;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46964__$1,(37),inst_46938);
} else {
if((state_val_46965 === (29))){
var inst_46902 = (state_46964[(16)]);
var state_46964__$1 = state_46964;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46964__$1,(31),inst_46902);
} else {
if((state_val_46965 === (6))){
var state_46964__$1 = state_46964;
var statearr_46983_47122 = state_46964__$1;
(statearr_46983_47122[(2)] = true);

(statearr_46983_47122[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (28))){
var inst_46902 = (state_46964[(16)]);
var inst_46898 = (state_46964[(13)]);
var inst_46918 = (state_46964[(2)]);
var inst_46919 = pinkgorilla.kernel.nrepl.receive_msgs_BANG_(inst_46898,inst_46902);
var state_46964__$1 = (function (){var statearr_46984 = state_46964;
(statearr_46984[(17)] = inst_46919);

(statearr_46984[(18)] = inst_46918);

return statearr_46984;
})();
var statearr_46985_47123 = state_46964__$1;
(statearr_46985_47123[(2)] = null);

(statearr_46985_47123[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (25))){
var inst_46960 = (state_46964[(2)]);
var state_46964__$1 = state_46964;
var statearr_46986_47124 = state_46964__$1;
(statearr_46986_47124[(2)] = inst_46960);

(statearr_46986_47124[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (34))){
var inst_46929 = (state_46964[(2)]);
var state_46964__$1 = state_46964;
var statearr_46987_47125 = state_46964__$1;
(statearr_46987_47125[(2)] = inst_46929);

(statearr_46987_47125[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (17))){
var state_46964__$1 = state_46964;
var statearr_46988_47126 = state_46964__$1;
(statearr_46988_47126[(2)] = true);

(statearr_46988_47126[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (3))){
var inst_46849 = (state_46964[(19)]);
var inst_46854 = inst_46849.cljs$lang$protocol_mask$partition0$;
var inst_46855 = (inst_46854 & (64));
var inst_46856 = inst_46849.cljs$core$ISeq$;
var inst_46857 = (cljs.core.PROTOCOL_SENTINEL === inst_46856);
var inst_46858 = ((inst_46855) || (inst_46857));
var state_46964__$1 = state_46964;
if(cljs.core.truth_(inst_46858)){
var statearr_46989_47127 = state_46964__$1;
(statearr_46989_47127[(1)] = (6));

} else {
var statearr_46990_47128 = state_46964__$1;
(statearr_46990_47128[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (12))){
var inst_46873 = (state_46964[(7)]);
var inst_46878 = (inst_46873 == null);
var inst_46879 = cljs.core.not(inst_46878);
var state_46964__$1 = state_46964;
if(inst_46879){
var statearr_46991_47129 = state_46964__$1;
(statearr_46991_47129[(1)] = (14));

} else {
var statearr_46992_47130 = state_46964__$1;
(statearr_46992_47130[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (2))){
var inst_46849 = (state_46964[(19)]);
var inst_46849__$1 = (state_46964[(2)]);
var inst_46851 = (inst_46849__$1 == null);
var inst_46852 = cljs.core.not(inst_46851);
var state_46964__$1 = (function (){var statearr_46993 = state_46964;
(statearr_46993[(19)] = inst_46849__$1);

return statearr_46993;
})();
if(inst_46852){
var statearr_46994_47131 = state_46964__$1;
(statearr_46994_47131[(1)] = (3));

} else {
var statearr_46995_47132 = state_46964__$1;
(statearr_46995_47132[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (23))){
var inst_46902 = (state_46964[(16)]);
var inst_46874 = (state_46964[(11)]);
var inst_46902__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_46903 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc,new cljs.core.Keyword(null,"channel","channel",734187692),inst_46902__$1);
var state_46964__$1 = (function (){var statearr_46996 = state_46964;
(statearr_46996[(16)] = inst_46902__$1);

(statearr_46996[(20)] = inst_46903);

return statearr_46996;
})();
if(cljs.core.truth_(inst_46874)){
var statearr_46997_47133 = state_46964__$1;
(statearr_46997_47133[(1)] = (26));

} else {
var statearr_46998_47134 = state_46964__$1;
(statearr_46998_47134[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (35))){
var inst_46925 = (state_46964[(2)]);
var state_46964__$1 = (function (){var statearr_46999 = state_46964;
(statearr_46999[(21)] = inst_46925);

return statearr_46999;
})();
var statearr_47000_47135 = state_46964__$1;
(statearr_47000_47135[(2)] = null);

(statearr_47000_47135[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (19))){
var inst_46889 = (state_46964[(2)]);
var state_46964__$1 = state_46964;
var statearr_47001_47136 = state_46964__$1;
(statearr_47001_47136[(2)] = inst_46889);

(statearr_47001_47136[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (11))){
var inst_46849 = (state_46964[(19)]);
var inst_46870 = (state_46964[(22)]);
var inst_46870__$1 = (state_46964[(2)]);
var inst_46871 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46870__$1,new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174));
var inst_46872 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46870__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var inst_46873 = inst_46849;
var inst_46874 = true;
var state_46964__$1 = (function (){var statearr_47002 = state_46964;
(statearr_47002[(22)] = inst_46870__$1);

(statearr_47002[(7)] = inst_46873);

(statearr_47002[(23)] = inst_46872);

(statearr_47002[(24)] = inst_46871);

(statearr_47002[(11)] = inst_46874);

return statearr_47002;
})();
var statearr_47003_47137 = state_46964__$1;
(statearr_47003_47137[(2)] = null);

(statearr_47003_47137[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (9))){
var inst_46849 = (state_46964[(19)]);
var inst_46867 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_46849);
var state_46964__$1 = state_46964;
var statearr_47004_47138 = state_46964__$1;
(statearr_47004_47138[(2)] = inst_46867);

(statearr_47004_47138[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (5))){
var inst_46865 = (state_46964[(2)]);
var state_46964__$1 = state_46964;
if(cljs.core.truth_(inst_46865)){
var statearr_47005_47139 = state_46964__$1;
(statearr_47005_47139[(1)] = (9));

} else {
var statearr_47006_47140 = state_46964__$1;
(statearr_47006_47140[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (14))){
var inst_46873 = (state_46964[(7)]);
var inst_46881 = inst_46873.cljs$lang$protocol_mask$partition0$;
var inst_46882 = (inst_46881 & (64));
var inst_46883 = inst_46873.cljs$core$ISeq$;
var inst_46884 = (cljs.core.PROTOCOL_SENTINEL === inst_46883);
var inst_46885 = ((inst_46882) || (inst_46884));
var state_46964__$1 = state_46964;
if(cljs.core.truth_(inst_46885)){
var statearr_47007_47141 = state_46964__$1;
(statearr_47007_47141[(1)] = (17));

} else {
var statearr_47008_47142 = state_46964__$1;
(statearr_47008_47142[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (26))){
var inst_46902 = (state_46964[(16)]);
var inst_46898 = (state_46964[(13)]);
var inst_46897 = (state_46964[(14)]);
var inst_46899 = (state_46964[(8)]);
var inst_46870 = (state_46964[(22)]);
var inst_46873 = (state_46964[(7)]);
var inst_46874 = (state_46964[(11)]);
var inst_46913 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_46914 = (function (){var G__46842 = inst_46873;
var map__46843 = inst_46870;
var ws_channel = inst_46898;
var error = inst_46899;
var new_session = inst_46874;
var map__46876 = inst_46897;
var msg_ch = inst_46902;
var c__29274__auto____$1 = inst_46913;
return (function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_46911){
var state_val_46912 = (state_46911[(1)]);
if((state_val_46912 === (1))){
var inst_46905 = [new cljs.core.Keyword(null,"op","op",-1882987955)];
var inst_46906 = ["clone"];
var inst_46907 = cljs.core.PersistentHashMap.fromArrays(inst_46905,inst_46906);
var state_46911__$1 = state_46911;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46911__$1,(2),msg_ch,inst_46907);
} else {
if((state_val_46912 === (2))){
var inst_46909 = (state_46911[(2)]);
var state_46911__$1 = state_46911;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46911__$1,inst_46909);
} else {
return null;
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto__ = null;
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto____0 = (function (){
var statearr_47009 = [null,null,null,null,null,null,null];
(statearr_47009[(0)] = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto__);

(statearr_47009[(1)] = (1));

return statearr_47009;
});
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto____1 = (function (state_46911){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_46911);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e47010){var ex__29242__auto__ = e47010;
var statearr_47011_47143 = state_46911;
(statearr_47011_47143[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_46911[(4)]))){
var statearr_47012_47144 = state_46911;
(statearr_47012_47144[(1)] = cljs.core.first((state_46911[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47145 = state_46911;
state_46911 = G__47145;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto__ = function(state_46911){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto____1.call(this,state_46911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto____0;
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto____1;
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_47013 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_47013[(6)] = c__29274__auto____$1);

return statearr_47013;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
});
})();
var inst_46915 = cljs.core.async.impl.dispatch.run(inst_46914);
var state_46964__$1 = (function (){var statearr_47014 = state_46964;
(statearr_47014[(25)] = inst_46915);

return statearr_47014;
})();
var statearr_47015_47146 = state_46964__$1;
(statearr_47015_47146[(2)] = inst_46913);

(statearr_47015_47146[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (16))){
var inst_46892 = (state_46964[(2)]);
var state_46964__$1 = state_46964;
if(cljs.core.truth_(inst_46892)){
var statearr_47016_47147 = state_46964__$1;
(statearr_47016_47147[(1)] = (20));

} else {
var statearr_47017_47148 = state_46964__$1;
(statearr_47017_47148[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (38))){
var inst_46950 = (state_46964[(2)]);
var inst_46951 = [new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_46952 = [new cljs.core.Keyword(null,"edn","edn",1317840885)];
var inst_46953 = cljs.core.PersistentHashMap.fromArrays(inst_46951,inst_46952);
var inst_46954 = chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(ws_url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_46953], 0));
var state_46964__$1 = (function (){var statearr_47018 = state_46964;
(statearr_47018[(26)] = inst_46950);

return statearr_47018;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46964__$1,(39),inst_46954);
} else {
if((state_val_46965 === (30))){
var inst_46931 = (state_46964[(2)]);
var inst_46932 = cljs.core.async.timeout((3000));
var state_46964__$1 = (function (){var statearr_47019 = state_46964;
(statearr_47019[(27)] = inst_46931);

return statearr_47019;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46964__$1,(36),inst_46932);
} else {
if((state_val_46965 === (10))){
var inst_46849 = (state_46964[(19)]);
var state_46964__$1 = state_46964;
var statearr_47020_47149 = state_46964__$1;
(statearr_47020_47149[(2)] = inst_46849);

(statearr_47020_47149[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (18))){
var state_46964__$1 = state_46964;
var statearr_47021_47150 = state_46964__$1;
(statearr_47021_47150[(2)] = false);

(statearr_47021_47150[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (37))){
var inst_46940 = (state_46964[(2)]);
var inst_46873 = inst_46940;
var inst_46874 = false;
var state_46964__$1 = (function (){var statearr_47022 = state_46964;
(statearr_47022[(7)] = inst_46873);

(statearr_47022[(11)] = inst_46874);

return statearr_47022;
})();
var statearr_47023_47151 = state_46964__$1;
(statearr_47023_47151[(2)] = null);

(statearr_47023_47151[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46965 === (8))){
var inst_46862 = (state_46964[(2)]);
var state_46964__$1 = state_46964;
var statearr_47024_47152 = state_46964__$1;
(statearr_47024_47152[(2)] = inst_46862);

(statearr_47024_47152[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto__ = null;
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto____0 = (function (){
var statearr_47025 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47025[(0)] = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto__);

(statearr_47025[(1)] = (1));

return statearr_47025;
});
var pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto____1 = (function (state_46964){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_46964);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e47026){var ex__29242__auto__ = e47026;
var statearr_47027_47153 = state_46964;
(statearr_47027_47153[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_46964[(4)]))){
var statearr_47028_47154 = state_46964;
(statearr_47028_47154[(1)] = cljs.core.first((state_46964[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47155 = state_46964;
state_46964 = G__47155;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto__ = function(state_46964){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto____1.call(this,state_46964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto____0;
pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto____1;
return pinkgorilla$kernel$nrepl$start_repl_BANG__$_state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_47029 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_47029[(6)] = c__29274__auto__);

return statearr_47029;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));

return c__29274__auto__;
});
pinkgorilla.kernel.nrepl.clj_eval = (function pinkgorilla$kernel$nrepl$clj_eval(snippet,callback){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",274,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["clj-eval: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(snippet)].join('')], null);
}),null)),null,-524405110);

return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),"eval",new cljs.core.Keyword(null,"code","code",1586293142),snippet], null),(function (message){
var map__47030 = message;
var map__47030__$1 = (((((!((map__47030 == null))))?(((((map__47030.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47030.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47030):map__47030);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47030__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47030__$1,new cljs.core.Keyword(null,"value","value",305978217));
var data = pinkgorilla.kernel.nrepl.parse_value(value);
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",280,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["clj-eval ns: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data)].join('')], null);
}),null)),null,312399043);
var ___$1 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",281,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["data value:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942),new cljs.core.Keyword(null,"value","value",305978217)], null)))].join('')], null);
}),null)),null,1144578313);
if(cljs.core.truth_(ns)){
var v2 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942),new cljs.core.Keyword(null,"value","value",305978217)], null)));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",283,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["clj-eval result: ",v2," type: ",cljs.core.type(v2)], null);
}),null)),null,-1032852722);

return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(v2) : callback.call(null,v2));
} else {
return null;
}
}));
});
goog.exportSymbol('pinkgorilla.kernel.nrepl.clj_eval', pinkgorilla.kernel.nrepl.clj_eval);
/**
 * executes a clojure expression
 * and returns the result to the ```result-atom```
 */
pinkgorilla.kernel.nrepl.clj_eval_sync = (function pinkgorilla$kernel$nrepl$clj_eval_sync(result_atom,snippet){
var result_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__29274__auto___47162 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_47035){
var state_val_47036 = (state_47035[(1)]);
if((state_val_47036 === (1))){
var inst_47032 = (function (){return (function (result){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",293,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["async evalued result: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(result)].join('')], null);
}),null)),null,1367920313);

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_chan,result);
});
})();
var inst_47033 = pinkgorilla.kernel.nrepl.clj_eval(snippet,inst_47032);
var state_47035__$1 = state_47035;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47035__$1,inst_47033);
} else {
return null;
}
});
return (function() {
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto__ = null;
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto____0 = (function (){
var statearr_47037 = [null,null,null,null,null,null,null];
(statearr_47037[(0)] = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto__);

(statearr_47037[(1)] = (1));

return statearr_47037;
});
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto____1 = (function (state_47035){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_47035);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e47038){var ex__29242__auto__ = e47038;
var statearr_47039_47165 = state_47035;
(statearr_47039_47165[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_47035[(4)]))){
var statearr_47040_47166 = state_47035;
(statearr_47040_47166[(1)] = cljs.core.first((state_47035[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47167 = state_47035;
state_47035 = G__47167;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto__ = function(state_47035){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto____1.call(this,state_47035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto____0;
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto____1;
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_47041 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_47041[(6)] = c__29274__auto___47162);

return statearr_47041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


var c__29274__auto___47169 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29275__auto__ = (function (){var switch__29238__auto__ = (function (state_47046){
var state_val_47047 = (state_47046[(1)]);
if((state_val_47047 === (1))){
var state_47046__$1 = state_47046;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47046__$1,(2),result_chan);
} else {
if((state_val_47047 === (2))){
var inst_47043 = (state_47046[(2)]);
var inst_47044 = cljs.core.reset_BANG_(result_atom,inst_47043);
var state_47046__$1 = state_47046;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47046__$1,inst_47044);
} else {
return null;
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto__ = null;
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto____0 = (function (){
var statearr_47048 = [null,null,null,null,null,null,null];
(statearr_47048[(0)] = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto__);

(statearr_47048[(1)] = (1));

return statearr_47048;
});
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto____1 = (function (state_47046){
while(true){
var ret_value__29240__auto__ = (function (){try{while(true){
var result__29241__auto__ = switch__29238__auto__(state_47046);
if(cljs.core.keyword_identical_QMARK_(result__29241__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29241__auto__;
}
break;
}
}catch (e47049){var ex__29242__auto__ = e47049;
var statearr_47050_47171 = state_47046;
(statearr_47050_47171[(2)] = ex__29242__auto__);


if(cljs.core.seq((state_47046[(4)]))){
var statearr_47051_47172 = state_47046;
(statearr_47051_47172[(1)] = cljs.core.first((state_47046[(4)])));

} else {
throw ex__29242__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29240__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47173 = state_47046;
state_47046 = G__47173;
continue;
} else {
return ret_value__29240__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto__ = function(state_47046){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto____1.call(this,state_47046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto____0;
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto____1;
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__29239__auto__;
})()
})();
var state__29276__auto__ = (function (){var statearr_47052 = (f__29275__auto__.cljs$core$IFn$_invoke$arity$0 ? f__29275__auto__.cljs$core$IFn$_invoke$arity$0() : f__29275__auto__.call(null));
(statearr_47052[(6)] = c__29274__auto___47169);

return statearr_47052;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29276__auto__);
}));


return result_atom;
});
goog.exportSymbol('pinkgorilla.kernel.nrepl.clj_eval_sync', pinkgorilla.kernel.nrepl.clj_eval_sync);
/**
 * executes a clojure ```function-as-string``` (from clojurescript) 
 * and stores the result in ```result-atom```
 */
pinkgorilla.kernel.nrepl.clj = (function pinkgorilla$kernel$nrepl$clj(var_args){
var args__4795__auto__ = [];
var len__4789__auto___47174 = arguments.length;
var i__4790__auto___47175 = (0);
while(true){
if((i__4790__auto___47175 < len__4789__auto___47174)){
args__4795__auto__.push((arguments[i__4790__auto___47175]));

var G__47176 = (i__4790__auto___47175 + (1));
i__4790__auto___47175 = G__47176;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return pinkgorilla.kernel.nrepl.clj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});
goog.exportSymbol('pinkgorilla.kernel.nrepl.clj', pinkgorilla.kernel.nrepl.clj);

(pinkgorilla.kernel.nrepl.clj.cljs$core$IFn$_invoke$arity$variadic = (function (result_atom,function_as_string,params){
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",302,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["params: ",params], null);
}),null)),null,1008397488);
var expr = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(",function_as_string], null),params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [")"], null)], 0));
var str_eval = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",expr);
var ___$1 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init2754261939868367118.clj",305,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["Calling CLJ: ",str_eval].join('')], null);
}),null)),null,-854522016);
return pinkgorilla.kernel.nrepl.clj_eval_sync(result_atom,str_eval);
}));

(pinkgorilla.kernel.nrepl.clj.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.kernel.nrepl.clj.cljs$lang$applyTo = (function (seq47053){
var G__47054 = cljs.core.first(seq47053);
var seq47053__$1 = cljs.core.next(seq47053);
var G__47055 = cljs.core.first(seq47053__$1);
var seq47053__$2 = cljs.core.next(seq47053__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47054,G__47055,seq47053__$2);
}));


//# sourceMappingURL=pinkgorilla.kernel.nrepl.js.map
