goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__26260 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__26261 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__26261);

try{try{var seq__26262 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__26263 = null;
var count__26264 = (0);
var i__26265 = (0);
while(true){
if((i__26265 < count__26264)){
var vec__26272 = chunk__26263.cljs$core$IIndexed$_nth$arity$2(null,i__26265);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26272,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26272,(1),null);
var temp__5733__auto___26317 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___26317)){
var effect_fn_26318 = temp__5733__auto___26317;
(effect_fn_26318.cljs$core$IFn$_invoke$arity$1 ? effect_fn_26318.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_26318.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__26319 = seq__26262;
var G__26320 = chunk__26263;
var G__26321 = count__26264;
var G__26322 = (i__26265 + (1));
seq__26262 = G__26319;
chunk__26263 = G__26320;
count__26264 = G__26321;
i__26265 = G__26322;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__26262);
if(temp__5735__auto__){
var seq__26262__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26262__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__26262__$1);
var G__26323 = cljs.core.chunk_rest(seq__26262__$1);
var G__26324 = c__4609__auto__;
var G__26325 = cljs.core.count(c__4609__auto__);
var G__26326 = (0);
seq__26262 = G__26323;
chunk__26263 = G__26324;
count__26264 = G__26325;
i__26265 = G__26326;
continue;
} else {
var vec__26275 = cljs.core.first(seq__26262__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26275,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26275,(1),null);
var temp__5733__auto___26327 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___26327)){
var effect_fn_26328 = temp__5733__auto___26327;
(effect_fn_26328.cljs$core$IFn$_invoke$arity$1 ? effect_fn_26328.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_26328.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__26329 = cljs.core.next(seq__26262__$1);
var G__26330 = null;
var G__26331 = (0);
var G__26332 = (0);
seq__26262 = G__26329;
chunk__26263 = G__26330;
count__26264 = G__26331;
i__26265 = G__26332;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__25979__auto___26333 = re_frame.interop.now();
var duration__25980__auto___26334 = (end__25979__auto___26333 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__25980__auto___26334,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__25979__auto___26333);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__26260);
}} else {
var seq__26278 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__26279 = null;
var count__26280 = (0);
var i__26281 = (0);
while(true){
if((i__26281 < count__26280)){
var vec__26288 = chunk__26279.cljs$core$IIndexed$_nth$arity$2(null,i__26281);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26288,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26288,(1),null);
var temp__5733__auto___26335 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___26335)){
var effect_fn_26336 = temp__5733__auto___26335;
(effect_fn_26336.cljs$core$IFn$_invoke$arity$1 ? effect_fn_26336.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_26336.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__26337 = seq__26278;
var G__26338 = chunk__26279;
var G__26339 = count__26280;
var G__26340 = (i__26281 + (1));
seq__26278 = G__26337;
chunk__26279 = G__26338;
count__26280 = G__26339;
i__26281 = G__26340;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__26278);
if(temp__5735__auto__){
var seq__26278__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26278__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__26278__$1);
var G__26341 = cljs.core.chunk_rest(seq__26278__$1);
var G__26342 = c__4609__auto__;
var G__26343 = cljs.core.count(c__4609__auto__);
var G__26344 = (0);
seq__26278 = G__26341;
chunk__26279 = G__26342;
count__26280 = G__26343;
i__26281 = G__26344;
continue;
} else {
var vec__26291 = cljs.core.first(seq__26278__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26291,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26291,(1),null);
var temp__5733__auto___26345 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___26345)){
var effect_fn_26346 = temp__5733__auto___26345;
(effect_fn_26346.cljs$core$IFn$_invoke$arity$1 ? effect_fn_26346.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_26346.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__26347 = cljs.core.next(seq__26278__$1);
var G__26348 = null;
var G__26349 = (0);
var G__26350 = (0);
seq__26278 = G__26347;
chunk__26279 = G__26348;
count__26280 = G__26349;
i__26281 = G__26350;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__26294 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__26295 = null;
var count__26296 = (0);
var i__26297 = (0);
while(true){
if((i__26297 < count__26296)){
var map__26304 = chunk__26295.cljs$core$IIndexed$_nth$arity$2(null,i__26297);
var map__26304__$1 = (((((!((map__26304 == null))))?(((((map__26304.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26304.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26304):map__26304);
var effect = map__26304__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26304__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26304__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__26294,chunk__26295,count__26296,i__26297,map__26304,map__26304__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__26294,chunk__26295,count__26296,i__26297,map__26304,map__26304__$1,effect,ms,dispatch))
,ms);
}


var G__26351 = seq__26294;
var G__26352 = chunk__26295;
var G__26353 = count__26296;
var G__26354 = (i__26297 + (1));
seq__26294 = G__26351;
chunk__26295 = G__26352;
count__26296 = G__26353;
i__26297 = G__26354;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__26294);
if(temp__5735__auto__){
var seq__26294__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26294__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__26294__$1);
var G__26355 = cljs.core.chunk_rest(seq__26294__$1);
var G__26356 = c__4609__auto__;
var G__26357 = cljs.core.count(c__4609__auto__);
var G__26358 = (0);
seq__26294 = G__26355;
chunk__26295 = G__26356;
count__26296 = G__26357;
i__26297 = G__26358;
continue;
} else {
var map__26306 = cljs.core.first(seq__26294__$1);
var map__26306__$1 = (((((!((map__26306 == null))))?(((((map__26306.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26306.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26306):map__26306);
var effect = map__26306__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26306__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26306__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__26294,chunk__26295,count__26296,i__26297,map__26306,map__26306__$1,effect,ms,dispatch,seq__26294__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__26294,chunk__26295,count__26296,i__26297,map__26306,map__26306__$1,effect,ms,dispatch,seq__26294__$1,temp__5735__auto__))
,ms);
}


var G__26359 = cljs.core.next(seq__26294__$1);
var G__26360 = null;
var G__26361 = (0);
var G__26362 = (0);
seq__26294 = G__26359;
chunk__26295 = G__26360;
count__26296 = G__26361;
i__26297 = G__26362;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__26309 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__26310 = null;
var count__26311 = (0);
var i__26312 = (0);
while(true){
if((i__26312 < count__26311)){
var event = chunk__26310.cljs$core$IIndexed$_nth$arity$2(null,i__26312);
re_frame.router.dispatch(event);


var G__26363 = seq__26309;
var G__26364 = chunk__26310;
var G__26365 = count__26311;
var G__26366 = (i__26312 + (1));
seq__26309 = G__26363;
chunk__26310 = G__26364;
count__26311 = G__26365;
i__26312 = G__26366;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__26309);
if(temp__5735__auto__){
var seq__26309__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26309__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__26309__$1);
var G__26367 = cljs.core.chunk_rest(seq__26309__$1);
var G__26368 = c__4609__auto__;
var G__26369 = cljs.core.count(c__4609__auto__);
var G__26370 = (0);
seq__26309 = G__26367;
chunk__26310 = G__26368;
count__26311 = G__26369;
i__26312 = G__26370;
continue;
} else {
var event = cljs.core.first(seq__26309__$1);
re_frame.router.dispatch(event);


var G__26371 = cljs.core.next(seq__26309__$1);
var G__26372 = null;
var G__26373 = (0);
var G__26374 = (0);
seq__26309 = G__26371;
chunk__26310 = G__26372;
count__26311 = G__26373;
i__26312 = G__26374;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__26313 = cljs.core.seq(value);
var chunk__26314 = null;
var count__26315 = (0);
var i__26316 = (0);
while(true){
if((i__26316 < count__26315)){
var event = chunk__26314.cljs$core$IIndexed$_nth$arity$2(null,i__26316);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__26375 = seq__26313;
var G__26376 = chunk__26314;
var G__26377 = count__26315;
var G__26378 = (i__26316 + (1));
seq__26313 = G__26375;
chunk__26314 = G__26376;
count__26315 = G__26377;
i__26316 = G__26378;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__26313);
if(temp__5735__auto__){
var seq__26313__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26313__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__26313__$1);
var G__26379 = cljs.core.chunk_rest(seq__26313__$1);
var G__26380 = c__4609__auto__;
var G__26381 = cljs.core.count(c__4609__auto__);
var G__26382 = (0);
seq__26313 = G__26379;
chunk__26314 = G__26380;
count__26315 = G__26381;
i__26316 = G__26382;
continue;
} else {
var event = cljs.core.first(seq__26313__$1);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__26383 = cljs.core.next(seq__26313__$1);
var G__26384 = null;
var G__26385 = (0);
var G__26386 = (0);
seq__26313 = G__26383;
chunk__26314 = G__26384;
count__26315 = G__26385;
i__26316 = G__26386;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return (clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(value) : clear_event.call(null,value));
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
