goog.provide('pinkgorilla.ui.leaflet');
goog.require('cljs.core');
var module$node_modules$react_leaflet$lib$index=shadow.js.require("module$node_modules$react_leaflet$lib$index", {});
var module$node_modules$leaflet$dist$leaflet_src=shadow.js.require("module$node_modules$leaflet$dist$leaflet_src", {});
goog.require('pinkgorilla.ui.pinkie');
goog.require('pinkgorilla.dsl.leaflet');
pinkgorilla.ui.leaflet.config = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"css","css",1135045163),"https://unpkg.com/leaflet@1.6.0/dist/leaflet.css",new cljs.core.Keyword(null,"tile-layer-url","tile-layer-url",-1729025633),"https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png",new cljs.core.Keyword(null,"attribution","attribution",1937239286),"&copy; <a href=&quot;http://osm.org/copyright&quot;>OpenStreetMap</a> contributors"], null);
pinkgorilla.ui.leaflet.default_marker = (new module$node_modules$leaflet$dist$leaflet_src.Icon(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"iconUrl","iconUrl",-1868537869),"images/marker-icon.png",new cljs.core.Keyword(null,"iconRetinaUrl","iconRetinaUrl",932366134),"images/marker-icon-2x.png",new cljs.core.Keyword(null,"iconAnchor","iconAnchor",970343173),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(5),(55)], null),new cljs.core.Keyword(null,"popupAnchor","popupAnchor",931949236),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(10),(-44)], null),new cljs.core.Keyword(null,"iconSize","iconSize",253109071),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(25),(55)], null),new cljs.core.Keyword(null,"shadowUrl","shadowUrl",1986496437),"images/marker-shadow.png",new cljs.core.Keyword(null,"shadowSize","shadowSize",-1015046863),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(68),(95)], null),new cljs.core.Keyword(null,"shadowAnchor","shadowAnchor",643451688),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(20),(92)], null)], null))));
pinkgorilla.ui.leaflet.marker_default = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"icon","icon",1679606541),pinkgorilla.ui.leaflet.default_marker], null);
pinkgorilla.ui.leaflet.log = (function pinkgorilla$ui$leaflet$log(s){
return console.log(s);
});
pinkgorilla.ui.leaflet.feature = (function pinkgorilla$ui$leaflet$feature(data_with_type){
var type = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(data_with_type);
var data = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(data_with_type,new cljs.core.Keyword(null,"type","type",1174270348));
var G__26572 = type;
var G__26572__$1 = (((G__26572 instanceof cljs.core.Keyword))?G__26572.fqn:null);
switch (G__26572__$1) {
case "rectangle":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Rectangle,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "circle":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Circle,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "line":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Polyline,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "polygon":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Polygon,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "marker":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Marker,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.ui.leaflet.marker_default,data], 0)),(((!((new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data) == null))))?cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Popup,new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null)):null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "circlemarker":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.CircleMarker,data,(((!((new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data) == null))))?cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Popup,new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null)):null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "geojson":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.GeoJSON,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
default:
pinkgorilla.ui.leaflet.log(["No feature found for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''));

return null;

}
});
pinkgorilla.ui.leaflet.view_QMARK_ = (function pinkgorilla$ui$leaflet$view_QMARK_(feature){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(feature));
});
pinkgorilla.ui.leaflet.assoc_if_exists = (function pinkgorilla$ui$leaflet$assoc_if_exists(m,key,val){
if((val == null)){
return m;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,key,val);
}
});
pinkgorilla.ui.leaflet.view_map_props = (function pinkgorilla$ui$leaflet$view_map_props(view){
var map__26580 = view;
var map__26580__$1 = (((((!((map__26580 == null))))?(((((map__26580.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26580.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26580):map__26580);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26580__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26580__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var zoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26580__$1,new cljs.core.Keyword(null,"zoom","zoom",-1827487038));
var center = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26580__$1,new cljs.core.Keyword(null,"center","center",-748944368));
var useFlyTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26580__$1,new cljs.core.Keyword(null,"useFlyTo","useFlyTo",1726688032));
var style = (cljs.core.truth_((function (){var or__4185__auto__ = width;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return height;
}
})())?pinkgorilla.ui.leaflet.assoc_if_exists(pinkgorilla.ui.leaflet.assoc_if_exists(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"width","width",-384071477),width),new cljs.core.Keyword(null,"height","height",1025178622),height):null);
return pinkgorilla.ui.leaflet.assoc_if_exists(pinkgorilla.ui.leaflet.assoc_if_exists(pinkgorilla.ui.leaflet.assoc_if_exists(pinkgorilla.ui.leaflet.assoc_if_exists(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"style","style",-496642736),style),new cljs.core.Keyword(null,"zoom","zoom",-1827487038),zoom),new cljs.core.Keyword(null,"center","center",-748944368),center),new cljs.core.Keyword(null,"useFlyTo","useFlyTo",1726688032),useFlyTo);
});
pinkgorilla.ui.leaflet.leaflet_map = (function pinkgorilla$ui$leaflet$leaflet_map(var_args){
var G__26583 = arguments.length;
switch (G__26583) {
case 2:
return pinkgorilla.ui.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return pinkgorilla.ui.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(pinkgorilla.ui.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$2 = (function (options,features_incl_view){
var map__26584 = pinkgorilla.ui.leaflet.config;
var map__26584__$1 = (((((!((map__26584 == null))))?(((((map__26584.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26584.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26584):map__26584);
var css = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26584__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var tile_layer_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26584__$1,new cljs.core.Keyword(null,"tile-layer-url","tile-layer-url",-1729025633));
var attribution = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26584__$1,new cljs.core.Keyword(null,"attribution","attribution",1937239286));
var map__26585 = options;
var map__26585__$1 = (((((!((map__26585 == null))))?(((((map__26585.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26585.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26585):map__26585);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26585__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26585__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var zoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26585__$1,new cljs.core.Keyword(null,"zoom","zoom",-1827487038));
var center = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26585__$1,new cljs.core.Keyword(null,"center","center",-748944368));
var view = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.leaflet.view_QMARK_,features_incl_view));
var features = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.leaflet.view_QMARK_,features_incl_view);
var view_map = pinkgorilla.ui.leaflet.view_map_props(view);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet",new cljs.core.Keyword(null,"href","href",-793805698),css], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Map,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"zoom","zoom",-1827487038),zoom,new cljs.core.Keyword(null,"center","center",-748944368),center,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),width,new cljs.core.Keyword(null,"height","height",1025178622),height], null)], null),view_map], 0)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.TileLayer,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),tile_layer_url,new cljs.core.Keyword(null,"attribution","attribution",1937239286),attribution], null)], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386)], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.leaflet.feature,features))], null)], null);
}));

(pinkgorilla.ui.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$1 = (function (features){
return pinkgorilla.ui.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$2(pinkgorilla.dsl.leaflet.default_options,features);
}));

(pinkgorilla.ui.leaflet.leaflet_map.cljs$lang$maxFixedArity = 2);

pinkgorilla.ui.pinkie.register_tag(new cljs.core.Keyword("p","leaflet","p/leaflet",1547983832),pinkgorilla.ui.leaflet.leaflet_map);

//# sourceMappingURL=pinkgorilla.ui.leaflet.js.map
