goog.provide('ajax.xml_http_request');
goog.require('cljs.core');
goog.require('ajax.protocols');
goog.require('goog.string');
ajax.xml_http_request.ready_state = (function ajax$xml_http_request$ready_state(e){
var G__35801 = e.target.readyState;
var fexpr__35800 = new cljs.core.PersistentArrayMap(null, 5, [(0),new cljs.core.Keyword(null,"not-initialized","not-initialized",-1937378906),(1),new cljs.core.Keyword(null,"connection-established","connection-established",-1403749733),(2),new cljs.core.Keyword(null,"request-received","request-received",2110590540),(3),new cljs.core.Keyword(null,"processing-request","processing-request",-264947221),(4),new cljs.core.Keyword(null,"response-ready","response-ready",245208276)], null);
return (fexpr__35800.cljs$core$IFn$_invoke$arity$1 ? fexpr__35800.cljs$core$IFn$_invoke$arity$1(G__35801) : fexpr__35800.call(null,G__35801));
});
ajax.xml_http_request.append = (function ajax$xml_http_request$append(current,next){
if(cljs.core.truth_(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current),", ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(next)].join('');
} else {
return next;
}
});
ajax.xml_http_request.process_headers = (function ajax$xml_http_request$process_headers(header_str){
if(cljs.core.truth_(header_str)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (headers,header_line){
if(cljs.core.truth_(goog.string.isEmptyOrWhitespace(header_line))){
return headers;
} else {
var key_value = goog.string.splitLimit(header_line,": ",(2));
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(headers,(key_value[(0)]),ajax.xml_http_request.append,(key_value[(1)]));
}
}),cljs.core.PersistentArrayMap.EMPTY,header_str.split("\r\n"));
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
ajax.xml_http_request.xmlhttprequest = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_target_STAR_,"nodejs"))?(function (){var xmlhttprequest = require("xmlhttprequest").XMLHttpRequest;
goog.object.set(global,"XMLHttpRequest",xmlhttprequest);

return xmlhttprequest;
})():XMLHttpRequest);
(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$_js_ajax_request$arity$3 = (function (this$,p__35803,handler){
var map__35804 = p__35803;
var map__35804__$1 = (((((!((map__35804 == null))))?(((((map__35804.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35804.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35804):map__35804);
var uri = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35804__$1,new cljs.core.Keyword(null,"uri","uri",-774711847));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35804__$1,new cljs.core.Keyword(null,"method","method",55703592));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35804__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35804__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35804__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(0));
var with_credentials = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35804__$1,new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235),false);
var response_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35804__$1,new cljs.core.Keyword(null,"response-format","response-format",1664465322));
var this$__$1 = this;
(this$__$1.withCredentials = with_credentials);

(this$__$1.onreadystatechange = (function (p1__35802_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"response-ready","response-ready",245208276),ajax.xml_http_request.ready_state(p1__35802_SHARP_))){
return (handler.cljs$core$IFn$_invoke$arity$1 ? handler.cljs$core$IFn$_invoke$arity$1(this$__$1) : handler.call(null,this$__$1));
} else {
return null;
}
}));

this$__$1.open(method,uri,true);

(this$__$1.timeout = timeout);

var temp__5735__auto___35824 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(response_format);
if(cljs.core.truth_(temp__5735__auto___35824)){
var response_type_35825 = temp__5735__auto___35824;
(this$__$1.responseType = cljs.core.name(response_type_35825));
} else {
}

var seq__35806_35826 = cljs.core.seq(headers);
var chunk__35807_35827 = null;
var count__35808_35828 = (0);
var i__35809_35829 = (0);
while(true){
if((i__35809_35829 < count__35808_35828)){
var vec__35816_35830 = chunk__35807_35827.cljs$core$IIndexed$_nth$arity$2(null,i__35809_35829);
var k_35831 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35816_35830,(0),null);
var v_35832 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35816_35830,(1),null);
this$__$1.setRequestHeader(k_35831,v_35832);


var G__35833 = seq__35806_35826;
var G__35834 = chunk__35807_35827;
var G__35835 = count__35808_35828;
var G__35836 = (i__35809_35829 + (1));
seq__35806_35826 = G__35833;
chunk__35807_35827 = G__35834;
count__35808_35828 = G__35835;
i__35809_35829 = G__35836;
continue;
} else {
var temp__5735__auto___35837 = cljs.core.seq(seq__35806_35826);
if(temp__5735__auto___35837){
var seq__35806_35838__$1 = temp__5735__auto___35837;
if(cljs.core.chunked_seq_QMARK_(seq__35806_35838__$1)){
var c__4550__auto___35839 = cljs.core.chunk_first(seq__35806_35838__$1);
var G__35840 = cljs.core.chunk_rest(seq__35806_35838__$1);
var G__35841 = c__4550__auto___35839;
var G__35842 = cljs.core.count(c__4550__auto___35839);
var G__35843 = (0);
seq__35806_35826 = G__35840;
chunk__35807_35827 = G__35841;
count__35808_35828 = G__35842;
i__35809_35829 = G__35843;
continue;
} else {
var vec__35819_35844 = cljs.core.first(seq__35806_35838__$1);
var k_35845 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35819_35844,(0),null);
var v_35846 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35819_35844,(1),null);
this$__$1.setRequestHeader(k_35845,v_35846);


var G__35847 = cljs.core.next(seq__35806_35838__$1);
var G__35848 = null;
var G__35849 = (0);
var G__35850 = (0);
seq__35806_35826 = G__35847;
chunk__35807_35827 = G__35848;
count__35808_35828 = G__35849;
i__35809_35829 = G__35850;
continue;
}
} else {
}
}
break;
}

this$__$1.send((function (){var or__4120__auto__ = body;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return "";
}
})());

return this$__$1;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$_abort$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.abort();
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_body$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.response;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.status;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status_text$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.statusText;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_all_headers$arity$1 = (function (this$){
var this$__$1 = this;
return ajax.xml_http_request.process_headers(this$__$1.getAllResponseHeaders());
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_response_header$arity$2 = (function (this$,header){
var this$__$1 = this;
return this$__$1.getResponseHeader(header);
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_was_aborted$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),this$__$1.readyState);
}));

//# sourceMappingURL=ajax.xml_http_request.js.map
