goog.provide('chord.client');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('chord.channels');
goog.require('chord.format');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e43377){var e = e43377;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4736__auto__ = [];
var len__4730__auto___43493 = arguments.length;
var i__4731__auto___43494 = (0);
while(true){
if((i__4731__auto___43494 < len__4730__auto___43493)){
args__4736__auto__.push((arguments[i__4731__auto___43494]));

var G__43495 = (i__4731__auto___43494 + (1));
i__4731__auto___43494 = G__43495;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__43382){
var vec__43383 = p__43382;
var map__43386 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43383,(0),null);
var map__43386__$1 = (((((!((map__43386 == null))))?(((((map__43386.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43386.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43386):map__43386);
var opts = map__43386__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43386__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43386__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43386__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43386__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__43388 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4120__auto__ = read_ch;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4120__auto__ = write_ch;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__43388__$1 = (((((!((map__43388 == null))))?(((((map__43388.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43388.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43388):map__43388);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43388__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43388__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__43378_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__43378_SHARP_);
}));

(web_socket.onclose = (function (p1__43379_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__43379_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__28446__auto___43496 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_43457){
var state_val_43458 = (state_43457[(1)]);
if((state_val_43458 === (7))){
var inst_43453 = (state_43457[(2)]);
var state_43457__$1 = state_43457;
var statearr_43459_43497 = state_43457__$1;
(statearr_43459_43497[(2)] = inst_43453);

(statearr_43459_43497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (20))){
var state_43457__$1 = state_43457;
var statearr_43460_43498 = state_43457__$1;
(statearr_43460_43498[(2)] = null);

(statearr_43460_43498[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (1))){
var inst_43390 = false;
var state_43457__$1 = (function (){var statearr_43461 = state_43457;
(statearr_43461[(7)] = inst_43390);

return statearr_43461;
})();
var statearr_43462_43499 = state_43457__$1;
(statearr_43462_43499[(2)] = null);

(statearr_43462_43499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (4))){
var inst_43405 = (state_43457[(8)]);
var inst_43399 = (state_43457[(9)]);
var inst_43407 = (state_43457[(10)]);
var inst_43405__$1 = (state_43457[(2)]);
var inst_43406 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43405__$1,(0),null);
var inst_43407__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43405__$1,(1),null);
var inst_43408 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_43407__$1,inst_43399);
var state_43457__$1 = (function (){var statearr_43463 = state_43457;
(statearr_43463[(8)] = inst_43405__$1);

(statearr_43463[(11)] = inst_43406);

(statearr_43463[(10)] = inst_43407__$1);

return statearr_43463;
})();
if(inst_43408){
var statearr_43464_43500 = state_43457__$1;
(statearr_43464_43500[(1)] = (5));

} else {
var statearr_43465_43501 = state_43457__$1;
(statearr_43465_43501[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (15))){
var inst_43438 = (state_43457[(2)]);
var state_43457__$1 = state_43457;
var statearr_43466_43502 = state_43457__$1;
(statearr_43466_43502[(2)] = inst_43438);

(statearr_43466_43502[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (21))){
var inst_43449 = (state_43457[(2)]);
var state_43457__$1 = state_43457;
var statearr_43467_43503 = state_43457__$1;
(statearr_43467_43503[(2)] = inst_43449);

(statearr_43467_43503[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (13))){
var state_43457__$1 = state_43457;
var statearr_43468_43504 = state_43457__$1;
(statearr_43468_43504[(2)] = null);

(statearr_43468_43504[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (6))){
var inst_43407 = (state_43457[(10)]);
var inst_43400 = (state_43457[(12)]);
var inst_43422 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_43407,inst_43400);
var state_43457__$1 = state_43457;
if(inst_43422){
var statearr_43469_43505 = state_43457__$1;
(statearr_43469_43505[(1)] = (9));

} else {
var statearr_43470_43506 = state_43457__$1;
(statearr_43470_43506[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (17))){
var state_43457__$1 = state_43457;
var statearr_43471_43508 = state_43457__$1;
(statearr_43471_43508[(2)] = initial_ch);

(statearr_43471_43508[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (3))){
var inst_43455 = (state_43457[(2)]);
var state_43457__$1 = state_43457;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43457__$1,inst_43455);
} else {
if((state_val_43458 === (12))){
var inst_43390 = (state_43457[(7)]);
var state_43457__$1 = state_43457;
if(cljs.core.truth_(inst_43390)){
var statearr_43472_43509 = state_43457__$1;
(statearr_43472_43509[(1)] = (16));

} else {
var statearr_43473_43510 = state_43457__$1;
(statearr_43473_43510[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (2))){
var inst_43399 = (state_43457[(9)]);
var inst_43400 = (state_43457[(12)]);
var inst_43399__$1 = open_ch;
var inst_43400__$1 = close_ch;
var inst_43401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43402 = [inst_43399__$1,inst_43400__$1];
var inst_43403 = (new cljs.core.PersistentVector(null,2,(5),inst_43401,inst_43402,null));
var state_43457__$1 = (function (){var statearr_43474 = state_43457;
(statearr_43474[(9)] = inst_43399__$1);

(statearr_43474[(12)] = inst_43400__$1);

return statearr_43474;
})();
return cljs.core.async.ioc_alts_BANG_(state_43457__$1,(4),inst_43403);
} else {
if((state_val_43458 === (19))){
var inst_43406 = (state_43457[(11)]);
var state_43457__$1 = state_43457;
var statearr_43475_43512 = state_43457__$1;
(statearr_43475_43512[(2)] = inst_43406);

(statearr_43475_43512[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (11))){
var inst_43451 = (state_43457[(2)]);
var state_43457__$1 = state_43457;
var statearr_43476_43514 = state_43457__$1;
(statearr_43476_43514[(2)] = inst_43451);

(statearr_43476_43514[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (9))){
var inst_43405 = (state_43457[(8)]);
var inst_43428 = (state_43457[(13)]);
var inst_43427 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43405,(0),null);
var inst_43428__$1 = chord.client.close_event__GT_maybe_error(inst_43427);
var state_43457__$1 = (function (){var statearr_43477 = state_43457;
(statearr_43477[(13)] = inst_43428__$1);

return statearr_43477;
})();
if(cljs.core.truth_(inst_43428__$1)){
var statearr_43478_43515 = state_43457__$1;
(statearr_43478_43515[(1)] = (12));

} else {
var statearr_43479_43516 = state_43457__$1;
(statearr_43479_43516[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (5))){
var inst_43405 = (state_43457[(8)]);
var inst_43413 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43405,(0),null);
var inst_43414 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_43415 = [ws_chan];
var inst_43416 = cljs.core.PersistentHashMap.fromArrays(inst_43414,inst_43415);
var state_43457__$1 = (function (){var statearr_43480 = state_43457;
(statearr_43480[(14)] = inst_43413);

return statearr_43480;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43457__$1,(8),initial_ch,inst_43416);
} else {
if((state_val_43458 === (14))){
var inst_43441 = (state_43457[(2)]);
var inst_43442 = cljs.core.async.close_BANG_(ws_chan);
var inst_43443 = cljs.core.async.close_BANG_(initial_ch);
var state_43457__$1 = (function (){var statearr_43481 = state_43457;
(statearr_43481[(15)] = inst_43442);

(statearr_43481[(16)] = inst_43441);

return statearr_43481;
})();
var statearr_43482_43517 = state_43457__$1;
(statearr_43482_43517[(2)] = inst_43443);

(statearr_43482_43517[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (16))){
var state_43457__$1 = state_43457;
var statearr_43483_43518 = state_43457__$1;
(statearr_43483_43518[(2)] = read_ch__$1);

(statearr_43483_43518[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (10))){
var inst_43407 = (state_43457[(10)]);
var inst_43445 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_43407,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_43457__$1 = state_43457;
if(inst_43445){
var statearr_43484_43519 = state_43457__$1;
(statearr_43484_43519[(1)] = (19));

} else {
var statearr_43485_43520 = state_43457__$1;
(statearr_43485_43520[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43458 === (18))){
var inst_43428 = (state_43457[(13)]);
var inst_43433 = (state_43457[(2)]);
var inst_43434 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_43435 = [inst_43428];
var inst_43436 = cljs.core.PersistentHashMap.fromArrays(inst_43434,inst_43435);
var state_43457__$1 = state_43457;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43457__$1,(15),inst_43433,inst_43436);
} else {
if((state_val_43458 === (8))){
var inst_43418 = (state_43457[(2)]);
var inst_43419 = cljs.core.async.close_BANG_(initial_ch);
var inst_43390 = true;
var state_43457__$1 = (function (){var statearr_43486 = state_43457;
(statearr_43486[(17)] = inst_43419);

(statearr_43486[(7)] = inst_43390);

(statearr_43486[(18)] = inst_43418);

return statearr_43486;
})();
var statearr_43487_43521 = state_43457__$1;
(statearr_43487_43521[(2)] = null);

(statearr_43487_43521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__28411__auto__ = null;
var chord$client$state_machine__28411__auto____0 = (function (){
var statearr_43488 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43488[(0)] = chord$client$state_machine__28411__auto__);

(statearr_43488[(1)] = (1));

return statearr_43488;
});
var chord$client$state_machine__28411__auto____1 = (function (state_43457){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_43457);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e43489){var ex__28414__auto__ = e43489;
var statearr_43490_43522 = state_43457;
(statearr_43490_43522[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_43457[(4)]))){
var statearr_43491_43523 = state_43457;
(statearr_43491_43523[(1)] = cljs.core.first((state_43457[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43524 = state_43457;
state_43457 = G__43524;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
chord$client$state_machine__28411__auto__ = function(state_43457){
switch(arguments.length){
case 0:
return chord$client$state_machine__28411__auto____0.call(this);
case 1:
return chord$client$state_machine__28411__auto____1.call(this,state_43457);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__28411__auto____0;
chord$client$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__28411__auto____1;
return chord$client$state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_43492 = f__28447__auto__();
(statearr_43492[(6)] = c__28446__auto___43496);

return statearr_43492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq43380){
var G__43381 = cljs.core.first(seq43380);
var seq43380__$1 = cljs.core.next(seq43380);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43381,seq43380__$1);
}));


//# sourceMappingURL=chord.client.js.map
