goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__39882 = s;
var map__39882__$1 = (((((!((map__39882 == null))))?(((((map__39882.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39882.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39882):map__39882);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39882__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39882__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__39885 = info;
var map__39886 = G__39885;
var map__39886__$1 = (((((!((map__39886 == null))))?(((((map__39886.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39886.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39886):map__39886);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39886__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__39885__$1 = G__39885;
while(true){
var d__$2 = d__$1;
var map__39891 = G__39885__$1;
var map__39891__$1 = (((((!((map__39891 == null))))?(((((map__39891.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39891.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39891):map__39891);
var shadow__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39891__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$2)){
var G__40705 = (d__$2 + (1));
var G__40706 = shadow__$2;
d__$1 = G__40705;
G__39885__$1 = G__40706;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__39893){
var map__39894 = p__39893;
var map__39894__$1 = (((((!((map__39894 == null))))?(((((map__39894.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39894.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39894):map__39894);
var name_var = map__39894__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39894__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39894__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__39896 = info;
var map__39896__$1 = (((((!((map__39896 == null))))?(((((map__39896.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39896.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39896):map__39896);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39896__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39896__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__39899 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__39899) : cljs.compiler.munge.call(null,G__39899));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__39948 = arguments.length;
switch (G__39948) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__39952 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11501,11501,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__39952.cljs$core$IFn$_invoke$arity$1 ? fexpr__39952.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__39952.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__39953 = cp;
switch (G__39953) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__39954_40711 = cljs.core.seq(s);
var chunk__39955_40712 = null;
var count__39956_40713 = (0);
var i__39957_40714 = (0);
while(true){
if((i__39957_40714 < count__39956_40713)){
var c_40715 = chunk__39955_40712.cljs$core$IIndexed$_nth$arity$2(null,i__39957_40714);
sb.append(cljs.compiler.escape_char(c_40715));


var G__40716 = seq__39954_40711;
var G__40717 = chunk__39955_40712;
var G__40718 = count__39956_40713;
var G__40719 = (i__39957_40714 + (1));
seq__39954_40711 = G__40716;
chunk__39955_40712 = G__40717;
count__39956_40713 = G__40718;
i__39957_40714 = G__40719;
continue;
} else {
var temp__5735__auto___40720 = cljs.core.seq(seq__39954_40711);
if(temp__5735__auto___40720){
var seq__39954_40721__$1 = temp__5735__auto___40720;
if(cljs.core.chunked_seq_QMARK_(seq__39954_40721__$1)){
var c__4550__auto___40724 = cljs.core.chunk_first(seq__39954_40721__$1);
var G__40725 = cljs.core.chunk_rest(seq__39954_40721__$1);
var G__40726 = c__4550__auto___40724;
var G__40727 = cljs.core.count(c__4550__auto___40724);
var G__40728 = (0);
seq__39954_40711 = G__40725;
chunk__39955_40712 = G__40726;
count__39956_40713 = G__40727;
i__39957_40714 = G__40728;
continue;
} else {
var c_40730 = cljs.core.first(seq__39954_40721__$1);
sb.append(cljs.compiler.escape_char(c_40730));


var G__40731 = cljs.core.next(seq__39954_40721__$1);
var G__40732 = null;
var G__40733 = (0);
var G__40734 = (0);
seq__39954_40711 = G__40731;
chunk__39955_40712 = G__40732;
count__39956_40713 = G__40733;
i__39957_40714 = G__40734;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4613__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__39958 = cljs.core.get_global_hierarchy;
return (fexpr__39958.cljs$core$IFn$_invoke$arity$0 ? fexpr__39958.cljs$core$IFn$_invoke$arity$0() : fexpr__39958.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__39959_40744 = ast;
var map__39959_40745__$1 = (((((!((map__39959_40744 == null))))?(((((map__39959_40744.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39959_40744.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39959_40744):map__39959_40744);
var env_40746 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39959_40745__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_40746))){
var map__39961_40750 = env_40746;
var map__39961_40751__$1 = (((((!((map__39961_40750 == null))))?(((((map__39961_40750.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39961_40750.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39961_40750):map__39961_40750);
var line_40752 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39961_40751__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_40753 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39961_40751__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__39963 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__39965 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__39964 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__39964.cljs$core$IFn$_invoke$arity$1 ? fexpr__39964.cljs$core$IFn$_invoke$arity$1(G__39965) : fexpr__39964.call(null,G__39965));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39963,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__39963;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_40752 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_40753)?(column_40753 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast);
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__39977 = arguments.length;
switch (G__39977) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___40762 = arguments.length;
var i__4731__auto___40763 = (0);
while(true){
if((i__4731__auto___40763 < len__4730__auto___40762)){
args_arr__4751__auto__.push((arguments[i__4731__auto___40763]));

var G__40764 = (i__4731__auto___40763 + (1));
i__4731__auto___40763 = G__40764;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4752__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_40765 = (function (){var G__39979 = a;
if((!(typeof a === 'string'))){
return G__39979.toString();
} else {
return G__39979;
}
})();
var temp__5739__auto___40766 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___40766 == null)){
} else {
var sm_data_40767 = temp__5739__auto___40766;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_40767,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__39966_SHARP_){
return (p1__39966_SHARP_ + s_40765.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_40765], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__39981 = cljs.core.seq(xs);
var chunk__39982 = null;
var count__39983 = (0);
var i__39984 = (0);
while(true){
if((i__39984 < count__39983)){
var x = chunk__39982.cljs$core$IIndexed$_nth$arity$2(null,i__39984);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__40768 = seq__39981;
var G__40769 = chunk__39982;
var G__40770 = count__39983;
var G__40771 = (i__39984 + (1));
seq__39981 = G__40768;
chunk__39982 = G__40769;
count__39983 = G__40770;
i__39984 = G__40771;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__39981);
if(temp__5735__auto__){
var seq__39981__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39981__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__39981__$1);
var G__40773 = cljs.core.chunk_rest(seq__39981__$1);
var G__40774 = c__4550__auto__;
var G__40775 = cljs.core.count(c__4550__auto__);
var G__40776 = (0);
seq__39981 = G__40773;
chunk__39982 = G__40774;
count__39983 = G__40775;
i__39984 = G__40776;
continue;
} else {
var x = cljs.core.first(seq__39981__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__40778 = cljs.core.next(seq__39981__$1);
var G__40779 = null;
var G__40780 = (0);
var G__40781 = (0);
seq__39981 = G__40778;
chunk__39982 = G__40779;
count__39983 = G__40780;
i__39984 = G__40781;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq39971){
var G__39972 = cljs.core.first(seq39971);
var seq39971__$1 = cljs.core.next(seq39971);
var G__39973 = cljs.core.first(seq39971__$1);
var seq39971__$2 = cljs.core.next(seq39971__$1);
var G__39974 = cljs.core.first(seq39971__$2);
var seq39971__$3 = cljs.core.next(seq39971__$2);
var G__39975 = cljs.core.first(seq39971__$3);
var seq39971__$4 = cljs.core.next(seq39971__$3);
var G__39976 = cljs.core.first(seq39971__$4);
var seq39971__$5 = cljs.core.next(seq39971__$4);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39972,G__39973,G__39974,G__39975,G__39976,seq39971__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__39986){
var map__39987 = p__39986;
var map__39987__$1 = (((((!((map__39987 == null))))?(((((map__39987.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39987.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39987):map__39987);
var m = map__39987__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39987__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__39996 = arguments.length;
switch (G__39996) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___40783 = arguments.length;
var i__4731__auto___40784 = (0);
while(true){
if((i__4731__auto___40784 < len__4730__auto___40783)){
args_arr__4751__auto__.push((arguments[i__4731__auto___40784]));

var G__40785 = (i__4731__auto___40784 + (1));
i__4731__auto___40784 = G__40785;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4752__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__40010_40786 = cljs.core.seq(xs);
var chunk__40011_40787 = null;
var count__40012_40788 = (0);
var i__40013_40789 = (0);
while(true){
if((i__40013_40789 < count__40012_40788)){
var x_40790 = chunk__40011_40787.cljs$core$IIndexed$_nth$arity$2(null,i__40013_40789);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_40790);


var G__40791 = seq__40010_40786;
var G__40792 = chunk__40011_40787;
var G__40793 = count__40012_40788;
var G__40794 = (i__40013_40789 + (1));
seq__40010_40786 = G__40791;
chunk__40011_40787 = G__40792;
count__40012_40788 = G__40793;
i__40013_40789 = G__40794;
continue;
} else {
var temp__5735__auto___40795 = cljs.core.seq(seq__40010_40786);
if(temp__5735__auto___40795){
var seq__40010_40796__$1 = temp__5735__auto___40795;
if(cljs.core.chunked_seq_QMARK_(seq__40010_40796__$1)){
var c__4550__auto___40797 = cljs.core.chunk_first(seq__40010_40796__$1);
var G__40798 = cljs.core.chunk_rest(seq__40010_40796__$1);
var G__40799 = c__4550__auto___40797;
var G__40800 = cljs.core.count(c__4550__auto___40797);
var G__40801 = (0);
seq__40010_40786 = G__40798;
chunk__40011_40787 = G__40799;
count__40012_40788 = G__40800;
i__40013_40789 = G__40801;
continue;
} else {
var x_40802 = cljs.core.first(seq__40010_40796__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_40802);


var G__40803 = cljs.core.next(seq__40010_40796__$1);
var G__40804 = null;
var G__40805 = (0);
var G__40806 = (0);
seq__40010_40786 = G__40803;
chunk__40011_40787 = G__40804;
count__40012_40788 = G__40805;
i__40013_40789 = G__40806;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq39990){
var G__39991 = cljs.core.first(seq39990);
var seq39990__$1 = cljs.core.next(seq39990);
var G__39992 = cljs.core.first(seq39990__$1);
var seq39990__$2 = cljs.core.next(seq39990__$1);
var G__39993 = cljs.core.first(seq39990__$2);
var seq39990__$3 = cljs.core.next(seq39990__$2);
var G__39994 = cljs.core.first(seq39990__$3);
var seq39990__$4 = cljs.core.next(seq39990__$3);
var G__39995 = cljs.core.first(seq39990__$4);
var seq39990__$5 = cljs.core.next(seq39990__$4);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39991,G__39992,G__39993,G__39994,G__39995,seq39990__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__40016_40807 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__40017_40808 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__40018_40809 = true;
var _STAR_print_fn_STAR__temp_val__40019_40810 = (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__40018_40809);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__40019_40810);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__40017_40808);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__40016_40807);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4613__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__40020 = cljs.core.get_global_hierarchy;
return (fexpr__40020.cljs$core$IFn$_invoke$arity$0 ? fexpr__40020.cljs$core$IFn$_invoke$arity$0() : fexpr__40020.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__40022 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40022,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40022,(1),null);
var G__40025 = ns;
var G__40026 = name;
var G__40027 = (function (){
var G__40028 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__40028) : cljs.compiler.emit_constant.call(null,G__40028));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__40025,G__40026,G__40027) : cljs.compiler.emit_record_value.call(null,G__40025,G__40026,G__40027));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__40029 = cljs.core.keys(x);
var G__40030 = cljs.core.vals(x);
var G__40031 = cljs.compiler.emit_constants_comma_sep;
var G__40032 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__40029,G__40030,G__40031,G__40032) : cljs.compiler.emit_map.call(null,G__40029,G__40030,G__40031,G__40032));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x);

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__40033 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__40034 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__40033,G__40034) : cljs.compiler.emit_with_meta.call(null,G__40033,G__40034));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__40037 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40037,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40037,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40037,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4109__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4109__auto__)){
var G__40040 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__40040) : x.call(null,G__40040));
} else {
return and__4109__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4109__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4109__auto__)){
var G__40042 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__40042) : x.call(null,G__40042));
} else {
return and__4109__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__40048 = items;
var G__40049 = (function (p1__40046_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__40046_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__40048,G__40049) : cljs.compiler.emit_js_object.call(null,G__40048,G__40049));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__40051){
var map__40052 = p__40051;
var map__40052__$1 = (((((!((map__40052 == null))))?(((((map__40052.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40052.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40052):map__40052);
var ast = map__40052__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40052__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40052__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40052__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__40057 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__40057__$1 = (((((!((map__40057 == null))))?(((((map__40057.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40057.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40057):map__40057);
var cenv = map__40057__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40057__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4120__auto__ = js_module_name;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__40060 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4109__auto__ = (function (){var G__40064 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__40064) : cljs.compiler.es5_GT__EQ_.call(null,G__40064));
})();
if(cljs.core.truth_(and__4109__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4109__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__40060,cljs.analyzer.es5_allowed);
} else {
return G__40060;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4120__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__40065 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__40065,reserved);
} else {
return G__40065;
}
})();
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__40066_40814 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__40066_40815__$1 = (((G__40066_40814 instanceof cljs.core.Keyword))?G__40066_40814.fqn:null);
switch (G__40066_40815__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4109__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4109__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4109__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__40067){
var map__40068 = p__40067;
var map__40068__$1 = (((((!((map__40068 == null))))?(((((map__40068.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40068.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40068):map__40068);
var arg = map__40068__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40068__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40068__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40068__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40068__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__40070 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__40070__$1 = (((((!((map__40070 == null))))?(((((map__40070.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40070.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40070):map__40070);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40070__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__40072){
var map__40074 = p__40072;
var map__40074__$1 = (((((!((map__40074 == null))))?(((((map__40074.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40074.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40074):map__40074);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40074__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40074__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40074__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__40076_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__40076_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__40077 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__40077) : comma_sep.call(null,G__40077));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__40078 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__40078) : comma_sep.call(null,G__40078));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__40079){
var map__40080 = p__40079;
var map__40080__$1 = (((((!((map__40080 == null))))?(((((map__40080.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40080.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40080):map__40080);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40080__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40080__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40080__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__40083){
var map__40084 = p__40083;
var map__40084__$1 = (((((!((map__40084 == null))))?(((((map__40084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40084.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40084):map__40084);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40084__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40084__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__40087_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__40087_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__40088 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__40088) : comma_sep.call(null,G__40088));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__40089){
var map__40090 = p__40089;
var map__40090__$1 = (((((!((map__40090 == null))))?(((((map__40090.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40090.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40090):map__40090);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40090__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40090__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___40819 = cljs.core.seq(items);
if(temp__5735__auto___40819){
var items_40820__$1 = temp__5735__auto___40819;
var vec__40092_40821 = items_40820__$1;
var seq__40093_40822 = cljs.core.seq(vec__40092_40821);
var first__40094_40823 = cljs.core.first(seq__40093_40822);
var seq__40093_40824__$1 = cljs.core.next(seq__40093_40822);
var vec__40095_40825 = first__40094_40823;
var k_40826 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40095_40825,(0),null);
var v_40827 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40095_40825,(1),null);
var r_40828 = seq__40093_40824__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_40826),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_40827) : emit_js_object_val.call(null,v_40827)));

var seq__40098_40829 = cljs.core.seq(r_40828);
var chunk__40099_40830 = null;
var count__40100_40831 = (0);
var i__40101_40832 = (0);
while(true){
if((i__40101_40832 < count__40100_40831)){
var vec__40111_40833 = chunk__40099_40830.cljs$core$IIndexed$_nth$arity$2(null,i__40101_40832);
var k_40834__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40111_40833,(0),null);
var v_40835__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40111_40833,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_40834__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_40835__$1) : emit_js_object_val.call(null,v_40835__$1)));


var G__40836 = seq__40098_40829;
var G__40837 = chunk__40099_40830;
var G__40838 = count__40100_40831;
var G__40839 = (i__40101_40832 + (1));
seq__40098_40829 = G__40836;
chunk__40099_40830 = G__40837;
count__40100_40831 = G__40838;
i__40101_40832 = G__40839;
continue;
} else {
var temp__5735__auto___40840__$1 = cljs.core.seq(seq__40098_40829);
if(temp__5735__auto___40840__$1){
var seq__40098_40841__$1 = temp__5735__auto___40840__$1;
if(cljs.core.chunked_seq_QMARK_(seq__40098_40841__$1)){
var c__4550__auto___40842 = cljs.core.chunk_first(seq__40098_40841__$1);
var G__40843 = cljs.core.chunk_rest(seq__40098_40841__$1);
var G__40844 = c__4550__auto___40842;
var G__40845 = cljs.core.count(c__4550__auto___40842);
var G__40846 = (0);
seq__40098_40829 = G__40843;
chunk__40099_40830 = G__40844;
count__40100_40831 = G__40845;
i__40101_40832 = G__40846;
continue;
} else {
var vec__40114_40847 = cljs.core.first(seq__40098_40841__$1);
var k_40848__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40114_40847,(0),null);
var v_40849__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40114_40847,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_40848__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_40849__$1) : emit_js_object_val.call(null,v_40849__$1)));


var G__40850 = cljs.core.next(seq__40098_40841__$1);
var G__40851 = null;
var G__40852 = (0);
var G__40853 = (0);
seq__40098_40829 = G__40850;
chunk__40099_40830 = G__40851;
count__40100_40831 = G__40852;
i__40101_40832 = G__40853;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__40121){
var map__40122 = p__40121;
var map__40122__$1 = (((((!((map__40122 == null))))?(((((map__40122.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40122.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40122):map__40122);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40122__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40122__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40122__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__40127){
var map__40128 = p__40127;
var map__40128__$1 = (((((!((map__40128 == null))))?(((((map__40128.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40128.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40128):map__40128);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40128__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40128__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__40130){
var map__40131 = p__40130;
var map__40131__$1 = (((((!((map__40131 == null))))?(((((map__40131.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40131.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40131):map__40131);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40131__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__40135){
var map__40136 = p__40135;
var map__40136__$1 = (((((!((map__40136 == null))))?(((((map__40136.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40136.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40136):map__40136);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40136__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40136__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__40148 = cljs.analyzer.unwrap_quote(expr);
var map__40148__$1 = (((((!((map__40148 == null))))?(((((map__40148.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40148.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40148):map__40148);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40148__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40148__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40148__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4120__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4109__auto__ = form;
if(cljs.core.truth_(and__4109__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4109__auto__;
}
})():false);
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__40154 = cljs.analyzer.unwrap_quote(expr);
var map__40154__$1 = (((((!((map__40154 == null))))?(((((map__40154.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40154.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40154):map__40154);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40154__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40154__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40154__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4120__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4120__auto__){
return or__4120__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4120__auto__ = (function (){var fexpr__40157 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__40157.cljs$core$IFn$_invoke$arity$1 ? fexpr__40157.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__40157.call(null,tag));
})();
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__40158){
var map__40159 = p__40158;
var map__40159__$1 = (((((!((map__40159 == null))))?(((((map__40159.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40159.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40159):map__40159);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40159__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40159__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40159__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40159__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40159__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4120__auto__ = unchecked;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__40161){
var map__40162 = p__40161;
var map__40162__$1 = (((((!((map__40162 == null))))?(((((map__40162.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40162.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40162):map__40162);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40162__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40162__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40162__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40162__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__40164_40864 = cljs.core.seq(nodes);
var chunk__40165_40865 = null;
var count__40166_40866 = (0);
var i__40167_40867 = (0);
while(true){
if((i__40167_40867 < count__40166_40866)){
var map__40189_40868 = chunk__40165_40865.cljs$core$IIndexed$_nth$arity$2(null,i__40167_40867);
var map__40189_40869__$1 = (((((!((map__40189_40868 == null))))?(((((map__40189_40868.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40189_40868.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40189_40868):map__40189_40868);
var ts_40870 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40189_40869__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__40190_40871 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40189_40869__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__40190_40872__$1 = (((((!((map__40190_40871 == null))))?(((((map__40190_40871.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40190_40871.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40190_40871):map__40190_40871);
var then_40873 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40190_40872__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__40193_40875 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_40870));
var chunk__40194_40876 = null;
var count__40195_40877 = (0);
var i__40196_40878 = (0);
while(true){
if((i__40196_40878 < count__40195_40877)){
var test_40879 = chunk__40194_40876.cljs$core$IIndexed$_nth$arity$2(null,i__40196_40878);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_40879,":");


var G__40880 = seq__40193_40875;
var G__40881 = chunk__40194_40876;
var G__40882 = count__40195_40877;
var G__40883 = (i__40196_40878 + (1));
seq__40193_40875 = G__40880;
chunk__40194_40876 = G__40881;
count__40195_40877 = G__40882;
i__40196_40878 = G__40883;
continue;
} else {
var temp__5735__auto___40884 = cljs.core.seq(seq__40193_40875);
if(temp__5735__auto___40884){
var seq__40193_40885__$1 = temp__5735__auto___40884;
if(cljs.core.chunked_seq_QMARK_(seq__40193_40885__$1)){
var c__4550__auto___40886 = cljs.core.chunk_first(seq__40193_40885__$1);
var G__40887 = cljs.core.chunk_rest(seq__40193_40885__$1);
var G__40888 = c__4550__auto___40886;
var G__40889 = cljs.core.count(c__4550__auto___40886);
var G__40890 = (0);
seq__40193_40875 = G__40887;
chunk__40194_40876 = G__40888;
count__40195_40877 = G__40889;
i__40196_40878 = G__40890;
continue;
} else {
var test_40891 = cljs.core.first(seq__40193_40885__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_40891,":");


var G__40892 = cljs.core.next(seq__40193_40885__$1);
var G__40893 = null;
var G__40894 = (0);
var G__40895 = (0);
seq__40193_40875 = G__40892;
chunk__40194_40876 = G__40893;
count__40195_40877 = G__40894;
i__40196_40878 = G__40895;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_40873);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_40873);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__40896 = seq__40164_40864;
var G__40897 = chunk__40165_40865;
var G__40898 = count__40166_40866;
var G__40899 = (i__40167_40867 + (1));
seq__40164_40864 = G__40896;
chunk__40165_40865 = G__40897;
count__40166_40866 = G__40898;
i__40167_40867 = G__40899;
continue;
} else {
var temp__5735__auto___40900 = cljs.core.seq(seq__40164_40864);
if(temp__5735__auto___40900){
var seq__40164_40901__$1 = temp__5735__auto___40900;
if(cljs.core.chunked_seq_QMARK_(seq__40164_40901__$1)){
var c__4550__auto___40902 = cljs.core.chunk_first(seq__40164_40901__$1);
var G__40903 = cljs.core.chunk_rest(seq__40164_40901__$1);
var G__40904 = c__4550__auto___40902;
var G__40905 = cljs.core.count(c__4550__auto___40902);
var G__40906 = (0);
seq__40164_40864 = G__40903;
chunk__40165_40865 = G__40904;
count__40166_40866 = G__40905;
i__40167_40867 = G__40906;
continue;
} else {
var map__40197_40907 = cljs.core.first(seq__40164_40901__$1);
var map__40197_40908__$1 = (((((!((map__40197_40907 == null))))?(((((map__40197_40907.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40197_40907.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40197_40907):map__40197_40907);
var ts_40909 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40197_40908__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__40198_40910 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40197_40908__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__40198_40911__$1 = (((((!((map__40198_40910 == null))))?(((((map__40198_40910.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40198_40910.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40198_40910):map__40198_40910);
var then_40912 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40198_40911__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__40201_40913 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_40909));
var chunk__40202_40914 = null;
var count__40203_40915 = (0);
var i__40204_40916 = (0);
while(true){
if((i__40204_40916 < count__40203_40915)){
var test_40917 = chunk__40202_40914.cljs$core$IIndexed$_nth$arity$2(null,i__40204_40916);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_40917,":");


var G__40918 = seq__40201_40913;
var G__40919 = chunk__40202_40914;
var G__40920 = count__40203_40915;
var G__40921 = (i__40204_40916 + (1));
seq__40201_40913 = G__40918;
chunk__40202_40914 = G__40919;
count__40203_40915 = G__40920;
i__40204_40916 = G__40921;
continue;
} else {
var temp__5735__auto___40922__$1 = cljs.core.seq(seq__40201_40913);
if(temp__5735__auto___40922__$1){
var seq__40201_40923__$1 = temp__5735__auto___40922__$1;
if(cljs.core.chunked_seq_QMARK_(seq__40201_40923__$1)){
var c__4550__auto___40924 = cljs.core.chunk_first(seq__40201_40923__$1);
var G__40925 = cljs.core.chunk_rest(seq__40201_40923__$1);
var G__40926 = c__4550__auto___40924;
var G__40927 = cljs.core.count(c__4550__auto___40924);
var G__40928 = (0);
seq__40201_40913 = G__40925;
chunk__40202_40914 = G__40926;
count__40203_40915 = G__40927;
i__40204_40916 = G__40928;
continue;
} else {
var test_40929 = cljs.core.first(seq__40201_40923__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_40929,":");


var G__40930 = cljs.core.next(seq__40201_40923__$1);
var G__40931 = null;
var G__40932 = (0);
var G__40933 = (0);
seq__40201_40913 = G__40930;
chunk__40202_40914 = G__40931;
count__40203_40915 = G__40932;
i__40204_40916 = G__40933;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_40912);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_40912);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__40934 = cljs.core.next(seq__40164_40901__$1);
var G__40935 = null;
var G__40936 = (0);
var G__40937 = (0);
seq__40164_40864 = G__40934;
chunk__40165_40865 = G__40935;
count__40166_40866 = G__40936;
i__40167_40867 = G__40937;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__40205){
var map__40206 = p__40205;
var map__40206__$1 = (((((!((map__40206 == null))))?(((((map__40206.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40206.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40206):map__40206);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40206__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40206__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__40211 = env;
var G__40212 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__40211,G__40212) : cljs.compiler.resolve_type.call(null,G__40211,G__40212));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__40213 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40213,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40213,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__40208_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__40208_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__40208_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__40216 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__40216,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__40216;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__40219 = env;
var G__40220 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__40219,G__40220) : cljs.compiler.resolve_type.call(null,G__40219,G__40220));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40221_SHARP_){
return cljs.compiler.resolve_type(env,p1__40221_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__40222 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__40223 = cljs.core.seq(vec__40222);
var first__40224 = cljs.core.first(seq__40223);
var seq__40223__$1 = cljs.core.next(seq__40223);
var p = first__40224;
var first__40224__$1 = cljs.core.first(seq__40223__$1);
var seq__40223__$2 = cljs.core.next(seq__40223__$1);
var ts = first__40224__$1;
var first__40224__$2 = cljs.core.first(seq__40223__$2);
var seq__40223__$3 = cljs.core.next(seq__40223__$2);
var n = first__40224__$2;
var xs = seq__40223__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4109__auto__ = ts;
if(cljs.core.truth_(and__4109__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4109__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__40225 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__40226 = cljs.core.seq(vec__40225);
var first__40227 = cljs.core.first(seq__40226);
var seq__40226__$1 = cljs.core.next(seq__40226);
var p = first__40227;
var first__40227__$1 = cljs.core.first(seq__40226__$1);
var seq__40226__$2 = cljs.core.next(seq__40226__$1);
var ts = first__40227__$1;
var xs = seq__40226__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4109__auto__ = ts;
if(cljs.core.truth_(and__4109__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4109__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__40229 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__40228 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__40228.cljs$core$IFn$_invoke$arity$1 ? fexpr__40228.cljs$core$IFn$_invoke$arity$1(G__40229) : fexpr__40228.call(null,G__40229));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__40232 = arguments.length;
switch (G__40232) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__40240 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40230_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__40230_SHARP_);
} else {
return p1__40230_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__40241 = cljs.core.seq(vec__40240);
var first__40242 = cljs.core.first(seq__40241);
var seq__40241__$1 = cljs.core.next(seq__40241);
var x = first__40242;
var ys = seq__40241__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__40243 = cljs.core.seq(ys);
var chunk__40244 = null;
var count__40245 = (0);
var i__40246 = (0);
while(true){
if((i__40246 < count__40245)){
var next_line = chunk__40244.cljs$core$IIndexed$_nth$arity$2(null,i__40246);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__40940 = seq__40243;
var G__40941 = chunk__40244;
var G__40942 = count__40245;
var G__40943 = (i__40246 + (1));
seq__40243 = G__40940;
chunk__40244 = G__40941;
count__40245 = G__40942;
i__40246 = G__40943;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__40243);
if(temp__5735__auto__){
var seq__40243__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40243__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__40243__$1);
var G__40944 = cljs.core.chunk_rest(seq__40243__$1);
var G__40945 = c__4550__auto__;
var G__40946 = cljs.core.count(c__4550__auto__);
var G__40947 = (0);
seq__40243 = G__40944;
chunk__40244 = G__40945;
count__40245 = G__40946;
i__40246 = G__40947;
continue;
} else {
var next_line = cljs.core.first(seq__40243__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__40948 = cljs.core.next(seq__40243__$1);
var G__40949 = null;
var G__40950 = (0);
var G__40951 = (0);
seq__40243 = G__40948;
chunk__40244 = G__40949;
count__40245 = G__40950;
i__40246 = G__40951;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__40247_40952 = cljs.core.seq(docs__$2);
var chunk__40248_40953 = null;
var count__40249_40954 = (0);
var i__40250_40955 = (0);
while(true){
if((i__40250_40955 < count__40249_40954)){
var e_40956 = chunk__40248_40953.cljs$core$IIndexed$_nth$arity$2(null,i__40250_40955);
if(cljs.core.truth_(e_40956)){
print_comment_lines(e_40956);
} else {
}


var G__40957 = seq__40247_40952;
var G__40958 = chunk__40248_40953;
var G__40959 = count__40249_40954;
var G__40960 = (i__40250_40955 + (1));
seq__40247_40952 = G__40957;
chunk__40248_40953 = G__40958;
count__40249_40954 = G__40959;
i__40250_40955 = G__40960;
continue;
} else {
var temp__5735__auto___40961 = cljs.core.seq(seq__40247_40952);
if(temp__5735__auto___40961){
var seq__40247_40962__$1 = temp__5735__auto___40961;
if(cljs.core.chunked_seq_QMARK_(seq__40247_40962__$1)){
var c__4550__auto___40963 = cljs.core.chunk_first(seq__40247_40962__$1);
var G__40964 = cljs.core.chunk_rest(seq__40247_40962__$1);
var G__40965 = c__4550__auto___40963;
var G__40966 = cljs.core.count(c__4550__auto___40963);
var G__40967 = (0);
seq__40247_40952 = G__40964;
chunk__40248_40953 = G__40965;
count__40249_40954 = G__40966;
i__40250_40955 = G__40967;
continue;
} else {
var e_40968 = cljs.core.first(seq__40247_40962__$1);
if(cljs.core.truth_(e_40968)){
print_comment_lines(e_40968);
} else {
}


var G__40969 = cljs.core.next(seq__40247_40962__$1);
var G__40970 = null;
var G__40971 = (0);
var G__40972 = (0);
seq__40247_40952 = G__40969;
chunk__40248_40953 = G__40970;
count__40249_40954 = G__40971;
i__40250_40955 = G__40972;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4109__auto__ = cljs.core.some((function (p1__40255_SHARP_){
return goog.string.startsWith(p1__40255_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4109__auto__)){
var and__4109__auto____$1 = opts;
if(cljs.core.truth_(and__4109__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4109__auto____$1;
}
} else {
return and__4109__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__40261){
var map__40262 = p__40261;
var map__40262__$1 = (((((!((map__40262 == null))))?(((((map__40262.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40262.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40262):map__40262);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40262__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40262__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40262__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40262__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40262__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40262__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40262__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40262__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40262__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40262__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4120__auto__ = init;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4109__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4109__auto__)){
return test;
} else {
return and__4109__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__40264){
var map__40265 = p__40264;
var map__40265__$1 = (((((!((map__40265 == null))))?(((((map__40265.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40265.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40265):map__40265);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40265__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40265__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40265__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__40267_40974 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__40268_40975 = null;
var count__40269_40976 = (0);
var i__40270_40977 = (0);
while(true){
if((i__40270_40977 < count__40269_40976)){
var vec__40277_40978 = chunk__40268_40975.cljs$core$IIndexed$_nth$arity$2(null,i__40270_40977);
var i_40979 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40277_40978,(0),null);
var param_40980 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40277_40978,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_40980);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__40981 = seq__40267_40974;
var G__40982 = chunk__40268_40975;
var G__40983 = count__40269_40976;
var G__40984 = (i__40270_40977 + (1));
seq__40267_40974 = G__40981;
chunk__40268_40975 = G__40982;
count__40269_40976 = G__40983;
i__40270_40977 = G__40984;
continue;
} else {
var temp__5735__auto___40985 = cljs.core.seq(seq__40267_40974);
if(temp__5735__auto___40985){
var seq__40267_40986__$1 = temp__5735__auto___40985;
if(cljs.core.chunked_seq_QMARK_(seq__40267_40986__$1)){
var c__4550__auto___40987 = cljs.core.chunk_first(seq__40267_40986__$1);
var G__40988 = cljs.core.chunk_rest(seq__40267_40986__$1);
var G__40989 = c__4550__auto___40987;
var G__40990 = cljs.core.count(c__4550__auto___40987);
var G__40991 = (0);
seq__40267_40974 = G__40988;
chunk__40268_40975 = G__40989;
count__40269_40976 = G__40990;
i__40270_40977 = G__40991;
continue;
} else {
var vec__40280_40992 = cljs.core.first(seq__40267_40986__$1);
var i_40993 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40280_40992,(0),null);
var param_40994 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40280_40992,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_40994);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__40995 = cljs.core.next(seq__40267_40986__$1);
var G__40996 = null;
var G__40997 = (0);
var G__40998 = (0);
seq__40267_40974 = G__40995;
chunk__40268_40975 = G__40996;
count__40269_40976 = G__40997;
i__40270_40977 = G__40998;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__40283_40999 = cljs.core.seq(params);
var chunk__40284_41000 = null;
var count__40285_41001 = (0);
var i__40286_41002 = (0);
while(true){
if((i__40286_41002 < count__40285_41001)){
var param_41003 = chunk__40284_41000.cljs$core$IIndexed$_nth$arity$2(null,i__40286_41002);
cljs.compiler.emit(param_41003);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_41003,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__41004 = seq__40283_40999;
var G__41005 = chunk__40284_41000;
var G__41006 = count__40285_41001;
var G__41007 = (i__40286_41002 + (1));
seq__40283_40999 = G__41004;
chunk__40284_41000 = G__41005;
count__40285_41001 = G__41006;
i__40286_41002 = G__41007;
continue;
} else {
var temp__5735__auto___41008 = cljs.core.seq(seq__40283_40999);
if(temp__5735__auto___41008){
var seq__40283_41009__$1 = temp__5735__auto___41008;
if(cljs.core.chunked_seq_QMARK_(seq__40283_41009__$1)){
var c__4550__auto___41010 = cljs.core.chunk_first(seq__40283_41009__$1);
var G__41011 = cljs.core.chunk_rest(seq__40283_41009__$1);
var G__41012 = c__4550__auto___41010;
var G__41013 = cljs.core.count(c__4550__auto___41010);
var G__41014 = (0);
seq__40283_40999 = G__41011;
chunk__40284_41000 = G__41012;
count__40285_41001 = G__41013;
i__40286_41002 = G__41014;
continue;
} else {
var param_41015 = cljs.core.first(seq__40283_41009__$1);
cljs.compiler.emit(param_41015);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_41015,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__41016 = cljs.core.next(seq__40283_41009__$1);
var G__41017 = null;
var G__41018 = (0);
var G__41019 = (0);
seq__40283_40999 = G__41016;
chunk__40284_41000 = G__41017;
count__40285_41001 = G__41018;
i__40286_41002 = G__41019;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__40287_41020 = cljs.core.seq(params);
var chunk__40288_41021 = null;
var count__40289_41022 = (0);
var i__40290_41023 = (0);
while(true){
if((i__40290_41023 < count__40289_41022)){
var param_41024 = chunk__40288_41021.cljs$core$IIndexed$_nth$arity$2(null,i__40290_41023);
cljs.compiler.emit(param_41024);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_41024,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__41025 = seq__40287_41020;
var G__41026 = chunk__40288_41021;
var G__41027 = count__40289_41022;
var G__41028 = (i__40290_41023 + (1));
seq__40287_41020 = G__41025;
chunk__40288_41021 = G__41026;
count__40289_41022 = G__41027;
i__40290_41023 = G__41028;
continue;
} else {
var temp__5735__auto___41029 = cljs.core.seq(seq__40287_41020);
if(temp__5735__auto___41029){
var seq__40287_41030__$1 = temp__5735__auto___41029;
if(cljs.core.chunked_seq_QMARK_(seq__40287_41030__$1)){
var c__4550__auto___41031 = cljs.core.chunk_first(seq__40287_41030__$1);
var G__41032 = cljs.core.chunk_rest(seq__40287_41030__$1);
var G__41033 = c__4550__auto___41031;
var G__41034 = cljs.core.count(c__4550__auto___41031);
var G__41035 = (0);
seq__40287_41020 = G__41032;
chunk__40288_41021 = G__41033;
count__40289_41022 = G__41034;
i__40290_41023 = G__41035;
continue;
} else {
var param_41036 = cljs.core.first(seq__40287_41030__$1);
cljs.compiler.emit(param_41036);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_41036,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__41037 = cljs.core.next(seq__40287_41030__$1);
var G__41038 = null;
var G__41039 = (0);
var G__41040 = (0);
seq__40287_41020 = G__41037;
chunk__40288_41021 = G__41038;
count__40289_41022 = G__41039;
i__40290_41023 = G__41040;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__40293 = cljs.core.seq(params);
var chunk__40294 = null;
var count__40295 = (0);
var i__40296 = (0);
while(true){
if((i__40296 < count__40295)){
var param = chunk__40294.cljs$core$IIndexed$_nth$arity$2(null,i__40296);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__41041 = seq__40293;
var G__41042 = chunk__40294;
var G__41043 = count__40295;
var G__41044 = (i__40296 + (1));
seq__40293 = G__41041;
chunk__40294 = G__41042;
count__40295 = G__41043;
i__40296 = G__41044;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__40293);
if(temp__5735__auto__){
var seq__40293__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40293__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__40293__$1);
var G__41045 = cljs.core.chunk_rest(seq__40293__$1);
var G__41046 = c__4550__auto__;
var G__41047 = cljs.core.count(c__4550__auto__);
var G__41048 = (0);
seq__40293 = G__41045;
chunk__40294 = G__41046;
count__40295 = G__41047;
i__40296 = G__41048;
continue;
} else {
var param = cljs.core.first(seq__40293__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__41049 = cljs.core.next(seq__40293__$1);
var G__41050 = null;
var G__41051 = (0);
var G__41052 = (0);
seq__40293 = G__41049;
chunk__40294 = G__41050;
count__40295 = G__41051;
i__40296 = G__41052;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__40297){
var map__40298 = p__40297;
var map__40298__$1 = (((((!((map__40298 == null))))?(((((map__40298.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40298.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40298):map__40298);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40298__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40298__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40298__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40298__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40298__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40298__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__40304){
var map__40305 = p__40304;
var map__40305__$1 = (((((!((map__40305 == null))))?(((((map__40305.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40305.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40305):map__40305);
var f = map__40305__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40305__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40305__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40305__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40305__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40305__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40305__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40305__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40305__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_41053__$1 = (function (){var or__4120__auto__ = name;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_41054 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_41053__$1);
var delegate_name_41055 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_41054),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_41055," = function (");

var seq__40307_41056 = cljs.core.seq(params);
var chunk__40308_41057 = null;
var count__40309_41058 = (0);
var i__40310_41059 = (0);
while(true){
if((i__40310_41059 < count__40309_41058)){
var param_41060 = chunk__40308_41057.cljs$core$IIndexed$_nth$arity$2(null,i__40310_41059);
cljs.compiler.emit(param_41060);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_41060,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__41061 = seq__40307_41056;
var G__41062 = chunk__40308_41057;
var G__41063 = count__40309_41058;
var G__41064 = (i__40310_41059 + (1));
seq__40307_41056 = G__41061;
chunk__40308_41057 = G__41062;
count__40309_41058 = G__41063;
i__40310_41059 = G__41064;
continue;
} else {
var temp__5735__auto___41065 = cljs.core.seq(seq__40307_41056);
if(temp__5735__auto___41065){
var seq__40307_41066__$1 = temp__5735__auto___41065;
if(cljs.core.chunked_seq_QMARK_(seq__40307_41066__$1)){
var c__4550__auto___41067 = cljs.core.chunk_first(seq__40307_41066__$1);
var G__41068 = cljs.core.chunk_rest(seq__40307_41066__$1);
var G__41069 = c__4550__auto___41067;
var G__41070 = cljs.core.count(c__4550__auto___41067);
var G__41071 = (0);
seq__40307_41056 = G__41068;
chunk__40308_41057 = G__41069;
count__40309_41058 = G__41070;
i__40310_41059 = G__41071;
continue;
} else {
var param_41072 = cljs.core.first(seq__40307_41066__$1);
cljs.compiler.emit(param_41072);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_41072,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__41073 = cljs.core.next(seq__40307_41066__$1);
var G__41074 = null;
var G__41075 = (0);
var G__41076 = (0);
seq__40307_41056 = G__41073;
chunk__40308_41057 = G__41074;
count__40309_41058 = G__41075;
i__40310_41059 = G__41076;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_41054," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_41077 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_41077,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_41055,".call(this,");

var seq__40313_41078 = cljs.core.seq(params);
var chunk__40314_41079 = null;
var count__40315_41080 = (0);
var i__40316_41081 = (0);
while(true){
if((i__40316_41081 < count__40315_41080)){
var param_41082 = chunk__40314_41079.cljs$core$IIndexed$_nth$arity$2(null,i__40316_41081);
cljs.compiler.emit(param_41082);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_41082,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__41083 = seq__40313_41078;
var G__41084 = chunk__40314_41079;
var G__41085 = count__40315_41080;
var G__41086 = (i__40316_41081 + (1));
seq__40313_41078 = G__41083;
chunk__40314_41079 = G__41084;
count__40315_41080 = G__41085;
i__40316_41081 = G__41086;
continue;
} else {
var temp__5735__auto___41087 = cljs.core.seq(seq__40313_41078);
if(temp__5735__auto___41087){
var seq__40313_41088__$1 = temp__5735__auto___41087;
if(cljs.core.chunked_seq_QMARK_(seq__40313_41088__$1)){
var c__4550__auto___41089 = cljs.core.chunk_first(seq__40313_41088__$1);
var G__41090 = cljs.core.chunk_rest(seq__40313_41088__$1);
var G__41091 = c__4550__auto___41089;
var G__41092 = cljs.core.count(c__4550__auto___41089);
var G__41093 = (0);
seq__40313_41078 = G__41090;
chunk__40314_41079 = G__41091;
count__40315_41080 = G__41092;
i__40316_41081 = G__41093;
continue;
} else {
var param_41094 = cljs.core.first(seq__40313_41088__$1);
cljs.compiler.emit(param_41094);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_41094,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__41095 = cljs.core.next(seq__40313_41088__$1);
var G__41096 = null;
var G__41097 = (0);
var G__41098 = (0);
seq__40313_41078 = G__41095;
chunk__40314_41079 = G__41096;
count__40315_41080 = G__41097;
i__40316_41081 = G__41098;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_41054,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_41054,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_41053__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_41054,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_41055,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_41054,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__40320){
var map__40321 = p__40320;
var map__40321__$1 = (((((!((map__40321 == null))))?(((((map__40321.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40321.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40321):map__40321);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40321__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40321__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40321__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40321__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40321__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40321__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40321__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40321__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__40317_SHARP_){
var and__4109__auto__ = p1__40317_SHARP_;
if(cljs.core.truth_(and__4109__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__40317_SHARP_));
} else {
return and__4109__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4120__auto__ = in_loop;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_41107__$1 = (function (){var or__4120__auto__ = name;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_41108 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_41107__$1);
var maxparams_41109 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_41110 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_41108),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_41111 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__40318_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__40318_SHARP_)));
}),cljs.core.seq(mmap_41110));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_41108," = null;");

var seq__40323_41112 = cljs.core.seq(ms_41111);
var chunk__40324_41113 = null;
var count__40325_41114 = (0);
var i__40326_41115 = (0);
while(true){
if((i__40326_41115 < count__40325_41114)){
var vec__40333_41116 = chunk__40324_41113.cljs$core$IIndexed$_nth$arity$2(null,i__40326_41115);
var n_41117 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40333_41116,(0),null);
var meth_41118 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40333_41116,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_41117," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_41118))){
cljs.compiler.emit_variadic_fn_method(meth_41118);
} else {
cljs.compiler.emit_fn_method(meth_41118);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__41119 = seq__40323_41112;
var G__41120 = chunk__40324_41113;
var G__41121 = count__40325_41114;
var G__41122 = (i__40326_41115 + (1));
seq__40323_41112 = G__41119;
chunk__40324_41113 = G__41120;
count__40325_41114 = G__41121;
i__40326_41115 = G__41122;
continue;
} else {
var temp__5735__auto___41123 = cljs.core.seq(seq__40323_41112);
if(temp__5735__auto___41123){
var seq__40323_41124__$1 = temp__5735__auto___41123;
if(cljs.core.chunked_seq_QMARK_(seq__40323_41124__$1)){
var c__4550__auto___41125 = cljs.core.chunk_first(seq__40323_41124__$1);
var G__41126 = cljs.core.chunk_rest(seq__40323_41124__$1);
var G__41127 = c__4550__auto___41125;
var G__41128 = cljs.core.count(c__4550__auto___41125);
var G__41129 = (0);
seq__40323_41112 = G__41126;
chunk__40324_41113 = G__41127;
count__40325_41114 = G__41128;
i__40326_41115 = G__41129;
continue;
} else {
var vec__40336_41131 = cljs.core.first(seq__40323_41124__$1);
var n_41132 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40336_41131,(0),null);
var meth_41133 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40336_41131,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_41132," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_41133))){
cljs.compiler.emit_variadic_fn_method(meth_41133);
} else {
cljs.compiler.emit_fn_method(meth_41133);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__41134 = cljs.core.next(seq__40323_41124__$1);
var G__41135 = null;
var G__41136 = (0);
var G__41137 = (0);
seq__40323_41112 = G__41134;
chunk__40324_41113 = G__41135;
count__40325_41114 = G__41136;
i__40326_41115 = G__41137;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_41108," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_41109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_41109)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_41109));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__40339_41138 = cljs.core.seq(ms_41111);
var chunk__40340_41139 = null;
var count__40341_41140 = (0);
var i__40342_41141 = (0);
while(true){
if((i__40342_41141 < count__40341_41140)){
var vec__40349_41142 = chunk__40340_41139.cljs$core$IIndexed$_nth$arity$2(null,i__40342_41141);
var n_41143 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40349_41142,(0),null);
var meth_41144 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40349_41142,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_41144))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_41145 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_41145," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_41146 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_41145," = new cljs.core.IndexedSeq(",a_41146,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_41143,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_41109)),(((cljs.core.count(maxparams_41109) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_41145,");"], 0));
} else {
var pcnt_41147 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_41144));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_41147,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_41143,".call(this",(((pcnt_41147 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_41147,maxparams_41109)),null,(1),null)),(2),null))),");");
}


var G__41148 = seq__40339_41138;
var G__41149 = chunk__40340_41139;
var G__41150 = count__40341_41140;
var G__41151 = (i__40342_41141 + (1));
seq__40339_41138 = G__41148;
chunk__40340_41139 = G__41149;
count__40341_41140 = G__41150;
i__40342_41141 = G__41151;
continue;
} else {
var temp__5735__auto___41152 = cljs.core.seq(seq__40339_41138);
if(temp__5735__auto___41152){
var seq__40339_41153__$1 = temp__5735__auto___41152;
if(cljs.core.chunked_seq_QMARK_(seq__40339_41153__$1)){
var c__4550__auto___41154 = cljs.core.chunk_first(seq__40339_41153__$1);
var G__41155 = cljs.core.chunk_rest(seq__40339_41153__$1);
var G__41156 = c__4550__auto___41154;
var G__41157 = cljs.core.count(c__4550__auto___41154);
var G__41158 = (0);
seq__40339_41138 = G__41155;
chunk__40340_41139 = G__41156;
count__40341_41140 = G__41157;
i__40342_41141 = G__41158;
continue;
} else {
var vec__40352_41159 = cljs.core.first(seq__40339_41153__$1);
var n_41160 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40352_41159,(0),null);
var meth_41161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40352_41159,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_41161))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_41164 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_41164," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_41165 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_41164," = new cljs.core.IndexedSeq(",a_41165,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_41160,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_41109)),(((cljs.core.count(maxparams_41109) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_41164,");"], 0));
} else {
var pcnt_41166 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_41161));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_41166,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_41160,".call(this",(((pcnt_41166 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_41166,maxparams_41109)),null,(1),null)),(2),null))),");");
}


var G__41167 = cljs.core.next(seq__40339_41153__$1);
var G__41168 = null;
var G__41169 = (0);
var G__41170 = (0);
seq__40339_41138 = G__41167;
chunk__40340_41139 = G__41168;
count__40341_41140 = G__41169;
i__40342_41141 = G__41170;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_41171 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_41111)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_41171,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_41108,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_41108,".cljs$lang$applyTo = ",cljs.core.some((function (p1__40319_SHARP_){
var vec__40355 = p1__40319_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40355,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40355,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_41111),".cljs$lang$applyTo;");
} else {
}

var seq__40358_41172 = cljs.core.seq(ms_41111);
var chunk__40359_41173 = null;
var count__40360_41174 = (0);
var i__40361_41175 = (0);
while(true){
if((i__40361_41175 < count__40360_41174)){
var vec__40368_41176 = chunk__40359_41173.cljs$core$IIndexed$_nth$arity$2(null,i__40361_41175);
var n_41177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40368_41176,(0),null);
var meth_41178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40368_41176,(1),null);
var c_41179 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_41178));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_41178))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_41108,".cljs$core$IFn$_invoke$arity$variadic = ",n_41177,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_41108,".cljs$core$IFn$_invoke$arity$",c_41179," = ",n_41177,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__41180 = seq__40358_41172;
var G__41181 = chunk__40359_41173;
var G__41182 = count__40360_41174;
var G__41183 = (i__40361_41175 + (1));
seq__40358_41172 = G__41180;
chunk__40359_41173 = G__41181;
count__40360_41174 = G__41182;
i__40361_41175 = G__41183;
continue;
} else {
var temp__5735__auto___41185 = cljs.core.seq(seq__40358_41172);
if(temp__5735__auto___41185){
var seq__40358_41187__$1 = temp__5735__auto___41185;
if(cljs.core.chunked_seq_QMARK_(seq__40358_41187__$1)){
var c__4550__auto___41188 = cljs.core.chunk_first(seq__40358_41187__$1);
var G__41189 = cljs.core.chunk_rest(seq__40358_41187__$1);
var G__41190 = c__4550__auto___41188;
var G__41191 = cljs.core.count(c__4550__auto___41188);
var G__41192 = (0);
seq__40358_41172 = G__41189;
chunk__40359_41173 = G__41190;
count__40360_41174 = G__41191;
i__40361_41175 = G__41192;
continue;
} else {
var vec__40371_41193 = cljs.core.first(seq__40358_41187__$1);
var n_41194 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40371_41193,(0),null);
var meth_41195 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40371_41193,(1),null);
var c_41196 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_41195));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_41195))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_41108,".cljs$core$IFn$_invoke$arity$variadic = ",n_41194,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_41108,".cljs$core$IFn$_invoke$arity$",c_41196," = ",n_41194,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__41198 = cljs.core.next(seq__40358_41187__$1);
var G__41199 = null;
var G__41200 = (0);
var G__41201 = (0);
seq__40358_41172 = G__41198;
chunk__40359_41173 = G__41199;
count__40360_41174 = G__41200;
i__40361_41175 = G__41201;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_41108,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__40377){
var map__40378 = p__40377;
var map__40378__$1 = (((((!((map__40378 == null))))?(((((map__40378.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40378.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40378):map__40378);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40378__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40378__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40378__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__40380_41202 = cljs.core.seq(statements);
var chunk__40381_41203 = null;
var count__40382_41204 = (0);
var i__40383_41205 = (0);
while(true){
if((i__40383_41205 < count__40382_41204)){
var s_41206 = chunk__40381_41203.cljs$core$IIndexed$_nth$arity$2(null,i__40383_41205);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_41206);


var G__41207 = seq__40380_41202;
var G__41208 = chunk__40381_41203;
var G__41209 = count__40382_41204;
var G__41210 = (i__40383_41205 + (1));
seq__40380_41202 = G__41207;
chunk__40381_41203 = G__41208;
count__40382_41204 = G__41209;
i__40383_41205 = G__41210;
continue;
} else {
var temp__5735__auto___41214 = cljs.core.seq(seq__40380_41202);
if(temp__5735__auto___41214){
var seq__40380_41215__$1 = temp__5735__auto___41214;
if(cljs.core.chunked_seq_QMARK_(seq__40380_41215__$1)){
var c__4550__auto___41219 = cljs.core.chunk_first(seq__40380_41215__$1);
var G__41220 = cljs.core.chunk_rest(seq__40380_41215__$1);
var G__41221 = c__4550__auto___41219;
var G__41222 = cljs.core.count(c__4550__auto___41219);
var G__41223 = (0);
seq__40380_41202 = G__41220;
chunk__40381_41203 = G__41221;
count__40382_41204 = G__41222;
i__40383_41205 = G__41223;
continue;
} else {
var s_41224 = cljs.core.first(seq__40380_41215__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_41224);


var G__41225 = cljs.core.next(seq__40380_41215__$1);
var G__41226 = null;
var G__41227 = (0);
var G__41228 = (0);
seq__40380_41202 = G__41225;
chunk__40381_41203 = G__41226;
count__40382_41204 = G__41227;
i__40383_41205 = G__41228;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__40384){
var map__40385 = p__40384;
var map__40385__$1 = (((((!((map__40385 == null))))?(((((map__40385.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40385.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40385):map__40385);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40385__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40385__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40385__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40385__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40385__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4120__auto__ = name;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__40387,is_loop){
var map__40388 = p__40387;
var map__40388__$1 = (((((!((map__40388 == null))))?(((((map__40388.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40388.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40388):map__40388);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40388__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40388__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40388__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__40390_41229 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__40391_41230 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__40391_41230);

try{var seq__40392_41231 = cljs.core.seq(bindings);
var chunk__40393_41232 = null;
var count__40394_41233 = (0);
var i__40395_41234 = (0);
while(true){
if((i__40395_41234 < count__40394_41233)){
var map__40400_41235 = chunk__40393_41232.cljs$core$IIndexed$_nth$arity$2(null,i__40395_41234);
var map__40400_41236__$1 = (((((!((map__40400_41235 == null))))?(((((map__40400_41235.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40400_41235.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40400_41235):map__40400_41235);
var binding_41237 = map__40400_41236__$1;
var init_41238 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40400_41236__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_41237);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_41238,";");


var G__41239 = seq__40392_41231;
var G__41240 = chunk__40393_41232;
var G__41241 = count__40394_41233;
var G__41242 = (i__40395_41234 + (1));
seq__40392_41231 = G__41239;
chunk__40393_41232 = G__41240;
count__40394_41233 = G__41241;
i__40395_41234 = G__41242;
continue;
} else {
var temp__5735__auto___41243 = cljs.core.seq(seq__40392_41231);
if(temp__5735__auto___41243){
var seq__40392_41244__$1 = temp__5735__auto___41243;
if(cljs.core.chunked_seq_QMARK_(seq__40392_41244__$1)){
var c__4550__auto___41245 = cljs.core.chunk_first(seq__40392_41244__$1);
var G__41246 = cljs.core.chunk_rest(seq__40392_41244__$1);
var G__41247 = c__4550__auto___41245;
var G__41248 = cljs.core.count(c__4550__auto___41245);
var G__41249 = (0);
seq__40392_41231 = G__41246;
chunk__40393_41232 = G__41247;
count__40394_41233 = G__41248;
i__40395_41234 = G__41249;
continue;
} else {
var map__40402_41250 = cljs.core.first(seq__40392_41244__$1);
var map__40402_41251__$1 = (((((!((map__40402_41250 == null))))?(((((map__40402_41250.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40402_41250.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40402_41250):map__40402_41250);
var binding_41252 = map__40402_41251__$1;
var init_41253 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40402_41251__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_41252);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_41253,";");


var G__41254 = cljs.core.next(seq__40392_41244__$1);
var G__41255 = null;
var G__41256 = (0);
var G__41257 = (0);
seq__40392_41231 = G__41254;
chunk__40393_41232 = G__41255;
count__40394_41233 = G__41256;
i__40395_41234 = G__41257;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__40390_41229);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__40404){
var map__40405 = p__40404;
var map__40405__$1 = (((((!((map__40405 == null))))?(((((map__40405.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40405.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40405):map__40405);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40405__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40405__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40405__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4607__auto___41258 = cljs.core.count(exprs);
var i_41259 = (0);
while(true){
if((i_41259 < n__4607__auto___41258)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_41259) : temps.call(null,i_41259))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_41259) : exprs.call(null,i_41259)),";");

var G__41260 = (i_41259 + (1));
i_41259 = G__41260;
continue;
} else {
}
break;
}

var n__4607__auto___41261 = cljs.core.count(exprs);
var i_41262 = (0);
while(true){
if((i_41262 < n__4607__auto___41261)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_41262) : params.call(null,i_41262)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_41262) : temps.call(null,i_41262)),";");

var G__41263 = (i_41262 + (1));
i_41262 = G__41263;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__40407){
var map__40408 = p__40407;
var map__40408__$1 = (((((!((map__40408 == null))))?(((((map__40408.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40408.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40408):map__40408);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40408__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40408__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40408__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__40410_41264 = cljs.core.seq(bindings);
var chunk__40411_41265 = null;
var count__40412_41266 = (0);
var i__40413_41267 = (0);
while(true){
if((i__40413_41267 < count__40412_41266)){
var map__40418_41268 = chunk__40411_41265.cljs$core$IIndexed$_nth$arity$2(null,i__40413_41267);
var map__40418_41269__$1 = (((((!((map__40418_41268 == null))))?(((((map__40418_41268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40418_41268.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40418_41268):map__40418_41268);
var binding_41270 = map__40418_41269__$1;
var init_41271 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40418_41269__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_41270)," = ",init_41271,";");


var G__41272 = seq__40410_41264;
var G__41273 = chunk__40411_41265;
var G__41274 = count__40412_41266;
var G__41275 = (i__40413_41267 + (1));
seq__40410_41264 = G__41272;
chunk__40411_41265 = G__41273;
count__40412_41266 = G__41274;
i__40413_41267 = G__41275;
continue;
} else {
var temp__5735__auto___41276 = cljs.core.seq(seq__40410_41264);
if(temp__5735__auto___41276){
var seq__40410_41277__$1 = temp__5735__auto___41276;
if(cljs.core.chunked_seq_QMARK_(seq__40410_41277__$1)){
var c__4550__auto___41278 = cljs.core.chunk_first(seq__40410_41277__$1);
var G__41279 = cljs.core.chunk_rest(seq__40410_41277__$1);
var G__41280 = c__4550__auto___41278;
var G__41281 = cljs.core.count(c__4550__auto___41278);
var G__41282 = (0);
seq__40410_41264 = G__41279;
chunk__40411_41265 = G__41280;
count__40412_41266 = G__41281;
i__40413_41267 = G__41282;
continue;
} else {
var map__40423_41283 = cljs.core.first(seq__40410_41277__$1);
var map__40423_41284__$1 = (((((!((map__40423_41283 == null))))?(((((map__40423_41283.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40423_41283.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40423_41283):map__40423_41283);
var binding_41285 = map__40423_41284__$1;
var init_41286 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40423_41284__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_41285)," = ",init_41286,";");


var G__41287 = cljs.core.next(seq__40410_41277__$1);
var G__41288 = null;
var G__41289 = (0);
var G__41290 = (0);
seq__40410_41264 = G__41287;
chunk__40411_41265 = G__41288;
count__40412_41266 = G__41289;
i__40413_41267 = G__41290;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__40427){
var map__40428 = p__40427;
var map__40428__$1 = (((((!((map__40428 == null))))?(((((map__40428.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40428.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40428):map__40428);
var expr = map__40428__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40428__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40428__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40428__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4109__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4109__auto__)){
if(cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4109__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4109__auto__ = protocol;
if(cljs.core.truth_(and__4109__auto__)){
var and__4109__auto____$1 = tag;
if(cljs.core.truth_(and__4109__auto____$1)){
var or__4120__auto__ = (function (){var and__4109__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4109__auto____$2)){
var and__4109__auto____$3 = protocol;
if(cljs.core.truth_(and__4109__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4109__auto____$3;
}
} else {
return and__4109__auto____$2;
}
})();
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
var and__4109__auto____$2 = (function (){var or__4120__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4120__auto____$1)){
return or__4120__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4109__auto____$2)){
var or__4120__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4120__auto____$1){
return or__4120__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__40444 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__40444.cljs$core$IFn$_invoke$arity$1 ? fexpr__40444.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__40444.call(null,tag));
})())){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4109__auto____$2;
}
}
} else {
return and__4109__auto____$1;
}
} else {
return and__4109__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__40446 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__40446.cljs$core$IFn$_invoke$arity$1 ? fexpr__40446.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__40446.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4120__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4120__auto__){
return or__4120__auto__;
} else {
var or__4120__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4120__auto____$1){
return or__4120__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4120__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4120__auto__){
return or__4120__auto__;
} else {
var or__4120__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4120__auto____$1)){
return or__4120__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4120__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4120__auto__){
return or__4120__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__40430 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4109__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4109__auto__)){
return (arity > mfa);
} else {
return and__4109__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__40425_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__40425_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__40426_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__40426_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40430,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40430,(1),null);
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_41291 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_41291,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_41292 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_41292,args)),(((mfa_41292 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_41292,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4120__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
var or__4120__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4120__auto____$1)){
return or__4120__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4109__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4109__auto__)){
var G__40448 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__40447 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__40447.cljs$core$IFn$_invoke$arity$1 ? fexpr__40447.cljs$core$IFn$_invoke$arity$1(G__40448) : fexpr__40447.call(null,G__40448));
} else {
return and__4109__auto__;
}
})())){
var fprop_41293 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_41293," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_41293,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_41293," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_41293,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__40449){
var map__40450 = p__40449;
var map__40450__$1 = (((((!((map__40450 == null))))?(((((map__40450.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40450.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40450):map__40450);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40450__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40450__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40450__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__40452){
var map__40453 = p__40452;
var map__40453__$1 = (((((!((map__40453 == null))))?(((((map__40453.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40453.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40453):map__40453);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40453__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40453__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40453__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4120__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__40456 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__40456__$1 = (((((!((map__40456 == null))))?(((((map__40456.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40456.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40456):map__40456);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40456__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40456__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__40457 = options;
var map__40457__$1 = (((((!((map__40457 == null))))?(((((map__40457.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40457.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40457):map__40457);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40457__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40457__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__40458 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__40467 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__40467__$1 = (((((!((map__40467 == null))))?(((((map__40467.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40467.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40467):map__40467);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40467__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40467__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40458,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40458,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__40469_41294 = cljs.core.seq(libs_to_load);
var chunk__40470_41295 = null;
var count__40471_41296 = (0);
var i__40472_41297 = (0);
while(true){
if((i__40472_41297 < count__40471_41296)){
var lib_41298 = chunk__40470_41295.cljs$core$IIndexed$_nth$arity$2(null,i__40472_41297);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_41298)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4120__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_41298),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_41298),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4120__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_41298),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_41298),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_41298,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_41298),"');");
}

}
}
}


var G__41299 = seq__40469_41294;
var G__41300 = chunk__40470_41295;
var G__41301 = count__40471_41296;
var G__41302 = (i__40472_41297 + (1));
seq__40469_41294 = G__41299;
chunk__40470_41295 = G__41300;
count__40471_41296 = G__41301;
i__40472_41297 = G__41302;
continue;
} else {
var temp__5735__auto___41303 = cljs.core.seq(seq__40469_41294);
if(temp__5735__auto___41303){
var seq__40469_41304__$1 = temp__5735__auto___41303;
if(cljs.core.chunked_seq_QMARK_(seq__40469_41304__$1)){
var c__4550__auto___41305 = cljs.core.chunk_first(seq__40469_41304__$1);
var G__41306 = cljs.core.chunk_rest(seq__40469_41304__$1);
var G__41307 = c__4550__auto___41305;
var G__41308 = cljs.core.count(c__4550__auto___41305);
var G__41309 = (0);
seq__40469_41294 = G__41306;
chunk__40470_41295 = G__41307;
count__40471_41296 = G__41308;
i__40472_41297 = G__41309;
continue;
} else {
var lib_41310 = cljs.core.first(seq__40469_41304__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_41310)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4120__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_41310),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_41310),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4120__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_41310),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_41310),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_41310,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_41310),"');");
}

}
}
}


var G__41311 = cljs.core.next(seq__40469_41304__$1);
var G__41312 = null;
var G__41313 = (0);
var G__41314 = (0);
seq__40469_41294 = G__41311;
chunk__40470_41295 = G__41312;
count__40471_41296 = G__41313;
i__40472_41297 = G__41314;
continue;
}
} else {
}
}
break;
}

var seq__40483_41315 = cljs.core.seq(node_libs);
var chunk__40484_41316 = null;
var count__40485_41317 = (0);
var i__40486_41318 = (0);
while(true){
if((i__40486_41318 < count__40485_41317)){
var lib_41319 = chunk__40484_41316.cljs$core$IIndexed$_nth$arity$2(null,i__40486_41318);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_41319)," = require('",lib_41319,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__41320 = seq__40483_41315;
var G__41321 = chunk__40484_41316;
var G__41322 = count__40485_41317;
var G__41323 = (i__40486_41318 + (1));
seq__40483_41315 = G__41320;
chunk__40484_41316 = G__41321;
count__40485_41317 = G__41322;
i__40486_41318 = G__41323;
continue;
} else {
var temp__5735__auto___41324 = cljs.core.seq(seq__40483_41315);
if(temp__5735__auto___41324){
var seq__40483_41325__$1 = temp__5735__auto___41324;
if(cljs.core.chunked_seq_QMARK_(seq__40483_41325__$1)){
var c__4550__auto___41326 = cljs.core.chunk_first(seq__40483_41325__$1);
var G__41327 = cljs.core.chunk_rest(seq__40483_41325__$1);
var G__41328 = c__4550__auto___41326;
var G__41329 = cljs.core.count(c__4550__auto___41326);
var G__41330 = (0);
seq__40483_41315 = G__41327;
chunk__40484_41316 = G__41328;
count__40485_41317 = G__41329;
i__40486_41318 = G__41330;
continue;
} else {
var lib_41331 = cljs.core.first(seq__40483_41325__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_41331)," = require('",lib_41331,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__41332 = cljs.core.next(seq__40483_41325__$1);
var G__41333 = null;
var G__41334 = (0);
var G__41335 = (0);
seq__40483_41315 = G__41332;
chunk__40484_41316 = G__41333;
count__40485_41317 = G__41334;
i__40486_41318 = G__41335;
continue;
}
} else {
}
}
break;
}

var seq__40492_41336 = cljs.core.seq(global_exports_libs);
var chunk__40493_41337 = null;
var count__40494_41338 = (0);
var i__40495_41339 = (0);
while(true){
if((i__40495_41339 < count__40494_41338)){
var lib_41340 = chunk__40493_41337.cljs$core$IIndexed$_nth$arity$2(null,i__40495_41339);
var map__40500_41341 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_41340));
var map__40500_41342__$1 = (((((!((map__40500_41341 == null))))?(((((map__40500_41341.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40500_41341.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40500_41341):map__40500_41341);
var global_exports_41343 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40500_41342__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_41343,lib_41340);


var G__41344 = seq__40492_41336;
var G__41345 = chunk__40493_41337;
var G__41346 = count__40494_41338;
var G__41347 = (i__40495_41339 + (1));
seq__40492_41336 = G__41344;
chunk__40493_41337 = G__41345;
count__40494_41338 = G__41346;
i__40495_41339 = G__41347;
continue;
} else {
var temp__5735__auto___41348 = cljs.core.seq(seq__40492_41336);
if(temp__5735__auto___41348){
var seq__40492_41349__$1 = temp__5735__auto___41348;
if(cljs.core.chunked_seq_QMARK_(seq__40492_41349__$1)){
var c__4550__auto___41350 = cljs.core.chunk_first(seq__40492_41349__$1);
var G__41351 = cljs.core.chunk_rest(seq__40492_41349__$1);
var G__41352 = c__4550__auto___41350;
var G__41353 = cljs.core.count(c__4550__auto___41350);
var G__41354 = (0);
seq__40492_41336 = G__41351;
chunk__40493_41337 = G__41352;
count__40494_41338 = G__41353;
i__40495_41339 = G__41354;
continue;
} else {
var lib_41355 = cljs.core.first(seq__40492_41349__$1);
var map__40502_41356 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_41355));
var map__40502_41357__$1 = (((((!((map__40502_41356 == null))))?(((((map__40502_41356.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40502_41356.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40502_41356):map__40502_41356);
var global_exports_41358 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40502_41357__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_41358,lib_41355);


var G__41359 = cljs.core.next(seq__40492_41349__$1);
var G__41360 = null;
var G__41361 = (0);
var G__41362 = (0);
seq__40492_41336 = G__41359;
chunk__40493_41337 = G__41360;
count__40494_41338 = G__41361;
i__40495_41339 = G__41362;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__40512){
var map__40513 = p__40512;
var map__40513__$1 = (((((!((map__40513 == null))))?(((((map__40513.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40513.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40513):map__40513);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40513__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40513__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40513__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40513__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40513__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40513__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40513__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__40520){
var map__40521 = p__40520;
var map__40521__$1 = (((((!((map__40521 == null))))?(((((map__40521.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40521.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40521):map__40521);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40521__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40521__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40521__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40521__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40521__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40521__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40521__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__40541){
var map__40542 = p__40541;
var map__40542__$1 = (((((!((map__40542 == null))))?(((((map__40542.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40542.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40542):map__40542);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40542__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40542__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40542__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40542__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40542__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__40551_41363 = cljs.core.seq(protocols);
var chunk__40552_41364 = null;
var count__40553_41365 = (0);
var i__40554_41366 = (0);
while(true){
if((i__40554_41366 < count__40553_41365)){
var protocol_41367 = chunk__40552_41364.cljs$core$IIndexed$_nth$arity$2(null,i__40554_41366);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_41367)),"}");


var G__41368 = seq__40551_41363;
var G__41369 = chunk__40552_41364;
var G__41370 = count__40553_41365;
var G__41371 = (i__40554_41366 + (1));
seq__40551_41363 = G__41368;
chunk__40552_41364 = G__41369;
count__40553_41365 = G__41370;
i__40554_41366 = G__41371;
continue;
} else {
var temp__5735__auto___41372 = cljs.core.seq(seq__40551_41363);
if(temp__5735__auto___41372){
var seq__40551_41373__$1 = temp__5735__auto___41372;
if(cljs.core.chunked_seq_QMARK_(seq__40551_41373__$1)){
var c__4550__auto___41374 = cljs.core.chunk_first(seq__40551_41373__$1);
var G__41375 = cljs.core.chunk_rest(seq__40551_41373__$1);
var G__41376 = c__4550__auto___41374;
var G__41377 = cljs.core.count(c__4550__auto___41374);
var G__41378 = (0);
seq__40551_41363 = G__41375;
chunk__40552_41364 = G__41376;
count__40553_41365 = G__41377;
i__40554_41366 = G__41378;
continue;
} else {
var protocol_41379 = cljs.core.first(seq__40551_41373__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_41379)),"}");


var G__41380 = cljs.core.next(seq__40551_41373__$1);
var G__41381 = null;
var G__41382 = (0);
var G__41383 = (0);
seq__40551_41363 = G__41380;
chunk__40552_41364 = G__41381;
count__40553_41365 = G__41382;
i__40554_41366 = G__41383;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__40555_41384 = cljs.core.seq(fields__$1);
var chunk__40556_41385 = null;
var count__40557_41386 = (0);
var i__40558_41387 = (0);
while(true){
if((i__40558_41387 < count__40557_41386)){
var fld_41388 = chunk__40556_41385.cljs$core$IIndexed$_nth$arity$2(null,i__40558_41387);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_41388," = ",fld_41388,";");


var G__41389 = seq__40555_41384;
var G__41390 = chunk__40556_41385;
var G__41391 = count__40557_41386;
var G__41392 = (i__40558_41387 + (1));
seq__40555_41384 = G__41389;
chunk__40556_41385 = G__41390;
count__40557_41386 = G__41391;
i__40558_41387 = G__41392;
continue;
} else {
var temp__5735__auto___41393 = cljs.core.seq(seq__40555_41384);
if(temp__5735__auto___41393){
var seq__40555_41394__$1 = temp__5735__auto___41393;
if(cljs.core.chunked_seq_QMARK_(seq__40555_41394__$1)){
var c__4550__auto___41395 = cljs.core.chunk_first(seq__40555_41394__$1);
var G__41396 = cljs.core.chunk_rest(seq__40555_41394__$1);
var G__41397 = c__4550__auto___41395;
var G__41398 = cljs.core.count(c__4550__auto___41395);
var G__41399 = (0);
seq__40555_41384 = G__41396;
chunk__40556_41385 = G__41397;
count__40557_41386 = G__41398;
i__40558_41387 = G__41399;
continue;
} else {
var fld_41400 = cljs.core.first(seq__40555_41394__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_41400," = ",fld_41400,";");


var G__41401 = cljs.core.next(seq__40555_41394__$1);
var G__41402 = null;
var G__41403 = (0);
var G__41404 = (0);
seq__40555_41384 = G__41401;
chunk__40556_41385 = G__41402;
count__40557_41386 = G__41403;
i__40558_41387 = G__41404;
continue;
}
} else {
}
}
break;
}

var seq__40559_41405 = cljs.core.seq(pmasks);
var chunk__40560_41406 = null;
var count__40561_41407 = (0);
var i__40562_41408 = (0);
while(true){
if((i__40562_41408 < count__40561_41407)){
var vec__40569_41409 = chunk__40560_41406.cljs$core$IIndexed$_nth$arity$2(null,i__40562_41408);
var pno_41410 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40569_41409,(0),null);
var pmask_41411 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40569_41409,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_41410,"$ = ",pmask_41411,";");


var G__41412 = seq__40559_41405;
var G__41413 = chunk__40560_41406;
var G__41414 = count__40561_41407;
var G__41415 = (i__40562_41408 + (1));
seq__40559_41405 = G__41412;
chunk__40560_41406 = G__41413;
count__40561_41407 = G__41414;
i__40562_41408 = G__41415;
continue;
} else {
var temp__5735__auto___41416 = cljs.core.seq(seq__40559_41405);
if(temp__5735__auto___41416){
var seq__40559_41417__$1 = temp__5735__auto___41416;
if(cljs.core.chunked_seq_QMARK_(seq__40559_41417__$1)){
var c__4550__auto___41418 = cljs.core.chunk_first(seq__40559_41417__$1);
var G__41419 = cljs.core.chunk_rest(seq__40559_41417__$1);
var G__41420 = c__4550__auto___41418;
var G__41421 = cljs.core.count(c__4550__auto___41418);
var G__41422 = (0);
seq__40559_41405 = G__41419;
chunk__40560_41406 = G__41420;
count__40561_41407 = G__41421;
i__40562_41408 = G__41422;
continue;
} else {
var vec__40572_41423 = cljs.core.first(seq__40559_41417__$1);
var pno_41424 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40572_41423,(0),null);
var pmask_41425 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40572_41423,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_41424,"$ = ",pmask_41425,";");


var G__41426 = cljs.core.next(seq__40559_41417__$1);
var G__41427 = null;
var G__41428 = (0);
var G__41429 = (0);
seq__40559_41405 = G__41426;
chunk__40560_41406 = G__41427;
count__40561_41407 = G__41428;
i__40562_41408 = G__41429;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__40575){
var map__40576 = p__40575;
var map__40576__$1 = (((((!((map__40576 == null))))?(((((map__40576.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40576.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40576):map__40576);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40576__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40576__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40576__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40576__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40576__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__40578_41430 = cljs.core.seq(protocols);
var chunk__40579_41431 = null;
var count__40580_41432 = (0);
var i__40581_41433 = (0);
while(true){
if((i__40581_41433 < count__40580_41432)){
var protocol_41434 = chunk__40579_41431.cljs$core$IIndexed$_nth$arity$2(null,i__40581_41433);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_41434)),"}");


var G__41435 = seq__40578_41430;
var G__41436 = chunk__40579_41431;
var G__41437 = count__40580_41432;
var G__41438 = (i__40581_41433 + (1));
seq__40578_41430 = G__41435;
chunk__40579_41431 = G__41436;
count__40580_41432 = G__41437;
i__40581_41433 = G__41438;
continue;
} else {
var temp__5735__auto___41439 = cljs.core.seq(seq__40578_41430);
if(temp__5735__auto___41439){
var seq__40578_41440__$1 = temp__5735__auto___41439;
if(cljs.core.chunked_seq_QMARK_(seq__40578_41440__$1)){
var c__4550__auto___41441 = cljs.core.chunk_first(seq__40578_41440__$1);
var G__41442 = cljs.core.chunk_rest(seq__40578_41440__$1);
var G__41443 = c__4550__auto___41441;
var G__41444 = cljs.core.count(c__4550__auto___41441);
var G__41445 = (0);
seq__40578_41430 = G__41442;
chunk__40579_41431 = G__41443;
count__40580_41432 = G__41444;
i__40581_41433 = G__41445;
continue;
} else {
var protocol_41446 = cljs.core.first(seq__40578_41440__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_41446)),"}");


var G__41447 = cljs.core.next(seq__40578_41440__$1);
var G__41448 = null;
var G__41449 = (0);
var G__41450 = (0);
seq__40578_41430 = G__41447;
chunk__40579_41431 = G__41448;
count__40580_41432 = G__41449;
i__40581_41433 = G__41450;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__40594_41451 = cljs.core.seq(fields__$1);
var chunk__40595_41452 = null;
var count__40596_41453 = (0);
var i__40597_41454 = (0);
while(true){
if((i__40597_41454 < count__40596_41453)){
var fld_41455 = chunk__40595_41452.cljs$core$IIndexed$_nth$arity$2(null,i__40597_41454);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_41455," = ",fld_41455,";");


var G__41456 = seq__40594_41451;
var G__41457 = chunk__40595_41452;
var G__41458 = count__40596_41453;
var G__41459 = (i__40597_41454 + (1));
seq__40594_41451 = G__41456;
chunk__40595_41452 = G__41457;
count__40596_41453 = G__41458;
i__40597_41454 = G__41459;
continue;
} else {
var temp__5735__auto___41460 = cljs.core.seq(seq__40594_41451);
if(temp__5735__auto___41460){
var seq__40594_41461__$1 = temp__5735__auto___41460;
if(cljs.core.chunked_seq_QMARK_(seq__40594_41461__$1)){
var c__4550__auto___41462 = cljs.core.chunk_first(seq__40594_41461__$1);
var G__41463 = cljs.core.chunk_rest(seq__40594_41461__$1);
var G__41464 = c__4550__auto___41462;
var G__41465 = cljs.core.count(c__4550__auto___41462);
var G__41466 = (0);
seq__40594_41451 = G__41463;
chunk__40595_41452 = G__41464;
count__40596_41453 = G__41465;
i__40597_41454 = G__41466;
continue;
} else {
var fld_41467 = cljs.core.first(seq__40594_41461__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_41467," = ",fld_41467,";");


var G__41468 = cljs.core.next(seq__40594_41461__$1);
var G__41469 = null;
var G__41470 = (0);
var G__41471 = (0);
seq__40594_41451 = G__41468;
chunk__40595_41452 = G__41469;
count__40596_41453 = G__41470;
i__40597_41454 = G__41471;
continue;
}
} else {
}
}
break;
}

var seq__40607_41472 = cljs.core.seq(pmasks);
var chunk__40608_41473 = null;
var count__40609_41474 = (0);
var i__40610_41475 = (0);
while(true){
if((i__40610_41475 < count__40609_41474)){
var vec__40625_41476 = chunk__40608_41473.cljs$core$IIndexed$_nth$arity$2(null,i__40610_41475);
var pno_41477 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40625_41476,(0),null);
var pmask_41478 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40625_41476,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_41477,"$ = ",pmask_41478,";");


var G__41479 = seq__40607_41472;
var G__41480 = chunk__40608_41473;
var G__41481 = count__40609_41474;
var G__41482 = (i__40610_41475 + (1));
seq__40607_41472 = G__41479;
chunk__40608_41473 = G__41480;
count__40609_41474 = G__41481;
i__40610_41475 = G__41482;
continue;
} else {
var temp__5735__auto___41483 = cljs.core.seq(seq__40607_41472);
if(temp__5735__auto___41483){
var seq__40607_41484__$1 = temp__5735__auto___41483;
if(cljs.core.chunked_seq_QMARK_(seq__40607_41484__$1)){
var c__4550__auto___41485 = cljs.core.chunk_first(seq__40607_41484__$1);
var G__41486 = cljs.core.chunk_rest(seq__40607_41484__$1);
var G__41487 = c__4550__auto___41485;
var G__41488 = cljs.core.count(c__4550__auto___41485);
var G__41489 = (0);
seq__40607_41472 = G__41486;
chunk__40608_41473 = G__41487;
count__40609_41474 = G__41488;
i__40610_41475 = G__41489;
continue;
} else {
var vec__40628_41490 = cljs.core.first(seq__40607_41484__$1);
var pno_41491 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40628_41490,(0),null);
var pmask_41492 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40628_41490,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_41491,"$ = ",pmask_41492,";");


var G__41493 = cljs.core.next(seq__40607_41484__$1);
var G__41494 = null;
var G__41495 = (0);
var G__41496 = (0);
seq__40607_41472 = G__41493;
chunk__40608_41473 = G__41494;
count__40609_41474 = G__41495;
i__40610_41475 = G__41496;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__40631){
var map__40632 = p__40631;
var map__40632__$1 = (((((!((map__40632 == null))))?(((((map__40632.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40632.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40632):map__40632);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40632__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40632__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40632__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40632__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40632__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__40636){
var map__40637 = p__40636;
var map__40637__$1 = (((((!((map__40637 == null))))?(((((map__40637.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40637.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40637):map__40637);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40637__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40637__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40637__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40637__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40637__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4109__auto__ = code;
if(cljs.core.truth_(and__4109__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4109__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__39876__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__39876__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__40668 = cljs.core.seq(table);
var chunk__40669 = null;
var count__40670 = (0);
var i__40671 = (0);
while(true){
if((i__40671 < count__40670)){
var vec__40680 = chunk__40669.cljs$core$IIndexed$_nth$arity$2(null,i__40671);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40680,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40680,(1),null);
var ns_41497 = cljs.core.namespace(sym);
var name_41498 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__41499 = seq__40668;
var G__41500 = chunk__40669;
var G__41501 = count__40670;
var G__41502 = (i__40671 + (1));
seq__40668 = G__41499;
chunk__40669 = G__41500;
count__40670 = G__41501;
i__40671 = G__41502;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__40668);
if(temp__5735__auto__){
var seq__40668__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40668__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__40668__$1);
var G__41503 = cljs.core.chunk_rest(seq__40668__$1);
var G__41504 = c__4550__auto__;
var G__41505 = cljs.core.count(c__4550__auto__);
var G__41506 = (0);
seq__40668 = G__41503;
chunk__40669 = G__41504;
count__40670 = G__41505;
i__40671 = G__41506;
continue;
} else {
var vec__40683 = cljs.core.first(seq__40668__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40683,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40683,(1),null);
var ns_41507 = cljs.core.namespace(sym);
var name_41508 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__41509 = cljs.core.next(seq__40668__$1);
var G__41510 = null;
var G__41511 = (0);
var G__41512 = (0);
seq__40668 = G__41509;
chunk__40669 = G__41510;
count__40670 = G__41511;
i__40671 = G__41512;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__40687 = arguments.length;
switch (G__40687) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_41514 = cljs.core.first(ks);
var vec__40696_41515 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_41514);
var top_41516 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40696_41515,(0),null);
var prefix_SINGLEQUOTE__41517 = vec__40696_41515;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_41514)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__41517) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_41516)) || (cljs.core.contains_QMARK_(known_externs,top_41516)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__41517)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_41516);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__41517)),";");
}
} else {
}

var m_41518 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_41514);
if(cljs.core.empty_QMARK_(m_41518)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__41517,m_41518,top_level,known_externs);
}

var G__41519 = cljs.core.next(ks);
ks = G__41519;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=cljs.compiler.js.map
