goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__28504 = arguments.length;
switch (G__28504) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28506 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28506 = (function (f,blockable,meta28507){
this.f = f;
this.blockable = blockable;
this.meta28507 = meta28507;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28506.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28508,meta28507__$1){
var self__ = this;
var _28508__$1 = this;
return (new cljs.core.async.t_cljs$core$async28506(self__.f,self__.blockable,meta28507__$1));
}));

(cljs.core.async.t_cljs$core$async28506.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28508){
var self__ = this;
var _28508__$1 = this;
return self__.meta28507;
}));

(cljs.core.async.t_cljs$core$async28506.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28506.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28506.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async28506.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async28506.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta28507","meta28507",-1284700049,null)], null);
}));

(cljs.core.async.t_cljs$core$async28506.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28506.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28506");

(cljs.core.async.t_cljs$core$async28506.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async28506");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28506.
 */
cljs.core.async.__GT_t_cljs$core$async28506 = (function cljs$core$async$__GT_t_cljs$core$async28506(f__$1,blockable__$1,meta28507){
return (new cljs.core.async.t_cljs$core$async28506(f__$1,blockable__$1,meta28507));
});

}

return (new cljs.core.async.t_cljs$core$async28506(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__28517 = arguments.length;
switch (G__28517) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__28525 = arguments.length;
switch (G__28525) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__28529 = arguments.length;
switch (G__28529) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_30070 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30070) : fn1.call(null,val_30070));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30070) : fn1.call(null,val_30070));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__28536 = arguments.length;
switch (G__28536) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___30079 = n;
var x_30080 = (0);
while(true){
if((x_30080 < n__4607__auto___30079)){
(a[x_30080] = x_30080);

var G__30081 = (x_30080 + (1));
x_30080 = G__30081;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28539 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28539 = (function (flag,meta28540){
this.flag = flag;
this.meta28540 = meta28540;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28539.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28541,meta28540__$1){
var self__ = this;
var _28541__$1 = this;
return (new cljs.core.async.t_cljs$core$async28539(self__.flag,meta28540__$1));
}));

(cljs.core.async.t_cljs$core$async28539.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28541){
var self__ = this;
var _28541__$1 = this;
return self__.meta28540;
}));

(cljs.core.async.t_cljs$core$async28539.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28539.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28539.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28539.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async28539.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta28540","meta28540",1473572997,null)], null);
}));

(cljs.core.async.t_cljs$core$async28539.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28539.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28539");

(cljs.core.async.t_cljs$core$async28539.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async28539");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28539.
 */
cljs.core.async.__GT_t_cljs$core$async28539 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async28539(flag__$1,meta28540){
return (new cljs.core.async.t_cljs$core$async28539(flag__$1,meta28540));
});

}

return (new cljs.core.async.t_cljs$core$async28539(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28544 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28544 = (function (flag,cb,meta28545){
this.flag = flag;
this.cb = cb;
this.meta28545 = meta28545;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28544.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28546,meta28545__$1){
var self__ = this;
var _28546__$1 = this;
return (new cljs.core.async.t_cljs$core$async28544(self__.flag,self__.cb,meta28545__$1));
}));

(cljs.core.async.t_cljs$core$async28544.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28546){
var self__ = this;
var _28546__$1 = this;
return self__.meta28545;
}));

(cljs.core.async.t_cljs$core$async28544.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28544.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28544.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28544.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async28544.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta28545","meta28545",352165987,null)], null);
}));

(cljs.core.async.t_cljs$core$async28544.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28544.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28544");

(cljs.core.async.t_cljs$core$async28544.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async28544");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28544.
 */
cljs.core.async.__GT_t_cljs$core$async28544 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async28544(flag__$1,cb__$1,meta28545){
return (new cljs.core.async.t_cljs$core$async28544(flag__$1,cb__$1,meta28545));
});

}

return (new cljs.core.async.t_cljs$core$async28544(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28551_SHARP_){
var G__28554 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28551_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28554) : fret.call(null,G__28554));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28552_SHARP_){
var G__28555 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28552_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28555) : fret.call(null,G__28555));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4120__auto__ = wport;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30094 = (i + (1));
i = G__30094;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4120__auto__ = ret;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4109__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4109__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4109__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___30095 = arguments.length;
var i__4731__auto___30096 = (0);
while(true){
if((i__4731__auto___30096 < len__4730__auto___30095)){
args__4736__auto__.push((arguments[i__4731__auto___30096]));

var G__30100 = (i__4731__auto___30096 + (1));
i__4731__auto___30096 = G__30100;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__28559){
var map__28560 = p__28559;
var map__28560__$1 = (((((!((map__28560 == null))))?(((((map__28560.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28560.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28560):map__28560);
var opts = map__28560__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq28556){
var G__28557 = cljs.core.first(seq28556);
var seq28556__$1 = cljs.core.next(seq28556);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28557,seq28556__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__28566 = arguments.length;
switch (G__28566) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__28446__auto___30106 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_28599){
var state_val_28600 = (state_28599[(1)]);
if((state_val_28600 === (7))){
var inst_28592 = (state_28599[(2)]);
var state_28599__$1 = state_28599;
var statearr_28601_30108 = state_28599__$1;
(statearr_28601_30108[(2)] = inst_28592);

(statearr_28601_30108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28600 === (1))){
var state_28599__$1 = state_28599;
var statearr_28602_30109 = state_28599__$1;
(statearr_28602_30109[(2)] = null);

(statearr_28602_30109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28600 === (4))){
var inst_28574 = (state_28599[(7)]);
var inst_28574__$1 = (state_28599[(2)]);
var inst_28575 = (inst_28574__$1 == null);
var state_28599__$1 = (function (){var statearr_28603 = state_28599;
(statearr_28603[(7)] = inst_28574__$1);

return statearr_28603;
})();
if(cljs.core.truth_(inst_28575)){
var statearr_28604_30110 = state_28599__$1;
(statearr_28604_30110[(1)] = (5));

} else {
var statearr_28605_30111 = state_28599__$1;
(statearr_28605_30111[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28600 === (13))){
var state_28599__$1 = state_28599;
var statearr_28609_30115 = state_28599__$1;
(statearr_28609_30115[(2)] = null);

(statearr_28609_30115[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28600 === (6))){
var inst_28574 = (state_28599[(7)]);
var state_28599__$1 = state_28599;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28599__$1,(11),to,inst_28574);
} else {
if((state_val_28600 === (3))){
var inst_28597 = (state_28599[(2)]);
var state_28599__$1 = state_28599;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28599__$1,inst_28597);
} else {
if((state_val_28600 === (12))){
var state_28599__$1 = state_28599;
var statearr_28610_30116 = state_28599__$1;
(statearr_28610_30116[(2)] = null);

(statearr_28610_30116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28600 === (2))){
var state_28599__$1 = state_28599;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28599__$1,(4),from);
} else {
if((state_val_28600 === (11))){
var inst_28585 = (state_28599[(2)]);
var state_28599__$1 = state_28599;
if(cljs.core.truth_(inst_28585)){
var statearr_28611_30118 = state_28599__$1;
(statearr_28611_30118[(1)] = (12));

} else {
var statearr_28612_30121 = state_28599__$1;
(statearr_28612_30121[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28600 === (9))){
var state_28599__$1 = state_28599;
var statearr_28614_30122 = state_28599__$1;
(statearr_28614_30122[(2)] = null);

(statearr_28614_30122[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28600 === (5))){
var state_28599__$1 = state_28599;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28615_30124 = state_28599__$1;
(statearr_28615_30124[(1)] = (8));

} else {
var statearr_28616_30125 = state_28599__$1;
(statearr_28616_30125[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28600 === (14))){
var inst_28590 = (state_28599[(2)]);
var state_28599__$1 = state_28599;
var statearr_28617_30126 = state_28599__$1;
(statearr_28617_30126[(2)] = inst_28590);

(statearr_28617_30126[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28600 === (10))){
var inst_28582 = (state_28599[(2)]);
var state_28599__$1 = state_28599;
var statearr_28618_30127 = state_28599__$1;
(statearr_28618_30127[(2)] = inst_28582);

(statearr_28618_30127[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28600 === (8))){
var inst_28579 = cljs.core.async.close_BANG_(to);
var state_28599__$1 = state_28599;
var statearr_28619_30128 = state_28599__$1;
(statearr_28619_30128[(2)] = inst_28579);

(statearr_28619_30128[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28411__auto__ = null;
var cljs$core$async$state_machine__28411__auto____0 = (function (){
var statearr_28620 = [null,null,null,null,null,null,null,null];
(statearr_28620[(0)] = cljs$core$async$state_machine__28411__auto__);

(statearr_28620[(1)] = (1));

return statearr_28620;
});
var cljs$core$async$state_machine__28411__auto____1 = (function (state_28599){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_28599);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e28621){var ex__28414__auto__ = e28621;
var statearr_28622_30133 = state_28599;
(statearr_28622_30133[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_28599[(4)]))){
var statearr_28623_30134 = state_28599;
(statearr_28623_30134[(1)] = cljs.core.first((state_28599[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30135 = state_28599;
state_28599 = G__30135;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$state_machine__28411__auto__ = function(state_28599){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28411__auto____1.call(this,state_28599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28411__auto____0;
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28411__auto____1;
return cljs$core$async$state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_28624 = f__28447__auto__();
(statearr_28624[(6)] = c__28446__auto___30106);

return statearr_28624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__28625){
var vec__28626 = p__28625;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28626,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28626,(1),null);
var job = vec__28626;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__28446__auto___30140 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_28635){
var state_val_28636 = (state_28635[(1)]);
if((state_val_28636 === (1))){
var state_28635__$1 = state_28635;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28635__$1,(2),res,v);
} else {
if((state_val_28636 === (2))){
var inst_28632 = (state_28635[(2)]);
var inst_28633 = cljs.core.async.close_BANG_(res);
var state_28635__$1 = (function (){var statearr_28638 = state_28635;
(statearr_28638[(7)] = inst_28632);

return statearr_28638;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28635__$1,inst_28633);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____0 = (function (){
var statearr_28639 = [null,null,null,null,null,null,null,null];
(statearr_28639[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__);

(statearr_28639[(1)] = (1));

return statearr_28639;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____1 = (function (state_28635){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_28635);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e28641){var ex__28414__auto__ = e28641;
var statearr_28642_30142 = state_28635;
(statearr_28642_30142[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_28635[(4)]))){
var statearr_28643_30143 = state_28635;
(statearr_28643_30143[(1)] = cljs.core.first((state_28635[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30144 = state_28635;
state_28635 = G__30144;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__ = function(state_28635){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____1.call(this,state_28635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_28644 = f__28447__auto__();
(statearr_28644[(6)] = c__28446__auto___30140);

return statearr_28644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__28645){
var vec__28646 = p__28645;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28646,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28646,(1),null);
var job = vec__28646;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4607__auto___30148 = n;
var __30149 = (0);
while(true){
if((__30149 < n__4607__auto___30148)){
var G__28649_30150 = type;
var G__28649_30151__$1 = (((G__28649_30150 instanceof cljs.core.Keyword))?G__28649_30150.fqn:null);
switch (G__28649_30151__$1) {
case "compute":
var c__28446__auto___30153 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30149,c__28446__auto___30153,G__28649_30150,G__28649_30151__$1,n__4607__auto___30148,jobs,results,process,async){
return (function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = ((function (__30149,c__28446__auto___30153,G__28649_30150,G__28649_30151__$1,n__4607__auto___30148,jobs,results,process,async){
return (function (state_28662){
var state_val_28663 = (state_28662[(1)]);
if((state_val_28663 === (1))){
var state_28662__$1 = state_28662;
var statearr_28665_30154 = state_28662__$1;
(statearr_28665_30154[(2)] = null);

(statearr_28665_30154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28663 === (2))){
var state_28662__$1 = state_28662;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28662__$1,(4),jobs);
} else {
if((state_val_28663 === (3))){
var inst_28660 = (state_28662[(2)]);
var state_28662__$1 = state_28662;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28662__$1,inst_28660);
} else {
if((state_val_28663 === (4))){
var inst_28652 = (state_28662[(2)]);
var inst_28653 = process(inst_28652);
var state_28662__$1 = state_28662;
if(cljs.core.truth_(inst_28653)){
var statearr_28668_30156 = state_28662__$1;
(statearr_28668_30156[(1)] = (5));

} else {
var statearr_28669_30157 = state_28662__$1;
(statearr_28669_30157[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28663 === (5))){
var state_28662__$1 = state_28662;
var statearr_28670_30158 = state_28662__$1;
(statearr_28670_30158[(2)] = null);

(statearr_28670_30158[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28663 === (6))){
var state_28662__$1 = state_28662;
var statearr_28674_30161 = state_28662__$1;
(statearr_28674_30161[(2)] = null);

(statearr_28674_30161[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28663 === (7))){
var inst_28658 = (state_28662[(2)]);
var state_28662__$1 = state_28662;
var statearr_28675_30162 = state_28662__$1;
(statearr_28675_30162[(2)] = inst_28658);

(statearr_28675_30162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30149,c__28446__auto___30153,G__28649_30150,G__28649_30151__$1,n__4607__auto___30148,jobs,results,process,async))
;
return ((function (__30149,switch__28410__auto__,c__28446__auto___30153,G__28649_30150,G__28649_30151__$1,n__4607__auto___30148,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____0 = (function (){
var statearr_28677 = [null,null,null,null,null,null,null];
(statearr_28677[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__);

(statearr_28677[(1)] = (1));

return statearr_28677;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____1 = (function (state_28662){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_28662);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e28679){var ex__28414__auto__ = e28679;
var statearr_28680_30166 = state_28662;
(statearr_28680_30166[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_28662[(4)]))){
var statearr_28681_30169 = state_28662;
(statearr_28681_30169[(1)] = cljs.core.first((state_28662[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30175 = state_28662;
state_28662 = G__30175;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__ = function(state_28662){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____1.call(this,state_28662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__;
})()
;})(__30149,switch__28410__auto__,c__28446__auto___30153,G__28649_30150,G__28649_30151__$1,n__4607__auto___30148,jobs,results,process,async))
})();
var state__28448__auto__ = (function (){var statearr_28683 = f__28447__auto__();
(statearr_28683[(6)] = c__28446__auto___30153);

return statearr_28683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
});})(__30149,c__28446__auto___30153,G__28649_30150,G__28649_30151__$1,n__4607__auto___30148,jobs,results,process,async))
);


break;
case "async":
var c__28446__auto___30185 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30149,c__28446__auto___30185,G__28649_30150,G__28649_30151__$1,n__4607__auto___30148,jobs,results,process,async){
return (function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = ((function (__30149,c__28446__auto___30185,G__28649_30150,G__28649_30151__$1,n__4607__auto___30148,jobs,results,process,async){
return (function (state_28696){
var state_val_28697 = (state_28696[(1)]);
if((state_val_28697 === (1))){
var state_28696__$1 = state_28696;
var statearr_28698_30187 = state_28696__$1;
(statearr_28698_30187[(2)] = null);

(statearr_28698_30187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28697 === (2))){
var state_28696__$1 = state_28696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28696__$1,(4),jobs);
} else {
if((state_val_28697 === (3))){
var inst_28694 = (state_28696[(2)]);
var state_28696__$1 = state_28696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28696__$1,inst_28694);
} else {
if((state_val_28697 === (4))){
var inst_28686 = (state_28696[(2)]);
var inst_28687 = async(inst_28686);
var state_28696__$1 = state_28696;
if(cljs.core.truth_(inst_28687)){
var statearr_28701_30188 = state_28696__$1;
(statearr_28701_30188[(1)] = (5));

} else {
var statearr_28702_30190 = state_28696__$1;
(statearr_28702_30190[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28697 === (5))){
var state_28696__$1 = state_28696;
var statearr_28705_30193 = state_28696__$1;
(statearr_28705_30193[(2)] = null);

(statearr_28705_30193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28697 === (6))){
var state_28696__$1 = state_28696;
var statearr_28707_30194 = state_28696__$1;
(statearr_28707_30194[(2)] = null);

(statearr_28707_30194[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28697 === (7))){
var inst_28692 = (state_28696[(2)]);
var state_28696__$1 = state_28696;
var statearr_28708_30197 = state_28696__$1;
(statearr_28708_30197[(2)] = inst_28692);

(statearr_28708_30197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30149,c__28446__auto___30185,G__28649_30150,G__28649_30151__$1,n__4607__auto___30148,jobs,results,process,async))
;
return ((function (__30149,switch__28410__auto__,c__28446__auto___30185,G__28649_30150,G__28649_30151__$1,n__4607__auto___30148,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____0 = (function (){
var statearr_28709 = [null,null,null,null,null,null,null];
(statearr_28709[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__);

(statearr_28709[(1)] = (1));

return statearr_28709;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____1 = (function (state_28696){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_28696);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e28713){var ex__28414__auto__ = e28713;
var statearr_28714_30201 = state_28696;
(statearr_28714_30201[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_28696[(4)]))){
var statearr_28715_30203 = state_28696;
(statearr_28715_30203[(1)] = cljs.core.first((state_28696[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30205 = state_28696;
state_28696 = G__30205;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__ = function(state_28696){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____1.call(this,state_28696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__;
})()
;})(__30149,switch__28410__auto__,c__28446__auto___30185,G__28649_30150,G__28649_30151__$1,n__4607__auto___30148,jobs,results,process,async))
})();
var state__28448__auto__ = (function (){var statearr_28716 = f__28447__auto__();
(statearr_28716[(6)] = c__28446__auto___30185);

return statearr_28716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
});})(__30149,c__28446__auto___30185,G__28649_30150,G__28649_30151__$1,n__4607__auto___30148,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28649_30151__$1)].join('')));

}

var G__30208 = (__30149 + (1));
__30149 = G__30208;
continue;
} else {
}
break;
}

var c__28446__auto___30209 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_28743){
var state_val_28744 = (state_28743[(1)]);
if((state_val_28744 === (7))){
var inst_28737 = (state_28743[(2)]);
var state_28743__$1 = state_28743;
var statearr_28746_30211 = state_28743__$1;
(statearr_28746_30211[(2)] = inst_28737);

(statearr_28746_30211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28744 === (1))){
var state_28743__$1 = state_28743;
var statearr_28747_30213 = state_28743__$1;
(statearr_28747_30213[(2)] = null);

(statearr_28747_30213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28744 === (4))){
var inst_28722 = (state_28743[(7)]);
var inst_28722__$1 = (state_28743[(2)]);
var inst_28723 = (inst_28722__$1 == null);
var state_28743__$1 = (function (){var statearr_28748 = state_28743;
(statearr_28748[(7)] = inst_28722__$1);

return statearr_28748;
})();
if(cljs.core.truth_(inst_28723)){
var statearr_28749_30216 = state_28743__$1;
(statearr_28749_30216[(1)] = (5));

} else {
var statearr_28750_30217 = state_28743__$1;
(statearr_28750_30217[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28744 === (6))){
var inst_28722 = (state_28743[(7)]);
var inst_28727 = (state_28743[(8)]);
var inst_28727__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_28728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28729 = [inst_28722,inst_28727__$1];
var inst_28730 = (new cljs.core.PersistentVector(null,2,(5),inst_28728,inst_28729,null));
var state_28743__$1 = (function (){var statearr_28751 = state_28743;
(statearr_28751[(8)] = inst_28727__$1);

return statearr_28751;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28743__$1,(8),jobs,inst_28730);
} else {
if((state_val_28744 === (3))){
var inst_28739 = (state_28743[(2)]);
var state_28743__$1 = state_28743;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28743__$1,inst_28739);
} else {
if((state_val_28744 === (2))){
var state_28743__$1 = state_28743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28743__$1,(4),from);
} else {
if((state_val_28744 === (9))){
var inst_28734 = (state_28743[(2)]);
var state_28743__$1 = (function (){var statearr_28752 = state_28743;
(statearr_28752[(9)] = inst_28734);

return statearr_28752;
})();
var statearr_28753_30222 = state_28743__$1;
(statearr_28753_30222[(2)] = null);

(statearr_28753_30222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28744 === (5))){
var inst_28725 = cljs.core.async.close_BANG_(jobs);
var state_28743__$1 = state_28743;
var statearr_28754_30223 = state_28743__$1;
(statearr_28754_30223[(2)] = inst_28725);

(statearr_28754_30223[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28744 === (8))){
var inst_28727 = (state_28743[(8)]);
var inst_28732 = (state_28743[(2)]);
var state_28743__$1 = (function (){var statearr_28755 = state_28743;
(statearr_28755[(10)] = inst_28732);

return statearr_28755;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28743__$1,(9),results,inst_28727);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____0 = (function (){
var statearr_28756 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28756[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__);

(statearr_28756[(1)] = (1));

return statearr_28756;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____1 = (function (state_28743){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_28743);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e28757){var ex__28414__auto__ = e28757;
var statearr_28758_30224 = state_28743;
(statearr_28758_30224[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_28743[(4)]))){
var statearr_28759_30225 = state_28743;
(statearr_28759_30225[(1)] = cljs.core.first((state_28743[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30226 = state_28743;
state_28743 = G__30226;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__ = function(state_28743){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____1.call(this,state_28743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_28760 = f__28447__auto__();
(statearr_28760[(6)] = c__28446__auto___30209);

return statearr_28760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


var c__28446__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_28801){
var state_val_28802 = (state_28801[(1)]);
if((state_val_28802 === (7))){
var inst_28797 = (state_28801[(2)]);
var state_28801__$1 = state_28801;
var statearr_28803_30227 = state_28801__$1;
(statearr_28803_30227[(2)] = inst_28797);

(statearr_28803_30227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28802 === (20))){
var state_28801__$1 = state_28801;
var statearr_28804_30228 = state_28801__$1;
(statearr_28804_30228[(2)] = null);

(statearr_28804_30228[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28802 === (1))){
var state_28801__$1 = state_28801;
var statearr_28805_30230 = state_28801__$1;
(statearr_28805_30230[(2)] = null);

(statearr_28805_30230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28802 === (4))){
var inst_28766 = (state_28801[(7)]);
var inst_28766__$1 = (state_28801[(2)]);
var inst_28767 = (inst_28766__$1 == null);
var state_28801__$1 = (function (){var statearr_28806 = state_28801;
(statearr_28806[(7)] = inst_28766__$1);

return statearr_28806;
})();
if(cljs.core.truth_(inst_28767)){
var statearr_28807_30232 = state_28801__$1;
(statearr_28807_30232[(1)] = (5));

} else {
var statearr_28809_30233 = state_28801__$1;
(statearr_28809_30233[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28802 === (15))){
var inst_28779 = (state_28801[(8)]);
var state_28801__$1 = state_28801;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28801__$1,(18),to,inst_28779);
} else {
if((state_val_28802 === (21))){
var inst_28792 = (state_28801[(2)]);
var state_28801__$1 = state_28801;
var statearr_28812_30237 = state_28801__$1;
(statearr_28812_30237[(2)] = inst_28792);

(statearr_28812_30237[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28802 === (13))){
var inst_28794 = (state_28801[(2)]);
var state_28801__$1 = (function (){var statearr_28813 = state_28801;
(statearr_28813[(9)] = inst_28794);

return statearr_28813;
})();
var statearr_28814_30238 = state_28801__$1;
(statearr_28814_30238[(2)] = null);

(statearr_28814_30238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28802 === (6))){
var inst_28766 = (state_28801[(7)]);
var state_28801__$1 = state_28801;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28801__$1,(11),inst_28766);
} else {
if((state_val_28802 === (17))){
var inst_28787 = (state_28801[(2)]);
var state_28801__$1 = state_28801;
if(cljs.core.truth_(inst_28787)){
var statearr_28815_30241 = state_28801__$1;
(statearr_28815_30241[(1)] = (19));

} else {
var statearr_28816_30242 = state_28801__$1;
(statearr_28816_30242[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28802 === (3))){
var inst_28799 = (state_28801[(2)]);
var state_28801__$1 = state_28801;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28801__$1,inst_28799);
} else {
if((state_val_28802 === (12))){
var inst_28776 = (state_28801[(10)]);
var state_28801__$1 = state_28801;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28801__$1,(14),inst_28776);
} else {
if((state_val_28802 === (2))){
var state_28801__$1 = state_28801;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28801__$1,(4),results);
} else {
if((state_val_28802 === (19))){
var state_28801__$1 = state_28801;
var statearr_28817_30246 = state_28801__$1;
(statearr_28817_30246[(2)] = null);

(statearr_28817_30246[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28802 === (11))){
var inst_28776 = (state_28801[(2)]);
var state_28801__$1 = (function (){var statearr_28818 = state_28801;
(statearr_28818[(10)] = inst_28776);

return statearr_28818;
})();
var statearr_28819_30247 = state_28801__$1;
(statearr_28819_30247[(2)] = null);

(statearr_28819_30247[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28802 === (9))){
var state_28801__$1 = state_28801;
var statearr_28820_30248 = state_28801__$1;
(statearr_28820_30248[(2)] = null);

(statearr_28820_30248[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28802 === (5))){
var state_28801__$1 = state_28801;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28822_30249 = state_28801__$1;
(statearr_28822_30249[(1)] = (8));

} else {
var statearr_28823_30250 = state_28801__$1;
(statearr_28823_30250[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28802 === (14))){
var inst_28779 = (state_28801[(8)]);
var inst_28779__$1 = (state_28801[(2)]);
var inst_28780 = (inst_28779__$1 == null);
var inst_28781 = cljs.core.not(inst_28780);
var state_28801__$1 = (function (){var statearr_28824 = state_28801;
(statearr_28824[(8)] = inst_28779__$1);

return statearr_28824;
})();
if(inst_28781){
var statearr_28825_30253 = state_28801__$1;
(statearr_28825_30253[(1)] = (15));

} else {
var statearr_28826_30254 = state_28801__$1;
(statearr_28826_30254[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28802 === (16))){
var state_28801__$1 = state_28801;
var statearr_28827_30255 = state_28801__$1;
(statearr_28827_30255[(2)] = false);

(statearr_28827_30255[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28802 === (10))){
var inst_28773 = (state_28801[(2)]);
var state_28801__$1 = state_28801;
var statearr_28828_30256 = state_28801__$1;
(statearr_28828_30256[(2)] = inst_28773);

(statearr_28828_30256[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28802 === (18))){
var inst_28784 = (state_28801[(2)]);
var state_28801__$1 = state_28801;
var statearr_28829_30257 = state_28801__$1;
(statearr_28829_30257[(2)] = inst_28784);

(statearr_28829_30257[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28802 === (8))){
var inst_28770 = cljs.core.async.close_BANG_(to);
var state_28801__$1 = state_28801;
var statearr_28830_30258 = state_28801__$1;
(statearr_28830_30258[(2)] = inst_28770);

(statearr_28830_30258[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____0 = (function (){
var statearr_28831 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28831[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__);

(statearr_28831[(1)] = (1));

return statearr_28831;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____1 = (function (state_28801){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_28801);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e28834){var ex__28414__auto__ = e28834;
var statearr_28836_30263 = state_28801;
(statearr_28836_30263[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_28801[(4)]))){
var statearr_28837_30264 = state_28801;
(statearr_28837_30264[(1)] = cljs.core.first((state_28801[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30268 = state_28801;
state_28801 = G__30268;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__ = function(state_28801){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____1.call(this,state_28801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28411__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_28838 = f__28447__auto__();
(statearr_28838[(6)] = c__28446__auto__);

return statearr_28838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));

return c__28446__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__28840 = arguments.length;
switch (G__28840) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__28842 = arguments.length;
switch (G__28842) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__28844 = arguments.length;
switch (G__28844) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__28446__auto___30289 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_28870){
var state_val_28871 = (state_28870[(1)]);
if((state_val_28871 === (7))){
var inst_28866 = (state_28870[(2)]);
var state_28870__$1 = state_28870;
var statearr_28872_30295 = state_28870__$1;
(statearr_28872_30295[(2)] = inst_28866);

(statearr_28872_30295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28871 === (1))){
var state_28870__$1 = state_28870;
var statearr_28873_30304 = state_28870__$1;
(statearr_28873_30304[(2)] = null);

(statearr_28873_30304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28871 === (4))){
var inst_28847 = (state_28870[(7)]);
var inst_28847__$1 = (state_28870[(2)]);
var inst_28848 = (inst_28847__$1 == null);
var state_28870__$1 = (function (){var statearr_28874 = state_28870;
(statearr_28874[(7)] = inst_28847__$1);

return statearr_28874;
})();
if(cljs.core.truth_(inst_28848)){
var statearr_28875_30325 = state_28870__$1;
(statearr_28875_30325[(1)] = (5));

} else {
var statearr_28876_30326 = state_28870__$1;
(statearr_28876_30326[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28871 === (13))){
var state_28870__$1 = state_28870;
var statearr_28877_30327 = state_28870__$1;
(statearr_28877_30327[(2)] = null);

(statearr_28877_30327[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28871 === (6))){
var inst_28847 = (state_28870[(7)]);
var inst_28853 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_28847) : p.call(null,inst_28847));
var state_28870__$1 = state_28870;
if(cljs.core.truth_(inst_28853)){
var statearr_28878_30334 = state_28870__$1;
(statearr_28878_30334[(1)] = (9));

} else {
var statearr_28879_30335 = state_28870__$1;
(statearr_28879_30335[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28871 === (3))){
var inst_28868 = (state_28870[(2)]);
var state_28870__$1 = state_28870;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28870__$1,inst_28868);
} else {
if((state_val_28871 === (12))){
var state_28870__$1 = state_28870;
var statearr_28880_30336 = state_28870__$1;
(statearr_28880_30336[(2)] = null);

(statearr_28880_30336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28871 === (2))){
var state_28870__$1 = state_28870;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28870__$1,(4),ch);
} else {
if((state_val_28871 === (11))){
var inst_28847 = (state_28870[(7)]);
var inst_28857 = (state_28870[(2)]);
var state_28870__$1 = state_28870;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28870__$1,(8),inst_28857,inst_28847);
} else {
if((state_val_28871 === (9))){
var state_28870__$1 = state_28870;
var statearr_28881_30340 = state_28870__$1;
(statearr_28881_30340[(2)] = tc);

(statearr_28881_30340[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28871 === (5))){
var inst_28850 = cljs.core.async.close_BANG_(tc);
var inst_28851 = cljs.core.async.close_BANG_(fc);
var state_28870__$1 = (function (){var statearr_28882 = state_28870;
(statearr_28882[(8)] = inst_28850);

return statearr_28882;
})();
var statearr_28883_30343 = state_28870__$1;
(statearr_28883_30343[(2)] = inst_28851);

(statearr_28883_30343[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28871 === (14))){
var inst_28864 = (state_28870[(2)]);
var state_28870__$1 = state_28870;
var statearr_28884_30345 = state_28870__$1;
(statearr_28884_30345[(2)] = inst_28864);

(statearr_28884_30345[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28871 === (10))){
var state_28870__$1 = state_28870;
var statearr_28885_30347 = state_28870__$1;
(statearr_28885_30347[(2)] = fc);

(statearr_28885_30347[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28871 === (8))){
var inst_28859 = (state_28870[(2)]);
var state_28870__$1 = state_28870;
if(cljs.core.truth_(inst_28859)){
var statearr_28886_30349 = state_28870__$1;
(statearr_28886_30349[(1)] = (12));

} else {
var statearr_28887_30350 = state_28870__$1;
(statearr_28887_30350[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28411__auto__ = null;
var cljs$core$async$state_machine__28411__auto____0 = (function (){
var statearr_28888 = [null,null,null,null,null,null,null,null,null];
(statearr_28888[(0)] = cljs$core$async$state_machine__28411__auto__);

(statearr_28888[(1)] = (1));

return statearr_28888;
});
var cljs$core$async$state_machine__28411__auto____1 = (function (state_28870){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_28870);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e28889){var ex__28414__auto__ = e28889;
var statearr_28890_30352 = state_28870;
(statearr_28890_30352[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_28870[(4)]))){
var statearr_28891_30353 = state_28870;
(statearr_28891_30353[(1)] = cljs.core.first((state_28870[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30356 = state_28870;
state_28870 = G__30356;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$state_machine__28411__auto__ = function(state_28870){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28411__auto____1.call(this,state_28870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28411__auto____0;
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28411__auto____1;
return cljs$core$async$state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_28892 = f__28447__auto__();
(statearr_28892[(6)] = c__28446__auto___30289);

return statearr_28892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__28446__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_28914){
var state_val_28915 = (state_28914[(1)]);
if((state_val_28915 === (7))){
var inst_28910 = (state_28914[(2)]);
var state_28914__$1 = state_28914;
var statearr_28916_30361 = state_28914__$1;
(statearr_28916_30361[(2)] = inst_28910);

(statearr_28916_30361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28915 === (1))){
var inst_28893 = init;
var inst_28894 = inst_28893;
var state_28914__$1 = (function (){var statearr_28917 = state_28914;
(statearr_28917[(7)] = inst_28894);

return statearr_28917;
})();
var statearr_28918_30364 = state_28914__$1;
(statearr_28918_30364[(2)] = null);

(statearr_28918_30364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28915 === (4))){
var inst_28897 = (state_28914[(8)]);
var inst_28897__$1 = (state_28914[(2)]);
var inst_28898 = (inst_28897__$1 == null);
var state_28914__$1 = (function (){var statearr_28919 = state_28914;
(statearr_28919[(8)] = inst_28897__$1);

return statearr_28919;
})();
if(cljs.core.truth_(inst_28898)){
var statearr_28920_30366 = state_28914__$1;
(statearr_28920_30366[(1)] = (5));

} else {
var statearr_28921_30367 = state_28914__$1;
(statearr_28921_30367[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28915 === (6))){
var inst_28897 = (state_28914[(8)]);
var inst_28894 = (state_28914[(7)]);
var inst_28901 = (state_28914[(9)]);
var inst_28901__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_28894,inst_28897) : f.call(null,inst_28894,inst_28897));
var inst_28902 = cljs.core.reduced_QMARK_(inst_28901__$1);
var state_28914__$1 = (function (){var statearr_28922 = state_28914;
(statearr_28922[(9)] = inst_28901__$1);

return statearr_28922;
})();
if(inst_28902){
var statearr_28923_30371 = state_28914__$1;
(statearr_28923_30371[(1)] = (8));

} else {
var statearr_28924_30372 = state_28914__$1;
(statearr_28924_30372[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28915 === (3))){
var inst_28912 = (state_28914[(2)]);
var state_28914__$1 = state_28914;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28914__$1,inst_28912);
} else {
if((state_val_28915 === (2))){
var state_28914__$1 = state_28914;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28914__$1,(4),ch);
} else {
if((state_val_28915 === (9))){
var inst_28901 = (state_28914[(9)]);
var inst_28894 = inst_28901;
var state_28914__$1 = (function (){var statearr_28925 = state_28914;
(statearr_28925[(7)] = inst_28894);

return statearr_28925;
})();
var statearr_28926_30376 = state_28914__$1;
(statearr_28926_30376[(2)] = null);

(statearr_28926_30376[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28915 === (5))){
var inst_28894 = (state_28914[(7)]);
var state_28914__$1 = state_28914;
var statearr_28927_30378 = state_28914__$1;
(statearr_28927_30378[(2)] = inst_28894);

(statearr_28927_30378[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28915 === (10))){
var inst_28908 = (state_28914[(2)]);
var state_28914__$1 = state_28914;
var statearr_28928_30380 = state_28914__$1;
(statearr_28928_30380[(2)] = inst_28908);

(statearr_28928_30380[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28915 === (8))){
var inst_28901 = (state_28914[(9)]);
var inst_28904 = cljs.core.deref(inst_28901);
var state_28914__$1 = state_28914;
var statearr_28929_30383 = state_28914__$1;
(statearr_28929_30383[(2)] = inst_28904);

(statearr_28929_30383[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__28411__auto__ = null;
var cljs$core$async$reduce_$_state_machine__28411__auto____0 = (function (){
var statearr_28930 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28930[(0)] = cljs$core$async$reduce_$_state_machine__28411__auto__);

(statearr_28930[(1)] = (1));

return statearr_28930;
});
var cljs$core$async$reduce_$_state_machine__28411__auto____1 = (function (state_28914){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_28914);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e28931){var ex__28414__auto__ = e28931;
var statearr_28932_30385 = state_28914;
(statearr_28932_30385[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_28914[(4)]))){
var statearr_28933_30386 = state_28914;
(statearr_28933_30386[(1)] = cljs.core.first((state_28914[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30387 = state_28914;
state_28914 = G__30387;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__28411__auto__ = function(state_28914){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__28411__auto____1.call(this,state_28914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__28411__auto____0;
cljs$core$async$reduce_$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__28411__auto____1;
return cljs$core$async$reduce_$_state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_28934 = f__28447__auto__();
(statearr_28934[(6)] = c__28446__auto__);

return statearr_28934;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));

return c__28446__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__28446__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_28940){
var state_val_28941 = (state_28940[(1)]);
if((state_val_28941 === (1))){
var inst_28935 = cljs.core.async.reduce(f__$1,init,ch);
var state_28940__$1 = state_28940;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28940__$1,(2),inst_28935);
} else {
if((state_val_28941 === (2))){
var inst_28937 = (state_28940[(2)]);
var inst_28938 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_28937) : f__$1.call(null,inst_28937));
var state_28940__$1 = state_28940;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28940__$1,inst_28938);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__28411__auto__ = null;
var cljs$core$async$transduce_$_state_machine__28411__auto____0 = (function (){
var statearr_28942 = [null,null,null,null,null,null,null];
(statearr_28942[(0)] = cljs$core$async$transduce_$_state_machine__28411__auto__);

(statearr_28942[(1)] = (1));

return statearr_28942;
});
var cljs$core$async$transduce_$_state_machine__28411__auto____1 = (function (state_28940){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_28940);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e28943){var ex__28414__auto__ = e28943;
var statearr_28944_30388 = state_28940;
(statearr_28944_30388[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_28940[(4)]))){
var statearr_28945_30389 = state_28940;
(statearr_28945_30389[(1)] = cljs.core.first((state_28940[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30390 = state_28940;
state_28940 = G__30390;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__28411__auto__ = function(state_28940){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__28411__auto____1.call(this,state_28940);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__28411__auto____0;
cljs$core$async$transduce_$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__28411__auto____1;
return cljs$core$async$transduce_$_state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_28946 = f__28447__auto__();
(statearr_28946[(6)] = c__28446__auto__);

return statearr_28946;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));

return c__28446__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__28948 = arguments.length;
switch (G__28948) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__28446__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_28973){
var state_val_28974 = (state_28973[(1)]);
if((state_val_28974 === (7))){
var inst_28955 = (state_28973[(2)]);
var state_28973__$1 = state_28973;
var statearr_28975_30393 = state_28973__$1;
(statearr_28975_30393[(2)] = inst_28955);

(statearr_28975_30393[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28974 === (1))){
var inst_28949 = cljs.core.seq(coll);
var inst_28950 = inst_28949;
var state_28973__$1 = (function (){var statearr_28976 = state_28973;
(statearr_28976[(7)] = inst_28950);

return statearr_28976;
})();
var statearr_28977_30394 = state_28973__$1;
(statearr_28977_30394[(2)] = null);

(statearr_28977_30394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28974 === (4))){
var inst_28950 = (state_28973[(7)]);
var inst_28953 = cljs.core.first(inst_28950);
var state_28973__$1 = state_28973;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28973__$1,(7),ch,inst_28953);
} else {
if((state_val_28974 === (13))){
var inst_28967 = (state_28973[(2)]);
var state_28973__$1 = state_28973;
var statearr_28978_30396 = state_28973__$1;
(statearr_28978_30396[(2)] = inst_28967);

(statearr_28978_30396[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28974 === (6))){
var inst_28958 = (state_28973[(2)]);
var state_28973__$1 = state_28973;
if(cljs.core.truth_(inst_28958)){
var statearr_28979_30397 = state_28973__$1;
(statearr_28979_30397[(1)] = (8));

} else {
var statearr_28980_30398 = state_28973__$1;
(statearr_28980_30398[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28974 === (3))){
var inst_28971 = (state_28973[(2)]);
var state_28973__$1 = state_28973;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28973__$1,inst_28971);
} else {
if((state_val_28974 === (12))){
var state_28973__$1 = state_28973;
var statearr_28981_30399 = state_28973__$1;
(statearr_28981_30399[(2)] = null);

(statearr_28981_30399[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28974 === (2))){
var inst_28950 = (state_28973[(7)]);
var state_28973__$1 = state_28973;
if(cljs.core.truth_(inst_28950)){
var statearr_28982_30400 = state_28973__$1;
(statearr_28982_30400[(1)] = (4));

} else {
var statearr_28983_30401 = state_28973__$1;
(statearr_28983_30401[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28974 === (11))){
var inst_28964 = cljs.core.async.close_BANG_(ch);
var state_28973__$1 = state_28973;
var statearr_28984_30402 = state_28973__$1;
(statearr_28984_30402[(2)] = inst_28964);

(statearr_28984_30402[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28974 === (9))){
var state_28973__$1 = state_28973;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28985_30403 = state_28973__$1;
(statearr_28985_30403[(1)] = (11));

} else {
var statearr_28986_30404 = state_28973__$1;
(statearr_28986_30404[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28974 === (5))){
var inst_28950 = (state_28973[(7)]);
var state_28973__$1 = state_28973;
var statearr_28987_30405 = state_28973__$1;
(statearr_28987_30405[(2)] = inst_28950);

(statearr_28987_30405[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28974 === (10))){
var inst_28969 = (state_28973[(2)]);
var state_28973__$1 = state_28973;
var statearr_28988_30406 = state_28973__$1;
(statearr_28988_30406[(2)] = inst_28969);

(statearr_28988_30406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28974 === (8))){
var inst_28950 = (state_28973[(7)]);
var inst_28960 = cljs.core.next(inst_28950);
var inst_28950__$1 = inst_28960;
var state_28973__$1 = (function (){var statearr_28989 = state_28973;
(statearr_28989[(7)] = inst_28950__$1);

return statearr_28989;
})();
var statearr_28990_30407 = state_28973__$1;
(statearr_28990_30407[(2)] = null);

(statearr_28990_30407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28411__auto__ = null;
var cljs$core$async$state_machine__28411__auto____0 = (function (){
var statearr_28991 = [null,null,null,null,null,null,null,null];
(statearr_28991[(0)] = cljs$core$async$state_machine__28411__auto__);

(statearr_28991[(1)] = (1));

return statearr_28991;
});
var cljs$core$async$state_machine__28411__auto____1 = (function (state_28973){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_28973);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e28992){var ex__28414__auto__ = e28992;
var statearr_28993_30408 = state_28973;
(statearr_28993_30408[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_28973[(4)]))){
var statearr_28994_30409 = state_28973;
(statearr_28994_30409[(1)] = cljs.core.first((state_28973[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30410 = state_28973;
state_28973 = G__30410;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$state_machine__28411__auto__ = function(state_28973){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28411__auto____1.call(this,state_28973);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28411__auto____0;
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28411__auto____1;
return cljs$core$async$state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_28995 = f__28447__auto__();
(statearr_28995[(6)] = c__28446__auto__);

return statearr_28995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));

return c__28446__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_30411 = (function (_){
var x__4422__auto__ = (((_ == null))?null:_);
var m__4423__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4423__auto__.call(null,_));
} else {
var m__4420__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4420__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_30411(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_30412 = (function (m,ch,close_QMARK_){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4423__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4420__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4420__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_30412(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_30413 = (function (m,ch){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4423__auto__.call(null,m,ch));
} else {
var m__4420__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4420__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_30413(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_30414 = (function (m){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4423__auto__.call(null,m));
} else {
var m__4420__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4420__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_30414(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28996 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28996 = (function (ch,cs,meta28997){
this.ch = ch;
this.cs = cs;
this.meta28997 = meta28997;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28996.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28998,meta28997__$1){
var self__ = this;
var _28998__$1 = this;
return (new cljs.core.async.t_cljs$core$async28996(self__.ch,self__.cs,meta28997__$1));
}));

(cljs.core.async.t_cljs$core$async28996.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28998){
var self__ = this;
var _28998__$1 = this;
return self__.meta28997;
}));

(cljs.core.async.t_cljs$core$async28996.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28996.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async28996.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28996.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async28996.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async28996.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async28996.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta28997","meta28997",325524718,null)], null);
}));

(cljs.core.async.t_cljs$core$async28996.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28996.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28996");

(cljs.core.async.t_cljs$core$async28996.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async28996");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28996.
 */
cljs.core.async.__GT_t_cljs$core$async28996 = (function cljs$core$async$mult_$___GT_t_cljs$core$async28996(ch__$1,cs__$1,meta28997){
return (new cljs.core.async.t_cljs$core$async28996(ch__$1,cs__$1,meta28997));
});

}

return (new cljs.core.async.t_cljs$core$async28996(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__28446__auto___30422 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_29131){
var state_val_29132 = (state_29131[(1)]);
if((state_val_29132 === (7))){
var inst_29127 = (state_29131[(2)]);
var state_29131__$1 = state_29131;
var statearr_29133_30425 = state_29131__$1;
(statearr_29133_30425[(2)] = inst_29127);

(statearr_29133_30425[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (20))){
var inst_29032 = (state_29131[(7)]);
var inst_29044 = cljs.core.first(inst_29032);
var inst_29045 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29044,(0),null);
var inst_29046 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29044,(1),null);
var state_29131__$1 = (function (){var statearr_29134 = state_29131;
(statearr_29134[(8)] = inst_29045);

return statearr_29134;
})();
if(cljs.core.truth_(inst_29046)){
var statearr_29135_30426 = state_29131__$1;
(statearr_29135_30426[(1)] = (22));

} else {
var statearr_29136_30427 = state_29131__$1;
(statearr_29136_30427[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (27))){
var inst_29001 = (state_29131[(9)]);
var inst_29074 = (state_29131[(10)]);
var inst_29076 = (state_29131[(11)]);
var inst_29081 = (state_29131[(12)]);
var inst_29081__$1 = cljs.core._nth(inst_29074,inst_29076);
var inst_29082 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29081__$1,inst_29001,done);
var state_29131__$1 = (function (){var statearr_29137 = state_29131;
(statearr_29137[(12)] = inst_29081__$1);

return statearr_29137;
})();
if(cljs.core.truth_(inst_29082)){
var statearr_29138_30428 = state_29131__$1;
(statearr_29138_30428[(1)] = (30));

} else {
var statearr_29139_30429 = state_29131__$1;
(statearr_29139_30429[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (1))){
var state_29131__$1 = state_29131;
var statearr_29140_30430 = state_29131__$1;
(statearr_29140_30430[(2)] = null);

(statearr_29140_30430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (24))){
var inst_29032 = (state_29131[(7)]);
var inst_29051 = (state_29131[(2)]);
var inst_29052 = cljs.core.next(inst_29032);
var inst_29010 = inst_29052;
var inst_29011 = null;
var inst_29012 = (0);
var inst_29013 = (0);
var state_29131__$1 = (function (){var statearr_29141 = state_29131;
(statearr_29141[(13)] = inst_29051);

(statearr_29141[(14)] = inst_29011);

(statearr_29141[(15)] = inst_29013);

(statearr_29141[(16)] = inst_29010);

(statearr_29141[(17)] = inst_29012);

return statearr_29141;
})();
var statearr_29142_30431 = state_29131__$1;
(statearr_29142_30431[(2)] = null);

(statearr_29142_30431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (39))){
var state_29131__$1 = state_29131;
var statearr_29146_30432 = state_29131__$1;
(statearr_29146_30432[(2)] = null);

(statearr_29146_30432[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (4))){
var inst_29001 = (state_29131[(9)]);
var inst_29001__$1 = (state_29131[(2)]);
var inst_29002 = (inst_29001__$1 == null);
var state_29131__$1 = (function (){var statearr_29147 = state_29131;
(statearr_29147[(9)] = inst_29001__$1);

return statearr_29147;
})();
if(cljs.core.truth_(inst_29002)){
var statearr_29148_30433 = state_29131__$1;
(statearr_29148_30433[(1)] = (5));

} else {
var statearr_29149_30434 = state_29131__$1;
(statearr_29149_30434[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (15))){
var inst_29011 = (state_29131[(14)]);
var inst_29013 = (state_29131[(15)]);
var inst_29010 = (state_29131[(16)]);
var inst_29012 = (state_29131[(17)]);
var inst_29028 = (state_29131[(2)]);
var inst_29029 = (inst_29013 + (1));
var tmp29143 = inst_29011;
var tmp29144 = inst_29010;
var tmp29145 = inst_29012;
var inst_29010__$1 = tmp29144;
var inst_29011__$1 = tmp29143;
var inst_29012__$1 = tmp29145;
var inst_29013__$1 = inst_29029;
var state_29131__$1 = (function (){var statearr_29150 = state_29131;
(statearr_29150[(14)] = inst_29011__$1);

(statearr_29150[(15)] = inst_29013__$1);

(statearr_29150[(18)] = inst_29028);

(statearr_29150[(16)] = inst_29010__$1);

(statearr_29150[(17)] = inst_29012__$1);

return statearr_29150;
})();
var statearr_29151_30435 = state_29131__$1;
(statearr_29151_30435[(2)] = null);

(statearr_29151_30435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (21))){
var inst_29055 = (state_29131[(2)]);
var state_29131__$1 = state_29131;
var statearr_29155_30436 = state_29131__$1;
(statearr_29155_30436[(2)] = inst_29055);

(statearr_29155_30436[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (31))){
var inst_29081 = (state_29131[(12)]);
var inst_29085 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29081);
var state_29131__$1 = state_29131;
var statearr_29156_30437 = state_29131__$1;
(statearr_29156_30437[(2)] = inst_29085);

(statearr_29156_30437[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (32))){
var inst_29074 = (state_29131[(10)]);
var inst_29076 = (state_29131[(11)]);
var inst_29075 = (state_29131[(19)]);
var inst_29073 = (state_29131[(20)]);
var inst_29087 = (state_29131[(2)]);
var inst_29088 = (inst_29076 + (1));
var tmp29152 = inst_29074;
var tmp29153 = inst_29075;
var tmp29154 = inst_29073;
var inst_29073__$1 = tmp29154;
var inst_29074__$1 = tmp29152;
var inst_29075__$1 = tmp29153;
var inst_29076__$1 = inst_29088;
var state_29131__$1 = (function (){var statearr_29157 = state_29131;
(statearr_29157[(10)] = inst_29074__$1);

(statearr_29157[(11)] = inst_29076__$1);

(statearr_29157[(21)] = inst_29087);

(statearr_29157[(19)] = inst_29075__$1);

(statearr_29157[(20)] = inst_29073__$1);

return statearr_29157;
})();
var statearr_29158_30438 = state_29131__$1;
(statearr_29158_30438[(2)] = null);

(statearr_29158_30438[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (40))){
var inst_29100 = (state_29131[(22)]);
var inst_29104 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29100);
var state_29131__$1 = state_29131;
var statearr_29159_30439 = state_29131__$1;
(statearr_29159_30439[(2)] = inst_29104);

(statearr_29159_30439[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (33))){
var inst_29091 = (state_29131[(23)]);
var inst_29093 = cljs.core.chunked_seq_QMARK_(inst_29091);
var state_29131__$1 = state_29131;
if(inst_29093){
var statearr_29160_30440 = state_29131__$1;
(statearr_29160_30440[(1)] = (36));

} else {
var statearr_29161_30441 = state_29131__$1;
(statearr_29161_30441[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (13))){
var inst_29022 = (state_29131[(24)]);
var inst_29025 = cljs.core.async.close_BANG_(inst_29022);
var state_29131__$1 = state_29131;
var statearr_29162_30442 = state_29131__$1;
(statearr_29162_30442[(2)] = inst_29025);

(statearr_29162_30442[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (22))){
var inst_29045 = (state_29131[(8)]);
var inst_29048 = cljs.core.async.close_BANG_(inst_29045);
var state_29131__$1 = state_29131;
var statearr_29163_30443 = state_29131__$1;
(statearr_29163_30443[(2)] = inst_29048);

(statearr_29163_30443[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (36))){
var inst_29091 = (state_29131[(23)]);
var inst_29095 = cljs.core.chunk_first(inst_29091);
var inst_29096 = cljs.core.chunk_rest(inst_29091);
var inst_29097 = cljs.core.count(inst_29095);
var inst_29073 = inst_29096;
var inst_29074 = inst_29095;
var inst_29075 = inst_29097;
var inst_29076 = (0);
var state_29131__$1 = (function (){var statearr_29164 = state_29131;
(statearr_29164[(10)] = inst_29074);

(statearr_29164[(11)] = inst_29076);

(statearr_29164[(19)] = inst_29075);

(statearr_29164[(20)] = inst_29073);

return statearr_29164;
})();
var statearr_29165_30447 = state_29131__$1;
(statearr_29165_30447[(2)] = null);

(statearr_29165_30447[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (41))){
var inst_29091 = (state_29131[(23)]);
var inst_29106 = (state_29131[(2)]);
var inst_29107 = cljs.core.next(inst_29091);
var inst_29073 = inst_29107;
var inst_29074 = null;
var inst_29075 = (0);
var inst_29076 = (0);
var state_29131__$1 = (function (){var statearr_29166 = state_29131;
(statearr_29166[(10)] = inst_29074);

(statearr_29166[(11)] = inst_29076);

(statearr_29166[(25)] = inst_29106);

(statearr_29166[(19)] = inst_29075);

(statearr_29166[(20)] = inst_29073);

return statearr_29166;
})();
var statearr_29167_30448 = state_29131__$1;
(statearr_29167_30448[(2)] = null);

(statearr_29167_30448[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (43))){
var state_29131__$1 = state_29131;
var statearr_29168_30449 = state_29131__$1;
(statearr_29168_30449[(2)] = null);

(statearr_29168_30449[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (29))){
var inst_29115 = (state_29131[(2)]);
var state_29131__$1 = state_29131;
var statearr_29169_30451 = state_29131__$1;
(statearr_29169_30451[(2)] = inst_29115);

(statearr_29169_30451[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (44))){
var inst_29124 = (state_29131[(2)]);
var state_29131__$1 = (function (){var statearr_29170 = state_29131;
(statearr_29170[(26)] = inst_29124);

return statearr_29170;
})();
var statearr_29171_30452 = state_29131__$1;
(statearr_29171_30452[(2)] = null);

(statearr_29171_30452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (6))){
var inst_29065 = (state_29131[(27)]);
var inst_29064 = cljs.core.deref(cs);
var inst_29065__$1 = cljs.core.keys(inst_29064);
var inst_29066 = cljs.core.count(inst_29065__$1);
var inst_29067 = cljs.core.reset_BANG_(dctr,inst_29066);
var inst_29072 = cljs.core.seq(inst_29065__$1);
var inst_29073 = inst_29072;
var inst_29074 = null;
var inst_29075 = (0);
var inst_29076 = (0);
var state_29131__$1 = (function (){var statearr_29172 = state_29131;
(statearr_29172[(28)] = inst_29067);

(statearr_29172[(27)] = inst_29065__$1);

(statearr_29172[(10)] = inst_29074);

(statearr_29172[(11)] = inst_29076);

(statearr_29172[(19)] = inst_29075);

(statearr_29172[(20)] = inst_29073);

return statearr_29172;
})();
var statearr_29173_30453 = state_29131__$1;
(statearr_29173_30453[(2)] = null);

(statearr_29173_30453[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (28))){
var inst_29091 = (state_29131[(23)]);
var inst_29073 = (state_29131[(20)]);
var inst_29091__$1 = cljs.core.seq(inst_29073);
var state_29131__$1 = (function (){var statearr_29174 = state_29131;
(statearr_29174[(23)] = inst_29091__$1);

return statearr_29174;
})();
if(inst_29091__$1){
var statearr_29175_30454 = state_29131__$1;
(statearr_29175_30454[(1)] = (33));

} else {
var statearr_29176_30455 = state_29131__$1;
(statearr_29176_30455[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (25))){
var inst_29076 = (state_29131[(11)]);
var inst_29075 = (state_29131[(19)]);
var inst_29078 = (inst_29076 < inst_29075);
var inst_29079 = inst_29078;
var state_29131__$1 = state_29131;
if(cljs.core.truth_(inst_29079)){
var statearr_29177_30456 = state_29131__$1;
(statearr_29177_30456[(1)] = (27));

} else {
var statearr_29178_30457 = state_29131__$1;
(statearr_29178_30457[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (34))){
var state_29131__$1 = state_29131;
var statearr_29179_30458 = state_29131__$1;
(statearr_29179_30458[(2)] = null);

(statearr_29179_30458[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (17))){
var state_29131__$1 = state_29131;
var statearr_29180_30459 = state_29131__$1;
(statearr_29180_30459[(2)] = null);

(statearr_29180_30459[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (3))){
var inst_29129 = (state_29131[(2)]);
var state_29131__$1 = state_29131;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29131__$1,inst_29129);
} else {
if((state_val_29132 === (12))){
var inst_29060 = (state_29131[(2)]);
var state_29131__$1 = state_29131;
var statearr_29181_30460 = state_29131__$1;
(statearr_29181_30460[(2)] = inst_29060);

(statearr_29181_30460[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (2))){
var state_29131__$1 = state_29131;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29131__$1,(4),ch);
} else {
if((state_val_29132 === (23))){
var state_29131__$1 = state_29131;
var statearr_29182_30461 = state_29131__$1;
(statearr_29182_30461[(2)] = null);

(statearr_29182_30461[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (35))){
var inst_29113 = (state_29131[(2)]);
var state_29131__$1 = state_29131;
var statearr_29183_30462 = state_29131__$1;
(statearr_29183_30462[(2)] = inst_29113);

(statearr_29183_30462[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (19))){
var inst_29032 = (state_29131[(7)]);
var inst_29036 = cljs.core.chunk_first(inst_29032);
var inst_29037 = cljs.core.chunk_rest(inst_29032);
var inst_29038 = cljs.core.count(inst_29036);
var inst_29010 = inst_29037;
var inst_29011 = inst_29036;
var inst_29012 = inst_29038;
var inst_29013 = (0);
var state_29131__$1 = (function (){var statearr_29184 = state_29131;
(statearr_29184[(14)] = inst_29011);

(statearr_29184[(15)] = inst_29013);

(statearr_29184[(16)] = inst_29010);

(statearr_29184[(17)] = inst_29012);

return statearr_29184;
})();
var statearr_29185_30463 = state_29131__$1;
(statearr_29185_30463[(2)] = null);

(statearr_29185_30463[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (11))){
var inst_29032 = (state_29131[(7)]);
var inst_29010 = (state_29131[(16)]);
var inst_29032__$1 = cljs.core.seq(inst_29010);
var state_29131__$1 = (function (){var statearr_29186 = state_29131;
(statearr_29186[(7)] = inst_29032__$1);

return statearr_29186;
})();
if(inst_29032__$1){
var statearr_29187_30464 = state_29131__$1;
(statearr_29187_30464[(1)] = (16));

} else {
var statearr_29188_30465 = state_29131__$1;
(statearr_29188_30465[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (9))){
var inst_29062 = (state_29131[(2)]);
var state_29131__$1 = state_29131;
var statearr_29189_30466 = state_29131__$1;
(statearr_29189_30466[(2)] = inst_29062);

(statearr_29189_30466[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (5))){
var inst_29008 = cljs.core.deref(cs);
var inst_29009 = cljs.core.seq(inst_29008);
var inst_29010 = inst_29009;
var inst_29011 = null;
var inst_29012 = (0);
var inst_29013 = (0);
var state_29131__$1 = (function (){var statearr_29190 = state_29131;
(statearr_29190[(14)] = inst_29011);

(statearr_29190[(15)] = inst_29013);

(statearr_29190[(16)] = inst_29010);

(statearr_29190[(17)] = inst_29012);

return statearr_29190;
})();
var statearr_29191_30467 = state_29131__$1;
(statearr_29191_30467[(2)] = null);

(statearr_29191_30467[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (14))){
var state_29131__$1 = state_29131;
var statearr_29192_30468 = state_29131__$1;
(statearr_29192_30468[(2)] = null);

(statearr_29192_30468[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (45))){
var inst_29121 = (state_29131[(2)]);
var state_29131__$1 = state_29131;
var statearr_29193_30469 = state_29131__$1;
(statearr_29193_30469[(2)] = inst_29121);

(statearr_29193_30469[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (26))){
var inst_29065 = (state_29131[(27)]);
var inst_29117 = (state_29131[(2)]);
var inst_29118 = cljs.core.seq(inst_29065);
var state_29131__$1 = (function (){var statearr_29194 = state_29131;
(statearr_29194[(29)] = inst_29117);

return statearr_29194;
})();
if(inst_29118){
var statearr_29195_30470 = state_29131__$1;
(statearr_29195_30470[(1)] = (42));

} else {
var statearr_29196_30471 = state_29131__$1;
(statearr_29196_30471[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (16))){
var inst_29032 = (state_29131[(7)]);
var inst_29034 = cljs.core.chunked_seq_QMARK_(inst_29032);
var state_29131__$1 = state_29131;
if(inst_29034){
var statearr_29197_30473 = state_29131__$1;
(statearr_29197_30473[(1)] = (19));

} else {
var statearr_29198_30474 = state_29131__$1;
(statearr_29198_30474[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (38))){
var inst_29110 = (state_29131[(2)]);
var state_29131__$1 = state_29131;
var statearr_29199_30475 = state_29131__$1;
(statearr_29199_30475[(2)] = inst_29110);

(statearr_29199_30475[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (30))){
var state_29131__$1 = state_29131;
var statearr_29200_30476 = state_29131__$1;
(statearr_29200_30476[(2)] = null);

(statearr_29200_30476[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (10))){
var inst_29011 = (state_29131[(14)]);
var inst_29013 = (state_29131[(15)]);
var inst_29021 = cljs.core._nth(inst_29011,inst_29013);
var inst_29022 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29021,(0),null);
var inst_29023 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29021,(1),null);
var state_29131__$1 = (function (){var statearr_29201 = state_29131;
(statearr_29201[(24)] = inst_29022);

return statearr_29201;
})();
if(cljs.core.truth_(inst_29023)){
var statearr_29202_30477 = state_29131__$1;
(statearr_29202_30477[(1)] = (13));

} else {
var statearr_29203_30478 = state_29131__$1;
(statearr_29203_30478[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (18))){
var inst_29058 = (state_29131[(2)]);
var state_29131__$1 = state_29131;
var statearr_29204_30479 = state_29131__$1;
(statearr_29204_30479[(2)] = inst_29058);

(statearr_29204_30479[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (42))){
var state_29131__$1 = state_29131;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29131__$1,(45),dchan);
} else {
if((state_val_29132 === (37))){
var inst_29001 = (state_29131[(9)]);
var inst_29100 = (state_29131[(22)]);
var inst_29091 = (state_29131[(23)]);
var inst_29100__$1 = cljs.core.first(inst_29091);
var inst_29101 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29100__$1,inst_29001,done);
var state_29131__$1 = (function (){var statearr_29205 = state_29131;
(statearr_29205[(22)] = inst_29100__$1);

return statearr_29205;
})();
if(cljs.core.truth_(inst_29101)){
var statearr_29206_30480 = state_29131__$1;
(statearr_29206_30480[(1)] = (39));

} else {
var statearr_29207_30481 = state_29131__$1;
(statearr_29207_30481[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29132 === (8))){
var inst_29013 = (state_29131[(15)]);
var inst_29012 = (state_29131[(17)]);
var inst_29015 = (inst_29013 < inst_29012);
var inst_29016 = inst_29015;
var state_29131__$1 = state_29131;
if(cljs.core.truth_(inst_29016)){
var statearr_29208_30484 = state_29131__$1;
(statearr_29208_30484[(1)] = (10));

} else {
var statearr_29209_30485 = state_29131__$1;
(statearr_29209_30485[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__28411__auto__ = null;
var cljs$core$async$mult_$_state_machine__28411__auto____0 = (function (){
var statearr_29210 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29210[(0)] = cljs$core$async$mult_$_state_machine__28411__auto__);

(statearr_29210[(1)] = (1));

return statearr_29210;
});
var cljs$core$async$mult_$_state_machine__28411__auto____1 = (function (state_29131){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_29131);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e29211){var ex__28414__auto__ = e29211;
var statearr_29212_30489 = state_29131;
(statearr_29212_30489[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_29131[(4)]))){
var statearr_29213_30490 = state_29131;
(statearr_29213_30490[(1)] = cljs.core.first((state_29131[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30491 = state_29131;
state_29131 = G__30491;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__28411__auto__ = function(state_29131){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__28411__auto____1.call(this,state_29131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__28411__auto____0;
cljs$core$async$mult_$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__28411__auto____1;
return cljs$core$async$mult_$_state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_29214 = f__28447__auto__();
(statearr_29214[(6)] = c__28446__auto___30422);

return statearr_29214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__29216 = arguments.length;
switch (G__29216) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_30497 = (function (m,ch){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4423__auto__.call(null,m,ch));
} else {
var m__4420__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4420__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_30497(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_30500 = (function (m,ch){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4423__auto__.call(null,m,ch));
} else {
var m__4420__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4420__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_30500(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_30504 = (function (m){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4423__auto__.call(null,m));
} else {
var m__4420__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4420__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_30504(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_30507 = (function (m,state_map){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4423__auto__.call(null,m,state_map));
} else {
var m__4420__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4420__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_30507(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_30511 = (function (m,mode){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4423__auto__.call(null,m,mode));
} else {
var m__4420__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4420__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_30511(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___30514 = arguments.length;
var i__4731__auto___30515 = (0);
while(true){
if((i__4731__auto___30515 < len__4730__auto___30514)){
args__4736__auto__.push((arguments[i__4731__auto___30515]));

var G__30516 = (i__4731__auto___30515 + (1));
i__4731__auto___30515 = G__30516;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__29221){
var map__29222 = p__29221;
var map__29222__$1 = (((((!((map__29222 == null))))?(((((map__29222.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29222.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29222):map__29222);
var opts = map__29222__$1;
var statearr_29224_30520 = state;
(statearr_29224_30520[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_29225_30521 = state;
(statearr_29225_30521[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_29226_30522 = state;
(statearr_29226_30522[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq29217){
var G__29218 = cljs.core.first(seq29217);
var seq29217__$1 = cljs.core.next(seq29217);
var G__29219 = cljs.core.first(seq29217__$1);
var seq29217__$2 = cljs.core.next(seq29217__$1);
var G__29220 = cljs.core.first(seq29217__$2);
var seq29217__$3 = cljs.core.next(seq29217__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29218,G__29219,G__29220,seq29217__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29227 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29227 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta29228){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta29228 = meta29228;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29227.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29229,meta29228__$1){
var self__ = this;
var _29229__$1 = this;
return (new cljs.core.async.t_cljs$core$async29227(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta29228__$1));
}));

(cljs.core.async.t_cljs$core$async29227.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29229){
var self__ = this;
var _29229__$1 = this;
return self__.meta29228;
}));

(cljs.core.async.t_cljs$core$async29227.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29227.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async29227.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29227.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29227.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29227.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29227.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29227.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29227.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta29228","meta29228",2103174614,null)], null);
}));

(cljs.core.async.t_cljs$core$async29227.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29227.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29227");

(cljs.core.async.t_cljs$core$async29227.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async29227");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29227.
 */
cljs.core.async.__GT_t_cljs$core$async29227 = (function cljs$core$async$mix_$___GT_t_cljs$core$async29227(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29228){
return (new cljs.core.async.t_cljs$core$async29227(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29228));
});

}

return (new cljs.core.async.t_cljs$core$async29227(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28446__auto___30523 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_29331){
var state_val_29332 = (state_29331[(1)]);
if((state_val_29332 === (7))){
var inst_29246 = (state_29331[(2)]);
var state_29331__$1 = state_29331;
var statearr_29333_30524 = state_29331__$1;
(statearr_29333_30524[(2)] = inst_29246);

(statearr_29333_30524[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (20))){
var inst_29258 = (state_29331[(7)]);
var state_29331__$1 = state_29331;
var statearr_29334_30525 = state_29331__$1;
(statearr_29334_30525[(2)] = inst_29258);

(statearr_29334_30525[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (27))){
var state_29331__$1 = state_29331;
var statearr_29335_30526 = state_29331__$1;
(statearr_29335_30526[(2)] = null);

(statearr_29335_30526[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (1))){
var inst_29233 = (state_29331[(8)]);
var inst_29233__$1 = calc_state();
var inst_29235 = (inst_29233__$1 == null);
var inst_29236 = cljs.core.not(inst_29235);
var state_29331__$1 = (function (){var statearr_29336 = state_29331;
(statearr_29336[(8)] = inst_29233__$1);

return statearr_29336;
})();
if(inst_29236){
var statearr_29337_30527 = state_29331__$1;
(statearr_29337_30527[(1)] = (2));

} else {
var statearr_29338_30528 = state_29331__$1;
(statearr_29338_30528[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (24))){
var inst_29282 = (state_29331[(9)]);
var inst_29305 = (state_29331[(10)]);
var inst_29291 = (state_29331[(11)]);
var inst_29305__$1 = (inst_29282.cljs$core$IFn$_invoke$arity$1 ? inst_29282.cljs$core$IFn$_invoke$arity$1(inst_29291) : inst_29282.call(null,inst_29291));
var state_29331__$1 = (function (){var statearr_29339 = state_29331;
(statearr_29339[(10)] = inst_29305__$1);

return statearr_29339;
})();
if(cljs.core.truth_(inst_29305__$1)){
var statearr_29340_30529 = state_29331__$1;
(statearr_29340_30529[(1)] = (29));

} else {
var statearr_29341_30530 = state_29331__$1;
(statearr_29341_30530[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (4))){
var inst_29249 = (state_29331[(2)]);
var state_29331__$1 = state_29331;
if(cljs.core.truth_(inst_29249)){
var statearr_29342_30531 = state_29331__$1;
(statearr_29342_30531[(1)] = (8));

} else {
var statearr_29343_30532 = state_29331__$1;
(statearr_29343_30532[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (15))){
var inst_29276 = (state_29331[(2)]);
var state_29331__$1 = state_29331;
if(cljs.core.truth_(inst_29276)){
var statearr_29344_30533 = state_29331__$1;
(statearr_29344_30533[(1)] = (19));

} else {
var statearr_29345_30534 = state_29331__$1;
(statearr_29345_30534[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (21))){
var inst_29281 = (state_29331[(12)]);
var inst_29281__$1 = (state_29331[(2)]);
var inst_29282 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29281__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29283 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29281__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29284 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29281__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_29331__$1 = (function (){var statearr_29346 = state_29331;
(statearr_29346[(9)] = inst_29282);

(statearr_29346[(13)] = inst_29283);

(statearr_29346[(12)] = inst_29281__$1);

return statearr_29346;
})();
return cljs.core.async.ioc_alts_BANG_(state_29331__$1,(22),inst_29284);
} else {
if((state_val_29332 === (31))){
var inst_29313 = (state_29331[(2)]);
var state_29331__$1 = state_29331;
if(cljs.core.truth_(inst_29313)){
var statearr_29347_30535 = state_29331__$1;
(statearr_29347_30535[(1)] = (32));

} else {
var statearr_29348_30536 = state_29331__$1;
(statearr_29348_30536[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (32))){
var inst_29290 = (state_29331[(14)]);
var state_29331__$1 = state_29331;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29331__$1,(35),out,inst_29290);
} else {
if((state_val_29332 === (33))){
var inst_29281 = (state_29331[(12)]);
var inst_29258 = inst_29281;
var state_29331__$1 = (function (){var statearr_29349 = state_29331;
(statearr_29349[(7)] = inst_29258);

return statearr_29349;
})();
var statearr_29350_30537 = state_29331__$1;
(statearr_29350_30537[(2)] = null);

(statearr_29350_30537[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (13))){
var inst_29258 = (state_29331[(7)]);
var inst_29265 = inst_29258.cljs$lang$protocol_mask$partition0$;
var inst_29266 = (inst_29265 & (64));
var inst_29267 = inst_29258.cljs$core$ISeq$;
var inst_29268 = (cljs.core.PROTOCOL_SENTINEL === inst_29267);
var inst_29269 = ((inst_29266) || (inst_29268));
var state_29331__$1 = state_29331;
if(cljs.core.truth_(inst_29269)){
var statearr_29351_30538 = state_29331__$1;
(statearr_29351_30538[(1)] = (16));

} else {
var statearr_29352_30539 = state_29331__$1;
(statearr_29352_30539[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (22))){
var inst_29290 = (state_29331[(14)]);
var inst_29291 = (state_29331[(11)]);
var inst_29289 = (state_29331[(2)]);
var inst_29290__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29289,(0),null);
var inst_29291__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29289,(1),null);
var inst_29292 = (inst_29290__$1 == null);
var inst_29293 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29291__$1,change);
var inst_29294 = ((inst_29292) || (inst_29293));
var state_29331__$1 = (function (){var statearr_29353 = state_29331;
(statearr_29353[(14)] = inst_29290__$1);

(statearr_29353[(11)] = inst_29291__$1);

return statearr_29353;
})();
if(cljs.core.truth_(inst_29294)){
var statearr_29354_30540 = state_29331__$1;
(statearr_29354_30540[(1)] = (23));

} else {
var statearr_29355_30541 = state_29331__$1;
(statearr_29355_30541[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (36))){
var inst_29281 = (state_29331[(12)]);
var inst_29258 = inst_29281;
var state_29331__$1 = (function (){var statearr_29356 = state_29331;
(statearr_29356[(7)] = inst_29258);

return statearr_29356;
})();
var statearr_29357_30542 = state_29331__$1;
(statearr_29357_30542[(2)] = null);

(statearr_29357_30542[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (29))){
var inst_29305 = (state_29331[(10)]);
var state_29331__$1 = state_29331;
var statearr_29358_30543 = state_29331__$1;
(statearr_29358_30543[(2)] = inst_29305);

(statearr_29358_30543[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (6))){
var state_29331__$1 = state_29331;
var statearr_29359_30544 = state_29331__$1;
(statearr_29359_30544[(2)] = false);

(statearr_29359_30544[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (28))){
var inst_29301 = (state_29331[(2)]);
var inst_29302 = calc_state();
var inst_29258 = inst_29302;
var state_29331__$1 = (function (){var statearr_29360 = state_29331;
(statearr_29360[(15)] = inst_29301);

(statearr_29360[(7)] = inst_29258);

return statearr_29360;
})();
var statearr_29361_30545 = state_29331__$1;
(statearr_29361_30545[(2)] = null);

(statearr_29361_30545[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (25))){
var inst_29327 = (state_29331[(2)]);
var state_29331__$1 = state_29331;
var statearr_29362_30546 = state_29331__$1;
(statearr_29362_30546[(2)] = inst_29327);

(statearr_29362_30546[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (34))){
var inst_29325 = (state_29331[(2)]);
var state_29331__$1 = state_29331;
var statearr_29363_30547 = state_29331__$1;
(statearr_29363_30547[(2)] = inst_29325);

(statearr_29363_30547[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (17))){
var state_29331__$1 = state_29331;
var statearr_29364_30548 = state_29331__$1;
(statearr_29364_30548[(2)] = false);

(statearr_29364_30548[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (3))){
var state_29331__$1 = state_29331;
var statearr_29365_30549 = state_29331__$1;
(statearr_29365_30549[(2)] = false);

(statearr_29365_30549[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (12))){
var inst_29329 = (state_29331[(2)]);
var state_29331__$1 = state_29331;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29331__$1,inst_29329);
} else {
if((state_val_29332 === (2))){
var inst_29233 = (state_29331[(8)]);
var inst_29238 = inst_29233.cljs$lang$protocol_mask$partition0$;
var inst_29239 = (inst_29238 & (64));
var inst_29240 = inst_29233.cljs$core$ISeq$;
var inst_29241 = (cljs.core.PROTOCOL_SENTINEL === inst_29240);
var inst_29242 = ((inst_29239) || (inst_29241));
var state_29331__$1 = state_29331;
if(cljs.core.truth_(inst_29242)){
var statearr_29366_30550 = state_29331__$1;
(statearr_29366_30550[(1)] = (5));

} else {
var statearr_29367_30551 = state_29331__$1;
(statearr_29367_30551[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (23))){
var inst_29290 = (state_29331[(14)]);
var inst_29296 = (inst_29290 == null);
var state_29331__$1 = state_29331;
if(cljs.core.truth_(inst_29296)){
var statearr_29368_30552 = state_29331__$1;
(statearr_29368_30552[(1)] = (26));

} else {
var statearr_29369_30553 = state_29331__$1;
(statearr_29369_30553[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (35))){
var inst_29316 = (state_29331[(2)]);
var state_29331__$1 = state_29331;
if(cljs.core.truth_(inst_29316)){
var statearr_29370_30554 = state_29331__$1;
(statearr_29370_30554[(1)] = (36));

} else {
var statearr_29371_30555 = state_29331__$1;
(statearr_29371_30555[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (19))){
var inst_29258 = (state_29331[(7)]);
var inst_29278 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29258);
var state_29331__$1 = state_29331;
var statearr_29372_30556 = state_29331__$1;
(statearr_29372_30556[(2)] = inst_29278);

(statearr_29372_30556[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (11))){
var inst_29258 = (state_29331[(7)]);
var inst_29262 = (inst_29258 == null);
var inst_29263 = cljs.core.not(inst_29262);
var state_29331__$1 = state_29331;
if(inst_29263){
var statearr_29373_30557 = state_29331__$1;
(statearr_29373_30557[(1)] = (13));

} else {
var statearr_29374_30558 = state_29331__$1;
(statearr_29374_30558[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (9))){
var inst_29233 = (state_29331[(8)]);
var state_29331__$1 = state_29331;
var statearr_29375_30559 = state_29331__$1;
(statearr_29375_30559[(2)] = inst_29233);

(statearr_29375_30559[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (5))){
var state_29331__$1 = state_29331;
var statearr_29376_30560 = state_29331__$1;
(statearr_29376_30560[(2)] = true);

(statearr_29376_30560[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (14))){
var state_29331__$1 = state_29331;
var statearr_29377_30561 = state_29331__$1;
(statearr_29377_30561[(2)] = false);

(statearr_29377_30561[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (26))){
var inst_29291 = (state_29331[(11)]);
var inst_29298 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_29291);
var state_29331__$1 = state_29331;
var statearr_29378_30562 = state_29331__$1;
(statearr_29378_30562[(2)] = inst_29298);

(statearr_29378_30562[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (16))){
var state_29331__$1 = state_29331;
var statearr_29379_30563 = state_29331__$1;
(statearr_29379_30563[(2)] = true);

(statearr_29379_30563[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (38))){
var inst_29321 = (state_29331[(2)]);
var state_29331__$1 = state_29331;
var statearr_29380_30564 = state_29331__$1;
(statearr_29380_30564[(2)] = inst_29321);

(statearr_29380_30564[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (30))){
var inst_29282 = (state_29331[(9)]);
var inst_29283 = (state_29331[(13)]);
var inst_29291 = (state_29331[(11)]);
var inst_29308 = cljs.core.empty_QMARK_(inst_29282);
var inst_29309 = (inst_29283.cljs$core$IFn$_invoke$arity$1 ? inst_29283.cljs$core$IFn$_invoke$arity$1(inst_29291) : inst_29283.call(null,inst_29291));
var inst_29310 = cljs.core.not(inst_29309);
var inst_29311 = ((inst_29308) && (inst_29310));
var state_29331__$1 = state_29331;
var statearr_29381_30565 = state_29331__$1;
(statearr_29381_30565[(2)] = inst_29311);

(statearr_29381_30565[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (10))){
var inst_29233 = (state_29331[(8)]);
var inst_29254 = (state_29331[(2)]);
var inst_29255 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29254,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29256 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29254,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29257 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29254,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_29258 = inst_29233;
var state_29331__$1 = (function (){var statearr_29382 = state_29331;
(statearr_29382[(7)] = inst_29258);

(statearr_29382[(16)] = inst_29257);

(statearr_29382[(17)] = inst_29256);

(statearr_29382[(18)] = inst_29255);

return statearr_29382;
})();
var statearr_29383_30566 = state_29331__$1;
(statearr_29383_30566[(2)] = null);

(statearr_29383_30566[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (18))){
var inst_29273 = (state_29331[(2)]);
var state_29331__$1 = state_29331;
var statearr_29384_30567 = state_29331__$1;
(statearr_29384_30567[(2)] = inst_29273);

(statearr_29384_30567[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (37))){
var state_29331__$1 = state_29331;
var statearr_29385_30568 = state_29331__$1;
(statearr_29385_30568[(2)] = null);

(statearr_29385_30568[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29332 === (8))){
var inst_29233 = (state_29331[(8)]);
var inst_29251 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29233);
var state_29331__$1 = state_29331;
var statearr_29386_30569 = state_29331__$1;
(statearr_29386_30569[(2)] = inst_29251);

(statearr_29386_30569[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__28411__auto__ = null;
var cljs$core$async$mix_$_state_machine__28411__auto____0 = (function (){
var statearr_29387 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29387[(0)] = cljs$core$async$mix_$_state_machine__28411__auto__);

(statearr_29387[(1)] = (1));

return statearr_29387;
});
var cljs$core$async$mix_$_state_machine__28411__auto____1 = (function (state_29331){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_29331);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e29388){var ex__28414__auto__ = e29388;
var statearr_29389_30570 = state_29331;
(statearr_29389_30570[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_29331[(4)]))){
var statearr_29390_30571 = state_29331;
(statearr_29390_30571[(1)] = cljs.core.first((state_29331[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30572 = state_29331;
state_29331 = G__30572;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__28411__auto__ = function(state_29331){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__28411__auto____1.call(this,state_29331);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__28411__auto____0;
cljs$core$async$mix_$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__28411__auto____1;
return cljs$core$async$mix_$_state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_29391 = f__28447__auto__();
(statearr_29391[(6)] = c__28446__auto___30523);

return statearr_29391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_30574 = (function (p,v,ch,close_QMARK_){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4423__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4420__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4420__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_30574(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_30578 = (function (p,v,ch){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4423__auto__.call(null,p,v,ch));
} else {
var m__4420__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4420__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_30578(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_30579 = (function() {
var G__30580 = null;
var G__30580__1 = (function (p){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4423__auto__.call(null,p));
} else {
var m__4420__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4420__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__30580__2 = (function (p,v){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4423__auto__.call(null,p,v));
} else {
var m__4420__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4420__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__30580 = function(p,v){
switch(arguments.length){
case 1:
return G__30580__1.call(this,p);
case 2:
return G__30580__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__30580.cljs$core$IFn$_invoke$arity$1 = G__30580__1;
G__30580.cljs$core$IFn$_invoke$arity$2 = G__30580__2;
return G__30580;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__29393 = arguments.length;
switch (G__29393) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_30579(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_30579(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__29396 = arguments.length;
switch (G__29396) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4120__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__29394_SHARP_){
if(cljs.core.truth_((p1__29394_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29394_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__29394_SHARP_.call(null,topic)))){
return p1__29394_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__29394_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29397 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29397 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta29398){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta29398 = meta29398;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29397.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29399,meta29398__$1){
var self__ = this;
var _29399__$1 = this;
return (new cljs.core.async.t_cljs$core$async29397(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta29398__$1));
}));

(cljs.core.async.t_cljs$core$async29397.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29399){
var self__ = this;
var _29399__$1 = this;
return self__.meta29398;
}));

(cljs.core.async.t_cljs$core$async29397.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29397.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29397.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29397.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async29397.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async29397.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async29397.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async29397.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta29398","meta29398",214718487,null)], null);
}));

(cljs.core.async.t_cljs$core$async29397.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29397.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29397");

(cljs.core.async.t_cljs$core$async29397.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async29397");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29397.
 */
cljs.core.async.__GT_t_cljs$core$async29397 = (function cljs$core$async$__GT_t_cljs$core$async29397(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29398){
return (new cljs.core.async.t_cljs$core$async29397(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29398));
});

}

return (new cljs.core.async.t_cljs$core$async29397(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28446__auto___30592 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_29471){
var state_val_29472 = (state_29471[(1)]);
if((state_val_29472 === (7))){
var inst_29467 = (state_29471[(2)]);
var state_29471__$1 = state_29471;
var statearr_29473_30593 = state_29471__$1;
(statearr_29473_30593[(2)] = inst_29467);

(statearr_29473_30593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (20))){
var state_29471__$1 = state_29471;
var statearr_29474_30594 = state_29471__$1;
(statearr_29474_30594[(2)] = null);

(statearr_29474_30594[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (1))){
var state_29471__$1 = state_29471;
var statearr_29475_30598 = state_29471__$1;
(statearr_29475_30598[(2)] = null);

(statearr_29475_30598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (24))){
var inst_29450 = (state_29471[(7)]);
var inst_29459 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_29450);
var state_29471__$1 = state_29471;
var statearr_29476_30599 = state_29471__$1;
(statearr_29476_30599[(2)] = inst_29459);

(statearr_29476_30599[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (4))){
var inst_29402 = (state_29471[(8)]);
var inst_29402__$1 = (state_29471[(2)]);
var inst_29403 = (inst_29402__$1 == null);
var state_29471__$1 = (function (){var statearr_29477 = state_29471;
(statearr_29477[(8)] = inst_29402__$1);

return statearr_29477;
})();
if(cljs.core.truth_(inst_29403)){
var statearr_29478_30600 = state_29471__$1;
(statearr_29478_30600[(1)] = (5));

} else {
var statearr_29479_30601 = state_29471__$1;
(statearr_29479_30601[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (15))){
var inst_29444 = (state_29471[(2)]);
var state_29471__$1 = state_29471;
var statearr_29480_30602 = state_29471__$1;
(statearr_29480_30602[(2)] = inst_29444);

(statearr_29480_30602[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (21))){
var inst_29464 = (state_29471[(2)]);
var state_29471__$1 = (function (){var statearr_29481 = state_29471;
(statearr_29481[(9)] = inst_29464);

return statearr_29481;
})();
var statearr_29482_30603 = state_29471__$1;
(statearr_29482_30603[(2)] = null);

(statearr_29482_30603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (13))){
var inst_29426 = (state_29471[(10)]);
var inst_29428 = cljs.core.chunked_seq_QMARK_(inst_29426);
var state_29471__$1 = state_29471;
if(inst_29428){
var statearr_29483_30604 = state_29471__$1;
(statearr_29483_30604[(1)] = (16));

} else {
var statearr_29484_30605 = state_29471__$1;
(statearr_29484_30605[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (22))){
var inst_29456 = (state_29471[(2)]);
var state_29471__$1 = state_29471;
if(cljs.core.truth_(inst_29456)){
var statearr_29485_30606 = state_29471__$1;
(statearr_29485_30606[(1)] = (23));

} else {
var statearr_29486_30608 = state_29471__$1;
(statearr_29486_30608[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (6))){
var inst_29450 = (state_29471[(7)]);
var inst_29452 = (state_29471[(11)]);
var inst_29402 = (state_29471[(8)]);
var inst_29450__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_29402) : topic_fn.call(null,inst_29402));
var inst_29451 = cljs.core.deref(mults);
var inst_29452__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29451,inst_29450__$1);
var state_29471__$1 = (function (){var statearr_29487 = state_29471;
(statearr_29487[(7)] = inst_29450__$1);

(statearr_29487[(11)] = inst_29452__$1);

return statearr_29487;
})();
if(cljs.core.truth_(inst_29452__$1)){
var statearr_29488_30611 = state_29471__$1;
(statearr_29488_30611[(1)] = (19));

} else {
var statearr_29489_30612 = state_29471__$1;
(statearr_29489_30612[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (25))){
var inst_29461 = (state_29471[(2)]);
var state_29471__$1 = state_29471;
var statearr_29490_30613 = state_29471__$1;
(statearr_29490_30613[(2)] = inst_29461);

(statearr_29490_30613[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (17))){
var inst_29426 = (state_29471[(10)]);
var inst_29435 = cljs.core.first(inst_29426);
var inst_29436 = cljs.core.async.muxch_STAR_(inst_29435);
var inst_29437 = cljs.core.async.close_BANG_(inst_29436);
var inst_29438 = cljs.core.next(inst_29426);
var inst_29412 = inst_29438;
var inst_29413 = null;
var inst_29414 = (0);
var inst_29415 = (0);
var state_29471__$1 = (function (){var statearr_29491 = state_29471;
(statearr_29491[(12)] = inst_29413);

(statearr_29491[(13)] = inst_29414);

(statearr_29491[(14)] = inst_29412);

(statearr_29491[(15)] = inst_29415);

(statearr_29491[(16)] = inst_29437);

return statearr_29491;
})();
var statearr_29492_30614 = state_29471__$1;
(statearr_29492_30614[(2)] = null);

(statearr_29492_30614[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (3))){
var inst_29469 = (state_29471[(2)]);
var state_29471__$1 = state_29471;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29471__$1,inst_29469);
} else {
if((state_val_29472 === (12))){
var inst_29446 = (state_29471[(2)]);
var state_29471__$1 = state_29471;
var statearr_29493_30615 = state_29471__$1;
(statearr_29493_30615[(2)] = inst_29446);

(statearr_29493_30615[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (2))){
var state_29471__$1 = state_29471;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29471__$1,(4),ch);
} else {
if((state_val_29472 === (23))){
var state_29471__$1 = state_29471;
var statearr_29494_30616 = state_29471__$1;
(statearr_29494_30616[(2)] = null);

(statearr_29494_30616[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (19))){
var inst_29452 = (state_29471[(11)]);
var inst_29402 = (state_29471[(8)]);
var inst_29454 = cljs.core.async.muxch_STAR_(inst_29452);
var state_29471__$1 = state_29471;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29471__$1,(22),inst_29454,inst_29402);
} else {
if((state_val_29472 === (11))){
var inst_29426 = (state_29471[(10)]);
var inst_29412 = (state_29471[(14)]);
var inst_29426__$1 = cljs.core.seq(inst_29412);
var state_29471__$1 = (function (){var statearr_29495 = state_29471;
(statearr_29495[(10)] = inst_29426__$1);

return statearr_29495;
})();
if(inst_29426__$1){
var statearr_29496_30617 = state_29471__$1;
(statearr_29496_30617[(1)] = (13));

} else {
var statearr_29497_30618 = state_29471__$1;
(statearr_29497_30618[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (9))){
var inst_29448 = (state_29471[(2)]);
var state_29471__$1 = state_29471;
var statearr_29498_30619 = state_29471__$1;
(statearr_29498_30619[(2)] = inst_29448);

(statearr_29498_30619[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (5))){
var inst_29409 = cljs.core.deref(mults);
var inst_29410 = cljs.core.vals(inst_29409);
var inst_29411 = cljs.core.seq(inst_29410);
var inst_29412 = inst_29411;
var inst_29413 = null;
var inst_29414 = (0);
var inst_29415 = (0);
var state_29471__$1 = (function (){var statearr_29499 = state_29471;
(statearr_29499[(12)] = inst_29413);

(statearr_29499[(13)] = inst_29414);

(statearr_29499[(14)] = inst_29412);

(statearr_29499[(15)] = inst_29415);

return statearr_29499;
})();
var statearr_29500_30623 = state_29471__$1;
(statearr_29500_30623[(2)] = null);

(statearr_29500_30623[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (14))){
var state_29471__$1 = state_29471;
var statearr_29504_30624 = state_29471__$1;
(statearr_29504_30624[(2)] = null);

(statearr_29504_30624[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (16))){
var inst_29426 = (state_29471[(10)]);
var inst_29430 = cljs.core.chunk_first(inst_29426);
var inst_29431 = cljs.core.chunk_rest(inst_29426);
var inst_29432 = cljs.core.count(inst_29430);
var inst_29412 = inst_29431;
var inst_29413 = inst_29430;
var inst_29414 = inst_29432;
var inst_29415 = (0);
var state_29471__$1 = (function (){var statearr_29505 = state_29471;
(statearr_29505[(12)] = inst_29413);

(statearr_29505[(13)] = inst_29414);

(statearr_29505[(14)] = inst_29412);

(statearr_29505[(15)] = inst_29415);

return statearr_29505;
})();
var statearr_29506_30625 = state_29471__$1;
(statearr_29506_30625[(2)] = null);

(statearr_29506_30625[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (10))){
var inst_29413 = (state_29471[(12)]);
var inst_29414 = (state_29471[(13)]);
var inst_29412 = (state_29471[(14)]);
var inst_29415 = (state_29471[(15)]);
var inst_29420 = cljs.core._nth(inst_29413,inst_29415);
var inst_29421 = cljs.core.async.muxch_STAR_(inst_29420);
var inst_29422 = cljs.core.async.close_BANG_(inst_29421);
var inst_29423 = (inst_29415 + (1));
var tmp29501 = inst_29413;
var tmp29502 = inst_29414;
var tmp29503 = inst_29412;
var inst_29412__$1 = tmp29503;
var inst_29413__$1 = tmp29501;
var inst_29414__$1 = tmp29502;
var inst_29415__$1 = inst_29423;
var state_29471__$1 = (function (){var statearr_29507 = state_29471;
(statearr_29507[(12)] = inst_29413__$1);

(statearr_29507[(13)] = inst_29414__$1);

(statearr_29507[(17)] = inst_29422);

(statearr_29507[(14)] = inst_29412__$1);

(statearr_29507[(15)] = inst_29415__$1);

return statearr_29507;
})();
var statearr_29508_30626 = state_29471__$1;
(statearr_29508_30626[(2)] = null);

(statearr_29508_30626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (18))){
var inst_29441 = (state_29471[(2)]);
var state_29471__$1 = state_29471;
var statearr_29509_30629 = state_29471__$1;
(statearr_29509_30629[(2)] = inst_29441);

(statearr_29509_30629[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29472 === (8))){
var inst_29414 = (state_29471[(13)]);
var inst_29415 = (state_29471[(15)]);
var inst_29417 = (inst_29415 < inst_29414);
var inst_29418 = inst_29417;
var state_29471__$1 = state_29471;
if(cljs.core.truth_(inst_29418)){
var statearr_29510_30631 = state_29471__$1;
(statearr_29510_30631[(1)] = (10));

} else {
var statearr_29511_30632 = state_29471__$1;
(statearr_29511_30632[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28411__auto__ = null;
var cljs$core$async$state_machine__28411__auto____0 = (function (){
var statearr_29512 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29512[(0)] = cljs$core$async$state_machine__28411__auto__);

(statearr_29512[(1)] = (1));

return statearr_29512;
});
var cljs$core$async$state_machine__28411__auto____1 = (function (state_29471){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_29471);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e29513){var ex__28414__auto__ = e29513;
var statearr_29514_30633 = state_29471;
(statearr_29514_30633[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_29471[(4)]))){
var statearr_29515_30636 = state_29471;
(statearr_29515_30636[(1)] = cljs.core.first((state_29471[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30638 = state_29471;
state_29471 = G__30638;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$state_machine__28411__auto__ = function(state_29471){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28411__auto____1.call(this,state_29471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28411__auto____0;
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28411__auto____1;
return cljs$core$async$state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_29516 = f__28447__auto__();
(statearr_29516[(6)] = c__28446__auto___30592);

return statearr_29516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__29518 = arguments.length;
switch (G__29518) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__29520 = arguments.length;
switch (G__29520) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__29522 = arguments.length;
switch (G__29522) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__28446__auto___30642 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_29565){
var state_val_29566 = (state_29565[(1)]);
if((state_val_29566 === (7))){
var state_29565__$1 = state_29565;
var statearr_29567_30643 = state_29565__$1;
(statearr_29567_30643[(2)] = null);

(statearr_29567_30643[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29566 === (1))){
var state_29565__$1 = state_29565;
var statearr_29568_30644 = state_29565__$1;
(statearr_29568_30644[(2)] = null);

(statearr_29568_30644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29566 === (4))){
var inst_29525 = (state_29565[(7)]);
var inst_29526 = (state_29565[(8)]);
var inst_29528 = (inst_29526 < inst_29525);
var state_29565__$1 = state_29565;
if(cljs.core.truth_(inst_29528)){
var statearr_29569_30645 = state_29565__$1;
(statearr_29569_30645[(1)] = (6));

} else {
var statearr_29570_30646 = state_29565__$1;
(statearr_29570_30646[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29566 === (15))){
var inst_29551 = (state_29565[(9)]);
var inst_29556 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_29551);
var state_29565__$1 = state_29565;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29565__$1,(17),out,inst_29556);
} else {
if((state_val_29566 === (13))){
var inst_29551 = (state_29565[(9)]);
var inst_29551__$1 = (state_29565[(2)]);
var inst_29552 = cljs.core.some(cljs.core.nil_QMARK_,inst_29551__$1);
var state_29565__$1 = (function (){var statearr_29571 = state_29565;
(statearr_29571[(9)] = inst_29551__$1);

return statearr_29571;
})();
if(cljs.core.truth_(inst_29552)){
var statearr_29572_30647 = state_29565__$1;
(statearr_29572_30647[(1)] = (14));

} else {
var statearr_29573_30648 = state_29565__$1;
(statearr_29573_30648[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29566 === (6))){
var state_29565__$1 = state_29565;
var statearr_29574_30649 = state_29565__$1;
(statearr_29574_30649[(2)] = null);

(statearr_29574_30649[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29566 === (17))){
var inst_29558 = (state_29565[(2)]);
var state_29565__$1 = (function (){var statearr_29576 = state_29565;
(statearr_29576[(10)] = inst_29558);

return statearr_29576;
})();
var statearr_29577_30650 = state_29565__$1;
(statearr_29577_30650[(2)] = null);

(statearr_29577_30650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29566 === (3))){
var inst_29563 = (state_29565[(2)]);
var state_29565__$1 = state_29565;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29565__$1,inst_29563);
} else {
if((state_val_29566 === (12))){
var _ = (function (){var statearr_29578 = state_29565;
(statearr_29578[(4)] = cljs.core.rest((state_29565[(4)])));

return statearr_29578;
})();
var state_29565__$1 = state_29565;
var ex29575 = (state_29565__$1[(2)]);
var statearr_29579_30651 = state_29565__$1;
(statearr_29579_30651[(5)] = ex29575);


if((ex29575 instanceof Object)){
var statearr_29580_30652 = state_29565__$1;
(statearr_29580_30652[(1)] = (11));

(statearr_29580_30652[(5)] = null);

} else {
throw ex29575;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29566 === (2))){
var inst_29524 = cljs.core.reset_BANG_(dctr,cnt);
var inst_29525 = cnt;
var inst_29526 = (0);
var state_29565__$1 = (function (){var statearr_29581 = state_29565;
(statearr_29581[(11)] = inst_29524);

(statearr_29581[(7)] = inst_29525);

(statearr_29581[(8)] = inst_29526);

return statearr_29581;
})();
var statearr_29582_30653 = state_29565__$1;
(statearr_29582_30653[(2)] = null);

(statearr_29582_30653[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29566 === (11))){
var inst_29530 = (state_29565[(2)]);
var inst_29531 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_29565__$1 = (function (){var statearr_29583 = state_29565;
(statearr_29583[(12)] = inst_29530);

return statearr_29583;
})();
var statearr_29584_30654 = state_29565__$1;
(statearr_29584_30654[(2)] = inst_29531);

(statearr_29584_30654[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29566 === (9))){
var inst_29526 = (state_29565[(8)]);
var _ = (function (){var statearr_29585 = state_29565;
(statearr_29585[(4)] = cljs.core.cons((12),(state_29565[(4)])));

return statearr_29585;
})();
var inst_29537 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_29526) : chs__$1.call(null,inst_29526));
var inst_29538 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_29526) : done.call(null,inst_29526));
var inst_29539 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_29537,inst_29538);
var ___$1 = (function (){var statearr_29586 = state_29565;
(statearr_29586[(4)] = cljs.core.rest((state_29565[(4)])));

return statearr_29586;
})();
var state_29565__$1 = state_29565;
var statearr_29587_30655 = state_29565__$1;
(statearr_29587_30655[(2)] = inst_29539);

(statearr_29587_30655[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29566 === (5))){
var inst_29549 = (state_29565[(2)]);
var state_29565__$1 = (function (){var statearr_29588 = state_29565;
(statearr_29588[(13)] = inst_29549);

return statearr_29588;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29565__$1,(13),dchan);
} else {
if((state_val_29566 === (14))){
var inst_29554 = cljs.core.async.close_BANG_(out);
var state_29565__$1 = state_29565;
var statearr_29589_30656 = state_29565__$1;
(statearr_29589_30656[(2)] = inst_29554);

(statearr_29589_30656[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29566 === (16))){
var inst_29561 = (state_29565[(2)]);
var state_29565__$1 = state_29565;
var statearr_29590_30657 = state_29565__$1;
(statearr_29590_30657[(2)] = inst_29561);

(statearr_29590_30657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29566 === (10))){
var inst_29526 = (state_29565[(8)]);
var inst_29542 = (state_29565[(2)]);
var inst_29543 = (inst_29526 + (1));
var inst_29526__$1 = inst_29543;
var state_29565__$1 = (function (){var statearr_29591 = state_29565;
(statearr_29591[(14)] = inst_29542);

(statearr_29591[(8)] = inst_29526__$1);

return statearr_29591;
})();
var statearr_29592_30658 = state_29565__$1;
(statearr_29592_30658[(2)] = null);

(statearr_29592_30658[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29566 === (8))){
var inst_29547 = (state_29565[(2)]);
var state_29565__$1 = state_29565;
var statearr_29593_30659 = state_29565__$1;
(statearr_29593_30659[(2)] = inst_29547);

(statearr_29593_30659[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28411__auto__ = null;
var cljs$core$async$state_machine__28411__auto____0 = (function (){
var statearr_29594 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29594[(0)] = cljs$core$async$state_machine__28411__auto__);

(statearr_29594[(1)] = (1));

return statearr_29594;
});
var cljs$core$async$state_machine__28411__auto____1 = (function (state_29565){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_29565);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e29595){var ex__28414__auto__ = e29595;
var statearr_29596_30660 = state_29565;
(statearr_29596_30660[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_29565[(4)]))){
var statearr_29597_30661 = state_29565;
(statearr_29597_30661[(1)] = cljs.core.first((state_29565[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30662 = state_29565;
state_29565 = G__30662;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$state_machine__28411__auto__ = function(state_29565){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28411__auto____1.call(this,state_29565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28411__auto____0;
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28411__auto____1;
return cljs$core$async$state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_29598 = f__28447__auto__();
(statearr_29598[(6)] = c__28446__auto___30642);

return statearr_29598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__29601 = arguments.length;
switch (G__29601) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28446__auto___30664 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_29633){
var state_val_29634 = (state_29633[(1)]);
if((state_val_29634 === (7))){
var inst_29613 = (state_29633[(7)]);
var inst_29612 = (state_29633[(8)]);
var inst_29612__$1 = (state_29633[(2)]);
var inst_29613__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29612__$1,(0),null);
var inst_29614 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29612__$1,(1),null);
var inst_29615 = (inst_29613__$1 == null);
var state_29633__$1 = (function (){var statearr_29635 = state_29633;
(statearr_29635[(9)] = inst_29614);

(statearr_29635[(7)] = inst_29613__$1);

(statearr_29635[(8)] = inst_29612__$1);

return statearr_29635;
})();
if(cljs.core.truth_(inst_29615)){
var statearr_29636_30665 = state_29633__$1;
(statearr_29636_30665[(1)] = (8));

} else {
var statearr_29637_30666 = state_29633__$1;
(statearr_29637_30666[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29634 === (1))){
var inst_29602 = cljs.core.vec(chs);
var inst_29603 = inst_29602;
var state_29633__$1 = (function (){var statearr_29638 = state_29633;
(statearr_29638[(10)] = inst_29603);

return statearr_29638;
})();
var statearr_29639_30667 = state_29633__$1;
(statearr_29639_30667[(2)] = null);

(statearr_29639_30667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29634 === (4))){
var inst_29603 = (state_29633[(10)]);
var state_29633__$1 = state_29633;
return cljs.core.async.ioc_alts_BANG_(state_29633__$1,(7),inst_29603);
} else {
if((state_val_29634 === (6))){
var inst_29629 = (state_29633[(2)]);
var state_29633__$1 = state_29633;
var statearr_29640_30668 = state_29633__$1;
(statearr_29640_30668[(2)] = inst_29629);

(statearr_29640_30668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29634 === (3))){
var inst_29631 = (state_29633[(2)]);
var state_29633__$1 = state_29633;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29633__$1,inst_29631);
} else {
if((state_val_29634 === (2))){
var inst_29603 = (state_29633[(10)]);
var inst_29605 = cljs.core.count(inst_29603);
var inst_29606 = (inst_29605 > (0));
var state_29633__$1 = state_29633;
if(cljs.core.truth_(inst_29606)){
var statearr_29642_30669 = state_29633__$1;
(statearr_29642_30669[(1)] = (4));

} else {
var statearr_29643_30670 = state_29633__$1;
(statearr_29643_30670[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29634 === (11))){
var inst_29603 = (state_29633[(10)]);
var inst_29622 = (state_29633[(2)]);
var tmp29641 = inst_29603;
var inst_29603__$1 = tmp29641;
var state_29633__$1 = (function (){var statearr_29644 = state_29633;
(statearr_29644[(10)] = inst_29603__$1);

(statearr_29644[(11)] = inst_29622);

return statearr_29644;
})();
var statearr_29645_30671 = state_29633__$1;
(statearr_29645_30671[(2)] = null);

(statearr_29645_30671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29634 === (9))){
var inst_29613 = (state_29633[(7)]);
var state_29633__$1 = state_29633;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29633__$1,(11),out,inst_29613);
} else {
if((state_val_29634 === (5))){
var inst_29627 = cljs.core.async.close_BANG_(out);
var state_29633__$1 = state_29633;
var statearr_29646_30672 = state_29633__$1;
(statearr_29646_30672[(2)] = inst_29627);

(statearr_29646_30672[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29634 === (10))){
var inst_29625 = (state_29633[(2)]);
var state_29633__$1 = state_29633;
var statearr_29647_30677 = state_29633__$1;
(statearr_29647_30677[(2)] = inst_29625);

(statearr_29647_30677[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29634 === (8))){
var inst_29614 = (state_29633[(9)]);
var inst_29613 = (state_29633[(7)]);
var inst_29612 = (state_29633[(8)]);
var inst_29603 = (state_29633[(10)]);
var inst_29617 = (function (){var cs = inst_29603;
var vec__29608 = inst_29612;
var v = inst_29613;
var c = inst_29614;
return (function (p1__29599_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__29599_SHARP_);
});
})();
var inst_29618 = cljs.core.filterv(inst_29617,inst_29603);
var inst_29603__$1 = inst_29618;
var state_29633__$1 = (function (){var statearr_29648 = state_29633;
(statearr_29648[(10)] = inst_29603__$1);

return statearr_29648;
})();
var statearr_29649_30678 = state_29633__$1;
(statearr_29649_30678[(2)] = null);

(statearr_29649_30678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28411__auto__ = null;
var cljs$core$async$state_machine__28411__auto____0 = (function (){
var statearr_29650 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29650[(0)] = cljs$core$async$state_machine__28411__auto__);

(statearr_29650[(1)] = (1));

return statearr_29650;
});
var cljs$core$async$state_machine__28411__auto____1 = (function (state_29633){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_29633);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e29651){var ex__28414__auto__ = e29651;
var statearr_29652_30679 = state_29633;
(statearr_29652_30679[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_29633[(4)]))){
var statearr_29653_30680 = state_29633;
(statearr_29653_30680[(1)] = cljs.core.first((state_29633[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30681 = state_29633;
state_29633 = G__30681;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$state_machine__28411__auto__ = function(state_29633){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28411__auto____1.call(this,state_29633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28411__auto____0;
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28411__auto____1;
return cljs$core$async$state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_29654 = f__28447__auto__();
(statearr_29654[(6)] = c__28446__auto___30664);

return statearr_29654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__29656 = arguments.length;
switch (G__29656) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28446__auto___30683 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_29680){
var state_val_29681 = (state_29680[(1)]);
if((state_val_29681 === (7))){
var inst_29662 = (state_29680[(7)]);
var inst_29662__$1 = (state_29680[(2)]);
var inst_29663 = (inst_29662__$1 == null);
var inst_29664 = cljs.core.not(inst_29663);
var state_29680__$1 = (function (){var statearr_29682 = state_29680;
(statearr_29682[(7)] = inst_29662__$1);

return statearr_29682;
})();
if(inst_29664){
var statearr_29683_30684 = state_29680__$1;
(statearr_29683_30684[(1)] = (8));

} else {
var statearr_29684_30685 = state_29680__$1;
(statearr_29684_30685[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29681 === (1))){
var inst_29657 = (0);
var state_29680__$1 = (function (){var statearr_29685 = state_29680;
(statearr_29685[(8)] = inst_29657);

return statearr_29685;
})();
var statearr_29686_30686 = state_29680__$1;
(statearr_29686_30686[(2)] = null);

(statearr_29686_30686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29681 === (4))){
var state_29680__$1 = state_29680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29680__$1,(7),ch);
} else {
if((state_val_29681 === (6))){
var inst_29675 = (state_29680[(2)]);
var state_29680__$1 = state_29680;
var statearr_29687_30687 = state_29680__$1;
(statearr_29687_30687[(2)] = inst_29675);

(statearr_29687_30687[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29681 === (3))){
var inst_29677 = (state_29680[(2)]);
var inst_29678 = cljs.core.async.close_BANG_(out);
var state_29680__$1 = (function (){var statearr_29688 = state_29680;
(statearr_29688[(9)] = inst_29677);

return statearr_29688;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29680__$1,inst_29678);
} else {
if((state_val_29681 === (2))){
var inst_29657 = (state_29680[(8)]);
var inst_29659 = (inst_29657 < n);
var state_29680__$1 = state_29680;
if(cljs.core.truth_(inst_29659)){
var statearr_29689_30688 = state_29680__$1;
(statearr_29689_30688[(1)] = (4));

} else {
var statearr_29690_30689 = state_29680__$1;
(statearr_29690_30689[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29681 === (11))){
var inst_29657 = (state_29680[(8)]);
var inst_29667 = (state_29680[(2)]);
var inst_29668 = (inst_29657 + (1));
var inst_29657__$1 = inst_29668;
var state_29680__$1 = (function (){var statearr_29691 = state_29680;
(statearr_29691[(8)] = inst_29657__$1);

(statearr_29691[(10)] = inst_29667);

return statearr_29691;
})();
var statearr_29692_30690 = state_29680__$1;
(statearr_29692_30690[(2)] = null);

(statearr_29692_30690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29681 === (9))){
var state_29680__$1 = state_29680;
var statearr_29693_30691 = state_29680__$1;
(statearr_29693_30691[(2)] = null);

(statearr_29693_30691[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29681 === (5))){
var state_29680__$1 = state_29680;
var statearr_29694_30692 = state_29680__$1;
(statearr_29694_30692[(2)] = null);

(statearr_29694_30692[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29681 === (10))){
var inst_29672 = (state_29680[(2)]);
var state_29680__$1 = state_29680;
var statearr_29695_30693 = state_29680__$1;
(statearr_29695_30693[(2)] = inst_29672);

(statearr_29695_30693[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29681 === (8))){
var inst_29662 = (state_29680[(7)]);
var state_29680__$1 = state_29680;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29680__$1,(11),out,inst_29662);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28411__auto__ = null;
var cljs$core$async$state_machine__28411__auto____0 = (function (){
var statearr_29696 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29696[(0)] = cljs$core$async$state_machine__28411__auto__);

(statearr_29696[(1)] = (1));

return statearr_29696;
});
var cljs$core$async$state_machine__28411__auto____1 = (function (state_29680){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_29680);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e29697){var ex__28414__auto__ = e29697;
var statearr_29698_30694 = state_29680;
(statearr_29698_30694[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_29680[(4)]))){
var statearr_29699_30695 = state_29680;
(statearr_29699_30695[(1)] = cljs.core.first((state_29680[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30696 = state_29680;
state_29680 = G__30696;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$state_machine__28411__auto__ = function(state_29680){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28411__auto____1.call(this,state_29680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28411__auto____0;
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28411__auto____1;
return cljs$core$async$state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_29700 = f__28447__auto__();
(statearr_29700[(6)] = c__28446__auto___30683);

return statearr_29700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29702 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29702 = (function (f,ch,meta29703){
this.f = f;
this.ch = ch;
this.meta29703 = meta29703;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29702.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29704,meta29703__$1){
var self__ = this;
var _29704__$1 = this;
return (new cljs.core.async.t_cljs$core$async29702(self__.f,self__.ch,meta29703__$1));
}));

(cljs.core.async.t_cljs$core$async29702.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29704){
var self__ = this;
var _29704__$1 = this;
return self__.meta29703;
}));

(cljs.core.async.t_cljs$core$async29702.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29702.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async29702.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async29702.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29702.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29705 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29705 = (function (f,ch,meta29703,_,fn1,meta29706){
this.f = f;
this.ch = ch;
this.meta29703 = meta29703;
this._ = _;
this.fn1 = fn1;
this.meta29706 = meta29706;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29705.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29707,meta29706__$1){
var self__ = this;
var _29707__$1 = this;
return (new cljs.core.async.t_cljs$core$async29705(self__.f,self__.ch,self__.meta29703,self__._,self__.fn1,meta29706__$1));
}));

(cljs.core.async.t_cljs$core$async29705.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29707){
var self__ = this;
var _29707__$1 = this;
return self__.meta29706;
}));

(cljs.core.async.t_cljs$core$async29705.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29705.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async29705.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async29705.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__29701_SHARP_){
var G__29708 = (((p1__29701_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__29701_SHARP_) : self__.f.call(null,p1__29701_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__29708) : f1.call(null,G__29708));
});
}));

(cljs.core.async.t_cljs$core$async29705.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29703","meta29703",1373601453,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async29702","cljs.core.async/t_cljs$core$async29702",-284344281,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta29706","meta29706",1433100600,null)], null);
}));

(cljs.core.async.t_cljs$core$async29705.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29705.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29705");

(cljs.core.async.t_cljs$core$async29705.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async29705");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29705.
 */
cljs.core.async.__GT_t_cljs$core$async29705 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async29705(f__$1,ch__$1,meta29703__$1,___$2,fn1__$1,meta29706){
return (new cljs.core.async.t_cljs$core$async29705(f__$1,ch__$1,meta29703__$1,___$2,fn1__$1,meta29706));
});

}

return (new cljs.core.async.t_cljs$core$async29705(self__.f,self__.ch,self__.meta29703,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4109__auto__ = ret;
if(cljs.core.truth_(and__4109__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4109__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__29709 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__29709) : self__.f.call(null,G__29709));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async29702.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29702.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async29702.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29703","meta29703",1373601453,null)], null);
}));

(cljs.core.async.t_cljs$core$async29702.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29702.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29702");

(cljs.core.async.t_cljs$core$async29702.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async29702");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29702.
 */
cljs.core.async.__GT_t_cljs$core$async29702 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async29702(f__$1,ch__$1,meta29703){
return (new cljs.core.async.t_cljs$core$async29702(f__$1,ch__$1,meta29703));
});

}

return (new cljs.core.async.t_cljs$core$async29702(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29710 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29710 = (function (f,ch,meta29711){
this.f = f;
this.ch = ch;
this.meta29711 = meta29711;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29710.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29712,meta29711__$1){
var self__ = this;
var _29712__$1 = this;
return (new cljs.core.async.t_cljs$core$async29710(self__.f,self__.ch,meta29711__$1));
}));

(cljs.core.async.t_cljs$core$async29710.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29712){
var self__ = this;
var _29712__$1 = this;
return self__.meta29711;
}));

(cljs.core.async.t_cljs$core$async29710.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29710.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async29710.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29710.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async29710.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29710.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async29710.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29711","meta29711",-993170383,null)], null);
}));

(cljs.core.async.t_cljs$core$async29710.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29710.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29710");

(cljs.core.async.t_cljs$core$async29710.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async29710");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29710.
 */
cljs.core.async.__GT_t_cljs$core$async29710 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async29710(f__$1,ch__$1,meta29711){
return (new cljs.core.async.t_cljs$core$async29710(f__$1,ch__$1,meta29711));
});

}

return (new cljs.core.async.t_cljs$core$async29710(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29713 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29713 = (function (p,ch,meta29714){
this.p = p;
this.ch = ch;
this.meta29714 = meta29714;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29713.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29715,meta29714__$1){
var self__ = this;
var _29715__$1 = this;
return (new cljs.core.async.t_cljs$core$async29713(self__.p,self__.ch,meta29714__$1));
}));

(cljs.core.async.t_cljs$core$async29713.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29715){
var self__ = this;
var _29715__$1 = this;
return self__.meta29714;
}));

(cljs.core.async.t_cljs$core$async29713.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29713.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async29713.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async29713.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29713.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async29713.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29713.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async29713.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29714","meta29714",1356687145,null)], null);
}));

(cljs.core.async.t_cljs$core$async29713.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29713.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29713");

(cljs.core.async.t_cljs$core$async29713.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async29713");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29713.
 */
cljs.core.async.__GT_t_cljs$core$async29713 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async29713(p__$1,ch__$1,meta29714){
return (new cljs.core.async.t_cljs$core$async29713(p__$1,ch__$1,meta29714));
});

}

return (new cljs.core.async.t_cljs$core$async29713(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__29717 = arguments.length;
switch (G__29717) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28446__auto___30705 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_29738){
var state_val_29739 = (state_29738[(1)]);
if((state_val_29739 === (7))){
var inst_29734 = (state_29738[(2)]);
var state_29738__$1 = state_29738;
var statearr_29740_30706 = state_29738__$1;
(statearr_29740_30706[(2)] = inst_29734);

(statearr_29740_30706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29739 === (1))){
var state_29738__$1 = state_29738;
var statearr_29741_30707 = state_29738__$1;
(statearr_29741_30707[(2)] = null);

(statearr_29741_30707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29739 === (4))){
var inst_29720 = (state_29738[(7)]);
var inst_29720__$1 = (state_29738[(2)]);
var inst_29721 = (inst_29720__$1 == null);
var state_29738__$1 = (function (){var statearr_29742 = state_29738;
(statearr_29742[(7)] = inst_29720__$1);

return statearr_29742;
})();
if(cljs.core.truth_(inst_29721)){
var statearr_29743_30708 = state_29738__$1;
(statearr_29743_30708[(1)] = (5));

} else {
var statearr_29744_30709 = state_29738__$1;
(statearr_29744_30709[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29739 === (6))){
var inst_29720 = (state_29738[(7)]);
var inst_29725 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_29720) : p.call(null,inst_29720));
var state_29738__$1 = state_29738;
if(cljs.core.truth_(inst_29725)){
var statearr_29745_30710 = state_29738__$1;
(statearr_29745_30710[(1)] = (8));

} else {
var statearr_29746_30711 = state_29738__$1;
(statearr_29746_30711[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29739 === (3))){
var inst_29736 = (state_29738[(2)]);
var state_29738__$1 = state_29738;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29738__$1,inst_29736);
} else {
if((state_val_29739 === (2))){
var state_29738__$1 = state_29738;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29738__$1,(4),ch);
} else {
if((state_val_29739 === (11))){
var inst_29728 = (state_29738[(2)]);
var state_29738__$1 = state_29738;
var statearr_29747_30712 = state_29738__$1;
(statearr_29747_30712[(2)] = inst_29728);

(statearr_29747_30712[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29739 === (9))){
var state_29738__$1 = state_29738;
var statearr_29748_30713 = state_29738__$1;
(statearr_29748_30713[(2)] = null);

(statearr_29748_30713[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29739 === (5))){
var inst_29723 = cljs.core.async.close_BANG_(out);
var state_29738__$1 = state_29738;
var statearr_29749_30714 = state_29738__$1;
(statearr_29749_30714[(2)] = inst_29723);

(statearr_29749_30714[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29739 === (10))){
var inst_29731 = (state_29738[(2)]);
var state_29738__$1 = (function (){var statearr_29750 = state_29738;
(statearr_29750[(8)] = inst_29731);

return statearr_29750;
})();
var statearr_29751_30715 = state_29738__$1;
(statearr_29751_30715[(2)] = null);

(statearr_29751_30715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29739 === (8))){
var inst_29720 = (state_29738[(7)]);
var state_29738__$1 = state_29738;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29738__$1,(11),out,inst_29720);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28411__auto__ = null;
var cljs$core$async$state_machine__28411__auto____0 = (function (){
var statearr_29752 = [null,null,null,null,null,null,null,null,null];
(statearr_29752[(0)] = cljs$core$async$state_machine__28411__auto__);

(statearr_29752[(1)] = (1));

return statearr_29752;
});
var cljs$core$async$state_machine__28411__auto____1 = (function (state_29738){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_29738);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e29753){var ex__28414__auto__ = e29753;
var statearr_29754_30719 = state_29738;
(statearr_29754_30719[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_29738[(4)]))){
var statearr_29755_30720 = state_29738;
(statearr_29755_30720[(1)] = cljs.core.first((state_29738[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30721 = state_29738;
state_29738 = G__30721;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$state_machine__28411__auto__ = function(state_29738){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28411__auto____1.call(this,state_29738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28411__auto____0;
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28411__auto____1;
return cljs$core$async$state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_29756 = f__28447__auto__();
(statearr_29756[(6)] = c__28446__auto___30705);

return statearr_29756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__29758 = arguments.length;
switch (G__29758) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__28446__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_29820){
var state_val_29821 = (state_29820[(1)]);
if((state_val_29821 === (7))){
var inst_29816 = (state_29820[(2)]);
var state_29820__$1 = state_29820;
var statearr_29822_30724 = state_29820__$1;
(statearr_29822_30724[(2)] = inst_29816);

(statearr_29822_30724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (20))){
var inst_29786 = (state_29820[(7)]);
var inst_29797 = (state_29820[(2)]);
var inst_29798 = cljs.core.next(inst_29786);
var inst_29772 = inst_29798;
var inst_29773 = null;
var inst_29774 = (0);
var inst_29775 = (0);
var state_29820__$1 = (function (){var statearr_29823 = state_29820;
(statearr_29823[(8)] = inst_29797);

(statearr_29823[(9)] = inst_29775);

(statearr_29823[(10)] = inst_29773);

(statearr_29823[(11)] = inst_29772);

(statearr_29823[(12)] = inst_29774);

return statearr_29823;
})();
var statearr_29824_30725 = state_29820__$1;
(statearr_29824_30725[(2)] = null);

(statearr_29824_30725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (1))){
var state_29820__$1 = state_29820;
var statearr_29825_30726 = state_29820__$1;
(statearr_29825_30726[(2)] = null);

(statearr_29825_30726[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (4))){
var inst_29761 = (state_29820[(13)]);
var inst_29761__$1 = (state_29820[(2)]);
var inst_29762 = (inst_29761__$1 == null);
var state_29820__$1 = (function (){var statearr_29826 = state_29820;
(statearr_29826[(13)] = inst_29761__$1);

return statearr_29826;
})();
if(cljs.core.truth_(inst_29762)){
var statearr_29827_30727 = state_29820__$1;
(statearr_29827_30727[(1)] = (5));

} else {
var statearr_29828_30728 = state_29820__$1;
(statearr_29828_30728[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (15))){
var state_29820__$1 = state_29820;
var statearr_29832_30729 = state_29820__$1;
(statearr_29832_30729[(2)] = null);

(statearr_29832_30729[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (21))){
var state_29820__$1 = state_29820;
var statearr_29833_30730 = state_29820__$1;
(statearr_29833_30730[(2)] = null);

(statearr_29833_30730[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (13))){
var inst_29775 = (state_29820[(9)]);
var inst_29773 = (state_29820[(10)]);
var inst_29772 = (state_29820[(11)]);
var inst_29774 = (state_29820[(12)]);
var inst_29782 = (state_29820[(2)]);
var inst_29783 = (inst_29775 + (1));
var tmp29829 = inst_29773;
var tmp29830 = inst_29772;
var tmp29831 = inst_29774;
var inst_29772__$1 = tmp29830;
var inst_29773__$1 = tmp29829;
var inst_29774__$1 = tmp29831;
var inst_29775__$1 = inst_29783;
var state_29820__$1 = (function (){var statearr_29834 = state_29820;
(statearr_29834[(14)] = inst_29782);

(statearr_29834[(9)] = inst_29775__$1);

(statearr_29834[(10)] = inst_29773__$1);

(statearr_29834[(11)] = inst_29772__$1);

(statearr_29834[(12)] = inst_29774__$1);

return statearr_29834;
})();
var statearr_29835_30733 = state_29820__$1;
(statearr_29835_30733[(2)] = null);

(statearr_29835_30733[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (22))){
var state_29820__$1 = state_29820;
var statearr_29836_30734 = state_29820__$1;
(statearr_29836_30734[(2)] = null);

(statearr_29836_30734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (6))){
var inst_29761 = (state_29820[(13)]);
var inst_29770 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_29761) : f.call(null,inst_29761));
var inst_29771 = cljs.core.seq(inst_29770);
var inst_29772 = inst_29771;
var inst_29773 = null;
var inst_29774 = (0);
var inst_29775 = (0);
var state_29820__$1 = (function (){var statearr_29837 = state_29820;
(statearr_29837[(9)] = inst_29775);

(statearr_29837[(10)] = inst_29773);

(statearr_29837[(11)] = inst_29772);

(statearr_29837[(12)] = inst_29774);

return statearr_29837;
})();
var statearr_29838_30735 = state_29820__$1;
(statearr_29838_30735[(2)] = null);

(statearr_29838_30735[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (17))){
var inst_29786 = (state_29820[(7)]);
var inst_29790 = cljs.core.chunk_first(inst_29786);
var inst_29791 = cljs.core.chunk_rest(inst_29786);
var inst_29792 = cljs.core.count(inst_29790);
var inst_29772 = inst_29791;
var inst_29773 = inst_29790;
var inst_29774 = inst_29792;
var inst_29775 = (0);
var state_29820__$1 = (function (){var statearr_29839 = state_29820;
(statearr_29839[(9)] = inst_29775);

(statearr_29839[(10)] = inst_29773);

(statearr_29839[(11)] = inst_29772);

(statearr_29839[(12)] = inst_29774);

return statearr_29839;
})();
var statearr_29840_30736 = state_29820__$1;
(statearr_29840_30736[(2)] = null);

(statearr_29840_30736[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (3))){
var inst_29818 = (state_29820[(2)]);
var state_29820__$1 = state_29820;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29820__$1,inst_29818);
} else {
if((state_val_29821 === (12))){
var inst_29806 = (state_29820[(2)]);
var state_29820__$1 = state_29820;
var statearr_29841_30737 = state_29820__$1;
(statearr_29841_30737[(2)] = inst_29806);

(statearr_29841_30737[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (2))){
var state_29820__$1 = state_29820;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29820__$1,(4),in$);
} else {
if((state_val_29821 === (23))){
var inst_29814 = (state_29820[(2)]);
var state_29820__$1 = state_29820;
var statearr_29842_30738 = state_29820__$1;
(statearr_29842_30738[(2)] = inst_29814);

(statearr_29842_30738[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (19))){
var inst_29801 = (state_29820[(2)]);
var state_29820__$1 = state_29820;
var statearr_29843_30739 = state_29820__$1;
(statearr_29843_30739[(2)] = inst_29801);

(statearr_29843_30739[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (11))){
var inst_29772 = (state_29820[(11)]);
var inst_29786 = (state_29820[(7)]);
var inst_29786__$1 = cljs.core.seq(inst_29772);
var state_29820__$1 = (function (){var statearr_29844 = state_29820;
(statearr_29844[(7)] = inst_29786__$1);

return statearr_29844;
})();
if(inst_29786__$1){
var statearr_29845_30740 = state_29820__$1;
(statearr_29845_30740[(1)] = (14));

} else {
var statearr_29846_30741 = state_29820__$1;
(statearr_29846_30741[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (9))){
var inst_29808 = (state_29820[(2)]);
var inst_29809 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_29820__$1 = (function (){var statearr_29847 = state_29820;
(statearr_29847[(15)] = inst_29808);

return statearr_29847;
})();
if(cljs.core.truth_(inst_29809)){
var statearr_29848_30742 = state_29820__$1;
(statearr_29848_30742[(1)] = (21));

} else {
var statearr_29849_30743 = state_29820__$1;
(statearr_29849_30743[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (5))){
var inst_29764 = cljs.core.async.close_BANG_(out);
var state_29820__$1 = state_29820;
var statearr_29850_30744 = state_29820__$1;
(statearr_29850_30744[(2)] = inst_29764);

(statearr_29850_30744[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (14))){
var inst_29786 = (state_29820[(7)]);
var inst_29788 = cljs.core.chunked_seq_QMARK_(inst_29786);
var state_29820__$1 = state_29820;
if(inst_29788){
var statearr_29851_30745 = state_29820__$1;
(statearr_29851_30745[(1)] = (17));

} else {
var statearr_29852_30746 = state_29820__$1;
(statearr_29852_30746[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (16))){
var inst_29804 = (state_29820[(2)]);
var state_29820__$1 = state_29820;
var statearr_29853_30747 = state_29820__$1;
(statearr_29853_30747[(2)] = inst_29804);

(statearr_29853_30747[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29821 === (10))){
var inst_29775 = (state_29820[(9)]);
var inst_29773 = (state_29820[(10)]);
var inst_29780 = cljs.core._nth(inst_29773,inst_29775);
var state_29820__$1 = state_29820;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29820__$1,(13),out,inst_29780);
} else {
if((state_val_29821 === (18))){
var inst_29786 = (state_29820[(7)]);
var inst_29795 = cljs.core.first(inst_29786);
var state_29820__$1 = state_29820;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29820__$1,(20),out,inst_29795);
} else {
if((state_val_29821 === (8))){
var inst_29775 = (state_29820[(9)]);
var inst_29774 = (state_29820[(12)]);
var inst_29777 = (inst_29775 < inst_29774);
var inst_29778 = inst_29777;
var state_29820__$1 = state_29820;
if(cljs.core.truth_(inst_29778)){
var statearr_29854_30748 = state_29820__$1;
(statearr_29854_30748[(1)] = (10));

} else {
var statearr_29855_30749 = state_29820__$1;
(statearr_29855_30749[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__28411__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__28411__auto____0 = (function (){
var statearr_29856 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29856[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__28411__auto__);

(statearr_29856[(1)] = (1));

return statearr_29856;
});
var cljs$core$async$mapcat_STAR__$_state_machine__28411__auto____1 = (function (state_29820){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_29820);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e29857){var ex__28414__auto__ = e29857;
var statearr_29858_30750 = state_29820;
(statearr_29858_30750[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_29820[(4)]))){
var statearr_29859_30751 = state_29820;
(statearr_29859_30751[(1)] = cljs.core.first((state_29820[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30752 = state_29820;
state_29820 = G__30752;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__28411__auto__ = function(state_29820){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__28411__auto____1.call(this,state_29820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__28411__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__28411__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_29860 = f__28447__auto__();
(statearr_29860[(6)] = c__28446__auto__);

return statearr_29860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));

return c__28446__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__29862 = arguments.length;
switch (G__29862) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__29864 = arguments.length;
switch (G__29864) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__29866 = arguments.length;
switch (G__29866) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28446__auto___30756 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_29890){
var state_val_29891 = (state_29890[(1)]);
if((state_val_29891 === (7))){
var inst_29885 = (state_29890[(2)]);
var state_29890__$1 = state_29890;
var statearr_29892_30757 = state_29890__$1;
(statearr_29892_30757[(2)] = inst_29885);

(statearr_29892_30757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (1))){
var inst_29867 = null;
var state_29890__$1 = (function (){var statearr_29893 = state_29890;
(statearr_29893[(7)] = inst_29867);

return statearr_29893;
})();
var statearr_29894_30758 = state_29890__$1;
(statearr_29894_30758[(2)] = null);

(statearr_29894_30758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (4))){
var inst_29870 = (state_29890[(8)]);
var inst_29870__$1 = (state_29890[(2)]);
var inst_29871 = (inst_29870__$1 == null);
var inst_29872 = cljs.core.not(inst_29871);
var state_29890__$1 = (function (){var statearr_29895 = state_29890;
(statearr_29895[(8)] = inst_29870__$1);

return statearr_29895;
})();
if(inst_29872){
var statearr_29896_30759 = state_29890__$1;
(statearr_29896_30759[(1)] = (5));

} else {
var statearr_29897_30760 = state_29890__$1;
(statearr_29897_30760[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (6))){
var state_29890__$1 = state_29890;
var statearr_29898_30761 = state_29890__$1;
(statearr_29898_30761[(2)] = null);

(statearr_29898_30761[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (3))){
var inst_29887 = (state_29890[(2)]);
var inst_29888 = cljs.core.async.close_BANG_(out);
var state_29890__$1 = (function (){var statearr_29899 = state_29890;
(statearr_29899[(9)] = inst_29887);

return statearr_29899;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29890__$1,inst_29888);
} else {
if((state_val_29891 === (2))){
var state_29890__$1 = state_29890;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29890__$1,(4),ch);
} else {
if((state_val_29891 === (11))){
var inst_29870 = (state_29890[(8)]);
var inst_29879 = (state_29890[(2)]);
var inst_29867 = inst_29870;
var state_29890__$1 = (function (){var statearr_29900 = state_29890;
(statearr_29900[(7)] = inst_29867);

(statearr_29900[(10)] = inst_29879);

return statearr_29900;
})();
var statearr_29901_30762 = state_29890__$1;
(statearr_29901_30762[(2)] = null);

(statearr_29901_30762[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (9))){
var inst_29870 = (state_29890[(8)]);
var state_29890__$1 = state_29890;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29890__$1,(11),out,inst_29870);
} else {
if((state_val_29891 === (5))){
var inst_29870 = (state_29890[(8)]);
var inst_29867 = (state_29890[(7)]);
var inst_29874 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29870,inst_29867);
var state_29890__$1 = state_29890;
if(inst_29874){
var statearr_29903_30763 = state_29890__$1;
(statearr_29903_30763[(1)] = (8));

} else {
var statearr_29904_30764 = state_29890__$1;
(statearr_29904_30764[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (10))){
var inst_29882 = (state_29890[(2)]);
var state_29890__$1 = state_29890;
var statearr_29905_30765 = state_29890__$1;
(statearr_29905_30765[(2)] = inst_29882);

(statearr_29905_30765[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (8))){
var inst_29867 = (state_29890[(7)]);
var tmp29902 = inst_29867;
var inst_29867__$1 = tmp29902;
var state_29890__$1 = (function (){var statearr_29906 = state_29890;
(statearr_29906[(7)] = inst_29867__$1);

return statearr_29906;
})();
var statearr_29907_30766 = state_29890__$1;
(statearr_29907_30766[(2)] = null);

(statearr_29907_30766[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28411__auto__ = null;
var cljs$core$async$state_machine__28411__auto____0 = (function (){
var statearr_29908 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29908[(0)] = cljs$core$async$state_machine__28411__auto__);

(statearr_29908[(1)] = (1));

return statearr_29908;
});
var cljs$core$async$state_machine__28411__auto____1 = (function (state_29890){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_29890);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e29909){var ex__28414__auto__ = e29909;
var statearr_29910_30767 = state_29890;
(statearr_29910_30767[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_29890[(4)]))){
var statearr_29911_30768 = state_29890;
(statearr_29911_30768[(1)] = cljs.core.first((state_29890[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30769 = state_29890;
state_29890 = G__30769;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$state_machine__28411__auto__ = function(state_29890){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28411__auto____1.call(this,state_29890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28411__auto____0;
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28411__auto____1;
return cljs$core$async$state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_29912 = f__28447__auto__();
(statearr_29912[(6)] = c__28446__auto___30756);

return statearr_29912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__29914 = arguments.length;
switch (G__29914) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28446__auto___30771 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_29952){
var state_val_29953 = (state_29952[(1)]);
if((state_val_29953 === (7))){
var inst_29948 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
var statearr_29954_30773 = state_29952__$1;
(statearr_29954_30773[(2)] = inst_29948);

(statearr_29954_30773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (1))){
var inst_29915 = (new Array(n));
var inst_29916 = inst_29915;
var inst_29917 = (0);
var state_29952__$1 = (function (){var statearr_29955 = state_29952;
(statearr_29955[(7)] = inst_29917);

(statearr_29955[(8)] = inst_29916);

return statearr_29955;
})();
var statearr_29956_30774 = state_29952__$1;
(statearr_29956_30774[(2)] = null);

(statearr_29956_30774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (4))){
var inst_29920 = (state_29952[(9)]);
var inst_29920__$1 = (state_29952[(2)]);
var inst_29921 = (inst_29920__$1 == null);
var inst_29922 = cljs.core.not(inst_29921);
var state_29952__$1 = (function (){var statearr_29957 = state_29952;
(statearr_29957[(9)] = inst_29920__$1);

return statearr_29957;
})();
if(inst_29922){
var statearr_29958_30776 = state_29952__$1;
(statearr_29958_30776[(1)] = (5));

} else {
var statearr_29959_30777 = state_29952__$1;
(statearr_29959_30777[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (15))){
var inst_29942 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
var statearr_29960_30778 = state_29952__$1;
(statearr_29960_30778[(2)] = inst_29942);

(statearr_29960_30778[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (13))){
var state_29952__$1 = state_29952;
var statearr_29961_30782 = state_29952__$1;
(statearr_29961_30782[(2)] = null);

(statearr_29961_30782[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (6))){
var inst_29917 = (state_29952[(7)]);
var inst_29938 = (inst_29917 > (0));
var state_29952__$1 = state_29952;
if(cljs.core.truth_(inst_29938)){
var statearr_29962_30783 = state_29952__$1;
(statearr_29962_30783[(1)] = (12));

} else {
var statearr_29963_30784 = state_29952__$1;
(statearr_29963_30784[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (3))){
var inst_29950 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29952__$1,inst_29950);
} else {
if((state_val_29953 === (12))){
var inst_29916 = (state_29952[(8)]);
var inst_29940 = cljs.core.vec(inst_29916);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29952__$1,(15),out,inst_29940);
} else {
if((state_val_29953 === (2))){
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29952__$1,(4),ch);
} else {
if((state_val_29953 === (11))){
var inst_29932 = (state_29952[(2)]);
var inst_29933 = (new Array(n));
var inst_29916 = inst_29933;
var inst_29917 = (0);
var state_29952__$1 = (function (){var statearr_29964 = state_29952;
(statearr_29964[(7)] = inst_29917);

(statearr_29964[(8)] = inst_29916);

(statearr_29964[(10)] = inst_29932);

return statearr_29964;
})();
var statearr_29965_30786 = state_29952__$1;
(statearr_29965_30786[(2)] = null);

(statearr_29965_30786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (9))){
var inst_29916 = (state_29952[(8)]);
var inst_29930 = cljs.core.vec(inst_29916);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29952__$1,(11),out,inst_29930);
} else {
if((state_val_29953 === (5))){
var inst_29920 = (state_29952[(9)]);
var inst_29917 = (state_29952[(7)]);
var inst_29916 = (state_29952[(8)]);
var inst_29925 = (state_29952[(11)]);
var inst_29924 = (inst_29916[inst_29917] = inst_29920);
var inst_29925__$1 = (inst_29917 + (1));
var inst_29926 = (inst_29925__$1 < n);
var state_29952__$1 = (function (){var statearr_29966 = state_29952;
(statearr_29966[(12)] = inst_29924);

(statearr_29966[(11)] = inst_29925__$1);

return statearr_29966;
})();
if(cljs.core.truth_(inst_29926)){
var statearr_29967_30787 = state_29952__$1;
(statearr_29967_30787[(1)] = (8));

} else {
var statearr_29968_30788 = state_29952__$1;
(statearr_29968_30788[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (14))){
var inst_29945 = (state_29952[(2)]);
var inst_29946 = cljs.core.async.close_BANG_(out);
var state_29952__$1 = (function (){var statearr_29970 = state_29952;
(statearr_29970[(13)] = inst_29945);

return statearr_29970;
})();
var statearr_29971_30789 = state_29952__$1;
(statearr_29971_30789[(2)] = inst_29946);

(statearr_29971_30789[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (10))){
var inst_29936 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
var statearr_29972_30790 = state_29952__$1;
(statearr_29972_30790[(2)] = inst_29936);

(statearr_29972_30790[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (8))){
var inst_29916 = (state_29952[(8)]);
var inst_29925 = (state_29952[(11)]);
var tmp29969 = inst_29916;
var inst_29916__$1 = tmp29969;
var inst_29917 = inst_29925;
var state_29952__$1 = (function (){var statearr_29973 = state_29952;
(statearr_29973[(7)] = inst_29917);

(statearr_29973[(8)] = inst_29916__$1);

return statearr_29973;
})();
var statearr_29974_30791 = state_29952__$1;
(statearr_29974_30791[(2)] = null);

(statearr_29974_30791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28411__auto__ = null;
var cljs$core$async$state_machine__28411__auto____0 = (function (){
var statearr_29975 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29975[(0)] = cljs$core$async$state_machine__28411__auto__);

(statearr_29975[(1)] = (1));

return statearr_29975;
});
var cljs$core$async$state_machine__28411__auto____1 = (function (state_29952){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_29952);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e29976){var ex__28414__auto__ = e29976;
var statearr_29977_30792 = state_29952;
(statearr_29977_30792[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_29952[(4)]))){
var statearr_29978_30794 = state_29952;
(statearr_29978_30794[(1)] = cljs.core.first((state_29952[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30797 = state_29952;
state_29952 = G__30797;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$state_machine__28411__auto__ = function(state_29952){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28411__auto____1.call(this,state_29952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28411__auto____0;
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28411__auto____1;
return cljs$core$async$state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_29979 = f__28447__auto__();
(statearr_29979[(6)] = c__28446__auto___30771);

return statearr_29979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__29981 = arguments.length;
switch (G__29981) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28446__auto___30799 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_30023){
var state_val_30024 = (state_30023[(1)]);
if((state_val_30024 === (7))){
var inst_30019 = (state_30023[(2)]);
var state_30023__$1 = state_30023;
var statearr_30025_30800 = state_30023__$1;
(statearr_30025_30800[(2)] = inst_30019);

(statearr_30025_30800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (1))){
var inst_29982 = [];
var inst_29983 = inst_29982;
var inst_29984 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_30023__$1 = (function (){var statearr_30026 = state_30023;
(statearr_30026[(7)] = inst_29983);

(statearr_30026[(8)] = inst_29984);

return statearr_30026;
})();
var statearr_30027_30802 = state_30023__$1;
(statearr_30027_30802[(2)] = null);

(statearr_30027_30802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (4))){
var inst_29987 = (state_30023[(9)]);
var inst_29987__$1 = (state_30023[(2)]);
var inst_29988 = (inst_29987__$1 == null);
var inst_29989 = cljs.core.not(inst_29988);
var state_30023__$1 = (function (){var statearr_30028 = state_30023;
(statearr_30028[(9)] = inst_29987__$1);

return statearr_30028;
})();
if(inst_29989){
var statearr_30029_30804 = state_30023__$1;
(statearr_30029_30804[(1)] = (5));

} else {
var statearr_30030_30805 = state_30023__$1;
(statearr_30030_30805[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (15))){
var inst_30013 = (state_30023[(2)]);
var state_30023__$1 = state_30023;
var statearr_30031_30806 = state_30023__$1;
(statearr_30031_30806[(2)] = inst_30013);

(statearr_30031_30806[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (13))){
var state_30023__$1 = state_30023;
var statearr_30032_30807 = state_30023__$1;
(statearr_30032_30807[(2)] = null);

(statearr_30032_30807[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (6))){
var inst_29983 = (state_30023[(7)]);
var inst_30008 = inst_29983.length;
var inst_30009 = (inst_30008 > (0));
var state_30023__$1 = state_30023;
if(cljs.core.truth_(inst_30009)){
var statearr_30033_30811 = state_30023__$1;
(statearr_30033_30811[(1)] = (12));

} else {
var statearr_30034_30812 = state_30023__$1;
(statearr_30034_30812[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (3))){
var inst_30021 = (state_30023[(2)]);
var state_30023__$1 = state_30023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30023__$1,inst_30021);
} else {
if((state_val_30024 === (12))){
var inst_29983 = (state_30023[(7)]);
var inst_30011 = cljs.core.vec(inst_29983);
var state_30023__$1 = state_30023;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30023__$1,(15),out,inst_30011);
} else {
if((state_val_30024 === (2))){
var state_30023__$1 = state_30023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30023__$1,(4),ch);
} else {
if((state_val_30024 === (11))){
var inst_29991 = (state_30023[(10)]);
var inst_29987 = (state_30023[(9)]);
var inst_30001 = (state_30023[(2)]);
var inst_30002 = [];
var inst_30003 = inst_30002.push(inst_29987);
var inst_29983 = inst_30002;
var inst_29984 = inst_29991;
var state_30023__$1 = (function (){var statearr_30035 = state_30023;
(statearr_30035[(11)] = inst_30001);

(statearr_30035[(12)] = inst_30003);

(statearr_30035[(7)] = inst_29983);

(statearr_30035[(8)] = inst_29984);

return statearr_30035;
})();
var statearr_30036_30814 = state_30023__$1;
(statearr_30036_30814[(2)] = null);

(statearr_30036_30814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (9))){
var inst_29983 = (state_30023[(7)]);
var inst_29999 = cljs.core.vec(inst_29983);
var state_30023__$1 = state_30023;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30023__$1,(11),out,inst_29999);
} else {
if((state_val_30024 === (5))){
var inst_29991 = (state_30023[(10)]);
var inst_29987 = (state_30023[(9)]);
var inst_29984 = (state_30023[(8)]);
var inst_29991__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_29987) : f.call(null,inst_29987));
var inst_29992 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29991__$1,inst_29984);
var inst_29993 = cljs.core.keyword_identical_QMARK_(inst_29984,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_29994 = ((inst_29992) || (inst_29993));
var state_30023__$1 = (function (){var statearr_30037 = state_30023;
(statearr_30037[(10)] = inst_29991__$1);

return statearr_30037;
})();
if(cljs.core.truth_(inst_29994)){
var statearr_30038_30815 = state_30023__$1;
(statearr_30038_30815[(1)] = (8));

} else {
var statearr_30039_30816 = state_30023__$1;
(statearr_30039_30816[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (14))){
var inst_30016 = (state_30023[(2)]);
var inst_30017 = cljs.core.async.close_BANG_(out);
var state_30023__$1 = (function (){var statearr_30041 = state_30023;
(statearr_30041[(13)] = inst_30016);

return statearr_30041;
})();
var statearr_30042_30817 = state_30023__$1;
(statearr_30042_30817[(2)] = inst_30017);

(statearr_30042_30817[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (10))){
var inst_30006 = (state_30023[(2)]);
var state_30023__$1 = state_30023;
var statearr_30043_30818 = state_30023__$1;
(statearr_30043_30818[(2)] = inst_30006);

(statearr_30043_30818[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (8))){
var inst_29991 = (state_30023[(10)]);
var inst_29987 = (state_30023[(9)]);
var inst_29983 = (state_30023[(7)]);
var inst_29996 = inst_29983.push(inst_29987);
var tmp30040 = inst_29983;
var inst_29983__$1 = tmp30040;
var inst_29984 = inst_29991;
var state_30023__$1 = (function (){var statearr_30044 = state_30023;
(statearr_30044[(14)] = inst_29996);

(statearr_30044[(7)] = inst_29983__$1);

(statearr_30044[(8)] = inst_29984);

return statearr_30044;
})();
var statearr_30045_30819 = state_30023__$1;
(statearr_30045_30819[(2)] = null);

(statearr_30045_30819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28411__auto__ = null;
var cljs$core$async$state_machine__28411__auto____0 = (function (){
var statearr_30046 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30046[(0)] = cljs$core$async$state_machine__28411__auto__);

(statearr_30046[(1)] = (1));

return statearr_30046;
});
var cljs$core$async$state_machine__28411__auto____1 = (function (state_30023){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_30023);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e30047){var ex__28414__auto__ = e30047;
var statearr_30048_30821 = state_30023;
(statearr_30048_30821[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_30023[(4)]))){
var statearr_30049_30824 = state_30023;
(statearr_30049_30824[(1)] = cljs.core.first((state_30023[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30825 = state_30023;
state_30023 = G__30825;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
cljs$core$async$state_machine__28411__auto__ = function(state_30023){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28411__auto____1.call(this,state_30023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28411__auto____0;
cljs$core$async$state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28411__auto____1;
return cljs$core$async$state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_30050 = f__28447__auto__();
(statearr_30050[(6)] = c__28446__auto___30799);

return statearr_30050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
