goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__44148 = (line + (1));
var G__44149 = (1);
var G__44150 = (counter + (1));
line = G__44148;
col = G__44149;
counter = G__44150;
continue;
} else {
var G__44151 = line;
var G__44152 = (col + (1));
var G__44153 = (counter + (1));
line = G__44151;
col = G__44152;
counter = G__44153;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__44154 = cljs.core.next(chars);
var G__44155 = (n__$1 - (1));
chars = G__44154;
n__$1 = G__44155;
continue;
} else {
var G__44156 = cljs.core.next(chars);
var G__44157 = n__$1;
chars = G__44156;
n__$1 = G__44157;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__44136){
var map__44137 = p__44136;
var map__44137__$1 = (((((!((map__44137 == null))))?(((((map__44137.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44137.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44137):map__44137);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44137__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44137__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44137__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44137__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__44140_44158 = cljs.core.seq(full_reasons);
var chunk__44141_44159 = null;
var count__44142_44160 = (0);
var i__44143_44161 = (0);
while(true){
if((i__44143_44161 < count__44142_44160)){
var r_44162 = chunk__44141_44159.cljs$core$IIndexed$_nth$arity$2(null,i__44143_44161);
instaparse.failure.print_reason(r_44162);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__44163 = seq__44140_44158;
var G__44164 = chunk__44141_44159;
var G__44165 = count__44142_44160;
var G__44166 = (i__44143_44161 + (1));
seq__44140_44158 = G__44163;
chunk__44141_44159 = G__44164;
count__44142_44160 = G__44165;
i__44143_44161 = G__44166;
continue;
} else {
var temp__5735__auto___44167 = cljs.core.seq(seq__44140_44158);
if(temp__5735__auto___44167){
var seq__44140_44168__$1 = temp__5735__auto___44167;
if(cljs.core.chunked_seq_QMARK_(seq__44140_44168__$1)){
var c__4550__auto___44169 = cljs.core.chunk_first(seq__44140_44168__$1);
var G__44170 = cljs.core.chunk_rest(seq__44140_44168__$1);
var G__44171 = c__4550__auto___44169;
var G__44172 = cljs.core.count(c__4550__auto___44169);
var G__44173 = (0);
seq__44140_44158 = G__44170;
chunk__44141_44159 = G__44171;
count__44142_44160 = G__44172;
i__44143_44161 = G__44173;
continue;
} else {
var r_44174 = cljs.core.first(seq__44140_44168__$1);
instaparse.failure.print_reason(r_44174);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__44175 = cljs.core.next(seq__44140_44168__$1);
var G__44176 = null;
var G__44177 = (0);
var G__44178 = (0);
seq__44140_44158 = G__44175;
chunk__44141_44159 = G__44176;
count__44142_44160 = G__44177;
i__44143_44161 = G__44178;
continue;
}
} else {
}
}
break;
}

var seq__44144 = cljs.core.seq(partial_reasons);
var chunk__44145 = null;
var count__44146 = (0);
var i__44147 = (0);
while(true){
if((i__44147 < count__44146)){
var r = chunk__44145.cljs$core$IIndexed$_nth$arity$2(null,i__44147);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__44179 = seq__44144;
var G__44180 = chunk__44145;
var G__44181 = count__44146;
var G__44182 = (i__44147 + (1));
seq__44144 = G__44179;
chunk__44145 = G__44180;
count__44146 = G__44181;
i__44147 = G__44182;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__44144);
if(temp__5735__auto__){
var seq__44144__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44144__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__44144__$1);
var G__44183 = cljs.core.chunk_rest(seq__44144__$1);
var G__44184 = c__4550__auto__;
var G__44185 = cljs.core.count(c__4550__auto__);
var G__44186 = (0);
seq__44144 = G__44183;
chunk__44145 = G__44184;
count__44146 = G__44185;
i__44147 = G__44186;
continue;
} else {
var r = cljs.core.first(seq__44144__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__44187 = cljs.core.next(seq__44144__$1);
var G__44188 = null;
var G__44189 = (0);
var G__44190 = (0);
seq__44144 = G__44187;
chunk__44145 = G__44188;
count__44146 = G__44189;
i__44147 = G__44190;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=instaparse.failure.js.map
