goog.provide('pinkgorilla.app_notebook');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('secretary.core');
goog.require('reagent.dom');
goog.require('re_frame.core');
goog.require('pinkgorilla.config.notebook');
goog.require('pinkgorilla.subs');
goog.require('pinkgorilla.events');
goog.require('pinkgorilla.util');
goog.require('pinkgorilla.views');
goog.require('pinkgorilla.codemirror.core');
goog.require('pinkgorilla.routes');
goog.require('pinkgorilla.kernel.nrepl');
pinkgorilla.app_notebook.mount_notebook_app = (function pinkgorilla$app_notebook$mount_notebook_app(){
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.views.gorilla_app], null),document.getElementById("gorilla-notebook-app"));
});
pinkgorilla.app_notebook.init_notebook_BANG_ = (function pinkgorilla$app_notebook$init_notebook_BANG_(){
pinkgorilla.routes.app_routes();

pinkgorilla.codemirror.core.configure_cm_globally_BANG_();

var app_url = pinkgorilla.util.application_url();
var route = app_url.anchor;
var read_write = ((cljs.core.not(route)) || (cljs.core.not(clojure.string.index_of.cljs$core$IFn$_invoke$arity$2(route,"/view"))));
var G__47522_47525 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"initialize-app-db","initialize-app-db",-1585144192),app_url], null);
(re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1(G__47522_47525) : re_frame.core.dispatch_sync.call(null,G__47522_47525));

var G__47523_47526 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"settings-localstorage-load","settings-localstorage-load",-1464956499)], null);
(re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1(G__47523_47526) : re_frame.core.dispatch_sync.call(null,G__47523_47526));

var G__47524_47527 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"load-config","load-config",-1041233310)], null);
(re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1(G__47524_47527) : re_frame.core.dispatch_sync.call(null,G__47524_47527));

pinkgorilla.app_notebook.mount_notebook_app();

if(read_write){
pinkgorilla.kernel.nrepl.start_repl_BANG_(pinkgorilla.util.ws_origin("repl/",app_url));
} else {
}

if(cljs.core.not(route)){
return pinkgorilla.routes.nav_BANG_("/new");
} else {
return secretary.core.dispatch_BANG_(route);
}
});
goog.exportSymbol('pinkgorilla.app_notebook.init_notebook_BANG_', pinkgorilla.app_notebook.init_notebook_BANG_);

//# sourceMappingURL=pinkgorilla.app_notebook.js.map
