goog.provide('pinkgorilla.encoding.jupyter');
goog.require('cljs.core');
goog.require('pinkgorilla.encoding.helper');
goog.require('pinkgorilla.encoding.decode');
pinkgorilla.encoding.jupyter.convert_md = (function pinkgorilla$encoding$jupyter$convert_md(source){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"free","free",801364328),new cljs.core.Keyword(null,"markup-visible","markup-visible",447471311),false,new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",305978217),source,new cljs.core.Keyword(null,"type","type",1174270348),"text/x-markdown"], null)], null);
});
pinkgorilla.encoding.jupyter.convert_code = (function pinkgorilla$encoding$jupyter$convert_code(source){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"code","code",1586293142),new cljs.core.Keyword(null,"kernel","kernel",-650895913),new cljs.core.Keyword(null,"clj","clj",-660495428),new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",305978217),source,new cljs.core.Keyword(null,"type","type",1174270348),"text/x-clojure"], null)], null);
});
pinkgorilla.encoding.jupyter.parse_cell = (function pinkgorilla$encoding$jupyter$parse_cell(cell){
var cell_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cell,"cell_type");
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cell,"source");
var source_multiline = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,source);
var G__46003 = cell_type;
switch (G__46003) {
case "markdown":
return pinkgorilla.encoding.jupyter.convert_md(source_multiline);

break;
case "code":
return pinkgorilla.encoding.jupyter.convert_code(source_multiline);

break;
default:
return null;

}
});
pinkgorilla.encoding.jupyter.parse_cells = (function pinkgorilla$encoding$jupyter$parse_cells(notebook){
var cells = cljs.core.get.cljs$core$IFn$_invoke$arity$2(notebook,"cells");
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(pinkgorilla.encoding.jupyter.parse_cell,cells));
});
pinkgorilla.encoding.decode.decode.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"jupyter","jupyter",-1124807371),(function (_,s){
var notebook = pinkgorilla.encoding.helper.from_json(s);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"version","version",425292698),"J",new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tagline","tagline",281987682),"Jupyter Notebook"], null),new cljs.core.Keyword(null,"segments","segments",1937535949),pinkgorilla.encoding.jupyter.parse_cells(notebook)], null);
}));

//# sourceMappingURL=pinkgorilla.encoding.jupyter.js.map
