goog.provide('pinkgorilla.kernel.guard');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.analyzer');
goog.require('cljs.compiler');
/**
 * each time the watchdog has a chance to run, this var is set with the current time
 */
pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_ = (0);
pinkgorilla.kernel.guard.min_max_eval_duration = (3000);
/**
 * The number of msec for the watchdog period.
 *          This value has to be much lower than min-max-eval-duration.
 */
pinkgorilla.kernel.guard.watchdog_period = (pinkgorilla.kernel.guard.min_max_eval_duration / (10));
pinkgorilla.kernel.guard.runonce = (function pinkgorilla$kernel$guard$runonce(f){
var ran = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
return (function() { 
var G__42372__delegate = function (args){
if(cljs.core.truth_(cljs.core.deref(ran))){
return null;
} else {
cljs.core.reset_BANG_(ran,true);

return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}
};
var G__42372 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__42373__i = 0, G__42373__a = new Array(arguments.length -  0);
while (G__42373__i < G__42373__a.length) {G__42373__a[G__42373__i] = arguments[G__42373__i + 0]; ++G__42373__i;}
  args = new cljs.core.IndexedSeq(G__42373__a,0,null);
} 
return G__42372__delegate.call(this,args);};
G__42372.cljs$lang$maxFixedArity = 0;
G__42372.cljs$lang$applyTo = (function (arglist__42374){
var args = cljs.core.seq(arglist__42374);
return G__42372__delegate(args);
});
G__42372.cljs$core$IFn$_invoke$arity$variadic = G__42372__delegate;
return G__42372;
})()
;
});
pinkgorilla.kernel.guard.tick = (function pinkgorilla$kernel$guard$tick(){
return (pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_ = cljs.core.system_time());
});
/**
 * reset the *watchdog-tick* to the current time once in a while
 */
pinkgorilla.kernel.guard.run_watchdog_STAR_ = (function pinkgorilla$kernel$guard$run_watchdog_STAR_(){
pinkgorilla.kernel.guard.tick();

var c__28446__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28447__auto__ = (function (){var switch__28410__auto__ = (function (state_42355){
var state_val_42356 = (state_42355[(1)]);
if((state_val_42356 === (1))){
var state_42355__$1 = state_42355;
var statearr_42357_42375 = state_42355__$1;
(statearr_42357_42375[(2)] = null);

(statearr_42357_42375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42356 === (2))){
var inst_42347 = cljs.core.async.timeout(pinkgorilla.kernel.guard.watchdog_period);
var state_42355__$1 = state_42355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42355__$1,(4),inst_42347);
} else {
if((state_val_42356 === (3))){
var inst_42353 = (state_42355[(2)]);
var state_42355__$1 = state_42355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42355__$1,inst_42353);
} else {
if((state_val_42356 === (4))){
var inst_42349 = (state_42355[(2)]);
var inst_42350 = pinkgorilla.kernel.guard.tick();
var state_42355__$1 = (function (){var statearr_42358 = state_42355;
(statearr_42358[(7)] = inst_42350);

(statearr_42358[(8)] = inst_42349);

return statearr_42358;
})();
var statearr_42359_42376 = state_42355__$1;
(statearr_42359_42376[(2)] = null);

(statearr_42359_42376[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__28411__auto__ = null;
var pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__28411__auto____0 = (function (){
var statearr_42360 = [null,null,null,null,null,null,null,null,null];
(statearr_42360[(0)] = pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__28411__auto__);

(statearr_42360[(1)] = (1));

return statearr_42360;
});
var pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__28411__auto____1 = (function (state_42355){
while(true){
var ret_value__28412__auto__ = (function (){try{while(true){
var result__28413__auto__ = switch__28410__auto__(state_42355);
if(cljs.core.keyword_identical_QMARK_(result__28413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28413__auto__;
}
break;
}
}catch (e42361){var ex__28414__auto__ = e42361;
var statearr_42362_42377 = state_42355;
(statearr_42362_42377[(2)] = ex__28414__auto__);


if(cljs.core.seq((state_42355[(4)]))){
var statearr_42363_42378 = state_42355;
(statearr_42363_42378[(1)] = cljs.core.first((state_42355[(4)])));

} else {
throw ex__28414__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42379 = state_42355;
state_42355 = G__42379;
continue;
} else {
return ret_value__28412__auto__;
}
break;
}
});
pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__28411__auto__ = function(state_42355){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__28411__auto____0.call(this);
case 1:
return pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__28411__auto____1.call(this,state_42355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__28411__auto____0;
pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__28411__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__28411__auto____1;
return pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__28411__auto__;
})()
})();
var state__28448__auto__ = (function (){var statearr_42364 = f__28447__auto__();
(statearr_42364[(6)] = c__28446__auto__);

return statearr_42364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28448__auto__);
}));

return c__28446__auto__;
});
pinkgorilla.kernel.guard.run_watchdog_once = pinkgorilla.kernel.guard.runonce(pinkgorilla.kernel.guard.run_watchdog_STAR_);
pinkgorilla.kernel.guard.watchdog = (function pinkgorilla$kernel$guard$watchdog(){
pinkgorilla.kernel.guard.tick();

return pinkgorilla.kernel.guard.run_watchdog_once();
});
pinkgorilla.kernel.guard.guard = (function pinkgorilla$kernel$guard$guard(max_eval_duration){
if(((cljs.core.system_time() - pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_) > max_eval_duration)){
if(cljs.core.truth_(confirm(["A KLIPSE snippet has been running for more than ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_eval_duration)," milliseconds. This is often because of a long-running computation or infinite loop. Would you like to interrupt the snippet? \n OK to interrupt the evaluation.\n Cancel to continue."].join('')))){
throw "Infinite Loop";
} else {
}

return (pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_ = cljs.core.system_time());
} else {
return null;
}
});
goog.exportSymbol('pinkgorilla.kernel.guard.guard', pinkgorilla.kernel.guard.guard);
/**
 * same as cljs.compiler/emits with insertion of a `guard()` call before if and recur (emitted as continue) statement.
 * 
 *   Limitations:
 *   1. It doesn't prevent infinite loop in imported code e.g. (reduce + (range)
 *   
 */
pinkgorilla.kernel.guard.my_emits = (function pinkgorilla$kernel$guard$my_emits(var_args){
var args__4736__auto__ = [];
var len__4730__auto___42380 = arguments.length;
var i__4731__auto___42381 = (0);
while(true){
if((i__4731__auto___42381 < len__4730__auto___42380)){
args__4736__auto__.push((arguments[i__4731__auto___42381]));

var G__42382 = (i__4731__auto___42381 + (1));
i__4731__auto___42381 = G__42382;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return pinkgorilla.kernel.guard.my_emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(pinkgorilla.kernel.guard.my_emits.cljs$core$IFn$_invoke$arity$variadic = (function (max_eval_duration,xs){
if(cljs.core.truth_(((typeof cljs.core.first(xs) === 'string')?cljs.core.re_matches(/^(if|continue).*/,cljs.core.first(xs)):false))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["klipse_clj.lang.clojure.guard.guard(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_eval_duration),");"].join('')], 0));
} else {
}

var seq__42368_42383 = cljs.core.seq(xs);
var chunk__42369_42384 = null;
var count__42370_42385 = (0);
var i__42371_42386 = (0);
while(true){
if((i__42371_42386 < count__42370_42385)){
var x_42387 = chunk__42369_42384.cljs$core$IIndexed$_nth$arity$2(null,i__42371_42386);
if((x_42387 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(x_42387)){
cljs.compiler.emit(x_42387);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(x_42387)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.guard.my_emits,max_eval_duration,x_42387);
} else {
if(goog.isFunction(x_42387)){
(x_42387.cljs$core$IFn$_invoke$arity$0 ? x_42387.cljs$core$IFn$_invoke$arity$0() : x_42387.call(null));
} else {
var s_42388 = cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x_42387], 0));
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__42368_42383,chunk__42369_42384,count__42370_42385,i__42371_42386,s_42388,x_42387){
return (function (p1__42365_SHARP_){
return (p1__42365_SHARP_ + ((s_42388).length));
});})(seq__42368_42383,chunk__42369_42384,count__42370_42385,i__42371_42386,s_42388,x_42387))
);
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_42388], 0));

}
}
}
}


var G__42389 = seq__42368_42383;
var G__42390 = chunk__42369_42384;
var G__42391 = count__42370_42385;
var G__42392 = (i__42371_42386 + (1));
seq__42368_42383 = G__42389;
chunk__42369_42384 = G__42390;
count__42370_42385 = G__42391;
i__42371_42386 = G__42392;
continue;
} else {
var temp__5735__auto___42393 = cljs.core.seq(seq__42368_42383);
if(temp__5735__auto___42393){
var seq__42368_42394__$1 = temp__5735__auto___42393;
if(cljs.core.chunked_seq_QMARK_(seq__42368_42394__$1)){
var c__4550__auto___42395 = cljs.core.chunk_first(seq__42368_42394__$1);
var G__42396 = cljs.core.chunk_rest(seq__42368_42394__$1);
var G__42397 = c__4550__auto___42395;
var G__42398 = cljs.core.count(c__4550__auto___42395);
var G__42399 = (0);
seq__42368_42383 = G__42396;
chunk__42369_42384 = G__42397;
count__42370_42385 = G__42398;
i__42371_42386 = G__42399;
continue;
} else {
var x_42400 = cljs.core.first(seq__42368_42394__$1);
if((x_42400 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(x_42400)){
cljs.compiler.emit(x_42400);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(x_42400)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.guard.my_emits,max_eval_duration,x_42400);
} else {
if(goog.isFunction(x_42400)){
(x_42400.cljs$core$IFn$_invoke$arity$0 ? x_42400.cljs$core$IFn$_invoke$arity$0() : x_42400.call(null));
} else {
var s_42401 = cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x_42400], 0));
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__42368_42383,chunk__42369_42384,count__42370_42385,i__42371_42386,s_42401,x_42400,seq__42368_42394__$1,temp__5735__auto___42393){
return (function (p1__42365_SHARP_){
return (p1__42365_SHARP_ + ((s_42401).length));
});})(seq__42368_42383,chunk__42369_42384,count__42370_42385,i__42371_42386,s_42401,x_42400,seq__42368_42394__$1,temp__5735__auto___42393))
);
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_42401], 0));

}
}
}
}


var G__42402 = cljs.core.next(seq__42368_42394__$1);
var G__42403 = null;
var G__42404 = (0);
var G__42405 = (0);
seq__42368_42383 = G__42402;
chunk__42369_42384 = G__42403;
count__42370_42385 = G__42404;
i__42371_42386 = G__42405;
continue;
}
} else {
}
}
break;
}

return null;
}));

(pinkgorilla.kernel.guard.my_emits.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.kernel.guard.my_emits.cljs$lang$applyTo = (function (seq42366){
var G__42367 = cljs.core.first(seq42366);
var seq42366__$1 = cljs.core.next(seq42366);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42367,seq42366__$1);
}));


//# sourceMappingURL=pinkgorilla.kernel.guard.js.map
