goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__25468 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__25469 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__25469);

try{try{var seq__25470 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__25471 = null;
var count__25472 = (0);
var i__25473 = (0);
while(true){
if((i__25473 < count__25472)){
var vec__25480 = chunk__25471.cljs$core$IIndexed$_nth$arity$2(null,i__25473);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25480,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25480,(1),null);
var temp__5733__auto___25525 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___25525)){
var effect_fn_25526 = temp__5733__auto___25525;
(effect_fn_25526.cljs$core$IFn$_invoke$arity$1 ? effect_fn_25526.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_25526.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__25527 = seq__25470;
var G__25528 = chunk__25471;
var G__25529 = count__25472;
var G__25530 = (i__25473 + (1));
seq__25470 = G__25527;
chunk__25471 = G__25528;
count__25472 = G__25529;
i__25473 = G__25530;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__25470);
if(temp__5735__auto__){
var seq__25470__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__25470__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__25470__$1);
var G__25531 = cljs.core.chunk_rest(seq__25470__$1);
var G__25532 = c__4550__auto__;
var G__25533 = cljs.core.count(c__4550__auto__);
var G__25534 = (0);
seq__25470 = G__25531;
chunk__25471 = G__25532;
count__25472 = G__25533;
i__25473 = G__25534;
continue;
} else {
var vec__25483 = cljs.core.first(seq__25470__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25483,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25483,(1),null);
var temp__5733__auto___25535 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___25535)){
var effect_fn_25536 = temp__5733__auto___25535;
(effect_fn_25536.cljs$core$IFn$_invoke$arity$1 ? effect_fn_25536.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_25536.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__25537 = cljs.core.next(seq__25470__$1);
var G__25538 = null;
var G__25539 = (0);
var G__25540 = (0);
seq__25470 = G__25537;
chunk__25471 = G__25538;
count__25472 = G__25539;
i__25473 = G__25540;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__25174__auto___25541 = re_frame.interop.now();
var duration__25175__auto___25542 = (end__25174__auto___25541 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__25175__auto___25542,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__25174__auto___25541);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__25468);
}} else {
var seq__25486 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__25487 = null;
var count__25488 = (0);
var i__25489 = (0);
while(true){
if((i__25489 < count__25488)){
var vec__25498 = chunk__25487.cljs$core$IIndexed$_nth$arity$2(null,i__25489);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25498,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25498,(1),null);
var temp__5733__auto___25543 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___25543)){
var effect_fn_25544 = temp__5733__auto___25543;
(effect_fn_25544.cljs$core$IFn$_invoke$arity$1 ? effect_fn_25544.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_25544.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__25548 = seq__25486;
var G__25549 = chunk__25487;
var G__25550 = count__25488;
var G__25551 = (i__25489 + (1));
seq__25486 = G__25548;
chunk__25487 = G__25549;
count__25488 = G__25550;
i__25489 = G__25551;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__25486);
if(temp__5735__auto__){
var seq__25486__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__25486__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__25486__$1);
var G__25552 = cljs.core.chunk_rest(seq__25486__$1);
var G__25553 = c__4550__auto__;
var G__25554 = cljs.core.count(c__4550__auto__);
var G__25555 = (0);
seq__25486 = G__25552;
chunk__25487 = G__25553;
count__25488 = G__25554;
i__25489 = G__25555;
continue;
} else {
var vec__25501 = cljs.core.first(seq__25486__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25501,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25501,(1),null);
var temp__5733__auto___25556 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___25556)){
var effect_fn_25557 = temp__5733__auto___25556;
(effect_fn_25557.cljs$core$IFn$_invoke$arity$1 ? effect_fn_25557.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_25557.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__25558 = cljs.core.next(seq__25486__$1);
var G__25559 = null;
var G__25560 = (0);
var G__25561 = (0);
seq__25486 = G__25558;
chunk__25487 = G__25559;
count__25488 = G__25560;
i__25489 = G__25561;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__25505 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__25506 = null;
var count__25507 = (0);
var i__25508 = (0);
while(true){
if((i__25508 < count__25507)){
var map__25513 = chunk__25506.cljs$core$IIndexed$_nth$arity$2(null,i__25508);
var map__25513__$1 = (((((!((map__25513 == null))))?(((((map__25513.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25513.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25513):map__25513);
var effect = map__25513__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25513__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25513__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__25505,chunk__25506,count__25507,i__25508,map__25513,map__25513__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__25505,chunk__25506,count__25507,i__25508,map__25513,map__25513__$1,effect,ms,dispatch))
,ms);
}


var G__25564 = seq__25505;
var G__25565 = chunk__25506;
var G__25566 = count__25507;
var G__25567 = (i__25508 + (1));
seq__25505 = G__25564;
chunk__25506 = G__25565;
count__25507 = G__25566;
i__25508 = G__25567;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__25505);
if(temp__5735__auto__){
var seq__25505__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__25505__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__25505__$1);
var G__25568 = cljs.core.chunk_rest(seq__25505__$1);
var G__25569 = c__4550__auto__;
var G__25570 = cljs.core.count(c__4550__auto__);
var G__25571 = (0);
seq__25505 = G__25568;
chunk__25506 = G__25569;
count__25507 = G__25570;
i__25508 = G__25571;
continue;
} else {
var map__25515 = cljs.core.first(seq__25505__$1);
var map__25515__$1 = (((((!((map__25515 == null))))?(((((map__25515.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25515.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25515):map__25515);
var effect = map__25515__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25515__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25515__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__25505,chunk__25506,count__25507,i__25508,map__25515,map__25515__$1,effect,ms,dispatch,seq__25505__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__25505,chunk__25506,count__25507,i__25508,map__25515,map__25515__$1,effect,ms,dispatch,seq__25505__$1,temp__5735__auto__))
,ms);
}


var G__25576 = cljs.core.next(seq__25505__$1);
var G__25577 = null;
var G__25578 = (0);
var G__25579 = (0);
seq__25505 = G__25576;
chunk__25506 = G__25577;
count__25507 = G__25578;
i__25508 = G__25579;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__25517 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__25518 = null;
var count__25519 = (0);
var i__25520 = (0);
while(true){
if((i__25520 < count__25519)){
var event = chunk__25518.cljs$core$IIndexed$_nth$arity$2(null,i__25520);
re_frame.router.dispatch(event);


var G__25580 = seq__25517;
var G__25581 = chunk__25518;
var G__25582 = count__25519;
var G__25583 = (i__25520 + (1));
seq__25517 = G__25580;
chunk__25518 = G__25581;
count__25519 = G__25582;
i__25520 = G__25583;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__25517);
if(temp__5735__auto__){
var seq__25517__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__25517__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__25517__$1);
var G__25584 = cljs.core.chunk_rest(seq__25517__$1);
var G__25585 = c__4550__auto__;
var G__25586 = cljs.core.count(c__4550__auto__);
var G__25587 = (0);
seq__25517 = G__25584;
chunk__25518 = G__25585;
count__25519 = G__25586;
i__25520 = G__25587;
continue;
} else {
var event = cljs.core.first(seq__25517__$1);
re_frame.router.dispatch(event);


var G__25590 = cljs.core.next(seq__25517__$1);
var G__25591 = null;
var G__25592 = (0);
var G__25593 = (0);
seq__25517 = G__25590;
chunk__25518 = G__25591;
count__25519 = G__25592;
i__25520 = G__25593;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__25521 = cljs.core.seq(value);
var chunk__25522 = null;
var count__25523 = (0);
var i__25524 = (0);
while(true){
if((i__25524 < count__25523)){
var event = chunk__25522.cljs$core$IIndexed$_nth$arity$2(null,i__25524);
clear_event(event);


var G__25596 = seq__25521;
var G__25597 = chunk__25522;
var G__25598 = count__25523;
var G__25599 = (i__25524 + (1));
seq__25521 = G__25596;
chunk__25522 = G__25597;
count__25523 = G__25598;
i__25524 = G__25599;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__25521);
if(temp__5735__auto__){
var seq__25521__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__25521__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__25521__$1);
var G__25600 = cljs.core.chunk_rest(seq__25521__$1);
var G__25601 = c__4550__auto__;
var G__25602 = cljs.core.count(c__4550__auto__);
var G__25603 = (0);
seq__25521 = G__25600;
chunk__25522 = G__25601;
count__25523 = G__25602;
i__25524 = G__25603;
continue;
} else {
var event = cljs.core.first(seq__25521__$1);
clear_event(event);


var G__25604 = cljs.core.next(seq__25521__$1);
var G__25605 = null;
var G__25606 = (0);
var G__25607 = (0);
seq__25521 = G__25604;
chunk__25522 = G__25605;
count__25523 = G__25606;
i__25524 = G__25607;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
