goog.provide('ajax.xml_http_request');
goog.require('cljs.core');
goog.require('ajax.protocols');
goog.require('goog.string');
ajax.xml_http_request.ready_state = (function ajax$xml_http_request$ready_state(e){
var G__31419 = e.target.readyState;
var fexpr__31418 = new cljs.core.PersistentArrayMap(null, 6, [(0),new cljs.core.Keyword(null,"not-initialized","not-initialized",-1937378906),(1),new cljs.core.Keyword(null,"connection-established","connection-established",-1403749733),(2),new cljs.core.Keyword(null,"request-received","request-received",2110590540),(3),new cljs.core.Keyword(null,"processing-request","processing-request",-264947221),(4),new cljs.core.Keyword(null,"response-ready","response-ready",245208276),new cljs.core.Keyword("cljs.analyzer","analyzed","cljs.analyzer/analyzed",-735094162),true], null);
return (fexpr__31418.cljs$core$IFn$_invoke$arity$1 ? fexpr__31418.cljs$core$IFn$_invoke$arity$1(G__31419) : fexpr__31418.call(null,G__31419));
});
ajax.xml_http_request.append = (function ajax$xml_http_request$append(current,next){
if(cljs.core.truth_(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current),", ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(next)].join('');
} else {
return next;
}
});
ajax.xml_http_request.process_headers = (function ajax$xml_http_request$process_headers(header_str){
if(cljs.core.truth_(header_str)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (headers,header_line){
if(cljs.core.truth_(goog.string.isEmptyOrWhitespace(header_line))){
return headers;
} else {
var key_value = goog.string.splitLimit(header_line,": ",(2));
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(headers,(key_value[(0)]),ajax.xml_http_request.append,(key_value[(1)]));
}
}),cljs.core.PersistentArrayMap.EMPTY,header_str.split("\r\n"));
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
ajax.xml_http_request.xmlhttprequest = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_target_STAR_,"nodejs"))?(function (){var xmlhttprequest = require("xmlhttprequest").XMLHttpRequest;
goog.object.set(global,"XMLHttpRequest",xmlhttprequest);

return xmlhttprequest;
})():XMLHttpRequest);
(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$_js_ajax_request$arity$3 = (function (this$,p__31421,handler){
var map__31422 = p__31421;
var map__31422__$1 = (((((!((map__31422 == null))))?(((((map__31422.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31422.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31422):map__31422);
var uri = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31422__$1,new cljs.core.Keyword(null,"uri","uri",-774711847));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31422__$1,new cljs.core.Keyword(null,"method","method",55703592));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31422__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31422__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31422__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(0));
var with_credentials = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31422__$1,new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235),false);
var response_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31422__$1,new cljs.core.Keyword(null,"response-format","response-format",1664465322));
var this$__$1 = this;
(this$__$1.withCredentials = with_credentials);

(this$__$1.onreadystatechange = (function (p1__31420_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"response-ready","response-ready",245208276),ajax.xml_http_request.ready_state(p1__31420_SHARP_))){
return (handler.cljs$core$IFn$_invoke$arity$1 ? handler.cljs$core$IFn$_invoke$arity$1(this$__$1) : handler.call(null,this$__$1));
} else {
return null;
}
}));

this$__$1.open(method,uri,true);

(this$__$1.timeout = timeout);

var temp__5735__auto___31440 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(response_format);
if(cljs.core.truth_(temp__5735__auto___31440)){
var response_type_31441 = temp__5735__auto___31440;
(this$__$1.responseType = cljs.core.name(response_type_31441));
} else {
}

var seq__31424_31442 = cljs.core.seq(headers);
var chunk__31425_31443 = null;
var count__31426_31444 = (0);
var i__31427_31445 = (0);
while(true){
if((i__31427_31445 < count__31426_31444)){
var vec__31434_31446 = chunk__31425_31443.cljs$core$IIndexed$_nth$arity$2(null,i__31427_31445);
var k_31447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31434_31446,(0),null);
var v_31448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31434_31446,(1),null);
this$__$1.setRequestHeader(k_31447,v_31448);


var G__31449 = seq__31424_31442;
var G__31450 = chunk__31425_31443;
var G__31451 = count__31426_31444;
var G__31452 = (i__31427_31445 + (1));
seq__31424_31442 = G__31449;
chunk__31425_31443 = G__31450;
count__31426_31444 = G__31451;
i__31427_31445 = G__31452;
continue;
} else {
var temp__5735__auto___31453 = cljs.core.seq(seq__31424_31442);
if(temp__5735__auto___31453){
var seq__31424_31454__$1 = temp__5735__auto___31453;
if(cljs.core.chunked_seq_QMARK_(seq__31424_31454__$1)){
var c__4609__auto___31455 = cljs.core.chunk_first(seq__31424_31454__$1);
var G__31456 = cljs.core.chunk_rest(seq__31424_31454__$1);
var G__31457 = c__4609__auto___31455;
var G__31458 = cljs.core.count(c__4609__auto___31455);
var G__31459 = (0);
seq__31424_31442 = G__31456;
chunk__31425_31443 = G__31457;
count__31426_31444 = G__31458;
i__31427_31445 = G__31459;
continue;
} else {
var vec__31437_31460 = cljs.core.first(seq__31424_31454__$1);
var k_31461 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31437_31460,(0),null);
var v_31462 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31437_31460,(1),null);
this$__$1.setRequestHeader(k_31461,v_31462);


var G__31463 = cljs.core.next(seq__31424_31454__$1);
var G__31464 = null;
var G__31465 = (0);
var G__31466 = (0);
seq__31424_31442 = G__31463;
chunk__31425_31443 = G__31464;
count__31426_31444 = G__31465;
i__31427_31445 = G__31466;
continue;
}
} else {
}
}
break;
}

this$__$1.send((function (){var or__4185__auto__ = body;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "";
}
})());

return this$__$1;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$_abort$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.abort();
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_body$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.response;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.status;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status_text$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.statusText;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_all_headers$arity$1 = (function (this$){
var this$__$1 = this;
return ajax.xml_http_request.process_headers(this$__$1.getAllResponseHeaders());
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_response_header$arity$2 = (function (this$,header){
var this$__$1 = this;
return this$__$1.getResponseHeader(header);
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_was_aborted$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),this$__$1.readyState);
}));

//# sourceMappingURL=ajax.xml_http_request.js.map
