goog.provide('day8.re_frame_10x.utils.localstorage');
goog.require('cljs.core');
goog.require('goog.storage.Storage');
goog.require('goog.storage.mechanism.HTML5LocalStorage');
goog.require('cljs.reader');
goog.require('clojure.string');
day8.re_frame_10x.utils.localstorage.storage = (new goog.storage.Storage((new goog.storage.mechanism.HTML5LocalStorage())));
day8.re_frame_10x.utils.localstorage.safe_prefix = "day8.re-frame-10x.";
day8.re_frame_10x.utils.localstorage.safe_key = (function day8$re_frame_10x$utils$localstorage$safe_key(key){

return [day8.re_frame_10x.utils.localstorage.safe_prefix,cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
});
/**
 * Gets a re-frame-10x value from local storage.
 */
day8.re_frame_10x.utils.localstorage.get = (function day8$re_frame_10x$utils$localstorage$get(var_args){
var G__39552 = arguments.length;
switch (G__39552) {
case 1:
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$1 = (function (key){
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2(key,null);
}));

(day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var value = day8.re_frame_10x.utils.localstorage.storage.get(day8.re_frame_10x.utils.localstorage.safe_key(key));
if((void 0 === value)){
return not_found;
} else {
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(value);
}
}));

(day8.re_frame_10x.utils.localstorage.get.cljs$lang$maxFixedArity = 2);

/**
 * Saves a re-frame-10x value to local storage.
 */
day8.re_frame_10x.utils.localstorage.save_BANG_ = (function day8$re_frame_10x$utils$localstorage$save_BANG_(key,value){
return day8.re_frame_10x.utils.localstorage.storage.set(day8.re_frame_10x.utils.localstorage.safe_key(key),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value], 0)));
});
/**
 * Deletes all re-frame-10x config keys
 */
day8.re_frame_10x.utils.localstorage.delete_all_keys_BANG_ = (function day8$re_frame_10x$utils$localstorage$delete_all_keys_BANG_(){
var seq__39565 = cljs.core.seq(Object.keys(localStorage));
var chunk__39566 = null;
var count__39567 = (0);
var i__39568 = (0);
while(true){
if((i__39568 < count__39567)){
var k = chunk__39566.cljs$core$IIndexed$_nth$arity$2(null,i__39568);
if(clojure.string.starts_with_QMARK_(k,day8.re_frame_10x.utils.localstorage.safe_prefix)){
day8.re_frame_10x.utils.localstorage.storage.remove(k);
} else {
}


var G__39606 = seq__39565;
var G__39607 = chunk__39566;
var G__39608 = count__39567;
var G__39609 = (i__39568 + (1));
seq__39565 = G__39606;
chunk__39566 = G__39607;
count__39567 = G__39608;
i__39568 = G__39609;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__39565);
if(temp__5735__auto__){
var seq__39565__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39565__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__39565__$1);
var G__39614 = cljs.core.chunk_rest(seq__39565__$1);
var G__39615 = c__4609__auto__;
var G__39616 = cljs.core.count(c__4609__auto__);
var G__39617 = (0);
seq__39565 = G__39614;
chunk__39566 = G__39615;
count__39567 = G__39616;
i__39568 = G__39617;
continue;
} else {
var k = cljs.core.first(seq__39565__$1);
if(clojure.string.starts_with_QMARK_(k,day8.re_frame_10x.utils.localstorage.safe_prefix)){
day8.re_frame_10x.utils.localstorage.storage.remove(k);
} else {
}


var G__39618 = cljs.core.next(seq__39565__$1);
var G__39619 = null;
var G__39620 = (0);
var G__39621 = (0);
seq__39565 = G__39618;
chunk__39566 = G__39619;
count__39567 = G__39620;
i__39568 = G__39621;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=day8.re_frame_10x.utils.localstorage.js.map
