goog.provide('chord.client');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('chord.channels');
goog.require('chord.format');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e51738){var e = e51738;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4795__auto__ = [];
var len__4789__auto___51850 = arguments.length;
var i__4790__auto___51851 = (0);
while(true){
if((i__4790__auto___51851 < len__4789__auto___51850)){
args__4795__auto__.push((arguments[i__4790__auto___51851]));

var G__51852 = (i__4790__auto___51851 + (1));
i__4790__auto___51851 = G__51852;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__51743){
var vec__51744 = p__51743;
var map__51747 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51744,(0),null);
var map__51747__$1 = (((((!((map__51747 == null))))?(((((map__51747.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51747.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51747):map__51747);
var opts = map__51747__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51747__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51747__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51747__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51747__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__51749 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4185__auto__ = read_ch;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4185__auto__ = write_ch;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__51749__$1 = (((((!((map__51749 == null))))?(((((map__51749.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51749.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51749):map__51749);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51749__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51749__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__51739_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__51739_SHARP_);
}));

(web_socket.onclose = (function (p1__51740_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__51740_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__42129__auto___51853 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42130__auto__ = (function (){var switch__42062__auto__ = (function (state_51816){
var state_val_51817 = (state_51816[(1)]);
if((state_val_51817 === (7))){
var inst_51812 = (state_51816[(2)]);
var state_51816__$1 = state_51816;
var statearr_51818_51854 = state_51816__$1;
(statearr_51818_51854[(2)] = inst_51812);

(statearr_51818_51854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (20))){
var state_51816__$1 = state_51816;
var statearr_51819_51855 = state_51816__$1;
(statearr_51819_51855[(2)] = null);

(statearr_51819_51855[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (1))){
var inst_51751 = false;
var state_51816__$1 = (function (){var statearr_51820 = state_51816;
(statearr_51820[(7)] = inst_51751);

return statearr_51820;
})();
var statearr_51821_51856 = state_51816__$1;
(statearr_51821_51856[(2)] = null);

(statearr_51821_51856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (4))){
var inst_51764 = (state_51816[(8)]);
var inst_51766 = (state_51816[(9)]);
var inst_51764__$1 = (state_51816[(2)]);
var inst_51765 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_51764__$1,(0),null);
var inst_51766__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_51764__$1,(1),null);
var inst_51767 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_51766__$1,open_ch);
var state_51816__$1 = (function (){var statearr_51822 = state_51816;
(statearr_51822[(8)] = inst_51764__$1);

(statearr_51822[(9)] = inst_51766__$1);

(statearr_51822[(10)] = inst_51765);

return statearr_51822;
})();
if(inst_51767){
var statearr_51823_51857 = state_51816__$1;
(statearr_51823_51857[(1)] = (5));

} else {
var statearr_51824_51858 = state_51816__$1;
(statearr_51824_51858[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (15))){
var inst_51797 = (state_51816[(2)]);
var state_51816__$1 = state_51816;
var statearr_51825_51859 = state_51816__$1;
(statearr_51825_51859[(2)] = inst_51797);

(statearr_51825_51859[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (21))){
var inst_51808 = (state_51816[(2)]);
var state_51816__$1 = state_51816;
var statearr_51826_51860 = state_51816__$1;
(statearr_51826_51860[(2)] = inst_51808);

(statearr_51826_51860[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (13))){
var state_51816__$1 = state_51816;
var statearr_51827_51861 = state_51816__$1;
(statearr_51827_51861[(2)] = null);

(statearr_51827_51861[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (6))){
var inst_51766 = (state_51816[(9)]);
var inst_51781 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_51766,close_ch);
var state_51816__$1 = state_51816;
if(inst_51781){
var statearr_51828_51862 = state_51816__$1;
(statearr_51828_51862[(1)] = (9));

} else {
var statearr_51829_51863 = state_51816__$1;
(statearr_51829_51863[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (17))){
var state_51816__$1 = state_51816;
var statearr_51830_51864 = state_51816__$1;
(statearr_51830_51864[(2)] = initial_ch);

(statearr_51830_51864[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (3))){
var inst_51814 = (state_51816[(2)]);
var state_51816__$1 = state_51816;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51816__$1,inst_51814);
} else {
if((state_val_51817 === (12))){
var inst_51751 = (state_51816[(7)]);
var state_51816__$1 = state_51816;
if(cljs.core.truth_(inst_51751)){
var statearr_51831_51865 = state_51816__$1;
(statearr_51831_51865[(1)] = (16));

} else {
var statearr_51832_51866 = state_51816__$1;
(statearr_51832_51866[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (2))){
var inst_51760 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_51761 = [open_ch,close_ch];
var inst_51762 = (new cljs.core.PersistentVector(null,2,(5),inst_51760,inst_51761,null));
var state_51816__$1 = state_51816;
return cljs.core.async.ioc_alts_BANG_(state_51816__$1,(4),inst_51762);
} else {
if((state_val_51817 === (19))){
var inst_51765 = (state_51816[(10)]);
var state_51816__$1 = state_51816;
var statearr_51833_51867 = state_51816__$1;
(statearr_51833_51867[(2)] = inst_51765);

(statearr_51833_51867[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (11))){
var inst_51810 = (state_51816[(2)]);
var state_51816__$1 = state_51816;
var statearr_51834_51868 = state_51816__$1;
(statearr_51834_51868[(2)] = inst_51810);

(statearr_51834_51868[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (9))){
var inst_51764 = (state_51816[(8)]);
var inst_51787 = (state_51816[(11)]);
var inst_51786 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_51764,(0),null);
var inst_51787__$1 = chord.client.close_event__GT_maybe_error(inst_51786);
var state_51816__$1 = (function (){var statearr_51835 = state_51816;
(statearr_51835[(11)] = inst_51787__$1);

return statearr_51835;
})();
if(cljs.core.truth_(inst_51787__$1)){
var statearr_51836_51869 = state_51816__$1;
(statearr_51836_51869[(1)] = (12));

} else {
var statearr_51837_51870 = state_51816__$1;
(statearr_51837_51870[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (5))){
var inst_51764 = (state_51816[(8)]);
var inst_51772 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_51764,(0),null);
var inst_51773 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_51774 = [ws_chan];
var inst_51775 = cljs.core.PersistentHashMap.fromArrays(inst_51773,inst_51774);
var state_51816__$1 = (function (){var statearr_51838 = state_51816;
(statearr_51838[(12)] = inst_51772);

return statearr_51838;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_51816__$1,(8),initial_ch,inst_51775);
} else {
if((state_val_51817 === (14))){
var inst_51800 = (state_51816[(2)]);
var inst_51801 = cljs.core.async.close_BANG_(ws_chan);
var inst_51802 = cljs.core.async.close_BANG_(initial_ch);
var state_51816__$1 = (function (){var statearr_51839 = state_51816;
(statearr_51839[(13)] = inst_51800);

(statearr_51839[(14)] = inst_51801);

return statearr_51839;
})();
var statearr_51840_51871 = state_51816__$1;
(statearr_51840_51871[(2)] = inst_51802);

(statearr_51840_51871[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (16))){
var state_51816__$1 = state_51816;
var statearr_51841_51872 = state_51816__$1;
(statearr_51841_51872[(2)] = read_ch__$1);

(statearr_51841_51872[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (10))){
var inst_51766 = (state_51816[(9)]);
var inst_51804 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_51766,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_51816__$1 = state_51816;
if(inst_51804){
var statearr_51842_51873 = state_51816__$1;
(statearr_51842_51873[(1)] = (19));

} else {
var statearr_51843_51874 = state_51816__$1;
(statearr_51843_51874[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51817 === (18))){
var inst_51787 = (state_51816[(11)]);
var inst_51792 = (state_51816[(2)]);
var inst_51793 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_51794 = [inst_51787];
var inst_51795 = cljs.core.PersistentHashMap.fromArrays(inst_51793,inst_51794);
var state_51816__$1 = state_51816;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_51816__$1,(15),inst_51792,inst_51795);
} else {
if((state_val_51817 === (8))){
var inst_51777 = (state_51816[(2)]);
var inst_51778 = cljs.core.async.close_BANG_(initial_ch);
var inst_51751 = true;
var state_51816__$1 = (function (){var statearr_51844 = state_51816;
(statearr_51844[(7)] = inst_51751);

(statearr_51844[(15)] = inst_51778);

(statearr_51844[(16)] = inst_51777);

return statearr_51844;
})();
var statearr_51845_51875 = state_51816__$1;
(statearr_51845_51875[(2)] = null);

(statearr_51845_51875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__42063__auto__ = null;
var chord$client$state_machine__42063__auto____0 = (function (){
var statearr_51846 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51846[(0)] = chord$client$state_machine__42063__auto__);

(statearr_51846[(1)] = (1));

return statearr_51846;
});
var chord$client$state_machine__42063__auto____1 = (function (state_51816){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_51816);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e51847){if((e51847 instanceof Object)){
var ex__42066__auto__ = e51847;
var statearr_51848_51876 = state_51816;
(statearr_51848_51876[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51816);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51847;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51877 = state_51816;
state_51816 = G__51877;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
chord$client$state_machine__42063__auto__ = function(state_51816){
switch(arguments.length){
case 0:
return chord$client$state_machine__42063__auto____0.call(this);
case 1:
return chord$client$state_machine__42063__auto____1.call(this,state_51816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__42063__auto____0;
chord$client$state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__42063__auto____1;
return chord$client$state_machine__42063__auto__;
})()
})();
var state__42131__auto__ = (function (){var statearr_51849 = (f__42130__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42130__auto__.cljs$core$IFn$_invoke$arity$0() : f__42130__auto__.call(null));
(statearr_51849[(6)] = c__42129__auto___51853);

return statearr_51849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42131__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq51741){
var G__51742 = cljs.core.first(seq51741);
var seq51741__$1 = cljs.core.next(seq51741);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__51742,seq51741__$1);
}));


//# sourceMappingURL=chord.client.js.map
