goog.provide('day8.re_frame_10x.utils.localstorage');
goog.require('cljs.core');
goog.require('goog.storage.Storage');
goog.require('goog.storage.mechanism.HTML5LocalStorage');
goog.require('cljs.reader');
goog.require('clojure.string');
day8.re_frame_10x.utils.localstorage.storage = (new goog.storage.Storage((new goog.storage.mechanism.HTML5LocalStorage())));
day8.re_frame_10x.utils.localstorage.safe_prefix = "day8.re-frame-10x.";
day8.re_frame_10x.utils.localstorage.safe_key = (function day8$re_frame_10x$utils$localstorage$safe_key(key){

return [day8.re_frame_10x.utils.localstorage.safe_prefix,cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
});
/**
 * Gets a re-frame-10x value from local storage.
 */
day8.re_frame_10x.utils.localstorage.get = (function day8$re_frame_10x$utils$localstorage$get(var_args){
var G__39626 = arguments.length;
switch (G__39626) {
case 1:
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$1 = (function (key){
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2(key,null);
}));

(day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var value = day8.re_frame_10x.utils.localstorage.storage.get(day8.re_frame_10x.utils.localstorage.safe_key(key));
if((void 0 === value)){
return not_found;
} else {
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(value);
}
}));

(day8.re_frame_10x.utils.localstorage.get.cljs$lang$maxFixedArity = 2);

/**
 * Saves a re-frame-10x value to local storage.
 */
day8.re_frame_10x.utils.localstorage.save_BANG_ = (function day8$re_frame_10x$utils$localstorage$save_BANG_(key,value){
return day8.re_frame_10x.utils.localstorage.storage.set(day8.re_frame_10x.utils.localstorage.safe_key(key),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value], 0)));
});
/**
 * Deletes all re-frame-10x config keys
 */
day8.re_frame_10x.utils.localstorage.delete_all_keys_BANG_ = (function day8$re_frame_10x$utils$localstorage$delete_all_keys_BANG_(){
var seq__39642 = cljs.core.seq(Object.keys(localStorage));
var chunk__39643 = null;
var count__39644 = (0);
var i__39645 = (0);
while(true){
if((i__39645 < count__39644)){
var k = chunk__39643.cljs$core$IIndexed$_nth$arity$2(null,i__39645);
if(clojure.string.starts_with_QMARK_(k,day8.re_frame_10x.utils.localstorage.safe_prefix)){
day8.re_frame_10x.utils.localstorage.storage.remove(k);
} else {
}


var G__39674 = seq__39642;
var G__39675 = chunk__39643;
var G__39676 = count__39644;
var G__39677 = (i__39645 + (1));
seq__39642 = G__39674;
chunk__39643 = G__39675;
count__39644 = G__39676;
i__39645 = G__39677;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__39642);
if(temp__5735__auto__){
var seq__39642__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39642__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__39642__$1);
var G__39678 = cljs.core.chunk_rest(seq__39642__$1);
var G__39679 = c__4609__auto__;
var G__39680 = cljs.core.count(c__4609__auto__);
var G__39681 = (0);
seq__39642 = G__39678;
chunk__39643 = G__39679;
count__39644 = G__39680;
i__39645 = G__39681;
continue;
} else {
var k = cljs.core.first(seq__39642__$1);
if(clojure.string.starts_with_QMARK_(k,day8.re_frame_10x.utils.localstorage.safe_prefix)){
day8.re_frame_10x.utils.localstorage.storage.remove(k);
} else {
}


var G__39682 = cljs.core.next(seq__39642__$1);
var G__39683 = null;
var G__39684 = (0);
var G__39685 = (0);
seq__39642 = G__39682;
chunk__39643 = G__39683;
count__39644 = G__39684;
i__39645 = G__39685;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=day8.re_frame_10x.utils.localstorage.js.map
