goog.provide('pinkgorilla.kernel.nrepl');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('cljs_uuid_utils.core');
goog.require('clojure.walk');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('chord.client');
goog.require('re_frame.core');
goog.require('pinkgorilla.notifications');
goog.require('pinkgorilla.kernel.cljs_helper');
/**
 * rendering via the Renderable protocol (needs renderable project)
 * (users can define their own render implementations)
 * identical to cljs version, except for non meta rendering it will not
 * call render, as this already has been rendered in the clj kernel
 */
pinkgorilla.kernel.nrepl.render_renderable_meta = (function pinkgorilla$kernel$nrepl$render_renderable_meta(result){
var m = cljs.core.meta(result);
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942),((cljs.core.contains_QMARK_(m,new cljs.core.Keyword(null,"r","r",-471384190)))?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"reagent-cljs","reagent-cljs",1666311021),new cljs.core.Keyword(null,"reagent","reagent",2131627322),result,new cljs.core.Keyword(null,"map-keywords","map-keywords",-170077571),false], null):((cljs.core.contains_QMARK_(m,new cljs.core.Keyword(null,"R","R",-936662523)))?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"reagent-cljs","reagent-cljs",1666311021),new cljs.core.Keyword(null,"reagent","reagent",2131627322),result,new cljs.core.Keyword(null,"map-keywords","map-keywords",-170077571),true], null):result
))], null);
});
if((typeof pinkgorilla !== 'undefined') && (typeof pinkgorilla.kernel !== 'undefined') && (typeof pinkgorilla.kernel.nrepl !== 'undefined') && (typeof pinkgorilla.kernel.nrepl.ws_repl !== 'undefined')){
} else {
pinkgorilla.kernel.nrepl.ws_repl = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"channel","channel",734187692),null,new cljs.core.Keyword(null,"session-id","session-id",-1147060351),null,new cljs.core.Keyword(null,"evaluations","evaluations",57802423),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ciders","ciders",-1421942407),cljs.core.PersistentArrayMap.EMPTY], null));
}
/**
 * awb99: TODO: if websocket is nil, this will throw! (or not?).
 * This could be the error of some of the notebooks not loading.
 * Why dont we keep the core.async channels open all the time. And when we have a
 * websocket connection, then the messages get sent. Or we just dump messages that happen
 * before the socket gets opened. But in this case we have to LOG message dumping.
 * I have seen situations where the first eval does not go through. Might be this issue.
 * 
 */
pinkgorilla.kernel.nrepl.send_message_BANG_ = (function pinkgorilla$kernel$nrepl$send_message_BANG_(key,message,storeval){
var eval_id = cljs_uuid_utils.core.uuid_string(cljs_uuid_utils.core.make_random_uuid());
var nrepl_msg = cljs.core.clj__GT_js(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),eval_id,new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"session-id","session-id",-1147060351).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl))], null)], 0)));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(eval_id)], null),storeval);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl)),nrepl_msg);

return eval_id;
});
pinkgorilla.kernel.nrepl.eval_BANG_ = (function pinkgorilla$kernel$nrepl$eval_BANG_(segment_id,content){
return pinkgorilla.kernel.nrepl.send_message_BANG_(new cljs.core.Keyword(null,"evaluations","evaluations",57802423),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),"eval",new cljs.core.Keyword(null,"code","code",1586293142),content], null),segment_id);
});
pinkgorilla.kernel.nrepl.send_cider_message_BANG_ = (function pinkgorilla$kernel$nrepl$send_cider_message_BANG_(message,storeval){
return pinkgorilla.kernel.nrepl.send_message_BANG_(new cljs.core.Keyword(null,"ciders","ciders",-1421942407),message,storeval);
});
/**
 * Query the REPL server for autocompletion suggestions. Relies on the cider-nrepl middleware.
 *   We call the given callback with the list of symbols once the REPL server replies.
 */
pinkgorilla.kernel.nrepl.get_completions = (function pinkgorilla$kernel$nrepl$get_completions(symbol,ns,context,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"op","op",-1882987955),"complete",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns,new cljs.core.Keyword(null,"context","context",-830191113),context], null),(function (msg){
var G__51879 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__51878_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__51878_SHARP_,"candidate");
}),cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"completions"));
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__51879) : callback.call(null,G__51879));
}));
});
/**
 * Queries the REPL server for docs for the given symbol. Relies on the cider-nrepl middleware.
 *   Calls back with the documentation text
 */
pinkgorilla.kernel.nrepl.get_completion_doc = (function pinkgorilla$kernel$nrepl$get_completion_doc(symbol,ns,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"complete-doc",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null),(function (msg){
var G__51880 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"completion-doc");
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__51880) : callback.call(null,G__51880));
}));
});
/**
 * resolve a symbol to get its namespace takes the symbol and the namespace that should be used as context.
 *   Relies on the cider-nrepl middleware. Calls back with the symbol and the symbol's namespace
 */
pinkgorilla.kernel.nrepl.resolve_symbol = (function pinkgorilla$kernel$nrepl$resolve_symbol(symbol,ns,callback){
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"info",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null),(function (msg){
var G__51881 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"symbol","symbol",-1038572696),cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"name"),new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"ns")], null);
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__51881) : callback.call(null,G__51881));
}));
});
pinkgorilla.kernel.nrepl.parse_value = (function pinkgorilla$kernel$nrepl$parse_value(value){
var data = clojure.walk.keywordize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(JSON.parse(JSON.parse(value))));
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init759419009955081863.clj",103,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["value ",value," => ",data], null);
}),null)),null,2002099821);
return data;
});
/**
 * processes an incoming message from websocket that comes from nrepl (and has cider enhancements)
 * dispatches events to reagent to update notebook state ui.
 *   
 */
pinkgorilla.kernel.nrepl.process_msg = (function pinkgorilla$kernel$nrepl$process_msg(message){
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"id"));
var out = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"out");
var err = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"err");
var root_ex = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"root-ex");
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"ns");
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"value");
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"status");
var segment_id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluations","evaluations",57802423),id], null));
var cider_cb = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(pinkgorilla.kernel.nrepl.ws_repl),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ciders","ciders",-1421942407),id], null));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init759419009955081863.clj",120,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got message",id,"for segment",segment_id], null);
}),null)),null,1896304481);

if(cljs.core.truth_(segment_id)){
if(cljs.core.truth_(ns)){
var data = pinkgorilla.kernel.nrepl.parse_value(value);
return pinkgorilla.kernel.cljs_helper.send_value.cljs$core$IFn$_invoke$arity$3(segment_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942),data], null),ns);
} else {
if(cljs.core.truth_(out)){
var G__51882 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:console-response","evaluator:console-response",-650807352),segment_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"console-response","console-response",81719661),out], null)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__51882) : re_frame.core.dispatch.call(null,G__51882));
} else {
if(cljs.core.truth_(err)){
var error = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error-text","error-text",2021893718),err,new cljs.core.Keyword(null,"segment-id","segment-id",1810133590),segment_id], null));
return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op","op",-1882987955),"stacktrace"], null),(function (msg){
var status__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(msg,"status");
if(cljs.core.truth_((function (){var and__4174__auto__ = status__$1;
if(cljs.core.truth_(and__4174__auto__)){
return (status__$1.indexOf("done") >= (0));
} else {
return and__4174__auto__;
}
})())){
var G__51883 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:error-response","evaluator:error-response",1375419587),cljs.core.deref(error)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__51883) : re_frame.core.dispatch.call(null,G__51883));
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(error,(function (err__$1,ex){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(err__$1,new cljs.core.Keyword(null,"exception","exception",-335277064)))){
return cljs.core.assoc_in(err__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"cause","cause",231901252)], null),new cljs.core.Keyword(null,"exception","exception",-335277064).cljs$core$IFn$_invoke$arity$1(ex));
} else {
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ex,err__$1], 0));
}
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"exception","exception",-335277064),msg], null));
}
}));
} else {
if(cljs.core.truth_(root_ex)){
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init759419009955081863.clj",160,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got root-ex",root_ex,"for",segment_id], null);
}),null)),null,-387366846);
} else {
if((status.indexOf("done") >= (0))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluations","evaluations",57802423),id], null));

var G__51884 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"evaluator:done-response","evaluator:done-response",1140676326),segment_id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__51884) : re_frame.core.dispatch.call(null,G__51884));
} else {
return null;
}
}
}
}
}
} else {
if(cljs.core.truth_(cider_cb)){
(cider_cb.cljs$core$IFn$_invoke$arity$1 ? cider_cb.cljs$core$IFn$_invoke$arity$1(message) : cider_cb.call(null,message));

if(cljs.core.truth_((function (){var and__4174__auto__ = status;
if(cljs.core.truth_(and__4174__auto__)){
return (status.indexOf("done") >= (0));
} else {
return and__4174__auto__;
}
})())){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ciders","ciders",-1421942407),id], null));
} else {
return null;
}
} else {
return null;
}
}
});
pinkgorilla.kernel.nrepl.set_clj_kernel_status = (function pinkgorilla$kernel$nrepl$set_clj_kernel_status(connected,session_id){
var G__51885 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"kernel-clj-status-set","kernel-clj-status-set",-1158664458),connected,session_id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__51885) : re_frame.core.dispatch.call(null,G__51885));
});
pinkgorilla.kernel.nrepl.receive_msgs_BANG_ = (function pinkgorilla$kernel$nrepl$receive_msgs_BANG_(server_ch){
var c__42129__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42130__auto__ = (function (){var switch__42062__auto__ = (function (state_51972){
var state_val_51973 = (state_51972[(1)]);
if((state_val_51973 === (7))){
var state_51972__$1 = state_51972;
var statearr_51974_52145 = state_51972__$1;
(statearr_51974_52145[(2)] = false);

(statearr_51974_52145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51973 === (1))){
var state_51972__$1 = state_51972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51972__$1,(2),server_ch);
} else {
if((state_val_51973 === (4))){
var state_51972__$1 = state_51972;
var statearr_51975_52146 = state_51972__$1;
(statearr_51975_52146[(2)] = false);

(statearr_51975_52146[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51973 === (13))){
var inst_51911 = (state_51972[(7)]);
var inst_51965 = ["clj-kernel Fatal Error : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_51911)," - Unable to create session. Game over"].join('');
var inst_51966 = pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"danger","danger",-624338030),inst_51965);
var inst_51967 = pinkgorilla.notifications.add_notification(inst_51966);
var inst_51968 = pinkgorilla.kernel.nrepl.set_clj_kernel_status(false,null);
var state_51972__$1 = (function (){var statearr_51976 = state_51972;
(statearr_51976[(8)] = inst_51967);

return statearr_51976;
})();
var statearr_51977_52147 = state_51972__$1;
(statearr_51977_52147[(2)] = inst_51968);

(statearr_51977_52147[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51973 === (6))){
var state_51972__$1 = state_51972;
var statearr_51978_52148 = state_51972__$1;
(statearr_51978_52148[(2)] = true);

(statearr_51978_52148[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51973 === (3))){
var inst_51888 = (state_51972[(9)]);
var inst_51893 = inst_51888.cljs$lang$protocol_mask$partition0$;
var inst_51894 = (inst_51893 & (64));
var inst_51895 = inst_51888.cljs$core$ISeq$;
var inst_51896 = (cljs.core.PROTOCOL_SENTINEL === inst_51895);
var inst_51897 = ((inst_51894) || (inst_51896));
var state_51972__$1 = state_51972;
if(cljs.core.truth_(inst_51897)){
var statearr_51979_52150 = state_51972__$1;
(statearr_51979_52150[(1)] = (6));

} else {
var statearr_51980_52151 = state_51972__$1;
(statearr_51980_52151[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51973 === (12))){
var inst_51911 = (state_51972[(7)]);
var inst_51915 = (state_51972[(10)]);
var inst_51910 = (state_51972[(11)]);
var inst_51909 = (state_51972[(12)]);
var inst_51917 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc,new cljs.core.Keyword(null,"session-id","session-id",-1147060351),inst_51915);
var inst_51918 = pinkgorilla.kernel.nrepl.set_clj_kernel_status(true,inst_51915);
var inst_51961 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_51962 = (function (){var map__51886 = inst_51909;
var message = inst_51910;
var error = inst_51911;
var temp__5733__auto__ = inst_51915;
var new_session = inst_51915;
var c__42129__auto____$1 = inst_51961;
return (function (){
var f__42130__auto__ = (function (){var switch__42062__auto__ = (function (state_51959){
var state_val_51960 = (state_51959[(1)]);
if((state_val_51960 === (7))){
var inst_51938 = (state_51959[(2)]);
var state_51959__$1 = state_51959;
if(cljs.core.truth_(inst_51938)){
var statearr_51981_52153 = state_51959__$1;
(statearr_51981_52153[(1)] = (11));

} else {
var statearr_51982_52154 = state_51959__$1;
(statearr_51982_52154[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51960 === (1))){
var state_51959__$1 = state_51959;
var statearr_51983_52155 = state_51959__$1;
(statearr_51983_52155[(2)] = null);

(statearr_51983_52155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51960 === (4))){
var inst_51922 = (state_51959[(7)]);
var inst_51922__$1 = (state_51959[(2)]);
var inst_51924 = (inst_51922__$1 == null);
var inst_51925 = cljs.core.not(inst_51924);
var state_51959__$1 = (function (){var statearr_51984 = state_51959;
(statearr_51984[(7)] = inst_51922__$1);

return statearr_51984;
})();
if(inst_51925){
var statearr_51985_52157 = state_51959__$1;
(statearr_51985_52157[(1)] = (5));

} else {
var statearr_51986_52158 = state_51959__$1;
(statearr_51986_52158[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51960 === (15))){
var inst_51945 = (state_51959[(8)]);
var inst_51950 = ["clj-kernel Fatal Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_51945)," - Game over"].join('');
var inst_51951 = pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"danger","danger",-624338030),inst_51950);
var inst_51952 = pinkgorilla.notifications.add_notification(inst_51951);
var inst_51953 = pinkgorilla.kernel.nrepl.set_clj_kernel_status(false,null);
var state_51959__$1 = (function (){var statearr_51987 = state_51959;
(statearr_51987[(9)] = inst_51952);

return statearr_51987;
})();
var statearr_51988_52160 = state_51959__$1;
(statearr_51988_52160[(2)] = inst_51953);

(statearr_51988_52160[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51960 === (13))){
var inst_51944 = (state_51959[(10)]);
var inst_51943 = (state_51959[(2)]);
var inst_51944__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51943,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_51945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51943,new cljs.core.Keyword(null,"error","error",-978969032));
var state_51959__$1 = (function (){var statearr_51990 = state_51959;
(statearr_51990[(8)] = inst_51945);

(statearr_51990[(10)] = inst_51944__$1);

return statearr_51990;
})();
if(cljs.core.truth_(inst_51944__$1)){
var statearr_51991_52161 = state_51959__$1;
(statearr_51991_52161[(1)] = (14));

} else {
var statearr_51992_52162 = state_51959__$1;
(statearr_51992_52162[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51960 === (6))){
var state_51959__$1 = state_51959;
var statearr_51994_52163 = state_51959__$1;
(statearr_51994_52163[(2)] = false);

(statearr_51994_52163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51960 === (3))){
var inst_51957 = (state_51959[(2)]);
var state_51959__$1 = state_51959;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51959__$1,inst_51957);
} else {
if((state_val_51960 === (12))){
var inst_51922 = (state_51959[(7)]);
var state_51959__$1 = state_51959;
var statearr_51995_52164 = state_51959__$1;
(statearr_51995_52164[(2)] = inst_51922);

(statearr_51995_52164[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51960 === (2))){
var state_51959__$1 = state_51959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51959__$1,(4),server_ch);
} else {
if((state_val_51960 === (11))){
var inst_51922 = (state_51959[(7)]);
var inst_51940 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_51922);
var state_51959__$1 = state_51959;
var statearr_51996_52165 = state_51959__$1;
(statearr_51996_52165[(2)] = inst_51940);

(statearr_51996_52165[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51960 === (9))){
var state_51959__$1 = state_51959;
var statearr_51997_52166 = state_51959__$1;
(statearr_51997_52166[(2)] = false);

(statearr_51997_52166[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51960 === (5))){
var inst_51922 = (state_51959[(7)]);
var inst_51927 = inst_51922.cljs$lang$protocol_mask$partition0$;
var inst_51928 = (inst_51927 & (64));
var inst_51929 = inst_51922.cljs$core$ISeq$;
var inst_51930 = (cljs.core.PROTOCOL_SENTINEL === inst_51929);
var inst_51931 = ((inst_51928) || (inst_51930));
var state_51959__$1 = state_51959;
if(cljs.core.truth_(inst_51931)){
var statearr_51998_52167 = state_51959__$1;
(statearr_51998_52167[(1)] = (8));

} else {
var statearr_51999_52168 = state_51959__$1;
(statearr_51999_52168[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51960 === (14))){
var inst_51944 = (state_51959[(10)]);
var inst_51947 = pinkgorilla.kernel.nrepl.process_msg(inst_51944);
var state_51959__$1 = (function (){var statearr_52000 = state_51959;
(statearr_52000[(11)] = inst_51947);

return statearr_52000;
})();
var statearr_52001_52171 = state_51959__$1;
(statearr_52001_52171[(2)] = null);

(statearr_52001_52171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51960 === (16))){
var inst_51955 = (state_51959[(2)]);
var state_51959__$1 = state_51959;
var statearr_52002_52173 = state_51959__$1;
(statearr_52002_52173[(2)] = inst_51955);

(statearr_52002_52173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51960 === (10))){
var inst_51935 = (state_51959[(2)]);
var state_51959__$1 = state_51959;
var statearr_52003_52174 = state_51959__$1;
(statearr_52003_52174[(2)] = inst_51935);

(statearr_52003_52174[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51960 === (8))){
var state_51959__$1 = state_51959;
var statearr_52004_52176 = state_51959__$1;
(statearr_52004_52176[(2)] = true);

(statearr_52004_52176[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0 = (function (){
var statearr_52005 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52005[(0)] = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__);

(statearr_52005[(1)] = (1));

return statearr_52005;
});
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1 = (function (state_51959){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_51959);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52006){if((e52006 instanceof Object)){
var ex__42066__auto__ = e52006;
var statearr_52007_52178 = state_51959;
(statearr_52007_52178[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51959);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52006;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52179 = state_51959;
state_51959 = G__52179;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__ = function(state_51959){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1.call(this,state_51959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__;
})()
})();
var state__42131__auto__ = (function (){var statearr_52008 = (f__42130__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42130__auto__.cljs$core$IFn$_invoke$arity$0() : f__42130__auto__.call(null));
(statearr_52008[(6)] = c__42129__auto____$1);

return statearr_52008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42131__auto__);
});
})();
var inst_51963 = cljs.core.async.impl.dispatch.run(inst_51962);
var state_51972__$1 = (function (){var statearr_52009 = state_51972;
(statearr_52009[(13)] = inst_51963);

(statearr_52009[(14)] = inst_51917);

(statearr_52009[(15)] = inst_51918);

return statearr_52009;
})();
var statearr_52010_52181 = state_51972__$1;
(statearr_52010_52181[(2)] = inst_51961);

(statearr_52010_52181[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51973 === (2))){
var inst_51888 = (state_51972[(9)]);
var inst_51888__$1 = (state_51972[(2)]);
var inst_51890 = (inst_51888__$1 == null);
var inst_51891 = cljs.core.not(inst_51890);
var state_51972__$1 = (function (){var statearr_52011 = state_51972;
(statearr_52011[(9)] = inst_51888__$1);

return statearr_52011;
})();
if(inst_51891){
var statearr_52012_52182 = state_51972__$1;
(statearr_52012_52182[(1)] = (3));

} else {
var statearr_52013_52183 = state_51972__$1;
(statearr_52013_52183[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51973 === (11))){
var inst_51911 = (state_51972[(7)]);
var inst_51915 = (state_51972[(10)]);
var inst_51910 = (state_51972[(11)]);
var inst_51909 = (state_51972[(12)]);
var inst_51909__$1 = (state_51972[(2)]);
var inst_51910__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51909__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_51911__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51909__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var inst_51912 = (function (){var map__51886 = inst_51909__$1;
var message = inst_51910__$1;
var error = inst_51911__$1;
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got initial message ",message], null);
});
})();
var inst_51913 = (new cljs.core.Delay(inst_51912,null));
var inst_51914 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init759419009955081863.clj",183,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_51913,null,1746689740);
var inst_51915__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51910__$1,"new-session");
var state_51972__$1 = (function (){var statearr_52014 = state_51972;
(statearr_52014[(7)] = inst_51911__$1);

(statearr_52014[(10)] = inst_51915__$1);

(statearr_52014[(11)] = inst_51910__$1);

(statearr_52014[(12)] = inst_51909__$1);

(statearr_52014[(16)] = inst_51914);

return statearr_52014;
})();
if(cljs.core.truth_(inst_51915__$1)){
var statearr_52015_52184 = state_51972__$1;
(statearr_52015_52184[(1)] = (12));

} else {
var statearr_52016_52185 = state_51972__$1;
(statearr_52016_52185[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51973 === (9))){
var inst_51888 = (state_51972[(9)]);
var inst_51906 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_51888);
var state_51972__$1 = state_51972;
var statearr_52017_52186 = state_51972__$1;
(statearr_52017_52186[(2)] = inst_51906);

(statearr_52017_52186[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51973 === (5))){
var inst_51904 = (state_51972[(2)]);
var state_51972__$1 = state_51972;
if(cljs.core.truth_(inst_51904)){
var statearr_52018_52187 = state_51972__$1;
(statearr_52018_52187[(1)] = (9));

} else {
var statearr_52019_52188 = state_51972__$1;
(statearr_52019_52188[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51973 === (14))){
var inst_51970 = (state_51972[(2)]);
var state_51972__$1 = state_51972;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51972__$1,inst_51970);
} else {
if((state_val_51973 === (10))){
var inst_51888 = (state_51972[(9)]);
var state_51972__$1 = state_51972;
var statearr_52020_52189 = state_51972__$1;
(statearr_52020_52189[(2)] = inst_51888);

(statearr_52020_52189[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51973 === (8))){
var inst_51901 = (state_51972[(2)]);
var state_51972__$1 = state_51972;
var statearr_52021_52190 = state_51972__$1;
(statearr_52021_52190[(2)] = inst_51901);

(statearr_52021_52190[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0 = (function (){
var statearr_52022 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52022[(0)] = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__);

(statearr_52022[(1)] = (1));

return statearr_52022;
});
var pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1 = (function (state_51972){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_51972);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52023){if((e52023 instanceof Object)){
var ex__42066__auto__ = e52023;
var statearr_52024_52191 = state_51972;
(statearr_52024_52191[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51972);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52023;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52192 = state_51972;
state_51972 = G__52192;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__ = function(state_51972){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1.call(this,state_51972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$receive_msgs_BANG__$_state_machine__42063__auto__;
})()
})();
var state__42131__auto__ = (function (){var statearr_52025 = (f__42130__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42130__auto__.cljs$core$IFn$_invoke$arity$0() : f__42130__auto__.call(null));
(statearr_52025[(6)] = c__42129__auto__);

return statearr_52025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42131__auto__);
}));

return c__42129__auto__;
});
pinkgorilla.kernel.nrepl.send_msgs_BANG_ = (function pinkgorilla$kernel$nrepl$send_msgs_BANG_(new_msg_ch,server_ch){
var c__42129__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42130__auto__ = (function (){var switch__42062__auto__ = (function (state_52039){
var state_val_52040 = (state_52039[(1)]);
if((state_val_52040 === (1))){
var state_52039__$1 = state_52039;
var statearr_52041_52193 = state_52039__$1;
(statearr_52041_52193[(2)] = null);

(statearr_52041_52193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52040 === (2))){
var state_52039__$1 = state_52039;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52039__$1,(4),new_msg_ch);
} else {
if((state_val_52040 === (3))){
var inst_52037 = (state_52039[(2)]);
var state_52039__$1 = state_52039;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52039__$1,inst_52037);
} else {
if((state_val_52040 === (4))){
var inst_52028 = (state_52039[(7)]);
var inst_52028__$1 = (state_52039[(2)]);
var state_52039__$1 = (function (){var statearr_52042 = state_52039;
(statearr_52042[(7)] = inst_52028__$1);

return statearr_52042;
})();
if(cljs.core.truth_(inst_52028__$1)){
var statearr_52043_52194 = state_52039__$1;
(statearr_52043_52194[(1)] = (5));

} else {
var statearr_52044_52195 = state_52039__$1;
(statearr_52044_52195[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52040 === (5))){
var inst_52028 = (state_52039[(7)]);
var state_52039__$1 = state_52039;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52039__$1,(8),server_ch,inst_52028);
} else {
if((state_val_52040 === (6))){
var state_52039__$1 = state_52039;
var statearr_52045_52196 = state_52039__$1;
(statearr_52045_52196[(2)] = null);

(statearr_52045_52196[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52040 === (7))){
var inst_52035 = (state_52039[(2)]);
var state_52039__$1 = state_52039;
var statearr_52046_52197 = state_52039__$1;
(statearr_52046_52197[(2)] = inst_52035);

(statearr_52046_52197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52040 === (8))){
var inst_52031 = (state_52039[(2)]);
var state_52039__$1 = (function (){var statearr_52047 = state_52039;
(statearr_52047[(8)] = inst_52031);

return statearr_52047;
})();
var statearr_52048_52198 = state_52039__$1;
(statearr_52048_52198[(2)] = null);

(statearr_52048_52198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto____0 = (function (){
var statearr_52049 = [null,null,null,null,null,null,null,null,null];
(statearr_52049[(0)] = pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto__);

(statearr_52049[(1)] = (1));

return statearr_52049;
});
var pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto____1 = (function (state_52039){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_52039);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52050){if((e52050 instanceof Object)){
var ex__42066__auto__ = e52050;
var statearr_52051_52199 = state_52039;
(statearr_52051_52199[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52039);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52050;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52200 = state_52039;
state_52039 = G__52200;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto__ = function(state_52039){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto____1.call(this,state_52039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$send_msgs_BANG__$_state_machine__42063__auto__;
})()
})();
var state__42131__auto__ = (function (){var statearr_52052 = (f__42130__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42130__auto__.cljs$core$IFn$_invoke$arity$0() : f__42130__auto__.call(null));
(statearr_52052[(6)] = c__42129__auto__);

return statearr_52052;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42131__auto__);
}));

return c__42129__auto__;
});
pinkgorilla.kernel.nrepl.init_BANG_ = (function pinkgorilla$kernel$nrepl$init_BANG_(ws_url){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init759419009955081863.clj",209,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["clj kernel starting at",ws_url], null);
}),null)),null,-644137823);

var c__42129__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42130__auto__ = (function (){var switch__42062__auto__ = (function (state_52098){
var state_val_52099 = (state_52098[(1)]);
if((state_val_52099 === (7))){
var state_52098__$1 = state_52098;
var statearr_52100_52201 = state_52098__$1;
(statearr_52100_52201[(2)] = false);

(statearr_52100_52201[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52099 === (1))){
var inst_52054 = [new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_52055 = [new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_52056 = cljs.core.PersistentHashMap.fromArrays(inst_52054,inst_52055);
var inst_52057 = chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(ws_url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_52056], 0));
var state_52098__$1 = state_52098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52098__$1,(2),inst_52057);
} else {
if((state_val_52099 === (4))){
var state_52098__$1 = state_52098;
var statearr_52101_52202 = state_52098__$1;
(statearr_52101_52202[(2)] = false);

(statearr_52101_52202[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52099 === (15))){
var inst_52096 = (state_52098[(2)]);
var state_52098__$1 = state_52098;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52098__$1,inst_52096);
} else {
if((state_val_52099 === (13))){
var state_52098__$1 = state_52098;
var statearr_52102_52203 = state_52098__$1;
(statearr_52102_52203[(2)] = null);

(statearr_52102_52203[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52099 === (6))){
var state_52098__$1 = state_52098;
var statearr_52103_52204 = state_52098__$1;
(statearr_52103_52204[(2)] = true);

(statearr_52103_52204[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52099 === (3))){
var inst_52059 = (state_52098[(7)]);
var inst_52064 = inst_52059.cljs$lang$protocol_mask$partition0$;
var inst_52065 = (inst_52064 & (64));
var inst_52066 = inst_52059.cljs$core$ISeq$;
var inst_52067 = (cljs.core.PROTOCOL_SENTINEL === inst_52066);
var inst_52068 = ((inst_52065) || (inst_52067));
var state_52098__$1 = state_52098;
if(cljs.core.truth_(inst_52068)){
var statearr_52104_52205 = state_52098__$1;
(statearr_52104_52205[(1)] = (6));

} else {
var statearr_52105_52206 = state_52098__$1;
(statearr_52105_52206[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52099 === (12))){
var inst_52082 = (state_52098[(8)]);
var inst_52084 = ["clj-kernel ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_52082)].join('');
var inst_52085 = pinkgorilla.notifications.notification.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"danger","danger",-624338030),inst_52084);
var inst_52086 = pinkgorilla.notifications.add_notification(inst_52085);
var state_52098__$1 = state_52098;
var statearr_52106_52207 = state_52098__$1;
(statearr_52106_52207[(2)] = inst_52086);

(statearr_52106_52207[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52099 === (2))){
var inst_52059 = (state_52098[(7)]);
var inst_52059__$1 = (state_52098[(2)]);
var inst_52061 = (inst_52059__$1 == null);
var inst_52062 = cljs.core.not(inst_52061);
var state_52098__$1 = (function (){var statearr_52107 = state_52098;
(statearr_52107[(7)] = inst_52059__$1);

return statearr_52107;
})();
if(inst_52062){
var statearr_52108_52208 = state_52098__$1;
(statearr_52108_52208[(1)] = (3));

} else {
var statearr_52109_52209 = state_52098__$1;
(statearr_52109_52209[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52099 === (11))){
var inst_52082 = (state_52098[(8)]);
var inst_52080 = (state_52098[(2)]);
var inst_52081 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52080,new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174));
var inst_52082__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52080,new cljs.core.Keyword(null,"error","error",-978969032));
var state_52098__$1 = (function (){var statearr_52110 = state_52098;
(statearr_52110[(8)] = inst_52082__$1);

(statearr_52110[(9)] = inst_52081);

return statearr_52110;
})();
if(cljs.core.truth_(inst_52082__$1)){
var statearr_52111_52210 = state_52098__$1;
(statearr_52111_52210[(1)] = (12));

} else {
var statearr_52112_52211 = state_52098__$1;
(statearr_52112_52211[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52099 === (9))){
var inst_52059 = (state_52098[(7)]);
var inst_52077 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_52059);
var state_52098__$1 = state_52098;
var statearr_52113_52212 = state_52098__$1;
(statearr_52113_52212[(2)] = inst_52077);

(statearr_52113_52212[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52099 === (5))){
var inst_52075 = (state_52098[(2)]);
var state_52098__$1 = state_52098;
if(cljs.core.truth_(inst_52075)){
var statearr_52114_52213 = state_52098__$1;
(statearr_52114_52213[(1)] = (9));

} else {
var statearr_52115_52214 = state_52098__$1;
(statearr_52115_52214[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52099 === (14))){
var inst_52081 = (state_52098[(9)]);
var inst_52089 = (state_52098[(2)]);
var inst_52091 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_52092 = pinkgorilla.kernel.nrepl.send_msgs_BANG_(inst_52091,inst_52081);
var inst_52093 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.kernel.nrepl.ws_repl,cljs.core.assoc,new cljs.core.Keyword(null,"channel","channel",734187692),inst_52091);
var inst_52094 = pinkgorilla.kernel.nrepl.receive_msgs_BANG_(inst_52081);
var state_52098__$1 = (function (){var statearr_52116 = state_52098;
(statearr_52116[(10)] = inst_52092);

(statearr_52116[(11)] = inst_52094);

(statearr_52116[(12)] = inst_52089);

(statearr_52116[(13)] = inst_52093);

return statearr_52116;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52098__$1,(15),inst_52091,({"op": "clone"}));
} else {
if((state_val_52099 === (10))){
var inst_52059 = (state_52098[(7)]);
var state_52098__$1 = state_52098;
var statearr_52117_52215 = state_52098__$1;
(statearr_52117_52215[(2)] = inst_52059);

(statearr_52117_52215[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52099 === (8))){
var inst_52072 = (state_52098[(2)]);
var state_52098__$1 = state_52098;
var statearr_52118_52216 = state_52098__$1;
(statearr_52118_52216[(2)] = inst_52072);

(statearr_52118_52216[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto____0 = (function (){
var statearr_52119 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52119[(0)] = pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto__);

(statearr_52119[(1)] = (1));

return statearr_52119;
});
var pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto____1 = (function (state_52098){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_52098);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52120){if((e52120 instanceof Object)){
var ex__42066__auto__ = e52120;
var statearr_52121_52217 = state_52098;
(statearr_52121_52217[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52098);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52120;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52218 = state_52098;
state_52098 = G__52218;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto__ = function(state_52098){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto____1.call(this,state_52098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$init_BANG__$_state_machine__42063__auto__;
})()
})();
var state__42131__auto__ = (function (){var statearr_52122 = (f__42130__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42130__auto__.cljs$core$IFn$_invoke$arity$0() : f__42130__auto__.call(null));
(statearr_52122[(6)] = c__42129__auto__);

return statearr_52122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42131__auto__);
}));

return c__42129__auto__;
});
pinkgorilla.kernel.nrepl.clj_eval = (function pinkgorilla$kernel$nrepl$clj_eval(snippet,callback){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["clj-eval: ",snippet], 0));

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init759419009955081863.clj",235,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["clj-eval: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(snippet)].join('')], null);
}),null)),null,-1853553372);

return pinkgorilla.kernel.nrepl.send_cider_message_BANG_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),"eval",new cljs.core.Keyword(null,"code","code",1586293142),snippet], null),(function (message){
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"ns");
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init759419009955081863.clj",240,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["ns: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join('')], null);
}),null)),null,-773782502);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(message,"value");
var data = pinkgorilla.kernel.nrepl.parse_value(value);
if(cljs.core.truth_(ns)){
var v2 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(data));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init759419009955081863.clj",244,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["clj-eval response: ",data," type: ",cljs.core.type(value)], null);
}),null)),null,412513956);

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init759419009955081863.clj",245,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["clj-eval result: ",v2," type: ",cljs.core.type(v2)], null);
}),null)),null,2070481333);

return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(v2) : callback.call(null,v2));
} else {
return null;
}
}));
});
goog.exportSymbol('pinkgorilla.kernel.nrepl.clj_eval', pinkgorilla.kernel.nrepl.clj_eval);
pinkgorilla.kernel.nrepl.clj_eval_sync = (function pinkgorilla$kernel$nrepl$clj_eval_sync(result_atom,snippet){
var result_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__42129__auto___52219 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42130__auto__ = (function (){var switch__42062__auto__ = (function (state_52126){
var state_val_52127 = (state_52126[(1)]);
if((state_val_52127 === (1))){
var inst_52123 = (function (){return (function (result){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init759419009955081863.clj",252,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["async evalued result: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(result)].join('')], null);
}),null)),null,181901200);

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_chan,result);
});
})();
var inst_52124 = pinkgorilla.kernel.nrepl.clj_eval(snippet,inst_52123);
var state_52126__$1 = state_52126;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52126__$1,inst_52124);
} else {
return null;
}
});
return (function() {
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0 = (function (){
var statearr_52128 = [null,null,null,null,null,null,null];
(statearr_52128[(0)] = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__);

(statearr_52128[(1)] = (1));

return statearr_52128;
});
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1 = (function (state_52126){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_52126);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52129){if((e52129 instanceof Object)){
var ex__42066__auto__ = e52129;
var statearr_52130_52220 = state_52126;
(statearr_52130_52220[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52126);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52129;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52221 = state_52126;
state_52126 = G__52221;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__ = function(state_52126){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1.call(this,state_52126);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__;
})()
})();
var state__42131__auto__ = (function (){var statearr_52131 = (f__42130__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42130__auto__.cljs$core$IFn$_invoke$arity$0() : f__42130__auto__.call(null));
(statearr_52131[(6)] = c__42129__auto___52219);

return statearr_52131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42131__auto__);
}));


var c__42129__auto___52222 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42130__auto__ = (function (){var switch__42062__auto__ = (function (state_52136){
var state_val_52137 = (state_52136[(1)]);
if((state_val_52137 === (1))){
var state_52136__$1 = state_52136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52136__$1,(2),result_chan);
} else {
if((state_val_52137 === (2))){
var inst_52133 = (state_52136[(2)]);
var inst_52134 = cljs.core.reset_BANG_(result_atom,inst_52133);
var state_52136__$1 = state_52136;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52136__$1,inst_52134);
} else {
return null;
}
}
});
return (function() {
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0 = (function (){
var statearr_52138 = [null,null,null,null,null,null,null];
(statearr_52138[(0)] = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__);

(statearr_52138[(1)] = (1));

return statearr_52138;
});
var pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1 = (function (state_52136){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_52136);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e52139){if((e52139 instanceof Object)){
var ex__42066__auto__ = e52139;
var statearr_52140_52223 = state_52136;
(statearr_52140_52223[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52136);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52139;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52224 = state_52136;
state_52136 = G__52224;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__ = function(state_52136){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1.call(this,state_52136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____0;
pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto____1;
return pinkgorilla$kernel$nrepl$clj_eval_sync_$_state_machine__42063__auto__;
})()
})();
var state__42131__auto__ = (function (){var statearr_52141 = (f__42130__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42130__auto__.cljs$core$IFn$_invoke$arity$0() : f__42130__auto__.call(null));
(statearr_52141[(6)] = c__42129__auto___52222);

return statearr_52141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42131__auto__);
}));


return result_atom;
});
goog.exportSymbol('pinkgorilla.kernel.nrepl.clj_eval_sync', pinkgorilla.kernel.nrepl.clj_eval_sync);
pinkgorilla.kernel.nrepl.clj = (function pinkgorilla$kernel$nrepl$clj(var_args){
var args__4795__auto__ = [];
var len__4789__auto___52225 = arguments.length;
var i__4790__auto___52226 = (0);
while(true){
if((i__4790__auto___52226 < len__4789__auto___52225)){
args__4795__auto__.push((arguments[i__4790__auto___52226]));

var G__52227 = (i__4790__auto___52226 + (1));
i__4790__auto___52226 = G__52227;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return pinkgorilla.kernel.nrepl.clj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});
goog.exportSymbol('pinkgorilla.kernel.nrepl.clj', pinkgorilla.kernel.nrepl.clj);

(pinkgorilla.kernel.nrepl.clj.cljs$core$IFn$_invoke$arity$variadic = (function (result_atom,function_as_string,params){
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init759419009955081863.clj",258,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["params: ",params], null);
}),null)),null,-1503209692);
var expr = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(",function_as_string], null),params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [")"], null)], 0));
var str_eval = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",expr);
var ___$1 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.kernel.nrepl","/tmp/form-init759419009955081863.clj",261,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["Calling CLJ: ",str_eval].join('')], null);
}),null)),null,402153085);
return pinkgorilla.kernel.nrepl.clj_eval_sync(result_atom,str_eval);
}));

(pinkgorilla.kernel.nrepl.clj.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.kernel.nrepl.clj.cljs$lang$applyTo = (function (seq52142){
var G__52143 = cljs.core.first(seq52142);
var seq52142__$1 = cljs.core.next(seq52142);
var G__52144 = cljs.core.first(seq52142__$1);
var seq52142__$2 = cljs.core.next(seq52142__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__52143,G__52144,seq52142__$2);
}));


//# sourceMappingURL=pinkgorilla.kernel.nrepl.js.map
