goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__44619){
var vec__44620 = p__44619;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44620,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44620,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__44633 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44633,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44633,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44633,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44633,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44633,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__44636 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44636,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44636,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44636,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44636,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44636,(4),null);
var vec__44639 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44639,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44639,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44639,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44639,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44639,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__44650 = segmap;
var map__44650__$1 = (((((!((map__44650 == null))))?(((((map__44650.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44650.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44650):map__44650);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44650__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44650__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44650__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44650__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44650__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__44660 = arguments.length;
switch (G__44660) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44672 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45777 = cljs.core.next(segs__$1);
var G__45778 = nrelseg;
var G__45779 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45777;
relseg__$1 = G__45778;
result__$1 = G__45779;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44672,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44672,(1),null);
var G__45780 = (gline + (1));
var G__45781 = cljs.core.next(lines__$1);
var G__45782 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45783 = result__$1;
gline = G__45780;
lines__$1 = G__45781;
relseg = G__45782;
result = G__45783;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__44680 = segmap;
var map__44680__$1 = (((((!((map__44680 == null))))?(((((map__44680.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44680.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44680):map__44680);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44680__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44680__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44680__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44680__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44680__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__44679_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__44679_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__44691 = arguments.length;
switch (G__44691) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44698 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45794 = cljs.core.next(segs__$1);
var G__45795 = nrelseg;
var G__45796 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45794;
relseg__$1 = G__45795;
result__$1 = G__45796;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44698,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44698,(1),null);
var G__45797 = (gline + (1));
var G__45798 = cljs.core.next(lines__$1);
var G__45799 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45800 = result__$1;
gline = G__45797;
lines__$1 = G__45798;
relseg = G__45799;
result = G__45800;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44710){
var vec__44711 = p__44710;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44711,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44711,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44711,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44711,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44711,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__44714){
var vec__44715 = p__44714;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44715,(4),null);
var seg = vec__44715;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44721){
var vec__44723 = p__44721;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44723,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44723,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44723,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44723,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44723,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__44742 = cljs.core.seq(infos);
var chunk__44743 = null;
var count__44744 = (0);
var i__44745 = (0);
while(true){
if((i__44745 < count__44744)){
var info = chunk__44743.cljs$core$IIndexed$_nth$arity$2(null,i__44745);
var segv_45804 = info__GT_segv(info,source_idx,line,col);
var gline_45805 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45806 = cljs.core.count(cljs.core.deref(lines));
if((gline_45805 > (lc_45806 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44742,chunk__44743,count__44744,i__44745,segv_45804,gline_45805,lc_45806,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45805 - (lc_45806 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45804], null));
});})(seq__44742,chunk__44743,count__44744,i__44745,segv_45804,gline_45805,lc_45806,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44742,chunk__44743,count__44744,i__44745,segv_45804,gline_45805,lc_45806,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45805], null),cljs.core.conj,segv_45804);
});})(seq__44742,chunk__44743,count__44744,i__44745,segv_45804,gline_45805,lc_45806,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45807 = seq__44742;
var G__45808 = chunk__44743;
var G__45809 = count__44744;
var G__45810 = (i__44745 + (1));
seq__44742 = G__45807;
chunk__44743 = G__45808;
count__44744 = G__45809;
i__44745 = G__45810;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__44742);
if(temp__5735__auto__){
var seq__44742__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44742__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__44742__$1);
var G__45811 = cljs.core.chunk_rest(seq__44742__$1);
var G__45812 = c__4609__auto__;
var G__45813 = cljs.core.count(c__4609__auto__);
var G__45814 = (0);
seq__44742 = G__45811;
chunk__44743 = G__45812;
count__44744 = G__45813;
i__44745 = G__45814;
continue;
} else {
var info = cljs.core.first(seq__44742__$1);
var segv_45815 = info__GT_segv(info,source_idx,line,col);
var gline_45816 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45817 = cljs.core.count(cljs.core.deref(lines));
if((gline_45816 > (lc_45817 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44742,chunk__44743,count__44744,i__44745,segv_45815,gline_45816,lc_45817,info,seq__44742__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45816 - (lc_45817 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45815], null));
});})(seq__44742,chunk__44743,count__44744,i__44745,segv_45815,gline_45816,lc_45817,info,seq__44742__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44742,chunk__44743,count__44744,i__44745,segv_45815,gline_45816,lc_45817,info,seq__44742__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45816], null),cljs.core.conj,segv_45815);
});})(seq__44742,chunk__44743,count__44744,i__44745,segv_45815,gline_45816,lc_45817,info,seq__44742__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45819 = cljs.core.next(seq__44742__$1);
var G__45820 = null;
var G__45821 = (0);
var G__45822 = (0);
seq__44742 = G__45819;
chunk__44743 = G__45820;
count__44744 = G__45821;
i__44745 = G__45822;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__44759_45823 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__44760_45824 = null;
var count__44761_45825 = (0);
var i__44762_45826 = (0);
while(true){
if((i__44762_45826 < count__44761_45825)){
var vec__45016_45827 = chunk__44760_45824.cljs$core$IIndexed$_nth$arity$2(null,i__44762_45826);
var source_idx_45828 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45016_45827,(0),null);
var vec__45019_45829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45016_45827,(1),null);
var __45830 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45019_45829,(0),null);
var lines_45831__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45019_45829,(1),null);
var seq__45022_45832 = cljs.core.seq(lines_45831__$1);
var chunk__45023_45833 = null;
var count__45024_45834 = (0);
var i__45025_45835 = (0);
while(true){
if((i__45025_45835 < count__45024_45834)){
var vec__45091_45836 = chunk__45023_45833.cljs$core$IIndexed$_nth$arity$2(null,i__45025_45835);
var line_45837 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45091_45836,(0),null);
var cols_45838 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45091_45836,(1),null);
var seq__45094_45839 = cljs.core.seq(cols_45838);
var chunk__45095_45840 = null;
var count__45096_45841 = (0);
var i__45097_45842 = (0);
while(true){
if((i__45097_45842 < count__45096_45841)){
var vec__45104_45843 = chunk__45095_45840.cljs$core$IIndexed$_nth$arity$2(null,i__45097_45842);
var col_45844 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45104_45843,(0),null);
var infos_45845 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45104_45843,(1),null);
encode_cols(infos_45845,source_idx_45828,line_45837,col_45844);


var G__45846 = seq__45094_45839;
var G__45847 = chunk__45095_45840;
var G__45848 = count__45096_45841;
var G__45849 = (i__45097_45842 + (1));
seq__45094_45839 = G__45846;
chunk__45095_45840 = G__45847;
count__45096_45841 = G__45848;
i__45097_45842 = G__45849;
continue;
} else {
var temp__5735__auto___45850 = cljs.core.seq(seq__45094_45839);
if(temp__5735__auto___45850){
var seq__45094_45851__$1 = temp__5735__auto___45850;
if(cljs.core.chunked_seq_QMARK_(seq__45094_45851__$1)){
var c__4609__auto___45852 = cljs.core.chunk_first(seq__45094_45851__$1);
var G__45853 = cljs.core.chunk_rest(seq__45094_45851__$1);
var G__45854 = c__4609__auto___45852;
var G__45855 = cljs.core.count(c__4609__auto___45852);
var G__45856 = (0);
seq__45094_45839 = G__45853;
chunk__45095_45840 = G__45854;
count__45096_45841 = G__45855;
i__45097_45842 = G__45856;
continue;
} else {
var vec__45107_45857 = cljs.core.first(seq__45094_45851__$1);
var col_45858 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45107_45857,(0),null);
var infos_45859 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45107_45857,(1),null);
encode_cols(infos_45859,source_idx_45828,line_45837,col_45858);


var G__45860 = cljs.core.next(seq__45094_45851__$1);
var G__45861 = null;
var G__45862 = (0);
var G__45863 = (0);
seq__45094_45839 = G__45860;
chunk__45095_45840 = G__45861;
count__45096_45841 = G__45862;
i__45097_45842 = G__45863;
continue;
}
} else {
}
}
break;
}


var G__45864 = seq__45022_45832;
var G__45865 = chunk__45023_45833;
var G__45866 = count__45024_45834;
var G__45867 = (i__45025_45835 + (1));
seq__45022_45832 = G__45864;
chunk__45023_45833 = G__45865;
count__45024_45834 = G__45866;
i__45025_45835 = G__45867;
continue;
} else {
var temp__5735__auto___45868 = cljs.core.seq(seq__45022_45832);
if(temp__5735__auto___45868){
var seq__45022_45869__$1 = temp__5735__auto___45868;
if(cljs.core.chunked_seq_QMARK_(seq__45022_45869__$1)){
var c__4609__auto___45870 = cljs.core.chunk_first(seq__45022_45869__$1);
var G__45871 = cljs.core.chunk_rest(seq__45022_45869__$1);
var G__45872 = c__4609__auto___45870;
var G__45873 = cljs.core.count(c__4609__auto___45870);
var G__45874 = (0);
seq__45022_45832 = G__45871;
chunk__45023_45833 = G__45872;
count__45024_45834 = G__45873;
i__45025_45835 = G__45874;
continue;
} else {
var vec__45110_45875 = cljs.core.first(seq__45022_45869__$1);
var line_45876 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45110_45875,(0),null);
var cols_45877 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45110_45875,(1),null);
var seq__45115_45878 = cljs.core.seq(cols_45877);
var chunk__45116_45879 = null;
var count__45117_45880 = (0);
var i__45118_45881 = (0);
while(true){
if((i__45118_45881 < count__45117_45880)){
var vec__45132_45882 = chunk__45116_45879.cljs$core$IIndexed$_nth$arity$2(null,i__45118_45881);
var col_45883 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45132_45882,(0),null);
var infos_45884 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45132_45882,(1),null);
encode_cols(infos_45884,source_idx_45828,line_45876,col_45883);


var G__45886 = seq__45115_45878;
var G__45887 = chunk__45116_45879;
var G__45888 = count__45117_45880;
var G__45889 = (i__45118_45881 + (1));
seq__45115_45878 = G__45886;
chunk__45116_45879 = G__45887;
count__45117_45880 = G__45888;
i__45118_45881 = G__45889;
continue;
} else {
var temp__5735__auto___45892__$1 = cljs.core.seq(seq__45115_45878);
if(temp__5735__auto___45892__$1){
var seq__45115_45893__$1 = temp__5735__auto___45892__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45115_45893__$1)){
var c__4609__auto___45894 = cljs.core.chunk_first(seq__45115_45893__$1);
var G__45895 = cljs.core.chunk_rest(seq__45115_45893__$1);
var G__45896 = c__4609__auto___45894;
var G__45897 = cljs.core.count(c__4609__auto___45894);
var G__45898 = (0);
seq__45115_45878 = G__45895;
chunk__45116_45879 = G__45896;
count__45117_45880 = G__45897;
i__45118_45881 = G__45898;
continue;
} else {
var vec__45139_45900 = cljs.core.first(seq__45115_45893__$1);
var col_45901 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45139_45900,(0),null);
var infos_45902 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45139_45900,(1),null);
encode_cols(infos_45902,source_idx_45828,line_45876,col_45901);


var G__45903 = cljs.core.next(seq__45115_45893__$1);
var G__45904 = null;
var G__45905 = (0);
var G__45906 = (0);
seq__45115_45878 = G__45903;
chunk__45116_45879 = G__45904;
count__45117_45880 = G__45905;
i__45118_45881 = G__45906;
continue;
}
} else {
}
}
break;
}


var G__45907 = cljs.core.next(seq__45022_45869__$1);
var G__45908 = null;
var G__45909 = (0);
var G__45910 = (0);
seq__45022_45832 = G__45907;
chunk__45023_45833 = G__45908;
count__45024_45834 = G__45909;
i__45025_45835 = G__45910;
continue;
}
} else {
}
}
break;
}


var G__45913 = seq__44759_45823;
var G__45914 = chunk__44760_45824;
var G__45915 = count__44761_45825;
var G__45916 = (i__44762_45826 + (1));
seq__44759_45823 = G__45913;
chunk__44760_45824 = G__45914;
count__44761_45825 = G__45915;
i__44762_45826 = G__45916;
continue;
} else {
var temp__5735__auto___45917 = cljs.core.seq(seq__44759_45823);
if(temp__5735__auto___45917){
var seq__44759_45918__$1 = temp__5735__auto___45917;
if(cljs.core.chunked_seq_QMARK_(seq__44759_45918__$1)){
var c__4609__auto___45919 = cljs.core.chunk_first(seq__44759_45918__$1);
var G__45920 = cljs.core.chunk_rest(seq__44759_45918__$1);
var G__45921 = c__4609__auto___45919;
var G__45922 = cljs.core.count(c__4609__auto___45919);
var G__45923 = (0);
seq__44759_45823 = G__45920;
chunk__44760_45824 = G__45921;
count__44761_45825 = G__45922;
i__44762_45826 = G__45923;
continue;
} else {
var vec__45142_45924 = cljs.core.first(seq__44759_45918__$1);
var source_idx_45925 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45142_45924,(0),null);
var vec__45145_45926 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45142_45924,(1),null);
var __45927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45145_45926,(0),null);
var lines_45928__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45145_45926,(1),null);
var seq__45148_45931 = cljs.core.seq(lines_45928__$1);
var chunk__45149_45932 = null;
var count__45150_45933 = (0);
var i__45151_45934 = (0);
while(true){
if((i__45151_45934 < count__45150_45933)){
var vec__45195_45935 = chunk__45149_45932.cljs$core$IIndexed$_nth$arity$2(null,i__45151_45934);
var line_45936 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45195_45935,(0),null);
var cols_45937 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45195_45935,(1),null);
var seq__45198_45938 = cljs.core.seq(cols_45937);
var chunk__45199_45939 = null;
var count__45200_45940 = (0);
var i__45201_45941 = (0);
while(true){
if((i__45201_45941 < count__45200_45940)){
var vec__45208_45942 = chunk__45199_45939.cljs$core$IIndexed$_nth$arity$2(null,i__45201_45941);
var col_45943 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45208_45942,(0),null);
var infos_45944 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45208_45942,(1),null);
encode_cols(infos_45944,source_idx_45925,line_45936,col_45943);


var G__45945 = seq__45198_45938;
var G__45946 = chunk__45199_45939;
var G__45947 = count__45200_45940;
var G__45948 = (i__45201_45941 + (1));
seq__45198_45938 = G__45945;
chunk__45199_45939 = G__45946;
count__45200_45940 = G__45947;
i__45201_45941 = G__45948;
continue;
} else {
var temp__5735__auto___45949__$1 = cljs.core.seq(seq__45198_45938);
if(temp__5735__auto___45949__$1){
var seq__45198_45950__$1 = temp__5735__auto___45949__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45198_45950__$1)){
var c__4609__auto___45951 = cljs.core.chunk_first(seq__45198_45950__$1);
var G__45952 = cljs.core.chunk_rest(seq__45198_45950__$1);
var G__45953 = c__4609__auto___45951;
var G__45954 = cljs.core.count(c__4609__auto___45951);
var G__45955 = (0);
seq__45198_45938 = G__45952;
chunk__45199_45939 = G__45953;
count__45200_45940 = G__45954;
i__45201_45941 = G__45955;
continue;
} else {
var vec__45211_45956 = cljs.core.first(seq__45198_45950__$1);
var col_45957 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45211_45956,(0),null);
var infos_45958 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45211_45956,(1),null);
encode_cols(infos_45958,source_idx_45925,line_45936,col_45957);


var G__45962 = cljs.core.next(seq__45198_45950__$1);
var G__45963 = null;
var G__45964 = (0);
var G__45965 = (0);
seq__45198_45938 = G__45962;
chunk__45199_45939 = G__45963;
count__45200_45940 = G__45964;
i__45201_45941 = G__45965;
continue;
}
} else {
}
}
break;
}


var G__45966 = seq__45148_45931;
var G__45967 = chunk__45149_45932;
var G__45968 = count__45150_45933;
var G__45969 = (i__45151_45934 + (1));
seq__45148_45931 = G__45966;
chunk__45149_45932 = G__45967;
count__45150_45933 = G__45968;
i__45151_45934 = G__45969;
continue;
} else {
var temp__5735__auto___45970__$1 = cljs.core.seq(seq__45148_45931);
if(temp__5735__auto___45970__$1){
var seq__45148_45971__$1 = temp__5735__auto___45970__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45148_45971__$1)){
var c__4609__auto___45972 = cljs.core.chunk_first(seq__45148_45971__$1);
var G__45973 = cljs.core.chunk_rest(seq__45148_45971__$1);
var G__45974 = c__4609__auto___45972;
var G__45975 = cljs.core.count(c__4609__auto___45972);
var G__45977 = (0);
seq__45148_45931 = G__45973;
chunk__45149_45932 = G__45974;
count__45150_45933 = G__45975;
i__45151_45934 = G__45977;
continue;
} else {
var vec__45214_45978 = cljs.core.first(seq__45148_45971__$1);
var line_45979 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45214_45978,(0),null);
var cols_45980 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45214_45978,(1),null);
var seq__45217_45981 = cljs.core.seq(cols_45980);
var chunk__45218_45982 = null;
var count__45219_45983 = (0);
var i__45220_45984 = (0);
while(true){
if((i__45220_45984 < count__45219_45983)){
var vec__45227_45985 = chunk__45218_45982.cljs$core$IIndexed$_nth$arity$2(null,i__45220_45984);
var col_45986 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45227_45985,(0),null);
var infos_45987 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45227_45985,(1),null);
encode_cols(infos_45987,source_idx_45925,line_45979,col_45986);


var G__45988 = seq__45217_45981;
var G__45989 = chunk__45218_45982;
var G__45990 = count__45219_45983;
var G__45991 = (i__45220_45984 + (1));
seq__45217_45981 = G__45988;
chunk__45218_45982 = G__45989;
count__45219_45983 = G__45990;
i__45220_45984 = G__45991;
continue;
} else {
var temp__5735__auto___45992__$2 = cljs.core.seq(seq__45217_45981);
if(temp__5735__auto___45992__$2){
var seq__45217_45993__$1 = temp__5735__auto___45992__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45217_45993__$1)){
var c__4609__auto___45994 = cljs.core.chunk_first(seq__45217_45993__$1);
var G__45995 = cljs.core.chunk_rest(seq__45217_45993__$1);
var G__45996 = c__4609__auto___45994;
var G__45997 = cljs.core.count(c__4609__auto___45994);
var G__45998 = (0);
seq__45217_45981 = G__45995;
chunk__45218_45982 = G__45996;
count__45219_45983 = G__45997;
i__45220_45984 = G__45998;
continue;
} else {
var vec__45240_45999 = cljs.core.first(seq__45217_45993__$1);
var col_46000 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45240_45999,(0),null);
var infos_46001 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45240_45999,(1),null);
encode_cols(infos_46001,source_idx_45925,line_45979,col_46000);


var G__46003 = cljs.core.next(seq__45217_45993__$1);
var G__46004 = null;
var G__46005 = (0);
var G__46006 = (0);
seq__45217_45981 = G__46003;
chunk__45218_45982 = G__46004;
count__45219_45983 = G__46005;
i__45220_45984 = G__46006;
continue;
}
} else {
}
}
break;
}


var G__46007 = cljs.core.next(seq__45148_45971__$1);
var G__46008 = null;
var G__46009 = (0);
var G__46010 = (0);
seq__45148_45931 = G__46007;
chunk__45149_45932 = G__46008;
count__45150_45933 = G__46009;
i__45151_45934 = G__46010;
continue;
}
} else {
}
}
break;
}


var G__46011 = cljs.core.next(seq__44759_45918__$1);
var G__46012 = null;
var G__46013 = (0);
var G__46014 = (0);
seq__44759_45823 = G__46011;
chunk__44760_45824 = G__46012;
count__44761_45825 = G__46013;
i__44762_45826 = G__46014;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__45244 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__44730_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__44730_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__44731_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__44731_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__44732_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__44732_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__45246 = G__45244;
var G__45247_46016 = G__45246;
var G__45248_46017 = "sourcesContent";
var G__45249_46018 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__45247_46016,G__45248_46017,G__45249_46018);

return G__45246;
} else {
return G__45244;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__45250 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45250,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45250,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__45253 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45253,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45253,(1),null);
var G__46021 = cljs.core.next(col_map_seq);
var G__46022 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__45253,col,infos,vec__45250,line,col_map){
return (function (v,p__45256){
var map__45258 = p__45256;
var map__45258__$1 = (((((!((map__45258 == null))))?(((((map__45258.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45258.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45258):map__45258);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45258__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45258__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__45253,col,infos,vec__45250,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__46021;
new_cols = G__46022;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__46024 = cljs.core.next(line_map_seq);
var G__46025 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__46024;
new_lines = G__46025;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__45264_46027 = cljs.core.seq(reverse_map);
var chunk__45265_46028 = null;
var count__45266_46029 = (0);
var i__45267_46030 = (0);
while(true){
if((i__45267_46030 < count__45266_46029)){
var vec__45535_46033 = chunk__45265_46028.cljs$core$IIndexed$_nth$arity$2(null,i__45267_46030);
var line_46034 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45535_46033,(0),null);
var columns_46035 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45535_46033,(1),null);
var seq__45538_46038 = cljs.core.seq(columns_46035);
var chunk__45539_46039 = null;
var count__45540_46040 = (0);
var i__45541_46041 = (0);
while(true){
if((i__45541_46041 < count__45540_46040)){
var vec__45610_46042 = chunk__45539_46039.cljs$core$IIndexed$_nth$arity$2(null,i__45541_46041);
var column_46043 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45610_46042,(0),null);
var column_info_46044 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45610_46042,(1),null);
var seq__45613_46046 = cljs.core.seq(column_info_46044);
var chunk__45614_46047 = null;
var count__45615_46048 = (0);
var i__45616_46049 = (0);
while(true){
if((i__45616_46049 < count__45615_46048)){
var map__45628_46051 = chunk__45614_46047.cljs$core$IIndexed$_nth$arity$2(null,i__45616_46049);
var map__45628_46052__$1 = (((((!((map__45628_46051 == null))))?(((((map__45628_46051.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45628_46051.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45628_46051):map__45628_46051);
var gline_46053 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45628_46052__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46054 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45628_46052__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46055 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45628_46052__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46053], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45613_46046,chunk__45614_46047,count__45615_46048,i__45616_46049,seq__45538_46038,chunk__45539_46039,count__45540_46040,i__45541_46041,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45628_46051,map__45628_46052__$1,gline_46053,gcol_46054,name_46055,vec__45610_46042,column_46043,column_info_46044,vec__45535_46033,line_46034,columns_46035,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46054], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46034,new cljs.core.Keyword(null,"col","col",-1959363084),column_46043,new cljs.core.Keyword(null,"name","name",1843675177),name_46055], null));
});})(seq__45613_46046,chunk__45614_46047,count__45615_46048,i__45616_46049,seq__45538_46038,chunk__45539_46039,count__45540_46040,i__45541_46041,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45628_46051,map__45628_46052__$1,gline_46053,gcol_46054,name_46055,vec__45610_46042,column_46043,column_info_46044,vec__45535_46033,line_46034,columns_46035,inverted))
,cljs.core.sorted_map()));


var G__46062 = seq__45613_46046;
var G__46063 = chunk__45614_46047;
var G__46064 = count__45615_46048;
var G__46065 = (i__45616_46049 + (1));
seq__45613_46046 = G__46062;
chunk__45614_46047 = G__46063;
count__45615_46048 = G__46064;
i__45616_46049 = G__46065;
continue;
} else {
var temp__5735__auto___46067 = cljs.core.seq(seq__45613_46046);
if(temp__5735__auto___46067){
var seq__45613_46068__$1 = temp__5735__auto___46067;
if(cljs.core.chunked_seq_QMARK_(seq__45613_46068__$1)){
var c__4609__auto___46070 = cljs.core.chunk_first(seq__45613_46068__$1);
var G__46071 = cljs.core.chunk_rest(seq__45613_46068__$1);
var G__46072 = c__4609__auto___46070;
var G__46073 = cljs.core.count(c__4609__auto___46070);
var G__46074 = (0);
seq__45613_46046 = G__46071;
chunk__45614_46047 = G__46072;
count__45615_46048 = G__46073;
i__45616_46049 = G__46074;
continue;
} else {
var map__45630_46075 = cljs.core.first(seq__45613_46068__$1);
var map__45630_46076__$1 = (((((!((map__45630_46075 == null))))?(((((map__45630_46075.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45630_46075.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45630_46075):map__45630_46075);
var gline_46077 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45630_46076__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46078 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45630_46076__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46079 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45630_46076__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46077], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45613_46046,chunk__45614_46047,count__45615_46048,i__45616_46049,seq__45538_46038,chunk__45539_46039,count__45540_46040,i__45541_46041,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45630_46075,map__45630_46076__$1,gline_46077,gcol_46078,name_46079,seq__45613_46068__$1,temp__5735__auto___46067,vec__45610_46042,column_46043,column_info_46044,vec__45535_46033,line_46034,columns_46035,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46078], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46034,new cljs.core.Keyword(null,"col","col",-1959363084),column_46043,new cljs.core.Keyword(null,"name","name",1843675177),name_46079], null));
});})(seq__45613_46046,chunk__45614_46047,count__45615_46048,i__45616_46049,seq__45538_46038,chunk__45539_46039,count__45540_46040,i__45541_46041,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45630_46075,map__45630_46076__$1,gline_46077,gcol_46078,name_46079,seq__45613_46068__$1,temp__5735__auto___46067,vec__45610_46042,column_46043,column_info_46044,vec__45535_46033,line_46034,columns_46035,inverted))
,cljs.core.sorted_map()));


var G__46087 = cljs.core.next(seq__45613_46068__$1);
var G__46088 = null;
var G__46089 = (0);
var G__46090 = (0);
seq__45613_46046 = G__46087;
chunk__45614_46047 = G__46088;
count__45615_46048 = G__46089;
i__45616_46049 = G__46090;
continue;
}
} else {
}
}
break;
}


var G__46091 = seq__45538_46038;
var G__46092 = chunk__45539_46039;
var G__46093 = count__45540_46040;
var G__46094 = (i__45541_46041 + (1));
seq__45538_46038 = G__46091;
chunk__45539_46039 = G__46092;
count__45540_46040 = G__46093;
i__45541_46041 = G__46094;
continue;
} else {
var temp__5735__auto___46095 = cljs.core.seq(seq__45538_46038);
if(temp__5735__auto___46095){
var seq__45538_46098__$1 = temp__5735__auto___46095;
if(cljs.core.chunked_seq_QMARK_(seq__45538_46098__$1)){
var c__4609__auto___46099 = cljs.core.chunk_first(seq__45538_46098__$1);
var G__46100 = cljs.core.chunk_rest(seq__45538_46098__$1);
var G__46101 = c__4609__auto___46099;
var G__46102 = cljs.core.count(c__4609__auto___46099);
var G__46103 = (0);
seq__45538_46038 = G__46100;
chunk__45539_46039 = G__46101;
count__45540_46040 = G__46102;
i__45541_46041 = G__46103;
continue;
} else {
var vec__45632_46104 = cljs.core.first(seq__45538_46098__$1);
var column_46105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45632_46104,(0),null);
var column_info_46106 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45632_46104,(1),null);
var seq__45635_46108 = cljs.core.seq(column_info_46106);
var chunk__45636_46109 = null;
var count__45637_46110 = (0);
var i__45638_46111 = (0);
while(true){
if((i__45638_46111 < count__45637_46110)){
var map__45652_46112 = chunk__45636_46109.cljs$core$IIndexed$_nth$arity$2(null,i__45638_46111);
var map__45652_46113__$1 = (((((!((map__45652_46112 == null))))?(((((map__45652_46112.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45652_46112.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45652_46112):map__45652_46112);
var gline_46114 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45652_46113__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46115 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45652_46113__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46116 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45652_46113__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46114], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45635_46108,chunk__45636_46109,count__45637_46110,i__45638_46111,seq__45538_46038,chunk__45539_46039,count__45540_46040,i__45541_46041,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45652_46112,map__45652_46113__$1,gline_46114,gcol_46115,name_46116,vec__45632_46104,column_46105,column_info_46106,seq__45538_46098__$1,temp__5735__auto___46095,vec__45535_46033,line_46034,columns_46035,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46115], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46034,new cljs.core.Keyword(null,"col","col",-1959363084),column_46105,new cljs.core.Keyword(null,"name","name",1843675177),name_46116], null));
});})(seq__45635_46108,chunk__45636_46109,count__45637_46110,i__45638_46111,seq__45538_46038,chunk__45539_46039,count__45540_46040,i__45541_46041,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45652_46112,map__45652_46113__$1,gline_46114,gcol_46115,name_46116,vec__45632_46104,column_46105,column_info_46106,seq__45538_46098__$1,temp__5735__auto___46095,vec__45535_46033,line_46034,columns_46035,inverted))
,cljs.core.sorted_map()));


var G__46124 = seq__45635_46108;
var G__46125 = chunk__45636_46109;
var G__46126 = count__45637_46110;
var G__46127 = (i__45638_46111 + (1));
seq__45635_46108 = G__46124;
chunk__45636_46109 = G__46125;
count__45637_46110 = G__46126;
i__45638_46111 = G__46127;
continue;
} else {
var temp__5735__auto___46128__$1 = cljs.core.seq(seq__45635_46108);
if(temp__5735__auto___46128__$1){
var seq__45635_46129__$1 = temp__5735__auto___46128__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45635_46129__$1)){
var c__4609__auto___46130 = cljs.core.chunk_first(seq__45635_46129__$1);
var G__46131 = cljs.core.chunk_rest(seq__45635_46129__$1);
var G__46132 = c__4609__auto___46130;
var G__46133 = cljs.core.count(c__4609__auto___46130);
var G__46134 = (0);
seq__45635_46108 = G__46131;
chunk__45636_46109 = G__46132;
count__45637_46110 = G__46133;
i__45638_46111 = G__46134;
continue;
} else {
var map__45654_46135 = cljs.core.first(seq__45635_46129__$1);
var map__45654_46136__$1 = (((((!((map__45654_46135 == null))))?(((((map__45654_46135.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45654_46135.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45654_46135):map__45654_46135);
var gline_46137 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45654_46136__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46138 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45654_46136__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46139 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45654_46136__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46137], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45635_46108,chunk__45636_46109,count__45637_46110,i__45638_46111,seq__45538_46038,chunk__45539_46039,count__45540_46040,i__45541_46041,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45654_46135,map__45654_46136__$1,gline_46137,gcol_46138,name_46139,seq__45635_46129__$1,temp__5735__auto___46128__$1,vec__45632_46104,column_46105,column_info_46106,seq__45538_46098__$1,temp__5735__auto___46095,vec__45535_46033,line_46034,columns_46035,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46138], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46034,new cljs.core.Keyword(null,"col","col",-1959363084),column_46105,new cljs.core.Keyword(null,"name","name",1843675177),name_46139], null));
});})(seq__45635_46108,chunk__45636_46109,count__45637_46110,i__45638_46111,seq__45538_46038,chunk__45539_46039,count__45540_46040,i__45541_46041,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45654_46135,map__45654_46136__$1,gline_46137,gcol_46138,name_46139,seq__45635_46129__$1,temp__5735__auto___46128__$1,vec__45632_46104,column_46105,column_info_46106,seq__45538_46098__$1,temp__5735__auto___46095,vec__45535_46033,line_46034,columns_46035,inverted))
,cljs.core.sorted_map()));


var G__46144 = cljs.core.next(seq__45635_46129__$1);
var G__46145 = null;
var G__46146 = (0);
var G__46147 = (0);
seq__45635_46108 = G__46144;
chunk__45636_46109 = G__46145;
count__45637_46110 = G__46146;
i__45638_46111 = G__46147;
continue;
}
} else {
}
}
break;
}


var G__46148 = cljs.core.next(seq__45538_46098__$1);
var G__46149 = null;
var G__46150 = (0);
var G__46151 = (0);
seq__45538_46038 = G__46148;
chunk__45539_46039 = G__46149;
count__45540_46040 = G__46150;
i__45541_46041 = G__46151;
continue;
}
} else {
}
}
break;
}


var G__46152 = seq__45264_46027;
var G__46153 = chunk__45265_46028;
var G__46154 = count__45266_46029;
var G__46155 = (i__45267_46030 + (1));
seq__45264_46027 = G__46152;
chunk__45265_46028 = G__46153;
count__45266_46029 = G__46154;
i__45267_46030 = G__46155;
continue;
} else {
var temp__5735__auto___46156 = cljs.core.seq(seq__45264_46027);
if(temp__5735__auto___46156){
var seq__45264_46157__$1 = temp__5735__auto___46156;
if(cljs.core.chunked_seq_QMARK_(seq__45264_46157__$1)){
var c__4609__auto___46158 = cljs.core.chunk_first(seq__45264_46157__$1);
var G__46159 = cljs.core.chunk_rest(seq__45264_46157__$1);
var G__46160 = c__4609__auto___46158;
var G__46161 = cljs.core.count(c__4609__auto___46158);
var G__46162 = (0);
seq__45264_46027 = G__46159;
chunk__45265_46028 = G__46160;
count__45266_46029 = G__46161;
i__45267_46030 = G__46162;
continue;
} else {
var vec__45665_46163 = cljs.core.first(seq__45264_46157__$1);
var line_46164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45665_46163,(0),null);
var columns_46165 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45665_46163,(1),null);
var seq__45668_46166 = cljs.core.seq(columns_46165);
var chunk__45669_46167 = null;
var count__45670_46168 = (0);
var i__45671_46169 = (0);
while(true){
if((i__45671_46169 < count__45670_46168)){
var vec__45714_46170 = chunk__45669_46167.cljs$core$IIndexed$_nth$arity$2(null,i__45671_46169);
var column_46171 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45714_46170,(0),null);
var column_info_46172 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45714_46170,(1),null);
var seq__45720_46173 = cljs.core.seq(column_info_46172);
var chunk__45721_46174 = null;
var count__45722_46175 = (0);
var i__45723_46176 = (0);
while(true){
if((i__45723_46176 < count__45722_46175)){
var map__45728_46177 = chunk__45721_46174.cljs$core$IIndexed$_nth$arity$2(null,i__45723_46176);
var map__45728_46178__$1 = (((((!((map__45728_46177 == null))))?(((((map__45728_46177.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45728_46177.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45728_46177):map__45728_46177);
var gline_46179 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45728_46178__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46180 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45728_46178__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46181 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45728_46178__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46179], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45720_46173,chunk__45721_46174,count__45722_46175,i__45723_46176,seq__45668_46166,chunk__45669_46167,count__45670_46168,i__45671_46169,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45728_46177,map__45728_46178__$1,gline_46179,gcol_46180,name_46181,vec__45714_46170,column_46171,column_info_46172,vec__45665_46163,line_46164,columns_46165,seq__45264_46157__$1,temp__5735__auto___46156,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46180], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46164,new cljs.core.Keyword(null,"col","col",-1959363084),column_46171,new cljs.core.Keyword(null,"name","name",1843675177),name_46181], null));
});})(seq__45720_46173,chunk__45721_46174,count__45722_46175,i__45723_46176,seq__45668_46166,chunk__45669_46167,count__45670_46168,i__45671_46169,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45728_46177,map__45728_46178__$1,gline_46179,gcol_46180,name_46181,vec__45714_46170,column_46171,column_info_46172,vec__45665_46163,line_46164,columns_46165,seq__45264_46157__$1,temp__5735__auto___46156,inverted))
,cljs.core.sorted_map()));


var G__46187 = seq__45720_46173;
var G__46188 = chunk__45721_46174;
var G__46189 = count__45722_46175;
var G__46190 = (i__45723_46176 + (1));
seq__45720_46173 = G__46187;
chunk__45721_46174 = G__46188;
count__45722_46175 = G__46189;
i__45723_46176 = G__46190;
continue;
} else {
var temp__5735__auto___46191__$1 = cljs.core.seq(seq__45720_46173);
if(temp__5735__auto___46191__$1){
var seq__45720_46192__$1 = temp__5735__auto___46191__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45720_46192__$1)){
var c__4609__auto___46193 = cljs.core.chunk_first(seq__45720_46192__$1);
var G__46194 = cljs.core.chunk_rest(seq__45720_46192__$1);
var G__46195 = c__4609__auto___46193;
var G__46196 = cljs.core.count(c__4609__auto___46193);
var G__46197 = (0);
seq__45720_46173 = G__46194;
chunk__45721_46174 = G__46195;
count__45722_46175 = G__46196;
i__45723_46176 = G__46197;
continue;
} else {
var map__45731_46198 = cljs.core.first(seq__45720_46192__$1);
var map__45731_46199__$1 = (((((!((map__45731_46198 == null))))?(((((map__45731_46198.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45731_46198.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45731_46198):map__45731_46198);
var gline_46200 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45731_46199__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46201 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45731_46199__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46202 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45731_46199__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46200], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45720_46173,chunk__45721_46174,count__45722_46175,i__45723_46176,seq__45668_46166,chunk__45669_46167,count__45670_46168,i__45671_46169,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45731_46198,map__45731_46199__$1,gline_46200,gcol_46201,name_46202,seq__45720_46192__$1,temp__5735__auto___46191__$1,vec__45714_46170,column_46171,column_info_46172,vec__45665_46163,line_46164,columns_46165,seq__45264_46157__$1,temp__5735__auto___46156,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46201], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46164,new cljs.core.Keyword(null,"col","col",-1959363084),column_46171,new cljs.core.Keyword(null,"name","name",1843675177),name_46202], null));
});})(seq__45720_46173,chunk__45721_46174,count__45722_46175,i__45723_46176,seq__45668_46166,chunk__45669_46167,count__45670_46168,i__45671_46169,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45731_46198,map__45731_46199__$1,gline_46200,gcol_46201,name_46202,seq__45720_46192__$1,temp__5735__auto___46191__$1,vec__45714_46170,column_46171,column_info_46172,vec__45665_46163,line_46164,columns_46165,seq__45264_46157__$1,temp__5735__auto___46156,inverted))
,cljs.core.sorted_map()));


var G__46208 = cljs.core.next(seq__45720_46192__$1);
var G__46209 = null;
var G__46210 = (0);
var G__46211 = (0);
seq__45720_46173 = G__46208;
chunk__45721_46174 = G__46209;
count__45722_46175 = G__46210;
i__45723_46176 = G__46211;
continue;
}
} else {
}
}
break;
}


var G__46212 = seq__45668_46166;
var G__46213 = chunk__45669_46167;
var G__46214 = count__45670_46168;
var G__46215 = (i__45671_46169 + (1));
seq__45668_46166 = G__46212;
chunk__45669_46167 = G__46213;
count__45670_46168 = G__46214;
i__45671_46169 = G__46215;
continue;
} else {
var temp__5735__auto___46216__$1 = cljs.core.seq(seq__45668_46166);
if(temp__5735__auto___46216__$1){
var seq__45668_46217__$1 = temp__5735__auto___46216__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45668_46217__$1)){
var c__4609__auto___46218 = cljs.core.chunk_first(seq__45668_46217__$1);
var G__46219 = cljs.core.chunk_rest(seq__45668_46217__$1);
var G__46220 = c__4609__auto___46218;
var G__46221 = cljs.core.count(c__4609__auto___46218);
var G__46222 = (0);
seq__45668_46166 = G__46219;
chunk__45669_46167 = G__46220;
count__45670_46168 = G__46221;
i__45671_46169 = G__46222;
continue;
} else {
var vec__45733_46223 = cljs.core.first(seq__45668_46217__$1);
var column_46224 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45733_46223,(0),null);
var column_info_46225 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45733_46223,(1),null);
var seq__45736_46226 = cljs.core.seq(column_info_46225);
var chunk__45737_46227 = null;
var count__45738_46228 = (0);
var i__45739_46229 = (0);
while(true){
if((i__45739_46229 < count__45738_46228)){
var map__45744_46230 = chunk__45737_46227.cljs$core$IIndexed$_nth$arity$2(null,i__45739_46229);
var map__45744_46231__$1 = (((((!((map__45744_46230 == null))))?(((((map__45744_46230.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45744_46230.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45744_46230):map__45744_46230);
var gline_46232 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45744_46231__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46233 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45744_46231__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46234 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45744_46231__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46232], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45736_46226,chunk__45737_46227,count__45738_46228,i__45739_46229,seq__45668_46166,chunk__45669_46167,count__45670_46168,i__45671_46169,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45744_46230,map__45744_46231__$1,gline_46232,gcol_46233,name_46234,vec__45733_46223,column_46224,column_info_46225,seq__45668_46217__$1,temp__5735__auto___46216__$1,vec__45665_46163,line_46164,columns_46165,seq__45264_46157__$1,temp__5735__auto___46156,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46233], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46164,new cljs.core.Keyword(null,"col","col",-1959363084),column_46224,new cljs.core.Keyword(null,"name","name",1843675177),name_46234], null));
});})(seq__45736_46226,chunk__45737_46227,count__45738_46228,i__45739_46229,seq__45668_46166,chunk__45669_46167,count__45670_46168,i__45671_46169,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45744_46230,map__45744_46231__$1,gline_46232,gcol_46233,name_46234,vec__45733_46223,column_46224,column_info_46225,seq__45668_46217__$1,temp__5735__auto___46216__$1,vec__45665_46163,line_46164,columns_46165,seq__45264_46157__$1,temp__5735__auto___46156,inverted))
,cljs.core.sorted_map()));


var G__46236 = seq__45736_46226;
var G__46237 = chunk__45737_46227;
var G__46238 = count__45738_46228;
var G__46239 = (i__45739_46229 + (1));
seq__45736_46226 = G__46236;
chunk__45737_46227 = G__46237;
count__45738_46228 = G__46238;
i__45739_46229 = G__46239;
continue;
} else {
var temp__5735__auto___46240__$2 = cljs.core.seq(seq__45736_46226);
if(temp__5735__auto___46240__$2){
var seq__45736_46241__$1 = temp__5735__auto___46240__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45736_46241__$1)){
var c__4609__auto___46242 = cljs.core.chunk_first(seq__45736_46241__$1);
var G__46243 = cljs.core.chunk_rest(seq__45736_46241__$1);
var G__46244 = c__4609__auto___46242;
var G__46245 = cljs.core.count(c__4609__auto___46242);
var G__46246 = (0);
seq__45736_46226 = G__46243;
chunk__45737_46227 = G__46244;
count__45738_46228 = G__46245;
i__45739_46229 = G__46246;
continue;
} else {
var map__45746_46248 = cljs.core.first(seq__45736_46241__$1);
var map__45746_46249__$1 = (((((!((map__45746_46248 == null))))?(((((map__45746_46248.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45746_46248.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45746_46248):map__45746_46248);
var gline_46250 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45746_46249__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46251 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45746_46249__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46252 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45746_46249__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46250], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45736_46226,chunk__45737_46227,count__45738_46228,i__45739_46229,seq__45668_46166,chunk__45669_46167,count__45670_46168,i__45671_46169,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45746_46248,map__45746_46249__$1,gline_46250,gcol_46251,name_46252,seq__45736_46241__$1,temp__5735__auto___46240__$2,vec__45733_46223,column_46224,column_info_46225,seq__45668_46217__$1,temp__5735__auto___46216__$1,vec__45665_46163,line_46164,columns_46165,seq__45264_46157__$1,temp__5735__auto___46156,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46251], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46164,new cljs.core.Keyword(null,"col","col",-1959363084),column_46224,new cljs.core.Keyword(null,"name","name",1843675177),name_46252], null));
});})(seq__45736_46226,chunk__45737_46227,count__45738_46228,i__45739_46229,seq__45668_46166,chunk__45669_46167,count__45670_46168,i__45671_46169,seq__45264_46027,chunk__45265_46028,count__45266_46029,i__45267_46030,map__45746_46248,map__45746_46249__$1,gline_46250,gcol_46251,name_46252,seq__45736_46241__$1,temp__5735__auto___46240__$2,vec__45733_46223,column_46224,column_info_46225,seq__45668_46217__$1,temp__5735__auto___46216__$1,vec__45665_46163,line_46164,columns_46165,seq__45264_46157__$1,temp__5735__auto___46156,inverted))
,cljs.core.sorted_map()));


var G__46255 = cljs.core.next(seq__45736_46241__$1);
var G__46256 = null;
var G__46257 = (0);
var G__46258 = (0);
seq__45736_46226 = G__46255;
chunk__45737_46227 = G__46256;
count__45738_46228 = G__46257;
i__45739_46229 = G__46258;
continue;
}
} else {
}
}
break;
}


var G__46261 = cljs.core.next(seq__45668_46217__$1);
var G__46262 = null;
var G__46263 = (0);
var G__46264 = (0);
seq__45668_46166 = G__46261;
chunk__45669_46167 = G__46262;
count__45670_46168 = G__46263;
i__45671_46169 = G__46264;
continue;
}
} else {
}
}
break;
}


var G__46265 = cljs.core.next(seq__45264_46157__$1);
var G__46266 = null;
var G__46267 = (0);
var G__46268 = (0);
seq__45264_46027 = G__46265;
chunk__45265_46028 = G__46266;
count__45266_46029 = G__46267;
i__45267_46030 = G__46268;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
