goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__46358 = s;
var map__46358__$1 = (((((!((map__46358 == null))))?(((((map__46358.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46358.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46358):map__46358);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46358__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46358__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__46361 = info;
var map__46362 = G__46361;
var map__46362__$1 = (((((!((map__46362 == null))))?(((((map__46362.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46362.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46362):map__46362);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46362__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__46361__$1 = G__46361;
while(true){
var d__$2 = d__$1;
var map__46366 = G__46361__$1;
var map__46366__$1 = (((((!((map__46366 == null))))?(((((map__46366.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46366.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46366):map__46366);
var shadow__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46366__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$2)){
var G__47004 = (d__$2 + (1));
var G__47005 = shadow__$2;
d__$1 = G__47004;
G__46361__$1 = G__47005;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__46368){
var map__46369 = p__46368;
var map__46369__$1 = (((((!((map__46369 == null))))?(((((map__46369.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46369.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46369):map__46369);
var name_var = map__46369__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46369__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46369__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__46371 = info;
var map__46371__$1 = (((((!((map__46371 == null))))?(((((map__46371.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46371.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46371):map__46371);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46371__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46371__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__46373 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__46373) : cljs.compiler.munge.call(null,G__46373));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__46375 = arguments.length;
switch (G__46375) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__46376 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11472,11472,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__46376.cljs$core$IFn$_invoke$arity$1 ? fexpr__46376.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__46376.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__46377 = cp;
switch (G__46377) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__46378_47023 = cljs.core.seq(s);
var chunk__46379_47024 = null;
var count__46380_47025 = (0);
var i__46381_47026 = (0);
while(true){
if((i__46381_47026 < count__46380_47025)){
var c_47027 = chunk__46379_47024.cljs$core$IIndexed$_nth$arity$2(null,i__46381_47026);
sb.append(cljs.compiler.escape_char(c_47027));


var G__47028 = seq__46378_47023;
var G__47029 = chunk__46379_47024;
var G__47030 = count__46380_47025;
var G__47031 = (i__46381_47026 + (1));
seq__46378_47023 = G__47028;
chunk__46379_47024 = G__47029;
count__46380_47025 = G__47030;
i__46381_47026 = G__47031;
continue;
} else {
var temp__5735__auto___47032 = cljs.core.seq(seq__46378_47023);
if(temp__5735__auto___47032){
var seq__46378_47033__$1 = temp__5735__auto___47032;
if(cljs.core.chunked_seq_QMARK_(seq__46378_47033__$1)){
var c__4609__auto___47034 = cljs.core.chunk_first(seq__46378_47033__$1);
var G__47035 = cljs.core.chunk_rest(seq__46378_47033__$1);
var G__47036 = c__4609__auto___47034;
var G__47037 = cljs.core.count(c__4609__auto___47034);
var G__47038 = (0);
seq__46378_47023 = G__47035;
chunk__46379_47024 = G__47036;
count__46380_47025 = G__47037;
i__46381_47026 = G__47038;
continue;
} else {
var c_47039 = cljs.core.first(seq__46378_47033__$1);
sb.append(cljs.compiler.escape_char(c_47039));


var G__47040 = cljs.core.next(seq__46378_47033__$1);
var G__47041 = null;
var G__47042 = (0);
var G__47043 = (0);
seq__46378_47023 = G__47040;
chunk__46379_47024 = G__47041;
count__46380_47025 = G__47042;
i__46381_47026 = G__47043;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__46383 = cljs.core.get_global_hierarchy;
return (fexpr__46383.cljs$core$IFn$_invoke$arity$0 ? fexpr__46383.cljs$core$IFn$_invoke$arity$0() : fexpr__46383.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__46386_47044 = ast;
var map__46386_47045__$1 = (((((!((map__46386_47044 == null))))?(((((map__46386_47044.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46386_47044.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46386_47044):map__46386_47044);
var env_47046 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46386_47045__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_47046))){
var map__46388_47047 = env_47046;
var map__46388_47048__$1 = (((((!((map__46388_47047 == null))))?(((((map__46388_47047.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46388_47047.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46388_47047):map__46388_47047);
var line_47049 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46388_47048__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_47050 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46388_47048__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__46390 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__46392 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__46391 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__46391.cljs$core$IFn$_invoke$arity$1 ? fexpr__46391.cljs$core$IFn$_invoke$arity$1(G__46392) : fexpr__46391.call(null,G__46392));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__46390,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__46390;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_47049 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_47050)?(column_47050 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__46402 = arguments.length;
switch (G__46402) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___47052 = arguments.length;
var i__4790__auto___47053 = (0);
while(true){
if((i__4790__auto___47053 < len__4789__auto___47052)){
args_arr__4810__auto__.push((arguments[i__4790__auto___47053]));

var G__47054 = (i__4790__auto___47053 + (1));
i__4790__auto___47053 = G__47054;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_47055 = (function (){var G__46404 = a;
if((!(typeof a === 'string'))){
return G__46404.toString();
} else {
return G__46404;
}
})();
var temp__5739__auto___47056 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___47056 == null)){
} else {
var sm_data_47057 = temp__5739__auto___47056;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_47057,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__46394_SHARP_){
return (p1__46394_SHARP_ + s_47055.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_47055], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__46406 = cljs.core.seq(xs);
var chunk__46407 = null;
var count__46408 = (0);
var i__46409 = (0);
while(true){
if((i__46409 < count__46408)){
var x = chunk__46407.cljs$core$IIndexed$_nth$arity$2(null,i__46409);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__47070 = seq__46406;
var G__47071 = chunk__46407;
var G__47072 = count__46408;
var G__47073 = (i__46409 + (1));
seq__46406 = G__47070;
chunk__46407 = G__47071;
count__46408 = G__47072;
i__46409 = G__47073;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46406);
if(temp__5735__auto__){
var seq__46406__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46406__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__46406__$1);
var G__47075 = cljs.core.chunk_rest(seq__46406__$1);
var G__47076 = c__4609__auto__;
var G__47077 = cljs.core.count(c__4609__auto__);
var G__47078 = (0);
seq__46406 = G__47075;
chunk__46407 = G__47076;
count__46408 = G__47077;
i__46409 = G__47078;
continue;
} else {
var x = cljs.core.first(seq__46406__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__47083 = cljs.core.next(seq__46406__$1);
var G__47084 = null;
var G__47085 = (0);
var G__47086 = (0);
seq__46406 = G__47083;
chunk__46407 = G__47084;
count__46408 = G__47085;
i__46409 = G__47086;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq46396){
var G__46397 = cljs.core.first(seq46396);
var seq46396__$1 = cljs.core.next(seq46396);
var G__46398 = cljs.core.first(seq46396__$1);
var seq46396__$2 = cljs.core.next(seq46396__$1);
var G__46399 = cljs.core.first(seq46396__$2);
var seq46396__$3 = cljs.core.next(seq46396__$2);
var G__46400 = cljs.core.first(seq46396__$3);
var seq46396__$4 = cljs.core.next(seq46396__$3);
var G__46401 = cljs.core.first(seq46396__$4);
var seq46396__$5 = cljs.core.next(seq46396__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46397,G__46398,G__46399,G__46400,G__46401,seq46396__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__46410){
var map__46411 = p__46410;
var map__46411__$1 = (((((!((map__46411 == null))))?(((((map__46411.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46411.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46411):map__46411);
var m = map__46411__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46411__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__46421 = arguments.length;
switch (G__46421) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___47105 = arguments.length;
var i__4790__auto___47106 = (0);
while(true){
if((i__4790__auto___47106 < len__4789__auto___47105)){
args_arr__4810__auto__.push((arguments[i__4790__auto___47106]));

var G__47111 = (i__4790__auto___47106 + (1));
i__4790__auto___47106 = G__47111;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__46435_47112 = cljs.core.seq(xs);
var chunk__46436_47113 = null;
var count__46437_47114 = (0);
var i__46438_47115 = (0);
while(true){
if((i__46438_47115 < count__46437_47114)){
var x_47116 = chunk__46436_47113.cljs$core$IIndexed$_nth$arity$2(null,i__46438_47115);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_47116);


var G__47117 = seq__46435_47112;
var G__47118 = chunk__46436_47113;
var G__47119 = count__46437_47114;
var G__47120 = (i__46438_47115 + (1));
seq__46435_47112 = G__47117;
chunk__46436_47113 = G__47118;
count__46437_47114 = G__47119;
i__46438_47115 = G__47120;
continue;
} else {
var temp__5735__auto___47121 = cljs.core.seq(seq__46435_47112);
if(temp__5735__auto___47121){
var seq__46435_47122__$1 = temp__5735__auto___47121;
if(cljs.core.chunked_seq_QMARK_(seq__46435_47122__$1)){
var c__4609__auto___47123 = cljs.core.chunk_first(seq__46435_47122__$1);
var G__47124 = cljs.core.chunk_rest(seq__46435_47122__$1);
var G__47125 = c__4609__auto___47123;
var G__47126 = cljs.core.count(c__4609__auto___47123);
var G__47127 = (0);
seq__46435_47112 = G__47124;
chunk__46436_47113 = G__47125;
count__46437_47114 = G__47126;
i__46438_47115 = G__47127;
continue;
} else {
var x_47128 = cljs.core.first(seq__46435_47122__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_47128);


var G__47129 = cljs.core.next(seq__46435_47122__$1);
var G__47130 = null;
var G__47131 = (0);
var G__47132 = (0);
seq__46435_47112 = G__47129;
chunk__46436_47113 = G__47130;
count__46437_47114 = G__47131;
i__46438_47115 = G__47132;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq46415){
var G__46416 = cljs.core.first(seq46415);
var seq46415__$1 = cljs.core.next(seq46415);
var G__46417 = cljs.core.first(seq46415__$1);
var seq46415__$2 = cljs.core.next(seq46415__$1);
var G__46418 = cljs.core.first(seq46415__$2);
var seq46415__$3 = cljs.core.next(seq46415__$2);
var G__46419 = cljs.core.first(seq46415__$3);
var seq46415__$4 = cljs.core.next(seq46415__$3);
var G__46420 = cljs.core.first(seq46415__$4);
var seq46415__$5 = cljs.core.next(seq46415__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46416,G__46417,G__46418,G__46419,G__46420,seq46415__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__46440_47133 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__46441_47134 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__46442_47135 = true;
var _STAR_print_fn_STAR__temp_val__46443_47136 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__46442_47135);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__46443_47136);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__46441_47134);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__46440_47133);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__46444 = cljs.core.get_global_hierarchy;
return (fexpr__46444.cljs$core$IFn$_invoke$arity$0 ? fexpr__46444.cljs$core$IFn$_invoke$arity$0() : fexpr__46444.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__46446 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46446,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46446,(1),null);
var G__46449 = ns;
var G__46450 = name;
var G__46451 = (function (){
var G__46452 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__46452) : cljs.compiler.emit_constant.call(null,G__46452));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__46449,G__46450,G__46451) : cljs.compiler.emit_record_value.call(null,G__46449,G__46450,G__46451));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__46453 = cljs.core.keys(x);
var G__46454 = cljs.core.vals(x);
var G__46455 = cljs.compiler.emit_constants_comma_sep;
var G__46456 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__46453,G__46454,G__46455,G__46456) : cljs.compiler.emit_map.call(null,G__46453,G__46454,G__46455,G__46456));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__46457 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__46458 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__46457,G__46458) : cljs.compiler.emit_with_meta.call(null,G__46457,G__46458));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__46461 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46461,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46461,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46461,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__46464 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__46464) : x.call(null,G__46464));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__46466 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__46466) : x.call(null,G__46466));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__46472 = items;
var G__46473 = (function (p1__46470_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__46470_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__46472,G__46473) : cljs.compiler.emit_js_object.call(null,G__46472,G__46473));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__46475){
var map__46476 = p__46475;
var map__46476__$1 = (((((!((map__46476 == null))))?(((((map__46476.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46476.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46476):map__46476);
var ast = map__46476__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46476__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46476__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46476__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__46481 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__46481__$1 = (((((!((map__46481 == null))))?(((((map__46481.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46481.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46481):map__46481);
var cenv = map__46481__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46481__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4185__auto__ = js_module_name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__46484 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4174__auto__ = (function (){var G__46488 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__46488) : cljs.compiler.es5_GT__EQ_.call(null,G__46488));
})();
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4174__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__46484,cljs.analyzer.es5_allowed);
} else {
return G__46484;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4185__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__46489 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__46489,reserved);
} else {
return G__46489;
}
})();
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__46490_47166 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__46490_47167__$1 = (((G__46490_47166 instanceof cljs.core.Keyword))?G__46490_47166.fqn:null);
switch (G__46490_47167__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4174__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__46491){
var map__46492 = p__46491;
var map__46492__$1 = (((((!((map__46492 == null))))?(((((map__46492.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46492.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46492):map__46492);
var arg = map__46492__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46492__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46492__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46492__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46492__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__46494 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__46494__$1 = (((((!((map__46494 == null))))?(((((map__46494.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46494.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46494):map__46494);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46494__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__46496){
var map__46497 = p__46496;
var map__46497__$1 = (((((!((map__46497 == null))))?(((((map__46497.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46497.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46497):map__46497);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46497__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46497__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46497__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__46499_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__46499_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__46500 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__46500) : comma_sep.call(null,G__46500));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__46501 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__46501) : comma_sep.call(null,G__46501));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__46502){
var map__46503 = p__46502;
var map__46503__$1 = (((((!((map__46503 == null))))?(((((map__46503.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46503.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46503):map__46503);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46503__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46503__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46503__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__46507){
var map__46508 = p__46507;
var map__46508__$1 = (((((!((map__46508 == null))))?(((((map__46508.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46508.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46508):map__46508);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46508__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46508__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__46510_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__46510_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__46511 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__46511) : comma_sep.call(null,G__46511));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__46512){
var map__46513 = p__46512;
var map__46513__$1 = (((((!((map__46513 == null))))?(((((map__46513.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46513.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46513):map__46513);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46513__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46513__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___47198 = cljs.core.seq(items);
if(temp__5735__auto___47198){
var items_47199__$1 = temp__5735__auto___47198;
var vec__46518_47200 = items_47199__$1;
var seq__46519_47201 = cljs.core.seq(vec__46518_47200);
var first__46520_47202 = cljs.core.first(seq__46519_47201);
var seq__46519_47203__$1 = cljs.core.next(seq__46519_47201);
var vec__46521_47204 = first__46520_47202;
var k_47205 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46521_47204,(0),null);
var v_47206 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46521_47204,(1),null);
var r_47207 = seq__46519_47203__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_47205),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_47206) : emit_js_object_val.call(null,v_47206)));

var seq__46524_47208 = cljs.core.seq(r_47207);
var chunk__46525_47209 = null;
var count__46526_47210 = (0);
var i__46527_47211 = (0);
while(true){
if((i__46527_47211 < count__46526_47210)){
var vec__46534_47212 = chunk__46525_47209.cljs$core$IIndexed$_nth$arity$2(null,i__46527_47211);
var k_47213__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46534_47212,(0),null);
var v_47214__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46534_47212,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_47213__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_47214__$1) : emit_js_object_val.call(null,v_47214__$1)));


var G__47215 = seq__46524_47208;
var G__47216 = chunk__46525_47209;
var G__47217 = count__46526_47210;
var G__47218 = (i__46527_47211 + (1));
seq__46524_47208 = G__47215;
chunk__46525_47209 = G__47216;
count__46526_47210 = G__47217;
i__46527_47211 = G__47218;
continue;
} else {
var temp__5735__auto___47219__$1 = cljs.core.seq(seq__46524_47208);
if(temp__5735__auto___47219__$1){
var seq__46524_47220__$1 = temp__5735__auto___47219__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46524_47220__$1)){
var c__4609__auto___47221 = cljs.core.chunk_first(seq__46524_47220__$1);
var G__47222 = cljs.core.chunk_rest(seq__46524_47220__$1);
var G__47223 = c__4609__auto___47221;
var G__47224 = cljs.core.count(c__4609__auto___47221);
var G__47225 = (0);
seq__46524_47208 = G__47222;
chunk__46525_47209 = G__47223;
count__46526_47210 = G__47224;
i__46527_47211 = G__47225;
continue;
} else {
var vec__46537_47226 = cljs.core.first(seq__46524_47220__$1);
var k_47227__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46537_47226,(0),null);
var v_47228__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46537_47226,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_47227__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_47228__$1) : emit_js_object_val.call(null,v_47228__$1)));


var G__47229 = cljs.core.next(seq__46524_47220__$1);
var G__47230 = null;
var G__47231 = (0);
var G__47232 = (0);
seq__46524_47208 = G__47229;
chunk__46525_47209 = G__47230;
count__46526_47210 = G__47231;
i__46527_47211 = G__47232;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__46540){
var map__46544 = p__46540;
var map__46544__$1 = (((((!((map__46544 == null))))?(((((map__46544.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46544.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46544):map__46544);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46544__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46544__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46544__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__46546){
var map__46550 = p__46546;
var map__46550__$1 = (((((!((map__46550 == null))))?(((((map__46550.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46550.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46550):map__46550);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46550__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46550__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__46552){
var map__46553 = p__46552;
var map__46553__$1 = (((((!((map__46553 == null))))?(((((map__46553.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46553.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46553):map__46553);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46553__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__46557){
var map__46558 = p__46557;
var map__46558__$1 = (((((!((map__46558 == null))))?(((((map__46558.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46558.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46558):map__46558);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46558__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46558__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__46570 = cljs.analyzer.unwrap_quote(expr);
var map__46570__$1 = (((((!((map__46570 == null))))?(((((map__46570.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46570.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46570):map__46570);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46570__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46570__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46570__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4174__auto__ = form;
if(cljs.core.truth_(and__4174__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4174__auto__;
}
})():false);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__46576 = cljs.analyzer.unwrap_quote(expr);
var map__46576__$1 = (((((!((map__46576 == null))))?(((((map__46576.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46576.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46576):map__46576);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46576__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46576__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46576__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4185__auto__){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4185__auto__ = (function (){var fexpr__46579 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__46579.cljs$core$IFn$_invoke$arity$1 ? fexpr__46579.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__46579.call(null,tag));
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__46580){
var map__46581 = p__46580;
var map__46581__$1 = (((((!((map__46581 == null))))?(((((map__46581.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46581.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46581):map__46581);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46581__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46581__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46581__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46581__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46581__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4185__auto__ = unchecked;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__46583){
var map__46584 = p__46583;
var map__46584__$1 = (((((!((map__46584 == null))))?(((((map__46584.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46584.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46584):map__46584);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46584__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46584__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46584__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46584__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__46586_47247 = cljs.core.seq(nodes);
var chunk__46587_47248 = null;
var count__46588_47249 = (0);
var i__46589_47250 = (0);
while(true){
if((i__46589_47250 < count__46588_47249)){
var map__46607_47251 = chunk__46587_47248.cljs$core$IIndexed$_nth$arity$2(null,i__46589_47250);
var map__46607_47252__$1 = (((((!((map__46607_47251 == null))))?(((((map__46607_47251.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46607_47251.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46607_47251):map__46607_47251);
var ts_47253 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46607_47252__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__46608_47254 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46607_47252__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__46608_47255__$1 = (((((!((map__46608_47254 == null))))?(((((map__46608_47254.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46608_47254.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46608_47254):map__46608_47254);
var then_47256 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46608_47255__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__46611_47257 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_47253));
var chunk__46612_47258 = null;
var count__46613_47259 = (0);
var i__46614_47260 = (0);
while(true){
if((i__46614_47260 < count__46613_47259)){
var test_47262 = chunk__46612_47258.cljs$core$IIndexed$_nth$arity$2(null,i__46614_47260);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_47262,":");


var G__47264 = seq__46611_47257;
var G__47265 = chunk__46612_47258;
var G__47266 = count__46613_47259;
var G__47267 = (i__46614_47260 + (1));
seq__46611_47257 = G__47264;
chunk__46612_47258 = G__47265;
count__46613_47259 = G__47266;
i__46614_47260 = G__47267;
continue;
} else {
var temp__5735__auto___47268 = cljs.core.seq(seq__46611_47257);
if(temp__5735__auto___47268){
var seq__46611_47269__$1 = temp__5735__auto___47268;
if(cljs.core.chunked_seq_QMARK_(seq__46611_47269__$1)){
var c__4609__auto___47270 = cljs.core.chunk_first(seq__46611_47269__$1);
var G__47271 = cljs.core.chunk_rest(seq__46611_47269__$1);
var G__47272 = c__4609__auto___47270;
var G__47273 = cljs.core.count(c__4609__auto___47270);
var G__47274 = (0);
seq__46611_47257 = G__47271;
chunk__46612_47258 = G__47272;
count__46613_47259 = G__47273;
i__46614_47260 = G__47274;
continue;
} else {
var test_47275 = cljs.core.first(seq__46611_47269__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_47275,":");


var G__47276 = cljs.core.next(seq__46611_47269__$1);
var G__47277 = null;
var G__47278 = (0);
var G__47279 = (0);
seq__46611_47257 = G__47276;
chunk__46612_47258 = G__47277;
count__46613_47259 = G__47278;
i__46614_47260 = G__47279;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_47256);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_47256);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__47280 = seq__46586_47247;
var G__47281 = chunk__46587_47248;
var G__47282 = count__46588_47249;
var G__47283 = (i__46589_47250 + (1));
seq__46586_47247 = G__47280;
chunk__46587_47248 = G__47281;
count__46588_47249 = G__47282;
i__46589_47250 = G__47283;
continue;
} else {
var temp__5735__auto___47284 = cljs.core.seq(seq__46586_47247);
if(temp__5735__auto___47284){
var seq__46586_47285__$1 = temp__5735__auto___47284;
if(cljs.core.chunked_seq_QMARK_(seq__46586_47285__$1)){
var c__4609__auto___47286 = cljs.core.chunk_first(seq__46586_47285__$1);
var G__47287 = cljs.core.chunk_rest(seq__46586_47285__$1);
var G__47288 = c__4609__auto___47286;
var G__47289 = cljs.core.count(c__4609__auto___47286);
var G__47290 = (0);
seq__46586_47247 = G__47287;
chunk__46587_47248 = G__47288;
count__46588_47249 = G__47289;
i__46589_47250 = G__47290;
continue;
} else {
var map__46615_47291 = cljs.core.first(seq__46586_47285__$1);
var map__46615_47292__$1 = (((((!((map__46615_47291 == null))))?(((((map__46615_47291.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46615_47291.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46615_47291):map__46615_47291);
var ts_47293 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46615_47292__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__46616_47294 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46615_47292__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__46616_47295__$1 = (((((!((map__46616_47294 == null))))?(((((map__46616_47294.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46616_47294.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46616_47294):map__46616_47294);
var then_47296 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46616_47295__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__46619_47297 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_47293));
var chunk__46620_47298 = null;
var count__46621_47299 = (0);
var i__46622_47300 = (0);
while(true){
if((i__46622_47300 < count__46621_47299)){
var test_47301 = chunk__46620_47298.cljs$core$IIndexed$_nth$arity$2(null,i__46622_47300);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_47301,":");


var G__47302 = seq__46619_47297;
var G__47303 = chunk__46620_47298;
var G__47304 = count__46621_47299;
var G__47305 = (i__46622_47300 + (1));
seq__46619_47297 = G__47302;
chunk__46620_47298 = G__47303;
count__46621_47299 = G__47304;
i__46622_47300 = G__47305;
continue;
} else {
var temp__5735__auto___47306__$1 = cljs.core.seq(seq__46619_47297);
if(temp__5735__auto___47306__$1){
var seq__46619_47307__$1 = temp__5735__auto___47306__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46619_47307__$1)){
var c__4609__auto___47308 = cljs.core.chunk_first(seq__46619_47307__$1);
var G__47309 = cljs.core.chunk_rest(seq__46619_47307__$1);
var G__47310 = c__4609__auto___47308;
var G__47311 = cljs.core.count(c__4609__auto___47308);
var G__47312 = (0);
seq__46619_47297 = G__47309;
chunk__46620_47298 = G__47310;
count__46621_47299 = G__47311;
i__46622_47300 = G__47312;
continue;
} else {
var test_47313 = cljs.core.first(seq__46619_47307__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_47313,":");


var G__47314 = cljs.core.next(seq__46619_47307__$1);
var G__47315 = null;
var G__47316 = (0);
var G__47317 = (0);
seq__46619_47297 = G__47314;
chunk__46620_47298 = G__47315;
count__46621_47299 = G__47316;
i__46622_47300 = G__47317;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_47296);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_47296);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__47318 = cljs.core.next(seq__46586_47285__$1);
var G__47319 = null;
var G__47320 = (0);
var G__47321 = (0);
seq__46586_47247 = G__47318;
chunk__46587_47248 = G__47319;
count__46588_47249 = G__47320;
i__46589_47250 = G__47321;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__46627){
var map__46628 = p__46627;
var map__46628__$1 = (((((!((map__46628 == null))))?(((((map__46628.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46628.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46628):map__46628);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46628__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46628__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__46633 = env;
var G__46634 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__46633,G__46634) : cljs.compiler.resolve_type.call(null,G__46633,G__46634));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__46635 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46635,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46635,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__46630_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__46630_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__46630_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__46638 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__46638,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__46638;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__46641 = env;
var G__46642 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__46641,G__46642) : cljs.compiler.resolve_type.call(null,G__46641,G__46642));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46643_SHARP_){
return cljs.compiler.resolve_type(env,p1__46643_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__46644 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__46645 = cljs.core.seq(vec__46644);
var first__46646 = cljs.core.first(seq__46645);
var seq__46645__$1 = cljs.core.next(seq__46645);
var p = first__46646;
var first__46646__$1 = cljs.core.first(seq__46645__$1);
var seq__46645__$2 = cljs.core.next(seq__46645__$1);
var ts = first__46646__$1;
var first__46646__$2 = cljs.core.first(seq__46645__$2);
var seq__46645__$3 = cljs.core.next(seq__46645__$2);
var n = first__46646__$2;
var xs = seq__46645__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__46647 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__46648 = cljs.core.seq(vec__46647);
var first__46649 = cljs.core.first(seq__46648);
var seq__46648__$1 = cljs.core.next(seq__46648);
var p = first__46649;
var first__46649__$1 = cljs.core.first(seq__46648__$1);
var seq__46648__$2 = cljs.core.next(seq__46648__$1);
var ts = first__46649__$1;
var xs = seq__46648__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__46651 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__46650 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__46650.cljs$core$IFn$_invoke$arity$1 ? fexpr__46650.cljs$core$IFn$_invoke$arity$1(G__46651) : fexpr__46650.call(null,G__46651));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__46654 = arguments.length;
switch (G__46654) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__46662 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__46652_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__46652_SHARP_);
} else {
return p1__46652_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__46663 = cljs.core.seq(vec__46662);
var first__46664 = cljs.core.first(seq__46663);
var seq__46663__$1 = cljs.core.next(seq__46663);
var x = first__46664;
var ys = seq__46663__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__46665 = cljs.core.seq(ys);
var chunk__46666 = null;
var count__46667 = (0);
var i__46668 = (0);
while(true){
if((i__46668 < count__46667)){
var next_line = chunk__46666.cljs$core$IIndexed$_nth$arity$2(null,i__46668);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__47345 = seq__46665;
var G__47346 = chunk__46666;
var G__47347 = count__46667;
var G__47348 = (i__46668 + (1));
seq__46665 = G__47345;
chunk__46666 = G__47346;
count__46667 = G__47347;
i__46668 = G__47348;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46665);
if(temp__5735__auto__){
var seq__46665__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46665__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__46665__$1);
var G__47349 = cljs.core.chunk_rest(seq__46665__$1);
var G__47350 = c__4609__auto__;
var G__47351 = cljs.core.count(c__4609__auto__);
var G__47352 = (0);
seq__46665 = G__47349;
chunk__46666 = G__47350;
count__46667 = G__47351;
i__46668 = G__47352;
continue;
} else {
var next_line = cljs.core.first(seq__46665__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__47353 = cljs.core.next(seq__46665__$1);
var G__47354 = null;
var G__47355 = (0);
var G__47356 = (0);
seq__46665 = G__47353;
chunk__46666 = G__47354;
count__46667 = G__47355;
i__46668 = G__47356;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__46669_47357 = cljs.core.seq(docs__$2);
var chunk__46670_47358 = null;
var count__46671_47359 = (0);
var i__46672_47360 = (0);
while(true){
if((i__46672_47360 < count__46671_47359)){
var e_47361 = chunk__46670_47358.cljs$core$IIndexed$_nth$arity$2(null,i__46672_47360);
if(cljs.core.truth_(e_47361)){
print_comment_lines(e_47361);
} else {
}


var G__47362 = seq__46669_47357;
var G__47363 = chunk__46670_47358;
var G__47364 = count__46671_47359;
var G__47365 = (i__46672_47360 + (1));
seq__46669_47357 = G__47362;
chunk__46670_47358 = G__47363;
count__46671_47359 = G__47364;
i__46672_47360 = G__47365;
continue;
} else {
var temp__5735__auto___47366 = cljs.core.seq(seq__46669_47357);
if(temp__5735__auto___47366){
var seq__46669_47367__$1 = temp__5735__auto___47366;
if(cljs.core.chunked_seq_QMARK_(seq__46669_47367__$1)){
var c__4609__auto___47368 = cljs.core.chunk_first(seq__46669_47367__$1);
var G__47370 = cljs.core.chunk_rest(seq__46669_47367__$1);
var G__47371 = c__4609__auto___47368;
var G__47372 = cljs.core.count(c__4609__auto___47368);
var G__47373 = (0);
seq__46669_47357 = G__47370;
chunk__46670_47358 = G__47371;
count__46671_47359 = G__47372;
i__46672_47360 = G__47373;
continue;
} else {
var e_47374 = cljs.core.first(seq__46669_47367__$1);
if(cljs.core.truth_(e_47374)){
print_comment_lines(e_47374);
} else {
}


var G__47376 = cljs.core.next(seq__46669_47367__$1);
var G__47377 = null;
var G__47378 = (0);
var G__47379 = (0);
seq__46669_47357 = G__47376;
chunk__46670_47358 = G__47377;
count__46671_47359 = G__47378;
i__46672_47360 = G__47379;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4174__auto__ = cljs.core.some((function (p1__46674_SHARP_){
return goog.string.startsWith(p1__46674_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = opts;
if(cljs.core.truth_(and__4174__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__46675){
var map__46676 = p__46675;
var map__46676__$1 = (((((!((map__46676 == null))))?(((((map__46676.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46676.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46676):map__46676);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"test","test",577538877));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46676__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4185__auto__ = init;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
return test;
} else {
return and__4174__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__46678){
var map__46679 = p__46678;
var map__46679__$1 = (((((!((map__46679 == null))))?(((((map__46679.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46679.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46679):map__46679);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46679__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46679__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46679__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__46681_47380 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__46682_47381 = null;
var count__46683_47382 = (0);
var i__46684_47383 = (0);
while(true){
if((i__46684_47383 < count__46683_47382)){
var vec__46691_47384 = chunk__46682_47381.cljs$core$IIndexed$_nth$arity$2(null,i__46684_47383);
var i_47385 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46691_47384,(0),null);
var param_47386 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46691_47384,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_47386);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__47387 = seq__46681_47380;
var G__47388 = chunk__46682_47381;
var G__47389 = count__46683_47382;
var G__47390 = (i__46684_47383 + (1));
seq__46681_47380 = G__47387;
chunk__46682_47381 = G__47388;
count__46683_47382 = G__47389;
i__46684_47383 = G__47390;
continue;
} else {
var temp__5735__auto___47391 = cljs.core.seq(seq__46681_47380);
if(temp__5735__auto___47391){
var seq__46681_47392__$1 = temp__5735__auto___47391;
if(cljs.core.chunked_seq_QMARK_(seq__46681_47392__$1)){
var c__4609__auto___47393 = cljs.core.chunk_first(seq__46681_47392__$1);
var G__47394 = cljs.core.chunk_rest(seq__46681_47392__$1);
var G__47395 = c__4609__auto___47393;
var G__47396 = cljs.core.count(c__4609__auto___47393);
var G__47397 = (0);
seq__46681_47380 = G__47394;
chunk__46682_47381 = G__47395;
count__46683_47382 = G__47396;
i__46684_47383 = G__47397;
continue;
} else {
var vec__46694_47398 = cljs.core.first(seq__46681_47392__$1);
var i_47399 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46694_47398,(0),null);
var param_47400 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46694_47398,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_47400);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__47401 = cljs.core.next(seq__46681_47392__$1);
var G__47402 = null;
var G__47403 = (0);
var G__47404 = (0);
seq__46681_47380 = G__47401;
chunk__46682_47381 = G__47402;
count__46683_47382 = G__47403;
i__46684_47383 = G__47404;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__46697_47405 = cljs.core.seq(params);
var chunk__46698_47406 = null;
var count__46699_47407 = (0);
var i__46700_47408 = (0);
while(true){
if((i__46700_47408 < count__46699_47407)){
var param_47409 = chunk__46698_47406.cljs$core$IIndexed$_nth$arity$2(null,i__46700_47408);
cljs.compiler.emit(param_47409);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47409,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47410 = seq__46697_47405;
var G__47411 = chunk__46698_47406;
var G__47412 = count__46699_47407;
var G__47413 = (i__46700_47408 + (1));
seq__46697_47405 = G__47410;
chunk__46698_47406 = G__47411;
count__46699_47407 = G__47412;
i__46700_47408 = G__47413;
continue;
} else {
var temp__5735__auto___47414 = cljs.core.seq(seq__46697_47405);
if(temp__5735__auto___47414){
var seq__46697_47415__$1 = temp__5735__auto___47414;
if(cljs.core.chunked_seq_QMARK_(seq__46697_47415__$1)){
var c__4609__auto___47416 = cljs.core.chunk_first(seq__46697_47415__$1);
var G__47417 = cljs.core.chunk_rest(seq__46697_47415__$1);
var G__47418 = c__4609__auto___47416;
var G__47419 = cljs.core.count(c__4609__auto___47416);
var G__47420 = (0);
seq__46697_47405 = G__47417;
chunk__46698_47406 = G__47418;
count__46699_47407 = G__47419;
i__46700_47408 = G__47420;
continue;
} else {
var param_47421 = cljs.core.first(seq__46697_47415__$1);
cljs.compiler.emit(param_47421);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47421,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47422 = cljs.core.next(seq__46697_47415__$1);
var G__47423 = null;
var G__47424 = (0);
var G__47425 = (0);
seq__46697_47405 = G__47422;
chunk__46698_47406 = G__47423;
count__46699_47407 = G__47424;
i__46700_47408 = G__47425;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__46701_47426 = cljs.core.seq(params);
var chunk__46702_47427 = null;
var count__46703_47428 = (0);
var i__46704_47429 = (0);
while(true){
if((i__46704_47429 < count__46703_47428)){
var param_47430 = chunk__46702_47427.cljs$core$IIndexed$_nth$arity$2(null,i__46704_47429);
cljs.compiler.emit(param_47430);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47430,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47431 = seq__46701_47426;
var G__47432 = chunk__46702_47427;
var G__47433 = count__46703_47428;
var G__47434 = (i__46704_47429 + (1));
seq__46701_47426 = G__47431;
chunk__46702_47427 = G__47432;
count__46703_47428 = G__47433;
i__46704_47429 = G__47434;
continue;
} else {
var temp__5735__auto___47435 = cljs.core.seq(seq__46701_47426);
if(temp__5735__auto___47435){
var seq__46701_47436__$1 = temp__5735__auto___47435;
if(cljs.core.chunked_seq_QMARK_(seq__46701_47436__$1)){
var c__4609__auto___47437 = cljs.core.chunk_first(seq__46701_47436__$1);
var G__47438 = cljs.core.chunk_rest(seq__46701_47436__$1);
var G__47439 = c__4609__auto___47437;
var G__47440 = cljs.core.count(c__4609__auto___47437);
var G__47441 = (0);
seq__46701_47426 = G__47438;
chunk__46702_47427 = G__47439;
count__46703_47428 = G__47440;
i__46704_47429 = G__47441;
continue;
} else {
var param_47442 = cljs.core.first(seq__46701_47436__$1);
cljs.compiler.emit(param_47442);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47442,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47443 = cljs.core.next(seq__46701_47436__$1);
var G__47444 = null;
var G__47445 = (0);
var G__47446 = (0);
seq__46701_47426 = G__47443;
chunk__46702_47427 = G__47444;
count__46703_47428 = G__47445;
i__46704_47429 = G__47446;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__46705 = cljs.core.seq(params);
var chunk__46706 = null;
var count__46707 = (0);
var i__46708 = (0);
while(true){
if((i__46708 < count__46707)){
var param = chunk__46706.cljs$core$IIndexed$_nth$arity$2(null,i__46708);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47447 = seq__46705;
var G__47448 = chunk__46706;
var G__47449 = count__46707;
var G__47450 = (i__46708 + (1));
seq__46705 = G__47447;
chunk__46706 = G__47448;
count__46707 = G__47449;
i__46708 = G__47450;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46705);
if(temp__5735__auto__){
var seq__46705__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46705__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__46705__$1);
var G__47451 = cljs.core.chunk_rest(seq__46705__$1);
var G__47452 = c__4609__auto__;
var G__47453 = cljs.core.count(c__4609__auto__);
var G__47454 = (0);
seq__46705 = G__47451;
chunk__46706 = G__47452;
count__46707 = G__47453;
i__46708 = G__47454;
continue;
} else {
var param = cljs.core.first(seq__46705__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47455 = cljs.core.next(seq__46705__$1);
var G__47456 = null;
var G__47457 = (0);
var G__47458 = (0);
seq__46705 = G__47455;
chunk__46706 = G__47456;
count__46707 = G__47457;
i__46708 = G__47458;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__46709){
var map__46710 = p__46709;
var map__46710__$1 = (((((!((map__46710 == null))))?(((((map__46710.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46710.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46710):map__46710);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46710__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46710__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46710__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46710__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46710__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46710__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__46720){
var map__46721 = p__46720;
var map__46721__$1 = (((((!((map__46721 == null))))?(((((map__46721.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46721.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46721):map__46721);
var f = map__46721__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46721__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_47459__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_47460 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_47459__$1);
var delegate_name_47461 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_47460),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_47461," = function (");

var seq__46723_47462 = cljs.core.seq(params);
var chunk__46724_47463 = null;
var count__46725_47464 = (0);
var i__46726_47465 = (0);
while(true){
if((i__46726_47465 < count__46725_47464)){
var param_47466 = chunk__46724_47463.cljs$core$IIndexed$_nth$arity$2(null,i__46726_47465);
cljs.compiler.emit(param_47466);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47466,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47467 = seq__46723_47462;
var G__47468 = chunk__46724_47463;
var G__47469 = count__46725_47464;
var G__47470 = (i__46726_47465 + (1));
seq__46723_47462 = G__47467;
chunk__46724_47463 = G__47468;
count__46725_47464 = G__47469;
i__46726_47465 = G__47470;
continue;
} else {
var temp__5735__auto___47471 = cljs.core.seq(seq__46723_47462);
if(temp__5735__auto___47471){
var seq__46723_47472__$1 = temp__5735__auto___47471;
if(cljs.core.chunked_seq_QMARK_(seq__46723_47472__$1)){
var c__4609__auto___47473 = cljs.core.chunk_first(seq__46723_47472__$1);
var G__47474 = cljs.core.chunk_rest(seq__46723_47472__$1);
var G__47475 = c__4609__auto___47473;
var G__47476 = cljs.core.count(c__4609__auto___47473);
var G__47477 = (0);
seq__46723_47462 = G__47474;
chunk__46724_47463 = G__47475;
count__46725_47464 = G__47476;
i__46726_47465 = G__47477;
continue;
} else {
var param_47478 = cljs.core.first(seq__46723_47472__$1);
cljs.compiler.emit(param_47478);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47478,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47479 = cljs.core.next(seq__46723_47472__$1);
var G__47480 = null;
var G__47481 = (0);
var G__47482 = (0);
seq__46723_47462 = G__47479;
chunk__46724_47463 = G__47480;
count__46725_47464 = G__47481;
i__46726_47465 = G__47482;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_47460," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_47483 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_47483,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_47461,".call(this,");

var seq__46727_47484 = cljs.core.seq(params);
var chunk__46728_47485 = null;
var count__46729_47486 = (0);
var i__46730_47487 = (0);
while(true){
if((i__46730_47487 < count__46729_47486)){
var param_47488 = chunk__46728_47485.cljs$core$IIndexed$_nth$arity$2(null,i__46730_47487);
cljs.compiler.emit(param_47488);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47488,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47492 = seq__46727_47484;
var G__47493 = chunk__46728_47485;
var G__47494 = count__46729_47486;
var G__47495 = (i__46730_47487 + (1));
seq__46727_47484 = G__47492;
chunk__46728_47485 = G__47493;
count__46729_47486 = G__47494;
i__46730_47487 = G__47495;
continue;
} else {
var temp__5735__auto___47496 = cljs.core.seq(seq__46727_47484);
if(temp__5735__auto___47496){
var seq__46727_47497__$1 = temp__5735__auto___47496;
if(cljs.core.chunked_seq_QMARK_(seq__46727_47497__$1)){
var c__4609__auto___47498 = cljs.core.chunk_first(seq__46727_47497__$1);
var G__47499 = cljs.core.chunk_rest(seq__46727_47497__$1);
var G__47500 = c__4609__auto___47498;
var G__47501 = cljs.core.count(c__4609__auto___47498);
var G__47502 = (0);
seq__46727_47484 = G__47499;
chunk__46728_47485 = G__47500;
count__46729_47486 = G__47501;
i__46730_47487 = G__47502;
continue;
} else {
var param_47503 = cljs.core.first(seq__46727_47497__$1);
cljs.compiler.emit(param_47503);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_47503,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__47504 = cljs.core.next(seq__46727_47497__$1);
var G__47505 = null;
var G__47506 = (0);
var G__47507 = (0);
seq__46727_47484 = G__47504;
chunk__46728_47485 = G__47505;
count__46729_47486 = G__47506;
i__46730_47487 = G__47507;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47460,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_47460,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_47459__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47460,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_47461,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_47460,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__46734){
var map__46735 = p__46734;
var map__46735__$1 = (((((!((map__46735 == null))))?(((((map__46735.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46735.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46735):map__46735);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46735__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__46731_SHARP_){
var and__4174__auto__ = p1__46731_SHARP_;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__46731_SHARP_));
} else {
return and__4174__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4185__auto__ = in_loop;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_47510__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_47511 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_47510__$1);
var maxparams_47512 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_47513 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_47511),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_47514 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__46732_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__46732_SHARP_)));
}),cljs.core.seq(mmap_47513));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_47511," = null;");

var seq__46737_47515 = cljs.core.seq(ms_47514);
var chunk__46738_47516 = null;
var count__46739_47517 = (0);
var i__46740_47518 = (0);
while(true){
if((i__46740_47518 < count__46739_47517)){
var vec__46747_47519 = chunk__46738_47516.cljs$core$IIndexed$_nth$arity$2(null,i__46740_47518);
var n_47520 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46747_47519,(0),null);
var meth_47521 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46747_47519,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_47520," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47521))){
cljs.compiler.emit_variadic_fn_method(meth_47521);
} else {
cljs.compiler.emit_fn_method(meth_47521);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__47522 = seq__46737_47515;
var G__47523 = chunk__46738_47516;
var G__47524 = count__46739_47517;
var G__47525 = (i__46740_47518 + (1));
seq__46737_47515 = G__47522;
chunk__46738_47516 = G__47523;
count__46739_47517 = G__47524;
i__46740_47518 = G__47525;
continue;
} else {
var temp__5735__auto___47526 = cljs.core.seq(seq__46737_47515);
if(temp__5735__auto___47526){
var seq__46737_47527__$1 = temp__5735__auto___47526;
if(cljs.core.chunked_seq_QMARK_(seq__46737_47527__$1)){
var c__4609__auto___47528 = cljs.core.chunk_first(seq__46737_47527__$1);
var G__47529 = cljs.core.chunk_rest(seq__46737_47527__$1);
var G__47530 = c__4609__auto___47528;
var G__47531 = cljs.core.count(c__4609__auto___47528);
var G__47532 = (0);
seq__46737_47515 = G__47529;
chunk__46738_47516 = G__47530;
count__46739_47517 = G__47531;
i__46740_47518 = G__47532;
continue;
} else {
var vec__46750_47533 = cljs.core.first(seq__46737_47527__$1);
var n_47534 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46750_47533,(0),null);
var meth_47535 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46750_47533,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_47534," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47535))){
cljs.compiler.emit_variadic_fn_method(meth_47535);
} else {
cljs.compiler.emit_fn_method(meth_47535);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__47536 = cljs.core.next(seq__46737_47527__$1);
var G__47537 = null;
var G__47538 = (0);
var G__47539 = (0);
seq__46737_47515 = G__47536;
chunk__46738_47516 = G__47537;
count__46739_47517 = G__47538;
i__46740_47518 = G__47539;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47511," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_47512),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_47512)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_47512));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__46753_47540 = cljs.core.seq(ms_47514);
var chunk__46754_47541 = null;
var count__46755_47542 = (0);
var i__46756_47543 = (0);
while(true){
if((i__46756_47543 < count__46755_47542)){
var vec__46765_47544 = chunk__46754_47541.cljs$core$IIndexed$_nth$arity$2(null,i__46756_47543);
var n_47545 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46765_47544,(0),null);
var meth_47546 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46765_47544,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47546))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_47547 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_47547," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_47548 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_47547," = new cljs.core.IndexedSeq(",a_47548,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_47545,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_47512)),(((cljs.core.count(maxparams_47512) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_47547,");"], 0));
} else {
var pcnt_47549 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_47546));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_47549,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_47545,".call(this",(((pcnt_47549 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_47549,maxparams_47512)),null,(1),null)),(2),null))),");");
}


var G__47550 = seq__46753_47540;
var G__47551 = chunk__46754_47541;
var G__47552 = count__46755_47542;
var G__47553 = (i__46756_47543 + (1));
seq__46753_47540 = G__47550;
chunk__46754_47541 = G__47551;
count__46755_47542 = G__47552;
i__46756_47543 = G__47553;
continue;
} else {
var temp__5735__auto___47554 = cljs.core.seq(seq__46753_47540);
if(temp__5735__auto___47554){
var seq__46753_47555__$1 = temp__5735__auto___47554;
if(cljs.core.chunked_seq_QMARK_(seq__46753_47555__$1)){
var c__4609__auto___47556 = cljs.core.chunk_first(seq__46753_47555__$1);
var G__47557 = cljs.core.chunk_rest(seq__46753_47555__$1);
var G__47558 = c__4609__auto___47556;
var G__47559 = cljs.core.count(c__4609__auto___47556);
var G__47560 = (0);
seq__46753_47540 = G__47557;
chunk__46754_47541 = G__47558;
count__46755_47542 = G__47559;
i__46756_47543 = G__47560;
continue;
} else {
var vec__46768_47561 = cljs.core.first(seq__46753_47555__$1);
var n_47562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46768_47561,(0),null);
var meth_47563 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46768_47561,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47563))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_47564 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_47564," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_47565 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_47564," = new cljs.core.IndexedSeq(",a_47565,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_47562,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_47512)),(((cljs.core.count(maxparams_47512) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_47564,");"], 0));
} else {
var pcnt_47566 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_47563));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_47566,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_47562,".call(this",(((pcnt_47566 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_47566,maxparams_47512)),null,(1),null)),(2),null))),");");
}


var G__47567 = cljs.core.next(seq__46753_47555__$1);
var G__47568 = null;
var G__47569 = (0);
var G__47570 = (0);
seq__46753_47540 = G__47567;
chunk__46754_47541 = G__47568;
count__46755_47542 = G__47569;
i__46756_47543 = G__47570;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_47571 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_47514)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_47571,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47511,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47511,".cljs$lang$applyTo = ",cljs.core.some((function (p1__46733_SHARP_){
var vec__46771 = p1__46733_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46771,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46771,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_47514),".cljs$lang$applyTo;");
} else {
}

var seq__46774_47572 = cljs.core.seq(ms_47514);
var chunk__46775_47573 = null;
var count__46776_47574 = (0);
var i__46777_47575 = (0);
while(true){
if((i__46777_47575 < count__46776_47574)){
var vec__46788_47576 = chunk__46775_47573.cljs$core$IIndexed$_nth$arity$2(null,i__46777_47575);
var n_47577 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46788_47576,(0),null);
var meth_47578 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46788_47576,(1),null);
var c_47579 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_47578));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47578))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47511,".cljs$core$IFn$_invoke$arity$variadic = ",n_47577,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_47511,".cljs$core$IFn$_invoke$arity$",c_47579," = ",n_47577,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__47580 = seq__46774_47572;
var G__47581 = chunk__46775_47573;
var G__47582 = count__46776_47574;
var G__47583 = (i__46777_47575 + (1));
seq__46774_47572 = G__47580;
chunk__46775_47573 = G__47581;
count__46776_47574 = G__47582;
i__46777_47575 = G__47583;
continue;
} else {
var temp__5735__auto___47584 = cljs.core.seq(seq__46774_47572);
if(temp__5735__auto___47584){
var seq__46774_47585__$1 = temp__5735__auto___47584;
if(cljs.core.chunked_seq_QMARK_(seq__46774_47585__$1)){
var c__4609__auto___47586 = cljs.core.chunk_first(seq__46774_47585__$1);
var G__47587 = cljs.core.chunk_rest(seq__46774_47585__$1);
var G__47588 = c__4609__auto___47586;
var G__47589 = cljs.core.count(c__4609__auto___47586);
var G__47590 = (0);
seq__46774_47572 = G__47587;
chunk__46775_47573 = G__47588;
count__46776_47574 = G__47589;
i__46777_47575 = G__47590;
continue;
} else {
var vec__46791_47591 = cljs.core.first(seq__46774_47585__$1);
var n_47592 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46791_47591,(0),null);
var meth_47593 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46791_47591,(1),null);
var c_47594 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_47593));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_47593))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_47511,".cljs$core$IFn$_invoke$arity$variadic = ",n_47592,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_47511,".cljs$core$IFn$_invoke$arity$",c_47594," = ",n_47592,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__47595 = cljs.core.next(seq__46774_47585__$1);
var G__47596 = null;
var G__47597 = (0);
var G__47598 = (0);
seq__46774_47572 = G__47595;
chunk__46775_47573 = G__47596;
count__46776_47574 = G__47597;
i__46777_47575 = G__47598;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_47511,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__46794){
var map__46795 = p__46794;
var map__46795__$1 = (((((!((map__46795 == null))))?(((((map__46795.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46795.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46795):map__46795);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46795__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46795__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46795__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__46797_47599 = cljs.core.seq(statements);
var chunk__46798_47600 = null;
var count__46799_47601 = (0);
var i__46800_47602 = (0);
while(true){
if((i__46800_47602 < count__46799_47601)){
var s_47603 = chunk__46798_47600.cljs$core$IIndexed$_nth$arity$2(null,i__46800_47602);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_47603);


var G__47604 = seq__46797_47599;
var G__47605 = chunk__46798_47600;
var G__47606 = count__46799_47601;
var G__47607 = (i__46800_47602 + (1));
seq__46797_47599 = G__47604;
chunk__46798_47600 = G__47605;
count__46799_47601 = G__47606;
i__46800_47602 = G__47607;
continue;
} else {
var temp__5735__auto___47608 = cljs.core.seq(seq__46797_47599);
if(temp__5735__auto___47608){
var seq__46797_47609__$1 = temp__5735__auto___47608;
if(cljs.core.chunked_seq_QMARK_(seq__46797_47609__$1)){
var c__4609__auto___47610 = cljs.core.chunk_first(seq__46797_47609__$1);
var G__47611 = cljs.core.chunk_rest(seq__46797_47609__$1);
var G__47612 = c__4609__auto___47610;
var G__47613 = cljs.core.count(c__4609__auto___47610);
var G__47614 = (0);
seq__46797_47599 = G__47611;
chunk__46798_47600 = G__47612;
count__46799_47601 = G__47613;
i__46800_47602 = G__47614;
continue;
} else {
var s_47615 = cljs.core.first(seq__46797_47609__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_47615);


var G__47616 = cljs.core.next(seq__46797_47609__$1);
var G__47617 = null;
var G__47618 = (0);
var G__47619 = (0);
seq__46797_47599 = G__47616;
chunk__46798_47600 = G__47617;
count__46799_47601 = G__47618;
i__46800_47602 = G__47619;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__46801){
var map__46802 = p__46801;
var map__46802__$1 = (((((!((map__46802 == null))))?(((((map__46802.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46802.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46802):map__46802);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46802__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46802__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46802__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46802__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46802__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__46804,is_loop){
var map__46805 = p__46804;
var map__46805__$1 = (((((!((map__46805 == null))))?(((((map__46805.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46805.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46805):map__46805);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46805__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46805__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46805__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__46809_47628 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__46810_47629 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__46810_47629);

try{var seq__46811_47630 = cljs.core.seq(bindings);
var chunk__46812_47631 = null;
var count__46813_47632 = (0);
var i__46814_47633 = (0);
while(true){
if((i__46814_47633 < count__46813_47632)){
var map__46819_47634 = chunk__46812_47631.cljs$core$IIndexed$_nth$arity$2(null,i__46814_47633);
var map__46819_47635__$1 = (((((!((map__46819_47634 == null))))?(((((map__46819_47634.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46819_47634.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46819_47634):map__46819_47634);
var binding_47636 = map__46819_47635__$1;
var init_47637 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46819_47635__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_47636);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_47637,";");


var G__47638 = seq__46811_47630;
var G__47639 = chunk__46812_47631;
var G__47640 = count__46813_47632;
var G__47641 = (i__46814_47633 + (1));
seq__46811_47630 = G__47638;
chunk__46812_47631 = G__47639;
count__46813_47632 = G__47640;
i__46814_47633 = G__47641;
continue;
} else {
var temp__5735__auto___47642 = cljs.core.seq(seq__46811_47630);
if(temp__5735__auto___47642){
var seq__46811_47643__$1 = temp__5735__auto___47642;
if(cljs.core.chunked_seq_QMARK_(seq__46811_47643__$1)){
var c__4609__auto___47644 = cljs.core.chunk_first(seq__46811_47643__$1);
var G__47645 = cljs.core.chunk_rest(seq__46811_47643__$1);
var G__47646 = c__4609__auto___47644;
var G__47647 = cljs.core.count(c__4609__auto___47644);
var G__47648 = (0);
seq__46811_47630 = G__47645;
chunk__46812_47631 = G__47646;
count__46813_47632 = G__47647;
i__46814_47633 = G__47648;
continue;
} else {
var map__46821_47649 = cljs.core.first(seq__46811_47643__$1);
var map__46821_47650__$1 = (((((!((map__46821_47649 == null))))?(((((map__46821_47649.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46821_47649.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46821_47649):map__46821_47649);
var binding_47651 = map__46821_47650__$1;
var init_47652 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46821_47650__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_47651);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_47652,";");


var G__47655 = cljs.core.next(seq__46811_47643__$1);
var G__47656 = null;
var G__47657 = (0);
var G__47658 = (0);
seq__46811_47630 = G__47655;
chunk__46812_47631 = G__47656;
count__46813_47632 = G__47657;
i__46814_47633 = G__47658;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__46809_47628);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__46823){
var map__46824 = p__46823;
var map__46824__$1 = (((((!((map__46824 == null))))?(((((map__46824.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46824.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46824):map__46824);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46824__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46824__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46824__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4666__auto___47659 = cljs.core.count(exprs);
var i_47660 = (0);
while(true){
if((i_47660 < n__4666__auto___47659)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_47660) : temps.call(null,i_47660))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_47660) : exprs.call(null,i_47660)),";");

var G__47661 = (i_47660 + (1));
i_47660 = G__47661;
continue;
} else {
}
break;
}

var n__4666__auto___47662 = cljs.core.count(exprs);
var i_47663 = (0);
while(true){
if((i_47663 < n__4666__auto___47662)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_47663) : params.call(null,i_47663)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_47663) : temps.call(null,i_47663)),";");

var G__47664 = (i_47663 + (1));
i_47663 = G__47664;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__46826){
var map__46827 = p__46826;
var map__46827__$1 = (((((!((map__46827 == null))))?(((((map__46827.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46827.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46827):map__46827);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46827__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46827__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46827__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__46829_47665 = cljs.core.seq(bindings);
var chunk__46830_47666 = null;
var count__46831_47667 = (0);
var i__46832_47668 = (0);
while(true){
if((i__46832_47668 < count__46831_47667)){
var map__46837_47669 = chunk__46830_47666.cljs$core$IIndexed$_nth$arity$2(null,i__46832_47668);
var map__46837_47670__$1 = (((((!((map__46837_47669 == null))))?(((((map__46837_47669.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46837_47669.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46837_47669):map__46837_47669);
var binding_47671 = map__46837_47670__$1;
var init_47672 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46837_47670__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_47671)," = ",init_47672,";");


var G__47673 = seq__46829_47665;
var G__47674 = chunk__46830_47666;
var G__47675 = count__46831_47667;
var G__47676 = (i__46832_47668 + (1));
seq__46829_47665 = G__47673;
chunk__46830_47666 = G__47674;
count__46831_47667 = G__47675;
i__46832_47668 = G__47676;
continue;
} else {
var temp__5735__auto___47677 = cljs.core.seq(seq__46829_47665);
if(temp__5735__auto___47677){
var seq__46829_47678__$1 = temp__5735__auto___47677;
if(cljs.core.chunked_seq_QMARK_(seq__46829_47678__$1)){
var c__4609__auto___47679 = cljs.core.chunk_first(seq__46829_47678__$1);
var G__47681 = cljs.core.chunk_rest(seq__46829_47678__$1);
var G__47682 = c__4609__auto___47679;
var G__47683 = cljs.core.count(c__4609__auto___47679);
var G__47684 = (0);
seq__46829_47665 = G__47681;
chunk__46830_47666 = G__47682;
count__46831_47667 = G__47683;
i__46832_47668 = G__47684;
continue;
} else {
var map__46839_47685 = cljs.core.first(seq__46829_47678__$1);
var map__46839_47686__$1 = (((((!((map__46839_47685 == null))))?(((((map__46839_47685.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46839_47685.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46839_47685):map__46839_47685);
var binding_47687 = map__46839_47686__$1;
var init_47688 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46839_47686__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_47687)," = ",init_47688,";");


var G__47689 = cljs.core.next(seq__46829_47678__$1);
var G__47690 = null;
var G__47691 = (0);
var G__47692 = (0);
seq__46829_47665 = G__47689;
chunk__46830_47666 = G__47690;
count__46831_47667 = G__47691;
i__46832_47668 = G__47692;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__46843){
var map__46844 = p__46843;
var map__46844__$1 = (((((!((map__46844 == null))))?(((((map__46844.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46844.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46844):map__46844);
var expr = map__46844__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46844__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46844__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46844__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
if(cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4174__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4174__auto__ = protocol;
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = tag;
if(cljs.core.truth_(and__4174__auto____$1)){
var or__4185__auto__ = (function (){var and__4174__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto____$2)){
var and__4174__auto____$3 = protocol;
if(cljs.core.truth_(and__4174__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4174__auto____$3;
}
} else {
return and__4174__auto____$2;
}
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var and__4174__auto____$2 = (function (){var or__4185__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4174__auto____$2)){
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__46856 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__46856.cljs$core$IFn$_invoke$arity$1 ? fexpr__46856.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__46856.call(null,tag));
})())){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4174__auto____$2;
}
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__46858 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__46858.cljs$core$IFn$_invoke$arity$1 ? fexpr__46858.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__46858.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4185__auto__){
return or__4185__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__46846 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4174__auto__)){
return (arity > mfa);
} else {
return and__4174__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__46841_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__46841_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__46842_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__46842_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46846,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46846,(1),null);
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_47693 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_47693,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_47694 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_47694,args)),(((mfa_47694 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_47694,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
var G__46860 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__46859 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__46859.cljs$core$IFn$_invoke$arity$1 ? fexpr__46859.cljs$core$IFn$_invoke$arity$1(G__46860) : fexpr__46859.call(null,G__46860));
} else {
return and__4174__auto__;
}
})())){
var fprop_47695 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_47695," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_47695,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_47695," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_47695,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__46861){
var map__46862 = p__46861;
var map__46862__$1 = (((((!((map__46862 == null))))?(((((map__46862.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46862.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46862):map__46862);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46862__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46862__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46862__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__46867){
var map__46868 = p__46867;
var map__46868__$1 = (((((!((map__46868 == null))))?(((((map__46868.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46868.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46868):map__46868);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46868__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46868__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46868__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__46870 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__46870__$1 = (((((!((map__46870 == null))))?(((((map__46870.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46870.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46870):map__46870);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46870__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46870__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__46871 = options;
var map__46871__$1 = (((((!((map__46871 == null))))?(((((map__46871.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46871.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46871):map__46871);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46871__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46871__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__46872 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__46877 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__46877__$1 = (((((!((map__46877 == null))))?(((((map__46877.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46877.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46877):map__46877);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46877__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46877__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46872,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46872,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__46879_47697 = cljs.core.seq(libs_to_load);
var chunk__46880_47698 = null;
var count__46881_47699 = (0);
var i__46882_47700 = (0);
while(true){
if((i__46882_47700 < count__46881_47699)){
var lib_47701 = chunk__46880_47698.cljs$core$IIndexed$_nth$arity$2(null,i__46882_47700);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_47701)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_47701),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47701),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_47701),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47701),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_47701,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47701),"');");
}

}
}
}


var G__47702 = seq__46879_47697;
var G__47703 = chunk__46880_47698;
var G__47704 = count__46881_47699;
var G__47705 = (i__46882_47700 + (1));
seq__46879_47697 = G__47702;
chunk__46880_47698 = G__47703;
count__46881_47699 = G__47704;
i__46882_47700 = G__47705;
continue;
} else {
var temp__5735__auto___47706 = cljs.core.seq(seq__46879_47697);
if(temp__5735__auto___47706){
var seq__46879_47707__$1 = temp__5735__auto___47706;
if(cljs.core.chunked_seq_QMARK_(seq__46879_47707__$1)){
var c__4609__auto___47708 = cljs.core.chunk_first(seq__46879_47707__$1);
var G__47709 = cljs.core.chunk_rest(seq__46879_47707__$1);
var G__47710 = c__4609__auto___47708;
var G__47711 = cljs.core.count(c__4609__auto___47708);
var G__47712 = (0);
seq__46879_47697 = G__47709;
chunk__46880_47698 = G__47710;
count__46881_47699 = G__47711;
i__46882_47700 = G__47712;
continue;
} else {
var lib_47713 = cljs.core.first(seq__46879_47707__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_47713)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_47713),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47713),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_47713),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47713),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_47713,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_47713),"');");
}

}
}
}


var G__47715 = cljs.core.next(seq__46879_47707__$1);
var G__47716 = null;
var G__47717 = (0);
var G__47718 = (0);
seq__46879_47697 = G__47715;
chunk__46880_47698 = G__47716;
count__46881_47699 = G__47717;
i__46882_47700 = G__47718;
continue;
}
} else {
}
}
break;
}

var seq__46883_47719 = cljs.core.seq(node_libs);
var chunk__46884_47720 = null;
var count__46885_47721 = (0);
var i__46886_47722 = (0);
while(true){
if((i__46886_47722 < count__46885_47721)){
var lib_47723 = chunk__46884_47720.cljs$core$IIndexed$_nth$arity$2(null,i__46886_47722);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_47723)," = require('",lib_47723,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__47724 = seq__46883_47719;
var G__47725 = chunk__46884_47720;
var G__47726 = count__46885_47721;
var G__47727 = (i__46886_47722 + (1));
seq__46883_47719 = G__47724;
chunk__46884_47720 = G__47725;
count__46885_47721 = G__47726;
i__46886_47722 = G__47727;
continue;
} else {
var temp__5735__auto___47728 = cljs.core.seq(seq__46883_47719);
if(temp__5735__auto___47728){
var seq__46883_47729__$1 = temp__5735__auto___47728;
if(cljs.core.chunked_seq_QMARK_(seq__46883_47729__$1)){
var c__4609__auto___47730 = cljs.core.chunk_first(seq__46883_47729__$1);
var G__47731 = cljs.core.chunk_rest(seq__46883_47729__$1);
var G__47732 = c__4609__auto___47730;
var G__47733 = cljs.core.count(c__4609__auto___47730);
var G__47734 = (0);
seq__46883_47719 = G__47731;
chunk__46884_47720 = G__47732;
count__46885_47721 = G__47733;
i__46886_47722 = G__47734;
continue;
} else {
var lib_47735 = cljs.core.first(seq__46883_47729__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_47735)," = require('",lib_47735,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__47736 = cljs.core.next(seq__46883_47729__$1);
var G__47737 = null;
var G__47738 = (0);
var G__47739 = (0);
seq__46883_47719 = G__47736;
chunk__46884_47720 = G__47737;
count__46885_47721 = G__47738;
i__46886_47722 = G__47739;
continue;
}
} else {
}
}
break;
}

var seq__46887_47740 = cljs.core.seq(global_exports_libs);
var chunk__46888_47741 = null;
var count__46889_47742 = (0);
var i__46890_47743 = (0);
while(true){
if((i__46890_47743 < count__46889_47742)){
var lib_47744 = chunk__46888_47741.cljs$core$IIndexed$_nth$arity$2(null,i__46890_47743);
var map__46895_47745 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_47744));
var map__46895_47746__$1 = (((((!((map__46895_47745 == null))))?(((((map__46895_47745.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46895_47745.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46895_47745):map__46895_47745);
var global_exports_47747 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46895_47746__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_47747,lib_47744);


var G__47748 = seq__46887_47740;
var G__47749 = chunk__46888_47741;
var G__47750 = count__46889_47742;
var G__47751 = (i__46890_47743 + (1));
seq__46887_47740 = G__47748;
chunk__46888_47741 = G__47749;
count__46889_47742 = G__47750;
i__46890_47743 = G__47751;
continue;
} else {
var temp__5735__auto___47752 = cljs.core.seq(seq__46887_47740);
if(temp__5735__auto___47752){
var seq__46887_47753__$1 = temp__5735__auto___47752;
if(cljs.core.chunked_seq_QMARK_(seq__46887_47753__$1)){
var c__4609__auto___47754 = cljs.core.chunk_first(seq__46887_47753__$1);
var G__47755 = cljs.core.chunk_rest(seq__46887_47753__$1);
var G__47756 = c__4609__auto___47754;
var G__47757 = cljs.core.count(c__4609__auto___47754);
var G__47758 = (0);
seq__46887_47740 = G__47755;
chunk__46888_47741 = G__47756;
count__46889_47742 = G__47757;
i__46890_47743 = G__47758;
continue;
} else {
var lib_47759 = cljs.core.first(seq__46887_47753__$1);
var map__46897_47760 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_47759));
var map__46897_47761__$1 = (((((!((map__46897_47760 == null))))?(((((map__46897_47760.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46897_47760.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46897_47760):map__46897_47760);
var global_exports_47762 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46897_47761__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_47762,lib_47759);


var G__47763 = cljs.core.next(seq__46887_47753__$1);
var G__47764 = null;
var G__47765 = (0);
var G__47766 = (0);
seq__46887_47740 = G__47763;
chunk__46888_47741 = G__47764;
count__46889_47742 = G__47765;
i__46890_47743 = G__47766;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__46899){
var map__46900 = p__46899;
var map__46900__$1 = (((((!((map__46900 == null))))?(((((map__46900.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46900.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46900):map__46900);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46900__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46900__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46900__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46900__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46900__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46900__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46900__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__46902){
var map__46903 = p__46902;
var map__46903__$1 = (((((!((map__46903 == null))))?(((((map__46903.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46903.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46903):map__46903);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46903__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46903__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46903__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46903__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46903__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46903__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46903__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__46905){
var map__46906 = p__46905;
var map__46906__$1 = (((((!((map__46906 == null))))?(((((map__46906.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46906.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46906):map__46906);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46906__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46906__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46906__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46906__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46906__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__46908_47767 = cljs.core.seq(protocols);
var chunk__46909_47768 = null;
var count__46910_47769 = (0);
var i__46911_47770 = (0);
while(true){
if((i__46911_47770 < count__46910_47769)){
var protocol_47771 = chunk__46909_47768.cljs$core$IIndexed$_nth$arity$2(null,i__46911_47770);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_47771)),"}");


var G__47772 = seq__46908_47767;
var G__47773 = chunk__46909_47768;
var G__47774 = count__46910_47769;
var G__47775 = (i__46911_47770 + (1));
seq__46908_47767 = G__47772;
chunk__46909_47768 = G__47773;
count__46910_47769 = G__47774;
i__46911_47770 = G__47775;
continue;
} else {
var temp__5735__auto___47776 = cljs.core.seq(seq__46908_47767);
if(temp__5735__auto___47776){
var seq__46908_47777__$1 = temp__5735__auto___47776;
if(cljs.core.chunked_seq_QMARK_(seq__46908_47777__$1)){
var c__4609__auto___47778 = cljs.core.chunk_first(seq__46908_47777__$1);
var G__47779 = cljs.core.chunk_rest(seq__46908_47777__$1);
var G__47780 = c__4609__auto___47778;
var G__47781 = cljs.core.count(c__4609__auto___47778);
var G__47782 = (0);
seq__46908_47767 = G__47779;
chunk__46909_47768 = G__47780;
count__46910_47769 = G__47781;
i__46911_47770 = G__47782;
continue;
} else {
var protocol_47783 = cljs.core.first(seq__46908_47777__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_47783)),"}");


var G__47784 = cljs.core.next(seq__46908_47777__$1);
var G__47785 = null;
var G__47786 = (0);
var G__47787 = (0);
seq__46908_47767 = G__47784;
chunk__46909_47768 = G__47785;
count__46910_47769 = G__47786;
i__46911_47770 = G__47787;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__46915_47788 = cljs.core.seq(fields__$1);
var chunk__46916_47789 = null;
var count__46917_47790 = (0);
var i__46918_47791 = (0);
while(true){
if((i__46918_47791 < count__46917_47790)){
var fld_47792 = chunk__46916_47789.cljs$core$IIndexed$_nth$arity$2(null,i__46918_47791);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_47792," = ",fld_47792,";");


var G__47793 = seq__46915_47788;
var G__47794 = chunk__46916_47789;
var G__47795 = count__46917_47790;
var G__47796 = (i__46918_47791 + (1));
seq__46915_47788 = G__47793;
chunk__46916_47789 = G__47794;
count__46917_47790 = G__47795;
i__46918_47791 = G__47796;
continue;
} else {
var temp__5735__auto___47797 = cljs.core.seq(seq__46915_47788);
if(temp__5735__auto___47797){
var seq__46915_47798__$1 = temp__5735__auto___47797;
if(cljs.core.chunked_seq_QMARK_(seq__46915_47798__$1)){
var c__4609__auto___47799 = cljs.core.chunk_first(seq__46915_47798__$1);
var G__47800 = cljs.core.chunk_rest(seq__46915_47798__$1);
var G__47801 = c__4609__auto___47799;
var G__47802 = cljs.core.count(c__4609__auto___47799);
var G__47803 = (0);
seq__46915_47788 = G__47800;
chunk__46916_47789 = G__47801;
count__46917_47790 = G__47802;
i__46918_47791 = G__47803;
continue;
} else {
var fld_47804 = cljs.core.first(seq__46915_47798__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_47804," = ",fld_47804,";");


var G__47805 = cljs.core.next(seq__46915_47798__$1);
var G__47806 = null;
var G__47807 = (0);
var G__47808 = (0);
seq__46915_47788 = G__47805;
chunk__46916_47789 = G__47806;
count__46917_47790 = G__47807;
i__46918_47791 = G__47808;
continue;
}
} else {
}
}
break;
}

var seq__46919_47809 = cljs.core.seq(pmasks);
var chunk__46920_47810 = null;
var count__46921_47811 = (0);
var i__46922_47812 = (0);
while(true){
if((i__46922_47812 < count__46921_47811)){
var vec__46929_47813 = chunk__46920_47810.cljs$core$IIndexed$_nth$arity$2(null,i__46922_47812);
var pno_47814 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46929_47813,(0),null);
var pmask_47815 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46929_47813,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_47814,"$ = ",pmask_47815,";");


var G__47816 = seq__46919_47809;
var G__47817 = chunk__46920_47810;
var G__47818 = count__46921_47811;
var G__47819 = (i__46922_47812 + (1));
seq__46919_47809 = G__47816;
chunk__46920_47810 = G__47817;
count__46921_47811 = G__47818;
i__46922_47812 = G__47819;
continue;
} else {
var temp__5735__auto___47820 = cljs.core.seq(seq__46919_47809);
if(temp__5735__auto___47820){
var seq__46919_47821__$1 = temp__5735__auto___47820;
if(cljs.core.chunked_seq_QMARK_(seq__46919_47821__$1)){
var c__4609__auto___47822 = cljs.core.chunk_first(seq__46919_47821__$1);
var G__47823 = cljs.core.chunk_rest(seq__46919_47821__$1);
var G__47824 = c__4609__auto___47822;
var G__47825 = cljs.core.count(c__4609__auto___47822);
var G__47826 = (0);
seq__46919_47809 = G__47823;
chunk__46920_47810 = G__47824;
count__46921_47811 = G__47825;
i__46922_47812 = G__47826;
continue;
} else {
var vec__46932_47827 = cljs.core.first(seq__46919_47821__$1);
var pno_47828 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46932_47827,(0),null);
var pmask_47829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46932_47827,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_47828,"$ = ",pmask_47829,";");


var G__47830 = cljs.core.next(seq__46919_47821__$1);
var G__47831 = null;
var G__47832 = (0);
var G__47833 = (0);
seq__46919_47809 = G__47830;
chunk__46920_47810 = G__47831;
count__46921_47811 = G__47832;
i__46922_47812 = G__47833;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__46935){
var map__46936 = p__46935;
var map__46936__$1 = (((((!((map__46936 == null))))?(((((map__46936.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46936.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46936):map__46936);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46936__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46936__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46936__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46936__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46936__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__46938_47834 = cljs.core.seq(protocols);
var chunk__46939_47835 = null;
var count__46940_47836 = (0);
var i__46941_47837 = (0);
while(true){
if((i__46941_47837 < count__46940_47836)){
var protocol_47838 = chunk__46939_47835.cljs$core$IIndexed$_nth$arity$2(null,i__46941_47837);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_47838)),"}");


var G__47839 = seq__46938_47834;
var G__47840 = chunk__46939_47835;
var G__47841 = count__46940_47836;
var G__47842 = (i__46941_47837 + (1));
seq__46938_47834 = G__47839;
chunk__46939_47835 = G__47840;
count__46940_47836 = G__47841;
i__46941_47837 = G__47842;
continue;
} else {
var temp__5735__auto___47843 = cljs.core.seq(seq__46938_47834);
if(temp__5735__auto___47843){
var seq__46938_47844__$1 = temp__5735__auto___47843;
if(cljs.core.chunked_seq_QMARK_(seq__46938_47844__$1)){
var c__4609__auto___47845 = cljs.core.chunk_first(seq__46938_47844__$1);
var G__47846 = cljs.core.chunk_rest(seq__46938_47844__$1);
var G__47847 = c__4609__auto___47845;
var G__47848 = cljs.core.count(c__4609__auto___47845);
var G__47849 = (0);
seq__46938_47834 = G__47846;
chunk__46939_47835 = G__47847;
count__46940_47836 = G__47848;
i__46941_47837 = G__47849;
continue;
} else {
var protocol_47850 = cljs.core.first(seq__46938_47844__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_47850)),"}");


var G__47851 = cljs.core.next(seq__46938_47844__$1);
var G__47852 = null;
var G__47853 = (0);
var G__47854 = (0);
seq__46938_47834 = G__47851;
chunk__46939_47835 = G__47852;
count__46940_47836 = G__47853;
i__46941_47837 = G__47854;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__46946_47855 = cljs.core.seq(fields__$1);
var chunk__46947_47856 = null;
var count__46948_47857 = (0);
var i__46949_47858 = (0);
while(true){
if((i__46949_47858 < count__46948_47857)){
var fld_47860 = chunk__46947_47856.cljs$core$IIndexed$_nth$arity$2(null,i__46949_47858);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_47860," = ",fld_47860,";");


var G__47867 = seq__46946_47855;
var G__47868 = chunk__46947_47856;
var G__47869 = count__46948_47857;
var G__47870 = (i__46949_47858 + (1));
seq__46946_47855 = G__47867;
chunk__46947_47856 = G__47868;
count__46948_47857 = G__47869;
i__46949_47858 = G__47870;
continue;
} else {
var temp__5735__auto___47871 = cljs.core.seq(seq__46946_47855);
if(temp__5735__auto___47871){
var seq__46946_47872__$1 = temp__5735__auto___47871;
if(cljs.core.chunked_seq_QMARK_(seq__46946_47872__$1)){
var c__4609__auto___47873 = cljs.core.chunk_first(seq__46946_47872__$1);
var G__47874 = cljs.core.chunk_rest(seq__46946_47872__$1);
var G__47875 = c__4609__auto___47873;
var G__47876 = cljs.core.count(c__4609__auto___47873);
var G__47877 = (0);
seq__46946_47855 = G__47874;
chunk__46947_47856 = G__47875;
count__46948_47857 = G__47876;
i__46949_47858 = G__47877;
continue;
} else {
var fld_47879 = cljs.core.first(seq__46946_47872__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_47879," = ",fld_47879,";");


var G__47880 = cljs.core.next(seq__46946_47872__$1);
var G__47881 = null;
var G__47882 = (0);
var G__47883 = (0);
seq__46946_47855 = G__47880;
chunk__46947_47856 = G__47881;
count__46948_47857 = G__47882;
i__46949_47858 = G__47883;
continue;
}
} else {
}
}
break;
}

var seq__46950_47884 = cljs.core.seq(pmasks);
var chunk__46951_47885 = null;
var count__46952_47886 = (0);
var i__46953_47887 = (0);
while(true){
if((i__46953_47887 < count__46952_47886)){
var vec__46960_47888 = chunk__46951_47885.cljs$core$IIndexed$_nth$arity$2(null,i__46953_47887);
var pno_47889 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46960_47888,(0),null);
var pmask_47890 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46960_47888,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_47889,"$ = ",pmask_47890,";");


var G__47891 = seq__46950_47884;
var G__47892 = chunk__46951_47885;
var G__47893 = count__46952_47886;
var G__47894 = (i__46953_47887 + (1));
seq__46950_47884 = G__47891;
chunk__46951_47885 = G__47892;
count__46952_47886 = G__47893;
i__46953_47887 = G__47894;
continue;
} else {
var temp__5735__auto___47895 = cljs.core.seq(seq__46950_47884);
if(temp__5735__auto___47895){
var seq__46950_47896__$1 = temp__5735__auto___47895;
if(cljs.core.chunked_seq_QMARK_(seq__46950_47896__$1)){
var c__4609__auto___47897 = cljs.core.chunk_first(seq__46950_47896__$1);
var G__47898 = cljs.core.chunk_rest(seq__46950_47896__$1);
var G__47899 = c__4609__auto___47897;
var G__47900 = cljs.core.count(c__4609__auto___47897);
var G__47901 = (0);
seq__46950_47884 = G__47898;
chunk__46951_47885 = G__47899;
count__46952_47886 = G__47900;
i__46953_47887 = G__47901;
continue;
} else {
var vec__46963_47902 = cljs.core.first(seq__46950_47896__$1);
var pno_47903 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46963_47902,(0),null);
var pmask_47904 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46963_47902,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_47903,"$ = ",pmask_47904,";");


var G__47905 = cljs.core.next(seq__46950_47896__$1);
var G__47906 = null;
var G__47907 = (0);
var G__47908 = (0);
seq__46950_47884 = G__47905;
chunk__46951_47885 = G__47906;
count__46952_47886 = G__47907;
i__46953_47887 = G__47908;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__46966){
var map__46967 = p__46966;
var map__46967__$1 = (((((!((map__46967 == null))))?(((((map__46967.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46967.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46967):map__46967);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46967__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46967__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46967__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46967__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46967__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__46969){
var map__46970 = p__46969;
var map__46970__$1 = (((((!((map__46970 == null))))?(((((map__46970.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46970.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46970):map__46970);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46970__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46970__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46970__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46970__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46970__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4174__auto__ = code;
if(cljs.core.truth_(and__4174__auto__)){
var G__46972 = clojure.string.trim(code);
var G__46973 = "/*";
return goog.string.startsWith(G__46972,G__46973);
} else {
return and__4174__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__46352__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__46352__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__46978 = cljs.core.seq(table);
var chunk__46979 = null;
var count__46980 = (0);
var i__46981 = (0);
while(true){
if((i__46981 < count__46980)){
var vec__46988 = chunk__46979.cljs$core$IIndexed$_nth$arity$2(null,i__46981);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46988,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46988,(1),null);
var ns_47910 = cljs.core.namespace(sym);
var name_47911 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__47912 = seq__46978;
var G__47913 = chunk__46979;
var G__47914 = count__46980;
var G__47915 = (i__46981 + (1));
seq__46978 = G__47912;
chunk__46979 = G__47913;
count__46980 = G__47914;
i__46981 = G__47915;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46978);
if(temp__5735__auto__){
var seq__46978__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46978__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__46978__$1);
var G__47918 = cljs.core.chunk_rest(seq__46978__$1);
var G__47919 = c__4609__auto__;
var G__47920 = cljs.core.count(c__4609__auto__);
var G__47921 = (0);
seq__46978 = G__47918;
chunk__46979 = G__47919;
count__46980 = G__47920;
i__46981 = G__47921;
continue;
} else {
var vec__46991 = cljs.core.first(seq__46978__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46991,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46991,(1),null);
var ns_47922 = cljs.core.namespace(sym);
var name_47923 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__47924 = cljs.core.next(seq__46978__$1);
var G__47925 = null;
var G__47926 = (0);
var G__47927 = (0);
seq__46978 = G__47924;
chunk__46979 = G__47925;
count__46980 = G__47926;
i__46981 = G__47927;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__46996 = arguments.length;
switch (G__46996) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_47929 = cljs.core.first(ks);
var vec__46997_47930 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_47929);
var top_47931 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46997_47930,(0),null);
var prefix_SINGLEQUOTE__47932 = vec__46997_47930;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_47929)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__47932) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_47931)) || (cljs.core.contains_QMARK_(known_externs,top_47931)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__47932)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_47931);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__47932)),";");
}
} else {
}

var m_47935 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_47929);
if(cljs.core.empty_QMARK_(m_47935)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__47932,m_47935,top_level,known_externs);
}

var G__47936 = cljs.core.next(ks);
ks = G__47936;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=cljs.compiler.js.map
