goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__44614){
var vec__44616 = p__44614;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44616,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44616,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__44623 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44623,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44623,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44623,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44623,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44623,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__44634 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44634,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44634,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44634,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44634,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44634,(4),null);
var vec__44637 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44637,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44637,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44637,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44637,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44637,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__44642 = segmap;
var map__44642__$1 = (((((!((map__44642 == null))))?(((((map__44642.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44642.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44642):map__44642);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44642__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44642__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44642__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44642__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44642__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__44653 = arguments.length;
switch (G__44653) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44664 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45749 = cljs.core.next(segs__$1);
var G__45750 = nrelseg;
var G__45751 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45749;
relseg__$1 = G__45750;
result__$1 = G__45751;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44664,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44664,(1),null);
var G__45752 = (gline + (1));
var G__45753 = cljs.core.next(lines__$1);
var G__45754 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45755 = result__$1;
gline = G__45752;
lines__$1 = G__45753;
relseg = G__45754;
result = G__45755;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__44670 = segmap;
var map__44670__$1 = (((((!((map__44670 == null))))?(((((map__44670.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44670.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44670):map__44670);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44670__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44670__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44670__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44670__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44670__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__44669_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__44669_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__44679 = arguments.length;
switch (G__44679) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44695 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45762 = cljs.core.next(segs__$1);
var G__45763 = nrelseg;
var G__45764 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45762;
relseg__$1 = G__45763;
result__$1 = G__45764;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44695,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44695,(1),null);
var G__45767 = (gline + (1));
var G__45768 = cljs.core.next(lines__$1);
var G__45769 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45770 = result__$1;
gline = G__45767;
lines__$1 = G__45768;
relseg = G__45769;
result = G__45770;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44700){
var vec__44701 = p__44700;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44701,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44701,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44701,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44701,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44701,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__44704){
var vec__44705 = p__44704;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44705,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44705,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44705,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44705,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44705,(4),null);
var seg = vec__44705;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44709){
var vec__44710 = p__44709;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44710,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44710,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44710,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44710,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44710,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__44729 = cljs.core.seq(infos);
var chunk__44730 = null;
var count__44731 = (0);
var i__44732 = (0);
while(true){
if((i__44732 < count__44731)){
var info = chunk__44730.cljs$core$IIndexed$_nth$arity$2(null,i__44732);
var segv_45792 = info__GT_segv(info,source_idx,line,col);
var gline_45793 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45794 = cljs.core.count(cljs.core.deref(lines));
if((gline_45793 > (lc_45794 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44729,chunk__44730,count__44731,i__44732,segv_45792,gline_45793,lc_45794,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45793 - (lc_45794 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45792], null));
});})(seq__44729,chunk__44730,count__44731,i__44732,segv_45792,gline_45793,lc_45794,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44729,chunk__44730,count__44731,i__44732,segv_45792,gline_45793,lc_45794,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45793], null),cljs.core.conj,segv_45792);
});})(seq__44729,chunk__44730,count__44731,i__44732,segv_45792,gline_45793,lc_45794,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45797 = seq__44729;
var G__45798 = chunk__44730;
var G__45799 = count__44731;
var G__45800 = (i__44732 + (1));
seq__44729 = G__45797;
chunk__44730 = G__45798;
count__44731 = G__45799;
i__44732 = G__45800;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__44729);
if(temp__5735__auto__){
var seq__44729__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44729__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__44729__$1);
var G__45803 = cljs.core.chunk_rest(seq__44729__$1);
var G__45804 = c__4609__auto__;
var G__45805 = cljs.core.count(c__4609__auto__);
var G__45806 = (0);
seq__44729 = G__45803;
chunk__44730 = G__45804;
count__44731 = G__45805;
i__44732 = G__45806;
continue;
} else {
var info = cljs.core.first(seq__44729__$1);
var segv_45807 = info__GT_segv(info,source_idx,line,col);
var gline_45808 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45809 = cljs.core.count(cljs.core.deref(lines));
if((gline_45808 > (lc_45809 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44729,chunk__44730,count__44731,i__44732,segv_45807,gline_45808,lc_45809,info,seq__44729__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45808 - (lc_45809 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45807], null));
});})(seq__44729,chunk__44730,count__44731,i__44732,segv_45807,gline_45808,lc_45809,info,seq__44729__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44729,chunk__44730,count__44731,i__44732,segv_45807,gline_45808,lc_45809,info,seq__44729__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45808], null),cljs.core.conj,segv_45807);
});})(seq__44729,chunk__44730,count__44731,i__44732,segv_45807,gline_45808,lc_45809,info,seq__44729__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45814 = cljs.core.next(seq__44729__$1);
var G__45815 = null;
var G__45816 = (0);
var G__45817 = (0);
seq__44729 = G__45814;
chunk__44730 = G__45815;
count__44731 = G__45816;
i__44732 = G__45817;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__44748_45818 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__44749_45819 = null;
var count__44750_45820 = (0);
var i__44751_45821 = (0);
while(true){
if((i__44751_45821 < count__44750_45820)){
var vec__44961_45822 = chunk__44749_45819.cljs$core$IIndexed$_nth$arity$2(null,i__44751_45821);
var source_idx_45823 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44961_45822,(0),null);
var vec__44964_45824 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44961_45822,(1),null);
var __45825 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44964_45824,(0),null);
var lines_45826__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44964_45824,(1),null);
var seq__44967_45828 = cljs.core.seq(lines_45826__$1);
var chunk__44968_45829 = null;
var count__44969_45830 = (0);
var i__44970_45831 = (0);
while(true){
if((i__44970_45831 < count__44969_45830)){
var vec__45038_45832 = chunk__44968_45829.cljs$core$IIndexed$_nth$arity$2(null,i__44970_45831);
var line_45833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45038_45832,(0),null);
var cols_45834 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45038_45832,(1),null);
var seq__45041_45835 = cljs.core.seq(cols_45834);
var chunk__45042_45836 = null;
var count__45043_45837 = (0);
var i__45044_45838 = (0);
while(true){
if((i__45044_45838 < count__45043_45837)){
var vec__45061_45839 = chunk__45042_45836.cljs$core$IIndexed$_nth$arity$2(null,i__45044_45838);
var col_45840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45061_45839,(0),null);
var infos_45841 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45061_45839,(1),null);
encode_cols(infos_45841,source_idx_45823,line_45833,col_45840);


var G__45843 = seq__45041_45835;
var G__45844 = chunk__45042_45836;
var G__45845 = count__45043_45837;
var G__45846 = (i__45044_45838 + (1));
seq__45041_45835 = G__45843;
chunk__45042_45836 = G__45844;
count__45043_45837 = G__45845;
i__45044_45838 = G__45846;
continue;
} else {
var temp__5735__auto___45848 = cljs.core.seq(seq__45041_45835);
if(temp__5735__auto___45848){
var seq__45041_45850__$1 = temp__5735__auto___45848;
if(cljs.core.chunked_seq_QMARK_(seq__45041_45850__$1)){
var c__4609__auto___45851 = cljs.core.chunk_first(seq__45041_45850__$1);
var G__45852 = cljs.core.chunk_rest(seq__45041_45850__$1);
var G__45853 = c__4609__auto___45851;
var G__45854 = cljs.core.count(c__4609__auto___45851);
var G__45855 = (0);
seq__45041_45835 = G__45852;
chunk__45042_45836 = G__45853;
count__45043_45837 = G__45854;
i__45044_45838 = G__45855;
continue;
} else {
var vec__45067_45856 = cljs.core.first(seq__45041_45850__$1);
var col_45857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45067_45856,(0),null);
var infos_45858 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45067_45856,(1),null);
encode_cols(infos_45858,source_idx_45823,line_45833,col_45857);


var G__45859 = cljs.core.next(seq__45041_45850__$1);
var G__45860 = null;
var G__45861 = (0);
var G__45862 = (0);
seq__45041_45835 = G__45859;
chunk__45042_45836 = G__45860;
count__45043_45837 = G__45861;
i__45044_45838 = G__45862;
continue;
}
} else {
}
}
break;
}


var G__45863 = seq__44967_45828;
var G__45864 = chunk__44968_45829;
var G__45865 = count__44969_45830;
var G__45866 = (i__44970_45831 + (1));
seq__44967_45828 = G__45863;
chunk__44968_45829 = G__45864;
count__44969_45830 = G__45865;
i__44970_45831 = G__45866;
continue;
} else {
var temp__5735__auto___45867 = cljs.core.seq(seq__44967_45828);
if(temp__5735__auto___45867){
var seq__44967_45868__$1 = temp__5735__auto___45867;
if(cljs.core.chunked_seq_QMARK_(seq__44967_45868__$1)){
var c__4609__auto___45869 = cljs.core.chunk_first(seq__44967_45868__$1);
var G__45870 = cljs.core.chunk_rest(seq__44967_45868__$1);
var G__45871 = c__4609__auto___45869;
var G__45872 = cljs.core.count(c__4609__auto___45869);
var G__45873 = (0);
seq__44967_45828 = G__45870;
chunk__44968_45829 = G__45871;
count__44969_45830 = G__45872;
i__44970_45831 = G__45873;
continue;
} else {
var vec__45072_45874 = cljs.core.first(seq__44967_45868__$1);
var line_45875 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45072_45874,(0),null);
var cols_45876 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45072_45874,(1),null);
var seq__45076_45877 = cljs.core.seq(cols_45876);
var chunk__45077_45878 = null;
var count__45078_45879 = (0);
var i__45079_45880 = (0);
while(true){
if((i__45079_45880 < count__45078_45879)){
var vec__45091_45881 = chunk__45077_45878.cljs$core$IIndexed$_nth$arity$2(null,i__45079_45880);
var col_45882 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45091_45881,(0),null);
var infos_45883 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45091_45881,(1),null);
encode_cols(infos_45883,source_idx_45823,line_45875,col_45882);


var G__45884 = seq__45076_45877;
var G__45885 = chunk__45077_45878;
var G__45886 = count__45078_45879;
var G__45887 = (i__45079_45880 + (1));
seq__45076_45877 = G__45884;
chunk__45077_45878 = G__45885;
count__45078_45879 = G__45886;
i__45079_45880 = G__45887;
continue;
} else {
var temp__5735__auto___45888__$1 = cljs.core.seq(seq__45076_45877);
if(temp__5735__auto___45888__$1){
var seq__45076_45889__$1 = temp__5735__auto___45888__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45076_45889__$1)){
var c__4609__auto___45890 = cljs.core.chunk_first(seq__45076_45889__$1);
var G__45891 = cljs.core.chunk_rest(seq__45076_45889__$1);
var G__45892 = c__4609__auto___45890;
var G__45893 = cljs.core.count(c__4609__auto___45890);
var G__45894 = (0);
seq__45076_45877 = G__45891;
chunk__45077_45878 = G__45892;
count__45078_45879 = G__45893;
i__45079_45880 = G__45894;
continue;
} else {
var vec__45099_45895 = cljs.core.first(seq__45076_45889__$1);
var col_45896 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45099_45895,(0),null);
var infos_45897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45099_45895,(1),null);
encode_cols(infos_45897,source_idx_45823,line_45875,col_45896);


var G__45898 = cljs.core.next(seq__45076_45889__$1);
var G__45899 = null;
var G__45900 = (0);
var G__45901 = (0);
seq__45076_45877 = G__45898;
chunk__45077_45878 = G__45899;
count__45078_45879 = G__45900;
i__45079_45880 = G__45901;
continue;
}
} else {
}
}
break;
}


var G__45902 = cljs.core.next(seq__44967_45868__$1);
var G__45903 = null;
var G__45904 = (0);
var G__45905 = (0);
seq__44967_45828 = G__45902;
chunk__44968_45829 = G__45903;
count__44969_45830 = G__45904;
i__44970_45831 = G__45905;
continue;
}
} else {
}
}
break;
}


var G__45906 = seq__44748_45818;
var G__45907 = chunk__44749_45819;
var G__45908 = count__44750_45820;
var G__45909 = (i__44751_45821 + (1));
seq__44748_45818 = G__45906;
chunk__44749_45819 = G__45907;
count__44750_45820 = G__45908;
i__44751_45821 = G__45909;
continue;
} else {
var temp__5735__auto___45910 = cljs.core.seq(seq__44748_45818);
if(temp__5735__auto___45910){
var seq__44748_45911__$1 = temp__5735__auto___45910;
if(cljs.core.chunked_seq_QMARK_(seq__44748_45911__$1)){
var c__4609__auto___45912 = cljs.core.chunk_first(seq__44748_45911__$1);
var G__45913 = cljs.core.chunk_rest(seq__44748_45911__$1);
var G__45914 = c__4609__auto___45912;
var G__45915 = cljs.core.count(c__4609__auto___45912);
var G__45916 = (0);
seq__44748_45818 = G__45913;
chunk__44749_45819 = G__45914;
count__44750_45820 = G__45915;
i__44751_45821 = G__45916;
continue;
} else {
var vec__45107_45917 = cljs.core.first(seq__44748_45911__$1);
var source_idx_45918 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45107_45917,(0),null);
var vec__45110_45919 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45107_45917,(1),null);
var __45920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45110_45919,(0),null);
var lines_45921__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45110_45919,(1),null);
var seq__45116_45922 = cljs.core.seq(lines_45921__$1);
var chunk__45117_45923 = null;
var count__45118_45924 = (0);
var i__45119_45925 = (0);
while(true){
if((i__45119_45925 < count__45118_45924)){
var vec__45177_45926 = chunk__45117_45923.cljs$core$IIndexed$_nth$arity$2(null,i__45119_45925);
var line_45927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45177_45926,(0),null);
var cols_45928 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45177_45926,(1),null);
var seq__45180_45929 = cljs.core.seq(cols_45928);
var chunk__45181_45930 = null;
var count__45182_45931 = (0);
var i__45183_45932 = (0);
while(true){
if((i__45183_45932 < count__45182_45931)){
var vec__45190_45933 = chunk__45181_45930.cljs$core$IIndexed$_nth$arity$2(null,i__45183_45932);
var col_45934 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45190_45933,(0),null);
var infos_45935 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45190_45933,(1),null);
encode_cols(infos_45935,source_idx_45918,line_45927,col_45934);


var G__45936 = seq__45180_45929;
var G__45937 = chunk__45181_45930;
var G__45938 = count__45182_45931;
var G__45939 = (i__45183_45932 + (1));
seq__45180_45929 = G__45936;
chunk__45181_45930 = G__45937;
count__45182_45931 = G__45938;
i__45183_45932 = G__45939;
continue;
} else {
var temp__5735__auto___45940__$1 = cljs.core.seq(seq__45180_45929);
if(temp__5735__auto___45940__$1){
var seq__45180_45941__$1 = temp__5735__auto___45940__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45180_45941__$1)){
var c__4609__auto___45942 = cljs.core.chunk_first(seq__45180_45941__$1);
var G__45943 = cljs.core.chunk_rest(seq__45180_45941__$1);
var G__45944 = c__4609__auto___45942;
var G__45945 = cljs.core.count(c__4609__auto___45942);
var G__45946 = (0);
seq__45180_45929 = G__45943;
chunk__45181_45930 = G__45944;
count__45182_45931 = G__45945;
i__45183_45932 = G__45946;
continue;
} else {
var vec__45201_45948 = cljs.core.first(seq__45180_45941__$1);
var col_45949 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45201_45948,(0),null);
var infos_45950 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45201_45948,(1),null);
encode_cols(infos_45950,source_idx_45918,line_45927,col_45949);


var G__45951 = cljs.core.next(seq__45180_45941__$1);
var G__45952 = null;
var G__45953 = (0);
var G__45954 = (0);
seq__45180_45929 = G__45951;
chunk__45181_45930 = G__45952;
count__45182_45931 = G__45953;
i__45183_45932 = G__45954;
continue;
}
} else {
}
}
break;
}


var G__45955 = seq__45116_45922;
var G__45956 = chunk__45117_45923;
var G__45957 = count__45118_45924;
var G__45958 = (i__45119_45925 + (1));
seq__45116_45922 = G__45955;
chunk__45117_45923 = G__45956;
count__45118_45924 = G__45957;
i__45119_45925 = G__45958;
continue;
} else {
var temp__5735__auto___45959__$1 = cljs.core.seq(seq__45116_45922);
if(temp__5735__auto___45959__$1){
var seq__45116_45960__$1 = temp__5735__auto___45959__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45116_45960__$1)){
var c__4609__auto___45961 = cljs.core.chunk_first(seq__45116_45960__$1);
var G__45962 = cljs.core.chunk_rest(seq__45116_45960__$1);
var G__45963 = c__4609__auto___45961;
var G__45964 = cljs.core.count(c__4609__auto___45961);
var G__45965 = (0);
seq__45116_45922 = G__45962;
chunk__45117_45923 = G__45963;
count__45118_45924 = G__45964;
i__45119_45925 = G__45965;
continue;
} else {
var vec__45205_45966 = cljs.core.first(seq__45116_45960__$1);
var line_45967 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45205_45966,(0),null);
var cols_45968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45205_45966,(1),null);
var seq__45208_45969 = cljs.core.seq(cols_45968);
var chunk__45209_45970 = null;
var count__45210_45971 = (0);
var i__45211_45972 = (0);
while(true){
if((i__45211_45972 < count__45210_45971)){
var vec__45222_45973 = chunk__45209_45970.cljs$core$IIndexed$_nth$arity$2(null,i__45211_45972);
var col_45974 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45222_45973,(0),null);
var infos_45975 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45222_45973,(1),null);
encode_cols(infos_45975,source_idx_45918,line_45967,col_45974);


var G__45976 = seq__45208_45969;
var G__45977 = chunk__45209_45970;
var G__45978 = count__45210_45971;
var G__45979 = (i__45211_45972 + (1));
seq__45208_45969 = G__45976;
chunk__45209_45970 = G__45977;
count__45210_45971 = G__45978;
i__45211_45972 = G__45979;
continue;
} else {
var temp__5735__auto___45980__$2 = cljs.core.seq(seq__45208_45969);
if(temp__5735__auto___45980__$2){
var seq__45208_45981__$1 = temp__5735__auto___45980__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45208_45981__$1)){
var c__4609__auto___45982 = cljs.core.chunk_first(seq__45208_45981__$1);
var G__45983 = cljs.core.chunk_rest(seq__45208_45981__$1);
var G__45984 = c__4609__auto___45982;
var G__45985 = cljs.core.count(c__4609__auto___45982);
var G__45986 = (0);
seq__45208_45969 = G__45983;
chunk__45209_45970 = G__45984;
count__45210_45971 = G__45985;
i__45211_45972 = G__45986;
continue;
} else {
var vec__45225_45987 = cljs.core.first(seq__45208_45981__$1);
var col_45988 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45225_45987,(0),null);
var infos_45989 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45225_45987,(1),null);
encode_cols(infos_45989,source_idx_45918,line_45967,col_45988);


var G__45990 = cljs.core.next(seq__45208_45981__$1);
var G__45991 = null;
var G__45992 = (0);
var G__45993 = (0);
seq__45208_45969 = G__45990;
chunk__45209_45970 = G__45991;
count__45210_45971 = G__45992;
i__45211_45972 = G__45993;
continue;
}
} else {
}
}
break;
}


var G__45994 = cljs.core.next(seq__45116_45960__$1);
var G__45995 = null;
var G__45996 = (0);
var G__45997 = (0);
seq__45116_45922 = G__45994;
chunk__45117_45923 = G__45995;
count__45118_45924 = G__45996;
i__45119_45925 = G__45997;
continue;
}
} else {
}
}
break;
}


var G__45998 = cljs.core.next(seq__44748_45911__$1);
var G__45999 = null;
var G__46000 = (0);
var G__46001 = (0);
seq__44748_45818 = G__45998;
chunk__44749_45819 = G__45999;
count__44750_45820 = G__46000;
i__44751_45821 = G__46001;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__45228 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__44720_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__44720_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__44721_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__44721_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__44722_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__44722_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__45229 = G__45228;
var G__45230_46002 = G__45229;
var G__45231_46003 = "sourcesContent";
var G__45232_46004 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__45230_46002,G__45231_46003,G__45232_46004);

return G__45229;
} else {
return G__45228;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__45233 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45233,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45233,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__45236 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45236,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45236,(1),null);
var G__46006 = cljs.core.next(col_map_seq);
var G__46007 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__45236,col,infos,vec__45233,line,col_map){
return (function (v,p__45239){
var map__45240 = p__45239;
var map__45240__$1 = (((((!((map__45240 == null))))?(((((map__45240.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45240.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45240):map__45240);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45240__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45240__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__45236,col,infos,vec__45233,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__46006;
new_cols = G__46007;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__46011 = cljs.core.next(line_map_seq);
var G__46012 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__46011;
new_lines = G__46012;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__45247_46015 = cljs.core.seq(reverse_map);
var chunk__45248_46016 = null;
var count__45249_46017 = (0);
var i__45250_46018 = (0);
while(true){
if((i__45250_46018 < count__45249_46017)){
var vec__45504_46019 = chunk__45248_46016.cljs$core$IIndexed$_nth$arity$2(null,i__45250_46018);
var line_46020 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45504_46019,(0),null);
var columns_46021 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45504_46019,(1),null);
var seq__45507_46022 = cljs.core.seq(columns_46021);
var chunk__45508_46023 = null;
var count__45509_46024 = (0);
var i__45510_46025 = (0);
while(true){
if((i__45510_46025 < count__45509_46024)){
var vec__45572_46026 = chunk__45508_46023.cljs$core$IIndexed$_nth$arity$2(null,i__45510_46025);
var column_46027 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45572_46026,(0),null);
var column_info_46028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45572_46026,(1),null);
var seq__45575_46031 = cljs.core.seq(column_info_46028);
var chunk__45576_46032 = null;
var count__45577_46033 = (0);
var i__45578_46034 = (0);
while(true){
if((i__45578_46034 < count__45577_46033)){
var map__45592_46035 = chunk__45576_46032.cljs$core$IIndexed$_nth$arity$2(null,i__45578_46034);
var map__45592_46036__$1 = (((((!((map__45592_46035 == null))))?(((((map__45592_46035.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45592_46035.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45592_46035):map__45592_46035);
var gline_46037 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45592_46036__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46038 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45592_46036__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46039 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45592_46036__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46037], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45575_46031,chunk__45576_46032,count__45577_46033,i__45578_46034,seq__45507_46022,chunk__45508_46023,count__45509_46024,i__45510_46025,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45592_46035,map__45592_46036__$1,gline_46037,gcol_46038,name_46039,vec__45572_46026,column_46027,column_info_46028,vec__45504_46019,line_46020,columns_46021,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46038], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46020,new cljs.core.Keyword(null,"col","col",-1959363084),column_46027,new cljs.core.Keyword(null,"name","name",1843675177),name_46039], null));
});})(seq__45575_46031,chunk__45576_46032,count__45577_46033,i__45578_46034,seq__45507_46022,chunk__45508_46023,count__45509_46024,i__45510_46025,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45592_46035,map__45592_46036__$1,gline_46037,gcol_46038,name_46039,vec__45572_46026,column_46027,column_info_46028,vec__45504_46019,line_46020,columns_46021,inverted))
,cljs.core.sorted_map()));


var G__46043 = seq__45575_46031;
var G__46044 = chunk__45576_46032;
var G__46045 = count__45577_46033;
var G__46046 = (i__45578_46034 + (1));
seq__45575_46031 = G__46043;
chunk__45576_46032 = G__46044;
count__45577_46033 = G__46045;
i__45578_46034 = G__46046;
continue;
} else {
var temp__5735__auto___46047 = cljs.core.seq(seq__45575_46031);
if(temp__5735__auto___46047){
var seq__45575_46048__$1 = temp__5735__auto___46047;
if(cljs.core.chunked_seq_QMARK_(seq__45575_46048__$1)){
var c__4609__auto___46049 = cljs.core.chunk_first(seq__45575_46048__$1);
var G__46050 = cljs.core.chunk_rest(seq__45575_46048__$1);
var G__46051 = c__4609__auto___46049;
var G__46052 = cljs.core.count(c__4609__auto___46049);
var G__46053 = (0);
seq__45575_46031 = G__46050;
chunk__45576_46032 = G__46051;
count__45577_46033 = G__46052;
i__45578_46034 = G__46053;
continue;
} else {
var map__45598_46054 = cljs.core.first(seq__45575_46048__$1);
var map__45598_46055__$1 = (((((!((map__45598_46054 == null))))?(((((map__45598_46054.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45598_46054.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45598_46054):map__45598_46054);
var gline_46056 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45598_46055__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46057 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45598_46055__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46058 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45598_46055__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46056], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45575_46031,chunk__45576_46032,count__45577_46033,i__45578_46034,seq__45507_46022,chunk__45508_46023,count__45509_46024,i__45510_46025,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45598_46054,map__45598_46055__$1,gline_46056,gcol_46057,name_46058,seq__45575_46048__$1,temp__5735__auto___46047,vec__45572_46026,column_46027,column_info_46028,vec__45504_46019,line_46020,columns_46021,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46057], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46020,new cljs.core.Keyword(null,"col","col",-1959363084),column_46027,new cljs.core.Keyword(null,"name","name",1843675177),name_46058], null));
});})(seq__45575_46031,chunk__45576_46032,count__45577_46033,i__45578_46034,seq__45507_46022,chunk__45508_46023,count__45509_46024,i__45510_46025,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45598_46054,map__45598_46055__$1,gline_46056,gcol_46057,name_46058,seq__45575_46048__$1,temp__5735__auto___46047,vec__45572_46026,column_46027,column_info_46028,vec__45504_46019,line_46020,columns_46021,inverted))
,cljs.core.sorted_map()));


var G__46060 = cljs.core.next(seq__45575_46048__$1);
var G__46061 = null;
var G__46062 = (0);
var G__46063 = (0);
seq__45575_46031 = G__46060;
chunk__45576_46032 = G__46061;
count__45577_46033 = G__46062;
i__45578_46034 = G__46063;
continue;
}
} else {
}
}
break;
}


var G__46064 = seq__45507_46022;
var G__46065 = chunk__45508_46023;
var G__46066 = count__45509_46024;
var G__46067 = (i__45510_46025 + (1));
seq__45507_46022 = G__46064;
chunk__45508_46023 = G__46065;
count__45509_46024 = G__46066;
i__45510_46025 = G__46067;
continue;
} else {
var temp__5735__auto___46069 = cljs.core.seq(seq__45507_46022);
if(temp__5735__auto___46069){
var seq__45507_46070__$1 = temp__5735__auto___46069;
if(cljs.core.chunked_seq_QMARK_(seq__45507_46070__$1)){
var c__4609__auto___46071 = cljs.core.chunk_first(seq__45507_46070__$1);
var G__46072 = cljs.core.chunk_rest(seq__45507_46070__$1);
var G__46073 = c__4609__auto___46071;
var G__46074 = cljs.core.count(c__4609__auto___46071);
var G__46075 = (0);
seq__45507_46022 = G__46072;
chunk__45508_46023 = G__46073;
count__45509_46024 = G__46074;
i__45510_46025 = G__46075;
continue;
} else {
var vec__45602_46076 = cljs.core.first(seq__45507_46070__$1);
var column_46077 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45602_46076,(0),null);
var column_info_46078 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45602_46076,(1),null);
var seq__45605_46079 = cljs.core.seq(column_info_46078);
var chunk__45606_46080 = null;
var count__45607_46081 = (0);
var i__45608_46082 = (0);
while(true){
if((i__45608_46082 < count__45607_46081)){
var map__45619_46083 = chunk__45606_46080.cljs$core$IIndexed$_nth$arity$2(null,i__45608_46082);
var map__45619_46084__$1 = (((((!((map__45619_46083 == null))))?(((((map__45619_46083.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45619_46083.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45619_46083):map__45619_46083);
var gline_46085 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45619_46084__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46086 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45619_46084__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46087 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45619_46084__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46085], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45605_46079,chunk__45606_46080,count__45607_46081,i__45608_46082,seq__45507_46022,chunk__45508_46023,count__45509_46024,i__45510_46025,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45619_46083,map__45619_46084__$1,gline_46085,gcol_46086,name_46087,vec__45602_46076,column_46077,column_info_46078,seq__45507_46070__$1,temp__5735__auto___46069,vec__45504_46019,line_46020,columns_46021,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46086], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46020,new cljs.core.Keyword(null,"col","col",-1959363084),column_46077,new cljs.core.Keyword(null,"name","name",1843675177),name_46087], null));
});})(seq__45605_46079,chunk__45606_46080,count__45607_46081,i__45608_46082,seq__45507_46022,chunk__45508_46023,count__45509_46024,i__45510_46025,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45619_46083,map__45619_46084__$1,gline_46085,gcol_46086,name_46087,vec__45602_46076,column_46077,column_info_46078,seq__45507_46070__$1,temp__5735__auto___46069,vec__45504_46019,line_46020,columns_46021,inverted))
,cljs.core.sorted_map()));


var G__46090 = seq__45605_46079;
var G__46091 = chunk__45606_46080;
var G__46092 = count__45607_46081;
var G__46093 = (i__45608_46082 + (1));
seq__45605_46079 = G__46090;
chunk__45606_46080 = G__46091;
count__45607_46081 = G__46092;
i__45608_46082 = G__46093;
continue;
} else {
var temp__5735__auto___46095__$1 = cljs.core.seq(seq__45605_46079);
if(temp__5735__auto___46095__$1){
var seq__45605_46096__$1 = temp__5735__auto___46095__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45605_46096__$1)){
var c__4609__auto___46097 = cljs.core.chunk_first(seq__45605_46096__$1);
var G__46098 = cljs.core.chunk_rest(seq__45605_46096__$1);
var G__46099 = c__4609__auto___46097;
var G__46100 = cljs.core.count(c__4609__auto___46097);
var G__46101 = (0);
seq__45605_46079 = G__46098;
chunk__45606_46080 = G__46099;
count__45607_46081 = G__46100;
i__45608_46082 = G__46101;
continue;
} else {
var map__45626_46102 = cljs.core.first(seq__45605_46096__$1);
var map__45626_46103__$1 = (((((!((map__45626_46102 == null))))?(((((map__45626_46102.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45626_46102.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45626_46102):map__45626_46102);
var gline_46104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45626_46103__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46105 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45626_46103__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46106 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45626_46103__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46104], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45605_46079,chunk__45606_46080,count__45607_46081,i__45608_46082,seq__45507_46022,chunk__45508_46023,count__45509_46024,i__45510_46025,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45626_46102,map__45626_46103__$1,gline_46104,gcol_46105,name_46106,seq__45605_46096__$1,temp__5735__auto___46095__$1,vec__45602_46076,column_46077,column_info_46078,seq__45507_46070__$1,temp__5735__auto___46069,vec__45504_46019,line_46020,columns_46021,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46105], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46020,new cljs.core.Keyword(null,"col","col",-1959363084),column_46077,new cljs.core.Keyword(null,"name","name",1843675177),name_46106], null));
});})(seq__45605_46079,chunk__45606_46080,count__45607_46081,i__45608_46082,seq__45507_46022,chunk__45508_46023,count__45509_46024,i__45510_46025,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45626_46102,map__45626_46103__$1,gline_46104,gcol_46105,name_46106,seq__45605_46096__$1,temp__5735__auto___46095__$1,vec__45602_46076,column_46077,column_info_46078,seq__45507_46070__$1,temp__5735__auto___46069,vec__45504_46019,line_46020,columns_46021,inverted))
,cljs.core.sorted_map()));


var G__46109 = cljs.core.next(seq__45605_46096__$1);
var G__46110 = null;
var G__46111 = (0);
var G__46112 = (0);
seq__45605_46079 = G__46109;
chunk__45606_46080 = G__46110;
count__45607_46081 = G__46111;
i__45608_46082 = G__46112;
continue;
}
} else {
}
}
break;
}


var G__46113 = cljs.core.next(seq__45507_46070__$1);
var G__46114 = null;
var G__46115 = (0);
var G__46116 = (0);
seq__45507_46022 = G__46113;
chunk__45508_46023 = G__46114;
count__45509_46024 = G__46115;
i__45510_46025 = G__46116;
continue;
}
} else {
}
}
break;
}


var G__46119 = seq__45247_46015;
var G__46120 = chunk__45248_46016;
var G__46121 = count__45249_46017;
var G__46122 = (i__45250_46018 + (1));
seq__45247_46015 = G__46119;
chunk__45248_46016 = G__46120;
count__45249_46017 = G__46121;
i__45250_46018 = G__46122;
continue;
} else {
var temp__5735__auto___46123 = cljs.core.seq(seq__45247_46015);
if(temp__5735__auto___46123){
var seq__45247_46126__$1 = temp__5735__auto___46123;
if(cljs.core.chunked_seq_QMARK_(seq__45247_46126__$1)){
var c__4609__auto___46127 = cljs.core.chunk_first(seq__45247_46126__$1);
var G__46128 = cljs.core.chunk_rest(seq__45247_46126__$1);
var G__46129 = c__4609__auto___46127;
var G__46130 = cljs.core.count(c__4609__auto___46127);
var G__46131 = (0);
seq__45247_46015 = G__46128;
chunk__45248_46016 = G__46129;
count__45249_46017 = G__46130;
i__45250_46018 = G__46131;
continue;
} else {
var vec__45632_46133 = cljs.core.first(seq__45247_46126__$1);
var line_46134 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45632_46133,(0),null);
var columns_46135 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45632_46133,(1),null);
var seq__45635_46136 = cljs.core.seq(columns_46135);
var chunk__45636_46137 = null;
var count__45637_46138 = (0);
var i__45638_46139 = (0);
while(true){
if((i__45638_46139 < count__45637_46138)){
var vec__45702_46141 = chunk__45636_46137.cljs$core$IIndexed$_nth$arity$2(null,i__45638_46139);
var column_46142 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45702_46141,(0),null);
var column_info_46143 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45702_46141,(1),null);
var seq__45705_46146 = cljs.core.seq(column_info_46143);
var chunk__45706_46147 = null;
var count__45707_46148 = (0);
var i__45708_46149 = (0);
while(true){
if((i__45708_46149 < count__45707_46148)){
var map__45715_46150 = chunk__45706_46147.cljs$core$IIndexed$_nth$arity$2(null,i__45708_46149);
var map__45715_46151__$1 = (((((!((map__45715_46150 == null))))?(((((map__45715_46150.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45715_46150.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45715_46150):map__45715_46150);
var gline_46152 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45715_46151__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46153 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45715_46151__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46154 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45715_46151__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46152], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45705_46146,chunk__45706_46147,count__45707_46148,i__45708_46149,seq__45635_46136,chunk__45636_46137,count__45637_46138,i__45638_46139,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45715_46150,map__45715_46151__$1,gline_46152,gcol_46153,name_46154,vec__45702_46141,column_46142,column_info_46143,vec__45632_46133,line_46134,columns_46135,seq__45247_46126__$1,temp__5735__auto___46123,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46153], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46134,new cljs.core.Keyword(null,"col","col",-1959363084),column_46142,new cljs.core.Keyword(null,"name","name",1843675177),name_46154], null));
});})(seq__45705_46146,chunk__45706_46147,count__45707_46148,i__45708_46149,seq__45635_46136,chunk__45636_46137,count__45637_46138,i__45638_46139,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45715_46150,map__45715_46151__$1,gline_46152,gcol_46153,name_46154,vec__45702_46141,column_46142,column_info_46143,vec__45632_46133,line_46134,columns_46135,seq__45247_46126__$1,temp__5735__auto___46123,inverted))
,cljs.core.sorted_map()));


var G__46161 = seq__45705_46146;
var G__46162 = chunk__45706_46147;
var G__46163 = count__45707_46148;
var G__46164 = (i__45708_46149 + (1));
seq__45705_46146 = G__46161;
chunk__45706_46147 = G__46162;
count__45707_46148 = G__46163;
i__45708_46149 = G__46164;
continue;
} else {
var temp__5735__auto___46165__$1 = cljs.core.seq(seq__45705_46146);
if(temp__5735__auto___46165__$1){
var seq__45705_46166__$1 = temp__5735__auto___46165__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45705_46166__$1)){
var c__4609__auto___46169 = cljs.core.chunk_first(seq__45705_46166__$1);
var G__46170 = cljs.core.chunk_rest(seq__45705_46166__$1);
var G__46171 = c__4609__auto___46169;
var G__46172 = cljs.core.count(c__4609__auto___46169);
var G__46173 = (0);
seq__45705_46146 = G__46170;
chunk__45706_46147 = G__46171;
count__45707_46148 = G__46172;
i__45708_46149 = G__46173;
continue;
} else {
var map__45718_46175 = cljs.core.first(seq__45705_46166__$1);
var map__45718_46176__$1 = (((((!((map__45718_46175 == null))))?(((((map__45718_46175.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45718_46175.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45718_46175):map__45718_46175);
var gline_46177 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45718_46176__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46178 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45718_46176__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46179 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45718_46176__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46177], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45705_46146,chunk__45706_46147,count__45707_46148,i__45708_46149,seq__45635_46136,chunk__45636_46137,count__45637_46138,i__45638_46139,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45718_46175,map__45718_46176__$1,gline_46177,gcol_46178,name_46179,seq__45705_46166__$1,temp__5735__auto___46165__$1,vec__45702_46141,column_46142,column_info_46143,vec__45632_46133,line_46134,columns_46135,seq__45247_46126__$1,temp__5735__auto___46123,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46178], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46134,new cljs.core.Keyword(null,"col","col",-1959363084),column_46142,new cljs.core.Keyword(null,"name","name",1843675177),name_46179], null));
});})(seq__45705_46146,chunk__45706_46147,count__45707_46148,i__45708_46149,seq__45635_46136,chunk__45636_46137,count__45637_46138,i__45638_46139,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45718_46175,map__45718_46176__$1,gline_46177,gcol_46178,name_46179,seq__45705_46166__$1,temp__5735__auto___46165__$1,vec__45702_46141,column_46142,column_info_46143,vec__45632_46133,line_46134,columns_46135,seq__45247_46126__$1,temp__5735__auto___46123,inverted))
,cljs.core.sorted_map()));


var G__46186 = cljs.core.next(seq__45705_46166__$1);
var G__46187 = null;
var G__46188 = (0);
var G__46189 = (0);
seq__45705_46146 = G__46186;
chunk__45706_46147 = G__46187;
count__45707_46148 = G__46188;
i__45708_46149 = G__46189;
continue;
}
} else {
}
}
break;
}


var G__46190 = seq__45635_46136;
var G__46191 = chunk__45636_46137;
var G__46192 = count__45637_46138;
var G__46193 = (i__45638_46139 + (1));
seq__45635_46136 = G__46190;
chunk__45636_46137 = G__46191;
count__45637_46138 = G__46192;
i__45638_46139 = G__46193;
continue;
} else {
var temp__5735__auto___46195__$1 = cljs.core.seq(seq__45635_46136);
if(temp__5735__auto___46195__$1){
var seq__45635_46196__$1 = temp__5735__auto___46195__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45635_46196__$1)){
var c__4609__auto___46197 = cljs.core.chunk_first(seq__45635_46196__$1);
var G__46198 = cljs.core.chunk_rest(seq__45635_46196__$1);
var G__46199 = c__4609__auto___46197;
var G__46200 = cljs.core.count(c__4609__auto___46197);
var G__46201 = (0);
seq__45635_46136 = G__46198;
chunk__45636_46137 = G__46199;
count__45637_46138 = G__46200;
i__45638_46139 = G__46201;
continue;
} else {
var vec__45720_46202 = cljs.core.first(seq__45635_46196__$1);
var column_46203 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45720_46202,(0),null);
var column_info_46204 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45720_46202,(1),null);
var seq__45723_46205 = cljs.core.seq(column_info_46204);
var chunk__45724_46206 = null;
var count__45725_46207 = (0);
var i__45726_46208 = (0);
while(true){
if((i__45726_46208 < count__45725_46207)){
var map__45737_46212 = chunk__45724_46206.cljs$core$IIndexed$_nth$arity$2(null,i__45726_46208);
var map__45737_46213__$1 = (((((!((map__45737_46212 == null))))?(((((map__45737_46212.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45737_46212.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45737_46212):map__45737_46212);
var gline_46214 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45737_46213__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46215 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45737_46213__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46216 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45737_46213__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46214], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45723_46205,chunk__45724_46206,count__45725_46207,i__45726_46208,seq__45635_46136,chunk__45636_46137,count__45637_46138,i__45638_46139,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45737_46212,map__45737_46213__$1,gline_46214,gcol_46215,name_46216,vec__45720_46202,column_46203,column_info_46204,seq__45635_46196__$1,temp__5735__auto___46195__$1,vec__45632_46133,line_46134,columns_46135,seq__45247_46126__$1,temp__5735__auto___46123,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46215], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46134,new cljs.core.Keyword(null,"col","col",-1959363084),column_46203,new cljs.core.Keyword(null,"name","name",1843675177),name_46216], null));
});})(seq__45723_46205,chunk__45724_46206,count__45725_46207,i__45726_46208,seq__45635_46136,chunk__45636_46137,count__45637_46138,i__45638_46139,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45737_46212,map__45737_46213__$1,gline_46214,gcol_46215,name_46216,vec__45720_46202,column_46203,column_info_46204,seq__45635_46196__$1,temp__5735__auto___46195__$1,vec__45632_46133,line_46134,columns_46135,seq__45247_46126__$1,temp__5735__auto___46123,inverted))
,cljs.core.sorted_map()));


var G__46221 = seq__45723_46205;
var G__46222 = chunk__45724_46206;
var G__46223 = count__45725_46207;
var G__46224 = (i__45726_46208 + (1));
seq__45723_46205 = G__46221;
chunk__45724_46206 = G__46222;
count__45725_46207 = G__46223;
i__45726_46208 = G__46224;
continue;
} else {
var temp__5735__auto___46225__$2 = cljs.core.seq(seq__45723_46205);
if(temp__5735__auto___46225__$2){
var seq__45723_46226__$1 = temp__5735__auto___46225__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45723_46226__$1)){
var c__4609__auto___46227 = cljs.core.chunk_first(seq__45723_46226__$1);
var G__46228 = cljs.core.chunk_rest(seq__45723_46226__$1);
var G__46229 = c__4609__auto___46227;
var G__46230 = cljs.core.count(c__4609__auto___46227);
var G__46231 = (0);
seq__45723_46205 = G__46228;
chunk__45724_46206 = G__46229;
count__45725_46207 = G__46230;
i__45726_46208 = G__46231;
continue;
} else {
var map__45739_46232 = cljs.core.first(seq__45723_46226__$1);
var map__45739_46233__$1 = (((((!((map__45739_46232 == null))))?(((((map__45739_46232.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45739_46232.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45739_46232):map__45739_46232);
var gline_46234 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45739_46233__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46235 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45739_46233__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46236 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45739_46233__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46234], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45723_46205,chunk__45724_46206,count__45725_46207,i__45726_46208,seq__45635_46136,chunk__45636_46137,count__45637_46138,i__45638_46139,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45739_46232,map__45739_46233__$1,gline_46234,gcol_46235,name_46236,seq__45723_46226__$1,temp__5735__auto___46225__$2,vec__45720_46202,column_46203,column_info_46204,seq__45635_46196__$1,temp__5735__auto___46195__$1,vec__45632_46133,line_46134,columns_46135,seq__45247_46126__$1,temp__5735__auto___46123,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46235], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46134,new cljs.core.Keyword(null,"col","col",-1959363084),column_46203,new cljs.core.Keyword(null,"name","name",1843675177),name_46236], null));
});})(seq__45723_46205,chunk__45724_46206,count__45725_46207,i__45726_46208,seq__45635_46136,chunk__45636_46137,count__45637_46138,i__45638_46139,seq__45247_46015,chunk__45248_46016,count__45249_46017,i__45250_46018,map__45739_46232,map__45739_46233__$1,gline_46234,gcol_46235,name_46236,seq__45723_46226__$1,temp__5735__auto___46225__$2,vec__45720_46202,column_46203,column_info_46204,seq__45635_46196__$1,temp__5735__auto___46195__$1,vec__45632_46133,line_46134,columns_46135,seq__45247_46126__$1,temp__5735__auto___46123,inverted))
,cljs.core.sorted_map()));


var G__46241 = cljs.core.next(seq__45723_46226__$1);
var G__46242 = null;
var G__46243 = (0);
var G__46244 = (0);
seq__45723_46205 = G__46241;
chunk__45724_46206 = G__46242;
count__45725_46207 = G__46243;
i__45726_46208 = G__46244;
continue;
}
} else {
}
}
break;
}


var G__46245 = cljs.core.next(seq__45635_46196__$1);
var G__46246 = null;
var G__46247 = (0);
var G__46248 = (0);
seq__45635_46136 = G__46245;
chunk__45636_46137 = G__46246;
count__45637_46138 = G__46247;
i__45638_46139 = G__46248;
continue;
}
} else {
}
}
break;
}


var G__46249 = cljs.core.next(seq__45247_46126__$1);
var G__46250 = null;
var G__46251 = (0);
var G__46252 = (0);
seq__45247_46015 = G__46249;
chunk__45248_46016 = G__46250;
count__45249_46017 = G__46251;
i__45250_46018 = G__46252;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
