goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__49848 = (line + (1));
var G__49849 = (1);
var G__49850 = (counter + (1));
line = G__49848;
col = G__49849;
counter = G__49850;
continue;
} else {
var G__49851 = line;
var G__49852 = (col + (1));
var G__49853 = (counter + (1));
line = G__49851;
col = G__49852;
counter = G__49853;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__49854 = cljs.core.next(chars);
var G__49855 = (n__$1 - (1));
chars = G__49854;
n__$1 = G__49855;
continue;
} else {
var G__49856 = cljs.core.next(chars);
var G__49857 = n__$1;
chars = G__49856;
n__$1 = G__49857;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__49836){
var map__49837 = p__49836;
var map__49837__$1 = (((((!((map__49837 == null))))?(((((map__49837.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49837.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49837):map__49837);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49837__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49837__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49837__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49837__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__49839_49858 = cljs.core.seq(full_reasons);
var chunk__49840_49859 = null;
var count__49841_49860 = (0);
var i__49842_49861 = (0);
while(true){
if((i__49842_49861 < count__49841_49860)){
var r_49862 = chunk__49840_49859.cljs$core$IIndexed$_nth$arity$2(null,i__49842_49861);
instaparse.failure.print_reason(r_49862);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__49863 = seq__49839_49858;
var G__49864 = chunk__49840_49859;
var G__49865 = count__49841_49860;
var G__49866 = (i__49842_49861 + (1));
seq__49839_49858 = G__49863;
chunk__49840_49859 = G__49864;
count__49841_49860 = G__49865;
i__49842_49861 = G__49866;
continue;
} else {
var temp__5735__auto___49867 = cljs.core.seq(seq__49839_49858);
if(temp__5735__auto___49867){
var seq__49839_49868__$1 = temp__5735__auto___49867;
if(cljs.core.chunked_seq_QMARK_(seq__49839_49868__$1)){
var c__4609__auto___49869 = cljs.core.chunk_first(seq__49839_49868__$1);
var G__49870 = cljs.core.chunk_rest(seq__49839_49868__$1);
var G__49871 = c__4609__auto___49869;
var G__49872 = cljs.core.count(c__4609__auto___49869);
var G__49873 = (0);
seq__49839_49858 = G__49870;
chunk__49840_49859 = G__49871;
count__49841_49860 = G__49872;
i__49842_49861 = G__49873;
continue;
} else {
var r_49874 = cljs.core.first(seq__49839_49868__$1);
instaparse.failure.print_reason(r_49874);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__49875 = cljs.core.next(seq__49839_49868__$1);
var G__49876 = null;
var G__49877 = (0);
var G__49878 = (0);
seq__49839_49858 = G__49875;
chunk__49840_49859 = G__49876;
count__49841_49860 = G__49877;
i__49842_49861 = G__49878;
continue;
}
} else {
}
}
break;
}

var seq__49844 = cljs.core.seq(partial_reasons);
var chunk__49845 = null;
var count__49846 = (0);
var i__49847 = (0);
while(true){
if((i__49847 < count__49846)){
var r = chunk__49845.cljs$core$IIndexed$_nth$arity$2(null,i__49847);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__49879 = seq__49844;
var G__49880 = chunk__49845;
var G__49881 = count__49846;
var G__49882 = (i__49847 + (1));
seq__49844 = G__49879;
chunk__49845 = G__49880;
count__49846 = G__49881;
i__49847 = G__49882;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__49844);
if(temp__5735__auto__){
var seq__49844__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49844__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__49844__$1);
var G__49883 = cljs.core.chunk_rest(seq__49844__$1);
var G__49884 = c__4609__auto__;
var G__49885 = cljs.core.count(c__4609__auto__);
var G__49886 = (0);
seq__49844 = G__49883;
chunk__49845 = G__49884;
count__49846 = G__49885;
i__49847 = G__49886;
continue;
} else {
var r = cljs.core.first(seq__49844__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__49887 = cljs.core.next(seq__49844__$1);
var G__49888 = null;
var G__49889 = (0);
var G__49890 = (0);
seq__49844 = G__49887;
chunk__49845 = G__49888;
count__49846 = G__49889;
i__49847 = G__49890;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=instaparse.failure.js.map
