goog.provide('pinkgorilla.kernel.guard');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.analyzer');
goog.require('cljs.compiler');
/**
 * each time the watchdog has a chance to run, this var is set with the current time
 */
pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_ = (0);
pinkgorilla.kernel.guard.min_max_eval_duration = (3000);
/**
 * The number of msec for the watchdog period.
 *          This value has to be much lower than min-max-eval-duration.
 */
pinkgorilla.kernel.guard.watchdog_period = (pinkgorilla.kernel.guard.min_max_eval_duration / (10));
pinkgorilla.kernel.guard.runonce = (function pinkgorilla$kernel$guard$runonce(f){
var ran = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
return (function() { 
var G__48835__delegate = function (args){
if(cljs.core.truth_(cljs.core.deref(ran))){
return null;
} else {
cljs.core.reset_BANG_(ran,true);

return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}
};
var G__48835 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__48836__i = 0, G__48836__a = new Array(arguments.length -  0);
while (G__48836__i < G__48836__a.length) {G__48836__a[G__48836__i] = arguments[G__48836__i + 0]; ++G__48836__i;}
  args = new cljs.core.IndexedSeq(G__48836__a,0,null);
} 
return G__48835__delegate.call(this,args);};
G__48835.cljs$lang$maxFixedArity = 0;
G__48835.cljs$lang$applyTo = (function (arglist__48837){
var args = cljs.core.seq(arglist__48837);
return G__48835__delegate(args);
});
G__48835.cljs$core$IFn$_invoke$arity$variadic = G__48835__delegate;
return G__48835;
})()
;
});
pinkgorilla.kernel.guard.tick = (function pinkgorilla$kernel$guard$tick(){
return (pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_ = cljs.core.system_time());
});
/**
 * reset the *watchdog-tick* to the current time once in a while
 */
pinkgorilla.kernel.guard.run_watchdog_STAR_ = (function pinkgorilla$kernel$guard$run_watchdog_STAR_(){
pinkgorilla.kernel.guard.tick();

var c__42130__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42131__auto__ = (function (){var switch__42062__auto__ = (function (state_48816){
var state_val_48817 = (state_48816[(1)]);
if((state_val_48817 === (1))){
var state_48816__$1 = state_48816;
var statearr_48818_48838 = state_48816__$1;
(statearr_48818_48838[(2)] = null);

(statearr_48818_48838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48817 === (2))){
var inst_48808 = cljs.core.async.timeout(pinkgorilla.kernel.guard.watchdog_period);
var state_48816__$1 = state_48816;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48816__$1,(4),inst_48808);
} else {
if((state_val_48817 === (3))){
var inst_48814 = (state_48816[(2)]);
var state_48816__$1 = state_48816;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48816__$1,inst_48814);
} else {
if((state_val_48817 === (4))){
var inst_48810 = (state_48816[(2)]);
var inst_48811 = pinkgorilla.kernel.guard.tick();
var state_48816__$1 = (function (){var statearr_48819 = state_48816;
(statearr_48819[(7)] = inst_48810);

(statearr_48819[(8)] = inst_48811);

return statearr_48819;
})();
var statearr_48820_48839 = state_48816__$1;
(statearr_48820_48839[(2)] = null);

(statearr_48820_48839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
});
return (function() {
var pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__42063__auto__ = null;
var pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__42063__auto____0 = (function (){
var statearr_48822 = [null,null,null,null,null,null,null,null,null];
(statearr_48822[(0)] = pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__42063__auto__);

(statearr_48822[(1)] = (1));

return statearr_48822;
});
var pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__42063__auto____1 = (function (state_48816){
while(true){
var ret_value__42064__auto__ = (function (){try{while(true){
var result__42065__auto__ = switch__42062__auto__(state_48816);
if(cljs.core.keyword_identical_QMARK_(result__42065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42065__auto__;
}
break;
}
}catch (e48823){if((e48823 instanceof Object)){
var ex__42066__auto__ = e48823;
var statearr_48824_48840 = state_48816;
(statearr_48824_48840[(5)] = ex__42066__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48816);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48823;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42064__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48841 = state_48816;
state_48816 = G__48841;
continue;
} else {
return ret_value__42064__auto__;
}
break;
}
});
pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__42063__auto__ = function(state_48816){
switch(arguments.length){
case 0:
return pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__42063__auto____0.call(this);
case 1:
return pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__42063__auto____1.call(this,state_48816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__42063__auto____0;
pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__42063__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__42063__auto____1;
return pinkgorilla$kernel$guard$run_watchdog_STAR__$_state_machine__42063__auto__;
})()
})();
var state__42132__auto__ = (function (){var statearr_48825 = (f__42131__auto__.cljs$core$IFn$_invoke$arity$0 ? f__42131__auto__.cljs$core$IFn$_invoke$arity$0() : f__42131__auto__.call(null));
(statearr_48825[(6)] = c__42130__auto__);

return statearr_48825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42132__auto__);
}));

return c__42130__auto__;
});
pinkgorilla.kernel.guard.run_watchdog_once = pinkgorilla.kernel.guard.runonce(pinkgorilla.kernel.guard.run_watchdog_STAR_);
pinkgorilla.kernel.guard.watchdog = (function pinkgorilla$kernel$guard$watchdog(){
pinkgorilla.kernel.guard.tick();

return (pinkgorilla.kernel.guard.run_watchdog_once.cljs$core$IFn$_invoke$arity$0 ? pinkgorilla.kernel.guard.run_watchdog_once.cljs$core$IFn$_invoke$arity$0() : pinkgorilla.kernel.guard.run_watchdog_once.call(null));
});
pinkgorilla.kernel.guard.guard = (function pinkgorilla$kernel$guard$guard(max_eval_duration){
if(((cljs.core.system_time() - pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_) > max_eval_duration)){
if(cljs.core.truth_(confirm(["A KLIPSE snippet has been running for more than ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_eval_duration)," milliseconds. This is often because of a long-running computation or infinite loop. Would you like to interrupt the snippet? \n OK to interrupt the evaluation.\n Cancel to continue."].join('')))){
throw "Infinite Loop";
} else {
}

return (pinkgorilla.kernel.guard._STAR_watchdog_tick_STAR_ = cljs.core.system_time());
} else {
return null;
}
});
goog.exportSymbol('pinkgorilla.kernel.guard.guard', pinkgorilla.kernel.guard.guard);
/**
 * same as cljs.compiler/emits with insertion of a `guard()` call before if and recur (emitted as continue) statement.
 * 
 *   Limitations:
 *   1. It doesn't prevent infinite loop in imported code e.g. (reduce + (range)
 *   
 */
pinkgorilla.kernel.guard.my_emits = (function pinkgorilla$kernel$guard$my_emits(var_args){
var args__4795__auto__ = [];
var len__4789__auto___48842 = arguments.length;
var i__4790__auto___48843 = (0);
while(true){
if((i__4790__auto___48843 < len__4789__auto___48842)){
args__4795__auto__.push((arguments[i__4790__auto___48843]));

var G__48844 = (i__4790__auto___48843 + (1));
i__4790__auto___48843 = G__48844;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return pinkgorilla.kernel.guard.my_emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(pinkgorilla.kernel.guard.my_emits.cljs$core$IFn$_invoke$arity$variadic = (function (max_eval_duration,xs){
if(cljs.core.truth_(((typeof cljs.core.first(xs) === 'string')?cljs.core.re_matches(/^(if|continue).*/,cljs.core.first(xs)):false))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["klipse_clj.lang.clojure.guard.guard(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_eval_duration),");"].join('')], 0));
} else {
}

var seq__48829_48845 = cljs.core.seq(xs);
var chunk__48830_48846 = null;
var count__48831_48847 = (0);
var i__48832_48848 = (0);
while(true){
if((i__48832_48848 < count__48831_48847)){
var x_48849 = chunk__48830_48846.cljs$core$IIndexed$_nth$arity$2(null,i__48832_48848);
if((x_48849 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(x_48849)){
cljs.compiler.emit(x_48849);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(x_48849)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.guard.my_emits,max_eval_duration,x_48849);
} else {
if(goog.isFunction(x_48849)){
(x_48849.cljs$core$IFn$_invoke$arity$0 ? x_48849.cljs$core$IFn$_invoke$arity$0() : x_48849.call(null));
} else {
var s_48850 = cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x_48849], 0));
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__48829_48845,chunk__48830_48846,count__48831_48847,i__48832_48848,s_48850,x_48849){
return (function (p1__48826_SHARP_){
return (p1__48826_SHARP_ + ((s_48850).length));
});})(seq__48829_48845,chunk__48830_48846,count__48831_48847,i__48832_48848,s_48850,x_48849))
);
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_48850], 0));

}
}
}
}


var G__48851 = seq__48829_48845;
var G__48852 = chunk__48830_48846;
var G__48853 = count__48831_48847;
var G__48854 = (i__48832_48848 + (1));
seq__48829_48845 = G__48851;
chunk__48830_48846 = G__48852;
count__48831_48847 = G__48853;
i__48832_48848 = G__48854;
continue;
} else {
var temp__5735__auto___48855 = cljs.core.seq(seq__48829_48845);
if(temp__5735__auto___48855){
var seq__48829_48856__$1 = temp__5735__auto___48855;
if(cljs.core.chunked_seq_QMARK_(seq__48829_48856__$1)){
var c__4609__auto___48857 = cljs.core.chunk_first(seq__48829_48856__$1);
var G__48858 = cljs.core.chunk_rest(seq__48829_48856__$1);
var G__48859 = c__4609__auto___48857;
var G__48860 = cljs.core.count(c__4609__auto___48857);
var G__48861 = (0);
seq__48829_48845 = G__48858;
chunk__48830_48846 = G__48859;
count__48831_48847 = G__48860;
i__48832_48848 = G__48861;
continue;
} else {
var x_48862 = cljs.core.first(seq__48829_48856__$1);
if((x_48862 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(x_48862)){
cljs.compiler.emit(x_48862);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(x_48862)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$3(pinkgorilla.kernel.guard.my_emits,max_eval_duration,x_48862);
} else {
if(goog.isFunction(x_48862)){
(x_48862.cljs$core$IFn$_invoke$arity$0 ? x_48862.cljs$core$IFn$_invoke$arity$0() : x_48862.call(null));
} else {
var s_48863 = cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x_48862], 0));
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__48829_48845,chunk__48830_48846,count__48831_48847,i__48832_48848,s_48863,x_48862,seq__48829_48856__$1,temp__5735__auto___48855){
return (function (p1__48826_SHARP_){
return (p1__48826_SHARP_ + ((s_48863).length));
});})(seq__48829_48845,chunk__48830_48846,count__48831_48847,i__48832_48848,s_48863,x_48862,seq__48829_48856__$1,temp__5735__auto___48855))
);
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_48863], 0));

}
}
}
}


var G__48864 = cljs.core.next(seq__48829_48856__$1);
var G__48865 = null;
var G__48866 = (0);
var G__48867 = (0);
seq__48829_48845 = G__48864;
chunk__48830_48846 = G__48865;
count__48831_48847 = G__48866;
i__48832_48848 = G__48867;
continue;
}
} else {
}
}
break;
}

return null;
}));

(pinkgorilla.kernel.guard.my_emits.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.kernel.guard.my_emits.cljs$lang$applyTo = (function (seq48827){
var G__48828 = cljs.core.first(seq48827);
var seq48827__$1 = cljs.core.next(seq48827);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__48828,seq48827__$1);
}));


//# sourceMappingURL=pinkgorilla.kernel.guard.js.map
