goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__44582){
var vec__44583 = p__44582;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44583,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44583,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__44590 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44590,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44590,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44590,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44590,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44590,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__44607 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44607,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44607,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44607,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44607,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44607,(4),null);
var vec__44610 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44610,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44610,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44610,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44610,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44610,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__44623 = segmap;
var map__44623__$1 = (((((!((map__44623 == null))))?(((((map__44623.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44623.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44623):map__44623);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44623__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44623__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44623__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44623__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44623__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__44633 = arguments.length;
switch (G__44633) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44649 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45750 = cljs.core.next(segs__$1);
var G__45751 = nrelseg;
var G__45752 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45750;
relseg__$1 = G__45751;
result__$1 = G__45752;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44649,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44649,(1),null);
var G__45754 = (gline + (1));
var G__45755 = cljs.core.next(lines__$1);
var G__45756 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45757 = result__$1;
gline = G__45754;
lines__$1 = G__45755;
relseg = G__45756;
result = G__45757;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__44654 = segmap;
var map__44654__$1 = (((((!((map__44654 == null))))?(((((map__44654.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44654.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44654):map__44654);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44654__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44654__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44654__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44654__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44654__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__44652_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__44652_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__44664 = arguments.length;
switch (G__44664) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44675 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45782 = cljs.core.next(segs__$1);
var G__45783 = nrelseg;
var G__45784 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45782;
relseg__$1 = G__45783;
result__$1 = G__45784;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44675,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44675,(1),null);
var G__45785 = (gline + (1));
var G__45786 = cljs.core.next(lines__$1);
var G__45787 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45788 = result__$1;
gline = G__45785;
lines__$1 = G__45786;
relseg = G__45787;
result = G__45788;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44686){
var vec__44687 = p__44686;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44687,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44687,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44687,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44687,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44687,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__44690){
var vec__44691 = p__44690;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44691,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44691,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44691,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44691,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44691,(4),null);
var seg = vec__44691;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44698){
var vec__44699 = p__44698;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44699,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44699,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44699,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44699,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44699,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__44715 = cljs.core.seq(infos);
var chunk__44716 = null;
var count__44717 = (0);
var i__44718 = (0);
while(true){
if((i__44718 < count__44717)){
var info = chunk__44716.cljs$core$IIndexed$_nth$arity$2(null,i__44718);
var segv_45800 = info__GT_segv(info,source_idx,line,col);
var gline_45801 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45802 = cljs.core.count(cljs.core.deref(lines));
if((gline_45801 > (lc_45802 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44715,chunk__44716,count__44717,i__44718,segv_45800,gline_45801,lc_45802,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45801 - (lc_45802 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45800], null));
});})(seq__44715,chunk__44716,count__44717,i__44718,segv_45800,gline_45801,lc_45802,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44715,chunk__44716,count__44717,i__44718,segv_45800,gline_45801,lc_45802,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45801], null),cljs.core.conj,segv_45800);
});})(seq__44715,chunk__44716,count__44717,i__44718,segv_45800,gline_45801,lc_45802,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45804 = seq__44715;
var G__45805 = chunk__44716;
var G__45806 = count__44717;
var G__45807 = (i__44718 + (1));
seq__44715 = G__45804;
chunk__44716 = G__45805;
count__44717 = G__45806;
i__44718 = G__45807;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__44715);
if(temp__5735__auto__){
var seq__44715__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44715__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__44715__$1);
var G__45808 = cljs.core.chunk_rest(seq__44715__$1);
var G__45809 = c__4609__auto__;
var G__45810 = cljs.core.count(c__4609__auto__);
var G__45811 = (0);
seq__44715 = G__45808;
chunk__44716 = G__45809;
count__44717 = G__45810;
i__44718 = G__45811;
continue;
} else {
var info = cljs.core.first(seq__44715__$1);
var segv_45812 = info__GT_segv(info,source_idx,line,col);
var gline_45813 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45814 = cljs.core.count(cljs.core.deref(lines));
if((gline_45813 > (lc_45814 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44715,chunk__44716,count__44717,i__44718,segv_45812,gline_45813,lc_45814,info,seq__44715__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45813 - (lc_45814 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45812], null));
});})(seq__44715,chunk__44716,count__44717,i__44718,segv_45812,gline_45813,lc_45814,info,seq__44715__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44715,chunk__44716,count__44717,i__44718,segv_45812,gline_45813,lc_45814,info,seq__44715__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45813], null),cljs.core.conj,segv_45812);
});})(seq__44715,chunk__44716,count__44717,i__44718,segv_45812,gline_45813,lc_45814,info,seq__44715__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45818 = cljs.core.next(seq__44715__$1);
var G__45819 = null;
var G__45820 = (0);
var G__45821 = (0);
seq__44715 = G__45818;
chunk__44716 = G__45819;
count__44717 = G__45820;
i__44718 = G__45821;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__44733_45822 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__44734_45823 = null;
var count__44735_45824 = (0);
var i__44736_45825 = (0);
while(true){
if((i__44736_45825 < count__44735_45824)){
var vec__44973_45826 = chunk__44734_45823.cljs$core$IIndexed$_nth$arity$2(null,i__44736_45825);
var source_idx_45827 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44973_45826,(0),null);
var vec__44976_45828 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44973_45826,(1),null);
var __45829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44976_45828,(0),null);
var lines_45830__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44976_45828,(1),null);
var seq__44979_45831 = cljs.core.seq(lines_45830__$1);
var chunk__44980_45832 = null;
var count__44981_45833 = (0);
var i__44982_45834 = (0);
while(true){
if((i__44982_45834 < count__44981_45833)){
var vec__45055_45835 = chunk__44980_45832.cljs$core$IIndexed$_nth$arity$2(null,i__44982_45834);
var line_45836 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45055_45835,(0),null);
var cols_45837 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45055_45835,(1),null);
var seq__45058_45838 = cljs.core.seq(cols_45837);
var chunk__45059_45839 = null;
var count__45060_45840 = (0);
var i__45061_45841 = (0);
while(true){
if((i__45061_45841 < count__45060_45840)){
var vec__45077_45842 = chunk__45059_45839.cljs$core$IIndexed$_nth$arity$2(null,i__45061_45841);
var col_45843 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45077_45842,(0),null);
var infos_45844 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45077_45842,(1),null);
encode_cols(infos_45844,source_idx_45827,line_45836,col_45843);


var G__45845 = seq__45058_45838;
var G__45846 = chunk__45059_45839;
var G__45847 = count__45060_45840;
var G__45848 = (i__45061_45841 + (1));
seq__45058_45838 = G__45845;
chunk__45059_45839 = G__45846;
count__45060_45840 = G__45847;
i__45061_45841 = G__45848;
continue;
} else {
var temp__5735__auto___45849 = cljs.core.seq(seq__45058_45838);
if(temp__5735__auto___45849){
var seq__45058_45850__$1 = temp__5735__auto___45849;
if(cljs.core.chunked_seq_QMARK_(seq__45058_45850__$1)){
var c__4609__auto___45851 = cljs.core.chunk_first(seq__45058_45850__$1);
var G__45852 = cljs.core.chunk_rest(seq__45058_45850__$1);
var G__45853 = c__4609__auto___45851;
var G__45854 = cljs.core.count(c__4609__auto___45851);
var G__45855 = (0);
seq__45058_45838 = G__45852;
chunk__45059_45839 = G__45853;
count__45060_45840 = G__45854;
i__45061_45841 = G__45855;
continue;
} else {
var vec__45083_45856 = cljs.core.first(seq__45058_45850__$1);
var col_45857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45083_45856,(0),null);
var infos_45858 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45083_45856,(1),null);
encode_cols(infos_45858,source_idx_45827,line_45836,col_45857);


var G__45859 = cljs.core.next(seq__45058_45850__$1);
var G__45860 = null;
var G__45861 = (0);
var G__45862 = (0);
seq__45058_45838 = G__45859;
chunk__45059_45839 = G__45860;
count__45060_45840 = G__45861;
i__45061_45841 = G__45862;
continue;
}
} else {
}
}
break;
}


var G__45863 = seq__44979_45831;
var G__45864 = chunk__44980_45832;
var G__45865 = count__44981_45833;
var G__45866 = (i__44982_45834 + (1));
seq__44979_45831 = G__45863;
chunk__44980_45832 = G__45864;
count__44981_45833 = G__45865;
i__44982_45834 = G__45866;
continue;
} else {
var temp__5735__auto___45867 = cljs.core.seq(seq__44979_45831);
if(temp__5735__auto___45867){
var seq__44979_45868__$1 = temp__5735__auto___45867;
if(cljs.core.chunked_seq_QMARK_(seq__44979_45868__$1)){
var c__4609__auto___45869 = cljs.core.chunk_first(seq__44979_45868__$1);
var G__45870 = cljs.core.chunk_rest(seq__44979_45868__$1);
var G__45871 = c__4609__auto___45869;
var G__45872 = cljs.core.count(c__4609__auto___45869);
var G__45873 = (0);
seq__44979_45831 = G__45870;
chunk__44980_45832 = G__45871;
count__44981_45833 = G__45872;
i__44982_45834 = G__45873;
continue;
} else {
var vec__45093_45874 = cljs.core.first(seq__44979_45868__$1);
var line_45875 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45093_45874,(0),null);
var cols_45876 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45093_45874,(1),null);
var seq__45096_45877 = cljs.core.seq(cols_45876);
var chunk__45097_45878 = null;
var count__45098_45879 = (0);
var i__45099_45880 = (0);
while(true){
if((i__45099_45880 < count__45098_45879)){
var vec__45114_45882 = chunk__45097_45878.cljs$core$IIndexed$_nth$arity$2(null,i__45099_45880);
var col_45883 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45114_45882,(0),null);
var infos_45884 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45114_45882,(1),null);
encode_cols(infos_45884,source_idx_45827,line_45875,col_45883);


var G__45885 = seq__45096_45877;
var G__45886 = chunk__45097_45878;
var G__45887 = count__45098_45879;
var G__45888 = (i__45099_45880 + (1));
seq__45096_45877 = G__45885;
chunk__45097_45878 = G__45886;
count__45098_45879 = G__45887;
i__45099_45880 = G__45888;
continue;
} else {
var temp__5735__auto___45889__$1 = cljs.core.seq(seq__45096_45877);
if(temp__5735__auto___45889__$1){
var seq__45096_45890__$1 = temp__5735__auto___45889__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45096_45890__$1)){
var c__4609__auto___45891 = cljs.core.chunk_first(seq__45096_45890__$1);
var G__45892 = cljs.core.chunk_rest(seq__45096_45890__$1);
var G__45893 = c__4609__auto___45891;
var G__45894 = cljs.core.count(c__4609__auto___45891);
var G__45895 = (0);
seq__45096_45877 = G__45892;
chunk__45097_45878 = G__45893;
count__45098_45879 = G__45894;
i__45099_45880 = G__45895;
continue;
} else {
var vec__45120_45896 = cljs.core.first(seq__45096_45890__$1);
var col_45897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45120_45896,(0),null);
var infos_45898 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45120_45896,(1),null);
encode_cols(infos_45898,source_idx_45827,line_45875,col_45897);


var G__45899 = cljs.core.next(seq__45096_45890__$1);
var G__45900 = null;
var G__45901 = (0);
var G__45902 = (0);
seq__45096_45877 = G__45899;
chunk__45097_45878 = G__45900;
count__45098_45879 = G__45901;
i__45099_45880 = G__45902;
continue;
}
} else {
}
}
break;
}


var G__45903 = cljs.core.next(seq__44979_45868__$1);
var G__45904 = null;
var G__45905 = (0);
var G__45906 = (0);
seq__44979_45831 = G__45903;
chunk__44980_45832 = G__45904;
count__44981_45833 = G__45905;
i__44982_45834 = G__45906;
continue;
}
} else {
}
}
break;
}


var G__45907 = seq__44733_45822;
var G__45908 = chunk__44734_45823;
var G__45909 = count__44735_45824;
var G__45910 = (i__44736_45825 + (1));
seq__44733_45822 = G__45907;
chunk__44734_45823 = G__45908;
count__44735_45824 = G__45909;
i__44736_45825 = G__45910;
continue;
} else {
var temp__5735__auto___45911 = cljs.core.seq(seq__44733_45822);
if(temp__5735__auto___45911){
var seq__44733_45912__$1 = temp__5735__auto___45911;
if(cljs.core.chunked_seq_QMARK_(seq__44733_45912__$1)){
var c__4609__auto___45913 = cljs.core.chunk_first(seq__44733_45912__$1);
var G__45914 = cljs.core.chunk_rest(seq__44733_45912__$1);
var G__45915 = c__4609__auto___45913;
var G__45916 = cljs.core.count(c__4609__auto___45913);
var G__45917 = (0);
seq__44733_45822 = G__45914;
chunk__44734_45823 = G__45915;
count__44735_45824 = G__45916;
i__44736_45825 = G__45917;
continue;
} else {
var vec__45123_45918 = cljs.core.first(seq__44733_45912__$1);
var source_idx_45919 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45123_45918,(0),null);
var vec__45126_45920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45123_45918,(1),null);
var __45921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45126_45920,(0),null);
var lines_45922__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45126_45920,(1),null);
var seq__45129_45923 = cljs.core.seq(lines_45922__$1);
var chunk__45130_45924 = null;
var count__45131_45925 = (0);
var i__45132_45926 = (0);
while(true){
if((i__45132_45926 < count__45131_45925)){
var vec__45190_45927 = chunk__45130_45924.cljs$core$IIndexed$_nth$arity$2(null,i__45132_45926);
var line_45928 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45190_45927,(0),null);
var cols_45929 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45190_45927,(1),null);
var seq__45193_45930 = cljs.core.seq(cols_45929);
var chunk__45194_45931 = null;
var count__45195_45932 = (0);
var i__45196_45933 = (0);
while(true){
if((i__45196_45933 < count__45195_45932)){
var vec__45203_45934 = chunk__45194_45931.cljs$core$IIndexed$_nth$arity$2(null,i__45196_45933);
var col_45935 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45203_45934,(0),null);
var infos_45936 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45203_45934,(1),null);
encode_cols(infos_45936,source_idx_45919,line_45928,col_45935);


var G__45937 = seq__45193_45930;
var G__45938 = chunk__45194_45931;
var G__45939 = count__45195_45932;
var G__45940 = (i__45196_45933 + (1));
seq__45193_45930 = G__45937;
chunk__45194_45931 = G__45938;
count__45195_45932 = G__45939;
i__45196_45933 = G__45940;
continue;
} else {
var temp__5735__auto___45941__$1 = cljs.core.seq(seq__45193_45930);
if(temp__5735__auto___45941__$1){
var seq__45193_45942__$1 = temp__5735__auto___45941__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45193_45942__$1)){
var c__4609__auto___45943 = cljs.core.chunk_first(seq__45193_45942__$1);
var G__45944 = cljs.core.chunk_rest(seq__45193_45942__$1);
var G__45945 = c__4609__auto___45943;
var G__45946 = cljs.core.count(c__4609__auto___45943);
var G__45947 = (0);
seq__45193_45930 = G__45944;
chunk__45194_45931 = G__45945;
count__45195_45932 = G__45946;
i__45196_45933 = G__45947;
continue;
} else {
var vec__45206_45948 = cljs.core.first(seq__45193_45942__$1);
var col_45949 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45206_45948,(0),null);
var infos_45950 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45206_45948,(1),null);
encode_cols(infos_45950,source_idx_45919,line_45928,col_45949);


var G__45951 = cljs.core.next(seq__45193_45942__$1);
var G__45952 = null;
var G__45953 = (0);
var G__45954 = (0);
seq__45193_45930 = G__45951;
chunk__45194_45931 = G__45952;
count__45195_45932 = G__45953;
i__45196_45933 = G__45954;
continue;
}
} else {
}
}
break;
}


var G__45955 = seq__45129_45923;
var G__45956 = chunk__45130_45924;
var G__45957 = count__45131_45925;
var G__45958 = (i__45132_45926 + (1));
seq__45129_45923 = G__45955;
chunk__45130_45924 = G__45956;
count__45131_45925 = G__45957;
i__45132_45926 = G__45958;
continue;
} else {
var temp__5735__auto___45959__$1 = cljs.core.seq(seq__45129_45923);
if(temp__5735__auto___45959__$1){
var seq__45129_45960__$1 = temp__5735__auto___45959__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45129_45960__$1)){
var c__4609__auto___45961 = cljs.core.chunk_first(seq__45129_45960__$1);
var G__45962 = cljs.core.chunk_rest(seq__45129_45960__$1);
var G__45963 = c__4609__auto___45961;
var G__45964 = cljs.core.count(c__4609__auto___45961);
var G__45965 = (0);
seq__45129_45923 = G__45962;
chunk__45130_45924 = G__45963;
count__45131_45925 = G__45964;
i__45132_45926 = G__45965;
continue;
} else {
var vec__45209_45967 = cljs.core.first(seq__45129_45960__$1);
var line_45968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45209_45967,(0),null);
var cols_45969 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45209_45967,(1),null);
var seq__45212_45972 = cljs.core.seq(cols_45969);
var chunk__45213_45973 = null;
var count__45214_45974 = (0);
var i__45215_45975 = (0);
while(true){
if((i__45215_45975 < count__45214_45974)){
var vec__45222_45976 = chunk__45213_45973.cljs$core$IIndexed$_nth$arity$2(null,i__45215_45975);
var col_45977 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45222_45976,(0),null);
var infos_45978 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45222_45976,(1),null);
encode_cols(infos_45978,source_idx_45919,line_45968,col_45977);


var G__45980 = seq__45212_45972;
var G__45981 = chunk__45213_45973;
var G__45982 = count__45214_45974;
var G__45983 = (i__45215_45975 + (1));
seq__45212_45972 = G__45980;
chunk__45213_45973 = G__45981;
count__45214_45974 = G__45982;
i__45215_45975 = G__45983;
continue;
} else {
var temp__5735__auto___45984__$2 = cljs.core.seq(seq__45212_45972);
if(temp__5735__auto___45984__$2){
var seq__45212_45985__$1 = temp__5735__auto___45984__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45212_45985__$1)){
var c__4609__auto___45986 = cljs.core.chunk_first(seq__45212_45985__$1);
var G__45987 = cljs.core.chunk_rest(seq__45212_45985__$1);
var G__45988 = c__4609__auto___45986;
var G__45989 = cljs.core.count(c__4609__auto___45986);
var G__45990 = (0);
seq__45212_45972 = G__45987;
chunk__45213_45973 = G__45988;
count__45214_45974 = G__45989;
i__45215_45975 = G__45990;
continue;
} else {
var vec__45226_45993 = cljs.core.first(seq__45212_45985__$1);
var col_45994 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45226_45993,(0),null);
var infos_45995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45226_45993,(1),null);
encode_cols(infos_45995,source_idx_45919,line_45968,col_45994);


var G__45996 = cljs.core.next(seq__45212_45985__$1);
var G__45997 = null;
var G__45998 = (0);
var G__45999 = (0);
seq__45212_45972 = G__45996;
chunk__45213_45973 = G__45997;
count__45214_45974 = G__45998;
i__45215_45975 = G__45999;
continue;
}
} else {
}
}
break;
}


var G__46000 = cljs.core.next(seq__45129_45960__$1);
var G__46001 = null;
var G__46002 = (0);
var G__46003 = (0);
seq__45129_45923 = G__46000;
chunk__45130_45924 = G__46001;
count__45131_45925 = G__46002;
i__45132_45926 = G__46003;
continue;
}
} else {
}
}
break;
}


var G__46004 = cljs.core.next(seq__44733_45912__$1);
var G__46005 = null;
var G__46006 = (0);
var G__46007 = (0);
seq__44733_45822 = G__46004;
chunk__44734_45823 = G__46005;
count__44735_45824 = G__46006;
i__44736_45825 = G__46007;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__45229 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__44709_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__44709_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__44711_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__44711_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__44712_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__44712_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__45234 = G__45229;
var G__45235_46010 = G__45234;
var G__45236_46011 = "sourcesContent";
var G__45237_46012 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__45235_46010,G__45236_46011,G__45237_46012);

return G__45234;
} else {
return G__45229;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__45238 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45238,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45238,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__45241 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45241,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45241,(1),null);
var G__46017 = cljs.core.next(col_map_seq);
var G__46018 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__45241,col,infos,vec__45238,line,col_map){
return (function (v,p__45244){
var map__45245 = p__45244;
var map__45245__$1 = (((((!((map__45245 == null))))?(((((map__45245.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45245.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45245):map__45245);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45245__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45245__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__45241,col,infos,vec__45238,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__46017;
new_cols = G__46018;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__46019 = cljs.core.next(line_map_seq);
var G__46020 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__46019;
new_lines = G__46020;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__45247_46022 = cljs.core.seq(reverse_map);
var chunk__45248_46023 = null;
var count__45249_46024 = (0);
var i__45250_46025 = (0);
while(true){
if((i__45250_46025 < count__45249_46024)){
var vec__45504_46026 = chunk__45248_46023.cljs$core$IIndexed$_nth$arity$2(null,i__45250_46025);
var line_46027 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45504_46026,(0),null);
var columns_46028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45504_46026,(1),null);
var seq__45507_46029 = cljs.core.seq(columns_46028);
var chunk__45508_46030 = null;
var count__45509_46031 = (0);
var i__45510_46032 = (0);
while(true){
if((i__45510_46032 < count__45509_46031)){
var vec__45571_46033 = chunk__45508_46030.cljs$core$IIndexed$_nth$arity$2(null,i__45510_46032);
var column_46034 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45571_46033,(0),null);
var column_info_46035 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45571_46033,(1),null);
var seq__45574_46036 = cljs.core.seq(column_info_46035);
var chunk__45575_46037 = null;
var count__45576_46038 = (0);
var i__45577_46039 = (0);
while(true){
if((i__45577_46039 < count__45576_46038)){
var map__45592_46040 = chunk__45575_46037.cljs$core$IIndexed$_nth$arity$2(null,i__45577_46039);
var map__45592_46041__$1 = (((((!((map__45592_46040 == null))))?(((((map__45592_46040.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45592_46040.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45592_46040):map__45592_46040);
var gline_46042 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45592_46041__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46043 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45592_46041__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46044 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45592_46041__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46042], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45574_46036,chunk__45575_46037,count__45576_46038,i__45577_46039,seq__45507_46029,chunk__45508_46030,count__45509_46031,i__45510_46032,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45592_46040,map__45592_46041__$1,gline_46042,gcol_46043,name_46044,vec__45571_46033,column_46034,column_info_46035,vec__45504_46026,line_46027,columns_46028,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46043], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46027,new cljs.core.Keyword(null,"col","col",-1959363084),column_46034,new cljs.core.Keyword(null,"name","name",1843675177),name_46044], null));
});})(seq__45574_46036,chunk__45575_46037,count__45576_46038,i__45577_46039,seq__45507_46029,chunk__45508_46030,count__45509_46031,i__45510_46032,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45592_46040,map__45592_46041__$1,gline_46042,gcol_46043,name_46044,vec__45571_46033,column_46034,column_info_46035,vec__45504_46026,line_46027,columns_46028,inverted))
,cljs.core.sorted_map()));


var G__46048 = seq__45574_46036;
var G__46049 = chunk__45575_46037;
var G__46050 = count__45576_46038;
var G__46051 = (i__45577_46039 + (1));
seq__45574_46036 = G__46048;
chunk__45575_46037 = G__46049;
count__45576_46038 = G__46050;
i__45577_46039 = G__46051;
continue;
} else {
var temp__5735__auto___46052 = cljs.core.seq(seq__45574_46036);
if(temp__5735__auto___46052){
var seq__45574_46053__$1 = temp__5735__auto___46052;
if(cljs.core.chunked_seq_QMARK_(seq__45574_46053__$1)){
var c__4609__auto___46054 = cljs.core.chunk_first(seq__45574_46053__$1);
var G__46055 = cljs.core.chunk_rest(seq__45574_46053__$1);
var G__46056 = c__4609__auto___46054;
var G__46057 = cljs.core.count(c__4609__auto___46054);
var G__46058 = (0);
seq__45574_46036 = G__46055;
chunk__45575_46037 = G__46056;
count__45576_46038 = G__46057;
i__45577_46039 = G__46058;
continue;
} else {
var map__45595_46059 = cljs.core.first(seq__45574_46053__$1);
var map__45595_46060__$1 = (((((!((map__45595_46059 == null))))?(((((map__45595_46059.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45595_46059.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45595_46059):map__45595_46059);
var gline_46061 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45595_46060__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46062 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45595_46060__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46063 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45595_46060__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46061], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45574_46036,chunk__45575_46037,count__45576_46038,i__45577_46039,seq__45507_46029,chunk__45508_46030,count__45509_46031,i__45510_46032,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45595_46059,map__45595_46060__$1,gline_46061,gcol_46062,name_46063,seq__45574_46053__$1,temp__5735__auto___46052,vec__45571_46033,column_46034,column_info_46035,vec__45504_46026,line_46027,columns_46028,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46062], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46027,new cljs.core.Keyword(null,"col","col",-1959363084),column_46034,new cljs.core.Keyword(null,"name","name",1843675177),name_46063], null));
});})(seq__45574_46036,chunk__45575_46037,count__45576_46038,i__45577_46039,seq__45507_46029,chunk__45508_46030,count__45509_46031,i__45510_46032,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45595_46059,map__45595_46060__$1,gline_46061,gcol_46062,name_46063,seq__45574_46053__$1,temp__5735__auto___46052,vec__45571_46033,column_46034,column_info_46035,vec__45504_46026,line_46027,columns_46028,inverted))
,cljs.core.sorted_map()));


var G__46070 = cljs.core.next(seq__45574_46053__$1);
var G__46071 = null;
var G__46072 = (0);
var G__46073 = (0);
seq__45574_46036 = G__46070;
chunk__45575_46037 = G__46071;
count__45576_46038 = G__46072;
i__45577_46039 = G__46073;
continue;
}
} else {
}
}
break;
}


var G__46075 = seq__45507_46029;
var G__46076 = chunk__45508_46030;
var G__46077 = count__45509_46031;
var G__46078 = (i__45510_46032 + (1));
seq__45507_46029 = G__46075;
chunk__45508_46030 = G__46076;
count__45509_46031 = G__46077;
i__45510_46032 = G__46078;
continue;
} else {
var temp__5735__auto___46079 = cljs.core.seq(seq__45507_46029);
if(temp__5735__auto___46079){
var seq__45507_46081__$1 = temp__5735__auto___46079;
if(cljs.core.chunked_seq_QMARK_(seq__45507_46081__$1)){
var c__4609__auto___46082 = cljs.core.chunk_first(seq__45507_46081__$1);
var G__46083 = cljs.core.chunk_rest(seq__45507_46081__$1);
var G__46084 = c__4609__auto___46082;
var G__46085 = cljs.core.count(c__4609__auto___46082);
var G__46086 = (0);
seq__45507_46029 = G__46083;
chunk__45508_46030 = G__46084;
count__45509_46031 = G__46085;
i__45510_46032 = G__46086;
continue;
} else {
var vec__45600_46089 = cljs.core.first(seq__45507_46081__$1);
var column_46090 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45600_46089,(0),null);
var column_info_46091 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45600_46089,(1),null);
var seq__45603_46092 = cljs.core.seq(column_info_46091);
var chunk__45604_46093 = null;
var count__45605_46094 = (0);
var i__45606_46095 = (0);
while(true){
if((i__45606_46095 < count__45605_46094)){
var map__45614_46097 = chunk__45604_46093.cljs$core$IIndexed$_nth$arity$2(null,i__45606_46095);
var map__45614_46098__$1 = (((((!((map__45614_46097 == null))))?(((((map__45614_46097.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45614_46097.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45614_46097):map__45614_46097);
var gline_46099 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45614_46098__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46100 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45614_46098__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46101 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45614_46098__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46099], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45603_46092,chunk__45604_46093,count__45605_46094,i__45606_46095,seq__45507_46029,chunk__45508_46030,count__45509_46031,i__45510_46032,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45614_46097,map__45614_46098__$1,gline_46099,gcol_46100,name_46101,vec__45600_46089,column_46090,column_info_46091,seq__45507_46081__$1,temp__5735__auto___46079,vec__45504_46026,line_46027,columns_46028,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46100], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46027,new cljs.core.Keyword(null,"col","col",-1959363084),column_46090,new cljs.core.Keyword(null,"name","name",1843675177),name_46101], null));
});})(seq__45603_46092,chunk__45604_46093,count__45605_46094,i__45606_46095,seq__45507_46029,chunk__45508_46030,count__45509_46031,i__45510_46032,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45614_46097,map__45614_46098__$1,gline_46099,gcol_46100,name_46101,vec__45600_46089,column_46090,column_info_46091,seq__45507_46081__$1,temp__5735__auto___46079,vec__45504_46026,line_46027,columns_46028,inverted))
,cljs.core.sorted_map()));


var G__46109 = seq__45603_46092;
var G__46110 = chunk__45604_46093;
var G__46111 = count__45605_46094;
var G__46112 = (i__45606_46095 + (1));
seq__45603_46092 = G__46109;
chunk__45604_46093 = G__46110;
count__45605_46094 = G__46111;
i__45606_46095 = G__46112;
continue;
} else {
var temp__5735__auto___46113__$1 = cljs.core.seq(seq__45603_46092);
if(temp__5735__auto___46113__$1){
var seq__45603_46115__$1 = temp__5735__auto___46113__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45603_46115__$1)){
var c__4609__auto___46116 = cljs.core.chunk_first(seq__45603_46115__$1);
var G__46117 = cljs.core.chunk_rest(seq__45603_46115__$1);
var G__46118 = c__4609__auto___46116;
var G__46119 = cljs.core.count(c__4609__auto___46116);
var G__46120 = (0);
seq__45603_46092 = G__46117;
chunk__45604_46093 = G__46118;
count__45605_46094 = G__46119;
i__45606_46095 = G__46120;
continue;
} else {
var map__45621_46123 = cljs.core.first(seq__45603_46115__$1);
var map__45621_46124__$1 = (((((!((map__45621_46123 == null))))?(((((map__45621_46123.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45621_46123.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45621_46123):map__45621_46123);
var gline_46125 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45621_46124__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46126 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45621_46124__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46127 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45621_46124__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46125], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45603_46092,chunk__45604_46093,count__45605_46094,i__45606_46095,seq__45507_46029,chunk__45508_46030,count__45509_46031,i__45510_46032,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45621_46123,map__45621_46124__$1,gline_46125,gcol_46126,name_46127,seq__45603_46115__$1,temp__5735__auto___46113__$1,vec__45600_46089,column_46090,column_info_46091,seq__45507_46081__$1,temp__5735__auto___46079,vec__45504_46026,line_46027,columns_46028,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46126], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46027,new cljs.core.Keyword(null,"col","col",-1959363084),column_46090,new cljs.core.Keyword(null,"name","name",1843675177),name_46127], null));
});})(seq__45603_46092,chunk__45604_46093,count__45605_46094,i__45606_46095,seq__45507_46029,chunk__45508_46030,count__45509_46031,i__45510_46032,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45621_46123,map__45621_46124__$1,gline_46125,gcol_46126,name_46127,seq__45603_46115__$1,temp__5735__auto___46113__$1,vec__45600_46089,column_46090,column_info_46091,seq__45507_46081__$1,temp__5735__auto___46079,vec__45504_46026,line_46027,columns_46028,inverted))
,cljs.core.sorted_map()));


var G__46133 = cljs.core.next(seq__45603_46115__$1);
var G__46134 = null;
var G__46135 = (0);
var G__46136 = (0);
seq__45603_46092 = G__46133;
chunk__45604_46093 = G__46134;
count__45605_46094 = G__46135;
i__45606_46095 = G__46136;
continue;
}
} else {
}
}
break;
}


var G__46137 = cljs.core.next(seq__45507_46081__$1);
var G__46138 = null;
var G__46139 = (0);
var G__46140 = (0);
seq__45507_46029 = G__46137;
chunk__45508_46030 = G__46138;
count__45509_46031 = G__46139;
i__45510_46032 = G__46140;
continue;
}
} else {
}
}
break;
}


var G__46141 = seq__45247_46022;
var G__46142 = chunk__45248_46023;
var G__46143 = count__45249_46024;
var G__46144 = (i__45250_46025 + (1));
seq__45247_46022 = G__46141;
chunk__45248_46023 = G__46142;
count__45249_46024 = G__46143;
i__45250_46025 = G__46144;
continue;
} else {
var temp__5735__auto___46145 = cljs.core.seq(seq__45247_46022);
if(temp__5735__auto___46145){
var seq__45247_46146__$1 = temp__5735__auto___46145;
if(cljs.core.chunked_seq_QMARK_(seq__45247_46146__$1)){
var c__4609__auto___46152 = cljs.core.chunk_first(seq__45247_46146__$1);
var G__46153 = cljs.core.chunk_rest(seq__45247_46146__$1);
var G__46154 = c__4609__auto___46152;
var G__46155 = cljs.core.count(c__4609__auto___46152);
var G__46156 = (0);
seq__45247_46022 = G__46153;
chunk__45248_46023 = G__46154;
count__45249_46024 = G__46155;
i__45250_46025 = G__46156;
continue;
} else {
var vec__45629_46159 = cljs.core.first(seq__45247_46146__$1);
var line_46160 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45629_46159,(0),null);
var columns_46161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45629_46159,(1),null);
var seq__45633_46162 = cljs.core.seq(columns_46161);
var chunk__45636_46163 = null;
var count__45637_46164 = (0);
var i__45638_46165 = (0);
while(true){
if((i__45638_46165 < count__45637_46164)){
var vec__45702_46166 = chunk__45636_46163.cljs$core$IIndexed$_nth$arity$2(null,i__45638_46165);
var column_46167 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45702_46166,(0),null);
var column_info_46168 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45702_46166,(1),null);
var seq__45705_46169 = cljs.core.seq(column_info_46168);
var chunk__45706_46170 = null;
var count__45707_46171 = (0);
var i__45708_46172 = (0);
while(true){
if((i__45708_46172 < count__45707_46171)){
var map__45715_46173 = chunk__45706_46170.cljs$core$IIndexed$_nth$arity$2(null,i__45708_46172);
var map__45715_46174__$1 = (((((!((map__45715_46173 == null))))?(((((map__45715_46173.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45715_46173.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45715_46173):map__45715_46173);
var gline_46175 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45715_46174__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46176 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45715_46174__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46177 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45715_46174__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46175], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45705_46169,chunk__45706_46170,count__45707_46171,i__45708_46172,seq__45633_46162,chunk__45636_46163,count__45637_46164,i__45638_46165,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45715_46173,map__45715_46174__$1,gline_46175,gcol_46176,name_46177,vec__45702_46166,column_46167,column_info_46168,vec__45629_46159,line_46160,columns_46161,seq__45247_46146__$1,temp__5735__auto___46145,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46176], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46160,new cljs.core.Keyword(null,"col","col",-1959363084),column_46167,new cljs.core.Keyword(null,"name","name",1843675177),name_46177], null));
});})(seq__45705_46169,chunk__45706_46170,count__45707_46171,i__45708_46172,seq__45633_46162,chunk__45636_46163,count__45637_46164,i__45638_46165,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45715_46173,map__45715_46174__$1,gline_46175,gcol_46176,name_46177,vec__45702_46166,column_46167,column_info_46168,vec__45629_46159,line_46160,columns_46161,seq__45247_46146__$1,temp__5735__auto___46145,inverted))
,cljs.core.sorted_map()));


var G__46180 = seq__45705_46169;
var G__46181 = chunk__45706_46170;
var G__46182 = count__45707_46171;
var G__46183 = (i__45708_46172 + (1));
seq__45705_46169 = G__46180;
chunk__45706_46170 = G__46181;
count__45707_46171 = G__46182;
i__45708_46172 = G__46183;
continue;
} else {
var temp__5735__auto___46186__$1 = cljs.core.seq(seq__45705_46169);
if(temp__5735__auto___46186__$1){
var seq__45705_46187__$1 = temp__5735__auto___46186__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45705_46187__$1)){
var c__4609__auto___46188 = cljs.core.chunk_first(seq__45705_46187__$1);
var G__46189 = cljs.core.chunk_rest(seq__45705_46187__$1);
var G__46190 = c__4609__auto___46188;
var G__46191 = cljs.core.count(c__4609__auto___46188);
var G__46192 = (0);
seq__45705_46169 = G__46189;
chunk__45706_46170 = G__46190;
count__45707_46171 = G__46191;
i__45708_46172 = G__46192;
continue;
} else {
var map__45718_46193 = cljs.core.first(seq__45705_46187__$1);
var map__45718_46194__$1 = (((((!((map__45718_46193 == null))))?(((((map__45718_46193.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45718_46193.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45718_46193):map__45718_46193);
var gline_46195 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45718_46194__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46196 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45718_46194__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46197 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45718_46194__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46195], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45705_46169,chunk__45706_46170,count__45707_46171,i__45708_46172,seq__45633_46162,chunk__45636_46163,count__45637_46164,i__45638_46165,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45718_46193,map__45718_46194__$1,gline_46195,gcol_46196,name_46197,seq__45705_46187__$1,temp__5735__auto___46186__$1,vec__45702_46166,column_46167,column_info_46168,vec__45629_46159,line_46160,columns_46161,seq__45247_46146__$1,temp__5735__auto___46145,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46196], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46160,new cljs.core.Keyword(null,"col","col",-1959363084),column_46167,new cljs.core.Keyword(null,"name","name",1843675177),name_46197], null));
});})(seq__45705_46169,chunk__45706_46170,count__45707_46171,i__45708_46172,seq__45633_46162,chunk__45636_46163,count__45637_46164,i__45638_46165,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45718_46193,map__45718_46194__$1,gline_46195,gcol_46196,name_46197,seq__45705_46187__$1,temp__5735__auto___46186__$1,vec__45702_46166,column_46167,column_info_46168,vec__45629_46159,line_46160,columns_46161,seq__45247_46146__$1,temp__5735__auto___46145,inverted))
,cljs.core.sorted_map()));


var G__46199 = cljs.core.next(seq__45705_46187__$1);
var G__46200 = null;
var G__46201 = (0);
var G__46202 = (0);
seq__45705_46169 = G__46199;
chunk__45706_46170 = G__46200;
count__45707_46171 = G__46201;
i__45708_46172 = G__46202;
continue;
}
} else {
}
}
break;
}


var G__46204 = seq__45633_46162;
var G__46205 = chunk__45636_46163;
var G__46206 = count__45637_46164;
var G__46207 = (i__45638_46165 + (1));
seq__45633_46162 = G__46204;
chunk__45636_46163 = G__46205;
count__45637_46164 = G__46206;
i__45638_46165 = G__46207;
continue;
} else {
var temp__5735__auto___46208__$1 = cljs.core.seq(seq__45633_46162);
if(temp__5735__auto___46208__$1){
var seq__45633_46209__$1 = temp__5735__auto___46208__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45633_46209__$1)){
var c__4609__auto___46210 = cljs.core.chunk_first(seq__45633_46209__$1);
var G__46211 = cljs.core.chunk_rest(seq__45633_46209__$1);
var G__46212 = c__4609__auto___46210;
var G__46213 = cljs.core.count(c__4609__auto___46210);
var G__46214 = (0);
seq__45633_46162 = G__46211;
chunk__45636_46163 = G__46212;
count__45637_46164 = G__46213;
i__45638_46165 = G__46214;
continue;
} else {
var vec__45720_46215 = cljs.core.first(seq__45633_46209__$1);
var column_46216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45720_46215,(0),null);
var column_info_46217 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45720_46215,(1),null);
var seq__45723_46218 = cljs.core.seq(column_info_46217);
var chunk__45724_46219 = null;
var count__45725_46220 = (0);
var i__45726_46221 = (0);
while(true){
if((i__45726_46221 < count__45725_46220)){
var map__45737_46222 = chunk__45724_46219.cljs$core$IIndexed$_nth$arity$2(null,i__45726_46221);
var map__45737_46223__$1 = (((((!((map__45737_46222 == null))))?(((((map__45737_46222.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45737_46222.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45737_46222):map__45737_46222);
var gline_46224 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45737_46223__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46225 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45737_46223__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46226 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45737_46223__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46224], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45723_46218,chunk__45724_46219,count__45725_46220,i__45726_46221,seq__45633_46162,chunk__45636_46163,count__45637_46164,i__45638_46165,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45737_46222,map__45737_46223__$1,gline_46224,gcol_46225,name_46226,vec__45720_46215,column_46216,column_info_46217,seq__45633_46209__$1,temp__5735__auto___46208__$1,vec__45629_46159,line_46160,columns_46161,seq__45247_46146__$1,temp__5735__auto___46145,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46225], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46160,new cljs.core.Keyword(null,"col","col",-1959363084),column_46216,new cljs.core.Keyword(null,"name","name",1843675177),name_46226], null));
});})(seq__45723_46218,chunk__45724_46219,count__45725_46220,i__45726_46221,seq__45633_46162,chunk__45636_46163,count__45637_46164,i__45638_46165,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45737_46222,map__45737_46223__$1,gline_46224,gcol_46225,name_46226,vec__45720_46215,column_46216,column_info_46217,seq__45633_46209__$1,temp__5735__auto___46208__$1,vec__45629_46159,line_46160,columns_46161,seq__45247_46146__$1,temp__5735__auto___46145,inverted))
,cljs.core.sorted_map()));


var G__46235 = seq__45723_46218;
var G__46236 = chunk__45724_46219;
var G__46237 = count__45725_46220;
var G__46238 = (i__45726_46221 + (1));
seq__45723_46218 = G__46235;
chunk__45724_46219 = G__46236;
count__45725_46220 = G__46237;
i__45726_46221 = G__46238;
continue;
} else {
var temp__5735__auto___46239__$2 = cljs.core.seq(seq__45723_46218);
if(temp__5735__auto___46239__$2){
var seq__45723_46240__$1 = temp__5735__auto___46239__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45723_46240__$1)){
var c__4609__auto___46241 = cljs.core.chunk_first(seq__45723_46240__$1);
var G__46242 = cljs.core.chunk_rest(seq__45723_46240__$1);
var G__46243 = c__4609__auto___46241;
var G__46244 = cljs.core.count(c__4609__auto___46241);
var G__46245 = (0);
seq__45723_46218 = G__46242;
chunk__45724_46219 = G__46243;
count__45725_46220 = G__46244;
i__45726_46221 = G__46245;
continue;
} else {
var map__45741_46246 = cljs.core.first(seq__45723_46240__$1);
var map__45741_46247__$1 = (((((!((map__45741_46246 == null))))?(((((map__45741_46246.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45741_46246.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45741_46246):map__45741_46246);
var gline_46248 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45741_46247__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46249 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45741_46247__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46250 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45741_46247__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46248], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45723_46218,chunk__45724_46219,count__45725_46220,i__45726_46221,seq__45633_46162,chunk__45636_46163,count__45637_46164,i__45638_46165,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45741_46246,map__45741_46247__$1,gline_46248,gcol_46249,name_46250,seq__45723_46240__$1,temp__5735__auto___46239__$2,vec__45720_46215,column_46216,column_info_46217,seq__45633_46209__$1,temp__5735__auto___46208__$1,vec__45629_46159,line_46160,columns_46161,seq__45247_46146__$1,temp__5735__auto___46145,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46249], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46160,new cljs.core.Keyword(null,"col","col",-1959363084),column_46216,new cljs.core.Keyword(null,"name","name",1843675177),name_46250], null));
});})(seq__45723_46218,chunk__45724_46219,count__45725_46220,i__45726_46221,seq__45633_46162,chunk__45636_46163,count__45637_46164,i__45638_46165,seq__45247_46022,chunk__45248_46023,count__45249_46024,i__45250_46025,map__45741_46246,map__45741_46247__$1,gline_46248,gcol_46249,name_46250,seq__45723_46240__$1,temp__5735__auto___46239__$2,vec__45720_46215,column_46216,column_info_46217,seq__45633_46209__$1,temp__5735__auto___46208__$1,vec__45629_46159,line_46160,columns_46161,seq__45247_46146__$1,temp__5735__auto___46145,inverted))
,cljs.core.sorted_map()));


var G__46252 = cljs.core.next(seq__45723_46240__$1);
var G__46253 = null;
var G__46254 = (0);
var G__46255 = (0);
seq__45723_46218 = G__46252;
chunk__45724_46219 = G__46253;
count__45725_46220 = G__46254;
i__45726_46221 = G__46255;
continue;
}
} else {
}
}
break;
}


var G__46256 = cljs.core.next(seq__45633_46209__$1);
var G__46257 = null;
var G__46258 = (0);
var G__46259 = (0);
seq__45633_46162 = G__46256;
chunk__45636_46163 = G__46257;
count__45637_46164 = G__46258;
i__45638_46165 = G__46259;
continue;
}
} else {
}
}
break;
}


var G__46260 = cljs.core.next(seq__45247_46146__$1);
var G__46261 = null;
var G__46262 = (0);
var G__46263 = (0);
seq__45247_46022 = G__46260;
chunk__45248_46023 = G__46261;
count__45249_46024 = G__46262;
i__45250_46025 = G__46263;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
