goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__44577){
var vec__44578 = p__44577;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44578,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44578,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__44584 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44584,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44584,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44584,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44584,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44584,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__44589 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44589,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44589,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44589,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44589,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44589,(4),null);
var vec__44592 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44592,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44592,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44592,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44592,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44592,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__44596 = segmap;
var map__44596__$1 = (((((!((map__44596 == null))))?(((((map__44596.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44596.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44596):map__44596);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44596__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44596__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44596__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44596__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44596__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__44616 = arguments.length;
switch (G__44616) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44632 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45749 = cljs.core.next(segs__$1);
var G__45750 = nrelseg;
var G__45751 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45749;
relseg__$1 = G__45750;
result__$1 = G__45751;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44632,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44632,(1),null);
var G__45752 = (gline + (1));
var G__45753 = cljs.core.next(lines__$1);
var G__45754 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45755 = result__$1;
gline = G__45752;
lines__$1 = G__45753;
relseg = G__45754;
result = G__45755;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__44641 = segmap;
var map__44641__$1 = (((((!((map__44641 == null))))?(((((map__44641.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44641.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44641):map__44641);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44641__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44641__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44641__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44641__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44641__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__44640_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__44640_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__44652 = arguments.length;
switch (G__44652) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__44661 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__45764 = cljs.core.next(segs__$1);
var G__45765 = nrelseg;
var G__45766 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__45764;
relseg__$1 = G__45765;
result__$1 = G__45766;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44661,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44661,(1),null);
var G__45771 = (gline + (1));
var G__45772 = cljs.core.next(lines__$1);
var G__45773 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__45774 = result__$1;
gline = G__45771;
lines__$1 = G__45772;
relseg = G__45773;
result = G__45774;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44671){
var vec__44672 = p__44671;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44672,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44672,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44672,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44672,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44672,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__44675){
var vec__44679 = p__44675;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44679,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44679,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44679,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44679,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44679,(4),null);
var seg = vec__44679;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__44686){
var vec__44687 = p__44686;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44687,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44687,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44687,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44687,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44687,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__44701 = cljs.core.seq(infos);
var chunk__44702 = null;
var count__44703 = (0);
var i__44704 = (0);
while(true){
if((i__44704 < count__44703)){
var info = chunk__44702.cljs$core$IIndexed$_nth$arity$2(null,i__44704);
var segv_45792 = info__GT_segv(info,source_idx,line,col);
var gline_45793 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45794 = cljs.core.count(cljs.core.deref(lines));
if((gline_45793 > (lc_45794 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44701,chunk__44702,count__44703,i__44704,segv_45792,gline_45793,lc_45794,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45793 - (lc_45794 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45792], null));
});})(seq__44701,chunk__44702,count__44703,i__44704,segv_45792,gline_45793,lc_45794,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44701,chunk__44702,count__44703,i__44704,segv_45792,gline_45793,lc_45794,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45793], null),cljs.core.conj,segv_45792);
});})(seq__44701,chunk__44702,count__44703,i__44704,segv_45792,gline_45793,lc_45794,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45797 = seq__44701;
var G__45798 = chunk__44702;
var G__45799 = count__44703;
var G__45800 = (i__44704 + (1));
seq__44701 = G__45797;
chunk__44702 = G__45798;
count__44703 = G__45799;
i__44704 = G__45800;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__44701);
if(temp__5735__auto__){
var seq__44701__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44701__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__44701__$1);
var G__45803 = cljs.core.chunk_rest(seq__44701__$1);
var G__45804 = c__4609__auto__;
var G__45805 = cljs.core.count(c__4609__auto__);
var G__45806 = (0);
seq__44701 = G__45803;
chunk__44702 = G__45804;
count__44703 = G__45805;
i__44704 = G__45806;
continue;
} else {
var info = cljs.core.first(seq__44701__$1);
var segv_45807 = info__GT_segv(info,source_idx,line,col);
var gline_45808 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_45809 = cljs.core.count(cljs.core.deref(lines));
if((gline_45808 > (lc_45809 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44701,chunk__44702,count__44703,i__44704,segv_45807,gline_45808,lc_45809,info,seq__44701__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_45808 - (lc_45809 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_45807], null));
});})(seq__44701,chunk__44702,count__44703,i__44704,segv_45807,gline_45808,lc_45809,info,seq__44701__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__44701,chunk__44702,count__44703,i__44704,segv_45807,gline_45808,lc_45809,info,seq__44701__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_45808], null),cljs.core.conj,segv_45807);
});})(seq__44701,chunk__44702,count__44703,i__44704,segv_45807,gline_45808,lc_45809,info,seq__44701__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__45814 = cljs.core.next(seq__44701__$1);
var G__45815 = null;
var G__45816 = (0);
var G__45817 = (0);
seq__44701 = G__45814;
chunk__44702 = G__45815;
count__44703 = G__45816;
i__44704 = G__45817;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__44719_45818 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__44720_45819 = null;
var count__44721_45820 = (0);
var i__44722_45821 = (0);
while(true){
if((i__44722_45821 < count__44721_45820)){
var vec__44961_45823 = chunk__44720_45819.cljs$core$IIndexed$_nth$arity$2(null,i__44722_45821);
var source_idx_45824 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44961_45823,(0),null);
var vec__44964_45825 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44961_45823,(1),null);
var __45826 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44964_45825,(0),null);
var lines_45827__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44964_45825,(1),null);
var seq__44967_45828 = cljs.core.seq(lines_45827__$1);
var chunk__44968_45829 = null;
var count__44969_45830 = (0);
var i__44970_45831 = (0);
while(true){
if((i__44970_45831 < count__44969_45830)){
var vec__45033_45832 = chunk__44968_45829.cljs$core$IIndexed$_nth$arity$2(null,i__44970_45831);
var line_45833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45033_45832,(0),null);
var cols_45834 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45033_45832,(1),null);
var seq__45036_45835 = cljs.core.seq(cols_45834);
var chunk__45037_45836 = null;
var count__45038_45837 = (0);
var i__45039_45838 = (0);
while(true){
if((i__45039_45838 < count__45038_45837)){
var vec__45056_45839 = chunk__45037_45836.cljs$core$IIndexed$_nth$arity$2(null,i__45039_45838);
var col_45840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45056_45839,(0),null);
var infos_45841 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45056_45839,(1),null);
encode_cols(infos_45841,source_idx_45824,line_45833,col_45840);


var G__45845 = seq__45036_45835;
var G__45846 = chunk__45037_45836;
var G__45847 = count__45038_45837;
var G__45848 = (i__45039_45838 + (1));
seq__45036_45835 = G__45845;
chunk__45037_45836 = G__45846;
count__45038_45837 = G__45847;
i__45039_45838 = G__45848;
continue;
} else {
var temp__5735__auto___45849 = cljs.core.seq(seq__45036_45835);
if(temp__5735__auto___45849){
var seq__45036_45850__$1 = temp__5735__auto___45849;
if(cljs.core.chunked_seq_QMARK_(seq__45036_45850__$1)){
var c__4609__auto___45851 = cljs.core.chunk_first(seq__45036_45850__$1);
var G__45852 = cljs.core.chunk_rest(seq__45036_45850__$1);
var G__45853 = c__4609__auto___45851;
var G__45854 = cljs.core.count(c__4609__auto___45851);
var G__45855 = (0);
seq__45036_45835 = G__45852;
chunk__45037_45836 = G__45853;
count__45038_45837 = G__45854;
i__45039_45838 = G__45855;
continue;
} else {
var vec__45064_45856 = cljs.core.first(seq__45036_45850__$1);
var col_45857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45064_45856,(0),null);
var infos_45858 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45064_45856,(1),null);
encode_cols(infos_45858,source_idx_45824,line_45833,col_45857);


var G__45859 = cljs.core.next(seq__45036_45850__$1);
var G__45860 = null;
var G__45861 = (0);
var G__45862 = (0);
seq__45036_45835 = G__45859;
chunk__45037_45836 = G__45860;
count__45038_45837 = G__45861;
i__45039_45838 = G__45862;
continue;
}
} else {
}
}
break;
}


var G__45863 = seq__44967_45828;
var G__45864 = chunk__44968_45829;
var G__45865 = count__44969_45830;
var G__45866 = (i__44970_45831 + (1));
seq__44967_45828 = G__45863;
chunk__44968_45829 = G__45864;
count__44969_45830 = G__45865;
i__44970_45831 = G__45866;
continue;
} else {
var temp__5735__auto___45867 = cljs.core.seq(seq__44967_45828);
if(temp__5735__auto___45867){
var seq__44967_45868__$1 = temp__5735__auto___45867;
if(cljs.core.chunked_seq_QMARK_(seq__44967_45868__$1)){
var c__4609__auto___45869 = cljs.core.chunk_first(seq__44967_45868__$1);
var G__45870 = cljs.core.chunk_rest(seq__44967_45868__$1);
var G__45871 = c__4609__auto___45869;
var G__45872 = cljs.core.count(c__4609__auto___45869);
var G__45873 = (0);
seq__44967_45828 = G__45870;
chunk__44968_45829 = G__45871;
count__44969_45830 = G__45872;
i__44970_45831 = G__45873;
continue;
} else {
var vec__45072_45874 = cljs.core.first(seq__44967_45868__$1);
var line_45875 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45072_45874,(0),null);
var cols_45876 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45072_45874,(1),null);
var seq__45075_45877 = cljs.core.seq(cols_45876);
var chunk__45076_45878 = null;
var count__45077_45879 = (0);
var i__45078_45880 = (0);
while(true){
if((i__45078_45880 < count__45077_45879)){
var vec__45087_45881 = chunk__45076_45878.cljs$core$IIndexed$_nth$arity$2(null,i__45078_45880);
var col_45882 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45087_45881,(0),null);
var infos_45883 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45087_45881,(1),null);
encode_cols(infos_45883,source_idx_45824,line_45875,col_45882);


var G__45884 = seq__45075_45877;
var G__45885 = chunk__45076_45878;
var G__45886 = count__45077_45879;
var G__45887 = (i__45078_45880 + (1));
seq__45075_45877 = G__45884;
chunk__45076_45878 = G__45885;
count__45077_45879 = G__45886;
i__45078_45880 = G__45887;
continue;
} else {
var temp__5735__auto___45888__$1 = cljs.core.seq(seq__45075_45877);
if(temp__5735__auto___45888__$1){
var seq__45075_45889__$1 = temp__5735__auto___45888__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45075_45889__$1)){
var c__4609__auto___45890 = cljs.core.chunk_first(seq__45075_45889__$1);
var G__45891 = cljs.core.chunk_rest(seq__45075_45889__$1);
var G__45892 = c__4609__auto___45890;
var G__45893 = cljs.core.count(c__4609__auto___45890);
var G__45894 = (0);
seq__45075_45877 = G__45891;
chunk__45076_45878 = G__45892;
count__45077_45879 = G__45893;
i__45078_45880 = G__45894;
continue;
} else {
var vec__45099_45895 = cljs.core.first(seq__45075_45889__$1);
var col_45896 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45099_45895,(0),null);
var infos_45897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45099_45895,(1),null);
encode_cols(infos_45897,source_idx_45824,line_45875,col_45896);


var G__45898 = cljs.core.next(seq__45075_45889__$1);
var G__45899 = null;
var G__45900 = (0);
var G__45901 = (0);
seq__45075_45877 = G__45898;
chunk__45076_45878 = G__45899;
count__45077_45879 = G__45900;
i__45078_45880 = G__45901;
continue;
}
} else {
}
}
break;
}


var G__45902 = cljs.core.next(seq__44967_45868__$1);
var G__45903 = null;
var G__45904 = (0);
var G__45905 = (0);
seq__44967_45828 = G__45902;
chunk__44968_45829 = G__45903;
count__44969_45830 = G__45904;
i__44970_45831 = G__45905;
continue;
}
} else {
}
}
break;
}


var G__45906 = seq__44719_45818;
var G__45907 = chunk__44720_45819;
var G__45908 = count__44721_45820;
var G__45909 = (i__44722_45821 + (1));
seq__44719_45818 = G__45906;
chunk__44720_45819 = G__45907;
count__44721_45820 = G__45908;
i__44722_45821 = G__45909;
continue;
} else {
var temp__5735__auto___45910 = cljs.core.seq(seq__44719_45818);
if(temp__5735__auto___45910){
var seq__44719_45911__$1 = temp__5735__auto___45910;
if(cljs.core.chunked_seq_QMARK_(seq__44719_45911__$1)){
var c__4609__auto___45912 = cljs.core.chunk_first(seq__44719_45911__$1);
var G__45913 = cljs.core.chunk_rest(seq__44719_45911__$1);
var G__45914 = c__4609__auto___45912;
var G__45915 = cljs.core.count(c__4609__auto___45912);
var G__45916 = (0);
seq__44719_45818 = G__45913;
chunk__44720_45819 = G__45914;
count__44721_45820 = G__45915;
i__44722_45821 = G__45916;
continue;
} else {
var vec__45107_45917 = cljs.core.first(seq__44719_45911__$1);
var source_idx_45918 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45107_45917,(0),null);
var vec__45110_45919 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45107_45917,(1),null);
var __45920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45110_45919,(0),null);
var lines_45921__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45110_45919,(1),null);
var seq__45113_45922 = cljs.core.seq(lines_45921__$1);
var chunk__45114_45923 = null;
var count__45115_45924 = (0);
var i__45116_45925 = (0);
while(true){
if((i__45116_45925 < count__45115_45924)){
var vec__45177_45926 = chunk__45114_45923.cljs$core$IIndexed$_nth$arity$2(null,i__45116_45925);
var line_45927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45177_45926,(0),null);
var cols_45928 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45177_45926,(1),null);
var seq__45180_45929 = cljs.core.seq(cols_45928);
var chunk__45181_45930 = null;
var count__45182_45931 = (0);
var i__45183_45932 = (0);
while(true){
if((i__45183_45932 < count__45182_45931)){
var vec__45190_45933 = chunk__45181_45930.cljs$core$IIndexed$_nth$arity$2(null,i__45183_45932);
var col_45934 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45190_45933,(0),null);
var infos_45935 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45190_45933,(1),null);
encode_cols(infos_45935,source_idx_45918,line_45927,col_45934);


var G__45937 = seq__45180_45929;
var G__45938 = chunk__45181_45930;
var G__45939 = count__45182_45931;
var G__45940 = (i__45183_45932 + (1));
seq__45180_45929 = G__45937;
chunk__45181_45930 = G__45938;
count__45182_45931 = G__45939;
i__45183_45932 = G__45940;
continue;
} else {
var temp__5735__auto___45941__$1 = cljs.core.seq(seq__45180_45929);
if(temp__5735__auto___45941__$1){
var seq__45180_45942__$1 = temp__5735__auto___45941__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45180_45942__$1)){
var c__4609__auto___45943 = cljs.core.chunk_first(seq__45180_45942__$1);
var G__45944 = cljs.core.chunk_rest(seq__45180_45942__$1);
var G__45945 = c__4609__auto___45943;
var G__45946 = cljs.core.count(c__4609__auto___45943);
var G__45947 = (0);
seq__45180_45929 = G__45944;
chunk__45181_45930 = G__45945;
count__45182_45931 = G__45946;
i__45183_45932 = G__45947;
continue;
} else {
var vec__45195_45948 = cljs.core.first(seq__45180_45942__$1);
var col_45949 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45195_45948,(0),null);
var infos_45950 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45195_45948,(1),null);
encode_cols(infos_45950,source_idx_45918,line_45927,col_45949);


var G__45951 = cljs.core.next(seq__45180_45942__$1);
var G__45952 = null;
var G__45953 = (0);
var G__45954 = (0);
seq__45180_45929 = G__45951;
chunk__45181_45930 = G__45952;
count__45182_45931 = G__45953;
i__45183_45932 = G__45954;
continue;
}
} else {
}
}
break;
}


var G__45955 = seq__45113_45922;
var G__45956 = chunk__45114_45923;
var G__45957 = count__45115_45924;
var G__45958 = (i__45116_45925 + (1));
seq__45113_45922 = G__45955;
chunk__45114_45923 = G__45956;
count__45115_45924 = G__45957;
i__45116_45925 = G__45958;
continue;
} else {
var temp__5735__auto___45959__$1 = cljs.core.seq(seq__45113_45922);
if(temp__5735__auto___45959__$1){
var seq__45113_45960__$1 = temp__5735__auto___45959__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45113_45960__$1)){
var c__4609__auto___45961 = cljs.core.chunk_first(seq__45113_45960__$1);
var G__45962 = cljs.core.chunk_rest(seq__45113_45960__$1);
var G__45963 = c__4609__auto___45961;
var G__45964 = cljs.core.count(c__4609__auto___45961);
var G__45965 = (0);
seq__45113_45922 = G__45962;
chunk__45114_45923 = G__45963;
count__45115_45924 = G__45964;
i__45116_45925 = G__45965;
continue;
} else {
var vec__45204_45966 = cljs.core.first(seq__45113_45960__$1);
var line_45967 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45204_45966,(0),null);
var cols_45968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45204_45966,(1),null);
var seq__45207_45969 = cljs.core.seq(cols_45968);
var chunk__45208_45970 = null;
var count__45209_45971 = (0);
var i__45210_45972 = (0);
while(true){
if((i__45210_45972 < count__45209_45971)){
var vec__45222_45973 = chunk__45208_45970.cljs$core$IIndexed$_nth$arity$2(null,i__45210_45972);
var col_45974 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45222_45973,(0),null);
var infos_45975 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45222_45973,(1),null);
encode_cols(infos_45975,source_idx_45918,line_45967,col_45974);


var G__45976 = seq__45207_45969;
var G__45977 = chunk__45208_45970;
var G__45978 = count__45209_45971;
var G__45979 = (i__45210_45972 + (1));
seq__45207_45969 = G__45976;
chunk__45208_45970 = G__45977;
count__45209_45971 = G__45978;
i__45210_45972 = G__45979;
continue;
} else {
var temp__5735__auto___45980__$2 = cljs.core.seq(seq__45207_45969);
if(temp__5735__auto___45980__$2){
var seq__45207_45981__$1 = temp__5735__auto___45980__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45207_45981__$1)){
var c__4609__auto___45982 = cljs.core.chunk_first(seq__45207_45981__$1);
var G__45983 = cljs.core.chunk_rest(seq__45207_45981__$1);
var G__45984 = c__4609__auto___45982;
var G__45985 = cljs.core.count(c__4609__auto___45982);
var G__45986 = (0);
seq__45207_45969 = G__45983;
chunk__45208_45970 = G__45984;
count__45209_45971 = G__45985;
i__45210_45972 = G__45986;
continue;
} else {
var vec__45225_45987 = cljs.core.first(seq__45207_45981__$1);
var col_45988 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45225_45987,(0),null);
var infos_45989 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45225_45987,(1),null);
encode_cols(infos_45989,source_idx_45918,line_45967,col_45988);


var G__45990 = cljs.core.next(seq__45207_45981__$1);
var G__45991 = null;
var G__45992 = (0);
var G__45993 = (0);
seq__45207_45969 = G__45990;
chunk__45208_45970 = G__45991;
count__45209_45971 = G__45992;
i__45210_45972 = G__45993;
continue;
}
} else {
}
}
break;
}


var G__45994 = cljs.core.next(seq__45113_45960__$1);
var G__45995 = null;
var G__45996 = (0);
var G__45997 = (0);
seq__45113_45922 = G__45994;
chunk__45114_45923 = G__45995;
count__45115_45924 = G__45996;
i__45116_45925 = G__45997;
continue;
}
} else {
}
}
break;
}


var G__45998 = cljs.core.next(seq__44719_45911__$1);
var G__45999 = null;
var G__46000 = (0);
var G__46001 = (0);
seq__44719_45818 = G__45998;
chunk__44720_45819 = G__45999;
count__44721_45820 = G__46000;
i__44722_45821 = G__46001;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__45228 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__44690_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__44690_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__44691_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__44691_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__44692_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__44692_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__45229 = G__45228;
var G__45230_46002 = G__45229;
var G__45231_46003 = "sourcesContent";
var G__45232_46004 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__45230_46002,G__45231_46003,G__45232_46004);

return G__45229;
} else {
return G__45228;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__45233 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45233,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45233,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__45236 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45236,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45236,(1),null);
var G__46009 = cljs.core.next(col_map_seq);
var G__46010 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__45236,col,infos,vec__45233,line,col_map){
return (function (v,p__45239){
var map__45240 = p__45239;
var map__45240__$1 = (((((!((map__45240 == null))))?(((((map__45240.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45240.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45240):map__45240);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45240__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45240__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__45236,col,infos,vec__45233,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__46009;
new_cols = G__46010;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__46013 = cljs.core.next(line_map_seq);
var G__46014 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__46013;
new_lines = G__46014;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__45247_46017 = cljs.core.seq(reverse_map);
var chunk__45248_46018 = null;
var count__45249_46019 = (0);
var i__45250_46020 = (0);
while(true){
if((i__45250_46020 < count__45249_46019)){
var vec__45492_46021 = chunk__45248_46018.cljs$core$IIndexed$_nth$arity$2(null,i__45250_46020);
var line_46022 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45492_46021,(0),null);
var columns_46023 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45492_46021,(1),null);
var seq__45499_46024 = cljs.core.seq(columns_46023);
var chunk__45500_46025 = null;
var count__45501_46026 = (0);
var i__45502_46027 = (0);
while(true){
if((i__45502_46027 < count__45501_46026)){
var vec__45560_46028 = chunk__45500_46025.cljs$core$IIndexed$_nth$arity$2(null,i__45502_46027);
var column_46029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45560_46028,(0),null);
var column_info_46030 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45560_46028,(1),null);
var seq__45566_46031 = cljs.core.seq(column_info_46030);
var chunk__45567_46032 = null;
var count__45568_46033 = (0);
var i__45569_46034 = (0);
while(true){
if((i__45569_46034 < count__45568_46033)){
var map__45582_46035 = chunk__45567_46032.cljs$core$IIndexed$_nth$arity$2(null,i__45569_46034);
var map__45582_46036__$1 = (((((!((map__45582_46035 == null))))?(((((map__45582_46035.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45582_46035.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45582_46035):map__45582_46035);
var gline_46037 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45582_46036__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46038 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45582_46036__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46039 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45582_46036__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46037], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45566_46031,chunk__45567_46032,count__45568_46033,i__45569_46034,seq__45499_46024,chunk__45500_46025,count__45501_46026,i__45502_46027,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45582_46035,map__45582_46036__$1,gline_46037,gcol_46038,name_46039,vec__45560_46028,column_46029,column_info_46030,vec__45492_46021,line_46022,columns_46023,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46038], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46022,new cljs.core.Keyword(null,"col","col",-1959363084),column_46029,new cljs.core.Keyword(null,"name","name",1843675177),name_46039], null));
});})(seq__45566_46031,chunk__45567_46032,count__45568_46033,i__45569_46034,seq__45499_46024,chunk__45500_46025,count__45501_46026,i__45502_46027,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45582_46035,map__45582_46036__$1,gline_46037,gcol_46038,name_46039,vec__45560_46028,column_46029,column_info_46030,vec__45492_46021,line_46022,columns_46023,inverted))
,cljs.core.sorted_map()));


var G__46044 = seq__45566_46031;
var G__46045 = chunk__45567_46032;
var G__46046 = count__45568_46033;
var G__46047 = (i__45569_46034 + (1));
seq__45566_46031 = G__46044;
chunk__45567_46032 = G__46045;
count__45568_46033 = G__46046;
i__45569_46034 = G__46047;
continue;
} else {
var temp__5735__auto___46048 = cljs.core.seq(seq__45566_46031);
if(temp__5735__auto___46048){
var seq__45566_46049__$1 = temp__5735__auto___46048;
if(cljs.core.chunked_seq_QMARK_(seq__45566_46049__$1)){
var c__4609__auto___46050 = cljs.core.chunk_first(seq__45566_46049__$1);
var G__46051 = cljs.core.chunk_rest(seq__45566_46049__$1);
var G__46052 = c__4609__auto___46050;
var G__46053 = cljs.core.count(c__4609__auto___46050);
var G__46054 = (0);
seq__45566_46031 = G__46051;
chunk__45567_46032 = G__46052;
count__45568_46033 = G__46053;
i__45569_46034 = G__46054;
continue;
} else {
var map__45585_46055 = cljs.core.first(seq__45566_46049__$1);
var map__45585_46056__$1 = (((((!((map__45585_46055 == null))))?(((((map__45585_46055.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45585_46055.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45585_46055):map__45585_46055);
var gline_46057 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45585_46056__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46058 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45585_46056__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46059 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45585_46056__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46057], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45566_46031,chunk__45567_46032,count__45568_46033,i__45569_46034,seq__45499_46024,chunk__45500_46025,count__45501_46026,i__45502_46027,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45585_46055,map__45585_46056__$1,gline_46057,gcol_46058,name_46059,seq__45566_46049__$1,temp__5735__auto___46048,vec__45560_46028,column_46029,column_info_46030,vec__45492_46021,line_46022,columns_46023,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46058], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46022,new cljs.core.Keyword(null,"col","col",-1959363084),column_46029,new cljs.core.Keyword(null,"name","name",1843675177),name_46059], null));
});})(seq__45566_46031,chunk__45567_46032,count__45568_46033,i__45569_46034,seq__45499_46024,chunk__45500_46025,count__45501_46026,i__45502_46027,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45585_46055,map__45585_46056__$1,gline_46057,gcol_46058,name_46059,seq__45566_46049__$1,temp__5735__auto___46048,vec__45560_46028,column_46029,column_info_46030,vec__45492_46021,line_46022,columns_46023,inverted))
,cljs.core.sorted_map()));


var G__46061 = cljs.core.next(seq__45566_46049__$1);
var G__46062 = null;
var G__46063 = (0);
var G__46064 = (0);
seq__45566_46031 = G__46061;
chunk__45567_46032 = G__46062;
count__45568_46033 = G__46063;
i__45569_46034 = G__46064;
continue;
}
} else {
}
}
break;
}


var G__46065 = seq__45499_46024;
var G__46066 = chunk__45500_46025;
var G__46067 = count__45501_46026;
var G__46068 = (i__45502_46027 + (1));
seq__45499_46024 = G__46065;
chunk__45500_46025 = G__46066;
count__45501_46026 = G__46067;
i__45502_46027 = G__46068;
continue;
} else {
var temp__5735__auto___46069 = cljs.core.seq(seq__45499_46024);
if(temp__5735__auto___46069){
var seq__45499_46070__$1 = temp__5735__auto___46069;
if(cljs.core.chunked_seq_QMARK_(seq__45499_46070__$1)){
var c__4609__auto___46071 = cljs.core.chunk_first(seq__45499_46070__$1);
var G__46072 = cljs.core.chunk_rest(seq__45499_46070__$1);
var G__46073 = c__4609__auto___46071;
var G__46074 = cljs.core.count(c__4609__auto___46071);
var G__46075 = (0);
seq__45499_46024 = G__46072;
chunk__45500_46025 = G__46073;
count__45501_46026 = G__46074;
i__45502_46027 = G__46075;
continue;
} else {
var vec__45596_46076 = cljs.core.first(seq__45499_46070__$1);
var column_46077 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45596_46076,(0),null);
var column_info_46078 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45596_46076,(1),null);
var seq__45599_46080 = cljs.core.seq(column_info_46078);
var chunk__45600_46081 = null;
var count__45601_46082 = (0);
var i__45602_46083 = (0);
while(true){
if((i__45602_46083 < count__45601_46082)){
var map__45611_46084 = chunk__45600_46081.cljs$core$IIndexed$_nth$arity$2(null,i__45602_46083);
var map__45611_46085__$1 = (((((!((map__45611_46084 == null))))?(((((map__45611_46084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45611_46084.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45611_46084):map__45611_46084);
var gline_46086 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45611_46085__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46087 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45611_46085__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46088 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45611_46085__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46086], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45599_46080,chunk__45600_46081,count__45601_46082,i__45602_46083,seq__45499_46024,chunk__45500_46025,count__45501_46026,i__45502_46027,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45611_46084,map__45611_46085__$1,gline_46086,gcol_46087,name_46088,vec__45596_46076,column_46077,column_info_46078,seq__45499_46070__$1,temp__5735__auto___46069,vec__45492_46021,line_46022,columns_46023,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46087], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46022,new cljs.core.Keyword(null,"col","col",-1959363084),column_46077,new cljs.core.Keyword(null,"name","name",1843675177),name_46088], null));
});})(seq__45599_46080,chunk__45600_46081,count__45601_46082,i__45602_46083,seq__45499_46024,chunk__45500_46025,count__45501_46026,i__45502_46027,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45611_46084,map__45611_46085__$1,gline_46086,gcol_46087,name_46088,vec__45596_46076,column_46077,column_info_46078,seq__45499_46070__$1,temp__5735__auto___46069,vec__45492_46021,line_46022,columns_46023,inverted))
,cljs.core.sorted_map()));


var G__46091 = seq__45599_46080;
var G__46092 = chunk__45600_46081;
var G__46093 = count__45601_46082;
var G__46094 = (i__45602_46083 + (1));
seq__45599_46080 = G__46091;
chunk__45600_46081 = G__46092;
count__45601_46082 = G__46093;
i__45602_46083 = G__46094;
continue;
} else {
var temp__5735__auto___46095__$1 = cljs.core.seq(seq__45599_46080);
if(temp__5735__auto___46095__$1){
var seq__45599_46096__$1 = temp__5735__auto___46095__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45599_46096__$1)){
var c__4609__auto___46097 = cljs.core.chunk_first(seq__45599_46096__$1);
var G__46098 = cljs.core.chunk_rest(seq__45599_46096__$1);
var G__46099 = c__4609__auto___46097;
var G__46100 = cljs.core.count(c__4609__auto___46097);
var G__46101 = (0);
seq__45599_46080 = G__46098;
chunk__45600_46081 = G__46099;
count__45601_46082 = G__46100;
i__45602_46083 = G__46101;
continue;
} else {
var map__45615_46102 = cljs.core.first(seq__45599_46096__$1);
var map__45615_46103__$1 = (((((!((map__45615_46102 == null))))?(((((map__45615_46102.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45615_46102.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45615_46102):map__45615_46102);
var gline_46104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45615_46103__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46105 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45615_46103__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46106 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45615_46103__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46104], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45599_46080,chunk__45600_46081,count__45601_46082,i__45602_46083,seq__45499_46024,chunk__45500_46025,count__45501_46026,i__45502_46027,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45615_46102,map__45615_46103__$1,gline_46104,gcol_46105,name_46106,seq__45599_46096__$1,temp__5735__auto___46095__$1,vec__45596_46076,column_46077,column_info_46078,seq__45499_46070__$1,temp__5735__auto___46069,vec__45492_46021,line_46022,columns_46023,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46105], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46022,new cljs.core.Keyword(null,"col","col",-1959363084),column_46077,new cljs.core.Keyword(null,"name","name",1843675177),name_46106], null));
});})(seq__45599_46080,chunk__45600_46081,count__45601_46082,i__45602_46083,seq__45499_46024,chunk__45500_46025,count__45501_46026,i__45502_46027,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45615_46102,map__45615_46103__$1,gline_46104,gcol_46105,name_46106,seq__45599_46096__$1,temp__5735__auto___46095__$1,vec__45596_46076,column_46077,column_info_46078,seq__45499_46070__$1,temp__5735__auto___46069,vec__45492_46021,line_46022,columns_46023,inverted))
,cljs.core.sorted_map()));


var G__46115 = cljs.core.next(seq__45599_46096__$1);
var G__46116 = null;
var G__46117 = (0);
var G__46118 = (0);
seq__45599_46080 = G__46115;
chunk__45600_46081 = G__46116;
count__45601_46082 = G__46117;
i__45602_46083 = G__46118;
continue;
}
} else {
}
}
break;
}


var G__46119 = cljs.core.next(seq__45499_46070__$1);
var G__46120 = null;
var G__46121 = (0);
var G__46122 = (0);
seq__45499_46024 = G__46119;
chunk__45500_46025 = G__46120;
count__45501_46026 = G__46121;
i__45502_46027 = G__46122;
continue;
}
} else {
}
}
break;
}


var G__46125 = seq__45247_46017;
var G__46126 = chunk__45248_46018;
var G__46127 = count__45249_46019;
var G__46128 = (i__45250_46020 + (1));
seq__45247_46017 = G__46125;
chunk__45248_46018 = G__46126;
count__45249_46019 = G__46127;
i__45250_46020 = G__46128;
continue;
} else {
var temp__5735__auto___46130 = cljs.core.seq(seq__45247_46017);
if(temp__5735__auto___46130){
var seq__45247_46131__$1 = temp__5735__auto___46130;
if(cljs.core.chunked_seq_QMARK_(seq__45247_46131__$1)){
var c__4609__auto___46132 = cljs.core.chunk_first(seq__45247_46131__$1);
var G__46134 = cljs.core.chunk_rest(seq__45247_46131__$1);
var G__46135 = c__4609__auto___46132;
var G__46136 = cljs.core.count(c__4609__auto___46132);
var G__46137 = (0);
seq__45247_46017 = G__46134;
chunk__45248_46018 = G__46135;
count__45249_46019 = G__46136;
i__45250_46020 = G__46137;
continue;
} else {
var vec__45618_46138 = cljs.core.first(seq__45247_46131__$1);
var line_46139 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45618_46138,(0),null);
var columns_46140 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45618_46138,(1),null);
var seq__45622_46143 = cljs.core.seq(columns_46140);
var chunk__45623_46144 = null;
var count__45624_46145 = (0);
var i__45625_46146 = (0);
while(true){
if((i__45625_46146 < count__45624_46145)){
var vec__45694_46147 = chunk__45623_46144.cljs$core$IIndexed$_nth$arity$2(null,i__45625_46146);
var column_46148 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45694_46147,(0),null);
var column_info_46149 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45694_46147,(1),null);
var seq__45703_46151 = cljs.core.seq(column_info_46149);
var chunk__45704_46152 = null;
var count__45705_46153 = (0);
var i__45706_46154 = (0);
while(true){
if((i__45706_46154 < count__45705_46153)){
var map__45715_46156 = chunk__45704_46152.cljs$core$IIndexed$_nth$arity$2(null,i__45706_46154);
var map__45715_46157__$1 = (((((!((map__45715_46156 == null))))?(((((map__45715_46156.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45715_46156.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45715_46156):map__45715_46156);
var gline_46158 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45715_46157__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46159 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45715_46157__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46160 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45715_46157__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46158], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45703_46151,chunk__45704_46152,count__45705_46153,i__45706_46154,seq__45622_46143,chunk__45623_46144,count__45624_46145,i__45625_46146,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45715_46156,map__45715_46157__$1,gline_46158,gcol_46159,name_46160,vec__45694_46147,column_46148,column_info_46149,vec__45618_46138,line_46139,columns_46140,seq__45247_46131__$1,temp__5735__auto___46130,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46159], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46139,new cljs.core.Keyword(null,"col","col",-1959363084),column_46148,new cljs.core.Keyword(null,"name","name",1843675177),name_46160], null));
});})(seq__45703_46151,chunk__45704_46152,count__45705_46153,i__45706_46154,seq__45622_46143,chunk__45623_46144,count__45624_46145,i__45625_46146,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45715_46156,map__45715_46157__$1,gline_46158,gcol_46159,name_46160,vec__45694_46147,column_46148,column_info_46149,vec__45618_46138,line_46139,columns_46140,seq__45247_46131__$1,temp__5735__auto___46130,inverted))
,cljs.core.sorted_map()));


var G__46168 = seq__45703_46151;
var G__46169 = chunk__45704_46152;
var G__46170 = count__45705_46153;
var G__46171 = (i__45706_46154 + (1));
seq__45703_46151 = G__46168;
chunk__45704_46152 = G__46169;
count__45705_46153 = G__46170;
i__45706_46154 = G__46171;
continue;
} else {
var temp__5735__auto___46172__$1 = cljs.core.seq(seq__45703_46151);
if(temp__5735__auto___46172__$1){
var seq__45703_46175__$1 = temp__5735__auto___46172__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45703_46175__$1)){
var c__4609__auto___46176 = cljs.core.chunk_first(seq__45703_46175__$1);
var G__46177 = cljs.core.chunk_rest(seq__45703_46175__$1);
var G__46178 = c__4609__auto___46176;
var G__46179 = cljs.core.count(c__4609__auto___46176);
var G__46180 = (0);
seq__45703_46151 = G__46177;
chunk__45704_46152 = G__46178;
count__45705_46153 = G__46179;
i__45706_46154 = G__46180;
continue;
} else {
var map__45718_46181 = cljs.core.first(seq__45703_46175__$1);
var map__45718_46182__$1 = (((((!((map__45718_46181 == null))))?(((((map__45718_46181.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45718_46181.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45718_46181):map__45718_46181);
var gline_46183 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45718_46182__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46184 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45718_46182__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46185 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45718_46182__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46183], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45703_46151,chunk__45704_46152,count__45705_46153,i__45706_46154,seq__45622_46143,chunk__45623_46144,count__45624_46145,i__45625_46146,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45718_46181,map__45718_46182__$1,gline_46183,gcol_46184,name_46185,seq__45703_46175__$1,temp__5735__auto___46172__$1,vec__45694_46147,column_46148,column_info_46149,vec__45618_46138,line_46139,columns_46140,seq__45247_46131__$1,temp__5735__auto___46130,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46184], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46139,new cljs.core.Keyword(null,"col","col",-1959363084),column_46148,new cljs.core.Keyword(null,"name","name",1843675177),name_46185], null));
});})(seq__45703_46151,chunk__45704_46152,count__45705_46153,i__45706_46154,seq__45622_46143,chunk__45623_46144,count__45624_46145,i__45625_46146,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45718_46181,map__45718_46182__$1,gline_46183,gcol_46184,name_46185,seq__45703_46175__$1,temp__5735__auto___46172__$1,vec__45694_46147,column_46148,column_info_46149,vec__45618_46138,line_46139,columns_46140,seq__45247_46131__$1,temp__5735__auto___46130,inverted))
,cljs.core.sorted_map()));


var G__46194 = cljs.core.next(seq__45703_46175__$1);
var G__46195 = null;
var G__46196 = (0);
var G__46197 = (0);
seq__45703_46151 = G__46194;
chunk__45704_46152 = G__46195;
count__45705_46153 = G__46196;
i__45706_46154 = G__46197;
continue;
}
} else {
}
}
break;
}


var G__46198 = seq__45622_46143;
var G__46199 = chunk__45623_46144;
var G__46200 = count__45624_46145;
var G__46201 = (i__45625_46146 + (1));
seq__45622_46143 = G__46198;
chunk__45623_46144 = G__46199;
count__45624_46145 = G__46200;
i__45625_46146 = G__46201;
continue;
} else {
var temp__5735__auto___46202__$1 = cljs.core.seq(seq__45622_46143);
if(temp__5735__auto___46202__$1){
var seq__45622_46203__$1 = temp__5735__auto___46202__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45622_46203__$1)){
var c__4609__auto___46204 = cljs.core.chunk_first(seq__45622_46203__$1);
var G__46205 = cljs.core.chunk_rest(seq__45622_46203__$1);
var G__46206 = c__4609__auto___46204;
var G__46207 = cljs.core.count(c__4609__auto___46204);
var G__46208 = (0);
seq__45622_46143 = G__46205;
chunk__45623_46144 = G__46206;
count__45624_46145 = G__46207;
i__45625_46146 = G__46208;
continue;
} else {
var vec__45720_46209 = cljs.core.first(seq__45622_46203__$1);
var column_46210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45720_46209,(0),null);
var column_info_46211 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45720_46209,(1),null);
var seq__45723_46212 = cljs.core.seq(column_info_46211);
var chunk__45724_46213 = null;
var count__45725_46214 = (0);
var i__45726_46215 = (0);
while(true){
if((i__45726_46215 < count__45725_46214)){
var map__45736_46216 = chunk__45724_46213.cljs$core$IIndexed$_nth$arity$2(null,i__45726_46215);
var map__45736_46217__$1 = (((((!((map__45736_46216 == null))))?(((((map__45736_46216.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45736_46216.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45736_46216):map__45736_46216);
var gline_46218 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45736_46217__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46219 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45736_46217__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46220 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45736_46217__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46218], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45723_46212,chunk__45724_46213,count__45725_46214,i__45726_46215,seq__45622_46143,chunk__45623_46144,count__45624_46145,i__45625_46146,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45736_46216,map__45736_46217__$1,gline_46218,gcol_46219,name_46220,vec__45720_46209,column_46210,column_info_46211,seq__45622_46203__$1,temp__5735__auto___46202__$1,vec__45618_46138,line_46139,columns_46140,seq__45247_46131__$1,temp__5735__auto___46130,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46219], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46139,new cljs.core.Keyword(null,"col","col",-1959363084),column_46210,new cljs.core.Keyword(null,"name","name",1843675177),name_46220], null));
});})(seq__45723_46212,chunk__45724_46213,count__45725_46214,i__45726_46215,seq__45622_46143,chunk__45623_46144,count__45624_46145,i__45625_46146,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45736_46216,map__45736_46217__$1,gline_46218,gcol_46219,name_46220,vec__45720_46209,column_46210,column_info_46211,seq__45622_46203__$1,temp__5735__auto___46202__$1,vec__45618_46138,line_46139,columns_46140,seq__45247_46131__$1,temp__5735__auto___46130,inverted))
,cljs.core.sorted_map()));


var G__46225 = seq__45723_46212;
var G__46226 = chunk__45724_46213;
var G__46227 = count__45725_46214;
var G__46228 = (i__45726_46215 + (1));
seq__45723_46212 = G__46225;
chunk__45724_46213 = G__46226;
count__45725_46214 = G__46227;
i__45726_46215 = G__46228;
continue;
} else {
var temp__5735__auto___46229__$2 = cljs.core.seq(seq__45723_46212);
if(temp__5735__auto___46229__$2){
var seq__45723_46230__$1 = temp__5735__auto___46229__$2;
if(cljs.core.chunked_seq_QMARK_(seq__45723_46230__$1)){
var c__4609__auto___46231 = cljs.core.chunk_first(seq__45723_46230__$1);
var G__46232 = cljs.core.chunk_rest(seq__45723_46230__$1);
var G__46233 = c__4609__auto___46231;
var G__46234 = cljs.core.count(c__4609__auto___46231);
var G__46235 = (0);
seq__45723_46212 = G__46232;
chunk__45724_46213 = G__46233;
count__45725_46214 = G__46234;
i__45726_46215 = G__46235;
continue;
} else {
var map__45739_46236 = cljs.core.first(seq__45723_46230__$1);
var map__45739_46237__$1 = (((((!((map__45739_46236 == null))))?(((((map__45739_46236.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45739_46236.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45739_46236):map__45739_46236);
var gline_46238 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45739_46237__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_46239 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45739_46237__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_46240 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45739_46237__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_46238], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__45723_46212,chunk__45724_46213,count__45725_46214,i__45726_46215,seq__45622_46143,chunk__45623_46144,count__45624_46145,i__45625_46146,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45739_46236,map__45739_46237__$1,gline_46238,gcol_46239,name_46240,seq__45723_46230__$1,temp__5735__auto___46229__$2,vec__45720_46209,column_46210,column_info_46211,seq__45622_46203__$1,temp__5735__auto___46202__$1,vec__45618_46138,line_46139,columns_46140,seq__45247_46131__$1,temp__5735__auto___46130,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_46239], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_46139,new cljs.core.Keyword(null,"col","col",-1959363084),column_46210,new cljs.core.Keyword(null,"name","name",1843675177),name_46240], null));
});})(seq__45723_46212,chunk__45724_46213,count__45725_46214,i__45726_46215,seq__45622_46143,chunk__45623_46144,count__45624_46145,i__45625_46146,seq__45247_46017,chunk__45248_46018,count__45249_46019,i__45250_46020,map__45739_46236,map__45739_46237__$1,gline_46238,gcol_46239,name_46240,seq__45723_46230__$1,temp__5735__auto___46229__$2,vec__45720_46209,column_46210,column_info_46211,seq__45622_46203__$1,temp__5735__auto___46202__$1,vec__45618_46138,line_46139,columns_46140,seq__45247_46131__$1,temp__5735__auto___46130,inverted))
,cljs.core.sorted_map()));


var G__46243 = cljs.core.next(seq__45723_46230__$1);
var G__46244 = null;
var G__46245 = (0);
var G__46246 = (0);
seq__45723_46212 = G__46243;
chunk__45724_46213 = G__46244;
count__45725_46214 = G__46245;
i__45726_46215 = G__46246;
continue;
}
} else {
}
}
break;
}


var G__46247 = cljs.core.next(seq__45622_46203__$1);
var G__46248 = null;
var G__46249 = (0);
var G__46250 = (0);
seq__45622_46143 = G__46247;
chunk__45623_46144 = G__46248;
count__45624_46145 = G__46249;
i__45625_46146 = G__46250;
continue;
}
} else {
}
}
break;
}


var G__46251 = cljs.core.next(seq__45247_46131__$1);
var G__46252 = null;
var G__46253 = (0);
var G__46254 = (0);
seq__45247_46017 = G__46251;
chunk__45248_46018 = G__46252;
count__45249_46019 = G__46253;
i__45250_46020 = G__46254;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
