goog.provide('cljs.source_map');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__12807){
var vec__12808 = p__12807;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12808,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12808,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__12817 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12817,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12817,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12817,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12817,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12817,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__12824 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12824,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12824,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12824,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12824,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12824,(4),null);
var vec__12827 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12827,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12827,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12827,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12827,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12827,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__12830 = segmap;
var map__12830__$1 = (((((!((map__12830 == null))))?(((((map__12830.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12830.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12830):map__12830);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12830__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12830__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12830__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12830__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12830__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__12835 = arguments.length;
switch (G__12835) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__12850 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__13900 = cljs.core.next(segs__$1);
var G__13901 = nrelseg;
var G__13902 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__13900;
relseg__$1 = G__13901;
result__$1 = G__13902;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12850,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12850,(1),null);
var G__13903 = (gline + (1));
var G__13904 = cljs.core.next(lines__$1);
var G__13905 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__13906 = result__$1;
gline = G__13903;
lines__$1 = G__13904;
relseg = G__13905;
result = G__13906;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__12860 = segmap;
var map__12860__$1 = (((((!((map__12860 == null))))?(((((map__12860.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12860.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12860):map__12860);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12860__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12860__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12860__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12860__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12860__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__12859_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__12859_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__12863 = arguments.length;
switch (G__12863) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__12867 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__13912 = cljs.core.next(segs__$1);
var G__13913 = nrelseg;
var G__13914 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__13912;
relseg__$1 = G__13913;
result__$1 = G__13914;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12867,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12867,(1),null);
var G__13915 = (gline + (1));
var G__13916 = cljs.core.next(lines__$1);
var G__13917 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__13918 = result__$1;
gline = G__13915;
lines__$1 = G__13916;
relseg = G__13917;
result = G__13918;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__12877){
var vec__12878 = p__12877;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12878,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12878,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12878,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12878,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12878,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__12881){
var vec__12882 = p__12881;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12882,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12882,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12882,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12882,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12882,(4),null);
var seg = vec__12882;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__12885){
var vec__12886 = p__12885;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12886,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12886,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12886,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12886,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12886,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__12897 = cljs.core.seq(infos);
var chunk__12898 = null;
var count__12899 = (0);
var i__12900 = (0);
while(true){
if((i__12900 < count__12899)){
var info = chunk__12898.cljs$core$IIndexed$_nth$arity$2(null,i__12900);
var segv_13935 = info__GT_segv(info,source_idx,line,col);
var gline_13936 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_13937 = cljs.core.count(cljs.core.deref(lines));
if((gline_13936 > (lc_13937 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12897,chunk__12898,count__12899,i__12900,segv_13935,gline_13936,lc_13937,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_13936 - (lc_13937 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_13935], null));
});})(seq__12897,chunk__12898,count__12899,i__12900,segv_13935,gline_13936,lc_13937,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12897,chunk__12898,count__12899,i__12900,segv_13935,gline_13936,lc_13937,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_13936], null),cljs.core.conj,segv_13935);
});})(seq__12897,chunk__12898,count__12899,i__12900,segv_13935,gline_13936,lc_13937,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__13942 = seq__12897;
var G__13943 = chunk__12898;
var G__13944 = count__12899;
var G__13945 = (i__12900 + (1));
seq__12897 = G__13942;
chunk__12898 = G__13943;
count__12899 = G__13944;
i__12900 = G__13945;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12897);
if(temp__5735__auto__){
var seq__12897__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12897__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__12897__$1);
var G__13946 = cljs.core.chunk_rest(seq__12897__$1);
var G__13947 = c__4609__auto__;
var G__13948 = cljs.core.count(c__4609__auto__);
var G__13949 = (0);
seq__12897 = G__13946;
chunk__12898 = G__13947;
count__12899 = G__13948;
i__12900 = G__13949;
continue;
} else {
var info = cljs.core.first(seq__12897__$1);
var segv_13963 = info__GT_segv(info,source_idx,line,col);
var gline_13964 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_13965 = cljs.core.count(cljs.core.deref(lines));
if((gline_13964 > (lc_13965 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12897,chunk__12898,count__12899,i__12900,segv_13963,gline_13964,lc_13965,info,seq__12897__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_13964 - (lc_13965 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_13963], null));
});})(seq__12897,chunk__12898,count__12899,i__12900,segv_13963,gline_13964,lc_13965,info,seq__12897__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12897,chunk__12898,count__12899,i__12900,segv_13963,gline_13964,lc_13965,info,seq__12897__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_13964], null),cljs.core.conj,segv_13963);
});})(seq__12897,chunk__12898,count__12899,i__12900,segv_13963,gline_13964,lc_13965,info,seq__12897__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__13969 = cljs.core.next(seq__12897__$1);
var G__13970 = null;
var G__13971 = (0);
var G__13972 = (0);
seq__12897 = G__13969;
chunk__12898 = G__13970;
count__12899 = G__13971;
i__12900 = G__13972;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__12907_13973 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__12908_13974 = null;
var count__12909_13975 = (0);
var i__12910_13976 = (0);
while(true){
if((i__12910_13976 < count__12909_13975)){
var vec__13093_13977 = chunk__12908_13974.cljs$core$IIndexed$_nth$arity$2(null,i__12910_13976);
var source_idx_13978 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13093_13977,(0),null);
var vec__13096_13979 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13093_13977,(1),null);
var __13980 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13096_13979,(0),null);
var lines_13981__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13096_13979,(1),null);
var seq__13101_13984 = cljs.core.seq(lines_13981__$1);
var chunk__13102_13985 = null;
var count__13103_13986 = (0);
var i__13104_13987 = (0);
while(true){
if((i__13104_13987 < count__13103_13986)){
var vec__13148_13988 = chunk__13102_13985.cljs$core$IIndexed$_nth$arity$2(null,i__13104_13987);
var line_13989 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13148_13988,(0),null);
var cols_13990 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13148_13988,(1),null);
var seq__13151_13991 = cljs.core.seq(cols_13990);
var chunk__13152_13992 = null;
var count__13153_13993 = (0);
var i__13154_13994 = (0);
while(true){
if((i__13154_13994 < count__13153_13993)){
var vec__13161_13995 = chunk__13152_13992.cljs$core$IIndexed$_nth$arity$2(null,i__13154_13994);
var col_13996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13161_13995,(0),null);
var infos_13997 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13161_13995,(1),null);
encode_cols(infos_13997,source_idx_13978,line_13989,col_13996);


var G__13998 = seq__13151_13991;
var G__13999 = chunk__13152_13992;
var G__14000 = count__13153_13993;
var G__14001 = (i__13154_13994 + (1));
seq__13151_13991 = G__13998;
chunk__13152_13992 = G__13999;
count__13153_13993 = G__14000;
i__13154_13994 = G__14001;
continue;
} else {
var temp__5735__auto___14002 = cljs.core.seq(seq__13151_13991);
if(temp__5735__auto___14002){
var seq__13151_14003__$1 = temp__5735__auto___14002;
if(cljs.core.chunked_seq_QMARK_(seq__13151_14003__$1)){
var c__4609__auto___14004 = cljs.core.chunk_first(seq__13151_14003__$1);
var G__14005 = cljs.core.chunk_rest(seq__13151_14003__$1);
var G__14006 = c__4609__auto___14004;
var G__14007 = cljs.core.count(c__4609__auto___14004);
var G__14008 = (0);
seq__13151_13991 = G__14005;
chunk__13152_13992 = G__14006;
count__13153_13993 = G__14007;
i__13154_13994 = G__14008;
continue;
} else {
var vec__13164_14013 = cljs.core.first(seq__13151_14003__$1);
var col_14014 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13164_14013,(0),null);
var infos_14015 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13164_14013,(1),null);
encode_cols(infos_14015,source_idx_13978,line_13989,col_14014);


var G__14019 = cljs.core.next(seq__13151_14003__$1);
var G__14020 = null;
var G__14021 = (0);
var G__14022 = (0);
seq__13151_13991 = G__14019;
chunk__13152_13992 = G__14020;
count__13153_13993 = G__14021;
i__13154_13994 = G__14022;
continue;
}
} else {
}
}
break;
}


var G__14023 = seq__13101_13984;
var G__14024 = chunk__13102_13985;
var G__14025 = count__13103_13986;
var G__14026 = (i__13104_13987 + (1));
seq__13101_13984 = G__14023;
chunk__13102_13985 = G__14024;
count__13103_13986 = G__14025;
i__13104_13987 = G__14026;
continue;
} else {
var temp__5735__auto___14042 = cljs.core.seq(seq__13101_13984);
if(temp__5735__auto___14042){
var seq__13101_14043__$1 = temp__5735__auto___14042;
if(cljs.core.chunked_seq_QMARK_(seq__13101_14043__$1)){
var c__4609__auto___14044 = cljs.core.chunk_first(seq__13101_14043__$1);
var G__14045 = cljs.core.chunk_rest(seq__13101_14043__$1);
var G__14046 = c__4609__auto___14044;
var G__14047 = cljs.core.count(c__4609__auto___14044);
var G__14048 = (0);
seq__13101_13984 = G__14045;
chunk__13102_13985 = G__14046;
count__13103_13986 = G__14047;
i__13104_13987 = G__14048;
continue;
} else {
var vec__13167_14049 = cljs.core.first(seq__13101_14043__$1);
var line_14050 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13167_14049,(0),null);
var cols_14051 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13167_14049,(1),null);
var seq__13170_14052 = cljs.core.seq(cols_14051);
var chunk__13171_14053 = null;
var count__13172_14054 = (0);
var i__13173_14055 = (0);
while(true){
if((i__13173_14055 < count__13172_14054)){
var vec__13182_14056 = chunk__13171_14053.cljs$core$IIndexed$_nth$arity$2(null,i__13173_14055);
var col_14057 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13182_14056,(0),null);
var infos_14058 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13182_14056,(1),null);
encode_cols(infos_14058,source_idx_13978,line_14050,col_14057);


var G__14059 = seq__13170_14052;
var G__14060 = chunk__13171_14053;
var G__14061 = count__13172_14054;
var G__14062 = (i__13173_14055 + (1));
seq__13170_14052 = G__14059;
chunk__13171_14053 = G__14060;
count__13172_14054 = G__14061;
i__13173_14055 = G__14062;
continue;
} else {
var temp__5735__auto___14063__$1 = cljs.core.seq(seq__13170_14052);
if(temp__5735__auto___14063__$1){
var seq__13170_14064__$1 = temp__5735__auto___14063__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13170_14064__$1)){
var c__4609__auto___14066 = cljs.core.chunk_first(seq__13170_14064__$1);
var G__14068 = cljs.core.chunk_rest(seq__13170_14064__$1);
var G__14069 = c__4609__auto___14066;
var G__14070 = cljs.core.count(c__4609__auto___14066);
var G__14071 = (0);
seq__13170_14052 = G__14068;
chunk__13171_14053 = G__14069;
count__13172_14054 = G__14070;
i__13173_14055 = G__14071;
continue;
} else {
var vec__13185_14073 = cljs.core.first(seq__13170_14064__$1);
var col_14074 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13185_14073,(0),null);
var infos_14075 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13185_14073,(1),null);
encode_cols(infos_14075,source_idx_13978,line_14050,col_14074);


var G__14077 = cljs.core.next(seq__13170_14064__$1);
var G__14078 = null;
var G__14079 = (0);
var G__14080 = (0);
seq__13170_14052 = G__14077;
chunk__13171_14053 = G__14078;
count__13172_14054 = G__14079;
i__13173_14055 = G__14080;
continue;
}
} else {
}
}
break;
}


var G__14082 = cljs.core.next(seq__13101_14043__$1);
var G__14083 = null;
var G__14084 = (0);
var G__14085 = (0);
seq__13101_13984 = G__14082;
chunk__13102_13985 = G__14083;
count__13103_13986 = G__14084;
i__13104_13987 = G__14085;
continue;
}
} else {
}
}
break;
}


var G__14087 = seq__12907_13973;
var G__14088 = chunk__12908_13974;
var G__14089 = count__12909_13975;
var G__14090 = (i__12910_13976 + (1));
seq__12907_13973 = G__14087;
chunk__12908_13974 = G__14088;
count__12909_13975 = G__14089;
i__12910_13976 = G__14090;
continue;
} else {
var temp__5735__auto___14091 = cljs.core.seq(seq__12907_13973);
if(temp__5735__auto___14091){
var seq__12907_14092__$1 = temp__5735__auto___14091;
if(cljs.core.chunked_seq_QMARK_(seq__12907_14092__$1)){
var c__4609__auto___14093 = cljs.core.chunk_first(seq__12907_14092__$1);
var G__14094 = cljs.core.chunk_rest(seq__12907_14092__$1);
var G__14095 = c__4609__auto___14093;
var G__14096 = cljs.core.count(c__4609__auto___14093);
var G__14097 = (0);
seq__12907_13973 = G__14094;
chunk__12908_13974 = G__14095;
count__12909_13975 = G__14096;
i__12910_13976 = G__14097;
continue;
} else {
var vec__13192_14098 = cljs.core.first(seq__12907_14092__$1);
var source_idx_14099 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13192_14098,(0),null);
var vec__13195_14100 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13192_14098,(1),null);
var __14101 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13195_14100,(0),null);
var lines_14102__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13195_14100,(1),null);
var seq__13198_14103 = cljs.core.seq(lines_14102__$1);
var chunk__13199_14104 = null;
var count__13200_14105 = (0);
var i__13201_14106 = (0);
while(true){
if((i__13201_14106 < count__13200_14105)){
var vec__13240_14107 = chunk__13199_14104.cljs$core$IIndexed$_nth$arity$2(null,i__13201_14106);
var line_14108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13240_14107,(0),null);
var cols_14109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13240_14107,(1),null);
var seq__13243_14110 = cljs.core.seq(cols_14109);
var chunk__13244_14111 = null;
var count__13245_14112 = (0);
var i__13246_14113 = (0);
while(true){
if((i__13246_14113 < count__13245_14112)){
var vec__13253_14114 = chunk__13244_14111.cljs$core$IIndexed$_nth$arity$2(null,i__13246_14113);
var col_14115 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13253_14114,(0),null);
var infos_14116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13253_14114,(1),null);
encode_cols(infos_14116,source_idx_14099,line_14108,col_14115);


var G__14117 = seq__13243_14110;
var G__14118 = chunk__13244_14111;
var G__14119 = count__13245_14112;
var G__14120 = (i__13246_14113 + (1));
seq__13243_14110 = G__14117;
chunk__13244_14111 = G__14118;
count__13245_14112 = G__14119;
i__13246_14113 = G__14120;
continue;
} else {
var temp__5735__auto___14121__$1 = cljs.core.seq(seq__13243_14110);
if(temp__5735__auto___14121__$1){
var seq__13243_14122__$1 = temp__5735__auto___14121__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13243_14122__$1)){
var c__4609__auto___14123 = cljs.core.chunk_first(seq__13243_14122__$1);
var G__14124 = cljs.core.chunk_rest(seq__13243_14122__$1);
var G__14125 = c__4609__auto___14123;
var G__14126 = cljs.core.count(c__4609__auto___14123);
var G__14127 = (0);
seq__13243_14110 = G__14124;
chunk__13244_14111 = G__14125;
count__13245_14112 = G__14126;
i__13246_14113 = G__14127;
continue;
} else {
var vec__13256_14128 = cljs.core.first(seq__13243_14122__$1);
var col_14129 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13256_14128,(0),null);
var infos_14130 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13256_14128,(1),null);
encode_cols(infos_14130,source_idx_14099,line_14108,col_14129);


var G__14131 = cljs.core.next(seq__13243_14122__$1);
var G__14132 = null;
var G__14133 = (0);
var G__14134 = (0);
seq__13243_14110 = G__14131;
chunk__13244_14111 = G__14132;
count__13245_14112 = G__14133;
i__13246_14113 = G__14134;
continue;
}
} else {
}
}
break;
}


var G__14140 = seq__13198_14103;
var G__14141 = chunk__13199_14104;
var G__14142 = count__13200_14105;
var G__14143 = (i__13201_14106 + (1));
seq__13198_14103 = G__14140;
chunk__13199_14104 = G__14141;
count__13200_14105 = G__14142;
i__13201_14106 = G__14143;
continue;
} else {
var temp__5735__auto___14144__$1 = cljs.core.seq(seq__13198_14103);
if(temp__5735__auto___14144__$1){
var seq__13198_14145__$1 = temp__5735__auto___14144__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13198_14145__$1)){
var c__4609__auto___14146 = cljs.core.chunk_first(seq__13198_14145__$1);
var G__14147 = cljs.core.chunk_rest(seq__13198_14145__$1);
var G__14148 = c__4609__auto___14146;
var G__14149 = cljs.core.count(c__4609__auto___14146);
var G__14150 = (0);
seq__13198_14103 = G__14147;
chunk__13199_14104 = G__14148;
count__13200_14105 = G__14149;
i__13201_14106 = G__14150;
continue;
} else {
var vec__13259_14151 = cljs.core.first(seq__13198_14145__$1);
var line_14152 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13259_14151,(0),null);
var cols_14153 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13259_14151,(1),null);
var seq__13262_14154 = cljs.core.seq(cols_14153);
var chunk__13263_14155 = null;
var count__13264_14156 = (0);
var i__13265_14157 = (0);
while(true){
if((i__13265_14157 < count__13264_14156)){
var vec__13272_14158 = chunk__13263_14155.cljs$core$IIndexed$_nth$arity$2(null,i__13265_14157);
var col_14159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13272_14158,(0),null);
var infos_14160 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13272_14158,(1),null);
encode_cols(infos_14160,source_idx_14099,line_14152,col_14159);


var G__14161 = seq__13262_14154;
var G__14162 = chunk__13263_14155;
var G__14163 = count__13264_14156;
var G__14164 = (i__13265_14157 + (1));
seq__13262_14154 = G__14161;
chunk__13263_14155 = G__14162;
count__13264_14156 = G__14163;
i__13265_14157 = G__14164;
continue;
} else {
var temp__5735__auto___14165__$2 = cljs.core.seq(seq__13262_14154);
if(temp__5735__auto___14165__$2){
var seq__13262_14166__$1 = temp__5735__auto___14165__$2;
if(cljs.core.chunked_seq_QMARK_(seq__13262_14166__$1)){
var c__4609__auto___14167 = cljs.core.chunk_first(seq__13262_14166__$1);
var G__14168 = cljs.core.chunk_rest(seq__13262_14166__$1);
var G__14169 = c__4609__auto___14167;
var G__14170 = cljs.core.count(c__4609__auto___14167);
var G__14171 = (0);
seq__13262_14154 = G__14168;
chunk__13263_14155 = G__14169;
count__13264_14156 = G__14170;
i__13265_14157 = G__14171;
continue;
} else {
var vec__13276_14172 = cljs.core.first(seq__13262_14166__$1);
var col_14173 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13276_14172,(0),null);
var infos_14174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13276_14172,(1),null);
encode_cols(infos_14174,source_idx_14099,line_14152,col_14173);


var G__14175 = cljs.core.next(seq__13262_14166__$1);
var G__14176 = null;
var G__14177 = (0);
var G__14178 = (0);
seq__13262_14154 = G__14175;
chunk__13263_14155 = G__14176;
count__13264_14156 = G__14177;
i__13265_14157 = G__14178;
continue;
}
} else {
}
}
break;
}


var G__14179 = cljs.core.next(seq__13198_14145__$1);
var G__14180 = null;
var G__14181 = (0);
var G__14182 = (0);
seq__13198_14103 = G__14179;
chunk__13199_14104 = G__14180;
count__13200_14105 = G__14181;
i__13201_14106 = G__14182;
continue;
}
} else {
}
}
break;
}


var G__14183 = cljs.core.next(seq__12907_14092__$1);
var G__14184 = null;
var G__14185 = (0);
var G__14186 = (0);
seq__12907_13973 = G__14183;
chunk__12908_13974 = G__14184;
count__12909_13975 = G__14185;
i__12910_13976 = G__14186;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__13281 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__12889_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__12889_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__12890_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__12890_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__12891_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__12891_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__13283 = G__13281;
goog.object.set(G__13283,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__13283;
} else {
return G__13281;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__13285 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13285,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13285,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__13288 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13288,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13288,(1),null);
var G__14192 = cljs.core.next(col_map_seq);
var G__14193 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__13288,col,infos,vec__13285,line,col_map){
return (function (v,p__13291){
var map__13292 = p__13291;
var map__13292__$1 = (((((!((map__13292 == null))))?(((((map__13292.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13292.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13292):map__13292);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13292__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13292__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__13288,col,infos,vec__13285,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__14192;
new_cols = G__14193;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__14194 = cljs.core.next(line_map_seq);
var G__14195 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__14194;
new_lines = G__14195;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__13294_14196 = cljs.core.seq(reverse_map);
var chunk__13295_14197 = null;
var count__13296_14198 = (0);
var i__13297_14199 = (0);
while(true){
if((i__13297_14199 < count__13296_14198)){
var vec__13578_14200 = chunk__13295_14197.cljs$core$IIndexed$_nth$arity$2(null,i__13297_14199);
var line_14201 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13578_14200,(0),null);
var columns_14202 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13578_14200,(1),null);
var seq__13581_14203 = cljs.core.seq(columns_14202);
var chunk__13582_14204 = null;
var count__13583_14205 = (0);
var i__13584_14206 = (0);
while(true){
if((i__13584_14206 < count__13583_14205)){
var vec__13631_14207 = chunk__13582_14204.cljs$core$IIndexed$_nth$arity$2(null,i__13584_14206);
var column_14208 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13631_14207,(0),null);
var column_info_14209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13631_14207,(1),null);
var seq__13636_14210 = cljs.core.seq(column_info_14209);
var chunk__13637_14211 = null;
var count__13638_14212 = (0);
var i__13639_14213 = (0);
while(true){
if((i__13639_14213 < count__13638_14212)){
var map__13664_14214 = chunk__13637_14211.cljs$core$IIndexed$_nth$arity$2(null,i__13639_14213);
var map__13664_14215__$1 = (((((!((map__13664_14214 == null))))?(((((map__13664_14214.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13664_14214.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13664_14214):map__13664_14214);
var gline_14216 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13664_14215__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14217 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13664_14215__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14218 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13664_14215__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14216], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13636_14210,chunk__13637_14211,count__13638_14212,i__13639_14213,seq__13581_14203,chunk__13582_14204,count__13583_14205,i__13584_14206,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13664_14214,map__13664_14215__$1,gline_14216,gcol_14217,name_14218,vec__13631_14207,column_14208,column_info_14209,vec__13578_14200,line_14201,columns_14202,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14217], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14201,new cljs.core.Keyword(null,"col","col",-1959363084),column_14208,new cljs.core.Keyword(null,"name","name",1843675177),name_14218], null));
});})(seq__13636_14210,chunk__13637_14211,count__13638_14212,i__13639_14213,seq__13581_14203,chunk__13582_14204,count__13583_14205,i__13584_14206,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13664_14214,map__13664_14215__$1,gline_14216,gcol_14217,name_14218,vec__13631_14207,column_14208,column_info_14209,vec__13578_14200,line_14201,columns_14202,inverted))
,cljs.core.sorted_map()));


var G__14219 = seq__13636_14210;
var G__14220 = chunk__13637_14211;
var G__14221 = count__13638_14212;
var G__14222 = (i__13639_14213 + (1));
seq__13636_14210 = G__14219;
chunk__13637_14211 = G__14220;
count__13638_14212 = G__14221;
i__13639_14213 = G__14222;
continue;
} else {
var temp__5735__auto___14223 = cljs.core.seq(seq__13636_14210);
if(temp__5735__auto___14223){
var seq__13636_14224__$1 = temp__5735__auto___14223;
if(cljs.core.chunked_seq_QMARK_(seq__13636_14224__$1)){
var c__4609__auto___14225 = cljs.core.chunk_first(seq__13636_14224__$1);
var G__14226 = cljs.core.chunk_rest(seq__13636_14224__$1);
var G__14227 = c__4609__auto___14225;
var G__14228 = cljs.core.count(c__4609__auto___14225);
var G__14229 = (0);
seq__13636_14210 = G__14226;
chunk__13637_14211 = G__14227;
count__13638_14212 = G__14228;
i__13639_14213 = G__14229;
continue;
} else {
var map__13672_14230 = cljs.core.first(seq__13636_14224__$1);
var map__13672_14231__$1 = (((((!((map__13672_14230 == null))))?(((((map__13672_14230.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13672_14230.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13672_14230):map__13672_14230);
var gline_14232 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13672_14231__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14233 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13672_14231__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14234 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13672_14231__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14232], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13636_14210,chunk__13637_14211,count__13638_14212,i__13639_14213,seq__13581_14203,chunk__13582_14204,count__13583_14205,i__13584_14206,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13672_14230,map__13672_14231__$1,gline_14232,gcol_14233,name_14234,seq__13636_14224__$1,temp__5735__auto___14223,vec__13631_14207,column_14208,column_info_14209,vec__13578_14200,line_14201,columns_14202,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14233], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14201,new cljs.core.Keyword(null,"col","col",-1959363084),column_14208,new cljs.core.Keyword(null,"name","name",1843675177),name_14234], null));
});})(seq__13636_14210,chunk__13637_14211,count__13638_14212,i__13639_14213,seq__13581_14203,chunk__13582_14204,count__13583_14205,i__13584_14206,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13672_14230,map__13672_14231__$1,gline_14232,gcol_14233,name_14234,seq__13636_14224__$1,temp__5735__auto___14223,vec__13631_14207,column_14208,column_info_14209,vec__13578_14200,line_14201,columns_14202,inverted))
,cljs.core.sorted_map()));


var G__14235 = cljs.core.next(seq__13636_14224__$1);
var G__14236 = null;
var G__14237 = (0);
var G__14238 = (0);
seq__13636_14210 = G__14235;
chunk__13637_14211 = G__14236;
count__13638_14212 = G__14237;
i__13639_14213 = G__14238;
continue;
}
} else {
}
}
break;
}


var G__14239 = seq__13581_14203;
var G__14240 = chunk__13582_14204;
var G__14241 = count__13583_14205;
var G__14242 = (i__13584_14206 + (1));
seq__13581_14203 = G__14239;
chunk__13582_14204 = G__14240;
count__13583_14205 = G__14241;
i__13584_14206 = G__14242;
continue;
} else {
var temp__5735__auto___14243 = cljs.core.seq(seq__13581_14203);
if(temp__5735__auto___14243){
var seq__13581_14244__$1 = temp__5735__auto___14243;
if(cljs.core.chunked_seq_QMARK_(seq__13581_14244__$1)){
var c__4609__auto___14245 = cljs.core.chunk_first(seq__13581_14244__$1);
var G__14246 = cljs.core.chunk_rest(seq__13581_14244__$1);
var G__14247 = c__4609__auto___14245;
var G__14248 = cljs.core.count(c__4609__auto___14245);
var G__14249 = (0);
seq__13581_14203 = G__14246;
chunk__13582_14204 = G__14247;
count__13583_14205 = G__14248;
i__13584_14206 = G__14249;
continue;
} else {
var vec__13682_14250 = cljs.core.first(seq__13581_14244__$1);
var column_14251 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13682_14250,(0),null);
var column_info_14252 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13682_14250,(1),null);
var seq__13685_14253 = cljs.core.seq(column_info_14252);
var chunk__13686_14254 = null;
var count__13687_14255 = (0);
var i__13688_14256 = (0);
while(true){
if((i__13688_14256 < count__13687_14255)){
var map__13721_14257 = chunk__13686_14254.cljs$core$IIndexed$_nth$arity$2(null,i__13688_14256);
var map__13721_14258__$1 = (((((!((map__13721_14257 == null))))?(((((map__13721_14257.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13721_14257.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13721_14257):map__13721_14257);
var gline_14259 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13721_14258__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14260 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13721_14258__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14261 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13721_14258__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14259], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13685_14253,chunk__13686_14254,count__13687_14255,i__13688_14256,seq__13581_14203,chunk__13582_14204,count__13583_14205,i__13584_14206,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13721_14257,map__13721_14258__$1,gline_14259,gcol_14260,name_14261,vec__13682_14250,column_14251,column_info_14252,seq__13581_14244__$1,temp__5735__auto___14243,vec__13578_14200,line_14201,columns_14202,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14260], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14201,new cljs.core.Keyword(null,"col","col",-1959363084),column_14251,new cljs.core.Keyword(null,"name","name",1843675177),name_14261], null));
});})(seq__13685_14253,chunk__13686_14254,count__13687_14255,i__13688_14256,seq__13581_14203,chunk__13582_14204,count__13583_14205,i__13584_14206,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13721_14257,map__13721_14258__$1,gline_14259,gcol_14260,name_14261,vec__13682_14250,column_14251,column_info_14252,seq__13581_14244__$1,temp__5735__auto___14243,vec__13578_14200,line_14201,columns_14202,inverted))
,cljs.core.sorted_map()));


var G__14279 = seq__13685_14253;
var G__14280 = chunk__13686_14254;
var G__14281 = count__13687_14255;
var G__14282 = (i__13688_14256 + (1));
seq__13685_14253 = G__14279;
chunk__13686_14254 = G__14280;
count__13687_14255 = G__14281;
i__13688_14256 = G__14282;
continue;
} else {
var temp__5735__auto___14283__$1 = cljs.core.seq(seq__13685_14253);
if(temp__5735__auto___14283__$1){
var seq__13685_14284__$1 = temp__5735__auto___14283__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13685_14284__$1)){
var c__4609__auto___14285 = cljs.core.chunk_first(seq__13685_14284__$1);
var G__14286 = cljs.core.chunk_rest(seq__13685_14284__$1);
var G__14287 = c__4609__auto___14285;
var G__14288 = cljs.core.count(c__4609__auto___14285);
var G__14289 = (0);
seq__13685_14253 = G__14286;
chunk__13686_14254 = G__14287;
count__13687_14255 = G__14288;
i__13688_14256 = G__14289;
continue;
} else {
var map__13732_14290 = cljs.core.first(seq__13685_14284__$1);
var map__13732_14291__$1 = (((((!((map__13732_14290 == null))))?(((((map__13732_14290.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13732_14290.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13732_14290):map__13732_14290);
var gline_14292 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13732_14291__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14293 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13732_14291__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14294 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13732_14291__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14292], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13685_14253,chunk__13686_14254,count__13687_14255,i__13688_14256,seq__13581_14203,chunk__13582_14204,count__13583_14205,i__13584_14206,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13732_14290,map__13732_14291__$1,gline_14292,gcol_14293,name_14294,seq__13685_14284__$1,temp__5735__auto___14283__$1,vec__13682_14250,column_14251,column_info_14252,seq__13581_14244__$1,temp__5735__auto___14243,vec__13578_14200,line_14201,columns_14202,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14293], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14201,new cljs.core.Keyword(null,"col","col",-1959363084),column_14251,new cljs.core.Keyword(null,"name","name",1843675177),name_14294], null));
});})(seq__13685_14253,chunk__13686_14254,count__13687_14255,i__13688_14256,seq__13581_14203,chunk__13582_14204,count__13583_14205,i__13584_14206,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13732_14290,map__13732_14291__$1,gline_14292,gcol_14293,name_14294,seq__13685_14284__$1,temp__5735__auto___14283__$1,vec__13682_14250,column_14251,column_info_14252,seq__13581_14244__$1,temp__5735__auto___14243,vec__13578_14200,line_14201,columns_14202,inverted))
,cljs.core.sorted_map()));


var G__14295 = cljs.core.next(seq__13685_14284__$1);
var G__14296 = null;
var G__14297 = (0);
var G__14298 = (0);
seq__13685_14253 = G__14295;
chunk__13686_14254 = G__14296;
count__13687_14255 = G__14297;
i__13688_14256 = G__14298;
continue;
}
} else {
}
}
break;
}


var G__14299 = cljs.core.next(seq__13581_14244__$1);
var G__14300 = null;
var G__14301 = (0);
var G__14302 = (0);
seq__13581_14203 = G__14299;
chunk__13582_14204 = G__14300;
count__13583_14205 = G__14301;
i__13584_14206 = G__14302;
continue;
}
} else {
}
}
break;
}


var G__14303 = seq__13294_14196;
var G__14304 = chunk__13295_14197;
var G__14305 = count__13296_14198;
var G__14306 = (i__13297_14199 + (1));
seq__13294_14196 = G__14303;
chunk__13295_14197 = G__14304;
count__13296_14198 = G__14305;
i__13297_14199 = G__14306;
continue;
} else {
var temp__5735__auto___14307 = cljs.core.seq(seq__13294_14196);
if(temp__5735__auto___14307){
var seq__13294_14308__$1 = temp__5735__auto___14307;
if(cljs.core.chunked_seq_QMARK_(seq__13294_14308__$1)){
var c__4609__auto___14309 = cljs.core.chunk_first(seq__13294_14308__$1);
var G__14310 = cljs.core.chunk_rest(seq__13294_14308__$1);
var G__14311 = c__4609__auto___14309;
var G__14312 = cljs.core.count(c__4609__auto___14309);
var G__14313 = (0);
seq__13294_14196 = G__14310;
chunk__13295_14197 = G__14311;
count__13296_14198 = G__14312;
i__13297_14199 = G__14313;
continue;
} else {
var vec__13739_14314 = cljs.core.first(seq__13294_14308__$1);
var line_14315 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13739_14314,(0),null);
var columns_14316 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13739_14314,(1),null);
var seq__13742_14317 = cljs.core.seq(columns_14316);
var chunk__13743_14318 = null;
var count__13744_14319 = (0);
var i__13745_14320 = (0);
while(true){
if((i__13745_14320 < count__13744_14319)){
var vec__13834_14321 = chunk__13743_14318.cljs$core$IIndexed$_nth$arity$2(null,i__13745_14320);
var column_14322 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13834_14321,(0),null);
var column_info_14323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13834_14321,(1),null);
var seq__13837_14324 = cljs.core.seq(column_info_14323);
var chunk__13838_14325 = null;
var count__13839_14326 = (0);
var i__13840_14327 = (0);
while(true){
if((i__13840_14327 < count__13839_14326)){
var map__13866_14328 = chunk__13838_14325.cljs$core$IIndexed$_nth$arity$2(null,i__13840_14327);
var map__13866_14329__$1 = (((((!((map__13866_14328 == null))))?(((((map__13866_14328.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13866_14328.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13866_14328):map__13866_14328);
var gline_14330 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13866_14329__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14331 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13866_14329__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14332 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13866_14329__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14330], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13837_14324,chunk__13838_14325,count__13839_14326,i__13840_14327,seq__13742_14317,chunk__13743_14318,count__13744_14319,i__13745_14320,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13866_14328,map__13866_14329__$1,gline_14330,gcol_14331,name_14332,vec__13834_14321,column_14322,column_info_14323,vec__13739_14314,line_14315,columns_14316,seq__13294_14308__$1,temp__5735__auto___14307,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14331], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14315,new cljs.core.Keyword(null,"col","col",-1959363084),column_14322,new cljs.core.Keyword(null,"name","name",1843675177),name_14332], null));
});})(seq__13837_14324,chunk__13838_14325,count__13839_14326,i__13840_14327,seq__13742_14317,chunk__13743_14318,count__13744_14319,i__13745_14320,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13866_14328,map__13866_14329__$1,gline_14330,gcol_14331,name_14332,vec__13834_14321,column_14322,column_info_14323,vec__13739_14314,line_14315,columns_14316,seq__13294_14308__$1,temp__5735__auto___14307,inverted))
,cljs.core.sorted_map()));


var G__14333 = seq__13837_14324;
var G__14334 = chunk__13838_14325;
var G__14335 = count__13839_14326;
var G__14336 = (i__13840_14327 + (1));
seq__13837_14324 = G__14333;
chunk__13838_14325 = G__14334;
count__13839_14326 = G__14335;
i__13840_14327 = G__14336;
continue;
} else {
var temp__5735__auto___14337__$1 = cljs.core.seq(seq__13837_14324);
if(temp__5735__auto___14337__$1){
var seq__13837_14338__$1 = temp__5735__auto___14337__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13837_14338__$1)){
var c__4609__auto___14339 = cljs.core.chunk_first(seq__13837_14338__$1);
var G__14340 = cljs.core.chunk_rest(seq__13837_14338__$1);
var G__14341 = c__4609__auto___14339;
var G__14342 = cljs.core.count(c__4609__auto___14339);
var G__14343 = (0);
seq__13837_14324 = G__14340;
chunk__13838_14325 = G__14341;
count__13839_14326 = G__14342;
i__13840_14327 = G__14343;
continue;
} else {
var map__13869_14362 = cljs.core.first(seq__13837_14338__$1);
var map__13869_14363__$1 = (((((!((map__13869_14362 == null))))?(((((map__13869_14362.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13869_14362.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13869_14362):map__13869_14362);
var gline_14364 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13869_14363__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14365 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13869_14363__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14366 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13869_14363__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14364], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13837_14324,chunk__13838_14325,count__13839_14326,i__13840_14327,seq__13742_14317,chunk__13743_14318,count__13744_14319,i__13745_14320,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13869_14362,map__13869_14363__$1,gline_14364,gcol_14365,name_14366,seq__13837_14338__$1,temp__5735__auto___14337__$1,vec__13834_14321,column_14322,column_info_14323,vec__13739_14314,line_14315,columns_14316,seq__13294_14308__$1,temp__5735__auto___14307,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14365], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14315,new cljs.core.Keyword(null,"col","col",-1959363084),column_14322,new cljs.core.Keyword(null,"name","name",1843675177),name_14366], null));
});})(seq__13837_14324,chunk__13838_14325,count__13839_14326,i__13840_14327,seq__13742_14317,chunk__13743_14318,count__13744_14319,i__13745_14320,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13869_14362,map__13869_14363__$1,gline_14364,gcol_14365,name_14366,seq__13837_14338__$1,temp__5735__auto___14337__$1,vec__13834_14321,column_14322,column_info_14323,vec__13739_14314,line_14315,columns_14316,seq__13294_14308__$1,temp__5735__auto___14307,inverted))
,cljs.core.sorted_map()));


var G__14367 = cljs.core.next(seq__13837_14338__$1);
var G__14368 = null;
var G__14369 = (0);
var G__14370 = (0);
seq__13837_14324 = G__14367;
chunk__13838_14325 = G__14368;
count__13839_14326 = G__14369;
i__13840_14327 = G__14370;
continue;
}
} else {
}
}
break;
}


var G__14371 = seq__13742_14317;
var G__14372 = chunk__13743_14318;
var G__14373 = count__13744_14319;
var G__14374 = (i__13745_14320 + (1));
seq__13742_14317 = G__14371;
chunk__13743_14318 = G__14372;
count__13744_14319 = G__14373;
i__13745_14320 = G__14374;
continue;
} else {
var temp__5735__auto___14375__$1 = cljs.core.seq(seq__13742_14317);
if(temp__5735__auto___14375__$1){
var seq__13742_14376__$1 = temp__5735__auto___14375__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13742_14376__$1)){
var c__4609__auto___14377 = cljs.core.chunk_first(seq__13742_14376__$1);
var G__14378 = cljs.core.chunk_rest(seq__13742_14376__$1);
var G__14379 = c__4609__auto___14377;
var G__14380 = cljs.core.count(c__4609__auto___14377);
var G__14381 = (0);
seq__13742_14317 = G__14378;
chunk__13743_14318 = G__14379;
count__13744_14319 = G__14380;
i__13745_14320 = G__14381;
continue;
} else {
var vec__13872_14382 = cljs.core.first(seq__13742_14376__$1);
var column_14383 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13872_14382,(0),null);
var column_info_14384 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13872_14382,(1),null);
var seq__13875_14385 = cljs.core.seq(column_info_14384);
var chunk__13876_14386 = null;
var count__13877_14387 = (0);
var i__13878_14388 = (0);
while(true){
if((i__13878_14388 < count__13877_14387)){
var map__13890_14389 = chunk__13876_14386.cljs$core$IIndexed$_nth$arity$2(null,i__13878_14388);
var map__13890_14390__$1 = (((((!((map__13890_14389 == null))))?(((((map__13890_14389.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13890_14389.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13890_14389):map__13890_14389);
var gline_14391 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13890_14390__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14392 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13890_14390__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14393 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13890_14390__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14391], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13875_14385,chunk__13876_14386,count__13877_14387,i__13878_14388,seq__13742_14317,chunk__13743_14318,count__13744_14319,i__13745_14320,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13890_14389,map__13890_14390__$1,gline_14391,gcol_14392,name_14393,vec__13872_14382,column_14383,column_info_14384,seq__13742_14376__$1,temp__5735__auto___14375__$1,vec__13739_14314,line_14315,columns_14316,seq__13294_14308__$1,temp__5735__auto___14307,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14392], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14315,new cljs.core.Keyword(null,"col","col",-1959363084),column_14383,new cljs.core.Keyword(null,"name","name",1843675177),name_14393], null));
});})(seq__13875_14385,chunk__13876_14386,count__13877_14387,i__13878_14388,seq__13742_14317,chunk__13743_14318,count__13744_14319,i__13745_14320,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13890_14389,map__13890_14390__$1,gline_14391,gcol_14392,name_14393,vec__13872_14382,column_14383,column_info_14384,seq__13742_14376__$1,temp__5735__auto___14375__$1,vec__13739_14314,line_14315,columns_14316,seq__13294_14308__$1,temp__5735__auto___14307,inverted))
,cljs.core.sorted_map()));


var G__14394 = seq__13875_14385;
var G__14395 = chunk__13876_14386;
var G__14396 = count__13877_14387;
var G__14397 = (i__13878_14388 + (1));
seq__13875_14385 = G__14394;
chunk__13876_14386 = G__14395;
count__13877_14387 = G__14396;
i__13878_14388 = G__14397;
continue;
} else {
var temp__5735__auto___14398__$2 = cljs.core.seq(seq__13875_14385);
if(temp__5735__auto___14398__$2){
var seq__13875_14399__$1 = temp__5735__auto___14398__$2;
if(cljs.core.chunked_seq_QMARK_(seq__13875_14399__$1)){
var c__4609__auto___14400 = cljs.core.chunk_first(seq__13875_14399__$1);
var G__14401 = cljs.core.chunk_rest(seq__13875_14399__$1);
var G__14402 = c__4609__auto___14400;
var G__14403 = cljs.core.count(c__4609__auto___14400);
var G__14404 = (0);
seq__13875_14385 = G__14401;
chunk__13876_14386 = G__14402;
count__13877_14387 = G__14403;
i__13878_14388 = G__14404;
continue;
} else {
var map__13895_14405 = cljs.core.first(seq__13875_14399__$1);
var map__13895_14406__$1 = (((((!((map__13895_14405 == null))))?(((((map__13895_14405.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13895_14405.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13895_14405):map__13895_14405);
var gline_14407 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13895_14406__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14408 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13895_14406__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14409 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13895_14406__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14407], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13875_14385,chunk__13876_14386,count__13877_14387,i__13878_14388,seq__13742_14317,chunk__13743_14318,count__13744_14319,i__13745_14320,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13895_14405,map__13895_14406__$1,gline_14407,gcol_14408,name_14409,seq__13875_14399__$1,temp__5735__auto___14398__$2,vec__13872_14382,column_14383,column_info_14384,seq__13742_14376__$1,temp__5735__auto___14375__$1,vec__13739_14314,line_14315,columns_14316,seq__13294_14308__$1,temp__5735__auto___14307,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14408], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14315,new cljs.core.Keyword(null,"col","col",-1959363084),column_14383,new cljs.core.Keyword(null,"name","name",1843675177),name_14409], null));
});})(seq__13875_14385,chunk__13876_14386,count__13877_14387,i__13878_14388,seq__13742_14317,chunk__13743_14318,count__13744_14319,i__13745_14320,seq__13294_14196,chunk__13295_14197,count__13296_14198,i__13297_14199,map__13895_14405,map__13895_14406__$1,gline_14407,gcol_14408,name_14409,seq__13875_14399__$1,temp__5735__auto___14398__$2,vec__13872_14382,column_14383,column_info_14384,seq__13742_14376__$1,temp__5735__auto___14375__$1,vec__13739_14314,line_14315,columns_14316,seq__13294_14308__$1,temp__5735__auto___14307,inverted))
,cljs.core.sorted_map()));


var G__14410 = cljs.core.next(seq__13875_14399__$1);
var G__14411 = null;
var G__14412 = (0);
var G__14413 = (0);
seq__13875_14385 = G__14410;
chunk__13876_14386 = G__14411;
count__13877_14387 = G__14412;
i__13878_14388 = G__14413;
continue;
}
} else {
}
}
break;
}


var G__14414 = cljs.core.next(seq__13742_14376__$1);
var G__14415 = null;
var G__14416 = (0);
var G__14417 = (0);
seq__13742_14317 = G__14414;
chunk__13743_14318 = G__14415;
count__13744_14319 = G__14416;
i__13745_14320 = G__14417;
continue;
}
} else {
}
}
break;
}


var G__14418 = cljs.core.next(seq__13294_14308__$1);
var G__14419 = null;
var G__14420 = (0);
var G__14421 = (0);
seq__13294_14196 = G__14418;
chunk__13295_14197 = G__14419;
count__13296_14198 = G__14420;
i__13297_14199 = G__14421;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
