goog.provide('cljs.compiler');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__15816 = s;
var map__15816__$1 = (((((!((map__15816 == null))))?(((((map__15816.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15816.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15816):map__15816);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15816__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15816__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__15822 = info;
var map__15823 = G__15822;
var map__15823__$1 = (((((!((map__15823 == null))))?(((((map__15823.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15823.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15823):map__15823);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15823__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__15822__$1 = G__15822;
while(true){
var d__$2 = d__$1;
var map__15829 = G__15822__$1;
var map__15829__$1 = (((((!((map__15829 == null))))?(((((map__15829.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15829.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15829):map__15829);
var shadow__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15829__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$2)){
var G__16670 = (d__$2 + (1));
var G__16671 = shadow__$2;
d__$1 = G__16670;
G__15822__$1 = G__16671;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__15834){
var map__15835 = p__15834;
var map__15835__$1 = (((((!((map__15835 == null))))?(((((map__15835.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15835.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15835):map__15835);
var name_var = map__15835__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15835__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15835__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__15840 = info;
var map__15840__$1 = (((((!((map__15840 == null))))?(((((map__15840.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15840.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15840):map__15840);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15840__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15840__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__15842 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__15842) : cljs.compiler.munge.call(null,G__15842));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__15844 = arguments.length;
switch (G__15844) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__15845 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11472,11472,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__15845.cljs$core$IFn$_invoke$arity$1 ? fexpr__15845.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__15845.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__15853 = cp;
switch (G__15853) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__15861_16687 = cljs.core.seq(s);
var chunk__15862_16688 = null;
var count__15863_16689 = (0);
var i__15864_16690 = (0);
while(true){
if((i__15864_16690 < count__15863_16689)){
var c_16691 = chunk__15862_16688.cljs$core$IIndexed$_nth$arity$2(null,i__15864_16690);
sb.append(cljs.compiler.escape_char(c_16691));


var G__16692 = seq__15861_16687;
var G__16693 = chunk__15862_16688;
var G__16694 = count__15863_16689;
var G__16695 = (i__15864_16690 + (1));
seq__15861_16687 = G__16692;
chunk__15862_16688 = G__16693;
count__15863_16689 = G__16694;
i__15864_16690 = G__16695;
continue;
} else {
var temp__5735__auto___16696 = cljs.core.seq(seq__15861_16687);
if(temp__5735__auto___16696){
var seq__15861_16697__$1 = temp__5735__auto___16696;
if(cljs.core.chunked_seq_QMARK_(seq__15861_16697__$1)){
var c__4609__auto___16698 = cljs.core.chunk_first(seq__15861_16697__$1);
var G__16699 = cljs.core.chunk_rest(seq__15861_16697__$1);
var G__16700 = c__4609__auto___16698;
var G__16701 = cljs.core.count(c__4609__auto___16698);
var G__16702 = (0);
seq__15861_16687 = G__16699;
chunk__15862_16688 = G__16700;
count__15863_16689 = G__16701;
i__15864_16690 = G__16702;
continue;
} else {
var c_16703 = cljs.core.first(seq__15861_16697__$1);
sb.append(cljs.compiler.escape_char(c_16703));


var G__16704 = cljs.core.next(seq__15861_16697__$1);
var G__16705 = null;
var G__16706 = (0);
var G__16707 = (0);
seq__15861_16687 = G__16704;
chunk__15862_16688 = G__16705;
count__15863_16689 = G__16706;
i__15864_16690 = G__16707;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__15869 = cljs.core.get_global_hierarchy;
return (fexpr__15869.cljs$core$IFn$_invoke$arity$0 ? fexpr__15869.cljs$core$IFn$_invoke$arity$0() : fexpr__15869.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__15870_16715 = ast;
var map__15870_16716__$1 = (((((!((map__15870_16715 == null))))?(((((map__15870_16715.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15870_16715.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15870_16715):map__15870_16715);
var env_16717 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15870_16716__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_16717))){
var map__15872_16718 = env_16717;
var map__15872_16719__$1 = (((((!((map__15872_16718 == null))))?(((((map__15872_16718.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15872_16718.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15872_16718):map__15872_16718);
var line_16720 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15872_16719__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_16721 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15872_16719__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__15874 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__15876 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__15875 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__15875.cljs$core$IFn$_invoke$arity$1 ? fexpr__15875.cljs$core$IFn$_invoke$arity$1(G__15876) : fexpr__15875.call(null,G__15876));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__15874,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__15874;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_16720 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_16721)?(column_16721 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__15889 = arguments.length;
switch (G__15889) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___16734 = arguments.length;
var i__4790__auto___16735 = (0);
while(true){
if((i__4790__auto___16735 < len__4789__auto___16734)){
args_arr__4810__auto__.push((arguments[i__4790__auto___16735]));

var G__16736 = (i__4790__auto___16735 + (1));
i__4790__auto___16735 = G__16736;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_16747 = (function (){var G__15893 = a;
if((!(typeof a === 'string'))){
return G__15893.toString();
} else {
return G__15893;
}
})();
var temp__5739__auto___16749 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___16749 == null)){
} else {
var sm_data_16754 = temp__5739__auto___16749;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_16754,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__15877_SHARP_){
return (p1__15877_SHARP_ + s_16747.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_16747], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__15905 = cljs.core.seq(xs);
var chunk__15906 = null;
var count__15907 = (0);
var i__15908 = (0);
while(true){
if((i__15908 < count__15907)){
var x = chunk__15906.cljs$core$IIndexed$_nth$arity$2(null,i__15908);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__16761 = seq__15905;
var G__16762 = chunk__15906;
var G__16763 = count__15907;
var G__16764 = (i__15908 + (1));
seq__15905 = G__16761;
chunk__15906 = G__16762;
count__15907 = G__16763;
i__15908 = G__16764;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15905);
if(temp__5735__auto__){
var seq__15905__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15905__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15905__$1);
var G__16765 = cljs.core.chunk_rest(seq__15905__$1);
var G__16766 = c__4609__auto__;
var G__16767 = cljs.core.count(c__4609__auto__);
var G__16768 = (0);
seq__15905 = G__16765;
chunk__15906 = G__16766;
count__15907 = G__16767;
i__15908 = G__16768;
continue;
} else {
var x = cljs.core.first(seq__15905__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__16769 = cljs.core.next(seq__15905__$1);
var G__16770 = null;
var G__16771 = (0);
var G__16772 = (0);
seq__15905 = G__16769;
chunk__15906 = G__16770;
count__15907 = G__16771;
i__15908 = G__16772;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq15883){
var G__15884 = cljs.core.first(seq15883);
var seq15883__$1 = cljs.core.next(seq15883);
var G__15885 = cljs.core.first(seq15883__$1);
var seq15883__$2 = cljs.core.next(seq15883__$1);
var G__15886 = cljs.core.first(seq15883__$2);
var seq15883__$3 = cljs.core.next(seq15883__$2);
var G__15887 = cljs.core.first(seq15883__$3);
var seq15883__$4 = cljs.core.next(seq15883__$3);
var G__15888 = cljs.core.first(seq15883__$4);
var seq15883__$5 = cljs.core.next(seq15883__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15884,G__15885,G__15886,G__15887,G__15888,seq15883__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__15910){
var map__15911 = p__15910;
var map__15911__$1 = (((((!((map__15911 == null))))?(((((map__15911.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15911.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15911):map__15911);
var m = map__15911__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15911__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__15924 = arguments.length;
switch (G__15924) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___16780 = arguments.length;
var i__4790__auto___16781 = (0);
while(true){
if((i__4790__auto___16781 < len__4789__auto___16780)){
args_arr__4810__auto__.push((arguments[i__4790__auto___16781]));

var G__16782 = (i__4790__auto___16781 + (1));
i__4790__auto___16781 = G__16782;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__15930_16783 = cljs.core.seq(xs);
var chunk__15931_16784 = null;
var count__15932_16785 = (0);
var i__15933_16786 = (0);
while(true){
if((i__15933_16786 < count__15932_16785)){
var x_16787 = chunk__15931_16784.cljs$core$IIndexed$_nth$arity$2(null,i__15933_16786);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_16787);


var G__16788 = seq__15930_16783;
var G__16789 = chunk__15931_16784;
var G__16790 = count__15932_16785;
var G__16791 = (i__15933_16786 + (1));
seq__15930_16783 = G__16788;
chunk__15931_16784 = G__16789;
count__15932_16785 = G__16790;
i__15933_16786 = G__16791;
continue;
} else {
var temp__5735__auto___16792 = cljs.core.seq(seq__15930_16783);
if(temp__5735__auto___16792){
var seq__15930_16793__$1 = temp__5735__auto___16792;
if(cljs.core.chunked_seq_QMARK_(seq__15930_16793__$1)){
var c__4609__auto___16794 = cljs.core.chunk_first(seq__15930_16793__$1);
var G__16795 = cljs.core.chunk_rest(seq__15930_16793__$1);
var G__16796 = c__4609__auto___16794;
var G__16797 = cljs.core.count(c__4609__auto___16794);
var G__16798 = (0);
seq__15930_16783 = G__16795;
chunk__15931_16784 = G__16796;
count__15932_16785 = G__16797;
i__15933_16786 = G__16798;
continue;
} else {
var x_16799 = cljs.core.first(seq__15930_16793__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_16799);


var G__16800 = cljs.core.next(seq__15930_16793__$1);
var G__16801 = null;
var G__16802 = (0);
var G__16803 = (0);
seq__15930_16783 = G__16800;
chunk__15931_16784 = G__16801;
count__15932_16785 = G__16802;
i__15933_16786 = G__16803;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq15918){
var G__15919 = cljs.core.first(seq15918);
var seq15918__$1 = cljs.core.next(seq15918);
var G__15920 = cljs.core.first(seq15918__$1);
var seq15918__$2 = cljs.core.next(seq15918__$1);
var G__15921 = cljs.core.first(seq15918__$2);
var seq15918__$3 = cljs.core.next(seq15918__$2);
var G__15922 = cljs.core.first(seq15918__$3);
var seq15918__$4 = cljs.core.next(seq15918__$3);
var G__15923 = cljs.core.first(seq15918__$4);
var seq15918__$5 = cljs.core.next(seq15918__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15919,G__15920,G__15921,G__15922,G__15923,seq15918__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__15935_16808 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__15936_16809 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__15937_16810 = true;
var _STAR_print_fn_STAR__temp_val__15938_16811 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__15937_16810);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__15938_16811);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__15936_16809);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__15935_16808);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__15941 = cljs.core.get_global_hierarchy;
return (fexpr__15941.cljs$core$IFn$_invoke$arity$0 ? fexpr__15941.cljs$core$IFn$_invoke$arity$0() : fexpr__15941.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__15944 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15944,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15944,(1),null);
var G__15947 = ns;
var G__15948 = name;
var G__15949 = (function (){
var G__15950 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__15950) : cljs.compiler.emit_constant.call(null,G__15950));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__15947,G__15948,G__15949) : cljs.compiler.emit_record_value.call(null,G__15947,G__15948,G__15949));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__15952 = cljs.core.keys(x);
var G__15953 = cljs.core.vals(x);
var G__15954 = cljs.compiler.emit_constants_comma_sep;
var G__15955 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__15952,G__15953,G__15954,G__15955) : cljs.compiler.emit_map.call(null,G__15952,G__15953,G__15954,G__15955));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__15956 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__15957 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__15956,G__15957) : cljs.compiler.emit_with_meta.call(null,G__15956,G__15957));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__15977 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15977,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15977,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15977,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__15981 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__15981) : x.call(null,G__15981));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__15982 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__15982) : x.call(null,G__15982));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__15990 = items;
var G__15991 = (function (p1__15989_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__15989_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__15990,G__15991) : cljs.compiler.emit_js_object.call(null,G__15990,G__15991));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__15994){
var map__15995 = p__15994;
var map__15995__$1 = (((((!((map__15995 == null))))?(((((map__15995.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15995.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15995):map__15995);
var ast = map__15995__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15995__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15995__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15995__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__15997 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__15997__$1 = (((((!((map__15997 == null))))?(((((map__15997.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15997.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15997):map__15997);
var cenv = map__15997__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15997__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4185__auto__ = js_module_name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__15999 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4174__auto__ = (function (){var G__16002 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__16002) : cljs.compiler.es5_GT__EQ_.call(null,G__16002));
})();
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4174__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__15999,cljs.analyzer.es5_allowed);
} else {
return G__15999;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4185__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__16004 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__16004,reserved);
} else {
return G__16004;
}
})();
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__16005_16827 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__16005_16828__$1 = (((G__16005_16827 instanceof cljs.core.Keyword))?G__16005_16827.fqn:null);
switch (G__16005_16828__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4174__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__16009){
var map__16010 = p__16009;
var map__16010__$1 = (((((!((map__16010 == null))))?(((((map__16010.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16010.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16010):map__16010);
var arg = map__16010__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16010__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16010__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16010__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16010__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));


var map__16016 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__16016__$1 = (((((!((map__16016 == null))))?(((((map__16016.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16016.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16016):map__16016);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16016__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__16018){
var map__16019 = p__16018;
var map__16019__$1 = (((((!((map__16019 == null))))?(((((map__16019.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16019.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16019):map__16019);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16019__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16019__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16019__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__16021_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__16021_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__16022 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__16022) : comma_sep.call(null,G__16022));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__16023 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__16023) : comma_sep.call(null,G__16023));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__16025){
var map__16026 = p__16025;
var map__16026__$1 = (((((!((map__16026 == null))))?(((((map__16026.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16026.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16026):map__16026);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16026__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16026__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16026__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__16035){
var map__16036 = p__16035;
var map__16036__$1 = (((((!((map__16036 == null))))?(((((map__16036.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16036.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16036):map__16036);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16036__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16036__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__16040_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__16040_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__16041 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__16041) : comma_sep.call(null,G__16041));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__16042){
var map__16043 = p__16042;
var map__16043__$1 = (((((!((map__16043 == null))))?(((((map__16043.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16043.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16043):map__16043);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16043__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16043__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___16845 = cljs.core.seq(items);
if(temp__5735__auto___16845){
var items_16846__$1 = temp__5735__auto___16845;
var vec__16049_16847 = items_16846__$1;
var seq__16050_16848 = cljs.core.seq(vec__16049_16847);
var first__16051_16849 = cljs.core.first(seq__16050_16848);
var seq__16050_16850__$1 = cljs.core.next(seq__16050_16848);
var vec__16052_16851 = first__16051_16849;
var k_16852 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16052_16851,(0),null);
var v_16853 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16052_16851,(1),null);
var r_16854 = seq__16050_16850__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_16852),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16853) : emit_js_object_val.call(null,v_16853)));

var seq__16055_16855 = cljs.core.seq(r_16854);
var chunk__16056_16856 = null;
var count__16057_16857 = (0);
var i__16058_16858 = (0);
while(true){
if((i__16058_16858 < count__16057_16857)){
var vec__16067_16860 = chunk__16056_16856.cljs$core$IIndexed$_nth$arity$2(null,i__16058_16858);
var k_16861__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16067_16860,(0),null);
var v_16862__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16067_16860,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_16861__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16862__$1) : emit_js_object_val.call(null,v_16862__$1)));


var G__16867 = seq__16055_16855;
var G__16868 = chunk__16056_16856;
var G__16869 = count__16057_16857;
var G__16870 = (i__16058_16858 + (1));
seq__16055_16855 = G__16867;
chunk__16056_16856 = G__16868;
count__16057_16857 = G__16869;
i__16058_16858 = G__16870;
continue;
} else {
var temp__5735__auto___16871__$1 = cljs.core.seq(seq__16055_16855);
if(temp__5735__auto___16871__$1){
var seq__16055_16872__$1 = temp__5735__auto___16871__$1;
if(cljs.core.chunked_seq_QMARK_(seq__16055_16872__$1)){
var c__4609__auto___16873 = cljs.core.chunk_first(seq__16055_16872__$1);
var G__16874 = cljs.core.chunk_rest(seq__16055_16872__$1);
var G__16875 = c__4609__auto___16873;
var G__16876 = cljs.core.count(c__4609__auto___16873);
var G__16877 = (0);
seq__16055_16855 = G__16874;
chunk__16056_16856 = G__16875;
count__16057_16857 = G__16876;
i__16058_16858 = G__16877;
continue;
} else {
var vec__16070_16878 = cljs.core.first(seq__16055_16872__$1);
var k_16879__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16070_16878,(0),null);
var v_16880__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16070_16878,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_16879__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16880__$1) : emit_js_object_val.call(null,v_16880__$1)));


var G__16881 = cljs.core.next(seq__16055_16872__$1);
var G__16882 = null;
var G__16883 = (0);
var G__16884 = (0);
seq__16055_16855 = G__16881;
chunk__16056_16856 = G__16882;
count__16057_16857 = G__16883;
i__16058_16858 = G__16884;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__16073){
var map__16074 = p__16073;
var map__16074__$1 = (((((!((map__16074 == null))))?(((((map__16074.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16074.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16074):map__16074);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16074__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16074__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16074__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__16076){
var map__16077 = p__16076;
var map__16077__$1 = (((((!((map__16077 == null))))?(((((map__16077.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16077.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16077):map__16077);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16077__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16077__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__16083){
var map__16084 = p__16083;
var map__16084__$1 = (((((!((map__16084 == null))))?(((((map__16084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16084.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16084):map__16084);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16084__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__16086){
var map__16087 = p__16086;
var map__16087__$1 = (((((!((map__16087 == null))))?(((((map__16087.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16087.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16087):map__16087);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16087__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16087__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__16090 = cljs.analyzer.unwrap_quote(expr);
var map__16090__$1 = (((((!((map__16090 == null))))?(((((map__16090.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16090.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16090):map__16090);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16090__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16090__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16090__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4174__auto__ = form;
if(cljs.core.truth_(and__4174__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4174__auto__;
}
})():false);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__16092 = cljs.analyzer.unwrap_quote(expr);
var map__16092__$1 = (((((!((map__16092 == null))))?(((((map__16092.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16092.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16092):map__16092);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16092__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16092__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16092__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4185__auto__){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4185__auto__ = (function (){var fexpr__16096 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__16096.cljs$core$IFn$_invoke$arity$1 ? fexpr__16096.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__16096.call(null,tag));
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__16098){
var map__16099 = p__16098;
var map__16099__$1 = (((((!((map__16099 == null))))?(((((map__16099.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16099.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16099):map__16099);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16099__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16099__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16099__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16099__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16099__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4185__auto__ = unchecked;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__16101){
var map__16102 = p__16101;
var map__16102__$1 = (((((!((map__16102 == null))))?(((((map__16102.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16102.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16102):map__16102);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16102__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16102__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16102__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16102__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__16104_16912 = cljs.core.seq(nodes);
var chunk__16105_16913 = null;
var count__16106_16914 = (0);
var i__16107_16915 = (0);
while(true){
if((i__16107_16915 < count__16106_16914)){
var map__16133_16916 = chunk__16105_16913.cljs$core$IIndexed$_nth$arity$2(null,i__16107_16915);
var map__16133_16917__$1 = (((((!((map__16133_16916 == null))))?(((((map__16133_16916.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16133_16916.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16133_16916):map__16133_16916);
var ts_16918 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16133_16917__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__16134_16919 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16133_16917__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__16134_16920__$1 = (((((!((map__16134_16919 == null))))?(((((map__16134_16919.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16134_16919.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16134_16919):map__16134_16919);
var then_16921 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16134_16920__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__16137_16923 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_16918));
var chunk__16138_16924 = null;
var count__16139_16925 = (0);
var i__16140_16926 = (0);
while(true){
if((i__16140_16926 < count__16139_16925)){
var test_16927 = chunk__16138_16924.cljs$core$IIndexed$_nth$arity$2(null,i__16140_16926);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16927,":");


var G__16930 = seq__16137_16923;
var G__16931 = chunk__16138_16924;
var G__16932 = count__16139_16925;
var G__16933 = (i__16140_16926 + (1));
seq__16137_16923 = G__16930;
chunk__16138_16924 = G__16931;
count__16139_16925 = G__16932;
i__16140_16926 = G__16933;
continue;
} else {
var temp__5735__auto___16936 = cljs.core.seq(seq__16137_16923);
if(temp__5735__auto___16936){
var seq__16137_16937__$1 = temp__5735__auto___16936;
if(cljs.core.chunked_seq_QMARK_(seq__16137_16937__$1)){
var c__4609__auto___16938 = cljs.core.chunk_first(seq__16137_16937__$1);
var G__16939 = cljs.core.chunk_rest(seq__16137_16937__$1);
var G__16940 = c__4609__auto___16938;
var G__16941 = cljs.core.count(c__4609__auto___16938);
var G__16942 = (0);
seq__16137_16923 = G__16939;
chunk__16138_16924 = G__16940;
count__16139_16925 = G__16941;
i__16140_16926 = G__16942;
continue;
} else {
var test_16943 = cljs.core.first(seq__16137_16937__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16943,":");


var G__16944 = cljs.core.next(seq__16137_16937__$1);
var G__16945 = null;
var G__16946 = (0);
var G__16947 = (0);
seq__16137_16923 = G__16944;
chunk__16138_16924 = G__16945;
count__16139_16925 = G__16946;
i__16140_16926 = G__16947;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_16921);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_16921);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__16948 = seq__16104_16912;
var G__16949 = chunk__16105_16913;
var G__16950 = count__16106_16914;
var G__16951 = (i__16107_16915 + (1));
seq__16104_16912 = G__16948;
chunk__16105_16913 = G__16949;
count__16106_16914 = G__16950;
i__16107_16915 = G__16951;
continue;
} else {
var temp__5735__auto___16952 = cljs.core.seq(seq__16104_16912);
if(temp__5735__auto___16952){
var seq__16104_16953__$1 = temp__5735__auto___16952;
if(cljs.core.chunked_seq_QMARK_(seq__16104_16953__$1)){
var c__4609__auto___16954 = cljs.core.chunk_first(seq__16104_16953__$1);
var G__16955 = cljs.core.chunk_rest(seq__16104_16953__$1);
var G__16956 = c__4609__auto___16954;
var G__16957 = cljs.core.count(c__4609__auto___16954);
var G__16958 = (0);
seq__16104_16912 = G__16955;
chunk__16105_16913 = G__16956;
count__16106_16914 = G__16957;
i__16107_16915 = G__16958;
continue;
} else {
var map__16153_16959 = cljs.core.first(seq__16104_16953__$1);
var map__16153_16960__$1 = (((((!((map__16153_16959 == null))))?(((((map__16153_16959.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16153_16959.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16153_16959):map__16153_16959);
var ts_16961 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16153_16960__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__16154_16962 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16153_16960__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__16154_16963__$1 = (((((!((map__16154_16962 == null))))?(((((map__16154_16962.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16154_16962.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16154_16962):map__16154_16962);
var then_16964 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16154_16963__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__16161_16965 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_16961));
var chunk__16162_16966 = null;
var count__16163_16967 = (0);
var i__16164_16968 = (0);
while(true){
if((i__16164_16968 < count__16163_16967)){
var test_16969 = chunk__16162_16966.cljs$core$IIndexed$_nth$arity$2(null,i__16164_16968);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16969,":");


var G__16970 = seq__16161_16965;
var G__16971 = chunk__16162_16966;
var G__16972 = count__16163_16967;
var G__16973 = (i__16164_16968 + (1));
seq__16161_16965 = G__16970;
chunk__16162_16966 = G__16971;
count__16163_16967 = G__16972;
i__16164_16968 = G__16973;
continue;
} else {
var temp__5735__auto___16974__$1 = cljs.core.seq(seq__16161_16965);
if(temp__5735__auto___16974__$1){
var seq__16161_16975__$1 = temp__5735__auto___16974__$1;
if(cljs.core.chunked_seq_QMARK_(seq__16161_16975__$1)){
var c__4609__auto___16976 = cljs.core.chunk_first(seq__16161_16975__$1);
var G__16977 = cljs.core.chunk_rest(seq__16161_16975__$1);
var G__16978 = c__4609__auto___16976;
var G__16979 = cljs.core.count(c__4609__auto___16976);
var G__16980 = (0);
seq__16161_16965 = G__16977;
chunk__16162_16966 = G__16978;
count__16163_16967 = G__16979;
i__16164_16968 = G__16980;
continue;
} else {
var test_16981 = cljs.core.first(seq__16161_16975__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16981,":");


var G__16982 = cljs.core.next(seq__16161_16975__$1);
var G__16983 = null;
var G__16984 = (0);
var G__16985 = (0);
seq__16161_16965 = G__16982;
chunk__16162_16966 = G__16983;
count__16163_16967 = G__16984;
i__16164_16968 = G__16985;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_16964);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_16964);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__16986 = cljs.core.next(seq__16104_16953__$1);
var G__16987 = null;
var G__16988 = (0);
var G__16989 = (0);
seq__16104_16912 = G__16986;
chunk__16105_16913 = G__16987;
count__16106_16914 = G__16988;
i__16107_16915 = G__16989;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__16165){
var map__16166 = p__16165;
var map__16166__$1 = (((((!((map__16166 == null))))?(((((map__16166.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16166.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16166):map__16166);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16166__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16166__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__16171 = env;
var G__16172 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__16171,G__16172) : cljs.compiler.resolve_type.call(null,G__16171,G__16172));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__16173 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16173,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16173,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__16168_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__16168_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__16168_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__16176 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__16176,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__16176;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__16179 = env;
var G__16180 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__16179,G__16180) : cljs.compiler.resolve_type.call(null,G__16179,G__16180));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16181_SHARP_){
return cljs.compiler.resolve_type(env,p1__16181_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__16183 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__16184 = cljs.core.seq(vec__16183);
var first__16185 = cljs.core.first(seq__16184);
var seq__16184__$1 = cljs.core.next(seq__16184);
var p = first__16185;
var first__16185__$1 = cljs.core.first(seq__16184__$1);
var seq__16184__$2 = cljs.core.next(seq__16184__$1);
var ts = first__16185__$1;
var first__16185__$2 = cljs.core.first(seq__16184__$2);
var seq__16184__$3 = cljs.core.next(seq__16184__$2);
var n = first__16185__$2;
var xs = seq__16184__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__16189 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__16190 = cljs.core.seq(vec__16189);
var first__16191 = cljs.core.first(seq__16190);
var seq__16190__$1 = cljs.core.next(seq__16190);
var p = first__16191;
var first__16191__$1 = cljs.core.first(seq__16190__$1);
var seq__16190__$2 = cljs.core.next(seq__16190__$1);
var ts = first__16191__$1;
var xs = seq__16190__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__16194 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__16193 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__16193.cljs$core$IFn$_invoke$arity$1 ? fexpr__16193.cljs$core$IFn$_invoke$arity$1(G__16194) : fexpr__16193.call(null,G__16194));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__16197 = arguments.length;
switch (G__16197) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__16205 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16195_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__16195_SHARP_);
} else {
return p1__16195_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__16206 = cljs.core.seq(vec__16205);
var first__16207 = cljs.core.first(seq__16206);
var seq__16206__$1 = cljs.core.next(seq__16206);
var x = first__16207;
var ys = seq__16206__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__16208 = cljs.core.seq(ys);
var chunk__16209 = null;
var count__16210 = (0);
var i__16211 = (0);
while(true){
if((i__16211 < count__16210)){
var next_line = chunk__16209.cljs$core$IIndexed$_nth$arity$2(null,i__16211);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__17017 = seq__16208;
var G__17018 = chunk__16209;
var G__17019 = count__16210;
var G__17020 = (i__16211 + (1));
seq__16208 = G__17017;
chunk__16209 = G__17018;
count__16210 = G__17019;
i__16211 = G__17020;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__16208);
if(temp__5735__auto__){
var seq__16208__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16208__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__16208__$1);
var G__17026 = cljs.core.chunk_rest(seq__16208__$1);
var G__17027 = c__4609__auto__;
var G__17028 = cljs.core.count(c__4609__auto__);
var G__17029 = (0);
seq__16208 = G__17026;
chunk__16209 = G__17027;
count__16210 = G__17028;
i__16211 = G__17029;
continue;
} else {
var next_line = cljs.core.first(seq__16208__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__17030 = cljs.core.next(seq__16208__$1);
var G__17031 = null;
var G__17032 = (0);
var G__17033 = (0);
seq__16208 = G__17030;
chunk__16209 = G__17031;
count__16210 = G__17032;
i__16211 = G__17033;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__16212_17034 = cljs.core.seq(docs__$2);
var chunk__16213_17035 = null;
var count__16214_17036 = (0);
var i__16215_17037 = (0);
while(true){
if((i__16215_17037 < count__16214_17036)){
var e_17038 = chunk__16213_17035.cljs$core$IIndexed$_nth$arity$2(null,i__16215_17037);
if(cljs.core.truth_(e_17038)){
print_comment_lines(e_17038);
} else {
}


var G__17039 = seq__16212_17034;
var G__17040 = chunk__16213_17035;
var G__17041 = count__16214_17036;
var G__17042 = (i__16215_17037 + (1));
seq__16212_17034 = G__17039;
chunk__16213_17035 = G__17040;
count__16214_17036 = G__17041;
i__16215_17037 = G__17042;
continue;
} else {
var temp__5735__auto___17043 = cljs.core.seq(seq__16212_17034);
if(temp__5735__auto___17043){
var seq__16212_17044__$1 = temp__5735__auto___17043;
if(cljs.core.chunked_seq_QMARK_(seq__16212_17044__$1)){
var c__4609__auto___17045 = cljs.core.chunk_first(seq__16212_17044__$1);
var G__17046 = cljs.core.chunk_rest(seq__16212_17044__$1);
var G__17047 = c__4609__auto___17045;
var G__17048 = cljs.core.count(c__4609__auto___17045);
var G__17049 = (0);
seq__16212_17034 = G__17046;
chunk__16213_17035 = G__17047;
count__16214_17036 = G__17048;
i__16215_17037 = G__17049;
continue;
} else {
var e_17050 = cljs.core.first(seq__16212_17044__$1);
if(cljs.core.truth_(e_17050)){
print_comment_lines(e_17050);
} else {
}


var G__17051 = cljs.core.next(seq__16212_17044__$1);
var G__17052 = null;
var G__17053 = (0);
var G__17054 = (0);
seq__16212_17034 = G__17051;
chunk__16213_17035 = G__17052;
count__16214_17036 = G__17053;
i__16215_17037 = G__17054;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4174__auto__ = cljs.core.some((function (p1__16217_SHARP_){
return goog.string.startsWith(p1__16217_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = opts;
if(cljs.core.truth_(and__4174__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__16218){
var map__16219 = p__16218;
var map__16219__$1 = (((((!((map__16219 == null))))?(((((map__16219.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16219.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16219):map__16219);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16219__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16219__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16219__$1,new cljs.core.Keyword(null,"test","test",577538877));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16219__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16219__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16219__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16219__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16219__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16219__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4185__auto__ = init;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
return test;
} else {
return and__4174__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__16221){
var map__16222 = p__16221;
var map__16222__$1 = (((((!((map__16222 == null))))?(((((map__16222.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16222.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16222):map__16222);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16222__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16222__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16222__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__16224_17064 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__16225_17065 = null;
var count__16226_17066 = (0);
var i__16227_17067 = (0);
while(true){
if((i__16227_17067 < count__16226_17066)){
var vec__16234_17068 = chunk__16225_17065.cljs$core$IIndexed$_nth$arity$2(null,i__16227_17067);
var i_17069 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16234_17068,(0),null);
var param_17070 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16234_17068,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_17070);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__17079 = seq__16224_17064;
var G__17080 = chunk__16225_17065;
var G__17081 = count__16226_17066;
var G__17082 = (i__16227_17067 + (1));
seq__16224_17064 = G__17079;
chunk__16225_17065 = G__17080;
count__16226_17066 = G__17081;
i__16227_17067 = G__17082;
continue;
} else {
var temp__5735__auto___17083 = cljs.core.seq(seq__16224_17064);
if(temp__5735__auto___17083){
var seq__16224_17084__$1 = temp__5735__auto___17083;
if(cljs.core.chunked_seq_QMARK_(seq__16224_17084__$1)){
var c__4609__auto___17085 = cljs.core.chunk_first(seq__16224_17084__$1);
var G__17086 = cljs.core.chunk_rest(seq__16224_17084__$1);
var G__17087 = c__4609__auto___17085;
var G__17088 = cljs.core.count(c__4609__auto___17085);
var G__17089 = (0);
seq__16224_17064 = G__17086;
chunk__16225_17065 = G__17087;
count__16226_17066 = G__17088;
i__16227_17067 = G__17089;
continue;
} else {
var vec__16238_17090 = cljs.core.first(seq__16224_17084__$1);
var i_17091 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16238_17090,(0),null);
var param_17092 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16238_17090,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_17092);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__17093 = cljs.core.next(seq__16224_17084__$1);
var G__17094 = null;
var G__17095 = (0);
var G__17096 = (0);
seq__16224_17064 = G__17093;
chunk__16225_17065 = G__17094;
count__16226_17066 = G__17095;
i__16227_17067 = G__17096;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__16244_17097 = cljs.core.seq(params);
var chunk__16245_17098 = null;
var count__16246_17099 = (0);
var i__16247_17100 = (0);
while(true){
if((i__16247_17100 < count__16246_17099)){
var param_17101 = chunk__16245_17098.cljs$core$IIndexed$_nth$arity$2(null,i__16247_17100);
cljs.compiler.emit(param_17101);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17101,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17102 = seq__16244_17097;
var G__17103 = chunk__16245_17098;
var G__17104 = count__16246_17099;
var G__17105 = (i__16247_17100 + (1));
seq__16244_17097 = G__17102;
chunk__16245_17098 = G__17103;
count__16246_17099 = G__17104;
i__16247_17100 = G__17105;
continue;
} else {
var temp__5735__auto___17106 = cljs.core.seq(seq__16244_17097);
if(temp__5735__auto___17106){
var seq__16244_17107__$1 = temp__5735__auto___17106;
if(cljs.core.chunked_seq_QMARK_(seq__16244_17107__$1)){
var c__4609__auto___17108 = cljs.core.chunk_first(seq__16244_17107__$1);
var G__17109 = cljs.core.chunk_rest(seq__16244_17107__$1);
var G__17110 = c__4609__auto___17108;
var G__17111 = cljs.core.count(c__4609__auto___17108);
var G__17112 = (0);
seq__16244_17097 = G__17109;
chunk__16245_17098 = G__17110;
count__16246_17099 = G__17111;
i__16247_17100 = G__17112;
continue;
} else {
var param_17113 = cljs.core.first(seq__16244_17107__$1);
cljs.compiler.emit(param_17113);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17113,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17114 = cljs.core.next(seq__16244_17107__$1);
var G__17115 = null;
var G__17116 = (0);
var G__17117 = (0);
seq__16244_17097 = G__17114;
chunk__16245_17098 = G__17115;
count__16246_17099 = G__17116;
i__16247_17100 = G__17117;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__16252_17118 = cljs.core.seq(params);
var chunk__16253_17119 = null;
var count__16254_17120 = (0);
var i__16255_17121 = (0);
while(true){
if((i__16255_17121 < count__16254_17120)){
var param_17122 = chunk__16253_17119.cljs$core$IIndexed$_nth$arity$2(null,i__16255_17121);
cljs.compiler.emit(param_17122);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17122,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17123 = seq__16252_17118;
var G__17124 = chunk__16253_17119;
var G__17125 = count__16254_17120;
var G__17126 = (i__16255_17121 + (1));
seq__16252_17118 = G__17123;
chunk__16253_17119 = G__17124;
count__16254_17120 = G__17125;
i__16255_17121 = G__17126;
continue;
} else {
var temp__5735__auto___17127 = cljs.core.seq(seq__16252_17118);
if(temp__5735__auto___17127){
var seq__16252_17128__$1 = temp__5735__auto___17127;
if(cljs.core.chunked_seq_QMARK_(seq__16252_17128__$1)){
var c__4609__auto___17130 = cljs.core.chunk_first(seq__16252_17128__$1);
var G__17131 = cljs.core.chunk_rest(seq__16252_17128__$1);
var G__17132 = c__4609__auto___17130;
var G__17133 = cljs.core.count(c__4609__auto___17130);
var G__17134 = (0);
seq__16252_17118 = G__17131;
chunk__16253_17119 = G__17132;
count__16254_17120 = G__17133;
i__16255_17121 = G__17134;
continue;
} else {
var param_17141 = cljs.core.first(seq__16252_17128__$1);
cljs.compiler.emit(param_17141);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17141,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17143 = cljs.core.next(seq__16252_17128__$1);
var G__17144 = null;
var G__17145 = (0);
var G__17146 = (0);
seq__16252_17118 = G__17143;
chunk__16253_17119 = G__17144;
count__16254_17120 = G__17145;
i__16255_17121 = G__17146;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__16256 = cljs.core.seq(params);
var chunk__16257 = null;
var count__16258 = (0);
var i__16259 = (0);
while(true){
if((i__16259 < count__16258)){
var param = chunk__16257.cljs$core$IIndexed$_nth$arity$2(null,i__16259);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17152 = seq__16256;
var G__17153 = chunk__16257;
var G__17154 = count__16258;
var G__17155 = (i__16259 + (1));
seq__16256 = G__17152;
chunk__16257 = G__17153;
count__16258 = G__17154;
i__16259 = G__17155;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__16256);
if(temp__5735__auto__){
var seq__16256__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16256__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__16256__$1);
var G__17156 = cljs.core.chunk_rest(seq__16256__$1);
var G__17157 = c__4609__auto__;
var G__17158 = cljs.core.count(c__4609__auto__);
var G__17159 = (0);
seq__16256 = G__17156;
chunk__16257 = G__17157;
count__16258 = G__17158;
i__16259 = G__17159;
continue;
} else {
var param = cljs.core.first(seq__16256__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17160 = cljs.core.next(seq__16256__$1);
var G__17161 = null;
var G__17162 = (0);
var G__17163 = (0);
seq__16256 = G__17160;
chunk__16257 = G__17161;
count__16258 = G__17162;
i__16259 = G__17163;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__16260){
var map__16261 = p__16260;
var map__16261__$1 = (((((!((map__16261 == null))))?(((((map__16261.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16261.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16261):map__16261);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16261__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16261__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16261__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16261__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16261__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16261__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__16263){
var map__16264 = p__16263;
var map__16264__$1 = (((((!((map__16264 == null))))?(((((map__16264.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16264.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16264):map__16264);
var f = map__16264__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16264__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16264__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16264__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16264__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16264__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16264__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16264__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16264__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_17167__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_17168 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_17167__$1);
var delegate_name_17169 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_17168),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_17169," = function (");

var seq__16266_17170 = cljs.core.seq(params);
var chunk__16267_17171 = null;
var count__16268_17172 = (0);
var i__16269_17173 = (0);
while(true){
if((i__16269_17173 < count__16268_17172)){
var param_17174 = chunk__16267_17171.cljs$core$IIndexed$_nth$arity$2(null,i__16269_17173);
cljs.compiler.emit(param_17174);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17174,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17175 = seq__16266_17170;
var G__17176 = chunk__16267_17171;
var G__17177 = count__16268_17172;
var G__17178 = (i__16269_17173 + (1));
seq__16266_17170 = G__17175;
chunk__16267_17171 = G__17176;
count__16268_17172 = G__17177;
i__16269_17173 = G__17178;
continue;
} else {
var temp__5735__auto___17179 = cljs.core.seq(seq__16266_17170);
if(temp__5735__auto___17179){
var seq__16266_17180__$1 = temp__5735__auto___17179;
if(cljs.core.chunked_seq_QMARK_(seq__16266_17180__$1)){
var c__4609__auto___17181 = cljs.core.chunk_first(seq__16266_17180__$1);
var G__17182 = cljs.core.chunk_rest(seq__16266_17180__$1);
var G__17183 = c__4609__auto___17181;
var G__17184 = cljs.core.count(c__4609__auto___17181);
var G__17185 = (0);
seq__16266_17170 = G__17182;
chunk__16267_17171 = G__17183;
count__16268_17172 = G__17184;
i__16269_17173 = G__17185;
continue;
} else {
var param_17186 = cljs.core.first(seq__16266_17180__$1);
cljs.compiler.emit(param_17186);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17186,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17187 = cljs.core.next(seq__16266_17180__$1);
var G__17188 = null;
var G__17189 = (0);
var G__17190 = (0);
seq__16266_17170 = G__17187;
chunk__16267_17171 = G__17188;
count__16268_17172 = G__17189;
i__16269_17173 = G__17190;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_17168," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_17193 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_17193,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_17169,".call(this,");

var seq__16272_17194 = cljs.core.seq(params);
var chunk__16273_17195 = null;
var count__16274_17196 = (0);
var i__16275_17197 = (0);
while(true){
if((i__16275_17197 < count__16274_17196)){
var param_17198 = chunk__16273_17195.cljs$core$IIndexed$_nth$arity$2(null,i__16275_17197);
cljs.compiler.emit(param_17198);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17198,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17199 = seq__16272_17194;
var G__17200 = chunk__16273_17195;
var G__17201 = count__16274_17196;
var G__17202 = (i__16275_17197 + (1));
seq__16272_17194 = G__17199;
chunk__16273_17195 = G__17200;
count__16274_17196 = G__17201;
i__16275_17197 = G__17202;
continue;
} else {
var temp__5735__auto___17203 = cljs.core.seq(seq__16272_17194);
if(temp__5735__auto___17203){
var seq__16272_17204__$1 = temp__5735__auto___17203;
if(cljs.core.chunked_seq_QMARK_(seq__16272_17204__$1)){
var c__4609__auto___17205 = cljs.core.chunk_first(seq__16272_17204__$1);
var G__17206 = cljs.core.chunk_rest(seq__16272_17204__$1);
var G__17207 = c__4609__auto___17205;
var G__17208 = cljs.core.count(c__4609__auto___17205);
var G__17209 = (0);
seq__16272_17194 = G__17206;
chunk__16273_17195 = G__17207;
count__16274_17196 = G__17208;
i__16275_17197 = G__17209;
continue;
} else {
var param_17210 = cljs.core.first(seq__16272_17204__$1);
cljs.compiler.emit(param_17210);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_17210,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__17211 = cljs.core.next(seq__16272_17204__$1);
var G__17212 = null;
var G__17213 = (0);
var G__17214 = (0);
seq__16272_17194 = G__17211;
chunk__16273_17195 = G__17212;
count__16274_17196 = G__17213;
i__16275_17197 = G__17214;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_17168,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_17168,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_17167__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_17168,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_17169,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_17168,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__16283){
var map__16284 = p__16283;
var map__16284__$1 = (((((!((map__16284 == null))))?(((((map__16284.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16284.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16284):map__16284);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16284__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16284__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16284__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16284__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16284__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16284__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16284__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16284__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__16276_SHARP_){
var and__4174__auto__ = p1__16276_SHARP_;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__16276_SHARP_));
} else {
return and__4174__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4185__auto__ = in_loop;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_17229__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_17230 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_17229__$1);
var maxparams_17231 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_17232 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_17230),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_17233 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__16278_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__16278_SHARP_)));
}),cljs.core.seq(mmap_17232));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_17230," = null;");

var seq__16286_17236 = cljs.core.seq(ms_17233);
var chunk__16287_17237 = null;
var count__16288_17238 = (0);
var i__16289_17239 = (0);
while(true){
if((i__16289_17239 < count__16288_17238)){
var vec__16296_17240 = chunk__16287_17237.cljs$core$IIndexed$_nth$arity$2(null,i__16289_17239);
var n_17241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16296_17240,(0),null);
var meth_17242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16296_17240,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_17241," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_17242))){
cljs.compiler.emit_variadic_fn_method(meth_17242);
} else {
cljs.compiler.emit_fn_method(meth_17242);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__17243 = seq__16286_17236;
var G__17244 = chunk__16287_17237;
var G__17245 = count__16288_17238;
var G__17246 = (i__16289_17239 + (1));
seq__16286_17236 = G__17243;
chunk__16287_17237 = G__17244;
count__16288_17238 = G__17245;
i__16289_17239 = G__17246;
continue;
} else {
var temp__5735__auto___17247 = cljs.core.seq(seq__16286_17236);
if(temp__5735__auto___17247){
var seq__16286_17248__$1 = temp__5735__auto___17247;
if(cljs.core.chunked_seq_QMARK_(seq__16286_17248__$1)){
var c__4609__auto___17249 = cljs.core.chunk_first(seq__16286_17248__$1);
var G__17250 = cljs.core.chunk_rest(seq__16286_17248__$1);
var G__17251 = c__4609__auto___17249;
var G__17252 = cljs.core.count(c__4609__auto___17249);
var G__17253 = (0);
seq__16286_17236 = G__17250;
chunk__16287_17237 = G__17251;
count__16288_17238 = G__17252;
i__16289_17239 = G__17253;
continue;
} else {
var vec__16301_17254 = cljs.core.first(seq__16286_17248__$1);
var n_17255 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16301_17254,(0),null);
var meth_17256 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16301_17254,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_17255," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_17256))){
cljs.compiler.emit_variadic_fn_method(meth_17256);
} else {
cljs.compiler.emit_fn_method(meth_17256);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__17257 = cljs.core.next(seq__16286_17248__$1);
var G__17258 = null;
var G__17259 = (0);
var G__17260 = (0);
seq__16286_17236 = G__17257;
chunk__16287_17237 = G__17258;
count__16288_17238 = G__17259;
i__16289_17239 = G__17260;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_17230," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_17231),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_17231)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_17231));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__16304_17263 = cljs.core.seq(ms_17233);
var chunk__16305_17264 = null;
var count__16306_17265 = (0);
var i__16307_17266 = (0);
while(true){
if((i__16307_17266 < count__16306_17265)){
var vec__16314_17268 = chunk__16305_17264.cljs$core$IIndexed$_nth$arity$2(null,i__16307_17266);
var n_17269 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16314_17268,(0),null);
var meth_17270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16314_17268,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_17270))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_17271 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_17271," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_17272 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_17271," = new cljs.core.IndexedSeq(",a_17272,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_17269,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_17231)),(((cljs.core.count(maxparams_17231) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_17271,");"], 0));
} else {
var pcnt_17273 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_17270));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_17273,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_17269,".call(this",(((pcnt_17273 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_17273,maxparams_17231)),null,(1),null)),(2),null))),");");
}


var G__17276 = seq__16304_17263;
var G__17277 = chunk__16305_17264;
var G__17278 = count__16306_17265;
var G__17279 = (i__16307_17266 + (1));
seq__16304_17263 = G__17276;
chunk__16305_17264 = G__17277;
count__16306_17265 = G__17278;
i__16307_17266 = G__17279;
continue;
} else {
var temp__5735__auto___17280 = cljs.core.seq(seq__16304_17263);
if(temp__5735__auto___17280){
var seq__16304_17281__$1 = temp__5735__auto___17280;
if(cljs.core.chunked_seq_QMARK_(seq__16304_17281__$1)){
var c__4609__auto___17282 = cljs.core.chunk_first(seq__16304_17281__$1);
var G__17283 = cljs.core.chunk_rest(seq__16304_17281__$1);
var G__17284 = c__4609__auto___17282;
var G__17285 = cljs.core.count(c__4609__auto___17282);
var G__17286 = (0);
seq__16304_17263 = G__17283;
chunk__16305_17264 = G__17284;
count__16306_17265 = G__17285;
i__16307_17266 = G__17286;
continue;
} else {
var vec__16317_17287 = cljs.core.first(seq__16304_17281__$1);
var n_17288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16317_17287,(0),null);
var meth_17289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16317_17287,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_17289))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_17290 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_17290," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_17291 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_17290," = new cljs.core.IndexedSeq(",a_17291,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_17288,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_17231)),(((cljs.core.count(maxparams_17231) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_17290,");"], 0));
} else {
var pcnt_17292 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_17289));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_17292,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_17288,".call(this",(((pcnt_17292 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_17292,maxparams_17231)),null,(1),null)),(2),null))),");");
}


var G__17295 = cljs.core.next(seq__16304_17281__$1);
var G__17296 = null;
var G__17297 = (0);
var G__17298 = (0);
seq__16304_17263 = G__17295;
chunk__16305_17264 = G__17296;
count__16306_17265 = G__17297;
i__16307_17266 = G__17298;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_17299 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_17233)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_17299,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_17230,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_17230,".cljs$lang$applyTo = ",cljs.core.some((function (p1__16281_SHARP_){
var vec__16320 = p1__16281_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16320,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16320,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_17233),".cljs$lang$applyTo;");
} else {
}

var seq__16323_17301 = cljs.core.seq(ms_17233);
var chunk__16324_17302 = null;
var count__16325_17303 = (0);
var i__16326_17304 = (0);
while(true){
if((i__16326_17304 < count__16325_17303)){
var vec__16333_17305 = chunk__16324_17302.cljs$core$IIndexed$_nth$arity$2(null,i__16326_17304);
var n_17306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16333_17305,(0),null);
var meth_17307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16333_17305,(1),null);
var c_17308 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_17307));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_17307))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_17230,".cljs$core$IFn$_invoke$arity$variadic = ",n_17306,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_17230,".cljs$core$IFn$_invoke$arity$",c_17308," = ",n_17306,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__17309 = seq__16323_17301;
var G__17310 = chunk__16324_17302;
var G__17311 = count__16325_17303;
var G__17312 = (i__16326_17304 + (1));
seq__16323_17301 = G__17309;
chunk__16324_17302 = G__17310;
count__16325_17303 = G__17311;
i__16326_17304 = G__17312;
continue;
} else {
var temp__5735__auto___17313 = cljs.core.seq(seq__16323_17301);
if(temp__5735__auto___17313){
var seq__16323_17314__$1 = temp__5735__auto___17313;
if(cljs.core.chunked_seq_QMARK_(seq__16323_17314__$1)){
var c__4609__auto___17315 = cljs.core.chunk_first(seq__16323_17314__$1);
var G__17316 = cljs.core.chunk_rest(seq__16323_17314__$1);
var G__17317 = c__4609__auto___17315;
var G__17318 = cljs.core.count(c__4609__auto___17315);
var G__17319 = (0);
seq__16323_17301 = G__17316;
chunk__16324_17302 = G__17317;
count__16325_17303 = G__17318;
i__16326_17304 = G__17319;
continue;
} else {
var vec__16336_17320 = cljs.core.first(seq__16323_17314__$1);
var n_17321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16336_17320,(0),null);
var meth_17322 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16336_17320,(1),null);
var c_17323 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_17322));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_17322))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_17230,".cljs$core$IFn$_invoke$arity$variadic = ",n_17321,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_17230,".cljs$core$IFn$_invoke$arity$",c_17323," = ",n_17321,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__17324 = cljs.core.next(seq__16323_17314__$1);
var G__17325 = null;
var G__17326 = (0);
var G__17327 = (0);
seq__16323_17301 = G__17324;
chunk__16324_17302 = G__17325;
count__16325_17303 = G__17326;
i__16326_17304 = G__17327;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_17230,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__16339){
var map__16340 = p__16339;
var map__16340__$1 = (((((!((map__16340 == null))))?(((((map__16340.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16340.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16340):map__16340);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16340__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16340__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16340__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__16342_17332 = cljs.core.seq(statements);
var chunk__16343_17333 = null;
var count__16344_17334 = (0);
var i__16345_17335 = (0);
while(true){
if((i__16345_17335 < count__16344_17334)){
var s_17336 = chunk__16343_17333.cljs$core$IIndexed$_nth$arity$2(null,i__16345_17335);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_17336);


var G__17337 = seq__16342_17332;
var G__17338 = chunk__16343_17333;
var G__17339 = count__16344_17334;
var G__17340 = (i__16345_17335 + (1));
seq__16342_17332 = G__17337;
chunk__16343_17333 = G__17338;
count__16344_17334 = G__17339;
i__16345_17335 = G__17340;
continue;
} else {
var temp__5735__auto___17341 = cljs.core.seq(seq__16342_17332);
if(temp__5735__auto___17341){
var seq__16342_17342__$1 = temp__5735__auto___17341;
if(cljs.core.chunked_seq_QMARK_(seq__16342_17342__$1)){
var c__4609__auto___17343 = cljs.core.chunk_first(seq__16342_17342__$1);
var G__17344 = cljs.core.chunk_rest(seq__16342_17342__$1);
var G__17345 = c__4609__auto___17343;
var G__17346 = cljs.core.count(c__4609__auto___17343);
var G__17347 = (0);
seq__16342_17332 = G__17344;
chunk__16343_17333 = G__17345;
count__16344_17334 = G__17346;
i__16345_17335 = G__17347;
continue;
} else {
var s_17348 = cljs.core.first(seq__16342_17342__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_17348);


var G__17349 = cljs.core.next(seq__16342_17342__$1);
var G__17350 = null;
var G__17351 = (0);
var G__17352 = (0);
seq__16342_17332 = G__17349;
chunk__16343_17333 = G__17350;
count__16344_17334 = G__17351;
i__16345_17335 = G__17352;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__16346){
var map__16347 = p__16346;
var map__16347__$1 = (((((!((map__16347 == null))))?(((((map__16347.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16347.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16347):map__16347);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16347__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16347__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16347__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16347__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16347__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__16349,is_loop){
var map__16350 = p__16349;
var map__16350__$1 = (((((!((map__16350 == null))))?(((((map__16350.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16350.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16350):map__16350);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16350__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16350__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16350__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__16352_17353 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__16353_17354 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__16353_17354);

try{var seq__16354_17355 = cljs.core.seq(bindings);
var chunk__16355_17356 = null;
var count__16356_17357 = (0);
var i__16357_17358 = (0);
while(true){
if((i__16357_17358 < count__16356_17357)){
var map__16362_17360 = chunk__16355_17356.cljs$core$IIndexed$_nth$arity$2(null,i__16357_17358);
var map__16362_17361__$1 = (((((!((map__16362_17360 == null))))?(((((map__16362_17360.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16362_17360.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16362_17360):map__16362_17360);
var binding_17362 = map__16362_17361__$1;
var init_17363 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16362_17361__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_17362);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_17363,";");


var G__17364 = seq__16354_17355;
var G__17365 = chunk__16355_17356;
var G__17366 = count__16356_17357;
var G__17367 = (i__16357_17358 + (1));
seq__16354_17355 = G__17364;
chunk__16355_17356 = G__17365;
count__16356_17357 = G__17366;
i__16357_17358 = G__17367;
continue;
} else {
var temp__5735__auto___17368 = cljs.core.seq(seq__16354_17355);
if(temp__5735__auto___17368){
var seq__16354_17369__$1 = temp__5735__auto___17368;
if(cljs.core.chunked_seq_QMARK_(seq__16354_17369__$1)){
var c__4609__auto___17370 = cljs.core.chunk_first(seq__16354_17369__$1);
var G__17371 = cljs.core.chunk_rest(seq__16354_17369__$1);
var G__17372 = c__4609__auto___17370;
var G__17373 = cljs.core.count(c__4609__auto___17370);
var G__17374 = (0);
seq__16354_17355 = G__17371;
chunk__16355_17356 = G__17372;
count__16356_17357 = G__17373;
i__16357_17358 = G__17374;
continue;
} else {
var map__16364_17375 = cljs.core.first(seq__16354_17369__$1);
var map__16364_17376__$1 = (((((!((map__16364_17375 == null))))?(((((map__16364_17375.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16364_17375.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16364_17375):map__16364_17375);
var binding_17377 = map__16364_17376__$1;
var init_17378 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16364_17376__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_17377);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_17378,";");


var G__17383 = cljs.core.next(seq__16354_17369__$1);
var G__17384 = null;
var G__17385 = (0);
var G__17386 = (0);
seq__16354_17355 = G__17383;
chunk__16355_17356 = G__17384;
count__16356_17357 = G__17385;
i__16357_17358 = G__17386;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__16352_17353);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__16366){
var map__16367 = p__16366;
var map__16367__$1 = (((((!((map__16367 == null))))?(((((map__16367.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16367.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16367):map__16367);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16367__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16367__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16367__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4666__auto___17387 = cljs.core.count(exprs);
var i_17388 = (0);
while(true){
if((i_17388 < n__4666__auto___17387)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_17388) : temps.call(null,i_17388))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_17388) : exprs.call(null,i_17388)),";");

var G__17389 = (i_17388 + (1));
i_17388 = G__17389;
continue;
} else {
}
break;
}

var n__4666__auto___17390 = cljs.core.count(exprs);
var i_17391 = (0);
while(true){
if((i_17391 < n__4666__auto___17390)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_17391) : params.call(null,i_17391)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_17391) : temps.call(null,i_17391)),";");

var G__17392 = (i_17391 + (1));
i_17391 = G__17392;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__16372){
var map__16373 = p__16372;
var map__16373__$1 = (((((!((map__16373 == null))))?(((((map__16373.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16373.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16373):map__16373);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16373__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16373__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16373__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__16375_17397 = cljs.core.seq(bindings);
var chunk__16376_17398 = null;
var count__16377_17399 = (0);
var i__16378_17400 = (0);
while(true){
if((i__16378_17400 < count__16377_17399)){
var map__16383_17401 = chunk__16376_17398.cljs$core$IIndexed$_nth$arity$2(null,i__16378_17400);
var map__16383_17402__$1 = (((((!((map__16383_17401 == null))))?(((((map__16383_17401.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16383_17401.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16383_17401):map__16383_17401);
var binding_17403 = map__16383_17402__$1;
var init_17404 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16383_17402__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_17403)," = ",init_17404,";");


var G__17405 = seq__16375_17397;
var G__17406 = chunk__16376_17398;
var G__17407 = count__16377_17399;
var G__17408 = (i__16378_17400 + (1));
seq__16375_17397 = G__17405;
chunk__16376_17398 = G__17406;
count__16377_17399 = G__17407;
i__16378_17400 = G__17408;
continue;
} else {
var temp__5735__auto___17409 = cljs.core.seq(seq__16375_17397);
if(temp__5735__auto___17409){
var seq__16375_17410__$1 = temp__5735__auto___17409;
if(cljs.core.chunked_seq_QMARK_(seq__16375_17410__$1)){
var c__4609__auto___17411 = cljs.core.chunk_first(seq__16375_17410__$1);
var G__17412 = cljs.core.chunk_rest(seq__16375_17410__$1);
var G__17413 = c__4609__auto___17411;
var G__17414 = cljs.core.count(c__4609__auto___17411);
var G__17415 = (0);
seq__16375_17397 = G__17412;
chunk__16376_17398 = G__17413;
count__16377_17399 = G__17414;
i__16378_17400 = G__17415;
continue;
} else {
var map__16385_17416 = cljs.core.first(seq__16375_17410__$1);
var map__16385_17417__$1 = (((((!((map__16385_17416 == null))))?(((((map__16385_17416.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16385_17416.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16385_17416):map__16385_17416);
var binding_17418 = map__16385_17417__$1;
var init_17419 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16385_17417__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_17418)," = ",init_17419,";");


var G__17420 = cljs.core.next(seq__16375_17410__$1);
var G__17421 = null;
var G__17422 = (0);
var G__17423 = (0);
seq__16375_17397 = G__17420;
chunk__16376_17398 = G__17421;
count__16377_17399 = G__17422;
i__16378_17400 = G__17423;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__16389){
var map__16390 = p__16389;
var map__16390__$1 = (((((!((map__16390 == null))))?(((((map__16390.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16390.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16390):map__16390);
var expr = map__16390__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16390__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16390__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16390__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
if(cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4174__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4174__auto__ = protocol;
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = tag;
if(cljs.core.truth_(and__4174__auto____$1)){
var or__4185__auto__ = (function (){var and__4174__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto____$2)){
var and__4174__auto____$3 = protocol;
if(cljs.core.truth_(and__4174__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4174__auto____$3;
}
} else {
return and__4174__auto____$2;
}
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var and__4174__auto____$2 = (function (){var or__4185__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4174__auto____$2)){
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__16402 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__16402.cljs$core$IFn$_invoke$arity$1 ? fexpr__16402.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__16402.call(null,tag));
})())){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4174__auto____$2;
}
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__16404 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__16404.cljs$core$IFn$_invoke$arity$1 ? fexpr__16404.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__16404.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4185__auto__){
return or__4185__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__16392 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4174__auto__)){
return (arity > mfa);
} else {
return and__4174__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__16387_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__16387_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__16388_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__16388_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16392,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16392,(1),null);
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_17441 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_17441,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_17442 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_17442,args)),(((mfa_17442 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_17442,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
var G__16409 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__16408 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__16408.cljs$core$IFn$_invoke$arity$1 ? fexpr__16408.cljs$core$IFn$_invoke$arity$1(G__16409) : fexpr__16408.call(null,G__16409));
} else {
return and__4174__auto__;
}
})())){
var fprop_17443 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_17443," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_17443,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_17443," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_17443,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__16410){
var map__16411 = p__16410;
var map__16411__$1 = (((((!((map__16411 == null))))?(((((map__16411.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16411.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16411):map__16411);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16411__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16411__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16411__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__16413){
var map__16414 = p__16413;
var map__16414__$1 = (((((!((map__16414 == null))))?(((((map__16414.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16414.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16414):map__16414);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16414__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16414__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16414__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__16420 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__16420__$1 = (((((!((map__16420 == null))))?(((((map__16420.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16420.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16420):map__16420);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16420__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16420__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__16421 = options;
var map__16421__$1 = (((((!((map__16421 == null))))?(((((map__16421.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16421.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16421):map__16421);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16421__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16421__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__16422 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__16427 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__16427__$1 = (((((!((map__16427 == null))))?(((((map__16427.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16427.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16427):map__16427);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16427__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16427__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16422,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16422,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__16429_17464 = cljs.core.seq(libs_to_load);
var chunk__16430_17465 = null;
var count__16431_17466 = (0);
var i__16432_17467 = (0);
while(true){
if((i__16432_17467 < count__16431_17466)){
var lib_17470 = chunk__16430_17465.cljs$core$IIndexed$_nth$arity$2(null,i__16432_17467);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_17470)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_17470),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_17470),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_17470),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_17470),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_17470,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_17470),"');");
}

}
}
}


var G__17471 = seq__16429_17464;
var G__17472 = chunk__16430_17465;
var G__17473 = count__16431_17466;
var G__17474 = (i__16432_17467 + (1));
seq__16429_17464 = G__17471;
chunk__16430_17465 = G__17472;
count__16431_17466 = G__17473;
i__16432_17467 = G__17474;
continue;
} else {
var temp__5735__auto___17475 = cljs.core.seq(seq__16429_17464);
if(temp__5735__auto___17475){
var seq__16429_17476__$1 = temp__5735__auto___17475;
if(cljs.core.chunked_seq_QMARK_(seq__16429_17476__$1)){
var c__4609__auto___17477 = cljs.core.chunk_first(seq__16429_17476__$1);
var G__17478 = cljs.core.chunk_rest(seq__16429_17476__$1);
var G__17479 = c__4609__auto___17477;
var G__17480 = cljs.core.count(c__4609__auto___17477);
var G__17481 = (0);
seq__16429_17464 = G__17478;
chunk__16430_17465 = G__17479;
count__16431_17466 = G__17480;
i__16432_17467 = G__17481;
continue;
} else {
var lib_17482 = cljs.core.first(seq__16429_17476__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_17482)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_17482),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_17482),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_17482),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_17482),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_17482,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_17482),"');");
}

}
}
}


var G__17487 = cljs.core.next(seq__16429_17476__$1);
var G__17488 = null;
var G__17489 = (0);
var G__17490 = (0);
seq__16429_17464 = G__17487;
chunk__16430_17465 = G__17488;
count__16431_17466 = G__17489;
i__16432_17467 = G__17490;
continue;
}
} else {
}
}
break;
}

var seq__16438_17491 = cljs.core.seq(node_libs);
var chunk__16439_17492 = null;
var count__16440_17493 = (0);
var i__16441_17494 = (0);
while(true){
if((i__16441_17494 < count__16440_17493)){
var lib_17495 = chunk__16439_17492.cljs$core$IIndexed$_nth$arity$2(null,i__16441_17494);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_17495)," = require('",lib_17495,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__17501 = seq__16438_17491;
var G__17502 = chunk__16439_17492;
var G__17503 = count__16440_17493;
var G__17504 = (i__16441_17494 + (1));
seq__16438_17491 = G__17501;
chunk__16439_17492 = G__17502;
count__16440_17493 = G__17503;
i__16441_17494 = G__17504;
continue;
} else {
var temp__5735__auto___17506 = cljs.core.seq(seq__16438_17491);
if(temp__5735__auto___17506){
var seq__16438_17507__$1 = temp__5735__auto___17506;
if(cljs.core.chunked_seq_QMARK_(seq__16438_17507__$1)){
var c__4609__auto___17508 = cljs.core.chunk_first(seq__16438_17507__$1);
var G__17509 = cljs.core.chunk_rest(seq__16438_17507__$1);
var G__17510 = c__4609__auto___17508;
var G__17511 = cljs.core.count(c__4609__auto___17508);
var G__17512 = (0);
seq__16438_17491 = G__17509;
chunk__16439_17492 = G__17510;
count__16440_17493 = G__17511;
i__16441_17494 = G__17512;
continue;
} else {
var lib_17513 = cljs.core.first(seq__16438_17507__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_17513)," = require('",lib_17513,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__17514 = cljs.core.next(seq__16438_17507__$1);
var G__17515 = null;
var G__17516 = (0);
var G__17517 = (0);
seq__16438_17491 = G__17514;
chunk__16439_17492 = G__17515;
count__16440_17493 = G__17516;
i__16441_17494 = G__17517;
continue;
}
} else {
}
}
break;
}

var seq__16443_17518 = cljs.core.seq(global_exports_libs);
var chunk__16444_17519 = null;
var count__16445_17520 = (0);
var i__16446_17521 = (0);
while(true){
if((i__16446_17521 < count__16445_17520)){
var lib_17522 = chunk__16444_17519.cljs$core$IIndexed$_nth$arity$2(null,i__16446_17521);
var map__16456_17523 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_17522));
var map__16456_17524__$1 = (((((!((map__16456_17523 == null))))?(((((map__16456_17523.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16456_17523.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16456_17523):map__16456_17523);
var global_exports_17525 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16456_17524__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_17525,lib_17522);


var G__17526 = seq__16443_17518;
var G__17527 = chunk__16444_17519;
var G__17528 = count__16445_17520;
var G__17529 = (i__16446_17521 + (1));
seq__16443_17518 = G__17526;
chunk__16444_17519 = G__17527;
count__16445_17520 = G__17528;
i__16446_17521 = G__17529;
continue;
} else {
var temp__5735__auto___17530 = cljs.core.seq(seq__16443_17518);
if(temp__5735__auto___17530){
var seq__16443_17531__$1 = temp__5735__auto___17530;
if(cljs.core.chunked_seq_QMARK_(seq__16443_17531__$1)){
var c__4609__auto___17532 = cljs.core.chunk_first(seq__16443_17531__$1);
var G__17533 = cljs.core.chunk_rest(seq__16443_17531__$1);
var G__17534 = c__4609__auto___17532;
var G__17535 = cljs.core.count(c__4609__auto___17532);
var G__17536 = (0);
seq__16443_17518 = G__17533;
chunk__16444_17519 = G__17534;
count__16445_17520 = G__17535;
i__16446_17521 = G__17536;
continue;
} else {
var lib_17539 = cljs.core.first(seq__16443_17531__$1);
var map__16463_17540 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_17539));
var map__16463_17541__$1 = (((((!((map__16463_17540 == null))))?(((((map__16463_17540.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16463_17540.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16463_17540):map__16463_17540);
var global_exports_17542 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16463_17541__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_17542,lib_17539);


var G__17543 = cljs.core.next(seq__16443_17531__$1);
var G__17544 = null;
var G__17545 = (0);
var G__17546 = (0);
seq__16443_17518 = G__17543;
chunk__16444_17519 = G__17544;
count__16445_17520 = G__17545;
i__16446_17521 = G__17546;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__16469){
var map__16470 = p__16469;
var map__16470__$1 = (((((!((map__16470 == null))))?(((((map__16470.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16470.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16470):map__16470);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16470__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16470__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16470__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16470__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16470__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16470__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16470__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__16472){
var map__16473 = p__16472;
var map__16473__$1 = (((((!((map__16473 == null))))?(((((map__16473.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16473.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16473):map__16473);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16473__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16473__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16473__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16473__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16473__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16473__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16473__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__16475){
var map__16476 = p__16475;
var map__16476__$1 = (((((!((map__16476 == null))))?(((((map__16476.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16476.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16476):map__16476);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16476__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16476__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16476__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16476__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16476__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__16478_17549 = cljs.core.seq(protocols);
var chunk__16479_17550 = null;
var count__16480_17551 = (0);
var i__16481_17552 = (0);
while(true){
if((i__16481_17552 < count__16480_17551)){
var protocol_17553 = chunk__16479_17550.cljs$core$IIndexed$_nth$arity$2(null,i__16481_17552);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_17553)),"}");


var G__17554 = seq__16478_17549;
var G__17555 = chunk__16479_17550;
var G__17556 = count__16480_17551;
var G__17557 = (i__16481_17552 + (1));
seq__16478_17549 = G__17554;
chunk__16479_17550 = G__17555;
count__16480_17551 = G__17556;
i__16481_17552 = G__17557;
continue;
} else {
var temp__5735__auto___17558 = cljs.core.seq(seq__16478_17549);
if(temp__5735__auto___17558){
var seq__16478_17559__$1 = temp__5735__auto___17558;
if(cljs.core.chunked_seq_QMARK_(seq__16478_17559__$1)){
var c__4609__auto___17560 = cljs.core.chunk_first(seq__16478_17559__$1);
var G__17561 = cljs.core.chunk_rest(seq__16478_17559__$1);
var G__17562 = c__4609__auto___17560;
var G__17563 = cljs.core.count(c__4609__auto___17560);
var G__17564 = (0);
seq__16478_17549 = G__17561;
chunk__16479_17550 = G__17562;
count__16480_17551 = G__17563;
i__16481_17552 = G__17564;
continue;
} else {
var protocol_17565 = cljs.core.first(seq__16478_17559__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_17565)),"}");


var G__17566 = cljs.core.next(seq__16478_17559__$1);
var G__17567 = null;
var G__17568 = (0);
var G__17569 = (0);
seq__16478_17549 = G__17566;
chunk__16479_17550 = G__17567;
count__16480_17551 = G__17568;
i__16481_17552 = G__17569;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__16482_17570 = cljs.core.seq(fields__$1);
var chunk__16483_17571 = null;
var count__16484_17572 = (0);
var i__16485_17573 = (0);
while(true){
if((i__16485_17573 < count__16484_17572)){
var fld_17574 = chunk__16483_17571.cljs$core$IIndexed$_nth$arity$2(null,i__16485_17573);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_17574," = ",fld_17574,";");


var G__17575 = seq__16482_17570;
var G__17576 = chunk__16483_17571;
var G__17577 = count__16484_17572;
var G__17578 = (i__16485_17573 + (1));
seq__16482_17570 = G__17575;
chunk__16483_17571 = G__17576;
count__16484_17572 = G__17577;
i__16485_17573 = G__17578;
continue;
} else {
var temp__5735__auto___17579 = cljs.core.seq(seq__16482_17570);
if(temp__5735__auto___17579){
var seq__16482_17580__$1 = temp__5735__auto___17579;
if(cljs.core.chunked_seq_QMARK_(seq__16482_17580__$1)){
var c__4609__auto___17581 = cljs.core.chunk_first(seq__16482_17580__$1);
var G__17582 = cljs.core.chunk_rest(seq__16482_17580__$1);
var G__17583 = c__4609__auto___17581;
var G__17584 = cljs.core.count(c__4609__auto___17581);
var G__17585 = (0);
seq__16482_17570 = G__17582;
chunk__16483_17571 = G__17583;
count__16484_17572 = G__17584;
i__16485_17573 = G__17585;
continue;
} else {
var fld_17586 = cljs.core.first(seq__16482_17580__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_17586," = ",fld_17586,";");


var G__17587 = cljs.core.next(seq__16482_17580__$1);
var G__17588 = null;
var G__17589 = (0);
var G__17590 = (0);
seq__16482_17570 = G__17587;
chunk__16483_17571 = G__17588;
count__16484_17572 = G__17589;
i__16485_17573 = G__17590;
continue;
}
} else {
}
}
break;
}

var seq__16498_17591 = cljs.core.seq(pmasks);
var chunk__16499_17592 = null;
var count__16500_17593 = (0);
var i__16501_17594 = (0);
while(true){
if((i__16501_17594 < count__16500_17593)){
var vec__16516_17595 = chunk__16499_17592.cljs$core$IIndexed$_nth$arity$2(null,i__16501_17594);
var pno_17596 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16516_17595,(0),null);
var pmask_17597 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16516_17595,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_17596,"$ = ",pmask_17597,";");


var G__17598 = seq__16498_17591;
var G__17599 = chunk__16499_17592;
var G__17600 = count__16500_17593;
var G__17601 = (i__16501_17594 + (1));
seq__16498_17591 = G__17598;
chunk__16499_17592 = G__17599;
count__16500_17593 = G__17600;
i__16501_17594 = G__17601;
continue;
} else {
var temp__5735__auto___17602 = cljs.core.seq(seq__16498_17591);
if(temp__5735__auto___17602){
var seq__16498_17603__$1 = temp__5735__auto___17602;
if(cljs.core.chunked_seq_QMARK_(seq__16498_17603__$1)){
var c__4609__auto___17604 = cljs.core.chunk_first(seq__16498_17603__$1);
var G__17605 = cljs.core.chunk_rest(seq__16498_17603__$1);
var G__17606 = c__4609__auto___17604;
var G__17607 = cljs.core.count(c__4609__auto___17604);
var G__17608 = (0);
seq__16498_17591 = G__17605;
chunk__16499_17592 = G__17606;
count__16500_17593 = G__17607;
i__16501_17594 = G__17608;
continue;
} else {
var vec__16526_17609 = cljs.core.first(seq__16498_17603__$1);
var pno_17610 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16526_17609,(0),null);
var pmask_17611 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16526_17609,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_17610,"$ = ",pmask_17611,";");


var G__17612 = cljs.core.next(seq__16498_17603__$1);
var G__17613 = null;
var G__17614 = (0);
var G__17615 = (0);
seq__16498_17591 = G__17612;
chunk__16499_17592 = G__17613;
count__16500_17593 = G__17614;
i__16501_17594 = G__17615;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__16536){
var map__16537 = p__16536;
var map__16537__$1 = (((((!((map__16537 == null))))?(((((map__16537.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16537.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16537):map__16537);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16537__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16537__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16537__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16537__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16537__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__16543_17616 = cljs.core.seq(protocols);
var chunk__16544_17617 = null;
var count__16545_17618 = (0);
var i__16546_17619 = (0);
while(true){
if((i__16546_17619 < count__16545_17618)){
var protocol_17620 = chunk__16544_17617.cljs$core$IIndexed$_nth$arity$2(null,i__16546_17619);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_17620)),"}");


var G__17621 = seq__16543_17616;
var G__17622 = chunk__16544_17617;
var G__17623 = count__16545_17618;
var G__17624 = (i__16546_17619 + (1));
seq__16543_17616 = G__17621;
chunk__16544_17617 = G__17622;
count__16545_17618 = G__17623;
i__16546_17619 = G__17624;
continue;
} else {
var temp__5735__auto___17625 = cljs.core.seq(seq__16543_17616);
if(temp__5735__auto___17625){
var seq__16543_17626__$1 = temp__5735__auto___17625;
if(cljs.core.chunked_seq_QMARK_(seq__16543_17626__$1)){
var c__4609__auto___17627 = cljs.core.chunk_first(seq__16543_17626__$1);
var G__17628 = cljs.core.chunk_rest(seq__16543_17626__$1);
var G__17629 = c__4609__auto___17627;
var G__17630 = cljs.core.count(c__4609__auto___17627);
var G__17631 = (0);
seq__16543_17616 = G__17628;
chunk__16544_17617 = G__17629;
count__16545_17618 = G__17630;
i__16546_17619 = G__17631;
continue;
} else {
var protocol_17632 = cljs.core.first(seq__16543_17626__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_17632)),"}");


var G__17633 = cljs.core.next(seq__16543_17626__$1);
var G__17634 = null;
var G__17635 = (0);
var G__17636 = (0);
seq__16543_17616 = G__17633;
chunk__16544_17617 = G__17634;
count__16545_17618 = G__17635;
i__16546_17619 = G__17636;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__16547_17637 = cljs.core.seq(fields__$1);
var chunk__16548_17638 = null;
var count__16549_17639 = (0);
var i__16550_17640 = (0);
while(true){
if((i__16550_17640 < count__16549_17639)){
var fld_17641 = chunk__16548_17638.cljs$core$IIndexed$_nth$arity$2(null,i__16550_17640);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_17641," = ",fld_17641,";");


var G__17642 = seq__16547_17637;
var G__17643 = chunk__16548_17638;
var G__17644 = count__16549_17639;
var G__17645 = (i__16550_17640 + (1));
seq__16547_17637 = G__17642;
chunk__16548_17638 = G__17643;
count__16549_17639 = G__17644;
i__16550_17640 = G__17645;
continue;
} else {
var temp__5735__auto___17646 = cljs.core.seq(seq__16547_17637);
if(temp__5735__auto___17646){
var seq__16547_17647__$1 = temp__5735__auto___17646;
if(cljs.core.chunked_seq_QMARK_(seq__16547_17647__$1)){
var c__4609__auto___17649 = cljs.core.chunk_first(seq__16547_17647__$1);
var G__17650 = cljs.core.chunk_rest(seq__16547_17647__$1);
var G__17651 = c__4609__auto___17649;
var G__17652 = cljs.core.count(c__4609__auto___17649);
var G__17653 = (0);
seq__16547_17637 = G__17650;
chunk__16548_17638 = G__17651;
count__16549_17639 = G__17652;
i__16550_17640 = G__17653;
continue;
} else {
var fld_17654 = cljs.core.first(seq__16547_17647__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_17654," = ",fld_17654,";");


var G__17655 = cljs.core.next(seq__16547_17647__$1);
var G__17656 = null;
var G__17657 = (0);
var G__17658 = (0);
seq__16547_17637 = G__17655;
chunk__16548_17638 = G__17656;
count__16549_17639 = G__17657;
i__16550_17640 = G__17658;
continue;
}
} else {
}
}
break;
}

var seq__16551_17659 = cljs.core.seq(pmasks);
var chunk__16552_17660 = null;
var count__16553_17661 = (0);
var i__16554_17662 = (0);
while(true){
if((i__16554_17662 < count__16553_17661)){
var vec__16561_17666 = chunk__16552_17660.cljs$core$IIndexed$_nth$arity$2(null,i__16554_17662);
var pno_17667 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16561_17666,(0),null);
var pmask_17668 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16561_17666,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_17667,"$ = ",pmask_17668,";");


var G__17669 = seq__16551_17659;
var G__17670 = chunk__16552_17660;
var G__17671 = count__16553_17661;
var G__17672 = (i__16554_17662 + (1));
seq__16551_17659 = G__17669;
chunk__16552_17660 = G__17670;
count__16553_17661 = G__17671;
i__16554_17662 = G__17672;
continue;
} else {
var temp__5735__auto___17673 = cljs.core.seq(seq__16551_17659);
if(temp__5735__auto___17673){
var seq__16551_17674__$1 = temp__5735__auto___17673;
if(cljs.core.chunked_seq_QMARK_(seq__16551_17674__$1)){
var c__4609__auto___17675 = cljs.core.chunk_first(seq__16551_17674__$1);
var G__17676 = cljs.core.chunk_rest(seq__16551_17674__$1);
var G__17677 = c__4609__auto___17675;
var G__17678 = cljs.core.count(c__4609__auto___17675);
var G__17679 = (0);
seq__16551_17659 = G__17676;
chunk__16552_17660 = G__17677;
count__16553_17661 = G__17678;
i__16554_17662 = G__17679;
continue;
} else {
var vec__16564_17680 = cljs.core.first(seq__16551_17674__$1);
var pno_17681 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16564_17680,(0),null);
var pmask_17682 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16564_17680,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_17681,"$ = ",pmask_17682,";");


var G__17683 = cljs.core.next(seq__16551_17674__$1);
var G__17684 = null;
var G__17685 = (0);
var G__17686 = (0);
seq__16551_17659 = G__17683;
chunk__16552_17660 = G__17684;
count__16553_17661 = G__17685;
i__16554_17662 = G__17686;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__16567){
var map__16568 = p__16567;
var map__16568__$1 = (((((!((map__16568 == null))))?(((((map__16568.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16568.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16568):map__16568);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16568__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16568__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16568__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16568__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16568__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__16582){
var map__16583 = p__16582;
var map__16583__$1 = (((((!((map__16583 == null))))?(((((map__16583.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16583.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16583):map__16583);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16583__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16583__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16583__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16583__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16583__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4174__auto__ = code;
if(cljs.core.truth_(and__4174__auto__)){
var G__16591 = clojure.string.trim(code);
var G__16592 = "/*";
return goog.string.startsWith(G__16591,G__16592);
} else {
return and__4174__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__15757__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15757__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__16610 = cljs.core.seq(table);
var chunk__16611 = null;
var count__16612 = (0);
var i__16613 = (0);
while(true){
if((i__16613 < count__16612)){
var vec__16645 = chunk__16611.cljs$core$IIndexed$_nth$arity$2(null,i__16613);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16645,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16645,(1),null);
var ns_17688 = cljs.core.namespace(sym);
var name_17689 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__17691 = seq__16610;
var G__17692 = chunk__16611;
var G__17693 = count__16612;
var G__17694 = (i__16613 + (1));
seq__16610 = G__17691;
chunk__16611 = G__17692;
count__16612 = G__17693;
i__16613 = G__17694;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__16610);
if(temp__5735__auto__){
var seq__16610__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16610__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__16610__$1);
var G__17695 = cljs.core.chunk_rest(seq__16610__$1);
var G__17696 = c__4609__auto__;
var G__17697 = cljs.core.count(c__4609__auto__);
var G__17698 = (0);
seq__16610 = G__17695;
chunk__16611 = G__17696;
count__16612 = G__17697;
i__16613 = G__17698;
continue;
} else {
var vec__16648 = cljs.core.first(seq__16610__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16648,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16648,(1),null);
var ns_17699 = cljs.core.namespace(sym);
var name_17700 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__17701 = cljs.core.next(seq__16610__$1);
var G__17702 = null;
var G__17703 = (0);
var G__17704 = (0);
seq__16610 = G__17701;
chunk__16611 = G__17702;
count__16612 = G__17703;
i__16613 = G__17704;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__16652 = arguments.length;
switch (G__16652) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_17706 = cljs.core.first(ks);
var vec__16655_17707 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_17706);
var top_17708 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16655_17707,(0),null);
var prefix_SINGLEQUOTE__17709 = vec__16655_17707;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_17706)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__17709) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_17708)) || (cljs.core.contains_QMARK_(known_externs,top_17708)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__17709)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_17708);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__17709)),";");
}
} else {
}

var m_17712 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_17706);
if(cljs.core.empty_QMARK_(m_17712)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__17709,m_17712,top_level,known_externs);
}

var G__17713 = cljs.core.next(ks);
ks = G__17713;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

