goog.provide('cljs.source_map');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__12741){
var vec__12742 = p__12741;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12742,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12742,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__12751 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12751,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12751,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12751,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12751,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12751,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__12760 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12760,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12760,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12760,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12760,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12760,(4),null);
var vec__12763 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12763,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12763,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12763,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12763,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12763,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__12769 = segmap;
var map__12769__$1 = (((((!((map__12769 == null))))?(((((map__12769.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12769.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12769):map__12769);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12769__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12769__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12769__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12769__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12769__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__12778 = arguments.length;
switch (G__12778) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__12786 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__13821 = cljs.core.next(segs__$1);
var G__13822 = nrelseg;
var G__13823 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__13821;
relseg__$1 = G__13822;
result__$1 = G__13823;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12786,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12786,(1),null);
var G__13826 = (gline + (1));
var G__13827 = cljs.core.next(lines__$1);
var G__13828 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__13829 = result__$1;
gline = G__13826;
lines__$1 = G__13827;
relseg = G__13828;
result = G__13829;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__12790 = segmap;
var map__12790__$1 = (((((!((map__12790 == null))))?(((((map__12790.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12790.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12790):map__12790);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12790__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12790__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12790__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12790__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12790__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__12789_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__12789_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__12797 = arguments.length;
switch (G__12797) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__12813 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__13843 = cljs.core.next(segs__$1);
var G__13844 = nrelseg;
var G__13845 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__13843;
relseg__$1 = G__13844;
result__$1 = G__13845;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12813,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12813,(1),null);
var G__13849 = (gline + (1));
var G__13850 = cljs.core.next(lines__$1);
var G__13851 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__13852 = result__$1;
gline = G__13849;
lines__$1 = G__13850;
relseg = G__13851;
result = G__13852;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__12818){
var vec__12819 = p__12818;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12819,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12819,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12819,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12819,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12819,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__12822){
var vec__12823 = p__12822;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12823,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12823,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12823,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12823,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12823,(4),null);
var seg = vec__12823;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__12826){
var vec__12827 = p__12826;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12827,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12827,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12827,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12827,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12827,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__12847 = cljs.core.seq(infos);
var chunk__12848 = null;
var count__12849 = (0);
var i__12850 = (0);
while(true){
if((i__12850 < count__12849)){
var info = chunk__12848.cljs$core$IIndexed$_nth$arity$2(null,i__12850);
var segv_13869 = info__GT_segv(info,source_idx,line,col);
var gline_13870 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_13871 = cljs.core.count(cljs.core.deref(lines));
if((gline_13870 > (lc_13871 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12847,chunk__12848,count__12849,i__12850,segv_13869,gline_13870,lc_13871,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_13870 - (lc_13871 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_13869], null));
});})(seq__12847,chunk__12848,count__12849,i__12850,segv_13869,gline_13870,lc_13871,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12847,chunk__12848,count__12849,i__12850,segv_13869,gline_13870,lc_13871,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_13870], null),cljs.core.conj,segv_13869);
});})(seq__12847,chunk__12848,count__12849,i__12850,segv_13869,gline_13870,lc_13871,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__13877 = seq__12847;
var G__13878 = chunk__12848;
var G__13879 = count__12849;
var G__13880 = (i__12850 + (1));
seq__12847 = G__13877;
chunk__12848 = G__13878;
count__12849 = G__13879;
i__12850 = G__13880;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12847);
if(temp__5735__auto__){
var seq__12847__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12847__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__12847__$1);
var G__13881 = cljs.core.chunk_rest(seq__12847__$1);
var G__13882 = c__4609__auto__;
var G__13883 = cljs.core.count(c__4609__auto__);
var G__13884 = (0);
seq__12847 = G__13881;
chunk__12848 = G__13882;
count__12849 = G__13883;
i__12850 = G__13884;
continue;
} else {
var info = cljs.core.first(seq__12847__$1);
var segv_13887 = info__GT_segv(info,source_idx,line,col);
var gline_13888 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_13889 = cljs.core.count(cljs.core.deref(lines));
if((gline_13888 > (lc_13889 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12847,chunk__12848,count__12849,i__12850,segv_13887,gline_13888,lc_13889,info,seq__12847__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_13888 - (lc_13889 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_13887], null));
});})(seq__12847,chunk__12848,count__12849,i__12850,segv_13887,gline_13888,lc_13889,info,seq__12847__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12847,chunk__12848,count__12849,i__12850,segv_13887,gline_13888,lc_13889,info,seq__12847__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_13888], null),cljs.core.conj,segv_13887);
});})(seq__12847,chunk__12848,count__12849,i__12850,segv_13887,gline_13888,lc_13889,info,seq__12847__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__13896 = cljs.core.next(seq__12847__$1);
var G__13897 = null;
var G__13898 = (0);
var G__13899 = (0);
seq__12847 = G__13896;
chunk__12848 = G__13897;
count__12849 = G__13898;
i__12850 = G__13899;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__12866_13900 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__12867_13901 = null;
var count__12868_13902 = (0);
var i__12869_13903 = (0);
while(true){
if((i__12869_13903 < count__12868_13902)){
var vec__13081_13906 = chunk__12867_13901.cljs$core$IIndexed$_nth$arity$2(null,i__12869_13903);
var source_idx_13907 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13081_13906,(0),null);
var vec__13084_13908 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13081_13906,(1),null);
var __13909 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13084_13908,(0),null);
var lines_13910__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13084_13908,(1),null);
var seq__13087_13913 = cljs.core.seq(lines_13910__$1);
var chunk__13088_13914 = null;
var count__13089_13915 = (0);
var i__13090_13916 = (0);
while(true){
if((i__13090_13916 < count__13089_13915)){
var vec__13139_13919 = chunk__13088_13914.cljs$core$IIndexed$_nth$arity$2(null,i__13090_13916);
var line_13920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13139_13919,(0),null);
var cols_13921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13139_13919,(1),null);
var seq__13142_13922 = cljs.core.seq(cols_13921);
var chunk__13143_13923 = null;
var count__13144_13924 = (0);
var i__13145_13925 = (0);
while(true){
if((i__13145_13925 < count__13144_13924)){
var vec__13152_13926 = chunk__13143_13923.cljs$core$IIndexed$_nth$arity$2(null,i__13145_13925);
var col_13927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13152_13926,(0),null);
var infos_13928 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13152_13926,(1),null);
encode_cols(infos_13928,source_idx_13907,line_13920,col_13927);


var G__13930 = seq__13142_13922;
var G__13931 = chunk__13143_13923;
var G__13932 = count__13144_13924;
var G__13933 = (i__13145_13925 + (1));
seq__13142_13922 = G__13930;
chunk__13143_13923 = G__13931;
count__13144_13924 = G__13932;
i__13145_13925 = G__13933;
continue;
} else {
var temp__5735__auto___13934 = cljs.core.seq(seq__13142_13922);
if(temp__5735__auto___13934){
var seq__13142_13936__$1 = temp__5735__auto___13934;
if(cljs.core.chunked_seq_QMARK_(seq__13142_13936__$1)){
var c__4609__auto___13938 = cljs.core.chunk_first(seq__13142_13936__$1);
var G__13939 = cljs.core.chunk_rest(seq__13142_13936__$1);
var G__13940 = c__4609__auto___13938;
var G__13941 = cljs.core.count(c__4609__auto___13938);
var G__13942 = (0);
seq__13142_13922 = G__13939;
chunk__13143_13923 = G__13940;
count__13144_13924 = G__13941;
i__13145_13925 = G__13942;
continue;
} else {
var vec__13156_13945 = cljs.core.first(seq__13142_13936__$1);
var col_13946 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13156_13945,(0),null);
var infos_13947 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13156_13945,(1),null);
encode_cols(infos_13947,source_idx_13907,line_13920,col_13946);


var G__13948 = cljs.core.next(seq__13142_13936__$1);
var G__13949 = null;
var G__13950 = (0);
var G__13951 = (0);
seq__13142_13922 = G__13948;
chunk__13143_13923 = G__13949;
count__13144_13924 = G__13950;
i__13145_13925 = G__13951;
continue;
}
} else {
}
}
break;
}


var G__13952 = seq__13087_13913;
var G__13953 = chunk__13088_13914;
var G__13954 = count__13089_13915;
var G__13955 = (i__13090_13916 + (1));
seq__13087_13913 = G__13952;
chunk__13088_13914 = G__13953;
count__13089_13915 = G__13954;
i__13090_13916 = G__13955;
continue;
} else {
var temp__5735__auto___13956 = cljs.core.seq(seq__13087_13913);
if(temp__5735__auto___13956){
var seq__13087_13958__$1 = temp__5735__auto___13956;
if(cljs.core.chunked_seq_QMARK_(seq__13087_13958__$1)){
var c__4609__auto___13959 = cljs.core.chunk_first(seq__13087_13958__$1);
var G__13960 = cljs.core.chunk_rest(seq__13087_13958__$1);
var G__13961 = c__4609__auto___13959;
var G__13962 = cljs.core.count(c__4609__auto___13959);
var G__13963 = (0);
seq__13087_13913 = G__13960;
chunk__13088_13914 = G__13961;
count__13089_13915 = G__13962;
i__13090_13916 = G__13963;
continue;
} else {
var vec__13160_13964 = cljs.core.first(seq__13087_13958__$1);
var line_13965 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13160_13964,(0),null);
var cols_13966 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13160_13964,(1),null);
var seq__13163_13969 = cljs.core.seq(cols_13966);
var chunk__13164_13970 = null;
var count__13165_13971 = (0);
var i__13166_13972 = (0);
while(true){
if((i__13166_13972 < count__13165_13971)){
var vec__13175_13975 = chunk__13164_13970.cljs$core$IIndexed$_nth$arity$2(null,i__13166_13972);
var col_13976 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13175_13975,(0),null);
var infos_13977 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13175_13975,(1),null);
encode_cols(infos_13977,source_idx_13907,line_13965,col_13976);


var G__13978 = seq__13163_13969;
var G__13979 = chunk__13164_13970;
var G__13980 = count__13165_13971;
var G__13981 = (i__13166_13972 + (1));
seq__13163_13969 = G__13978;
chunk__13164_13970 = G__13979;
count__13165_13971 = G__13980;
i__13166_13972 = G__13981;
continue;
} else {
var temp__5735__auto___13982__$1 = cljs.core.seq(seq__13163_13969);
if(temp__5735__auto___13982__$1){
var seq__13163_13983__$1 = temp__5735__auto___13982__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13163_13983__$1)){
var c__4609__auto___13984 = cljs.core.chunk_first(seq__13163_13983__$1);
var G__13985 = cljs.core.chunk_rest(seq__13163_13983__$1);
var G__13986 = c__4609__auto___13984;
var G__13987 = cljs.core.count(c__4609__auto___13984);
var G__13988 = (0);
seq__13163_13969 = G__13985;
chunk__13164_13970 = G__13986;
count__13165_13971 = G__13987;
i__13166_13972 = G__13988;
continue;
} else {
var vec__13179_13989 = cljs.core.first(seq__13163_13983__$1);
var col_13990 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13179_13989,(0),null);
var infos_13991 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13179_13989,(1),null);
encode_cols(infos_13991,source_idx_13907,line_13965,col_13990);


var G__13995 = cljs.core.next(seq__13163_13983__$1);
var G__13996 = null;
var G__13997 = (0);
var G__13998 = (0);
seq__13163_13969 = G__13995;
chunk__13164_13970 = G__13996;
count__13165_13971 = G__13997;
i__13166_13972 = G__13998;
continue;
}
} else {
}
}
break;
}


var G__13999 = cljs.core.next(seq__13087_13958__$1);
var G__14000 = null;
var G__14001 = (0);
var G__14002 = (0);
seq__13087_13913 = G__13999;
chunk__13088_13914 = G__14000;
count__13089_13915 = G__14001;
i__13090_13916 = G__14002;
continue;
}
} else {
}
}
break;
}


var G__14003 = seq__12866_13900;
var G__14004 = chunk__12867_13901;
var G__14005 = count__12868_13902;
var G__14006 = (i__12869_13903 + (1));
seq__12866_13900 = G__14003;
chunk__12867_13901 = G__14004;
count__12868_13902 = G__14005;
i__12869_13903 = G__14006;
continue;
} else {
var temp__5735__auto___14007 = cljs.core.seq(seq__12866_13900);
if(temp__5735__auto___14007){
var seq__12866_14008__$1 = temp__5735__auto___14007;
if(cljs.core.chunked_seq_QMARK_(seq__12866_14008__$1)){
var c__4609__auto___14009 = cljs.core.chunk_first(seq__12866_14008__$1);
var G__14010 = cljs.core.chunk_rest(seq__12866_14008__$1);
var G__14011 = c__4609__auto___14009;
var G__14012 = cljs.core.count(c__4609__auto___14009);
var G__14013 = (0);
seq__12866_13900 = G__14010;
chunk__12867_13901 = G__14011;
count__12868_13902 = G__14012;
i__12869_13903 = G__14013;
continue;
} else {
var vec__13184_14014 = cljs.core.first(seq__12866_14008__$1);
var source_idx_14015 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13184_14014,(0),null);
var vec__13187_14016 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13184_14014,(1),null);
var __14017 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13187_14016,(0),null);
var lines_14018__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13187_14016,(1),null);
var seq__13190_14019 = cljs.core.seq(lines_14018__$1);
var chunk__13191_14020 = null;
var count__13192_14021 = (0);
var i__13193_14022 = (0);
while(true){
if((i__13193_14022 < count__13192_14021)){
var vec__13244_14023 = chunk__13191_14020.cljs$core$IIndexed$_nth$arity$2(null,i__13193_14022);
var line_14024 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13244_14023,(0),null);
var cols_14025 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13244_14023,(1),null);
var seq__13247_14026 = cljs.core.seq(cols_14025);
var chunk__13248_14027 = null;
var count__13249_14028 = (0);
var i__13250_14029 = (0);
while(true){
if((i__13250_14029 < count__13249_14028)){
var vec__13257_14030 = chunk__13248_14027.cljs$core$IIndexed$_nth$arity$2(null,i__13250_14029);
var col_14031 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13257_14030,(0),null);
var infos_14032 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13257_14030,(1),null);
encode_cols(infos_14032,source_idx_14015,line_14024,col_14031);


var G__14033 = seq__13247_14026;
var G__14034 = chunk__13248_14027;
var G__14035 = count__13249_14028;
var G__14036 = (i__13250_14029 + (1));
seq__13247_14026 = G__14033;
chunk__13248_14027 = G__14034;
count__13249_14028 = G__14035;
i__13250_14029 = G__14036;
continue;
} else {
var temp__5735__auto___14037__$1 = cljs.core.seq(seq__13247_14026);
if(temp__5735__auto___14037__$1){
var seq__13247_14038__$1 = temp__5735__auto___14037__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13247_14038__$1)){
var c__4609__auto___14044 = cljs.core.chunk_first(seq__13247_14038__$1);
var G__14045 = cljs.core.chunk_rest(seq__13247_14038__$1);
var G__14046 = c__4609__auto___14044;
var G__14047 = cljs.core.count(c__4609__auto___14044);
var G__14048 = (0);
seq__13247_14026 = G__14045;
chunk__13248_14027 = G__14046;
count__13249_14028 = G__14047;
i__13250_14029 = G__14048;
continue;
} else {
var vec__13260_14052 = cljs.core.first(seq__13247_14038__$1);
var col_14053 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13260_14052,(0),null);
var infos_14054 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13260_14052,(1),null);
encode_cols(infos_14054,source_idx_14015,line_14024,col_14053);


var G__14055 = cljs.core.next(seq__13247_14038__$1);
var G__14056 = null;
var G__14057 = (0);
var G__14058 = (0);
seq__13247_14026 = G__14055;
chunk__13248_14027 = G__14056;
count__13249_14028 = G__14057;
i__13250_14029 = G__14058;
continue;
}
} else {
}
}
break;
}


var G__14059 = seq__13190_14019;
var G__14060 = chunk__13191_14020;
var G__14061 = count__13192_14021;
var G__14062 = (i__13193_14022 + (1));
seq__13190_14019 = G__14059;
chunk__13191_14020 = G__14060;
count__13192_14021 = G__14061;
i__13193_14022 = G__14062;
continue;
} else {
var temp__5735__auto___14063__$1 = cljs.core.seq(seq__13190_14019);
if(temp__5735__auto___14063__$1){
var seq__13190_14064__$1 = temp__5735__auto___14063__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13190_14064__$1)){
var c__4609__auto___14065 = cljs.core.chunk_first(seq__13190_14064__$1);
var G__14066 = cljs.core.chunk_rest(seq__13190_14064__$1);
var G__14067 = c__4609__auto___14065;
var G__14068 = cljs.core.count(c__4609__auto___14065);
var G__14069 = (0);
seq__13190_14019 = G__14066;
chunk__13191_14020 = G__14067;
count__13192_14021 = G__14068;
i__13193_14022 = G__14069;
continue;
} else {
var vec__13263_14073 = cljs.core.first(seq__13190_14064__$1);
var line_14074 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13263_14073,(0),null);
var cols_14075 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13263_14073,(1),null);
var seq__13266_14076 = cljs.core.seq(cols_14075);
var chunk__13267_14077 = null;
var count__13268_14078 = (0);
var i__13269_14079 = (0);
while(true){
if((i__13269_14079 < count__13268_14078)){
var vec__13276_14082 = chunk__13267_14077.cljs$core$IIndexed$_nth$arity$2(null,i__13269_14079);
var col_14083 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13276_14082,(0),null);
var infos_14084 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13276_14082,(1),null);
encode_cols(infos_14084,source_idx_14015,line_14074,col_14083);


var G__14086 = seq__13266_14076;
var G__14087 = chunk__13267_14077;
var G__14088 = count__13268_14078;
var G__14089 = (i__13269_14079 + (1));
seq__13266_14076 = G__14086;
chunk__13267_14077 = G__14087;
count__13268_14078 = G__14088;
i__13269_14079 = G__14089;
continue;
} else {
var temp__5735__auto___14092__$2 = cljs.core.seq(seq__13266_14076);
if(temp__5735__auto___14092__$2){
var seq__13266_14093__$1 = temp__5735__auto___14092__$2;
if(cljs.core.chunked_seq_QMARK_(seq__13266_14093__$1)){
var c__4609__auto___14096 = cljs.core.chunk_first(seq__13266_14093__$1);
var G__14097 = cljs.core.chunk_rest(seq__13266_14093__$1);
var G__14098 = c__4609__auto___14096;
var G__14099 = cljs.core.count(c__4609__auto___14096);
var G__14100 = (0);
seq__13266_14076 = G__14097;
chunk__13267_14077 = G__14098;
count__13268_14078 = G__14099;
i__13269_14079 = G__14100;
continue;
} else {
var vec__13281_14102 = cljs.core.first(seq__13266_14093__$1);
var col_14103 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13281_14102,(0),null);
var infos_14104 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13281_14102,(1),null);
encode_cols(infos_14104,source_idx_14015,line_14074,col_14103);


var G__14105 = cljs.core.next(seq__13266_14093__$1);
var G__14106 = null;
var G__14107 = (0);
var G__14108 = (0);
seq__13266_14076 = G__14105;
chunk__13267_14077 = G__14106;
count__13268_14078 = G__14107;
i__13269_14079 = G__14108;
continue;
}
} else {
}
}
break;
}


var G__14109 = cljs.core.next(seq__13190_14064__$1);
var G__14110 = null;
var G__14111 = (0);
var G__14112 = (0);
seq__13190_14019 = G__14109;
chunk__13191_14020 = G__14110;
count__13192_14021 = G__14111;
i__13193_14022 = G__14112;
continue;
}
} else {
}
}
break;
}


var G__14117 = cljs.core.next(seq__12866_14008__$1);
var G__14118 = null;
var G__14119 = (0);
var G__14120 = (0);
seq__12866_13900 = G__14117;
chunk__12867_13901 = G__14118;
count__12868_13902 = G__14119;
i__12869_13903 = G__14120;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__13285 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__12830_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__12830_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__12831_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__12831_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__12832_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__12832_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__13292 = G__13285;
var G__13295_14125 = G__13292;
var G__13296_14126 = "sourcesContent";
var G__13297_14127 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__13295_14125,G__13296_14126,G__13297_14127);

return G__13292;
} else {
return G__13285;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__13303 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13303,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13303,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__13306 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13306,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13306,(1),null);
var G__14131 = cljs.core.next(col_map_seq);
var G__14132 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__13306,col,infos,vec__13303,line,col_map){
return (function (v,p__13309){
var map__13310 = p__13309;
var map__13310__$1 = (((((!((map__13310 == null))))?(((((map__13310.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13310.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13310):map__13310);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13310__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13310__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__13306,col,infos,vec__13303,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__14131;
new_cols = G__14132;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__14140 = cljs.core.next(line_map_seq);
var G__14141 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__14140;
new_lines = G__14141;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__13313_14143 = cljs.core.seq(reverse_map);
var chunk__13314_14144 = null;
var count__13315_14145 = (0);
var i__13316_14146 = (0);
while(true){
if((i__13316_14146 < count__13315_14145)){
var vec__13538_14147 = chunk__13314_14144.cljs$core$IIndexed$_nth$arity$2(null,i__13316_14146);
var line_14148 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13538_14147,(0),null);
var columns_14149 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13538_14147,(1),null);
var seq__13542_14150 = cljs.core.seq(columns_14149);
var chunk__13543_14151 = null;
var count__13544_14152 = (0);
var i__13545_14153 = (0);
while(true){
if((i__13545_14153 < count__13544_14152)){
var vec__13578_14154 = chunk__13543_14151.cljs$core$IIndexed$_nth$arity$2(null,i__13545_14153);
var column_14155 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13578_14154,(0),null);
var column_info_14156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13578_14154,(1),null);
var seq__13581_14158 = cljs.core.seq(column_info_14156);
var chunk__13582_14159 = null;
var count__13583_14160 = (0);
var i__13584_14161 = (0);
while(true){
if((i__13584_14161 < count__13583_14160)){
var map__13594_14162 = chunk__13582_14159.cljs$core$IIndexed$_nth$arity$2(null,i__13584_14161);
var map__13594_14163__$1 = (((((!((map__13594_14162 == null))))?(((((map__13594_14162.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13594_14162.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13594_14162):map__13594_14162);
var gline_14164 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13594_14163__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14165 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13594_14163__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14166 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13594_14163__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14164], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13581_14158,chunk__13582_14159,count__13583_14160,i__13584_14161,seq__13542_14150,chunk__13543_14151,count__13544_14152,i__13545_14153,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13594_14162,map__13594_14163__$1,gline_14164,gcol_14165,name_14166,vec__13578_14154,column_14155,column_info_14156,vec__13538_14147,line_14148,columns_14149,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14165], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14148,new cljs.core.Keyword(null,"col","col",-1959363084),column_14155,new cljs.core.Keyword(null,"name","name",1843675177),name_14166], null));
});})(seq__13581_14158,chunk__13582_14159,count__13583_14160,i__13584_14161,seq__13542_14150,chunk__13543_14151,count__13544_14152,i__13545_14153,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13594_14162,map__13594_14163__$1,gline_14164,gcol_14165,name_14166,vec__13578_14154,column_14155,column_info_14156,vec__13538_14147,line_14148,columns_14149,inverted))
,cljs.core.sorted_map()));


var G__14176 = seq__13581_14158;
var G__14177 = chunk__13582_14159;
var G__14178 = count__13583_14160;
var G__14179 = (i__13584_14161 + (1));
seq__13581_14158 = G__14176;
chunk__13582_14159 = G__14177;
count__13583_14160 = G__14178;
i__13584_14161 = G__14179;
continue;
} else {
var temp__5735__auto___14180 = cljs.core.seq(seq__13581_14158);
if(temp__5735__auto___14180){
var seq__13581_14181__$1 = temp__5735__auto___14180;
if(cljs.core.chunked_seq_QMARK_(seq__13581_14181__$1)){
var c__4609__auto___14182 = cljs.core.chunk_first(seq__13581_14181__$1);
var G__14183 = cljs.core.chunk_rest(seq__13581_14181__$1);
var G__14184 = c__4609__auto___14182;
var G__14185 = cljs.core.count(c__4609__auto___14182);
var G__14186 = (0);
seq__13581_14158 = G__14183;
chunk__13582_14159 = G__14184;
count__13583_14160 = G__14185;
i__13584_14161 = G__14186;
continue;
} else {
var map__13596_14187 = cljs.core.first(seq__13581_14181__$1);
var map__13596_14188__$1 = (((((!((map__13596_14187 == null))))?(((((map__13596_14187.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13596_14187.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13596_14187):map__13596_14187);
var gline_14189 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13596_14188__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14190 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13596_14188__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14191 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13596_14188__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14189], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13581_14158,chunk__13582_14159,count__13583_14160,i__13584_14161,seq__13542_14150,chunk__13543_14151,count__13544_14152,i__13545_14153,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13596_14187,map__13596_14188__$1,gline_14189,gcol_14190,name_14191,seq__13581_14181__$1,temp__5735__auto___14180,vec__13578_14154,column_14155,column_info_14156,vec__13538_14147,line_14148,columns_14149,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14190], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14148,new cljs.core.Keyword(null,"col","col",-1959363084),column_14155,new cljs.core.Keyword(null,"name","name",1843675177),name_14191], null));
});})(seq__13581_14158,chunk__13582_14159,count__13583_14160,i__13584_14161,seq__13542_14150,chunk__13543_14151,count__13544_14152,i__13545_14153,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13596_14187,map__13596_14188__$1,gline_14189,gcol_14190,name_14191,seq__13581_14181__$1,temp__5735__auto___14180,vec__13578_14154,column_14155,column_info_14156,vec__13538_14147,line_14148,columns_14149,inverted))
,cljs.core.sorted_map()));


var G__14198 = cljs.core.next(seq__13581_14181__$1);
var G__14199 = null;
var G__14200 = (0);
var G__14201 = (0);
seq__13581_14158 = G__14198;
chunk__13582_14159 = G__14199;
count__13583_14160 = G__14200;
i__13584_14161 = G__14201;
continue;
}
} else {
}
}
break;
}


var G__14202 = seq__13542_14150;
var G__14203 = chunk__13543_14151;
var G__14204 = count__13544_14152;
var G__14205 = (i__13545_14153 + (1));
seq__13542_14150 = G__14202;
chunk__13543_14151 = G__14203;
count__13544_14152 = G__14204;
i__13545_14153 = G__14205;
continue;
} else {
var temp__5735__auto___14206 = cljs.core.seq(seq__13542_14150);
if(temp__5735__auto___14206){
var seq__13542_14207__$1 = temp__5735__auto___14206;
if(cljs.core.chunked_seq_QMARK_(seq__13542_14207__$1)){
var c__4609__auto___14208 = cljs.core.chunk_first(seq__13542_14207__$1);
var G__14209 = cljs.core.chunk_rest(seq__13542_14207__$1);
var G__14210 = c__4609__auto___14208;
var G__14211 = cljs.core.count(c__4609__auto___14208);
var G__14212 = (0);
seq__13542_14150 = G__14209;
chunk__13543_14151 = G__14210;
count__13544_14152 = G__14211;
i__13545_14153 = G__14212;
continue;
} else {
var vec__13602_14213 = cljs.core.first(seq__13542_14207__$1);
var column_14214 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13602_14213,(0),null);
var column_info_14215 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13602_14213,(1),null);
var seq__13605_14216 = cljs.core.seq(column_info_14215);
var chunk__13606_14217 = null;
var count__13607_14218 = (0);
var i__13608_14219 = (0);
while(true){
if((i__13608_14219 < count__13607_14218)){
var map__13634_14220 = chunk__13606_14217.cljs$core$IIndexed$_nth$arity$2(null,i__13608_14219);
var map__13634_14221__$1 = (((((!((map__13634_14220 == null))))?(((((map__13634_14220.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13634_14220.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13634_14220):map__13634_14220);
var gline_14222 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13634_14221__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14223 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13634_14221__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14224 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13634_14221__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14222], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13605_14216,chunk__13606_14217,count__13607_14218,i__13608_14219,seq__13542_14150,chunk__13543_14151,count__13544_14152,i__13545_14153,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13634_14220,map__13634_14221__$1,gline_14222,gcol_14223,name_14224,vec__13602_14213,column_14214,column_info_14215,seq__13542_14207__$1,temp__5735__auto___14206,vec__13538_14147,line_14148,columns_14149,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14223], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14148,new cljs.core.Keyword(null,"col","col",-1959363084),column_14214,new cljs.core.Keyword(null,"name","name",1843675177),name_14224], null));
});})(seq__13605_14216,chunk__13606_14217,count__13607_14218,i__13608_14219,seq__13542_14150,chunk__13543_14151,count__13544_14152,i__13545_14153,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13634_14220,map__13634_14221__$1,gline_14222,gcol_14223,name_14224,vec__13602_14213,column_14214,column_info_14215,seq__13542_14207__$1,temp__5735__auto___14206,vec__13538_14147,line_14148,columns_14149,inverted))
,cljs.core.sorted_map()));


var G__14228 = seq__13605_14216;
var G__14229 = chunk__13606_14217;
var G__14230 = count__13607_14218;
var G__14231 = (i__13608_14219 + (1));
seq__13605_14216 = G__14228;
chunk__13606_14217 = G__14229;
count__13607_14218 = G__14230;
i__13608_14219 = G__14231;
continue;
} else {
var temp__5735__auto___14232__$1 = cljs.core.seq(seq__13605_14216);
if(temp__5735__auto___14232__$1){
var seq__13605_14233__$1 = temp__5735__auto___14232__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13605_14233__$1)){
var c__4609__auto___14234 = cljs.core.chunk_first(seq__13605_14233__$1);
var G__14235 = cljs.core.chunk_rest(seq__13605_14233__$1);
var G__14236 = c__4609__auto___14234;
var G__14237 = cljs.core.count(c__4609__auto___14234);
var G__14238 = (0);
seq__13605_14216 = G__14235;
chunk__13606_14217 = G__14236;
count__13607_14218 = G__14237;
i__13608_14219 = G__14238;
continue;
} else {
var map__13645_14239 = cljs.core.first(seq__13605_14233__$1);
var map__13645_14240__$1 = (((((!((map__13645_14239 == null))))?(((((map__13645_14239.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13645_14239.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13645_14239):map__13645_14239);
var gline_14241 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13645_14240__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14242 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13645_14240__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14243 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13645_14240__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14241], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13605_14216,chunk__13606_14217,count__13607_14218,i__13608_14219,seq__13542_14150,chunk__13543_14151,count__13544_14152,i__13545_14153,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13645_14239,map__13645_14240__$1,gline_14241,gcol_14242,name_14243,seq__13605_14233__$1,temp__5735__auto___14232__$1,vec__13602_14213,column_14214,column_info_14215,seq__13542_14207__$1,temp__5735__auto___14206,vec__13538_14147,line_14148,columns_14149,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14242], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14148,new cljs.core.Keyword(null,"col","col",-1959363084),column_14214,new cljs.core.Keyword(null,"name","name",1843675177),name_14243], null));
});})(seq__13605_14216,chunk__13606_14217,count__13607_14218,i__13608_14219,seq__13542_14150,chunk__13543_14151,count__13544_14152,i__13545_14153,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13645_14239,map__13645_14240__$1,gline_14241,gcol_14242,name_14243,seq__13605_14233__$1,temp__5735__auto___14232__$1,vec__13602_14213,column_14214,column_info_14215,seq__13542_14207__$1,temp__5735__auto___14206,vec__13538_14147,line_14148,columns_14149,inverted))
,cljs.core.sorted_map()));


var G__14250 = cljs.core.next(seq__13605_14233__$1);
var G__14251 = null;
var G__14252 = (0);
var G__14253 = (0);
seq__13605_14216 = G__14250;
chunk__13606_14217 = G__14251;
count__13607_14218 = G__14252;
i__13608_14219 = G__14253;
continue;
}
} else {
}
}
break;
}


var G__14254 = cljs.core.next(seq__13542_14207__$1);
var G__14255 = null;
var G__14256 = (0);
var G__14257 = (0);
seq__13542_14150 = G__14254;
chunk__13543_14151 = G__14255;
count__13544_14152 = G__14256;
i__13545_14153 = G__14257;
continue;
}
} else {
}
}
break;
}


var G__14258 = seq__13313_14143;
var G__14259 = chunk__13314_14144;
var G__14260 = count__13315_14145;
var G__14261 = (i__13316_14146 + (1));
seq__13313_14143 = G__14258;
chunk__13314_14144 = G__14259;
count__13315_14145 = G__14260;
i__13316_14146 = G__14261;
continue;
} else {
var temp__5735__auto___14265 = cljs.core.seq(seq__13313_14143);
if(temp__5735__auto___14265){
var seq__13313_14266__$1 = temp__5735__auto___14265;
if(cljs.core.chunked_seq_QMARK_(seq__13313_14266__$1)){
var c__4609__auto___14267 = cljs.core.chunk_first(seq__13313_14266__$1);
var G__14268 = cljs.core.chunk_rest(seq__13313_14266__$1);
var G__14269 = c__4609__auto___14267;
var G__14270 = cljs.core.count(c__4609__auto___14267);
var G__14271 = (0);
seq__13313_14143 = G__14268;
chunk__13314_14144 = G__14269;
count__13315_14145 = G__14270;
i__13316_14146 = G__14271;
continue;
} else {
var vec__13647_14276 = cljs.core.first(seq__13313_14266__$1);
var line_14277 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13647_14276,(0),null);
var columns_14278 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13647_14276,(1),null);
var seq__13650_14279 = cljs.core.seq(columns_14278);
var chunk__13651_14280 = null;
var count__13652_14281 = (0);
var i__13653_14282 = (0);
while(true){
if((i__13653_14282 < count__13652_14281)){
var vec__13693_14283 = chunk__13651_14280.cljs$core$IIndexed$_nth$arity$2(null,i__13653_14282);
var column_14284 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13693_14283,(0),null);
var column_info_14285 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13693_14283,(1),null);
var seq__13696_14289 = cljs.core.seq(column_info_14285);
var chunk__13697_14290 = null;
var count__13698_14291 = (0);
var i__13699_14292 = (0);
while(true){
if((i__13699_14292 < count__13698_14291)){
var map__13706_14293 = chunk__13697_14290.cljs$core$IIndexed$_nth$arity$2(null,i__13699_14292);
var map__13706_14294__$1 = (((((!((map__13706_14293 == null))))?(((((map__13706_14293.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13706_14293.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13706_14293):map__13706_14293);
var gline_14295 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13706_14294__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14296 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13706_14294__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14297 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13706_14294__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14295], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13696_14289,chunk__13697_14290,count__13698_14291,i__13699_14292,seq__13650_14279,chunk__13651_14280,count__13652_14281,i__13653_14282,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13706_14293,map__13706_14294__$1,gline_14295,gcol_14296,name_14297,vec__13693_14283,column_14284,column_info_14285,vec__13647_14276,line_14277,columns_14278,seq__13313_14266__$1,temp__5735__auto___14265,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14296], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14277,new cljs.core.Keyword(null,"col","col",-1959363084),column_14284,new cljs.core.Keyword(null,"name","name",1843675177),name_14297], null));
});})(seq__13696_14289,chunk__13697_14290,count__13698_14291,i__13699_14292,seq__13650_14279,chunk__13651_14280,count__13652_14281,i__13653_14282,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13706_14293,map__13706_14294__$1,gline_14295,gcol_14296,name_14297,vec__13693_14283,column_14284,column_info_14285,vec__13647_14276,line_14277,columns_14278,seq__13313_14266__$1,temp__5735__auto___14265,inverted))
,cljs.core.sorted_map()));


var G__14304 = seq__13696_14289;
var G__14305 = chunk__13697_14290;
var G__14306 = count__13698_14291;
var G__14307 = (i__13699_14292 + (1));
seq__13696_14289 = G__14304;
chunk__13697_14290 = G__14305;
count__13698_14291 = G__14306;
i__13699_14292 = G__14307;
continue;
} else {
var temp__5735__auto___14311__$1 = cljs.core.seq(seq__13696_14289);
if(temp__5735__auto___14311__$1){
var seq__13696_14312__$1 = temp__5735__auto___14311__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13696_14312__$1)){
var c__4609__auto___14313 = cljs.core.chunk_first(seq__13696_14312__$1);
var G__14314 = cljs.core.chunk_rest(seq__13696_14312__$1);
var G__14315 = c__4609__auto___14313;
var G__14316 = cljs.core.count(c__4609__auto___14313);
var G__14317 = (0);
seq__13696_14289 = G__14314;
chunk__13697_14290 = G__14315;
count__13698_14291 = G__14316;
i__13699_14292 = G__14317;
continue;
} else {
var map__13729_14318 = cljs.core.first(seq__13696_14312__$1);
var map__13729_14319__$1 = (((((!((map__13729_14318 == null))))?(((((map__13729_14318.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13729_14318.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13729_14318):map__13729_14318);
var gline_14320 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13729_14319__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14321 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13729_14319__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14322 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13729_14319__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14320], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13696_14289,chunk__13697_14290,count__13698_14291,i__13699_14292,seq__13650_14279,chunk__13651_14280,count__13652_14281,i__13653_14282,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13729_14318,map__13729_14319__$1,gline_14320,gcol_14321,name_14322,seq__13696_14312__$1,temp__5735__auto___14311__$1,vec__13693_14283,column_14284,column_info_14285,vec__13647_14276,line_14277,columns_14278,seq__13313_14266__$1,temp__5735__auto___14265,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14321], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14277,new cljs.core.Keyword(null,"col","col",-1959363084),column_14284,new cljs.core.Keyword(null,"name","name",1843675177),name_14322], null));
});})(seq__13696_14289,chunk__13697_14290,count__13698_14291,i__13699_14292,seq__13650_14279,chunk__13651_14280,count__13652_14281,i__13653_14282,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13729_14318,map__13729_14319__$1,gline_14320,gcol_14321,name_14322,seq__13696_14312__$1,temp__5735__auto___14311__$1,vec__13693_14283,column_14284,column_info_14285,vec__13647_14276,line_14277,columns_14278,seq__13313_14266__$1,temp__5735__auto___14265,inverted))
,cljs.core.sorted_map()));


var G__14324 = cljs.core.next(seq__13696_14312__$1);
var G__14325 = null;
var G__14326 = (0);
var G__14327 = (0);
seq__13696_14289 = G__14324;
chunk__13697_14290 = G__14325;
count__13698_14291 = G__14326;
i__13699_14292 = G__14327;
continue;
}
} else {
}
}
break;
}


var G__14328 = seq__13650_14279;
var G__14329 = chunk__13651_14280;
var G__14330 = count__13652_14281;
var G__14331 = (i__13653_14282 + (1));
seq__13650_14279 = G__14328;
chunk__13651_14280 = G__14329;
count__13652_14281 = G__14330;
i__13653_14282 = G__14331;
continue;
} else {
var temp__5735__auto___14332__$1 = cljs.core.seq(seq__13650_14279);
if(temp__5735__auto___14332__$1){
var seq__13650_14333__$1 = temp__5735__auto___14332__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13650_14333__$1)){
var c__4609__auto___14334 = cljs.core.chunk_first(seq__13650_14333__$1);
var G__14335 = cljs.core.chunk_rest(seq__13650_14333__$1);
var G__14336 = c__4609__auto___14334;
var G__14337 = cljs.core.count(c__4609__auto___14334);
var G__14338 = (0);
seq__13650_14279 = G__14335;
chunk__13651_14280 = G__14336;
count__13652_14281 = G__14337;
i__13653_14282 = G__14338;
continue;
} else {
var vec__13738_14339 = cljs.core.first(seq__13650_14333__$1);
var column_14340 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13738_14339,(0),null);
var column_info_14341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13738_14339,(1),null);
var seq__13742_14342 = cljs.core.seq(column_info_14341);
var chunk__13743_14343 = null;
var count__13744_14344 = (0);
var i__13745_14345 = (0);
while(true){
if((i__13745_14345 < count__13744_14344)){
var map__13775_14346 = chunk__13743_14343.cljs$core$IIndexed$_nth$arity$2(null,i__13745_14345);
var map__13775_14347__$1 = (((((!((map__13775_14346 == null))))?(((((map__13775_14346.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13775_14346.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13775_14346):map__13775_14346);
var gline_14348 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13775_14347__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14349 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13775_14347__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14350 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13775_14347__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14348], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13742_14342,chunk__13743_14343,count__13744_14344,i__13745_14345,seq__13650_14279,chunk__13651_14280,count__13652_14281,i__13653_14282,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13775_14346,map__13775_14347__$1,gline_14348,gcol_14349,name_14350,vec__13738_14339,column_14340,column_info_14341,seq__13650_14333__$1,temp__5735__auto___14332__$1,vec__13647_14276,line_14277,columns_14278,seq__13313_14266__$1,temp__5735__auto___14265,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14349], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14277,new cljs.core.Keyword(null,"col","col",-1959363084),column_14340,new cljs.core.Keyword(null,"name","name",1843675177),name_14350], null));
});})(seq__13742_14342,chunk__13743_14343,count__13744_14344,i__13745_14345,seq__13650_14279,chunk__13651_14280,count__13652_14281,i__13653_14282,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13775_14346,map__13775_14347__$1,gline_14348,gcol_14349,name_14350,vec__13738_14339,column_14340,column_info_14341,seq__13650_14333__$1,temp__5735__auto___14332__$1,vec__13647_14276,line_14277,columns_14278,seq__13313_14266__$1,temp__5735__auto___14265,inverted))
,cljs.core.sorted_map()));


var G__14357 = seq__13742_14342;
var G__14358 = chunk__13743_14343;
var G__14359 = count__13744_14344;
var G__14360 = (i__13745_14345 + (1));
seq__13742_14342 = G__14357;
chunk__13743_14343 = G__14358;
count__13744_14344 = G__14359;
i__13745_14345 = G__14360;
continue;
} else {
var temp__5735__auto___14361__$2 = cljs.core.seq(seq__13742_14342);
if(temp__5735__auto___14361__$2){
var seq__13742_14362__$1 = temp__5735__auto___14361__$2;
if(cljs.core.chunked_seq_QMARK_(seq__13742_14362__$1)){
var c__4609__auto___14363 = cljs.core.chunk_first(seq__13742_14362__$1);
var G__14364 = cljs.core.chunk_rest(seq__13742_14362__$1);
var G__14365 = c__4609__auto___14363;
var G__14366 = cljs.core.count(c__4609__auto___14363);
var G__14367 = (0);
seq__13742_14342 = G__14364;
chunk__13743_14343 = G__14365;
count__13744_14344 = G__14366;
i__13745_14345 = G__14367;
continue;
} else {
var map__13777_14368 = cljs.core.first(seq__13742_14362__$1);
var map__13777_14369__$1 = (((((!((map__13777_14368 == null))))?(((((map__13777_14368.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13777_14368.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13777_14368):map__13777_14368);
var gline_14370 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13777_14369__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14371 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13777_14369__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14372 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13777_14369__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14370], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13742_14342,chunk__13743_14343,count__13744_14344,i__13745_14345,seq__13650_14279,chunk__13651_14280,count__13652_14281,i__13653_14282,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13777_14368,map__13777_14369__$1,gline_14370,gcol_14371,name_14372,seq__13742_14362__$1,temp__5735__auto___14361__$2,vec__13738_14339,column_14340,column_info_14341,seq__13650_14333__$1,temp__5735__auto___14332__$1,vec__13647_14276,line_14277,columns_14278,seq__13313_14266__$1,temp__5735__auto___14265,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14371], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14277,new cljs.core.Keyword(null,"col","col",-1959363084),column_14340,new cljs.core.Keyword(null,"name","name",1843675177),name_14372], null));
});})(seq__13742_14342,chunk__13743_14343,count__13744_14344,i__13745_14345,seq__13650_14279,chunk__13651_14280,count__13652_14281,i__13653_14282,seq__13313_14143,chunk__13314_14144,count__13315_14145,i__13316_14146,map__13777_14368,map__13777_14369__$1,gline_14370,gcol_14371,name_14372,seq__13742_14362__$1,temp__5735__auto___14361__$2,vec__13738_14339,column_14340,column_info_14341,seq__13650_14333__$1,temp__5735__auto___14332__$1,vec__13647_14276,line_14277,columns_14278,seq__13313_14266__$1,temp__5735__auto___14265,inverted))
,cljs.core.sorted_map()));


var G__14380 = cljs.core.next(seq__13742_14362__$1);
var G__14381 = null;
var G__14382 = (0);
var G__14383 = (0);
seq__13742_14342 = G__14380;
chunk__13743_14343 = G__14381;
count__13744_14344 = G__14382;
i__13745_14345 = G__14383;
continue;
}
} else {
}
}
break;
}


var G__14384 = cljs.core.next(seq__13650_14333__$1);
var G__14385 = null;
var G__14386 = (0);
var G__14387 = (0);
seq__13650_14279 = G__14384;
chunk__13651_14280 = G__14385;
count__13652_14281 = G__14386;
i__13653_14282 = G__14387;
continue;
}
} else {
}
}
break;
}


var G__14388 = cljs.core.next(seq__13313_14266__$1);
var G__14389 = null;
var G__14390 = (0);
var G__14391 = (0);
seq__13313_14143 = G__14388;
chunk__13314_14144 = G__14389;
count__13315_14145 = G__14390;
i__13316_14146 = G__14391;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
