goog.provide('cljs.source_map');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__12734){
var vec__12735 = p__12734;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12735,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12735,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__12740 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12740,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12740,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12740,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12740,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12740,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__12755 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12755,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12755,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12755,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12755,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12755,(4),null);
var vec__12758 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12758,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12758,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12758,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12758,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12758,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__12770 = segmap;
var map__12770__$1 = (((((!((map__12770 == null))))?(((((map__12770.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12770.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12770):map__12770);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12770__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12770__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12770__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12770__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12770__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__12776 = arguments.length;
switch (G__12776) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__12787 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__13723 = cljs.core.next(segs__$1);
var G__13724 = nrelseg;
var G__13725 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__13723;
relseg__$1 = G__13724;
result__$1 = G__13725;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12787,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12787,(1),null);
var G__13726 = (gline + (1));
var G__13727 = cljs.core.next(lines__$1);
var G__13728 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__13729 = result__$1;
gline = G__13726;
lines__$1 = G__13727;
relseg = G__13728;
result = G__13729;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__12791 = segmap;
var map__12791__$1 = (((((!((map__12791 == null))))?(((((map__12791.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12791.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12791):map__12791);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12791__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12791__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12791__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12791__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12791__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__12790_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__12790_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__12794 = arguments.length;
switch (G__12794) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__12803 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__13761 = cljs.core.next(segs__$1);
var G__13762 = nrelseg;
var G__13763 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__13761;
relseg__$1 = G__13762;
result__$1 = G__13763;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12803,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12803,(1),null);
var G__13770 = (gline + (1));
var G__13771 = cljs.core.next(lines__$1);
var G__13772 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__13773 = result__$1;
gline = G__13770;
lines__$1 = G__13771;
relseg = G__13772;
result = G__13773;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__12811){
var vec__12812 = p__12811;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12812,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12812,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12812,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12812,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12812,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__12815){
var vec__12816 = p__12815;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12816,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12816,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12816,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12816,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12816,(4),null);
var seg = vec__12816;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__12819){
var vec__12826 = p__12819;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12826,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12826,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12826,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12826,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12826,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__12834 = cljs.core.seq(infos);
var chunk__12835 = null;
var count__12836 = (0);
var i__12837 = (0);
while(true){
if((i__12837 < count__12836)){
var info = chunk__12835.cljs$core$IIndexed$_nth$arity$2(null,i__12837);
var segv_13833 = info__GT_segv(info,source_idx,line,col);
var gline_13834 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_13835 = cljs.core.count(cljs.core.deref(lines));
if((gline_13834 > (lc_13835 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12834,chunk__12835,count__12836,i__12837,segv_13833,gline_13834,lc_13835,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_13834 - (lc_13835 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_13833], null));
});})(seq__12834,chunk__12835,count__12836,i__12837,segv_13833,gline_13834,lc_13835,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12834,chunk__12835,count__12836,i__12837,segv_13833,gline_13834,lc_13835,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_13834], null),cljs.core.conj,segv_13833);
});})(seq__12834,chunk__12835,count__12836,i__12837,segv_13833,gline_13834,lc_13835,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__13840 = seq__12834;
var G__13841 = chunk__12835;
var G__13842 = count__12836;
var G__13843 = (i__12837 + (1));
seq__12834 = G__13840;
chunk__12835 = G__13841;
count__12836 = G__13842;
i__12837 = G__13843;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12834);
if(temp__5735__auto__){
var seq__12834__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12834__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__12834__$1);
var G__13846 = cljs.core.chunk_rest(seq__12834__$1);
var G__13847 = c__4609__auto__;
var G__13848 = cljs.core.count(c__4609__auto__);
var G__13849 = (0);
seq__12834 = G__13846;
chunk__12835 = G__13847;
count__12836 = G__13848;
i__12837 = G__13849;
continue;
} else {
var info = cljs.core.first(seq__12834__$1);
var segv_13853 = info__GT_segv(info,source_idx,line,col);
var gline_13854 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_13855 = cljs.core.count(cljs.core.deref(lines));
if((gline_13854 > (lc_13855 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12834,chunk__12835,count__12836,i__12837,segv_13853,gline_13854,lc_13855,info,seq__12834__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_13854 - (lc_13855 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_13853], null));
});})(seq__12834,chunk__12835,count__12836,i__12837,segv_13853,gline_13854,lc_13855,info,seq__12834__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12834,chunk__12835,count__12836,i__12837,segv_13853,gline_13854,lc_13855,info,seq__12834__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_13854], null),cljs.core.conj,segv_13853);
});})(seq__12834,chunk__12835,count__12836,i__12837,segv_13853,gline_13854,lc_13855,info,seq__12834__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__13862 = cljs.core.next(seq__12834__$1);
var G__13863 = null;
var G__13864 = (0);
var G__13865 = (0);
seq__12834 = G__13862;
chunk__12835 = G__13863;
count__12836 = G__13864;
i__12837 = G__13865;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__12838_13866 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__12839_13867 = null;
var count__12840_13868 = (0);
var i__12841_13869 = (0);
while(true){
if((i__12841_13869 < count__12840_13868)){
var vec__13071_13875 = chunk__12839_13867.cljs$core$IIndexed$_nth$arity$2(null,i__12841_13869);
var source_idx_13876 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13071_13875,(0),null);
var vec__13074_13877 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13071_13875,(1),null);
var __13878 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13074_13877,(0),null);
var lines_13879__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13074_13877,(1),null);
var seq__13077_13881 = cljs.core.seq(lines_13879__$1);
var chunk__13078_13882 = null;
var count__13079_13883 = (0);
var i__13080_13884 = (0);
while(true){
if((i__13080_13884 < count__13079_13883)){
var vec__13124_13885 = chunk__13078_13882.cljs$core$IIndexed$_nth$arity$2(null,i__13080_13884);
var line_13886 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13124_13885,(0),null);
var cols_13887 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13124_13885,(1),null);
var seq__13127_13892 = cljs.core.seq(cols_13887);
var chunk__13128_13893 = null;
var count__13129_13894 = (0);
var i__13130_13895 = (0);
while(true){
if((i__13130_13895 < count__13129_13894)){
var vec__13138_13896 = chunk__13128_13893.cljs$core$IIndexed$_nth$arity$2(null,i__13130_13895);
var col_13897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13138_13896,(0),null);
var infos_13898 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13138_13896,(1),null);
encode_cols(infos_13898,source_idx_13876,line_13886,col_13897);


var G__13901 = seq__13127_13892;
var G__13902 = chunk__13128_13893;
var G__13903 = count__13129_13894;
var G__13904 = (i__13130_13895 + (1));
seq__13127_13892 = G__13901;
chunk__13128_13893 = G__13902;
count__13129_13894 = G__13903;
i__13130_13895 = G__13904;
continue;
} else {
var temp__5735__auto___13908 = cljs.core.seq(seq__13127_13892);
if(temp__5735__auto___13908){
var seq__13127_13911__$1 = temp__5735__auto___13908;
if(cljs.core.chunked_seq_QMARK_(seq__13127_13911__$1)){
var c__4609__auto___13912 = cljs.core.chunk_first(seq__13127_13911__$1);
var G__13913 = cljs.core.chunk_rest(seq__13127_13911__$1);
var G__13914 = c__4609__auto___13912;
var G__13915 = cljs.core.count(c__4609__auto___13912);
var G__13916 = (0);
seq__13127_13892 = G__13913;
chunk__13128_13893 = G__13914;
count__13129_13894 = G__13915;
i__13130_13895 = G__13916;
continue;
} else {
var vec__13141_13919 = cljs.core.first(seq__13127_13911__$1);
var col_13920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13141_13919,(0),null);
var infos_13921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13141_13919,(1),null);
encode_cols(infos_13921,source_idx_13876,line_13886,col_13920);


var G__13922 = cljs.core.next(seq__13127_13911__$1);
var G__13923 = null;
var G__13924 = (0);
var G__13925 = (0);
seq__13127_13892 = G__13922;
chunk__13128_13893 = G__13923;
count__13129_13894 = G__13924;
i__13130_13895 = G__13925;
continue;
}
} else {
}
}
break;
}


var G__13926 = seq__13077_13881;
var G__13927 = chunk__13078_13882;
var G__13928 = count__13079_13883;
var G__13929 = (i__13080_13884 + (1));
seq__13077_13881 = G__13926;
chunk__13078_13882 = G__13927;
count__13079_13883 = G__13928;
i__13080_13884 = G__13929;
continue;
} else {
var temp__5735__auto___13931 = cljs.core.seq(seq__13077_13881);
if(temp__5735__auto___13931){
var seq__13077_13932__$1 = temp__5735__auto___13931;
if(cljs.core.chunked_seq_QMARK_(seq__13077_13932__$1)){
var c__4609__auto___13933 = cljs.core.chunk_first(seq__13077_13932__$1);
var G__13934 = cljs.core.chunk_rest(seq__13077_13932__$1);
var G__13935 = c__4609__auto___13933;
var G__13936 = cljs.core.count(c__4609__auto___13933);
var G__13937 = (0);
seq__13077_13881 = G__13934;
chunk__13078_13882 = G__13935;
count__13079_13883 = G__13936;
i__13080_13884 = G__13937;
continue;
} else {
var vec__13147_13940 = cljs.core.first(seq__13077_13932__$1);
var line_13941 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13147_13940,(0),null);
var cols_13942 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13147_13940,(1),null);
var seq__13150_13945 = cljs.core.seq(cols_13942);
var chunk__13151_13946 = null;
var count__13152_13947 = (0);
var i__13153_13948 = (0);
while(true){
if((i__13153_13948 < count__13152_13947)){
var vec__13160_13949 = chunk__13151_13946.cljs$core$IIndexed$_nth$arity$2(null,i__13153_13948);
var col_13950 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13160_13949,(0),null);
var infos_13951 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13160_13949,(1),null);
encode_cols(infos_13951,source_idx_13876,line_13941,col_13950);


var G__13955 = seq__13150_13945;
var G__13956 = chunk__13151_13946;
var G__13957 = count__13152_13947;
var G__13958 = (i__13153_13948 + (1));
seq__13150_13945 = G__13955;
chunk__13151_13946 = G__13956;
count__13152_13947 = G__13957;
i__13153_13948 = G__13958;
continue;
} else {
var temp__5735__auto___13961__$1 = cljs.core.seq(seq__13150_13945);
if(temp__5735__auto___13961__$1){
var seq__13150_13962__$1 = temp__5735__auto___13961__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13150_13962__$1)){
var c__4609__auto___13963 = cljs.core.chunk_first(seq__13150_13962__$1);
var G__13964 = cljs.core.chunk_rest(seq__13150_13962__$1);
var G__13965 = c__4609__auto___13963;
var G__13966 = cljs.core.count(c__4609__auto___13963);
var G__13967 = (0);
seq__13150_13945 = G__13964;
chunk__13151_13946 = G__13965;
count__13152_13947 = G__13966;
i__13153_13948 = G__13967;
continue;
} else {
var vec__13163_13970 = cljs.core.first(seq__13150_13962__$1);
var col_13971 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13163_13970,(0),null);
var infos_13972 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13163_13970,(1),null);
encode_cols(infos_13972,source_idx_13876,line_13941,col_13971);


var G__13975 = cljs.core.next(seq__13150_13962__$1);
var G__13976 = null;
var G__13977 = (0);
var G__13978 = (0);
seq__13150_13945 = G__13975;
chunk__13151_13946 = G__13976;
count__13152_13947 = G__13977;
i__13153_13948 = G__13978;
continue;
}
} else {
}
}
break;
}


var G__13980 = cljs.core.next(seq__13077_13932__$1);
var G__13981 = null;
var G__13982 = (0);
var G__13983 = (0);
seq__13077_13881 = G__13980;
chunk__13078_13882 = G__13981;
count__13079_13883 = G__13982;
i__13080_13884 = G__13983;
continue;
}
} else {
}
}
break;
}


var G__13986 = seq__12838_13866;
var G__13987 = chunk__12839_13867;
var G__13988 = count__12840_13868;
var G__13989 = (i__12841_13869 + (1));
seq__12838_13866 = G__13986;
chunk__12839_13867 = G__13987;
count__12840_13868 = G__13988;
i__12841_13869 = G__13989;
continue;
} else {
var temp__5735__auto___13991 = cljs.core.seq(seq__12838_13866);
if(temp__5735__auto___13991){
var seq__12838_13992__$1 = temp__5735__auto___13991;
if(cljs.core.chunked_seq_QMARK_(seq__12838_13992__$1)){
var c__4609__auto___13994 = cljs.core.chunk_first(seq__12838_13992__$1);
var G__13995 = cljs.core.chunk_rest(seq__12838_13992__$1);
var G__13996 = c__4609__auto___13994;
var G__13997 = cljs.core.count(c__4609__auto___13994);
var G__13998 = (0);
seq__12838_13866 = G__13995;
chunk__12839_13867 = G__13996;
count__12840_13868 = G__13997;
i__12841_13869 = G__13998;
continue;
} else {
var vec__13166_13999 = cljs.core.first(seq__12838_13992__$1);
var source_idx_14000 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13166_13999,(0),null);
var vec__13169_14001 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13166_13999,(1),null);
var __14002 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13169_14001,(0),null);
var lines_14003__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13169_14001,(1),null);
var seq__13172_14004 = cljs.core.seq(lines_14003__$1);
var chunk__13173_14005 = null;
var count__13174_14006 = (0);
var i__13175_14007 = (0);
while(true){
if((i__13175_14007 < count__13174_14006)){
var vec__13222_14009 = chunk__13173_14005.cljs$core$IIndexed$_nth$arity$2(null,i__13175_14007);
var line_14010 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13222_14009,(0),null);
var cols_14011 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13222_14009,(1),null);
var seq__13225_14015 = cljs.core.seq(cols_14011);
var chunk__13226_14016 = null;
var count__13227_14017 = (0);
var i__13228_14018 = (0);
while(true){
if((i__13228_14018 < count__13227_14017)){
var vec__13237_14019 = chunk__13226_14016.cljs$core$IIndexed$_nth$arity$2(null,i__13228_14018);
var col_14020 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13237_14019,(0),null);
var infos_14021 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13237_14019,(1),null);
encode_cols(infos_14021,source_idx_14000,line_14010,col_14020);


var G__14023 = seq__13225_14015;
var G__14024 = chunk__13226_14016;
var G__14025 = count__13227_14017;
var G__14026 = (i__13228_14018 + (1));
seq__13225_14015 = G__14023;
chunk__13226_14016 = G__14024;
count__13227_14017 = G__14025;
i__13228_14018 = G__14026;
continue;
} else {
var temp__5735__auto___14027__$1 = cljs.core.seq(seq__13225_14015);
if(temp__5735__auto___14027__$1){
var seq__13225_14028__$1 = temp__5735__auto___14027__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13225_14028__$1)){
var c__4609__auto___14029 = cljs.core.chunk_first(seq__13225_14028__$1);
var G__14031 = cljs.core.chunk_rest(seq__13225_14028__$1);
var G__14032 = c__4609__auto___14029;
var G__14033 = cljs.core.count(c__4609__auto___14029);
var G__14034 = (0);
seq__13225_14015 = G__14031;
chunk__13226_14016 = G__14032;
count__13227_14017 = G__14033;
i__13228_14018 = G__14034;
continue;
} else {
var vec__13240_14035 = cljs.core.first(seq__13225_14028__$1);
var col_14036 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13240_14035,(0),null);
var infos_14037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13240_14035,(1),null);
encode_cols(infos_14037,source_idx_14000,line_14010,col_14036);


var G__14038 = cljs.core.next(seq__13225_14028__$1);
var G__14039 = null;
var G__14040 = (0);
var G__14041 = (0);
seq__13225_14015 = G__14038;
chunk__13226_14016 = G__14039;
count__13227_14017 = G__14040;
i__13228_14018 = G__14041;
continue;
}
} else {
}
}
break;
}


var G__14042 = seq__13172_14004;
var G__14043 = chunk__13173_14005;
var G__14044 = count__13174_14006;
var G__14045 = (i__13175_14007 + (1));
seq__13172_14004 = G__14042;
chunk__13173_14005 = G__14043;
count__13174_14006 = G__14044;
i__13175_14007 = G__14045;
continue;
} else {
var temp__5735__auto___14048__$1 = cljs.core.seq(seq__13172_14004);
if(temp__5735__auto___14048__$1){
var seq__13172_14051__$1 = temp__5735__auto___14048__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13172_14051__$1)){
var c__4609__auto___14052 = cljs.core.chunk_first(seq__13172_14051__$1);
var G__14053 = cljs.core.chunk_rest(seq__13172_14051__$1);
var G__14054 = c__4609__auto___14052;
var G__14055 = cljs.core.count(c__4609__auto___14052);
var G__14056 = (0);
seq__13172_14004 = G__14053;
chunk__13173_14005 = G__14054;
count__13174_14006 = G__14055;
i__13175_14007 = G__14056;
continue;
} else {
var vec__13245_14057 = cljs.core.first(seq__13172_14051__$1);
var line_14058 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13245_14057,(0),null);
var cols_14059 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13245_14057,(1),null);
var seq__13248_14060 = cljs.core.seq(cols_14059);
var chunk__13249_14061 = null;
var count__13250_14062 = (0);
var i__13251_14063 = (0);
while(true){
if((i__13251_14063 < count__13250_14062)){
var vec__13258_14064 = chunk__13249_14061.cljs$core$IIndexed$_nth$arity$2(null,i__13251_14063);
var col_14065 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13258_14064,(0),null);
var infos_14066 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13258_14064,(1),null);
encode_cols(infos_14066,source_idx_14000,line_14058,col_14065);


var G__14067 = seq__13248_14060;
var G__14068 = chunk__13249_14061;
var G__14069 = count__13250_14062;
var G__14070 = (i__13251_14063 + (1));
seq__13248_14060 = G__14067;
chunk__13249_14061 = G__14068;
count__13250_14062 = G__14069;
i__13251_14063 = G__14070;
continue;
} else {
var temp__5735__auto___14071__$2 = cljs.core.seq(seq__13248_14060);
if(temp__5735__auto___14071__$2){
var seq__13248_14072__$1 = temp__5735__auto___14071__$2;
if(cljs.core.chunked_seq_QMARK_(seq__13248_14072__$1)){
var c__4609__auto___14074 = cljs.core.chunk_first(seq__13248_14072__$1);
var G__14075 = cljs.core.chunk_rest(seq__13248_14072__$1);
var G__14076 = c__4609__auto___14074;
var G__14077 = cljs.core.count(c__4609__auto___14074);
var G__14078 = (0);
seq__13248_14060 = G__14075;
chunk__13249_14061 = G__14076;
count__13250_14062 = G__14077;
i__13251_14063 = G__14078;
continue;
} else {
var vec__13261_14079 = cljs.core.first(seq__13248_14072__$1);
var col_14080 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13261_14079,(0),null);
var infos_14081 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13261_14079,(1),null);
encode_cols(infos_14081,source_idx_14000,line_14058,col_14080);


var G__14085 = cljs.core.next(seq__13248_14072__$1);
var G__14086 = null;
var G__14087 = (0);
var G__14088 = (0);
seq__13248_14060 = G__14085;
chunk__13249_14061 = G__14086;
count__13250_14062 = G__14087;
i__13251_14063 = G__14088;
continue;
}
} else {
}
}
break;
}


var G__14090 = cljs.core.next(seq__13172_14051__$1);
var G__14091 = null;
var G__14092 = (0);
var G__14093 = (0);
seq__13172_14004 = G__14090;
chunk__13173_14005 = G__14091;
count__13174_14006 = G__14092;
i__13175_14007 = G__14093;
continue;
}
} else {
}
}
break;
}


var G__14094 = cljs.core.next(seq__12838_13992__$1);
var G__14095 = null;
var G__14096 = (0);
var G__14097 = (0);
seq__12838_13866 = G__14094;
chunk__12839_13867 = G__14095;
count__12840_13868 = G__14096;
i__12841_13869 = G__14097;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__13264 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__12829_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__12829_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__12830_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__12830_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__12831_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__12831_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__13266 = G__13264;
var G__13267_14103 = G__13266;
var G__13268_14104 = "sourcesContent";
var G__13269_14105 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__13267_14103,G__13268_14104,G__13269_14105);

return G__13266;
} else {
return G__13264;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__13271 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13271,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13271,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__13274 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13274,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13274,(1),null);
var G__14111 = cljs.core.next(col_map_seq);
var G__14112 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__13274,col,infos,vec__13271,line,col_map){
return (function (v,p__13277){
var map__13278 = p__13277;
var map__13278__$1 = (((((!((map__13278 == null))))?(((((map__13278.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13278.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13278):map__13278);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13278__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13278__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__13274,col,infos,vec__13271,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__14111;
new_cols = G__14112;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__14131 = cljs.core.next(line_map_seq);
var G__14132 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__14131;
new_lines = G__14132;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__13283_14133 = cljs.core.seq(reverse_map);
var chunk__13284_14134 = null;
var count__13285_14135 = (0);
var i__13286_14136 = (0);
while(true){
if((i__13286_14136 < count__13285_14135)){
var vec__13476_14137 = chunk__13284_14134.cljs$core$IIndexed$_nth$arity$2(null,i__13286_14136);
var line_14138 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13476_14137,(0),null);
var columns_14139 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13476_14137,(1),null);
var seq__13479_14140 = cljs.core.seq(columns_14139);
var chunk__13480_14141 = null;
var count__13481_14142 = (0);
var i__13482_14143 = (0);
while(true){
if((i__13482_14143 < count__13481_14142)){
var vec__13524_14144 = chunk__13480_14141.cljs$core$IIndexed$_nth$arity$2(null,i__13482_14143);
var column_14145 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13524_14144,(0),null);
var column_info_14146 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13524_14144,(1),null);
var seq__13529_14147 = cljs.core.seq(column_info_14146);
var chunk__13530_14148 = null;
var count__13531_14149 = (0);
var i__13532_14150 = (0);
while(true){
if((i__13532_14150 < count__13531_14149)){
var map__13539_14151 = chunk__13530_14148.cljs$core$IIndexed$_nth$arity$2(null,i__13532_14150);
var map__13539_14152__$1 = (((((!((map__13539_14151 == null))))?(((((map__13539_14151.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13539_14151.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13539_14151):map__13539_14151);
var gline_14153 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13539_14152__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14154 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13539_14152__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14155 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13539_14152__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14153], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13529_14147,chunk__13530_14148,count__13531_14149,i__13532_14150,seq__13479_14140,chunk__13480_14141,count__13481_14142,i__13482_14143,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13539_14151,map__13539_14152__$1,gline_14153,gcol_14154,name_14155,vec__13524_14144,column_14145,column_info_14146,vec__13476_14137,line_14138,columns_14139,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14154], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14138,new cljs.core.Keyword(null,"col","col",-1959363084),column_14145,new cljs.core.Keyword(null,"name","name",1843675177),name_14155], null));
});})(seq__13529_14147,chunk__13530_14148,count__13531_14149,i__13532_14150,seq__13479_14140,chunk__13480_14141,count__13481_14142,i__13482_14143,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13539_14151,map__13539_14152__$1,gline_14153,gcol_14154,name_14155,vec__13524_14144,column_14145,column_info_14146,vec__13476_14137,line_14138,columns_14139,inverted))
,cljs.core.sorted_map()));


var G__14159 = seq__13529_14147;
var G__14160 = chunk__13530_14148;
var G__14161 = count__13531_14149;
var G__14162 = (i__13532_14150 + (1));
seq__13529_14147 = G__14159;
chunk__13530_14148 = G__14160;
count__13531_14149 = G__14161;
i__13532_14150 = G__14162;
continue;
} else {
var temp__5735__auto___14163 = cljs.core.seq(seq__13529_14147);
if(temp__5735__auto___14163){
var seq__13529_14164__$1 = temp__5735__auto___14163;
if(cljs.core.chunked_seq_QMARK_(seq__13529_14164__$1)){
var c__4609__auto___14165 = cljs.core.chunk_first(seq__13529_14164__$1);
var G__14166 = cljs.core.chunk_rest(seq__13529_14164__$1);
var G__14167 = c__4609__auto___14165;
var G__14168 = cljs.core.count(c__4609__auto___14165);
var G__14169 = (0);
seq__13529_14147 = G__14166;
chunk__13530_14148 = G__14167;
count__13531_14149 = G__14168;
i__13532_14150 = G__14169;
continue;
} else {
var map__13543_14181 = cljs.core.first(seq__13529_14164__$1);
var map__13543_14182__$1 = (((((!((map__13543_14181 == null))))?(((((map__13543_14181.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13543_14181.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13543_14181):map__13543_14181);
var gline_14183 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13543_14182__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14184 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13543_14182__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14185 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13543_14182__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14183], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13529_14147,chunk__13530_14148,count__13531_14149,i__13532_14150,seq__13479_14140,chunk__13480_14141,count__13481_14142,i__13482_14143,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13543_14181,map__13543_14182__$1,gline_14183,gcol_14184,name_14185,seq__13529_14164__$1,temp__5735__auto___14163,vec__13524_14144,column_14145,column_info_14146,vec__13476_14137,line_14138,columns_14139,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14184], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14138,new cljs.core.Keyword(null,"col","col",-1959363084),column_14145,new cljs.core.Keyword(null,"name","name",1843675177),name_14185], null));
});})(seq__13529_14147,chunk__13530_14148,count__13531_14149,i__13532_14150,seq__13479_14140,chunk__13480_14141,count__13481_14142,i__13482_14143,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13543_14181,map__13543_14182__$1,gline_14183,gcol_14184,name_14185,seq__13529_14164__$1,temp__5735__auto___14163,vec__13524_14144,column_14145,column_info_14146,vec__13476_14137,line_14138,columns_14139,inverted))
,cljs.core.sorted_map()));


var G__14189 = cljs.core.next(seq__13529_14164__$1);
var G__14190 = null;
var G__14191 = (0);
var G__14192 = (0);
seq__13529_14147 = G__14189;
chunk__13530_14148 = G__14190;
count__13531_14149 = G__14191;
i__13532_14150 = G__14192;
continue;
}
} else {
}
}
break;
}


var G__14193 = seq__13479_14140;
var G__14194 = chunk__13480_14141;
var G__14195 = count__13481_14142;
var G__14196 = (i__13482_14143 + (1));
seq__13479_14140 = G__14193;
chunk__13480_14141 = G__14194;
count__13481_14142 = G__14195;
i__13482_14143 = G__14196;
continue;
} else {
var temp__5735__auto___14198 = cljs.core.seq(seq__13479_14140);
if(temp__5735__auto___14198){
var seq__13479_14200__$1 = temp__5735__auto___14198;
if(cljs.core.chunked_seq_QMARK_(seq__13479_14200__$1)){
var c__4609__auto___14202 = cljs.core.chunk_first(seq__13479_14200__$1);
var G__14203 = cljs.core.chunk_rest(seq__13479_14200__$1);
var G__14204 = c__4609__auto___14202;
var G__14205 = cljs.core.count(c__4609__auto___14202);
var G__14206 = (0);
seq__13479_14140 = G__14203;
chunk__13480_14141 = G__14204;
count__13481_14142 = G__14205;
i__13482_14143 = G__14206;
continue;
} else {
var vec__13548_14211 = cljs.core.first(seq__13479_14200__$1);
var column_14212 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13548_14211,(0),null);
var column_info_14213 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13548_14211,(1),null);
var seq__13551_14214 = cljs.core.seq(column_info_14213);
var chunk__13552_14215 = null;
var count__13553_14216 = (0);
var i__13554_14217 = (0);
while(true){
if((i__13554_14217 < count__13553_14216)){
var map__13576_14219 = chunk__13552_14215.cljs$core$IIndexed$_nth$arity$2(null,i__13554_14217);
var map__13576_14220__$1 = (((((!((map__13576_14219 == null))))?(((((map__13576_14219.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13576_14219.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13576_14219):map__13576_14219);
var gline_14221 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13576_14220__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14222 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13576_14220__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14223 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13576_14220__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14221], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13551_14214,chunk__13552_14215,count__13553_14216,i__13554_14217,seq__13479_14140,chunk__13480_14141,count__13481_14142,i__13482_14143,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13576_14219,map__13576_14220__$1,gline_14221,gcol_14222,name_14223,vec__13548_14211,column_14212,column_info_14213,seq__13479_14200__$1,temp__5735__auto___14198,vec__13476_14137,line_14138,columns_14139,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14222], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14138,new cljs.core.Keyword(null,"col","col",-1959363084),column_14212,new cljs.core.Keyword(null,"name","name",1843675177),name_14223], null));
});})(seq__13551_14214,chunk__13552_14215,count__13553_14216,i__13554_14217,seq__13479_14140,chunk__13480_14141,count__13481_14142,i__13482_14143,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13576_14219,map__13576_14220__$1,gline_14221,gcol_14222,name_14223,vec__13548_14211,column_14212,column_info_14213,seq__13479_14200__$1,temp__5735__auto___14198,vec__13476_14137,line_14138,columns_14139,inverted))
,cljs.core.sorted_map()));


var G__14246 = seq__13551_14214;
var G__14247 = chunk__13552_14215;
var G__14248 = count__13553_14216;
var G__14249 = (i__13554_14217 + (1));
seq__13551_14214 = G__14246;
chunk__13552_14215 = G__14247;
count__13553_14216 = G__14248;
i__13554_14217 = G__14249;
continue;
} else {
var temp__5735__auto___14250__$1 = cljs.core.seq(seq__13551_14214);
if(temp__5735__auto___14250__$1){
var seq__13551_14251__$1 = temp__5735__auto___14250__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13551_14251__$1)){
var c__4609__auto___14252 = cljs.core.chunk_first(seq__13551_14251__$1);
var G__14253 = cljs.core.chunk_rest(seq__13551_14251__$1);
var G__14254 = c__4609__auto___14252;
var G__14255 = cljs.core.count(c__4609__auto___14252);
var G__14256 = (0);
seq__13551_14214 = G__14253;
chunk__13552_14215 = G__14254;
count__13553_14216 = G__14255;
i__13554_14217 = G__14256;
continue;
} else {
var map__13585_14261 = cljs.core.first(seq__13551_14251__$1);
var map__13585_14262__$1 = (((((!((map__13585_14261 == null))))?(((((map__13585_14261.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13585_14261.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13585_14261):map__13585_14261);
var gline_14263 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13585_14262__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14264 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13585_14262__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14265 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13585_14262__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14263], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13551_14214,chunk__13552_14215,count__13553_14216,i__13554_14217,seq__13479_14140,chunk__13480_14141,count__13481_14142,i__13482_14143,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13585_14261,map__13585_14262__$1,gline_14263,gcol_14264,name_14265,seq__13551_14251__$1,temp__5735__auto___14250__$1,vec__13548_14211,column_14212,column_info_14213,seq__13479_14200__$1,temp__5735__auto___14198,vec__13476_14137,line_14138,columns_14139,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14264], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14138,new cljs.core.Keyword(null,"col","col",-1959363084),column_14212,new cljs.core.Keyword(null,"name","name",1843675177),name_14265], null));
});})(seq__13551_14214,chunk__13552_14215,count__13553_14216,i__13554_14217,seq__13479_14140,chunk__13480_14141,count__13481_14142,i__13482_14143,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13585_14261,map__13585_14262__$1,gline_14263,gcol_14264,name_14265,seq__13551_14251__$1,temp__5735__auto___14250__$1,vec__13548_14211,column_14212,column_info_14213,seq__13479_14200__$1,temp__5735__auto___14198,vec__13476_14137,line_14138,columns_14139,inverted))
,cljs.core.sorted_map()));


var G__14285 = cljs.core.next(seq__13551_14251__$1);
var G__14286 = null;
var G__14287 = (0);
var G__14288 = (0);
seq__13551_14214 = G__14285;
chunk__13552_14215 = G__14286;
count__13553_14216 = G__14287;
i__13554_14217 = G__14288;
continue;
}
} else {
}
}
break;
}


var G__14289 = cljs.core.next(seq__13479_14200__$1);
var G__14290 = null;
var G__14291 = (0);
var G__14292 = (0);
seq__13479_14140 = G__14289;
chunk__13480_14141 = G__14290;
count__13481_14142 = G__14291;
i__13482_14143 = G__14292;
continue;
}
} else {
}
}
break;
}


var G__14301 = seq__13283_14133;
var G__14302 = chunk__13284_14134;
var G__14303 = count__13285_14135;
var G__14304 = (i__13286_14136 + (1));
seq__13283_14133 = G__14301;
chunk__13284_14134 = G__14302;
count__13285_14135 = G__14303;
i__13286_14136 = G__14304;
continue;
} else {
var temp__5735__auto___14308 = cljs.core.seq(seq__13283_14133);
if(temp__5735__auto___14308){
var seq__13283_14309__$1 = temp__5735__auto___14308;
if(cljs.core.chunked_seq_QMARK_(seq__13283_14309__$1)){
var c__4609__auto___14310 = cljs.core.chunk_first(seq__13283_14309__$1);
var G__14311 = cljs.core.chunk_rest(seq__13283_14309__$1);
var G__14312 = c__4609__auto___14310;
var G__14313 = cljs.core.count(c__4609__auto___14310);
var G__14314 = (0);
seq__13283_14133 = G__14311;
chunk__13284_14134 = G__14312;
count__13285_14135 = G__14313;
i__13286_14136 = G__14314;
continue;
} else {
var vec__13592_14315 = cljs.core.first(seq__13283_14309__$1);
var line_14316 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13592_14315,(0),null);
var columns_14317 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13592_14315,(1),null);
var seq__13596_14318 = cljs.core.seq(columns_14317);
var chunk__13597_14319 = null;
var count__13598_14320 = (0);
var i__13599_14321 = (0);
while(true){
if((i__13599_14321 < count__13598_14320)){
var vec__13644_14324 = chunk__13597_14319.cljs$core$IIndexed$_nth$arity$2(null,i__13599_14321);
var column_14325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13644_14324,(0),null);
var column_info_14326 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13644_14324,(1),null);
var seq__13647_14332 = cljs.core.seq(column_info_14326);
var chunk__13648_14333 = null;
var count__13649_14334 = (0);
var i__13650_14335 = (0);
while(true){
if((i__13650_14335 < count__13649_14334)){
var map__13658_14336 = chunk__13648_14333.cljs$core$IIndexed$_nth$arity$2(null,i__13650_14335);
var map__13658_14337__$1 = (((((!((map__13658_14336 == null))))?(((((map__13658_14336.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13658_14336.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13658_14336):map__13658_14336);
var gline_14338 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13658_14337__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14339 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13658_14337__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14340 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13658_14337__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14338], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13647_14332,chunk__13648_14333,count__13649_14334,i__13650_14335,seq__13596_14318,chunk__13597_14319,count__13598_14320,i__13599_14321,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13658_14336,map__13658_14337__$1,gline_14338,gcol_14339,name_14340,vec__13644_14324,column_14325,column_info_14326,vec__13592_14315,line_14316,columns_14317,seq__13283_14309__$1,temp__5735__auto___14308,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14339], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14316,new cljs.core.Keyword(null,"col","col",-1959363084),column_14325,new cljs.core.Keyword(null,"name","name",1843675177),name_14340], null));
});})(seq__13647_14332,chunk__13648_14333,count__13649_14334,i__13650_14335,seq__13596_14318,chunk__13597_14319,count__13598_14320,i__13599_14321,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13658_14336,map__13658_14337__$1,gline_14338,gcol_14339,name_14340,vec__13644_14324,column_14325,column_info_14326,vec__13592_14315,line_14316,columns_14317,seq__13283_14309__$1,temp__5735__auto___14308,inverted))
,cljs.core.sorted_map()));


var G__14348 = seq__13647_14332;
var G__14349 = chunk__13648_14333;
var G__14350 = count__13649_14334;
var G__14351 = (i__13650_14335 + (1));
seq__13647_14332 = G__14348;
chunk__13648_14333 = G__14349;
count__13649_14334 = G__14350;
i__13650_14335 = G__14351;
continue;
} else {
var temp__5735__auto___14352__$1 = cljs.core.seq(seq__13647_14332);
if(temp__5735__auto___14352__$1){
var seq__13647_14353__$1 = temp__5735__auto___14352__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13647_14353__$1)){
var c__4609__auto___14354 = cljs.core.chunk_first(seq__13647_14353__$1);
var G__14356 = cljs.core.chunk_rest(seq__13647_14353__$1);
var G__14357 = c__4609__auto___14354;
var G__14358 = cljs.core.count(c__4609__auto___14354);
var G__14359 = (0);
seq__13647_14332 = G__14356;
chunk__13648_14333 = G__14357;
count__13649_14334 = G__14358;
i__13650_14335 = G__14359;
continue;
} else {
var map__13668_14362 = cljs.core.first(seq__13647_14353__$1);
var map__13668_14363__$1 = (((((!((map__13668_14362 == null))))?(((((map__13668_14362.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13668_14362.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13668_14362):map__13668_14362);
var gline_14364 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13668_14363__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14365 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13668_14363__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14366 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13668_14363__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14364], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13647_14332,chunk__13648_14333,count__13649_14334,i__13650_14335,seq__13596_14318,chunk__13597_14319,count__13598_14320,i__13599_14321,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13668_14362,map__13668_14363__$1,gline_14364,gcol_14365,name_14366,seq__13647_14353__$1,temp__5735__auto___14352__$1,vec__13644_14324,column_14325,column_info_14326,vec__13592_14315,line_14316,columns_14317,seq__13283_14309__$1,temp__5735__auto___14308,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14365], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14316,new cljs.core.Keyword(null,"col","col",-1959363084),column_14325,new cljs.core.Keyword(null,"name","name",1843675177),name_14366], null));
});})(seq__13647_14332,chunk__13648_14333,count__13649_14334,i__13650_14335,seq__13596_14318,chunk__13597_14319,count__13598_14320,i__13599_14321,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13668_14362,map__13668_14363__$1,gline_14364,gcol_14365,name_14366,seq__13647_14353__$1,temp__5735__auto___14352__$1,vec__13644_14324,column_14325,column_info_14326,vec__13592_14315,line_14316,columns_14317,seq__13283_14309__$1,temp__5735__auto___14308,inverted))
,cljs.core.sorted_map()));


var G__14368 = cljs.core.next(seq__13647_14353__$1);
var G__14369 = null;
var G__14370 = (0);
var G__14371 = (0);
seq__13647_14332 = G__14368;
chunk__13648_14333 = G__14369;
count__13649_14334 = G__14370;
i__13650_14335 = G__14371;
continue;
}
} else {
}
}
break;
}


var G__14372 = seq__13596_14318;
var G__14373 = chunk__13597_14319;
var G__14374 = count__13598_14320;
var G__14375 = (i__13599_14321 + (1));
seq__13596_14318 = G__14372;
chunk__13597_14319 = G__14373;
count__13598_14320 = G__14374;
i__13599_14321 = G__14375;
continue;
} else {
var temp__5735__auto___14376__$1 = cljs.core.seq(seq__13596_14318);
if(temp__5735__auto___14376__$1){
var seq__13596_14377__$1 = temp__5735__auto___14376__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13596_14377__$1)){
var c__4609__auto___14378 = cljs.core.chunk_first(seq__13596_14377__$1);
var G__14379 = cljs.core.chunk_rest(seq__13596_14377__$1);
var G__14380 = c__4609__auto___14378;
var G__14381 = cljs.core.count(c__4609__auto___14378);
var G__14382 = (0);
seq__13596_14318 = G__14379;
chunk__13597_14319 = G__14380;
count__13598_14320 = G__14381;
i__13599_14321 = G__14382;
continue;
} else {
var vec__13679_14383 = cljs.core.first(seq__13596_14377__$1);
var column_14384 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13679_14383,(0),null);
var column_info_14385 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13679_14383,(1),null);
var seq__13683_14386 = cljs.core.seq(column_info_14385);
var chunk__13684_14387 = null;
var count__13685_14388 = (0);
var i__13686_14389 = (0);
while(true){
if((i__13686_14389 < count__13685_14388)){
var map__13711_14390 = chunk__13684_14387.cljs$core$IIndexed$_nth$arity$2(null,i__13686_14389);
var map__13711_14391__$1 = (((((!((map__13711_14390 == null))))?(((((map__13711_14390.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13711_14390.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13711_14390):map__13711_14390);
var gline_14392 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13711_14391__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14393 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13711_14391__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14394 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13711_14391__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14392], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13683_14386,chunk__13684_14387,count__13685_14388,i__13686_14389,seq__13596_14318,chunk__13597_14319,count__13598_14320,i__13599_14321,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13711_14390,map__13711_14391__$1,gline_14392,gcol_14393,name_14394,vec__13679_14383,column_14384,column_info_14385,seq__13596_14377__$1,temp__5735__auto___14376__$1,vec__13592_14315,line_14316,columns_14317,seq__13283_14309__$1,temp__5735__auto___14308,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14393], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14316,new cljs.core.Keyword(null,"col","col",-1959363084),column_14384,new cljs.core.Keyword(null,"name","name",1843675177),name_14394], null));
});})(seq__13683_14386,chunk__13684_14387,count__13685_14388,i__13686_14389,seq__13596_14318,chunk__13597_14319,count__13598_14320,i__13599_14321,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13711_14390,map__13711_14391__$1,gline_14392,gcol_14393,name_14394,vec__13679_14383,column_14384,column_info_14385,seq__13596_14377__$1,temp__5735__auto___14376__$1,vec__13592_14315,line_14316,columns_14317,seq__13283_14309__$1,temp__5735__auto___14308,inverted))
,cljs.core.sorted_map()));


var G__14395 = seq__13683_14386;
var G__14396 = chunk__13684_14387;
var G__14397 = count__13685_14388;
var G__14398 = (i__13686_14389 + (1));
seq__13683_14386 = G__14395;
chunk__13684_14387 = G__14396;
count__13685_14388 = G__14397;
i__13686_14389 = G__14398;
continue;
} else {
var temp__5735__auto___14399__$2 = cljs.core.seq(seq__13683_14386);
if(temp__5735__auto___14399__$2){
var seq__13683_14400__$1 = temp__5735__auto___14399__$2;
if(cljs.core.chunked_seq_QMARK_(seq__13683_14400__$1)){
var c__4609__auto___14401 = cljs.core.chunk_first(seq__13683_14400__$1);
var G__14402 = cljs.core.chunk_rest(seq__13683_14400__$1);
var G__14403 = c__4609__auto___14401;
var G__14404 = cljs.core.count(c__4609__auto___14401);
var G__14405 = (0);
seq__13683_14386 = G__14402;
chunk__13684_14387 = G__14403;
count__13685_14388 = G__14404;
i__13686_14389 = G__14405;
continue;
} else {
var map__13713_14406 = cljs.core.first(seq__13683_14400__$1);
var map__13713_14407__$1 = (((((!((map__13713_14406 == null))))?(((((map__13713_14406.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13713_14406.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13713_14406):map__13713_14406);
var gline_14408 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13713_14407__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14409 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13713_14407__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14410 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13713_14407__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14408], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__13683_14386,chunk__13684_14387,count__13685_14388,i__13686_14389,seq__13596_14318,chunk__13597_14319,count__13598_14320,i__13599_14321,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13713_14406,map__13713_14407__$1,gline_14408,gcol_14409,name_14410,seq__13683_14400__$1,temp__5735__auto___14399__$2,vec__13679_14383,column_14384,column_info_14385,seq__13596_14377__$1,temp__5735__auto___14376__$1,vec__13592_14315,line_14316,columns_14317,seq__13283_14309__$1,temp__5735__auto___14308,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14409], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14316,new cljs.core.Keyword(null,"col","col",-1959363084),column_14384,new cljs.core.Keyword(null,"name","name",1843675177),name_14410], null));
});})(seq__13683_14386,chunk__13684_14387,count__13685_14388,i__13686_14389,seq__13596_14318,chunk__13597_14319,count__13598_14320,i__13599_14321,seq__13283_14133,chunk__13284_14134,count__13285_14135,i__13286_14136,map__13713_14406,map__13713_14407__$1,gline_14408,gcol_14409,name_14410,seq__13683_14400__$1,temp__5735__auto___14399__$2,vec__13679_14383,column_14384,column_info_14385,seq__13596_14377__$1,temp__5735__auto___14376__$1,vec__13592_14315,line_14316,columns_14317,seq__13283_14309__$1,temp__5735__auto___14308,inverted))
,cljs.core.sorted_map()));


var G__14419 = cljs.core.next(seq__13683_14400__$1);
var G__14420 = null;
var G__14421 = (0);
var G__14422 = (0);
seq__13683_14386 = G__14419;
chunk__13684_14387 = G__14420;
count__13685_14388 = G__14421;
i__13686_14389 = G__14422;
continue;
}
} else {
}
}
break;
}


var G__14423 = cljs.core.next(seq__13596_14377__$1);
var G__14424 = null;
var G__14425 = (0);
var G__14426 = (0);
seq__13596_14318 = G__14423;
chunk__13597_14319 = G__14424;
count__13598_14320 = G__14425;
i__13599_14321 = G__14426;
continue;
}
} else {
}
}
break;
}


var G__14427 = cljs.core.next(seq__13283_14309__$1);
var G__14428 = null;
var G__14429 = (0);
var G__14430 = (0);
seq__13283_14133 = G__14427;
chunk__13284_14134 = G__14428;
count__13285_14135 = G__14429;
i__13286_14136 = G__14430;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
